/* Utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Utils.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*
* Copyright (c) 2013 Mario Guerriero <mefrio.g@gmail.com>
*               2017 elementary LLC. <https://elementary.io>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gio/gdesktopappinfo.h>
#include <gee.h>
#include <granite.h>

#define SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_GROUP "file-view"
#define SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_PREFIX SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_GROUP "."
#define SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_LAUNCH_APP_WITH_FILE_PATH "launch-app-with-file-path"
#define SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_EXECUTE_CONTRACT_WITH_FILE_PATH "execute-contract-with-file-path"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SCRATCH_TYPE_APPLICATION (scratch_application_get_type ())
#define SCRATCH_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_TYPE_APPLICATION, ScratchApplication))
#define SCRATCH_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_TYPE_APPLICATION, ScratchApplicationClass))
#define SCRATCH_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_TYPE_APPLICATION))
#define SCRATCH_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_TYPE_APPLICATION))
#define SCRATCH_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_TYPE_APPLICATION, ScratchApplicationClass))

typedef struct _ScratchApplication ScratchApplication;
typedef struct _ScratchApplicationClass ScratchApplicationClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

VALA_EXTERN gchar* scratch_utils_last_path;
gchar* scratch_utils_last_path = NULL;

VALA_EXTERN GSimpleAction* scratch_utils_action_from_group (const gchar* action_name,
                                                GSimpleActionGroup* action_group);
VALA_EXTERN gchar* scratch_utils_pango_font_description_to_css (PangoFontDescription* font_descr);
VALA_EXTERN gchar* scratch_utils_replace_home_with_tilde (const gchar* path);
VALA_EXTERN gboolean scratch_utils_find_unique_path (GFile* f1,
                                         GFile* f2,
                                         gchar** path1,
                                         gchar** path2);
VALA_EXTERN gboolean scratch_utils_check_if_valid_text_file (const gchar* path,
                                                 GFileInfo* info);
VALA_EXTERN GMenu* scratch_utils_create_executable_app_items_for_file (GFile* file,
                                                           const gchar* file_type);
VALA_EXTERN GType scratch_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchApplication, g_object_unref)
VALA_EXTERN gboolean scratch_application_get_is_running_in_flatpak (ScratchApplication* self);
static GVariant* _variant_new9 (gchar* value);
static GVariant* _variant_new10 (const gchar* value);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gint ____lambda80_ (GAppInfo* a,
                    GAppInfo* b);
static gint _____lambda80__gcompare_func (gconstpointer a,
                                   gconstpointer b);
static GVariant* _variant_new11 (gchar* value);
static GVariant* _variant_new12 (const gchar* value);
VALA_EXTERN void scratch_utils_launch_app_with_file (const gchar* app_id,
                                         const gchar* path);
VALA_EXTERN GMenu* scratch_utils_create_contract_items_for_file (GFile* file);
static GVariant* _variant_new13 (gchar* value);
static GVariant* _variant_new14 (const gchar* value);
VALA_EXTERN void scratch_utils_execute_contract_with_file_path (const gchar* path,
                                                    const gchar* contract_name);
VALA_EXTERN gchar* scratch_utils_get_accel_for_action (const gchar* detailed_action_name);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GSimpleAction*
scratch_utils_action_from_group (const gchar* action_name,
                                 GSimpleActionGroup* action_group)
{
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* result;
	g_return_val_if_fail (action_name != NULL, NULL);
	g_return_val_if_fail (action_group != NULL, NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) action_group, action_name);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	result = _tmp1_;
	return result;
}

gchar*
scratch_utils_pango_font_description_to_css (PangoFontDescription* font_descr)
{
	GString* sb = NULL;
	GString* _tmp0_;
	PangoFontMask mask = 0U;
	GString* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* result;
	g_return_val_if_fail (font_descr != NULL, NULL);
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	mask = pango_font_description_get_set_fields (font_descr);
	if ((mask & PANGO_FONT_MASK_FAMILY) == PANGO_FONT_MASK_FAMILY) {
		const gchar* family = NULL;
		const gchar* _tmp1_;
		GString* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = pango_font_description_get_family (font_descr);
		family = _tmp1_;
		_tmp2_ = sb;
		_tmp3_ = family;
		g_string_append_printf (_tmp2_, "font-family: \"%s\";", _tmp3_);
	}
	if ((mask & PANGO_FONT_MASK_STYLE) == PANGO_FONT_MASK_STYLE) {
		PangoStyle style = 0;
		style = pango_font_description_get_style (font_descr);
		switch (style) {
			case PANGO_STYLE_NORMAL:
			{
				GString* _tmp4_;
				_tmp4_ = sb;
				g_string_append (_tmp4_, "font-style: normal;");
				break;
			}
			case PANGO_STYLE_ITALIC:
			{
				GString* _tmp5_;
				_tmp5_ = sb;
				g_string_append (_tmp5_, "font-style: italic;");
				break;
			}
			case PANGO_STYLE_OBLIQUE:
			{
				GString* _tmp6_;
				_tmp6_ = sb;
				g_string_append (_tmp6_, "font-style: bold;");
				break;
			}
			default:
			{
				break;
			}
		}
	}
	if ((mask & PANGO_FONT_MASK_VARIANT) == PANGO_FONT_MASK_VARIANT) {
		PangoVariant variant = 0;
		variant = pango_font_description_get_variant (font_descr);
		switch (variant) {
			case PANGO_VARIANT_NORMAL:
			{
				GString* _tmp7_;
				_tmp7_ = sb;
				g_string_append (_tmp7_, "font-variant: normal;");
				break;
			}
			case PANGO_VARIANT_SMALL_CAPS:
			{
				GString* _tmp8_;
				_tmp8_ = sb;
				g_string_append (_tmp8_, "font-variant: small-caps");
				break;
			}
			default:
			{
				break;
			}
		}
	}
	if ((mask & PANGO_FONT_MASK_WEIGHT) == PANGO_FONT_MASK_WEIGHT) {
		gint weight = 0;
		GString* _tmp9_;
		weight = CLAMP ((gint) ((pango_font_description_get_weight (font_descr) / 100) * 100), 100, 900);
		_tmp9_ = sb;
		g_string_append_printf (_tmp9_, "font-weight: %i;", weight);
	}
	if ((mask & PANGO_FONT_MASK_STRETCH) == PANGO_FONT_MASK_STRETCH) {
		PangoStretch stretch = 0;
		stretch = pango_font_description_get_stretch (font_descr);
		switch (stretch) {
			case PANGO_STRETCH_NORMAL:
			{
				GString* _tmp10_;
				_tmp10_ = sb;
				g_string_append_printf (_tmp10_, "font-stretch: %s;", "normal");
				break;
			}
			case PANGO_STRETCH_ULTRA_CONDENSED:
			{
				GString* _tmp11_;
				_tmp11_ = sb;
				g_string_append_printf (_tmp11_, "font-stretch: %s;", "condensed");
				break;
			}
			case PANGO_STRETCH_EXTRA_CONDENSED:
			{
				GString* _tmp12_;
				_tmp12_ = sb;
				g_string_append_printf (_tmp12_, "font-stretch: %s;", "extra-condensed");
				break;
			}
			case PANGO_STRETCH_CONDENSED:
			{
				GString* _tmp13_;
				_tmp13_ = sb;
				g_string_append_printf (_tmp13_, "font-stretch: %s;", "condensed");
				break;
			}
			case PANGO_STRETCH_SEMI_CONDENSED:
			{
				GString* _tmp14_;
				_tmp14_ = sb;
				g_string_append_printf (_tmp14_, "font-stretch: %s;", "normal");
				break;
			}
			case PANGO_STRETCH_SEMI_EXPANDED:
			{
				GString* _tmp15_;
				_tmp15_ = sb;
				g_string_append_printf (_tmp15_, "font-stretch: %s;", "semi-expanded");
				break;
			}
			case PANGO_STRETCH_EXPANDED:
			{
				GString* _tmp16_;
				_tmp16_ = sb;
				g_string_append_printf (_tmp16_, "font-stretch: %s;", "expanded");
				break;
			}
			case PANGO_STRETCH_EXTRA_EXPANDED:
			{
				GString* _tmp17_;
				_tmp17_ = sb;
				g_string_append_printf (_tmp17_, "font-stretch: %s;", "extra-expanded");
				break;
			}
			case PANGO_STRETCH_ULTRA_EXPANDED:
			{
				GString* _tmp18_;
				_tmp18_ = sb;
				g_string_append_printf (_tmp18_, "font-stretch: %s;", "ultra-expanded");
				break;
			}
			default:
			{
				break;
			}
		}
	}
	if ((mask & PANGO_FONT_MASK_SIZE) == PANGO_FONT_MASK_SIZE) {
		gint font_size = 0;
		GString* _tmp19_;
		font_size = pango_font_description_get_size (font_descr) / PANGO_SCALE;
		_tmp19_ = sb;
		g_string_append_printf (_tmp19_, "font-size: %dpt;", font_size);
	}
	_tmp20_ = sb;
	_tmp21_ = _tmp20_->str;
	_tmp22_ = g_strdup (_tmp21_);
	result = _tmp22_;
	_g_string_free0 (sb);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
scratch_utils_replace_home_with_tilde (const gchar* path)
{
	gchar* home_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	home_dir = _tmp1_;
	_tmp2_ = home_dir;
	if (g_str_has_prefix (path, _tmp2_)) {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp3_ = home_dir;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = string_substring (path, (glong) _tmp5_, (glong) -1);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("~", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		result = _tmp9_;
		_g_free0 (home_dir);
		return result;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (path);
		result = _tmp10_;
		_g_free0 (home_dir);
		return result;
	}
}

gboolean
scratch_utils_find_unique_path (GFile* f1,
                                GFile* f2,
                                gchar** path1,
                                gchar** path2)
{
	gchar* _vala_path1 = NULL;
	gchar* _vala_path2 = NULL;
	gboolean _tmp0_ = FALSE;
	GFile* f1_parent = NULL;
	GFile* _tmp3_;
	GFile* f2_parent = NULL;
	GFile* _tmp4_;
	GFile* _tmp22_;
	gchar* _tmp23_;
	GFile* _tmp24_;
	gchar* _tmp25_;
	gboolean result;
	g_return_val_if_fail (f1 != NULL, FALSE);
	g_return_val_if_fail (f2 != NULL, FALSE);
	if (g_file_equal (f1, f2)) {
		_g_free0 (_vala_path1);
		_vala_path1 = NULL;
		_g_free0 (_vala_path2);
		_vala_path2 = NULL;
		result = FALSE;
		if (path1) {
			*path1 = _vala_path1;
		} else {
			_g_free0 (_vala_path1);
		}
		if (path2) {
			*path2 = _vala_path2;
		} else {
			_g_free0 (_vala_path2);
		}
		return result;
	}
	if (!g_file_has_parent (f1, NULL)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !g_file_has_parent (f2, NULL);
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_file_get_basename (f1);
		_g_free0 (_vala_path1);
		_vala_path1 = _tmp1_;
		_tmp2_ = g_file_get_basename (f2);
		_g_free0 (_vala_path2);
		_vala_path2 = _tmp2_;
		result = TRUE;
		if (path1) {
			*path1 = _vala_path1;
		} else {
			_g_free0 (_vala_path1);
		}
		if (path2) {
			*path2 = _vala_path2;
		} else {
			_g_free0 (_vala_path2);
		}
		return result;
	}
	_tmp3_ = g_file_get_parent (f1);
	f1_parent = _tmp3_;
	_tmp4_ = g_file_get_parent (f2);
	f2_parent = _tmp4_;
	while (TRUE) {
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp15_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
		_tmp5_ = f1_parent;
		_tmp6_ = g_file_get_relative_path (_tmp5_, f1);
		_tmp7_ = _tmp6_;
		_tmp8_ = f2_parent;
		_tmp9_ = g_file_get_relative_path (_tmp8_, f2);
		_tmp10_ = _tmp9_;
		_tmp11_ = !(g_strcmp0 (_tmp7_, _tmp10_) == 0);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp7_);
		if (_tmp11_) {
			break;
		}
		_tmp12_ = f1_parent;
		if (!g_file_has_parent (_tmp12_, NULL)) {
			GFile* _tmp13_;
			GFile* _tmp14_;
			_tmp13_ = f2_parent;
			_tmp14_ = g_file_get_parent (_tmp13_);
			_g_object_unref0 (f2_parent);
			f2_parent = _tmp14_;
			break;
		}
		_tmp15_ = f2_parent;
		if (!g_file_has_parent (_tmp15_, NULL)) {
			GFile* _tmp16_;
			GFile* _tmp17_;
			_tmp16_ = f1_parent;
			_tmp17_ = g_file_get_parent (_tmp16_);
			_g_object_unref0 (f1_parent);
			f1_parent = _tmp17_;
			break;
		}
		_tmp18_ = f1_parent;
		_tmp19_ = g_file_get_parent (_tmp18_);
		_g_object_unref0 (f1_parent);
		f1_parent = _tmp19_;
		_tmp20_ = f2_parent;
		_tmp21_ = g_file_get_parent (_tmp20_);
		_g_object_unref0 (f2_parent);
		f2_parent = _tmp21_;
	}
	_tmp22_ = f1_parent;
	_tmp23_ = g_file_get_relative_path (_tmp22_, f1);
	_g_free0 (_vala_path1);
	_vala_path1 = _tmp23_;
	_tmp24_ = f2_parent;
	_tmp25_ = g_file_get_relative_path (_tmp24_, f2);
	_g_free0 (_vala_path2);
	_vala_path2 = _tmp25_;
	result = TRUE;
	_g_object_unref0 (f2_parent);
	_g_object_unref0 (f1_parent);
	if (path1) {
		*path1 = _vala_path1;
	} else {
		_g_free0 (_vala_path1);
	}
	if (path2) {
		*path2 = _vala_path2;
	} else {
		_g_free0 (_vala_path2);
	}
	return result;
}

gboolean
scratch_utils_check_if_valid_text_file (const gchar* path,
                                        GFileInfo* info)
{
	gchar* content_type = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	if (g_str_has_prefix (path, ".goutputstream")) {
		result = FALSE;
		return result;
	}
	if (g_file_info_get_is_backup (info)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = g_file_info_get_content_type (info);
	_tmp1_ = g_strdup (_tmp0_);
	content_type = _tmp1_;
	if (g_file_info_get_file_type (info) == G_FILE_TYPE_REGULAR) {
		const gchar* _tmp4_;
		_tmp4_ = content_type;
		_tmp3_ = g_content_type_is_a (_tmp4_, "text/*");
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = content_type;
		_tmp2_ = g_content_type_is_a (_tmp5_, "application/x-zerosize");
	}
	if (_tmp2_) {
		result = TRUE;
		_g_free0 (content_type);
		return result;
	}
	result = FALSE;
	_g_free0 (content_type);
	return result;
}

static GVariant*
_variant_new9 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new10 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gint
____lambda80_ (GAppInfo* a,
               GAppInfo* b)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_app_info_get_name (a);
	_tmp1_ = g_app_info_get_name (b);
	result = g_utf8_collate (_tmp0_, _tmp1_);
	return result;
}

static gint
_____lambda80__gcompare_func (gconstpointer a,
                              gconstpointer b)
{
	gint result;
	result = ____lambda80_ ((GAppInfo*) a, (GAppInfo*) b);
	return result;
}

static GVariant*
_variant_new11 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new12 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

GMenu*
scratch_utils_create_executable_app_items_for_file (GFile* file,
                                                    const gchar* file_type)
{
	ScratchApplication* scratch_app = NULL;
	GApplication* _tmp0_;
	ScratchApplication* _tmp1_;
	gchar* this_id = NULL;
	ScratchApplication* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GMenu* menu = NULL;
	GMenu* _tmp6_;
	ScratchApplication* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GMenu* result;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (file_type != NULL, NULL);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SCRATCH_TYPE_APPLICATION, ScratchApplication));
	scratch_app = _tmp1_;
	_tmp2_ = scratch_app;
	_tmp3_ = g_application_get_application_id ((GApplication*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, ".desktop", NULL);
	this_id = _tmp5_;
	_tmp6_ = g_menu_new ();
	menu = _tmp6_;
	_tmp7_ = scratch_app;
	_tmp8_ = scratch_application_get_is_running_in_flatpak (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		GMenuItem* menu_item = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		const GVariantType* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GVariant* _tmp17_;
		GVariant* _tmp18_;
		GVariant** _tmp19_;
		GVariant** _tmp20_;
		gint _tmp20__length1;
		GVariant* _tmp21_;
		GVariant* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GMenuItem* _tmp25_;
		GMenuItem* _tmp26_;
		GMenu* _tmp27_;
		GMenuItem* _tmp28_;
		_tmp10_ = g_file_get_basename (file);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf (_ ("Show '%s' with default app"), _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = G_VARIANT_TYPE_STRING;
		_tmp15_ = g_file_get_path (file);
		_tmp16_ = _tmp15_;
		_tmp17_ = _variant_new9 (_tmp16_);
		_tmp18_ = _variant_new10 ("");
		_tmp19_ = g_new0 (GVariant*, 2 + 1);
		_tmp19_[0] = _tmp17_;
		_tmp19_[1] = _tmp18_;
		_tmp20_ = _tmp19_;
		_tmp20__length1 = 2;
		_tmp21_ = g_variant_new_array (_tmp14_, _tmp20_, 2);
		g_variant_ref_sink (_tmp21_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_action_print_detailed_name (SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_PREFIX SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_LAUNCH_APP_WITH_FILE_PATH, _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_menu_item_new (_tmp13_, _tmp24_);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp24_);
		_g_variant_unref0 (_tmp22_);
		_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_variant_unref), NULL);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		menu_item = _tmp26_;
		_tmp27_ = menu;
		_tmp28_ = menu_item;
		g_menu_append_item (_tmp27_, _tmp28_);
		_g_object_unref0 (menu_item);
	} else {
		GList* external_apps = NULL;
		GList* _tmp33_;
		external_apps = NULL;
		if (g_strcmp0 (file_type, "") == 0) {
			GAppInfo* files_appinfo = NULL;
			GAppInfo* _tmp29_;
			GAppInfo* _tmp30_;
			GAppInfo* _tmp31_;
			_tmp29_ = g_app_info_get_default_for_type ("inode/directory", TRUE);
			files_appinfo = _tmp29_;
			_tmp30_ = files_appinfo;
			_tmp31_ = _g_object_ref0 (_tmp30_);
			external_apps = g_list_prepend (external_apps, _tmp31_);
			_g_object_unref0 (files_appinfo);
		} else {
			GList* _tmp32_;
			_tmp32_ = g_app_info_get_all_for_type (file_type);
			(external_apps == NULL) ? NULL : (external_apps = (_g_list_free__g_object_unref0_ (external_apps), NULL));
			external_apps = _tmp32_;
			external_apps = g_list_sort (external_apps, _____lambda80__gcompare_func);
		}
		_tmp33_ = external_apps;
		{
			GList* app_info_collection = NULL;
			GList* app_info_it = NULL;
			app_info_collection = _tmp33_;
			for (app_info_it = app_info_collection; app_info_it != NULL; app_info_it = app_info_it->next) {
				GAppInfo* _tmp34_;
				GAppInfo* app_info = NULL;
				_tmp34_ = _g_object_ref0 ((GAppInfo*) app_info_it->data);
				app_info = _tmp34_;
				{
					gchar* app_id = NULL;
					GAppInfo* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					GMenuItem* menu_item = NULL;
					GAppInfo* _tmp40_;
					const gchar* _tmp41_;
					const GVariantType* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					GVariant* _tmp45_;
					const gchar* _tmp46_;
					GVariant* _tmp47_;
					GVariant** _tmp48_;
					GVariant** _tmp49_;
					gint _tmp49__length1;
					GVariant* _tmp50_;
					GVariant* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					GMenuItem* _tmp54_;
					GMenuItem* _tmp55_;
					GMenuItem* _tmp56_;
					GAppInfo* _tmp57_;
					GIcon* _tmp58_;
					GMenu* _tmp59_;
					GMenuItem* _tmp60_;
					_tmp35_ = app_info;
					_tmp36_ = g_app_info_get_id (_tmp35_);
					_tmp37_ = g_strdup (_tmp36_);
					app_id = _tmp37_;
					_tmp38_ = app_id;
					_tmp39_ = this_id;
					if (g_strcmp0 (_tmp38_, _tmp39_) == 0) {
						_g_free0 (app_id);
						_g_object_unref0 (app_info);
						continue;
					}
					_tmp40_ = app_info;
					_tmp41_ = g_app_info_get_name (_tmp40_);
					_tmp42_ = G_VARIANT_TYPE_STRING;
					_tmp43_ = g_file_get_path (file);
					_tmp44_ = _tmp43_;
					_tmp45_ = _variant_new11 (_tmp44_);
					_tmp46_ = app_id;
					_tmp47_ = _variant_new12 (_tmp46_);
					_tmp48_ = g_new0 (GVariant*, 2 + 1);
					_tmp48_[0] = _tmp45_;
					_tmp48_[1] = _tmp47_;
					_tmp49_ = _tmp48_;
					_tmp49__length1 = 2;
					_tmp50_ = g_variant_new_array (_tmp42_, _tmp49_, 2);
					g_variant_ref_sink (_tmp50_);
					_tmp51_ = _tmp50_;
					_tmp52_ = g_action_print_detailed_name (SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_PREFIX SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_LAUNCH_APP_WITH_FILE_PATH, _tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = g_menu_item_new (_tmp41_, _tmp53_);
					_tmp55_ = _tmp54_;
					_g_free0 (_tmp53_);
					_g_variant_unref0 (_tmp51_);
					_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_variant_unref), NULL);
					_g_free0 (_tmp44_);
					menu_item = _tmp55_;
					_tmp56_ = menu_item;
					_tmp57_ = app_info;
					_tmp58_ = g_app_info_get_icon (_tmp57_);
					g_menu_item_set_icon (_tmp56_, _tmp58_);
					_tmp59_ = menu;
					_tmp60_ = menu_item;
					g_menu_append_item (_tmp59_, _tmp60_);
					_g_object_unref0 (menu_item);
					_g_free0 (app_id);
					_g_object_unref0 (app_info);
				}
			}
		}
		(external_apps == NULL) ? NULL : (external_apps = (_g_list_free__g_object_unref0_ (external_apps), NULL));
	}
	result = menu;
	_g_free0 (this_id);
	_g_object_unref0 (scratch_app);
	return result;
}

void
scratch_utils_launch_app_with_file (const gchar* app_id,
                                    const gchar* path)
{
	ScratchApplication* scratch_app = NULL;
	GApplication* _tmp0_;
	ScratchApplication* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ScratchApplication* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (app_id != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SCRATCH_TYPE_APPLICATION, ScratchApplication));
	scratch_app = _tmp1_;
	_tmp3_ = scratch_app;
	_tmp4_ = scratch_application_get_is_running_in_flatpak (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (app_id, "") == 0;
	}
	if (_tmp2_) {
		gchar* uri = NULL;
		gchar* _tmp6_;
		_tmp6_ = g_uri_join (G_URI_FLAGS_NONE, "file", NULL, NULL, -1, path, NULL, NULL);
		uri = _tmp6_;
		{
			ScratchApplication* _tmp7_;
			GtkWindow* _tmp8_;
			const gchar* _tmp9_;
			_tmp7_ = scratch_app;
			_tmp8_ = gtk_application_get_active_window ((GtkApplication*) _tmp7_);
			_tmp9_ = uri;
			gtk_show_uri_on_window (_tmp8_, _tmp9_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp10_ = uri;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			g_warning ("Utils.vala:268: Error showing uri %s, %s", _tmp10_, _tmp12_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (uri);
			_g_object_unref0 (scratch_app);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (uri);
	} else {
		GDesktopAppInfo* app_info = NULL;
		GDesktopAppInfo* _tmp13_;
		GFile* file = NULL;
		GFile* _tmp14_;
		GList* file_list = NULL;
		GFile* _tmp15_;
		GFile* _tmp16_;
		_tmp13_ = g_desktop_app_info_new (app_id);
		app_info = _tmp13_;
		_tmp14_ = g_file_new_for_path (path);
		file = _tmp14_;
		file_list = NULL;
		_tmp15_ = file;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		file_list = g_list_append (file_list, _tmp16_);
		{
			GDesktopAppInfo* _tmp17_;
			GList* _tmp18_;
			_tmp17_ = app_info;
			_tmp18_ = file_list;
			g_app_info_launch ((GAppInfo*) _tmp17_, _tmp18_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp19_;
			const gchar* _tmp20_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp19_ = e;
			_tmp20_ = _tmp19_->message;
			g_warning ("Utils.vala:279: %s", _tmp20_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			(file_list == NULL) ? NULL : (file_list = (_g_list_free__g_object_unref0_ (file_list), NULL));
			_g_object_unref0 (file);
			_g_object_unref0 (app_info);
			_g_object_unref0 (scratch_app);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		(file_list == NULL) ? NULL : (file_list = (_g_list_free__g_object_unref0_ (file_list), NULL));
		_g_object_unref0 (file);
		_g_object_unref0 (app_info);
	}
	_g_object_unref0 (scratch_app);
}

static GVariant*
_variant_new13 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new14 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

GMenu*
scratch_utils_create_contract_items_for_file (GFile* file)
{
	GMenu* menu = NULL;
	GMenu* _tmp0_;
	GError* _inner_error0_ = NULL;
	GMenu* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_menu_new ();
	menu = _tmp0_;
	{
		GeeList* contracts = NULL;
		GeeList* _tmp1_;
		_tmp1_ = granite_services_contractor_proxy_get_contracts_for_file (file, &_inner_error0_);
		contracts = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GeeList* _contract_list = NULL;
			GeeList* _tmp2_;
			gint _contract_size = 0;
			GeeList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _contract_index = 0;
			_tmp2_ = contracts;
			_contract_list = _tmp2_;
			_tmp3_ = _contract_list;
			_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_contract_size = _tmp5_;
			_contract_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				GraniteServicesContract* contract = NULL;
				GeeList* _tmp8_;
				gpointer _tmp9_;
				gchar* contract_name = NULL;
				GraniteServicesContract* _tmp10_;
				gchar* _tmp11_;
				GMenuItem* menu_item = NULL;
				const gchar* _tmp12_;
				const GVariantType* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				GVariant* _tmp16_;
				const gchar* _tmp17_;
				GVariant* _tmp18_;
				GVariant** _tmp19_;
				GVariant** _tmp20_;
				gint _tmp20__length1;
				GVariant* _tmp21_;
				GVariant* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				GMenuItem* _tmp25_;
				GMenuItem* _tmp26_;
				GMenu* _tmp27_;
				GMenuItem* _tmp28_;
				_contract_index = _contract_index + 1;
				_tmp6_ = _contract_index;
				_tmp7_ = _contract_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _contract_list;
				_tmp9_ = gee_list_get (_tmp8_, _contract_index);
				contract = (GraniteServicesContract*) _tmp9_;
				_tmp10_ = contract;
				_tmp11_ = granite_services_contract_get_display_name (_tmp10_);
				contract_name = _tmp11_;
				_tmp12_ = contract_name;
				_tmp13_ = G_VARIANT_TYPE_STRING;
				_tmp14_ = g_file_get_path (file);
				_tmp15_ = _tmp14_;
				_tmp16_ = _variant_new13 (_tmp15_);
				_tmp17_ = contract_name;
				_tmp18_ = _variant_new14 (_tmp17_);
				_tmp19_ = g_new0 (GVariant*, 2 + 1);
				_tmp19_[0] = _tmp16_;
				_tmp19_[1] = _tmp18_;
				_tmp20_ = _tmp19_;
				_tmp20__length1 = 2;
				_tmp21_ = g_variant_new_array (_tmp13_, _tmp20_, 2);
				g_variant_ref_sink (_tmp21_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_action_print_detailed_name (SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_PREFIX SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_EXECUTE_CONTRACT_WITH_FILE_PATH, _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_menu_item_new (_tmp12_, _tmp24_);
				_tmp26_ = _tmp25_;
				_g_free0 (_tmp24_);
				_g_variant_unref0 (_tmp22_);
				_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_variant_unref), NULL);
				_g_free0 (_tmp15_);
				menu_item = _tmp26_;
				_tmp27_ = menu;
				_tmp28_ = menu_item;
				g_menu_append_item (_tmp27_, _tmp28_);
				_g_object_unref0 (menu_item);
				_g_free0 (contract_name);
				_g_object_unref0 (contract);
			}
		}
		_g_object_unref0 (contracts);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_warning ("Utils.vala:306: %s", _tmp30_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (menu);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = menu;
	return result;
}

void
scratch_utils_execute_contract_with_file_path (const gchar* path,
                                               const gchar* contract_name)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (path != NULL);
	g_return_if_fail (contract_name != NULL);
	_tmp0_ = g_file_new_for_path (path);
	file = _tmp0_;
	{
		GeeList* contracts = NULL;
		GFile* _tmp1_;
		GeeList* _tmp2_;
		gint length = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp1_ = file;
		_tmp2_ = granite_services_contractor_proxy_get_contracts_for_file (_tmp1_, &_inner_error0_);
		contracts = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = contracts;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		length = _tmp5_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					GraniteServicesContract* contract = NULL;
					GeeList* _tmp8_;
					gpointer _tmp9_;
					GraniteServicesContract* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gboolean _tmp13_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					if (!(i < length)) {
						break;
					}
					_tmp8_ = contracts;
					_tmp9_ = gee_list_get (_tmp8_, i);
					contract = (GraniteServicesContract*) _tmp9_;
					_tmp10_ = contract;
					_tmp11_ = granite_services_contract_get_display_name (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strcmp0 (_tmp12_, contract_name) == 0;
					_g_free0 (_tmp12_);
					if (_tmp13_) {
						GraniteServicesContract* _tmp14_;
						GFile* _tmp15_;
						_tmp14_ = contract;
						_tmp15_ = file;
						granite_services_contract_execute_with_file (_tmp14_, _tmp15_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (contract);
							_g_object_unref0 (contracts);
							goto __catch0_g_error;
						}
						_g_object_unref0 (contract);
						break;
					}
					_g_object_unref0 (contract);
				}
			}
		}
		_g_object_unref0 (contracts);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("Utils.vala:326: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

gchar*
scratch_utils_get_accel_for_action (const gchar* detailed_action_name)
{
	GtkApplication* app_instance = NULL;
	GApplication* _tmp0_;
	GtkApplication* _tmp1_;
	gchar** accels = NULL;
	GtkApplication* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint accels_length1;
	gint _accels_size_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (detailed_action_name != NULL, NULL);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	app_instance = _tmp1_;
	_tmp2_ = app_instance;
	_tmp4_ = _tmp3_ = gtk_application_get_accels_for_action (_tmp2_, detailed_action_name);
	accels = _tmp4_;
	accels_length1 = _vala_array_length (_tmp3_);
	_accels_size_ = accels_length1;
	_tmp5_ = accels;
	_tmp5__length1 = accels_length1;
	if (_tmp5__length1 > 0) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = accels;
		_tmp6__length1 = accels_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_strdup (_tmp7_);
		result = _tmp8_;
		accels = (_vala_array_free (accels, accels_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (app_instance);
		return result;
	}
	g_warning ("Utils.vala:337: Accelerators were not found for the action: %s", detailed_action_name);
	_tmp9_ = g_strdup ("");
	result = _tmp9_;
	accels = (_vala_array_free (accels, accels_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (app_instance);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

