/* MonitoredRepository.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MonitoredRepository.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2020 elementary LLC. (https://elementary.io),
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Jeremy Wootten <jeremy@elementaryos.org>
 */

#include <glib-object.h>
#include <libgit2-glib/ggit.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>

#define SCRATCH_SERVICES_MONITORED_REPOSITORY_ORIGIN_PREFIX "origin/"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	SCRATCH_SERVICES_VC_STATUS_NONE,
	SCRATCH_SERVICES_VC_STATUS_ADDED,
	SCRATCH_SERVICES_VC_STATUS_CHANGED,
	SCRATCH_SERVICES_VC_STATUS_REMOVED,
	SCRATCH_SERVICES_VC_STATUS_REPLACES_DELETED,
	SCRATCH_SERVICES_VC_STATUS_OTHER
} ScratchServicesVCStatus;

#define SCRATCH_SERVICES_TYPE_VC_STATUS (scratch_services_vc_status_get_type ())

#define SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY (scratch_services_monitored_repository_get_type ())
#define SCRATCH_SERVICES_MONITORED_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, ScratchServicesMonitoredRepository))
#define SCRATCH_SERVICES_MONITORED_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, ScratchServicesMonitoredRepositoryClass))
#define SCRATCH_SERVICES_IS_MONITORED_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY))
#define SCRATCH_SERVICES_IS_MONITORED_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY))
#define SCRATCH_SERVICES_MONITORED_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, ScratchServicesMonitoredRepositoryClass))

typedef struct _ScratchServicesMonitoredRepository ScratchServicesMonitoredRepository;
typedef struct _ScratchServicesMonitoredRepositoryClass ScratchServicesMonitoredRepositoryClass;
typedef struct _ScratchServicesMonitoredRepositoryPrivate ScratchServicesMonitoredRepositoryPrivate;
enum  {
	SCRATCH_SERVICES_MONITORED_REPOSITORY_0_PROPERTY,
	SCRATCH_SERVICES_MONITORED_REPOSITORY_GIT_REPO_PROPERTY,
	SCRATCH_SERVICES_MONITORED_REPOSITORY_BRANCH_NAME_PROPERTY,
	SCRATCH_SERVICES_MONITORED_REPOSITORY_HEAD_IS_BRANCH_PROPERTY,
	SCRATCH_SERVICES_MONITORED_REPOSITORY_NON_CURRENT_ENTRIES_PROPERTY,
	SCRATCH_SERVICES_MONITORED_REPOSITORY_HAS_UNCOMMITTED_PROPERTY,
	SCRATCH_SERVICES_MONITORED_REPOSITORY_NUM_PROPERTIES
};
static GParamSpec* scratch_services_monitored_repository_properties[SCRATCH_SERVICES_MONITORED_REPOSITORY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GgitStatusOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitStatusOptions_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _ggit_branch_enumerator_unref0(var) ((var == NULL) ? NULL : (var = (ggit_branch_enumerator_unref (var), NULL)))
typedef struct _Block35Data Block35Data;

#define SCRATCH_DIALOGS_TYPE_OVERWRITE_UNCOMMITTED_CONFIRMATION_DIALOG (scratch_dialogs_overwrite_uncommitted_confirmation_dialog_get_type ())
#define SCRATCH_DIALOGS_OVERWRITE_UNCOMMITTED_CONFIRMATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_DIALOGS_TYPE_OVERWRITE_UNCOMMITTED_CONFIRMATION_DIALOG, ScratchDialogsOverwriteUncommittedConfirmationDialog))
#define SCRATCH_DIALOGS_OVERWRITE_UNCOMMITTED_CONFIRMATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_DIALOGS_TYPE_OVERWRITE_UNCOMMITTED_CONFIRMATION_DIALOG, ScratchDialogsOverwriteUncommittedConfirmationDialogClass))
#define SCRATCH_DIALOGS_IS_OVERWRITE_UNCOMMITTED_CONFIRMATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_DIALOGS_TYPE_OVERWRITE_UNCOMMITTED_CONFIRMATION_DIALOG))
#define SCRATCH_DIALOGS_IS_OVERWRITE_UNCOMMITTED_CONFIRMATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_DIALOGS_TYPE_OVERWRITE_UNCOMMITTED_CONFIRMATION_DIALOG))
#define SCRATCH_DIALOGS_OVERWRITE_UNCOMMITTED_CONFIRMATION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_DIALOGS_TYPE_OVERWRITE_UNCOMMITTED_CONFIRMATION_DIALOG, ScratchDialogsOverwriteUncommittedConfirmationDialogClass))

typedef struct _ScratchDialogsOverwriteUncommittedConfirmationDialog ScratchDialogsOverwriteUncommittedConfirmationDialog;
typedef struct _ScratchDialogsOverwriteUncommittedConfirmationDialogClass ScratchDialogsOverwriteUncommittedConfirmationDialogClass;
typedef struct _Block36Data Block36Data;
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
typedef struct _Block37Data Block37Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _Block38Data Block38Data;
enum  {
	SCRATCH_SERVICES_MONITORED_REPOSITORY_BRANCH_CHANGED_SIGNAL,
	SCRATCH_SERVICES_MONITORED_REPOSITORY_IGNORED_CHANGED_SIGNAL,
	SCRATCH_SERVICES_MONITORED_REPOSITORY_FILE_STATUS_CHANGE_SIGNAL,
	SCRATCH_SERVICES_MONITORED_REPOSITORY_FILE_CONTENT_CHANGED_SIGNAL,
	SCRATCH_SERVICES_MONITORED_REPOSITORY_NUM_SIGNALS
};
static guint scratch_services_monitored_repository_signals[SCRATCH_SERVICES_MONITORED_REPOSITORY_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ScratchServicesMonitoredRepository {
	GObject parent_instance;
	ScratchServicesMonitoredRepositoryPrivate * priv;
};

struct _ScratchServicesMonitoredRepositoryClass {
	GObjectClass parent_class;
};

struct _ScratchServicesMonitoredRepositoryPrivate {
	GgitRepository* _git_repo;
	GFileMonitor* git_monitor;
	GFileMonitor* gitignore_monitor;
	gchar* _branch_name;
	guint update_timer_id;
	GgitStatusOptions* status_options;
	GeeHashMap* file_status_map;
	GList* remote_branch_ref_list;
	gboolean do_update;
	gboolean refreshing;
};

struct _Block35Data {
	int _ref_count_;
	ScratchServicesMonitoredRepository* self;
	GraniteMessageDialog* dialog;
};

struct _Block36Data {
	int _ref_count_;
	ScratchServicesMonitoredRepository* self;
	ScratchDialogsOverwriteUncommittedConfirmationDialog* dialog;
	GgitBranch* new_head_branch;
};

struct _Block37Data {
	int _ref_count_;
	ScratchServicesMonitoredRepository* self;
	GString* sb;
};

struct _Block38Data {
	int _ref_count_;
	ScratchServicesMonitoredRepository* self;
	GeeHashMap* status_map;
	gint prev_deletions;
	gint prev_additions;
	gchar* file_path;
};

static gint ScratchServicesMonitoredRepository_private_offset;
static gpointer scratch_services_monitored_repository_parent_class = NULL;

VALA_EXTERN GType scratch_services_vc_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scratch_services_monitored_repository_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchServicesMonitoredRepository, g_object_unref)
static void _vala_GgitStatusOptions_free (GgitStatusOptions* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN ScratchServicesMonitoredRepository* scratch_services_monitored_repository_new (GgitRepository* _git_repo);
VALA_EXTERN ScratchServicesMonitoredRepository* scratch_services_monitored_repository_construct (GType object_type,
                                                                                     GgitRepository* _git_repo);
VALA_EXTERN GgitRepository* scratch_services_monitored_repository_get_git_repo (ScratchServicesMonitoredRepository* self);
static void ___lambda6_ (ScratchServicesMonitoredRepository* self);
VALA_EXTERN void scratch_services_monitored_repository_update_status_map (ScratchServicesMonitoredRepository* self);
static void ____lambda6__g_file_monitor_changed (GFileMonitor* _sender,
                                          GFile* file,
                                          GFile* other_file,
                                          GFileMonitorEvent event_type,
                                          gpointer self);
static void ____lambda9_ (ScratchServicesMonitoredRepository* self);
static void _____lambda9__g_file_monitor_changed (GFileMonitor* _sender,
                                           GFile* file,
                                           GFile* other_file,
                                           GFileMonitorEvent event_type,
                                           gpointer self);
VALA_EXTERN const gchar* scratch_services_monitored_repository_get_current_branch (ScratchServicesMonitoredRepository* self);
VALA_EXTERN GList* scratch_services_monitored_repository_get_local_branches (ScratchServicesMonitoredRepository* self);
static gint _g_utf8_collate_gcompare_func (gconstpointer a,
                                    gconstpointer b);
VALA_EXTERN GList* scratch_services_monitored_repository_get_remote_branches (ScratchServicesMonitoredRepository* self);
VALA_EXTERN gboolean scratch_services_monitored_repository_has_local_branch_name (ScratchServicesMonitoredRepository* self,
                                                                      const gchar* name);
VALA_EXTERN gboolean scratch_services_monitored_repository_is_valid_new_local_branch_name (ScratchServicesMonitoredRepository* self,
                                                                               const gchar* new_name);
VALA_EXTERN void scratch_services_monitored_repository_change_local_branch (ScratchServicesMonitoredRepository* self,
                                                                const gchar* new_branch_name,
                                                                GError** error);
static void scratch_services_monitored_repository_checkout_branch (ScratchServicesMonitoredRepository* self,
                                                            GgitBranch* new_head_branch,
                                                            gboolean confirm);
VALA_EXTERN void scratch_services_monitored_repository_checkout_remote_branch (ScratchServicesMonitoredRepository* self,
                                                                   const gchar* target_shorthand,
                                                                   GError** error);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
static void ___lambda13_ (Block35Data* _data35_);
static void ____lambda13__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
VALA_EXTERN gboolean scratch_services_monitored_repository_get_has_uncommitted (ScratchServicesMonitoredRepository* self);
static void scratch_services_monitored_repository_confirm_checkout_branch (ScratchServicesMonitoredRepository* self,
                                                                    GgitBranch* new_head_branch,
                                                                    GError** error);
VALA_EXTERN void scratch_services_monitored_repository_set_branch_name (ScratchServicesMonitoredRepository* self,
                                                            const gchar* value);
VALA_EXTERN GType scratch_dialogs_overwrite_uncommitted_confirmation_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchDialogsOverwriteUncommittedConfirmationDialog, g_object_unref)
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
VALA_EXTERN gchar* scratch_services_monitored_repository_get_project_diff (ScratchServicesMonitoredRepository* self,
                                                               GError** error);
VALA_EXTERN ScratchDialogsOverwriteUncommittedConfirmationDialog* scratch_dialogs_overwrite_uncommitted_confirmation_dialog_new (GtkWindow* parent,
                                                                                                                     const gchar* new_branch_name,
                                                                                                                     const gchar* details);
VALA_EXTERN ScratchDialogsOverwriteUncommittedConfirmationDialog* scratch_dialogs_overwrite_uncommitted_confirmation_dialog_construct (GType object_type,
                                                                                                                           GtkWindow* parent,
                                                                                                                           const gchar* new_branch_name,
                                                                                                                           const gchar* details);
static void __lambda12_ (Block36Data* _data36_,
                  gint res);
static void ___lambda12__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
VALA_EXTERN void scratch_services_monitored_repository_create_new_branch (ScratchServicesMonitoredRepository* self,
                                                              const gchar* name,
                                                              GError** error);
static gboolean ___lambda7_ (ScratchServicesMonitoredRepository* self);
static void _vala_GgitOId_free (GgitOId* self);
static gint ____lambda8_ (ScratchServicesMonitoredRepository* self,
                   const gchar* path,
                   GgitStatusFlags status);
static gint _____lambda8__ggit_status_callback (const gchar* path,
                                         GgitStatusFlags status_flags,
                                         gpointer self);
static gboolean ____lambda7__gsource_func (gpointer self);
VALA_EXTERN gboolean scratch_services_monitored_repository_path_is_ignored (ScratchServicesMonitoredRepository* self,
                                                                const gchar* path,
                                                                GError** error);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
static gint __lambda11_ (Block37Data* _data37_,
                  GgitDiffDelta* delta,
                  GgitDiffHunk* hunk,
                  GgitDiffLine* line);
static gint ___lambda11__ggit_diff_line_callback (GgitDiffDelta* delta,
                                           GgitDiffHunk* hunk,
                                           GgitDiffLine* line,
                                           gpointer self);
VALA_EXTERN void scratch_services_monitored_repository_refresh_diff (ScratchServicesMonitoredRepository* self,
                                                         const gchar* file_path,
                                                         GeeHashMap** line_status_map);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
static gint ___lambda14_ (Block38Data* _data38_,
                   GgitDiffDelta* delta,
                   GgitDiffHunk* hunk,
                   GgitDiffLine* line);
static void scratch_services_monitored_repository_process_diff_line (ScratchServicesMonitoredRepository* self,
                                                              GgitDiffLineType line_type,
                                                              gint new_line_no,
                                                              gint old_line_no,
                                                              GeeHashMap** line_status_map,
                                                              gint* prev_deletions,
                                                              gint* prev_additions);
static gint ____lambda14__ggit_diff_line_callback (GgitDiffDelta* delta,
                                            GgitDiffHunk* hunk,
                                            GgitDiffLine* line,
                                            gpointer self);
VALA_EXTERN void scratch_services_monitored_repository_set_git_repo (ScratchServicesMonitoredRepository* self,
                                                         GgitRepository* value);
VALA_EXTERN const gchar* scratch_services_monitored_repository_get_branch_name (ScratchServicesMonitoredRepository* self);
VALA_EXTERN gboolean scratch_services_monitored_repository_get_head_is_branch (ScratchServicesMonitoredRepository* self);
VALA_EXTERN GeeSet* scratch_services_monitored_repository_get_non_current_entries (ScratchServicesMonitoredRepository* self);
static gboolean _scratch_services_monitored_repository_has_uncommitted___lambda10_ (ScratchServicesMonitoredRepository* self,
                                                                             GgitStatusFlags* status);
static gboolean __scratch_services_monitored_repository_has_uncommitted___lambda10__gee_predicate (gconstpointer g,
                                                                                            gpointer self);
static GObject * scratch_services_monitored_repository_constructor (GType type,
                                                             guint n_construct_properties,
                                                             GObjectConstructParam * construct_properties);
static GgitStatusFlags* _ggit_status_flags_dup (GgitStatusFlags* self);
static void scratch_services_monitored_repository_finalize (GObject * obj);
static GType scratch_services_monitored_repository_get_type_once (void);
static void _vala_scratch_services_monitored_repository_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_scratch_services_monitored_repository_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);

 G_GNUC_NO_INLINE static GType
scratch_services_vc_status_get_type_once (void)
{
	static const GEnumValue values[] = {{SCRATCH_SERVICES_VC_STATUS_NONE, "SCRATCH_SERVICES_VC_STATUS_NONE", "none"}, {SCRATCH_SERVICES_VC_STATUS_ADDED, "SCRATCH_SERVICES_VC_STATUS_ADDED", "added"}, {SCRATCH_SERVICES_VC_STATUS_CHANGED, "SCRATCH_SERVICES_VC_STATUS_CHANGED", "changed"}, {SCRATCH_SERVICES_VC_STATUS_REMOVED, "SCRATCH_SERVICES_VC_STATUS_REMOVED", "removed"}, {SCRATCH_SERVICES_VC_STATUS_REPLACES_DELETED, "SCRATCH_SERVICES_VC_STATUS_REPLACES_DELETED", "replaces-deleted"}, {SCRATCH_SERVICES_VC_STATUS_OTHER, "SCRATCH_SERVICES_VC_STATUS_OTHER", "other"}, {0, NULL, NULL}};
	GType scratch_services_vc_status_type_id;
	scratch_services_vc_status_type_id = g_enum_register_static ("ScratchServicesVCStatus", values);
	return scratch_services_vc_status_type_id;
}

GType
scratch_services_vc_status_get_type (void)
{
	static gsize scratch_services_vc_status_type_id__once = 0;
	if (g_once_init_enter (&scratch_services_vc_status_type_id__once)) {
		GType scratch_services_vc_status_type_id;
		scratch_services_vc_status_type_id = scratch_services_vc_status_get_type_once ();
		g_once_init_leave (&scratch_services_vc_status_type_id__once, scratch_services_vc_status_type_id);
	}
	return scratch_services_vc_status_type_id__once;
}

static inline gpointer
scratch_services_monitored_repository_get_instance_private (ScratchServicesMonitoredRepository* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchServicesMonitoredRepository_private_offset);
}

static void
_vala_GgitStatusOptions_free (GgitStatusOptions* self)
{
	g_boxed_free (ggit_status_options_get_type (), self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
___lambda6_ (ScratchServicesMonitoredRepository* self)
{
	scratch_services_monitored_repository_update_status_map (self);
}

static void
____lambda6__g_file_monitor_changed (GFileMonitor* _sender,
                                     GFile* file,
                                     GFile* other_file,
                                     GFileMonitorEvent event_type,
                                     gpointer self)
{
	___lambda6_ ((ScratchServicesMonitoredRepository*) self);
}

static void
____lambda9_ (ScratchServicesMonitoredRepository* self)
{
	g_signal_emit (self, scratch_services_monitored_repository_signals[SCRATCH_SERVICES_MONITORED_REPOSITORY_IGNORED_CHANGED_SIGNAL], 0);
}

static void
_____lambda9__g_file_monitor_changed (GFileMonitor* _sender,
                                      GFile* file,
                                      GFile* other_file,
                                      GFileMonitorEvent event_type,
                                      gpointer self)
{
	____lambda9_ ((ScratchServicesMonitoredRepository*) self);
}

ScratchServicesMonitoredRepository*
scratch_services_monitored_repository_construct (GType object_type,
                                                 GgitRepository* _git_repo)
{
	ScratchServicesMonitoredRepository * self = NULL;
	GFile* git_folder = NULL;
	GgitRepository* _tmp0_;
	GFile* _tmp1_;
	GFile* workdir = NULL;
	GgitRepository* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* gitignore_file = NULL;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (_git_repo != NULL, NULL);
	self = (ScratchServicesMonitoredRepository*) g_object_new (object_type, "git-repo", _git_repo, NULL);
	_tmp0_ = self->priv->_git_repo;
	_tmp1_ = ggit_repository_get_location (_tmp0_);
	git_folder = _tmp1_;
	{
		GFileMonitor* _tmp2_ = NULL;
		GFileMonitor* _tmp3_;
		GFileMonitor* _tmp4_;
		GFileMonitor* _tmp5_;
		_tmp3_ = g_file_monitor_directory (git_folder, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (git_folder);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (self->priv->git_monitor);
		self->priv->git_monitor = _tmp4_;
		_tmp5_ = self->priv->git_monitor;
		g_signal_connect_object (_tmp5_, "changed", (GCallback) ____lambda6__g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("MonitoredRepository.vala:120: An error occurred setting up a file moni" \
"tor on the git folder: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (git_folder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp8_ = self->priv->_git_repo;
	g_object_get (_tmp8_, "workdir", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	workdir = _tmp10_;
	_tmp11_ = workdir;
	_tmp12_ = g_file_get_child (_tmp11_, ".gitignore");
	gitignore_file = _tmp12_;
	_tmp13_ = gitignore_file;
	if (g_file_query_exists (_tmp13_, NULL)) {
		{
			GFileMonitor* _tmp14_ = NULL;
			GFile* _tmp15_;
			GFileMonitor* _tmp16_;
			GFileMonitor* _tmp17_;
			GFileMonitor* _tmp18_;
			_tmp15_ = gitignore_file;
			_tmp16_ = g_file_monitor_file (_tmp15_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
			_tmp14_ = _tmp16_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				_g_object_unref0 (gitignore_file);
				_g_object_unref0 (workdir);
				_g_object_unref0 (git_folder);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp17_ = _tmp14_;
			_tmp14_ = NULL;
			_g_object_unref0 (self->priv->gitignore_monitor);
			self->priv->gitignore_monitor = _tmp17_;
			_tmp18_ = self->priv->gitignore_monitor;
			g_signal_connect_object (_tmp18_, "changed", (GCallback) _____lambda9__g_file_monitor_changed, self, 0);
			_g_object_unref0 (_tmp14_);
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			GError* e = NULL;
			GError* _tmp19_;
			const gchar* _tmp20_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp19_ = e;
			_tmp20_ = _tmp19_->message;
			g_warning ("MonitoredRepository.vala:132: An error occurred setting up a file moni" \
"tor on the gitignore file: %s", _tmp20_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (gitignore_file);
			_g_object_unref0 (workdir);
			_g_object_unref0 (git_folder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_g_object_unref0 (gitignore_file);
	_g_object_unref0 (workdir);
	_g_object_unref0 (git_folder);
	return self;
}

ScratchServicesMonitoredRepository*
scratch_services_monitored_repository_new (GgitRepository* _git_repo)
{
	return scratch_services_monitored_repository_construct (SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, _git_repo);
}

const gchar*
scratch_services_monitored_repository_get_current_branch (ScratchServicesMonitoredRepository* self)
{
	GError* _inner_error0_ = NULL;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GgitRef* head = NULL;
		GgitRepository* _tmp0_;
		GgitRef* _tmp1_;
		GgitRef* _tmp2_;
		_tmp0_ = self->priv->_git_repo;
		_tmp1_ = ggit_repository_get_head (_tmp0_, &_inner_error0_);
		head = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = head;
		if (ggit_ref_is_branch (_tmp2_)) {
			const gchar* _tmp3_ = NULL;
			GgitRef* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = head;
			_tmp5_ = ggit_branch_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, ggit_branch_get_type (), GgitBranch), &_inner_error0_);
			_tmp3_ = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (head);
				goto __catch0_g_error;
			}
			result = _tmp3_;
			_g_object_unref0 (head);
			return result;
		}
		_g_object_unref0 (head);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("MonitoredRepository.vala:154: Could not get current branch name - %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = "";
	return result;
}

static gint
_g_utf8_collate_gcompare_func (gconstpointer a,
                               gconstpointer b)
{
	gint result;
	result = g_utf8_collate (a, (const gchar*) b);
	return result;
}

GList*
scratch_services_monitored_repository_get_local_branches (ScratchServicesMonitoredRepository* self)
{
	GList* branches = NULL;
	GList* _tmp14_;
	GError* _inner_error0_ = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	branches = NULL;
	{
		GgitBranchEnumerator* branch_enumerator = NULL;
		GgitRepository* _tmp0_;
		GgitBranchEnumerator* _tmp1_;
		_tmp0_ = self->priv->_git_repo;
		_tmp1_ = ggit_repository_enumerate_branches (_tmp0_, GGIT_BRANCH_LOCAL, &_inner_error0_);
		branch_enumerator = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GgitBranchEnumerator* _branch_ref_it = NULL;
			GgitBranchEnumerator* _tmp2_;
			GgitBranchEnumerator* _tmp3_;
			_tmp2_ = branch_enumerator;
			_tmp3_ = ggit_branch_enumerator_iterator (_tmp2_);
			_branch_ref_it = _tmp3_;
			while (TRUE) {
				GgitBranchEnumerator* _tmp4_;
				GgitRef* branch_ref = NULL;
				GgitBranchEnumerator* _tmp5_;
				GgitRef* _tmp6_;
				GgitRef* _tmp7_;
				_tmp4_ = _branch_ref_it;
				if (!ggit_branch_enumerator_next (_tmp4_)) {
					break;
				}
				_tmp5_ = _branch_ref_it;
				_tmp6_ = ggit_branch_enumerator_get (_tmp5_);
				branch_ref = _tmp6_;
				_tmp7_ = branch_ref;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, ggit_branch_get_type ())) {
					const gchar* _tmp8_ = NULL;
					GgitRef* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp9_ = branch_ref;
					_tmp10_ = ggit_branch_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, ggit_branch_get_type (), GgitBranch), &_inner_error0_);
					_tmp8_ = _tmp10_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (branch_ref);
						_ggit_branch_enumerator_unref0 (branch_enumerator);
						goto __catch0_g_error;
					}
					_tmp11_ = g_strdup (_tmp8_);
					branches = g_list_insert_sorted (branches, _tmp11_, _g_utf8_collate_gcompare_func);
				}
				_g_object_unref0 (branch_ref);
			}
		}
		_ggit_branch_enumerator_unref0 (branch_enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("MonitoredRepository.vala:174: Could not enumerate branches %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp14_ = branches;
	result = _tmp14_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GList*
scratch_services_monitored_repository_get_remote_branches (ScratchServicesMonitoredRepository* self)
{
	GList* branch_names = NULL;
	GList* _tmp24_;
	GError* _inner_error0_ = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	branch_names = NULL;
	{
		GgitBranchEnumerator* branch_enumerator = NULL;
		GgitRepository* _tmp0_;
		GgitBranchEnumerator* _tmp1_;
		_tmp0_ = self->priv->_git_repo;
		_tmp1_ = ggit_repository_enumerate_branches (_tmp0_, GGIT_BRANCH_REMOTE, &_inner_error0_);
		branch_enumerator = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GgitBranchEnumerator* _branch_ref_it = NULL;
			GgitBranchEnumerator* _tmp2_;
			GgitBranchEnumerator* _tmp3_;
			_tmp2_ = branch_enumerator;
			_tmp3_ = ggit_branch_enumerator_iterator (_tmp2_);
			_branch_ref_it = _tmp3_;
			while (TRUE) {
				GgitBranchEnumerator* _tmp4_;
				GgitRef* branch_ref = NULL;
				GgitBranchEnumerator* _tmp5_;
				GgitRef* _tmp6_;
				gchar* remote_name = NULL;
				GgitRef* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				const gchar* _tmp11_;
				GgitRef* _tmp20_;
				GgitRef* _tmp21_;
				_tmp4_ = _branch_ref_it;
				if (!ggit_branch_enumerator_next (_tmp4_)) {
					break;
				}
				_tmp5_ = _branch_ref_it;
				_tmp6_ = ggit_branch_enumerator_get (_tmp5_);
				branch_ref = _tmp6_;
				_tmp7_ = branch_ref;
				_tmp8_ = ggit_ref_get_shorthand (_tmp7_);
				_tmp9_ = g_strdup (_tmp8_);
				remote_name = _tmp9_;
				_tmp11_ = remote_name;
				if (!g_str_has_suffix (_tmp11_, "HEAD")) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp12_ = remote_name;
					_tmp13_ = strlen (SCRATCH_SERVICES_MONITORED_REPOSITORY_ORIGIN_PREFIX);
					_tmp14_ = _tmp13_;
					_tmp15_ = string_substring (_tmp12_, (glong) _tmp14_, (glong) -1);
					_tmp16_ = _tmp15_;
					_tmp10_ = !scratch_services_monitored_repository_has_local_branch_name (self, _tmp16_);
					_g_free0 (_tmp16_);
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					GgitRef* _tmp17_;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp17_ = branch_ref;
					_tmp18_ = ggit_ref_get_shorthand (_tmp17_);
					_tmp19_ = g_strdup (_tmp18_);
					branch_names = g_list_insert_sorted (branch_names, _tmp19_, _g_utf8_collate_gcompare_func);
				}
				_tmp20_ = branch_ref;
				_tmp21_ = _g_object_ref0 (_tmp20_);
				self->priv->remote_branch_ref_list = g_list_append (self->priv->remote_branch_ref_list, _tmp21_);
				_g_free0 (remote_name);
				_g_object_unref0 (branch_ref);
			}
		}
		_ggit_branch_enumerator_unref0 (branch_enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_warning ("MonitoredRepository.vala:200: Could not enumerate local branches %s", _tmp23_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp24_ = branch_names;
	result = _tmp24_;
	return result;
}

gboolean
scratch_services_monitored_repository_has_local_branch_name (ScratchServicesMonitoredRepository* self,
                                                             const gchar* name)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		GgitRepository* _tmp0_;
		GgitBranch* _tmp1_;
		GgitBranch* _tmp2_;
		_tmp0_ = self->priv->_git_repo;
		_tmp1_ = ggit_repository_lookup_branch (_tmp0_, name, GGIT_BRANCH_LOCAL, &_inner_error0_);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = TRUE;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	result = FALSE;
	return result;
}

gboolean
scratch_services_monitored_repository_is_valid_new_local_branch_name (ScratchServicesMonitoredRepository* self,
                                                                      const gchar* new_name)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_name != NULL, FALSE);
	_tmp1_ = g_strconcat ("refs/heads/", new_name, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = !ggit_ref_is_valid_name (_tmp2_);
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = scratch_services_monitored_repository_has_local_branch_name (self, new_name);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

void
scratch_services_monitored_repository_change_local_branch (ScratchServicesMonitoredRepository* self,
                                                           const gchar* new_branch_name,
                                                           GError** error)
{
	GgitBranch* branch = NULL;
	GgitRepository* _tmp0_;
	GgitBranch* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_branch_name != NULL);
	_vala_return_if_fail (!g_str_has_prefix (new_branch_name, SCRATCH_SERVICES_MONITORED_REPOSITORY_ORIGIN_PREFIX), "!new_branch_name.has_prefix (ORIGIN_PREFIX)");
	_tmp0_ = self->priv->_git_repo;
	_tmp1_ = ggit_repository_lookup_branch (_tmp0_, new_branch_name, GGIT_BRANCH_LOCAL, &_inner_error0_);
	branch = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	scratch_services_monitored_repository_checkout_branch (self, branch, TRUE);
	_g_object_unref0 (branch);
}

static Block35Data*
block35_data_ref (Block35Data* _data35_)
{
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}

static void
block35_data_unref (void * _userdata_)
{
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		ScratchServicesMonitoredRepository* self;
		self = _data35_->self;
		_g_object_unref0 (_data35_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}

static void
___lambda13_ (Block35Data* _data35_)
{
	ScratchServicesMonitoredRepository* self;
	GraniteMessageDialog* _tmp0_;
	self = _data35_->self;
	_tmp0_ = _data35_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
____lambda13__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda13_ (self);
}

void
scratch_services_monitored_repository_checkout_remote_branch (ScratchServicesMonitoredRepository* self,
                                                              const gchar* target_shorthand,
                                                              GError** error)
{
	GgitRef* branch_ref = NULL;
	GList* list_pointer = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp10_;
	gconstpointer _tmp11_;
	GgitRef* _tmp12_;
	GgitRef* _tmp13_;
	GgitObject* commit = NULL;
	GgitRef* _tmp20_;
	GgitObject* _tmp21_;
	gchar* local_name = NULL;
	gint _tmp22_;
	gint _tmp23_;
	gchar* _tmp24_;
	GgitBranch* _tmp25_ = NULL;
	GgitRepository* _tmp26_;
	const gchar* _tmp27_;
	GgitObject* _tmp28_;
	GgitBranch* _tmp29_;
	GgitBranch* local_branch = NULL;
	GgitBranch* _tmp30_;
	GgitBranch* _tmp31_;
	GgitBranch* _tmp32_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target_shorthand != NULL);
	_vala_return_if_fail (g_str_has_prefix (target_shorthand, SCRATCH_SERVICES_MONITORED_REPOSITORY_ORIGIN_PREFIX), "target_shorthand.has_prefix (ORIGIN_PREFIX)");
	_tmp0_ = self->priv->remote_branch_ref_list;
	_tmp1_ = g_list_first (_tmp0_);
	list_pointer = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		GList* _tmp3_;
		gconstpointer _tmp4_;
		GList* _tmp8_;
		GList* _tmp9_;
		_tmp3_ = list_pointer;
		_tmp4_ = _tmp3_->data;
		if (((GgitRef*) _tmp4_) != NULL) {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = list_pointer;
			_tmp6_ = _tmp5_->data;
			_tmp7_ = ggit_ref_get_shorthand ((GgitRef*) _tmp6_);
			_tmp2_ = g_strcmp0 (_tmp7_, target_shorthand) != 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp8_ = list_pointer;
		_tmp9_ = _tmp8_->next;
		list_pointer = _tmp9_;
	}
	_tmp10_ = list_pointer;
	_tmp11_ = _tmp10_->data;
	_tmp12_ = _g_object_ref0 ((GgitRef*) _tmp11_);
	_g_object_unref0 (branch_ref);
	branch_ref = _tmp12_;
	_tmp13_ = branch_ref;
	if (_tmp13_ == NULL) {
		Block35Data* _data35_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GraniteMessageDialog* _tmp16_ = NULL;
		GraniteMessageDialog* _tmp17_;
		GraniteMessageDialog* _tmp18_;
		GraniteMessageDialog* _tmp19_;
		_data35_ = g_slice_new0 (Block35Data);
		_data35_->_ref_count_ = 1;
		_data35_->self = g_object_ref (self);
		_tmp14_ = g_strdup_printf (_ ("Remote Branch '%s' not found"), target_shorthand);
		_tmp15_ = _tmp14_;
		_tmp16_ = granite_message_dialog_new_with_image_from_icon_name (_tmp15_, _ ("The requested branch was not found in any remote linked to this reposi" \
"tory"), "dialog-warning", GTK_BUTTONS_CLOSE);
		gtk_window_set_modal ((GtkWindow*) _tmp16_, TRUE);
		g_object_ref_sink (_tmp16_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		_data35_->dialog = _tmp17_;
		_tmp18_ = _data35_->dialog;
		g_signal_connect_data ((GtkDialog*) _tmp18_, "response", (GCallback) ____lambda13__gtk_dialog_response, block35_data_ref (_data35_), (GClosureNotify) block35_data_unref, 0);
		_tmp19_ = _data35_->dialog;
		gtk_window_present ((GtkWindow*) _tmp19_);
		block35_data_unref (_data35_);
		_data35_ = NULL;
		_g_object_unref0 (branch_ref);
		return;
	}
	_tmp20_ = branch_ref;
	_tmp21_ = ggit_ref_lookup (_tmp20_, &_inner_error0_);
	commit = _tmp21_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (branch_ref);
		return;
	}
	_tmp22_ = strlen (SCRATCH_SERVICES_MONITORED_REPOSITORY_ORIGIN_PREFIX);
	_tmp23_ = _tmp22_;
	_tmp24_ = string_substring (target_shorthand, (glong) _tmp23_, (glong) -1);
	local_name = _tmp24_;
	_tmp26_ = self->priv->_git_repo;
	_tmp27_ = local_name;
	_tmp28_ = commit;
	_tmp29_ = ggit_repository_create_branch (_tmp26_, _tmp27_, _tmp28_, GGIT_CREATE_NONE, &_inner_error0_);
	_tmp25_ = _tmp29_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (local_name);
		_g_object_unref0 (commit);
		_g_object_unref0 (branch_ref);
		return;
	}
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, ggit_branch_get_type ()) ? ((GgitBranch*) _tmp25_) : NULL);
	local_branch = _tmp30_;
	_tmp31_ = local_branch;
	scratch_services_monitored_repository_checkout_branch (self, _tmp31_, TRUE);
	_tmp32_ = local_branch;
	ggit_branch_set_upstream (_tmp32_, target_shorthand, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (local_branch);
		_g_object_unref0 (_tmp25_);
		_g_free0 (local_name);
		_g_object_unref0 (commit);
		_g_object_unref0 (branch_ref);
		return;
	}
	_g_object_unref0 (local_branch);
	_g_object_unref0 (_tmp25_);
	_g_free0 (local_name);
	_g_object_unref0 (commit);
	_g_object_unref0 (branch_ref);
}

static void
scratch_services_monitored_repository_checkout_branch (ScratchServicesMonitoredRepository* self,
                                                       GgitBranch* new_head_branch,
                                                       gboolean confirm)
{
	gchar* new_branch_name = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_head_branch != NULL);
	_tmp0_ = g_strdup ("");
	new_branch_name = _tmp0_;
	{
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GgitRepository* _tmp7_;
		const gchar* _tmp8_;
		GgitCheckoutOptions* options = NULL;
		GgitCheckoutOptions* _tmp9_ = NULL;
		GgitRepository* _tmp10_;
		GgitCheckoutOptions* _tmp11_;
		const gchar* _tmp12_;
		_tmp2_ = ggit_branch_get_name (new_head_branch, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = g_strdup (_tmp1_);
		_g_free0 (new_branch_name);
		new_branch_name = _tmp3_;
		if (confirm) {
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp5_ = scratch_services_monitored_repository_get_has_uncommitted (self);
			_tmp6_ = _tmp5_;
			_tmp4_ = _tmp6_;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			scratch_services_monitored_repository_confirm_checkout_branch (self, new_head_branch, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_g_free0 (new_branch_name);
			return;
		}
		_tmp7_ = self->priv->_git_repo;
		_tmp8_ = ggit_ref_get_name (G_TYPE_CHECK_INSTANCE_CAST (new_head_branch, ggit_ref_get_type (), GgitRef));
		ggit_repository_set_head (_tmp7_, _tmp8_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = ggit_checkout_options_new ();
		ggit_checkout_options_set_strategy (_tmp9_, GGIT_CHECKOUT_FORCE);
		options = _tmp9_;
		_tmp10_ = self->priv->_git_repo;
		_tmp11_ = options;
		ggit_repository_checkout_head (_tmp10_, _tmp11_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (options);
			goto __catch0_g_error;
		}
		_tmp12_ = new_branch_name;
		scratch_services_monitored_repository_set_branch_name (self, _tmp12_);
		_g_object_unref0 (options);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GraniteMessageDialog* dialog = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		GraniteMessageDialog* _tmp15_;
		GraniteMessageDialog* _tmp16_;
		GraniteMessageDialog* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = granite_message_dialog_new_with_image_from_icon_name (_ ("An error occurred while checking out the requested branch"), _tmp14_, "dialog-warning", GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp15_);
		dialog = _tmp15_;
		_tmp16_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp16_);
		_tmp17_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp17_);
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (new_branch_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (new_branch_name);
}

static Block36Data*
block36_data_ref (Block36Data* _data36_)
{
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}

static void
block36_data_unref (void * _userdata_)
{
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		ScratchServicesMonitoredRepository* self;
		self = _data36_->self;
		_g_object_unref0 (_data36_->dialog);
		_g_object_unref0 (_data36_->new_head_branch);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}

static void
__lambda12_ (Block36Data* _data36_,
             gint res)
{
	ScratchServicesMonitoredRepository* self;
	ScratchDialogsOverwriteUncommittedConfirmationDialog* _tmp0_;
	self = _data36_->self;
	_tmp0_ = _data36_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	if (res == ((gint) GTK_RESPONSE_ACCEPT)) {
		scratch_services_monitored_repository_checkout_branch (self, _data36_->new_head_branch, FALSE);
	}
}

static void
___lambda12__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda12_ (self, response_id);
}

static void
scratch_services_monitored_repository_confirm_checkout_branch (ScratchServicesMonitoredRepository* self,
                                                               GgitBranch* new_head_branch,
                                                               GError** error)
{
	Block36Data* _data36_;
	GgitBranch* _tmp0_;
	GtkWindow* parent = NULL;
	GApplication* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	gchar* new_branch_name = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GtkWindow* _tmp8_;
	const gchar* _tmp9_;
	ScratchDialogsOverwriteUncommittedConfirmationDialog* _tmp10_;
	ScratchDialogsOverwriteUncommittedConfirmationDialog* _tmp11_;
	ScratchDialogsOverwriteUncommittedConfirmationDialog* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_head_branch != NULL);
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_data36_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (new_head_branch);
	_g_object_unref0 (_data36_->new_head_branch);
	_data36_->new_head_branch = _tmp0_;
	_tmp1_ = g_application_get_default ();
	_tmp2_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_application_get_type (), GtkApplication));
	_tmp3_ = _g_object_ref0 (_tmp2_);
	parent = _tmp3_;
	_tmp4_ = ggit_branch_get_name (_data36_->new_head_branch, &_inner_error0_);
	_tmp5_ = g_strdup (_tmp4_);
	new_branch_name = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (parent);
		block36_data_unref (_data36_);
		_data36_ = NULL;
		return;
	}
	_tmp7_ = scratch_services_monitored_repository_get_project_diff (self, &_inner_error0_);
	_tmp6_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (new_branch_name);
		_g_object_unref0 (parent);
		block36_data_unref (_data36_);
		_data36_ = NULL;
		return;
	}
	_tmp8_ = parent;
	_tmp9_ = new_branch_name;
	_tmp10_ = scratch_dialogs_overwrite_uncommitted_confirmation_dialog_new (_tmp8_, _tmp9_, _tmp6_);
	g_object_ref_sink (_tmp10_);
	_data36_->dialog = _tmp10_;
	_tmp11_ = _data36_->dialog;
	g_signal_connect_data ((GtkDialog*) _tmp11_, "response", (GCallback) ___lambda12__gtk_dialog_response, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	_tmp12_ = _data36_->dialog;
	gtk_window_present ((GtkWindow*) _tmp12_);
	_g_free0 (_tmp6_);
	_g_free0 (new_branch_name);
	_g_object_unref0 (parent);
	block36_data_unref (_data36_);
	_data36_ = NULL;
}

void
scratch_services_monitored_repository_create_new_branch (ScratchServicesMonitoredRepository* self,
                                                         const gchar* name,
                                                         GError** error)
{
	GgitRef* _tmp0_ = NULL;
	GgitRepository* _tmp1_;
	GgitRef* _tmp2_;
	GgitObject* git_object = NULL;
	GgitObject* _tmp3_;
	GgitBranch* new_branch = NULL;
	GgitRepository* _tmp4_;
	GgitObject* _tmp5_;
	GgitBranch* _tmp6_;
	GgitRepository* _tmp7_;
	GgitBranch* _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->_git_repo;
	_tmp2_ = ggit_repository_get_head (_tmp1_, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp3_ = ggit_ref_lookup (_tmp0_, &_inner_error0_);
	git_object = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp0_);
		return;
	}
	_tmp4_ = self->priv->_git_repo;
	_tmp5_ = git_object;
	_tmp6_ = ggit_repository_create_branch (_tmp4_, name, _tmp5_, GGIT_CREATE_NONE, &_inner_error0_);
	new_branch = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (git_object);
		_g_object_unref0 (_tmp0_);
		return;
	}
	_tmp7_ = self->priv->_git_repo;
	_tmp8_ = new_branch;
	_tmp9_ = ggit_ref_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, ggit_ref_get_type (), GgitRef));
	ggit_repository_set_head (_tmp7_, _tmp9_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (new_branch);
		_g_object_unref0 (git_object);
		_g_object_unref0 (_tmp0_);
		return;
	}
	_g_object_unref0 (new_branch);
	_g_object_unref0 (git_object);
	_g_object_unref0 (_tmp0_);
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

static gint
____lambda8_ (ScratchServicesMonitoredRepository* self,
              const gchar* path,
              GgitStatusFlags status)
{
	GeeHashMap* _tmp0_;
	gint result;
	g_return_val_if_fail (path != NULL, 0);
	_tmp0_ = self->priv->file_status_map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, path, (gpointer) ((gintptr) (&status)));
	result = 0;
	return result;
}

static gint
_____lambda8__ggit_status_callback (const gchar* path,
                                    GgitStatusFlags status_flags,
                                    gpointer self)
{
	gint result;
	result = ____lambda8_ ((ScratchServicesMonitoredRepository*) self, path, status_flags);
	return result;
}

static gboolean
___lambda7_ (ScratchServicesMonitoredRepository* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	if (self->priv->do_update) {
		gchar* target_name = NULL;
		gchar* _tmp0_;
		const gchar* _tmp18_;
		_tmp0_ = g_strdup ("");
		target_name = _tmp0_;
		{
			GgitRef* head = NULL;
			GgitRepository* _tmp1_;
			GgitRef* _tmp2_;
			GgitRef* _tmp3_;
			_tmp1_ = self->priv->_git_repo;
			_tmp2_ = ggit_repository_get_head (_tmp1_, &_inner_error0_);
			head = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = head;
			if (ggit_ref_is_branch (_tmp3_)) {
				const gchar* _tmp4_ = NULL;
				GgitRef* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp5_ = head;
				_tmp6_ = ggit_branch_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, ggit_branch_get_type (), GgitBranch), &_inner_error0_);
				_tmp4_ = _tmp6_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (head);
					goto __catch0_g_error;
				}
				_tmp7_ = g_strdup (_tmp4_);
				_g_free0 (target_name);
				target_name = _tmp7_;
			} else {
				GgitOId* target = NULL;
				GgitRef* _tmp8_;
				GgitOId* _tmp9_;
				GgitOId* _tmp10_;
				_tmp8_ = head;
				_tmp9_ = ggit_ref_get_target (_tmp8_);
				target = _tmp9_;
				_tmp10_ = target;
				if (_tmp10_ != NULL) {
					GgitOId* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp11_ = target;
					_tmp12_ = ggit_oid_to_string (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = g_strdup_printf (_ ("%.8s (detached)"), _tmp13_);
					_g_free0 (target_name);
					target_name = _tmp14_;
					_g_free0 (_tmp13_);
				}
				__vala_GgitOId_free0 (target);
			}
			_g_object_unref0 (head);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp15_;
			const gchar* _tmp16_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			g_warning ("MonitoredRepository.vala:337: An error occurred while fetching the cur" \
"rent git branch name: %s", _tmp16_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp17_ = FALSE;
			_g_free0 (target_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp17_;
		}
		_tmp18_ = target_name;
		scratch_services_monitored_repository_set_branch_name (self, _tmp18_);
		{
			GeeHashMap* _tmp19_;
			GgitRepository* _tmp20_;
			GgitStatusOptions* _tmp21_;
			_tmp19_ = self->priv->file_status_map;
			gee_abstract_map_clear ((GeeAbstractMap*) _tmp19_);
			_tmp20_ = self->priv->_git_repo;
			_tmp21_ = self->priv->status_options;
			ggit_repository_file_status_foreach (_tmp20_, _tmp21_, _____lambda8__ggit_status_callback, self, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			g_signal_emit (self, scratch_services_monitored_repository_signals[SCRATCH_SERVICES_MONITORED_REPOSITORY_FILE_STATUS_CHANGE_SIGNAL], 0);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp22_;
			const gchar* _tmp23_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			g_critical ("MonitoredRepository.vala:355: Error enumerating git status: %s", _tmp23_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp24_ = FALSE;
			_g_free0 (target_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp24_;
		}
		self->priv->do_update = FALSE;
		self->priv->update_timer_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		_g_free0 (target_name);
		return result;
	} else {
		self->priv->do_update = TRUE;
		result = G_SOURCE_CONTINUE;
		return result;
	}
}

static gboolean
____lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda7_ ((ScratchServicesMonitoredRepository*) self);
	return result;
}

void
scratch_services_monitored_repository_update_status_map (ScratchServicesMonitoredRepository* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->update_timer_id == ((guint) 0)) {
		self->priv->update_timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, ____lambda7__gsource_func, g_object_ref (self), g_object_unref);
		g_signal_emit (self, scratch_services_monitored_repository_signals[SCRATCH_SERVICES_MONITORED_REPOSITORY_FILE_CONTENT_CHANGED_SIGNAL], 0);
	} else {
		self->priv->do_update = FALSE;
	}
}

gboolean
scratch_services_monitored_repository_path_is_ignored (ScratchServicesMonitoredRepository* self,
                                                       const gchar* path,
                                                       GError** error)
{
	gboolean _tmp0_ = FALSE;
	GgitRepository* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp1_ = self->priv->_git_repo;
	_tmp0_ = ggit_repository_path_is_ignored (_tmp1_, path, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = _tmp0_;
	return result;
}

static Block37Data*
block37_data_ref (Block37Data* _data37_)
{
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}

static void
block37_data_unref (void * _userdata_)
{
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		ScratchServicesMonitoredRepository* self;
		self = _data37_->self;
		_g_string_free0 (_data37_->sb);
		_g_object_unref0 (self);
		g_slice_free (Block37Data, _data37_);
	}
}

static gint
__lambda11_ (Block37Data* _data37_,
             GgitDiffDelta* delta,
             GgitDiffHunk* hunk,
             GgitDiffLine* line)
{
	ScratchServicesMonitoredRepository* self;
	GgitDiffFile* file_diff = NULL;
	GgitDiffFile* _tmp0_;
	GgitDiffFile* _tmp1_;
	gint result;
	self = _data37_->self;
	g_return_val_if_fail (delta != NULL, 0);
	g_return_val_if_fail (line != NULL, 0);
	_tmp0_ = ggit_diff_delta_get_old_file (delta);
	file_diff = _tmp0_;
	_tmp1_ = file_diff;
	if (_tmp1_ == NULL) {
		result = 0;
		return result;
	}
	if (line != NULL) {
		GgitDiffLineType delta_type = 0;
		gchar* prefix = NULL;
		gchar* _tmp2_;
		GString* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		delta_type = ggit_diff_line_get_origin (line);
		_tmp2_ = g_strdup ("?");
		prefix = _tmp2_;
		switch (delta_type) {
			case GGIT_DIFF_LINE_ADDITION:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("+");
				_g_free0 (prefix);
				prefix = _tmp3_;
				break;
			}
			case GGIT_DIFF_LINE_DELETION:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("-");
				_g_free0 (prefix);
				prefix = _tmp4_;
				break;
			}
			case GGIT_DIFF_LINE_CONTEXT:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup (" ");
				_g_free0 (prefix);
				prefix = _tmp5_;
				break;
			}
			default:
			{
				break;
			}
		}
		_tmp6_ = _data37_->sb;
		_tmp7_ = prefix;
		_tmp8_ = ggit_diff_line_get_text (line);
		_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		g_string_append (_tmp6_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (prefix);
	}
	result = 0;
	return result;
}

static gint
___lambda11__ggit_diff_line_callback (GgitDiffDelta* delta,
                                      GgitDiffHunk* hunk,
                                      GgitDiffLine* line,
                                      gpointer self)
{
	gint result;
	result = __lambda11_ (self, delta, hunk, line);
	return result;
}

gchar*
scratch_services_monitored_repository_get_project_diff (ScratchServicesMonitoredRepository* self,
                                                        GError** error)
{
	Block37Data* _data37_;
	GString* _tmp0_;
	GgitDiff* repo_diff_list = NULL;
	GgitRepository* _tmp1_;
	GgitDiff* _tmp2_;
	GgitDiff* _tmp3_;
	GString* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data37_ = g_slice_new0 (Block37Data);
	_data37_->_ref_count_ = 1;
	_data37_->self = g_object_ref (self);
	_tmp0_ = g_string_new ("");
	_data37_->sb = _tmp0_;
	_tmp1_ = self->priv->_git_repo;
	_tmp2_ = ggit_diff_new_index_to_workdir (_tmp1_, NULL, NULL, &_inner_error0_);
	repo_diff_list = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		block37_data_unref (_data37_);
		_data37_ = NULL;
		return NULL;
	}
	_tmp3_ = repo_diff_list;
	ggit_diff_print (_tmp3_, GGIT_DIFF_FORMAT_PATCH, ___lambda11__ggit_diff_line_callback, _data37_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (repo_diff_list);
		block37_data_unref (_data37_);
		_data37_ = NULL;
		return NULL;
	}
	_tmp4_ = _data37_->sb;
	_tmp5_ = _tmp4_->str;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	_g_object_unref0 (repo_diff_list);
	block37_data_unref (_data37_);
	_data37_ = NULL;
	return result;
}

static Block38Data*
block38_data_ref (Block38Data* _data38_)
{
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}

static void
block38_data_unref (void * _userdata_)
{
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		ScratchServicesMonitoredRepository* self;
		self = _data38_->self;
		_g_object_unref0 (_data38_->status_map);
		_g_free0 (_data38_->file_path);
		_g_object_unref0 (self);
		g_slice_free (Block38Data, _data38_);
	}
}

static gint
___lambda14_ (Block38Data* _data38_,
              GgitDiffDelta* delta,
              GgitDiffHunk* hunk,
              GgitDiffLine* line)
{
	ScratchServicesMonitoredRepository* self;
	GgitDiffFile* file_diff = NULL;
	GgitDiffFile* _tmp0_;
	GgitDiffFile* _tmp1_;
	const gchar* diff_file_path = NULL;
	GgitDiffFile* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gint result;
	self = _data38_->self;
	g_return_val_if_fail (delta != NULL, 0);
	g_return_val_if_fail (line != NULL, 0);
	_tmp0_ = ggit_diff_delta_get_old_file (delta);
	file_diff = _tmp0_;
	_tmp1_ = file_diff;
	if (_tmp1_ == NULL) {
		result = 0;
		return result;
	}
	_tmp2_ = file_diff;
	_tmp3_ = ggit_diff_file_get_path (_tmp2_);
	diff_file_path = _tmp3_;
	_tmp5_ = diff_file_path;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = diff_file_path;
		_tmp4_ = !g_str_has_suffix (_data38_->file_path, _tmp6_);
	}
	if (_tmp4_) {
		result = 0;
		return result;
	}
	scratch_services_monitored_repository_process_diff_line (self, ggit_diff_line_get_origin (line), ggit_diff_line_get_new_lineno (line), ggit_diff_line_get_old_lineno (line), &_data38_->status_map, &_data38_->prev_deletions, &_data38_->prev_additions);
	result = 0;
	return result;
}

static gint
____lambda14__ggit_diff_line_callback (GgitDiffDelta* delta,
                                       GgitDiffHunk* hunk,
                                       GgitDiffLine* line,
                                       gpointer self)
{
	gint result;
	result = ___lambda14_ (self, delta, hunk, line);
	return result;
}

void
scratch_services_monitored_repository_refresh_diff (ScratchServicesMonitoredRepository* self,
                                                    const gchar* file_path,
                                                    GeeHashMap** line_status_map)
{
	Block38Data* _data38_;
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp7_;
	GeeHashMap* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_path != NULL);
	g_return_if_fail (*line_status_map != NULL);
	_data38_ = g_slice_new0 (Block38Data);
	_data38_->_ref_count_ = 1;
	_data38_->self = g_object_ref (self);
	_tmp0_ = g_strdup (file_path);
	_g_free0 (_data38_->file_path);
	_data38_->file_path = _tmp0_;
	if (self->priv->refreshing) {
		block38_data_unref (_data38_);
		_data38_ = NULL;
		return;
	} else {
		self->priv->refreshing = TRUE;
	}
	_tmp1_ = _g_object_ref0 (*line_status_map);
	_data38_->status_map = _tmp1_;
	_data38_->prev_deletions = 0;
	_data38_->prev_additions = 0;
	{
		GgitDiff* repo_diff_list = NULL;
		GgitRepository* _tmp2_;
		GgitDiff* _tmp3_;
		GgitDiff* _tmp4_;
		_tmp2_ = self->priv->_git_repo;
		_tmp3_ = ggit_diff_new_index_to_workdir (_tmp2_, NULL, NULL, &_inner_error0_);
		repo_diff_list = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = repo_diff_list;
		ggit_diff_foreach (_tmp4_, NULL, NULL, NULL, ____lambda14__ggit_diff_line_callback, _data38_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (repo_diff_list);
			goto __catch0_g_error;
		}
		_g_object_unref0 (repo_diff_list);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("MonitoredRepository.vala:455: Error getting diff list %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		self->priv->refreshing = FALSE;
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block38_data_unref (_data38_);
		_data38_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = _data38_->status_map;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (*line_status_map);
	*line_status_map = _tmp8_;
	block38_data_unref (_data38_);
	_data38_ = NULL;
}

static void
scratch_services_monitored_repository_process_diff_line (ScratchServicesMonitoredRepository* self,
                                                         GgitDiffLineType line_type,
                                                         gint new_line_no,
                                                         gint old_line_no,
                                                         GeeHashMap** line_status_map,
                                                         gint* prev_deletions,
                                                         gint* prev_additions)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*line_status_map != NULL);
	if (line_type == GGIT_DIFF_LINE_CONTEXT) {
		if ((*prev_deletions) > 0) {
			gee_abstract_map_set ((GeeAbstractMap*) (*line_status_map), (gpointer) ((gintptr) new_line_no), (gpointer) ((gintptr) SCRATCH_SERVICES_VC_STATUS_REPLACES_DELETED));
		}
		*prev_deletions = 0;
		*prev_additions = 0;
		return;
	}
	if (new_line_no < 0) {
		gint _tmp0_;
		_tmp0_ = *prev_deletions;
		*prev_deletions = _tmp0_ + 1;
		*prev_additions = 0;
		return;
	} else {
		if (line_type == GGIT_DIFF_LINE_ADDITION) {
			gint _tmp1_;
			_tmp1_ = *prev_additions;
			*prev_additions = _tmp1_ + 1;
			if ((*prev_deletions) >= (*prev_additions)) {
				gint _tmp2_;
				gee_abstract_map_set ((GeeAbstractMap*) (*line_status_map), (gpointer) ((gintptr) new_line_no), (gpointer) ((gintptr) SCRATCH_SERVICES_VC_STATUS_CHANGED));
				_tmp2_ = *prev_deletions;
				*prev_deletions = _tmp2_ - 1;
			} else {
				gee_abstract_map_set ((GeeAbstractMap*) (*line_status_map), (gpointer) ((gintptr) new_line_no), (gpointer) ((gintptr) SCRATCH_SERVICES_VC_STATUS_ADDED));
				*prev_deletions = 0;
			}
		} else {
			gee_abstract_map_set ((GeeAbstractMap*) (*line_status_map), (gpointer) ((gintptr) new_line_no), (gpointer) ((gintptr) SCRATCH_SERVICES_VC_STATUS_OTHER));
		}
	}
}

GgitRepository*
scratch_services_monitored_repository_get_git_repo (ScratchServicesMonitoredRepository* self)
{
	GgitRepository* result;
	GgitRepository* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_git_repo;
	result = _tmp0_;
	return result;
}

void
scratch_services_monitored_repository_set_git_repo (ScratchServicesMonitoredRepository* self,
                                                    GgitRepository* value)
{
	GgitRepository* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_services_monitored_repository_get_git_repo (self);
	if (old_value != value) {
		GgitRepository* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_git_repo);
		self->priv->_git_repo = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_services_monitored_repository_properties[SCRATCH_SERVICES_MONITORED_REPOSITORY_GIT_REPO_PROPERTY]);
	}
}

const gchar*
scratch_services_monitored_repository_get_branch_name (ScratchServicesMonitoredRepository* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_branch_name;
	result = _tmp0_;
	return result;
}

void
scratch_services_monitored_repository_set_branch_name (ScratchServicesMonitoredRepository* self,
                                                       const gchar* value)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_branch_name;
	if (g_strcmp0 (_tmp0_, value) != 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (value);
		_g_free0 (self->priv->_branch_name);
		self->priv->_branch_name = _tmp1_;
		g_signal_emit (self, scratch_services_monitored_repository_signals[SCRATCH_SERVICES_MONITORED_REPOSITORY_BRANCH_CHANGED_SIGNAL], 0);
	}
	g_object_notify_by_pspec ((GObject *) self, scratch_services_monitored_repository_properties[SCRATCH_SERVICES_MONITORED_REPOSITORY_BRANCH_NAME_PROPERTY]);
}

gboolean
scratch_services_monitored_repository_get_head_is_branch (ScratchServicesMonitoredRepository* self)
{
	gboolean result;
	gboolean _tmp3_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GgitRef* _tmp0_ = NULL;
		GgitRepository* _tmp1_;
		GgitRef* _tmp2_;
		_tmp1_ = self->priv->_git_repo;
		_tmp2_ = ggit_repository_get_head (_tmp1_, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = ggit_ref_is_branch (_tmp0_);
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp3_;
}

GeeSet*
scratch_services_monitored_repository_get_non_current_entries (ScratchServicesMonitoredRepository* self)
{
	GeeSet* result;
	GeeHashMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file_status_map;
	_tmp1_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static gboolean
_scratch_services_monitored_repository_has_uncommitted___lambda10_ (ScratchServicesMonitoredRepository* self,
                                                                    GgitStatusFlags* status)
{
	gboolean result;
	switch (*status) {
		case GGIT_STATUS_INDEX_NEW:
		case GGIT_STATUS_INDEX_MODIFIED:
		case GGIT_STATUS_INDEX_RENAMED:
		case GGIT_STATUS_WORKING_TREE_MODIFIED:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gboolean
__scratch_services_monitored_repository_has_uncommitted___lambda10__gee_predicate (gconstpointer g,
                                                                                   gpointer self)
{
	gboolean result;
	result = _scratch_services_monitored_repository_has_uncommitted___lambda10_ ((ScratchServicesMonitoredRepository*) self, (GgitStatusFlags*) g);
	return result;
}

gboolean
scratch_services_monitored_repository_get_has_uncommitted (ScratchServicesMonitoredRepository* self)
{
	gboolean result;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->file_status_map;
	_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_traversable_any_match ((GeeTraversable*) _tmp3_, __scratch_services_monitored_repository_has_uncommitted___lambda10__gee_predicate, g_object_ref (self), g_object_unref);
	_g_object_unref0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static GgitStatusFlags*
_ggit_status_flags_dup (GgitStatusFlags* self)
{
	GgitStatusFlags* dup;
	dup = g_new0 (GgitStatusFlags, 1);
	memcpy (dup, self, sizeof (GgitStatusFlags));
	return dup;
}

static GObject *
scratch_services_monitored_repository_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchServicesMonitoredRepository * self;
	GeeHashMap* _tmp0_;
	GgitStatusOptions* _tmp1_;
	parent_class = G_OBJECT_CLASS (scratch_services_monitored_repository_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, ScratchServicesMonitoredRepository);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, ggit_status_flags_get_type (), (GBoxedCopyFunc) _ggit_status_flags_dup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->file_status_map);
	self->priv->file_status_map = _tmp0_;
	_tmp1_ = ggit_status_options_new (GGIT_STATUS_OPTION_INCLUDE_UNTRACKED | GGIT_STATUS_OPTION_RECURSE_UNTRACKED_DIRS, GGIT_STATUS_SHOW_INDEX_AND_WORKDIR, NULL);
	__vala_GgitStatusOptions_free0 (self->priv->status_options);
	self->priv->status_options = _tmp1_;
	(self->priv->remote_branch_ref_list == NULL) ? NULL : (self->priv->remote_branch_ref_list = (_g_list_free__g_object_unref0_ (self->priv->remote_branch_ref_list), NULL));
	self->priv->remote_branch_ref_list = NULL;
	return obj;
}

static void
scratch_services_monitored_repository_class_init (ScratchServicesMonitoredRepositoryClass * klass,
                                                  gpointer klass_data)
{
	scratch_services_monitored_repository_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchServicesMonitoredRepository_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_services_monitored_repository_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_services_monitored_repository_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_services_monitored_repository_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_services_monitored_repository_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_MONITORED_REPOSITORY_GIT_REPO_PROPERTY, scratch_services_monitored_repository_properties[SCRATCH_SERVICES_MONITORED_REPOSITORY_GIT_REPO_PROPERTY] = g_param_spec_object ("git-repo", "git-repo", "git-repo", ggit_repository_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_MONITORED_REPOSITORY_BRANCH_NAME_PROPERTY, scratch_services_monitored_repository_properties[SCRATCH_SERVICES_MONITORED_REPOSITORY_BRANCH_NAME_PROPERTY] = g_param_spec_string ("branch-name", "branch-name", "branch-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_MONITORED_REPOSITORY_HEAD_IS_BRANCH_PROPERTY, scratch_services_monitored_repository_properties[SCRATCH_SERVICES_MONITORED_REPOSITORY_HEAD_IS_BRANCH_PROPERTY] = g_param_spec_boolean ("head-is-branch", "head-is-branch", "head-is-branch", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_MONITORED_REPOSITORY_NON_CURRENT_ENTRIES_PROPERTY, scratch_services_monitored_repository_properties[SCRATCH_SERVICES_MONITORED_REPOSITORY_NON_CURRENT_ENTRIES_PROPERTY] = g_param_spec_object ("non-current-entries", "non-current-entries", "non-current-entries", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_MONITORED_REPOSITORY_HAS_UNCOMMITTED_PROPERTY, scratch_services_monitored_repository_properties[SCRATCH_SERVICES_MONITORED_REPOSITORY_HAS_UNCOMMITTED_PROPERTY] = g_param_spec_boolean ("has-uncommitted", "has-uncommitted", "has-uncommitted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	scratch_services_monitored_repository_signals[SCRATCH_SERVICES_MONITORED_REPOSITORY_BRANCH_CHANGED_SIGNAL] = g_signal_new ("branch-changed", SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	scratch_services_monitored_repository_signals[SCRATCH_SERVICES_MONITORED_REPOSITORY_IGNORED_CHANGED_SIGNAL] = g_signal_new ("ignored-changed", SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	scratch_services_monitored_repository_signals[SCRATCH_SERVICES_MONITORED_REPOSITORY_FILE_STATUS_CHANGE_SIGNAL] = g_signal_new ("file-status-change", SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	scratch_services_monitored_repository_signals[SCRATCH_SERVICES_MONITORED_REPOSITORY_FILE_CONTENT_CHANGED_SIGNAL] = g_signal_new ("file-content-changed", SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
scratch_services_monitored_repository_instance_init (ScratchServicesMonitoredRepository * self,
                                                     gpointer klass)
{
	gchar* _tmp0_;
	self->priv = scratch_services_monitored_repository_get_instance_private (self);
	self->priv->git_monitor = NULL;
	self->priv->gitignore_monitor = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_branch_name = _tmp0_;
	self->priv->update_timer_id = (guint) 0;
	self->priv->do_update = FALSE;
	self->priv->refreshing = FALSE;
}

static void
scratch_services_monitored_repository_finalize (GObject * obj)
{
	ScratchServicesMonitoredRepository * self;
	GFileMonitor* _tmp0_;
	GFileMonitor* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, ScratchServicesMonitoredRepository);
	_tmp0_ = self->priv->git_monitor;
	if (_tmp0_ != NULL) {
		GFileMonitor* _tmp1_;
		_tmp1_ = self->priv->git_monitor;
		g_file_monitor_cancel (_tmp1_);
	}
	_tmp2_ = self->priv->gitignore_monitor;
	if (_tmp2_ != NULL) {
		GFileMonitor* _tmp3_;
		_tmp3_ = self->priv->gitignore_monitor;
		g_file_monitor_cancel (_tmp3_);
	}
	_g_object_unref0 (self->priv->_git_repo);
	_g_object_unref0 (self->priv->git_monitor);
	_g_object_unref0 (self->priv->gitignore_monitor);
	_g_free0 (self->priv->_branch_name);
	__vala_GgitStatusOptions_free0 (self->priv->status_options);
	_g_object_unref0 (self->priv->file_status_map);
	(self->priv->remote_branch_ref_list == NULL) ? NULL : (self->priv->remote_branch_ref_list = (_g_list_free__g_object_unref0_ (self->priv->remote_branch_ref_list), NULL));
	G_OBJECT_CLASS (scratch_services_monitored_repository_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scratch_services_monitored_repository_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchServicesMonitoredRepositoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_services_monitored_repository_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchServicesMonitoredRepository), 0, (GInstanceInitFunc) scratch_services_monitored_repository_instance_init, NULL };
	GType scratch_services_monitored_repository_type_id;
	scratch_services_monitored_repository_type_id = g_type_register_static (G_TYPE_OBJECT, "ScratchServicesMonitoredRepository", &g_define_type_info, 0);
	ScratchServicesMonitoredRepository_private_offset = g_type_add_instance_private (scratch_services_monitored_repository_type_id, sizeof (ScratchServicesMonitoredRepositoryPrivate));
	return scratch_services_monitored_repository_type_id;
}

GType
scratch_services_monitored_repository_get_type (void)
{
	static gsize scratch_services_monitored_repository_type_id__once = 0;
	if (g_once_init_enter (&scratch_services_monitored_repository_type_id__once)) {
		GType scratch_services_monitored_repository_type_id;
		scratch_services_monitored_repository_type_id = scratch_services_monitored_repository_get_type_once ();
		g_once_init_leave (&scratch_services_monitored_repository_type_id__once, scratch_services_monitored_repository_type_id);
	}
	return scratch_services_monitored_repository_type_id__once;
}

static void
_vala_scratch_services_monitored_repository_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	ScratchServicesMonitoredRepository * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, ScratchServicesMonitoredRepository);
	switch (property_id) {
		case SCRATCH_SERVICES_MONITORED_REPOSITORY_GIT_REPO_PROPERTY:
		g_value_set_object (value, scratch_services_monitored_repository_get_git_repo (self));
		break;
		case SCRATCH_SERVICES_MONITORED_REPOSITORY_BRANCH_NAME_PROPERTY:
		g_value_set_string (value, scratch_services_monitored_repository_get_branch_name (self));
		break;
		case SCRATCH_SERVICES_MONITORED_REPOSITORY_HEAD_IS_BRANCH_PROPERTY:
		g_value_set_boolean (value, scratch_services_monitored_repository_get_head_is_branch (self));
		break;
		case SCRATCH_SERVICES_MONITORED_REPOSITORY_NON_CURRENT_ENTRIES_PROPERTY:
		g_value_take_object (value, scratch_services_monitored_repository_get_non_current_entries (self));
		break;
		case SCRATCH_SERVICES_MONITORED_REPOSITORY_HAS_UNCOMMITTED_PROPERTY:
		g_value_set_boolean (value, scratch_services_monitored_repository_get_has_uncommitted (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_services_monitored_repository_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	ScratchServicesMonitoredRepository * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, ScratchServicesMonitoredRepository);
	switch (property_id) {
		case SCRATCH_SERVICES_MONITORED_REPOSITORY_GIT_REPO_PROPERTY:
		scratch_services_monitored_repository_set_git_repo (self, g_value_get_object (value));
		break;
		case SCRATCH_SERVICES_MONITORED_REPOSITORY_BRANCH_NAME_PROPERTY:
		scratch_services_monitored_repository_set_branch_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

