// This file is @generated by prost-build.
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WirelessConnection {
    #[prost(string, optional, tag = "1")]
    pub ssid: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(uint32, optional, tag = "2")]
    pub frequency_mhz: ::core::option::Option<u32>,
    #[prost(uint32, optional, tag = "3")]
    pub bitrate_kbps: ::core::option::Option<u32>,
    #[prost(uint32, optional, tag = "4")]
    pub signal_strength_percent: ::core::option::Option<u32>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Connection {
    #[prost(string, required, tag = "1")]
    pub id: ::prost::alloc::string::String,
    #[prost(string, optional, tag = "2")]
    pub device_name: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(enumeration = "ConnectionKind", required, tag = "3")]
    pub kind: i32,
    #[prost(message, optional, tag = "4")]
    pub wireless_connection: ::core::option::Option<WirelessConnection>,
    #[prost(string, required, tag = "5")]
    pub hw_address: ::prost::alloc::string::String,
    #[prost(float, required, tag = "6")]
    pub tx_rate_bytes_ps: f32,
    #[prost(uint64, required, tag = "7")]
    pub tx_total_bytes: u64,
    #[prost(float, required, tag = "8")]
    pub rx_rate_bytes_ps: f32,
    #[prost(uint64, required, tag = "9")]
    pub rx_total_bytes: u64,
    #[prost(uint64, optional, tag = "10")]
    pub max_speed_bytes_ps: ::core::option::Option<u64>,
    #[prost(string, optional, tag = "11")]
    pub ipv4_address: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(string, optional, tag = "12")]
    pub ipv6_address: ::core::option::Option<::prost::alloc::string::String>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ConnectionsRequest {}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ConnectionsResponse {
    #[prost(oneof = "connections_response::Response", tags = "1, 2")]
    pub response: ::core::option::Option<connections_response::Response>,
}
/// Nested message and enum types in `ConnectionsResponse`.
pub mod connections_response {
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ConnectionList {
        #[prost(message, repeated, tag = "1")]
        pub connections: ::prost::alloc::vec::Vec<super::Connection>,
    }
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(strum::EnumIter)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Response {
        #[prost(message, tag = "1")]
        Connections(ConnectionList),
        #[prost(message, tag = "2")]
        Error(super::ConnectionsResponseError),
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ConnectionsResponseError {}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(strum::EnumIter)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum ConnectionKind {
    Bluetooth = 1,
    Bridge = 2,
    Docker = 3,
    InfiniBand = 4,
    Multipass = 5,
    Virtual = 6,
    Vpn = 7,
    Wired = 8,
    Wireless = 9,
    Wwan = 10,
    Other = 255,
}
impl ConnectionKind {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Bluetooth => "Bluetooth",
            Self::Bridge => "Bridge",
            Self::Docker => "Docker",
            Self::InfiniBand => "InfiniBand",
            Self::Multipass => "Multipass",
            Self::Virtual => "Virtual",
            Self::Vpn => "VPN",
            Self::Wired => "Wired",
            Self::Wireless => "Wireless",
            Self::Wwan => "WWAN",
            Self::Other => "Other",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "Bluetooth" => Some(Self::Bluetooth),
            "Bridge" => Some(Self::Bridge),
            "Docker" => Some(Self::Docker),
            "InfiniBand" => Some(Self::InfiniBand),
            "Multipass" => Some(Self::Multipass),
            "Virtual" => Some(Self::Virtual),
            "VPN" => Some(Self::Vpn),
            "Wired" => Some(Self::Wired),
            "Wireless" => Some(Self::Wireless),
            "WWAN" => Some(Self::Wwan),
            "Other" => Some(Self::Other),
            _ => None,
        }
    }
}
