/* dash-box.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from dash-box.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011,2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Michael Terry <michael.terry@canonical.com>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>

#define DASH_BOX_BLUR_RADIUS 8
#define grid_size 40
#define GREETER_LIST_DEFAULT_BOX_HEIGHT 3
#define GREETER_LIST_BORDER 4
#define GREETER_LIST_BOX_WIDTH 9
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DASH_BOX (dash_box_get_type ())
#define DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DASH_BOX, DashBox))
#define DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DASH_BOX, DashBoxClass))
#define IS_DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DASH_BOX))
#define IS_DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DASH_BOX))
#define DASH_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DASH_BOX, DashBoxClass))

typedef struct _DashBox DashBox;
typedef struct _DashBoxClass DashBoxClass;
typedef struct _DashBoxPrivate DashBoxPrivate;

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;

#define TYPE_FADABLE_BOX (fadable_box_get_type ())
#define FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE_BOX, FadableBox))
#define FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADABLE_BOX, FadableBoxClass))
#define IS_FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE_BOX))
#define IS_FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADABLE_BOX))
#define FADABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADABLE_BOX, FadableBoxClass))

typedef struct _FadableBox FadableBox;
typedef struct _FadableBoxClass FadableBoxClass;

#define TYPE_GREETER_LIST (greeter_list_get_type ())
#define GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GREETER_LIST, GreeterList))
#define GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GREETER_LIST, GreeterListClass))
#define IS_GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GREETER_LIST))
#define IS_GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GREETER_LIST))
#define GREETER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GREETER_LIST, GreeterListClass))

typedef struct _GreeterList GreeterList;
typedef struct _GreeterListClass GreeterListClass;

#define TYPE_FADE_TRACKER (fade_tracker_get_type ())
#define FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADE_TRACKER, FadeTracker))
#define FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADE_TRACKER, FadeTrackerClass))
#define IS_FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADE_TRACKER))
#define IS_FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADE_TRACKER))
#define FADE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADE_TRACKER, FadeTrackerClass))

typedef struct _FadeTracker FadeTracker;
typedef struct _FadeTrackerClass FadeTrackerClass;
typedef enum  {
	DASH_BOX_MODE_NORMAL,
	DASH_BOX_MODE_PUSH_FADE_OUT,
	DASH_BOX_MODE_PUSH_FADE_IN,
	DASH_BOX_MODE_POP_FADE_OUT,
	DASH_BOX_MODE_POP_FADE_IN
} DashBoxMode;

#define DASH_BOX_TYPE_MODE (dash_box_mode_get_type ())
enum  {
	DASH_BOX_0_PROPERTY,
	DASH_BOX_BACKGROUND_PROPERTY,
	DASH_BOX_HAS_BASE_PROPERTY,
	DASH_BOX_BASE_ALPHA_PROPERTY,
	DASH_BOX_NUM_PROPERTIES
};
static GParamSpec* dash_box_properties[DASH_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef enum  {
	FADE_TRACKER_MODE_FADE_IN,
	FADE_TRACKER_MODE_FADE_OUT
} FadeTrackerMode;

#define FADE_TRACKER_TYPE_MODE (fade_tracker_mode_get_type ())

#define TYPE_FADABLE (fadable_get_type ())
#define FADABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE, Fadable))
#define IS_FADABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE))
#define FADABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FADABLE, FadableIface))

typedef struct _Fadable Fadable;
typedef struct _FadableIface FadableIface;

#define TYPE_PROMPT_BOX (prompt_box_get_type ())
#define PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROMPT_BOX, PromptBox))
#define PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROMPT_BOX, PromptBoxClass))
#define IS_PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROMPT_BOX))
#define IS_PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROMPT_BOX))
#define PROMPT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROMPT_BOX, PromptBoxClass))

typedef struct _PromptBox PromptBox;
typedef struct _PromptBoxClass PromptBoxClass;
typedef enum  {
	BACKGROUND_DRAW_FLAGS_NONE = 1 << 0,
	BACKGROUND_DRAW_FLAGS_GRID = 1 << 1,
	BACKGROUND_DRAW_FLAGS_SPAN = 1 << 2
} BackgroundDrawFlags;

#define BACKGROUND_TYPE_DRAW_FLAGS (background_draw_flags_get_type ())
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	DASH_BOX_TRANSITION_COMPLETE_SIGNAL,
	DASH_BOX_NUM_SIGNALS
};
static guint dash_box_signals[DASH_BOX_NUM_SIGNALS] = {0};

struct _DashBox {
	GtkBox parent_instance;
	DashBoxPrivate * priv;
};

struct _DashBoxClass {
	GtkBoxClass parent_class;
};

struct _DashBoxPrivate {
	Background* _background;
	gboolean _has_base;
	gdouble _base_alpha;
	GreeterList* pushed;
	GtkWidget* orig;
	FadeTracker* orig_tracker;
	gint orig_height;
	DashBoxMode mode;
	cairo_surface_t* bg_surface;
};

struct _FadableIface {
	GTypeInterface parent_iface;
	FadeTracker* (*get_fade_tracker) (Fadable* self);
	void (*set_fade_tracker) (Fadable* self, FadeTracker* value);
};

static gint DashBox_private_offset;
static gpointer dash_box_parent_class = NULL;

VALA_EXTERN GType dash_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DashBox, g_object_unref)
VALA_EXTERN GType background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Background, g_object_unref)
VALA_EXTERN GType fadable_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FadableBox, g_object_unref)
VALA_EXTERN GType greeter_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterList, g_object_unref)
VALA_EXTERN GType fade_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FadeTracker, g_object_unref)
static GType dash_box_mode_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN DashBox* dash_box_new (Background* bg);
VALA_EXTERN DashBox* dash_box_construct (GType object_type,
                             Background* bg);
static void dash_box_rebuild_background (DashBox* self);
VALA_EXTERN void dash_box_cleanup (DashBox* self);
static void dash_box_real_size_allocate (GtkWidget* base,
                                  GtkAllocation* allocation);
VALA_EXTERN void dash_box_set_base (DashBox* self,
                        GtkWidget* w);
static void dash_box_base_size_allocate_cb (DashBox* self);
static void _dash_box_base_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                               GtkAllocation* allocation,
                                                               gpointer self);
VALA_EXTERN FadeTracker* fade_tracker_new (GtkWidget* widget);
VALA_EXTERN FadeTracker* fade_tracker_construct (GType object_type,
                                     GtkWidget* widget);
static void ___lambda38_ (DashBox* self);
VALA_EXTERN gdouble fade_tracker_get_alpha (FadeTracker* self);
static void dash_box_set_base_alpha (DashBox* self,
                              gdouble value);
static void ____lambda38__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void dash_box_fade_done_cb (DashBox* self);
static void _dash_box_fade_done_cb_fade_tracker_done (FadeTracker* _sender,
                                               gpointer self);
static void dash_box_set_has_base (DashBox* self,
                            gboolean value);
VALA_EXTERN void dash_box_push (DashBox* self,
                    GreeterList* l);
static void _dash_box_fade_done_cb_fadable_box_fade_done (FadableBox* _sender,
                                                   gpointer self);
VALA_EXTERN GType fade_tracker_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void fade_tracker_reset (FadeTracker* self,
                         FadeTrackerMode mode);
VALA_EXTERN void dash_box_pop (DashBox* self);
VALA_EXTERN GType fadable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Fadable, g_object_unref)
VALA_EXTERN void fadable_fade_out (Fadable* self);
VALA_EXTERN void fadable_fade_in (Fadable* self);
static void dash_box_force_immediate_layout_update (DashBox* self);
static void dash_box_real_get_preferred_height (GtkWidget* base,
                                         gint* min,
                                         gint* nat);
VALA_EXTERN GType prompt_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PromptBox, g_object_unref)
VALA_EXTERN PromptBox* greeter_list_get_selected_entry (GreeterList* self);
static void dash_box_real_get_preferred_width (GtkWidget* base,
                                        gint* min,
                                        gint* nat);
static gboolean dash_box_real_draw (GtkWidget* base,
                             cairo_t* c);
VALA_EXTERN gdouble dash_box_get_base_alpha (DashBox* self);
VALA_EXTERN Background* dash_box_get_background (DashBox* self);
VALA_EXTERN GType background_draw_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void background_draw_full (Background* self,
                           cairo_t* c,
                           BackgroundDrawFlags flags);
VALA_EXTERN void cairo_utils_exponential_blur_surface (cairo_surface_t* surface,
                                           gint radius);
VALA_EXTERN void cairo_utils_rounded_rectangle (cairo_t* c,
                                    gdouble x,
                                    gdouble y,
                                    gdouble width,
                                    gdouble height,
                                    gdouble radius);
static void dash_box_set_background (DashBox* self,
                              Background* value);
VALA_EXTERN gboolean dash_box_get_has_base (DashBox* self);
static GObject * dash_box_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties);
static void _dash_box_rebuild_background_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self);
static void dash_box_finalize (GObject * obj);
static GType dash_box_get_type_once (void);
static void _vala_dash_box_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_dash_box_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
dash_box_get_instance_private (DashBox* self)
{
	return G_STRUCT_MEMBER_P (self, DashBox_private_offset);
}

static GType
dash_box_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{DASH_BOX_MODE_NORMAL, "DASH_BOX_MODE_NORMAL", "normal"}, {DASH_BOX_MODE_PUSH_FADE_OUT, "DASH_BOX_MODE_PUSH_FADE_OUT", "push-fade-out"}, {DASH_BOX_MODE_PUSH_FADE_IN, "DASH_BOX_MODE_PUSH_FADE_IN", "push-fade-in"}, {DASH_BOX_MODE_POP_FADE_OUT, "DASH_BOX_MODE_POP_FADE_OUT", "pop-fade-out"}, {DASH_BOX_MODE_POP_FADE_IN, "DASH_BOX_MODE_POP_FADE_IN", "pop-fade-in"}, {0, NULL, NULL}};
	GType dash_box_mode_type_id;
	dash_box_mode_type_id = g_enum_register_static ("DashBoxMode", values);
	return dash_box_mode_type_id;
}

static GType
dash_box_mode_get_type (void)
{
	static volatile gsize dash_box_mode_type_id__once = 0;
	if (g_once_init_enter (&dash_box_mode_type_id__once)) {
		GType dash_box_mode_type_id;
		dash_box_mode_type_id = dash_box_mode_get_type_once ();
		g_once_init_leave (&dash_box_mode_type_id__once, dash_box_mode_type_id);
	}
	return dash_box_mode_type_id__once;
}

DashBox*
dash_box_construct (GType object_type,
                    Background* bg)
{
	DashBox * self = NULL;
#line 47 "../src/dash-box.vala"
	g_return_val_if_fail (bg != NULL, NULL);
#line 49 "../src/dash-box.vala"
	self = (DashBox*) g_object_new (object_type, "background", bg, NULL);
#line 47 "../src/dash-box.vala"
	return self;
#line 331 "dash-box.c"
}

DashBox*
dash_box_new (Background* bg)
{
#line 47 "../src/dash-box.vala"
	return dash_box_construct (TYPE_DASH_BOX, bg);
#line 339 "dash-box.c"
}

static void
dash_box_rebuild_background (DashBox* self)
{
#line 64 "../src/dash-box.vala"
	g_return_if_fail (self != NULL);
#line 66 "../src/dash-box.vala"
	_cairo_surface_destroy0 (self->priv->bg_surface);
#line 66 "../src/dash-box.vala"
	self->priv->bg_surface = NULL;
#line 67 "../src/dash-box.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 353 "dash-box.c"
}

void
dash_box_cleanup (DashBox* self)
{
	cairo_surface_t* _tmp0_;
#line 70 "../src/dash-box.vala"
	g_return_if_fail (self != NULL);
#line 73 "../src/dash-box.vala"
	_tmp0_ = self->priv->bg_surface;
#line 73 "../src/dash-box.vala"
	if (_tmp0_ != NULL) {
#line 366 "dash-box.c"
		cairo_surface_t* _tmp1_;
#line 75 "../src/dash-box.vala"
		_tmp1_ = self->priv->bg_surface;
#line 75 "../src/dash-box.vala"
		cairo_surface_finish (_tmp1_);
#line 76 "../src/dash-box.vala"
		_cairo_surface_destroy0 (self->priv->bg_surface);
#line 76 "../src/dash-box.vala"
		self->priv->bg_surface = NULL;
#line 376 "dash-box.c"
	}
}

static void
dash_box_real_size_allocate (GtkWidget* base,
                             GtkAllocation* allocation)
{
	DashBox * self;
	GtkAllocation _tmp0_;
#line 80 "../src/dash-box.vala"
	self = (DashBox*) base;
#line 80 "../src/dash-box.vala"
	g_return_if_fail (allocation != NULL);
#line 82 "../src/dash-box.vala"
	_tmp0_ = *allocation;
#line 82 "../src/dash-box.vala"
	GTK_WIDGET_CLASS (dash_box_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox), &_tmp0_);
#line 85 "../src/dash-box.vala"
	dash_box_rebuild_background (self);
#line 396 "dash-box.c"
}

static void
_dash_box_base_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                          GtkAllocation* allocation,
                                                          gpointer self)
{
#line 95 "../src/dash-box.vala"
	dash_box_base_size_allocate_cb ((DashBox*) self);
#line 406 "dash-box.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 96 "../src/dash-box.vala"
	return self ? g_object_ref (self) : NULL;
#line 414 "dash-box.c"
}

static void
___lambda38_ (DashBox* self)
{
	FadeTracker* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
#line 104 "../src/dash-box.vala"
	_tmp0_ = self->priv->orig_tracker;
#line 104 "../src/dash-box.vala"
	_tmp1_ = fade_tracker_get_alpha (_tmp0_);
#line 104 "../src/dash-box.vala"
	_tmp2_ = _tmp1_;
#line 104 "../src/dash-box.vala"
	dash_box_set_base_alpha (self, _tmp2_);
#line 105 "../src/dash-box.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 433 "dash-box.c"
}

static void
____lambda38__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
#line 102 "../src/dash-box.vala"
	___lambda38_ ((DashBox*) self);
#line 443 "dash-box.c"
}

static void
_dash_box_fade_done_cb_fade_tracker_done (FadeTracker* _sender,
                                          gpointer self)
{
#line 107 "../src/dash-box.vala"
	dash_box_fade_done_cb ((DashBox*) self);
#line 452 "dash-box.c"
}

void
dash_box_set_base (DashBox* self,
                   GtkWidget* w)
{
	GreeterList* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
#line 89 "../src/dash-box.vala"
	g_return_if_fail (self != NULL);
#line 91 "../src/dash-box.vala"
	_tmp0_ = self->priv->pushed;
#line 91 "../src/dash-box.vala"
	g_return_if_fail (_tmp0_ == NULL);
#line 92 "../src/dash-box.vala"
	g_return_if_fail (self->priv->mode == DASH_BOX_MODE_NORMAL);
#line 94 "../src/dash-box.vala"
	_tmp1_ = self->priv->orig;
#line 94 "../src/dash-box.vala"
	if (_tmp1_ != NULL) {
#line 475 "dash-box.c"
		GtkWidget* _tmp2_;
		guint _tmp3_;
#line 95 "../src/dash-box.vala"
		_tmp2_ = self->priv->orig;
#line 95 "../src/dash-box.vala"
		g_signal_parse_name ("size-allocate", gtk_widget_get_type (), &_tmp3_, NULL, FALSE);
#line 95 "../src/dash-box.vala"
		g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _dash_box_base_size_allocate_cb_gtk_widget_size_allocate, self);
#line 484 "dash-box.c"
	}
#line 96 "../src/dash-box.vala"
	_tmp4_ = _g_object_ref0 (w);
#line 96 "../src/dash-box.vala"
	_g_object_unref0 (self->priv->orig);
#line 96 "../src/dash-box.vala"
	self->priv->orig = _tmp4_;
#line 98 "../src/dash-box.vala"
	_tmp5_ = self->priv->orig;
#line 98 "../src/dash-box.vala"
	if (_tmp5_ != NULL) {
#line 496 "dash-box.c"
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		FadeTracker* _tmp8_;
		FadeTracker* _tmp9_;
		FadeTracker* _tmp10_;
		FadeTracker* _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
#line 100 "../src/dash-box.vala"
		_tmp6_ = self->priv->orig;
#line 100 "../src/dash-box.vala"
		g_signal_connect_object (_tmp6_, "size-allocate", (GCallback) _dash_box_base_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 101 "../src/dash-box.vala"
		_tmp7_ = self->priv->orig;
#line 101 "../src/dash-box.vala"
		_tmp8_ = fade_tracker_new (_tmp7_);
#line 101 "../src/dash-box.vala"
		_g_object_unref0 (self->priv->orig_tracker);
#line 101 "../src/dash-box.vala"
		self->priv->orig_tracker = _tmp8_;
#line 102 "../src/dash-box.vala"
		_tmp9_ = self->priv->orig_tracker;
#line 102 "../src/dash-box.vala"
		g_signal_connect_object ((GObject*) _tmp9_, "notify::alpha", (GCallback) ____lambda38__g_object_notify, self, 0);
#line 107 "../src/dash-box.vala"
		_tmp10_ = self->priv->orig_tracker;
#line 107 "../src/dash-box.vala"
		g_signal_connect_object (_tmp10_, "done", (GCallback) _dash_box_fade_done_cb_fade_tracker_done, self, 0);
#line 108 "../src/dash-box.vala"
		_tmp11_ = self->priv->orig_tracker;
#line 108 "../src/dash-box.vala"
		_tmp12_ = fade_tracker_get_alpha (_tmp11_);
#line 108 "../src/dash-box.vala"
		_tmp13_ = _tmp12_;
#line 108 "../src/dash-box.vala"
		dash_box_set_base_alpha (self, _tmp13_);
#line 109 "../src/dash-box.vala"
		dash_box_set_has_base (self, TRUE);
#line 535 "dash-box.c"
	} else {
		gint _tmp14_ = 0;
#line 113 "../src/dash-box.vala"
		self->priv->orig_height = -1;
#line 114 "../src/dash-box.vala"
		gtk_widget_get_preferred_height ((GtkWidget*) self, NULL, &_tmp14_);
#line 114 "../src/dash-box.vala"
		self->priv->orig_height = _tmp14_;
#line 116 "../src/dash-box.vala"
		_g_object_unref0 (self->priv->orig_tracker);
#line 116 "../src/dash-box.vala"
		self->priv->orig_tracker = NULL;
#line 117 "../src/dash-box.vala"
		dash_box_set_base_alpha (self, 1.0);
#line 118 "../src/dash-box.vala"
		dash_box_set_has_base (self, FALSE);
#line 552 "dash-box.c"
	}
#line 121 "../src/dash-box.vala"
	gtk_widget_queue_resize ((GtkWidget*) self);
#line 556 "dash-box.c"
}

static void
_dash_box_fade_done_cb_fadable_box_fade_done (FadableBox* _sender,
                                              gpointer self)
{
#line 133 "../src/dash-box.vala"
	dash_box_fade_done_cb ((DashBox*) self);
#line 565 "dash-box.c"
}

void
dash_box_push (DashBox* self,
               GreeterList* l)
{
	GreeterList* _tmp0_;
	GtkWidget* _tmp1_;
	gint _tmp2_ = 0;
	GreeterList* _tmp3_;
	GreeterList* _tmp4_;
	FadeTracker* _tmp5_;
#line 124 "../src/dash-box.vala"
	g_return_if_fail (self != NULL);
#line 124 "../src/dash-box.vala"
	g_return_if_fail (l != NULL);
#line 127 "../src/dash-box.vala"
	_tmp0_ = self->priv->pushed;
#line 127 "../src/dash-box.vala"
	g_return_if_fail (_tmp0_ == NULL);
#line 128 "../src/dash-box.vala"
	_tmp1_ = self->priv->orig;
#line 128 "../src/dash-box.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 129 "../src/dash-box.vala"
	g_return_if_fail (self->priv->mode == DASH_BOX_MODE_NORMAL);
#line 131 "../src/dash-box.vala"
	gtk_widget_get_preferred_height ((GtkWidget*) self, NULL, &_tmp2_);
#line 131 "../src/dash-box.vala"
	self->priv->orig_height = _tmp2_;
#line 132 "../src/dash-box.vala"
	_tmp3_ = _g_object_ref0 (l);
#line 132 "../src/dash-box.vala"
	_g_object_unref0 (self->priv->pushed);
#line 132 "../src/dash-box.vala"
	self->priv->pushed = _tmp3_;
#line 133 "../src/dash-box.vala"
	_tmp4_ = self->priv->pushed;
#line 133 "../src/dash-box.vala"
	g_signal_connect_object ((FadableBox*) _tmp4_, "fade-done", (GCallback) _dash_box_fade_done_cb_fadable_box_fade_done, self, 0);
#line 134 "../src/dash-box.vala"
	self->priv->mode = DASH_BOX_MODE_PUSH_FADE_OUT;
#line 135 "../src/dash-box.vala"
	_tmp5_ = self->priv->orig_tracker;
#line 135 "../src/dash-box.vala"
	fade_tracker_reset (_tmp5_, FADE_TRACKER_MODE_FADE_OUT);
#line 137 "../src/dash-box.vala"
	dash_box_rebuild_background (self);
#line 139 "../src/dash-box.vala"
	gtk_widget_queue_resize ((GtkWidget*) self);
#line 616 "dash-box.c"
}

void
dash_box_pop (DashBox* self)
{
	GreeterList* _tmp0_;
	GtkWidget* _tmp1_;
	GreeterList* _tmp2_;
#line 142 "../src/dash-box.vala"
	g_return_if_fail (self != NULL);
#line 144 "../src/dash-box.vala"
	_tmp0_ = self->priv->pushed;
#line 144 "../src/dash-box.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 145 "../src/dash-box.vala"
	_tmp1_ = self->priv->orig;
#line 145 "../src/dash-box.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 146 "../src/dash-box.vala"
	g_return_if_fail (self->priv->mode == DASH_BOX_MODE_NORMAL);
#line 148 "../src/dash-box.vala"
	self->priv->mode = DASH_BOX_MODE_POP_FADE_OUT;
#line 149 "../src/dash-box.vala"
	_tmp2_ = self->priv->pushed;
#line 149 "../src/dash-box.vala"
	fadable_fade_out ((Fadable*) _tmp2_);
#line 151 "../src/dash-box.vala"
	dash_box_rebuild_background (self);
#line 645 "dash-box.c"
}

static void
dash_box_fade_done_cb (DashBox* self)
{
#line 154 "../src/dash-box.vala"
	g_return_if_fail (self != NULL);
#line 156 "../src/dash-box.vala"
	switch (self->priv->mode) {
#line 156 "../src/dash-box.vala"
		case DASH_BOX_MODE_PUSH_FADE_OUT:
#line 657 "dash-box.c"
		{
			GtkWidget* _tmp0_;
			GreeterList* _tmp1_;
#line 159 "../src/dash-box.vala"
			self->priv->mode = DASH_BOX_MODE_PUSH_FADE_IN;
#line 160 "../src/dash-box.vala"
			_tmp0_ = self->priv->orig;
#line 160 "../src/dash-box.vala"
			gtk_widget_hide (_tmp0_);
#line 161 "../src/dash-box.vala"
			_tmp1_ = self->priv->pushed;
#line 161 "../src/dash-box.vala"
			fadable_fade_in ((Fadable*) _tmp1_);
#line 162 "../src/dash-box.vala"
			break;
#line 673 "dash-box.c"
		}
#line 156 "../src/dash-box.vala"
		case DASH_BOX_MODE_PUSH_FADE_IN:
#line 677 "dash-box.c"
		{
			GreeterList* _tmp2_;
#line 164 "../src/dash-box.vala"
			self->priv->mode = DASH_BOX_MODE_NORMAL;
#line 165 "../src/dash-box.vala"
			_tmp2_ = self->priv->pushed;
#line 165 "../src/dash-box.vala"
			gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
#line 167 "../src/dash-box.vala"
			dash_box_force_immediate_layout_update (self);
#line 169 "../src/dash-box.vala"
			dash_box_rebuild_background (self);
#line 170 "../src/dash-box.vala"
			break;
#line 692 "dash-box.c"
		}
#line 156 "../src/dash-box.vala"
		case DASH_BOX_MODE_POP_FADE_OUT:
#line 696 "dash-box.c"
		{
			FadeTracker* _tmp3_;
			GtkWidget* _tmp4_;
#line 172 "../src/dash-box.vala"
			self->priv->mode = DASH_BOX_MODE_POP_FADE_IN;
#line 173 "../src/dash-box.vala"
			_tmp3_ = self->priv->orig_tracker;
#line 173 "../src/dash-box.vala"
			fade_tracker_reset (_tmp3_, FADE_TRACKER_MODE_FADE_IN);
#line 174 "../src/dash-box.vala"
			_tmp4_ = self->priv->orig;
#line 174 "../src/dash-box.vala"
			gtk_widget_show (_tmp4_);
#line 175 "../src/dash-box.vala"
			break;
#line 712 "dash-box.c"
		}
#line 156 "../src/dash-box.vala"
		case DASH_BOX_MODE_POP_FADE_IN:
#line 716 "dash-box.c"
		{
			GreeterList* _tmp5_;
			guint _tmp6_;
			GreeterList* _tmp7_;
			GtkWidget* _tmp8_;
#line 177 "../src/dash-box.vala"
			self->priv->mode = DASH_BOX_MODE_NORMAL;
#line 178 "../src/dash-box.vala"
			_tmp5_ = self->priv->pushed;
#line 178 "../src/dash-box.vala"
			g_signal_parse_name ("fade-done", TYPE_FADABLE_BOX, &_tmp6_, NULL, FALSE);
#line 178 "../src/dash-box.vala"
			g_signal_handlers_disconnect_matched ((FadableBox*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _dash_box_fade_done_cb_fadable_box_fade_done, self);
#line 179 "../src/dash-box.vala"
			_tmp7_ = self->priv->pushed;
#line 179 "../src/dash-box.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp7_);
#line 180 "../src/dash-box.vala"
			_g_object_unref0 (self->priv->pushed);
#line 180 "../src/dash-box.vala"
			self->priv->pushed = NULL;
#line 181 "../src/dash-box.vala"
			gtk_widget_queue_resize ((GtkWidget*) self);
#line 182 "../src/dash-box.vala"
			_tmp8_ = self->priv->orig;
#line 182 "../src/dash-box.vala"
			gtk_widget_grab_focus (_tmp8_);
#line 183 "../src/dash-box.vala"
			dash_box_force_immediate_layout_update (self);
#line 184 "../src/dash-box.vala"
			dash_box_rebuild_background (self);
#line 185 "../src/dash-box.vala"
			break;
#line 750 "dash-box.c"
		}
		default:
#line 156 "../src/dash-box.vala"
		break;
#line 755 "dash-box.c"
	}
}

static void
dash_box_force_immediate_layout_update (DashBox* self)
{
	GtkWidget* widget = NULL;
	GtkWidget* _tmp0_;
#line 189 "../src/dash-box.vala"
	g_return_if_fail (self != NULL);
#line 192 "../src/dash-box.vala"
	gtk_widget_queue_resize ((GtkWidget*) self);
#line 193 "../src/dash-box.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 198 "../src/dash-box.vala"
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_widget_get_type ()) ? ((GtkWidget*) self) : NULL);
#line 198 "../src/dash-box.vala"
	widget = _tmp0_;
#line 199 "../src/dash-box.vala"
	while (TRUE) {
#line 776 "dash-box.c"
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		GtkContainer* _tmp5_;
		GtkWidget* _tmp6_;
#line 199 "../src/dash-box.vala"
		_tmp1_ = widget;
#line 199 "../src/dash-box.vala"
		if (!(_tmp1_ != NULL)) {
#line 199 "../src/dash-box.vala"
			break;
#line 789 "dash-box.c"
		}
#line 201 "../src/dash-box.vala"
		_tmp2_ = widget;
#line 201 "../src/dash-box.vala"
		gtk_widget_queue_resize (_tmp2_);
#line 202 "../src/dash-box.vala"
		_tmp3_ = widget;
#line 202 "../src/dash-box.vala"
		gtk_widget_queue_draw (_tmp3_);
#line 203 "../src/dash-box.vala"
		_tmp4_ = widget;
#line 203 "../src/dash-box.vala"
		_tmp5_ = gtk_widget_get_parent (_tmp4_);
#line 203 "../src/dash-box.vala"
		_tmp6_ = _g_object_ref0 ((GtkWidget*) _tmp5_);
#line 203 "../src/dash-box.vala"
		_g_object_unref0 (widget);
#line 203 "../src/dash-box.vala"
		widget = _tmp6_;
#line 809 "dash-box.c"
	}
#line 206 "../src/dash-box.vala"
	g_signal_emit (self, dash_box_signals[DASH_BOX_TRANSITION_COMPLETE_SIGNAL], 0);
#line 189 "../src/dash-box.vala"
	_g_object_unref0 (widget);
#line 815 "dash-box.c"
}

static void
dash_box_base_size_allocate_cb (DashBox* self)
{
#line 209 "../src/dash-box.vala"
	g_return_if_fail (self != NULL);
#line 211 "../src/dash-box.vala"
	gtk_widget_queue_resize ((GtkWidget*) self);
#line 825 "dash-box.c"
}

static void
dash_box_real_get_preferred_height (GtkWidget* base,
                                    gint* min,
                                    gint* nat)
{
	DashBox * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	GtkWidget* _tmp0_;
#line 214 "../src/dash-box.vala"
	self = (DashBox*) base;
#line 216 "../src/dash-box.vala"
	_tmp0_ = self->priv->orig;
#line 216 "../src/dash-box.vala"
	if (_tmp0_ == NULL) {
#line 219 "../src/dash-box.vala"
		if (self->priv->orig_height >= 0) {
#line 221 "../src/dash-box.vala"
			_vala_min = self->priv->orig_height;
#line 222 "../src/dash-box.vala"
			_vala_nat = self->priv->orig_height;
#line 849 "dash-box.c"
		} else {
#line 226 "../src/dash-box.vala"
			_vala_min = (grid_size * GREETER_LIST_DEFAULT_BOX_HEIGHT) - (GREETER_LIST_BORDER * 2);
#line 227 "../src/dash-box.vala"
			_vala_nat = (grid_size * GREETER_LIST_DEFAULT_BOX_HEIGHT) - (GREETER_LIST_BORDER * 2);
#line 855 "dash-box.c"
		}
	} else {
		GreeterList* _tmp1_;
#line 232 "../src/dash-box.vala"
		_tmp1_ = self->priv->pushed;
#line 232 "../src/dash-box.vala"
		if (_tmp1_ == NULL) {
#line 863 "dash-box.c"
			GtkWidget* _tmp2_;
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
#line 233 "../src/dash-box.vala"
			_tmp2_ = self->priv->orig;
#line 233 "../src/dash-box.vala"
			gtk_widget_get_preferred_height (_tmp2_, &_tmp3_, &_tmp4_);
#line 233 "../src/dash-box.vala"
			_vala_min = _tmp3_;
#line 233 "../src/dash-box.vala"
			_vala_nat = _tmp4_;
#line 875 "dash-box.c"
		} else {
			GreeterList* _tmp5_;
			PromptBox* _tmp6_;
			PromptBox* _tmp7_;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
#line 236 "../src/dash-box.vala"
			_tmp5_ = self->priv->pushed;
#line 236 "../src/dash-box.vala"
			_tmp6_ = greeter_list_get_selected_entry (_tmp5_);
#line 236 "../src/dash-box.vala"
			_tmp7_ = _tmp6_;
#line 236 "../src/dash-box.vala"
			gtk_widget_get_preferred_height ((GtkWidget*) _tmp7_, &_tmp8_, &_tmp9_);
#line 236 "../src/dash-box.vala"
			_vala_min = _tmp8_;
#line 236 "../src/dash-box.vala"
			_vala_nat = _tmp9_;
#line 237 "../src/dash-box.vala"
			_vala_min = MAX (self->priv->orig_height, _vala_min);
#line 238 "../src/dash-box.vala"
			_vala_nat = MAX (self->priv->orig_height, _vala_nat);
#line 898 "dash-box.c"
		}
	}
#line 214 "../src/dash-box.vala"
	if (min) {
#line 214 "../src/dash-box.vala"
		*min = _vala_min;
#line 905 "dash-box.c"
	}
#line 214 "../src/dash-box.vala"
	if (nat) {
#line 214 "../src/dash-box.vala"
		*nat = _vala_nat;
#line 911 "dash-box.c"
	}
}

static void
dash_box_real_get_preferred_width (GtkWidget* base,
                                   gint* min,
                                   gint* nat)
{
	DashBox * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
#line 243 "../src/dash-box.vala"
	self = (DashBox*) base;
#line 245 "../src/dash-box.vala"
	_vala_min = (grid_size * GREETER_LIST_BOX_WIDTH) - (GREETER_LIST_BORDER * 2);
#line 246 "../src/dash-box.vala"
	_vala_nat = (grid_size * GREETER_LIST_BOX_WIDTH) - (GREETER_LIST_BORDER * 2);
#line 243 "../src/dash-box.vala"
	if (min) {
#line 243 "../src/dash-box.vala"
		*min = _vala_min;
#line 933 "dash-box.c"
	}
#line 243 "../src/dash-box.vala"
	if (nat) {
#line 243 "../src/dash-box.vala"
		*nat = _vala_nat;
#line 939 "dash-box.c"
	}
}

static gboolean
dash_box_real_draw (GtkWidget* base,
                    cairo_t* c)
{
	DashBox * self;
	gint width = 0;
	gint height = 0;
	gdouble box_r = 0.0;
	gint box_y = 0;
	gint box_w = 0;
	gint box_h = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* _tmp26_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 249 "../src/dash-box.vala"
	self = (DashBox*) base;
#line 249 "../src/dash-box.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 251 "../src/dash-box.vala"
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 252 "../src/dash-box.vala"
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 255 "../src/dash-box.vala"
	box_r = 0.3 * grid_size;
#line 256 "../src/dash-box.vala"
	box_y = 0;
#line 259 "../src/dash-box.vala"
	gtk_widget_get_preferred_width ((GtkWidget*) self, NULL, &_tmp0_);
#line 259 "../src/dash-box.vala"
	box_w = _tmp0_;
#line 260 "../src/dash-box.vala"
	gtk_widget_get_preferred_height ((GtkWidget*) self, NULL, &_tmp1_);
#line 260 "../src/dash-box.vala"
	box_h = _tmp1_;
#line 262 "../src/dash-box.vala"
	if (self->priv->mode == DASH_BOX_MODE_PUSH_FADE_OUT) {
#line 262 "../src/dash-box.vala"
		_tmp2_ = TRUE;
#line 987 "dash-box.c"
	} else {
#line 262 "../src/dash-box.vala"
		_tmp2_ = self->priv->mode == DASH_BOX_MODE_POP_FADE_IN;
#line 991 "dash-box.c"
	}
#line 262 "../src/dash-box.vala"
	if (_tmp2_) {
#line 995 "dash-box.c"
		gint new_box_h = 0;
		gdouble _tmp3_;
#line 264 "../src/dash-box.vala"
		_tmp3_ = self->priv->_base_alpha;
#line 264 "../src/dash-box.vala"
		new_box_h = box_h - ((gint) ((box_h - self->priv->orig_height) * _tmp3_));
#line 265 "../src/dash-box.vala"
		box_h = MAX (new_box_h, 1);
#line 1004 "dash-box.c"
	}
#line 269 "../src/dash-box.vala"
	_tmp6_ = self->priv->bg_surface;
#line 269 "../src/dash-box.vala"
	if (_tmp6_ == NULL) {
#line 269 "../src/dash-box.vala"
		_tmp5_ = TRUE;
#line 1012 "dash-box.c"
	} else {
		cairo_surface_t* _tmp7_;
#line 269 "../src/dash-box.vala"
		_tmp7_ = self->priv->bg_surface;
#line 269 "../src/dash-box.vala"
		_tmp5_ = cairo_image_surface_get_width (_tmp7_) != width;
#line 1019 "dash-box.c"
	}
#line 269 "../src/dash-box.vala"
	if (_tmp5_) {
#line 269 "../src/dash-box.vala"
		_tmp4_ = TRUE;
#line 1025 "dash-box.c"
	} else {
		cairo_surface_t* _tmp8_;
#line 269 "../src/dash-box.vala"
		_tmp8_ = self->priv->bg_surface;
#line 269 "../src/dash-box.vala"
		_tmp4_ = cairo_image_surface_get_height (_tmp8_) != height;
#line 1032 "dash-box.c"
	}
#line 269 "../src/dash-box.vala"
	if (_tmp4_) {
#line 1036 "dash-box.c"
		gboolean _tmp9_ = FALSE;
#line 271 "../src/dash-box.vala"
		if (width > 0) {
#line 271 "../src/dash-box.vala"
			_tmp9_ = height > 0;
#line 1042 "dash-box.c"
		} else {
#line 271 "../src/dash-box.vala"
			_tmp9_ = FALSE;
#line 1046 "dash-box.c"
		}
#line 271 "../src/dash-box.vala"
		if (_tmp9_) {
#line 1050 "dash-box.c"
			{
				cairo_surface_t* _tmp10_;
				cairo_t* bg_cr = NULL;
				cairo_surface_t* _tmp11_;
				cairo_t* _tmp12_;
				Background* _tmp13_;
				cairo_surface_t* _tmp22_;
#line 275 "../src/dash-box.vala"
				_tmp10_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);
#line 275 "../src/dash-box.vala"
				_cairo_surface_destroy0 (self->priv->bg_surface);
#line 275 "../src/dash-box.vala"
				self->priv->bg_surface = _tmp10_;
#line 276 "../src/dash-box.vala"
				_tmp11_ = self->priv->bg_surface;
#line 276 "../src/dash-box.vala"
				_tmp12_ = cairo_create (_tmp11_);
#line 276 "../src/dash-box.vala"
				bg_cr = _tmp12_;
#line 278 "../src/dash-box.vala"
				_tmp13_ = self->priv->_background;
#line 278 "../src/dash-box.vala"
				if (_tmp13_ != NULL) {
#line 1074 "dash-box.c"
					gint x = 0;
					gint y = 0;
					Background* _tmp14_;
					gint _tmp15_ = 0;
					gint _tmp16_ = 0;
					cairo_t* _tmp17_;
					cairo_t* _tmp18_;
					Background* _tmp19_;
					cairo_t* _tmp20_;
					cairo_t* _tmp21_;
#line 281 "../src/dash-box.vala"
					_tmp14_ = self->priv->_background;
#line 281 "../src/dash-box.vala"
					gtk_widget_translate_coordinates ((GtkWidget*) _tmp14_, (GtkWidget*) self, 0, 0, &_tmp15_, &_tmp16_);
#line 281 "../src/dash-box.vala"
					x = _tmp15_;
#line 281 "../src/dash-box.vala"
					y = _tmp16_;
#line 282 "../src/dash-box.vala"
					_tmp17_ = bg_cr;
#line 282 "../src/dash-box.vala"
					cairo_save (_tmp17_);
#line 283 "../src/dash-box.vala"
					_tmp18_ = bg_cr;
#line 283 "../src/dash-box.vala"
					cairo_translate (_tmp18_, (gdouble) x, (gdouble) y);
#line 284 "../src/dash-box.vala"
					_tmp19_ = self->priv->_background;
#line 284 "../src/dash-box.vala"
					_tmp20_ = bg_cr;
#line 284 "../src/dash-box.vala"
					background_draw_full (_tmp19_, _tmp20_, BACKGROUND_DRAW_FLAGS_NONE);
#line 285 "../src/dash-box.vala"
					_tmp21_ = bg_cr;
#line 285 "../src/dash-box.vala"
					cairo_restore (_tmp21_);
#line 1111 "dash-box.c"
				}
#line 288 "../src/dash-box.vala"
				_tmp22_ = self->priv->bg_surface;
#line 288 "../src/dash-box.vala"
				cairo_utils_exponential_blur_surface (_tmp22_, DASH_BOX_BLUR_RADIUS);
#line 273 "../src/dash-box.vala"
				_cairo_destroy0 (bg_cr);
#line 1119 "dash-box.c"
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp23_;
				const gchar* _tmp24_;
#line 273 "../src/dash-box.vala"
				e = _inner_error0_;
#line 273 "../src/dash-box.vala"
				_inner_error0_ = NULL;
#line 292 "../src/dash-box.vala"
				_tmp23_ = e;
#line 292 "../src/dash-box.vala"
				_tmp24_ = _tmp23_->message;
#line 292 "../src/dash-box.vala"
				g_warning ("dash-box.vala:292: Failed to create background surface: %s", _tmp24_);
#line 293 "../src/dash-box.vala"
				_cairo_surface_destroy0 (self->priv->bg_surface);
#line 293 "../src/dash-box.vala"
				self->priv->bg_surface = NULL;
#line 273 "../src/dash-box.vala"
				_g_error_free0 (e);
#line 1143 "dash-box.c"
			}
			__finally0:
#line 273 "../src/dash-box.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1148 "dash-box.c"
				gboolean _tmp25_ = FALSE;
#line 273 "../src/dash-box.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 273 "../src/dash-box.vala"
				g_clear_error (&_inner_error0_);
#line 273 "../src/dash-box.vala"
				return _tmp25_;
#line 1156 "dash-box.c"
			}
		}
	}
#line 299 "../src/dash-box.vala"
	_tmp26_ = self->priv->bg_surface;
#line 299 "../src/dash-box.vala"
	if (_tmp26_ != NULL) {
#line 1164 "dash-box.c"
		cairo_surface_t* _tmp27_;
#line 301 "../src/dash-box.vala"
		cairo_save (c);
#line 303 "../src/dash-box.vala"
		cairo_utils_rounded_rectangle (c, (gdouble) 0, (gdouble) box_y, (gdouble) box_w, (gdouble) box_h, box_r);
#line 304 "../src/dash-box.vala"
		cairo_clip (c);
#line 306 "../src/dash-box.vala"
		_tmp27_ = self->priv->bg_surface;
#line 306 "../src/dash-box.vala"
		cairo_set_source_surface (c, _tmp27_, (gdouble) 0, (gdouble) 0);
#line 307 "../src/dash-box.vala"
		cairo_paint (c);
#line 308 "../src/dash-box.vala"
		cairo_restore (c);
#line 1180 "dash-box.c"
	}
#line 312 "../src/dash-box.vala"
	cairo_save (c);
#line 313 "../src/dash-box.vala"
	cairo_utils_rounded_rectangle (c, (gdouble) 0, (gdouble) box_y, (gdouble) box_w, (gdouble) box_h, box_r);
#line 314 "../src/dash-box.vala"
	cairo_set_source_rgba (c, 0.1, 0.1, 0.1, 0.55);
#line 315 "../src/dash-box.vala"
	cairo_fill_preserve (c);
#line 316 "../src/dash-box.vala"
	cairo_set_source_rgba (c, 0.4, 0.4, 0.4, 0.4);
#line 317 "../src/dash-box.vala"
	cairo_set_line_width (c, (gdouble) 1);
#line 318 "../src/dash-box.vala"
	cairo_stroke (c);
#line 319 "../src/dash-box.vala"
	cairo_restore (c);
#line 321 "../src/dash-box.vala"
	result = GTK_WIDGET_CLASS (dash_box_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_box_get_type (), GtkBox), c);
#line 321 "../src/dash-box.vala"
	return result;
#line 1202 "dash-box.c"
}

Background*
dash_box_get_background (DashBox* self)
{
	Background* result;
	Background* _tmp0_;
#line 22 "../src/dash-box.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 22 "../src/dash-box.vala"
	_tmp0_ = self->priv->_background;
#line 22 "../src/dash-box.vala"
	result = _tmp0_;
#line 22 "../src/dash-box.vala"
	return result;
#line 1218 "dash-box.c"
}

static void
dash_box_set_background (DashBox* self,
                         Background* value)
{
	Background* old_value;
#line 22 "../src/dash-box.vala"
	g_return_if_fail (self != NULL);
#line 22 "../src/dash-box.vala"
	old_value = dash_box_get_background (self);
#line 22 "../src/dash-box.vala"
	if (old_value != value) {
#line 1232 "dash-box.c"
		Background* _tmp0_;
#line 22 "../src/dash-box.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 22 "../src/dash-box.vala"
		_g_object_unref0 (self->priv->_background);
#line 22 "../src/dash-box.vala"
		self->priv->_background = _tmp0_;
#line 22 "../src/dash-box.vala"
		g_object_notify_by_pspec ((GObject *) self, dash_box_properties[DASH_BOX_BACKGROUND_PROPERTY]);
#line 1242 "dash-box.c"
	}
}

gboolean
dash_box_get_has_base (DashBox* self)
{
	gboolean result;
#line 24 "../src/dash-box.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 24 "../src/dash-box.vala"
	result = self->priv->_has_base;
#line 24 "../src/dash-box.vala"
	return result;
#line 1256 "dash-box.c"
}

static void
dash_box_set_has_base (DashBox* self,
                       gboolean value)
{
	gboolean old_value;
#line 24 "../src/dash-box.vala"
	g_return_if_fail (self != NULL);
#line 24 "../src/dash-box.vala"
	old_value = dash_box_get_has_base (self);
#line 24 "../src/dash-box.vala"
	if (old_value != value) {
#line 24 "../src/dash-box.vala"
		self->priv->_has_base = value;
#line 24 "../src/dash-box.vala"
		g_object_notify_by_pspec ((GObject *) self, dash_box_properties[DASH_BOX_HAS_BASE_PROPERTY]);
#line 1274 "dash-box.c"
	}
}

gdouble
dash_box_get_base_alpha (DashBox* self)
{
	gdouble result;
#line 25 "../src/dash-box.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 25 "../src/dash-box.vala"
	result = self->priv->_base_alpha;
#line 25 "../src/dash-box.vala"
	return result;
#line 1288 "dash-box.c"
}

static void
dash_box_set_base_alpha (DashBox* self,
                         gdouble value)
{
	gdouble old_value;
#line 25 "../src/dash-box.vala"
	g_return_if_fail (self != NULL);
#line 25 "../src/dash-box.vala"
	old_value = dash_box_get_base_alpha (self);
#line 25 "../src/dash-box.vala"
	if (old_value != value) {
#line 25 "../src/dash-box.vala"
		self->priv->_base_alpha = value;
#line 25 "../src/dash-box.vala"
		g_object_notify_by_pspec ((GObject *) self, dash_box_properties[DASH_BOX_BASE_ALPHA_PROPERTY]);
#line 1306 "dash-box.c"
	}
}

static void
_dash_box_rebuild_background_g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self)
{
#line 59 "../src/dash-box.vala"
	dash_box_rebuild_background ((DashBox*) self);
#line 1317 "dash-box.c"
}

static GObject *
dash_box_constructor (GType type,
                      guint n_construct_properties,
                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DashBox * self;
	Background* _tmp0_;
#line 52 "../src/dash-box.vala"
	parent_class = G_OBJECT_CLASS (dash_box_parent_class);
#line 52 "../src/dash-box.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 52 "../src/dash-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DASH_BOX, DashBox);
#line 54 "../src/dash-box.vala"
	self->priv->mode = DASH_BOX_MODE_NORMAL;
#line 57 "../src/dash-box.vala"
	_tmp0_ = self->priv->_background;
#line 57 "../src/dash-box.vala"
	if (_tmp0_ != NULL) {
#line 1341 "dash-box.c"
		Background* _tmp1_;
		Background* _tmp2_;
#line 59 "../src/dash-box.vala"
		_tmp1_ = self->priv->_background;
#line 59 "../src/dash-box.vala"
		g_signal_connect_object ((GObject*) _tmp1_, "notify::alpha", (GCallback) _dash_box_rebuild_background_g_object_notify, self, 0);
#line 60 "../src/dash-box.vala"
		_tmp2_ = self->priv->_background;
#line 60 "../src/dash-box.vala"
		g_signal_connect_object ((GObject*) _tmp2_, "notify::average-color", (GCallback) _dash_box_rebuild_background_g_object_notify, self, 0);
#line 1352 "dash-box.c"
	}
#line 52 "../src/dash-box.vala"
	return obj;
#line 1356 "dash-box.c"
}

static void
dash_box_class_init (DashBoxClass * klass,
                     gpointer klass_data)
{
#line 20 "../src/dash-box.vala"
	dash_box_parent_class = g_type_class_peek_parent (klass);
#line 20 "../src/dash-box.vala"
	g_type_class_adjust_private_offset (klass, &DashBox_private_offset);
#line 20 "../src/dash-box.vala"
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) dash_box_real_size_allocate;
#line 20 "../src/dash-box.vala"
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) dash_box_real_get_preferred_height;
#line 20 "../src/dash-box.vala"
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) dash_box_real_get_preferred_width;
#line 20 "../src/dash-box.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) dash_box_real_draw;
#line 20 "../src/dash-box.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_dash_box_get_property;
#line 20 "../src/dash-box.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_dash_box_set_property;
#line 20 "../src/dash-box.vala"
	G_OBJECT_CLASS (klass)->constructor = dash_box_constructor;
#line 20 "../src/dash-box.vala"
	G_OBJECT_CLASS (klass)->finalize = dash_box_finalize;
#line 20 "../src/dash-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DASH_BOX_BACKGROUND_PROPERTY, dash_box_properties[DASH_BOX_BACKGROUND_PROPERTY] = g_param_spec_object ("background", "background", "background", TYPE_BACKGROUND, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 20 "../src/dash-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DASH_BOX_HAS_BASE_PROPERTY, dash_box_properties[DASH_BOX_HAS_BASE_PROPERTY] = g_param_spec_boolean ("has-base", "has-base", "has-base", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 20 "../src/dash-box.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DASH_BOX_BASE_ALPHA_PROPERTY, dash_box_properties[DASH_BOX_BASE_ALPHA_PROPERTY] = g_param_spec_double ("base-alpha", "base-alpha", "base-alpha", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 20 "../src/dash-box.vala"
	dash_box_signals[DASH_BOX_TRANSITION_COMPLETE_SIGNAL] = g_signal_new ("transition-complete", TYPE_DASH_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1391 "dash-box.c"
}

static void
dash_box_instance_init (DashBox * self,
                        gpointer klass)
{
#line 20 "../src/dash-box.vala"
	self->priv = dash_box_get_instance_private (self);
#line 22 "../src/dash-box.vala"
	self->priv->_background = NULL;
#line 24 "../src/dash-box.vala"
	self->priv->_has_base = FALSE;
#line 25 "../src/dash-box.vala"
	self->priv->_base_alpha = 1.0;
#line 39 "../src/dash-box.vala"
	self->priv->orig = NULL;
#line 41 "../src/dash-box.vala"
	self->priv->orig_height = -1;
#line 44 "../src/dash-box.vala"
	self->priv->bg_surface = NULL;
#line 1412 "dash-box.c"
}

static void
dash_box_finalize (GObject * obj)
{
	DashBox * self;
#line 20 "../src/dash-box.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DASH_BOX, DashBox);
#line 22 "../src/dash-box.vala"
	_g_object_unref0 (self->priv->_background);
#line 38 "../src/dash-box.vala"
	_g_object_unref0 (self->priv->pushed);
#line 39 "../src/dash-box.vala"
	_g_object_unref0 (self->priv->orig);
#line 40 "../src/dash-box.vala"
	_g_object_unref0 (self->priv->orig_tracker);
#line 44 "../src/dash-box.vala"
	_cairo_surface_destroy0 (self->priv->bg_surface);
#line 20 "../src/dash-box.vala"
	G_OBJECT_CLASS (dash_box_parent_class)->finalize (obj);
#line 1433 "dash-box.c"
}

static GType
dash_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DashBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dash_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DashBox), 0, (GInstanceInitFunc) dash_box_instance_init, NULL };
	GType dash_box_type_id;
	dash_box_type_id = g_type_register_static (gtk_box_get_type (), "DashBox", &g_define_type_info, 0);
	DashBox_private_offset = g_type_add_instance_private (dash_box_type_id, sizeof (DashBoxPrivate));
	return dash_box_type_id;
}

GType
dash_box_get_type (void)
{
	static volatile gsize dash_box_type_id__once = 0;
	if (g_once_init_enter (&dash_box_type_id__once)) {
		GType dash_box_type_id;
		dash_box_type_id = dash_box_get_type_once ();
		g_once_init_leave (&dash_box_type_id__once, dash_box_type_id);
	}
	return dash_box_type_id__once;
}

static void
_vala_dash_box_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	DashBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DASH_BOX, DashBox);
#line 20 "../src/dash-box.vala"
	switch (property_id) {
#line 20 "../src/dash-box.vala"
		case DASH_BOX_BACKGROUND_PROPERTY:
#line 20 "../src/dash-box.vala"
		g_value_set_object (value, dash_box_get_background (self));
#line 20 "../src/dash-box.vala"
		break;
#line 20 "../src/dash-box.vala"
		case DASH_BOX_HAS_BASE_PROPERTY:
#line 20 "../src/dash-box.vala"
		g_value_set_boolean (value, dash_box_get_has_base (self));
#line 20 "../src/dash-box.vala"
		break;
#line 20 "../src/dash-box.vala"
		case DASH_BOX_BASE_ALPHA_PROPERTY:
#line 20 "../src/dash-box.vala"
		g_value_set_double (value, dash_box_get_base_alpha (self));
#line 20 "../src/dash-box.vala"
		break;
#line 1486 "dash-box.c"
		default:
#line 20 "../src/dash-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "../src/dash-box.vala"
		break;
#line 1492 "dash-box.c"
	}
}

static void
_vala_dash_box_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	DashBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DASH_BOX, DashBox);
#line 20 "../src/dash-box.vala"
	switch (property_id) {
#line 20 "../src/dash-box.vala"
		case DASH_BOX_BACKGROUND_PROPERTY:
#line 20 "../src/dash-box.vala"
		dash_box_set_background (self, g_value_get_object (value));
#line 20 "../src/dash-box.vala"
		break;
#line 20 "../src/dash-box.vala"
		case DASH_BOX_HAS_BASE_PROPERTY:
#line 20 "../src/dash-box.vala"
		dash_box_set_has_base (self, g_value_get_boolean (value));
#line 20 "../src/dash-box.vala"
		break;
#line 20 "../src/dash-box.vala"
		case DASH_BOX_BASE_ALPHA_PROPERTY:
#line 20 "../src/dash-box.vala"
		dash_box_set_base_alpha (self, g_value_get_double (value));
#line 20 "../src/dash-box.vala"
		break;
#line 1524 "dash-box.c"
		default:
#line 20 "../src/dash-box.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "../src/dash-box.vala"
		break;
#line 1530 "dash-box.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

