/* background.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from background.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011,2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Robert Ancell <robert.ancell@canonical.com>
 *          Michael Terry <michael.terry@canonical.com>
 */

#include <glib-object.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <gtk/gtk.h>
#include <gio/gio.h>

#define BACKGROUND_LOADER_QUAD_MAX_LEVEL_OF_RECURSION 16
#define BACKGROUND_LOADER_QUAD_MIN_LEVEL_OF_RECURSION 2
#define BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NW 3
#define BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NE 1
#define BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SE 1
#define BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SW 3
#define BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_CENTER 2
#define BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_TOTAL ((((BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NW + BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NE) + BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SE) + BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SW) + BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_CENTER)
#define grid_size 40
#define UG_SETTINGS_KEY_DRAW_GRID "draw-grid"
#define UG_SETTINGS_KEY_BACKGROUND_STRETCH "stretch-background-across-monitors"
#define UG_SETTINGS_KEY_LOGO "logo"
#define UG_SETTINGS_KEY_OTHER_MONITORS_LOGO "other-monitors-logo"
#define UG_SETTINGS_KEY_BACKGROUND_COLOR "background-color"
#define UG_SETTINGS_KEY_BACKGROUND "background"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BACKGROUND_LOADER (background_loader_get_type ())
#define BACKGROUND_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_LOADER, BackgroundLoader))
#define BACKGROUND_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_LOADER, BackgroundLoaderClass))
#define IS_BACKGROUND_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_LOADER))
#define IS_BACKGROUND_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_LOADER))
#define BACKGROUND_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_LOADER, BackgroundLoaderClass))

typedef struct _BackgroundLoader BackgroundLoader;
typedef struct _BackgroundLoaderClass BackgroundLoaderClass;
typedef struct _BackgroundLoaderPrivate BackgroundLoaderPrivate;
enum  {
	BACKGROUND_LOADER_0_PROPERTY,
	BACKGROUND_LOADER_FILENAME_PROPERTY,
	BACKGROUND_LOADER_LOGO_PROPERTY,
	BACKGROUND_LOADER_NUM_PROPERTIES
};
static GParamSpec* background_loader_properties[BACKGROUND_LOADER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
enum  {
	BACKGROUND_LOADER_LOADED_SIGNAL,
	BACKGROUND_LOADER_NUM_SIGNALS
};
static guint background_loader_signals[BACKGROUND_LOADER_NUM_SIGNALS] = {0};

#define TYPE_MONITOR (monitor_get_type ())
#define MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITOR, Monitor))
#define MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITOR, MonitorClass))
#define IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITOR))
#define IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITOR))
#define MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITOR, MonitorClass))

typedef struct _Monitor Monitor;
typedef struct _MonitorClass MonitorClass;
typedef struct _MonitorPrivate MonitorPrivate;
typedef struct _ParamSpecMonitor ParamSpecMonitor;

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;
typedef struct _BackgroundPrivate BackgroundPrivate;
typedef enum  {
	BACKGROUND_DRAW_FLAGS_NONE = 1 << 0,
	BACKGROUND_DRAW_FLAGS_GRID = 1 << 1,
	BACKGROUND_DRAW_FLAGS_SPAN = 1 << 2
} BackgroundDrawFlags;

#define BACKGROUND_TYPE_DRAW_FLAGS (background_draw_flags_get_type ())

#define TYPE_ANIMATE_TIMER (animate_timer_get_type ())
#define ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATE_TIMER, AnimateTimer))
#define ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATE_TIMER, AnimateTimerClass))
#define IS_ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATE_TIMER))
#define IS_ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATE_TIMER))
#define ANIMATE_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATE_TIMER, AnimateTimerClass))

typedef struct _AnimateTimer AnimateTimer;
typedef struct _AnimateTimerClass AnimateTimerClass;
enum  {
	BACKGROUND_0_PROPERTY,
	BACKGROUND_FALLBACK_COLOR_PROPERTY,
	BACKGROUND_SYSTEM_BACKGROUND_PROPERTY,
	BACKGROUND_CURRENT_BACKGROUND_PROPERTY,
	BACKGROUND_WIDTH_PROPERTY,
	BACKGROUND_HEIGHT_PROPERTY,
	BACKGROUND_ALPHA_PROPERTY,
	BACKGROUND_AVERAGE_COLOR_PROPERTY,
	BACKGROUND_NUM_PROPERTIES
};
static GParamSpec* background_properties[BACKGROUND_NUM_PROPERTIES];
#define _monitor_unref0(var) ((var == NULL) ? NULL : (var = (monitor_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef gdouble (*AnimateTimerEasingFunc) (gdouble x, gpointer user_data);

#define TYPE_DASH_BOX (dash_box_get_type ())
#define DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DASH_BOX, DashBox))
#define DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DASH_BOX, DashBoxClass))
#define IS_DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DASH_BOX))
#define IS_DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DASH_BOX))
#define DASH_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DASH_BOX, DashBoxClass))

typedef struct _DashBox DashBox;
typedef struct _DashBoxClass DashBoxClass;

#define TYPE_SLICK_GREETER (slick_greeter_get_type ())
#define SLICK_GREETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLICK_GREETER, SlickGreeter))
#define SLICK_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLICK_GREETER, SlickGreeterClass))
#define IS_SLICK_GREETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLICK_GREETER))
#define IS_SLICK_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLICK_GREETER))
#define SLICK_GREETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLICK_GREETER, SlickGreeterClass))

typedef struct _SlickGreeter SlickGreeter;
typedef struct _SlickGreeterClass SlickGreeterClass;
typedef struct _SlickGreeterPrivate SlickGreeterPrivate;

struct _BackgroundLoader {
	GObject parent_instance;
	BackgroundLoaderPrivate * priv;
	gint* widths;
	gint widths_length1;
	gint _widths_size_;
	gint* heights;
	gint heights_length1;
	gint _heights_size_;
	cairo_pattern_t** patterns;
	gint patterns_length1;
	gint _patterns_size_;
	GdkRGBA average_color;
};

struct _BackgroundLoaderClass {
	GObjectClass parent_class;
};

struct _BackgroundLoaderPrivate {
	gchar* _filename;
	cairo_surface_t* _logo;
	cairo_surface_t* target_surface;
	GThread* thread;
	GdkPixbuf** images;
	gint images_length1;
	gint _images_size_;
	gboolean finished;
	guint ready_id;
};

struct _Monitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MonitorPrivate * priv;
	gint x;
	gint y;
	gint width;
	gint height;
};

struct _MonitorClass {
	GTypeClass parent_class;
	void (*finalize) (Monitor *self);
};

struct _ParamSpecMonitor {
	GParamSpec parent_instance;
};

struct _Background {
	GtkFixed parent_instance;
	BackgroundPrivate * priv;
};

struct _BackgroundClass {
	GtkFixedClass parent_class;
};

struct _BackgroundPrivate {
	BackgroundDrawFlags flags;
	gchar* _fallback_color;
	gchar* _system_background;
	gchar* _current_background;
	gint _width;
	gint _height;
	gdouble _alpha;
	cairo_surface_t* target_surface;
	GList* monitors;
	Monitor* active_monitor;
	AnimateTimer* timer;
	BackgroundLoader* current;
	BackgroundLoader* old;
	GHashTable* loaders;
	cairo_surface_t* version_logo_surface;
	gint version_logo_width;
	gint version_logo_height;
	cairo_surface_t* other_monitors_logo_surface;
	gint other_monitors_logo_width;
	gint other_monitors_logo_height;
};

struct _SlickGreeter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SlickGreeterPrivate * priv;
	gboolean test_mode;
	gboolean orca_needs_kick;
};

struct _SlickGreeterClass {
	GTypeClass parent_class;
	void (*finalize) (SlickGreeter *self);
};

static gint BackgroundLoader_private_offset;
static gpointer background_loader_parent_class = NULL;
static gpointer monitor_parent_class = NULL;
static gint Background_private_offset;
static gpointer background_parent_class = NULL;
VALA_EXTERN SlickGreeter* slick_greeter_singleton;

VALA_EXTERN GType background_loader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackgroundLoader, g_object_unref)
VALA_EXTERN BackgroundLoader* background_loader_new (cairo_surface_t* target_surface,
                                         const gchar* filename,
                                         gint* widths,
                                         gint widths_length1,
                                         gint* heights,
                                         gint heights_length1);
VALA_EXTERN BackgroundLoader* background_loader_construct (GType object_type,
                                               cairo_surface_t* target_surface,
                                               const gchar* filename,
                                               gint* widths,
                                               gint widths_length1,
                                               gint* heights,
                                               gint heights_length1);
static void background_loader_set_filename (BackgroundLoader* self,
                                     const gchar* value);
static gint* _vala_array_dup1 (gint* self,
                        gssize length);
static gint* _vala_array_dup2 (gint* self,
                        gssize length);
VALA_EXTERN gboolean background_loader_load (BackgroundLoader* self);
VALA_EXTERN const gchar* background_loader_get_filename (BackgroundLoader* self);
static void* background_loader_load_and_scale (BackgroundLoader* self);
static gpointer _background_loader_load_and_scale_gthread_func (gpointer self);
VALA_EXTERN cairo_pattern_t* background_loader_get_pattern (BackgroundLoader* self,
                                                gint width,
                                                gint height);
static gboolean background_loader_ready_cb (BackgroundLoader* self);
static cairo_pattern_t* background_loader_create_pattern (BackgroundLoader* self,
                                                   GdkPixbuf* image);
static void background_loader_pixbuf_average_value (BackgroundLoader* self,
                                             GdkPixbuf* pixbuf,
                                             GdkRGBA* _result_);
static GdkPixbuf* background_loader_scale (BackgroundLoader* self,
                                    GdkPixbuf* image,
                                    gint width,
                                    gint height);
static gboolean _background_loader_ready_cb_gsource_func (gpointer self);
VALA_EXTERN gint get_grid_offset (gint size);
VALA_EXTERN cairo_surface_t* background_loader_get_logo (BackgroundLoader* self);
static void background_loader_get_pixbuf_sample (BackgroundLoader* self,
                                          guint8* pixels,
                                          gint pixels_length1,
                                          gint rowstride,
                                          gint channels,
                                          gint x,
                                          gint y,
                                          GdkRGBA* result);
static gboolean background_loader_is_color_different (BackgroundLoader* self,
                                               GdkRGBA* color_a,
                                               GdkRGBA* color_b);
static void background_loader_get_quad_average (BackgroundLoader* self,
                                         gint x,
                                         gint y,
                                         gint width,
                                         gint height,
                                         gint level_of_recursion,
                                         guint8* pixels,
                                         gint pixels_length1,
                                         gint rowstride,
                                         gint channels,
                                         GdkRGBA* result);
VALA_EXTERN void background_loader_set_logo (BackgroundLoader* self,
                                 cairo_surface_t* value);
static void background_loader_finalize (GObject * obj);
static GType background_loader_get_type_once (void);
static void _vala_background_loader_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_background_loader_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
VALA_EXTERN gpointer monitor_ref (gpointer instance);
VALA_EXTERN void monitor_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_monitor (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_monitor (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_monitor (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_monitor (const GValue* value);
VALA_EXTERN GType monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Monitor, monitor_unref)
VALA_EXTERN Monitor* monitor_new (gint x,
                      gint y,
                      gint width,
                      gint height);
VALA_EXTERN Monitor* monitor_construct (GType object_type,
                            gint x,
                            gint y,
                            gint width,
                            gint height);
VALA_EXTERN gboolean monitor_equals (Monitor* self,
                         Monitor* other);
static void monitor_finalize (Monitor * obj);
static GType monitor_get_type_once (void);
VALA_EXTERN GType background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Background, g_object_unref)
VALA_EXTERN GType background_draw_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType animate_timer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimateTimer, g_object_unref)
static void _monitor_unref0_ (gpointer var);
static inline void _g_list_free__monitor_unref0_ (GList* self);
VALA_EXTERN Background* background_new (void);
VALA_EXTERN Background* background_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN gboolean ug_settings_get_boolean (const gchar* key);
VALA_EXTERN void background_set_surface (Background* self,
                             cairo_surface_t* target_surface);
VALA_EXTERN gdouble animate_timer_ease_in_out (gdouble x);
static gdouble _animate_timer_ease_in_out_animate_timer_easing_func (gdouble x,
                                                              gpointer self);
VALA_EXTERN AnimateTimer* animate_timer_new (AnimateTimerEasingFunc func,
                                 gpointer func_target,
                                 gint speed);
VALA_EXTERN AnimateTimer* animate_timer_construct (GType object_type,
                                       AnimateTimerEasingFunc func,
                                       gpointer func_target,
                                       gint speed);
static BackgroundLoader* background_load_background (Background* self,
                                              const gchar* filename);
VALA_EXTERN void background_set_logo (Background* self,
                          const gchar* version_logo,
                          const gchar* other_monitors_logo);
VALA_EXTERN gchar* ug_settings_get_string (const gchar* key);
static void background_animate_cb (Background* self,
                            gdouble progress);
static void _background_animate_cb_animate_timer_animate (AnimateTimer* _sender,
                                                   gdouble progress,
                                                   gpointer self);
static cairo_surface_t* background_load_image (Background* self,
                                        const gchar* filename,
                                        gint* width,
                                        gint* height);
VALA_EXTERN void background_set_monitors (Background* self,
                              GList* monitors);
VALA_EXTERN void background_set_active_monitor (Background* self,
                                    Monitor* monitor);
VALA_EXTERN GType dash_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DashBox, g_object_unref)
VALA_EXTERN void background_connect_to_dashbox_transitions (Background* self,
                                                DashBox* dashbox);
static void background_synchronized_redraw (Background* self);
static void _background_synchronized_redraw_dash_box_transition_complete (DashBox* _sender,
                                                                   gpointer self);
static gboolean __lambda53_ (Background* self);
static gboolean ___lambda53__gsource_func (gpointer self);
static void background_real_size_allocate (GtkWidget* base,
                                    GtkAllocation* allocation);
static void background_reload (Background* self);
static gboolean background_real_draw (GtkWidget* base,
                               cairo_t* c);
VALA_EXTERN void background_draw_full (Background* self,
                           cairo_t* c,
                           BackgroundDrawFlags flags);
static void background_publish_average_color (Background* self);
VALA_EXTERN gboolean animate_timer_get_is_running (AnimateTimer* self);
static void background_set_alpha (Background* self,
                           gdouble value);
VALA_EXTERN void animate_timer_reset (AnimateTimer* self,
                          gint temp_speed);
VALA_EXTERN gdouble background_get_alpha (Background* self);
static void background_draw_background (Background* self,
                                 cairo_t* c,
                                 BackgroundLoader* background,
                                 gdouble alpha);
static void background_overlay_grid (Background* self,
                              cairo_t* c);
VALA_EXTERN const gchar* background_get_current_background (Background* self);
VALA_EXTERN void animate_timer_stop (AnimateTimer* self);
VALA_EXTERN const gchar* background_get_fallback_color (Background* self);
VALA_EXTERN const gchar* background_get_system_background (Background* self);
static gboolean background_monitor_is_unique_size (Background* self,
                                            Monitor* monitor);
static void ___lambda4_ (Background* self);
static void ____lambda4__background_loader_loaded (BackgroundLoader* _sender,
                                            gpointer self);
VALA_EXTERN gpointer slick_greeter_ref (gpointer instance);
VALA_EXTERN void slick_greeter_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_slick_greeter (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_slick_greeter (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_slick_greeter (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_slick_greeter (const GValue* value);
VALA_EXTERN GType slick_greeter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SlickGreeter, slick_greeter_unref)
VALA_EXTERN void background_set_current_background (Background* self,
                                        const gchar* value);
VALA_EXTERN gint background_get_width (Background* self);
VALA_EXTERN gint background_get_height (Background* self);
VALA_EXTERN void background_get_average_color (Background* self,
                                   GdkRGBA * result);
static void background_finalize (GObject * obj);
static GType background_get_type_once (void);
static void _vala_background_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_background_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
background_loader_get_instance_private (BackgroundLoader* self)
{
	return G_STRUCT_MEMBER_P (self, BackgroundLoader_private_offset);
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
#line 41 "../src/background.vala"
	return self ? cairo_surface_reference (self) : NULL;
#line 513 "background.c"
}

static gint*
_vala_array_dup1 (gint* self,
                  gssize length)
{
#line 43 "../src/background.vala"
	if (length > 0) {
#line 43 "../src/background.vala"
		return _vala_memdup2 (self, length * sizeof (gint));
#line 524 "background.c"
	}
#line 43 "../src/background.vala"
	return NULL;
#line 528 "background.c"
}

static gint*
_vala_array_dup2 (gint* self,
                  gssize length)
{
#line 44 "../src/background.vala"
	if (length > 0) {
#line 44 "../src/background.vala"
		return _vala_memdup2 (self, length * sizeof (gint));
#line 539 "background.c"
	}
#line 44 "../src/background.vala"
	return NULL;
#line 543 "background.c"
}

BackgroundLoader*
background_loader_construct (GType object_type,
                             cairo_surface_t* target_surface,
                             const gchar* filename,
                             gint* widths,
                             gint widths_length1,
                             gint* heights,
                             gint heights_length1)
{
	BackgroundLoader * self = NULL;
	cairo_surface_t* _tmp0_;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint* _tmp2_;
	gint _tmp2__length1;
	cairo_pattern_t** _tmp3_;
	GdkPixbuf** _tmp4_;
#line 39 "../src/background.vala"
	g_return_val_if_fail (target_surface != NULL, NULL);
#line 39 "../src/background.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 39 "../src/background.vala"
	self = (BackgroundLoader*) g_object_new (object_type, NULL);
#line 41 "../src/background.vala"
	_tmp0_ = _cairo_surface_reference0 (target_surface);
#line 41 "../src/background.vala"
	_cairo_surface_destroy0 (self->priv->target_surface);
#line 41 "../src/background.vala"
	self->priv->target_surface = _tmp0_;
#line 42 "../src/background.vala"
	background_loader_set_filename (self, filename);
#line 43 "../src/background.vala"
	_tmp1_ = (widths != NULL) ? _vala_array_dup1 (widths, widths_length1) : widths;
#line 43 "../src/background.vala"
	_tmp1__length1 = widths_length1;
#line 43 "../src/background.vala"
	self->widths = (g_free (self->widths), NULL);
#line 43 "../src/background.vala"
	self->widths = _tmp1_;
#line 43 "../src/background.vala"
	self->widths_length1 = _tmp1__length1;
#line 43 "../src/background.vala"
	self->_widths_size_ = self->widths_length1;
#line 44 "../src/background.vala"
	_tmp2_ = (heights != NULL) ? _vala_array_dup2 (heights, heights_length1) : heights;
#line 44 "../src/background.vala"
	_tmp2__length1 = heights_length1;
#line 44 "../src/background.vala"
	self->heights = (g_free (self->heights), NULL);
#line 44 "../src/background.vala"
	self->heights = _tmp2_;
#line 44 "../src/background.vala"
	self->heights_length1 = _tmp2__length1;
#line 44 "../src/background.vala"
	self->_heights_size_ = self->heights_length1;
#line 45 "../src/background.vala"
	_tmp3_ = g_new0 (cairo_pattern_t*, widths_length1 + 1);
#line 45 "../src/background.vala"
	self->patterns = (_vala_array_free (self->patterns, self->patterns_length1, (GDestroyNotify) cairo_pattern_destroy), NULL);
#line 45 "../src/background.vala"
	self->patterns = _tmp3_;
#line 45 "../src/background.vala"
	self->patterns_length1 = widths_length1;
#line 45 "../src/background.vala"
	self->_patterns_size_ = self->patterns_length1;
#line 46 "../src/background.vala"
	_tmp4_ = g_new0 (GdkPixbuf*, widths_length1 + 1);
#line 46 "../src/background.vala"
	self->priv->images = (_vala_array_free (self->priv->images, self->priv->images_length1, (GDestroyNotify) g_object_unref), NULL);
#line 46 "../src/background.vala"
	self->priv->images = _tmp4_;
#line 46 "../src/background.vala"
	self->priv->images_length1 = widths_length1;
#line 46 "../src/background.vala"
	self->priv->_images_size_ = self->priv->images_length1;
#line 39 "../src/background.vala"
	return self;
#line 623 "background.c"
}

BackgroundLoader*
background_loader_new (cairo_surface_t* target_surface,
                       const gchar* filename,
                       gint* widths,
                       gint widths_length1,
                       gint* heights,
                       gint heights_length1)
{
#line 39 "../src/background.vala"
	return background_loader_construct (TYPE_BACKGROUND_LOADER, target_surface, filename, widths, widths_length1, heights, heights_length1);
#line 636 "background.c"
}

static gpointer
_cairo_pattern_reference0 (gpointer self)
{
#line 73 "../src/background.vala"
	return self ? cairo_pattern_reference (self) : NULL;
#line 644 "background.c"
}

static gpointer
_background_loader_load_and_scale_gthread_func (gpointer self)
{
	gpointer result;
	result = background_loader_load_and_scale ((BackgroundLoader*) self);
#line 85 "../src/background.vala"
	g_object_unref (self);
#line 85 "../src/background.vala"
	return result;
#line 656 "background.c"
}

gboolean
background_loader_load (BackgroundLoader* self)
{
	GThread* _tmp0_;
	gint* _tmp1_;
	gint _tmp1__length1;
	gchar* text = NULL;
	const gchar* _tmp2_;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gint* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp19_;
	GdkRGBA color = {0};
	const gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 49 "../src/background.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 52 "../src/background.vala"
	if (self->priv->finished) {
#line 53 "../src/background.vala"
		result = TRUE;
#line 53 "../src/background.vala"
		return result;
#line 687 "background.c"
	}
#line 56 "../src/background.vala"
	_tmp0_ = self->priv->thread;
#line 56 "../src/background.vala"
	if (_tmp0_ != NULL) {
#line 57 "../src/background.vala"
		result = FALSE;
#line 57 "../src/background.vala"
		return result;
#line 697 "background.c"
	}
#line 60 "../src/background.vala"
	_tmp1_ = self->widths;
#line 60 "../src/background.vala"
	_tmp1__length1 = self->widths_length1;
#line 60 "../src/background.vala"
	if (_tmp1__length1 == 0) {
#line 61 "../src/background.vala"
		result = FALSE;
#line 61 "../src/background.vala"
		return result;
#line 709 "background.c"
	}
#line 63 "../src/background.vala"
	_tmp2_ = self->priv->_filename;
#line 63 "../src/background.vala"
	_tmp3_ = self->widths;
#line 63 "../src/background.vala"
	_tmp3__length1 = self->widths_length1;
#line 63 "../src/background.vala"
	_tmp4_ = _tmp3_[0];
#line 63 "../src/background.vala"
	_tmp5_ = self->heights;
#line 63 "../src/background.vala"
	_tmp5__length1 = self->heights_length1;
#line 63 "../src/background.vala"
	_tmp6_ = _tmp5_[0];
#line 63 "../src/background.vala"
	_tmp7_ = g_strdup_printf ("Making background %s at %dx%d", _tmp2_, _tmp4_, _tmp6_);
#line 63 "../src/background.vala"
	text = _tmp7_;
#line 729 "background.c"
	{
		gint i = 0;
#line 64 "../src/background.vala"
		i = 1;
#line 734 "background.c"
		{
			gboolean _tmp8_ = FALSE;
#line 64 "../src/background.vala"
			_tmp8_ = TRUE;
#line 64 "../src/background.vala"
			while (TRUE) {
#line 741 "background.c"
				gint* _tmp10_;
				gint _tmp10__length1;
				const gchar* _tmp11_;
				gint* _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				gint* _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
#line 64 "../src/background.vala"
				if (!_tmp8_) {
#line 756 "background.c"
					gint _tmp9_;
#line 64 "../src/background.vala"
					_tmp9_ = i;
#line 64 "../src/background.vala"
					i = _tmp9_ + 1;
#line 762 "background.c"
				}
#line 64 "../src/background.vala"
				_tmp8_ = FALSE;
#line 64 "../src/background.vala"
				_tmp10_ = self->widths;
#line 64 "../src/background.vala"
				_tmp10__length1 = self->widths_length1;
#line 64 "../src/background.vala"
				if (!(i < _tmp10__length1)) {
#line 64 "../src/background.vala"
					break;
#line 774 "background.c"
				}
#line 65 "../src/background.vala"
				_tmp11_ = text;
#line 65 "../src/background.vala"
				_tmp12_ = self->widths;
#line 65 "../src/background.vala"
				_tmp12__length1 = self->widths_length1;
#line 65 "../src/background.vala"
				_tmp13_ = _tmp12_[i];
#line 65 "../src/background.vala"
				_tmp14_ = self->heights;
#line 65 "../src/background.vala"
				_tmp14__length1 = self->heights_length1;
#line 65 "../src/background.vala"
				_tmp15_ = _tmp14_[i];
#line 65 "../src/background.vala"
				_tmp16_ = g_strdup_printf (",%dx%d", _tmp13_, _tmp15_);
#line 65 "../src/background.vala"
				_tmp17_ = _tmp16_;
#line 65 "../src/background.vala"
				_tmp18_ = g_strconcat (_tmp11_, _tmp17_, NULL);
#line 65 "../src/background.vala"
				_g_free0 (text);
#line 65 "../src/background.vala"
				text = _tmp18_;
#line 65 "../src/background.vala"
				_g_free0 (_tmp17_);
#line 802 "background.c"
			}
		}
	}
#line 66 "../src/background.vala"
	_tmp19_ = text;
#line 66 "../src/background.vala"
	g_debug ("background.vala:66: %s", _tmp19_);
#line 68 "../src/background.vala"
	memset (&color, 0, sizeof (GdkRGBA));
#line 69 "../src/background.vala"
	_tmp20_ = self->priv->_filename;
#line 69 "../src/background.vala"
	if (gdk_rgba_parse (&color, _tmp20_)) {
#line 816 "background.c"
		cairo_pattern_t* pattern = NULL;
		GdkRGBA _tmp21_;
		GdkRGBA _tmp22_;
		GdkRGBA _tmp23_;
		GdkRGBA _tmp24_;
		cairo_pattern_t* _tmp25_;
		GdkRGBA _tmp32_;
		const gchar* _tmp33_;
#line 71 "../src/background.vala"
		_tmp21_ = color;
#line 71 "../src/background.vala"
		_tmp22_ = color;
#line 71 "../src/background.vala"
		_tmp23_ = color;
#line 71 "../src/background.vala"
		_tmp24_ = color;
#line 71 "../src/background.vala"
		_tmp25_ = cairo_pattern_create_rgba (_tmp21_.red, _tmp22_.green, _tmp23_.blue, _tmp24_.alpha);
#line 71 "../src/background.vala"
		pattern = _tmp25_;
#line 837 "background.c"
		{
			gint i = 0;
#line 72 "../src/background.vala"
			i = 0;
#line 842 "background.c"
			{
				gboolean _tmp26_ = FALSE;
#line 72 "../src/background.vala"
				_tmp26_ = TRUE;
#line 72 "../src/background.vala"
				while (TRUE) {
#line 849 "background.c"
					gint* _tmp28_;
					gint _tmp28__length1;
					cairo_pattern_t** _tmp29_;
					gint _tmp29__length1;
					cairo_pattern_t* _tmp30_;
					cairo_pattern_t* _tmp31_;
#line 72 "../src/background.vala"
					if (!_tmp26_) {
#line 858 "background.c"
						gint _tmp27_;
#line 72 "../src/background.vala"
						_tmp27_ = i;
#line 72 "../src/background.vala"
						i = _tmp27_ + 1;
#line 864 "background.c"
					}
#line 72 "../src/background.vala"
					_tmp26_ = FALSE;
#line 72 "../src/background.vala"
					_tmp28_ = self->widths;
#line 72 "../src/background.vala"
					_tmp28__length1 = self->widths_length1;
#line 72 "../src/background.vala"
					if (!(i < _tmp28__length1)) {
#line 72 "../src/background.vala"
						break;
#line 876 "background.c"
					}
#line 73 "../src/background.vala"
					_tmp29_ = self->patterns;
#line 73 "../src/background.vala"
					_tmp29__length1 = self->patterns_length1;
#line 73 "../src/background.vala"
					_tmp30_ = pattern;
#line 73 "../src/background.vala"
					_tmp31_ = _cairo_pattern_reference0 (_tmp30_);
#line 73 "../src/background.vala"
					_cairo_pattern_destroy0 (_tmp29_[i]);
#line 73 "../src/background.vala"
					_tmp29_[i] = _tmp31_;
#line 890 "background.c"
				}
			}
		}
#line 75 "../src/background.vala"
		_tmp32_ = color;
#line 75 "../src/background.vala"
		self->average_color = _tmp32_;
#line 76 "../src/background.vala"
		self->priv->finished = TRUE;
#line 77 "../src/background.vala"
		_tmp33_ = self->priv->_filename;
#line 77 "../src/background.vala"
		g_debug ("background.vala:77: Render of background %s complete", _tmp33_);
#line 78 "../src/background.vala"
		result = TRUE;
#line 78 "../src/background.vala"
		_cairo_pattern_destroy0 (pattern);
#line 78 "../src/background.vala"
		_g_free0 (text);
#line 78 "../src/background.vala"
		return result;
#line 912 "background.c"
	} else {
		{
			GThread* _tmp34_ = NULL;
			GThread* _tmp35_;
			GThread* _tmp36_;
#line 84 "../src/background.vala"
			g_object_ref ((GObject*) self);
#line 85 "../src/background.vala"
			_tmp35_ = g_thread_try_new ("background-loader", _background_loader_load_and_scale_gthread_func, g_object_ref (self), &_inner_error0_);
#line 85 "../src/background.vala"
			_tmp34_ = _tmp35_;
#line 85 "../src/background.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 926 "background.c"
				goto __catch0_g_error;
			}
#line 85 "../src/background.vala"
			_tmp36_ = _tmp34_;
#line 85 "../src/background.vala"
			_tmp34_ = NULL;
#line 85 "../src/background.vala"
			_g_thread_unref0 (self->priv->thread);
#line 85 "../src/background.vala"
			self->priv->thread = _tmp36_;
#line 82 "../src/background.vala"
			_g_thread_unref0 (_tmp34_);
#line 939 "background.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
#line 82 "../src/background.vala"
			g_clear_error (&_inner_error0_);
#line 89 "../src/background.vala"
			g_object_unref ((GObject*) self);
#line 90 "../src/background.vala"
			self->priv->finished = TRUE;
#line 91 "../src/background.vala"
			result = TRUE;
#line 91 "../src/background.vala"
			_g_free0 (text);
#line 91 "../src/background.vala"
			return result;
#line 956 "background.c"
		}
		__finally0:
#line 82 "../src/background.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 961 "background.c"
			gboolean _tmp37_ = FALSE;
#line 82 "../src/background.vala"
			_g_free0 (text);
#line 82 "../src/background.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 82 "../src/background.vala"
			g_clear_error (&_inner_error0_);
#line 82 "../src/background.vala"
			return _tmp37_;
#line 971 "background.c"
		}
	}
#line 95 "../src/background.vala"
	result = FALSE;
#line 95 "../src/background.vala"
	_g_free0 (text);
#line 95 "../src/background.vala"
	return result;
#line 980 "background.c"
}

cairo_pattern_t*
background_loader_get_pattern (BackgroundLoader* self,
                               gint width,
                               gint height)
{
	cairo_pattern_t* result;
#line 98 "../src/background.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 991 "background.c"
	{
		gint i = 0;
#line 100 "../src/background.vala"
		i = 0;
#line 996 "background.c"
		{
			gboolean _tmp0_ = FALSE;
#line 100 "../src/background.vala"
			_tmp0_ = TRUE;
#line 100 "../src/background.vala"
			while (TRUE) {
#line 1003 "background.c"
				gint* _tmp2_;
				gint _tmp2__length1;
				gboolean _tmp3_ = FALSE;
				gint* _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
#line 100 "../src/background.vala"
				if (!_tmp0_) {
#line 1012 "background.c"
					gint _tmp1_;
#line 100 "../src/background.vala"
					_tmp1_ = i;
#line 100 "../src/background.vala"
					i = _tmp1_ + 1;
#line 1018 "background.c"
				}
#line 100 "../src/background.vala"
				_tmp0_ = FALSE;
#line 100 "../src/background.vala"
				_tmp2_ = self->widths;
#line 100 "../src/background.vala"
				_tmp2__length1 = self->widths_length1;
#line 100 "../src/background.vala"
				if (!(i < _tmp2__length1)) {
#line 100 "../src/background.vala"
					break;
#line 1030 "background.c"
				}
#line 102 "../src/background.vala"
				_tmp4_ = self->widths;
#line 102 "../src/background.vala"
				_tmp4__length1 = self->widths_length1;
#line 102 "../src/background.vala"
				_tmp5_ = _tmp4_[i];
#line 102 "../src/background.vala"
				if (_tmp5_ == width) {
#line 1040 "background.c"
					gint* _tmp6_;
					gint _tmp6__length1;
					gint _tmp7_;
#line 102 "../src/background.vala"
					_tmp6_ = self->heights;
#line 102 "../src/background.vala"
					_tmp6__length1 = self->heights_length1;
#line 102 "../src/background.vala"
					_tmp7_ = _tmp6_[i];
#line 102 "../src/background.vala"
					_tmp3_ = _tmp7_ == height;
#line 1052 "background.c"
				} else {
#line 102 "../src/background.vala"
					_tmp3_ = FALSE;
#line 1056 "background.c"
				}
#line 102 "../src/background.vala"
				if (_tmp3_) {
#line 1060 "background.c"
					cairo_pattern_t** _tmp8_;
					gint _tmp8__length1;
					cairo_pattern_t* _tmp9_;
					cairo_pattern_t* _tmp10_;
#line 103 "../src/background.vala"
					_tmp8_ = self->patterns;
#line 103 "../src/background.vala"
					_tmp8__length1 = self->patterns_length1;
#line 103 "../src/background.vala"
					_tmp9_ = _tmp8_[i];
#line 103 "../src/background.vala"
					_tmp10_ = _cairo_pattern_reference0 (_tmp9_);
#line 103 "../src/background.vala"
					result = _tmp10_;
#line 103 "../src/background.vala"
					return result;
#line 1077 "background.c"
				}
			}
		}
	}
#line 105 "../src/background.vala"
	result = NULL;
#line 105 "../src/background.vala"
	return result;
#line 1086 "background.c"
}

static gboolean
background_loader_ready_cb (BackgroundLoader* self)
{
	const gchar* _tmp0_;
	GThread* _tmp1_;
	gboolean result;
#line 115 "../src/background.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 117 "../src/background.vala"
	self->priv->ready_id = (guint) 0;
#line 119 "../src/background.vala"
	_tmp0_ = self->priv->_filename;
#line 119 "../src/background.vala"
	g_debug ("background.vala:119: Render of background %s complete", _tmp0_);
#line 121 "../src/background.vala"
	_tmp1_ = self->priv->thread;
#line 121 "../src/background.vala"
	self->priv->thread = NULL;
#line 121 "../src/background.vala"
	g_thread_join (_tmp1_);
#line 122 "../src/background.vala"
	_g_thread_unref0 (self->priv->thread);
#line 122 "../src/background.vala"
	self->priv->thread = NULL;
#line 123 "../src/background.vala"
	self->priv->finished = TRUE;
#line 1115 "background.c"
	{
		gint i = 0;
#line 125 "../src/background.vala"
		i = 0;
#line 1120 "background.c"
		{
			gboolean _tmp2_ = FALSE;
#line 125 "../src/background.vala"
			_tmp2_ = TRUE;
#line 125 "../src/background.vala"
			while (TRUE) {
#line 1127 "background.c"
				gint* _tmp4_;
				gint _tmp4__length1;
				GdkPixbuf** _tmp5_;
				gint _tmp5__length1;
				GdkPixbuf* _tmp6_;
#line 125 "../src/background.vala"
				if (!_tmp2_) {
#line 1135 "background.c"
					gint _tmp3_;
#line 125 "../src/background.vala"
					_tmp3_ = i;
#line 125 "../src/background.vala"
					i = _tmp3_ + 1;
#line 1141 "background.c"
				}
#line 125 "../src/background.vala"
				_tmp2_ = FALSE;
#line 125 "../src/background.vala"
				_tmp4_ = self->widths;
#line 125 "../src/background.vala"
				_tmp4__length1 = self->widths_length1;
#line 125 "../src/background.vala"
				if (!(i < _tmp4__length1)) {
#line 125 "../src/background.vala"
					break;
#line 1153 "background.c"
				}
#line 127 "../src/background.vala"
				_tmp5_ = self->priv->images;
#line 127 "../src/background.vala"
				_tmp5__length1 = self->priv->images_length1;
#line 127 "../src/background.vala"
				_tmp6_ = _tmp5_[i];
#line 127 "../src/background.vala"
				if (_tmp6_ != NULL) {
#line 1163 "background.c"
					cairo_pattern_t** _tmp7_;
					gint _tmp7__length1;
					GdkPixbuf** _tmp8_;
					gint _tmp8__length1;
					GdkPixbuf* _tmp9_;
					cairo_pattern_t* _tmp10_;
					GdkPixbuf** _tmp14_;
					gint _tmp14__length1;
#line 129 "../src/background.vala"
					_tmp7_ = self->patterns;
#line 129 "../src/background.vala"
					_tmp7__length1 = self->patterns_length1;
#line 129 "../src/background.vala"
					_tmp8_ = self->priv->images;
#line 129 "../src/background.vala"
					_tmp8__length1 = self->priv->images_length1;
#line 129 "../src/background.vala"
					_tmp9_ = _tmp8_[i];
#line 129 "../src/background.vala"
					_tmp10_ = background_loader_create_pattern (self, _tmp9_);
#line 129 "../src/background.vala"
					_cairo_pattern_destroy0 (_tmp7_[i]);
#line 129 "../src/background.vala"
					_tmp7_[i] = _tmp10_;
#line 130 "../src/background.vala"
					if (i == 0) {
#line 1190 "background.c"
						GdkPixbuf** _tmp11_;
						gint _tmp11__length1;
						GdkPixbuf* _tmp12_;
						GdkRGBA _tmp13_ = {0};
#line 131 "../src/background.vala"
						_tmp11_ = self->priv->images;
#line 131 "../src/background.vala"
						_tmp11__length1 = self->priv->images_length1;
#line 131 "../src/background.vala"
						_tmp12_ = _tmp11_[i];
#line 131 "../src/background.vala"
						background_loader_pixbuf_average_value (self, _tmp12_, &_tmp13_);
#line 131 "../src/background.vala"
						self->average_color = _tmp13_;
#line 1205 "background.c"
					}
#line 132 "../src/background.vala"
					_tmp14_ = self->priv->images;
#line 132 "../src/background.vala"
					_tmp14__length1 = self->priv->images_length1;
#line 132 "../src/background.vala"
					_g_object_unref0 (_tmp14_[i]);
#line 132 "../src/background.vala"
					_tmp14_[i] = NULL;
#line 1215 "background.c"
				} else {
					const gchar* _tmp15_;
					cairo_pattern_t** _tmp16_;
					gint _tmp16__length1;
#line 136 "../src/background.vala"
					_tmp15_ = self->priv->_filename;
#line 136 "../src/background.vala"
					g_debug ("background.vala:136: images[%d] was null for %s", i, _tmp15_);
#line 137 "../src/background.vala"
					_tmp16_ = self->patterns;
#line 137 "../src/background.vala"
					_tmp16__length1 = self->patterns_length1;
#line 137 "../src/background.vala"
					_cairo_pattern_destroy0 (_tmp16_[i]);
#line 137 "../src/background.vala"
					_tmp16_[i] = NULL;
#line 1232 "background.c"
				}
			}
		}
	}
#line 141 "../src/background.vala"
	g_signal_emit (self, background_loader_signals[BACKGROUND_LOADER_LOADED_SIGNAL], 0);
#line 143 "../src/background.vala"
	g_object_unref ((GObject*) self);
#line 144 "../src/background.vala"
	result = FALSE;
#line 144 "../src/background.vala"
	return result;
#line 1245 "background.c"
}

static gboolean
_background_loader_ready_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = background_loader_ready_cb ((BackgroundLoader*) self);
#line 160 "../src/background.vala"
	return result;
#line 1255 "background.c"
}

static void*
background_loader_load_and_scale (BackgroundLoader* self)
{
	GError* _inner_error0_ = NULL;
	void* result;
#line 147 "../src/background.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1265 "background.c"
	{
		GdkPixbuf* image = NULL;
		const gchar* _tmp0_;
		GdkPixbuf* _tmp1_;
#line 151 "../src/background.vala"
		_tmp0_ = self->priv->_filename;
#line 151 "../src/background.vala"
		_tmp1_ = gdk_pixbuf_new_from_file (_tmp0_, &_inner_error0_);
#line 151 "../src/background.vala"
		image = _tmp1_;
#line 151 "../src/background.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1278 "background.c"
			goto __catch0_g_error;
		}
		{
			gint i = 0;
#line 152 "../src/background.vala"
			i = 0;
#line 1285 "background.c"
			{
				gboolean _tmp2_ = FALSE;
#line 152 "../src/background.vala"
				_tmp2_ = TRUE;
#line 152 "../src/background.vala"
				while (TRUE) {
#line 1292 "background.c"
					gint* _tmp4_;
					gint _tmp4__length1;
					GdkPixbuf** _tmp5_;
					gint _tmp5__length1;
					GdkPixbuf* _tmp6_;
					gint* _tmp7_;
					gint _tmp7__length1;
					gint _tmp8_;
					gint* _tmp9_;
					gint _tmp9__length1;
					gint _tmp10_;
					GdkPixbuf* _tmp11_;
#line 152 "../src/background.vala"
					if (!_tmp2_) {
#line 1307 "background.c"
						gint _tmp3_;
#line 152 "../src/background.vala"
						_tmp3_ = i;
#line 152 "../src/background.vala"
						i = _tmp3_ + 1;
#line 1313 "background.c"
					}
#line 152 "../src/background.vala"
					_tmp2_ = FALSE;
#line 152 "../src/background.vala"
					_tmp4_ = self->widths;
#line 152 "../src/background.vala"
					_tmp4__length1 = self->widths_length1;
#line 152 "../src/background.vala"
					if (!(i < _tmp4__length1)) {
#line 152 "../src/background.vala"
						break;
#line 1325 "background.c"
					}
#line 153 "../src/background.vala"
					_tmp5_ = self->priv->images;
#line 153 "../src/background.vala"
					_tmp5__length1 = self->priv->images_length1;
#line 153 "../src/background.vala"
					_tmp6_ = image;
#line 153 "../src/background.vala"
					_tmp7_ = self->widths;
#line 153 "../src/background.vala"
					_tmp7__length1 = self->widths_length1;
#line 153 "../src/background.vala"
					_tmp8_ = _tmp7_[i];
#line 153 "../src/background.vala"
					_tmp9_ = self->heights;
#line 153 "../src/background.vala"
					_tmp9__length1 = self->heights_length1;
#line 153 "../src/background.vala"
					_tmp10_ = _tmp9_[i];
#line 153 "../src/background.vala"
					_tmp11_ = background_loader_scale (self, _tmp6_, _tmp8_, _tmp10_);
#line 153 "../src/background.vala"
					_g_object_unref0 (_tmp5_[i]);
#line 153 "../src/background.vala"
					_tmp5_[i] = _tmp11_;
#line 1351 "background.c"
				}
			}
		}
#line 149 "../src/background.vala"
		_g_object_unref0 (image);
#line 1357 "background.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
#line 149 "../src/background.vala"
		e = _inner_error0_;
#line 149 "../src/background.vala"
		_inner_error0_ = NULL;
#line 157 "../src/background.vala"
		_tmp12_ = e;
#line 157 "../src/background.vala"
		_tmp13_ = _tmp12_->message;
#line 157 "../src/background.vala"
		g_debug ("background.vala:157: Error loading background: %s", _tmp13_);
#line 149 "../src/background.vala"
		_g_error_free0 (e);
#line 1377 "background.c"
	}
	__finally0:
#line 149 "../src/background.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 149 "../src/background.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 149 "../src/background.vala"
		g_clear_error (&_inner_error0_);
#line 149 "../src/background.vala"
		return NULL;
#line 1388 "background.c"
	}
#line 160 "../src/background.vala"
	self->priv->ready_id = gdk_threads_add_idle (_background_loader_ready_cb_gsource_func, self);
#line 162 "../src/background.vala"
	result = NULL;
#line 162 "../src/background.vala"
	return result;
#line 1396 "background.c"
}

static GdkPixbuf*
background_loader_scale (BackgroundLoader* self,
                         GdkPixbuf* image,
                         gint width,
                         gint height)
{
	gdouble target_aspect = 0.0;
	gdouble aspect = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gdouble scale = 0.0;
	gdouble offset_x = 0.0;
	gdouble offset_y = 0.0;
	GdkPixbuf* scaled_image = NULL;
	GdkColorspace _tmp12_;
	GdkColorspace _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GdkPixbuf* _tmp18_;
	GdkPixbuf* result;
#line 165 "../src/background.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 167 "../src/background.vala"
	target_aspect = ((gdouble) width) / height;
#line 168 "../src/background.vala"
	_tmp0_ = gdk_pixbuf_get_width (image);
#line 168 "../src/background.vala"
	_tmp1_ = _tmp0_;
#line 168 "../src/background.vala"
	_tmp2_ = gdk_pixbuf_get_height (image);
#line 168 "../src/background.vala"
	_tmp3_ = _tmp2_;
#line 168 "../src/background.vala"
	aspect = ((gdouble) _tmp1_) / _tmp3_;
#line 169 "../src/background.vala"
	offset_x = (gdouble) 0;
#line 169 "../src/background.vala"
	offset_y = (gdouble) 0;
#line 170 "../src/background.vala"
	if (aspect > target_aspect) {
#line 1443 "background.c"
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
#line 173 "../src/background.vala"
		_tmp4_ = gdk_pixbuf_get_height (image);
#line 173 "../src/background.vala"
		_tmp5_ = _tmp4_;
#line 173 "../src/background.vala"
		scale = ((gdouble) height) / _tmp5_;
#line 174 "../src/background.vala"
		_tmp6_ = gdk_pixbuf_get_width (image);
#line 174 "../src/background.vala"
		_tmp7_ = _tmp6_;
#line 174 "../src/background.vala"
		offset_x = ((_tmp7_ * scale) - width) / 2;
#line 1460 "background.c"
	} else {
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
#line 179 "../src/background.vala"
		_tmp8_ = gdk_pixbuf_get_width (image);
#line 179 "../src/background.vala"
		_tmp9_ = _tmp8_;
#line 179 "../src/background.vala"
		scale = ((gdouble) width) / _tmp9_;
#line 180 "../src/background.vala"
		_tmp10_ = gdk_pixbuf_get_height (image);
#line 180 "../src/background.vala"
		_tmp11_ = _tmp10_;
#line 180 "../src/background.vala"
		offset_y = ((_tmp11_ * scale) - height) / 2;
#line 1478 "background.c"
	}
#line 183 "../src/background.vala"
	_tmp12_ = gdk_pixbuf_get_colorspace (image);
#line 183 "../src/background.vala"
	_tmp13_ = _tmp12_;
#line 183 "../src/background.vala"
	_tmp14_ = gdk_pixbuf_get_has_alpha (image);
#line 183 "../src/background.vala"
	_tmp15_ = _tmp14_;
#line 183 "../src/background.vala"
	_tmp16_ = gdk_pixbuf_get_bits_per_sample (image);
#line 183 "../src/background.vala"
	_tmp17_ = _tmp16_;
#line 183 "../src/background.vala"
	_tmp18_ = gdk_pixbuf_new (_tmp13_, _tmp15_, _tmp17_, width, height);
#line 183 "../src/background.vala"
	scaled_image = _tmp18_;
#line 184 "../src/background.vala"
	gdk_pixbuf_scale (image, scaled_image, 0, 0, width, height, -offset_x, -offset_y, scale, scale, GDK_INTERP_BILINEAR);
#line 186 "../src/background.vala"
	result = scaled_image;
#line 186 "../src/background.vala"
	return result;
#line 1502 "background.c"
}

static cairo_pattern_t*
background_loader_create_pattern (BackgroundLoader* self,
                                  GdkPixbuf* image)
{
	gint grid_x_offset = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint grid_y_offset = 0;
	gint _tmp2_;
	gint _tmp3_;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	cairo_surface_t* _tmp9_;
	cairo_t* bc = NULL;
	cairo_surface_t* _tmp10_;
	cairo_t* _tmp11_;
	cairo_t* _tmp12_;
	cairo_t* _tmp13_;
	cairo_surface_t* _tmp14_;
	cairo_pattern_t* pattern = NULL;
	cairo_surface_t* _tmp23_;
	cairo_pattern_t* _tmp24_;
	cairo_pattern_t* result;
#line 189 "../src/background.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 189 "../src/background.vala"
	g_return_val_if_fail (image != NULL, NULL);
#line 191 "../src/background.vala"
	_tmp0_ = gdk_pixbuf_get_width (image);
#line 191 "../src/background.vala"
	_tmp1_ = _tmp0_;
#line 191 "../src/background.vala"
	grid_x_offset = get_grid_offset (_tmp1_);
#line 192 "../src/background.vala"
	_tmp2_ = gdk_pixbuf_get_height (image);
#line 192 "../src/background.vala"
	_tmp3_ = _tmp2_;
#line 192 "../src/background.vala"
	grid_y_offset = get_grid_offset (_tmp3_);
#line 195 "../src/background.vala"
	_tmp4_ = self->priv->target_surface;
#line 195 "../src/background.vala"
	_tmp5_ = gdk_pixbuf_get_width (image);
#line 195 "../src/background.vala"
	_tmp6_ = _tmp5_;
#line 195 "../src/background.vala"
	_tmp7_ = gdk_pixbuf_get_height (image);
#line 195 "../src/background.vala"
	_tmp8_ = _tmp7_;
#line 195 "../src/background.vala"
	_tmp9_ = cairo_surface_create_similar (_tmp4_, CAIRO_CONTENT_COLOR, _tmp6_, _tmp8_);
#line 195 "../src/background.vala"
	surface = _tmp9_;
#line 196 "../src/background.vala"
	_tmp10_ = surface;
#line 196 "../src/background.vala"
	_tmp11_ = cairo_create (_tmp10_);
#line 196 "../src/background.vala"
	bc = _tmp11_;
#line 197 "../src/background.vala"
	_tmp12_ = bc;
#line 197 "../src/background.vala"
	gdk_cairo_set_source_pixbuf (_tmp12_, image, (gdouble) 0, (gdouble) 0);
#line 199 "../src/background.vala"
	_tmp13_ = bc;
#line 199 "../src/background.vala"
	cairo_paint (_tmp13_);
#line 202 "../src/background.vala"
	_tmp14_ = self->priv->_logo;
#line 202 "../src/background.vala"
	if (_tmp14_ != NULL) {
#line 1580 "background.c"
		cairo_t* _tmp15_;
		gint y = 0;
		gint _tmp16_;
		gint _tmp17_;
		cairo_t* _tmp18_;
		cairo_t* _tmp19_;
		cairo_surface_t* _tmp20_;
		cairo_t* _tmp21_;
		cairo_t* _tmp22_;
#line 204 "../src/background.vala"
		_tmp15_ = bc;
#line 204 "../src/background.vala"
		cairo_save (_tmp15_);
#line 205 "../src/background.vala"
		_tmp16_ = gdk_pixbuf_get_height (image);
#line 205 "../src/background.vala"
		_tmp17_ = _tmp16_;
#line 205 "../src/background.vala"
		y = (((gint) ((_tmp17_ / grid_size) - 2)) * grid_size) + grid_y_offset;
#line 206 "../src/background.vala"
		_tmp18_ = bc;
#line 206 "../src/background.vala"
		cairo_translate (_tmp18_, (gdouble) grid_x_offset, (gdouble) y);
#line 207 "../src/background.vala"
		_tmp19_ = bc;
#line 207 "../src/background.vala"
		_tmp20_ = self->priv->_logo;
#line 207 "../src/background.vala"
		cairo_set_source_surface (_tmp19_, _tmp20_, (gdouble) 0, (gdouble) 0);
#line 208 "../src/background.vala"
		_tmp21_ = bc;
#line 208 "../src/background.vala"
		cairo_paint_with_alpha (_tmp21_, 1.0);
#line 209 "../src/background.vala"
		_tmp22_ = bc;
#line 209 "../src/background.vala"
		cairo_restore (_tmp22_);
#line 1618 "background.c"
	}
#line 212 "../src/background.vala"
	_tmp23_ = surface;
#line 212 "../src/background.vala"
	_tmp24_ = cairo_pattern_create_for_surface (_tmp23_);
#line 212 "../src/background.vala"
	pattern = _tmp24_;
#line 213 "../src/background.vala"
	cairo_pattern_set_extend (pattern, CAIRO_EXTEND_REPEAT);
#line 215 "../src/background.vala"
	result = pattern;
#line 215 "../src/background.vala"
	_cairo_destroy0 (bc);
#line 215 "../src/background.vala"
	_cairo_surface_destroy0 (surface);
#line 215 "../src/background.vala"
	return result;
#line 1636 "background.c"
}

static void
background_loader_get_pixbuf_sample (BackgroundLoader* self,
                                     guint8* pixels,
                                     gint pixels_length1,
                                     gint rowstride,
                                     gint channels,
                                     gint x,
                                     gint y,
                                     GdkRGBA* result)
{
	GdkRGBA sample = {0};
	gdouble dd = 0.0;
	gint offset = 0;
	gint _tmp0_;
	guint8 _tmp1_;
	gdouble _tmp2_;
	gint _tmp3_;
	guint8 _tmp4_;
	gdouble _tmp5_;
	gint _tmp6_;
	guint8 _tmp7_;
	gdouble _tmp8_;
#line 234 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 240 "../src/background.vala"
	memset (&sample, 0, sizeof (GdkRGBA));
#line 241 "../src/background.vala"
	dd = (gdouble) 0xFF;
#line 242 "../src/background.vala"
	offset = (y * rowstride) + (x * channels);
#line 244 "../src/background.vala"
	_tmp0_ = offset;
#line 244 "../src/background.vala"
	offset = _tmp0_ + 1;
#line 244 "../src/background.vala"
	_tmp1_ = pixels[_tmp0_];
#line 244 "../src/background.vala"
	_tmp2_ = dd;
#line 244 "../src/background.vala"
	sample.red = _tmp1_ / _tmp2_;
#line 245 "../src/background.vala"
	_tmp3_ = offset;
#line 245 "../src/background.vala"
	offset = _tmp3_ + 1;
#line 245 "../src/background.vala"
	_tmp4_ = pixels[_tmp3_];
#line 245 "../src/background.vala"
	_tmp5_ = dd;
#line 245 "../src/background.vala"
	sample.green = _tmp4_ / _tmp5_;
#line 246 "../src/background.vala"
	_tmp6_ = offset;
#line 246 "../src/background.vala"
	offset = _tmp6_ + 1;
#line 246 "../src/background.vala"
	_tmp7_ = pixels[_tmp6_];
#line 246 "../src/background.vala"
	_tmp8_ = dd;
#line 246 "../src/background.vala"
	sample.blue = _tmp7_ / _tmp8_;
#line 247 "../src/background.vala"
	sample.alpha = (gdouble) 1.0f;
#line 249 "../src/background.vala"
	*result = sample;
#line 249 "../src/background.vala"
	return;
#line 1705 "background.c"
}

static gboolean
background_loader_is_color_different (BackgroundLoader* self,
                                      GdkRGBA* color_a,
                                      GdkRGBA* color_b)
{
	GdkRGBA diff = {0};
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GdkRGBA _tmp8_;
	gboolean result;
#line 252 "../src/background.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 252 "../src/background.vala"
	g_return_val_if_fail (color_a != NULL, FALSE);
#line 252 "../src/background.vala"
	g_return_val_if_fail (color_b != NULL, FALSE);
#line 255 "../src/background.vala"
	memset (&diff, 0, sizeof (GdkRGBA));
#line 257 "../src/background.vala"
	_tmp0_ = *color_a;
#line 257 "../src/background.vala"
	_tmp1_ = *color_b;
#line 257 "../src/background.vala"
	diff.red = _tmp0_.red - _tmp1_.red;
#line 258 "../src/background.vala"
	_tmp2_ = *color_a;
#line 258 "../src/background.vala"
	_tmp3_ = *color_b;
#line 258 "../src/background.vala"
	diff.green = _tmp2_.green - _tmp3_.green;
#line 259 "../src/background.vala"
	_tmp4_ = *color_a;
#line 259 "../src/background.vala"
	_tmp5_ = *color_b;
#line 259 "../src/background.vala"
	diff.blue = _tmp4_.blue - _tmp5_.blue;
#line 260 "../src/background.vala"
	diff.alpha = (gdouble) 1.0f;
#line 262 "../src/background.vala"
	_tmp8_ = diff;
#line 262 "../src/background.vala"
	if (fabs (_tmp8_.red) > 0.15) {
#line 262 "../src/background.vala"
		_tmp7_ = TRUE;
#line 1758 "background.c"
	} else {
		GdkRGBA _tmp9_;
#line 263 "../src/background.vala"
		_tmp9_ = diff;
#line 263 "../src/background.vala"
		_tmp7_ = fabs (_tmp9_.green) > 0.15;
#line 1765 "background.c"
	}
#line 262 "../src/background.vala"
	if (_tmp7_) {
#line 262 "../src/background.vala"
		_tmp6_ = TRUE;
#line 1771 "background.c"
	} else {
		GdkRGBA _tmp10_;
#line 264 "../src/background.vala"
		_tmp10_ = diff;
#line 264 "../src/background.vala"
		_tmp6_ = fabs (_tmp10_.blue) > 0.15;
#line 1778 "background.c"
	}
#line 262 "../src/background.vala"
	if (_tmp6_) {
#line 265 "../src/background.vala"
		result = TRUE;
#line 265 "../src/background.vala"
		return result;
#line 1786 "background.c"
	}
#line 267 "../src/background.vala"
	result = FALSE;
#line 267 "../src/background.vala"
	return result;
#line 1792 "background.c"
}

static void
background_loader_get_quad_average (BackgroundLoader* self,
                                    gint x,
                                    gint y,
                                    gint width,
                                    gint height,
                                    gint level_of_recursion,
                                    guint8* pixels,
                                    gint pixels_length1,
                                    gint rowstride,
                                    gint channels,
                                    GdkRGBA* result)
{
	GdkRGBA average = {0};
	GdkRGBA corner1 = {0};
	GdkRGBA _tmp0_ = {0};
	GdkRGBA corner2 = {0};
	GdkRGBA _tmp1_ = {0};
	GdkRGBA corner3 = {0};
	GdkRGBA _tmp2_ = {0};
	GdkRGBA corner4 = {0};
	GdkRGBA _tmp3_ = {0};
	GdkRGBA centre = {0};
	GdkRGBA _tmp4_ = {0};
	GdkRGBA _tmp21_;
	GdkRGBA _tmp22_;
	GdkRGBA _tmp23_;
	GdkRGBA _tmp24_;
	GdkRGBA _tmp25_;
	GdkRGBA _tmp26_;
	GdkRGBA _tmp27_;
	GdkRGBA _tmp28_;
	GdkRGBA _tmp29_;
	GdkRGBA _tmp30_;
	GdkRGBA _tmp31_;
	GdkRGBA _tmp32_;
	GdkRGBA _tmp33_;
	GdkRGBA _tmp34_;
	GdkRGBA _tmp35_;
#line 270 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 284 "../src/background.vala"
	memset (&average, 0, sizeof (GdkRGBA));
#line 285 "../src/background.vala"
	background_loader_get_pixbuf_sample (self, pixels, (gint) pixels_length1, rowstride, channels, x, y, &_tmp0_);
#line 285 "../src/background.vala"
	corner1 = _tmp0_;
#line 286 "../src/background.vala"
	background_loader_get_pixbuf_sample (self, pixels, (gint) pixels_length1, rowstride, channels, x + width, y, &_tmp1_);
#line 286 "../src/background.vala"
	corner2 = _tmp1_;
#line 287 "../src/background.vala"
	background_loader_get_pixbuf_sample (self, pixels, (gint) pixels_length1, rowstride, channels, x, y + height, &_tmp2_);
#line 287 "../src/background.vala"
	corner3 = _tmp2_;
#line 288 "../src/background.vala"
	background_loader_get_pixbuf_sample (self, pixels, (gint) pixels_length1, rowstride, channels, x + width, y + height, &_tmp3_);
#line 288 "../src/background.vala"
	corner4 = _tmp3_;
#line 289 "../src/background.vala"
	background_loader_get_pixbuf_sample (self, pixels, (gint) pixels_length1, rowstride, channels, x + (width / 2), y + (height / 2), &_tmp4_);
#line 289 "../src/background.vala"
	centre = _tmp4_;
#line 293 "../src/background.vala"
	if (level_of_recursion < BACKGROUND_LOADER_QUAD_MAX_LEVEL_OF_RECURSION) {
#line 1860 "background.c"
		gboolean _tmp5_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp17_ = FALSE;
#line 298 "../src/background.vala"
		if (level_of_recursion < BACKGROUND_LOADER_QUAD_MIN_LEVEL_OF_RECURSION) {
#line 298 "../src/background.vala"
			_tmp5_ = TRUE;
#line 1869 "background.c"
		} else {
			GdkRGBA _tmp6_;
			GdkRGBA _tmp7_;
#line 299 "../src/background.vala"
			_tmp6_ = corner1;
#line 299 "../src/background.vala"
			_tmp7_ = centre;
#line 299 "../src/background.vala"
			_tmp5_ = background_loader_is_color_different (self, &_tmp6_, &_tmp7_);
#line 1879 "background.c"
		}
#line 298 "../src/background.vala"
		if (_tmp5_) {
#line 1883 "background.c"
			GdkRGBA _tmp8_ = {0};
#line 300 "../src/background.vala"
			background_loader_get_quad_average (self, x, y, width / 2, height / 2, level_of_recursion + 1, pixels, (gint) pixels_length1, rowstride, channels, &_tmp8_);
#line 300 "../src/background.vala"
			corner1 = _tmp8_;
#line 1889 "background.c"
		}
#line 304 "../src/background.vala"
		if (level_of_recursion < BACKGROUND_LOADER_QUAD_MIN_LEVEL_OF_RECURSION) {
#line 304 "../src/background.vala"
			_tmp9_ = TRUE;
#line 1895 "background.c"
		} else {
			GdkRGBA _tmp10_;
			GdkRGBA _tmp11_;
#line 305 "../src/background.vala"
			_tmp10_ = corner2;
#line 305 "../src/background.vala"
			_tmp11_ = centre;
#line 305 "../src/background.vala"
			_tmp9_ = background_loader_is_color_different (self, &_tmp10_, &_tmp11_);
#line 1905 "background.c"
		}
#line 304 "../src/background.vala"
		if (_tmp9_) {
#line 1909 "background.c"
			GdkRGBA _tmp12_ = {0};
#line 306 "../src/background.vala"
			background_loader_get_quad_average (self, x + (width / 2), y, width / 2, height / 2, level_of_recursion + 1, pixels, (gint) pixels_length1, rowstride, channels, &_tmp12_);
#line 306 "../src/background.vala"
			corner2 = _tmp12_;
#line 1915 "background.c"
		}
#line 310 "../src/background.vala"
		if (level_of_recursion < BACKGROUND_LOADER_QUAD_MIN_LEVEL_OF_RECURSION) {
#line 310 "../src/background.vala"
			_tmp13_ = TRUE;
#line 1921 "background.c"
		} else {
			GdkRGBA _tmp14_;
			GdkRGBA _tmp15_;
#line 311 "../src/background.vala"
			_tmp14_ = corner3;
#line 311 "../src/background.vala"
			_tmp15_ = centre;
#line 311 "../src/background.vala"
			_tmp13_ = background_loader_is_color_different (self, &_tmp14_, &_tmp15_);
#line 1931 "background.c"
		}
#line 310 "../src/background.vala"
		if (_tmp13_) {
#line 1935 "background.c"
			GdkRGBA _tmp16_ = {0};
#line 312 "../src/background.vala"
			background_loader_get_quad_average (self, x, y + (height / 2), width / 2, height / 2, level_of_recursion + 1, pixels, (gint) pixels_length1, rowstride, channels, &_tmp16_);
#line 312 "../src/background.vala"
			corner3 = _tmp16_;
#line 1941 "background.c"
		}
#line 316 "../src/background.vala"
		if (level_of_recursion < BACKGROUND_LOADER_QUAD_MIN_LEVEL_OF_RECURSION) {
#line 316 "../src/background.vala"
			_tmp17_ = TRUE;
#line 1947 "background.c"
		} else {
			GdkRGBA _tmp18_;
			GdkRGBA _tmp19_;
#line 317 "../src/background.vala"
			_tmp18_ = corner4;
#line 317 "../src/background.vala"
			_tmp19_ = centre;
#line 317 "../src/background.vala"
			_tmp17_ = background_loader_is_color_different (self, &_tmp18_, &_tmp19_);
#line 1957 "background.c"
		}
#line 316 "../src/background.vala"
		if (_tmp17_) {
#line 1961 "background.c"
			GdkRGBA _tmp20_ = {0};
#line 318 "../src/background.vala"
			background_loader_get_quad_average (self, x + (width / 2), y + (height / 2), width / 2, height / 2, level_of_recursion + 1, pixels, (gint) pixels_length1, rowstride, channels, &_tmp20_);
#line 318 "../src/background.vala"
			corner4 = _tmp20_;
#line 1967 "background.c"
		}
	}
#line 322 "../src/background.vala"
	_tmp21_ = corner1;
#line 322 "../src/background.vala"
	_tmp22_ = corner3;
#line 322 "../src/background.vala"
	_tmp23_ = centre;
#line 322 "../src/background.vala"
	_tmp24_ = corner2;
#line 322 "../src/background.vala"
	_tmp25_ = corner4;
#line 322 "../src/background.vala"
	average.red = (((((_tmp21_.red * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NW) + (_tmp22_.red * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SW)) + (_tmp23_.red * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_CENTER)) + (_tmp24_.red * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NE)) + (_tmp25_.red * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SE)) / BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_TOTAL;
#line 328 "../src/background.vala"
	_tmp26_ = corner1;
#line 328 "../src/background.vala"
	_tmp27_ = corner3;
#line 328 "../src/background.vala"
	_tmp28_ = centre;
#line 328 "../src/background.vala"
	_tmp29_ = corner2;
#line 328 "../src/background.vala"
	_tmp30_ = corner4;
#line 328 "../src/background.vala"
	average.green = (((((_tmp26_.green * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NW) + (_tmp27_.green * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SW)) + (_tmp28_.green * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_CENTER)) + (_tmp29_.green * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NE)) + (_tmp30_.green * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SE)) / BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_TOTAL;
#line 334 "../src/background.vala"
	_tmp31_ = corner1;
#line 334 "../src/background.vala"
	_tmp32_ = corner3;
#line 334 "../src/background.vala"
	_tmp33_ = centre;
#line 334 "../src/background.vala"
	_tmp34_ = corner2;
#line 334 "../src/background.vala"
	_tmp35_ = corner4;
#line 334 "../src/background.vala"
	average.blue = (((((_tmp31_.blue * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NW) + (_tmp32_.blue * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SW)) + (_tmp33_.blue * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_CENTER)) + (_tmp34_.blue * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_NE)) + (_tmp35_.blue * BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_SE)) / BACKGROUND_LOADER_QUAD_CORNER_WEIGHT_TOTAL;
#line 340 "../src/background.vala"
	average.alpha = (gdouble) 1.0f;
#line 342 "../src/background.vala"
	*result = average;
#line 342 "../src/background.vala"
	return;
#line 2012 "background.c"
}

static void
background_loader_pixbuf_average_value (BackgroundLoader* self,
                                        GdkPixbuf* pixbuf,
                                        GdkRGBA* _result_)
{
	GdkRGBA _vala__result_ = {0};
	GdkRGBA average = {0};
	guint8* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
#line 345 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 345 "../src/background.vala"
	g_return_if_fail (pixbuf != NULL);
#line 348 "../src/background.vala"
	_tmp0_ = gdk_pixbuf_get_pixels (pixbuf);
#line 348 "../src/background.vala"
	background_loader_get_quad_average (self, 0, 0, gdk_pixbuf_get_width (pixbuf) - 1, gdk_pixbuf_get_height (pixbuf) - 1, 1, _tmp0_, (gint) -1, gdk_pixbuf_get_rowstride (pixbuf), gdk_pixbuf_get_n_channels (pixbuf), &_tmp1_);
#line 348 "../src/background.vala"
	average = _tmp1_;
#line 355 "../src/background.vala"
	memset (&_vala__result_, 0, sizeof (GdkRGBA));
#line 356 "../src/background.vala"
	_tmp2_ = average;
#line 356 "../src/background.vala"
	_vala__result_.red = _tmp2_.red;
#line 357 "../src/background.vala"
	_tmp3_ = average;
#line 357 "../src/background.vala"
	_vala__result_.green = _tmp3_.green;
#line 358 "../src/background.vala"
	_tmp4_ = average;
#line 358 "../src/background.vala"
	_vala__result_.blue = _tmp4_.blue;
#line 359 "../src/background.vala"
	_tmp5_ = average;
#line 359 "../src/background.vala"
	_vala__result_.alpha = _tmp5_.alpha;
#line 345 "../src/background.vala"
	if (_result_) {
#line 345 "../src/background.vala"
		*_result_ = _vala__result_;
#line 2060 "background.c"
	}
}

const gchar*
background_loader_get_filename (BackgroundLoader* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 23 "../src/background.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 23 "../src/background.vala"
	_tmp0_ = self->priv->_filename;
#line 23 "../src/background.vala"
	result = _tmp0_;
#line 23 "../src/background.vala"
	return result;
#line 2077 "background.c"
}

static void
background_loader_set_filename (BackgroundLoader* self,
                                const gchar* value)
{
	gchar* old_value;
#line 23 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 23 "../src/background.vala"
	old_value = background_loader_get_filename (self);
#line 23 "../src/background.vala"
	if (g_strcmp0 (value, old_value) != 0) {
#line 2091 "background.c"
		gchar* _tmp0_;
#line 23 "../src/background.vala"
		_tmp0_ = g_strdup (value);
#line 23 "../src/background.vala"
		_g_free0 (self->priv->_filename);
#line 23 "../src/background.vala"
		self->priv->_filename = _tmp0_;
#line 23 "../src/background.vala"
		g_object_notify_by_pspec ((GObject *) self, background_loader_properties[BACKGROUND_LOADER_FILENAME_PROPERTY]);
#line 2101 "background.c"
	}
}

cairo_surface_t*
background_loader_get_logo (BackgroundLoader* self)
{
	cairo_surface_t* result;
	cairo_surface_t* _tmp0_;
#line 24 "../src/background.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 24 "../src/background.vala"
	_tmp0_ = self->priv->_logo;
#line 24 "../src/background.vala"
	result = _tmp0_;
#line 24 "../src/background.vala"
	return result;
#line 2118 "background.c"
}

void
background_loader_set_logo (BackgroundLoader* self,
                            cairo_surface_t* value)
{
	cairo_surface_t* old_value;
#line 24 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 24 "../src/background.vala"
	old_value = background_loader_get_logo (self);
#line 24 "../src/background.vala"
	if (old_value != value) {
#line 2132 "background.c"
		cairo_surface_t* _tmp0_;
#line 24 "../src/background.vala"
		_tmp0_ = _cairo_surface_reference0 (value);
#line 24 "../src/background.vala"
		_cairo_surface_destroy0 (self->priv->_logo);
#line 24 "../src/background.vala"
		self->priv->_logo = _tmp0_;
#line 24 "../src/background.vala"
		g_object_notify_by_pspec ((GObject *) self, background_loader_properties[BACKGROUND_LOADER_LOGO_PROPERTY]);
#line 2142 "background.c"
	}
}

static void
background_loader_class_init (BackgroundLoaderClass * klass,
                              gpointer klass_data)
{
#line 21 "../src/background.vala"
	background_loader_parent_class = g_type_class_peek_parent (klass);
#line 21 "../src/background.vala"
	g_type_class_adjust_private_offset (klass, &BackgroundLoader_private_offset);
#line 21 "../src/background.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_background_loader_get_property;
#line 21 "../src/background.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_background_loader_set_property;
#line 21 "../src/background.vala"
	G_OBJECT_CLASS (klass)->finalize = background_loader_finalize;
#line 21 "../src/background.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_LOADER_FILENAME_PROPERTY, background_loader_properties[BACKGROUND_LOADER_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 21 "../src/background.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_LOADER_LOGO_PROPERTY, background_loader_properties[BACKGROUND_LOADER_LOGO_PROPERTY] = g_param_spec_boxed ("logo", "logo", "logo", cairo_gobject_surface_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "../src/background.vala"
	background_loader_signals[BACKGROUND_LOADER_LOADED_SIGNAL] = g_signal_new ("loaded", TYPE_BACKGROUND_LOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 2166 "background.c"
}

static void
background_loader_instance_init (BackgroundLoader * self,
                                 gpointer klass)
{
#line 21 "../src/background.vala"
	self->priv = background_loader_get_instance_private (self);
#line 2175 "background.c"
}

static void
background_loader_finalize (GObject * obj)
{
	BackgroundLoader * self;
#line 21 "../src/background.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKGROUND_LOADER, BackgroundLoader);
#line 110 "../src/background.vala"
	if (self->priv->ready_id > ((guint) 0)) {
#line 111 "../src/background.vala"
		g_source_remove (self->priv->ready_id);
#line 2188 "background.c"
	}
#line 112 "../src/background.vala"
	self->priv->ready_id = (guint) 0;
#line 23 "../src/background.vala"
	_g_free0 (self->priv->_filename);
#line 24 "../src/background.vala"
	_cairo_surface_destroy0 (self->priv->_logo);
#line 26 "../src/background.vala"
	self->widths = (g_free (self->widths), NULL);
#line 27 "../src/background.vala"
	self->heights = (g_free (self->heights), NULL);
#line 28 "../src/background.vala"
	self->patterns = (_vala_array_free (self->patterns, self->patterns_length1, (GDestroyNotify) cairo_pattern_destroy), NULL);
#line 31 "../src/background.vala"
	_cairo_surface_destroy0 (self->priv->target_surface);
#line 32 "../src/background.vala"
	_g_thread_unref0 (self->priv->thread);
#line 33 "../src/background.vala"
	self->priv->images = (_vala_array_free (self->priv->images, self->priv->images_length1, (GDestroyNotify) g_object_unref), NULL);
#line 21 "../src/background.vala"
	G_OBJECT_CLASS (background_loader_parent_class)->finalize (obj);
#line 2210 "background.c"
}

static GType
background_loader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BackgroundLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackgroundLoader), 0, (GInstanceInitFunc) background_loader_instance_init, NULL };
	GType background_loader_type_id;
	background_loader_type_id = g_type_register_static (G_TYPE_OBJECT, "BackgroundLoader", &g_define_type_info, 0);
	BackgroundLoader_private_offset = g_type_add_instance_private (background_loader_type_id, sizeof (BackgroundLoaderPrivate));
	return background_loader_type_id;
}

GType
background_loader_get_type (void)
{
	static volatile gsize background_loader_type_id__once = 0;
	if (g_once_init_enter (&background_loader_type_id__once)) {
		GType background_loader_type_id;
		background_loader_type_id = background_loader_get_type_once ();
		g_once_init_leave (&background_loader_type_id__once, background_loader_type_id);
	}
	return background_loader_type_id__once;
}

static void
_vala_background_loader_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	BackgroundLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BACKGROUND_LOADER, BackgroundLoader);
#line 21 "../src/background.vala"
	switch (property_id) {
#line 21 "../src/background.vala"
		case BACKGROUND_LOADER_FILENAME_PROPERTY:
#line 21 "../src/background.vala"
		g_value_set_string (value, background_loader_get_filename (self));
#line 21 "../src/background.vala"
		break;
#line 21 "../src/background.vala"
		case BACKGROUND_LOADER_LOGO_PROPERTY:
#line 21 "../src/background.vala"
		g_value_set_boxed (value, background_loader_get_logo (self));
#line 21 "../src/background.vala"
		break;
#line 2257 "background.c"
		default:
#line 21 "../src/background.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "../src/background.vala"
		break;
#line 2263 "background.c"
	}
}

static void
_vala_background_loader_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	BackgroundLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BACKGROUND_LOADER, BackgroundLoader);
#line 21 "../src/background.vala"
	switch (property_id) {
#line 21 "../src/background.vala"
		case BACKGROUND_LOADER_FILENAME_PROPERTY:
#line 21 "../src/background.vala"
		background_loader_set_filename (self, g_value_get_string (value));
#line 21 "../src/background.vala"
		break;
#line 21 "../src/background.vala"
		case BACKGROUND_LOADER_LOGO_PROPERTY:
#line 21 "../src/background.vala"
		background_loader_set_logo (self, g_value_get_boxed (value));
#line 21 "../src/background.vala"
		break;
#line 2289 "background.c"
		default:
#line 21 "../src/background.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "../src/background.vala"
		break;
#line 2295 "background.c"
	}
}

Monitor*
monitor_construct (GType object_type,
                   gint x,
                   gint y,
                   gint width,
                   gint height)
{
	Monitor* self = NULL;
#line 370 "../src/background.vala"
	self = (Monitor*) g_type_create_instance (object_type);
#line 372 "../src/background.vala"
	self->x = x;
#line 373 "../src/background.vala"
	self->y = y;
#line 374 "../src/background.vala"
	self->width = width;
#line 375 "../src/background.vala"
	self->height = height;
#line 370 "../src/background.vala"
	return self;
#line 2319 "background.c"
}

Monitor*
monitor_new (gint x,
             gint y,
             gint width,
             gint height)
{
#line 370 "../src/background.vala"
	return monitor_construct (TYPE_MONITOR, x, y, width, height);
#line 2330 "background.c"
}

gboolean
monitor_equals (Monitor* self,
                Monitor* other)
{
	gboolean result;
#line 378 "../src/background.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 380 "../src/background.vala"
	if (other != NULL) {
#line 2342 "background.c"
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
#line 381 "../src/background.vala"
		if (self->x == other->x) {
#line 381 "../src/background.vala"
			_tmp2_ = self->y == other->y;
#line 2350 "background.c"
		} else {
#line 381 "../src/background.vala"
			_tmp2_ = FALSE;
#line 2354 "background.c"
		}
#line 381 "../src/background.vala"
		if (_tmp2_) {
#line 381 "../src/background.vala"
			_tmp1_ = self->width == other->width;
#line 2360 "background.c"
		} else {
#line 381 "../src/background.vala"
			_tmp1_ = FALSE;
#line 2364 "background.c"
		}
#line 381 "../src/background.vala"
		if (_tmp1_) {
#line 381 "../src/background.vala"
			_tmp0_ = self->height == other->height;
#line 2370 "background.c"
		} else {
#line 381 "../src/background.vala"
			_tmp0_ = FALSE;
#line 2374 "background.c"
		}
#line 381 "../src/background.vala"
		result = _tmp0_;
#line 381 "../src/background.vala"
		return result;
#line 2380 "background.c"
	}
#line 383 "../src/background.vala"
	result = FALSE;
#line 383 "../src/background.vala"
	return result;
#line 2386 "background.c"
}

static void
value_monitor_init (GValue* value)
{
#line 363 "../src/background.vala"
	value->data[0].v_pointer = NULL;
#line 2394 "background.c"
}

static void
value_monitor_free_value (GValue* value)
{
#line 363 "../src/background.vala"
	if (value->data[0].v_pointer) {
#line 363 "../src/background.vala"
		monitor_unref (value->data[0].v_pointer);
#line 2404 "background.c"
	}
}

static void
value_monitor_copy_value (const GValue* src_value,
                          GValue* dest_value)
{
#line 363 "../src/background.vala"
	if (src_value->data[0].v_pointer) {
#line 363 "../src/background.vala"
		dest_value->data[0].v_pointer = monitor_ref (src_value->data[0].v_pointer);
#line 2416 "background.c"
	} else {
#line 363 "../src/background.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2420 "background.c"
	}
}

static gpointer
value_monitor_peek_pointer (const GValue* value)
{
#line 363 "../src/background.vala"
	return value->data[0].v_pointer;
#line 2429 "background.c"
}

static gchar*
value_monitor_collect_value (GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
#line 363 "../src/background.vala"
	if (collect_values[0].v_pointer) {
#line 2440 "background.c"
		Monitor * object;
		object = collect_values[0].v_pointer;
#line 363 "../src/background.vala"
		if (object->parent_instance.g_class == NULL) {
#line 363 "../src/background.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2447 "background.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 363 "../src/background.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2451 "background.c"
		}
#line 363 "../src/background.vala"
		value->data[0].v_pointer = monitor_ref (object);
#line 2455 "background.c"
	} else {
#line 363 "../src/background.vala"
		value->data[0].v_pointer = NULL;
#line 2459 "background.c"
	}
#line 363 "../src/background.vala"
	return NULL;
#line 2463 "background.c"
}

static gchar*
value_monitor_lcopy_value (const GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
	Monitor ** object_p;
	object_p = collect_values[0].v_pointer;
#line 363 "../src/background.vala"
	if (!object_p) {
#line 363 "../src/background.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2478 "background.c"
	}
#line 363 "../src/background.vala"
	if (!value->data[0].v_pointer) {
#line 363 "../src/background.vala"
		*object_p = NULL;
#line 2484 "background.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 363 "../src/background.vala"
		*object_p = value->data[0].v_pointer;
#line 2488 "background.c"
	} else {
#line 363 "../src/background.vala"
		*object_p = monitor_ref (value->data[0].v_pointer);
#line 2492 "background.c"
	}
#line 363 "../src/background.vala"
	return NULL;
#line 2496 "background.c"
}

GParamSpec*
param_spec_monitor (const gchar* name,
                    const gchar* nick,
                    const gchar* blurb,
                    GType object_type,
                    GParamFlags flags)
{
	ParamSpecMonitor* spec;
#line 363 "../src/background.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MONITOR), NULL);
#line 363 "../src/background.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 363 "../src/background.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 363 "../src/background.vala"
	return G_PARAM_SPEC (spec);
#line 2515 "background.c"
}

gpointer
value_get_monitor (const GValue* value)
{
#line 363 "../src/background.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MONITOR), NULL);
#line 363 "../src/background.vala"
	return value->data[0].v_pointer;
#line 2525 "background.c"
}

void
value_set_monitor (GValue* value,
                   gpointer v_object)
{
	Monitor * old;
#line 363 "../src/background.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MONITOR));
#line 363 "../src/background.vala"
	old = value->data[0].v_pointer;
#line 363 "../src/background.vala"
	if (v_object) {
#line 363 "../src/background.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MONITOR));
#line 363 "../src/background.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 363 "../src/background.vala"
		value->data[0].v_pointer = v_object;
#line 363 "../src/background.vala"
		monitor_ref (value->data[0].v_pointer);
#line 2547 "background.c"
	} else {
#line 363 "../src/background.vala"
		value->data[0].v_pointer = NULL;
#line 2551 "background.c"
	}
#line 363 "../src/background.vala"
	if (old) {
#line 363 "../src/background.vala"
		monitor_unref (old);
#line 2557 "background.c"
	}
}

void
value_take_monitor (GValue* value,
                    gpointer v_object)
{
	Monitor * old;
#line 363 "../src/background.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MONITOR));
#line 363 "../src/background.vala"
	old = value->data[0].v_pointer;
#line 363 "../src/background.vala"
	if (v_object) {
#line 363 "../src/background.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MONITOR));
#line 363 "../src/background.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 363 "../src/background.vala"
		value->data[0].v_pointer = v_object;
#line 2578 "background.c"
	} else {
#line 363 "../src/background.vala"
		value->data[0].v_pointer = NULL;
#line 2582 "background.c"
	}
#line 363 "../src/background.vala"
	if (old) {
#line 363 "../src/background.vala"
		monitor_unref (old);
#line 2588 "background.c"
	}
}

static void
monitor_class_init (MonitorClass * klass,
                    gpointer klass_data)
{
#line 363 "../src/background.vala"
	monitor_parent_class = g_type_class_peek_parent (klass);
#line 363 "../src/background.vala"
	((MonitorClass *) klass)->finalize = monitor_finalize;
#line 2600 "background.c"
}

static void
monitor_instance_init (Monitor * self,
                       gpointer klass)
{
#line 363 "../src/background.vala"
	self->ref_count = 1;
#line 2609 "background.c"
}

static void
monitor_finalize (Monitor * obj)
{
	Monitor * self;
#line 363 "../src/background.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MONITOR, Monitor);
#line 363 "../src/background.vala"
	g_signal_handlers_destroy (self);
#line 2620 "background.c"
}

static GType
monitor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_monitor_init, value_monitor_free_value, value_monitor_copy_value, value_monitor_peek_pointer, "p", value_monitor_collect_value, "p", value_monitor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Monitor), 0, (GInstanceInitFunc) monitor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType monitor_type_id;
	monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Monitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return monitor_type_id;
}

GType
monitor_get_type (void)
{
	static volatile gsize monitor_type_id__once = 0;
	if (g_once_init_enter (&monitor_type_id__once)) {
		GType monitor_type_id;
		monitor_type_id = monitor_get_type_once ();
		g_once_init_leave (&monitor_type_id__once, monitor_type_id);
	}
	return monitor_type_id__once;
}

gpointer
monitor_ref (gpointer instance)
{
	Monitor * self;
	self = instance;
#line 363 "../src/background.vala"
	g_atomic_int_inc (&self->ref_count);
#line 363 "../src/background.vala"
	return instance;
#line 2655 "background.c"
}

void
monitor_unref (gpointer instance)
{
	Monitor * self;
	self = instance;
#line 363 "../src/background.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 363 "../src/background.vala"
		MONITOR_GET_CLASS (self)->finalize (self);
#line 363 "../src/background.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2669 "background.c"
	}
}

static inline gpointer
background_get_instance_private (Background* self)
{
	return G_STRUCT_MEMBER_P (self, Background_private_offset);
}

static GType
background_draw_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{BACKGROUND_DRAW_FLAGS_NONE, "BACKGROUND_DRAW_FLAGS_NONE", "none"}, {BACKGROUND_DRAW_FLAGS_GRID, "BACKGROUND_DRAW_FLAGS_GRID", "grid"}, {BACKGROUND_DRAW_FLAGS_SPAN, "BACKGROUND_DRAW_FLAGS_SPAN", "span"}, {0, NULL, NULL}};
	GType background_draw_flags_type_id;
	background_draw_flags_type_id = g_flags_register_static ("BackgroundDrawFlags", values);
	return background_draw_flags_type_id;
}

GType
background_draw_flags_get_type (void)
{
	static volatile gsize background_draw_flags_type_id__once = 0;
	if (g_once_init_enter (&background_draw_flags_type_id__once)) {
		GType background_draw_flags_type_id;
		background_draw_flags_type_id = background_draw_flags_get_type_once ();
		g_once_init_leave (&background_draw_flags_type_id__once, background_draw_flags_type_id);
	}
	return background_draw_flags_type_id__once;
}

static void
_monitor_unref0_ (gpointer var)
{
#line 495 "../src/background.vala"
	(var == NULL) ? NULL : (var = (monitor_unref (var), NULL));
#line 2705 "background.c"
}

static inline void
_g_list_free__monitor_unref0_ (GList* self)
{
#line 495 "../src/background.vala"
	g_list_free_full (self, (GDestroyNotify) _monitor_unref0_);
#line 2713 "background.c"
}

static void
_g_free0_ (gpointer var)
{
#line 518 "../src/background.vala"
	var = (g_free (var), NULL);
#line 2721 "background.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 518 "../src/background.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 2729 "background.c"
}

Background*
background_construct (GType object_type)
{
	Background * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
#line 512 "../src/background.vala"
	self = (Background*) g_object_new (object_type, NULL);
#line 514 "../src/background.vala"
	_cairo_surface_destroy0 (self->priv->target_surface);
#line 514 "../src/background.vala"
	self->priv->target_surface = NULL;
#line 515 "../src/background.vala"
	_g_object_unref0 (self->priv->timer);
#line 515 "../src/background.vala"
	self->priv->timer = NULL;
#line 517 "../src/background.vala"
	gtk_container_set_resize_mode ((GtkContainer*) self, GTK_RESIZE_QUEUE);
#line 518 "../src/background.vala"
	_tmp0_ = g_str_hash;
#line 518 "../src/background.vala"
	_tmp1_ = g_str_equal;
#line 518 "../src/background.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
#line 518 "../src/background.vala"
	_g_hash_table_unref0 (self->priv->loaders);
#line 518 "../src/background.vala"
	self->priv->loaders = _tmp2_;
#line 519 "../src/background.vala"
	if (ug_settings_get_boolean (UG_SETTINGS_KEY_DRAW_GRID)) {
#line 520 "../src/background.vala"
		self->priv->flags = self->priv->flags | BACKGROUND_DRAW_FLAGS_GRID;
#line 2765 "background.c"
	}
#line 522 "../src/background.vala"
	if (ug_settings_get_boolean (UG_SETTINGS_KEY_BACKGROUND_STRETCH)) {
#line 523 "../src/background.vala"
		self->priv->flags = self->priv->flags | BACKGROUND_DRAW_FLAGS_SPAN;
#line 2771 "background.c"
	}
#line 525 "../src/background.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 512 "../src/background.vala"
	return self;
#line 2777 "background.c"
}

Background*
background_new (void)
{
#line 512 "../src/background.vala"
	return background_construct (TYPE_BACKGROUND);
#line 2785 "background.c"
}

static gdouble
_animate_timer_ease_in_out_animate_timer_easing_func (gdouble x,
                                                      gpointer self)
{
	gdouble result;
	result = animate_timer_ease_in_out (x);
#line 532 "../src/background.vala"
	return result;
#line 2796 "background.c"
}

static void
_background_animate_cb_animate_timer_animate (AnimateTimer* _sender,
                                              gdouble progress,
                                              gpointer self)
{
#line 536 "../src/background.vala"
	background_animate_cb ((Background*) self, progress);
#line 2806 "background.c"
}

void
background_set_surface (Background* self,
                        cairo_surface_t* target_surface)
{
	cairo_surface_t* _tmp0_;
	AnimateTimer* _tmp1_;
	BackgroundLoader* _tmp2_;
	BackgroundLoader* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	AnimateTimer* _tmp8_;
#line 528 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 528 "../src/background.vala"
	g_return_if_fail (target_surface != NULL);
#line 530 "../src/background.vala"
	_tmp0_ = _cairo_surface_reference0 (target_surface);
#line 530 "../src/background.vala"
	_cairo_surface_destroy0 (self->priv->target_surface);
#line 530 "../src/background.vala"
	self->priv->target_surface = _tmp0_;
#line 532 "../src/background.vala"
	_tmp1_ = animate_timer_new (_animate_timer_ease_in_out_animate_timer_easing_func, NULL, 700);
#line 532 "../src/background.vala"
	_g_object_unref0 (self->priv->timer);
#line 532 "../src/background.vala"
	self->priv->timer = _tmp1_;
#line 534 "../src/background.vala"
	_tmp2_ = background_load_background (self, NULL);
#line 534 "../src/background.vala"
	_tmp3_ = _tmp2_;
#line 534 "../src/background.vala"
	_g_object_unref0 (_tmp3_);
#line 535 "../src/background.vala"
	_tmp4_ = ug_settings_get_string (UG_SETTINGS_KEY_LOGO);
#line 535 "../src/background.vala"
	_tmp5_ = _tmp4_;
#line 535 "../src/background.vala"
	_tmp6_ = ug_settings_get_string (UG_SETTINGS_KEY_OTHER_MONITORS_LOGO);
#line 535 "../src/background.vala"
	_tmp7_ = _tmp6_;
#line 535 "../src/background.vala"
	background_set_logo (self, _tmp5_, _tmp7_);
#line 535 "../src/background.vala"
	_g_free0 (_tmp7_);
#line 535 "../src/background.vala"
	_g_free0 (_tmp5_);
#line 536 "../src/background.vala"
	_tmp8_ = self->priv->timer;
#line 536 "../src/background.vala"
	g_signal_connect_object (_tmp8_, "animate", (GCallback) _background_animate_cb_animate_timer_animate, self, 0);
#line 2862 "background.c"
}

void
background_set_logo (Background* self,
                     const gchar* version_logo,
                     const gchar* other_monitors_logo)
{
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	cairo_surface_t* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	cairo_surface_t* _tmp5_;
#line 539 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 539 "../src/background.vala"
	g_return_if_fail (version_logo != NULL);
#line 539 "../src/background.vala"
	g_return_if_fail (other_monitors_logo != NULL);
#line 541 "../src/background.vala"
	_tmp2_ = background_load_image (self, version_logo, &_tmp0_, &_tmp1_);
#line 541 "../src/background.vala"
	self->priv->version_logo_width = _tmp0_;
#line 541 "../src/background.vala"
	self->priv->version_logo_height = _tmp1_;
#line 541 "../src/background.vala"
	_cairo_surface_destroy0 (self->priv->version_logo_surface);
#line 541 "../src/background.vala"
	self->priv->version_logo_surface = _tmp2_;
#line 542 "../src/background.vala"
	_tmp5_ = background_load_image (self, other_monitors_logo, &_tmp3_, &_tmp4_);
#line 542 "../src/background.vala"
	self->priv->other_monitors_logo_width = _tmp3_;
#line 542 "../src/background.vala"
	self->priv->other_monitors_logo_height = _tmp4_;
#line 542 "../src/background.vala"
	_cairo_surface_destroy0 (self->priv->other_monitors_logo_surface);
#line 542 "../src/background.vala"
	self->priv->other_monitors_logo_surface = _tmp5_;
#line 2902 "background.c"
}

static cairo_surface_t*
background_load_image (Background* self,
                       const gchar* filename,
                       gint* width,
                       gint* height)
{
	gint _vala_width = 0;
	gint _vala_height = 0;
	GError* _inner_error0_ = NULL;
	cairo_surface_t* result;
#line 545 "../src/background.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 545 "../src/background.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 547 "../src/background.vala"
	_vala_height = 0;
#line 547 "../src/background.vala"
	_vala_width = _vala_height;
#line 2923 "background.c"
	{
#line 551 "../src/background.vala"
		if (g_strcmp0 (filename, "") != 0) {
#line 2927 "background.c"
			GdkPixbuf* image = NULL;
			GdkPixbuf* _tmp0_;
			GdkPixbuf* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			GdkPixbuf* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			cairo_surface_t* surface = NULL;
			cairo_surface_t* _tmp7_;
			GdkPixbuf* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GdkPixbuf* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			cairo_surface_t* _tmp14_;
			cairo_t* c = NULL;
			cairo_surface_t* _tmp15_;
			cairo_t* _tmp16_;
			cairo_t* _tmp17_;
			GdkPixbuf* _tmp18_;
			cairo_t* _tmp19_;
#line 552 "../src/background.vala"
			_tmp0_ = gdk_pixbuf_new_from_file (filename, &_inner_error0_);
#line 552 "../src/background.vala"
			image = _tmp0_;
#line 552 "../src/background.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2957 "background.c"
				goto __catch0_g_error;
			}
#line 553 "../src/background.vala"
			_tmp1_ = image;
#line 553 "../src/background.vala"
			_tmp2_ = gdk_pixbuf_get_width (_tmp1_);
#line 553 "../src/background.vala"
			_tmp3_ = _tmp2_;
#line 553 "../src/background.vala"
			_vala_width = _tmp3_;
#line 554 "../src/background.vala"
			_tmp4_ = image;
#line 554 "../src/background.vala"
			_tmp5_ = gdk_pixbuf_get_height (_tmp4_);
#line 554 "../src/background.vala"
			_tmp6_ = _tmp5_;
#line 554 "../src/background.vala"
			_vala_height = _tmp6_;
#line 555 "../src/background.vala"
			_tmp7_ = self->priv->target_surface;
#line 555 "../src/background.vala"
			_tmp8_ = image;
#line 555 "../src/background.vala"
			_tmp9_ = gdk_pixbuf_get_width (_tmp8_);
#line 555 "../src/background.vala"
			_tmp10_ = _tmp9_;
#line 555 "../src/background.vala"
			_tmp11_ = image;
#line 555 "../src/background.vala"
			_tmp12_ = gdk_pixbuf_get_height (_tmp11_);
#line 555 "../src/background.vala"
			_tmp13_ = _tmp12_;
#line 555 "../src/background.vala"
			_tmp14_ = cairo_surface_create_similar (_tmp7_, CAIRO_CONTENT_COLOR_ALPHA, _tmp10_, _tmp13_);
#line 555 "../src/background.vala"
			surface = _tmp14_;
#line 556 "../src/background.vala"
			_tmp15_ = surface;
#line 556 "../src/background.vala"
			_tmp16_ = cairo_create (_tmp15_);
#line 556 "../src/background.vala"
			c = _tmp16_;
#line 557 "../src/background.vala"
			_tmp17_ = c;
#line 557 "../src/background.vala"
			_tmp18_ = image;
#line 557 "../src/background.vala"
			gdk_cairo_set_source_pixbuf (_tmp17_, _tmp18_, (gdouble) 0, (gdouble) 0);
#line 558 "../src/background.vala"
			_tmp19_ = c;
#line 558 "../src/background.vala"
			cairo_paint (_tmp19_);
#line 559 "../src/background.vala"
			result = surface;
#line 559 "../src/background.vala"
			_cairo_destroy0 (c);
#line 559 "../src/background.vala"
			_g_object_unref0 (image);
#line 559 "../src/background.vala"
			if (width) {
#line 559 "../src/background.vala"
				*width = _vala_width;
#line 3020 "background.c"
			}
#line 559 "../src/background.vala"
			if (height) {
#line 559 "../src/background.vala"
				*height = _vala_height;
#line 3026 "background.c"
			}
#line 559 "../src/background.vala"
			return result;
#line 3030 "background.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
#line 549 "../src/background.vala"
		e = _inner_error0_;
#line 549 "../src/background.vala"
		_inner_error0_ = NULL;
#line 564 "../src/background.vala"
		_tmp20_ = e;
#line 564 "../src/background.vala"
		_tmp21_ = _tmp20_->message;
#line 564 "../src/background.vala"
		g_debug ("background.vala:564: Failed to load background component %s: %s", filename, _tmp21_);
#line 549 "../src/background.vala"
		_g_error_free0 (e);
#line 3051 "background.c"
	}
	__finally0:
#line 549 "../src/background.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 549 "../src/background.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 549 "../src/background.vala"
		g_clear_error (&_inner_error0_);
#line 549 "../src/background.vala"
		return NULL;
#line 3062 "background.c"
	}
#line 567 "../src/background.vala"
	result = NULL;
#line 567 "../src/background.vala"
	if (width) {
#line 567 "../src/background.vala"
		*width = _vala_width;
#line 3070 "background.c"
	}
#line 567 "../src/background.vala"
	if (height) {
#line 567 "../src/background.vala"
		*height = _vala_height;
#line 3076 "background.c"
	}
#line 567 "../src/background.vala"
	return result;
#line 3080 "background.c"
}

static gpointer
_monitor_ref0 (gpointer self)
{
#line 573 "../src/background.vala"
	return self ? monitor_ref (self) : NULL;
#line 3088 "background.c"
}

void
background_set_monitors (Background* self,
                         GList* monitors)
{
#line 570 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 572 "../src/background.vala"
	(self->priv->monitors == NULL) ? NULL : (self->priv->monitors = (_g_list_free__monitor_unref0_ (self->priv->monitors), NULL));
#line 572 "../src/background.vala"
	self->priv->monitors = NULL;
#line 3101 "background.c"
	{
		GList* m_collection = NULL;
		GList* m_it = NULL;
#line 573 "../src/background.vala"
		m_collection = monitors;
#line 573 "../src/background.vala"
		for (m_it = m_collection; m_it != NULL; m_it = m_it->next) {
#line 3109 "background.c"
			Monitor* _tmp0_;
			Monitor* m = NULL;
#line 573 "../src/background.vala"
			_tmp0_ = _monitor_ref0 ((Monitor*) m_it->data);
#line 573 "../src/background.vala"
			m = _tmp0_;
#line 3116 "background.c"
			{
				Monitor* _tmp1_;
				Monitor* _tmp2_;
				Monitor* _tmp5_;
				Monitor* _tmp6_;
				Monitor* _tmp9_;
				Monitor* _tmp10_;
#line 575 "../src/background.vala"
				_tmp1_ = m;
#line 575 "../src/background.vala"
				_tmp2_ = m;
#line 575 "../src/background.vala"
				if (self->priv->_width < (_tmp1_->x + _tmp2_->width)) {
#line 3130 "background.c"
					Monitor* _tmp3_;
					Monitor* _tmp4_;
#line 576 "../src/background.vala"
					_tmp3_ = m;
#line 576 "../src/background.vala"
					_tmp4_ = m;
#line 576 "../src/background.vala"
					self->priv->_width = _tmp3_->x + _tmp4_->width;
#line 3139 "background.c"
				}
#line 578 "../src/background.vala"
				_tmp5_ = m;
#line 578 "../src/background.vala"
				_tmp6_ = m;
#line 578 "../src/background.vala"
				if (self->priv->_height < (_tmp5_->y + _tmp6_->height)) {
#line 3147 "background.c"
					Monitor* _tmp7_;
					Monitor* _tmp8_;
#line 579 "../src/background.vala"
					_tmp7_ = m;
#line 579 "../src/background.vala"
					_tmp8_ = m;
#line 579 "../src/background.vala"
					self->priv->_height = _tmp7_->y + _tmp8_->height;
#line 3156 "background.c"
				}
#line 581 "../src/background.vala"
				_tmp9_ = m;
#line 581 "../src/background.vala"
				_tmp10_ = _monitor_ref0 (_tmp9_);
#line 581 "../src/background.vala"
				self->priv->monitors = g_list_append (self->priv->monitors, _tmp10_);
#line 573 "../src/background.vala"
				_monitor_unref0 (m);
#line 3166 "background.c"
			}
		}
	}
#line 583 "../src/background.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 3172 "background.c"
}

void
background_set_active_monitor (Background* self,
                               Monitor* monitor)
{
	Monitor* _tmp0_;
#line 586 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 588 "../src/background.vala"
	_tmp0_ = _monitor_ref0 (monitor);
#line 588 "../src/background.vala"
	_monitor_unref0 (self->priv->active_monitor);
#line 588 "../src/background.vala"
	self->priv->active_monitor = _tmp0_;
#line 3188 "background.c"
}

static void
_background_synchronized_redraw_dash_box_transition_complete (DashBox* _sender,
                                                              gpointer self)
{
#line 595 "../src/background.vala"
	background_synchronized_redraw ((Background*) self);
#line 3197 "background.c"
}

void
background_connect_to_dashbox_transitions (Background* self,
                                           DashBox* dashbox)
{
#line 591 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 591 "../src/background.vala"
	g_return_if_fail (dashbox != NULL);
#line 593 "../src/background.vala"
	if (dashbox != NULL) {
#line 595 "../src/background.vala"
		g_signal_connect_object (dashbox, "transition-complete", (GCallback) _background_synchronized_redraw_dash_box_transition_complete, self, 0);
#line 3212 "background.c"
	}
}

static gboolean
__lambda53_ (Background* self)
{
	gboolean result;
#line 603 "../src/background.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 604 "../src/background.vala"
	result = FALSE;
#line 604 "../src/background.vala"
	return result;
#line 3226 "background.c"
}

static gboolean
___lambda53__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda53_ ((Background*) self);
#line 602 "../src/background.vala"
	return result;
#line 3236 "background.c"
}

static void
background_synchronized_redraw (Background* self)
{
#line 599 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 602 "../src/background.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10, ___lambda53__gsource_func, g_object_ref (self), g_object_unref);
#line 3246 "background.c"
}

static void
background_real_size_allocate (GtkWidget* base,
                               GtkAllocation* allocation)
{
	Background * self;
	gboolean _tmp0_ = FALSE;
	GtkAllocation _tmp1_;
	gboolean resized = FALSE;
	GtkAllocation _tmp3_;
#line 608 "../src/background.vala"
	self = (Background*) base;
#line 608 "../src/background.vala"
	g_return_if_fail (allocation != NULL);
#line 610 "../src/background.vala"
	if (!gtk_widget_get_realized ((GtkWidget*) self)) {
#line 612 "../src/background.vala"
		return;
#line 3266 "background.c"
	}
#line 615 "../src/background.vala"
	_tmp1_ = *allocation;
#line 615 "../src/background.vala"
	if (_tmp1_.height != gtk_widget_get_allocated_height ((GtkWidget*) self)) {
#line 615 "../src/background.vala"
		_tmp0_ = TRUE;
#line 3274 "background.c"
	} else {
		GtkAllocation _tmp2_;
#line 615 "../src/background.vala"
		_tmp2_ = *allocation;
#line 615 "../src/background.vala"
		_tmp0_ = _tmp2_.width != gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 3281 "background.c"
	}
#line 615 "../src/background.vala"
	resized = _tmp0_;
#line 617 "../src/background.vala"
	_tmp3_ = *allocation;
#line 617 "../src/background.vala"
	GTK_WIDGET_CLASS (background_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_fixed_get_type (), GtkFixed), &_tmp3_);
#line 620 "../src/background.vala"
	if (resized) {
#line 3291 "background.c"
		GHashTable* _tmp4_;
		BackgroundLoader* _tmp5_;
		BackgroundLoader* _tmp6_;
#line 622 "../src/background.vala"
		g_debug ("background.vala:622: Regenerating backgrounds");
#line 623 "../src/background.vala"
		_tmp4_ = self->priv->loaders;
#line 623 "../src/background.vala"
		g_hash_table_remove_all (_tmp4_);
#line 624 "../src/background.vala"
		_tmp5_ = background_load_background (self, NULL);
#line 624 "../src/background.vala"
		_tmp6_ = _tmp5_;
#line 624 "../src/background.vala"
		_g_object_unref0 (_tmp6_);
#line 625 "../src/background.vala"
		background_reload (self);
#line 3309 "background.c"
	}
}

static gboolean
background_real_draw (GtkWidget* base,
                      cairo_t* c)
{
	Background * self;
	gboolean result;
#line 629 "../src/background.vala"
	self = (Background*) base;
#line 629 "../src/background.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 631 "../src/background.vala"
	background_draw_full (self, c, self->priv->flags);
#line 632 "../src/background.vala"
	result = GTK_WIDGET_CLASS (background_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_fixed_get_type (), GtkFixed), c);
#line 632 "../src/background.vala"
	return result;
#line 3329 "background.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 646 "../src/background.vala"
	return self ? g_object_ref (self) : NULL;
#line 3337 "background.c"
}

void
background_draw_full (Background* self,
                      cairo_t* c,
                      BackgroundDrawFlags flags)
{
	gboolean _tmp0_ = FALSE;
	BackgroundLoader* _tmp1_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	BackgroundLoader* _tmp24_;
	gboolean old_painted = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	BackgroundLoader* _tmp33_;
	gboolean _tmp39_ = FALSE;
	BackgroundLoader* _tmp40_;
#line 635 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 635 "../src/background.vala"
	g_return_if_fail (c != NULL);
#line 637 "../src/background.vala"
	cairo_save (c);
#line 640 "../src/background.vala"
	_tmp1_ = self->priv->current;
#line 640 "../src/background.vala"
	if (_tmp1_ == NULL) {
#line 640 "../src/background.vala"
		_tmp0_ = TRUE;
#line 3368 "background.c"
	} else {
		gboolean _tmp2_ = FALSE;
		BackgroundLoader* _tmp3_;
#line 640 "../src/background.vala"
		_tmp3_ = self->priv->current;
#line 640 "../src/background.vala"
		if (background_loader_load (_tmp3_)) {
#line 3376 "background.c"
			BackgroundLoader* _tmp4_;
			cairo_pattern_t** _tmp5_;
			gint _tmp5__length1;
			cairo_pattern_t* _tmp6_;
#line 640 "../src/background.vala"
			_tmp4_ = self->priv->current;
#line 640 "../src/background.vala"
			_tmp5_ = _tmp4_->patterns;
#line 640 "../src/background.vala"
			_tmp5__length1 = _tmp4_->patterns_length1;
#line 640 "../src/background.vala"
			_tmp6_ = _tmp5_[0];
#line 640 "../src/background.vala"
			_tmp2_ = _tmp6_ == NULL;
#line 3391 "background.c"
		} else {
#line 640 "../src/background.vala"
			_tmp2_ = FALSE;
#line 3395 "background.c"
		}
#line 640 "../src/background.vala"
		_tmp0_ = _tmp2_;
#line 3399 "background.c"
	}
#line 640 "../src/background.vala"
	if (_tmp0_) {
#line 3403 "background.c"
		BackgroundLoader* new_background = NULL;
		BackgroundLoader* _tmp7_;
		BackgroundLoader* _tmp8_;
		BackgroundLoader* _tmp16_;
		BackgroundLoader* _tmp17_;
		BackgroundLoader* _tmp20_;
		BackgroundLoader* _tmp21_;
#line 644 "../src/background.vala"
		_tmp7_ = background_load_background (self, NULL);
#line 644 "../src/background.vala"
		new_background = _tmp7_;
#line 645 "../src/background.vala"
		_tmp8_ = self->priv->current;
#line 645 "../src/background.vala"
		if (_tmp8_ != NULL) {
#line 3419 "background.c"
			GHashTable* _tmp9_;
			BackgroundLoader* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			BackgroundLoader* _tmp14_;
			BackgroundLoader* _tmp15_;
#line 646 "../src/background.vala"
			_tmp9_ = self->priv->loaders;
#line 646 "../src/background.vala"
			_tmp10_ = self->priv->current;
#line 646 "../src/background.vala"
			_tmp11_ = background_loader_get_filename (_tmp10_);
#line 646 "../src/background.vala"
			_tmp12_ = _tmp11_;
#line 646 "../src/background.vala"
			_tmp13_ = g_strdup (_tmp12_);
#line 646 "../src/background.vala"
			_tmp14_ = new_background;
#line 646 "../src/background.vala"
			_tmp15_ = _g_object_ref0 (_tmp14_);
#line 646 "../src/background.vala"
			g_hash_table_insert (_tmp9_, _tmp13_, _tmp15_);
#line 3443 "background.c"
		}
#line 647 "../src/background.vala"
		_tmp16_ = self->priv->old;
#line 647 "../src/background.vala"
		_tmp17_ = self->priv->current;
#line 647 "../src/background.vala"
		if (_tmp16_ == _tmp17_) {
#line 3451 "background.c"
			BackgroundLoader* _tmp18_;
			BackgroundLoader* _tmp19_;
#line 648 "../src/background.vala"
			_tmp18_ = new_background;
#line 648 "../src/background.vala"
			_tmp19_ = _g_object_ref0 (_tmp18_);
#line 648 "../src/background.vala"
			_g_object_unref0 (self->priv->old);
#line 648 "../src/background.vala"
			self->priv->old = _tmp19_;
#line 3462 "background.c"
		}
#line 649 "../src/background.vala"
		_tmp20_ = new_background;
#line 649 "../src/background.vala"
		_tmp21_ = _g_object_ref0 (_tmp20_);
#line 649 "../src/background.vala"
		_g_object_unref0 (self->priv->current);
#line 649 "../src/background.vala"
		self->priv->current = _tmp21_;
#line 650 "../src/background.vala"
		background_publish_average_color (self);
#line 640 "../src/background.vala"
		_g_object_unref0 (new_background);
#line 3476 "background.c"
	}
#line 654 "../src/background.vala"
	_tmp24_ = self->priv->current;
#line 654 "../src/background.vala"
	if (background_loader_load (_tmp24_)) {
#line 3482 "background.c"
		BackgroundLoader* _tmp25_;
		BackgroundLoader* _tmp26_;
#line 654 "../src/background.vala"
		_tmp25_ = self->priv->current;
#line 654 "../src/background.vala"
		_tmp26_ = self->priv->old;
#line 654 "../src/background.vala"
		_tmp23_ = _tmp25_ != _tmp26_;
#line 3491 "background.c"
	} else {
#line 654 "../src/background.vala"
		_tmp23_ = FALSE;
#line 3495 "background.c"
	}
#line 654 "../src/background.vala"
	if (_tmp23_) {
#line 3499 "background.c"
		AnimateTimer* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
#line 654 "../src/background.vala"
		_tmp27_ = self->priv->timer;
#line 654 "../src/background.vala"
		_tmp28_ = animate_timer_get_is_running (_tmp27_);
#line 654 "../src/background.vala"
		_tmp29_ = _tmp28_;
#line 654 "../src/background.vala"
		_tmp22_ = !_tmp29_;
#line 3511 "background.c"
	} else {
#line 654 "../src/background.vala"
		_tmp22_ = FALSE;
#line 3515 "background.c"
	}
#line 654 "../src/background.vala"
	if (_tmp22_) {
#line 3519 "background.c"
		AnimateTimer* _tmp30_;
#line 656 "../src/background.vala"
		background_set_alpha (self, 0.0);
#line 657 "../src/background.vala"
		_tmp30_ = self->priv->timer;
#line 657 "../src/background.vala"
		animate_timer_reset (_tmp30_, -1);
#line 3527 "background.c"
	}
#line 660 "../src/background.vala"
	cairo_set_source_rgba (c, 0.0, 0.0, 0.0, 0.0);
#line 661 "../src/background.vala"
	old_painted = FALSE;
#line 664 "../src/background.vala"
	_tmp33_ = self->priv->old;
#line 664 "../src/background.vala"
	if (_tmp33_ != NULL) {
#line 3537 "background.c"
		BackgroundLoader* _tmp34_;
#line 664 "../src/background.vala"
		_tmp34_ = self->priv->old;
#line 664 "../src/background.vala"
		_tmp32_ = background_loader_load (_tmp34_);
#line 3543 "background.c"
	} else {
#line 664 "../src/background.vala"
		_tmp32_ = FALSE;
#line 3547 "background.c"
	}
#line 664 "../src/background.vala"
	if (_tmp32_) {
#line 3551 "background.c"
		gboolean _tmp35_ = FALSE;
		gdouble _tmp36_;
#line 664 "../src/background.vala"
		_tmp36_ = self->priv->_alpha;
#line 664 "../src/background.vala"
		if (_tmp36_ < 1.0) {
#line 664 "../src/background.vala"
			_tmp35_ = TRUE;
#line 3560 "background.c"
		} else {
			BackgroundLoader* _tmp37_;
#line 664 "../src/background.vala"
			_tmp37_ = self->priv->current;
#line 664 "../src/background.vala"
			_tmp35_ = !background_loader_load (_tmp37_);
#line 3567 "background.c"
		}
#line 664 "../src/background.vala"
		_tmp31_ = _tmp35_;
#line 3571 "background.c"
	} else {
#line 664 "../src/background.vala"
		_tmp31_ = FALSE;
#line 3575 "background.c"
	}
#line 664 "../src/background.vala"
	if (_tmp31_) {
#line 3579 "background.c"
		BackgroundLoader* _tmp38_;
#line 666 "../src/background.vala"
		_tmp38_ = self->priv->old;
#line 666 "../src/background.vala"
		background_draw_background (self, c, _tmp38_, 1.0);
#line 667 "../src/background.vala"
		old_painted = TRUE;
#line 3587 "background.c"
	}
#line 671 "../src/background.vala"
	_tmp40_ = self->priv->current;
#line 671 "../src/background.vala"
	if (background_loader_load (_tmp40_)) {
#line 3593 "background.c"
		gdouble _tmp41_;
#line 671 "../src/background.vala"
		_tmp41_ = self->priv->_alpha;
#line 671 "../src/background.vala"
		_tmp39_ = _tmp41_ > 0.0;
#line 3599 "background.c"
	} else {
#line 671 "../src/background.vala"
		_tmp39_ = FALSE;
#line 3603 "background.c"
	}
#line 671 "../src/background.vala"
	if (_tmp39_) {
#line 3607 "background.c"
		gdouble _tmp42_ = 0.0;
		BackgroundLoader* _tmp44_;
#line 672 "../src/background.vala"
		if (old_painted) {
#line 3612 "background.c"
			gdouble _tmp43_;
#line 672 "../src/background.vala"
			_tmp43_ = self->priv->_alpha;
#line 672 "../src/background.vala"
			_tmp42_ = _tmp43_;
#line 3618 "background.c"
		} else {
#line 672 "../src/background.vala"
			_tmp42_ = 1.0;
#line 3622 "background.c"
		}
#line 672 "../src/background.vala"
		_tmp44_ = self->priv->current;
#line 672 "../src/background.vala"
		background_draw_background (self, c, _tmp44_, _tmp42_);
#line 3628 "background.c"
	}
#line 674 "../src/background.vala"
	cairo_restore (c);
#line 676 "../src/background.vala"
	if ((flags & BACKGROUND_DRAW_FLAGS_GRID) == BACKGROUND_DRAW_FLAGS_GRID) {
#line 677 "../src/background.vala"
		background_overlay_grid (self, c);
#line 3636 "background.c"
	}
}

static void
background_draw_background (Background* self,
                            cairo_t* c,
                            BackgroundLoader* background,
                            gdouble alpha)
{
	GList* _tmp0_;
#line 680 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 680 "../src/background.vala"
	g_return_if_fail (c != NULL);
#line 680 "../src/background.vala"
	g_return_if_fail (background != NULL);
#line 682 "../src/background.vala"
	_tmp0_ = self->priv->monitors;
#line 3655 "background.c"
	{
		GList* monitor_collection = NULL;
		GList* monitor_it = NULL;
#line 682 "../src/background.vala"
		monitor_collection = _tmp0_;
#line 682 "../src/background.vala"
		for (monitor_it = monitor_collection; monitor_it != NULL; monitor_it = monitor_it->next) {
#line 3663 "background.c"
			Monitor* _tmp1_;
			Monitor* monitor = NULL;
#line 682 "../src/background.vala"
			_tmp1_ = _monitor_ref0 ((Monitor*) monitor_it->data);
#line 682 "../src/background.vala"
			monitor = _tmp1_;
#line 3670 "background.c"
			{
				cairo_pattern_t* pattern = NULL;
				cairo_matrix_t matrix = {0};
				cairo_pattern_t* _tmp8_;
				cairo_pattern_t* _tmp9_;
				cairo_matrix_t _tmp10_;
				cairo_pattern_t* _tmp11_;
				Monitor* _tmp12_;
				Monitor* _tmp13_;
				Monitor* _tmp14_;
				Monitor* _tmp15_;
				gboolean _tmp16_ = FALSE;
				Monitor* _tmp17_;
				Monitor* _tmp18_;
#line 685 "../src/background.vala"
				cairo_matrix_init_identity (&matrix);
#line 686 "../src/background.vala"
				if ((self->priv->flags & BACKGROUND_DRAW_FLAGS_SPAN) == BACKGROUND_DRAW_FLAGS_SPAN) {
#line 3689 "background.c"
					cairo_pattern_t* _tmp2_;
#line 688 "../src/background.vala"
					_tmp2_ = background_loader_get_pattern (background, self->priv->_width, self->priv->_height);
#line 688 "../src/background.vala"
					_cairo_pattern_destroy0 (pattern);
#line 688 "../src/background.vala"
					pattern = _tmp2_;
#line 3697 "background.c"
				} else {
					Monitor* _tmp3_;
					Monitor* _tmp4_;
					cairo_pattern_t* _tmp5_;
					Monitor* _tmp6_;
					Monitor* _tmp7_;
#line 692 "../src/background.vala"
					_tmp3_ = monitor;
#line 692 "../src/background.vala"
					_tmp4_ = monitor;
#line 692 "../src/background.vala"
					_tmp5_ = background_loader_get_pattern (background, _tmp3_->width, _tmp4_->height);
#line 692 "../src/background.vala"
					_cairo_pattern_destroy0 (pattern);
#line 692 "../src/background.vala"
					pattern = _tmp5_;
#line 693 "../src/background.vala"
					_tmp6_ = monitor;
#line 693 "../src/background.vala"
					_tmp7_ = monitor;
#line 693 "../src/background.vala"
					cairo_matrix_translate (&matrix, (gdouble) (-_tmp6_->x), (gdouble) (-_tmp7_->y));
#line 3720 "background.c"
				}
#line 696 "../src/background.vala"
				_tmp8_ = pattern;
#line 696 "../src/background.vala"
				if (_tmp8_ == NULL) {
#line 697 "../src/background.vala"
					_cairo_pattern_destroy0 (pattern);
#line 697 "../src/background.vala"
					_monitor_unref0 (monitor);
#line 697 "../src/background.vala"
					continue;
#line 3732 "background.c"
				}
#line 699 "../src/background.vala"
				cairo_save (c);
#line 700 "../src/background.vala"
				_tmp9_ = pattern;
#line 700 "../src/background.vala"
				_tmp10_ = matrix;
#line 700 "../src/background.vala"
				cairo_pattern_set_matrix (_tmp9_, &_tmp10_);
#line 701 "../src/background.vala"
				_tmp11_ = pattern;
#line 701 "../src/background.vala"
				cairo_set_source (c, _tmp11_);
#line 702 "../src/background.vala"
				_tmp12_ = monitor;
#line 702 "../src/background.vala"
				_tmp13_ = monitor;
#line 702 "../src/background.vala"
				_tmp14_ = monitor;
#line 702 "../src/background.vala"
				_tmp15_ = monitor;
#line 702 "../src/background.vala"
				cairo_rectangle (c, (gdouble) _tmp12_->x, (gdouble) _tmp13_->y, (gdouble) _tmp14_->width, (gdouble) _tmp15_->height);
#line 703 "../src/background.vala"
				cairo_clip (c);
#line 704 "../src/background.vala"
				cairo_paint_with_alpha (c, alpha);
#line 705 "../src/background.vala"
				cairo_restore (c);
#line 707 "../src/background.vala"
				_tmp17_ = monitor;
#line 707 "../src/background.vala"
				_tmp18_ = self->priv->active_monitor;
#line 707 "../src/background.vala"
				if (_tmp17_ != _tmp18_) {
#line 3768 "background.c"
					cairo_surface_t* _tmp19_;
#line 707 "../src/background.vala"
					_tmp19_ = self->priv->other_monitors_logo_surface;
#line 707 "../src/background.vala"
					_tmp16_ = _tmp19_ != NULL;
#line 3774 "background.c"
				} else {
#line 707 "../src/background.vala"
					_tmp16_ = FALSE;
#line 3778 "background.c"
				}
#line 707 "../src/background.vala"
				if (_tmp16_) {
#line 3782 "background.c"
					gint width = 0;
					gint height = 0;
					cairo_surface_t* _tmp20_;
					cairo_pattern_t* _tmp21_;
					gint x = 0;
					Monitor* _tmp22_;
					Monitor* _tmp23_;
					gint y = 0;
					Monitor* _tmp24_;
					Monitor* _tmp25_;
					cairo_pattern_t* _tmp26_;
					cairo_matrix_t _tmp27_;
					cairo_pattern_t* _tmp28_;
#line 709 "../src/background.vala"
					width = self->priv->other_monitors_logo_width;
#line 710 "../src/background.vala"
					height = self->priv->other_monitors_logo_height;
#line 712 "../src/background.vala"
					cairo_save (c);
#line 713 "../src/background.vala"
					_tmp20_ = self->priv->other_monitors_logo_surface;
#line 713 "../src/background.vala"
					_tmp21_ = cairo_pattern_create_for_surface (_tmp20_);
#line 713 "../src/background.vala"
					_cairo_pattern_destroy0 (pattern);
#line 713 "../src/background.vala"
					pattern = _tmp21_;
#line 714 "../src/background.vala"
					cairo_matrix_init_identity (&matrix);
#line 715 "../src/background.vala"
					_tmp22_ = monitor;
#line 715 "../src/background.vala"
					_tmp23_ = monitor;
#line 715 "../src/background.vala"
					x = _tmp22_->x + ((_tmp23_->width - width) / 2);
#line 716 "../src/background.vala"
					_tmp24_ = monitor;
#line 716 "../src/background.vala"
					_tmp25_ = monitor;
#line 716 "../src/background.vala"
					y = _tmp24_->y + ((_tmp25_->height - height) / 2);
#line 717 "../src/background.vala"
					cairo_matrix_translate (&matrix, (gdouble) (-x), (gdouble) (-y));
#line 718 "../src/background.vala"
					_tmp26_ = pattern;
#line 718 "../src/background.vala"
					_tmp27_ = matrix;
#line 718 "../src/background.vala"
					cairo_pattern_set_matrix (_tmp26_, &_tmp27_);
#line 719 "../src/background.vala"
					_tmp28_ = pattern;
#line 719 "../src/background.vala"
					cairo_set_source (c, _tmp28_);
#line 720 "../src/background.vala"
					cairo_rectangle (c, (gdouble) x, (gdouble) y, (gdouble) width, (gdouble) height);
#line 721 "../src/background.vala"
					cairo_clip (c);
#line 722 "../src/background.vala"
					cairo_paint_with_alpha (c, alpha);
#line 723 "../src/background.vala"
					cairo_restore (c);
#line 3844 "background.c"
				}
#line 682 "../src/background.vala"
				_cairo_pattern_destroy0 (pattern);
#line 682 "../src/background.vala"
				_monitor_unref0 (monitor);
#line 3850 "background.c"
			}
		}
	}
}

static void
background_animate_cb (Background* self,
                       gdouble progress)
{
	gdouble _tmp0_;
#line 728 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 730 "../src/background.vala"
	background_set_alpha (self, progress);
#line 731 "../src/background.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 734 "../src/background.vala"
	_tmp0_ = self->priv->_alpha;
#line 734 "../src/background.vala"
	if (_tmp0_ >= 1.0) {
#line 3871 "background.c"
		BackgroundLoader* _tmp1_;
		BackgroundLoader* _tmp2_;
#line 735 "../src/background.vala"
		_tmp1_ = self->priv->current;
#line 735 "../src/background.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 735 "../src/background.vala"
		_g_object_unref0 (self->priv->old);
#line 735 "../src/background.vala"
		self->priv->old = _tmp2_;
#line 3882 "background.c"
	}
}

static void
background_reload (Background* self)
{
#line 738 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 740 "../src/background.vala"
	if (gtk_widget_get_realized ((GtkWidget*) self)) {
#line 3893 "background.c"
		BackgroundLoader* new_background = NULL;
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		BackgroundLoader* _tmp2_;
		BackgroundLoader* _tmp3_;
		BackgroundLoader* _tmp4_;
#line 742 "../src/background.vala"
		_tmp0_ = background_get_current_background (self);
#line 742 "../src/background.vala"
		_tmp1_ = _tmp0_;
#line 742 "../src/background.vala"
		_tmp2_ = background_load_background (self, _tmp1_);
#line 742 "../src/background.vala"
		new_background = _tmp2_;
#line 744 "../src/background.vala"
		_tmp3_ = self->priv->current;
#line 744 "../src/background.vala"
		_tmp4_ = new_background;
#line 744 "../src/background.vala"
		if (_tmp3_ != _tmp4_) {
#line 3914 "background.c"
			BackgroundLoader* _tmp5_;
			BackgroundLoader* _tmp6_;
			BackgroundLoader* _tmp7_;
			BackgroundLoader* _tmp8_;
			AnimateTimer* _tmp9_;
#line 746 "../src/background.vala"
			_tmp5_ = self->priv->current;
#line 746 "../src/background.vala"
			_tmp6_ = _g_object_ref0 (_tmp5_);
#line 746 "../src/background.vala"
			_g_object_unref0 (self->priv->old);
#line 746 "../src/background.vala"
			self->priv->old = _tmp6_;
#line 747 "../src/background.vala"
			_tmp7_ = new_background;
#line 747 "../src/background.vala"
			_tmp8_ = _g_object_ref0 (_tmp7_);
#line 747 "../src/background.vala"
			_g_object_unref0 (self->priv->current);
#line 747 "../src/background.vala"
			self->priv->current = _tmp8_;
#line 748 "../src/background.vala"
			background_set_alpha (self, 1.0);
#line 749 "../src/background.vala"
			_tmp9_ = self->priv->timer;
#line 749 "../src/background.vala"
			animate_timer_stop (_tmp9_);
#line 3942 "background.c"
		}
#line 752 "../src/background.vala"
		gtk_widget_queue_draw ((GtkWidget*) self);
#line 753 "../src/background.vala"
		background_publish_average_color (self);
#line 740 "../src/background.vala"
		_g_object_unref0 (new_background);
#line 3950 "background.c"
	}
}

static void
___lambda4_ (Background* self)
{
#line 810 "../src/background.vala"
	background_reload (self);
#line 3959 "background.c"
}

static void
____lambda4__background_loader_loaded (BackgroundLoader* _sender,
                                       gpointer self)
{
#line 810 "../src/background.vala"
	___lambda4_ ((Background*) self);
#line 3968 "background.c"
}

static BackgroundLoader*
background_load_background (Background* self,
                            const gchar* filename)
{
	BackgroundLoader* b = NULL;
	GHashTable* _tmp12_;
	gconstpointer _tmp13_;
	BackgroundLoader* _tmp14_;
	BackgroundLoader* _tmp15_;
	GError* _inner_error0_ = NULL;
	BackgroundLoader* result;
#line 757 "../src/background.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 759 "../src/background.vala"
	if (filename == NULL) {
#line 3986 "background.c"
		const gchar* _tmp0_;
		const gchar* _tmp1_;
#line 761 "../src/background.vala"
		_tmp0_ = background_get_fallback_color (self);
#line 761 "../src/background.vala"
		_tmp1_ = _tmp0_;
#line 761 "../src/background.vala"
		filename = _tmp1_;
#line 3995 "background.c"
	} else {
		{
			GFile* file = NULL;
			GFile* _tmp2_;
			GFileInfo* fileInfo = NULL;
			GFile* _tmp3_;
			GFileInfo* _tmp4_;
			GFileInfo* _tmp5_;
#line 766 "../src/background.vala"
			_tmp2_ = g_file_new_for_path (filename);
#line 766 "../src/background.vala"
			file = _tmp2_;
#line 767 "../src/background.vala"
			_tmp3_ = file;
#line 767 "../src/background.vala"
			_tmp4_ = g_file_query_info (_tmp3_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
#line 767 "../src/background.vala"
			fileInfo = _tmp4_;
#line 767 "../src/background.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 767 "../src/background.vala"
				_g_object_unref0 (file);
#line 4018 "background.c"
				goto __catch0_g_error;
			}
#line 768 "../src/background.vala"
			_tmp5_ = fileInfo;
#line 768 "../src/background.vala"
			if (!g_file_info_get_attribute_boolean (_tmp5_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
#line 4025 "background.c"
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
#line 770 "../src/background.vala"
				_tmp6_ = background_get_system_background (self);
#line 770 "../src/background.vala"
				_tmp7_ = _tmp6_;
#line 770 "../src/background.vala"
				g_debug ("background.vala:770: Can't read background file %s, falling back to %s", filename, _tmp7_);
#line 771 "../src/background.vala"
				_tmp8_ = background_get_system_background (self);
#line 771 "../src/background.vala"
				_tmp9_ = _tmp8_;
#line 771 "../src/background.vala"
				filename = _tmp9_;
#line 4042 "background.c"
			}
#line 764 "../src/background.vala"
			_g_object_unref0 (fileInfo);
#line 764 "../src/background.vala"
			_g_object_unref0 (file);
#line 4048 "background.c"
		}
		goto __finally0;
		__catch0_g_error:
		{
			const gchar* _tmp10_;
			const gchar* _tmp11_;
#line 764 "../src/background.vala"
			g_clear_error (&_inner_error0_);
#line 776 "../src/background.vala"
			_tmp10_ = background_get_system_background (self);
#line 776 "../src/background.vala"
			_tmp11_ = _tmp10_;
#line 776 "../src/background.vala"
			filename = _tmp11_;
#line 4063 "background.c"
		}
		__finally0:
#line 764 "../src/background.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 764 "../src/background.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 764 "../src/background.vala"
			g_clear_error (&_inner_error0_);
#line 764 "../src/background.vala"
			return NULL;
#line 4074 "background.c"
		}
	}
#line 780 "../src/background.vala"
	_tmp12_ = self->priv->loaders;
#line 780 "../src/background.vala"
	_tmp13_ = g_hash_table_lookup (_tmp12_, filename);
#line 780 "../src/background.vala"
	_tmp14_ = _g_object_ref0 ((BackgroundLoader*) _tmp13_);
#line 780 "../src/background.vala"
	b = _tmp14_;
#line 781 "../src/background.vala"
	_tmp15_ = b;
#line 781 "../src/background.vala"
	if (_tmp15_ == NULL) {
#line 4089 "background.c"
		gint* widths = NULL;
		GList* _tmp16_;
		gint* _tmp17_;
		gint widths_length1;
		gint _widths_size_;
		gint* heights = NULL;
		GList* _tmp18_;
		gint* _tmp19_;
		gint heights_length1;
		gint _heights_size_;
		gint n_sizes = 0;
		gint _tmp31_;
		gint _tmp32_;
		cairo_surface_t* _tmp33_;
		gint* _tmp34_;
		gint _tmp34__length1;
		gint* _tmp35_;
		gint _tmp35__length1;
		BackgroundLoader* _tmp36_;
		BackgroundLoader* _tmp37_;
		cairo_surface_t* _tmp38_;
		BackgroundLoader* _tmp39_;
		BackgroundLoader* _tmp40_;
		GHashTable* _tmp41_;
		gchar* _tmp42_;
		BackgroundLoader* _tmp43_;
		BackgroundLoader* _tmp44_;
#line 784 "../src/background.vala"
		_tmp16_ = self->priv->monitors;
#line 784 "../src/background.vala"
		_tmp17_ = g_new0 (gint, g_list_length (_tmp16_));
#line 784 "../src/background.vala"
		widths = _tmp17_;
#line 784 "../src/background.vala"
		widths_length1 = g_list_length (_tmp16_);
#line 784 "../src/background.vala"
		_widths_size_ = widths_length1;
#line 785 "../src/background.vala"
		_tmp18_ = self->priv->monitors;
#line 785 "../src/background.vala"
		_tmp19_ = g_new0 (gint, g_list_length (_tmp18_));
#line 785 "../src/background.vala"
		heights = _tmp19_;
#line 785 "../src/background.vala"
		heights_length1 = g_list_length (_tmp18_);
#line 785 "../src/background.vala"
		_heights_size_ = heights_length1;
#line 786 "../src/background.vala"
		n_sizes = 0;
#line 787 "../src/background.vala"
		if ((self->priv->flags & BACKGROUND_DRAW_FLAGS_SPAN) == BACKGROUND_DRAW_FLAGS_SPAN) {
#line 4141 "background.c"
			gint* _tmp20_;
			gint _tmp20__length1;
			gint* _tmp21_;
			gint _tmp21__length1;
			gint _tmp22_;
#line 789 "../src/background.vala"
			_tmp20_ = widths;
#line 789 "../src/background.vala"
			_tmp20__length1 = widths_length1;
#line 789 "../src/background.vala"
			_tmp20_[n_sizes] = self->priv->_width;
#line 790 "../src/background.vala"
			_tmp21_ = heights;
#line 790 "../src/background.vala"
			_tmp21__length1 = heights_length1;
#line 790 "../src/background.vala"
			_tmp21_[n_sizes] = self->priv->_height;
#line 791 "../src/background.vala"
			_tmp22_ = n_sizes;
#line 791 "../src/background.vala"
			n_sizes = _tmp22_ + 1;
#line 4163 "background.c"
		} else {
			GList* _tmp23_;
#line 795 "../src/background.vala"
			_tmp23_ = self->priv->monitors;
#line 4168 "background.c"
			{
				GList* monitor_collection = NULL;
				GList* monitor_it = NULL;
#line 795 "../src/background.vala"
				monitor_collection = _tmp23_;
#line 795 "../src/background.vala"
				for (monitor_it = monitor_collection; monitor_it != NULL; monitor_it = monitor_it->next) {
#line 4176 "background.c"
					Monitor* _tmp24_;
					Monitor* monitor = NULL;
#line 795 "../src/background.vala"
					_tmp24_ = _monitor_ref0 ((Monitor*) monitor_it->data);
#line 795 "../src/background.vala"
					monitor = _tmp24_;
#line 4183 "background.c"
					{
						Monitor* _tmp25_;
#line 797 "../src/background.vala"
						_tmp25_ = monitor;
#line 797 "../src/background.vala"
						if (background_monitor_is_unique_size (self, _tmp25_)) {
#line 4190 "background.c"
							gint* _tmp26_;
							gint _tmp26__length1;
							Monitor* _tmp27_;
							gint* _tmp28_;
							gint _tmp28__length1;
							Monitor* _tmp29_;
							gint _tmp30_;
#line 799 "../src/background.vala"
							_tmp26_ = widths;
#line 799 "../src/background.vala"
							_tmp26__length1 = widths_length1;
#line 799 "../src/background.vala"
							_tmp27_ = monitor;
#line 799 "../src/background.vala"
							_tmp26_[n_sizes] = _tmp27_->width;
#line 800 "../src/background.vala"
							_tmp28_ = heights;
#line 800 "../src/background.vala"
							_tmp28__length1 = heights_length1;
#line 800 "../src/background.vala"
							_tmp29_ = monitor;
#line 800 "../src/background.vala"
							_tmp28_[n_sizes] = _tmp29_->height;
#line 801 "../src/background.vala"
							_tmp30_ = n_sizes;
#line 801 "../src/background.vala"
							n_sizes = _tmp30_ + 1;
#line 4218 "background.c"
						}
#line 795 "../src/background.vala"
						_monitor_unref0 (monitor);
#line 4222 "background.c"
					}
				}
			}
		}
#line 805 "../src/background.vala"
		_tmp31_ = n_sizes;
#line 805 "../src/background.vala"
		widths = g_renew (gint, widths, n_sizes);
#line 805 "../src/background.vala"
		(_tmp31_ > widths_length1) ? memset (widths + widths_length1, 0, sizeof (gint) * (_tmp31_ - widths_length1)) : NULL;
#line 805 "../src/background.vala"
		widths_length1 = _tmp31_;
#line 805 "../src/background.vala"
		_widths_size_ = _tmp31_;
#line 806 "../src/background.vala"
		_tmp32_ = n_sizes;
#line 806 "../src/background.vala"
		heights = g_renew (gint, heights, n_sizes);
#line 806 "../src/background.vala"
		(_tmp32_ > heights_length1) ? memset (heights + heights_length1, 0, sizeof (gint) * (_tmp32_ - heights_length1)) : NULL;
#line 806 "../src/background.vala"
		heights_length1 = _tmp32_;
#line 806 "../src/background.vala"
		_heights_size_ = _tmp32_;
#line 808 "../src/background.vala"
		_tmp33_ = self->priv->target_surface;
#line 808 "../src/background.vala"
		_tmp34_ = widths;
#line 808 "../src/background.vala"
		_tmp34__length1 = widths_length1;
#line 808 "../src/background.vala"
		_tmp35_ = heights;
#line 808 "../src/background.vala"
		_tmp35__length1 = heights_length1;
#line 808 "../src/background.vala"
		_tmp36_ = background_loader_new (_tmp33_, filename, _tmp34_, _tmp34__length1, _tmp35_, _tmp35__length1);
#line 808 "../src/background.vala"
		_g_object_unref0 (b);
#line 808 "../src/background.vala"
		b = _tmp36_;
#line 809 "../src/background.vala"
		_tmp37_ = b;
#line 809 "../src/background.vala"
		_tmp38_ = self->priv->version_logo_surface;
#line 809 "../src/background.vala"
		background_loader_set_logo (_tmp37_, _tmp38_);
#line 810 "../src/background.vala"
		_tmp39_ = b;
#line 810 "../src/background.vala"
		g_signal_connect_object (_tmp39_, "loaded", (GCallback) ____lambda4__background_loader_loaded, self, 0);
#line 811 "../src/background.vala"
		_tmp40_ = b;
#line 811 "../src/background.vala"
		background_loader_load (_tmp40_);
#line 812 "../src/background.vala"
		_tmp41_ = self->priv->loaders;
#line 812 "../src/background.vala"
		_tmp42_ = g_strdup (filename);
#line 812 "../src/background.vala"
		_tmp43_ = b;
#line 812 "../src/background.vala"
		_tmp44_ = _g_object_ref0 (_tmp43_);
#line 812 "../src/background.vala"
		g_hash_table_insert (_tmp41_, _tmp42_, _tmp44_);
#line 781 "../src/background.vala"
		heights = (g_free (heights), NULL);
#line 781 "../src/background.vala"
		widths = (g_free (widths), NULL);
#line 4291 "background.c"
	}
#line 815 "../src/background.vala"
	result = b;
#line 815 "../src/background.vala"
	return result;
#line 4297 "background.c"
}

static gboolean
background_monitor_is_unique_size (Background* self,
                                   Monitor* monitor)
{
	GList* _tmp0_;
	gboolean result;
#line 819 "../src/background.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 819 "../src/background.vala"
	g_return_val_if_fail (monitor != NULL, FALSE);
#line 821 "../src/background.vala"
	_tmp0_ = self->priv->monitors;
#line 4312 "background.c"
	{
		GList* m_collection = NULL;
		GList* m_it = NULL;
#line 821 "../src/background.vala"
		m_collection = _tmp0_;
#line 821 "../src/background.vala"
		for (m_it = m_collection; m_it != NULL; m_it = m_it->next) {
#line 4320 "background.c"
			Monitor* _tmp1_;
			Monitor* m = NULL;
#line 821 "../src/background.vala"
			_tmp1_ = _monitor_ref0 ((Monitor*) m_it->data);
#line 821 "../src/background.vala"
			m = _tmp1_;
#line 4327 "background.c"
			{
				Monitor* _tmp2_;
#line 823 "../src/background.vala"
				_tmp2_ = m;
#line 823 "../src/background.vala"
				if (_tmp2_ == monitor) {
#line 824 "../src/background.vala"
					_monitor_unref0 (m);
#line 824 "../src/background.vala"
					break;
#line 4338 "background.c"
				} else {
					gboolean _tmp3_ = FALSE;
					Monitor* _tmp4_;
#line 825 "../src/background.vala"
					_tmp4_ = m;
#line 825 "../src/background.vala"
					if (_tmp4_->width == monitor->width) {
#line 4346 "background.c"
						Monitor* _tmp5_;
#line 825 "../src/background.vala"
						_tmp5_ = m;
#line 825 "../src/background.vala"
						_tmp3_ = _tmp5_->height == monitor->height;
#line 4352 "background.c"
					} else {
#line 825 "../src/background.vala"
						_tmp3_ = FALSE;
#line 4356 "background.c"
					}
#line 825 "../src/background.vala"
					if (_tmp3_) {
#line 826 "../src/background.vala"
						result = FALSE;
#line 826 "../src/background.vala"
						_monitor_unref0 (m);
#line 826 "../src/background.vala"
						return result;
#line 4366 "background.c"
					}
				}
#line 821 "../src/background.vala"
				_monitor_unref0 (m);
#line 4371 "background.c"
			}
		}
	}
#line 829 "../src/background.vala"
	result = TRUE;
#line 829 "../src/background.vala"
	return result;
#line 4379 "background.c"
}

static void
background_overlay_grid (Background* self,
                         cairo_t* c)
{
	gint width = 0;
	gint height = 0;
	gint grid_x_offset = 0;
	gint grid_y_offset = 0;
	cairo_surface_t* overlay_surface = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_t* oc = NULL;
	cairo_t* _tmp2_;
	cairo_pattern_t* overlay = NULL;
	cairo_pattern_t* _tmp3_;
	cairo_matrix_t matrix = {0};
	cairo_matrix_t _tmp4_;
#line 832 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 832 "../src/background.vala"
	g_return_if_fail (c != NULL);
#line 834 "../src/background.vala"
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 835 "../src/background.vala"
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 836 "../src/background.vala"
	grid_x_offset = get_grid_offset (width);
#line 837 "../src/background.vala"
	grid_y_offset = get_grid_offset (height);
#line 840 "../src/background.vala"
	_tmp0_ = self->priv->target_surface;
#line 840 "../src/background.vala"
	_tmp1_ = cairo_surface_create_similar (_tmp0_, CAIRO_CONTENT_COLOR_ALPHA, grid_size, grid_size);
#line 840 "../src/background.vala"
	overlay_surface = _tmp1_;
#line 841 "../src/background.vala"
	_tmp2_ = cairo_create (overlay_surface);
#line 841 "../src/background.vala"
	oc = _tmp2_;
#line 842 "../src/background.vala"
	cairo_rectangle (oc, (gdouble) 0, (gdouble) 0, (gdouble) 1, (gdouble) 1);
#line 843 "../src/background.vala"
	cairo_rectangle (oc, (gdouble) (grid_size - 1), (gdouble) 0, (gdouble) 1, (gdouble) 1);
#line 844 "../src/background.vala"
	cairo_rectangle (oc, (gdouble) 0, (gdouble) (grid_size - 1), (gdouble) 1, (gdouble) 1);
#line 845 "../src/background.vala"
	cairo_rectangle (oc, (gdouble) (grid_size - 1), (gdouble) (grid_size - 1), (gdouble) 1, (gdouble) 1);
#line 846 "../src/background.vala"
	cairo_set_source_rgba (oc, 1.0, 1.0, 1.0, 0.25);
#line 847 "../src/background.vala"
	cairo_fill (oc);
#line 848 "../src/background.vala"
	_tmp3_ = cairo_pattern_create_for_surface (overlay_surface);
#line 848 "../src/background.vala"
	overlay = _tmp3_;
#line 849 "../src/background.vala"
	cairo_matrix_init_identity (&matrix);
#line 850 "../src/background.vala"
	cairo_matrix_translate (&matrix, (gdouble) (-grid_x_offset), (gdouble) (-grid_y_offset));
#line 851 "../src/background.vala"
	_tmp4_ = matrix;
#line 851 "../src/background.vala"
	cairo_pattern_set_matrix (overlay, &_tmp4_);
#line 852 "../src/background.vala"
	cairo_pattern_set_extend (overlay, CAIRO_EXTEND_REPEAT);
#line 855 "../src/background.vala"
	cairo_save (c);
#line 856 "../src/background.vala"
	cairo_set_source (c, overlay);
#line 857 "../src/background.vala"
	cairo_rectangle (c, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
#line 858 "../src/background.vala"
	cairo_fill (c);
#line 859 "../src/background.vala"
	cairo_restore (c);
#line 832 "../src/background.vala"
	_cairo_pattern_destroy0 (overlay);
#line 832 "../src/background.vala"
	_cairo_destroy0 (oc);
#line 832 "../src/background.vala"
	_cairo_surface_destroy0 (overlay_surface);
#line 4463 "background.c"
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1609 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1610 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1610 "glib-2.0.vapi"
	res_length1 = -1;
#line 1610 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1611 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1611 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1611 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1612 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1612 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1612 "glib-2.0.vapi"
	if (result_length1) {
#line 1612 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 4500 "background.c"
	}
#line 1612 "glib-2.0.vapi"
	result = _tmp2_;
#line 1612 "glib-2.0.vapi"
	return result;
#line 4506 "background.c"
}

static void
background_publish_average_color (Background* self)
{
	SlickGreeter* _tmp0_;
#line 862 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 864 "../src/background.vala"
	g_object_notify ((GObject*) self, "average-color");
#line 866 "../src/background.vala"
	_tmp0_ = slick_greeter_singleton;
#line 866 "../src/background.vala"
	if (!_tmp0_->test_mode) {
#line 4521 "background.c"
		gchar* rgba = NULL;
		BackgroundLoader* _tmp1_;
		gchar* _tmp2_;
		GdkWindow* root = NULL;
		GdkScreen* _tmp3_;
		GdkWindow* _tmp4_;
		GdkWindow* _tmp5_;
		GdkWindow* _tmp6_;
		const gchar* _tmp7_;
		guint8* _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_ = 0;
		guint8* _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		guint8* _tmp12_;
		gint _tmp12__length1;
		gint _tmp13_ = 0;
		guint8* _tmp14_;
		gint _tmp14__length1;
#line 868 "../src/background.vala"
		_tmp1_ = self->priv->current;
#line 868 "../src/background.vala"
		_tmp2_ = gdk_rgba_to_string (&_tmp1_->average_color);
#line 868 "../src/background.vala"
		rgba = _tmp2_;
#line 869 "../src/background.vala"
		_tmp3_ = gtk_widget_get_screen ((GtkWidget*) self);
#line 869 "../src/background.vala"
		_tmp4_ = gdk_screen_get_root_window (_tmp3_);
#line 869 "../src/background.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 869 "../src/background.vala"
		root = _tmp5_;
#line 870 "../src/background.vala"
		_tmp6_ = root;
#line 870 "../src/background.vala"
		_tmp7_ = rgba;
#line 870 "../src/background.vala"
		_tmp8_ = string_get_data (_tmp7_, &_tmp9_);
#line 870 "../src/background.vala"
		_tmp8__length1 = _tmp9_;
#line 870 "../src/background.vala"
		_tmp10_ = _tmp8_;
#line 870 "../src/background.vala"
		_tmp10__length1 = _tmp8__length1;
#line 870 "../src/background.vala"
		_tmp11_ = rgba;
#line 870 "../src/background.vala"
		_tmp12_ = string_get_data (_tmp11_, &_tmp13_);
#line 870 "../src/background.vala"
		_tmp12__length1 = _tmp13_;
#line 870 "../src/background.vala"
		_tmp14_ = _tmp12_;
#line 870 "../src/background.vala"
		_tmp14__length1 = _tmp12__length1;
#line 870 "../src/background.vala"
		gdk_property_change (_tmp6_, gdk_atom_intern_static_string ("_GNOME_BACKGROUND_REPRESENTATIVE_COLORS"), gdk_atom_intern_static_string ("STRING"), 8, GDK_PROP_MODE_REPLACE, (const guchar*) _tmp10_, _tmp14__length1);
#line 866 "../src/background.vala"
		_g_object_unref0 (root);
#line 866 "../src/background.vala"
		_g_free0 (rgba);
#line 4584 "background.c"
	}
}

const gchar*
background_get_fallback_color (Background* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp8_;
#line 403 "../src/background.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 404 "../src/background.vala"
	_tmp0_ = self->priv->_fallback_color;
#line 404 "../src/background.vala"
	if (_tmp0_ == NULL) {
#line 4600 "background.c"
		gchar* settings_color = NULL;
		gchar* _tmp1_;
		GdkRGBA color = {0};
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
#line 406 "../src/background.vala"
		_tmp1_ = ug_settings_get_string (UG_SETTINGS_KEY_BACKGROUND_COLOR);
#line 406 "../src/background.vala"
		settings_color = _tmp1_;
#line 407 "../src/background.vala"
		memset (&color, 0, sizeof (GdkRGBA));
#line 409 "../src/background.vala"
		_tmp3_ = settings_color;
#line 409 "../src/background.vala"
		if (g_strcmp0 (_tmp3_, "") == 0) {
#line 409 "../src/background.vala"
			_tmp2_ = TRUE;
#line 4620 "background.c"
		} else {
			const gchar* _tmp4_;
#line 409 "../src/background.vala"
			_tmp4_ = settings_color;
#line 409 "../src/background.vala"
			_tmp2_ = !gdk_rgba_parse (&color, _tmp4_);
#line 4627 "background.c"
		}
#line 409 "../src/background.vala"
		if (_tmp2_) {
#line 4631 "background.c"
			gchar* _tmp5_;
#line 411 "../src/background.vala"
			_tmp5_ = g_strdup ("#000000");
#line 411 "../src/background.vala"
			_g_free0 (settings_color);
#line 411 "../src/background.vala"
			settings_color = _tmp5_;
#line 4639 "background.c"
		}
#line 414 "../src/background.vala"
		_tmp6_ = settings_color;
#line 414 "../src/background.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 414 "../src/background.vala"
		_g_free0 (self->priv->_fallback_color);
#line 414 "../src/background.vala"
		self->priv->_fallback_color = _tmp7_;
#line 404 "../src/background.vala"
		_g_free0 (settings_color);
#line 4651 "background.c"
	}
#line 417 "../src/background.vala"
	_tmp8_ = self->priv->_fallback_color;
#line 417 "../src/background.vala"
	result = _tmp8_;
#line 417 "../src/background.vala"
	return result;
#line 4659 "background.c"
}

const gchar*
background_get_system_background (Background* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp8_;
#line 423 "../src/background.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 424 "../src/background.vala"
	_tmp0_ = self->priv->_system_background;
#line 424 "../src/background.vala"
	if (_tmp0_ == NULL) {
#line 4674 "background.c"
		gchar* system_bg = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
#line 426 "../src/background.vala"
		_tmp1_ = ug_settings_get_string (UG_SETTINGS_KEY_BACKGROUND);
#line 426 "../src/background.vala"
		system_bg = _tmp1_;
#line 428 "../src/background.vala"
		_tmp2_ = system_bg;
#line 428 "../src/background.vala"
		if (g_strcmp0 (_tmp2_, "") == 0) {
#line 4688 "background.c"
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
#line 430 "../src/background.vala"
			_tmp3_ = background_get_fallback_color (self);
#line 430 "../src/background.vala"
			_tmp4_ = _tmp3_;
#line 430 "../src/background.vala"
			_tmp5_ = g_strdup (_tmp4_);
#line 430 "../src/background.vala"
			_g_free0 (system_bg);
#line 430 "../src/background.vala"
			system_bg = _tmp5_;
#line 4702 "background.c"
		}
#line 433 "../src/background.vala"
		_tmp6_ = system_bg;
#line 433 "../src/background.vala"
		_tmp7_ = g_strdup (_tmp6_);
#line 433 "../src/background.vala"
		_g_free0 (self->priv->_system_background);
#line 433 "../src/background.vala"
		self->priv->_system_background = _tmp7_;
#line 424 "../src/background.vala"
		_g_free0 (system_bg);
#line 4714 "background.c"
	}
#line 436 "../src/background.vala"
	_tmp8_ = self->priv->_system_background;
#line 436 "../src/background.vala"
	result = _tmp8_;
#line 436 "../src/background.vala"
	return result;
#line 4722 "background.c"
}

const gchar*
background_get_current_background (Background* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
#line 447 "../src/background.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 448 "../src/background.vala"
	_tmp0_ = self->priv->_current_background;
#line 448 "../src/background.vala"
	if (_tmp0_ == NULL) {
#line 4737 "background.c"
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 450 "../src/background.vala"
		_tmp1_ = background_get_fallback_color (self);
#line 450 "../src/background.vala"
		_tmp2_ = _tmp1_;
#line 450 "../src/background.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 450 "../src/background.vala"
		_g_free0 (self->priv->_current_background);
#line 450 "../src/background.vala"
		self->priv->_current_background = _tmp3_;
#line 4751 "background.c"
	}
#line 453 "../src/background.vala"
	_tmp4_ = self->priv->_current_background;
#line 453 "../src/background.vala"
	result = _tmp4_;
#line 453 "../src/background.vala"
	return result;
#line 4759 "background.c"
}

void
background_set_current_background (Background* self,
                                   const gchar* value)
{
	gboolean _tmp0_ = FALSE;
#line 455 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 456 "../src/background.vala"
	if (value == NULL) {
#line 456 "../src/background.vala"
		_tmp0_ = TRUE;
#line 4773 "background.c"
	} else {
#line 456 "../src/background.vala"
		_tmp0_ = g_strcmp0 (value, "") == 0;
#line 4777 "background.c"
	}
#line 456 "../src/background.vala"
	if (_tmp0_) {
#line 4781 "background.c"
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 458 "../src/background.vala"
		_tmp1_ = background_get_system_background (self);
#line 458 "../src/background.vala"
		_tmp2_ = _tmp1_;
#line 458 "../src/background.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 458 "../src/background.vala"
		_g_free0 (self->priv->_current_background);
#line 458 "../src/background.vala"
		self->priv->_current_background = _tmp3_;
#line 4795 "background.c"
	} else {
		gchar* _tmp4_;
#line 461 "../src/background.vala"
		_tmp4_ = g_strdup (value);
#line 461 "../src/background.vala"
		_g_free0 (self->priv->_current_background);
#line 461 "../src/background.vala"
		self->priv->_current_background = _tmp4_;
#line 4804 "background.c"
	}
#line 464 "../src/background.vala"
	background_reload (self);
#line 455 "../src/background.vala"
	g_object_notify_by_pspec ((GObject *) self, background_properties[BACKGROUND_CURRENT_BACKGROUND_PROPERTY]);
#line 4810 "background.c"
}

gint
background_get_width (Background* self)
{
	gint result;
#line 474 "../src/background.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 475 "../src/background.vala"
	result = self->priv->_width;
#line 475 "../src/background.vala"
	return result;
#line 4823 "background.c"
}

gint
background_get_height (Background* self)
{
	gint result;
#line 485 "../src/background.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 486 "../src/background.vala"
	result = self->priv->_height;
#line 486 "../src/background.vala"
	return result;
#line 4836 "background.c"
}

gdouble
background_get_alpha (Background* self)
{
	gdouble result;
#line 490 "../src/background.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 490 "../src/background.vala"
	result = self->priv->_alpha;
#line 490 "../src/background.vala"
	return result;
#line 4849 "background.c"
}

static void
background_set_alpha (Background* self,
                      gdouble value)
{
	gdouble old_value;
#line 490 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 490 "../src/background.vala"
	old_value = background_get_alpha (self);
#line 490 "../src/background.vala"
	if (old_value != value) {
#line 490 "../src/background.vala"
		self->priv->_alpha = value;
#line 490 "../src/background.vala"
		g_object_notify_by_pspec ((GObject *) self, background_properties[BACKGROUND_ALPHA_PROPERTY]);
#line 4867 "background.c"
	}
}

void
background_get_average_color (Background* self,
                              GdkRGBA * result)
{
	BackgroundLoader* _tmp0_;
	GdkRGBA _tmp1_;
#line 491 "../src/background.vala"
	g_return_if_fail (self != NULL);
#line 491 "../src/background.vala"
	_tmp0_ = self->priv->current;
#line 491 "../src/background.vala"
	_tmp1_ = _tmp0_->average_color;
#line 491 "../src/background.vala"
	*result = _tmp1_;
#line 491 "../src/background.vala"
	return;
#line 4887 "background.c"
}

static void
background_class_init (BackgroundClass * klass,
                       gpointer klass_data)
{
#line 387 "../src/background.vala"
	background_parent_class = g_type_class_peek_parent (klass);
#line 387 "../src/background.vala"
	g_type_class_adjust_private_offset (klass, &Background_private_offset);
#line 387 "../src/background.vala"
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) background_real_size_allocate;
#line 387 "../src/background.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) background_real_draw;
#line 387 "../src/background.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_background_get_property;
#line 387 "../src/background.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_background_set_property;
#line 387 "../src/background.vala"
	G_OBJECT_CLASS (klass)->finalize = background_finalize;
#line 387 "../src/background.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_FALLBACK_COLOR_PROPERTY, background_properties[BACKGROUND_FALLBACK_COLOR_PROPERTY] = g_param_spec_string ("fallback-color", "fallback-color", "fallback-color", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 387 "../src/background.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_SYSTEM_BACKGROUND_PROPERTY, background_properties[BACKGROUND_SYSTEM_BACKGROUND_PROPERTY] = g_param_spec_string ("system-background", "system-background", "system-background", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 387 "../src/background.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_CURRENT_BACKGROUND_PROPERTY, background_properties[BACKGROUND_CURRENT_BACKGROUND_PROPERTY] = g_param_spec_string ("current-background", "current-background", "current-background", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 387 "../src/background.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_WIDTH_PROPERTY, background_properties[BACKGROUND_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 387 "../src/background.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_HEIGHT_PROPERTY, background_properties[BACKGROUND_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 387 "../src/background.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_ALPHA_PROPERTY, background_properties[BACKGROUND_ALPHA_PROPERTY] = g_param_spec_double ("alpha", "alpha", "alpha", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 387 "../src/background.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), BACKGROUND_AVERAGE_COLOR_PROPERTY, background_properties[BACKGROUND_AVERAGE_COLOR_PROPERTY] = g_param_spec_boxed ("average-color", "average-color", "average-color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 4922 "background.c"
}

static void
background_instance_init (Background * self,
                          gpointer klass)
{
#line 387 "../src/background.vala"
	self->priv = background_get_instance_private (self);
#line 396 "../src/background.vala"
	self->priv->flags = BACKGROUND_DRAW_FLAGS_NONE;
#line 401 "../src/background.vala"
	self->priv->_fallback_color = NULL;
#line 472 "../src/background.vala"
	self->priv->_width = 0;
#line 483 "../src/background.vala"
	self->priv->_height = 0;
#line 490 "../src/background.vala"
	self->priv->_alpha = 1.0;
#line 495 "../src/background.vala"
	self->priv->monitors = NULL;
#line 496 "../src/background.vala"
	self->priv->active_monitor = NULL;
#line 505 "../src/background.vala"
	self->priv->version_logo_surface = NULL;
#line 508 "../src/background.vala"
	self->priv->other_monitors_logo_surface = NULL;
#line 4949 "background.c"
}

static void
background_finalize (GObject * obj)
{
	Background * self;
#line 387 "../src/background.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKGROUND, Background);
#line 401 "../src/background.vala"
	_g_free0 (self->priv->_fallback_color);
#line 421 "../src/background.vala"
	_g_free0 (self->priv->_system_background);
#line 445 "../src/background.vala"
	_g_free0 (self->priv->_current_background);
#line 493 "../src/background.vala"
	_cairo_surface_destroy0 (self->priv->target_surface);
#line 495 "../src/background.vala"
	(self->priv->monitors == NULL) ? NULL : (self->priv->monitors = (_g_list_free__monitor_unref0_ (self->priv->monitors), NULL));
#line 496 "../src/background.vala"
	_monitor_unref0 (self->priv->active_monitor);
#line 498 "../src/background.vala"
	_g_object_unref0 (self->priv->timer);
#line 500 "../src/background.vala"
	_g_object_unref0 (self->priv->current);
#line 501 "../src/background.vala"
	_g_object_unref0 (self->priv->old);
#line 503 "../src/background.vala"
	_g_hash_table_unref0 (self->priv->loaders);
#line 505 "../src/background.vala"
	_cairo_surface_destroy0 (self->priv->version_logo_surface);
#line 508 "../src/background.vala"
	_cairo_surface_destroy0 (self->priv->other_monitors_logo_surface);
#line 387 "../src/background.vala"
	G_OBJECT_CLASS (background_parent_class)->finalize (obj);
#line 4984 "background.c"
}

static GType
background_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Background), 0, (GInstanceInitFunc) background_instance_init, NULL };
	GType background_type_id;
	background_type_id = g_type_register_static (gtk_fixed_get_type (), "Background", &g_define_type_info, 0);
	Background_private_offset = g_type_add_instance_private (background_type_id, sizeof (BackgroundPrivate));
	return background_type_id;
}

GType
background_get_type (void)
{
	static volatile gsize background_type_id__once = 0;
	if (g_once_init_enter (&background_type_id__once)) {
		GType background_type_id;
		background_type_id = background_get_type_once ();
		g_once_init_leave (&background_type_id__once, background_type_id);
	}
	return background_type_id__once;
}

static void
_vala_background_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	Background * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BACKGROUND, Background);
#line 387 "../src/background.vala"
	switch (property_id) {
#line 387 "../src/background.vala"
		case BACKGROUND_FALLBACK_COLOR_PROPERTY:
#line 387 "../src/background.vala"
		g_value_set_string (value, background_get_fallback_color (self));
#line 387 "../src/background.vala"
		break;
#line 387 "../src/background.vala"
		case BACKGROUND_SYSTEM_BACKGROUND_PROPERTY:
#line 387 "../src/background.vala"
		g_value_set_string (value, background_get_system_background (self));
#line 387 "../src/background.vala"
		break;
#line 387 "../src/background.vala"
		case BACKGROUND_CURRENT_BACKGROUND_PROPERTY:
#line 387 "../src/background.vala"
		g_value_set_string (value, background_get_current_background (self));
#line 387 "../src/background.vala"
		break;
#line 387 "../src/background.vala"
		case BACKGROUND_WIDTH_PROPERTY:
#line 387 "../src/background.vala"
		g_value_set_int (value, background_get_width (self));
#line 387 "../src/background.vala"
		break;
#line 387 "../src/background.vala"
		case BACKGROUND_HEIGHT_PROPERTY:
#line 387 "../src/background.vala"
		g_value_set_int (value, background_get_height (self));
#line 387 "../src/background.vala"
		break;
#line 387 "../src/background.vala"
		case BACKGROUND_ALPHA_PROPERTY:
#line 387 "../src/background.vala"
		g_value_set_double (value, background_get_alpha (self));
#line 387 "../src/background.vala"
		break;
#line 387 "../src/background.vala"
		case BACKGROUND_AVERAGE_COLOR_PROPERTY:
#line 5057 "background.c"
		{
			GdkRGBA boxed;
#line 387 "../src/background.vala"
			background_get_average_color (self, &boxed);
#line 387 "../src/background.vala"
			g_value_set_boxed (value, &boxed);
#line 5064 "background.c"
		}
#line 387 "../src/background.vala"
		break;
#line 5068 "background.c"
		default:
#line 387 "../src/background.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 387 "../src/background.vala"
		break;
#line 5074 "background.c"
	}
}

static void
_vala_background_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	Background * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BACKGROUND, Background);
#line 387 "../src/background.vala"
	switch (property_id) {
#line 387 "../src/background.vala"
		case BACKGROUND_CURRENT_BACKGROUND_PROPERTY:
#line 387 "../src/background.vala"
		background_set_current_background (self, g_value_get_string (value));
#line 387 "../src/background.vala"
		break;
#line 387 "../src/background.vala"
		case BACKGROUND_ALPHA_PROPERTY:
#line 387 "../src/background.vala"
		background_set_alpha (self, g_value_get_double (value));
#line 387 "../src/background.vala"
		break;
#line 5100 "background.c"
		default:
#line 387 "../src/background.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 387 "../src/background.vala"
		break;
#line 5106 "background.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

