
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kcapacitybar_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <kcapacitybar.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qrect.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KCapacityBar_Type = nullptr;
static PyTypeObject *Sbk_KCapacityBar_TypeF(void)
{
    return _Sbk_KCapacityBar_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KCapacityBarWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KCapacityBarWrapper::KCapacityBarWrapper(::KCapacityBar::DrawTextMode drawTextMode, ::QWidget * parent) : KCapacityBar(drawTextMode, parent)
{
}

KCapacityBarWrapper::KCapacityBarWrapper(::QWidget * parent) : KCapacityBar(parent)
{
}

void KCapacityBarWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCapacityBar::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KCapacityBar", funcName, gil, pyOverride, signal);
}

void KCapacityBarWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

int KCapacityBarWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KCapacityBar", funcName, gil, pyOverride);
}

void KCapacityBarWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KCapacityBar", funcName, gil, pyOverride, signal);
}

void KCapacityBarWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

bool KCapacityBarWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KCapacityBar", funcName, gil, pyOverride, event);
}

bool KCapacityBarWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KCapacityBar", funcName, gil, pyOverride, watched, event);
}

void KCapacityBarWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

bool KCapacityBarWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KCapacityBar", funcName, gil, pyOverride, next);
}

void KCapacityBarWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

bool KCapacityBarWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KCapacityBar", funcName, gil, pyOverride);
}

int KCapacityBarWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KCapacityBar", funcName, gil, pyOverride, arg__1);
}

void KCapacityBarWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KCapacityBar", funcName, gil, pyOverride, painter);
}

void KCapacityBarWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

::QVariant KCapacityBarWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KCapacityBar", funcName, gil, pyOverride, arg__1);
}

void KCapacityBarWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

int KCapacityBarWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KCapacityBar", funcName, gil, pyOverride, arg__1);
}

::QSize KCapacityBarWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCapacityBar::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KCapacityBar", funcName, gil, pyOverride);
}

void KCapacityBarWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

bool KCapacityBarWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KCapacityBar", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KCapacityBarWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KCapacityBar", funcName, gil, pyOverride);
}

void KCapacityBarWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCapacityBar::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

::QPaintDevice * KCapacityBarWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KCapacityBar", funcName, gil, pyOverride, offset);
}

void KCapacityBarWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KCapacityBar", funcName, gil, pyOverride, visible);
}

::QPainter * KCapacityBarWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KCapacityBar", funcName, gil, pyOverride);
}

void KCapacityBarWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

::QSize KCapacityBarWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KCapacityBar", funcName, gil, pyOverride);
}

void KCapacityBarWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

void KCapacityBarWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCapacityBar_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KCapacityBar", funcName, gil, pyOverride, event);
}

const QMetaObject *KCapacityBarWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KCapacityBar::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KCapacityBarWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KCapacityBar::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KCapacityBarWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KCapacityBarWrapper *>(this));
    }
    return KCapacityBar::qt_metacast(_clname);
}

KCapacityBarWrapper::~KCapacityBarWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KCapacityBar_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KCapacityBar_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KCapacityBar >()))
        return -1;

    KCapacityBarWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KCapacityBar", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KCapacityBar::KCapacityBar(KCapacityBar::DrawTextMode,QWidget*=)
    // 1: KCapacityBar::KCapacityBar(QWidget*=)
    if (numArgs == 0) {
        overloadId = 1; // KCapacityBar(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KCapacityBar(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_DrawTextMode_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KCapacityBar(KCapacityBar::DrawTextMode,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            overloadId = 0; // KCapacityBar(KCapacityBar::DrawTextMode,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KCapacityBar(KCapacityBar::DrawTextMode drawTextMode, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);
                }
            }
            ::KCapacityBar::DrawTextMode cppArg0{KCapacityBar::DrawTextInline};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KCapacityBar(KCapacityBar::DrawTextMode,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KCapacityBarWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KCapacityBarWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
        case 1: // KCapacityBar(QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KCapacityBar(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KCapacityBarWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KCapacityBarWrapper(cppArg0);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KCapacityBar >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KCapacityBarFunc_barHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // barHeight()const
        int cppResult = const_cast<const ::KCapacityBar *>(cppSelf)->barHeight();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCapacityBarFunc_changeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::changeEvent(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // changeEvent(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "changeEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // changeEvent(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCapacityBar::changeEvent(cppArg0)
                : cppSelf->changeEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCapacityBarFunc_continuous(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // continuous()const
        bool cppResult = const_cast<const ::KCapacityBar *>(cppSelf)->continuous();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCapacityBarFunc_drawCapacityBar(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "drawCapacityBar", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KCapacityBar::drawCapacityBar(QPainter*,QRect)const
    // 1: KCapacityBar::drawCapacityBar(QPainter*,QRect,QFlags<QStyle::StateFlag>)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPainter_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // drawCapacityBar(QPainter*,QRect)const
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFlags_QStyle_StateFlag_IDX])))->flagsConverter, (pyArgs[2])))) {
            overloadId = 1; // drawCapacityBar(QPainter*,QRect,QFlags<QStyle::StateFlag>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "drawCapacityBar", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // drawCapacityBar(QPainter *p, const QRect &rect) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPainter *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QRect cppArg1_local;
            ::QRect *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (Shiboken::Errors::occurred() == nullptr) {
                // drawCapacityBar(QPainter*,QRect)const
                const_cast<const ::KCapacityBar *>(cppSelf)->drawCapacityBar(cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // drawCapacityBar(QPainter *p, const QRect &rect, QFlags<QStyle::StateFlag> state) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPainter *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QRect cppArg1_local;
            ::QRect *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QFlags<QStyle::StateFlag> cppArg2 = QFlags<QStyle::StateFlag>(0);
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // drawCapacityBar(QPainter*,QRect,QFlags<QStyle::StateFlag>)const
                const_cast<const ::KCapacityBar *>(cppSelf)->drawCapacityBar(cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCapacityBarFunc_drawTextMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // drawTextMode()const
        KCapacityBar::DrawTextMode cppResult = const_cast<const ::KCapacityBar *>(cppSelf)->drawTextMode();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_DrawTextMode_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCapacityBarFunc_fillFullBlocks(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // fillFullBlocks()const
        bool cppResult = const_cast<const ::KCapacityBar *>(cppSelf)->fillFullBlocks();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCapacityBarFunc_horizontalTextAlignment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // horizontalTextAlignment()const
        QFlags<Qt::AlignmentFlag> cppResult = const_cast<const ::KCapacityBar *>(cppSelf)->horizontalTextAlignment();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCapacityBarFunc_minimumSizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minimumSizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KCapacityBar *>(cppSelf)->::KCapacityBar::minimumSizeHint()
            : const_cast<const ::KCapacityBar *>(cppSelf)->minimumSizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCapacityBarFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintEvent_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "paintEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // paintEvent(QPaintEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCapacityBar::paintEvent(cppArg0)
                : cppSelf->paintEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCapacityBarFunc_setBarHeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCapacityBar::setBarHeight(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setBarHeight(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBarHeight", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setBarHeight(int)
            cppSelf->setBarHeight(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCapacityBarFunc_setContinuous(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCapacityBar::setContinuous(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setContinuous(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setContinuous", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setContinuous(bool)
            cppSelf->setContinuous(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCapacityBarFunc_setDrawTextMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCapacityBar::setDrawTextMode(KCapacityBar::DrawTextMode)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_DrawTextMode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setDrawTextMode(KCapacityBar::DrawTextMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDrawTextMode", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);

    // Call function/method
    {
        ::KCapacityBar::DrawTextMode cppArg0{KCapacityBar::DrawTextInline};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDrawTextMode(KCapacityBar::DrawTextMode)
            cppSelf->setDrawTextMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCapacityBarFunc_setFillFullBlocks(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCapacityBar::setFillFullBlocks(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFillFullBlocks(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFillFullBlocks", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFillFullBlocks(bool)
            cppSelf->setFillFullBlocks(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCapacityBarFunc_setHorizontalTextAlignment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCapacityBar::setHorizontalTextAlignment(QFlags<Qt::AlignmentFlag>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_AlignmentFlag_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setHorizontalTextAlignment(QFlags<Qt::AlignmentFlag>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setHorizontalTextAlignment", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);

    // Call function/method
    {
        ::QFlags<Qt::AlignmentFlag> cppArg0 = QFlags<Qt::AlignmentFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setHorizontalTextAlignment(QFlags<Qt::AlignmentFlag>)
            cppSelf->setHorizontalTextAlignment(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCapacityBarFunc_setText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCapacityBar::setText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setText(QString)
            cppSelf->setText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCapacityBarFunc_setValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCapacityBar::setValue(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setValue(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setValue", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setValue(int)
            cppSelf->setValue(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCapacityBarFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // text()const
        QString cppResult = const_cast<const ::KCapacityBar *>(cppSelf)->text();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCapacityBarFunc_value(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // value()const
        int cppResult = const_cast<const ::KCapacityBar *>(cppSelf)->value();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KCapacityBar_PropertyStrings[] = {
    "barHeight::",
    "continuous::",
    "drawTextMode::",
    "fillFullBlocks::",
    "horizontalTextAlignment::",
    "text::",
    "value::",
    nullptr // Sentinel
};

static const char *Sbk_KCapacityBar_EnumFlagInfo[] = {
    "DrawTextMode:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KCapacityBar_methods[] = {
    {"barHeight", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_barHeight), METH_NOARGS, nullptr},
    {"changeEvent", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_changeEvent), METH_O, nullptr},
    {"continuous", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_continuous), METH_NOARGS, nullptr},
    {"drawCapacityBar", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_drawCapacityBar), METH_VARARGS, nullptr},
    {"drawTextMode", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_drawTextMode), METH_NOARGS, nullptr},
    {"fillFullBlocks", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_fillFullBlocks), METH_NOARGS, nullptr},
    {"horizontalTextAlignment", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_horizontalTextAlignment), METH_NOARGS, nullptr},
    {"minimumSizeHint", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_minimumSizeHint), METH_NOARGS, nullptr},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_paintEvent), METH_O, nullptr},
    {"setBarHeight", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_setBarHeight), METH_O, nullptr},
    {"setContinuous", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_setContinuous), METH_O, nullptr},
    {"setDrawTextMode", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_setDrawTextMode), METH_O, nullptr},
    {"setFillFullBlocks", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_setFillFullBlocks), METH_O, nullptr},
    {"setHorizontalTextAlignment", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_setHorizontalTextAlignment), METH_O, nullptr},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_setText), METH_O, nullptr},
    {"setValue", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_setValue), METH_O, nullptr},
    {"text", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_text), METH_NOARGS, nullptr},
    {"value", reinterpret_cast<PyCFunction>(Sbk_KCapacityBarFunc_value), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KCapacityBar_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KCapacityBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KCapacityBarWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KCapacityBar_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KCapacityBar_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KCapacityBarSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KCapacityBar *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KCapacityBar_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KCapacityBar_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KCapacityBar_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KCapacityBar_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KCapacityBar_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KCapacityBar_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KCapacityBar_spec = {
    "1:KWidgetsAddons.KCapacityBar",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KCapacityBar_slots
};

} //extern "C"

static void *Sbk_KCapacityBar_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KCapacityBar *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KCapacityBar *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KCapacityBar *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KCapacityBar_DrawTextMode(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KCapacityBar::DrawTextMode>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KCapacityBar::DrawTextMode *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KCapacityBar_DrawTextMode_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_DrawTextMode_IDX])))
        return Enum_PythonToCpp_KCapacityBar_DrawTextMode;
    return {};
}

static PyObject *KCapacityBar_DrawTextMode_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KCapacityBar::DrawTextMode>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KCapacityBar::DrawTextMode *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KCapacityBar_PythonToCpp_KCapacityBar_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KCapacityBar_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KCapacityBar_PythonToCpp_KCapacityBar_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KCapacityBar_TypeF()))
        return KCapacityBar_PythonToCpp_KCapacityBar_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KCapacityBar_PTR_CppToPython_KCapacityBar(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KCapacityBar *>(const_cast<void *>(cppIn)), Sbk_KCapacityBar_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCapacityBar_SignatureStrings[] = {
    "1:KWidgetsAddons.KCapacityBar(self,drawTextMode:KWidgetsAddons.KCapacityBar.DrawTextMode,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,value:int=None,text:QString=None,drawTextMode:KWidgetsAddons.KCapacityBar.DrawTextMode=None,fillFullBlocks:bool=None,continuous:bool=None,barHeight:int=None,horizontalTextAlignment:PySide6.QtCore.Qt.AlignmentFlag=None)",
    "0:KWidgetsAddons.KCapacityBar(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,value:int=None,text:QString=None,drawTextMode:KWidgetsAddons.KCapacityBar.DrawTextMode=None,fillFullBlocks:bool=None,continuous:bool=None,barHeight:int=None,horizontalTextAlignment:PySide6.QtCore.Qt.AlignmentFlag=None)",
    "KWidgetsAddons.KCapacityBar.barHeight(self)->int",
    "KWidgetsAddons.KCapacityBar.changeEvent(self,event:PySide6.QtCore.QEvent)",
    "KWidgetsAddons.KCapacityBar.continuous(self)->bool",
    "1:KWidgetsAddons.KCapacityBar.drawCapacityBar(self,p:PySide6.QtGui.QPainter,rect:PySide6.QtCore.QRect)",
    "0:KWidgetsAddons.KCapacityBar.drawCapacityBar(self,p:PySide6.QtGui.QPainter,rect:PySide6.QtCore.QRect,state:PySide6.QtWidgets.QStyle.StateFlag)",
    "KWidgetsAddons.KCapacityBar.drawTextMode(self)->KWidgetsAddons.KCapacityBar.DrawTextMode",
    "KWidgetsAddons.KCapacityBar.fillFullBlocks(self)->bool",
    "KWidgetsAddons.KCapacityBar.horizontalTextAlignment(self)->PySide6.QtCore.Qt.AlignmentFlag",
    "KWidgetsAddons.KCapacityBar.minimumSizeHint(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KCapacityBar.paintEvent(self,event:PySide6.QtGui.QPaintEvent)",
    "KWidgetsAddons.KCapacityBar.setBarHeight(self,barHeight:int)",
    "KWidgetsAddons.KCapacityBar.setContinuous(self,continuous:bool)",
    "KWidgetsAddons.KCapacityBar.setDrawTextMode(self,mode:KWidgetsAddons.KCapacityBar.DrawTextMode)",
    "KWidgetsAddons.KCapacityBar.setFillFullBlocks(self,fillFullBlocks:bool)",
    "KWidgetsAddons.KCapacityBar.setHorizontalTextAlignment(self,textAlignment:PySide6.QtCore.Qt.AlignmentFlag)",
    "KWidgetsAddons.KCapacityBar.setText(self,text:QString)",
    "KWidgetsAddons.KCapacityBar.setValue(self,value:int)",
    "KWidgetsAddons.KCapacityBar.text(self)->QString",
    "KWidgetsAddons.KCapacityBar.value(self)->int",
    nullptr}; // Sentinel
#else
static constexpr size_t KCapacityBar_SignatureByteSize = 432;
static constexpr uint8_t KCapacityBar_SignatureBytes[432] = {
    0x78, 0xda, 0xed, 0x54, 0x4d, 0x53, 0xc2, 0x30, 0x10, 0xbd, 0xf3, 0x4b, 0xc4, 0xa9, 0x1d, 0xb9,
    0x78, 0xe8, 0x0c, 0xce, 0xf0, 0x21, 0x32, 0xc3, 0xa8, 0xd4, 0x3a, 0x7a, 0x0e, 0xed, 0x52, 0x32,
    0xa6, 0x49, 0x27, 0x4d, 0x8b, 0xe5, 0xd7, 0x9b, 0x50, 0xfa, 0x05, 0x25, 0x41, 0xc7, 0xa3, 0x27,
    0x4a, 0x76, 0xdf, 0xbe, 0xcd, 0xdb, 0x97, 0x1d, 0x38, 0x8b, 0x0f, 0x1c, 0x84, 0x20, 0x92, 0x51,
    0x10, 0x30, 0x9a, 0xd8, 0x8b, 0x09, 0x8a, 0x91, 0x8f, 0x45, 0x3e, 0x46, 0xfc, 0x2a, 0x01, 0xb2,
    0xb6, 0x02, 0x8e, 0xb6, 0x6f, 0xf0, 0x25, 0x9e, 0x58, 0x00, 0xba, 0x6c, 0x7b, 0xda, 0x48, 0xb4,
    0x62, 0xc4, 0x81, 0x0a, 0x67, 0x99, 0x7b, 0x38, 0x80, 0x3b, 0xdb, 0x15, 0x07, 0xa0, 0xed, 0x16,
    0x1f, 0x43, 0x9a, 0x12, 0x12, 0x0b, 0x6e, 0x5d, 0x3b, 0x0b, 0xc8, 0xb7, 0x8c, 0x07, 0x2f, 0x94,
    0xe4, 0xc3, 0x67, 0x46, 0xc1, 0xca, 0x10, 0x49, 0xc1, 0xc1, 0x54, 0x14, 0x7f, 0x85, 0xac, 0xe9,
    0xb8, 0x9e, 0xe0, 0x98, 0x86, 0xc5, 0xc9, 0xaf, 0x5a, 0x2a, 0xa0, 0x6b, 0x4c, 0xc8, 0x4c, 0x52,
    0x8f, 0x09, 0xf3, 0x3f, 0x13, 0x67, 0xc5, 0x18, 0x29, 0x02, 0x3e, 0xa3, 0x02, 0xd3, 0x94, 0xa5,
    0xcd, 0xc3, 0x15, 0xe2, 0x73, 0xc0, 0xe1, 0x46, 0xd4, 0xdd, 0x6c, 0x18, 0xc7, 0x3b, 0x99, 0x8b,
    0x88, 0x2a, 0x3c, 0x22, 0x38, 0xa4, 0x51, 0xfb, 0xa6, 0x13, 0xc6, 0x41, 0xfe, 0xd8, 0x55, 0x6c,
    0x46, 0x50, 0xd1, 0x78, 0xbf, 0x77, 0x6b, 0xd6, 0xfb, 0x5f, 0xb9, 0x4e, 0xe5, 0x74, 0xcd, 0x56,
    0x64, 0x7b, 0x05, 0xfb, 0x37, 0xf7, 0x92, 0x53, 0x0b, 0xf0, 0x37, 0x88, 0x86, 0xf0, 0x90, 0x49,
    0x8a, 0x42, 0x74, 0xc8, 0xba, 0x3a, 0xd9, 0x27, 0xe8, 0xa9, 0xeb, 0xcb, 0x97, 0xdc, 0x4a, 0x83,
    0xde, 0x40, 0x2b, 0xae, 0x9a, 0xc2, 0xe9, 0xdc, 0x1b, 0xf4, 0x8f, 0x29, 0xb6, 0xdd, 0x25, 0x92,
    0xd7, 0x00, 0x6e, 0x71, 0xf0, 0x4f, 0x5b, 0x7b, 0x95, 0x87, 0x06, 0x3b, 0xfd, 0x15, 0x8d, 0x95,
    0x08, 0x24, 0xa0, 0xcb, 0x90, 0x9e, 0xc8, 0x09, 0xd8, 0x9e, 0x0a, 0xab, 0x49, 0xe9, 0x95, 0x6a,
    0x5a, 0xaf, 0xd4, 0xea, 0x52, 0x07, 0x6a, 0x0b, 0xb7, 0x8d, 0xd9, 0x1a, 0x83, 0x0e, 0x76, 0xc6,
    0x8e, 0x25, 0xde, 0xe0, 0x4a, 0x6d, 0xe9, 0x08, 0x53, 0x1c, 0xa5, 0x91, 0x87, 0x77, 0x30, 0xc7,
    0xe7, 0x4b, 0xaa, 0xb8, 0xb6, 0x4e, 0xac, 0x46, 0xa3, 0x71, 0x69, 0x3d, 0xbf, 0x0b, 0x9c, 0x9a,
    0x80, 0x18, 0xb7, 0xde, 0x49, 0xfb, 0x8d, 0x1a, 0xc1, 0x93, 0xb6, 0xd3, 0x8f, 0x9f, 0xbd, 0x11,
    0x3f, 0x3d, 0x9e, 0xbf, 0x15, 0xfd, 0x64, 0x09, 0x19, 0xeb, 0xcf, 0x4e, 0x6d, 0xd0, 0xb5, 0xb3,
    0x8c, 0x75, 0xe6, 0x1a, 0x5f, 0xec, 0x37, 0xea, 0xc5, 0x9b, 0xcb, 0x48, 0xa5, 0x08, 0xea, 0xba,
    0xe5, 0xa6, 0x36, 0xc2, 0xde, 0xd5, 0x96, 0x2f, 0x70, 0xd5, 0xc2, 0xd7, 0x83, 0x44, 0x49, 0x24,
    0x5d, 0x78, 0x60, 0xd1, 0xe6, 0x67, 0x15, 0xc3, 0x61, 0x99, 0x7e, 0x03, 0x0c, 0x29, 0x02, 0x2d
};
#endif

PyTypeObject *init_KCapacityBar(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX].type;

    Shiboken::AutoDecRef Sbk_KCapacityBar_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KCapacityBar_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KCapacityBar",
        "KCapacityBar*",
        &Sbk_KCapacityBar_spec,
        &Shiboken::callCppDestructor< KCapacityBar >,
        Sbk_KCapacityBar_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KCapacityBar_Type; // references _Sbk_KCapacityBar_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCapacityBar_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCapacityBar_SignatureBytes, KCapacityBar_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KCapacityBar_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KCapacityBar_PythonToCpp_KCapacityBar_PTR,
        is_KCapacityBar_PythonToCpp_KCapacityBar_PTR_Convertible,
        KCapacityBar_PTR_CppToPython_KCapacityBar);

    Shiboken::Conversions::registerConverterName(converter, "KCapacityBar");
    Shiboken::Conversions::registerConverterName(converter, "KCapacityBar*");
    Shiboken::Conversions::registerConverterName(converter, "KCapacityBar&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KCapacityBar).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KCapacityBarWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KCapacityBar_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KCapacityBar_TypeF(), &Sbk_KCapacityBarSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KCapacityBar_TypeF(), &Sbk_KCapacityBar_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KCapacityBar_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'DrawTextMode'.
    const char *DrawTextMode_Initializer[] = {
        "DrawTextInline",
        "DrawTextOutline",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t DrawTextMode_InitializerValues[] = {
        uint8_t(KCapacityBar::DrawTextMode::DrawTextInline), //  0x00  0
        uint8_t(KCapacityBar::DrawTextMode::DrawTextOutline) //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KCapacityBar_TypeF(),
        "1:KWidgetsAddons.KCapacityBar.DrawTextMode",
        DrawTextMode_Initializer, DrawTextMode_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_DrawTextMode_IDX].type = EType;
    // Register converter for enum 'KCapacityBar::DrawTextMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KCapacityBar_DrawTextMode_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KCapacityBar_DrawTextMode,
            is_Enum_PythonToCpp_KCapacityBar_DrawTextMode_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KCapacityBar::DrawTextMode");
        Shiboken::Conversions::registerConverterAlias(converter, "DrawTextMode");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'DrawTextMode' enum.

    qRegisterMetaType< ::KCapacityBar::DrawTextMode >("KCapacityBar::DrawTextMode");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KCapacityBar::staticMetaObject, sizeof(KCapacityBarWrapper));

    return pyType;
}
