/*
 * Copyright (C) 2021 Damir Porobic <damir.porobic@gmx.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "SettingsPickerWidget.h"

namespace kImageAnnotator {

SettingsPickerWidget::SettingsPickerWidget(QWidget *parent) :
	QWidget(parent)
{

}

void SettingsPickerWidget::showEvent(QShowEvent *event)
{
	emit visibilityChanged(true);
	QWidget::showEvent(event);
}

void SettingsPickerWidget::hideEvent(QHideEvent *event)
{
	emit visibilityChanged(false);
	QWidget::hideEvent(event);
}

} // namespace kImageAnnotator
