/*
 *  Copyright (C) 2019 KeePassXC Team <team@keepassxc.org>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 or (at your option)
 *  version 3 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KEEPASSXC_GENERATE_H
#define KEEPASSXC_GENERATE_H

#include "Command.h"

class PasswordGenerator;

class Generate : public Command
{
public:
    Generate();
    int execute(const QStringList& arguments) override;

    static QSharedPointer<PasswordGenerator> createGenerator(QSharedPointer<QCommandLineParser> parser);

    static const QCommandLineOption PasswordLengthOption;
    static const QCommandLineOption LowerCaseOption;
    static const QCommandLineOption UpperCaseOption;
    static const QCommandLineOption NumbersOption;
    static const QCommandLineOption SpecialCharsOption;
    static const QCommandLineOption ExtendedAsciiOption;
    static const QCommandLineOption ExcludeCharsOption;
    static const QCommandLineOption ExcludeSimilarCharsOption;
    static const QCommandLineOption IncludeEveryGroupOption;
    static const QCommandLineOption CustomCharacterSetOption;
};

#endif // KEEPASSXC_GENERATE_H
