/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha2

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	apixv1alpha2 "sigs.k8s.io/gateway-api-inference-extension/apix/v1alpha2"
	applyconfigurationapixv1alpha2 "sigs.k8s.io/gateway-api-inference-extension/client-go/applyconfiguration/apix/v1alpha2"
	scheme "sigs.k8s.io/gateway-api-inference-extension/client-go/clientset/versioned/scheme"
)

// InferenceObjectivesGetter has a method to return a InferenceObjectiveInterface.
// A group's client should implement this interface.
type InferenceObjectivesGetter interface {
	InferenceObjectives(namespace string) InferenceObjectiveInterface
}

// InferenceObjectiveInterface has methods to work with InferenceObjective resources.
type InferenceObjectiveInterface interface {
	Create(ctx context.Context, inferenceObjective *apixv1alpha2.InferenceObjective, opts v1.CreateOptions) (*apixv1alpha2.InferenceObjective, error)
	Update(ctx context.Context, inferenceObjective *apixv1alpha2.InferenceObjective, opts v1.UpdateOptions) (*apixv1alpha2.InferenceObjective, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, inferenceObjective *apixv1alpha2.InferenceObjective, opts v1.UpdateOptions) (*apixv1alpha2.InferenceObjective, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*apixv1alpha2.InferenceObjective, error)
	List(ctx context.Context, opts v1.ListOptions) (*apixv1alpha2.InferenceObjectiveList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *apixv1alpha2.InferenceObjective, err error)
	Apply(ctx context.Context, inferenceObjective *applyconfigurationapixv1alpha2.InferenceObjectiveApplyConfiguration, opts v1.ApplyOptions) (result *apixv1alpha2.InferenceObjective, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, inferenceObjective *applyconfigurationapixv1alpha2.InferenceObjectiveApplyConfiguration, opts v1.ApplyOptions) (result *apixv1alpha2.InferenceObjective, err error)
	InferenceObjectiveExpansion
}

// inferenceObjectives implements InferenceObjectiveInterface
type inferenceObjectives struct {
	*gentype.ClientWithListAndApply[*apixv1alpha2.InferenceObjective, *apixv1alpha2.InferenceObjectiveList, *applyconfigurationapixv1alpha2.InferenceObjectiveApplyConfiguration]
}

// newInferenceObjectives returns a InferenceObjectives
func newInferenceObjectives(c *XInferenceV1alpha2Client, namespace string) *inferenceObjectives {
	return &inferenceObjectives{
		gentype.NewClientWithListAndApply[*apixv1alpha2.InferenceObjective, *apixv1alpha2.InferenceObjectiveList, *applyconfigurationapixv1alpha2.InferenceObjectiveApplyConfiguration](
			"inferenceobjectives",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *apixv1alpha2.InferenceObjective { return &apixv1alpha2.InferenceObjective{} },
			func() *apixv1alpha2.InferenceObjectiveList { return &apixv1alpha2.InferenceObjectiveList{} },
		),
	}
}
