/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// InferencePoolSpecApplyConfiguration represents a declarative configuration of the InferencePoolSpec type for use
// with apply.
type InferencePoolSpecApplyConfiguration struct {
	Selector          *LabelSelectorApplyConfiguration     `json:"selector,omitempty"`
	TargetPorts       []PortApplyConfiguration             `json:"targetPorts,omitempty"`
	EndpointPickerRef *EndpointPickerRefApplyConfiguration `json:"endpointPickerRef,omitempty"`
}

// InferencePoolSpecApplyConfiguration constructs a declarative configuration of the InferencePoolSpec type for use with
// apply.
func InferencePoolSpec() *InferencePoolSpecApplyConfiguration {
	return &InferencePoolSpecApplyConfiguration{}
}

// WithSelector sets the Selector field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Selector field is set to the value of the last call.
func (b *InferencePoolSpecApplyConfiguration) WithSelector(value *LabelSelectorApplyConfiguration) *InferencePoolSpecApplyConfiguration {
	b.Selector = value
	return b
}

// WithTargetPorts adds the given value to the TargetPorts field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the TargetPorts field.
func (b *InferencePoolSpecApplyConfiguration) WithTargetPorts(values ...*PortApplyConfiguration) *InferencePoolSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithTargetPorts")
		}
		b.TargetPorts = append(b.TargetPorts, *values[i])
	}
	return b
}

// WithEndpointPickerRef sets the EndpointPickerRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the EndpointPickerRef field is set to the value of the last call.
func (b *InferencePoolSpecApplyConfiguration) WithEndpointPickerRef(value *EndpointPickerRefApplyConfiguration) *InferencePoolSpecApplyConfiguration {
	b.EndpointPickerRef = value
	return b
}
