/* Autogenerated file, DO NOT EDIT manually! generated by perf-metricset-codegen.py
 *
 * Copyright (c) 2018 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#include "i915_drm.h"

#include "i915_perf_metrics_acmgt1.h"
#include "i915_perf_equations.h"
#include "i915_perf_registers_acmgt1.h"

static bool acmgt1_render_basic_Sampler20Bottleneck_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_render_basic_Sampler20Busy_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_render_basic_SamplerBottleneck_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_render_basic_SamplersBusy_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_render_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics Basic - aggregation approximation";
    metric_set->symbol_name = "RenderBasic";
    metric_set->hw_config_guid = "f5b8f05e-c84c-4f1c-bb05-68fbea73879b";
    metric_set->counters = calloc(30, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_render_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__render_basic__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__render_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = acmgt1__render_basic__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "ThreadDispatcher",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__render_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__render_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__render_basic__gti_read_throughput__read,
                .max_uint64 = acmgt1__render_basic__gti_read_throughput__max,
                .group = "Memory",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__render_basic__gti_write_throughput__read,
                .max_uint64 = acmgt1__render_basic__gti_write_throughput__max,
                .group = "Memory",
            },

            {
                .name = "FS EM Pipe Active",
                .symbol_name = "PsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a fragment shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__ps_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "FS FPU Pipe Active",
                .symbol_name = "PsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a fragment shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__ps_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "FS Send Pipe Active",
                .symbol_name = "PsSendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing a fragment shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__ps_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "Sampler20 Bottleneck",
                .symbol_name = "Sampler20Bottleneck",
                .desc = "The percentage of time in which Slice2 Sampler0 has been slowing down the pipe when processing XVE requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__sampler20_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_render_basic_Sampler20Bottleneck_availability,
            },

            {
                .name = "Sampler Slice2 Xe Core0 is busy",
                .symbol_name = "Sampler20Busy",
                .desc = "The percentage of time when sampler slice2 Xe core0 is busy",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__sampler20_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_render_basic_Sampler20Busy_availability,
            },

            {
                .name = "Samplers Bottleneck",
                .symbol_name = "SamplerBottleneck",
                .desc = "The percentage of time in which samplers have been slowing down the pipe when processing XVE requests.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__sampler_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_render_basic_SamplerBottleneck_availability,
            },

            {
                .name = "Sampler Texels Misses",
                .symbol_name = "SamplerTexelMisses",
                .desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = acmgt1__render_basic__sampler_texel_misses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Sampler Texels",
                .symbol_name = "SamplerTexels",
                .desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS,
                .read_uint64 = acmgt1__render_basic__sampler_texels__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Sampler",
            },

            {
                .name = "Samplers Busy",
                .symbol_name = "SamplersBusy",
                .desc = "The percentage of time in which samplers or L1 cache are not idle.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__samplers_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_render_basic_SamplersBusy_availability,
            },

            {
                .name = "Samples Blended",
                .symbol_name = "SamplesBlended",
                .desc = "The total number of blended samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = acmgt1__render_basic__samples_blended__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "Samples Written",
                .symbol_name = "SamplesWritten",
                .desc = "The total number of samples or pixels written to all render targets.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = acmgt1__render_basic__samples_written__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Rasterizer",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__render_basic__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "VectorEngine",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__render_basic__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "VectorEngine",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__render_basic__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "VectorEngine",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmReads",
                .desc = "The total number of reads from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__render_basic__slm_reads__read,
                .max_uint64 = acmgt1__render_basic__slm_reads__max,
                .group = "L1Cache",
            },

            {
                .name = "SLM Writes",
                .symbol_name = "SlmWrites",
                .desc = "The total number of writes into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__render_basic__slm_writes__read,
                .max_uint64 = acmgt1__render_basic__slm_writes__max,
                .group = "L1Cache",
            },

            {
                .name = "VS EM Pipe Active",
                .symbol_name = "VsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__vs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "VS FPU Pipe Active",
                .symbol_name = "VsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__vs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "VS Send Pipe Active",
                .symbol_name = "VsSendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__vs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE Active",
                .symbol_name = "XveActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "EM And FPU Pipes Active",
                .symbol_name = "XveFpuEmActive",
                .desc = "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__xve_fpu_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE Stall",
                .symbol_name = "XveStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE Thread Occupancy",
                .symbol_name = "XveThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied XVEs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_basic__xve_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 30);
}


static void
acmgt1_add_compute_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Basic";
    metric_set->symbol_name = "ComputeBasic";
    metric_set->hw_config_guid = "53ee6271-905c-4b2a-b449-9117ffd10a48";
    metric_set->counters = calloc(25, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_compute_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__compute_basic__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__compute_basic__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = acmgt1__compute_basic__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "ThreadDispatcher",
            },

            {
                .name = "EM Pipe Active",
                .symbol_name = "EmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_basic__em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE FPU Pipe Active",
                .symbol_name = "FpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_basic__fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_basic__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__compute_basic__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__compute_basic__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GTI Read Throughput",
                .symbol_name = "GtiReadThroughput",
                .desc = "The total number of GPU memory bytes read from GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__compute_basic__gti_read_throughput__read,
                .max_uint64 = acmgt1__compute_basic__gti_read_throughput__max,
                .group = "Memory",
            },

            {
                .name = "GTI Write Throughput",
                .symbol_name = "GtiWriteThroughput",
                .desc = "The total number of GPU memory bytes written to GTI.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__compute_basic__gti_write_throughput__read,
                .max_uint64 = acmgt1__compute_basic__gti_write_throughput__max,
                .group = "Memory",
            },

            {
                .name = "Send Pipe Active",
                .symbol_name = "SendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_basic__send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "Shader Atomic Memory Accesses",
                .symbol_name = "ShaderAtomics",
                .desc = "The total number of shader atomic memory accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__compute_basic__shader_atomics__read,
                .max_uint64 = NULL /* undefined */,
                .group = "VectorEngine",
            },

            {
                .name = "Shader Barrier Messages",
                .symbol_name = "ShaderBarriers",
                .desc = "The total number of shader barrier messages.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__compute_basic__shader_barriers__read,
                .max_uint64 = NULL /* undefined */,
                .group = "VectorEngine",
            },

            {
                .name = "Shader Memory Accesses",
                .symbol_name = "ShaderMemoryAccesses",
                .desc = "The total number of shader memory accesses to L3.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__compute_basic__shader_memory_accesses__read,
                .max_uint64 = NULL /* undefined */,
                .group = "VectorEngine",
            },

            {
                .name = "SLM Bytes Read",
                .symbol_name = "SlmReads",
                .desc = "The total number of reads from shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__compute_basic__slm_reads__read,
                .max_uint64 = acmgt1__compute_basic__slm_reads__max,
                .group = "L1Cache",
            },

            {
                .name = "SLM Writes",
                .symbol_name = "SlmWrites",
                .desc = "The total number of writes into shared local memory.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__compute_basic__slm_writes__read,
                .max_uint64 = acmgt1__compute_basic__slm_writes__max,
                .group = "L1Cache",
            },

            {
                .name = "XMX Pipe Active",
                .symbol_name = "XmxActive",
                .desc = "The percentage of time in which XVE XMX pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_basic__xmx_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE Active",
                .symbol_name = "XveActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_basic__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE AVG IPC Rate",
                .symbol_name = "XveAvgIpcRate",
                .desc = "The average rate of IPC calculated for 2 FPU pipelines.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NUMBER,
                .read_float = acmgt1__compute_basic__xve_avg_ipc_rate__read,
                .max_float = acmgt1__compute_basic__xve_avg_ipc_rate__max,
                .group = "VectorEngine",
            },

            {
                .name = "EM And FPU Pipes Active",
                .symbol_name = "XveFpuEmActive",
                .desc = "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_basic__xve_fpu_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "FPU FLT16 Instruction",
                .symbol_name = "XveFpuFlt16",
                .desc = "The percentage of time in which FLT16 instruction were processed actively on FPU INT64 pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_basic__xve_fpu_flt16__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "FPU FLT32 Instruction",
                .symbol_name = "XveFpuFlt32",
                .desc = "The percentage of time in which FLT32 instruction were processed actively on FPU INT64 pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_basic__xve_fpu_flt32__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "FPU FLT64 Instruction",
                .symbol_name = "XveFpuFlt64",
                .desc = "The percentage of time in which FLT64 instruction were processed actively on FPU INT64 pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_basic__xve_fpu_flt64__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XMX And FPU Pipes Active",
                .symbol_name = "XveFpuXmxActive",
                .desc = "The percentage of time in which XVE XMX and FPU INT64 pipelines were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_basic__xve_fpu_xmx_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE Stall",
                .symbol_name = "XveStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_basic__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE Thread Occupancy",
                .symbol_name = "XveThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied XVEs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_basic__xve_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 25);
}


static void
acmgt1_add_threads_and_rast1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ThreadsAndRast1";
    metric_set->symbol_name = "ThreadsAndRast1";
    metric_set->hw_config_guid = "952f5f55-449d-43db-87d7-6113e9c3b89a";
    metric_set->counters = calloc(6, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_threads_and_rast1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__threads_and_rast1__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__threads_and_rast1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DS Threads Dispatched",
                .symbol_name = "DsThreads",
                .desc = "Number of DS thread dispatches",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__threads_and_rast1__ds_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "ThreadDispatcher",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__threads_and_rast1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__threads_and_rast1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HS Threads Dispatched",
                .symbol_name = "HsThreads",
                .desc = "Number of HS thread dispatches",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__threads_and_rast1__hs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "ThreadDispatcher",
            },

            {
                .name = "VS Threads Dispatched",
                .symbol_name = "VsThreads",
                .desc = "Number of VS thread dispatches",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__threads_and_rast1__vs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "ThreadDispatcher",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 6);
}


static void
acmgt1_add_threads_and_rast2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ThreadsAndRast2";
    metric_set->symbol_name = "ThreadsAndRast2";
    metric_set->hw_config_guid = "797ae4a3-6d36-4be1-9064-a9bc3263957f";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_threads_and_rast2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__threads_and_rast2__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__threads_and_rast2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__threads_and_rast2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__threads_and_rast2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "PS Threads Dispatched",
                .symbol_name = "PsThreads",
                .desc = "Number of PS thread dispatches",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__threads_and_rast2__ps_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "ThreadDispatcher",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}


static void
acmgt1_add_threads_and_rast3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ThreadsAndRast3";
    metric_set->symbol_name = "ThreadsAndRast3";
    metric_set->hw_config_guid = "abb4b8fd-b9cd-4b11-a610-1c0707af14cf";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_threads_and_rast3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__threads_and_rast3__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__threads_and_rast3__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__threads_and_rast3__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__threads_and_rast3__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS Threads Dispatched",
                .symbol_name = "GsThreads",
                .desc = "Number of GS thread dispatches",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__threads_and_rast3__gs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "ThreadDispatcher",
            },

            {
                .name = "Early Hi-Depth Test Fails",
                .symbol_name = "HiDepthTestFails",
                .desc = "The total number of pixels dropped on early hierarchical depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS,
                .read_uint64 = acmgt1__threads_and_rast3__hi_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "DepthPipe",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}


static void
acmgt1_add_threads_and_rast4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ThreadsAndRast4";
    metric_set->symbol_name = "ThreadsAndRast4";
    metric_set->hw_config_guid = "2da159d5-8ace-42bb-9d81-26f2b162d8d8";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_threads_and_rast4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__threads_and_rast4__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__threads_and_rast4__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Early Depth Test Fails",
                .symbol_name = "EarlyDepthTestFails",
                .desc = "The total number of pixels dropped on early depth test.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__threads_and_rast4__early_depth_test_fails__read,
                .max_uint64 = NULL /* undefined */,
                .group = "DepthPipe",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__threads_and_rast4__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__threads_and_rast4__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}


static void
acmgt1_add_async_compute_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "AsyncCompute";
    metric_set->symbol_name = "AsyncCompute";
    metric_set->hw_config_guid = "91273130-42fe-4c5e-ba34-6f9140b612c6";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_async_compute_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "ASYNC CS EM Pipe Active",
                .symbol_name = "AsyncCsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__async_compute__async_cs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "ASYNC CS FPU Pipe Active",
                .symbol_name = "AsyncCsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__async_compute__async_cs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__async_compute__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__async_compute__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS EM Pipe Active",
                .symbol_name = "CsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__async_compute__cs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "CS FPU Pipe Active",
                .symbol_name = "CsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__async_compute__cs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = acmgt1__async_compute__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "ThreadDispatcher",
            },

            {
                .name = "EM Pipe Active",
                .symbol_name = "EmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__async_compute__em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE FPU Pipe Active",
                .symbol_name = "FpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__async_compute__fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__async_compute__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__async_compute__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__async_compute__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "FS EM Pipe Active",
                .symbol_name = "PsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a fragment shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__async_compute__ps_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "FS FPU Pipe Active",
                .symbol_name = "PsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a fragment shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__async_compute__ps_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "VS EM Pipe Active",
                .symbol_name = "VsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__async_compute__vs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "VS FPU Pipe Active",
                .symbol_name = "VsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__async_compute__vs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE Active",
                .symbol_name = "XveActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__async_compute__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE Stall",
                .symbol_name = "XveStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__async_compute__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE Thread Occupancy",
                .symbol_name = "XveThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied XVEs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__async_compute__xve_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 18);
}


static void
acmgt1_add_xve_activity1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "XveActivity1";
    metric_set->symbol_name = "XveActivity1";
    metric_set->hw_config_guid = "fd9d1ad4-13b3-4583-9f2c-998f627e370d";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_xve_activity1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__xve_activity1__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__xve_activity1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "CS Send Pipe Active",
                .symbol_name = "CsSendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing a compute shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__xve_activity1__cs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = acmgt1__xve_activity1__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "ThreadDispatcher",
            },

            {
                .name = "DS EM Pipe Active",
                .symbol_name = "DsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a domain shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__xve_activity1__ds_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "DS FPU Pipe Active",
                .symbol_name = "DsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a domain shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__xve_activity1__ds_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "DS Send Pipe Active",
                .symbol_name = "DsSendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing a domain shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__xve_activity1__ds_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__xve_activity1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__xve_activity1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__xve_activity1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS EM Pipe Active",
                .symbol_name = "GsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a geometry shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__xve_activity1__gs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "GS FPU Pipe Active",
                .symbol_name = "GsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a geometry shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__xve_activity1__gs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "GS Send Pipe Active",
                .symbol_name = "GsSendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing a geometry shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__xve_activity1__gs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "HS EM Pipe Active",
                .symbol_name = "HsEmActive",
                .desc = "The percentage of time in which XVE EM INT pipeline was actively processing a hull shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__xve_activity1__hs_em_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "HS FPU Pipe Active",
                .symbol_name = "HsFpuActive",
                .desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a hull shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__xve_activity1__hs_fpu_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "HS Send Pipe Active",
                .symbol_name = "HsSendActive",
                .desc = "The percentage of time in which XVE send pipeline was actively processing a hull shader instruction.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__xve_activity1__hs_send_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 15);
}


static void
acmgt1_add_gpu_busyness_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "GpuBusyness";
    metric_set->symbol_name = "GpuBusyness";
    metric_set->hw_config_guid = "4b785529-8efb-471e-93c5-481dae7b3b8b";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_gpu_busyness_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "Any compute engine busy",
                .symbol_name = "AnyComputeEngineBusy",
                .desc = "The percentage of time when any compute engine is busy",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__any_compute_engine_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__gpu_busyness__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__gpu_busyness__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "Blitter Ring Busy",
                .symbol_name = "BlitterBusy",
                .desc = "The percentage of time when blitter command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__blitter_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "ComputeEngine0 Ring Busy",
                .symbol_name = "ComputeEngine0Busy",
                .desc = "The percentage of time when compute command streamer 0 was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__compute_engine0_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "ComputeEngine1 Ring Busy",
                .symbol_name = "ComputeEngine1Busy",
                .desc = "The percentage of time when compute command streamer 1 was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__compute_engine1_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "ComputeEngine2 Ring Busy",
                .symbol_name = "ComputeEngine2Busy",
                .desc = "The percentage of time when compute command streamer 2 was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__compute_engine2_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "ComputeEngine3 Ring Busy",
                .symbol_name = "ComputeEngine3Busy",
                .desc = "The percentage of time when compute command streamer 3 was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__compute_engine3_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "CS Threads Dispatched",
                .symbol_name = "CsThreads",
                .desc = "The total number of compute shader hardware threads dispatched.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = acmgt1__gpu_busyness__cs_threads__read,
                .max_uint64 = NULL /* undefined */,
                .group = "ThreadDispatcher",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__gpu_busyness__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__gpu_busyness__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Render and any compute engines are simultaneously busy",
                .symbol_name = "RenderAndAnyComputeEngineBusy",
                .desc = "The percentage of time when render and any compute engines are simultaneously busy",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__render_and_any_compute_engine_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "Render Ring Busy",
                .symbol_name = "RenderBusy",
                .desc = "The percentage of time when render command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__render_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "Vdbox00 Ring Busy",
                .symbol_name = "Vdbox00Busy",
                .desc = "The percentage of time when vdbox00 command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__vdbox00_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Media",
            },

            {
                .name = "Vdbox10 Ring Busy",
                .symbol_name = "Vdbox10Busy",
                .desc = "The percentage of time when vdbox10 command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__vdbox10_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Media",
            },

            {
                .name = "Vebox0 Ring Busy",
                .symbol_name = "Vebox0Busy",
                .desc = "The percentage of time when vebox0 command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__vebox0_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Media",
            },

            {
                .name = "Vebox1 Ring Busy",
                .symbol_name = "Vebox1Busy",
                .desc = "The percentage of time when vebox1 command streamer was busy.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__vebox1_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "Media",
            },

            {
                .name = "XVE Active",
                .symbol_name = "XveActive",
                .desc = "The percentage of time in which the Execution Units were actively processing.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE Stall",
                .symbol_name = "XveStall",
                .desc = "The percentage of time in which the Execution Units were stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE Thread Occupancy",
                .symbol_name = "XveThreadOccupancy",
                .desc = "The percentage of time in which hardware threads occupied XVEs.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__gpu_busyness__xve_thread_occupancy__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 20);
}


static void
acmgt1_add_render_pipe_profile1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile1";
    metric_set->hw_config_guid = "8a0c5d31-e0cb-4d2c-8056-f3824c57ad9a";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_render_pipe_profile1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__render_pipe_profile1__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__render_pipe_profile1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "BC20 Bottleneck",
                .symbol_name = "Bc20Bottleneck",
                .desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__bc20_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "Clipper2 Bottleneck",
                .symbol_name = "Cl2Bottleneck",
                .desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__cl2_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "CL2 Stall",
                .symbol_name = "Cl2Stall",
                .desc = "The percentage of time in which clipper pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__cl2_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "DS2 Bottleneck",
                .symbol_name = "Ds2Bottleneck",
                .desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__ds2_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "DS2 Stall",
                .symbol_name = "Ds2Stall",
                .desc = "The percentage of time in which domain shader pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__ds2_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__render_pipe_profile1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__render_pipe_profile1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS2 Bottleneck",
                .symbol_name = "Gs2Bottleneck",
                .desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__gs2_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "Hi-Depth20 Bottleneck",
                .symbol_name = "HiDepth20Bottleneck",
                .desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__hi_depth20_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "DepthPipe",
            },

            {
                .name = "HS2 Bottleneck",
                .symbol_name = "Hs2Bottleneck",
                .desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__hs2_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "HS2 Stall",
                .symbol_name = "Hs2Stall",
                .desc = "The percentage of time in which hull stall pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__hs2_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "SF2 Bottleneck",
                .symbol_name = "Sf2Bottleneck",
                .desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__sf2_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "SF2 Stall",
                .symbol_name = "Sf2Stall",
                .desc = "The percentage of time in which strip-fans pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__sf2_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "SO2 Bottleneck",
                .symbol_name = "So2Bottleneck",
                .desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__so2_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "SO2 Stall",
                .symbol_name = "So2Stall",
                .desc = "The percentage of time in which stream-output pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__so2_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "VF2 Bottleneck",
                .symbol_name = "Vf2Bottleneck",
                .desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__vf2_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "VS2 Bottleneck",
                .symbol_name = "Vs2Bottleneck",
                .desc = "The percentage of time in which VS2 pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile1__vs2_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 19);
}


static void
acmgt1_add_render_pipe_profile2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile2";
    metric_set->hw_config_guid = "0f40fba0-129a-4a19-87de-5fdbe111b915";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_render_pipe_profile2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__render_pipe_profile2__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__render_pipe_profile2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "BC30 Bottleneck",
                .symbol_name = "Bc30Bottleneck",
                .desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__bc30_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "Clipper3 Bottleneck",
                .symbol_name = "Cl3Bottleneck",
                .desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__cl3_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "CL3 Stall",
                .symbol_name = "Cl3Stall",
                .desc = "The percentage of time in which clipper pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__cl3_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "DS3 Bottleneck",
                .symbol_name = "Ds3Bottleneck",
                .desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__ds3_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "DS3 Stall",
                .symbol_name = "Ds3Stall",
                .desc = "The percentage of time in which domain shader pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__ds3_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__render_pipe_profile2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__render_pipe_profile2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GS3 Bottleneck",
                .symbol_name = "Gs3Bottleneck",
                .desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__gs3_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "Hi-Depth30 Bottleneck",
                .symbol_name = "HiDepth30Bottleneck",
                .desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__hi_depth30_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "DepthPipe",
            },

            {
                .name = "HS3 Bottleneck",
                .symbol_name = "Hs3Bottleneck",
                .desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__hs3_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "HS3 Stall",
                .symbol_name = "Hs3Stall",
                .desc = "The percentage of time in which hull stall pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__hs3_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "SF3 Bottleneck",
                .symbol_name = "Sf3Bottleneck",
                .desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__sf3_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "SF3 Stall",
                .symbol_name = "Sf3Stall",
                .desc = "The percentage of time in which strip-fans pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__sf3_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "SO3 Bottleneck",
                .symbol_name = "So3Bottleneck",
                .desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__so3_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "SO3 Stall",
                .symbol_name = "So3Stall",
                .desc = "The percentage of time in which stream-output pipeline stage was stalled.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__so3_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "VF3 Bottleneck",
                .symbol_name = "Vf3Bottleneck",
                .desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__vf3_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "VS3 Bottleneck",
                .symbol_name = "Vs3Bottleneck",
                .desc = "The percentage of time in which VS3 pipeline stage was slowing down the 3D pipeline.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__render_pipe_profile2__vs3_bottleneck__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 19);
}


static void
acmgt1_add_l3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3";
    metric_set->symbol_name = "L3";
    metric_set->hw_config_guid = "24695fb7-a404-4cd6-9aad-d23738b6d499";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_l3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__l3__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__l3__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__l3__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__l3__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Quad1 L3 Bank0 Input Available",
                .symbol_name = "L31Bank0InputAvailable",
                .desc = "The percentage of time in which Quad1 L3 bank0 has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank0_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank0 Output Ready",
                .symbol_name = "L31Bank0OutputReady",
                .desc = "The percentage of time in which quad1 L3 bank0 output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank0_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank1 Input Available",
                .symbol_name = "L31Bank1InputAvailable",
                .desc = "The percentage of time in which Quad1 L3 bank1 has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank1_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank1 Output Ready",
                .symbol_name = "L31Bank1OutputReady",
                .desc = "The percentage of time in which quad1 L3 bank1 output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank1_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank2 Input Available",
                .symbol_name = "L31Bank2InputAvailable",
                .desc = "The percentage of time in which Quad1 L3 bank2 has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank2_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank2 Output Ready",
                .symbol_name = "L31Bank2OutputReady",
                .desc = "The percentage of time in which quad1 L3 bank2 output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank2_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank3 Input Available",
                .symbol_name = "L31Bank3InputAvailable",
                .desc = "The percentage of time in which Quad1 L3 bank3 has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank3_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank3 Output Ready",
                .symbol_name = "L31Bank3OutputReady",
                .desc = "The percentage of time in which quad1 L3 bank3 output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank3_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank4 Input Available",
                .symbol_name = "L31Bank4InputAvailable",
                .desc = "The percentage of time in which Quad1 L3 bank4 has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank4_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank4 Output Ready",
                .symbol_name = "L31Bank4OutputReady",
                .desc = "The percentage of time in which quad1 L3 bank4 output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank4_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank5 Input Available",
                .symbol_name = "L31Bank5InputAvailable",
                .desc = "The percentage of time in which Quad1 L3 bank5 has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank5_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank5 Output Ready",
                .symbol_name = "L31Bank5OutputReady",
                .desc = "The percentage of time in which quad1 L3 bank5 output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank5_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank6 Input Available",
                .symbol_name = "L31Bank6InputAvailable",
                .desc = "The percentage of time in which Quad1 L3 bank6 has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank6_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank6 Output Ready",
                .symbol_name = "L31Bank6OutputReady",
                .desc = "The percentage of time in which quad1 L3 bank6 output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank6_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank7 Input Available",
                .symbol_name = "L31Bank7InputAvailable",
                .desc = "The percentage of time in which Quad1 L3 bank7 has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank7_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },

            {
                .name = "Quad1 L3 Bank7 Output Ready",
                .symbol_name = "L31Bank7OutputReady",
                .desc = "The percentage of time in which quad1 L3 bank7 output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l3__l31_bank7_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 20);
}

static bool acmgt1_sampler_Sampler20InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler20OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler21InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler21OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler22InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler22OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler23InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler23OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler30InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler30OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler31InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler31OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler32InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler32OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler33InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_sampler_Sampler33OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_sampler_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Sampler_Slice23";
    metric_set->symbol_name = "Sampler";
    metric_set->hw_config_guid = "4486113b-a8a7-4f75-a1c2-7d307fa0e00e";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_sampler_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__sampler__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__sampler__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__sampler__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__sampler__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Slice2 Xe Core0 Input Available",
                .symbol_name = "Sampler20InputAvailable",
                .desc = "The percentage of time in which slice2 Xe core0 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler20_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler20InputAvailable_availability,
            },

            {
                .name = "Slice2 Xe Core0 Sampler Output Ready",
                .symbol_name = "Sampler20OutputReady",
                .desc = "The percentage of time in which slice2 Xe core0 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler20_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler20OutputReady_availability,
            },

            {
                .name = "Slice2 Xe Core1 Input Available",
                .symbol_name = "Sampler21InputAvailable",
                .desc = "The percentage of time in which slice2 Xe core1 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler21_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler21InputAvailable_availability,
            },

            {
                .name = "Slice2 Xe Core1 Sampler Output Ready",
                .symbol_name = "Sampler21OutputReady",
                .desc = "The percentage of time in which slice2 Xe core1 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler21_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler21OutputReady_availability,
            },

            {
                .name = "Slice2 Xe Core2 Input Available",
                .symbol_name = "Sampler22InputAvailable",
                .desc = "The percentage of time in which slice2 Xe core2 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler22_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler22InputAvailable_availability,
            },

            {
                .name = "Slice2 Xe Core2 Sampler Output Ready",
                .symbol_name = "Sampler22OutputReady",
                .desc = "The percentage of time in which slice2 Xe core2 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler22_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler22OutputReady_availability,
            },

            {
                .name = "Slice2 Xe Core3 Input Available",
                .symbol_name = "Sampler23InputAvailable",
                .desc = "The percentage of time in which slice2 Xe core3 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler23_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler23InputAvailable_availability,
            },

            {
                .name = "Slice2 Xe Core3 Sampler Output Ready",
                .symbol_name = "Sampler23OutputReady",
                .desc = "The percentage of time in which slice2 Xe core3 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler23_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler23OutputReady_availability,
            },

            {
                .name = "Slice3 Xe Core0 Input Available",
                .symbol_name = "Sampler30InputAvailable",
                .desc = "The percentage of time in which slice3 Xe core0 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler30_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler30InputAvailable_availability,
            },

            {
                .name = "Slice3 Xe Core0 Sampler Output Ready",
                .symbol_name = "Sampler30OutputReady",
                .desc = "The percentage of time in which slice3 Xe core0 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler30_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler30OutputReady_availability,
            },

            {
                .name = "Slice3 Xe Core1 Input Available",
                .symbol_name = "Sampler31InputAvailable",
                .desc = "The percentage of time in which slice3 Xe core1 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler31_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler31InputAvailable_availability,
            },

            {
                .name = "Slice3 Xe Core1 Sampler Output Ready",
                .symbol_name = "Sampler31OutputReady",
                .desc = "The percentage of time in which slice3 Xe core1 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler31_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler31OutputReady_availability,
            },

            {
                .name = "Slice3 Xe Core2 Input Available",
                .symbol_name = "Sampler32InputAvailable",
                .desc = "The percentage of time in which slice3 Xe core2 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler32_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler32InputAvailable_availability,
            },

            {
                .name = "Slice3 Xe Core2 Sampler Output Ready",
                .symbol_name = "Sampler32OutputReady",
                .desc = "The percentage of time in which slice3 Xe core2 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler32_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler32OutputReady_availability,
            },

            {
                .name = "Slice3 Xe Core3 Input Available",
                .symbol_name = "Sampler33InputAvailable",
                .desc = "The percentage of time in which slice3 Xe core3 sampler input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler33_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler33InputAvailable_availability,
            },

            {
                .name = "Slice3 Xe Core3 Sampler Output Ready",
                .symbol_name = "Sampler33OutputReady",
                .desc = "The percentage of time in which slice3 Xe core3 sampler output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__sampler__sampler33_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_sampler_Sampler33OutputReady_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 20);
}

static bool acmgt1_hdc_and_sf1_NonSamplerShader20AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_hdc_and_sf1_NonSamplerShader21AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_hdc_and_sf1_NonSamplerShader22AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_hdc_and_sf1_NonSamplerShader23AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_hdc_and_sf1_NonSamplerShader30AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_hdc_and_sf1_NonSamplerShader31AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_hdc_and_sf1_NonSamplerShader32AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_hdc_and_sf1_NonSamplerShader33AccessStalledOnL3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_hdc_and_sf1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF1";
    metric_set->symbol_name = "HDCAndSF1";
    metric_set->hw_config_guid = "75fc20f8-8694-47f2-b67b-cbb35f697a8e";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_hdc_and_sf1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__hdc_and_sf1__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__hdc_and_sf1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__hdc_and_sf1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__hdc_and_sf1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__hdc_and_sf1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Slice2 Xe Core0 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader20AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice2 Xe Core0)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__hdc_and_sf1__non_sampler_shader20_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_hdc_and_sf1_NonSamplerShader20AccessStalledOnL3_availability,
            },

            {
                .name = "Slice2 Xe Core1 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader21AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice2 Xe Core1)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__hdc_and_sf1__non_sampler_shader21_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_hdc_and_sf1_NonSamplerShader21AccessStalledOnL3_availability,
            },

            {
                .name = "Slice2 Xe Core2 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader22AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice2 Xe Core2)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__hdc_and_sf1__non_sampler_shader22_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_hdc_and_sf1_NonSamplerShader22AccessStalledOnL3_availability,
            },

            {
                .name = "Slice2 Xe Core3 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader23AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice2 Xe Core3)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__hdc_and_sf1__non_sampler_shader23_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_hdc_and_sf1_NonSamplerShader23AccessStalledOnL3_availability,
            },

            {
                .name = "Slice3 Xe Core0 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader30AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice3 Xe Core0)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__hdc_and_sf1__non_sampler_shader30_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_hdc_and_sf1_NonSamplerShader30AccessStalledOnL3_availability,
            },

            {
                .name = "Slice3 Xe Core1 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader31AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice3 Xe Core1)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__hdc_and_sf1__non_sampler_shader31_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_hdc_and_sf1_NonSamplerShader31AccessStalledOnL3_availability,
            },

            {
                .name = "Slice3 Xe Core2 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader32AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice3 Xe Core2)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__hdc_and_sf1__non_sampler_shader32_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_hdc_and_sf1_NonSamplerShader32AccessStalledOnL3_availability,
            },

            {
                .name = "Slice3 Xe Core3 Non-sampler Shader Access Stalled On L3",
                .symbol_name = "NonSamplerShader33AccessStalledOnL3",
                .desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice3 Xe Core3)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__hdc_and_sf1__non_sampler_shader33_access_stalled_on_l3__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_hdc_and_sf1_NonSamplerShader33AccessStalledOnL3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 12);
}


static void
acmgt1_add_hdc_and_sf2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF2";
    metric_set->symbol_name = "HDCAndSF2";
    metric_set->hw_config_guid = "d5e02a31-fc87-4cdc-8136-4b19e00b7e94";
    metric_set->counters = calloc(8, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_hdc_and_sf2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__hdc_and_sf2__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__hdc_and_sf2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "SQ20 is full",
                .symbol_name = "GTRequestQueue20Full",
                .desc = "The percentage of time when IDI0 SQ20 is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__hdc_and_sf2__gt_request_queue20_full__read,
                .max_float = percentage_max_callback_float,
                .group = "Memory",
            },

            {
                .name = "SQ30 is full",
                .symbol_name = "GTRequestQueue30Full",
                .desc = "The percentage of time when IDI0 SQ30 is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__hdc_and_sf2__gt_request_queue30_full__read,
                .max_float = percentage_max_callback_float,
                .group = "Memory",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__hdc_and_sf2__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__hdc_and_sf2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__hdc_and_sf2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Polygon (Slice2) Data Ready",
                .symbol_name = "Poly2DataReady",
                .desc = "The percentage of time in which geometry pipeline output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__hdc_and_sf2__poly2_data_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },

            {
                .name = "Polygon (Slice3) Data Ready",
                .symbol_name = "Poly3DataReady",
                .desc = "The percentage of time in which geometry pipeline output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__hdc_and_sf2__poly3_data_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "Geometry",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 8);
}

static bool acmgt1_rasterizer_and_pixel_backend1_Rasterizer2InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_rasterizer_and_pixel_backend1_Rasterizer3OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_rasterizer_and_pixel_backend1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend1";
    metric_set->symbol_name = "RasterizerAndPixelBackend1";
    metric_set->hw_config_guid = "08858210-0dc3-452b-afee-e5c7811c01cb";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_rasterizer_and_pixel_backend1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__rasterizer_and_pixel_backend1__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__rasterizer_and_pixel_backend1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__rasterizer_and_pixel_backend1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__rasterizer_and_pixel_backend1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__rasterizer_and_pixel_backend1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "PS10 Output Available",
                .symbol_name = "PSOutput10Available",
                .desc = "The percentage of time in which PS10 output is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__rasterizer_and_pixel_backend1__ps_output10_available__read,
                .max_float = percentage_max_callback_float,
                .group = "ColorPipe",
            },

            {
                .name = "PS11 Output Available",
                .symbol_name = "PSOutput11Available",
                .desc = "The percentage of time in which PS11 output is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__rasterizer_and_pixel_backend1__ps_output11_available__read,
                .max_float = percentage_max_callback_float,
                .group = "ColorPipe",
            },

            {
                .name = "Slice2 Pipe0 Post-EarlyZ Pixel Data Ready",
                .symbol_name = "PixelData20Ready",
                .desc = "The percentage of time in which slice2  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__rasterizer_and_pixel_backend1__pixel_data20_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "DepthPipe",
            },

            {
                .name = "Slice2 Pipe1 Post-EarlyZ Pixel Data Ready",
                .symbol_name = "PixelData21Ready",
                .desc = "The percentage of time in which slice2  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__rasterizer_and_pixel_backend1__pixel_data21_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "DepthPipe",
            },

            {
                .name = "Pixel Values 10 Ready",
                .symbol_name = "PixelValues10Ready",
                .desc = "The percentage of time in which pixel values 10 are ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__rasterizer_and_pixel_backend1__pixel_values10_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "ColorPipe",
            },

            {
                .name = "Pixel Values 11 Ready",
                .symbol_name = "PixelValues11Ready",
                .desc = "The percentage of time in which pixel values 11 are ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__rasterizer_and_pixel_backend1__pixel_values11_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "ColorPipe",
            },

            {
                .name = "Slice2 Rasterizer Input Available",
                .symbol_name = "Rasterizer2InputAvailable",
                .desc = "The percentage of time in which slice2 rasterizer input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__rasterizer_and_pixel_backend1__rasterizer2_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "Rasterizer",
                .availability = acmgt1_rasterizer_and_pixel_backend1_Rasterizer2InputAvailable_availability,
            },

            {
                .name = "Slice3 Rasterizer Output Ready",
                .symbol_name = "Rasterizer3OutputReady",
                .desc = "The percentage of time in which slice3 rasterizer output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__rasterizer_and_pixel_backend1__rasterizer3_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "Rasterizer",
                .availability = acmgt1_rasterizer_and_pixel_backend1_Rasterizer3OutputReady_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 12);
}

static bool acmgt1_rasterizer_and_pixel_backend2_Rasterizer2OutputReady_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_rasterizer_and_pixel_backend2_Rasterizer3InputAvailable_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_rasterizer_and_pixel_backend2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend2";
    metric_set->symbol_name = "RasterizerAndPixelBackend2";
    metric_set->hw_config_guid = "30b71e0c-55eb-49ed-8863-ee7db68ff1b1";
    metric_set->counters = calloc(8, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_rasterizer_and_pixel_backend2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__rasterizer_and_pixel_backend2__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__rasterizer_and_pixel_backend2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__rasterizer_and_pixel_backend2__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__rasterizer_and_pixel_backend2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__rasterizer_and_pixel_backend2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Slice3 Pipe0 Post-EarlyZ Pixel Data Ready",
                .symbol_name = "PixelData30Ready",
                .desc = "The percentage of time in which slice3  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__rasterizer_and_pixel_backend2__pixel_data30_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "DepthPipe",
            },

            {
                .name = "Slice3 Pipe1 Post-EarlyZ Pixel Data Ready",
                .symbol_name = "PixelData31Ready",
                .desc = "The percentage of time in which slice3  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__rasterizer_and_pixel_backend2__pixel_data31_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "DepthPipe",
            },

            {
                .name = "Slice2 Rasterizer Output Ready",
                .symbol_name = "Rasterizer2OutputReady",
                .desc = "The percentage of time in which slice2 rasterizer output is ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__rasterizer_and_pixel_backend2__rasterizer2_output_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "Rasterizer",
                .availability = acmgt1_rasterizer_and_pixel_backend2_Rasterizer2OutputReady_availability,
            },

            {
                .name = "Slice3 Rasterizer Input Available",
                .symbol_name = "Rasterizer3InputAvailable",
                .desc = "The percentage of time in which slice3 rasterizer input is available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__rasterizer_and_pixel_backend2__rasterizer3_input_available__read,
                .max_float = percentage_max_callback_float,
                .group = "Rasterizer",
                .availability = acmgt1_rasterizer_and_pixel_backend2_Rasterizer3InputAvailable_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 8);
}

static bool acmgt1_tdl1_NonPSThread20ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_NonPSThread21ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_NonPSThread22ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_NonPSThread23ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_NonPSThread30ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_NonPSThread31ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_NonPSThread32ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_NonPSThread33ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_ThreadHeader23ReadyPort0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_ThreadHeader23ReadyPort1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_ThreadHeader23ReadyPort2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_ThreadHeader23ReadyPort3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_ThreadHeader33ReadyPort0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_ThreadHeader33ReadyPort1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_ThreadHeader33ReadyPort2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl1_ThreadHeader33ReadyPort3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_tdl1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL1";
    metric_set->symbol_name = "TDL1";
    metric_set->hw_config_guid = "3620f0df-42c6-4904-b395-5497f5a2ea4b";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_tdl1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__tdl1__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__tdl1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__tdl1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__tdl1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice2 Xe Core0 Thread Dispatcher",
                .symbol_name = "NonPSThread20ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice2 Xe core0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__non_ps_thread20_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_NonPSThread20ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice2 Xe Core1 Thread Dispatcher",
                .symbol_name = "NonPSThread21ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice2 Xe core1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__non_ps_thread21_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_NonPSThread21ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice2 Xe Core2 Thread Dispatcher",
                .symbol_name = "NonPSThread22ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice2 Xe core2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__non_ps_thread22_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_NonPSThread22ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice2 Xe Core3 Thread Dispatcher",
                .symbol_name = "NonPSThread23ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice2 Xe core3 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__non_ps_thread23_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_NonPSThread23ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice3 Xe Core0 Thread Dispatcher",
                .symbol_name = "NonPSThread30ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice3 Xe core0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__non_ps_thread30_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_NonPSThread30ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice3 Xe Core1 Thread Dispatcher",
                .symbol_name = "NonPSThread31ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice3 Xe core1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__non_ps_thread31_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_NonPSThread31ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice3 Xe Core2 Thread Dispatcher",
                .symbol_name = "NonPSThread32ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice3 Xe core2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__non_ps_thread32_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_NonPSThread32ReadyForDispatch_availability,
            },

            {
                .name = "Non-PS Thread Ready For Dispatch on Slice3 Xe Core3 Thread Dispatcher",
                .symbol_name = "NonPSThread33ReadyForDispatch",
                .desc = "The percentage of time in which non-PS thread is ready for dispatch on slice3 Xe core3 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__non_ps_thread33_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_NonPSThread33ReadyForDispatch_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader23ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__thread_header23_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_ThreadHeader23ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader23ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__thread_header23_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_ThreadHeader23ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher Port 2",
                .symbol_name = "ThreadHeader23ReadyPort2",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher port 2",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__thread_header23_ready_port2__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_ThreadHeader23ReadyPort2_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher Port 3",
                .symbol_name = "ThreadHeader23ReadyPort3",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher port 3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__thread_header23_ready_port3__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_ThreadHeader23ReadyPort3_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader33ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__thread_header33_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_ThreadHeader33ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader33ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__thread_header33_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_ThreadHeader33ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher Port 2",
                .symbol_name = "ThreadHeader33ReadyPort2",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher port 2",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__thread_header33_ready_port2__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_ThreadHeader33ReadyPort2_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher Port 3",
                .symbol_name = "ThreadHeader33ReadyPort3",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher port 3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl1__thread_header33_ready_port3__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl1_ThreadHeader33ReadyPort3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 20);
}

static bool acmgt1_tdl2_PSThread20ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl2_PSThread21ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl2_PSThread22ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl2_PSThread23ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl2_PSThread30ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl2_PSThread31ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl2_PSThread32ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl2_PSThread33ReadyForDispatch_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_tdl2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL2";
    metric_set->symbol_name = "TDL2";
    metric_set->hw_config_guid = "28357a3a-a53b-4da4-a5b7-395dbfa501f1";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_tdl2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__tdl2__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__tdl2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl2__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__tdl2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__tdl2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice2 Xe Core0 Thread Dispatcher",
                .symbol_name = "PSThread20ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice2 Xe core0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl2__ps_thread20_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl2_PSThread20ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice2 Xe Core1 Thread Dispatcher",
                .symbol_name = "PSThread21ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice2 Xe core1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl2__ps_thread21_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl2_PSThread21ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice2 Xe Core2 Thread Dispatcher",
                .symbol_name = "PSThread22ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice2 Xe core2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl2__ps_thread22_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl2_PSThread22ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice2 Xe Core3 Thread Dispatcher",
                .symbol_name = "PSThread23ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice2 Xe core3 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl2__ps_thread23_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl2_PSThread23ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice3 Xe Core0 Thread Dispatcher",
                .symbol_name = "PSThread30ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice3 Xe core0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl2__ps_thread30_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl2_PSThread30ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice3 Xe Core1 Thread Dispatcher",
                .symbol_name = "PSThread31ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice3 Xe core1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl2__ps_thread31_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl2_PSThread31ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice3 Xe Core2 Thread Dispatcher",
                .symbol_name = "PSThread32ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice3 Xe core2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl2__ps_thread32_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl2_PSThread32ReadyForDispatch_availability,
            },

            {
                .name = "PS Thread Ready For Dispatch on Slice3 Xe Core3 Thread Dispatcher",
                .symbol_name = "PSThread33ReadyForDispatch",
                .desc = "The percentage of time in which PS thread is ready for dispatch on slice3 Xe core3 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl2__ps_thread33_ready_for_dispatch__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl2_PSThread33ReadyForDispatch_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 12);
}

static bool acmgt1_tdl3_ThreadHeader20Ready_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader20ReadyPort0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader20ReadyPort1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader20ReadyPort2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader20ReadyPort3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader21Ready_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader21ReadyPort0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader21ReadyPort1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader21ReadyPort2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader21ReadyPort3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader22Ready_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader22ReadyPort0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader22ReadyPort1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader22ReadyPort2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader22ReadyPort3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl3_ThreadHeader23Ready_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_tdl3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL3";
    metric_set->symbol_name = "TDL3";
    metric_set->hw_config_guid = "262cf8cb-824e-4f48-bac4-6be3d8dda6a5";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_tdl3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__tdl3__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__tdl3__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__tdl3__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__tdl3__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher",
                .symbol_name = "ThreadHeader20Ready",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header20_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader20Ready_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader20ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header20_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader20ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader20ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header20_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader20ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher Port 2",
                .symbol_name = "ThreadHeader20ReadyPort2",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher port 2",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header20_ready_port2__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader20ReadyPort2_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher Port 3",
                .symbol_name = "ThreadHeader20ReadyPort3",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher port 3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header20_ready_port3__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader20ReadyPort3_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher",
                .symbol_name = "ThreadHeader21Ready",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header21_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader21Ready_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader21ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header21_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader21ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader21ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header21_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader21ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher Port 2",
                .symbol_name = "ThreadHeader21ReadyPort2",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher port 2",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header21_ready_port2__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader21ReadyPort2_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher Port 3",
                .symbol_name = "ThreadHeader21ReadyPort3",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher port 3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header21_ready_port3__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader21ReadyPort3_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher",
                .symbol_name = "ThreadHeader22Ready",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header22_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader22Ready_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader22ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header22_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader22ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader22ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header22_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader22ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher Port 2",
                .symbol_name = "ThreadHeader22ReadyPort2",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher port 2",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header22_ready_port2__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader22ReadyPort2_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher Port 3",
                .symbol_name = "ThreadHeader22ReadyPort3",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher port 3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header22_ready_port3__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader22ReadyPort3_availability,
            },

            {
                .name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher",
                .symbol_name = "ThreadHeader23Ready",
                .desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl3__thread_header23_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl3_ThreadHeader23Ready_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 20);
}

static bool acmgt1_tdl4_ThreadHeader30Ready_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader30ReadyPort0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader30ReadyPort1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader30ReadyPort2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader30ReadyPort3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader31Ready_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader31ReadyPort0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader31ReadyPort1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader31ReadyPort2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader31ReadyPort3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader32Ready_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader32ReadyPort0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader32ReadyPort1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader32ReadyPort2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader32ReadyPort3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_tdl4_ThreadHeader33Ready_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_tdl4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL4";
    metric_set->symbol_name = "TDL4";
    metric_set->hw_config_guid = "1e629e21-abd2-418e-a184-753977bb529b";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_tdl4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__tdl4__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__tdl4__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Busy",
                .symbol_name = "GpuBusy",
                .desc = "The percentage of time in which the GPU has been processing GPU commands.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__gpu_busy__read,
                .max_float = percentage_max_callback_float,
                .group = "FrontEnd",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__tdl4__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__tdl4__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher",
                .symbol_name = "ThreadHeader30Ready",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header30_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader30Ready_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader30ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header30_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader30ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader30ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header30_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader30ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher Port 2",
                .symbol_name = "ThreadHeader30ReadyPort2",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher port 2",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header30_ready_port2__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader30ReadyPort2_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher Port 3",
                .symbol_name = "ThreadHeader30ReadyPort3",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher port 3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header30_ready_port3__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader30ReadyPort3_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher",
                .symbol_name = "ThreadHeader31Ready",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header31_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader31Ready_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader31ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header31_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader31ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader31ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header31_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader31ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher Port 2",
                .symbol_name = "ThreadHeader31ReadyPort2",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher port 2",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header31_ready_port2__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader31ReadyPort2_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher Port 3",
                .symbol_name = "ThreadHeader31ReadyPort3",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher port 3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header31_ready_port3__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader31ReadyPort3_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher",
                .symbol_name = "ThreadHeader32Ready",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header32_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader32Ready_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher Port 0",
                .symbol_name = "ThreadHeader32ReadyPort0",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher port 0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header32_ready_port0__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader32ReadyPort0_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher Port 1",
                .symbol_name = "ThreadHeader32ReadyPort1",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher port 1",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header32_ready_port1__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader32ReadyPort1_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher Port 2",
                .symbol_name = "ThreadHeader32ReadyPort2",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher port 2",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header32_ready_port2__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader32ReadyPort2_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher Port 3",
                .symbol_name = "ThreadHeader32ReadyPort3",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher port 3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header32_ready_port3__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader32ReadyPort3_availability,
            },

            {
                .name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher",
                .symbol_name = "ThreadHeader33Ready",
                .desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__tdl4__thread_header33_ready__read,
                .max_float = percentage_max_callback_float,
                .group = "ThreadDispatcher",
                .availability = acmgt1_tdl4_ThreadHeader33Ready_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 20);
}


static void
acmgt1_add_test_oa_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set TestOa";
    metric_set->symbol_name = "TestOa";
    metric_set->hw_config_guid = "57f210de-b537-464a-af7b-7dfe2f3780c1";
    metric_set->counters = calloc(13, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_test_oa_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__test_oa__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__test_oa__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "TestCounter0",
                .symbol_name = "Counter0",
                .desc = "HW test counter 0. Factor: 0.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter1",
                .symbol_name = "Counter1",
                .desc = "HW test counter 1. Factor: 1.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter2",
                .symbol_name = "Counter2",
                .desc = "HW test counter 2. Factor: 1.0",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter3",
                .symbol_name = "Counter3",
                .desc = "HW test counter 3. Factor: 0.5",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter4",
                .symbol_name = "Counter4",
                .desc = "HW test counter 4. Factor: 0.3333",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter5",
                .symbol_name = "Counter5",
                .desc = "HW test counter 5. Factor: 0.3333",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter6",
                .symbol_name = "Counter6",
                .desc = "HW test counter 6. Factor: 0.16666",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter7",
                .symbol_name = "Counter7",
                .desc = "HW test counter 7. Factor: 0.6666",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter8",
                .symbol_name = "Counter8",
                .desc = "HW test counter 8. Should be equal to 1 in IOStream or in OAG query mode",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter8__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "TestCounter9 - OAR enable",
                .symbol_name = "Counter9",
                .desc = "HW test counter 9. Should be equal to 1 in query.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__test_oa__counter9__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Test",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__test_oa__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__test_oa__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 13);
}


static void
acmgt1_add_compute_overview_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ComputeOverview";
    metric_set->symbol_name = "ComputeOverview";
    metric_set->hw_config_guid = "37b5b93b-6acf-4726-9b57-1a65fab22bb2";
    metric_set->counters = calloc(26, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_compute_overview_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__compute_overview__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__compute_overview__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE READ",
                .symbol_name = "GPU_MEMORY_BYTE_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__compute_overview__gpu_memory_byte_read__read,
                .max_uint64 = acmgt1__compute_overview__gpu_memory_byte_read__max,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__compute_overview__gpu_memory_byte_write__read,
                .max_uint64 = acmgt1__compute_overview__gpu_memory_byte_write__max,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__compute_overview__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__compute_overview__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 BYTE READ",
                .symbol_name = "L3_BYTE_READ",
                .desc = "Number of bytes read from L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__compute_overview__l3_byte_read__read,
                .max_uint64 = acmgt1__compute_overview__l3_byte_read__max,
                .group = "L3Cache",
            },

            {
                .name = "L3 BYTE WRITE",
                .symbol_name = "L3_BYTE_WRITE",
                .desc = "Number of bytes written to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__compute_overview__l3_byte_write__read,
                .max_uint64 = acmgt1__compute_overview__l3_byte_write__max,
                .group = "L3Cache",
            },

            {
                .name = "XVE ACTIVE",
                .symbol_name = "XVE_ACTIVE",
                .desc = "Percentage of time in which at least one pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_overview__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE ATOMIC ACCESS COUNT",
                .symbol_name = "XVE_ATOMIC_ACCESS_COUNT",
                .desc = "Number of shader atomic memory accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__compute_overview__xve_atomic_access_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "VectorEngine",
            },

            {
                .name = "XVE BARRIER MESSAGE COUNT",
                .symbol_name = "XVE_BARRIER_MESSAGE_COUNT",
                .desc = "Number of shader barrier messages",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES,
                .read_uint64 = acmgt1__compute_overview__xve_barrier_message_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "VectorEngine",
            },

            {
                .name = "XVE BUSY",
                .symbol_name = "XVE_BUSY",
                .desc = "Any XVE thread loaded.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__compute_overview__xve_busy__read,
                .max_uint64 = acmgt1__compute_overview__xve_busy__max,
                .group = "VectorEngine",
            },

            {
                .name = "XVE COMPUTE THREAD COUNT",
                .symbol_name = "XVE_COMPUTE_THREAD_COUNT",
                .desc = "Number of compute shader hardware threads dispatched",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = acmgt1__compute_overview__xve_compute_thread_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "VectorEngine",
            },

            {
                .name = "XVE INST EXECUTED ALU0 ALL",
                .symbol_name = "XVE_INST_EXECUTED_ALU0_ALL",
                .desc = "Number of execution slots taken by instructions executed on ALU0 pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__compute_overview__xve_inst_executed_alu0_all__read,
                .max_uint64 = acmgt1__compute_overview__xve_inst_executed_alu0_all__max,
                .group = "VectorEngine",
            },

            {
                .name = "XVE INST EXECUTED ALU0 ALL UTILIZATION",
                .symbol_name = "XVE_INST_EXECUTED_ALU0_ALL_UTILIZATION",
                .desc = "Percentage of execution slots taken by instructions executed on ALU0 pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_overview__xve_inst_executed_alu0_all_utilization__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE INST EXECUTED ALU1 ALL",
                .symbol_name = "XVE_INST_EXECUTED_ALU1_ALL",
                .desc = "Number of execution slots taken by instructions executed on ALU1 pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__compute_overview__xve_inst_executed_alu1_all__read,
                .max_uint64 = acmgt1__compute_overview__xve_inst_executed_alu1_all__max,
                .group = "VectorEngine",
            },

            {
                .name = "XVE INST EXECUTED ALU1 ALL UTILIZATION",
                .symbol_name = "XVE_INST_EXECUTED_ALU1_ALL_UTILIZATION",
                .desc = "Percentage of execution slots taken by instructions executed on ALU1 pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_overview__xve_inst_executed_alu1_all_utilization__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE INST EXECUTED CONTROL ALL",
                .symbol_name = "XVE_INST_EXECUTED_CONTROL_ALL",
                .desc = "Number of instructions executed on Jump Pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__compute_overview__xve_inst_executed_control_all__read,
                .max_uint64 = acmgt1__compute_overview__xve_inst_executed_control_all__max,
                .group = "VectorEngine",
            },

            {
                .name = "XVE INST EXECUTED CONTROL ALL UTILIZATION",
                .symbol_name = "XVE_INST_EXECUTED_CONTROL_ALL_UTILIZATION",
                .desc = "Percentage of time taken by instructions executed on Jump Pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_overview__xve_inst_executed_control_all_utilization__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE INST EXECUTED SEND ALL",
                .symbol_name = "XVE_INST_EXECUTED_SEND_ALL",
                .desc = "Number of instructions executed on SEND pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__compute_overview__xve_inst_executed_send_all__read,
                .max_uint64 = acmgt1__compute_overview__xve_inst_executed_send_all__max,
                .group = "VectorEngine",
            },

            {
                .name = "XVE INST EXECUTED SEND ALL UTILIZATION",
                .symbol_name = "XVE_INST_EXECUTED_SEND_ALL_UTILIZATION",
                .desc = "Percentage of time taken by instructions executed on SEND pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_overview__xve_inst_executed_send_all_utilization__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE INST EXECUTED XMX ALL",
                .symbol_name = "XVE_INST_EXECUTED_XMX_ALL",
                .desc = "Number of execution slots taken by instructions executed in XMX pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__compute_overview__xve_inst_executed_xmx_all__read,
                .max_uint64 = acmgt1__compute_overview__xve_inst_executed_xmx_all__max,
                .group = "VectorEngine",
            },

            {
                .name = "XVE INST EXECUTED XMX ALL UTILIZATION",
                .symbol_name = "XVE_INST_EXECUTED_XMX_ALL_UTILIZATION",
                .desc = "Percentage of execution slots taken by instructions executed in XMX pipe",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_overview__xve_inst_executed_xmx_all_utilization__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE PIPE ALU0 AND ALU1 ACTIVE",
                .symbol_name = "XVE_PIPE_ALU0_AND_ALU1_ACTIVE",
                .desc = "Percentage of time in which ALU0 and ALU1 pipes are both actively executing a Gen ISA instruction",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_overview__xve_pipe_alu0_and_alu1_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE PIPE ALU0 AND XMX ACTIVE",
                .symbol_name = "XVE_PIPE_ALU0_AND_XMX_ACTIVE",
                .desc = "Percentage of time in which ALU0 and XMX pipes are both actively executing a Gen ISA instruction",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_overview__xve_pipe_alu0_and_xmx_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE STALL",
                .symbol_name = "XVE_STALL",
                .desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_overview__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE THREADS OCCUPANCY ALL",
                .symbol_name = "XVE_THREADS_OCCUPANCY_ALL",
                .desc = "Percentage of thread slots occupied",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__compute_overview__xve_threads_occupancy_all__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 26);
}


static void
acmgt1_add_l1_profile_reads__xe_core0_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L1ProfileReads";
    metric_set->symbol_name = "L1ProfileReads_XeCore0";
    metric_set->hw_config_guid = "a2fe4388-0540-4550-b57e-6948cd7ab47a";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_l1_profile_reads__xe_core0_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core0__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__l1_profile_reads__xe_core0__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE READ",
                .symbol_name = "GPU_MEMORY_BYTE_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core0__gpu_memory_byte_read__read,
                .max_uint64 = acmgt1__l1_profile_reads__xe_core0__gpu_memory_byte_read__max,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core0__gpu_memory_byte_write__read,
                .max_uint64 = acmgt1__l1_profile_reads__xe_core0__gpu_memory_byte_write__max,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core0__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core0__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE BYTE READ",
                .symbol_name = "LOAD_STORE_CACHE_BYTE_READ",
                .desc = "Number of bytes read out of the Load Store Cache, excluding SLM accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core0__load_store_cache_byte_read__read,
                .max_uint64 = acmgt1__l1_profile_reads__xe_core0__load_store_cache_byte_read__max,
                .group = "L1Cache",
            },

            {
                .name = "SLM BYTE READ",
                .symbol_name = "SLM_BYTE_READ",
                .desc = "Number of bytes read from SLM",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core0__slm_byte_read__read,
                .max_uint64 = acmgt1__l1_profile_reads__xe_core0__slm_byte_read__max,
                .group = "L1Cache",
            },

            {
                .name = "XVE ACTIVE",
                .symbol_name = "XVE_ACTIVE",
                .desc = "Percentage of time in which at least one pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_reads__xe_core0__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE BUSY",
                .symbol_name = "XVE_BUSY",
                .desc = "Any XVE thread loaded.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core0__xve_busy__read,
                .max_uint64 = acmgt1__l1_profile_reads__xe_core0__xve_busy__max,
                .group = "VectorEngine",
            },

            {
                .name = "XVE STALL",
                .symbol_name = "XVE_STALL",
                .desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_reads__xe_core0__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE THREADS OCCUPANCY ALL",
                .symbol_name = "XVE_THREADS_OCCUPANCY_ALL",
                .desc = "Percentage of thread slots occupied",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_reads__xe_core0__xve_threads_occupancy_all__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}


static void
acmgt1_add_l1_profile_reads__xe_core3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L1ProfileReads";
    metric_set->symbol_name = "L1ProfileReads_XeCore3";
    metric_set->hw_config_guid = "16bc63c3-d365-4bee-baf7-bafbc1aa7c2d";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_l1_profile_reads__xe_core3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core3__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__l1_profile_reads__xe_core3__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE READ",
                .symbol_name = "GPU_MEMORY_BYTE_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core3__gpu_memory_byte_read__read,
                .max_uint64 = acmgt1__l1_profile_reads__xe_core3__gpu_memory_byte_read__max,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core3__gpu_memory_byte_write__read,
                .max_uint64 = acmgt1__l1_profile_reads__xe_core3__gpu_memory_byte_write__max,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core3__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core3__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE BYTE READ",
                .symbol_name = "LOAD_STORE_CACHE_BYTE_READ",
                .desc = "Number of bytes read out of the Load Store Cache, excluding SLM accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core3__load_store_cache_byte_read__read,
                .max_uint64 = acmgt1__l1_profile_reads__xe_core3__load_store_cache_byte_read__max,
                .group = "L1Cache",
            },

            {
                .name = "SLM BYTE READ",
                .symbol_name = "SLM_BYTE_READ",
                .desc = "Number of bytes read from SLM",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core3__slm_byte_read__read,
                .max_uint64 = acmgt1__l1_profile_reads__xe_core3__slm_byte_read__max,
                .group = "L1Cache",
            },

            {
                .name = "XVE ACTIVE",
                .symbol_name = "XVE_ACTIVE",
                .desc = "Percentage of time in which at least one pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_reads__xe_core3__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE BUSY",
                .symbol_name = "XVE_BUSY",
                .desc = "Any XVE thread loaded.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__l1_profile_reads__xe_core3__xve_busy__read,
                .max_uint64 = acmgt1__l1_profile_reads__xe_core3__xve_busy__max,
                .group = "VectorEngine",
            },

            {
                .name = "XVE STALL",
                .symbol_name = "XVE_STALL",
                .desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_reads__xe_core3__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE THREADS OCCUPANCY ALL",
                .symbol_name = "XVE_THREADS_OCCUPANCY_ALL",
                .desc = "Percentage of thread slots occupied",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_reads__xe_core3__xve_threads_occupancy_all__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}


static void
acmgt1_add_l1_profile_slm_bank_conflicts__xe_core0_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L1ProfileSlmBankConflicts";
    metric_set->symbol_name = "L1ProfileSlmBankConflicts_XeCore0";
    metric_set->hw_config_guid = "28da4c17-4629-4111-a575-787a85100db9";
    metric_set->counters = calloc(10, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_l1_profile_slm_bank_conflicts__xe_core0_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core0__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core0__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE READ",
                .symbol_name = "GPU_MEMORY_BYTE_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core0__gpu_memory_byte_read__read,
                .max_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core0__gpu_memory_byte_read__max,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core0__gpu_memory_byte_write__read,
                .max_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core0__gpu_memory_byte_write__max,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core0__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core0__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SLM BANK CONFLICT COUNT",
                .symbol_name = "SLM_BANK_CONFLICT_COUNT",
                .desc = "Number of SLM accesses resulting in a bank conflict.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core0__slm_bank_conflict_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
            },

            {
                .name = "XVE ACTIVE",
                .symbol_name = "XVE_ACTIVE",
                .desc = "Percentage of time in which at least one pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_slm_bank_conflicts__xe_core0__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE BUSY",
                .symbol_name = "XVE_BUSY",
                .desc = "Any XVE thread loaded.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core0__xve_busy__read,
                .max_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core0__xve_busy__max,
                .group = "VectorEngine",
            },

            {
                .name = "XVE STALL",
                .symbol_name = "XVE_STALL",
                .desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_slm_bank_conflicts__xe_core0__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE THREADS OCCUPANCY ALL",
                .symbol_name = "XVE_THREADS_OCCUPANCY_ALL",
                .desc = "Percentage of thread slots occupied",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_slm_bank_conflicts__xe_core0__xve_threads_occupancy_all__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 10);
}


static void
acmgt1_add_l1_profile_slm_bank_conflicts__xe_core3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L1ProfileSlmBankConflicts";
    metric_set->symbol_name = "L1ProfileSlmBankConflicts_XeCore3";
    metric_set->hw_config_guid = "825f82b5-486a-4ca2-96fa-f358871984b0";
    metric_set->counters = calloc(10, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_l1_profile_slm_bank_conflicts__xe_core3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core3__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core3__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE READ",
                .symbol_name = "GPU_MEMORY_BYTE_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core3__gpu_memory_byte_read__read,
                .max_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core3__gpu_memory_byte_read__max,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core3__gpu_memory_byte_write__read,
                .max_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core3__gpu_memory_byte_write__max,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core3__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core3__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SLM BANK CONFLICT COUNT",
                .symbol_name = "SLM_BANK_CONFLICT_COUNT",
                .desc = "Number of SLM accesses resulting in a bank conflict.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core3__slm_bank_conflict_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
            },

            {
                .name = "XVE ACTIVE",
                .symbol_name = "XVE_ACTIVE",
                .desc = "Percentage of time in which at least one pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_slm_bank_conflicts__xe_core3__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE BUSY",
                .symbol_name = "XVE_BUSY",
                .desc = "Any XVE thread loaded.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core3__xve_busy__read,
                .max_uint64 = acmgt1__l1_profile_slm_bank_conflicts__xe_core3__xve_busy__max,
                .group = "VectorEngine",
            },

            {
                .name = "XVE STALL",
                .symbol_name = "XVE_STALL",
                .desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_slm_bank_conflicts__xe_core3__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE THREADS OCCUPANCY ALL",
                .symbol_name = "XVE_THREADS_OCCUPANCY_ALL",
                .desc = "Percentage of thread slots occupied",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_slm_bank_conflicts__xe_core3__xve_threads_occupancy_all__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 10);
}


static void
acmgt1_add_l1_profile_writes__xe_core0_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L1ProfileWrites";
    metric_set->symbol_name = "L1ProfileWrites_XeCore0";
    metric_set->hw_config_guid = "5d58094c-105e-4562-b53d-68185319c794";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_l1_profile_writes__xe_core0_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core0__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__l1_profile_writes__xe_core0__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE READ",
                .symbol_name = "GPU_MEMORY_BYTE_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core0__gpu_memory_byte_read__read,
                .max_uint64 = acmgt1__l1_profile_writes__xe_core0__gpu_memory_byte_read__max,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core0__gpu_memory_byte_write__read,
                .max_uint64 = acmgt1__l1_profile_writes__xe_core0__gpu_memory_byte_write__max,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core0__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core0__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE BYTE WRITE",
                .symbol_name = "LOAD_STORE_CACHE_BYTE_WRITE",
                .desc = "Number of bytes written to the Load Store Cache, excluding SLM accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core0__load_store_cache_byte_write__read,
                .max_uint64 = acmgt1__l1_profile_writes__xe_core0__load_store_cache_byte_write__max,
                .group = "L1Cache",
            },

            {
                .name = "SLM BYTE WRITE",
                .symbol_name = "SLM_BYTE_WRITE",
                .desc = "Number of bytes written to SLM",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core0__slm_byte_write__read,
                .max_uint64 = acmgt1__l1_profile_writes__xe_core0__slm_byte_write__max,
                .group = "L1Cache",
            },

            {
                .name = "XVE ACTIVE",
                .symbol_name = "XVE_ACTIVE",
                .desc = "Percentage of time in which at least one pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_writes__xe_core0__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE BUSY",
                .symbol_name = "XVE_BUSY",
                .desc = "Any XVE thread loaded.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core0__xve_busy__read,
                .max_uint64 = acmgt1__l1_profile_writes__xe_core0__xve_busy__max,
                .group = "VectorEngine",
            },

            {
                .name = "XVE STALL",
                .symbol_name = "XVE_STALL",
                .desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_writes__xe_core0__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE THREADS OCCUPANCY ALL",
                .symbol_name = "XVE_THREADS_OCCUPANCY_ALL",
                .desc = "Percentage of thread slots occupied",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_writes__xe_core0__xve_threads_occupancy_all__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}


static void
acmgt1_add_l1_profile_writes__xe_core3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L1ProfileWrites";
    metric_set->symbol_name = "L1ProfileWrites_XeCore3";
    metric_set->hw_config_guid = "3ce21cd6-fe3e-468f-ae53-07dbf73c45f9";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_l1_profile_writes__xe_core3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core3__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__l1_profile_writes__xe_core3__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY BYTE READ",
                .symbol_name = "GPU_MEMORY_BYTE_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core3__gpu_memory_byte_read__read,
                .max_uint64 = acmgt1__l1_profile_writes__xe_core3__gpu_memory_byte_read__max,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core3__gpu_memory_byte_write__read,
                .max_uint64 = acmgt1__l1_profile_writes__xe_core3__gpu_memory_byte_write__max,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core3__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core3__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE BYTE WRITE",
                .symbol_name = "LOAD_STORE_CACHE_BYTE_WRITE",
                .desc = "Number of bytes written to the Load Store Cache, excluding SLM accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core3__load_store_cache_byte_write__read,
                .max_uint64 = acmgt1__l1_profile_writes__xe_core3__load_store_cache_byte_write__max,
                .group = "L1Cache",
            },

            {
                .name = "SLM BYTE WRITE",
                .symbol_name = "SLM_BYTE_WRITE",
                .desc = "Number of bytes written to SLM",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core3__slm_byte_write__read,
                .max_uint64 = acmgt1__l1_profile_writes__xe_core3__slm_byte_write__max,
                .group = "L1Cache",
            },

            {
                .name = "XVE ACTIVE",
                .symbol_name = "XVE_ACTIVE",
                .desc = "Percentage of time in which at least one pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_writes__xe_core3__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE BUSY",
                .symbol_name = "XVE_BUSY",
                .desc = "Any XVE thread loaded.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__l1_profile_writes__xe_core3__xve_busy__read,
                .max_uint64 = acmgt1__l1_profile_writes__xe_core3__xve_busy__max,
                .group = "VectorEngine",
            },

            {
                .name = "XVE STALL",
                .symbol_name = "XVE_STALL",
                .desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_writes__xe_core3__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE THREADS OCCUPANCY ALL",
                .symbol_name = "XVE_THREADS_OCCUPANCY_ALL",
                .desc = "Percentage of thread slots occupied",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__l1_profile_writes__xe_core3__xve_threads_occupancy_all__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}


static void
acmgt1_add_dataport_reads_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DataportReads";
    metric_set->symbol_name = "DataportReads";
    metric_set->hw_config_guid = "54d0193f-f8e0-4b81-99ba-e73a23fd9418";
    metric_set->counters = calloc(13, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_dataport_reads_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__dataport_reads__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__dataport_reads__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT BYTE READ",
                .symbol_name = "DATAPORT_BYTE_READ",
                .desc = "Number of bytes read through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__dataport_reads__dataport_byte_read__read,
                .max_uint64 = acmgt1__dataport_reads__dataport_byte_read__max,
                .group = "Dataport",
            },

            {
                .name = "GPU MEMORY BYTE READ",
                .symbol_name = "GPU_MEMORY_BYTE_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__dataport_reads__gpu_memory_byte_read__read,
                .max_uint64 = acmgt1__dataport_reads__gpu_memory_byte_read__max,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__dataport_reads__gpu_memory_byte_write__read,
                .max_uint64 = acmgt1__dataport_reads__gpu_memory_byte_write__max,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__dataport_reads__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__dataport_reads__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HOST TO GPUMEM BYTE READ",
                .symbol_name = "HOST_TO_GPUMEM_BYTE_READ",
                .desc = "Number of bytes read by host from GPU local (HBM) memory (downstream)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__dataport_reads__host_to_gpumem_byte_read__read,
                .max_uint64 = acmgt1__dataport_reads__host_to_gpumem_byte_read__max,
                .group = "Memory",
            },

            {
                .name = "HOST TO GPUMEM BYTE WRITE",
                .symbol_name = "HOST_TO_GPUMEM_BYTE_WRITE",
                .desc = "Number of bytes written by host to GPU local (HBM) memory (downstream)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__dataport_reads__host_to_gpumem_byte_write__read,
                .max_uint64 = acmgt1__dataport_reads__host_to_gpumem_byte_write__max,
                .group = "Memory",
            },

            {
                .name = "XVE ACTIVE",
                .symbol_name = "XVE_ACTIVE",
                .desc = "Percentage of time in which at least one pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__dataport_reads__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE BUSY",
                .symbol_name = "XVE_BUSY",
                .desc = "Any XVE thread loaded.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__dataport_reads__xve_busy__read,
                .max_uint64 = acmgt1__dataport_reads__xve_busy__max,
                .group = "VectorEngine",
            },

            {
                .name = "XVE COMPUTE THREAD COUNT",
                .symbol_name = "XVE_COMPUTE_THREAD_COUNT",
                .desc = "Number of compute shader hardware threads dispatched",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = acmgt1__dataport_reads__xve_compute_thread_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "VectorEngine",
            },

            {
                .name = "XVE STALL",
                .symbol_name = "XVE_STALL",
                .desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__dataport_reads__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE THREADS OCCUPANCY ALL",
                .symbol_name = "XVE_THREADS_OCCUPANCY_ALL",
                .desc = "Percentage of thread slots occupied",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__dataport_reads__xve_threads_occupancy_all__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 13);
}


static void
acmgt1_add_dataport_writes_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DataportWrites";
    metric_set->symbol_name = "DataportWrites";
    metric_set->hw_config_guid = "17982512-46b0-4b58-9e8d-d59b5bf8b3f5";
    metric_set->counters = calloc(14, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_dataport_writes_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__dataport_writes__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__dataport_writes__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT BYTE WRITE",
                .symbol_name = "DATAPORT_BYTE_WRITE",
                .desc = "Number of bytes written through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__dataport_writes__dataport_byte_write__read,
                .max_uint64 = acmgt1__dataport_writes__dataport_byte_write__max,
                .group = "Dataport",
            },

            {
                .name = "GPU MEMORY BYTE READ",
                .symbol_name = "GPU_MEMORY_BYTE_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__dataport_writes__gpu_memory_byte_read__read,
                .max_uint64 = acmgt1__dataport_writes__gpu_memory_byte_read__max,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__dataport_writes__gpu_memory_byte_write__read,
                .max_uint64 = acmgt1__dataport_writes__gpu_memory_byte_write__max,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__dataport_writes__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__dataport_writes__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SAMPLER L3 READ",
                .symbol_name = "SAMPLER_L3_READ",
                .desc = "Number of L3 read requests resulting from sampler local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__dataport_writes__sampler_l3_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
            },

            {
                .name = "SYSMEM BYTE READ",
                .symbol_name = "SYSMEM_BYTE_READ",
                .desc = "Number of system memory bytes read (upstream)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__dataport_writes__sysmem_byte_read__read,
                .max_uint64 = acmgt1__dataport_writes__sysmem_byte_read__max,
                .group = "Memory",
            },

            {
                .name = "SYSMEM BYTE WRITE",
                .symbol_name = "SYSMEM_BYTE_WRITE",
                .desc = "Number of system memory bytes written (upstream)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__dataport_writes__sysmem_byte_write__read,
                .max_uint64 = acmgt1__dataport_writes__sysmem_byte_write__max,
                .group = "Memory",
            },

            {
                .name = "XVE ACTIVE",
                .symbol_name = "XVE_ACTIVE",
                .desc = "Percentage of time in which at least one pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__dataport_writes__xve_active__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE BUSY",
                .symbol_name = "XVE_BUSY",
                .desc = "Any XVE thread loaded.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__dataport_writes__xve_busy__read,
                .max_uint64 = acmgt1__dataport_writes__xve_busy__max,
                .group = "VectorEngine",
            },

            {
                .name = "XVE COMPUTE THREAD COUNT",
                .symbol_name = "XVE_COMPUTE_THREAD_COUNT",
                .desc = "Number of compute shader hardware threads dispatched",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS,
                .read_uint64 = acmgt1__dataport_writes__xve_compute_thread_count__read,
                .max_uint64 = NULL /* undefined */,
                .group = "VectorEngine",
            },

            {
                .name = "XVE STALL",
                .symbol_name = "XVE_STALL",
                .desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__dataport_writes__xve_stall__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },

            {
                .name = "XVE THREADS OCCUPANCY ALL",
                .symbol_name = "XVE_THREADS_OCCUPANCY_ALL",
                .desc = "Percentage of thread slots occupied",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__dataport_writes__xve_threads_occupancy_all__read,
                .max_float = percentage_max_callback_float,
                .group = "VectorEngine",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 14);
}


static void
acmgt1_add_ext1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext1";
    metric_set->symbol_name = "Ext1";
    metric_set->hw_config_guid = "480895b0-8013-4be1-8bbf-fc3f1ad2e97f";
    metric_set->counters = calloc(25, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext1__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext1__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY ACTIVE SQIDI0",
                .symbol_name = "GPU_MEMORY_ACTIVE_SQIDI0",
                .desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext1__gpu_memory_active_sqidi0__read,
                .max_float = percentage_max_callback_float,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY ACTIVE SQIDI1",
                .symbol_name = "GPU_MEMORY_ACTIVE_SQIDI1",
                .desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext1__gpu_memory_active_sqidi1__read,
                .max_float = percentage_max_callback_float,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE READ",
                .symbol_name = "GPU_MEMORY_BYTE_READ",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext1__gpu_memory_byte_read__read,
                .max_uint64 = acmgt1__ext1__gpu_memory_byte_read__max,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE READ BW",
                .symbol_name = "GPU_MEMORY_BYTE_READ_BW",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = acmgt1__ext1__gpu_memory_byte_read_bw__read,
                .max_float = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE READ BW SQIDI0",
                .symbol_name = "GPU_MEMORY_BYTE_READ_BW_SQIDI0",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = acmgt1__ext1__gpu_memory_byte_read_bw_sqidi0__read,
                .max_float = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE READ BW SQIDI1",
                .symbol_name = "GPU_MEMORY_BYTE_READ_BW_SQIDI1",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = acmgt1__ext1__gpu_memory_byte_read_bw_sqidi1__read,
                .max_float = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE READ SQIDI0",
                .symbol_name = "GPU_MEMORY_BYTE_READ_SQIDI0",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext1__gpu_memory_byte_read_sqidi0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE READ SQIDI1",
                .symbol_name = "GPU_MEMORY_BYTE_READ_SQIDI1",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext1__gpu_memory_byte_read_sqidi1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext1__gpu_memory_byte_write__read,
                .max_uint64 = acmgt1__ext1__gpu_memory_byte_write__max,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE BW",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE_BW",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = acmgt1__ext1__gpu_memory_byte_write_bw__read,
                .max_float = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE BW SQIDI0",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE_BW_SQIDI0",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = acmgt1__ext1__gpu_memory_byte_write_bw_sqidi0__read,
                .max_float = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE BW SQIDI1",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE_BW_SQIDI1",
                .desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS,
                .read_float = acmgt1__ext1__gpu_memory_byte_write_bw_sqidi1__read,
                .max_float = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE SQIDI0",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE_SQIDI0",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext1__gpu_memory_byte_write_sqidi0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY BYTE WRITE SQIDI1",
                .symbol_name = "GPU_MEMORY_BYTE_WRITE_SQIDI1",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext1__gpu_memory_byte_write_sqidi1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY READ",
                .symbol_name = "GPU_MEMORY_READ",
                .desc = "Number of GTI memory reads",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext1__gpu_memory_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY READ SQIDI0",
                .symbol_name = "GPU_MEMORY_READ_SQIDI0",
                .desc = "Number of GTI memory reads",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext1__gpu_memory_read_sqidi0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY READ SQIDI1",
                .symbol_name = "GPU_MEMORY_READ_SQIDI1",
                .desc = "Number of GTI memory reads",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext1__gpu_memory_read_sqidi1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY WRITE",
                .symbol_name = "GPU_MEMORY_WRITE",
                .desc = "Number of GTI memory writes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext1__gpu_memory_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY WRITE SQIDI0",
                .symbol_name = "GPU_MEMORY_WRITE_SQIDI0",
                .desc = "Number of GTI memory writes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext1__gpu_memory_write_sqidi0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY WRITE SQIDI1",
                .symbol_name = "GPU_MEMORY_WRITE_SQIDI1",
                .desc = "Number of GTI memory writes",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext1__gpu_memory_write_sqidi1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext1__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext1__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SYSMEM TRANSACTION READ",
                .symbol_name = "SYSMEM_TRANSACTION_READ",
                .desc = "Number of system memory reads (upstream)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext1__sysmem_transaction_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "SYSMEM TRANSACTION WRITE",
                .symbol_name = "SYSMEM_TRANSACTION_WRITE",
                .desc = "Number of system memory writes (upstream)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext1__sysmem_transaction_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 25);
}


static void
acmgt1_add_ext2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext2";
    metric_set->symbol_name = "Ext2";
    metric_set->hw_config_guid = "b899d843-d8ce-4803-8174-f2bf1107de00";
    metric_set->counters = calloc(9, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext2__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext2__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY 32B TRANSACTION READ SQIDI0",
                .symbol_name = "GPU_MEMORY_32B_TRANSACTION_READ_SQIDI0",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext2__gpu_memory_32_b_transaction_read_sqidi0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY 32B TRANSACTION READ SQIDI1",
                .symbol_name = "GPU_MEMORY_32B_TRANSACTION_READ_SQIDI1",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext2__gpu_memory_32_b_transaction_read_sqidi1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY 64B TRANSACTION READ SQIDI0",
                .symbol_name = "GPU_MEMORY_64B_TRANSACTION_READ_SQIDI0",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext2__gpu_memory_64_b_transaction_read_sqidi0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY 64B TRANSACTION READ SQIDI1",
                .symbol_name = "GPU_MEMORY_64B_TRANSACTION_READ_SQIDI1",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext2__gpu_memory_64_b_transaction_read_sqidi1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY REQUEST QUEUE FULL SQIDI0",
                .symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI0",
                .desc = "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext2__gpu_memory_request_queue_full_sqidi0__read,
                .max_float = percentage_max_callback_float,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY REQUEST QUEUE FULL SQIDI1",
                .symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI1",
                .desc = "Percentage of time in which SQ is filled above a threshold (usually 48 entries)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext2__gpu_memory_request_queue_full_sqidi1__read,
                .max_float = percentage_max_callback_float,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext2__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext2__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 9);
}


static void
acmgt1_add_ext3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext3";
    metric_set->symbol_name = "Ext3";
    metric_set->hw_config_guid = "59e0ed29-cd2d-43ee-bf49-e4637e8ef9ee";
    metric_set->counters = calloc(9, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext3__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext3__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU MEMORY 32B TRANSACTION WRITE SQIDI0",
                .symbol_name = "GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI0",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext3__gpu_memory_32_b_transaction_write_sqidi0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY 32B TRANSACTION WRITE SQIDI1",
                .symbol_name = "GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI1",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext3__gpu_memory_32_b_transaction_write_sqidi1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY 64B TRANSACTION WRITE SQIDI0",
                .symbol_name = "GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI0",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext3__gpu_memory_64_b_transaction_write_sqidi0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU MEMORY 64B TRANSACTION WRITE SQIDI1",
                .symbol_name = "GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI1",
                .desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext3__gpu_memory_64_b_transaction_write_sqidi1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext3__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext3__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "HOST TO GPUMEM TRANSACTION READ",
                .symbol_name = "HOST_TO_GPUMEM_TRANSACTION_READ",
                .desc = "Number of host reads to GPU local (HBM) memory (downstream)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext3__host_to_gpumem_transaction_read__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },

            {
                .name = "HOST TO GPUMEM TRANSACTION WRITE",
                .symbol_name = "HOST_TO_GPUMEM_TRANSACTION_WRITE",
                .desc = "Number of host writes to GPU local (HBM) memory (downstream)",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext3__host_to_gpumem_transaction_write__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Memory",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 9);
}

static bool acmgt1_ext4_L3_READ_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_READ_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_READ_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_READ_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_READ_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_READ_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_READ_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_READ_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_WRITE_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_WRITE_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_WRITE_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_WRITE_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_WRITE_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_WRITE_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_WRITE_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext4_L3_WRITE_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext4";
    metric_set->symbol_name = "Ext4";
    metric_set->hw_config_guid = "475c650e-1045-45dc-a280-3365f7af8f8c";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext4__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext4__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext4__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext4__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 READ L3BANK0",
                .symbol_name = "L3_READ_L3BANK0",
                .desc = "Number of L3 read requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_read_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_READ_L3BANK0_availability,
            },

            {
                .name = "L3 READ L3BANK1",
                .symbol_name = "L3_READ_L3BANK1",
                .desc = "Number of L3 read requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_read_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_READ_L3BANK1_availability,
            },

            {
                .name = "L3 READ L3BANK2",
                .symbol_name = "L3_READ_L3BANK2",
                .desc = "Number of L3 read requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_read_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_READ_L3BANK2_availability,
            },

            {
                .name = "L3 READ L3BANK3",
                .symbol_name = "L3_READ_L3BANK3",
                .desc = "Number of L3 read requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_read_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_READ_L3BANK3_availability,
            },

            {
                .name = "L3 READ L3BANK4",
                .symbol_name = "L3_READ_L3BANK4",
                .desc = "Number of L3 read requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_read_l3_bank4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_READ_L3BANK4_availability,
            },

            {
                .name = "L3 READ L3BANK5",
                .symbol_name = "L3_READ_L3BANK5",
                .desc = "Number of L3 read requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_read_l3_bank5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_READ_L3BANK5_availability,
            },

            {
                .name = "L3 READ L3BANK6",
                .symbol_name = "L3_READ_L3BANK6",
                .desc = "Number of L3 read requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_read_l3_bank6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_READ_L3BANK6_availability,
            },

            {
                .name = "L3 READ L3BANK7",
                .symbol_name = "L3_READ_L3BANK7",
                .desc = "Number of L3 read requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_read_l3_bank7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_READ_L3BANK7_availability,
            },

            {
                .name = "L3 WRITE L3BANK0",
                .symbol_name = "L3_WRITE_L3BANK0",
                .desc = "Number of L3 write requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_write_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_WRITE_L3BANK0_availability,
            },

            {
                .name = "L3 WRITE L3BANK1",
                .symbol_name = "L3_WRITE_L3BANK1",
                .desc = "Number of L3 write requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_write_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_WRITE_L3BANK1_availability,
            },

            {
                .name = "L3 WRITE L3BANK2",
                .symbol_name = "L3_WRITE_L3BANK2",
                .desc = "Number of L3 write requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_write_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_WRITE_L3BANK2_availability,
            },

            {
                .name = "L3 WRITE L3BANK3",
                .symbol_name = "L3_WRITE_L3BANK3",
                .desc = "Number of L3 write requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_write_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_WRITE_L3BANK3_availability,
            },

            {
                .name = "L3 WRITE L3BANK4",
                .symbol_name = "L3_WRITE_L3BANK4",
                .desc = "Number of L3 write requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_write_l3_bank4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_WRITE_L3BANK4_availability,
            },

            {
                .name = "L3 WRITE L3BANK5",
                .symbol_name = "L3_WRITE_L3BANK5",
                .desc = "Number of L3 write requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_write_l3_bank5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_WRITE_L3BANK5_availability,
            },

            {
                .name = "L3 WRITE L3BANK6",
                .symbol_name = "L3_WRITE_L3BANK6",
                .desc = "Number of L3 write requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_write_l3_bank6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_WRITE_L3BANK6_availability,
            },

            {
                .name = "L3 WRITE L3BANK7",
                .symbol_name = "L3_WRITE_L3BANK7",
                .desc = "Number of L3 write requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext4__l3_write_l3_bank7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext4_L3_WRITE_L3BANK7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 19);
}

static bool acmgt1_ext5_DATAPORT_L3_READ_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_READ_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_READ_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_READ_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_READ_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_READ_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_READ_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_READ_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext5";
    metric_set->symbol_name = "Ext5";
    metric_set->hw_config_guid = "b7d7a874-19d8-48e6-bf54-f859a994b0a4";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext5__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext5__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT L3 READ L3BANK0",
                .symbol_name = "DATAPORT_L3_READ_L3BANK0",
                .desc = "Number of L3 read requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_read_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_READ_L3BANK0_availability,
            },

            {
                .name = "DATAPORT L3 READ L3BANK1",
                .symbol_name = "DATAPORT_L3_READ_L3BANK1",
                .desc = "Number of L3 read requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_read_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_READ_L3BANK1_availability,
            },

            {
                .name = "DATAPORT L3 READ L3BANK2",
                .symbol_name = "DATAPORT_L3_READ_L3BANK2",
                .desc = "Number of L3 read requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_read_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_READ_L3BANK2_availability,
            },

            {
                .name = "DATAPORT L3 READ L3BANK3",
                .symbol_name = "DATAPORT_L3_READ_L3BANK3",
                .desc = "Number of L3 read requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_read_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_READ_L3BANK3_availability,
            },

            {
                .name = "DATAPORT L3 READ L3BANK4",
                .symbol_name = "DATAPORT_L3_READ_L3BANK4",
                .desc = "Number of L3 read requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_read_l3_bank4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_READ_L3BANK4_availability,
            },

            {
                .name = "DATAPORT L3 READ L3BANK5",
                .symbol_name = "DATAPORT_L3_READ_L3BANK5",
                .desc = "Number of L3 read requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_read_l3_bank5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_READ_L3BANK5_availability,
            },

            {
                .name = "DATAPORT L3 READ L3BANK6",
                .symbol_name = "DATAPORT_L3_READ_L3BANK6",
                .desc = "Number of L3 read requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_read_l3_bank6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_READ_L3BANK6_availability,
            },

            {
                .name = "DATAPORT L3 READ L3BANK7",
                .symbol_name = "DATAPORT_L3_READ_L3BANK7",
                .desc = "Number of L3 read requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_read_l3_bank7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_READ_L3BANK7_availability,
            },

            {
                .name = "DATAPORT L3 WRITE L3BANK0",
                .symbol_name = "DATAPORT_L3_WRITE_L3BANK0",
                .desc = "Number of L3 write requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_write_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK0_availability,
            },

            {
                .name = "DATAPORT L3 WRITE L3BANK1",
                .symbol_name = "DATAPORT_L3_WRITE_L3BANK1",
                .desc = "Number of L3 write requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_write_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK1_availability,
            },

            {
                .name = "DATAPORT L3 WRITE L3BANK2",
                .symbol_name = "DATAPORT_L3_WRITE_L3BANK2",
                .desc = "Number of L3 write requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_write_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK2_availability,
            },

            {
                .name = "DATAPORT L3 WRITE L3BANK3",
                .symbol_name = "DATAPORT_L3_WRITE_L3BANK3",
                .desc = "Number of L3 write requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_write_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK3_availability,
            },

            {
                .name = "DATAPORT L3 WRITE L3BANK4",
                .symbol_name = "DATAPORT_L3_WRITE_L3BANK4",
                .desc = "Number of L3 write requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_write_l3_bank4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK4_availability,
            },

            {
                .name = "DATAPORT L3 WRITE L3BANK5",
                .symbol_name = "DATAPORT_L3_WRITE_L3BANK5",
                .desc = "Number of L3 write requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_write_l3_bank5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK5_availability,
            },

            {
                .name = "DATAPORT L3 WRITE L3BANK6",
                .symbol_name = "DATAPORT_L3_WRITE_L3BANK6",
                .desc = "Number of L3 write requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_write_l3_bank6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK6_availability,
            },

            {
                .name = "DATAPORT L3 WRITE L3BANK7",
                .symbol_name = "DATAPORT_L3_WRITE_L3BANK7",
                .desc = "Number of L3 write requests coming from XVE via Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext5__dataport_l3_write_l3_bank7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext5_DATAPORT_L3_WRITE_L3BANK7_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext5__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext5__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 19);
}


static void
acmgt1_add_ext6_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext6";
    metric_set->symbol_name = "Ext6";
    metric_set->hw_config_guid = "f1a94d28-672b-41a6-9ab9-e2040200d28a";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext6_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext6__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext6__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext6__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext6__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 HIT L3BANK0",
                .symbol_name = "L3_HIT_L3BANK0",
                .desc = "Number of L3 accesses which hits in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext6__l3_hit_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
            },

            {
                .name = "L3 HIT L3BANK1",
                .symbol_name = "L3_HIT_L3BANK1",
                .desc = "Number of L3 accesses which hits in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext6__l3_hit_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
            },

            {
                .name = "L3 HIT L3BANK2",
                .symbol_name = "L3_HIT_L3BANK2",
                .desc = "Number of L3 accesses which hits in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext6__l3_hit_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
            },

            {
                .name = "L3 HIT L3BANK3",
                .symbol_name = "L3_HIT_L3BANK3",
                .desc = "Number of L3 accesses which hits in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext6__l3_hit_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
            },

            {
                .name = "L3 HIT L3BANK4",
                .symbol_name = "L3_HIT_L3BANK4",
                .desc = "Number of L3 accesses which hits in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext6__l3_hit_l3_bank4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
            },

            {
                .name = "L3 HIT L3BANK5",
                .symbol_name = "L3_HIT_L3BANK5",
                .desc = "Number of L3 accesses which hits in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext6__l3_hit_l3_bank5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
            },

            {
                .name = "L3 HIT L3BANK6",
                .symbol_name = "L3_HIT_L3BANK6",
                .desc = "Number of L3 accesses which hits in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext6__l3_hit_l3_bank6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
            },

            {
                .name = "L3 HIT L3BANK7",
                .symbol_name = "L3_HIT_L3BANK7",
                .desc = "Number of L3 accesses which hits in the L3 cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext6__l3_hit_l3_bank7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool acmgt1_ext7_SAMPLER_L3_HIT_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_HIT_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_HIT_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_HIT_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_HIT_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_HIT_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_HIT_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_HIT_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_READ_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_READ_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_READ_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_READ_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_READ_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_READ_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_READ_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext7_SAMPLER_L3_READ_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext7_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext7";
    metric_set->symbol_name = "Ext7";
    metric_set->hw_config_guid = "31d119ed-a150-4b52-9206-3f9832e275ea";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext7_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext7__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext7__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext7__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext7__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SAMPLER L3 HIT L3BANK0",
                .symbol_name = "SAMPLER_L3_HIT_L3BANK0",
                .desc = "Number of L3 hit requests resulting from sampler local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_hit_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_HIT_L3BANK0_availability,
            },

            {
                .name = "SAMPLER L3 HIT L3BANK1",
                .symbol_name = "SAMPLER_L3_HIT_L3BANK1",
                .desc = "Number of L3 hit requests resulting from sampler local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_hit_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_HIT_L3BANK1_availability,
            },

            {
                .name = "SAMPLER L3 HIT L3BANK2",
                .symbol_name = "SAMPLER_L3_HIT_L3BANK2",
                .desc = "Number of L3 hit requests resulting from sampler local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_hit_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_HIT_L3BANK2_availability,
            },

            {
                .name = "SAMPLER L3 HIT L3BANK3",
                .symbol_name = "SAMPLER_L3_HIT_L3BANK3",
                .desc = "Number of L3 hit requests resulting from sampler local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_hit_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_HIT_L3BANK3_availability,
            },

            {
                .name = "SAMPLER L3 HIT L3BANK4",
                .symbol_name = "SAMPLER_L3_HIT_L3BANK4",
                .desc = "Number of L3 hit requests resulting from sampler local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_hit_l3_bank4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_HIT_L3BANK4_availability,
            },

            {
                .name = "SAMPLER L3 HIT L3BANK5",
                .symbol_name = "SAMPLER_L3_HIT_L3BANK5",
                .desc = "Number of L3 hit requests resulting from sampler local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_hit_l3_bank5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_HIT_L3BANK5_availability,
            },

            {
                .name = "SAMPLER L3 HIT L3BANK6",
                .symbol_name = "SAMPLER_L3_HIT_L3BANK6",
                .desc = "Number of L3 hit requests resulting from sampler local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_hit_l3_bank6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_HIT_L3BANK6_availability,
            },

            {
                .name = "SAMPLER L3 HIT L3BANK7",
                .symbol_name = "SAMPLER_L3_HIT_L3BANK7",
                .desc = "Number of L3 hit requests resulting from sampler local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_hit_l3_bank7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_HIT_L3BANK7_availability,
            },

            {
                .name = "SAMPLER L3 READ L3BANK0",
                .symbol_name = "SAMPLER_L3_READ_L3BANK0",
                .desc = "Number of L3 read requests resulting from sampler local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_read_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_READ_L3BANK0_availability,
            },

            {
                .name = "SAMPLER L3 READ L3BANK1",
                .symbol_name = "SAMPLER_L3_READ_L3BANK1",
                .desc = "Number of L3 read requests resulting from sampler local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_read_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_READ_L3BANK1_availability,
            },

            {
                .name = "SAMPLER L3 READ L3BANK2",
                .symbol_name = "SAMPLER_L3_READ_L3BANK2",
                .desc = "Number of L3 read requests resulting from sampler local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_read_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_READ_L3BANK2_availability,
            },

            {
                .name = "SAMPLER L3 READ L3BANK3",
                .symbol_name = "SAMPLER_L3_READ_L3BANK3",
                .desc = "Number of L3 read requests resulting from sampler local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_read_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_READ_L3BANK3_availability,
            },

            {
                .name = "SAMPLER L3 READ L3BANK4",
                .symbol_name = "SAMPLER_L3_READ_L3BANK4",
                .desc = "Number of L3 read requests resulting from sampler local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_read_l3_bank4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_READ_L3BANK4_availability,
            },

            {
                .name = "SAMPLER L3 READ L3BANK5",
                .symbol_name = "SAMPLER_L3_READ_L3BANK5",
                .desc = "Number of L3 read requests resulting from sampler local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_read_l3_bank5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_READ_L3BANK5_availability,
            },

            {
                .name = "SAMPLER L3 READ L3BANK6",
                .symbol_name = "SAMPLER_L3_READ_L3BANK6",
                .desc = "Number of L3 read requests resulting from sampler local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_read_l3_bank6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_READ_L3BANK6_availability,
            },

            {
                .name = "SAMPLER L3 READ L3BANK7",
                .symbol_name = "SAMPLER_L3_READ_L3BANK7",
                .desc = "Number of L3 read requests resulting from sampler local cache miss",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext7__sampler_l3_read_l3_bank7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext7_SAMPLER_L3_READ_L3BANK7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 19);
}

static bool acmgt1_ext8_ICACHE_L3_HIT_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_HIT_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_HIT_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_HIT_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_HIT_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_HIT_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_HIT_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_HIT_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_READ_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_READ_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_READ_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_READ_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_READ_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_READ_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_READ_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext8_ICACHE_L3_READ_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext8_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext8";
    metric_set->symbol_name = "Ext8";
    metric_set->hw_config_guid = "4eb14f16-d2ac-46d3-b974-e413430fddec";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext8_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext8__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext8__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext8__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext8__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "ICACHE L3 HIT L3BANK0",
                .symbol_name = "ICACHE_L3_HIT_L3BANK0",
                .desc = "Number of XVE instruction cache requests that hit the L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_hit_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_HIT_L3BANK0_availability,
            },

            {
                .name = "ICACHE L3 HIT L3BANK1",
                .symbol_name = "ICACHE_L3_HIT_L3BANK1",
                .desc = "Number of XVE instruction cache requests that hit the L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_hit_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_HIT_L3BANK1_availability,
            },

            {
                .name = "ICACHE L3 HIT L3BANK2",
                .symbol_name = "ICACHE_L3_HIT_L3BANK2",
                .desc = "Number of XVE instruction cache requests that hit the L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_hit_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_HIT_L3BANK2_availability,
            },

            {
                .name = "ICACHE L3 HIT L3BANK3",
                .symbol_name = "ICACHE_L3_HIT_L3BANK3",
                .desc = "Number of XVE instruction cache requests that hit the L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_hit_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_HIT_L3BANK3_availability,
            },

            {
                .name = "ICACHE L3 HIT L3BANK4",
                .symbol_name = "ICACHE_L3_HIT_L3BANK4",
                .desc = "Number of XVE instruction cache requests that hit the L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_hit_l3_bank4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_HIT_L3BANK4_availability,
            },

            {
                .name = "ICACHE L3 HIT L3BANK5",
                .symbol_name = "ICACHE_L3_HIT_L3BANK5",
                .desc = "Number of XVE instruction cache requests that hit the L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_hit_l3_bank5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_HIT_L3BANK5_availability,
            },

            {
                .name = "ICACHE L3 HIT L3BANK6",
                .symbol_name = "ICACHE_L3_HIT_L3BANK6",
                .desc = "Number of XVE instruction cache requests that hit the L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_hit_l3_bank6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_HIT_L3BANK6_availability,
            },

            {
                .name = "ICACHE L3 HIT L3BANK7",
                .symbol_name = "ICACHE_L3_HIT_L3BANK7",
                .desc = "Number of XVE instruction cache requests that hit the L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_hit_l3_bank7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_HIT_L3BANK7_availability,
            },

            {
                .name = "ICACHE L3 READ L3BANK0",
                .symbol_name = "ICACHE_L3_READ_L3BANK0",
                .desc = "Number of L3 read requests coming from XVE Instruction Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_read_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_READ_L3BANK0_availability,
            },

            {
                .name = "ICACHE L3 READ L3BANK1",
                .symbol_name = "ICACHE_L3_READ_L3BANK1",
                .desc = "Number of L3 read requests coming from XVE Instruction Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_read_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_READ_L3BANK1_availability,
            },

            {
                .name = "ICACHE L3 READ L3BANK2",
                .symbol_name = "ICACHE_L3_READ_L3BANK2",
                .desc = "Number of L3 read requests coming from XVE Instruction Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_read_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_READ_L3BANK2_availability,
            },

            {
                .name = "ICACHE L3 READ L3BANK3",
                .symbol_name = "ICACHE_L3_READ_L3BANK3",
                .desc = "Number of L3 read requests coming from XVE Instruction Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_read_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_READ_L3BANK3_availability,
            },

            {
                .name = "ICACHE L3 READ L3BANK4",
                .symbol_name = "ICACHE_L3_READ_L3BANK4",
                .desc = "Number of L3 read requests coming from XVE Instruction Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_read_l3_bank4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_READ_L3BANK4_availability,
            },

            {
                .name = "ICACHE L3 READ L3BANK5",
                .symbol_name = "ICACHE_L3_READ_L3BANK5",
                .desc = "Number of L3 read requests coming from XVE Instruction Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_read_l3_bank5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_READ_L3BANK5_availability,
            },

            {
                .name = "ICACHE L3 READ L3BANK6",
                .symbol_name = "ICACHE_L3_READ_L3BANK6",
                .desc = "Number of L3 read requests coming from XVE Instruction Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_read_l3_bank6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_READ_L3BANK6_availability,
            },

            {
                .name = "ICACHE L3 READ L3BANK7",
                .symbol_name = "ICACHE_L3_READ_L3BANK7",
                .desc = "Number of L3 read requests coming from XVE Instruction Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext8__icache_l3_read_l3_bank7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext8_ICACHE_L3_READ_L3BANK7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 19);
}

static bool acmgt1_ext9_SAMPLER_BUSY_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext9_SAMPLER_BUSY_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext9_SAMPLER_BUSY_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext9_SAMPLER_BUSY_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext9_SAMPLER_BUSY_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext9_SAMPLER_BUSY_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext9_SAMPLER_BUSY_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext9_SAMPLER_BUSY_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext9_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext9";
    metric_set->symbol_name = "Ext9";
    metric_set->hw_config_guid = "b875dedd-f121-4f89-b02f-ff2c873e2543";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext9_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext9__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext9__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext9__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext9__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "SAMPLER BUSY XECORE0",
                .symbol_name = "SAMPLER_BUSY_XECORE0",
                .desc = "Percentage of time in which Sampler pipeline active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext9__sampler_busy_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_ext9_SAMPLER_BUSY_XECORE0_availability,
            },

            {
                .name = "SAMPLER BUSY XECORE1",
                .symbol_name = "SAMPLER_BUSY_XECORE1",
                .desc = "Percentage of time in which Sampler pipeline active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext9__sampler_busy_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_ext9_SAMPLER_BUSY_XECORE1_availability,
            },

            {
                .name = "SAMPLER BUSY XECORE2",
                .symbol_name = "SAMPLER_BUSY_XECORE2",
                .desc = "Percentage of time in which Sampler pipeline active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext9__sampler_busy_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_ext9_SAMPLER_BUSY_XECORE2_availability,
            },

            {
                .name = "SAMPLER BUSY XECORE3",
                .symbol_name = "SAMPLER_BUSY_XECORE3",
                .desc = "Percentage of time in which Sampler pipeline active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext9__sampler_busy_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_ext9_SAMPLER_BUSY_XECORE3_availability,
            },

            {
                .name = "SAMPLER BUSY XECORE4",
                .symbol_name = "SAMPLER_BUSY_XECORE4",
                .desc = "Percentage of time in which Sampler pipeline active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext9__sampler_busy_xecore4__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_ext9_SAMPLER_BUSY_XECORE4_availability,
            },

            {
                .name = "SAMPLER BUSY XECORE5",
                .symbol_name = "SAMPLER_BUSY_XECORE5",
                .desc = "Percentage of time in which Sampler pipeline active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext9__sampler_busy_xecore5__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_ext9_SAMPLER_BUSY_XECORE5_availability,
            },

            {
                .name = "SAMPLER BUSY XECORE6",
                .symbol_name = "SAMPLER_BUSY_XECORE6",
                .desc = "Percentage of time in which Sampler pipeline active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext9__sampler_busy_xecore6__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_ext9_SAMPLER_BUSY_XECORE6_availability,
            },

            {
                .name = "SAMPLER BUSY XECORE7",
                .symbol_name = "SAMPLER_BUSY_XECORE7",
                .desc = "Percentage of time in which Sampler pipeline active",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext9__sampler_busy_xecore7__read,
                .max_float = percentage_max_callback_float,
                .group = "Sampler",
                .availability = acmgt1_ext9_SAMPLER_BUSY_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool acmgt1_ext10_COLOR_L3_HIT_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_COLOR_L3_HIT_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_COLOR_L3_HIT_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_COLOR_L3_HIT_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_COLOR_L3_HIT_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_COLOR_L3_HIT_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_COLOR_L3_HIT_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_COLOR_L3_HIT_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_DATAPORT_L3_HIT_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_DATAPORT_L3_HIT_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_DATAPORT_L3_HIT_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_DATAPORT_L3_HIT_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_DATAPORT_L3_HIT_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_DATAPORT_L3_HIT_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_DATAPORT_L3_HIT_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext10_DATAPORT_L3_HIT_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext10_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext10";
    metric_set->symbol_name = "Ext10";
    metric_set->hw_config_guid = "691b6a0d-d3d7-4b5e-a70e-d8232722cddf";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext10_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext10__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext10__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "COLOR L3 HIT L3BANK0",
                .symbol_name = "COLOR_L3_HIT_L3BANK0",
                .desc = "Number of L3 read requests resulting from color local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__color_l3_hit_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_COLOR_L3_HIT_L3BANK0_availability,
            },

            {
                .name = "COLOR L3 HIT L3BANK1",
                .symbol_name = "COLOR_L3_HIT_L3BANK1",
                .desc = "Number of L3 read requests resulting from color local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__color_l3_hit_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_COLOR_L3_HIT_L3BANK1_availability,
            },

            {
                .name = "COLOR L3 HIT L3BANK2",
                .symbol_name = "COLOR_L3_HIT_L3BANK2",
                .desc = "Number of L3 read requests resulting from color local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__color_l3_hit_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_COLOR_L3_HIT_L3BANK2_availability,
            },

            {
                .name = "COLOR L3 HIT L3BANK3",
                .symbol_name = "COLOR_L3_HIT_L3BANK3",
                .desc = "Number of L3 read requests resulting from color local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__color_l3_hit_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_COLOR_L3_HIT_L3BANK3_availability,
            },

            {
                .name = "COLOR L3 HIT L3BANK4",
                .symbol_name = "COLOR_L3_HIT_L3BANK4",
                .desc = "Number of L3 read requests resulting from color local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__color_l3_hit_l3_bank4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_COLOR_L3_HIT_L3BANK4_availability,
            },

            {
                .name = "COLOR L3 HIT L3BANK5",
                .symbol_name = "COLOR_L3_HIT_L3BANK5",
                .desc = "Number of L3 read requests resulting from color local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__color_l3_hit_l3_bank5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_COLOR_L3_HIT_L3BANK5_availability,
            },

            {
                .name = "COLOR L3 HIT L3BANK6",
                .symbol_name = "COLOR_L3_HIT_L3BANK6",
                .desc = "Number of L3 read requests resulting from color local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__color_l3_hit_l3_bank6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_COLOR_L3_HIT_L3BANK6_availability,
            },

            {
                .name = "COLOR L3 HIT L3BANK7",
                .symbol_name = "COLOR_L3_HIT_L3BANK7",
                .desc = "Number of L3 read requests resulting from color local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__color_l3_hit_l3_bank7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_COLOR_L3_HIT_L3BANK7_availability,
            },

            {
                .name = "DATAPORT L3 HIT L3BANK0",
                .symbol_name = "DATAPORT_L3_HIT_L3BANK0",
                .desc = "Number of L3 hits for requests coming from the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__dataport_l3_hit_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_DATAPORT_L3_HIT_L3BANK0_availability,
            },

            {
                .name = "DATAPORT L3 HIT L3BANK1",
                .symbol_name = "DATAPORT_L3_HIT_L3BANK1",
                .desc = "Number of L3 hits for requests coming from the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__dataport_l3_hit_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_DATAPORT_L3_HIT_L3BANK1_availability,
            },

            {
                .name = "DATAPORT L3 HIT L3BANK2",
                .symbol_name = "DATAPORT_L3_HIT_L3BANK2",
                .desc = "Number of L3 hits for requests coming from the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__dataport_l3_hit_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_DATAPORT_L3_HIT_L3BANK2_availability,
            },

            {
                .name = "DATAPORT L3 HIT L3BANK3",
                .symbol_name = "DATAPORT_L3_HIT_L3BANK3",
                .desc = "Number of L3 hits for requests coming from the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__dataport_l3_hit_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_DATAPORT_L3_HIT_L3BANK3_availability,
            },

            {
                .name = "DATAPORT L3 HIT L3BANK4",
                .symbol_name = "DATAPORT_L3_HIT_L3BANK4",
                .desc = "Number of L3 hits for requests coming from the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__dataport_l3_hit_l3_bank4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_DATAPORT_L3_HIT_L3BANK4_availability,
            },

            {
                .name = "DATAPORT L3 HIT L3BANK5",
                .symbol_name = "DATAPORT_L3_HIT_L3BANK5",
                .desc = "Number of L3 hits for requests coming from the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__dataport_l3_hit_l3_bank5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_DATAPORT_L3_HIT_L3BANK5_availability,
            },

            {
                .name = "DATAPORT L3 HIT L3BANK6",
                .symbol_name = "DATAPORT_L3_HIT_L3BANK6",
                .desc = "Number of L3 hits for requests coming from the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__dataport_l3_hit_l3_bank6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_DATAPORT_L3_HIT_L3BANK6_availability,
            },

            {
                .name = "DATAPORT L3 HIT L3BANK7",
                .symbol_name = "DATAPORT_L3_HIT_L3BANK7",
                .desc = "Number of L3 hits for requests coming from the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext10__dataport_l3_hit_l3_bank7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext10_DATAPORT_L3_HIT_L3BANK7_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext10__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext10__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 19);
}

static bool acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_Z_L3_HIT_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_Z_L3_HIT_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_Z_L3_HIT_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_Z_L3_HIT_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_Z_L3_HIT_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_Z_L3_HIT_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_Z_L3_HIT_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext11_Z_L3_HIT_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext11_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext11";
    metric_set->symbol_name = "Ext11";
    metric_set->hw_config_guid = "3c626d93-4368-4115-a21d-8fd8cd10e8fa";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext11_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext11__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext11__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext11__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext11__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 ATOMIC ACCESS L3BANK0",
                .symbol_name = "L3_ATOMIC_ACCESS_L3BANK0",
                .desc = "Number of atomic accesses to L3 bank",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__l3_atomic_access_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK0_availability,
            },

            {
                .name = "L3 ATOMIC ACCESS L3BANK1",
                .symbol_name = "L3_ATOMIC_ACCESS_L3BANK1",
                .desc = "Number of atomic accesses to L3 bank",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__l3_atomic_access_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK1_availability,
            },

            {
                .name = "L3 ATOMIC ACCESS L3BANK2",
                .symbol_name = "L3_ATOMIC_ACCESS_L3BANK2",
                .desc = "Number of atomic accesses to L3 bank",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__l3_atomic_access_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK2_availability,
            },

            {
                .name = "L3 ATOMIC ACCESS L3BANK3",
                .symbol_name = "L3_ATOMIC_ACCESS_L3BANK3",
                .desc = "Number of atomic accesses to L3 bank",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__l3_atomic_access_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK3_availability,
            },

            {
                .name = "L3 ATOMIC ACCESS L3BANK4",
                .symbol_name = "L3_ATOMIC_ACCESS_L3BANK4",
                .desc = "Number of atomic accesses to L3 bank",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__l3_atomic_access_l3_bank4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK4_availability,
            },

            {
                .name = "L3 ATOMIC ACCESS L3BANK5",
                .symbol_name = "L3_ATOMIC_ACCESS_L3BANK5",
                .desc = "Number of atomic accesses to L3 bank",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__l3_atomic_access_l3_bank5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK5_availability,
            },

            {
                .name = "L3 ATOMIC ACCESS L3BANK6",
                .symbol_name = "L3_ATOMIC_ACCESS_L3BANK6",
                .desc = "Number of atomic accesses to L3 bank",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__l3_atomic_access_l3_bank6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK6_availability,
            },

            {
                .name = "L3 ATOMIC ACCESS L3BANK7",
                .symbol_name = "L3_ATOMIC_ACCESS_L3BANK7",
                .desc = "Number of atomic accesses to L3 bank",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__l3_atomic_access_l3_bank7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_L3_ATOMIC_ACCESS_L3BANK7_availability,
            },

            {
                .name = "Z L3 HIT L3BANK0",
                .symbol_name = "Z_L3_HIT_L3BANK0",
                .desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__z_l3_hit_l3_bank0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_Z_L3_HIT_L3BANK0_availability,
            },

            {
                .name = "Z L3 HIT L3BANK1",
                .symbol_name = "Z_L3_HIT_L3BANK1",
                .desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__z_l3_hit_l3_bank1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_Z_L3_HIT_L3BANK1_availability,
            },

            {
                .name = "Z L3 HIT L3BANK2",
                .symbol_name = "Z_L3_HIT_L3BANK2",
                .desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__z_l3_hit_l3_bank2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_Z_L3_HIT_L3BANK2_availability,
            },

            {
                .name = "Z L3 HIT L3BANK3",
                .symbol_name = "Z_L3_HIT_L3BANK3",
                .desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__z_l3_hit_l3_bank3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_Z_L3_HIT_L3BANK3_availability,
            },

            {
                .name = "Z L3 HIT L3BANK4",
                .symbol_name = "Z_L3_HIT_L3BANK4",
                .desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__z_l3_hit_l3_bank4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_Z_L3_HIT_L3BANK4_availability,
            },

            {
                .name = "Z L3 HIT L3BANK5",
                .symbol_name = "Z_L3_HIT_L3BANK5",
                .desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__z_l3_hit_l3_bank5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_Z_L3_HIT_L3BANK5_availability,
            },

            {
                .name = "Z L3 HIT L3BANK6",
                .symbol_name = "Z_L3_HIT_L3BANK6",
                .desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__z_l3_hit_l3_bank6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_Z_L3_HIT_L3BANK6_availability,
            },

            {
                .name = "Z L3 HIT L3BANK7",
                .symbol_name = "Z_L3_HIT_L3BANK7",
                .desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext11__z_l3_hit_l3_bank7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L3Cache",
                .availability = acmgt1_ext11_Z_L3_HIT_L3BANK7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 19);
}

static bool acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_OUTPUT_READY_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_OUTPUT_READY_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_OUTPUT_READY_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_OUTPUT_READY_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_OUTPUT_READY_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_OUTPUT_READY_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_OUTPUT_READY_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext12_L3_OUTPUT_READY_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext12_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext12";
    metric_set->symbol_name = "Ext12";
    metric_set->hw_config_guid = "4678846c-99cd-4a3f-acb4-8f055f48da56";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext12_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext12__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext12__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext12__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext12__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 BANK INPUT AVAILABLE L3BANK0",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK0",
                .desc = "Percentage of time in which L3 bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_input_available_l3_bank0__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK0_availability,
            },

            {
                .name = "L3 BANK INPUT AVAILABLE L3BANK1",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK1",
                .desc = "Percentage of time in which L3 bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_input_available_l3_bank1__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK1_availability,
            },

            {
                .name = "L3 BANK INPUT AVAILABLE L3BANK2",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK2",
                .desc = "Percentage of time in which L3 bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_input_available_l3_bank2__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK2_availability,
            },

            {
                .name = "L3 BANK INPUT AVAILABLE L3BANK3",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK3",
                .desc = "Percentage of time in which L3 bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_input_available_l3_bank3__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK3_availability,
            },

            {
                .name = "L3 BANK INPUT AVAILABLE L3BANK4",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK4",
                .desc = "Percentage of time in which L3 bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_input_available_l3_bank4__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK4_availability,
            },

            {
                .name = "L3 BANK INPUT AVAILABLE L3BANK5",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK5",
                .desc = "Percentage of time in which L3 bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_input_available_l3_bank5__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK5_availability,
            },

            {
                .name = "L3 BANK INPUT AVAILABLE L3BANK6",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK6",
                .desc = "Percentage of time in which L3 bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_input_available_l3_bank6__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK6_availability,
            },

            {
                .name = "L3 BANK INPUT AVAILABLE L3BANK7",
                .symbol_name = "L3_INPUT_AVAILABLE_L3BANK7",
                .desc = "Percentage of time in which L3 bank has input requests",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_input_available_l3_bank7__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_INPUT_AVAILABLE_L3BANK7_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK0",
                .symbol_name = "L3_OUTPUT_READY_L3BANK0",
                .desc = "Percentage of time in which L3 bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_output_ready_l3_bank0__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_OUTPUT_READY_L3BANK0_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK1",
                .symbol_name = "L3_OUTPUT_READY_L3BANK1",
                .desc = "Percentage of time in which L3 bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_output_ready_l3_bank1__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_OUTPUT_READY_L3BANK1_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK2",
                .symbol_name = "L3_OUTPUT_READY_L3BANK2",
                .desc = "Percentage of time in which L3 bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_output_ready_l3_bank2__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_OUTPUT_READY_L3BANK2_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK3",
                .symbol_name = "L3_OUTPUT_READY_L3BANK3",
                .desc = "Percentage of time in which L3 bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_output_ready_l3_bank3__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_OUTPUT_READY_L3BANK3_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK4",
                .symbol_name = "L3_OUTPUT_READY_L3BANK4",
                .desc = "Percentage of time in which L3 bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_output_ready_l3_bank4__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_OUTPUT_READY_L3BANK4_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK5",
                .symbol_name = "L3_OUTPUT_READY_L3BANK5",
                .desc = "Percentage of time in which L3 bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_output_ready_l3_bank5__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_OUTPUT_READY_L3BANK5_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK6",
                .symbol_name = "L3_OUTPUT_READY_L3BANK6",
                .desc = "Percentage of time in which L3 bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_output_ready_l3_bank6__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_OUTPUT_READY_L3BANK6_availability,
            },

            {
                .name = "L3 OUTPUT READY L3BANK7",
                .symbol_name = "L3_OUTPUT_READY_L3BANK7",
                .desc = "Percentage of time in which L3 bank has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext12__l3_output_ready_l3_bank7__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext12_L3_OUTPUT_READY_L3BANK7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 19);
}

static bool acmgt1_ext13_L3_SUPERQ_FULL_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext13_L3_SUPERQ_FULL_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext13_L3_SUPERQ_FULL_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext13_L3_SUPERQ_FULL_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext13_L3_SUPERQ_FULL_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext13_L3_SUPERQ_FULL_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext13_L3_SUPERQ_FULL_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext13_L3_SUPERQ_FULL_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext13_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext13";
    metric_set->symbol_name = "Ext13";
    metric_set->hw_config_guid = "04d1f1c5-17e5-4104-b5a1-d62337b681b9";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext13_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext13__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext13__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext13__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext13__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 SUPERQ FULL L3BANK0",
                .symbol_name = "L3_SUPERQ_FULL_L3BANK0",
                .desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext13__l3_superq_full_l3_bank0__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext13_L3_SUPERQ_FULL_L3BANK0_availability,
            },

            {
                .name = "L3 SUPERQ FULL L3BANK1",
                .symbol_name = "L3_SUPERQ_FULL_L3BANK1",
                .desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext13__l3_superq_full_l3_bank1__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext13_L3_SUPERQ_FULL_L3BANK1_availability,
            },

            {
                .name = "L3 SUPERQ FULL L3BANK2",
                .symbol_name = "L3_SUPERQ_FULL_L3BANK2",
                .desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext13__l3_superq_full_l3_bank2__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext13_L3_SUPERQ_FULL_L3BANK2_availability,
            },

            {
                .name = "L3 SUPERQ FULL L3BANK3",
                .symbol_name = "L3_SUPERQ_FULL_L3BANK3",
                .desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext13__l3_superq_full_l3_bank3__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext13_L3_SUPERQ_FULL_L3BANK3_availability,
            },

            {
                .name = "L3 SUPERQ FULL L3BANK4",
                .symbol_name = "L3_SUPERQ_FULL_L3BANK4",
                .desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext13__l3_superq_full_l3_bank4__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext13_L3_SUPERQ_FULL_L3BANK4_availability,
            },

            {
                .name = "L3 SUPERQ FULL L3BANK5",
                .symbol_name = "L3_SUPERQ_FULL_L3BANK5",
                .desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext13__l3_superq_full_l3_bank5__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext13_L3_SUPERQ_FULL_L3BANK5_availability,
            },

            {
                .name = "L3 SUPERQ FULL L3BANK6",
                .symbol_name = "L3_SUPERQ_FULL_L3BANK6",
                .desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext13__l3_superq_full_l3_bank6__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext13_L3_SUPERQ_FULL_L3BANK6_availability,
            },

            {
                .name = "L3 SUPERQ FULL L3BANK7",
                .symbol_name = "L3_SUPERQ_FULL_L3BANK7",
                .desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext13__l3_superq_full_l3_bank7__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext13_L3_SUPERQ_FULL_L3BANK7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool acmgt1_ext14_L3_BUSY_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext14_L3_BUSY_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext14_L3_BUSY_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext14_L3_BUSY_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext14_L3_BUSY_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext14_L3_BUSY_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext14_L3_BUSY_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext14_L3_BUSY_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext14_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext14";
    metric_set->symbol_name = "Ext14";
    metric_set->hw_config_guid = "9312e21f-5d97-4058-a2fc-c7497c18f0a1";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext14_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext14__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext14__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext14__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext14__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 BANK ACTIVE L3BANK0",
                .symbol_name = "L3_BUSY_L3BANK0",
                .desc = "Percentage of time in which L3 request queue has one or more requests pending",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext14__l3_busy_l3_bank0__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext14_L3_BUSY_L3BANK0_availability,
            },

            {
                .name = "L3 BANK ACTIVE L3BANK1",
                .symbol_name = "L3_BUSY_L3BANK1",
                .desc = "Percentage of time in which L3 request queue has one or more requests pending",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext14__l3_busy_l3_bank1__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext14_L3_BUSY_L3BANK1_availability,
            },

            {
                .name = "L3 BANK ACTIVE L3BANK2",
                .symbol_name = "L3_BUSY_L3BANK2",
                .desc = "Percentage of time in which L3 request queue has one or more requests pending",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext14__l3_busy_l3_bank2__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext14_L3_BUSY_L3BANK2_availability,
            },

            {
                .name = "L3 BANK ACTIVE L3BANK3",
                .symbol_name = "L3_BUSY_L3BANK3",
                .desc = "Percentage of time in which L3 request queue has one or more requests pending",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext14__l3_busy_l3_bank3__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext14_L3_BUSY_L3BANK3_availability,
            },

            {
                .name = "L3 BANK ACTIVE L3BANK4",
                .symbol_name = "L3_BUSY_L3BANK4",
                .desc = "Percentage of time in which L3 request queue has one or more requests pending",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext14__l3_busy_l3_bank4__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext14_L3_BUSY_L3BANK4_availability,
            },

            {
                .name = "L3 BANK ACTIVE L3BANK5",
                .symbol_name = "L3_BUSY_L3BANK5",
                .desc = "Percentage of time in which L3 request queue has one or more requests pending",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext14__l3_busy_l3_bank5__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext14_L3_BUSY_L3BANK5_availability,
            },

            {
                .name = "L3 BANK ACTIVE L3BANK6",
                .symbol_name = "L3_BUSY_L3BANK6",
                .desc = "Percentage of time in which L3 request queue has one or more requests pending",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext14__l3_busy_l3_bank6__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext14_L3_BUSY_L3BANK6_availability,
            },

            {
                .name = "L3 BANK ACTIVE L3BANK7",
                .symbol_name = "L3_BUSY_L3BANK7",
                .desc = "Percentage of time in which L3 request queue has one or more requests pending",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext14__l3_busy_l3_bank7__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext14_L3_BUSY_L3BANK7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool acmgt1_ext15_L3_STALL_L3BANK0_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext15_L3_STALL_L3BANK1_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext15_L3_STALL_L3BANK2_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext15_L3_STALL_L3BANK3_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext15_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext15";
    metric_set->symbol_name = "Ext15";
    metric_set->hw_config_guid = "fd355e93-4edf-425c-99e6-8693a22ae3cd";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext15_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext15__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext15__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext15__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext15__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 BANK STALL L3BANK0",
                .symbol_name = "L3_STALL_L3BANK0",
                .desc = "Percentage of time in which L3 bank stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext15__l3_stall_l3_bank0__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext15_L3_STALL_L3BANK0_availability,
            },

            {
                .name = "L3 BANK STALL L3BANK1",
                .symbol_name = "L3_STALL_L3BANK1",
                .desc = "Percentage of time in which L3 bank stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext15__l3_stall_l3_bank1__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext15_L3_STALL_L3BANK1_availability,
            },

            {
                .name = "L3 BANK STALL L3BANK2",
                .symbol_name = "L3_STALL_L3BANK2",
                .desc = "Percentage of time in which L3 bank stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext15__l3_stall_l3_bank2__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext15_L3_STALL_L3BANK2_availability,
            },

            {
                .name = "L3 BANK STALL L3BANK3",
                .symbol_name = "L3_STALL_L3BANK3",
                .desc = "Percentage of time in which L3 bank stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext15__l3_stall_l3_bank3__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext15_L3_STALL_L3BANK3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext16_L3_STALL_L3BANK4_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext16_L3_STALL_L3BANK5_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext16_L3_STALL_L3BANK6_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}
static bool acmgt1_ext16_L3_STALL_L3BANK7_availability(const struct intel_perf *perf) {
    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext16_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext16";
    metric_set->symbol_name = "Ext16";
    metric_set->hw_config_guid = "844efb3d-c453-4dd2-b556-7bac8e111b46";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext16_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext16__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext16__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext16__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext16__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "L3 BANK STALL L3BANK4",
                .symbol_name = "L3_STALL_L3BANK4",
                .desc = "Percentage of time in which L3 bank stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext16__l3_stall_l3_bank4__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext16_L3_STALL_L3BANK4_availability,
            },

            {
                .name = "L3 BANK STALL L3BANK5",
                .symbol_name = "L3_STALL_L3BANK5",
                .desc = "Percentage of time in which L3 bank stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext16__l3_stall_l3_bank5__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext16_L3_STALL_L3BANK5_availability,
            },

            {
                .name = "L3 BANK STALL L3BANK6",
                .symbol_name = "L3_STALL_L3BANK6",
                .desc = "Percentage of time in which L3 bank stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext16__l3_stall_l3_bank6__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext16_L3_STALL_L3BANK6_availability,
            },

            {
                .name = "L3 BANK STALL L3BANK7",
                .symbol_name = "L3_STALL_L3BANK7",
                .desc = "Percentage of time in which L3 bank stalled",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext16__l3_stall_l3_bank7__read,
                .max_float = percentage_max_callback_float,
                .group = "L3Cache",
                .availability = acmgt1_ext16_L3_STALL_L3BANK7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext17_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext17";
    metric_set->symbol_name = "Ext17";
    metric_set->hw_config_guid = "fadda67d-1b94-40d1-be89-759f78641ab2";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext17_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext17__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext17__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext17__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext17__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE INPUT AVAILABLE XECORE0",
                .symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE0",
                .desc = "Percentage of time in which the Load Store Cache has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext17__load_store_cache_input_available_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE0_availability,
            },

            {
                .name = "LOAD STORE CACHE INPUT AVAILABLE XECORE1",
                .symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE1",
                .desc = "Percentage of time in which the Load Store Cache has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext17__load_store_cache_input_available_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE1_availability,
            },

            {
                .name = "LOAD STORE CACHE INPUT AVAILABLE XECORE2",
                .symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE2",
                .desc = "Percentage of time in which the Load Store Cache has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext17__load_store_cache_input_available_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE2_availability,
            },

            {
                .name = "LOAD STORE CACHE INPUT AVAILABLE XECORE3",
                .symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE3",
                .desc = "Percentage of time in which the Load Store Cache has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext17__load_store_cache_input_available_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext17_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext18_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext18_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext18_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext18_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext18_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext18";
    metric_set->symbol_name = "Ext18";
    metric_set->hw_config_guid = "bdd021fa-a841-4f92-826f-c3ae681c68e6";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext18_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext18__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext18__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext18__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext18__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE INPUT AVAILABLE XECORE4",
                .symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE4",
                .desc = "Percentage of time in which the Load Store Cache has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext18__load_store_cache_input_available_xecore4__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext18_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE4_availability,
            },

            {
                .name = "LOAD STORE CACHE INPUT AVAILABLE XECORE5",
                .symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE5",
                .desc = "Percentage of time in which the Load Store Cache has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext18__load_store_cache_input_available_xecore5__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext18_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE5_availability,
            },

            {
                .name = "LOAD STORE CACHE INPUT AVAILABLE XECORE6",
                .symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE6",
                .desc = "Percentage of time in which the Load Store Cache has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext18__load_store_cache_input_available_xecore6__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext18_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE6_availability,
            },

            {
                .name = "LOAD STORE CACHE INPUT AVAILABLE XECORE7",
                .symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE7",
                .desc = "Percentage of time in which the Load Store Cache has input available",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext18__load_store_cache_input_available_xecore7__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext18_LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext19_LOAD_STORE_CACHE_OUTPUT_READY_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext19_LOAD_STORE_CACHE_OUTPUT_READY_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext19_LOAD_STORE_CACHE_OUTPUT_READY_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext19_LOAD_STORE_CACHE_OUTPUT_READY_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext19_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext19";
    metric_set->symbol_name = "Ext19";
    metric_set->hw_config_guid = "1181d35b-bf9a-4640-82b8-e31e031ea8d3";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext19_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext19__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext19__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext19__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext19__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE OUTPUT READY XECORE0",
                .symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE0",
                .desc = "Percentage of time in which the Load Store Cache has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext19__load_store_cache_output_ready_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext19_LOAD_STORE_CACHE_OUTPUT_READY_XECORE0_availability,
            },

            {
                .name = "LOAD STORE CACHE OUTPUT READY XECORE1",
                .symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE1",
                .desc = "Percentage of time in which the Load Store Cache has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext19__load_store_cache_output_ready_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext19_LOAD_STORE_CACHE_OUTPUT_READY_XECORE1_availability,
            },

            {
                .name = "LOAD STORE CACHE OUTPUT READY XECORE2",
                .symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE2",
                .desc = "Percentage of time in which the Load Store Cache has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext19__load_store_cache_output_ready_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext19_LOAD_STORE_CACHE_OUTPUT_READY_XECORE2_availability,
            },

            {
                .name = "LOAD STORE CACHE OUTPUT READY XECORE3",
                .symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE3",
                .desc = "Percentage of time in which the Load Store Cache has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext19__load_store_cache_output_ready_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext19_LOAD_STORE_CACHE_OUTPUT_READY_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext20_LOAD_STORE_CACHE_OUTPUT_READY_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext20_LOAD_STORE_CACHE_OUTPUT_READY_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext20_LOAD_STORE_CACHE_OUTPUT_READY_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext20_LOAD_STORE_CACHE_OUTPUT_READY_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext20_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext20";
    metric_set->symbol_name = "Ext20";
    metric_set->hw_config_guid = "aa39f75d-0a8a-43d1-9c51-bcd8c62cdfe6";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext20_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext20__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext20__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext20__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext20__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE OUTPUT READY XECORE4",
                .symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE4",
                .desc = "Percentage of time in which the Load Store Cache has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext20__load_store_cache_output_ready_xecore4__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext20_LOAD_STORE_CACHE_OUTPUT_READY_XECORE4_availability,
            },

            {
                .name = "LOAD STORE CACHE OUTPUT READY XECORE5",
                .symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE5",
                .desc = "Percentage of time in which the Load Store Cache has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext20__load_store_cache_output_ready_xecore5__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext20_LOAD_STORE_CACHE_OUTPUT_READY_XECORE5_availability,
            },

            {
                .name = "LOAD STORE CACHE OUTPUT READY XECORE6",
                .symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE6",
                .desc = "Percentage of time in which the Load Store Cache has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext20__load_store_cache_output_ready_xecore6__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext20_LOAD_STORE_CACHE_OUTPUT_READY_XECORE6_availability,
            },

            {
                .name = "LOAD STORE CACHE OUTPUT READY XECORE7",
                .symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE7",
                .desc = "Percentage of time in which the Load Store Cache has output ready",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext20__load_store_cache_output_ready_xecore7__read,
                .max_float = percentage_max_callback_float,
                .group = "L1Cache",
                .availability = acmgt1_ext20_LOAD_STORE_CACHE_OUTPUT_READY_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext21_LOAD_STORE_CACHE_ACCESS_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext21_LOAD_STORE_CACHE_ACCESS_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext21_LOAD_STORE_CACHE_ACCESS_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext21_LOAD_STORE_CACHE_ACCESS_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext21_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext21";
    metric_set->symbol_name = "Ext21";
    metric_set->hw_config_guid = "ae58d1ad-8aed-4104-a8e2-443d7e800378";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext21_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext21__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext21__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext21__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext21__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE ACCESS XECORE0",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE0",
                .desc = "Number of Load Store Cache accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext21__load_store_cache_access_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext21_LOAD_STORE_CACHE_ACCESS_XECORE0_availability,
            },

            {
                .name = "LOAD STORE CACHE ACCESS XECORE1",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE1",
                .desc = "Number of Load Store Cache accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext21__load_store_cache_access_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext21_LOAD_STORE_CACHE_ACCESS_XECORE1_availability,
            },

            {
                .name = "LOAD STORE CACHE ACCESS XECORE2",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE2",
                .desc = "Number of Load Store Cache accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext21__load_store_cache_access_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext21_LOAD_STORE_CACHE_ACCESS_XECORE2_availability,
            },

            {
                .name = "LOAD STORE CACHE ACCESS XECORE3",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE3",
                .desc = "Number of Load Store Cache accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext21__load_store_cache_access_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext21_LOAD_STORE_CACHE_ACCESS_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext22_LOAD_STORE_CACHE_ACCESS_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext22_LOAD_STORE_CACHE_ACCESS_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext22_LOAD_STORE_CACHE_ACCESS_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext22_LOAD_STORE_CACHE_ACCESS_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext22_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext22";
    metric_set->symbol_name = "Ext22";
    metric_set->hw_config_guid = "c27ebd95-f242-4f4b-969a-9850f1081c30";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext22_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext22__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext22__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext22__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext22__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE ACCESS XECORE4",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE4",
                .desc = "Number of Load Store Cache accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext22__load_store_cache_access_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext22_LOAD_STORE_CACHE_ACCESS_XECORE4_availability,
            },

            {
                .name = "LOAD STORE CACHE ACCESS XECORE5",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE5",
                .desc = "Number of Load Store Cache accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext22__load_store_cache_access_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext22_LOAD_STORE_CACHE_ACCESS_XECORE5_availability,
            },

            {
                .name = "LOAD STORE CACHE ACCESS XECORE6",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE6",
                .desc = "Number of Load Store Cache accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext22__load_store_cache_access_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext22_LOAD_STORE_CACHE_ACCESS_XECORE6_availability,
            },

            {
                .name = "LOAD STORE CACHE ACCESS XECORE7",
                .symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE7",
                .desc = "Number of Load Store Cache accesses.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext22__load_store_cache_access_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext22_LOAD_STORE_CACHE_ACCESS_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext23_LOAD_STORE_CACHE_HIT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext23_LOAD_STORE_CACHE_HIT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext23_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext23";
    metric_set->symbol_name = "Ext23";
    metric_set->hw_config_guid = "881a8616-b63f-4bb1-970a-73b40b762434";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext23_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext23__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext23__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext23__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext23__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE HIT XECORE0",
                .symbol_name = "LOAD_STORE_CACHE_HIT_XECORE0",
                .desc = "Number of Load Store Cache hits.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext23__load_store_cache_hit_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext23_LOAD_STORE_CACHE_HIT_XECORE0_availability,
            },

            {
                .name = "LOAD STORE CACHE HIT XECORE1",
                .symbol_name = "LOAD_STORE_CACHE_HIT_XECORE1",
                .desc = "Number of Load Store Cache hits.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext23__load_store_cache_hit_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext23_LOAD_STORE_CACHE_HIT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext24_LOAD_STORE_CACHE_HIT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext24_LOAD_STORE_CACHE_HIT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext24_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext24";
    metric_set->symbol_name = "Ext24";
    metric_set->hw_config_guid = "9fe09ad3-d296-4d41-ab19-270431f7ab29";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext24_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext24__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext24__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext24__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext24__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE HIT XECORE2",
                .symbol_name = "LOAD_STORE_CACHE_HIT_XECORE2",
                .desc = "Number of Load Store Cache hits.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext24__load_store_cache_hit_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext24_LOAD_STORE_CACHE_HIT_XECORE2_availability,
            },

            {
                .name = "LOAD STORE CACHE HIT XECORE3",
                .symbol_name = "LOAD_STORE_CACHE_HIT_XECORE3",
                .desc = "Number of Load Store Cache hits.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext24__load_store_cache_hit_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext24_LOAD_STORE_CACHE_HIT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext25_LOAD_STORE_CACHE_HIT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext25_LOAD_STORE_CACHE_HIT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext25_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext25";
    metric_set->symbol_name = "Ext25";
    metric_set->hw_config_guid = "e2016425-8755-4ca0-bc93-354ba7a6ca7a";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext25_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext25__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext25__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext25__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext25__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE HIT XECORE4",
                .symbol_name = "LOAD_STORE_CACHE_HIT_XECORE4",
                .desc = "Number of Load Store Cache hits.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext25__load_store_cache_hit_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext25_LOAD_STORE_CACHE_HIT_XECORE4_availability,
            },

            {
                .name = "LOAD STORE CACHE HIT XECORE5",
                .symbol_name = "LOAD_STORE_CACHE_HIT_XECORE5",
                .desc = "Number of Load Store Cache hits.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext25__load_store_cache_hit_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext25_LOAD_STORE_CACHE_HIT_XECORE5_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext26_LOAD_STORE_CACHE_HIT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext26_LOAD_STORE_CACHE_HIT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext26_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext26";
    metric_set->symbol_name = "Ext26";
    metric_set->hw_config_guid = "9fc2d1f6-7504-41f2-9f4b-96ff3307f6cb";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext26_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext26__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext26__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext26__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext26__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE HIT XECORE6",
                .symbol_name = "LOAD_STORE_CACHE_HIT_XECORE6",
                .desc = "Number of Load Store Cache hits.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext26__load_store_cache_hit_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext26_LOAD_STORE_CACHE_HIT_XECORE6_availability,
            },

            {
                .name = "LOAD STORE CACHE HIT XECORE7",
                .symbol_name = "LOAD_STORE_CACHE_HIT_XECORE7",
                .desc = "Number of Load Store Cache hits.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext26__load_store_cache_hit_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext26_LOAD_STORE_CACHE_HIT_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext27_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext27";
    metric_set->symbol_name = "Ext27";
    metric_set->hw_config_guid = "7bc1c162-2b4b-4cb8-b351-65be069d3f10";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext27_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext27__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext27__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext27__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext27__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE L3 READ XECORE0",
                .symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE0",
                .desc = "Number of cacheline read requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext27__load_store_cache_l3_read_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE0_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 READ XECORE1",
                .symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE1",
                .desc = "Number of cacheline read requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext27__load_store_cache_l3_read_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE1_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 READ XECORE2",
                .symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE2",
                .desc = "Number of cacheline read requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext27__load_store_cache_l3_read_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE2_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 READ XECORE3",
                .symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE3",
                .desc = "Number of cacheline read requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext27__load_store_cache_l3_read_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE3_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 READ XECORE4",
                .symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE4",
                .desc = "Number of cacheline read requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext27__load_store_cache_l3_read_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE4_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 READ XECORE5",
                .symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE5",
                .desc = "Number of cacheline read requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext27__load_store_cache_l3_read_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE5_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 READ XECORE6",
                .symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE6",
                .desc = "Number of cacheline read requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext27__load_store_cache_l3_read_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE6_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 READ XECORE7",
                .symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE7",
                .desc = "Number of cacheline read requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext27__load_store_cache_l3_read_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext27_LOAD_STORE_CACHE_L3_READ_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext28_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext28";
    metric_set->symbol_name = "Ext28";
    metric_set->hw_config_guid = "afdf809e-962c-4af5-8e08-cd55b455dee9";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext28_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext28__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext28__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext28__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext28__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE L3 WRITE XECORE0",
                .symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE0",
                .desc = "Number of cacheline write requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext28__load_store_cache_l3_write_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE0_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 WRITE XECORE1",
                .symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE1",
                .desc = "Number of cacheline write requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext28__load_store_cache_l3_write_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE1_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 WRITE XECORE2",
                .symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE2",
                .desc = "Number of cacheline write requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext28__load_store_cache_l3_write_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE2_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 WRITE XECORE3",
                .symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE3",
                .desc = "Number of cacheline write requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext28__load_store_cache_l3_write_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE3_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 WRITE XECORE4",
                .symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE4",
                .desc = "Number of cacheline write requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext28__load_store_cache_l3_write_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE4_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 WRITE XECORE5",
                .symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE5",
                .desc = "Number of cacheline write requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext28__load_store_cache_l3_write_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE5_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 WRITE XECORE6",
                .symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE6",
                .desc = "Number of cacheline write requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext28__load_store_cache_l3_write_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE6_availability,
            },

            {
                .name = "LOAD STORE CACHE L3 WRITE XECORE7",
                .symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE7",
                .desc = "Number of cacheline write requests from the Load Store Cache to L3",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext28__load_store_cache_l3_write_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext28_LOAD_STORE_CACHE_L3_WRITE_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool acmgt1_ext29_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext29_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext29_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext29_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext29_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext29";
    metric_set->symbol_name = "Ext29";
    metric_set->hw_config_guid = "4f22c4f0-68ce-46ad-91a7-272b517bfa2e";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext29_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext29__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext29__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext29__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext29__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE0",
                .symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE0",
                .desc = "Number of writes to the Load Store Cache that don't fill a subsector",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext29__load_store_cache_partial_write_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext29_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE0_availability,
            },

            {
                .name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE1",
                .symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE1",
                .desc = "Number of writes to the Load Store Cache that don't fill a subsector",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext29__load_store_cache_partial_write_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext29_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE1_availability,
            },

            {
                .name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE2",
                .symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE2",
                .desc = "Number of writes to the Load Store Cache that don't fill a subsector",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext29__load_store_cache_partial_write_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext29_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE2_availability,
            },

            {
                .name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE3",
                .symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE3",
                .desc = "Number of writes to the Load Store Cache that don't fill a subsector",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext29__load_store_cache_partial_write_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext29_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext30_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext30_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext30_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext30_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext30_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext30";
    metric_set->symbol_name = "Ext30";
    metric_set->hw_config_guid = "376f6937-f69d-41b0-a1ae-402dee9d42cb";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext30_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext30__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext30__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext30__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext30__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE4",
                .symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE4",
                .desc = "Number of writes to the Load Store Cache that don't fill a subsector",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext30__load_store_cache_partial_write_count_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext30_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE4_availability,
            },

            {
                .name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE5",
                .symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE5",
                .desc = "Number of writes to the Load Store Cache that don't fill a subsector",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext30__load_store_cache_partial_write_count_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext30_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE5_availability,
            },

            {
                .name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE6",
                .symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE6",
                .desc = "Number of writes to the Load Store Cache that don't fill a subsector",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext30__load_store_cache_partial_write_count_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext30_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE6_availability,
            },

            {
                .name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE7",
                .symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE7",
                .desc = "Number of writes to the Load Store Cache that don't fill a subsector",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext30__load_store_cache_partial_write_count_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext30_LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext31_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext31_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext31_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext31";
    metric_set->symbol_name = "Ext31";
    metric_set->hw_config_guid = "28e81769-8b4e-4a6f-a658-19901c71f724";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext31_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext31__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext31__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext31__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext31__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE0",
                .desc = "Number of read messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext31__xve_load_store_cache_read_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext31_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE1",
                .desc = "Number of read messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext31__xve_load_store_cache_read_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext31_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext32_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext32_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext32_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext32";
    metric_set->symbol_name = "Ext32";
    metric_set->hw_config_guid = "0efcc5a6-bbc5-4af3-bf07-db3597f314ab";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext32_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext32__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext32__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext32__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext32__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE2",
                .desc = "Number of read messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext32__xve_load_store_cache_read_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext32_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE3",
                .desc = "Number of read messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext32__xve_load_store_cache_read_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext32_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext33_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext33_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext33_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext33";
    metric_set->symbol_name = "Ext33";
    metric_set->hw_config_guid = "038bcd96-55da-41c0-b9ad-6d71e943f1b9";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext33_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext33__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext33__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext33__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext33__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE4",
                .symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE4",
                .desc = "Number of read messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext33__xve_load_store_cache_read_message_count_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext33_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE4_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE5",
                .symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE5",
                .desc = "Number of read messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext33__xve_load_store_cache_read_message_count_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext33_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE5_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext34_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext34_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext34_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext34";
    metric_set->symbol_name = "Ext34";
    metric_set->hw_config_guid = "48d0ac9b-3e47-43c9-9779-3e2cdf315635";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext34_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext34__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext34__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext34__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext34__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE6",
                .symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE6",
                .desc = "Number of read messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext34__xve_load_store_cache_read_message_count_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext34_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE6_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE7",
                .symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE7",
                .desc = "Number of read messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext34__xve_load_store_cache_read_message_count_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext34_XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext35_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext35_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext35_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext35";
    metric_set->symbol_name = "Ext35";
    metric_set->hw_config_guid = "ebe68cc1-ddda-412d-b9de-4616c4421712";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext35_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext35__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext35__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext35__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext35__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE0",
                .desc = "Number of write messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext35__xve_load_store_cache_write_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext35_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE1",
                .desc = "Number of write messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext35__xve_load_store_cache_write_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext35_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext36_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext36_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext36_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext36";
    metric_set->symbol_name = "Ext36";
    metric_set->hw_config_guid = "b305a4ce-2466-4172-97f1-a09a874f377c";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext36_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext36__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext36__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext36__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext36__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE2",
                .desc = "Number of write messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext36__xve_load_store_cache_write_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext36_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE3",
                .desc = "Number of write messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext36__xve_load_store_cache_write_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext36_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext37_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext37_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext37_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext37";
    metric_set->symbol_name = "Ext37";
    metric_set->hw_config_guid = "8184361a-7e98-4f4d-b047-42c767d4c863";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext37_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext37__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext37__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext37__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext37__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE4",
                .symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE4",
                .desc = "Number of write messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext37__xve_load_store_cache_write_message_count_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext37_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE4_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE5",
                .symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE5",
                .desc = "Number of write messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext37__xve_load_store_cache_write_message_count_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext37_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE5_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext38_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext38_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext38_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext38";
    metric_set->symbol_name = "Ext38";
    metric_set->hw_config_guid = "0298d65d-a984-4f19-b968-1e65f072189d";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext38_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext38__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext38__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext38__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext38__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE6",
                .symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE6",
                .desc = "Number of write messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext38__xve_load_store_cache_write_message_count_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext38_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE6_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE7",
                .symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE7",
                .desc = "Number of write messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext38__xve_load_store_cache_write_message_count_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext38_XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext39_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext39_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext39_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext39";
    metric_set->symbol_name = "Ext39";
    metric_set->hw_config_guid = "602b3d8e-9299-4615-9739-fe44dd9b7102";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext39_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext39__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext39__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext39__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext39__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE0",
                .desc = "Number of fence messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext39__xve_load_store_cache_fence_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext39_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE1",
                .desc = "Number of fence messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext39__xve_load_store_cache_fence_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext39_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext40_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext40_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext40_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext40";
    metric_set->symbol_name = "Ext40";
    metric_set->hw_config_guid = "7595f984-7cd3-4b1c-8332-bacfd2b3a359";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext40_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext40__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext40__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext40__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext40__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE2",
                .desc = "Number of fence messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext40__xve_load_store_cache_fence_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext40_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE3",
                .desc = "Number of fence messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext40__xve_load_store_cache_fence_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext40_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext41_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext41_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext41_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext41";
    metric_set->symbol_name = "Ext41";
    metric_set->hw_config_guid = "61bf91ad-0dfa-421c-b503-0eed63b64ef5";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext41_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext41__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext41__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext41__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext41__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE4",
                .symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE4",
                .desc = "Number of fence messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext41__xve_load_store_cache_fence_message_count_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext41_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE4_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE5",
                .symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE5",
                .desc = "Number of fence messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext41__xve_load_store_cache_fence_message_count_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext41_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE5_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext42_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext42_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext42_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext42";
    metric_set->symbol_name = "Ext42";
    metric_set->hw_config_guid = "a2f3417e-fbe1-4c26-a20c-509c7205445f";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext42_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext42__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext42__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext42__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext42__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE6",
                .symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE6",
                .desc = "Number of fence messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext42__xve_load_store_cache_fence_message_count_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext42_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE6_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE7",
                .symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE7",
                .desc = "Number of fence messages sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext42__xve_load_store_cache_fence_message_count_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext42_XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext43_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext43_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext43_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext43";
    metric_set->symbol_name = "Ext43";
    metric_set->hw_config_guid = "343460a0-c54f-4fe5-b7ac-6d9870a56aaf";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext43_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext43__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext43__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext43__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext43__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE0",
                .desc = "Number of atomic operations sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext43__xve_load_store_cache_atomic_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext43_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE0",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE0",
                .desc = "Number of message payload transactions sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext43__xve_load_store_cache_register_request_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext43_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext44_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext44_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext44_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext44";
    metric_set->symbol_name = "Ext44";
    metric_set->hw_config_guid = "cfaeaf8e-4888-459f-8019-c3080595c528";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext44_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext44__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext44__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext44__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext44__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE1",
                .desc = "Number of atomic operations sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext44__xve_load_store_cache_atomic_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext44_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE1",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE1",
                .desc = "Number of message payload transactions sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext44__xve_load_store_cache_register_request_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext44_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext45_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext45_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext45_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext45";
    metric_set->symbol_name = "Ext45";
    metric_set->hw_config_guid = "c50cb371-e940-4499-aa74-4e75bc131329";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext45_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext45__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext45__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext45__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext45__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE2",
                .desc = "Number of atomic operations sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext45__xve_load_store_cache_atomic_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext45_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE2",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE2",
                .desc = "Number of message payload transactions sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext45__xve_load_store_cache_register_request_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext45_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE2_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext46_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext46_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext46_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext46";
    metric_set->symbol_name = "Ext46";
    metric_set->hw_config_guid = "b56a3837-111d-4ec1-8d3f-42e9e304d8f5";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext46_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext46__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext46__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext46__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext46__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE3",
                .desc = "Number of atomic operations sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext46__xve_load_store_cache_atomic_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext46_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE3_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE3",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE3",
                .desc = "Number of message payload transactions sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext46__xve_load_store_cache_register_request_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext46_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext47_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext47_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext47_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext47";
    metric_set->symbol_name = "Ext47";
    metric_set->hw_config_guid = "3725926f-9a84-4cc2-963c-2294f47c017c";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext47_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext47__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext47__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext47__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext47__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE4",
                .symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE4",
                .desc = "Number of atomic operations sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext47__xve_load_store_cache_atomic_message_count_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext47_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE4_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE4",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE4",
                .desc = "Number of message payload transactions sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext47__xve_load_store_cache_register_request_count_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext47_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE4_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext48_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext48_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext48_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext48";
    metric_set->symbol_name = "Ext48";
    metric_set->hw_config_guid = "357a3801-3f4e-4106-8f1e-c0bfe1c5f419";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext48_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext48__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext48__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext48__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext48__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE5",
                .symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE5",
                .desc = "Number of atomic operations sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext48__xve_load_store_cache_atomic_message_count_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext48_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE5_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE5",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE5",
                .desc = "Number of message payload transactions sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext48__xve_load_store_cache_register_request_count_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext48_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE5_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext49_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext49_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext49_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext49";
    metric_set->symbol_name = "Ext49";
    metric_set->hw_config_guid = "8b324152-65d7-4b13-8fa9-cab57cd68471";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext49_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext49__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext49__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext49__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext49__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE6",
                .symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE6",
                .desc = "Number of atomic operations sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext49__xve_load_store_cache_atomic_message_count_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext49_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE6_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE6",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE6",
                .desc = "Number of message payload transactions sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext49__xve_load_store_cache_register_request_count_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext49_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE6_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext50_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext50_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext50_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext50";
    metric_set->symbol_name = "Ext50";
    metric_set->hw_config_guid = "db09b08d-a300-4f2a-aeb0-b797e7073ef3";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext50_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext50__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext50__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext50__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext50__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE7",
                .symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE7",
                .desc = "Number of atomic operations sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext50__xve_load_store_cache_atomic_message_count_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext50_XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE7_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE7",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE7",
                .desc = "Number of message payload transactions sent by XVEs to the Load Store Cache",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext50__xve_load_store_cache_register_request_count_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext50_XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext51_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext51";
    metric_set->symbol_name = "Ext51";
    metric_set->hw_config_guid = "fc148084-3936-4dab-9b42-d7ba6ae1952d";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext51_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext51__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext51__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext51__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext51__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE0",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE0",
                .desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext51__xve_load_store_cache_register_response_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE1",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE1",
                .desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext51__xve_load_store_cache_register_response_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE2",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE2",
                .desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext51__xve_load_store_cache_register_response_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE3",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE3",
                .desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext51__xve_load_store_cache_register_response_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext51_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext52_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext52_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext52_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext52_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext52_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext52";
    metric_set->symbol_name = "Ext52";
    metric_set->hw_config_guid = "f6a3c36f-9fd8-49c4-b25a-dbf26256bdc6";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext52_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext52__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext52__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext52__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext52__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE4",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE4",
                .desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext52__xve_load_store_cache_register_response_count_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext52_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE4_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE5",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE5",
                .desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext52__xve_load_store_cache_register_response_count_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext52_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE5_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE6",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE6",
                .desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext52__xve_load_store_cache_register_response_count_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext52_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE6_availability,
            },

            {
                .name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE7",
                .symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE7",
                .desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext52__xve_load_store_cache_register_response_count_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext52_XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext53_XVE_SLM_READ_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext53_XVE_SLM_READ_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext53_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext53";
    metric_set->symbol_name = "Ext53";
    metric_set->hw_config_guid = "a9a91699-a2b3-4841-8641-4f09f04be7e1";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext53_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext53__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext53__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext53__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext53__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM READ MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE0",
                .desc = "Number of SLM read messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext53__xve_slm_read_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext53_XVE_SLM_READ_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE SLM READ MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE1",
                .desc = "Number of SLM read messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext53__xve_slm_read_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext53_XVE_SLM_READ_MESSAGE_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext54_XVE_SLM_READ_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext54_XVE_SLM_READ_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext54_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext54";
    metric_set->symbol_name = "Ext54";
    metric_set->hw_config_guid = "c44659b1-937a-44bc-8819-9c1ae31d9bdd";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext54_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext54__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext54__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext54__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext54__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM READ MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE2",
                .desc = "Number of SLM read messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext54__xve_slm_read_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext54_XVE_SLM_READ_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE SLM READ MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE3",
                .desc = "Number of SLM read messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext54__xve_slm_read_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext54_XVE_SLM_READ_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext55_XVE_SLM_READ_MESSAGE_COUNT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext55_XVE_SLM_READ_MESSAGE_COUNT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext55_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext55";
    metric_set->symbol_name = "Ext55";
    metric_set->hw_config_guid = "5bfd7ae1-27ea-4211-beb2-64565a49dfbe";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext55_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext55__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext55__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext55__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext55__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM READ MESSAGE COUNT XECORE4",
                .symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE4",
                .desc = "Number of SLM read messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext55__xve_slm_read_message_count_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext55_XVE_SLM_READ_MESSAGE_COUNT_XECORE4_availability,
            },

            {
                .name = "XVE SLM READ MESSAGE COUNT XECORE5",
                .symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE5",
                .desc = "Number of SLM read messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext55__xve_slm_read_message_count_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext55_XVE_SLM_READ_MESSAGE_COUNT_XECORE5_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext56_XVE_SLM_READ_MESSAGE_COUNT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext56_XVE_SLM_READ_MESSAGE_COUNT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext56_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext56";
    metric_set->symbol_name = "Ext56";
    metric_set->hw_config_guid = "7aefc824-149a-4f75-abed-f6430f8d4eee";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext56_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext56__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext56__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext56__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext56__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM READ MESSAGE COUNT XECORE6",
                .symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE6",
                .desc = "Number of SLM read messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext56__xve_slm_read_message_count_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext56_XVE_SLM_READ_MESSAGE_COUNT_XECORE6_availability,
            },

            {
                .name = "XVE SLM READ MESSAGE COUNT XECORE7",
                .symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE7",
                .desc = "Number of SLM read messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext56__xve_slm_read_message_count_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext56_XVE_SLM_READ_MESSAGE_COUNT_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext57_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext57_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext57_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext57";
    metric_set->symbol_name = "Ext57";
    metric_set->hw_config_guid = "0ccb67b5-7f31-4885-9973-d97e318a6f90";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext57_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext57__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext57__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext57__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext57__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM WRITE MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE0",
                .desc = "Number of SLM write messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext57__xve_slm_write_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext57_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE SLM WRITE MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE1",
                .desc = "Number of SLM write messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext57__xve_slm_write_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext57_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext58_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext58_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext58_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext58";
    metric_set->symbol_name = "Ext58";
    metric_set->hw_config_guid = "af47d7b7-691b-4ec5-abfd-67ce50938fe4";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext58_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext58__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext58__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext58__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext58__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM WRITE MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE2",
                .desc = "Number of SLM write messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext58__xve_slm_write_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext58_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE SLM WRITE MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE3",
                .desc = "Number of SLM write messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext58__xve_slm_write_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext58_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext59_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext59_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext59_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext59";
    metric_set->symbol_name = "Ext59";
    metric_set->hw_config_guid = "0df81caa-d128-4f0e-9eff-69e0359fedf1";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext59_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext59__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext59__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext59__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext59__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM WRITE MESSAGE COUNT XECORE4",
                .symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE4",
                .desc = "Number of SLM write messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext59__xve_slm_write_message_count_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext59_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE4_availability,
            },

            {
                .name = "XVE SLM WRITE MESSAGE COUNT XECORE5",
                .symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE5",
                .desc = "Number of SLM write messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext59__xve_slm_write_message_count_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext59_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE5_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext60_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext60_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext60_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext60";
    metric_set->symbol_name = "Ext60";
    metric_set->hw_config_guid = "09e71710-e49d-4d9e-b7f8-0e597aabf25b";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext60_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext60__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext60__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext60__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext60__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM WRITE MESSAGE COUNT XECORE6",
                .symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE6",
                .desc = "Number of SLM write messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext60__xve_slm_write_message_count_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext60_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE6_availability,
            },

            {
                .name = "XVE SLM WRITE MESSAGE COUNT XECORE7",
                .symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE7",
                .desc = "Number of SLM write messages sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext60__xve_slm_write_message_count_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext60_XVE_SLM_WRITE_MESSAGE_COUNT_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext61_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext61_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext61_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext61";
    metric_set->symbol_name = "Ext61";
    metric_set->hw_config_guid = "374c4608-89a8-46d3-92fa-d4848e4a7a95";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext61_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext61__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext61__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext61__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext61__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM FENCE MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE0",
                .desc = "Number of SLM fence operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext61__xve_slm_fence_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext61_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE SLM FENCE MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE1",
                .desc = "Number of SLM fence operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext61__xve_slm_fence_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext61_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext62_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext62_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext62_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext62";
    metric_set->symbol_name = "Ext62";
    metric_set->hw_config_guid = "1013ed95-4958-4cfe-8fbc-1482c07046cb";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext62_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext62__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext62__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext62__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext62__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM FENCE MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE2",
                .desc = "Number of SLM fence operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext62__xve_slm_fence_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext62_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE SLM FENCE MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE3",
                .desc = "Number of SLM fence operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext62__xve_slm_fence_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext62_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext63_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext63_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext63_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext63";
    metric_set->symbol_name = "Ext63";
    metric_set->hw_config_guid = "7a3c4561-56d3-4b61-a619-ed8c1887e034";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext63_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext63__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext63__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext63__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext63__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM FENCE MESSAGE COUNT XECORE4",
                .symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE4",
                .desc = "Number of SLM fence operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext63__xve_slm_fence_message_count_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext63_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE4_availability,
            },

            {
                .name = "XVE SLM FENCE MESSAGE COUNT XECORE5",
                .symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE5",
                .desc = "Number of SLM fence operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext63__xve_slm_fence_message_count_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext63_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE5_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext64_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext64_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext64_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext64";
    metric_set->symbol_name = "Ext64";
    metric_set->hw_config_guid = "7d50a975-2d8d-48c2-ae61-86decd3aba1d";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext64_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext64__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext64__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext64__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext64__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM FENCE MESSAGE COUNT XECORE6",
                .symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE6",
                .desc = "Number of SLM fence operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext64__xve_slm_fence_message_count_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext64_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE6_availability,
            },

            {
                .name = "XVE SLM FENCE MESSAGE COUNT XECORE7",
                .symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE7",
                .desc = "Number of SLM fence operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext64__xve_slm_fence_message_count_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext64_XVE_SLM_FENCE_MESSAGE_COUNT_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext65_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext65_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext65";
    metric_set->symbol_name = "Ext65";
    metric_set->hw_config_guid = "c036e0c0-c23a-45ec-8b24-7ab7577b18d1";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext65_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext65__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext65__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext65__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext65__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM ATOMIC MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE0",
                .desc = "Number of SLM atomic operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext65__xve_slm_atomic_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext65_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE0_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool acmgt1_ext66_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext66_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext66";
    metric_set->symbol_name = "Ext66";
    metric_set->hw_config_guid = "df8127a7-0efc-487e-a819-a20c2471e30b";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext66_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext66__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext66__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext66__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext66__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM ATOMIC MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE1",
                .desc = "Number of SLM atomic operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext66__xve_slm_atomic_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext66_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool acmgt1_ext67_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext67_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext67";
    metric_set->symbol_name = "Ext67";
    metric_set->hw_config_guid = "f9d2c7da-14c9-45a4-97f5-a0d58dd3a1aa";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext67_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext67__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext67__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext67__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext67__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM ATOMIC MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE2",
                .desc = "Number of SLM atomic operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext67__xve_slm_atomic_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext67_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE2_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool acmgt1_ext68_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext68_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext68";
    metric_set->symbol_name = "Ext68";
    metric_set->hw_config_guid = "210f665b-abaa-4389-95e3-7cad6f71db8b";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext68_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext68__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext68__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext68__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext68__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM ATOMIC MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE3",
                .desc = "Number of SLM atomic operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext68__xve_slm_atomic_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext68_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool acmgt1_ext69_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext69_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext69";
    metric_set->symbol_name = "Ext69";
    metric_set->hw_config_guid = "26eeaeca-61f0-46ba-b6ad-effb4ea076ae";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext69_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext69__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext69__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext69__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext69__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM ATOMIC MESSAGE COUNT XECORE4",
                .symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE4",
                .desc = "Number of SLM atomic operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext69__xve_slm_atomic_message_count_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext69_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE4_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool acmgt1_ext70_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext70_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext70";
    metric_set->symbol_name = "Ext70";
    metric_set->hw_config_guid = "18a0a208-526a-4705-9b06-9145f03433ea";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext70_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext70__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext70__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext70__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext70__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM ATOMIC MESSAGE COUNT XECORE5",
                .symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE5",
                .desc = "Number of SLM atomic operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext70__xve_slm_atomic_message_count_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext70_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE5_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool acmgt1_ext71_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext71_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext71";
    metric_set->symbol_name = "Ext71";
    metric_set->hw_config_guid = "0677d73a-a563-47ac-8b11-9c7c3371fc04";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext71_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext71__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext71__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext71__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext71__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM ATOMIC MESSAGE COUNT XECORE6",
                .symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE6",
                .desc = "Number of SLM atomic operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext71__xve_slm_atomic_message_count_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext71_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE6_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool acmgt1_ext72_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext72_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext72";
    metric_set->symbol_name = "Ext72";
    metric_set->hw_config_guid = "0a10b421-f9ee-4147-81e2-b2ceeb74697f";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext72_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext72__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext72__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext72__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext72__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE SLM ATOMIC MESSAGE COUNT XECORE7",
                .symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE7",
                .desc = "Number of SLM atomic operations sent by XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext72__xve_slm_atomic_message_count_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "L1Cache",
                .availability = acmgt1_ext72_XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 4);
}

static bool acmgt1_ext73_DATAPORT_INPUT_AVAILABLE_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext73_DATAPORT_INPUT_AVAILABLE_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext73_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext73";
    metric_set->symbol_name = "Ext73";
    metric_set->hw_config_guid = "4051668d-2020-4f10-a9e7-e840455b125b";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext73_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext73__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext73__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT INPUT AVAILABLE XECORE0",
                .symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE0",
                .desc = "Percentage of time in which XVEs have requests to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext73__dataport_input_available_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext73_DATAPORT_INPUT_AVAILABLE_XECORE0_availability,
            },

            {
                .name = "DATAPORT INPUT AVAILABLE XECORE1",
                .symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE1",
                .desc = "Percentage of time in which XVEs have requests to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext73__dataport_input_available_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext73_DATAPORT_INPUT_AVAILABLE_XECORE1_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext73__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext73__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext74_DATAPORT_INPUT_AVAILABLE_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext74_DATAPORT_INPUT_AVAILABLE_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext74_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext74";
    metric_set->symbol_name = "Ext74";
    metric_set->hw_config_guid = "0548ee0d-a4b2-42a7-86c6-4171ed191bec";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext74_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext74__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext74__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT INPUT AVAILABLE XECORE2",
                .symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE2",
                .desc = "Percentage of time in which XVEs have requests to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext74__dataport_input_available_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext74_DATAPORT_INPUT_AVAILABLE_XECORE2_availability,
            },

            {
                .name = "DATAPORT INPUT AVAILABLE XECORE3",
                .symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE3",
                .desc = "Percentage of time in which XVEs have requests to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext74__dataport_input_available_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext74_DATAPORT_INPUT_AVAILABLE_XECORE3_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext74__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext74__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext75_DATAPORT_INPUT_AVAILABLE_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext75_DATAPORT_INPUT_AVAILABLE_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext75_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext75";
    metric_set->symbol_name = "Ext75";
    metric_set->hw_config_guid = "4604dea5-4e86-4713-b82d-fce110cb82f8";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext75_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext75__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext75__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT INPUT AVAILABLE XECORE4",
                .symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE4",
                .desc = "Percentage of time in which XVEs have requests to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext75__dataport_input_available_xecore4__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext75_DATAPORT_INPUT_AVAILABLE_XECORE4_availability,
            },

            {
                .name = "DATAPORT INPUT AVAILABLE XECORE5",
                .symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE5",
                .desc = "Percentage of time in which XVEs have requests to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext75__dataport_input_available_xecore5__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext75_DATAPORT_INPUT_AVAILABLE_XECORE5_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext75__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext75__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext76_DATAPORT_INPUT_AVAILABLE_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext76_DATAPORT_INPUT_AVAILABLE_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext76_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext76";
    metric_set->symbol_name = "Ext76";
    metric_set->hw_config_guid = "d4171f1f-6e14-41e1-8b9d-0e28077aca25";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext76_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext76__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext76__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT INPUT AVAILABLE XECORE6",
                .symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE6",
                .desc = "Percentage of time in which XVEs have requests to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext76__dataport_input_available_xecore6__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext76_DATAPORT_INPUT_AVAILABLE_XECORE6_availability,
            },

            {
                .name = "DATAPORT INPUT AVAILABLE XECORE7",
                .symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE7",
                .desc = "Percentage of time in which XVEs have requests to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext76__dataport_input_available_xecore7__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext76_DATAPORT_INPUT_AVAILABLE_XECORE7_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext76__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext76__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext77_DATAPORT_OUTPUT_READY_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext77_DATAPORT_OUTPUT_READY_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext77_DATAPORT_OUTPUT_READY_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext77_DATAPORT_OUTPUT_READY_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext77_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext77";
    metric_set->symbol_name = "Ext77";
    metric_set->hw_config_guid = "8e91f318-149b-4ffe-9b51-42dd9b2c80a5";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext77_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext77__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext77__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT OUTPUT READY XECORE0",
                .symbol_name = "DATAPORT_OUTPUT_READY_XECORE0",
                .desc = "Percentage of time in which the Dataport has data to return to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext77__dataport_output_ready_xecore0__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext77_DATAPORT_OUTPUT_READY_XECORE0_availability,
            },

            {
                .name = "DATAPORT OUTPUT READY XECORE1",
                .symbol_name = "DATAPORT_OUTPUT_READY_XECORE1",
                .desc = "Percentage of time in which the Dataport has data to return to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext77__dataport_output_ready_xecore1__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext77_DATAPORT_OUTPUT_READY_XECORE1_availability,
            },

            {
                .name = "DATAPORT OUTPUT READY XECORE2",
                .symbol_name = "DATAPORT_OUTPUT_READY_XECORE2",
                .desc = "Percentage of time in which the Dataport has data to return to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext77__dataport_output_ready_xecore2__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext77_DATAPORT_OUTPUT_READY_XECORE2_availability,
            },

            {
                .name = "DATAPORT OUTPUT READY XECORE3",
                .symbol_name = "DATAPORT_OUTPUT_READY_XECORE3",
                .desc = "Percentage of time in which the Dataport has data to return to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext77__dataport_output_ready_xecore3__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext77_DATAPORT_OUTPUT_READY_XECORE3_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext77__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext77__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext78_DATAPORT_OUTPUT_READY_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext78_DATAPORT_OUTPUT_READY_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext78_DATAPORT_OUTPUT_READY_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext78_DATAPORT_OUTPUT_READY_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext78_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext78";
    metric_set->symbol_name = "Ext78";
    metric_set->hw_config_guid = "bf68f6bc-fdcb-4dbe-a923-abaeb72e8af6";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext78_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext78__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext78__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT OUTPUT READY XECORE4",
                .symbol_name = "DATAPORT_OUTPUT_READY_XECORE4",
                .desc = "Percentage of time in which the Dataport has data to return to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext78__dataport_output_ready_xecore4__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext78_DATAPORT_OUTPUT_READY_XECORE4_availability,
            },

            {
                .name = "DATAPORT OUTPUT READY XECORE5",
                .symbol_name = "DATAPORT_OUTPUT_READY_XECORE5",
                .desc = "Percentage of time in which the Dataport has data to return to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext78__dataport_output_ready_xecore5__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext78_DATAPORT_OUTPUT_READY_XECORE5_availability,
            },

            {
                .name = "DATAPORT OUTPUT READY XECORE6",
                .symbol_name = "DATAPORT_OUTPUT_READY_XECORE6",
                .desc = "Percentage of time in which the Dataport has data to return to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext78__dataport_output_ready_xecore6__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext78_DATAPORT_OUTPUT_READY_XECORE6_availability,
            },

            {
                .name = "DATAPORT OUTPUT READY XECORE7",
                .symbol_name = "DATAPORT_OUTPUT_READY_XECORE7",
                .desc = "Percentage of time in which the Dataport has data to return to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT,
                .read_float = acmgt1__ext78__dataport_output_ready_xecore7__read,
                .max_float = percentage_max_callback_float,
                .group = "Dataport",
                .availability = acmgt1_ext78_DATAPORT_OUTPUT_READY_XECORE7_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext78__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext78__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext79_DATAPORT_BYTE_READ_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext79_DATAPORT_BYTE_READ_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext79_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext79";
    metric_set->symbol_name = "Ext79";
    metric_set->hw_config_guid = "76b52ef9-7a1b-4475-b3bc-3a035acd32e7";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext79_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext79__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext79__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT BYTE READ XECORE0",
                .symbol_name = "DATAPORT_BYTE_READ_XECORE0",
                .desc = "Number of bytes read through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext79__dataport_byte_read_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext79_DATAPORT_BYTE_READ_XECORE0_availability,
            },

            {
                .name = "DATAPORT BYTE READ XECORE1",
                .symbol_name = "DATAPORT_BYTE_READ_XECORE1",
                .desc = "Number of bytes read through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext79__dataport_byte_read_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext79_DATAPORT_BYTE_READ_XECORE1_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext79__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext79__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext80_DATAPORT_BYTE_READ_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext80_DATAPORT_BYTE_READ_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext80_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext80";
    metric_set->symbol_name = "Ext80";
    metric_set->hw_config_guid = "171d99e0-0ace-4af7-8702-19e9fbb04a46";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext80_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext80__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext80__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT BYTE READ XECORE2",
                .symbol_name = "DATAPORT_BYTE_READ_XECORE2",
                .desc = "Number of bytes read through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext80__dataport_byte_read_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext80_DATAPORT_BYTE_READ_XECORE2_availability,
            },

            {
                .name = "DATAPORT BYTE READ XECORE3",
                .symbol_name = "DATAPORT_BYTE_READ_XECORE3",
                .desc = "Number of bytes read through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext80__dataport_byte_read_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext80_DATAPORT_BYTE_READ_XECORE3_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext80__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext80__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext81_DATAPORT_BYTE_READ_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext81_DATAPORT_BYTE_READ_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext81_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext81";
    metric_set->symbol_name = "Ext81";
    metric_set->hw_config_guid = "f399ee12-9656-47fe-8566-416a8e4e4c07";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext81_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext81__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext81__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT BYTE READ XECORE4",
                .symbol_name = "DATAPORT_BYTE_READ_XECORE4",
                .desc = "Number of bytes read through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext81__dataport_byte_read_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext81_DATAPORT_BYTE_READ_XECORE4_availability,
            },

            {
                .name = "DATAPORT BYTE READ XECORE5",
                .symbol_name = "DATAPORT_BYTE_READ_XECORE5",
                .desc = "Number of bytes read through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext81__dataport_byte_read_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext81_DATAPORT_BYTE_READ_XECORE5_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext81__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext81__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext82_DATAPORT_BYTE_READ_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext82_DATAPORT_BYTE_READ_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext82_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext82";
    metric_set->symbol_name = "Ext82";
    metric_set->hw_config_guid = "766bbe37-ffda-41f0-92da-e31184140e43";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext82_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext82__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext82__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT BYTE READ XECORE6",
                .symbol_name = "DATAPORT_BYTE_READ_XECORE6",
                .desc = "Number of bytes read through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext82__dataport_byte_read_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext82_DATAPORT_BYTE_READ_XECORE6_availability,
            },

            {
                .name = "DATAPORT BYTE READ XECORE7",
                .symbol_name = "DATAPORT_BYTE_READ_XECORE7",
                .desc = "Number of bytes read through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext82__dataport_byte_read_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext82_DATAPORT_BYTE_READ_XECORE7_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext82__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext82__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext83_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext83";
    metric_set->symbol_name = "Ext83";
    metric_set->hw_config_guid = "4d5d9009-c75e-4655-8374-503fd68ac0c7";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext83_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext83__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext83__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT BYTE WRITE XECORE0",
                .symbol_name = "DATAPORT_BYTE_WRITE_XECORE0",
                .desc = "Number of bytes written through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext83__dataport_byte_write_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE0_availability,
            },

            {
                .name = "DATAPORT BYTE WRITE XECORE1",
                .symbol_name = "DATAPORT_BYTE_WRITE_XECORE1",
                .desc = "Number of bytes written through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext83__dataport_byte_write_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE1_availability,
            },

            {
                .name = "DATAPORT BYTE WRITE XECORE2",
                .symbol_name = "DATAPORT_BYTE_WRITE_XECORE2",
                .desc = "Number of bytes written through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext83__dataport_byte_write_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE2_availability,
            },

            {
                .name = "DATAPORT BYTE WRITE XECORE3",
                .symbol_name = "DATAPORT_BYTE_WRITE_XECORE3",
                .desc = "Number of bytes written through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext83__dataport_byte_write_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE3_availability,
            },

            {
                .name = "DATAPORT BYTE WRITE XECORE4",
                .symbol_name = "DATAPORT_BYTE_WRITE_XECORE4",
                .desc = "Number of bytes written through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext83__dataport_byte_write_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE4_availability,
            },

            {
                .name = "DATAPORT BYTE WRITE XECORE5",
                .symbol_name = "DATAPORT_BYTE_WRITE_XECORE5",
                .desc = "Number of bytes written through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext83__dataport_byte_write_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE5_availability,
            },

            {
                .name = "DATAPORT BYTE WRITE XECORE6",
                .symbol_name = "DATAPORT_BYTE_WRITE_XECORE6",
                .desc = "Number of bytes written through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext83__dataport_byte_write_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE6_availability,
            },

            {
                .name = "DATAPORT BYTE WRITE XECORE7",
                .symbol_name = "DATAPORT_BYTE_WRITE_XECORE7",
                .desc = "Number of bytes written through the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES,
                .read_uint64 = acmgt1__ext83__dataport_byte_write_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_BYTE_WRITE_XECORE7_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE ACCESS XECORE0",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE0",
                .desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext83__dataport_texture_cache_access_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE0_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE ACCESS XECORE1",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE1",
                .desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext83__dataport_texture_cache_access_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE1_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE ACCESS XECORE2",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE2",
                .desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext83__dataport_texture_cache_access_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE2_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE ACCESS XECORE3",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE3",
                .desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext83__dataport_texture_cache_access_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE3_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE ACCESS XECORE4",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE4",
                .desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext83__dataport_texture_cache_access_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE4_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE ACCESS XECORE5",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE5",
                .desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext83__dataport_texture_cache_access_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE5_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE ACCESS XECORE6",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE6",
                .desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext83__dataport_texture_cache_access_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE6_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE ACCESS XECORE7",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE7",
                .desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext83__dataport_texture_cache_access_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext83_DATAPORT_TEXTURE_CACHE_ACCESS_XECORE7_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext83__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext83__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 19);
}

static bool acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext84_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext84";
    metric_set->symbol_name = "Ext84";
    metric_set->hw_config_guid = "fd091d19-b48d-49d2-b99e-c5505624daa3";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext84_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext84__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext84__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "DATAPORT TEXTURE CACHE HIT XECORE0",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE0",
                .desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext84__dataport_texture_cache_hit_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE0_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE HIT XECORE1",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE1",
                .desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext84__dataport_texture_cache_hit_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE1_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE HIT XECORE2",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE2",
                .desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext84__dataport_texture_cache_hit_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE2_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE HIT XECORE3",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE3",
                .desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext84__dataport_texture_cache_hit_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE3_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE HIT XECORE4",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE4",
                .desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext84__dataport_texture_cache_hit_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE4_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE HIT XECORE5",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE5",
                .desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext84__dataport_texture_cache_hit_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE5_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE HIT XECORE6",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE6",
                .desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext84__dataport_texture_cache_hit_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE6_availability,
            },

            {
                .name = "DATAPORT TEXTURE CACHE HIT XECORE7",
                .symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE7",
                .desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext84__dataport_texture_cache_hit_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext84_DATAPORT_TEXTURE_CACHE_HIT_XECORE7_availability,
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext84__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext84__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 11);
}

static bool acmgt1_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext85_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext85";
    metric_set->symbol_name = "Ext85";
    metric_set->hw_config_guid = "d45a3f38-372d-4757-88cf-5589035652d5";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext85_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext85__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext85__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext85__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext85__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE DATAPORT READ MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE0",
                .desc = "Number of read messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext85__xve_dataport_read_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE DATAPORT READ MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE1",
                .desc = "Number of read messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext85__xve_dataport_read_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE DATAPORT READ MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE2",
                .desc = "Number of read messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext85__xve_dataport_read_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE DATAPORT READ MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE3",
                .desc = "Number of read messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext85__xve_dataport_read_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext85_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext86_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext86_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext86_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext86_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext86_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext86";
    metric_set->symbol_name = "Ext86";
    metric_set->hw_config_guid = "46f2e8eb-1a50-499e-9096-66f79932703e";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext86_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext86__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext86__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext86__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext86__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE DATAPORT READ MESSAGE COUNT XECORE4",
                .symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE4",
                .desc = "Number of read messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext86__xve_dataport_read_message_count_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext86_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE4_availability,
            },

            {
                .name = "XVE DATAPORT READ MESSAGE COUNT XECORE5",
                .symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE5",
                .desc = "Number of read messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext86__xve_dataport_read_message_count_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext86_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE5_availability,
            },

            {
                .name = "XVE DATAPORT READ MESSAGE COUNT XECORE6",
                .symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE6",
                .desc = "Number of read messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext86__xve_dataport_read_message_count_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext86_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE6_availability,
            },

            {
                .name = "XVE DATAPORT READ MESSAGE COUNT XECORE7",
                .symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE7",
                .desc = "Number of read messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext86__xve_dataport_read_message_count_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext86_XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext87_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext87";
    metric_set->symbol_name = "Ext87";
    metric_set->hw_config_guid = "35a680fa-e0c7-4e60-9a42-4e5c67d90b4d";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext87_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext87__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext87__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext87__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext87__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE0",
                .desc = "Number of write messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext87__xve_dataport_write_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE1",
                .desc = "Number of write messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext87__xve_dataport_write_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE2",
                .desc = "Number of write messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext87__xve_dataport_write_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE3",
                .desc = "Number of write messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext87__xve_dataport_write_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext87_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext88_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext88_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext88_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext88_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext88_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext88";
    metric_set->symbol_name = "Ext88";
    metric_set->hw_config_guid = "e1d0a1c4-41c7-4d82-a6f0-42ea537e5664";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext88_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext88__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext88__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext88__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext88__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE4",
                .symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE4",
                .desc = "Number of write messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext88__xve_dataport_write_message_count_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext88_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE4_availability,
            },

            {
                .name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE5",
                .symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE5",
                .desc = "Number of write messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext88__xve_dataport_write_message_count_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext88_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE5_availability,
            },

            {
                .name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE6",
                .symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE6",
                .desc = "Number of write messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext88__xve_dataport_write_message_count_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext88_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE6_availability,
            },

            {
                .name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE7",
                .symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE7",
                .desc = "Number of write messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext88__xve_dataport_write_message_count_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext88_XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext91_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext91";
    metric_set->symbol_name = "Ext91";
    metric_set->hw_config_guid = "c26ba023-58d3-4ec7-9282-f2638a292912";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext91_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext91__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext91__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext91__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext91__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE0",
                .symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE0",
                .desc = "Number of atomic messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext91__xve_dataport_atomic_message_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE1",
                .symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE1",
                .desc = "Number of atomic messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext91__xve_dataport_atomic_message_count_xecore1__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE1_availability,
            },

            {
                .name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE2",
                .symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE2",
                .desc = "Number of atomic messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext91__xve_dataport_atomic_message_count_xecore2__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE2_availability,
            },

            {
                .name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE3",
                .symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE3",
                .desc = "Number of atomic messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext91__xve_dataport_atomic_message_count_xecore3__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext91_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE3_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext92_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE4_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext92_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE5_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext92_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE6_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext92_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE7_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext92_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext92";
    metric_set->symbol_name = "Ext92";
    metric_set->hw_config_guid = "7e5a8ef5-b434-4bf1-81f0-eeddaa072d37";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext92_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext92__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext92__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext92__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext92__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE4",
                .symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE4",
                .desc = "Number of atomic messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext92__xve_dataport_atomic_message_count_xecore4__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext92_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE4_availability,
            },

            {
                .name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE5",
                .symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE5",
                .desc = "Number of atomic messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext92__xve_dataport_atomic_message_count_xecore5__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext92_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE5_availability,
            },

            {
                .name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE6",
                .symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE6",
                .desc = "Number of atomic messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext92__xve_dataport_atomic_message_count_xecore6__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext92_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE6_availability,
            },

            {
                .name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE7",
                .symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE7",
                .desc = "Number of atomic messages sent by XVEs to the Dataport",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext92__xve_dataport_atomic_message_count_xecore7__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext92_XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE7_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 7);
}

static bool acmgt1_ext93_XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE0_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext93_XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE1_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext93_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext93";
    metric_set->symbol_name = "Ext93";
    metric_set->hw_config_guid = "917a8688-0aa2-4b9a-a1a1-60dc016b17e6";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext93_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ,
                .read_uint64 = acmgt1__ext93__avg_gpu_core_frequency__read,
                .max_uint64 = acmgt1__ext93__avg_gpu_core_frequency__max,
                .group = "GPU",
            },

            {
                .name = "GPU Core Clocks",
                .symbol_name = "GpuCoreClocks",
                .desc = "The total number of GPU core clocks elapsed during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES,
                .read_uint64 = acmgt1__ext93__gpu_core_clocks__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "GPU Time Elapsed",
                .symbol_name = "GpuTime",
                .desc = "Time elapsed on the GPU during the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS,
                .read_uint64 = acmgt1__ext93__gpu_time__read,
                .max_uint64 = NULL /* undefined */,
                .group = "GPU",
            },

            {
                .name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE0",
                .symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE0",
                .desc = "Number of return message payload transactions sent from the Dataport to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_uint64 = acmgt1__ext93__xve_dataport_register_response_count_xecore0__read,
                .max_uint64 = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext93_XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE0_availability,
            },

            {
                .name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE1",
                .symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE1",
                .desc = "Number of return message payload transactions sent from the Dataport to XVEs",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT,
                .unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS,
                .read_float = acmgt1__ext93__xve_dataport_register_response_count_xecore1__read,
                .max_float = NULL /* undefined */,
                .group = "Dataport",
                .availability = acmgt1_ext93_XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE1_availability,
            },
        };
        int i;
        for (i = 0; i < sizeof(_counters) / sizeof(_counters[0]); i++) {
            if (_counters[i].availability && !_counters[i].availability(perf))
                continue;
            counter = &metric_set->counters[metric_set->n_counters++];
            *counter = _counters[i];
            counter->metric_set = metric_set;
            intel_perf_add_logical_counter(perf, counter, counter->group);
        }
    }

    assert(metric_set->n_counters <= 5);
}

static bool acmgt1_ext94_XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE2_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        return true;
    }
    return false;
}
static bool acmgt1_ext94_XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE3_availability(const struct intel_perf *perf) {
    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        return true;
    }
    return false;
}

static void
acmgt1_add_ext94_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext94";
    metric_set->symbol_name = "Ext94";
    metric_set->hw_config_guid = "dad96cfd-65c0-470c-a9d2-33d7881234c0";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;
    acmgt1_ext94_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);

    {
        static const struct intel_perf_logical_counter _counters[] = {

            {
                .name = "AVG GPU Core Frequency",
                .symbol_name = "AvgGpuCoreFrequency",
                .desc = "Average GPU Core Frequency in the measurement.",
                .type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT,
                .storage = INTE