{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GtkWindow@ subclass that integrates with @GtkApplication@.
-- 
-- Notably, @GtkApplicationWindow@ can handle an application menubar.
-- 
-- This class implements the t'GI.Gio.Interfaces.ActionGroup.ActionGroup' and t'GI.Gio.Interfaces.ActionMap.ActionMap'
-- interfaces, to let you add window-specific actions that will be exported
-- by the associated t'GI.Gtk.Objects.Application.Application', together with its application-wide
-- actions. Window-specific actions are prefixed with the “win.”
-- prefix and application-wide actions are prefixed with the “app.”
-- prefix. Actions must be addressed with the prefixed name when
-- referring to them from a menu model.
-- 
-- Note that widgets that are placed inside a @GtkApplicationWindow@
-- can also activate these actions, if they implement the
-- t'GI.Gtk.Interfaces.Actionable.Actionable' interface.
-- 
-- The settings [Settings:gtkShellShowsAppMenu]("GI.Gtk.Objects.Settings#g:attr:gtkShellShowsAppMenu") and
-- [Settings:gtkShellShowsMenubar]("GI.Gtk.Objects.Settings#g:attr:gtkShellShowsMenubar") tell GTK whether the
-- desktop environment is showing the application menu and menubar
-- models outside the application as part of the desktop shell.
-- For instance, on OS X, both menus will be displayed remotely;
-- on Windows neither will be.
-- 
-- If the desktop environment does not display the menubar, it can be shown in
-- the @GtkApplicationWindow@ by setting the
-- [ApplicationWindow:showMenubar]("GI.Gtk.Objects.ApplicationWindow#g:attr:showMenubar") property to true. If the
-- desktop environment does not display the application menu, then it will
-- automatically be included in the menubar or in the window’s client-side
-- decorations.
-- 
-- See t'GI.Gtk.Objects.PopoverMenu.PopoverMenu' for information about the XML language
-- used by @GtkBuilder@ for menu models.
-- 
-- See also: 'GI.Gtk.Objects.Application.applicationSetMenubar'.
-- 
-- == A GtkApplicationWindow with a menubar
-- 
-- The code sample below shows how to set up a @GtkApplicationWindow@
-- with a menu bar defined on the t'GI.Gtk.Objects.Application.Application':
-- 
-- 
-- === /c code/
-- >GtkApplication *app = gtk_application_new ("org.gtk.test", 0);
-- >
-- >GtkBuilder *builder = gtk_builder_new_from_string (
-- >    "<interface>"
-- >    "  <menu id='menubar'>"
-- >    "    <submenu>"
-- >    "      <attribute name='label' translatable='yes'>_Edit</attribute>"
-- >    "      <item>"
-- >    "        <attribute name='label' translatable='yes'>_Copy</attribute>"
-- >    "        <attribute name='action'>win.copy</attribute>"
-- >    "      </item>"
-- >    "      <item>"
-- >    "        <attribute name='label' translatable='yes'>_Paste</attribute>"
-- >    "        <attribute name='action'>win.paste</attribute>"
-- >    "      </item>"
-- >    "    </submenu>"
-- >    "  </menu>"
-- >    "</interface>",
-- >    -1);
-- >
-- >GMenuModel *menubar = G_MENU_MODEL (gtk_builder_get_object (builder, "menubar"));
-- >gtk_application_set_menubar (GTK_APPLICATION (app), menubar);
-- >g_object_unref (builder);
-- >
-- >// ...
-- >
-- >GtkWidget *window = gtk_application_window_new (app);
-- 

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ApplicationWindow
    ( 

-- * Exported types
    ApplicationWindow(..)                   ,
    IsApplicationWindow                     ,
    toApplicationWindow                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionAdded]("GI.Gio.Interfaces.ActionGroup#g:method:actionAdded"), [actionEnabledChanged]("GI.Gio.Interfaces.ActionGroup#g:method:actionEnabledChanged"), [actionRemoved]("GI.Gio.Interfaces.ActionGroup#g:method:actionRemoved"), [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [actionStateChanged]("GI.Gio.Interfaces.ActionGroup#g:method:actionStateChanged"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addAction]("GI.Gio.Interfaces.ActionMap#g:method:addAction"), [addActionEntries]("GI.Gio.Interfaces.ActionMap#g:method:addActionEntries"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changeActionState]("GI.Gio.Interfaces.ActionGroup#g:method:changeActionState"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [close]("GI.Gtk.Objects.Window#g:method:close"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [destroy]("GI.Gtk.Objects.Window#g:method:destroy"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [fullscreen]("GI.Gtk.Objects.Window#g:method:fullscreen"), [fullscreenOnMonitor]("GI.Gtk.Objects.Window#g:method:fullscreenOnMonitor"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasAction]("GI.Gio.Interfaces.ActionGroup#g:method:hasAction"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasGroup]("GI.Gtk.Objects.Window#g:method:hasGroup"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isActive]("GI.Gtk.Objects.Window#g:method:isActive"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isFullscreen]("GI.Gtk.Objects.Window#g:method:isFullscreen"), [isMaximized]("GI.Gtk.Objects.Window#g:method:isMaximized"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isSuspended]("GI.Gtk.Objects.Window#g:method:isSuspended"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listActions]("GI.Gio.Interfaces.ActionGroup#g:method:listActions"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [lookupAction]("GI.Gio.Interfaces.ActionMap#g:method:lookupAction"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [maximize]("GI.Gtk.Objects.Window#g:method:maximize"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [minimize]("GI.Gtk.Objects.Window#g:method:minimize"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [present]("GI.Gtk.Objects.Window#g:method:present"), [presentWithTime]("GI.Gtk.Objects.Window#g:method:presentWithTime"), [queryAction]("GI.Gio.Interfaces.ActionGroup#g:method:queryAction"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeAction]("GI.Gio.Interfaces.ActionMap#g:method:removeAction"), [removeActionEntries]("GI.Gio.Interfaces.ActionMap#g:method:removeActionEntries"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unfullscreen]("GI.Gtk.Objects.Window#g:method:unfullscreen"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unmaximize]("GI.Gtk.Objects.Window#g:method:unmaximize"), [unminimize]("GI.Gtk.Objects.Window#g:method:unminimize"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getActionEnabled]("GI.Gio.Interfaces.ActionGroup#g:method:getActionEnabled"), [getActionParameterType]("GI.Gio.Interfaces.ActionGroup#g:method:getActionParameterType"), [getActionState]("GI.Gio.Interfaces.ActionGroup#g:method:getActionState"), [getActionStateHint]("GI.Gio.Interfaces.ActionGroup#g:method:getActionStateHint"), [getActionStateType]("GI.Gio.Interfaces.ActionGroup#g:method:getActionStateType"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getApplication]("GI.Gtk.Objects.Window#g:method:getApplication"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.Window#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDecorated]("GI.Gtk.Objects.Window#g:method:getDecorated"), [getDefaultSize]("GI.Gtk.Objects.Window#g:method:getDefaultSize"), [getDefaultWidget]("GI.Gtk.Objects.Window#g:method:getDefaultWidget"), [getDeletable]("GI.Gtk.Objects.Window#g:method:getDeletable"), [getDestroyWithParent]("GI.Gtk.Objects.Window#g:method:getDestroyWithParent"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocus]("GI.Gtk.Objects.Window#g:method:getFocus"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusVisible]("GI.Gtk.Objects.Window#g:method:getFocusVisible"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getGravity]("GI.Gtk.Objects.Window#g:method:getGravity"), [getGroup]("GI.Gtk.Objects.Window#g:method:getGroup"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHandleMenubarAccel]("GI.Gtk.Objects.Window#g:method:getHandleMenubarAccel"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHelpOverlay]("GI.Gtk.Objects.ApplicationWindow#g:method:getHelpOverlay"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHideOnClose]("GI.Gtk.Objects.Window#g:method:getHideOnClose"), [getIconName]("GI.Gtk.Objects.Window#g:method:getIconName"), [getId]("GI.Gtk.Objects.ApplicationWindow#g:method:getId"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMnemonicsVisible]("GI.Gtk.Objects.Window#g:method:getMnemonicsVisible"), [getModal]("GI.Gtk.Objects.Window#g:method:getModal"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRenderer]("GI.Gtk.Interfaces.Native#g:method:getRenderer"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getResizable]("GI.Gtk.Objects.Window#g:method:getResizable"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowMenubar]("GI.Gtk.Objects.ApplicationWindow#g:method:getShowMenubar"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getSurface]("GI.Gtk.Interfaces.Native#g:method:getSurface"), [getSurfaceTransform]("GI.Gtk.Interfaces.Native#g:method:getSurfaceTransform"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTitle]("GI.Gtk.Objects.Window#g:method:getTitle"), [getTitlebar]("GI.Gtk.Objects.Window#g:method:getTitlebar"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getTransientFor]("GI.Gtk.Objects.Window#g:method:getTransientFor"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setApplication]("GI.Gtk.Objects.Window#g:method:setApplication"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.Window#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDecorated]("GI.Gtk.Objects.Window#g:method:setDecorated"), [setDefaultSize]("GI.Gtk.Objects.Window#g:method:setDefaultSize"), [setDefaultWidget]("GI.Gtk.Objects.Window#g:method:setDefaultWidget"), [setDeletable]("GI.Gtk.Objects.Window#g:method:setDeletable"), [setDestroyWithParent]("GI.Gtk.Objects.Window#g:method:setDestroyWithParent"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setDisplay]("GI.Gtk.Objects.Window#g:method:setDisplay"), [setFocus]("GI.Gtk.Objects.Window#g:method:setFocus"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusVisible]("GI.Gtk.Objects.Window#g:method:setFocusVisible"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setGravity]("GI.Gtk.Objects.Window#g:method:setGravity"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHandleMenubarAccel]("GI.Gtk.Objects.Window#g:method:setHandleMenubarAccel"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHelpOverlay]("GI.Gtk.Objects.ApplicationWindow#g:method:setHelpOverlay"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHideOnClose]("GI.Gtk.Objects.Window#g:method:setHideOnClose"), [setIconName]("GI.Gtk.Objects.Window#g:method:setIconName"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMnemonicsVisible]("GI.Gtk.Objects.Window#g:method:setMnemonicsVisible"), [setModal]("GI.Gtk.Objects.Window#g:method:setModal"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setResizable]("GI.Gtk.Objects.Window#g:method:setResizable"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowMenubar]("GI.Gtk.Objects.ApplicationWindow#g:method:setShowMenubar"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStartupId]("GI.Gtk.Objects.Window#g:method:setStartupId"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTitle]("GI.Gtk.Objects.Window#g:method:setTitle"), [setTitlebar]("GI.Gtk.Objects.Window#g:method:setTitlebar"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setTransientFor]("GI.Gtk.Objects.Window#g:method:setTransientFor"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveApplicationWindowMethod          ,
#endif

-- ** getHelpOverlay #method:getHelpOverlay#

#if defined(ENABLE_OVERLOADING)
    ApplicationWindowGetHelpOverlayMethodInfo,
#endif
    applicationWindowGetHelpOverlay         ,


-- ** getId #method:getId#

#if defined(ENABLE_OVERLOADING)
    ApplicationWindowGetIdMethodInfo        ,
#endif
    applicationWindowGetId                  ,


-- ** getShowMenubar #method:getShowMenubar#

#if defined(ENABLE_OVERLOADING)
    ApplicationWindowGetShowMenubarMethodInfo,
#endif
    applicationWindowGetShowMenubar         ,


-- ** new #method:new#

    applicationWindowNew                    ,


-- ** setHelpOverlay #method:setHelpOverlay#

#if defined(ENABLE_OVERLOADING)
    ApplicationWindowSetHelpOverlayMethodInfo,
#endif
    applicationWindowSetHelpOverlay         ,


-- ** setShowMenubar #method:setShowMenubar#

#if defined(ENABLE_OVERLOADING)
    ApplicationWindowSetShowMenubarMethodInfo,
#endif
    applicationWindowSetShowMenubar         ,




 -- * Properties


-- ** showMenubar #attr:showMenubar#
-- | If this property is true, the window will display a menubar
-- unless it is shown by the desktop shell.
-- 
-- See 'GI.Gtk.Objects.Application.applicationSetMenubar'.
-- 
-- If false, the window will not display a menubar, regardless
-- of whether the desktop shell is showing it or not.

#if defined(ENABLE_OVERLOADING)
    ApplicationWindowShowMenubarPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    applicationWindowShowMenubar            ,
#endif
    constructApplicationWindowShowMenubar   ,
    getApplicationWindowShowMenubar         ,
    setApplicationWindowShowMenubar         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.Box as Gtk.Box
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutsGroup as Gtk.ShortcutsGroup
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutsSection as Gtk.ShortcutsSection
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutsShortcut as Gtk.ShortcutsShortcut
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutsWindow as Gtk.ShortcutsWindow
import {-# SOURCE #-} qualified GI.Gtk.Objects.SizeGroup as Gtk.SizeGroup
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutsWindow as Gtk.ShortcutsWindow
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window

#endif

-- | Memory-managed wrapper type.
newtype ApplicationWindow = ApplicationWindow (SP.ManagedPtr ApplicationWindow)
    deriving (Eq)

instance SP.ManagedPtrNewtype ApplicationWindow where
    toManagedPtr (ApplicationWindow p) = p

foreign import ccall "gtk_application_window_get_type"
    c_gtk_application_window_get_type :: IO B.Types.GType

instance B.Types.TypedObject ApplicationWindow where
    glibType = c_gtk_application_window_get_type

instance B.Types.GObject ApplicationWindow

-- | Type class for types which can be safely cast to t'ApplicationWindow', for instance with `toApplicationWindow`.
class (SP.GObject o, O.IsDescendantOf ApplicationWindow o) => IsApplicationWindow o
instance (SP.GObject o, O.IsDescendantOf ApplicationWindow o) => IsApplicationWindow o

instance O.HasParentTypes ApplicationWindow
type instance O.ParentTypes ApplicationWindow = '[Gtk.Window.Window, Gtk.Widget.Widget, GObject.Object.Object, Gio.ActionGroup.ActionGroup, Gio.ActionMap.ActionMap, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Native.Native, Gtk.Root.Root, Gtk.ShortcutManager.ShortcutManager]

-- | Cast to t'ApplicationWindow', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toApplicationWindow :: (MIO.MonadIO m, IsApplicationWindow o) => o -> m ApplicationWindow
toApplicationWindow = MIO.liftIO . B.ManagedPtr.unsafeCastTo ApplicationWindow

-- | Convert t'ApplicationWindow' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ApplicationWindow) where
    gvalueGType_ = c_gtk_application_window_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ApplicationWindow)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ApplicationWindow)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ApplicationWindow ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveApplicationWindowMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveApplicationWindowMethod "actionAdded" o = Gio.ActionGroup.ActionGroupActionAddedMethodInfo
    ResolveApplicationWindowMethod "actionEnabledChanged" o = Gio.ActionGroup.ActionGroupActionEnabledChangedMethodInfo
    ResolveApplicationWindowMethod "actionRemoved" o = Gio.ActionGroup.ActionGroupActionRemovedMethodInfo
    ResolveApplicationWindowMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveApplicationWindowMethod "actionStateChanged" o = Gio.ActionGroup.ActionGroupActionStateChangedMethodInfo
    ResolveApplicationWindowMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveApplicationWindowMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveApplicationWindowMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveApplicationWindowMethod "addAction" o = Gio.ActionMap.ActionMapAddActionMethodInfo
    ResolveApplicationWindowMethod "addActionEntries" o = Gio.ActionMap.ActionMapAddActionEntriesMethodInfo
    ResolveApplicationWindowMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveApplicationWindowMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveApplicationWindowMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveApplicationWindowMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveApplicationWindowMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveApplicationWindowMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveApplicationWindowMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveApplicationWindowMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveApplicationWindowMethod "changeActionState" o = Gio.ActionGroup.ActionGroupChangeActionStateMethodInfo
    ResolveApplicationWindowMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveApplicationWindowMethod "close" o = Gtk.Window.WindowCloseMethodInfo
    ResolveApplicationWindowMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveApplicationWindowMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveApplicationWindowMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveApplicationWindowMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveApplicationWindowMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveApplicationWindowMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveApplicationWindowMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveApplicationWindowMethod "destroy" o = Gtk.Window.WindowDestroyMethodInfo
    ResolveApplicationWindowMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveApplicationWindowMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveApplicationWindowMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveApplicationWindowMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveApplicationWindowMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveApplicationWindowMethod "fullscreen" o = Gtk.Window.WindowFullscreenMethodInfo
    ResolveApplicationWindowMethod "fullscreenOnMonitor" o = Gtk.Window.WindowFullscreenOnMonitorMethodInfo
    ResolveApplicationWindowMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveApplicationWindowMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveApplicationWindowMethod "hasAction" o = Gio.ActionGroup.ActionGroupHasActionMethodInfo
    ResolveApplicationWindowMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveApplicationWindowMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveApplicationWindowMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveApplicationWindowMethod "hasGroup" o = Gtk.Window.WindowHasGroupMethodInfo
    ResolveApplicationWindowMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveApplicationWindowMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveApplicationWindowMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveApplicationWindowMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveApplicationWindowMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveApplicationWindowMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveApplicationWindowMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveApplicationWindowMethod "isActive" o = Gtk.Window.WindowIsActiveMethodInfo
    ResolveApplicationWindowMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveApplicationWindowMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveApplicationWindowMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveApplicationWindowMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveApplicationWindowMethod "isFullscreen" o = Gtk.Window.WindowIsFullscreenMethodInfo
    ResolveApplicationWindowMethod "isMaximized" o = Gtk.Window.WindowIsMaximizedMethodInfo
    ResolveApplicationWindowMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveApplicationWindowMethod "isSuspended" o = Gtk.Window.WindowIsSuspendedMethodInfo
    ResolveApplicationWindowMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveApplicationWindowMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveApplicationWindowMethod "listActions" o = Gio.ActionGroup.ActionGroupListActionsMethodInfo
    ResolveApplicationWindowMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveApplicationWindowMethod "lookupAction" o = Gio.ActionMap.ActionMapLookupActionMethodInfo
    ResolveApplicationWindowMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveApplicationWindowMethod "maximize" o = Gtk.Window.WindowMaximizeMethodInfo
    ResolveApplicationWindowMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveApplicationWindowMethod "minimize" o = Gtk.Window.WindowMinimizeMethodInfo
    ResolveApplicationWindowMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveApplicationWindowMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveApplicationWindowMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveApplicationWindowMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveApplicationWindowMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveApplicationWindowMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveApplicationWindowMethod "present" o = Gtk.Window.WindowPresentMethodInfo
    ResolveApplicationWindowMethod "presentWithTime" o = Gtk.Window.WindowPresentWithTimeMethodInfo
    ResolveApplicationWindowMethod "queryAction" o = Gio.ActionGroup.ActionGroupQueryActionMethodInfo
    ResolveApplicationWindowMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveApplicationWindowMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveApplicationWindowMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveApplicationWindowMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveApplicationWindowMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveApplicationWindowMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveApplicationWindowMethod "removeAction" o = Gio.ActionMap.ActionMapRemoveActionMethodInfo
    ResolveApplicationWindowMethod "removeActionEntries" o = Gio.ActionMap.ActionMapRemoveActionEntriesMethodInfo
    ResolveApplicationWindowMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveApplicationWindowMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveApplicationWindowMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveApplicationWindowMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveApplicationWindowMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveApplicationWindowMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveApplicationWindowMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveApplicationWindowMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveApplicationWindowMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveApplicationWindowMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveApplicationWindowMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveApplicationWindowMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveApplicationWindowMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveApplicationWindowMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveApplicationWindowMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveApplicationWindowMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveApplicationWindowMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveApplicationWindowMethod "unfullscreen" o = Gtk.Window.WindowUnfullscreenMethodInfo
    ResolveApplicationWindowMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveApplicationWindowMethod "unmaximize" o = Gtk.Window.WindowUnmaximizeMethodInfo
    ResolveApplicationWindowMethod "unminimize" o = Gtk.Window.WindowUnminimizeMethodInfo
    ResolveApplicationWindowMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveApplicationWindowMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveApplicationWindowMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveApplicationWindowMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveApplicationWindowMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveApplicationWindowMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveApplicationWindowMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveApplicationWindowMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveApplicationWindowMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveApplicationWindowMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveApplicationWindowMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveApplicationWindowMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveApplicationWindowMethod "getActionEnabled" o = Gio.ActionGroup.ActionGroupGetActionEnabledMethodInfo
    ResolveApplicationWindowMethod "getActionParameterType" o = Gio.ActionGroup.ActionGroupGetActionParameterTypeMethodInfo
    ResolveApplicationWindowMethod "getActionState" o = Gio.ActionGroup.ActionGroupGetActionStateMethodInfo
    ResolveApplicationWindowMethod "getActionStateHint" o = Gio.ActionGroup.ActionGroupGetActionStateHintMethodInfo
    ResolveApplicationWindowMethod "getActionStateType" o = Gio.ActionGroup.ActionGroupGetActionStateTypeMethodInfo
    ResolveApplicationWindowMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveApplicationWindowMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveApplicationWindowMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveApplicationWindowMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveApplicationWindowMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveApplicationWindowMethod "getApplication" o = Gtk.Window.WindowGetApplicationMethodInfo
    ResolveApplicationWindowMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveApplicationWindowMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveApplicationWindowMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveApplicationWindowMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveApplicationWindowMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveApplicationWindowMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveApplicationWindowMethod "getChild" o = Gtk.Window.WindowGetChildMethodInfo
    ResolveApplicationWindowMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveApplicationWindowMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveApplicationWindowMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveApplicationWindowMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveApplicationWindowMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveApplicationWindowMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveApplicationWindowMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveApplicationWindowMethod "getDecorated" o = Gtk.Window.WindowGetDecoratedMethodInfo
    ResolveApplicationWindowMethod "getDefaultSize" o = Gtk.Window.WindowGetDefaultSizeMethodInfo
    ResolveApplicationWindowMethod "getDefaultWidget" o = Gtk.Window.WindowGetDefaultWidgetMethodInfo
    ResolveApplicationWindowMethod "getDeletable" o = Gtk.Window.WindowGetDeletableMethodInfo
    ResolveApplicationWindowMethod "getDestroyWithParent" o = Gtk.Window.WindowGetDestroyWithParentMethodInfo
    ResolveApplicationWindowMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveApplicationWindowMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveApplicationWindowMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveApplicationWindowMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveApplicationWindowMethod "getFocus" o = Gtk.Window.WindowGetFocusMethodInfo
    ResolveApplicationWindowMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveApplicationWindowMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveApplicationWindowMethod "getFocusVisible" o = Gtk.Window.WindowGetFocusVisibleMethodInfo
    ResolveApplicationWindowMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveApplicationWindowMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveApplicationWindowMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveApplicationWindowMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveApplicationWindowMethod "getGravity" o = Gtk.Window.WindowGetGravityMethodInfo
    ResolveApplicationWindowMethod "getGroup" o = Gtk.Window.WindowGetGroupMethodInfo
    ResolveApplicationWindowMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveApplicationWindowMethod "getHandleMenubarAccel" o = Gtk.Window.WindowGetHandleMenubarAccelMethodInfo
    ResolveApplicationWindowMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveApplicationWindowMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveApplicationWindowMethod "getHelpOverlay" o = ApplicationWindowGetHelpOverlayMethodInfo
    ResolveApplicationWindowMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveApplicationWindowMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveApplicationWindowMethod "getHideOnClose" o = Gtk.Window.WindowGetHideOnCloseMethodInfo
    ResolveApplicationWindowMethod "getIconName" o = Gtk.Window.WindowGetIconNameMethodInfo
    ResolveApplicationWindowMethod "getId" o = ApplicationWindowGetIdMethodInfo
    ResolveApplicationWindowMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveApplicationWindowMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveApplicationWindowMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveApplicationWindowMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveApplicationWindowMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveApplicationWindowMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveApplicationWindowMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveApplicationWindowMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveApplicationWindowMethod "getMnemonicsVisible" o = Gtk.Window.WindowGetMnemonicsVisibleMethodInfo
    ResolveApplicationWindowMethod "getModal" o = Gtk.Window.WindowGetModalMethodInfo
    ResolveApplicationWindowMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveApplicationWindowMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveApplicationWindowMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveApplicationWindowMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveApplicationWindowMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveApplicationWindowMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveApplicationWindowMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveApplicationWindowMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveApplicationWindowMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveApplicationWindowMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveApplicationWindowMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveApplicationWindowMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveApplicationWindowMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveApplicationWindowMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveApplicationWindowMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveApplicationWindowMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveApplicationWindowMethod "getRenderer" o = Gtk.Native.NativeGetRendererMethodInfo
    ResolveApplicationWindowMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveApplicationWindowMethod "getResizable" o = Gtk.Window.WindowGetResizableMethodInfo
    ResolveApplicationWindowMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveApplicationWindowMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveApplicationWindowMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveApplicationWindowMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveApplicationWindowMethod "getShowMenubar" o = ApplicationWindowGetShowMenubarMethodInfo
    ResolveApplicationWindowMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveApplicationWindowMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveApplicationWindowMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveApplicationWindowMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveApplicationWindowMethod "getSurface" o = Gtk.Native.NativeGetSurfaceMethodInfo
    ResolveApplicationWindowMethod "getSurfaceTransform" o = Gtk.Native.NativeGetSurfaceTransformMethodInfo
    ResolveApplicationWindowMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveApplicationWindowMethod "getTitle" o = Gtk.Window.WindowGetTitleMethodInfo
    ResolveApplicationWindowMethod "getTitlebar" o = Gtk.Window.WindowGetTitlebarMethodInfo
    ResolveApplicationWindowMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveApplicationWindowMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveApplicationWindowMethod "getTransientFor" o = Gtk.Window.WindowGetTransientForMethodInfo
    ResolveApplicationWindowMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveApplicationWindowMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveApplicationWindowMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveApplicationWindowMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveApplicationWindowMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveApplicationWindowMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveApplicationWindowMethod "setApplication" o = Gtk.Window.WindowSetApplicationMethodInfo
    ResolveApplicationWindowMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveApplicationWindowMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveApplicationWindowMethod "setChild" o = Gtk.Window.WindowSetChildMethodInfo
    ResolveApplicationWindowMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveApplicationWindowMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveApplicationWindowMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveApplicationWindowMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveApplicationWindowMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveApplicationWindowMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveApplicationWindowMethod "setDecorated" o = Gtk.Window.WindowSetDecoratedMethodInfo
    ResolveApplicationWindowMethod "setDefaultSize" o = Gtk.Window.WindowSetDefaultSizeMethodInfo
    ResolveApplicationWindowMethod "setDefaultWidget" o = Gtk.Window.WindowSetDefaultWidgetMethodInfo
    ResolveApplicationWindowMethod "setDeletable" o = Gtk.Window.WindowSetDeletableMethodInfo
    ResolveApplicationWindowMethod "setDestroyWithParent" o = Gtk.Window.WindowSetDestroyWithParentMethodInfo
    ResolveApplicationWindowMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveApplicationWindowMethod "setDisplay" o = Gtk.Window.WindowSetDisplayMethodInfo
    ResolveApplicationWindowMethod "setFocus" o = Gtk.Window.WindowSetFocusMethodInfo
    ResolveApplicationWindowMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveApplicationWindowMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveApplicationWindowMethod "setFocusVisible" o = Gtk.Window.WindowSetFocusVisibleMethodInfo
    ResolveApplicationWindowMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveApplicationWindowMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveApplicationWindowMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveApplicationWindowMethod "setGravity" o = Gtk.Window.WindowSetGravityMethodInfo
    ResolveApplicationWindowMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveApplicationWindowMethod "setHandleMenubarAccel" o = Gtk.Window.WindowSetHandleMenubarAccelMethodInfo
    ResolveApplicationWindowMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveApplicationWindowMethod "setHelpOverlay" o = ApplicationWindowSetHelpOverlayMethodInfo
    ResolveApplicationWindowMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveApplicationWindowMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveApplicationWindowMethod "setHideOnClose" o = Gtk.Window.WindowSetHideOnCloseMethodInfo
    ResolveApplicationWindowMethod "setIconName" o = Gtk.Window.WindowSetIconNameMethodInfo
    ResolveApplicationWindowMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveApplicationWindowMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveApplicationWindowMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveApplicationWindowMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveApplicationWindowMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveApplicationWindowMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveApplicationWindowMethod "setMnemonicsVisible" o = Gtk.Window.WindowSetMnemonicsVisibleMethodInfo
    ResolveApplicationWindowMethod "setModal" o = Gtk.Window.WindowSetModalMethodInfo
    ResolveApplicationWindowMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveApplicationWindowMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveApplicationWindowMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveApplicationWindowMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveApplicationWindowMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveApplicationWindowMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveApplicationWindowMethod "setResizable" o = Gtk.Window.WindowSetResizableMethodInfo
    ResolveApplicationWindowMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveApplicationWindowMethod "setShowMenubar" o = ApplicationWindowSetShowMenubarMethodInfo
    ResolveApplicationWindowMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveApplicationWindowMethod "setStartupId" o = Gtk.Window.WindowSetStartupIdMethodInfo
    ResolveApplicationWindowMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveApplicationWindowMethod "setTitle" o = Gtk.Window.WindowSetTitleMethodInfo
    ResolveApplicationWindowMethod "setTitlebar" o = Gtk.Window.WindowSetTitlebarMethodInfo
    ResolveApplicationWindowMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveApplicationWindowMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveApplicationWindowMethod "setTransientFor" o = Gtk.Window.WindowSetTransientForMethodInfo
    ResolveApplicationWindowMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveApplicationWindowMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveApplicationWindowMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveApplicationWindowMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveApplicationWindowMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveApplicationWindowMethod t ApplicationWindow, O.OverloadedMethod info ApplicationWindow p) => OL.IsLabel t (ApplicationWindow -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveApplicationWindowMethod t ApplicationWindow, O.OverloadedMethod info ApplicationWindow p, R.HasField t ApplicationWindow p) => R.HasField t ApplicationWindow p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveApplicationWindowMethod t ApplicationWindow, O.OverloadedMethodInfo info ApplicationWindow) => OL.IsLabel t (O.MethodProxy info ApplicationWindow) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "show-menubar"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-menubar@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' applicationWindow #showMenubar
-- @
getApplicationWindowShowMenubar :: (MonadIO m, IsApplicationWindow o) => o -> m Bool
getApplicationWindowShowMenubar obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-menubar"

-- | Set the value of the “@show-menubar@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' applicationWindow [ #showMenubar 'Data.GI.Base.Attributes.:=' value ]
-- @
setApplicationWindowShowMenubar :: (MonadIO m, IsApplicationWindow o) => o -> Bool -> m ()
setApplicationWindowShowMenubar obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-menubar" val

-- | Construct a t'GValueConstruct' with valid value for the “@show-menubar@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructApplicationWindowShowMenubar :: (IsApplicationWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructApplicationWindowShowMenubar val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-menubar" val

#if defined(ENABLE_OVERLOADING)
data ApplicationWindowShowMenubarPropertyInfo
instance AttrInfo ApplicationWindowShowMenubarPropertyInfo where
    type AttrAllowedOps ApplicationWindowShowMenubarPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ApplicationWindowShowMenubarPropertyInfo = IsApplicationWindow
    type AttrSetTypeConstraint ApplicationWindowShowMenubarPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ApplicationWindowShowMenubarPropertyInfo = (~) Bool
    type AttrTransferType ApplicationWindowShowMenubarPropertyInfo = Bool
    type AttrGetType ApplicationWindowShowMenubarPropertyInfo = Bool
    type AttrLabel ApplicationWindowShowMenubarPropertyInfo = "show-menubar"
    type AttrOrigin ApplicationWindowShowMenubarPropertyInfo = ApplicationWindow
    attrGet = getApplicationWindowShowMenubar
    attrSet = setApplicationWindowShowMenubar
    attrTransfer _ v = do
        return v
    attrConstruct = constructApplicationWindowShowMenubar
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ApplicationWindow.showMenubar"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ApplicationWindow.html#g:attr:showMenubar"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ApplicationWindow
type instance O.AttributeList ApplicationWindow = ApplicationWindowAttributeList
type ApplicationWindowAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("application", Gtk.Window.WindowApplicationPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", Gtk.Window.WindowChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("decorated", Gtk.Window.WindowDecoratedPropertyInfo), '("defaultHeight", Gtk.Window.WindowDefaultHeightPropertyInfo), '("defaultWidget", Gtk.Window.WindowDefaultWidgetPropertyInfo), '("defaultWidth", Gtk.Window.WindowDefaultWidthPropertyInfo), '("deletable", Gtk.Window.WindowDeletablePropertyInfo), '("destroyWithParent", Gtk.Window.WindowDestroyWithParentPropertyInfo), '("display", Gtk.Window.WindowDisplayPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusVisible", Gtk.Window.WindowFocusVisiblePropertyInfo), '("focusWidget", Gtk.Window.WindowFocusWidgetPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("fullscreened", Gtk.Window.WindowFullscreenedPropertyInfo), '("gravity", Gtk.Window.WindowGravityPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("handleMenubarAccel", Gtk.Window.WindowHandleMenubarAccelPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hideOnClose", Gtk.Window.WindowHideOnClosePropertyInfo), '("iconName", Gtk.Window.WindowIconNamePropertyInfo), '("isActive", Gtk.Window.WindowIsActivePropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("maximized", Gtk.Window.WindowMaximizedPropertyInfo), '("mnemonicsVisible", Gtk.Window.WindowMnemonicsVisiblePropertyInfo), '("modal", Gtk.Window.WindowModalPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("resizable", Gtk.Window.WindowResizablePropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showMenubar", ApplicationWindowShowMenubarPropertyInfo), '("startupId", Gtk.Window.WindowStartupIdPropertyInfo), '("suspended", Gtk.Window.WindowSuspendedPropertyInfo), '("title", Gtk.Window.WindowTitlePropertyInfo), '("titlebar", Gtk.Window.WindowTitlebarPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("transientFor", Gtk.Window.WindowTransientForPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
applicationWindowShowMenubar :: AttrLabelProxy "showMenubar"
applicationWindowShowMenubar = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ApplicationWindow = ApplicationWindowSignalList
type ApplicationWindowSignalList = ('[ '("actionAdded", Gio.ActionGroup.ActionGroupActionAddedSignalInfo), '("actionEnabledChanged", Gio.ActionGroup.ActionGroupActionEnabledChangedSignalInfo), '("actionRemoved", Gio.ActionGroup.ActionGroupActionRemovedSignalInfo), '("actionStateChanged", Gio.ActionGroup.ActionGroupActionStateChangedSignalInfo), '("activateDefault", Gtk.Window.WindowActivateDefaultSignalInfo), '("activateFocus", Gtk.Window.WindowActivateFocusSignalInfo), '("closeRequest", Gtk.Window.WindowCloseRequestSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("enableDebugging", Gtk.Window.WindowEnableDebuggingSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("keysChanged", Gtk.Window.WindowKeysChangedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ApplicationWindow::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "application"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Application" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an application" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "ApplicationWindow" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_application_window_new" gtk_application_window_new :: 
    Ptr Gtk.Application.Application ->      -- application : TInterface (Name {namespace = "Gtk", name = "Application"})
    IO (Ptr ApplicationWindow)

-- | Creates a new @GtkApplicationWindow@.
applicationWindowNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Application.IsApplication a) =>
    a
    -- ^ /@application@/: an application
    -> m ApplicationWindow
    -- ^ __Returns:__ a newly created @GtkApplicationWindow@
applicationWindowNew application = liftIO $ do
    application' <- unsafeManagedPtrCastPtr application
    result <- gtk_application_window_new application'
    checkUnexpectedReturnNULL "applicationWindowNew" result
    result' <- (newObject ApplicationWindow) result
    touchManagedPtr application
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ApplicationWindow::get_help_overlay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ApplicationWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an application window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ShortcutsWindow" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_application_window_get_help_overlay" gtk_application_window_get_help_overlay :: 
    Ptr ApplicationWindow ->                -- window : TInterface (Name {namespace = "Gtk", name = "ApplicationWindow"})
    IO (Ptr Gtk.ShortcutsWindow.ShortcutsWindow)

{-# DEPRECATED applicationWindowGetHelpOverlay ["(Since version 4.18)","@GtkShortcutsWindow@ will be removed in GTK 5"] #-}
-- | Gets the @GtkShortcutsWindow@ that is associated with /@window@/.
-- 
-- See 'GI.Gtk.Objects.ApplicationWindow.applicationWindowSetHelpOverlay'.
applicationWindowGetHelpOverlay ::
    (B.CallStack.HasCallStack, MonadIO m, IsApplicationWindow a) =>
    a
    -- ^ /@window@/: an application window
    -> m (Maybe Gtk.ShortcutsWindow.ShortcutsWindow)
    -- ^ __Returns:__ the help overlay associated
    --   with the window
applicationWindowGetHelpOverlay window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_application_window_get_help_overlay window'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ShortcutsWindow.ShortcutsWindow) result'
        return result''
    touchManagedPtr window
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ApplicationWindowGetHelpOverlayMethodInfo
instance (signature ~ (m (Maybe Gtk.ShortcutsWindow.ShortcutsWindow)), MonadIO m, IsApplicationWindow a) => O.OverloadedMethod ApplicationWindowGetHelpOverlayMethodInfo a signature where
    overloadedMethod = applicationWindowGetHelpOverlay

instance O.OverloadedMethodInfo ApplicationWindowGetHelpOverlayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ApplicationWindow.applicationWindowGetHelpOverlay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ApplicationWindow.html#v:applicationWindowGetHelpOverlay"
        })


#endif

-- method ApplicationWindow::get_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ApplicationWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an application window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_application_window_get_id" gtk_application_window_get_id :: 
    Ptr ApplicationWindow ->                -- window : TInterface (Name {namespace = "Gtk", name = "ApplicationWindow"})
    IO Word32

-- | Returns the unique ID of the window.
-- 
--  If the window has not yet been added to a @GtkApplication@, returns @0@.
applicationWindowGetId ::
    (B.CallStack.HasCallStack, MonadIO m, IsApplicationWindow a) =>
    a
    -- ^ /@window@/: an application window
    -> m Word32
    -- ^ __Returns:__ the unique ID for the window, or @0@ if the window
    --   has not yet been added to an application
applicationWindowGetId window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_application_window_get_id window'
    touchManagedPtr window
    return result

#if defined(ENABLE_OVERLOADING)
data ApplicationWindowGetIdMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsApplicationWindow a) => O.OverloadedMethod ApplicationWindowGetIdMethodInfo a signature where
    overloadedMethod = applicationWindowGetId

instance O.OverloadedMethodInfo ApplicationWindowGetIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ApplicationWindow.applicationWindowGetId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ApplicationWindow.html#v:applicationWindowGetId"
        })


#endif

-- method ApplicationWindow::get_show_menubar
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ApplicationWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an application window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_application_window_get_show_menubar" gtk_application_window_get_show_menubar :: 
    Ptr ApplicationWindow ->                -- window : TInterface (Name {namespace = "Gtk", name = "ApplicationWindow"})
    IO CInt

-- | Returns whether the window will display a menubar for the app menu
-- and menubar as needed.
applicationWindowGetShowMenubar ::
    (B.CallStack.HasCallStack, MonadIO m, IsApplicationWindow a) =>
    a
    -- ^ /@window@/: an application window
    -> m Bool
    -- ^ __Returns:__ True if the window will display a menubar when needed
applicationWindowGetShowMenubar window = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    result <- gtk_application_window_get_show_menubar window'
    let result' = (/= 0) result
    touchManagedPtr window
    return result'

#if defined(ENABLE_OVERLOADING)
data ApplicationWindowGetShowMenubarMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsApplicationWindow a) => O.OverloadedMethod ApplicationWindowGetShowMenubarMethodInfo a signature where
    overloadedMethod = applicationWindowGetShowMenubar

instance O.OverloadedMethodInfo ApplicationWindowGetShowMenubarMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ApplicationWindow.applicationWindowGetShowMenubar",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ApplicationWindow.html#v:applicationWindowGetShowMenubar"
        })


#endif

-- method ApplicationWindow::set_help_overlay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ApplicationWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an application window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "help_overlay"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ShortcutsWindow" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a shortcuts window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_application_window_set_help_overlay" gtk_application_window_set_help_overlay :: 
    Ptr ApplicationWindow ->                -- window : TInterface (Name {namespace = "Gtk", name = "ApplicationWindow"})
    Ptr Gtk.ShortcutsWindow.ShortcutsWindow -> -- help_overlay : TInterface (Name {namespace = "Gtk", name = "ShortcutsWindow"})
    IO ()

{-# DEPRECATED applicationWindowSetHelpOverlay ["(Since version 4.18)","@GtkShortcutsWindow@ will be removed in GTK 5"] #-}
-- | Associates a shortcuts window with the application window.
-- 
-- Additionally, sets up an action with the name
-- @win.show-help-overlay@ to present it.
-- 
-- The window takes responsibility for destroying the help overlay.
applicationWindowSetHelpOverlay ::
    (B.CallStack.HasCallStack, MonadIO m, IsApplicationWindow a, Gtk.ShortcutsWindow.IsShortcutsWindow b) =>
    a
    -- ^ /@window@/: an application window
    -> Maybe (b)
    -- ^ /@helpOverlay@/: a shortcuts window
    -> m ()
applicationWindowSetHelpOverlay window helpOverlay = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    maybeHelpOverlay <- case helpOverlay of
        Nothing -> return FP.nullPtr
        Just jHelpOverlay -> do
            jHelpOverlay' <- unsafeManagedPtrCastPtr jHelpOverlay
            return jHelpOverlay'
    gtk_application_window_set_help_overlay window' maybeHelpOverlay
    touchManagedPtr window
    whenJust helpOverlay touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ApplicationWindowSetHelpOverlayMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsApplicationWindow a, Gtk.ShortcutsWindow.IsShortcutsWindow b) => O.OverloadedMethod ApplicationWindowSetHelpOverlayMethodInfo a signature where
    overloadedMethod = applicationWindowSetHelpOverlay

instance O.OverloadedMethodInfo ApplicationWindowSetHelpOverlayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ApplicationWindow.applicationWindowSetHelpOverlay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ApplicationWindow.html#v:applicationWindowSetHelpOverlay"
        })


#endif

-- method ApplicationWindow::set_show_menubar
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ApplicationWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an application window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "show_menubar"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to show a menubar when needed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_application_window_set_show_menubar" gtk_application_window_set_show_menubar :: 
    Ptr ApplicationWindow ->                -- window : TInterface (Name {namespace = "Gtk", name = "ApplicationWindow"})
    CInt ->                                 -- show_menubar : TBasicType TBoolean
    IO ()

-- | Sets whether the window will display a menubar for the app menu
-- and menubar as needed.
applicationWindowSetShowMenubar ::
    (B.CallStack.HasCallStack, MonadIO m, IsApplicationWindow a) =>
    a
    -- ^ /@window@/: an application window
    -> Bool
    -- ^ /@showMenubar@/: whether to show a menubar when needed
    -> m ()
applicationWindowSetShowMenubar window showMenubar = liftIO $ do
    window' <- unsafeManagedPtrCastPtr window
    let showMenubar' = (P.fromIntegral . P.fromEnum) showMenubar
    gtk_application_window_set_show_menubar window' showMenubar'
    touchManagedPtr window
    return ()

#if defined(ENABLE_OVERLOADING)
data ApplicationWindowSetShowMenubarMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsApplicationWindow a) => O.OverloadedMethod ApplicationWindowSetShowMenubarMethodInfo a signature where
    overloadedMethod = applicationWindowSetShowMenubar

instance O.OverloadedMethodInfo ApplicationWindowSetShowMenubarMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ApplicationWindow.applicationWindowSetShowMenubar",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ApplicationWindow.html#v:applicationWindowSetShowMenubar"
        })


#endif


