{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GSimpleAction@ is the obvious simple implementation of the
-- t'GI.Gio.Interfaces.Action.Action' interface. This is the easiest way to create an action for
-- purposes of adding it to a t'GI.Gio.Objects.SimpleActionGroup.SimpleActionGroup'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.SimpleAction
    ( 

-- * Exported types
    SimpleAction(..)                        ,
    IsSimpleAction                          ,
    toSimpleAction                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [activate]("GI.Gio.Interfaces.Action#g:method:activate"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changeState]("GI.Gio.Interfaces.Action#g:method:changeState"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getEnabled]("GI.Gio.Interfaces.Action#g:method:getEnabled"), [getName]("GI.Gio.Interfaces.Action#g:method:getName"), [getParameterType]("GI.Gio.Interfaces.Action#g:method:getParameterType"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getState]("GI.Gio.Interfaces.Action#g:method:getState"), [getStateHint]("GI.Gio.Interfaces.Action#g:method:getStateHint"), [getStateType]("GI.Gio.Interfaces.Action#g:method:getStateType").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setEnabled]("GI.Gio.Objects.SimpleAction#g:method:setEnabled"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setState]("GI.Gio.Objects.SimpleAction#g:method:setState"), [setStateHint]("GI.Gio.Objects.SimpleAction#g:method:setStateHint").

#if defined(ENABLE_OVERLOADING)
    ResolveSimpleActionMethod               ,
#endif

-- ** new #method:new#

    simpleActionNew                         ,


-- ** newStateful #method:newStateful#

    simpleActionNewStateful                 ,


-- ** setEnabled #method:setEnabled#

#if defined(ENABLE_OVERLOADING)
    SimpleActionSetEnabledMethodInfo        ,
#endif
    simpleActionSetEnabled                  ,


-- ** setState #method:setState#

#if defined(ENABLE_OVERLOADING)
    SimpleActionSetStateMethodInfo          ,
#endif
    simpleActionSetState                    ,


-- ** setStateHint #method:setStateHint#

#if defined(ENABLE_OVERLOADING)
    SimpleActionSetStateHintMethodInfo      ,
#endif
    simpleActionSetStateHint                ,




 -- * Properties


-- ** enabled #attr:enabled#
-- | If /@action@/ is currently enabled.
-- 
-- If the action is disabled then calls to 'GI.Gio.Interfaces.Action.actionActivate' and
-- 'GI.Gio.Interfaces.Action.actionChangeState' have no effect.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    SimpleActionEnabledPropertyInfo         ,
#endif
    constructSimpleActionEnabled            ,
    getSimpleActionEnabled                  ,
    setSimpleActionEnabled                  ,
#if defined(ENABLE_OVERLOADING)
    simpleActionEnabled                     ,
#endif


-- ** name #attr:name#
-- | The name of the action. This is mostly meaningful for identifying
-- the action once it has been added to a t'GI.Gio.Objects.SimpleActionGroup.SimpleActionGroup'.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    SimpleActionNamePropertyInfo            ,
#endif
    constructSimpleActionName               ,
    getSimpleActionName                     ,
#if defined(ENABLE_OVERLOADING)
    simpleActionName                        ,
#endif


-- ** parameterType #attr:parameterType#
-- | The type of the parameter that must be given when activating the
-- action.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    SimpleActionParameterTypePropertyInfo   ,
#endif
    constructSimpleActionParameterType      ,
    getSimpleActionParameterType            ,
#if defined(ENABLE_OVERLOADING)
    simpleActionParameterType               ,
#endif


-- ** state #attr:state#
-- | The state of the action, or 'P.Nothing' if the action is stateless.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    SimpleActionStatePropertyInfo           ,
#endif
    constructSimpleActionState              ,
    getSimpleActionState                    ,
    setSimpleActionState                    ,
#if defined(ENABLE_OVERLOADING)
    simpleActionState                       ,
#endif


-- ** stateType #attr:stateType#
-- | The t'GI.GLib.Structs.VariantType.VariantType' of the state that the action has, or 'P.Nothing' if the
-- action is stateless.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    SimpleActionStateTypePropertyInfo       ,
#endif
    getSimpleActionStateType                ,
#if defined(ENABLE_OVERLOADING)
    simpleActionStateType                   ,
#endif




 -- * Signals


-- ** activate #signal:activate#

    SimpleActionActivateCallback            ,
#if defined(ENABLE_OVERLOADING)
    SimpleActionActivateSignalInfo          ,
#endif
    afterSimpleActionActivate               ,
    onSimpleActionActivate                  ,


-- ** changeState #signal:changeState#

    SimpleActionChangeStateCallback         ,
#if defined(ENABLE_OVERLOADING)
    SimpleActionChangeStateSignalInfo       ,
#endif
    afterSimpleActionChangeState            ,
    onSimpleActionChangeState               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Action as Gio.Action

#else
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Action as Gio.Action

#endif

-- | Memory-managed wrapper type.
newtype SimpleAction = SimpleAction (SP.ManagedPtr SimpleAction)
    deriving (Eq)

instance SP.ManagedPtrNewtype SimpleAction where
    toManagedPtr (SimpleAction p) = p

foreign import ccall "g_simple_action_get_type"
    c_g_simple_action_get_type :: IO B.Types.GType

instance B.Types.TypedObject SimpleAction where
    glibType = c_g_simple_action_get_type

instance B.Types.GObject SimpleAction

-- | Type class for types which can be safely cast to t'SimpleAction', for instance with `toSimpleAction`.
class (SP.GObject o, O.IsDescendantOf SimpleAction o) => IsSimpleAction o
instance (SP.GObject o, O.IsDescendantOf SimpleAction o) => IsSimpleAction o

instance O.HasParentTypes SimpleAction
type instance O.ParentTypes SimpleAction = '[GObject.Object.Object, Gio.Action.Action]

-- | Cast to t'SimpleAction', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSimpleAction :: (MIO.MonadIO m, IsSimpleAction o) => o -> m SimpleAction
toSimpleAction = MIO.liftIO . B.ManagedPtr.unsafeCastTo SimpleAction

-- | Convert t'SimpleAction' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SimpleAction) where
    gvalueGType_ = c_g_simple_action_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SimpleAction)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SimpleAction)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SimpleAction ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSimpleActionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSimpleActionMethod "activate" o = Gio.Action.ActionActivateMethodInfo
    ResolveSimpleActionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSimpleActionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSimpleActionMethod "changeState" o = Gio.Action.ActionChangeStateMethodInfo
    ResolveSimpleActionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSimpleActionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSimpleActionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSimpleActionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSimpleActionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSimpleActionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSimpleActionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSimpleActionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSimpleActionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSimpleActionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSimpleActionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSimpleActionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSimpleActionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSimpleActionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSimpleActionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSimpleActionMethod "getEnabled" o = Gio.Action.ActionGetEnabledMethodInfo
    ResolveSimpleActionMethod "getName" o = Gio.Action.ActionGetNameMethodInfo
    ResolveSimpleActionMethod "getParameterType" o = Gio.Action.ActionGetParameterTypeMethodInfo
    ResolveSimpleActionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSimpleActionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSimpleActionMethod "getState" o = Gio.Action.ActionGetStateMethodInfo
    ResolveSimpleActionMethod "getStateHint" o = Gio.Action.ActionGetStateHintMethodInfo
    ResolveSimpleActionMethod "getStateType" o = Gio.Action.ActionGetStateTypeMethodInfo
    ResolveSimpleActionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSimpleActionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSimpleActionMethod "setEnabled" o = SimpleActionSetEnabledMethodInfo
    ResolveSimpleActionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSimpleActionMethod "setState" o = SimpleActionSetStateMethodInfo
    ResolveSimpleActionMethod "setStateHint" o = SimpleActionSetStateHintMethodInfo
    ResolveSimpleActionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSimpleActionMethod t SimpleAction, O.OverloadedMethod info SimpleAction p) => OL.IsLabel t (SimpleAction -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSimpleActionMethod t SimpleAction, O.OverloadedMethod info SimpleAction p, R.HasField t SimpleAction p) => R.HasField t SimpleAction p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSimpleActionMethod t SimpleAction, O.OverloadedMethodInfo info SimpleAction) => OL.IsLabel t (O.MethodProxy info SimpleAction) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal SimpleAction::activate
-- | Indicates that the action was just activated.
-- 
-- /@parameter@/ will always be of the expected type, i.e. the parameter type
-- specified when the action was created. If an incorrect type is given when
-- activating the action, this signal is not emitted.
-- 
-- Since GLib 2.40, if no handler is connected to this signal then the
-- default behaviour for boolean-stated actions with a 'P.Nothing' parameter
-- type is to toggle them via the [SimpleAction::changeState]("GI.Gio.Objects.SimpleAction#g:signal:changeState") signal.
-- For stateful actions where the state type is equal to the parameter
-- type, the default is to forward them directly to
-- [SimpleAction::changeState]("GI.Gio.Objects.SimpleAction#g:signal:changeState").  This should allow almost all users
-- of t'GI.Gio.Objects.SimpleAction.SimpleAction' to connect only one handler or the other.
-- 
-- /Since: 2.28/
type SimpleActionActivateCallback =
    Maybe GVariant
    -- ^ /@parameter@/: the parameter to the activation, or 'P.Nothing' if it has
    --   no parameter
    -> IO ()

type C_SimpleActionActivateCallback =
    Ptr SimpleAction ->                     -- object
    Ptr GVariant ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SimpleActionActivateCallback`.
foreign import ccall "wrapper"
    mk_SimpleActionActivateCallback :: C_SimpleActionActivateCallback -> IO (FunPtr C_SimpleActionActivateCallback)

wrap_SimpleActionActivateCallback :: 
    GObject a => (a -> SimpleActionActivateCallback) ->
    C_SimpleActionActivateCallback
wrap_SimpleActionActivateCallback gi'cb gi'selfPtr parameter _ = do
    maybeParameter <-
        if parameter == FP.nullPtr
        then return Nothing
        else do
            parameter' <- B.GVariant.newGVariantFromPtr parameter
            return $ Just parameter'
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  maybeParameter


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' simpleAction #activate callback
-- @
-- 
-- 
onSimpleActionActivate :: (IsSimpleAction a, MonadIO m) => a -> ((?self :: a) => SimpleActionActivateCallback) -> m SignalHandlerId
onSimpleActionActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SimpleActionActivateCallback wrapped
    wrapped'' <- mk_SimpleActionActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' simpleAction #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSimpleActionActivate :: (IsSimpleAction a, MonadIO m) => a -> ((?self :: a) => SimpleActionActivateCallback) -> m SignalHandlerId
afterSimpleActionActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SimpleActionActivateCallback wrapped
    wrapped'' <- mk_SimpleActionActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SimpleActionActivateSignalInfo
instance SignalInfo SimpleActionActivateSignalInfo where
    type HaskellCallbackType SimpleActionActivateSignalInfo = SimpleActionActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SimpleActionActivateCallback cb
        cb'' <- mk_SimpleActionActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAction::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleAction.html#g:signal:activate"})

#endif

-- signal SimpleAction::change-state
-- | Indicates that the action just received a request to change its
-- state.
-- 
-- /@value@/ will always be of the correct state type, i.e. the type of the
-- initial state passed to 'GI.Gio.Objects.SimpleAction.simpleActionNewStateful'. If an incorrect
-- type is given when requesting to change the state, this signal is not
-- emitted.
-- 
-- If no handler is connected to this signal then the default
-- behaviour is to call 'GI.Gio.Objects.SimpleAction.simpleActionSetState' to set the state
-- to the requested value. If you connect a signal handler then no
-- default action is taken. If the state should change then you must
-- call 'GI.Gio.Objects.SimpleAction.simpleActionSetState' from the handler.
-- 
-- An example of a \'change-state\' handler:
-- 
-- === /C code/
-- >
-- >static void
-- >change_volume_state (GSimpleAction *action,
-- >                     GVariant      *value,
-- >                     gpointer       user_data)
-- >{
-- >  gint requested;
-- >
-- >  requested = g_variant_get_int32 (value);
-- >
-- >  // Volume only goes from 0 to 10
-- >  if (0 <= requested && requested <= 10)
-- >    g_simple_action_set_state (action, value);
-- >}
-- 
-- 
-- The handler need not set the state to the requested value.
-- It could set it to any value at all, or take some other action.
-- 
-- /Since: 2.30/
type SimpleActionChangeStateCallback =
    Maybe GVariant
    -- ^ /@value@/: the requested value for the state
    -> IO ()

type C_SimpleActionChangeStateCallback =
    Ptr SimpleAction ->                     -- object
    Ptr GVariant ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SimpleActionChangeStateCallback`.
foreign import ccall "wrapper"
    mk_SimpleActionChangeStateCallback :: C_SimpleActionChangeStateCallback -> IO (FunPtr C_SimpleActionChangeStateCallback)

wrap_SimpleActionChangeStateCallback :: 
    GObject a => (a -> SimpleActionChangeStateCallback) ->
    C_SimpleActionChangeStateCallback
wrap_SimpleActionChangeStateCallback gi'cb gi'selfPtr value _ = do
    maybeValue <-
        if value == FP.nullPtr
        then return Nothing
        else do
            value' <- B.GVariant.newGVariantFromPtr value
            return $ Just value'
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  maybeValue


-- | Connect a signal handler for the [changeState](#signal:changeState) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' simpleAction #changeState callback
-- @
-- 
-- 
onSimpleActionChangeState :: (IsSimpleAction a, MonadIO m) => a -> ((?self :: a) => SimpleActionChangeStateCallback) -> m SignalHandlerId
onSimpleActionChangeState obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SimpleActionChangeStateCallback wrapped
    wrapped'' <- mk_SimpleActionChangeStateCallback wrapped'
    connectSignalFunPtr obj "change-state" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changeState](#signal:changeState) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' simpleAction #changeState callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSimpleActionChangeState :: (IsSimpleAction a, MonadIO m) => a -> ((?self :: a) => SimpleActionChangeStateCallback) -> m SignalHandlerId
afterSimpleActionChangeState obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SimpleActionChangeStateCallback wrapped
    wrapped'' <- mk_SimpleActionChangeStateCallback wrapped'
    connectSignalFunPtr obj "change-state" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SimpleActionChangeStateSignalInfo
instance SignalInfo SimpleActionChangeStateSignalInfo where
    type HaskellCallbackType SimpleActionChangeStateSignalInfo = SimpleActionChangeStateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SimpleActionChangeStateCallback cb
        cb'' <- mk_SimpleActionChangeStateCallback cb'
        connectSignalFunPtr obj "change-state" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAction::change-state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleAction.html#g:signal:changeState"})

#endif

--- XXX Duplicated object with different types:
  --- Name {namespace = "Gio", name = "SimpleAction"} -> Property {propName = "enabled", propType = TBasicType TBoolean, propFlags = [PropertyReadable,PropertyWritable], propReadNullable = Nothing, propWriteNullable = Just False, propSetter = Just "set_enabled", propGetter = Nothing, propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "If @action is currently enabled.\n\nIf the action is disabled then calls to g_action_activate() and\ng_action_change_state() have no effect.", sinceVersion = Just "2.28"}, propDeprecated = Nothing}
  --- Name {namespace = "Gio", name = "Action"} -> Property {propName = "enabled", propType = TBasicType TBoolean, propFlags = [PropertyReadable], propReadNullable = Just False, propWriteNullable = Nothing, propSetter = Nothing, propGetter = Just "get_enabled", propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "If @action is currently enabled.\n\nIf the action is disabled then calls to [method@Gio.Action.activate] and\n[method@Gio.Action.change_state] have no effect.", sinceVersion = Just "2.28"}, propDeprecated = Nothing}
--- XXX Duplicated object with different types:
  --- Name {namespace = "Gio", name = "SimpleAction"} -> Property {propName = "name", propType = TBasicType TUTF8, propFlags = [PropertyReadable,PropertyWritable,PropertyConstructOnly], propReadNullable = Nothing, propWriteNullable = Nothing, propSetter = Nothing, propGetter = Nothing, propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The name of the action. This is mostly meaningful for identifying\nthe action once it has been added to a #GSimpleActionGroup.", sinceVersion = Just "2.28"}, propDeprecated = Nothing}
  --- Name {namespace = "Gio", name = "Action"} -> Property {propName = "name", propType = TBasicType TUTF8, propFlags = [PropertyReadable], propReadNullable = Just False, propWriteNullable = Nothing, propSetter = Nothing, propGetter = Just "get_name", propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The name of the action.  This is mostly meaningful for identifying\nthe action once it has been added to a [type@Gio.ActionGroup]. It is immutable.", sinceVersion = Just "2.28"}, propDeprecated = Nothing}
--- XXX Duplicated object with different types:
  --- Name {namespace = "Gio", name = "SimpleAction"} -> Property {propName = "parameter-type", propType = TInterface (Name {namespace = "GLib", name = "VariantType"}), propFlags = [PropertyReadable,PropertyWritable,PropertyConstructOnly], propReadNullable = Nothing, propWriteNullable = Nothing, propSetter = Nothing, propGetter = Nothing, propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The type of the parameter that must be given when activating the\naction.", sinceVersion = Just "2.28"}, propDeprecated = Nothing}
  --- Name {namespace = "Gio", name = "Action"} -> Property {propName = "parameter-type", propType = TInterface (Name {namespace = "GLib", name = "VariantType"}), propFlags = [PropertyReadable], propReadNullable = Just True, propWriteNullable = Nothing, propSetter = Nothing, propGetter = Just "get_parameter_type", propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The type of the parameter that must be given when activating the\naction. This is immutable, and may be `NULL` if no parameter is needed when\nactivating the action.", sinceVersion = Just "2.28"}, propDeprecated = Nothing}
--- XXX Duplicated object with different types:
  --- Name {namespace = "Gio", name = "SimpleAction"} -> Property {propName = "state", propType = TVariant, propFlags = [PropertyReadable,PropertyWritable,PropertyConstruct], propReadNullable = Nothing, propWriteNullable = Just False, propSetter = Just "set_state", propGetter = Nothing, propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The state of the action, or %NULL if the action is stateless.", sinceVersion = Just "2.28"}, propDeprecated = Nothing}
  --- Name {namespace = "Gio", name = "Action"} -> Property {propName = "state", propType = TVariant, propFlags = [PropertyReadable], propReadNullable = Nothing, propWriteNullable = Nothing, propSetter = Nothing, propGetter = Just "get_state", propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The state of the action, or `NULL` if the action is stateless.", sinceVersion = Just "2.28"}, propDeprecated = Nothing}
--- XXX Duplicated object with different types:
  --- Name {namespace = "Gio", name = "SimpleAction"} -> Property {propName = "state-type", propType = TInterface (Name {namespace = "GLib", name = "VariantType"}), propFlags = [PropertyReadable], propReadNullable = Nothing, propWriteNullable = Nothing, propSetter = Nothing, propGetter = Nothing, propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The #GVariantType of the state that the action has, or %NULL if the\naction is stateless.", sinceVersion = Just "2.28"}, propDeprecated = Nothing}
  --- Name {namespace = "Gio", name = "Action"} -> Property {propName = "state-type", propType = TInterface (Name {namespace = "GLib", name = "VariantType"}), propFlags = [PropertyReadable], propReadNullable = Just True, propWriteNullable = Nothing, propSetter = Nothing, propGetter = Just "get_state_type", propTransfer = TransferNothing, propDoc = Documentation {rawDocText = Just "The [type@GLib.VariantType] of the state that the action has, or `NULL` if the\naction is stateless. This is immutable.", sinceVersion = Just "2.28"}, propDeprecated = Nothing}
-- VVV Prop "enabled"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

-- | Get the value of the “@enabled@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' simpleAction #enabled
-- @
getSimpleActionEnabled :: (MonadIO m, IsSimpleAction o) => o -> m Bool
getSimpleActionEnabled obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "enabled"

-- | Set the value of the “@enabled@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' simpleAction [ #enabled 'Data.GI.Base.Attributes.:=' value ]
-- @
setSimpleActionEnabled :: (MonadIO m, IsSimpleAction o) => o -> Bool -> m ()
setSimpleActionEnabled obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "enabled" val

-- | Construct a t'GValueConstruct' with valid value for the “@enabled@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSimpleActionEnabled :: (IsSimpleAction o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSimpleActionEnabled val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "enabled" val

#if defined(ENABLE_OVERLOADING)
data SimpleActionEnabledPropertyInfo
instance AttrInfo SimpleActionEnabledPropertyInfo where
    type AttrAllowedOps SimpleActionEnabledPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint SimpleActionEnabledPropertyInfo = IsSimpleAction
    type AttrSetTypeConstraint SimpleActionEnabledPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SimpleActionEnabledPropertyInfo = (~) Bool
    type AttrTransferType SimpleActionEnabledPropertyInfo = Bool
    type AttrGetType SimpleActionEnabledPropertyInfo = Bool
    type AttrLabel SimpleActionEnabledPropertyInfo = "enabled"
    type AttrOrigin SimpleActionEnabledPropertyInfo = SimpleAction
    attrGet = getSimpleActionEnabled
    attrSet = setSimpleActionEnabled
    attrPut = setSimpleActionEnabled
    attrTransfer _ v = do
        return v
    attrConstruct = constructSimpleActionEnabled
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAction.enabled"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleAction.html#g:attr:enabled"
        })
#endif

-- VVV Prop "name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' simpleAction #name
-- @
getSimpleActionName :: (MonadIO m, IsSimpleAction o) => o -> m (Maybe T.Text)
getSimpleActionName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "name"

-- | Construct a t'GValueConstruct' with valid value for the “@name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSimpleActionName :: (IsSimpleAction o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructSimpleActionName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "name" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data SimpleActionNamePropertyInfo
instance AttrInfo SimpleActionNamePropertyInfo where
    type AttrAllowedOps SimpleActionNamePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SimpleActionNamePropertyInfo = IsSimpleAction
    type AttrSetTypeConstraint SimpleActionNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint SimpleActionNamePropertyInfo = (~) T.Text
    type AttrTransferType SimpleActionNamePropertyInfo = T.Text
    type AttrGetType SimpleActionNamePropertyInfo = (Maybe T.Text)
    type AttrLabel SimpleActionNamePropertyInfo = "name"
    type AttrOrigin SimpleActionNamePropertyInfo = SimpleAction
    attrGet = getSimpleActionName
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructSimpleActionName
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAction.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleAction.html#g:attr:name"
        })
#endif

-- VVV Prop "parameter-type"
   -- Type: TInterface (Name {namespace = "GLib", name = "VariantType"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@parameter-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' simpleAction #parameterType
-- @
getSimpleActionParameterType :: (MonadIO m, IsSimpleAction o) => o -> m (Maybe GLib.VariantType.VariantType)
getSimpleActionParameterType obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "parameter-type" GLib.VariantType.VariantType

-- | Construct a t'GValueConstruct' with valid value for the “@parameter-type@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSimpleActionParameterType :: (IsSimpleAction o, MIO.MonadIO m) => GLib.VariantType.VariantType -> m (GValueConstruct o)
constructSimpleActionParameterType val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "parameter-type" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data SimpleActionParameterTypePropertyInfo
instance AttrInfo SimpleActionParameterTypePropertyInfo where
    type AttrAllowedOps SimpleActionParameterTypePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SimpleActionParameterTypePropertyInfo = IsSimpleAction
    type AttrSetTypeConstraint SimpleActionParameterTypePropertyInfo = (~) GLib.VariantType.VariantType
    type AttrTransferTypeConstraint SimpleActionParameterTypePropertyInfo = (~) GLib.VariantType.VariantType
    type AttrTransferType SimpleActionParameterTypePropertyInfo = GLib.VariantType.VariantType
    type AttrGetType SimpleActionParameterTypePropertyInfo = (Maybe GLib.VariantType.VariantType)
    type AttrLabel SimpleActionParameterTypePropertyInfo = "parameter-type"
    type AttrOrigin SimpleActionParameterTypePropertyInfo = SimpleAction
    attrGet = getSimpleActionParameterType
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructSimpleActionParameterType
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAction.parameterType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleAction.html#g:attr:parameterType"
        })
#endif

-- VVV Prop "state"
   -- Type: TVariant
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Nothing,Just False)

-- | Get the value of the “@state@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' simpleAction #state
-- @
getSimpleActionState :: (MonadIO m, IsSimpleAction o) => o -> m (Maybe GVariant)
getSimpleActionState obj = MIO.liftIO $ B.Properties.getObjectPropertyVariant obj "state"

-- | Set the value of the “@state@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' simpleAction [ #state 'Data.GI.Base.Attributes.:=' value ]
-- @
setSimpleActionState :: (MonadIO m, IsSimpleAction o) => o -> GVariant -> m ()
setSimpleActionState obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyVariant obj "state" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@state@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSimpleActionState :: (IsSimpleAction o, MIO.MonadIO m) => GVariant -> m (GValueConstruct o)
constructSimpleActionState val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyVariant "state" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data SimpleActionStatePropertyInfo
instance AttrInfo SimpleActionStatePropertyInfo where
    type AttrAllowedOps SimpleActionStatePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SimpleActionStatePropertyInfo = IsSimpleAction
    type AttrSetTypeConstraint SimpleActionStatePropertyInfo = (~) GVariant
    type AttrTransferTypeConstraint SimpleActionStatePropertyInfo = (~) GVariant
    type AttrTransferType SimpleActionStatePropertyInfo = GVariant
    type AttrGetType SimpleActionStatePropertyInfo = (Maybe GVariant)
    type AttrLabel SimpleActionStatePropertyInfo = "state"
    type AttrOrigin SimpleActionStatePropertyInfo = SimpleAction
    attrGet = getSimpleActionState
    attrSet = setSimpleActionState
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructSimpleActionState
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAction.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleAction.html#g:attr:state"
        })
#endif

-- VVV Prop "state-type"
   -- Type: TInterface (Name {namespace = "GLib", name = "VariantType"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@state-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' simpleAction #stateType
-- @
getSimpleActionStateType :: (MonadIO m, IsSimpleAction o) => o -> m (Maybe GLib.VariantType.VariantType)
getSimpleActionStateType obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "state-type" GLib.VariantType.VariantType

#if defined(ENABLE_OVERLOADING)
data SimpleActionStateTypePropertyInfo
instance AttrInfo SimpleActionStateTypePropertyInfo where
    type AttrAllowedOps SimpleActionStateTypePropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SimpleActionStateTypePropertyInfo = IsSimpleAction
    type AttrSetTypeConstraint SimpleActionStateTypePropertyInfo = (~) ()
    type AttrTransferTypeConstraint SimpleActionStateTypePropertyInfo = (~) ()
    type AttrTransferType SimpleActionStateTypePropertyInfo = ()
    type AttrGetType SimpleActionStateTypePropertyInfo = (Maybe GLib.VariantType.VariantType)
    type AttrLabel SimpleActionStateTypePropertyInfo = "state-type"
    type AttrOrigin SimpleActionStateTypePropertyInfo = SimpleAction
    attrGet = getSimpleActionStateType
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAction.stateType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleAction.html#g:attr:stateType"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SimpleAction
type instance O.AttributeList SimpleAction = SimpleActionAttributeList
type SimpleActionAttributeList = ('[ '("enabled", SimpleActionEnabledPropertyInfo), '("name", SimpleActionNamePropertyInfo), '("parameterType", SimpleActionParameterTypePropertyInfo), '("state", SimpleActionStatePropertyInfo), '("stateType", SimpleActionStateTypePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
simpleActionEnabled :: AttrLabelProxy "enabled"
simpleActionEnabled = AttrLabelProxy

simpleActionName :: AttrLabelProxy "name"
simpleActionName = AttrLabelProxy

simpleActionParameterType :: AttrLabelProxy "parameterType"
simpleActionParameterType = AttrLabelProxy

simpleActionState :: AttrLabelProxy "state"
simpleActionState = AttrLabelProxy

simpleActionStateType :: AttrLabelProxy "stateType"
simpleActionStateType = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SimpleAction = SimpleActionSignalList
type SimpleActionSignalList = ('[ '("activate", SimpleActionActivateSignalInfo), '("changeState", SimpleActionChangeStateSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SimpleAction::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the action"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parameter_type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantType" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the type of parameter that will be passed to\n  handlers for the #GSimpleAction::activate signal, or %NULL for no parameter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SimpleAction" })
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_action_new" g_simple_action_new :: 
    CString ->                              -- name : TBasicType TUTF8
    Ptr GLib.VariantType.VariantType ->     -- parameter_type : TInterface (Name {namespace = "GLib", name = "VariantType"})
    IO (Ptr SimpleAction)

-- | Creates a new action.
-- 
-- The created action is stateless. See 'GI.Gio.Objects.SimpleAction.simpleActionNewStateful' to create
-- an action that has state.
-- 
-- /Since: 2.28/
simpleActionNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: the name of the action
    -> Maybe (GLib.VariantType.VariantType)
    -- ^ /@parameterType@/: the type of parameter that will be passed to
    --   handlers for the [SimpleAction::activate]("GI.Gio.Objects.SimpleAction#g:signal:activate") signal, or 'P.Nothing' for no parameter
    -> m SimpleAction
    -- ^ __Returns:__ a new t'GI.Gio.Objects.SimpleAction.SimpleAction'
simpleActionNew name parameterType = liftIO $ do
    name' <- textToCString name
    maybeParameterType <- case parameterType of
        Nothing -> return FP.nullPtr
        Just jParameterType -> do
            jParameterType' <- unsafeManagedPtrGetPtr jParameterType
            return jParameterType'
    result <- g_simple_action_new name' maybeParameterType
    checkUnexpectedReturnNULL "simpleActionNew" result
    result' <- (wrapObject SimpleAction) result
    whenJust parameterType touchManagedPtr
    freeMem name'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SimpleAction::new_stateful
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the action"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parameter_type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantType" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the type of the parameter that will be passed to\n  handlers for the #GSimpleAction::activate signal, or %NULL for no parameter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "state"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the initial state of the action"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "SimpleAction" })
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_action_new_stateful" g_simple_action_new_stateful :: 
    CString ->                              -- name : TBasicType TUTF8
    Ptr GLib.VariantType.VariantType ->     -- parameter_type : TInterface (Name {namespace = "GLib", name = "VariantType"})
    Ptr GVariant ->                         -- state : TVariant
    IO (Ptr SimpleAction)

-- | Creates a new stateful action.
-- 
-- All future state values must have the same t'GI.GLib.Structs.VariantType.VariantType' as the initial
-- /@state@/.
-- 
-- If the /@state@/ t'GVariant' is floating, it is consumed.
-- 
-- /Since: 2.28/
simpleActionNewStateful ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@name@/: the name of the action
    -> Maybe (GLib.VariantType.VariantType)
    -- ^ /@parameterType@/: the type of the parameter that will be passed to
    --   handlers for the [SimpleAction::activate]("GI.Gio.Objects.SimpleAction#g:signal:activate") signal, or 'P.Nothing' for no parameter
    -> GVariant
    -- ^ /@state@/: the initial state of the action
    -> m SimpleAction
    -- ^ __Returns:__ a new t'GI.Gio.Objects.SimpleAction.SimpleAction'
simpleActionNewStateful name parameterType state = liftIO $ do
    name' <- textToCString name
    maybeParameterType <- case parameterType of
        Nothing -> return FP.nullPtr
        Just jParameterType -> do
            jParameterType' <- unsafeManagedPtrGetPtr jParameterType
            return jParameterType'
    state' <- unsafeManagedPtrGetPtr state
    result <- g_simple_action_new_stateful name' maybeParameterType state'
    checkUnexpectedReturnNULL "simpleActionNewStateful" result
    result' <- (wrapObject SimpleAction) result
    whenJust parameterType touchManagedPtr
    touchManagedPtr state
    freeMem name'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SimpleAction::set_enabled
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleAction" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "enabled"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether the action is enabled"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_action_set_enabled" g_simple_action_set_enabled :: 
    Ptr SimpleAction ->                     -- simple : TInterface (Name {namespace = "Gio", name = "SimpleAction"})
    CInt ->                                 -- enabled : TBasicType TBoolean
    IO ()

-- | Sets the action as enabled or not.
-- 
-- An action must be enabled in order to be activated or in order to
-- have its state changed from outside callers.
-- 
-- This should only be called by the implementor of the action.  Users
-- of the action should not attempt to modify its enabled flag.
-- 
-- /Since: 2.28/
simpleActionSetEnabled ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleAction a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleAction.SimpleAction'
    -> Bool
    -- ^ /@enabled@/: whether the action is enabled
    -> m ()
simpleActionSetEnabled simple enabled = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    let enabled' = (P.fromIntegral . P.fromEnum) enabled
    g_simple_action_set_enabled simple' enabled'
    touchManagedPtr simple
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleActionSetEnabledMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSimpleAction a) => O.OverloadedMethod SimpleActionSetEnabledMethodInfo a signature where
    overloadedMethod = simpleActionSetEnabled

instance O.OverloadedMethodInfo SimpleActionSetEnabledMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAction.simpleActionSetEnabled",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleAction.html#v:simpleActionSetEnabled"
        })


#endif

-- method SimpleAction::set_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleAction" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new #GVariant for the state"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_action_set_state" g_simple_action_set_state :: 
    Ptr SimpleAction ->                     -- simple : TInterface (Name {namespace = "Gio", name = "SimpleAction"})
    Ptr GVariant ->                         -- value : TVariant
    IO ()

-- | Sets the state of the action.
-- 
-- This directly updates the \'state\' property to the given value.
-- 
-- This should only be called by the implementor of the action.  Users
-- of the action should not attempt to directly modify the \'state\'
-- property.  Instead, they should call 'GI.Gio.Interfaces.Action.actionChangeState' to
-- request the change.
-- 
-- If the /@value@/ GVariant is floating, it is consumed.
-- 
-- /Since: 2.30/
simpleActionSetState ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleAction a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleAction.SimpleAction'
    -> GVariant
    -- ^ /@value@/: the new t'GVariant' for the state
    -> m ()
simpleActionSetState simple value = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    value' <- unsafeManagedPtrGetPtr value
    g_simple_action_set_state simple' value'
    touchManagedPtr simple
    touchManagedPtr value
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleActionSetStateMethodInfo
instance (signature ~ (GVariant -> m ()), MonadIO m, IsSimpleAction a) => O.OverloadedMethod SimpleActionSetStateMethodInfo a signature where
    overloadedMethod = simpleActionSetState

instance O.OverloadedMethodInfo SimpleActionSetStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAction.simpleActionSetState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleAction.html#v:simpleActionSetState"
        })


#endif

-- method SimpleAction::set_state_hint
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "simple"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "SimpleAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSimpleAction" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "state_hint"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVariant representing the state hint"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_simple_action_set_state_hint" g_simple_action_set_state_hint :: 
    Ptr SimpleAction ->                     -- simple : TInterface (Name {namespace = "Gio", name = "SimpleAction"})
    Ptr GVariant ->                         -- state_hint : TVariant
    IO ()

-- | Sets the state hint for the action.
-- 
-- See 'GI.Gio.Interfaces.Action.actionGetStateHint' for more information about
-- action state hints.
-- 
-- /Since: 2.44/
simpleActionSetStateHint ::
    (B.CallStack.HasCallStack, MonadIO m, IsSimpleAction a) =>
    a
    -- ^ /@simple@/: a t'GI.Gio.Objects.SimpleAction.SimpleAction'
    -> Maybe (GVariant)
    -- ^ /@stateHint@/: a t'GVariant' representing the state hint
    -> m ()
simpleActionSetStateHint simple stateHint = liftIO $ do
    simple' <- unsafeManagedPtrCastPtr simple
    maybeStateHint <- case stateHint of
        Nothing -> return FP.nullPtr
        Just jStateHint -> do
            jStateHint' <- unsafeManagedPtrGetPtr jStateHint
            return jStateHint'
    g_simple_action_set_state_hint simple' maybeStateHint
    touchManagedPtr simple
    whenJust stateHint touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SimpleActionSetStateHintMethodInfo
instance (signature ~ (Maybe (GVariant) -> m ()), MonadIO m, IsSimpleAction a) => O.OverloadedMethod SimpleActionSetStateHintMethodInfo a signature where
    overloadedMethod = simpleActionSetStateHint

instance O.OverloadedMethodInfo SimpleActionSetStateHintMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.SimpleAction.simpleActionSetStateHint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-SimpleAction.html#v:simpleActionSetStateHint"
        })


#endif


