/* Toast.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Toast.vala, do not modify */

/*-
 * Copyright 2016-2022 elementary, Inc. (https://elementary.io)
 * Copyright 2016-2017 Artem Anufrij <artem.anufrij@live.de>
 * Copyright 2016-2017 Daniel Foré <daniel@elementary.io>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite-7.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_TOAST_0_PROPERTY,
	GRANITE_TOAST_TITLE_PROPERTY,
	GRANITE_TOAST_NUM_PROPERTIES
};
static GParamSpec* granite_toast_properties[GRANITE_TOAST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GRANITE_TOAST_CLOSED_SIGNAL,
	GRANITE_TOAST_DISMISSED_SIGNAL,
	GRANITE_TOAST_DEFAULT_ACTION_SIGNAL,
	GRANITE_TOAST_NUM_SIGNALS
};
static guint granite_toast_signals[GRANITE_TOAST_NUM_SIGNALS] = {0};

struct _GraniteToastPrivate {
	GtkRevealer* revealer;
	GtkLabel* notification_label;
	GtkButton* default_action_button;
	gchar* _title;
	guint timeout_id;
};

static gint GraniteToast_private_offset;
static gpointer granite_toast_parent_class = NULL;

static void granite_toast_start_timeout (GraniteToast* self);
static gboolean __lambda38_ (GraniteToast* self);
static gboolean ___lambda38__gsource_func (gpointer self);
static void granite_toast_stop_timeout (GraniteToast* self);
static GObject * granite_toast_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void _granite_toast___lambda39_ (GraniteToast* self);
static void __granite_toast___lambda39__gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void _granite_toast___lambda40_ (GraniteToast* self);
static void __granite_toast___lambda40__gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void _granite_toast___lambda41_ (GraniteToast* self);
static void __granite_toast___lambda41__gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                                    gdouble x,
                                                                    gdouble y,
                                                                    gpointer self);
static void _granite_toast___lambda42_ (GraniteToast* self);
static void __granite_toast___lambda42__gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                                    gpointer self);
static void granite_toast_finalize (GObject * obj);
static GType granite_toast_get_type_once (void);
static void _vala_granite_toast_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_granite_toast_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static inline gpointer
granite_toast_get_instance_private (GraniteToast* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteToast_private_offset);
}

/**
     * Reason why a Toast was dismissed
     * @since 7.5.0
     */
static GType
granite_toast_dismiss_reason_get_type_once (void)
{
	static const GEnumValue values[] = {{GRANITE_TOAST_DISMISS_REASON_EXPIRED, "GRANITE_TOAST_DISMISS_REASON_EXPIRED", "expired"}, {GRANITE_TOAST_DISMISS_REASON_CLOSED, "GRANITE_TOAST_DISMISS_REASON_CLOSED", "closed"}, {GRANITE_TOAST_DISMISS_REASON_WITHDRAWN, "GRANITE_TOAST_DISMISS_REASON_WITHDRAWN", "withdrawn"}, {0, NULL, NULL}};
	GType granite_toast_dismiss_reason_type_id;
	granite_toast_dismiss_reason_type_id = g_enum_register_static ("GraniteToastDismissReason", values);
	return granite_toast_dismiss_reason_type_id;
}

GType
granite_toast_dismiss_reason_get_type (void)
{
	static volatile gsize granite_toast_dismiss_reason_type_id__once = 0;
	if (g_once_init_enter (&granite_toast_dismiss_reason_type_id__once)) {
		GType granite_toast_dismiss_reason_type_id;
		granite_toast_dismiss_reason_type_id = granite_toast_dismiss_reason_get_type_once ();
		g_once_init_leave (&granite_toast_dismiss_reason_type_id__once, granite_toast_dismiss_reason_type_id);
	}
	return granite_toast_dismiss_reason_type_id__once;
}

const gchar*
granite_toast_get_title (GraniteToast* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

void
granite_toast_set_title (GraniteToast* self,
                         const gchar* value)
{
	GtkLabel* _tmp0_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notification_label;
	if (_tmp0_ != NULL) {
		GtkLabel* _tmp1_;
		_tmp1_ = self->priv->notification_label;
		gtk_label_set_label (_tmp1_, value);
	}
	_tmp2_ = g_strdup (value);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp2_;
	g_object_notify_by_pspec ((GObject *) self, granite_toast_properties[GRANITE_TOAST_TITLE_PROPERTY]);
}

/**
     * Creates a new Toast with #title as its title
     */
GraniteToast*
granite_toast_construct (GType object_type,
                         const gchar* title)
{
	GraniteToast * self = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	self = (GraniteToast*) g_object_new (object_type, "title", title, NULL);
	return self;
}

GraniteToast*
granite_toast_new (const gchar* title)
{
	return granite_toast_construct (GRANITE_TYPE_TOAST, title);
}

static gboolean
__lambda38_ (GraniteToast* self)
{
	GtkRevealer* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	g_signal_emit (self, granite_toast_signals[GRANITE_TOAST_DISMISSED_SIGNAL], 0, GRANITE_TOAST_DISMISS_REASON_EXPIRED);
	self->priv->timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda38__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda38_ ((GraniteToast*) self);
	return result;
}

static void
granite_toast_start_timeout (GraniteToast* self)
{
	guint duration = 0U;
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->default_action_button;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		duration = (guint) 3500;
	} else {
		duration = (guint) 2000;
	}
	self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, duration, ___lambda38__gsource_func, g_object_ref (self), g_object_unref);
}

static void
granite_toast_stop_timeout (GraniteToast* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
}

/**
     * Sets the default action button label of #this to #label and hides the
     * button if #label is #null.
     */
void
granite_toast_set_default_action (GraniteToast* self,
                                  const gchar* label)
{
	gboolean _tmp0_ = FALSE;
	GtkButton* _tmp3_;
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (label, "") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = label == NULL;
	}
	if (_tmp0_) {
		GtkButton* _tmp1_;
		_tmp1_ = self->priv->default_action_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
	} else {
		GtkButton* _tmp2_;
		_tmp2_ = self->priv->default_action_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
	}
	_tmp3_ = self->priv->default_action_button;
	gtk_button_set_label (_tmp3_, label);
}

/**
     * Sends the Toast on behalf of #this
     */
void
granite_toast_send_notification (GraniteToast* self)
{
	GtkRevealer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->revealer;
	_tmp1_ = gtk_revealer_get_child_revealed (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GtkRevealer* _tmp3_;
		_tmp3_ = self->priv->revealer;
		gtk_revealer_set_reveal_child (_tmp3_, TRUE);
	}
	granite_toast_stop_timeout (self);
	granite_toast_start_timeout (self);
}

/**
     * Withdraws the currently displayed Toast
     * @since 7.4.0
     */
void
granite_toast_withdraw (GraniteToast* self)
{
	GtkRevealer* _tmp0_;
	g_return_if_fail (self != NULL);
	granite_toast_stop_timeout (self);
	_tmp0_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	g_signal_emit (self, granite_toast_signals[GRANITE_TOAST_DISMISSED_SIGNAL], 0, GRANITE_TOAST_DISMISS_REASON_WITHDRAWN);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_granite_toast___lambda39_ (GraniteToast* self)
{
	GtkRevealer* _tmp0_;
	_tmp0_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	granite_toast_stop_timeout (self);
	g_signal_emit (self, granite_toast_signals[GRANITE_TOAST_CLOSED_SIGNAL], 0);
	g_signal_emit (self, granite_toast_signals[GRANITE_TOAST_DISMISSED_SIGNAL], 0, GRANITE_TOAST_DISMISS_REASON_CLOSED);
}

static void
__granite_toast___lambda39__gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	_granite_toast___lambda39_ ((GraniteToast*) self);
}

static void
_granite_toast___lambda40_ (GraniteToast* self)
{
	GtkRevealer* _tmp0_;
	_tmp0_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	granite_toast_stop_timeout (self);
	g_signal_emit (self, granite_toast_signals[GRANITE_TOAST_DEFAULT_ACTION_SIGNAL], 0);
}

static void
__granite_toast___lambda40__gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	_granite_toast___lambda40_ ((GraniteToast*) self);
}

static void
_granite_toast___lambda41_ (GraniteToast* self)
{
	granite_toast_stop_timeout (self);
}

static void
__granite_toast___lambda41__gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                               gdouble x,
                                                               gdouble y,
                                                               gpointer self)
{
	_granite_toast___lambda41_ ((GraniteToast*) self);
}

static void
_granite_toast___lambda42_ (GraniteToast* self)
{
	granite_toast_start_timeout (self);
}

static void
__granite_toast___lambda42__gtk_event_controller_motion_leave (GtkEventControllerMotion* _sender,
                                                               gpointer self)
{
	_granite_toast___lambda42_ ((GraniteToast*) self);
}

static GObject *
granite_toast_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteToast * self;
	GtkButton* _tmp0_ = NULL;
	GtkButton* close_button = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkLabel* _tmp5_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkButton* _tmp9_;
	GtkBox* _tmp10_;
	GtkLabel* _tmp11_;
	GtkBox* _tmp12_;
	GtkButton* _tmp13_;
	GtkEventControllerMotion* motion_controller = NULL;
	GtkEventControllerMotion* _tmp14_;
	GtkBox* _tmp15_;
	GtkWidget* _tmp16_;
	GtkRevealer* _tmp17_ = NULL;
	GtkRevealer* _tmp18_;
	GtkEventControllerMotion* _tmp19_;
	GtkEventController* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	GtkEventControllerMotion* _tmp23_;
	GtkEventControllerMotion* _tmp24_;
	parent_class = G_OBJECT_CLASS (granite_toast_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_TOAST, GraniteToast);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_START);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->default_action_button);
	self->priv->default_action_button = _tmp0_;
	_tmp1_ = (GtkButton*) gtk_button_new_from_icon_name ("window-close-symbolic");
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp1_);
	close_button = _tmp1_;
	_tmp2_ = close_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_CIRCULAR);
	_tmp3_ = granite_toast_get_title (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	gtk_label_set_wrap (_tmp5_, TRUE);
	gtk_label_set_wrap_mode (_tmp5_, PANGO_WRAP_WORD);
	gtk_label_set_natural_wrap_mode (_tmp5_, GTK_NATURAL_WRAP_NONE);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->notification_label);
	self->priv->notification_label = _tmp5_;
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp6_);
	box = _tmp6_;
	_tmp7_ = box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp7_, GRANITE_STYLE_CLASS_OSD);
	_tmp8_ = box;
	_tmp9_ = close_button;
	gtk_box_append (_tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = box;
	_tmp11_ = self->priv->notification_label;
	gtk_box_append (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = box;
	_tmp13_ = self->priv->default_action_button;
	gtk_box_append (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ();
	motion_controller = _tmp14_;
	_tmp15_ = box;
	_tmp16_ = _g_object_ref0 ((GtkWidget*) _tmp15_);
	_tmp17_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp17_, _tmp16_);
	_g_object_unref0 (_tmp16_);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->revealer);
	self->priv->revealer = _tmp17_;
	_tmp18_ = self->priv->revealer;
	gtk_widget_set_parent ((GtkWidget*) _tmp18_, (GtkWidget*) self);
	_tmp19_ = motion_controller;
	_tmp20_ = _g_object_ref0 ((GtkEventController*) _tmp19_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp20_);
	_tmp21_ = close_button;
	g_signal_connect_object (_tmp21_, "clicked", (GCallback) __granite_toast___lambda39__gtk_button_clicked, self, 0);
	_tmp22_ = self->priv->default_action_button;
	g_signal_connect_object (_tmp22_, "clicked", (GCallback) __granite_toast___lambda40__gtk_button_clicked, self, 0);
	_tmp23_ = motion_controller;
	g_signal_connect_object (_tmp23_, "enter", (GCallback) __granite_toast___lambda41__gtk_event_controller_motion_enter, self, 0);
	_tmp24_ = motion_controller;
	g_signal_connect_object (_tmp24_, "leave", (GCallback) __granite_toast___lambda42__gtk_event_controller_motion_leave, self, 0);
	_g_object_unref0 (motion_controller);
	_g_object_unref0 (box);
	_g_object_unref0 (close_button);
	return obj;
}

static void
granite_toast_base_init (GraniteToastClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "toast");
}

static void
granite_toast_class_init (GraniteToastClass * klass,
                          gpointer klass_data)
{
	granite_toast_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteToast_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_toast_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_toast_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_toast_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_toast_finalize;
	/**
	     * The notification text label to be displayed inside of #this
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_TOAST_TITLE_PROPERTY, granite_toast_properties[GRANITE_TOAST_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * Emitted when the Toast is closed by activating the close button
	     */
	granite_toast_signals[GRANITE_TOAST_CLOSED_SIGNAL] = g_signal_new ("closed", GRANITE_TYPE_TOAST, G_SIGNAL_RUN_LAST | G_SIGNAL_DEPRECATED, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * Emitted when the Toast has been dismissed
	     */
	granite_toast_signals[GRANITE_TOAST_DISMISSED_SIGNAL] = g_signal_new ("dismissed", GRANITE_TYPE_TOAST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, GRANITE_TOAST_TYPE_DISMISS_REASON);
	/**
	     * Emitted when the default action button is activated
	     */
	granite_toast_signals[GRANITE_TOAST_DEFAULT_ACTION_SIGNAL] = g_signal_new ("default-action", GRANITE_TYPE_TOAST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_set_layout_manager_type (GTK_WIDGET_CLASS (klass), gtk_bin_layout_get_type ());
}

static void
granite_toast_instance_init (GraniteToast * self,
                             gpointer klass)
{
	self->priv = granite_toast_get_instance_private (self);
}

static void
granite_toast_finalize (GObject * obj)
{
	GraniteToast * self;
	GtkWidget* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_TOAST, GraniteToast);
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
	gtk_widget_unparent (_tmp0_);
	_g_object_unref0 (self->priv->revealer);
	_g_object_unref0 (self->priv->notification_label);
	_g_object_unref0 (self->priv->default_action_button);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (granite_toast_parent_class)->finalize (obj);
}

/**
 * Toasts are small in-app notifications that provide feedback about an operation
 * in a small popup. They only fill the space required to show the message and do
 * not block the UI.
 *
 * Granite.Widgets.Toast will get the style class .app-notification
 *
 * {{../doc/images/Toast.png}}
 */
static GType
granite_toast_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteToastClass), (GBaseInitFunc) granite_toast_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_toast_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteToast), 0, (GInstanceInitFunc) granite_toast_instance_init, NULL };
	GType granite_toast_type_id;
	granite_toast_type_id = g_type_register_static (gtk_widget_get_type (), "GraniteToast", &g_define_type_info, 0);
	GraniteToast_private_offset = g_type_add_instance_private (granite_toast_type_id, sizeof (GraniteToastPrivate));
	return granite_toast_type_id;
}

GType
granite_toast_get_type (void)
{
	static volatile gsize granite_toast_type_id__once = 0;
	if (g_once_init_enter (&granite_toast_type_id__once)) {
		GType granite_toast_type_id;
		granite_toast_type_id = granite_toast_get_type_once ();
		g_once_init_leave (&granite_toast_type_id__once, granite_toast_type_id);
	}
	return granite_toast_type_id__once;
}

static void
_vala_granite_toast_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	GraniteToast * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_TOAST, GraniteToast);
	switch (property_id) {
		case GRANITE_TOAST_TITLE_PROPERTY:
		g_value_set_string (value, granite_toast_get_title (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_toast_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	GraniteToast * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_TOAST, GraniteToast);
	switch (property_id) {
		case GRANITE_TOAST_TITLE_PROPERTY:
		granite_toast_set_title (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

