/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_packet_header_default = R"doc(Default header formatter for digital packet transmission.

For bursty/packetized digital transmission, packets are usually prepended with a packet header, containing the number of bytes etc. This class is not a block, but a tool to create these packet header.


This is a default packet header (see header_formatter()) for a description on the header format). To create other header, derive packet header creator classes from this function.


gr::digital::packet_headergenerator_bb uses header generators derived from this class to create packet headers from data streams.

Constructor Specific Documentation:



Args:
    header_len : 
    len_tag_key : 
    num_tag_key : 
    bits_per_byte : )doc";


static const char* __doc_gr_digital_packet_header_default_packet_header_default_0 =
    R"doc()doc";


static const char* __doc_gr_digital_packet_header_default_packet_header_default_1 =
    R"doc()doc";


static const char* __doc_gr_digital_packet_header_default_base = R"doc()doc";


static const char* __doc_gr_digital_packet_header_default_formatter = R"doc()doc";


static const char* __doc_gr_digital_packet_header_default_set_header_num = R"doc()doc";


static const char* __doc_gr_digital_packet_header_default_header_len = R"doc()doc";


static const char* __doc_gr_digital_packet_header_default_len_tag_key = R"doc()doc";


static const char* __doc_gr_digital_packet_header_default_header_formatter = R"doc(Encodes the header information in the given tags into bits and places them into .

Uses the following header format: Bits 0-11: The packet length (what was stored in the tag with key ) Bits 12-23: The header number (counts up every time this function is called) Bit 24-31: 8-Bit CRC All other bits: Are set to zero


If the header length is smaller than 32, bits are simply left out. For this reason, they always start with the LSB.


However, it is recommended to stay above 32 Bits, in order to have a working CRC.)doc";


static const char* __doc_gr_digital_packet_header_default_header_parser = R"doc(Inverse function to header_formatter().

Reads the bit stream in  and writes a corresponding tag into .)doc";


static const char* __doc_gr_digital_packet_header_default_make = R"doc(Default header formatter for digital packet transmission.

For bursty/packetized digital transmission, packets are usually prepended with a packet header, containing the number of bytes etc. This class is not a block, but a tool to create these packet header.


This is a default packet header (see header_formatter()) for a description on the header format). To create other header, derive packet header creator classes from this function.


gr::digital::packet_headergenerator_bb uses header generators derived from this class to create packet headers from data streams.

Constructor Specific Documentation:



Args:
    header_len : 
    len_tag_key : 
    num_tag_key : 
    bits_per_byte : )doc";
