/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_control_loop = R"doc(A second-order control loop implementation class.

This class implements a second order control loop and is intended to act as a parent class to blocks which need a control loop (e.g., gr::digital::costas_loop_cc, gr::analog::pll_refout_cc, etc.). It takes in a loop bandwidth as well as a max and min frequency and provides the functions that control the update of the loop.


The loop works of alpha and beta gains. These gains are calculated using the input loop bandwidth and a pre-set damping factor. The damping factor can be changed using the set_damping_factor after the block is constructed. The alpha and beta values can be set using their respective set_alpha or set_beta functions if very precise control over these is required.


The class tracks both phase and frequency of a signal based on an error signal. The error calculation is unique for each algorithm and is calculated externally and passed to the advance_loop function, which uses this to update its phase and frequency estimates.


This class also provides the functions phase_wrap and frequency_limit to easily keep the phase and frequency estimates within our set bounds (phase_wrap keeps it within +/-2pi).)doc";


static const char* __doc_gr_blocks_control_loop_control_loop_0 = R"doc()doc";


static const char* __doc_gr_blocks_control_loop_control_loop_1 = R"doc()doc";


static const char* __doc_gr_blocks_control_loop_control_loop_2 = R"doc()doc";


static const char* __doc_gr_blocks_control_loop_update_gains = R"doc(Update the system gains from the loop bandwidth and damping factor.

This function updates the system gains based on the loop bandwidth and damping factor of the system. These two factors can be set separately through their own set functions.)doc";


static const char* __doc_gr_blocks_control_loop_advance_loop = R"doc(Advance the control loop based on the current gain settings and the inputted error signal.)doc";


static const char* __doc_gr_blocks_control_loop_phase_wrap = R"doc(Keep the phase between -2pi and 2pi.

This function keeps the phase between -2pi and 2pi. If the phase is greater than 2pi by d, it wraps around to be -2pi+d; similarly if it is less than -2pi by d, it wraps around to 2pi-d.


This function should be called after advance_loop to keep the phase in a good operating region. It is set as a separate method in case another way is desired as this is fairly heavy-handed.)doc";


static const char* __doc_gr_blocks_control_loop_frequency_limit = R"doc(Keep the frequency between d_min_freq and d_max_freq.

This function keeps the frequency between d_min_freq and d_max_freq. If the frequency is greater than d_max_freq, it is set to d_max_freq. If the frequency is less than d_min_freq, it is set to d_min_freq.


This function should be called after advance_loop to keep the frequency in the specified region. It is set as a separate method in case another way is desired as this is fairly heavy-handed.)doc";


static const char* __doc_gr_blocks_control_loop_set_loop_bandwidth = R"doc(Set the loop bandwidth.

Set the loop filter's bandwidth to . This should be between 2*pi/200 and 2*pi/100 (in rads/samp). It must also be a positive number.


When a new damping factor is set, the gains, alpha and beta, of the loop are recalculated by a call to update_gains().)doc";


static const char* __doc_gr_blocks_control_loop_set_damping_factor = R"doc(Set the loop damping factor.

Set the loop filter's damping factor to . The damping factor should be sqrt(2)/2.0 for critically damped systems. Set it to anything else only if you know what you are doing. It must be a number between 0 and 1.


When a new damping factor is set, the gains, alpha and beta, of the loop are recalculated by a call to update_gains().)doc";


static const char* __doc_gr_blocks_control_loop_set_alpha = R"doc(Set the loop gain alpha.

Sets the loop filter's alpha gain parameter.


This value should really only be set by adjusting the loop bandwidth and damping factor.)doc";


static const char* __doc_gr_blocks_control_loop_set_beta = R"doc(Set the loop gain beta.

Sets the loop filter's beta gain parameter.


This value should really only be set by adjusting the loop bandwidth and damping factor.)doc";


static const char* __doc_gr_blocks_control_loop_set_frequency = R"doc(Set the control loop's frequency.

Sets the control loop's frequency. While this is normally updated by the inner loop of the algorithm, it could be useful to manually initialize, set, or reset this under certain circumstances.)doc";


static const char* __doc_gr_blocks_control_loop_set_phase = R"doc(Set the control loop's phase.

Sets the control loop's phase. While this is normally updated by the inner loop of the algorithm, it could be useful to manually initialize, set, or reset this under certain circumstances.)doc";


static const char* __doc_gr_blocks_control_loop_set_max_freq = R"doc(Set the control loop's maximum frequency.

Set the maximum frequency the control loop can track.)doc";


static const char* __doc_gr_blocks_control_loop_set_min_freq = R"doc(Set the control loop's minimum frequency.

Set the minimum frequency the control loop can track.)doc";


static const char* __doc_gr_blocks_control_loop_get_loop_bandwidth = R"doc(Returns the loop bandwidth.)doc";


static const char* __doc_gr_blocks_control_loop_get_damping_factor = R"doc(Returns the loop damping factor.)doc";


static const char* __doc_gr_blocks_control_loop_get_alpha = R"doc(Returns the loop gain alpha.)doc";


static const char* __doc_gr_blocks_control_loop_get_beta = R"doc(Returns the loop gain beta.)doc";


static const char* __doc_gr_blocks_control_loop_get_frequency = R"doc(Get the control loop's frequency estimate.)doc";


static const char* __doc_gr_blocks_control_loop_get_phase = R"doc(Get the control loop's phase estimate.)doc";


static const char* __doc_gr_blocks_control_loop_get_max_freq = R"doc(Get the control loop's maximum frequency.)doc";


static const char* __doc_gr_blocks_control_loop_get_min_freq = R"doc(Get the control loop's minimum frequency.)doc";


static const char* __doc_gr_blocks_tanhf_lut = R"doc()doc";
