// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v6.30.2
// source: remote.proto

package gitalypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	RemoteService_UpdateRemoteMirror_FullMethodName   = "/gitaly.RemoteService/UpdateRemoteMirror"
	RemoteService_FindRemoteRepository_FullMethodName = "/gitaly.RemoteService/FindRemoteRepository"
	RemoteService_FindRemoteRootRef_FullMethodName    = "/gitaly.RemoteService/FindRemoteRootRef"
)

// RemoteServiceClient is the client API for RemoteService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// RemoteService is a service providing RPCs to interact with a remote
// repository that is hosted on another Git server.
type RemoteServiceClient interface {
	// UpdateRemoteMirror compares the references in the target repository and its remote mirror
	// repository. Any differences in the references are then addressed by pushing the differing
	// references to the mirror. Created and modified references are updated, removed references are
	// deleted from the mirror. UpdateRemoteMirror updates all tags. Branches are updated if they match
	// the patterns specified in the requests.
	UpdateRemoteMirror(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[UpdateRemoteMirrorRequest, UpdateRemoteMirrorResponse], error)
	// FindRemoteRepository detects whether a repository exists at the given URI. This is done by
	// asking git-ls-remote(1) to enumerate the remote's HEAD and then checking that we recognize it
	// as a valid reference.
	FindRemoteRepository(ctx context.Context, in *FindRemoteRepositoryRequest, opts ...grpc.CallOption) (*FindRemoteRepositoryResponse, error)
	// FindRemoteRootRef tries to find the root reference of a remote
	// repository. The root reference is the default branch as pointed to by
	// the remotes HEAD reference. Returns an InvalidArgument error if the
	// specified remote does not exist and a NotFound error in case no HEAD
	// branch was found.
	FindRemoteRootRef(ctx context.Context, in *FindRemoteRootRefRequest, opts ...grpc.CallOption) (*FindRemoteRootRefResponse, error)
}

type remoteServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRemoteServiceClient(cc grpc.ClientConnInterface) RemoteServiceClient {
	return &remoteServiceClient{cc}
}

func (c *remoteServiceClient) UpdateRemoteMirror(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[UpdateRemoteMirrorRequest, UpdateRemoteMirrorResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RemoteService_ServiceDesc.Streams[0], RemoteService_UpdateRemoteMirror_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[UpdateRemoteMirrorRequest, UpdateRemoteMirrorResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RemoteService_UpdateRemoteMirrorClient = grpc.ClientStreamingClient[UpdateRemoteMirrorRequest, UpdateRemoteMirrorResponse]

func (c *remoteServiceClient) FindRemoteRepository(ctx context.Context, in *FindRemoteRepositoryRequest, opts ...grpc.CallOption) (*FindRemoteRepositoryResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(FindRemoteRepositoryResponse)
	err := c.cc.Invoke(ctx, RemoteService_FindRemoteRepository_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *remoteServiceClient) FindRemoteRootRef(ctx context.Context, in *FindRemoteRootRefRequest, opts ...grpc.CallOption) (*FindRemoteRootRefResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(FindRemoteRootRefResponse)
	err := c.cc.Invoke(ctx, RemoteService_FindRemoteRootRef_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RemoteServiceServer is the server API for RemoteService service.
// All implementations must embed UnimplementedRemoteServiceServer
// for forward compatibility.
//
// RemoteService is a service providing RPCs to interact with a remote
// repository that is hosted on another Git server.
type RemoteServiceServer interface {
	// UpdateRemoteMirror compares the references in the target repository and its remote mirror
	// repository. Any differences in the references are then addressed by pushing the differing
	// references to the mirror. Created and modified references are updated, removed references are
	// deleted from the mirror. UpdateRemoteMirror updates all tags. Branches are updated if they match
	// the patterns specified in the requests.
	UpdateRemoteMirror(grpc.ClientStreamingServer[UpdateRemoteMirrorRequest, UpdateRemoteMirrorResponse]) error
	// FindRemoteRepository detects whether a repository exists at the given URI. This is done by
	// asking git-ls-remote(1) to enumerate the remote's HEAD and then checking that we recognize it
	// as a valid reference.
	FindRemoteRepository(context.Context, *FindRemoteRepositoryRequest) (*FindRemoteRepositoryResponse, error)
	// FindRemoteRootRef tries to find the root reference of a remote
	// repository. The root reference is the default branch as pointed to by
	// the remotes HEAD reference. Returns an InvalidArgument error if the
	// specified remote does not exist and a NotFound error in case no HEAD
	// branch was found.
	FindRemoteRootRef(context.Context, *FindRemoteRootRefRequest) (*FindRemoteRootRefResponse, error)
	mustEmbedUnimplementedRemoteServiceServer()
}

// UnimplementedRemoteServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedRemoteServiceServer struct{}

func (UnimplementedRemoteServiceServer) UpdateRemoteMirror(grpc.ClientStreamingServer[UpdateRemoteMirrorRequest, UpdateRemoteMirrorResponse]) error {
	return status.Errorf(codes.Unimplemented, "method UpdateRemoteMirror not implemented")
}
func (UnimplementedRemoteServiceServer) FindRemoteRepository(context.Context, *FindRemoteRepositoryRequest) (*FindRemoteRepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindRemoteRepository not implemented")
}
func (UnimplementedRemoteServiceServer) FindRemoteRootRef(context.Context, *FindRemoteRootRefRequest) (*FindRemoteRootRefResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindRemoteRootRef not implemented")
}
func (UnimplementedRemoteServiceServer) mustEmbedUnimplementedRemoteServiceServer() {}
func (UnimplementedRemoteServiceServer) testEmbeddedByValue()                       {}

// UnsafeRemoteServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RemoteServiceServer will
// result in compilation errors.
type UnsafeRemoteServiceServer interface {
	mustEmbedUnimplementedRemoteServiceServer()
}

func RegisterRemoteServiceServer(s grpc.ServiceRegistrar, srv RemoteServiceServer) {
	// If the following call pancis, it indicates UnimplementedRemoteServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&RemoteService_ServiceDesc, srv)
}

func _RemoteService_UpdateRemoteMirror_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RemoteServiceServer).UpdateRemoteMirror(&grpc.GenericServerStream[UpdateRemoteMirrorRequest, UpdateRemoteMirrorResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RemoteService_UpdateRemoteMirrorServer = grpc.ClientStreamingServer[UpdateRemoteMirrorRequest, UpdateRemoteMirrorResponse]

func _RemoteService_FindRemoteRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindRemoteRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RemoteServiceServer).FindRemoteRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RemoteService_FindRemoteRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RemoteServiceServer).FindRemoteRepository(ctx, req.(*FindRemoteRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RemoteService_FindRemoteRootRef_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindRemoteRootRefRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RemoteServiceServer).FindRemoteRootRef(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RemoteService_FindRemoteRootRef_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RemoteServiceServer).FindRemoteRootRef(ctx, req.(*FindRemoteRootRefRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RemoteService_ServiceDesc is the grpc.ServiceDesc for RemoteService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RemoteService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.RemoteService",
	HandlerType: (*RemoteServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FindRemoteRepository",
			Handler:    _RemoteService_FindRemoteRepository_Handler,
		},
		{
			MethodName: "FindRemoteRootRef",
			Handler:    _RemoteService_FindRemoteRootRef_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "UpdateRemoteMirror",
			Handler:       _RemoteService_UpdateRemoteMirror_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "remote.proto",
}
