#include <stdint.h>
#include <fcitx/fcitx.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>


#ifndef __FCITX_MODULE_FCITX_PINYIN_ADD_FUNCTION_H
#define __FCITX_MODULE_FCITX_PINYIN_ADD_FUNCTION_H

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-pinyin", _Pinyin_)

static void*
__fcitx_Pinyin_function_LoadBaseDict(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxPinyinState*, __self, _self);
    FCITX_UNUSED(_args);
    FcitxPinyinState* self = __self;
    FCITX_UNUSED(self);
    (self)->bPYBaseDictLoaded ? false : LoadPYBaseDict((self));
    return NULL;
}

static void*
__fcitx_Pinyin_function_GetPyByHZ(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxPinyinState*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(char*, arg1, _args.args[1]);
    FcitxPinyinState* self = __self;
    FCITX_UNUSED(self);
    PYGetPYByHZ(self, arg0, arg1);
    return NULL;
}

static void*
__fcitx_Pinyin_function_DoInput(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxPinyinState*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const FcitxKeySym*, _arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(const unsigned int*, _arg1, _args.args[1]);
    FcitxPinyinState* self = __self;
    FCITX_UNUSED(self);
    FcitxKeySym arg0 = (*(_arg0));
    unsigned int arg1 = (*(_arg1));
    DoPYInput(self, arg0, arg1);
    return NULL;
}

static void*
__fcitx_Pinyin_function_GetCandwords(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxPinyinState*, __self, _self);
    FCITX_UNUSED(_args);
    FcitxPinyinState* self = __self;
    FCITX_UNUSED(self);
    PYGetCandWords(self);
    return NULL;
}

static void*
__fcitx_Pinyin_function_GetFindString(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxPinyinState*, __self, _self);
    FCITX_UNUSED(_args);
    FcitxPinyinState* self = __self;
    FCITX_UNUSED(self);
    char* res = ((self)->strFindString);
    FCITX_RETURN_AS_PTR(char*, res);
}

static void*
__fcitx_Pinyin_function_Reset(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxPinyinState*, __self, _self);
    FCITX_UNUSED(_args);
    FcitxPinyinState* self = __self;
    FCITX_UNUSED(self);
    (self)->bSP = false;
    ResetPYStatus(self);
    return NULL;
}

static void*
__fcitx_Pinyin_function_SP2QP(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxPinyinState*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FcitxPinyinState* self = __self;
    FCITX_UNUSED(self);
    char* res = (PYSP2QP(self, arg0));
    FCITX_RETURN_AS_PTR(char*, res);
}

static void*
__fcitx_Pinyin_function_AddUserPhrase(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxPinyinState*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FcitxPinyinState* self = __self;
    FCITX_UNUSED(self);
    PYAddUserPhraseFromCString(self, arg0);
    return NULL;
}

static void
FcitxPinyinAddFunctions(FcitxInstance *instance)
{
    int i;
    FcitxAddon *addon = Fcitx_Pinyin_GetAddon(instance);
    static const FcitxModuleFunction ____fcitx_Pinyin_addon_functions_table[] = {
        __fcitx_Pinyin_function_LoadBaseDict,
        __fcitx_Pinyin_function_GetPyByHZ,
        __fcitx_Pinyin_function_DoInput,
        __fcitx_Pinyin_function_GetCandwords,
        __fcitx_Pinyin_function_GetFindString,
        __fcitx_Pinyin_function_Reset,
        __fcitx_Pinyin_function_SP2QP,
        __fcitx_Pinyin_function_AddUserPhrase,
    };
    for (i = 0;i < 8;i++) {
        FcitxModuleAddFunction(addon, ____fcitx_Pinyin_addon_functions_table[i]);
    }
}

#ifdef __cplusplus
}
#endif

#endif
