
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "downloadmanager_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

// inner classes
#include "downloadmanager_downloadinfo_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_DownloadManager_Type = nullptr;
static PyTypeObject *Sbk_DownloadManager_TypeF(void)
{
    return _Sbk_DownloadManager_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void DownloadManagerWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::DownloadManager::DownloadOption >("DownloadManager::DownloadOption");
}

void DownloadManagerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

DownloadManagerWrapper::DownloadManagerWrapper(::QWidget * parent) : DownloadManager(parent)
{
}

void DownloadManagerWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    WebViewWrapper::sbk_o_changeEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("DownloadManager", funcName, gil, pyOverride, signal);
}

void DownloadManagerWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("DownloadManager", funcName, gil, pyOverride, event);
}

int DownloadManagerWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("DownloadManager", funcName, gil, pyOverride);
}

void DownloadManagerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("DownloadManager", funcName, gil, pyOverride, signal);
}

void DownloadManagerWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("DownloadManager", funcName, gil, pyOverride, event);
}

bool DownloadManagerWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return WebViewWrapper::sbk_o_event("DownloadManager", funcName, gil, pyOverride, event);
}

bool DownloadManagerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("DownloadManager", funcName, gil, pyOverride, watched, event);
}

void DownloadManagerWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("DownloadManager", funcName, gil, pyOverride, event);
}

bool DownloadManagerWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("DownloadManager", funcName, gil, pyOverride, next);
}

void DownloadManagerWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    WebViewWrapper::sbk_o_focusOutEvent("DownloadManager", funcName, gil, pyOverride, event);
}

bool DownloadManagerWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("DownloadManager", funcName, gil, pyOverride);
}

int DownloadManagerWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("DownloadManager", funcName, gil, pyOverride, arg__1);
}

void DownloadManagerWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("DownloadManager", funcName, gil, pyOverride, painter);
}

void DownloadManagerWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("DownloadManager", funcName, gil, pyOverride, event);
}

::QVariant DownloadManagerWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("DownloadManager", funcName, gil, pyOverride, arg__1);
}

void DownloadManagerWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("DownloadManager", funcName, gil, pyOverride, event);
}

int DownloadManagerWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("DownloadManager", funcName, gil, pyOverride, arg__1);
}

::QSize DownloadManagerWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("DownloadManager", funcName, gil, pyOverride);
}

void DownloadManagerWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    WebViewWrapper::sbk_o_mousePressEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("DownloadManager", funcName, gil, pyOverride, event);
}

bool DownloadManagerWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("DownloadManager", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * DownloadManagerWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("DownloadManager", funcName, gil, pyOverride);
}

void DownloadManagerWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    WebViewWrapper::sbk_o_paintEvent("DownloadManager", funcName, gil, pyOverride, event);
}

::QPaintDevice * DownloadManagerWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("DownloadManager", funcName, gil, pyOverride, offset);
}

void DownloadManagerWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("DownloadManager", funcName, gil, pyOverride, visible);
}

::QPainter * DownloadManagerWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("DownloadManager", funcName, gil, pyOverride);
}

void DownloadManagerWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("DownloadManager", funcName, gil, pyOverride, event);
}

::QSize DownloadManagerWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("DownloadManager", funcName, gil, pyOverride);
}

void DownloadManagerWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("DownloadManager", funcName, gil, pyOverride, event);
}

void DownloadManagerWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_DownloadManager_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("DownloadManager", funcName, gil, pyOverride, event);
}

const QMetaObject *DownloadManagerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return DownloadManager::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int DownloadManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = DownloadManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *DownloadManagerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< DownloadManagerWrapper *>(this));
    }
    return DownloadManager::qt_metacast(_clname);
}

DownloadManagerWrapper::~DownloadManagerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_DownloadManager_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_DownloadManager_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::DownloadManager >()))
        return -1;

    DownloadManagerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:DownloadManager", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: DownloadManager::DownloadManager(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // DownloadManager(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // DownloadManager(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // DownloadManager(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) DownloadManagerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new DownloadManagerWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< DownloadManager >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]);
    };


    return 1;
}

static PyObject *Sbk_DownloadManagerFunc_activeDownloadsCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadManagerWrapper *>(reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // activeDownloadsCount()const
        int cppResult = const_cast<const DownloadManagerWrapper *>(cppSelf)->activeDownloadsCount();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DownloadManagerFunc_canClose(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadManagerWrapper *>(reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // canClose()
        bool cppResult = cppSelf->canClose();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DownloadManagerFunc_closeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadManagerWrapper *>(reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::closeEvent(QCloseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QCloseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // closeEvent(QCloseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "closeEvent", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("closeEvent(QCloseEvent *e)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DownloadManagerFunc_download(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadManagerWrapper *>(reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: DownloadManager::download(QWebEngineDownloadRequest*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineDownloadRequest_IDX]), (pyArg)))) {
        overloadId = 0; // download(QWebEngineDownloadRequest*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "download", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineDownloadRequest *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // download(QWebEngineDownloadRequest*)
            cppSelf->download(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DownloadManagerFunc_downloadsCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadManagerWrapper *>(reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // downloadsCount()const
        int cppResult = const_cast<const DownloadManagerWrapper *>(cppSelf)->downloadsCount();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_DownloadManagerFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadManagerWrapper *>(reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keyPressEvent", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("keyPressEvent(QKeyEvent *e)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DownloadManagerFunc_loadSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadManagerWrapper *>(reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadSettings()
        cppSelf->loadSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DownloadManagerFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadManagerWrapper *>(reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QResizeEvent_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resizeEvent", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("resizeEvent(QResizeEvent *e)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DownloadManagerFunc_setLastDownloadOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadManagerWrapper *>(reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: DownloadManager::setLastDownloadOption(DownloadManager::DownloadOption)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadOption_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setLastDownloadOption(DownloadManager::DownloadOption)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLastDownloadOption", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]);

    // Call function/method
    {
        ::DownloadManager::DownloadOption cppArg0{DownloadManager::OpenFile};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLastDownloadOption(DownloadManager::DownloadOption)
            cppSelf->setLastDownloadOption(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DownloadManagerFunc_setLastDownloadPath(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadManagerWrapper *>(reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: DownloadManager::setLastDownloadPath(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setLastDownloadPath(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLastDownloadPath", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLastDownloadPath(QString)
            cppSelf->setLastDownloadPath(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DownloadManagerFunc_show(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadManagerWrapper *>(reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // show()
        cppSelf->show();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DownloadManagerFunc_startExternalManager(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadManagerWrapper *>(reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: DownloadManager::startExternalManager(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // startExternalManager(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "startExternalManager", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // startExternalManager(QUrl)
            cppSelf->startExternalManager(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DownloadManagerFunc_timerEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadManagerWrapper *>(reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::timerEvent(QTimerEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimerEvent_IDX]), (pyArg)))) {
        overloadId = 0; // timerEvent(QTimerEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "timerEvent", errInfo, SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("timerEvent(QTimerEvent *e)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_DownloadManagerFunc_useExternalManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<DownloadManagerWrapper *>(reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // useExternalManager()const
        bool cppResult = const_cast<const DownloadManagerWrapper *>(cppSelf)->useExternalManager();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_DownloadManager_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_DownloadManager_EnumFlagInfo[] = {
    "DownloadOption:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_DownloadManager_methods[] = {
    {"activeDownloadsCount", reinterpret_cast<PyCFunction>(Sbk_DownloadManagerFunc_activeDownloadsCount), METH_NOARGS, nullptr},
    {"canClose", reinterpret_cast<PyCFunction>(Sbk_DownloadManagerFunc_canClose), METH_NOARGS, nullptr},
    {"closeEvent", reinterpret_cast<PyCFunction>(Sbk_DownloadManagerFunc_closeEvent), METH_O, nullptr},
    {"download", reinterpret_cast<PyCFunction>(Sbk_DownloadManagerFunc_download), METH_O, nullptr},
    {"downloadsCount", reinterpret_cast<PyCFunction>(Sbk_DownloadManagerFunc_downloadsCount), METH_NOARGS, nullptr},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_DownloadManagerFunc_keyPressEvent), METH_O, nullptr},
    {"loadSettings", reinterpret_cast<PyCFunction>(Sbk_DownloadManagerFunc_loadSettings), METH_NOARGS, nullptr},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_DownloadManagerFunc_resizeEvent), METH_O, nullptr},
    {"setLastDownloadOption", reinterpret_cast<PyCFunction>(Sbk_DownloadManagerFunc_setLastDownloadOption), METH_O, nullptr},
    {"setLastDownloadPath", reinterpret_cast<PyCFunction>(Sbk_DownloadManagerFunc_setLastDownloadPath), METH_O, nullptr},
    {"show", reinterpret_cast<PyCFunction>(Sbk_DownloadManagerFunc_show), METH_NOARGS, nullptr},
    {"startExternalManager", reinterpret_cast<PyCFunction>(Sbk_DownloadManagerFunc_startExternalManager), METH_O, nullptr},
    {"timerEvent", reinterpret_cast<PyCFunction>(Sbk_DownloadManagerFunc_timerEvent), METH_O, nullptr},
    {"useExternalManager", reinterpret_cast<PyCFunction>(Sbk_DownloadManagerFunc_useExternalManager), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_DownloadManager_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::DownloadManager *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<DownloadManagerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_DownloadManager_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_DownloadManager_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_DownloadManagerSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::DownloadManager *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_DownloadManager_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_DownloadManager_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_DownloadManager_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_DownloadManager_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_DownloadManager_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_DownloadManager_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_DownloadManager_spec = {
    "1:PyFalkon.DownloadManager",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_DownloadManager_slots
};

} //extern "C"

static void *Sbk_DownloadManager_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::DownloadManager *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::DownloadManager *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::DownloadManager *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_DownloadManager_DownloadOption(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::DownloadManager::DownloadOption>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::DownloadManager::DownloadOption *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_DownloadManager_DownloadOption_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadOption_IDX])))
        return Enum_PythonToCpp_DownloadManager_DownloadOption;
    return {};
}

static PyObject *DownloadManager_DownloadOption_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::DownloadManager::DownloadOption>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::DownloadManager::DownloadOption *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void DownloadManager_PythonToCpp_DownloadManager_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_DownloadManager_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_DownloadManager_PythonToCpp_DownloadManager_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_DownloadManager_TypeF()))
        return DownloadManager_PythonToCpp_DownloadManager_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *DownloadManager_PTR_CppToPython_DownloadManager(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::DownloadManager *>(const_cast<void *>(cppIn)), Sbk_DownloadManager_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *DownloadManager_SignatureStrings[] = {
    "PyFalkon.DownloadManager(self,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "PyFalkon.DownloadManager.activeDownloadsCount(self)->int",
    "PyFalkon.DownloadManager.canClose(self)->bool",
    "PyFalkon.DownloadManager.closeEvent(self,e:PySide6.QtGui.QCloseEvent)",
    "PyFalkon.DownloadManager.download(self,downloadItem:PySide6.QtWebEngineCore.QWebEngineDownloadRequest)",
    "PyFalkon.DownloadManager.downloadsCount(self)->int",
    "PyFalkon.DownloadManager.keyPressEvent(self,e:PySide6.QtGui.QKeyEvent)",
    "PyFalkon.DownloadManager.loadSettings(self)",
    "PyFalkon.DownloadManager.resizeEvent(self,e:PySide6.QtGui.QResizeEvent)",
    "PyFalkon.DownloadManager.setLastDownloadOption(self,option:PyFalkon.DownloadManager.DownloadOption)",
    "PyFalkon.DownloadManager.setLastDownloadPath(self,lastPath:QString)",
    "PyFalkon.DownloadManager.show(self)",
    "PyFalkon.DownloadManager.startExternalManager(self,url:typing.Union[PySide6.QtCore.QUrl, QString])",
    "PyFalkon.DownloadManager.timerEvent(self,e:PySide6.QtCore.QTimerEvent)",
    "PyFalkon.DownloadManager.useExternalManager(self)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t DownloadManager_SignatureByteSize = 314;
static constexpr uint8_t DownloadManager_SignatureBytes[314] = {
    0x78, 0xda, 0x95, 0x53, 0xcb, 0x4e, 0xc3, 0x30, 0x10, 0xbc, 0xf3, 0x15, 0x1c, 0xa9, 0x14, 0x72,
    0xe4, 0x10, 0x09, 0x2e, 0x21, 0x20, 0x04, 0x88, 0xa4, 0xa1, 0xe2, 0x80, 0x38, 0xb8, 0xcd, 0x92,
    0x5a, 0x75, 0xd7, 0xc1, 0x5e, 0xb7, 0x84, 0xaf, 0xc7, 0xa9, 0xe3, 0x3e, 0x24, 0xe2, 0x96, 0xdb,
    0xee, 0x6a, 0x76, 0x66, 0x76, 0x64, 0xe7, 0xed, 0x1d, 0x13, 0x0b, 0x89, 0xf1, 0xad, 0x5c, 0xa3,
    0x90, 0xac, 0x7a, 0x66, 0xc8, 0x6a, 0x50, 0x17, 0x1a, 0xc4, 0x67, 0xd4, 0x30, 0x05, 0x48, 0x49,
    0xde, 0x96, 0xbc, 0x82, 0xab, 0xb8, 0xa0, 0x37, 0x5e, 0xd5, 0x40, 0x3a, 0x2e, 0x5c, 0x71, 0x8d,
    0x46, 0x88, 0x86, 0xd4, 0xe8, 0x2c, 0x1f, 0xe0, 0x89, 0xd9, 0x8c, 0xf8, 0x0a, 0xfc, 0x54, 0xa7,
    0xd2, 0x20, 0x6d, 0xc8, 0x47, 0x97, 0x37, 0x1c, 0x69, 0x78, 0x71, 0xc6, 0x30, 0x15, 0x52, 0x83,
    0x07, 0x4f, 0xa5, 0x14, 0x01, 0x74, 0x07, 0xcd, 0x56, 0xd0, 0x93, 0x47, 0xb0, 0x67, 0xfa, 0xde,
    0xf0, 0xb8, 0x48, 0xb7, 0x80, 0x80, 0xd9, 0xaa, 0xef, 0x1d, 0x87, 0xef, 0x1e, 0x08, 0x96, 0xfb,
    0x19, 0xc0, 0x34, 0xc3, 0x9a, 0x23, 0xa4, 0x52, 0x81, 0x4d, 0xc2, 0xb7, 0x9e, 0x6c, 0x0c, 0x5f,
    0x06, 0xf4, 0x29, 0x32, 0xff, 0x48, 0x63, 0x01, 0x6d, 0xae, 0x40, 0xeb, 0xd0, 0x89, 0x8f, 0xd0,
    0x1e, 0x3b, 0xb0, 0xab, 0x4b, 0x20, 0xe2, 0x58, 0x6b, 0xa7, 0x3b, 0x8c, 0xb5, 0x72, 0xfc, 0x27,
    0x98, 0xe9, 0x78, 0x87, 0x08, 0xf0, 0x68, 0xa0, 0x27, 0xa6, 0xc9, 0x8f, 0x5f, 0x1a, 0xe2, 0x12,
    0x1d, 0xa3, 0xdc, 0xd4, 0xc9, 0xe0, 0xea, 0xe1, 0xce, 0xe9, 0x1a, 0x39, 0xa3, 0xb9, 0x53, 0x10,
    0x76, 0xda, 0x75, 0x49, 0x51, 0x92, 0xb2, 0x57, 0x87, 0x38, 0xe6, 0x72, 0x7d, 0x2c, 0x13, 0x4d,
    0x4c, 0x51, 0xf6, 0x4d, 0xa0, 0x90, 0x89, 0x83, 0xaf, 0x62, 0x94, 0x48, 0xa8, 0x6d, 0xac, 0x44,
    0x3c, 0x41, 0x6b, 0xf6, 0x7d, 0x97, 0x95, 0x7b, 0x27, 0x13, 0x25, 0xa2, 0xf3, 0xde, 0xc5, 0x47,
    0x40, 0x82, 0xf8, 0x12, 0xd4, 0x40, 0xea, 0x8e, 0xe9, 0x75, 0x8b, 0x08, 0xd0, 0x18, 0xfb, 0xda,
    0xff, 0xf0, 0xe9, 0x3f, 0xd2, 0x2f, 0xb4, 0x5e, 0x79, 0x03
};
#endif

PyTypeObject *init_DownloadManager(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX].type;

    Shiboken::AutoDecRef Sbk_DownloadManager_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_DownloadManager_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "DownloadManager",
        "DownloadManager*",
        &Sbk_DownloadManager_spec,
        &Shiboken::callCppDestructor< DownloadManager >,
        Sbk_DownloadManager_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_DownloadManager_TypeF(); // references _Sbk_DownloadManager_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, DownloadManager_SignatureStrings);
#else
    InitSignatureBytes(pyType, DownloadManager_SignatureBytes, DownloadManager_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_DownloadManager_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_DownloadManager_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        DownloadManager_PythonToCpp_DownloadManager_PTR,
        is_DownloadManager_PythonToCpp_DownloadManager_PTR_Convertible,
        DownloadManager_PTR_CppToPython_DownloadManager);

    Shiboken::Conversions::registerConverterName(converter, "DownloadManager");
    Shiboken::Conversions::registerConverterName(converter, "DownloadManager*");
    Shiboken::Conversions::registerConverterName(converter, "DownloadManager&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::DownloadManager).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(DownloadManagerWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_DownloadManager_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_DownloadManager_TypeF(), &Sbk_DownloadManagerSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_DownloadManager_TypeF(), &Sbk_DownloadManager_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_DownloadManager_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'DownloadOption'.
    const char *DownloadOption_Initializer[] = {
        "OpenFile",
        "SaveFile",
        "ExternalManager",
        "NoOption",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t DownloadOption_InitializerValues[] = {
        uint8_t(DownloadManager::DownloadOption::OpenFile),        //  0x00  0
        uint8_t(DownloadManager::DownloadOption::SaveFile),        //  0x01  1
        uint8_t(DownloadManager::DownloadOption::ExternalManager), //  0x02  2
        uint8_t(DownloadManager::DownloadOption::NoOption)         //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_DownloadManager_TypeF(),
        "1:PyFalkon.DownloadManager.DownloadOption",
        DownloadOption_Initializer, DownloadOption_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_DownloadManager_DownloadOption_IDX].type = EType;
    // Register converter for enum 'DownloadManager::DownloadOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            DownloadManager_DownloadOption_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_DownloadManager_DownloadOption,
            is_Enum_PythonToCpp_DownloadManager_DownloadOption_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "DownloadManager::DownloadOption");
        Shiboken::Conversions::registerConverterAlias(converter, "DownloadOption");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'DownloadOption' enum.

    PySide::Signal::registerSignals(pyType, &::DownloadManager::staticMetaObject);
    DownloadManagerWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::DownloadManager::staticMetaObject, sizeof(DownloadManagerWrapper));

    return pyType;
}
