/* Generated by wayland-scanner 1.24.0 */

#ifndef DDE_SEAT_SERVER_PROTOCOL_H
#define DDE_SEAT_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_dde_seat The dde_seat protocol
 * protocol to get global input events
 *
 * @section page_desc_dde_seat Description
 *
 *
 * @section page_ifaces_dde_seat Interfaces
 * - @subpage page_iface_dde_seat - get pointer objects
 * - @subpage page_iface_dde_pointer - relative pointer object
 * - @subpage page_iface_dde_keyboard - keyboard input device
 * - @subpage page_iface_dde_touch - touch input device
 * @section page_copyright_dde_seat Copyright
 * <pre>
 *
 * Copyright © 2020  wugang <wugang@uniontech.com>
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct dde_keyboard;
struct dde_pointer;
struct dde_seat;
struct dde_touch;
struct wl_surface;

#ifndef DDE_SEAT_INTERFACE
#define DDE_SEAT_INTERFACE
/**
 * @page page_iface_dde_seat dde_seat
 * @section page_iface_dde_seat_desc Description
 *
 * A global interface used for getting the global seat object for a
 * given input device.
 * @section page_iface_dde_seat_api API
 * See @ref iface_dde_seat.
 */
/**
 * @defgroup iface_dde_seat The dde_seat interface
 *
 * A global interface used for getting the global seat object for a
 * given input device.
 */
extern const struct wl_interface dde_seat_interface;
#endif
#ifndef DDE_POINTER_INTERFACE
#define DDE_POINTER_INTERFACE
/**
 * @page page_iface_dde_pointer dde_pointer
 * @section page_iface_dde_pointer_desc Description
 *
 * A dde_pointer object is an extension to the wl_pointer interface
 * used for emitting global pointer events.
 * @section page_iface_dde_pointer_api API
 * See @ref iface_dde_pointer.
 */
/**
 * @defgroup iface_dde_pointer The dde_pointer interface
 *
 * A dde_pointer object is an extension to the wl_pointer interface
 * used for emitting global pointer events.
 */
extern const struct wl_interface dde_pointer_interface;
#endif
#ifndef DDE_KEYBOARD_INTERFACE
#define DDE_KEYBOARD_INTERFACE
/**
 * @page page_iface_dde_keyboard dde_keyboard
 * @section page_iface_dde_keyboard_desc Description
 *
 * The wl_keyboard interface represents one or more keyboards
 * associated with a seat.
 * @section page_iface_dde_keyboard_api API
 * See @ref iface_dde_keyboard.
 */
/**
 * @defgroup iface_dde_keyboard The dde_keyboard interface
 *
 * The wl_keyboard interface represents one or more keyboards
 * associated with a seat.
 */
extern const struct wl_interface dde_keyboard_interface;
#endif
#ifndef DDE_TOUCH_INTERFACE
#define DDE_TOUCH_INTERFACE
/**
 * @page page_iface_dde_touch dde_touch
 * @section page_iface_dde_touch_desc Description
 *
 * The wl_touch interface represents one or more touchs
 * associated with a seat.
 * @section page_iface_dde_touch_api API
 * See @ref iface_dde_touch.
 */
/**
 * @defgroup iface_dde_touch The dde_touch interface
 *
 * The wl_touch interface represents one or more touchs
 * associated with a seat.
 */
extern const struct wl_interface dde_touch_interface;
#endif

/**
 * @ingroup iface_dde_seat
 * @struct dde_seat_interface
 */
struct dde_seat_interface {
	/**
	 * get a pointer object
	 *
	 * get a pointer through a global seat object
	 */
	void (*get_dde_pointer)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t id);
	/**
	 * return keyboard object
	 *
	 * The ID provided will be initialized to the dde_keyboard
	 * interface for this seat.
	 *
	 * This request only takes effect if the seat has the keyboard
	 * capability, or has had the keyboard capability in the past. It
	 * is a protocol violation to issue this request on a seat that has
	 * never had the keyboard capability. The missing_capability error
	 * will be sent in this case.
	 * @param id seat keyboard
	 */
	void (*get_dde_keyboard)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t id);
	/**
	 * get touch object
	 *
	 * get a touch through a global seat object
	 * @param id seat touch
	 */
	void (*get_dde_touch)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t id);
};


/**
 * @ingroup iface_dde_seat
 */
#define DDE_SEAT_GET_DDE_POINTER_SINCE_VERSION 1
/**
 * @ingroup iface_dde_seat
 */
#define DDE_SEAT_GET_DDE_KEYBOARD_SINCE_VERSION 1
/**
 * @ingroup iface_dde_seat
 */
#define DDE_SEAT_GET_DDE_TOUCH_SINCE_VERSION 1

#ifndef DDE_POINTER_BUTTON_STATE_ENUM
#define DDE_POINTER_BUTTON_STATE_ENUM
/**
 * @ingroup iface_dde_pointer
 * physical button state
 *
 * Describes the physical state of a button that produced the button
 * event.
 */
enum dde_pointer_button_state {
	/**
	 * the button is not pressed
	 */
	DDE_POINTER_BUTTON_STATE_RELEASED = 0,
	/**
	 * the button is pressed
	 */
	DDE_POINTER_BUTTON_STATE_PRESSED = 1,
};
#endif /* DDE_POINTER_BUTTON_STATE_ENUM */

#ifndef DDE_POINTER_BUTTON_STATE_ENUM_IS_VALID
#define DDE_POINTER_BUTTON_STATE_ENUM_IS_VALID
/**
 * @ingroup iface_dde_pointer
 * Validate a dde_pointer button_state value.
 *
 * @return true on success, false on error.
 * @ref dde_pointer_button_state
 */
static inline bool
dde_pointer_button_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_POINTER_BUTTON_STATE_RELEASED:
		return version >= 1;
	case DDE_POINTER_BUTTON_STATE_PRESSED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_POINTER_BUTTON_STATE_ENUM_IS_VALID */

#ifndef DDE_POINTER_AXIS_ENUM
#define DDE_POINTER_AXIS_ENUM
/**
 * @ingroup iface_dde_pointer
 * axis types
 *
 * Describes the axis types of scroll events.
 */
enum dde_pointer_axis {
	/**
	 * vertical axis
	 */
	DDE_POINTER_AXIS_VERTICAL_SCROLL = 0,
	/**
	 * horizontal axis
	 */
	DDE_POINTER_AXIS_HORIZONTAL_SCROLL = 1,
};
#endif /* DDE_POINTER_AXIS_ENUM */

#ifndef DDE_POINTER_AXIS_ENUM_IS_VALID
#define DDE_POINTER_AXIS_ENUM_IS_VALID
/**
 * @ingroup iface_dde_pointer
 * Validate a dde_pointer axis value.
 *
 * @return true on success, false on error.
 * @ref dde_pointer_axis
 */
static inline bool
dde_pointer_axis_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_POINTER_AXIS_VERTICAL_SCROLL:
		return version >= 1;
	case DDE_POINTER_AXIS_HORIZONTAL_SCROLL:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_POINTER_AXIS_ENUM_IS_VALID */

/**
 * @ingroup iface_dde_pointer
 * @struct dde_pointer_interface
 */
struct dde_pointer_interface {
	/**
	 * get a global cursor position
	 *
	 * client request server to send a global cursor position
	 */
	void (*get_motion)(struct wl_client *client,
			   struct wl_resource *resource);
};

#define DDE_POINTER_MOTION 0
#define DDE_POINTER_BUTTON 1
#define DDE_POINTER_AXIS 2

/**
 * @ingroup iface_dde_pointer
 */
#define DDE_POINTER_MOTION_SINCE_VERSION 1
/**
 * @ingroup iface_dde_pointer
 */
#define DDE_POINTER_BUTTON_SINCE_VERSION 1
/**
 * @ingroup iface_dde_pointer
 */
#define DDE_POINTER_AXIS_SINCE_VERSION 1

/**
 * @ingroup iface_dde_pointer
 */
#define DDE_POINTER_GET_MOTION_SINCE_VERSION 1

/**
 * @ingroup iface_dde_pointer
 * Sends an motion event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x global x coordinate
 * @param y global y coordinate
 */
static inline void
dde_pointer_send_motion(struct wl_resource *resource_, wl_fixed_t x, wl_fixed_t y)
{
	wl_resource_post_event(resource_, DDE_POINTER_MOTION, x, y);
}

/**
 * @ingroup iface_dde_pointer
 * Sends an button event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x global x coordinate
 * @param y global y coordinate
 * @param button button that produced the event
 * @param state physical state of the button
 */
static inline void
dde_pointer_send_button(struct wl_resource *resource_, wl_fixed_t x, wl_fixed_t y, uint32_t button, uint32_t state)
{
	wl_resource_post_event(resource_, DDE_POINTER_BUTTON, x, y, button, state);
}

/**
 * @ingroup iface_dde_pointer
 * Sends an axis event to the client owning the resource.
 * @param resource_ The client's resource
 * @param time timestamp with millisecond granularity
 * @param axis axis type
 * @param value length of vector in surface-local coordinate space
 */
static inline void
dde_pointer_send_axis(struct wl_resource *resource_, uint32_t time, uint32_t axis, wl_fixed_t value)
{
	wl_resource_post_event(resource_, DDE_POINTER_AXIS, time, axis, value);
}

#ifndef DDE_KEYBOARD_KEYMAP_FORMAT_ENUM
#define DDE_KEYBOARD_KEYMAP_FORMAT_ENUM
/**
 * @ingroup iface_dde_keyboard
 * keyboard mapping format
 *
 * This specifies the format of the keymap provided to the
 * client with the wl_keyboard.keymap event.
 */
enum dde_keyboard_keymap_format {
	/**
	 * no keymap; client must understand how to interpret the raw keycode
	 */
	DDE_KEYBOARD_KEYMAP_FORMAT_NO_KEYMAP = 0,
	/**
	 * libxkbcommon compatible; to determine the xkb keycode, clients must add 8 to the key event keycode
	 */
	DDE_KEYBOARD_KEYMAP_FORMAT_XKB_V1 = 1,
};
#endif /* DDE_KEYBOARD_KEYMAP_FORMAT_ENUM */

#ifndef DDE_KEYBOARD_KEYMAP_FORMAT_ENUM_IS_VALID
#define DDE_KEYBOARD_KEYMAP_FORMAT_ENUM_IS_VALID
/**
 * @ingroup iface_dde_keyboard
 * Validate a dde_keyboard keymap_format value.
 *
 * @return true on success, false on error.
 * @ref dde_keyboard_keymap_format
 */
static inline bool
dde_keyboard_keymap_format_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_KEYBOARD_KEYMAP_FORMAT_NO_KEYMAP:
		return version >= 1;
	case DDE_KEYBOARD_KEYMAP_FORMAT_XKB_V1:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_KEYBOARD_KEYMAP_FORMAT_ENUM_IS_VALID */

#ifndef DDE_KEYBOARD_KEY_STATE_ENUM
#define DDE_KEYBOARD_KEY_STATE_ENUM
/**
 * @ingroup iface_dde_keyboard
 * physical key state
 *
 * Describes the physical state of a key that produced the key event.
 */
enum dde_keyboard_key_state {
	/**
	 * key is not pressed
	 */
	DDE_KEYBOARD_KEY_STATE_RELEASED = 0,
	/**
	 * key is pressed
	 */
	DDE_KEYBOARD_KEY_STATE_PRESSED = 1,
};
#endif /* DDE_KEYBOARD_KEY_STATE_ENUM */

#ifndef DDE_KEYBOARD_KEY_STATE_ENUM_IS_VALID
#define DDE_KEYBOARD_KEY_STATE_ENUM_IS_VALID
/**
 * @ingroup iface_dde_keyboard
 * Validate a dde_keyboard key_state value.
 *
 * @return true on success, false on error.
 * @ref dde_keyboard_key_state
 */
static inline bool
dde_keyboard_key_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_KEYBOARD_KEY_STATE_RELEASED:
		return version >= 1;
	case DDE_KEYBOARD_KEY_STATE_PRESSED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_KEYBOARD_KEY_STATE_ENUM_IS_VALID */

/**
 * @ingroup iface_dde_keyboard
 * @struct dde_keyboard_interface
 */
struct dde_keyboard_interface {
	/**
	 * release the keyboard object
	 *
	 * 
	 * @since 3
	 */
	void (*release)(struct wl_client *client,
			struct wl_resource *resource);
};

#define DDE_KEYBOARD_KEYMAP 0
#define DDE_KEYBOARD_ENTER 1
#define DDE_KEYBOARD_LEAVE 2
#define DDE_KEYBOARD_KEY 3
#define DDE_KEYBOARD_MODIFIERS 4
#define DDE_KEYBOARD_REPEAT_INFO 5

/**
 * @ingroup iface_dde_keyboard
 */
#define DDE_KEYBOARD_KEYMAP_SINCE_VERSION 1
/**
 * @ingroup iface_dde_keyboard
 */
#define DDE_KEYBOARD_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_dde_keyboard
 */
#define DDE_KEYBOARD_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_dde_keyboard
 */
#define DDE_KEYBOARD_KEY_SINCE_VERSION 1
/**
 * @ingroup iface_dde_keyboard
 */
#define DDE_KEYBOARD_MODIFIERS_SINCE_VERSION 1
/**
 * @ingroup iface_dde_keyboard
 */
#define DDE_KEYBOARD_REPEAT_INFO_SINCE_VERSION 4

/**
 * @ingroup iface_dde_keyboard
 */
#define DDE_KEYBOARD_RELEASE_SINCE_VERSION 3

/**
 * @ingroup iface_dde_keyboard
 * Sends an keymap event to the client owning the resource.
 * @param resource_ The client's resource
 * @param format keymap format
 * @param fd keymap file descriptor
 * @param size keymap size, in bytes
 */
static inline void
dde_keyboard_send_keymap(struct wl_resource *resource_, uint32_t format, int32_t fd, uint32_t size)
{
	wl_resource_post_event(resource_, DDE_KEYBOARD_KEYMAP, format, fd, size);
}

/**
 * @ingroup iface_dde_keyboard
 * Sends an enter event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial serial number of the enter event
 * @param surface surface gaining keyboard focus
 * @param keys the currently pressed keys
 */
static inline void
dde_keyboard_send_enter(struct wl_resource *resource_, uint32_t serial, struct wl_resource *surface, struct wl_array *keys)
{
	wl_resource_post_event(resource_, DDE_KEYBOARD_ENTER, serial, surface, keys);
}

/**
 * @ingroup iface_dde_keyboard
 * Sends an leave event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial serial number of the leave event
 * @param surface surface that lost keyboard focus
 */
static inline void
dde_keyboard_send_leave(struct wl_resource *resource_, uint32_t serial, struct wl_resource *surface)
{
	wl_resource_post_event(resource_, DDE_KEYBOARD_LEAVE, serial, surface);
}

/**
 * @ingroup iface_dde_keyboard
 * Sends an key event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial serial number of the key event
 * @param time timestamp with millisecond granularity
 * @param key key that produced the event
 * @param state physical state of the key
 */
static inline void
dde_keyboard_send_key(struct wl_resource *resource_, uint32_t serial, uint32_t time, uint32_t key, uint32_t state)
{
	wl_resource_post_event(resource_, DDE_KEYBOARD_KEY, serial, time, key, state);
}

/**
 * @ingroup iface_dde_keyboard
 * Sends an modifiers event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial serial number of the modifiers event
 * @param mods_depressed depressed modifiers
 * @param mods_latched latched modifiers
 * @param mods_locked locked modifiers
 * @param group keyboard layout
 */
static inline void
dde_keyboard_send_modifiers(struct wl_resource *resource_, uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group)
{
	wl_resource_post_event(resource_, DDE_KEYBOARD_MODIFIERS, serial, mods_depressed, mods_latched, mods_locked, group);
}

/**
 * @ingroup iface_dde_keyboard
 * Sends an repeat_info event to the client owning the resource.
 * @param resource_ The client's resource
 * @param rate the rate of repeating keys in characters per second
 * @param delay delay in milliseconds since key down until repeating starts
 */
static inline void
dde_keyboard_send_repeat_info(struct wl_resource *resource_, int32_t rate, int32_t delay)
{
	wl_resource_post_event(resource_, DDE_KEYBOARD_REPEAT_INFO, rate, delay);
}

/**
 * @ingroup iface_dde_touch
 * @struct dde_touch_interface
 */
struct dde_touch_interface {
	/**
	 * release the touch object
	 *
	 * 
	 * @since 3
	 */
	void (*release)(struct wl_client *client,
			struct wl_resource *resource);
};

#define DDE_TOUCH_DOWN 0
#define DDE_TOUCH_UP 1
#define DDE_TOUCH_MOTION 2

/**
 * @ingroup iface_dde_touch
 */
#define DDE_TOUCH_DOWN_SINCE_VERSION 1
/**
 * @ingroup iface_dde_touch
 */
#define DDE_TOUCH_UP_SINCE_VERSION 1
/**
 * @ingroup iface_dde_touch
 */
#define DDE_TOUCH_MOTION_SINCE_VERSION 1

/**
 * @ingroup iface_dde_touch
 */
#define DDE_TOUCH_RELEASE_SINCE_VERSION 3

/**
 * @ingroup iface_dde_touch
 * Sends an down event to the client owning the resource.
 * @param resource_ The client's resource
 * @param id id of the touch down event
 * @param time timestamp with millisecond granularity
 * @param x global x coordinate
 * @param y global y coordinate
 */
static inline void
dde_touch_send_down(struct wl_resource *resource_, int32_t id, uint32_t time, wl_fixed_t x, wl_fixed_t y)
{
	wl_resource_post_event(resource_, DDE_TOUCH_DOWN, id, time, x, y);
}

/**
 * @ingroup iface_dde_touch
 * Sends an up event to the client owning the resource.
 * @param resource_ The client's resource
 * @param id id of the touch up event
 * @param time timestamp with millisecond granularity
 */
static inline void
dde_touch_send_up(struct wl_resource *resource_, int32_t id, uint32_t time)
{
	wl_resource_post_event(resource_, DDE_TOUCH_UP, id, time);
}

/**
 * @ingroup iface_dde_touch
 * Sends an motion event to the client owning the resource.
 * @param resource_ The client's resource
 * @param id id of the touch motion event
 * @param time timestamp with millisecond granularity
 * @param x global x coordinate
 * @param y global y coordinate
 */
static inline void
dde_touch_send_motion(struct wl_resource *resource_, int32_t id, uint32_t time, wl_fixed_t x, wl_fixed_t y)
{
	wl_resource_post_event(resource_, DDE_TOUCH_MOTION, id, time, x, y);
}

#ifdef  __cplusplus
}
#endif

#endif
