/* settings_plugin_chooser.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from settings_plugin_chooser.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <libpeas/peas.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER_ITEM (budgie_settings_plugin_chooser_item_get_type ())
#define BUDGIE_SETTINGS_PLUGIN_CHOOSER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER_ITEM, BudgieSettingsPluginChooserItem))
#define BUDGIE_SETTINGS_PLUGIN_CHOOSER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER_ITEM, BudgieSettingsPluginChooserItemClass))
#define BUDGIE_IS_SETTINGS_PLUGIN_CHOOSER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER_ITEM))
#define BUDGIE_IS_SETTINGS_PLUGIN_CHOOSER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER_ITEM))
#define BUDGIE_SETTINGS_PLUGIN_CHOOSER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER_ITEM, BudgieSettingsPluginChooserItemClass))

typedef struct _BudgieSettingsPluginChooserItem BudgieSettingsPluginChooserItem;
typedef struct _BudgieSettingsPluginChooserItemClass BudgieSettingsPluginChooserItemClass;
typedef struct _BudgieSettingsPluginChooserItemPrivate BudgieSettingsPluginChooserItemPrivate;
enum  {
	BUDGIE_SETTINGS_PLUGIN_CHOOSER_ITEM_0_PROPERTY,
	BUDGIE_SETTINGS_PLUGIN_CHOOSER_ITEM_PLUGIN_PROPERTY,
	BUDGIE_SETTINGS_PLUGIN_CHOOSER_ITEM_NUM_PROPERTIES
};
static GParamSpec* budgie_settings_plugin_chooser_item_properties[BUDGIE_SETTINGS_PLUGIN_CHOOSER_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER (budgie_settings_plugin_chooser_get_type ())
#define BUDGIE_SETTINGS_PLUGIN_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER, BudgieSettingsPluginChooser))
#define BUDGIE_SETTINGS_PLUGIN_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER, BudgieSettingsPluginChooserClass))
#define BUDGIE_IS_SETTINGS_PLUGIN_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER))
#define BUDGIE_IS_SETTINGS_PLUGIN_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER))
#define BUDGIE_SETTINGS_PLUGIN_CHOOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER, BudgieSettingsPluginChooserClass))

typedef struct _BudgieSettingsPluginChooser BudgieSettingsPluginChooser;
typedef struct _BudgieSettingsPluginChooserClass BudgieSettingsPluginChooserClass;
typedef struct _BudgieSettingsPluginChooserPrivate BudgieSettingsPluginChooserPrivate;
enum  {
	BUDGIE_SETTINGS_PLUGIN_CHOOSER_0_PROPERTY,
	BUDGIE_SETTINGS_PLUGIN_CHOOSER_NUM_PROPERTIES
};
static GParamSpec* budgie_settings_plugin_chooser_properties[BUDGIE_SETTINGS_PLUGIN_CHOOSER_NUM_PROPERTIES];
#define __vala_PeasPluginInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL)))

struct _BudgieSettingsPluginChooserItem {
	GtkBox parent_instance;
	BudgieSettingsPluginChooserItemPrivate * priv;
};

struct _BudgieSettingsPluginChooserItemClass {
	GtkBoxClass parent_class;
};

struct _BudgieSettingsPluginChooserItemPrivate {
	PeasPluginInfo* _plugin;
	GtkImage* image;
	GtkLabel* label;
};

struct _BudgieSettingsPluginChooser {
	GtkDialog parent_instance;
	BudgieSettingsPluginChooserPrivate * priv;
};

struct _BudgieSettingsPluginChooserClass {
	GtkDialogClass parent_class;
};

struct _BudgieSettingsPluginChooserPrivate {
	GtkListBox* applets;
	GtkWidget* button_ok;
	GtkImage* selected_plugin_icon;
	GtkLabel* selected_plugin_name;
	GtkLabel* selected_plugin_description;
	GtkLabel* selected_plugin_authors;
	GtkLabel* selected_plugin_copyright;
	GtkLabel* selected_plugin_website;
	gchar* applet_id;
	gboolean use_applet_name;
};

static gint BudgieSettingsPluginChooserItem_private_offset;
static gpointer budgie_settings_plugin_chooser_item_parent_class = NULL;
static gint BudgieSettingsPluginChooser_private_offset;
static gpointer budgie_settings_plugin_chooser_parent_class = NULL;

VALA_EXTERN GType budgie_settings_plugin_chooser_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsPluginChooserItem, g_object_unref)
VALA_EXTERN BudgieSettingsPluginChooserItem* budgie_settings_plugin_chooser_item_new (PeasPluginInfo* info);
VALA_EXTERN BudgieSettingsPluginChooserItem* budgie_settings_plugin_chooser_item_construct (GType object_type,
                                                                                PeasPluginInfo* info);
VALA_EXTERN PeasPluginInfo* budgie_settings_plugin_chooser_item_get_plugin (BudgieSettingsPluginChooserItem* self);
VALA_EXTERN void budgie_settings_plugin_chooser_item_set_plugin (BudgieSettingsPluginChooserItem* self,
                                                     PeasPluginInfo* value);
static void budgie_settings_plugin_chooser_item_finalize (GObject * obj);
static GType budgie_settings_plugin_chooser_item_get_type_once (void);
static void _vala_budgie_settings_plugin_chooser_item_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec);
static void _vala_budgie_settings_plugin_chooser_item_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec);
VALA_EXTERN GType budgie_settings_plugin_chooser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsPluginChooser, g_object_unref)
VALA_EXTERN BudgieSettingsPluginChooser* budgie_settings_plugin_chooser_new (GtkWindow* parent,
                                                                 gboolean use_applet_name);
VALA_EXTERN BudgieSettingsPluginChooser* budgie_settings_plugin_chooser_construct (GType object_type,
                                                                       GtkWindow* parent,
                                                                       gboolean use_applet_name);
static gint budgie_settings_plugin_chooser_sort_applets (BudgieSettingsPluginChooser* self,
                                                  GtkListBoxRow* a,
                                                  GtkListBoxRow* b);
static gint _budgie_settings_plugin_chooser_sort_applets_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                          GtkListBoxRow* row2,
                                                                          gpointer self);
static void budgie_settings_plugin_chooser_row_selected (BudgieSettingsPluginChooser* self,
                                                  GtkListBoxRow* row);
static void _budgie_settings_plugin_chooser_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                             GtkListBoxRow* row,
                                                                             gpointer self);
static void budgie_settings_plugin_chooser_row_activated (BudgieSettingsPluginChooser* self,
                                                   GtkListBoxRow* row);
static void _budgie_settings_plugin_chooser_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                               GtkListBoxRow* row,
                                                                               gpointer self);
VALA_EXTERN gchar* budgie_settings_plugin_chooser_run (BudgieSettingsPluginChooser* self);
static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
VALA_EXTERN void budgie_settings_plugin_chooser_set_plugin_list (BudgieSettingsPluginChooser* self,
                                                     GList* plugins);
static void budgie_settings_plugin_chooser_add_plugin (BudgieSettingsPluginChooser* self,
                                                PeasPluginInfo* plugin);
static void budgie_settings_plugin_chooser_finalize (GObject * obj);
static GType budgie_settings_plugin_chooser_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
budgie_settings_plugin_chooser_item_get_instance_private (BudgieSettingsPluginChooserItem* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieSettingsPluginChooserItem_private_offset);
}

/**
* Construct a new SettingsPluginChooserItem for the given widget
*/
BudgieSettingsPluginChooserItem*
budgie_settings_plugin_chooser_item_construct (GType object_type,
                                               PeasPluginInfo* info)
{
	BudgieSettingsPluginChooserItem * self = NULL;
	GtkStyleContext* _tmp0_;
	const gchar* _tmp1_;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkBox* label_box = NULL;
	GtkBox* _tmp6_;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GtkBox* _tmp14_;
	GtkLabel* _tmp15_;
	GtkImage* _tmp25_;
	GtkBox* _tmp26_;
	self = (BudgieSettingsPluginChooserItem*) g_object_new (object_type, "plugin", info, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "plugin-item");
	gtk_widget_set_margin_top ((GtkWidget*) self, 4);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 4);
	_tmp1_ = peas_plugin_info_get_icon_name (info);
	_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp1_, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp2_;
	_tmp3_ = self->priv->image;
	gtk_image_set_pixel_size (_tmp3_, 32);
	_tmp4_ = self->priv->image;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 8);
	_tmp5_ = self->priv->image;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp5_, 12);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp6_);
	label_box = _tmp6_;
	_tmp7_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_CENTER);
	gtk_label_set_xalign (_tmp7_, 0.0f);
	gtk_label_set_max_width_chars (_tmp7_, 1);
	gtk_label_set_ellipsize (_tmp7_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp7_, TRUE);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp7_;
	_tmp8_ = self->priv->label;
	_tmp9_ = peas_plugin_info_get_name (info);
	_tmp10_ = g_markup_escape_text (_tmp9_, (gssize) -1);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("<b>%s</b>", _tmp11_);
	_tmp13_ = _tmp12_;
	gtk_label_set_markup (_tmp8_, _tmp13_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp14_ = label_box;
	_tmp15_ = self->priv->label;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	if (peas_plugin_info_is_builtin (info)) {
		GtkLabel* builtin = NULL;
		GtkLabel* _tmp16_ = NULL;
		GtkLabel* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GtkLabel* _tmp20_;
		GtkStyleContext* _tmp21_;
		GtkBox* _tmp22_;
		GtkLabel* _tmp23_;
		_tmp16_ = (GtkLabel*) gtk_label_new (NULL);
		gtk_widget_set_valign ((GtkWidget*) _tmp16_, GTK_ALIGN_CENTER);
		gtk_label_set_xalign (_tmp16_, 0.0f);
		gtk_label_set_max_width_chars (_tmp16_, 1);
		gtk_label_set_ellipsize (_tmp16_, PANGO_ELLIPSIZE_END);
		gtk_widget_set_hexpand ((GtkWidget*) _tmp16_, TRUE);
		g_object_ref_sink (_tmp16_);
		builtin = _tmp16_;
		_tmp17_ = builtin;
		_tmp18_ = g_strdup_printf ("<i><small>%s</small></i>", _ ("Built-in"));
		_tmp19_ = _tmp18_;
		gtk_label_set_markup (_tmp17_, _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = builtin;
		_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _tmp20_);
		gtk_style_context_add_class (_tmp21_, "dim-label");
		_tmp22_ = label_box;
		_tmp23_ = builtin;
		gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
		_g_object_unref0 (builtin);
	} else {
		GtkLabel* _tmp24_;
		_tmp24_ = self->priv->label;
		gtk_widget_set_vexpand ((GtkWidget*) _tmp24_, TRUE);
	}
	_tmp25_ = self->priv->image;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp25_);
	_tmp26_ = label_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp26_);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (label_box);
	return self;
}

BudgieSettingsPluginChooserItem*
budgie_settings_plugin_chooser_item_new (PeasPluginInfo* info)
{
	return budgie_settings_plugin_chooser_item_construct (BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER_ITEM, info);
}

PeasPluginInfo*
budgie_settings_plugin_chooser_item_get_plugin (BudgieSettingsPluginChooserItem* self)
{
	PeasPluginInfo* result;
	PeasPluginInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plugin;
	result = _tmp0_;
	return result;
}

void
budgie_settings_plugin_chooser_item_set_plugin (BudgieSettingsPluginChooserItem* self,
                                                PeasPluginInfo* value)
{
	PeasPluginInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_settings_plugin_chooser_item_get_plugin (self);
	if (old_value != value) {
		self->priv->_plugin = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_settings_plugin_chooser_item_properties[BUDGIE_SETTINGS_PLUGIN_CHOOSER_ITEM_PLUGIN_PROPERTY]);
	}
}

static void
budgie_settings_plugin_chooser_item_class_init (BudgieSettingsPluginChooserItemClass * klass,
                                                gpointer klass_data)
{
	budgie_settings_plugin_chooser_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieSettingsPluginChooserItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_settings_plugin_chooser_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_settings_plugin_chooser_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_settings_plugin_chooser_item_finalize;
	/**
	* We're bound to the info
	*/
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_SETTINGS_PLUGIN_CHOOSER_ITEM_PLUGIN_PROPERTY, budgie_settings_plugin_chooser_item_properties[BUDGIE_SETTINGS_PLUGIN_CHOOSER_ITEM_PLUGIN_PROPERTY] = g_param_spec_boxed ("plugin", "plugin", "plugin", peas_plugin_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
budgie_settings_plugin_chooser_item_instance_init (BudgieSettingsPluginChooserItem * self,
                                                   gpointer klass)
{
	self->priv = budgie_settings_plugin_chooser_item_get_instance_private (self);
}

static void
budgie_settings_plugin_chooser_item_finalize (GObject * obj)
{
	BudgieSettingsPluginChooserItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER_ITEM, BudgieSettingsPluginChooserItem);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->label);
	G_OBJECT_CLASS (budgie_settings_plugin_chooser_item_parent_class)->finalize (obj);
}

/**
* SettingsPluginChooserItem is used to represent a plugin for the user to add to their
* panel or raven through the applet or widget API
*/
static GType
budgie_settings_plugin_chooser_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieSettingsPluginChooserItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_settings_plugin_chooser_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieSettingsPluginChooserItem), 0, (GInstanceInitFunc) budgie_settings_plugin_chooser_item_instance_init, NULL };
	GType budgie_settings_plugin_chooser_item_type_id;
	budgie_settings_plugin_chooser_item_type_id = g_type_register_static (gtk_box_get_type (), "BudgieSettingsPluginChooserItem", &g_define_type_info, 0);
	BudgieSettingsPluginChooserItem_private_offset = g_type_add_instance_private (budgie_settings_plugin_chooser_item_type_id, sizeof (BudgieSettingsPluginChooserItemPrivate));
	return budgie_settings_plugin_chooser_item_type_id;
}

GType
budgie_settings_plugin_chooser_item_get_type (void)
{
	static volatile gsize budgie_settings_plugin_chooser_item_type_id__once = 0;
	if (g_once_init_enter (&budgie_settings_plugin_chooser_item_type_id__once)) {
		GType budgie_settings_plugin_chooser_item_type_id;
		budgie_settings_plugin_chooser_item_type_id = budgie_settings_plugin_chooser_item_get_type_once ();
		g_once_init_leave (&budgie_settings_plugin_chooser_item_type_id__once, budgie_settings_plugin_chooser_item_type_id);
	}
	return budgie_settings_plugin_chooser_item_type_id__once;
}

static void
_vala_budgie_settings_plugin_chooser_item_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec)
{
	BudgieSettingsPluginChooserItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER_ITEM, BudgieSettingsPluginChooserItem);
	switch (property_id) {
		case BUDGIE_SETTINGS_PLUGIN_CHOOSER_ITEM_PLUGIN_PROPERTY:
		g_value_set_boxed (value, budgie_settings_plugin_chooser_item_get_plugin (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_settings_plugin_chooser_item_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec)
{
	BudgieSettingsPluginChooserItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER_ITEM, BudgieSettingsPluginChooserItem);
	switch (property_id) {
		case BUDGIE_SETTINGS_PLUGIN_CHOOSER_ITEM_PLUGIN_PROPERTY:
		budgie_settings_plugin_chooser_item_set_plugin (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
budgie_settings_plugin_chooser_get_instance_private (BudgieSettingsPluginChooser* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieSettingsPluginChooser_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
_budgie_settings_plugin_chooser_sort_applets_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                     GtkListBoxRow* row2,
                                                                     gpointer self)
{
	gint result;
	result = budgie_settings_plugin_chooser_sort_applets ((BudgieSettingsPluginChooser*) self, row1, row2);
	return result;
}

static void
_budgie_settings_plugin_chooser_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                        GtkListBoxRow* row,
                                                                        gpointer self)
{
	budgie_settings_plugin_chooser_row_selected ((BudgieSettingsPluginChooser*) self, row);
}

static void
_budgie_settings_plugin_chooser_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                          GtkListBoxRow* row,
                                                                          gpointer self)
{
	budgie_settings_plugin_chooser_row_activated ((BudgieSettingsPluginChooser*) self, row);
}

BudgieSettingsPluginChooser*
budgie_settings_plugin_chooser_construct (GType object_type,
                                          GtkWindow* parent,
                                          gboolean use_applet_name)
{
	BudgieSettingsPluginChooser * self = NULL;
	GtkBox* content_area = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBox* _tmp10_;
	GtkListBox* _tmp11_;
	GtkListBox* _tmp12_;
	GtkListBox* _tmp13_;
	GtkListBox* _tmp14_;
	GtkImage* _tmp15_;
	GtkImage* _tmp16_;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_ = NULL;
	GtkLabel* _tmp21_;
	GtkStyleContext* _tmp22_;
	GtkLabel* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkLabel* _tmp25_;
	GtkStyleContext* _tmp26_;
	GtkBox* upper_text_box = NULL;
	GtkBox* _tmp27_;
	GtkLabel* _tmp28_;
	GtkLabel* _tmp29_;
	GtkLabel* _tmp30_;
	GtkBox* upper_box = NULL;
	GtkBox* _tmp31_;
	GtkImage* _tmp32_;
	GtkBox* plugin_info_box = NULL;
	GtkBox* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (BudgieSettingsPluginChooser*) g_object_new (object_type, "use-header-bar", 1, "modal", TRUE, "title", _ ("Choose a plugin"), "transient-for", parent, "resizable", FALSE, NULL);
	self->priv->use_applet_name = use_applet_name;
	_tmp0_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_box_get_type ()) ? ((GtkBox*) _tmp0_) : NULL);
	content_area = _tmp1_;
	gtk_orientable_set_orientation ((GtkOrientable*) content_area, GTK_ORIENTATION_HORIZONTAL);
	gtk_dialog_add_button ((GtkDialog*) self, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp2_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Add"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->button_ok);
	self->priv->button_ok = _tmp3_;
	_tmp4_ = self->priv->button_ok;
	gtk_widget_set_sensitive (_tmp4_, FALSE);
	_tmp5_ = self->priv->button_ok;
	_tmp6_ = gtk_widget_get_style_context (_tmp5_);
	gtk_style_context_add_class (_tmp6_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp7_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp7_);
	scroll = _tmp7_;
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp8_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->applets);
	self->priv->applets = _tmp8_;
	_tmp9_ = self->priv->applets;
	gtk_widget_set_size_request ((GtkWidget*) _tmp9_, 225, -1);
	_tmp10_ = self->priv->applets;
	gtk_list_box_set_activate_on_single_click (_tmp10_, FALSE);
	_tmp11_ = self->priv->applets;
	gtk_list_box_set_sort_func (_tmp11_, _budgie_settings_plugin_chooser_sort_applets_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp12_ = self->priv->applets;
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->applets;
	g_signal_connect_object (_tmp13_, "row-selected", (GCallback) _budgie_settings_plugin_chooser_row_selected_gtk_list_box_row_selected, self, 0);
	_tmp14_ = self->priv->applets;
	g_signal_connect_object (_tmp14_, "row-activated", (GCallback) _budgie_settings_plugin_chooser_row_activated_gtk_list_box_row_activated, self, 0);
	gtk_box_pack_start (content_area, (GtkWidget*) scroll, FALSE, FALSE, (guint) 0);
	_tmp15_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->selected_plugin_icon);
	self->priv->selected_plugin_icon = _tmp15_;
	_tmp16_ = self->priv->selected_plugin_icon;
	gtk_image_set_pixel_size (_tmp16_, 64);
	_tmp17_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_CENTER);
	gtk_label_set_xalign (_tmp17_, 0.0f);
	gtk_label_set_max_width_chars (_tmp17_, 1);
	gtk_label_set_ellipsize (_tmp17_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp17_, TRUE);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->selected_plugin_name);
	self->priv->selected_plugin_name = _tmp17_;
	_tmp18_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_xalign (_tmp18_, 0.0f);
	g_object_set (_tmp18_, "wrap", TRUE, NULL);
	g_object_set (_tmp18_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	gtk_label_set_max_width_chars (_tmp18_, 1);
	gtk_label_set_justify (_tmp18_, GTK_JUSTIFY_LEFT);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp18_, TRUE);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->selected_plugin_description);
	self->priv->selected_plugin_description = _tmp18_;
	_tmp19_ = self->priv->selected_plugin_description;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp19_, 4);
	_tmp20_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_valign ((GtkWidget*) _tmp20_, GTK_ALIGN_CENTER);
	gtk_label_set_xalign (_tmp20_, 0.0f);
	gtk_label_set_max_width_chars (_tmp20_, 1);
	gtk_label_set_ellipsize (_tmp20_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp20_, TRUE);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->selected_plugin_authors);
	self->priv->selected_plugin_authors = _tmp20_;
	_tmp21_ = self->priv->selected_plugin_authors;
	_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) _tmp21_);
	gtk_style_context_add_class (_tmp22_, "dim-label");
	_tmp23_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_valign ((GtkWidget*) _tmp23_, GTK_ALIGN_CENTER);
	gtk_label_set_xalign (_tmp23_, 0.0f);
	gtk_label_set_max_width_chars (_tmp23_, 1);
	gtk_label_set_ellipsize (_tmp23_, PANGO_ELLIPSIZE_END);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp23_, TRUE);
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->selected_plugin_website);
	self->priv->selected_plugin_website = _tmp23_;
	_tmp24_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_valign ((GtkWidget*) _tmp24_, GTK_ALIGN_CENTER);
	g_object_set (_tmp24_, "wrap", TRUE, NULL);
	g_object_set (_tmp24_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	gtk_label_set_max_width_chars (_tmp24_, 1);
	gtk_label_set_justify (_tmp24_, GTK_JUSTIFY_CENTER);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp24_, TRUE);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->selected_plugin_copyright);
	self->priv->selected_plugin_copyright = _tmp24_;
	_tmp25_ = self->priv->selected_plugin_copyright;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
	gtk_style_context_add_class (_tmp26_, "dim-label");
	_tmp27_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 2);
	g_object_ref_sink (_tmp27_);
	upper_text_box = _tmp27_;
	gtk_widget_set_valign ((GtkWidget*) upper_text_box, GTK_ALIGN_START);
	_tmp28_ = self->priv->selected_plugin_name;
	gtk_container_add ((GtkContainer*) upper_text_box, (GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->selected_plugin_authors;
	gtk_box_pack_start (upper_text_box, (GtkWidget*) _tmp29_, FALSE, FALSE, (guint) 0);
	_tmp30_ = self->priv->selected_plugin_website;
	gtk_box_pack_start (upper_text_box, (GtkWidget*) _tmp30_, FALSE, FALSE, (guint) 0);
	_tmp31_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp31_);
	upper_box = _tmp31_;
	_tmp32_ = self->priv->selected_plugin_icon;
	gtk_box_pack_start (upper_box, (GtkWidget*) _tmp32_, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (upper_box, (GtkWidget*) upper_text_box, TRUE, TRUE, (guint) 0);
	_tmp33_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp33_);
	plugin_info_box = _tmp33_;
	gtk_container_set_border_width ((GtkContainer*) plugin_info_box, (guint) 8);
	gtk_widget_set_margin_start ((GtkWidget*) plugin_info_box, 8);
	gtk_widget_set_margin_end ((GtkWidget*) plugin_info_box, 8);
	gtk_box_pack_start (plugin_info_box, (GtkWidget*) upper_box, FALSE, FALSE, (guint) 0);
	_tmp34_ = self->priv->selected_plugin_description;
	gtk_box_pack_start (plugin_info_box, (GtkWidget*) _tmp34_, FALSE, FALSE, (guint) 0);
	_tmp35_ = self->priv->selected_plugin_copyright;
	gtk_box_pack_end (plugin_info_box, (GtkWidget*) _tmp35_, FALSE, FALSE, (guint) 0);
	gtk_widget_set_size_request ((GtkWidget*) plugin_info_box, 400, -1);
	gtk_box_pack_start (content_area, (GtkWidget*) plugin_info_box, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	gtk_window_set_default_size ((GtkWindow*) self, -1, 400);
	_g_object_unref0 (plugin_info_box);
	_g_object_unref0 (upper_box);
	_g_object_unref0 (upper_text_box);
	_g_object_unref0 (scroll);
	_g_object_unref0 (content_area);
	return self;
}

BudgieSettingsPluginChooser*
budgie_settings_plugin_chooser_new (GtkWindow* parent,
                                    gboolean use_applet_name)
{
	return budgie_settings_plugin_chooser_construct (BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER, parent, use_applet_name);
}

/**
* Simple accessor to get the new widget ID to be added
*/
gchar*
budgie_settings_plugin_chooser_run (BudgieSettingsPluginChooser* self)
{
	GtkResponseType resp = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	resp = (GtkResponseType) gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
	switch (resp) {
		case GTK_RESPONSE_ACCEPT:
		{
			const gchar* _tmp0_;
			gchar* _tmp1_;
			_tmp0_ = self->priv->applet_id;
			_tmp1_ = g_strdup (_tmp0_);
			result = _tmp1_;
			return result;
		}
		default:
		case GTK_RESPONSE_CANCEL:
		{
			result = NULL;
			return result;
		}
	}
}

/**
* Super simple sorting of applets in alphabetical listing
*/
static PeasPluginInfo*
_vala_PeasPluginInfo_copy (PeasPluginInfo* self)
{
	return g_boxed_copy (peas_plugin_info_get_type (), self);
}

static gpointer
__vala_PeasPluginInfo_copy0 (gpointer self)
{
	return self ? _vala_PeasPluginInfo_copy (self) : NULL;
}

static void
_vala_PeasPluginInfo_free (PeasPluginInfo* self)
{
	g_boxed_free (peas_plugin_info_get_type (), self);
}

static gint
budgie_settings_plugin_chooser_sort_applets (BudgieSettingsPluginChooser* self,
                                             GtkListBoxRow* a,
                                             GtkListBoxRow* b)
{
	PeasPluginInfo* infoA = NULL;
	GtkWidget* _tmp0_;
	PeasPluginInfo* _tmp1_;
	PeasPluginInfo* _tmp2_;
	PeasPluginInfo* _tmp3_;
	PeasPluginInfo* infoB = NULL;
	GtkWidget* _tmp4_;
	PeasPluginInfo* _tmp5_;
	PeasPluginInfo* _tmp6_;
	PeasPluginInfo* _tmp7_;
	GCompareFunc _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint _tmp15_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) a);
	_tmp1_ = budgie_settings_plugin_chooser_item_get_plugin (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER_ITEM, BudgieSettingsPluginChooserItem));
	_tmp2_ = _tmp1_;
	_tmp3_ = __vala_PeasPluginInfo_copy0 (_tmp2_);
	infoA = _tmp3_;
	_tmp4_ = gtk_bin_get_child ((GtkBin*) b);
	_tmp5_ = budgie_settings_plugin_chooser_item_get_plugin (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER_ITEM, BudgieSettingsPluginChooserItem));
	_tmp6_ = _tmp5_;
	_tmp7_ = __vala_PeasPluginInfo_copy0 (_tmp6_);
	infoB = _tmp7_;
	_tmp8_ = ((GCompareFunc) g_strcmp0);
	_tmp9_ = peas_plugin_info_get_name (infoA);
	_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
	_tmp11_ = _tmp10_;
	_tmp12_ = peas_plugin_info_get_name (infoB);
	_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp8_ (_tmp11_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp11_);
	result = _tmp15_;
	__vala_PeasPluginInfo_free0 (infoB);
	__vala_PeasPluginInfo_free0 (infoA);
	return result;
}

/**
* User picked a plugin
*/
static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
budgie_settings_plugin_chooser_row_selected (BudgieSettingsPluginChooser* self,
                                             GtkListBoxRow* row)
{
	GtkWidget* _tmp1_;
	PeasPluginInfo* plugin = NULL;
	GtkWidget* _tmp2_;
	PeasPluginInfo* _tmp3_;
	PeasPluginInfo* _tmp4_;
	PeasPluginInfo* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp11_;
	GtkImage* _tmp12_;
	PeasPluginInfo* _tmp13_;
	const gchar* _tmp14_;
	GtkLabel* _tmp15_;
	PeasPluginInfo* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_ = NULL;
	PeasPluginInfo* _tmp23_;
	const gchar* _tmp24_;
	gchar* description = NULL;
	gchar* _tmp29_;
	GtkLabel* _tmp30_;
	const gchar* _tmp31_;
	PeasPluginInfo* _tmp32_;
	const gchar* _tmp33_;
	PeasPluginInfo* _tmp41_;
	const gchar* _tmp42_;
	gboolean _tmp53_ = FALSE;
	PeasPluginInfo* _tmp54_;
	gchar** _tmp55_;
	gchar** _tmp56_;
	g_return_if_fail (self != NULL);
	if (row == NULL) {
		GtkWidget* _tmp0_;
		_g_free0 (self->priv->applet_id);
		self->priv->applet_id = NULL;
		_tmp0_ = self->priv->button_ok;
		gtk_widget_set_sensitive (_tmp0_, FALSE);
		return;
	}
	_tmp1_ = self->priv->button_ok;
	gtk_widget_set_sensitive (_tmp1_, TRUE);
	_tmp2_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp3_ = budgie_settings_plugin_chooser_item_get_plugin (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER_ITEM, BudgieSettingsPluginChooserItem));
	_tmp4_ = _tmp3_;
	_tmp5_ = __vala_PeasPluginInfo_copy0 (_tmp4_);
	plugin = _tmp5_;
	if (self->priv->use_applet_name) {
		PeasPluginInfo* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = plugin;
		_tmp8_ = peas_plugin_info_get_name (_tmp7_);
		_tmp6_ = _tmp8_;
	} else {
		PeasPluginInfo* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = plugin;
		_tmp10_ = peas_plugin_info_get_module_name (_tmp9_);
		_tmp6_ = _tmp10_;
	}
	_tmp11_ = g_strdup (_tmp6_);
	_g_free0 (self->priv->applet_id);
	self->priv->applet_id = _tmp11_;
	_tmp12_ = self->priv->selected_plugin_icon;
	_tmp13_ = plugin;
	_tmp14_ = peas_plugin_info_get_icon_name (_tmp13_);
	gtk_image_set_from_icon_name (_tmp12_, _tmp14_, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	_tmp15_ = self->priv->selected_plugin_name;
	_tmp16_ = plugin;
	_tmp17_ = peas_plugin_info_get_name (_tmp16_);
	_tmp18_ = g_markup_escape_text (_tmp17_, (gssize) -1);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("<span size='x-large'>%s</span>", _tmp19_);
	_tmp21_ = _tmp20_;
	gtk_label_set_markup (_tmp15_, _tmp21_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_tmp23_ = plugin;
	_tmp24_ = peas_plugin_info_get_description (_tmp23_);
	if (_tmp24_ != NULL) {
		PeasPluginInfo* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp25_ = plugin;
		_tmp26_ = peas_plugin_info_get_description (_tmp25_);
		_tmp27_ = g_markup_escape_text (_tmp26_, (gssize) -1);
		_g_free0 (_tmp22_);
		_tmp22_ = _tmp27_;
	} else {
		gchar* _tmp28_;
		_tmp28_ = g_strdup (_ ("No description."));
		_g_free0 (_tmp22_);
		_tmp22_ = _tmp28_;
	}
	_tmp29_ = g_strdup (_tmp22_);
	description = _tmp29_;
	_tmp30_ = self->priv->selected_plugin_description;
	_tmp31_ = description;
	gtk_label_set_markup (_tmp30_, _tmp31_);
	_tmp32_ = plugin;
	_tmp33_ = peas_plugin_info_get_copyright (_tmp32_);
	if (_tmp33_ != NULL) {
		gchar* copyright = NULL;
		PeasPluginInfo* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		GtkLabel* _tmp37_;
		const gchar* _tmp38_;
		GtkLabel* _tmp39_;
		_tmp34_ = plugin;
		_tmp35_ = peas_plugin_info_get_copyright (_tmp34_);
		_tmp36_ = g_markup_escape_text (_tmp35_, (gssize) -1);
		copyright = _tmp36_;
		_tmp37_ = self->priv->selected_plugin_copyright;
		_tmp38_ = copyright;
		gtk_label_set_markup (_tmp37_, _tmp38_);
		_tmp39_ = self->priv->selected_plugin_copyright;
		gtk_widget_show ((GtkWidget*) _tmp39_);
		_g_free0 (copyright);
	} else {
		GtkLabel* _tmp40_;
		_tmp40_ = self->priv->selected_plugin_copyright;
		gtk_widget_hide ((GtkWidget*) _tmp40_);
	}
	_tmp41_ = plugin;
	_tmp42_ = peas_plugin_info_get_website (_tmp41_);
	if (_tmp42_ != NULL) {
		gchar* website = NULL;
		PeasPluginInfo* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		GtkLabel* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		GtkLabel* _tmp51_;
		_tmp43_ = plugin;
		_tmp44_ = peas_plugin_info_get_website (_tmp43_);
		_tmp45_ = g_markup_escape_text (_tmp44_, (gssize) -1);
		website = _tmp45_;
		_tmp46_ = self->priv->selected_plugin_website;
		_tmp47_ = website;
		_tmp48_ = website;
		_tmp49_ = g_strdup_printf ("<a href='%s'>%s</a>", _tmp47_, _tmp48_);
		_tmp50_ = _tmp49_;
		gtk_label_set_markup (_tmp46_, _tmp50_);
		_g_free0 (_tmp50_);
		_tmp51_ = self->priv->selected_plugin_website;
		gtk_widget_show ((GtkWidget*) _tmp51_);
		_g_free0 (website);
	} else {
		GtkLabel* _tmp52_;
		_tmp52_ = self->priv->selected_plugin_website;
		gtk_widget_hide ((GtkWidget*) _tmp52_);
	}
	_tmp54_ = plugin;
	_tmp56_ = _tmp55_ = peas_plugin_info_get_authors (_tmp54_);
	if (_tmp56_ != NULL) {
		PeasPluginInfo* _tmp57_;
		gchar** _tmp58_;
		gchar** _tmp59_;
		_tmp57_ = plugin;
		_tmp59_ = _tmp58_ = peas_plugin_info_get_authors (_tmp57_);
		_tmp53_ = _vala_array_length (_tmp58_) > 0;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		gchar** authors = NULL;
		PeasPluginInfo* _tmp60_;
		gchar** _tmp61_;
		gchar** _tmp62_;
		gchar** _tmp63_;
		gint _tmp63__length1;
		gint authors_length1;
		gint _authors_size_;
		gchar* authors_string = NULL;
		gchar** _tmp64_;
		gint _tmp64__length1;
		gchar* _tmp65_;
		gchar* final_authors_string = NULL;
		const gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		GtkLabel* _tmp71_;
		const gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		_tmp60_ = plugin;
		_tmp62_ = _tmp61_ = peas_plugin_info_get_authors (_tmp60_);
		_tmp63_ = (_tmp62_ != NULL) ? _vala_array_dup1 (_tmp62_, _vala_array_length (_tmp61_)) : _tmp62_;
		_tmp63__length1 = _vala_array_length (_tmp61_);
		authors = _tmp63_;
		authors_length1 = _tmp63__length1;
		_authors_size_ = authors_length1;
		_tmp64_ = authors;
		_tmp64__length1 = authors_length1;
		_tmp65_ = _vala_g_strjoinv (",", _tmp64_, (gint) _tmp64__length1);
		authors_string = _tmp65_;
		_tmp66_ = authors_string;
		_tmp67_ = g_strdup_printf (_ ("by %s"), _tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = g_markup_escape_text (_tmp68_, (gssize) -1);
		_tmp70_ = _tmp69_;
		_g_free0 (_tmp68_);
		final_authors_string = _tmp70_;
		_tmp71_ = self->priv->selected_plugin_authors;
		_tmp72_ = final_authors_string;
		_tmp73_ = g_strdup_printf ("<i>%s</i>", _tmp72_);
		_tmp74_ = _tmp73_;
		gtk_label_set_markup (_tmp71_, _tmp74_);
		_g_free0 (_tmp74_);
		_g_free0 (final_authors_string);
		_g_free0 (authors_string);
		authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	} else {
		GtkLabel* _tmp75_;
		gchar* _tmp76_;
		gchar* _tmp77_;
		_tmp75_ = self->priv->selected_plugin_authors;
		_tmp76_ = g_strdup_printf ("<i>%s</i>", _ ("No authors listed"));
		_tmp77_ = _tmp76_;
		gtk_label_set_markup (_tmp75_, _tmp77_);
		_g_free0 (_tmp77_);
	}
	_g_free0 (description);
	_g_free0 (_tmp22_);
	__vala_PeasPluginInfo_free0 (plugin);
}

/**
* Special sauce to allow us to double-click activate an widget
*/
static void
budgie_settings_plugin_chooser_row_activated (BudgieSettingsPluginChooser* self,
                                              GtkListBoxRow* row)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	budgie_settings_plugin_chooser_row_selected (self, row);
	_tmp0_ = self->priv->applet_id;
	if (_tmp0_ == NULL) {
		return;
	}
	gtk_dialog_response ((GtkDialog*) self, (gint) GTK_RESPONSE_ACCEPT);
}

/**
* Set the available plugins to show in the dialog
*/
void
budgie_settings_plugin_chooser_set_plugin_list (BudgieSettingsPluginChooser* self,
                                                GList* plugins)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GtkListBox* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->applets;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = child;
				gtk_widget_destroy (_tmp2_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	{
		GList* plugin_collection = NULL;
		GList* plugin_it = NULL;
		plugin_collection = plugins;
		for (plugin_it = plugin_collection; plugin_it != NULL; plugin_it = plugin_it->next) {
			PeasPluginInfo* _tmp3_;
			PeasPluginInfo* plugin = NULL;
			_tmp3_ = __vala_PeasPluginInfo_copy0 ((PeasPluginInfo*) plugin_it->data);
			plugin = _tmp3_;
			{
				PeasPluginInfo* _tmp4_;
				_tmp4_ = plugin;
				budgie_settings_plugin_chooser_add_plugin (self, _tmp4_);
				__vala_PeasPluginInfo_free0 (plugin);
			}
		}
	}
	_tmp5_ = self->priv->applets;
	gtk_list_box_invalidate_sort (_tmp5_);
}

/**
* Add a new plugin to our display area
*/
static void
budgie_settings_plugin_chooser_add_plugin (BudgieSettingsPluginChooser* self,
                                           PeasPluginInfo* plugin)
{
	GtkListBox* _tmp0_;
	BudgieSettingsPluginChooserItem* _tmp1_;
	BudgieSettingsPluginChooserItem* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->applets;
	_tmp1_ = budgie_settings_plugin_chooser_item_new (plugin);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_container_add ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
budgie_settings_plugin_chooser_class_init (BudgieSettingsPluginChooserClass * klass,
                                           gpointer klass_data)
{
	budgie_settings_plugin_chooser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieSettingsPluginChooser_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_settings_plugin_chooser_finalize;
}

static void
budgie_settings_plugin_chooser_instance_init (BudgieSettingsPluginChooser * self,
                                              gpointer klass)
{
	self->priv = budgie_settings_plugin_chooser_get_instance_private (self);
	self->priv->selected_plugin_icon = NULL;
	self->priv->selected_plugin_name = NULL;
	self->priv->selected_plugin_description = NULL;
	self->priv->selected_plugin_authors = NULL;
	self->priv->selected_plugin_copyright = NULL;
	self->priv->selected_plugin_website = NULL;
	self->priv->applet_id = NULL;
}

static void
budgie_settings_plugin_chooser_finalize (GObject * obj)
{
	BudgieSettingsPluginChooser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SETTINGS_PLUGIN_CHOOSER, BudgieSettingsPluginChooser);
	_g_object_unref0 (self->priv->applets);
	_g_object_unref0 (self->priv->button_ok);
	_g_object_unref0 (self->priv->selected_plugin_icon);
	_g_object_unref0 (self->priv->selected_plugin_name);
	_g_object_unref0 (self->priv->selected_plugin_description);
	_g_object_unref0 (self->priv->selected_plugin_authors);
	_g_object_unref0 (self->priv->selected_plugin_copyright);
	_g_object_unref0 (self->priv->selected_plugin_website);
	_g_free0 (self->priv->applet_id);
	G_OBJECT_CLASS (budgie_settings_plugin_chooser_parent_class)->finalize (obj);
}

/**
* SettingsPluginChooser provides a dialog to allow selection of an widget to be added to Raven
*/
static GType
budgie_settings_plugin_chooser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieSettingsPluginChooserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_settings_plugin_chooser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieSettingsPluginChooser), 0, (GInstanceInitFunc) budgie_settings_plugin_chooser_instance_init, NULL };
	GType budgie_settings_plugin_chooser_type_id;
	budgie_settings_plugin_chooser_type_id = g_type_register_static (gtk_dialog_get_type (), "BudgieSettingsPluginChooser", &g_define_type_info, 0);
	BudgieSettingsPluginChooser_private_offset = g_type_add_instance_private (budgie_settings_plugin_chooser_type_id, sizeof (BudgieSettingsPluginChooserPrivate));
	return budgie_settings_plugin_chooser_type_id;
}

GType
budgie_settings_plugin_chooser_get_type (void)
{
	static volatile gsize budgie_settings_plugin_chooser_type_id__once = 0;
	if (g_once_init_enter (&budgie_settings_plugin_chooser_type_id__once)) {
		GType budgie_settings_plugin_chooser_type_id;
		budgie_settings_plugin_chooser_type_id = budgie_settings_plugin_chooser_get_type_once ();
		g_once_init_leave (&budgie_settings_plugin_chooser_type_id__once, budgie_settings_plugin_chooser_type_id);
	}
	return budgie_settings_plugin_chooser_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

