/* baobab-size-cell.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from baobab-size-cell.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright © 2024 Adrien Plazas <aplazas@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "baobab.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BAOBAB_SIZE_CELL_0_PROPERTY,
	BAOBAB_SIZE_CELL_ITEM_PROPERTY,
	BAOBAB_SIZE_CELL_NUM_PROPERTIES
};
static GParamSpec* baobab_size_cell_properties[BAOBAB_SIZE_CELL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BaobabSizeCellPrivate {
	BaobabScannerResults* _item;
};

static gint BaobabSizeCell_private_offset;
static gpointer baobab_size_cell_parent_class = NULL;

static gchar* baobab_size_cell_format_size_cb (BaobabSizeCell* self,
                                        guint64 size);
static void baobab_size_cell_finalize (GObject * obj);
static GType baobab_size_cell_get_type_once (void);
static void _vala_baobab_size_cell_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_baobab_size_cell_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static inline gpointer
baobab_size_cell_get_instance_private (BaobabSizeCell* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabSizeCell_private_offset);
}

static gchar*
baobab_size_cell_format_size_cb (BaobabSizeCell* self,
                                 guint64 size)
{
	gboolean _tmp0_ = FALSE;
	BaobabScannerResults* _tmp1_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_item;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		BaobabScannerResults* _tmp2_;
		BaobabScannerState _tmp3_;
		BaobabScannerState _tmp4_;
		_tmp2_ = self->priv->_item;
		_tmp3_ = baobab_scanner_results_get_state (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == BAOBAB_SCANNER_STATE_ERROR;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		result = _tmp5_;
		return result;
	}
	_tmp6_ = g_format_size_full (size, G_FORMAT_SIZE_DEFAULT);
	result = _tmp6_;
	return result;
}

BaobabSizeCell*
baobab_size_cell_construct (GType object_type)
{
	BaobabSizeCell * self = NULL;
	self = (BaobabSizeCell*) g_object_new (object_type, NULL);
	return self;
}

BaobabSizeCell*
baobab_size_cell_new (void)
{
	return baobab_size_cell_construct (BAOBAB_TYPE_SIZE_CELL);
}

BaobabScannerResults*
baobab_size_cell_get_item (BaobabSizeCell* self)
{
	BaobabScannerResults* result;
	BaobabScannerResults* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_item;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
baobab_size_cell_set_item (BaobabSizeCell* self,
                           BaobabScannerResults* value)
{
	BaobabScannerResults* old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_size_cell_get_item (self);
	if (old_value != value) {
		BaobabScannerResults* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_item);
		self->priv->_item = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, baobab_size_cell_properties[BAOBAB_SIZE_CELL_ITEM_PROPERTY]);
	}
}

static void
baobab_size_cell_class_init (BaobabSizeCellClass * klass,
                             gpointer klass_data)
{
	baobab_size_cell_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabSizeCell_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_size_cell_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_size_cell_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_size_cell_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SIZE_CELL_ITEM_PROPERTY, baobab_size_cell_properties[BAOBAB_SIZE_CELL_ITEM_PROPERTY] = g_param_spec_object ("item", "item", "item", BAOBAB_SCANNER_TYPE_RESULTS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/baobab/ui/baobab-size-cell.ui");
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "format_size_cb", G_CALLBACK(baobab_size_cell_format_size_cb));
}

static void
baobab_size_cell_instance_init (BaobabSizeCell * self,
                                gpointer klass)
{
	self->priv = baobab_size_cell_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
baobab_size_cell_finalize (GObject * obj)
{
	BaobabSizeCell * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_SIZE_CELL, BaobabSizeCell);
	_g_object_unref0 (self->priv->_item);
	G_OBJECT_CLASS (baobab_size_cell_parent_class)->finalize (obj);
}

static GType
baobab_size_cell_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabSizeCellClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_size_cell_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabSizeCell), 0, (GInstanceInitFunc) baobab_size_cell_instance_init, NULL };
	GType baobab_size_cell_type_id;
	baobab_size_cell_type_id = g_type_register_static (adw_bin_get_type (), "BaobabSizeCell", &g_define_type_info, 0);
	BaobabSizeCell_private_offset = g_type_add_instance_private (baobab_size_cell_type_id, sizeof (BaobabSizeCellPrivate));
	return baobab_size_cell_type_id;
}

GType
baobab_size_cell_get_type (void)
{
	static volatile gsize baobab_size_cell_type_id__once = 0;
	if (g_once_init_enter (&baobab_size_cell_type_id__once)) {
		GType baobab_size_cell_type_id;
		baobab_size_cell_type_id = baobab_size_cell_get_type_once ();
		g_once_init_leave (&baobab_size_cell_type_id__once, baobab_size_cell_type_id);
	}
	return baobab_size_cell_type_id__once;
}

static void
_vala_baobab_size_cell_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	BaobabSizeCell * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_SIZE_CELL, BaobabSizeCell);
	switch (property_id) {
		case BAOBAB_SIZE_CELL_ITEM_PROPERTY:
		g_value_set_object (value, baobab_size_cell_get_item (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_baobab_size_cell_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	BaobabSizeCell * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_SIZE_CELL, BaobabSizeCell);
	switch (property_id) {
		case BAOBAB_SIZE_CELL_ITEM_PROPERTY:
		baobab_size_cell_set_item (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

