/******************************************************************************
  This source file is part of the Avogadro project.
  This source code is released under the 3-Clause BSD License, (see "LICENSE").
******************************************************************************/

#include <QtCore/QtPlugin>

#include "/build/avogadrolibs/src/avogadrolibs/avogadro/qtplugins/label/label.h"


namespace Avogadro::QtPlugins {

class LabelFactory : public QObject, public QtGui::ScenePluginFactory
{
  Q_OBJECT
  Q_PLUGIN_METADATA(IID "org.openchemistry.avogadro.ScenePluginFactory")
  Q_INTERFACES(Avogadro::QtGui::ScenePluginFactory)

public:
  explicit LabelFactory(QObject* parent_ = nullptr) : QObject(parent_) {}

  QtGui::ScenePlugin* createInstance(QObject* parent_ = nullptr) override
  {
    auto* object = new Label(parent_);
    object->setObjectName("Label");
    return object;
  }

  QString identifier() const override { return "Label"; }

  QString description() const override { return "Labels rendering scheme"; }

};

} // namespace Avogadro::QtPlugins

#include "LabelPlugin.moc"
