// This file is part of arduino-cli.
//
// Copyright 2024 ARDUINO SA (https://www.arduino.cc/)
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: cc/arduino/cli/commands/v1/monitor.proto

package commands

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type MonitorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*MonitorRequest_OpenRequest
	//	*MonitorRequest_TxData
	//	*MonitorRequest_UpdatedConfiguration
	//	*MonitorRequest_Close
	Message isMonitorRequest_Message `protobuf_oneof:"message"`
}

func (x *MonitorRequest) Reset() {
	*x = MonitorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonitorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitorRequest) ProtoMessage() {}

func (x *MonitorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitorRequest.ProtoReflect.Descriptor instead.
func (*MonitorRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_monitor_proto_rawDescGZIP(), []int{0}
}

func (m *MonitorRequest) GetMessage() isMonitorRequest_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *MonitorRequest) GetOpenRequest() *MonitorPortOpenRequest {
	if x, ok := x.GetMessage().(*MonitorRequest_OpenRequest); ok {
		return x.OpenRequest
	}
	return nil
}

func (x *MonitorRequest) GetTxData() []byte {
	if x, ok := x.GetMessage().(*MonitorRequest_TxData); ok {
		return x.TxData
	}
	return nil
}

func (x *MonitorRequest) GetUpdatedConfiguration() *MonitorPortConfiguration {
	if x, ok := x.GetMessage().(*MonitorRequest_UpdatedConfiguration); ok {
		return x.UpdatedConfiguration
	}
	return nil
}

func (x *MonitorRequest) GetClose() bool {
	if x, ok := x.GetMessage().(*MonitorRequest_Close); ok {
		return x.Close
	}
	return false
}

type isMonitorRequest_Message interface {
	isMonitorRequest_Message()
}

type MonitorRequest_OpenRequest struct {
	// Open request, it must be the first incoming message.
	OpenRequest *MonitorPortOpenRequest `protobuf:"bytes,1,opt,name=open_request,json=openRequest,proto3,oneof"`
}

type MonitorRequest_TxData struct {
	// Data to send to the port.
	TxData []byte `protobuf:"bytes,2,opt,name=tx_data,json=txData,proto3,oneof"`
}

type MonitorRequest_UpdatedConfiguration struct {
	// Port configuration, contains settings of the port to be changed.
	UpdatedConfiguration *MonitorPortConfiguration `protobuf:"bytes,3,opt,name=updated_configuration,json=updatedConfiguration,proto3,oneof"`
}

type MonitorRequest_Close struct {
	// Close message, set to true to gracefully close a port (this ensure
	// that the gRPC streaming call is closed by the daemon AFTER the port
	// has been successfully closed).
	Close bool `protobuf:"varint,4,opt,name=close,proto3,oneof"`
}

func (*MonitorRequest_OpenRequest) isMonitorRequest_Message() {}

func (*MonitorRequest_TxData) isMonitorRequest_Message() {}

func (*MonitorRequest_UpdatedConfiguration) isMonitorRequest_Message() {}

func (*MonitorRequest_Close) isMonitorRequest_Message() {}

type MonitorPortOpenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Port to open, must be filled only on the first request.
	Port *Port `protobuf:"bytes,2,opt,name=port,proto3" json:"port,omitempty"`
	// The board FQBN we are trying to connect to. This is optional, and  it's
	// needed to disambiguate if more than one platform provides the pluggable
	// monitor for a given port protocol.
	Fqbn string `protobuf:"bytes,3,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
	// Port configuration, optional, contains settings of the port to be applied.
	PortConfiguration *MonitorPortConfiguration `protobuf:"bytes,4,opt,name=port_configuration,json=portConfiguration,proto3" json:"port_configuration,omitempty"`
}

func (x *MonitorPortOpenRequest) Reset() {
	*x = MonitorPortOpenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonitorPortOpenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitorPortOpenRequest) ProtoMessage() {}

func (x *MonitorPortOpenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitorPortOpenRequest.ProtoReflect.Descriptor instead.
func (*MonitorPortOpenRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_monitor_proto_rawDescGZIP(), []int{1}
}

func (x *MonitorPortOpenRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *MonitorPortOpenRequest) GetPort() *Port {
	if x != nil {
		return x.Port
	}
	return nil
}

func (x *MonitorPortOpenRequest) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

func (x *MonitorPortOpenRequest) GetPortConfiguration() *MonitorPortConfiguration {
	if x != nil {
		return x.PortConfiguration
	}
	return nil
}

type MonitorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Message:
	//
	//	*MonitorResponse_Error
	//	*MonitorResponse_RxData
	//	*MonitorResponse_AppliedSettings
	//	*MonitorResponse_Success
	Message isMonitorResponse_Message `protobuf_oneof:"message"`
}

func (x *MonitorResponse) Reset() {
	*x = MonitorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonitorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitorResponse) ProtoMessage() {}

func (x *MonitorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitorResponse.ProtoReflect.Descriptor instead.
func (*MonitorResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_monitor_proto_rawDescGZIP(), []int{2}
}

func (m *MonitorResponse) GetMessage() isMonitorResponse_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *MonitorResponse) GetError() string {
	if x, ok := x.GetMessage().(*MonitorResponse_Error); ok {
		return x.Error
	}
	return ""
}

func (x *MonitorResponse) GetRxData() []byte {
	if x, ok := x.GetMessage().(*MonitorResponse_RxData); ok {
		return x.RxData
	}
	return nil
}

func (x *MonitorResponse) GetAppliedSettings() *MonitorPortConfiguration {
	if x, ok := x.GetMessage().(*MonitorResponse_AppliedSettings); ok {
		return x.AppliedSettings
	}
	return nil
}

func (x *MonitorResponse) GetSuccess() bool {
	if x, ok := x.GetMessage().(*MonitorResponse_Success); ok {
		return x.Success
	}
	return false
}

type isMonitorResponse_Message interface {
	isMonitorResponse_Message()
}

type MonitorResponse_Error struct {
	// Eventual errors dealing with monitor port.
	Error string `protobuf:"bytes,1,opt,name=error,proto3,oneof"`
}

type MonitorResponse_RxData struct {
	// Data received from the port.
	RxData []byte `protobuf:"bytes,2,opt,name=rx_data,json=rxData,proto3,oneof"`
}

type MonitorResponse_AppliedSettings struct {
	// Settings applied to the port, may be returned after a port is opened (to
	// report the default settings) or after a new port_configuration is sent
	// (to report the new settings applied).
	AppliedSettings *MonitorPortConfiguration `protobuf:"bytes,3,opt,name=applied_settings,json=appliedSettings,proto3,oneof"`
}

type MonitorResponse_Success struct {
	// A message with this field set to true is sent as soon as the port is
	// succesfully opened.
	Success bool `protobuf:"varint,4,opt,name=success,proto3,oneof"`
}

func (*MonitorResponse_Error) isMonitorResponse_Message() {}

func (*MonitorResponse_RxData) isMonitorResponse_Message() {}

func (*MonitorResponse_AppliedSettings) isMonitorResponse_Message() {}

func (*MonitorResponse_Success) isMonitorResponse_Message() {}

type EnumerateMonitorPortSettingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Arduino Core Service instance from the `Init` response.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The port protocol to enumerate settings.
	PortProtocol string `protobuf:"bytes,2,opt,name=port_protocol,json=portProtocol,proto3" json:"port_protocol,omitempty"`
	// The board FQBN we are trying to connect to. This is optional, and it's
	// needed to disambiguate if more than one platform provides the pluggable
	// monitor for a given port protocol.
	Fqbn string `protobuf:"bytes,3,opt,name=fqbn,proto3" json:"fqbn,omitempty"`
}

func (x *EnumerateMonitorPortSettingsRequest) Reset() {
	*x = EnumerateMonitorPortSettingsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnumerateMonitorPortSettingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumerateMonitorPortSettingsRequest) ProtoMessage() {}

func (x *EnumerateMonitorPortSettingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnumerateMonitorPortSettingsRequest.ProtoReflect.Descriptor instead.
func (*EnumerateMonitorPortSettingsRequest) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_monitor_proto_rawDescGZIP(), []int{3}
}

func (x *EnumerateMonitorPortSettingsRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *EnumerateMonitorPortSettingsRequest) GetPortProtocol() string {
	if x != nil {
		return x.PortProtocol
	}
	return ""
}

func (x *EnumerateMonitorPortSettingsRequest) GetFqbn() string {
	if x != nil {
		return x.Fqbn
	}
	return ""
}

type EnumerateMonitorPortSettingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of descriptors of the settings that may be changed for the monitor
	// port.
	Settings []*MonitorPortSettingDescriptor `protobuf:"bytes,1,rep,name=settings,proto3" json:"settings,omitempty"`
}

func (x *EnumerateMonitorPortSettingsResponse) Reset() {
	*x = EnumerateMonitorPortSettingsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnumerateMonitorPortSettingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumerateMonitorPortSettingsResponse) ProtoMessage() {}

func (x *EnumerateMonitorPortSettingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnumerateMonitorPortSettingsResponse.ProtoReflect.Descriptor instead.
func (*EnumerateMonitorPortSettingsResponse) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_monitor_proto_rawDescGZIP(), []int{4}
}

func (x *EnumerateMonitorPortSettingsResponse) GetSettings() []*MonitorPortSettingDescriptor {
	if x != nil {
		return x.Settings
	}
	return nil
}

type MonitorPortSettingDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The setting identifier.
	SettingId string `protobuf:"bytes,1,opt,name=setting_id,json=settingId,proto3" json:"setting_id,omitempty"`
	// A human-readable label of the setting (to be displayed on the GUI).
	Label string `protobuf:"bytes,2,opt,name=label,proto3" json:"label,omitempty"`
	// The setting type (at the moment only "enum" is avaiable).
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// The values allowed on "enum" types.
	EnumValues []string `protobuf:"bytes,4,rep,name=enum_values,json=enumValues,proto3" json:"enum_values,omitempty"`
	// The selected or default value.
	Value string `protobuf:"bytes,5,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *MonitorPortSettingDescriptor) Reset() {
	*x = MonitorPortSettingDescriptor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonitorPortSettingDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitorPortSettingDescriptor) ProtoMessage() {}

func (x *MonitorPortSettingDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitorPortSettingDescriptor.ProtoReflect.Descriptor instead.
func (*MonitorPortSettingDescriptor) Descriptor() ([]byte, []int) {
	return file_cc_arduino_cli_commands_v1_monitor_proto_rawDescGZIP(), []int{5}
}

func (x *MonitorPortSettingDescriptor) GetSettingId() string {
	if x != nil {
		return x.SettingId
	}
	return ""
}

func (x *MonitorPortSettingDescriptor) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

func (x *MonitorPortSettingDescriptor) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *MonitorPortSettingDescriptor) GetEnumValues() []string {
	if x != nil {
		return x.EnumValues
	}
	return nil
}

func (x *MonitorPortSettingDescriptor) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_cc_arduino_cli_commands_v1_monitor_proto protoreflect.FileDescriptor

var file_cc_arduino_cli_commands_v1_monitor_proto_rawDesc = []byte{
	0x0a, 0x28, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x63, 0x63, 0x2e, 0x61,
	0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x27, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f,
	0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x25, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c, 0x69, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x72, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x94, 0x02, 0x0a, 0x0e, 0x4d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x0c, 0x6f, 0x70, 0x65,
	0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x6f, 0x70, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x19, 0x0a, 0x07, 0x74, 0x78, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x06, 0x74, 0x78, 0x44, 0x61, 0x74, 0x61, 0x12, 0x6b, 0x0a,
	0x15, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x63,
	0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x50, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x14, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x05, 0x63, 0x6c,
	0x6f, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x05, 0x63, 0x6c, 0x6f,
	0x73, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x89, 0x02,
	0x0a, 0x16, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x65,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x34, 0x0a, 0x04, 0x70, 0x6f,
	0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72,
	0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x66, 0x71, 0x62, 0x6e, 0x12, 0x63, 0x0a, 0x12, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c,
	0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xce, 0x01, 0x0a, 0x0f, 0x4d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x19, 0x0a, 0x07, 0x72, 0x78, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x06, 0x72, 0x78, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x61, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x63, 0x63, 0x2e,
	0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x50,
	0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x1a, 0x0a, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x07, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42,
	0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x23, 0x45,
	0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x50,
	0x6f, 0x72, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x40, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e,
	0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x6f, 0x72,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x62,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x62, 0x6e, 0x22, 0x7c, 0x0a,
	0x24, 0x45, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x50, 0x6f, 0x72, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x63, 0x63, 0x2e, 0x61, 0x72, 0x64,
	0x75, 0x69, 0x6e, 0x6f, 0x2e, 0x63, 0x6c, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x50, 0x6f, 0x72, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f,
	0x72, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x9e, 0x01, 0x0a, 0x1c,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x1d, 0x0a, 0x0a,
	0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x6e, 0x75, 0x6d,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x48, 0x5a, 0x46,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69,
	0x6e, 0x6f, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2d, 0x63, 0x6c, 0x69, 0x2f, 0x72,
	0x70, 0x63, 0x2f, 0x63, 0x63, 0x2f, 0x61, 0x72, 0x64, 0x75, 0x69, 0x6e, 0x6f, 0x2f, 0x63, 0x6c,
	0x69, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_cc_arduino_cli_commands_v1_monitor_proto_rawDescOnce sync.Once
	file_cc_arduino_cli_commands_v1_monitor_proto_rawDescData = file_cc_arduino_cli_commands_v1_monitor_proto_rawDesc
)

func file_cc_arduino_cli_commands_v1_monitor_proto_rawDescGZIP() []byte {
	file_cc_arduino_cli_commands_v1_monitor_proto_rawDescOnce.Do(func() {
		file_cc_arduino_cli_commands_v1_monitor_proto_rawDescData = protoimpl.X.CompressGZIP(file_cc_arduino_cli_commands_v1_monitor_proto_rawDescData)
	})
	return file_cc_arduino_cli_commands_v1_monitor_proto_rawDescData
}

var file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_cc_arduino_cli_commands_v1_monitor_proto_goTypes = []any{
	(*MonitorRequest)(nil),                       // 0: cc.arduino.cli.commands.v1.MonitorRequest
	(*MonitorPortOpenRequest)(nil),               // 1: cc.arduino.cli.commands.v1.MonitorPortOpenRequest
	(*MonitorResponse)(nil),                      // 2: cc.arduino.cli.commands.v1.MonitorResponse
	(*EnumerateMonitorPortSettingsRequest)(nil),  // 3: cc.arduino.cli.commands.v1.EnumerateMonitorPortSettingsRequest
	(*EnumerateMonitorPortSettingsResponse)(nil), // 4: cc.arduino.cli.commands.v1.EnumerateMonitorPortSettingsResponse
	(*MonitorPortSettingDescriptor)(nil),         // 5: cc.arduino.cli.commands.v1.MonitorPortSettingDescriptor
	(*MonitorPortConfiguration)(nil),             // 6: cc.arduino.cli.commands.v1.MonitorPortConfiguration
	(*Instance)(nil),                             // 7: cc.arduino.cli.commands.v1.Instance
	(*Port)(nil),                                 // 8: cc.arduino.cli.commands.v1.Port
}
var file_cc_arduino_cli_commands_v1_monitor_proto_depIdxs = []int32{
	1, // 0: cc.arduino.cli.commands.v1.MonitorRequest.open_request:type_name -> cc.arduino.cli.commands.v1.MonitorPortOpenRequest
	6, // 1: cc.arduino.cli.commands.v1.MonitorRequest.updated_configuration:type_name -> cc.arduino.cli.commands.v1.MonitorPortConfiguration
	7, // 2: cc.arduino.cli.commands.v1.MonitorPortOpenRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	8, // 3: cc.arduino.cli.commands.v1.MonitorPortOpenRequest.port:type_name -> cc.arduino.cli.commands.v1.Port
	6, // 4: cc.arduino.cli.commands.v1.MonitorPortOpenRequest.port_configuration:type_name -> cc.arduino.cli.commands.v1.MonitorPortConfiguration
	6, // 5: cc.arduino.cli.commands.v1.MonitorResponse.applied_settings:type_name -> cc.arduino.cli.commands.v1.MonitorPortConfiguration
	7, // 6: cc.arduino.cli.commands.v1.EnumerateMonitorPortSettingsRequest.instance:type_name -> cc.arduino.cli.commands.v1.Instance
	5, // 7: cc.arduino.cli.commands.v1.EnumerateMonitorPortSettingsResponse.settings:type_name -> cc.arduino.cli.commands.v1.MonitorPortSettingDescriptor
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_cc_arduino_cli_commands_v1_monitor_proto_init() }
func file_cc_arduino_cli_commands_v1_monitor_proto_init() {
	if File_cc_arduino_cli_commands_v1_monitor_proto != nil {
		return
	}
	file_cc_arduino_cli_commands_v1_common_proto_init()
	file_cc_arduino_cli_commands_v1_port_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*MonitorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*MonitorPortOpenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*MonitorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*EnumerateMonitorPortSettingsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*EnumerateMonitorPortSettingsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*MonitorPortSettingDescriptor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[0].OneofWrappers = []any{
		(*MonitorRequest_OpenRequest)(nil),
		(*MonitorRequest_TxData)(nil),
		(*MonitorRequest_UpdatedConfiguration)(nil),
		(*MonitorRequest_Close)(nil),
	}
	file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes[2].OneofWrappers = []any{
		(*MonitorResponse_Error)(nil),
		(*MonitorResponse_RxData)(nil),
		(*MonitorResponse_AppliedSettings)(nil),
		(*MonitorResponse_Success)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_cc_arduino_cli_commands_v1_monitor_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_cc_arduino_cli_commands_v1_monitor_proto_goTypes,
		DependencyIndexes: file_cc_arduino_cli_commands_v1_monitor_proto_depIdxs,
		MessageInfos:      file_cc_arduino_cli_commands_v1_monitor_proto_msgTypes,
	}.Build()
	File_cc_arduino_cli_commands_v1_monitor_proto = out.File
	file_cc_arduino_cli_commands_v1_monitor_proto_rawDesc = nil
	file_cc_arduino_cli_commands_v1_monitor_proto_goTypes = nil
	file_cc_arduino_cli_commands_v1_monitor_proto_depIdxs = nil
}
