shouldBe("Number()", "0");
shouldBe("Number(1)", "1");
shouldBe("Number(1.1)", "1.1");
shouldBe("Number('1.2')", "1.2");
shouldBe("isNaN(Number('a'))", "true");

shouldBe("(new Number()).valueOf()", "0");
shouldBe("(new Number(.4)).valueOf()", "0.4");
shouldBe("(new Number('1.')).valueOf()", "1");
shouldBe("isNaN(new Number('a'))", "true");

shouldBe("isNaN(Number.NaN)", "true");
shouldBe("Number.NEGATIVE_INFINITY", "-Infinity");
shouldBe("Number.POSITIVE_INFINITY", "Infinity");

shouldBe("(1).toString()", "'1'");
shouldBe("typeof (1).toString()", "'string'");
shouldBe("(10).toString(16)", "'a'");
shouldBe("(8.5).toString(16)", "'8.8'");
shouldBe("(-8.5).toString(16)", "'-8.8'");
shouldBe("Number.NaN.toString(16)", "'NaN'");
shouldBe("Number.POSITIVE_INFINITY.toString(16)", "'Infinity'");
shouldBe("Number.NEGATIVE_INFINITY.toString(16)", "'-Infinity'");
shouldBe("Number.MAX_VALUE.toString(2).length", "1024");
shouldBe("(1).valueOf()", "1");
shouldBe("typeof (1).valueOf()", "'number'");

function toFixedOrException(val,fractionDigits)
{
  var s = "";
  try {
    s = String(Number(val).toFixed(fractionDigits));
  }
  catch (e) {
    s = String(e);
  }
  return s;
}

shouldBe("Number(1234.567).toFixed(0)","\"1235\"");
shouldBe("Number(1234.567).toFixed(undefined)","\"1235\"");
shouldBe("Number(-1234.567).toFixed(0)","\"-1235\"");
shouldBe("Number(-1234.567).toFixed(undefined)","\"-1235\"");
shouldBe("Number(0).toFixed(7)","\"0.0000000\"");
shouldBe("Number(0.003).toFixed(0)","\"0\"");
shouldBe("Number(-0.003).toFixed(0)","\"-0\"");
shouldBe("Number(40.1234567890123).toFixed(7)","\"40.1234568\"");
shouldBe("Number(-40.1234567890123).toFixed(7)","\"-40.1234568\"");
shouldBe("Number(4).toFixed(7)","\"4.0000000\"");
shouldBe("Number(-4).toFixed(7)","\"-4.0000000\"");
shouldBe("Number(0.000056).toFixed(7)","\"0.0000560\"");
shouldBe("Number(-0.000056).toFixed(7)","\"-0.0000560\"");
shouldBe("Number(NaN).toFixed(7)","\"NaN\"");
shouldBe("Number(Infinity).toFixed(7)","\"Infinity\"");
shouldBe("Number(-Infinity).toFixed(7)","\"-Infinity\"");
shouldBe("Number(Math.pow(10,4)).toFixed(13)","\"10000.0000000000000\"");
shouldBe("Number(Math.pow(10,17)).toFixed(16)","\"100000000000000000.0000000000000000\"");
shouldBe("Number(Math.pow(10,18)).toFixed(17)","\"1000000000000000000.00000000000000000\"");
shouldBe("Number(Math.pow(10,19)).toFixed(18)","\"10000000000000000000.000000000000000000\"");
shouldBe("Number(Math.pow(10,17)).toFixed(20)","\"100000000000000000.00000000000000000000\"");
shouldBe("Number(Math.pow(10,18)).toFixed(20)","\"1000000000000000000.00000000000000000000\"");
shouldBe("Number(Math.pow(10,19)).toFixed(20)","\"10000000000000000000.00000000000000000000\"");
shouldBe("Number(Math.pow(10,20)).toFixed(20)","\"100000000000000000000.00000000000000000000\"");
shouldBe("Number(Math.pow(10,21)).toFixed(20)","\"1e+21\"");
shouldBe("Number(-Math.pow(10,4)).toFixed(13)","\"-10000.0000000000000\"");
shouldBe("Number(-Math.pow(10,17)).toFixed(16)","\"-100000000000000000.0000000000000000\"");
shouldBe("Number(-Math.pow(10,18)).toFixed(17)","\"-1000000000000000000.00000000000000000\"");
shouldBe("Number(-Math.pow(10,19)).toFixed(18)","\"-10000000000000000000.000000000000000000\"");
shouldBe("Number(-Math.pow(10,17)).toFixed(20)","\"-100000000000000000.00000000000000000000\"");
shouldBe("Number(-Math.pow(10,18)).toFixed(20)","\"-1000000000000000000.00000000000000000000\"");
shouldBe("Number(-Math.pow(10,19)).toFixed(20)","\"-10000000000000000000.00000000000000000000\"");
shouldBe("Number(-Math.pow(10,20)).toFixed(20)","\"-100000000000000000000.00000000000000000000\"");
shouldBe("Number(-Math.pow(10,21)).toFixed(20)","\"-1e+21\"");
shouldBeTrue("toFixedOrException(2,-1).indexOf('Range') >= 0");
shouldBe("Number(2).toFixed(0)","\"2\"");
shouldBe("Number(2).toFixed(20)","\"2.00000000000000000000\"");
shouldBeTrue("toFixedOrException(2,21).indexOf('Range') >= 0");
shouldBeTrue("toFixedOrException(-2,-1).indexOf('Range') >= 0");
shouldBe("Number(-2).toFixed(0)","\"-2\"");
shouldBe("Number(-2).toFixed(20)","\"-2.00000000000000000000\"");
shouldBeTrue("toFixedOrException(-2,21).indexOf('Range') >= 0");




shouldBe("Number(NaN).toExponential()","\"NaN\"");
shouldBe("Number(Infinity).toExponential()","\"Infinity\"");
shouldBe("Number(-Infinity).toExponential()","\"-Infinity\"");
shouldBe("Number(NaN).toExponential(4)","\"NaN\"");
shouldBe("Number(Infinity).toExponential(4)","\"Infinity\"");
shouldBe("Number(-Infinity).toExponential(4)","\"-Infinity\"");
shouldBe("Number(123.456).toExponential()","\"1.23456e+2\"");
shouldBeTrue("try { Number(123.456).toExponential(-1) } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBe("Number(123.456).toExponential(0)","\"1e+2\"");
shouldBe("Number(123.456).toExponential(1)","\"1.2e+2\"");
shouldBe("Number(123.456).toExponential(2)","\"1.23e+2\"");
shouldBe("Number(123.456).toExponential(3)","\"1.235e+2\"");
shouldBe("Number(123.456).toExponential(4)","\"1.2346e+2\"");
shouldBe("Number(123.456).toExponential(5)","\"1.23456e+2\"");
shouldBe("Number(123.456).toExponential(6)","\"1.234560e+2\"");
shouldBe("Number(123.456).toExponential(7)","\"1.2345600e+2\"");
shouldBe("Number(123.456).toExponential(8)","\"1.23456000e+2\"");
shouldBe("Number(123.456).toExponential(9)","\"1.234560000e+2\"");
shouldBe("Number(123.456).toExponential(10)","\"1.2345600000e+2\"");
shouldBe("Number(123.456).toExponential(11)","\"1.23456000000e+2\"");
shouldBe("Number(123.456).toExponential(12)","\"1.234560000000e+2\"");
shouldBe("Number(123.456).toExponential(13)","\"1.2345600000000e+2\"");
shouldBe("Number(123.456).toExponential(14)","\"1.23456000000000e+2\"");
shouldBe("Number(123.456).toExponential(15)","\"1.234560000000000e+2\"");
shouldBe("Number(123.456).toExponential(16)","\"1.2345600000000000e+2\"");
shouldBe("Number(123.456).toExponential(17)","\"1.23456000000000000e+2\"");
shouldBe("Number(123.456).toExponential(18)","\"1.234560000000000000e+2\"");
shouldBe("Number(123.456).toExponential(19)","\"1.2345600000000000000e+2\"");
shouldBe("Number(123.456).toExponential(20)","\"1.23456000000000000000e+2\"");
shouldBeTrue("try { Number(123.456).toExponential(21) } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBe("Number(-123.456).toExponential()","\"-1.23456e+2\"");
shouldBeTrue("try { Number(-123.456).toExponential(-1) } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBe("Number(-123.456).toExponential(0)","\"-1e+2\"");
shouldBe("Number(-123.456).toExponential(1)","\"-1.2e+2\"");
shouldBe("Number(-123.456).toExponential(2)","\"-1.23e+2\"");
shouldBe("Number(-123.456).toExponential(3)","\"-1.235e+2\"");
shouldBe("Number(-123.456).toExponential(4)","\"-1.2346e+2\"");
shouldBe("Number(-123.456).toExponential(5)","\"-1.23456e+2\"");
shouldBe("Number(-123.456).toExponential(6)","\"-1.234560e+2\"");
shouldBe("Number(-123.456).toExponential(7)","\"-1.2345600e+2\"");
shouldBe("Number(-123.456).toExponential(8)","\"-1.23456000e+2\"");
shouldBe("Number(-123.456).toExponential(9)","\"-1.234560000e+2\"");
shouldBe("Number(-123.456).toExponential(10)","\"-1.2345600000e+2\"");
shouldBe("Number(-123.456).toExponential(11)","\"-1.23456000000e+2\"");
shouldBe("Number(-123.456).toExponential(12)","\"-1.234560000000e+2\"");
shouldBe("Number(-123.456).toExponential(13)","\"-1.2345600000000e+2\"");
shouldBe("Number(-123.456).toExponential(14)","\"-1.23456000000000e+2\"");
shouldBe("Number(-123.456).toExponential(15)","\"-1.234560000000000e+2\"");
shouldBe("Number(-123.456).toExponential(16)","\"-1.2345600000000000e+2\"");
shouldBe("Number(-123.456).toExponential(17)","\"-1.23456000000000000e+2\"");
shouldBe("Number(-123.456).toExponential(18)","\"-1.234560000000000000e+2\"");
shouldBe("Number(-123.456).toExponential(19)","\"-1.2345600000000000000e+2\"");
shouldBe("Number(-123.456).toExponential(20)","\"-1.23456000000000000000e+2\"");
shouldBeTrue("try { Number(-123.456).toExponential(21) } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBe("Number(.000123456).toExponential()","\"1.23456e-4\"");
shouldBeTrue("try { Number(.000123456).toExponential(-1) } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBe("Number(.000123456).toExponential(0)","\"1e-4\"");
shouldBe("Number(.000123456).toExponential(1)","\"1.2e-4\"");
shouldBe("Number(.000123456).toExponential(2)","\"1.23e-4\"");
shouldBe("Number(.000123456).toExponential(3)","\"1.235e-4\"");
shouldBe("Number(.000123456).toExponential(4)","\"1.2346e-4\"");
shouldBe("Number(.000123456).toExponential(5)","\"1.23456e-4\"");
shouldBe("Number(.000123456).toExponential(6)","\"1.234560e-4\"");
shouldBe("Number(.000123456).toExponential(7)","\"1.2345600e-4\"");
shouldBe("Number(.000123456).toExponential(8)","\"1.23456000e-4\"");
shouldBe("Number(.000123456).toExponential(9)","\"1.234560000e-4\"");
shouldBe("Number(.000123456).toExponential(10)","\"1.2345600000e-4\"");
shouldBe("Number(.000123456).toExponential(11)","\"1.23456000000e-4\"");
shouldBe("Number(.000123456).toExponential(12)","\"1.234560000000e-4\"");
shouldBe("Number(.000123456).toExponential(13)","\"1.2345600000000e-4\"");
shouldBe("Number(.000123456).toExponential(14)","\"1.23456000000000e-4\"");
shouldBe("Number(.000123456).toExponential(15)","\"1.234560000000000e-4\"");
shouldBe("Number(.000123456).toExponential(16)","\"1.2345600000000000e-4\"");
shouldBe("Number(.000123456).toExponential(17)","\"1.23456000000000000e-4\"");
shouldBe("Number(.000123456).toExponential(18)","\"1.234560000000000000e-4\"");
shouldBe("Number(.000123456).toExponential(19)","\"1.2345600000000000000e-4\"");
shouldBe("Number(.000123456).toExponential(20)","\"1.23456000000000000000e-4\"");
shouldBeTrue("try { Number(.000123456).toExponential(21) } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBe("Number(-.000123456).toExponential()","\"-1.23456e-4\"");
shouldBeTrue("try { Number(-.000123456).toExponential(-1) } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBe("Number(-.000123456).toExponential(0)","\"-1e-4\"");
shouldBe("Number(-.000123456).toExponential(1)","\"-1.2e-4\"");
shouldBe("Number(-.000123456).toExponential(2)","\"-1.23e-4\"");
shouldBe("Number(-.000123456).toExponential(3)","\"-1.235e-4\"");
shouldBe("Number(-.000123456).toExponential(4)","\"-1.2346e-4\"");
shouldBe("Number(-.000123456).toExponential(5)","\"-1.23456e-4\"");
shouldBe("Number(-.000123456).toExponential(6)","\"-1.234560e-4\"");
shouldBe("Number(-.000123456).toExponential(7)","\"-1.2345600e-4\"");
shouldBe("Number(-.000123456).toExponential(8)","\"-1.23456000e-4\"");
shouldBe("Number(-.000123456).toExponential(9)","\"-1.234560000e-4\"");
shouldBe("Number(-.000123456).toExponential(10)","\"-1.2345600000e-4\"");
shouldBe("Number(-.000123456).toExponential(11)","\"-1.23456000000e-4\"");
shouldBe("Number(-.000123456).toExponential(12)","\"-1.234560000000e-4\"");
shouldBe("Number(-.000123456).toExponential(13)","\"-1.2345600000000e-4\"");
shouldBe("Number(-.000123456).toExponential(14)","\"-1.23456000000000e-4\"");
shouldBe("Number(-.000123456).toExponential(15)","\"-1.234560000000000e-4\"");
shouldBe("Number(-.000123456).toExponential(16)","\"-1.2345600000000000e-4\"");
shouldBe("Number(-.000123456).toExponential(17)","\"-1.23456000000000000e-4\"");
shouldBe("Number(-.000123456).toExponential(18)","\"-1.234560000000000000e-4\"");
shouldBe("Number(-.000123456).toExponential(19)","\"-1.2345600000000000000e-4\"");
shouldBe("Number(-.000123456).toExponential(20)","\"-1.23456000000000000000e-4\"");
shouldBeTrue("try { Number(-.000123456).toExponential(21) } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBe("Number(123.4567890123456789012).toExponential()","\"1.2345678901234568e+2\"");
shouldBeTrue("try { Number(123.4567890123456789012).toExponential(-1) } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBe("Number(123.4567890123456789012).toExponential(0)","\"1e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(1)","\"1.2e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(2)","\"1.23e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(3)","\"1.235e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(4)","\"1.2346e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(5)","\"1.23457e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(6)","\"1.234568e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(7)","\"1.2345679e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(8)","\"1.23456789e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(9)","\"1.234567890e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(10)","\"1.2345678901e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(11)","\"1.23456789012e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(12)","\"1.234567890123e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(13)","\"1.2345678901235e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(14)","\"1.23456789012346e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(15)","\"1.234567890123457e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(16)","\"1.2345678901234570e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(17)","\"1.23456789012345700e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(18)","\"1.234567890123457100e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(19)","\"1.2345678901234570000e+2\"");
shouldBe("Number(123.4567890123456789012).toExponential(20)","\"1.23456789012345700000e+2\"");
shouldBeTrue("try { Number(123.4567890123456789012).toExponential(21) } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBe("Number(-123.4567890123456789012).toExponential()","\"-1.2345678901234568e+2\"");
shouldBeTrue("try { Number(-123.4567890123456789012).toExponential(-1) } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBe("Number(-123.4567890123456789012).toExponential(0)","\"-1e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(1)","\"-1.2e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(2)","\"-1.23e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(3)","\"-1.235e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(4)","\"-1.2346e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(5)","\"-1.23457e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(6)","\"-1.234568e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(7)","\"-1.2345679e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(8)","\"-1.23456789e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(9)","\"-1.234567890e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(10)","\"-1.2345678901e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(11)","\"-1.23456789012e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(12)","\"-1.234567890123e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(13)","\"-1.2345678901235e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(14)","\"-1.23456789012346e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(15)","\"-1.234567890123457e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(16)","\"-1.2345678901234570e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(17)","\"-1.23456789012345700e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(18)","\"-1.234567890123457100e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(19)","\"-1.2345678901234570000e+2\"");
shouldBe("Number(-123.4567890123456789012).toExponential(20)","\"-1.23456789012345700000e+2\"");
shouldBeTrue("try { Number(-123.4567890123456789012).toExponential(21) } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBe("Number(.0000000000000000000001).toExponential()","\"1e-22\"");
shouldBe("Number(.0000000000000000000012).toExponential()","\"1.2e-21\"");
shouldBe("Number(.0000000000000000000123).toExponential()","\"1.23e-20\"");
shouldBe("Number(.0000000000000000000123).toExponential()","\"1.23e-20\"");
shouldBe("Number(.0000000000000000001234).toExponential()","\"1.234e-19\"");
shouldBe("Number(.0000000000000000012345).toExponential()","\"1.2345e-18\"");
shouldBe("Number(.0000000000000000123456).toExponential()","\"1.23456e-17\"");
shouldBe("Number(.0000000000000001234567).toExponential()","\"1.234567e-16\"");
shouldBe("Number(.0000000000000012345678).toExponential()","\"1.2345678e-15\"");
shouldBe("Number(.0000000000000123456789).toExponential()","\"1.23456789e-14\"");
shouldBe("Number(.0000000000001234567890).toExponential()","\"1.23456789e-13\"");
shouldBe("Number(.0000000000012345678901).toExponential()","\"1.2345678901e-12\"");
shouldBe("Number(.0000000000123456789012).toExponential()","\"1.23456789012e-11\"");
shouldBe("Number(.0000000001234567890123).toExponential()","\"1.234567890123e-10\"");
shouldBe("Number(.0000000012345678901234).toExponential()","\"1.2345678901234e-9\"");
shouldBe("Number(.0000000123456789012345).toExponential()","\"1.23456789012345e-8\"");
shouldBe("Number(.0000001234567890123456).toExponential()","\"1.234567890123456e-7\"");
shouldBe("Number(.0000012345678901234567).toExponential()","\"1.2345678901234567e-6\"");
shouldBe("Number(.0000123456789012345678).toExponential()","\"1.2345678901234568e-5\"");
shouldBe("Number(.0001234567890123456789).toExponential()","\"1.2345678901234567e-4\"");
shouldBe("Number(.0012345678901234567890).toExponential()","\"1.2345678901234567e-3\"");
shouldBe("Number(.0123456789012345678901).toExponential()","\"1.2345678901234568e-2\"");
shouldBe("Number(1.234567890123456789012).toExponential()","\"1.2345678901234567e+0\"");
shouldBe("Number(12.34567890123456789012).toExponential()","\"1.2345678901234567e+1\"");
shouldBe("Number(123.4567890123456789012).toExponential()","\"1.2345678901234568e+2\"");
shouldBe("Number(1234.567890123456789012).toExponential()","\"1.234567890123457e+3\"");
shouldBe("Number(12345.67890123456789012).toExponential()","\"1.2345678901234567e+4\"");
shouldBe("Number(123456.7890123456789012).toExponential()","\"1.2345678901234567e+5\"");
shouldBe("Number(1234567.890123456789012).toExponential()","\"1.2345678901234567e+6\"");
shouldBe("Number(12345678.90123456789012).toExponential()","\"1.2345678901234567e+7\"");
shouldBe("Number(123456789.0123456789012).toExponential()","\"1.2345678901234567e+8\"");
shouldBe("Number(1234567890.123456789012).toExponential()","\"1.2345678901234567e+9\"");
shouldBe("Number(12345678901.23456789012).toExponential()","\"1.2345678901234568e+10\"");
shouldBe("Number(123456789012.3456789012).toExponential()","\"1.2345678901234567e+11\"");
shouldBe("Number(1234567890123.456789012).toExponential()","\"1.2345678901234568e+12\"");
shouldBe("Number(12345678901234.56789012).toExponential()","\"1.2345678901234568e+13\"");
shouldBe("Number(123456789012345.6789012).toExponential()","\"1.2345678901234567e+14\"");
shouldBe("Number(1234567890123456.789012).toExponential()","\"1.2345678901234568e+15\"");
shouldBe("Number(12345678901234567.89012).toExponential()","\"1.2345678901234568e+16\"");
shouldBe("Number(123456789012345678.9012).toExponential()","\"1.2345678901234568e+17\"");
shouldBe("Number(1234567890123456789.012).toExponential()","\"1.2345678901234568e+18\"");
shouldBe("Number(12345678901234567890.12).toExponential()","\"1.2345678901234567e+19\"");
shouldBe("Number(123456789012345678901.2).toExponential()","\"1.2345678901234568e+20\"");
shouldBe("Number(-.0000000000000000000001).toExponential()","\"-1e-22\"");
shouldBe("Number(-.0000000000000000000012).toExponential()","\"-1.2e-21\"");
shouldBe("Number(-.0000000000000000000123).toExponential()","\"-1.23e-20\"");
shouldBe("Number(-.0000000000000000000123).toExponential()","\"-1.23e-20\"");
shouldBe("Number(-.0000000000000000001234).toExponential()","\"-1.234e-19\"");
shouldBe("Number(-.0000000000000000012345).toExponential()","\"-1.2345e-18\"");
shouldBe("Number(-.0000000000000000123456).toExponential()","\"-1.23456e-17\"");
shouldBe("Number(-.0000000000000001234567).toExponential()","\"-1.234567e-16\"");
shouldBe("Number(-.0000000000000012345678).toExponential()","\"-1.2345678e-15\"");
shouldBe("Number(-.0000000000000123456789).toExponential()","\"-1.23456789e-14\"");
shouldBe("Number(-.0000000000001234567890).toExponential()","\"-1.23456789e-13\"");
shouldBe("Number(-.0000000000012345678901).toExponential()","\"-1.2345678901e-12\"");
shouldBe("Number(-.0000000000123456789012).toExponential()","\"-1.23456789012e-11\"");
shouldBe("Number(-.0000000001234567890123).toExponential()","\"-1.234567890123e-10\"");
shouldBe("Number(-.0000000012345678901234).toExponential()","\"-1.2345678901234e-9\"");
shouldBe("Number(-.0000000123456789012345).toExponential()","\"-1.23456789012345e-8\"");
shouldBe("Number(-.0000001234567890123456).toExponential()","\"-1.234567890123456e-7\"");
shouldBe("Number(-.0000012345678901234567).toExponential()","\"-1.2345678901234567e-6\"");
shouldBe("Number(-.0000123456789012345678).toExponential()","\"-1.2345678901234568e-5\"");
shouldBe("Number(-.0001234567890123456789).toExponential()","\"-1.2345678901234567e-4\"");
shouldBe("Number(-.0012345678901234567890).toExponential()","\"-1.2345678901234567e-3\"");
shouldBe("Number(-.0123456789012345678901).toExponential()","\"-1.2345678901234568e-2\"");
shouldBe("Number(-1.234567890123456789012).toExponential()","\"-1.2345678901234567e+0\"");
shouldBe("Number(-12.34567890123456789012).toExponential()","\"-1.2345678901234567e+1\"");
shouldBe("Number(-123.4567890123456789012).toExponential()","\"-1.2345678901234568e+2\"");
shouldBe("Number(-1234.567890123456789012).toExponential()","\"-1.234567890123457e+3\"");
shouldBe("Number(-12345.67890123456789012).toExponential()","\"-1.2345678901234567e+4\"");
shouldBe("Number(-123456.7890123456789012).toExponential()","\"-1.2345678901234567e+5\"");
shouldBe("Number(-1234567.890123456789012).toExponential()","\"-1.2345678901234567e+6\"");
shouldBe("Number(-12345678.90123456789012).toExponential()","\"-1.2345678901234567e+7\"");
shouldBe("Number(-123456789.0123456789012).toExponential()","\"-1.2345678901234567e+8\"");
shouldBe("Number(-1234567890.123456789012).toExponential()","\"-1.2345678901234567e+9\"");
shouldBe("Number(-12345678901.23456789012).toExponential()","\"-1.2345678901234568e+10\"");
shouldBe("Number(-123456789012.3456789012).toExponential()","\"-1.2345678901234567e+11\"");
shouldBe("Number(-1234567890123.456789012).toExponential()","\"-1.2345678901234568e+12\"");
shouldBe("Number(-12345678901234.56789012).toExponential()","\"-1.2345678901234568e+13\"");
shouldBe("Number(-123456789012345.6789012).toExponential()","\"-1.2345678901234567e+14\"");
shouldBe("Number(-1234567890123456.789012).toExponential()","\"-1.2345678901234568e+15\"");
shouldBe("Number(-12345678901234567.89012).toExponential()","\"-1.2345678901234568e+16\"");
shouldBe("Number(-123456789012345678.9012).toExponential()","\"-1.2345678901234568e+17\"");
shouldBe("Number(-1234567890123456789.012).toExponential()","\"-1.2345678901234568e+18\"");
shouldBe("Number(-12345678901234567890.12).toExponential()","\"-1.2345678901234567e+19\"");
shouldBe("Number(-123456789012345678901.2).toExponential()","\"-1.2345678901234568e+20\"");

shouldBeTrue("try { Number(1).toPrecision(-1); } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBeTrue("try { Number(1).toPrecision(0); } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBe("try { Number(1).toPrecision(1); } catch (e) { String(e); }","\"1\"");
shouldBe("try { Number(1).toPrecision(21); } catch (e) { String(e); }","\"1.00000000000000000000\"");
shouldBeTrue("try { Number(1).toPrecision(22); } catch (e) { String(e).indexOf('Range') >= 0; }");
shouldBe("Number(NaN).toPrecision()","\"NaN\"");
shouldBe("Number(NaN).toPrecision(1)","\"NaN\"");
shouldBe("Number(Infinity).toPrecision()","\"Infinity\"");
shouldBe("Number(Infinity).toPrecision(1)","\"Infinity\"");
shouldBe("Number(-Infinity).toPrecision()","\"-Infinity\"");
shouldBe("Number(-Infinity).toPrecision(1)","\"-Infinity\"");
shouldBe("Number(.0000000012345).toPrecision(2)","\"1.2e-9\"");
shouldBe("Number(.000000012345).toPrecision(2)","\"1.2e-8\"");
shouldBe("Number(.00000012345).toPrecision(2)","\"1.2e-7\"");
shouldBe("Number(.0000012345).toPrecision(2)","\"0.0000012\"");
shouldBe("Number(.000012345).toPrecision(2)","\"0.000012\"");
shouldBe("Number(.00012345).toPrecision(2)","\"0.00012\"");
shouldBe("Number(.0012345).toPrecision(2)","\"0.0012\"");
shouldBe("Number(.012345).toPrecision(2)","\"0.012\"");
shouldBe("Number(.12345).toPrecision(2)","\"0.12\"");
shouldBe("Number(1.2345).toPrecision(2)","\"1.2\"");
shouldBe("Number(12.345).toPrecision(2)","\"12\"");
shouldBe("Number(123.45).toPrecision(2)","\"1.2e+2\"");
shouldBe("Number(1234.5).toPrecision(2)","\"1.2e+3\"");
shouldBe("Number(12345).toPrecision(2)","\"1.2e+4\"");
shouldBe("Number(12345.67).toPrecision(4)","\"1.235e+4\"");
shouldBe("Number(12344.67).toPrecision(4)","\"1.234e+4\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision()","\"0.00012345678901234567\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(1)","\"0.0001\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(2)","\"0.00012\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(3)","\"0.000123\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(4)","\"0.0001235\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(5)","\"0.00012346\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(6)","\"0.000123457\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(7)","\"0.0001234568\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(8)","\"0.00012345679\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(9)","\"0.000123456789\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(10)","\"0.0001234567890\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(11)","\"0.00012345678901\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(12)","\"0.000123456789012\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(13)","\"0.0001234567890123\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(14)","\"0.00012345678901235\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(15)","\"0.000123456789012346\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(16)","\"0.0001234567890123457\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(17)","\"0.00012345678901234568\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(18)","\"0.000123456789012345680\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(19)","\"0.0001234567890123456800\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(20)","\"0.00012345678901234567000\"");
shouldBe("Number(0.0001234567890123456789012345).toPrecision(21)","\"0.000123456789012345680000\"");
shouldBe("Number(12345.67890123456789012345).toPrecision()","\"12345.678901234567\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(1)","\"1e+4\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(2)","\"1.2e+4\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(3)","\"1.23e+4\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(4)","\"1.235e+4\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(5)","\"12346\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(6)","\"12345.7\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(7)","\"12345.68\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(8)","\"12345.679\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(9)","\"12345.6789\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(10)","\"12345.67890\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(11)","\"12345.678901\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(12)","\"12345.6789012\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(13)","\"12345.67890123\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(14)","\"12345.678901235\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(15)","\"12345.6789012346\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(16)","\"12345.67890123457\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(17)","\"12345.678901234568\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(18)","\"12345.6789012345660\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(19)","\"12345.67890123456800\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(20)","\"12345.678901234565000\"");
shouldBe("Number(12345.67890123456789012345).toPrecision(21)","\"12345.6789012345670000\"");
shouldBe("Number(-.0000000012345).toPrecision(2)","\"-1.2e-9\"");
shouldBe("Number(-.000000012345).toPrecision(2)","\"-1.2e-8\"");
shouldBe("Number(-.00000012345).toPrecision(2)","\"-1.2e-7\"");
shouldBe("Number(-.0000012345).toPrecision(2)","\"-0.0000012\"");
shouldBe("Number(-.000012345).toPrecision(2)","\"-0.000012\"");
shouldBe("Number(-.00012345).toPrecision(2)","\"-0.00012\"");
shouldBe("Number(-.0012345).toPrecision(2)","\"-0.0012\"");
shouldBe("Number(-.012345).toPrecision(2)","\"-0.012\"");
shouldBe("Number(-.12345).toPrecision(2)","\"-0.12\"");
shouldBe("Number(-1.2345).toPrecision(2)","\"-1.2\"");
shouldBe("Number(-12.345).toPrecision(2)","\"-12\"");
shouldBe("Number(-123.45).toPrecision(2)","\"-1.2e+2\"");
shouldBe("Number(-1234.5).toPrecision(2)","\"-1.2e+3\"");
shouldBe("Number(-12345).toPrecision(2)","\"-1.2e+4\"");
shouldBe("Number(-12345.67).toPrecision(4)","\"-1.235e+4\"");
shouldBe("Number(-12344.67).toPrecision(4)","\"-1.234e+4\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision()","\"-0.00012345678901234567\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(1)","\"-0.0001\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(2)","\"-0.00012\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(3)","\"-0.000123\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(4)","\"-0.0001235\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(5)","\"-0.00012346\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(6)","\"-0.000123457\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(7)","\"-0.0001234568\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(8)","\"-0.00012345679\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(9)","\"-0.000123456789\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(10)","\"-0.0001234567890\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(11)","\"-0.00012345678901\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(12)","\"-0.000123456789012\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(13)","\"-0.0001234567890123\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(14)","\"-0.00012345678901235\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(15)","\"-0.000123456789012346\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(16)","\"-0.0001234567890123457\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(17)","\"-0.00012345678901234568\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(18)","\"-0.000123456789012345680\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(19)","\"-0.0001234567890123456800\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(20)","\"-0.00012345678901234567000\"");
shouldBe("Number(-0.0001234567890123456789012345).toPrecision(21)","\"-0.000123456789012345680000\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision()","\"-12345.678901234567\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(1)","\"-1e+4\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(2)","\"-1.2e+4\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(3)","\"-1.23e+4\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(4)","\"-1.235e+4\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(5)","\"-12346\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(6)","\"-12345.7\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(7)","\"-12345.68\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(8)","\"-12345.679\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(9)","\"-12345.6789\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(10)","\"-12345.67890\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(11)","\"-12345.678901\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(12)","\"-12345.6789012\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(13)","\"-12345.67890123\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(14)","\"-12345.678901235\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(15)","\"-12345.6789012346\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(16)","\"-12345.67890123457\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(17)","\"-12345.678901234568\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(18)","\"-12345.6789012345660\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(19)","\"-12345.67890123456800\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(20)","\"-12345.678901234565000\"");
shouldBe("Number(-12345.67890123456789012345).toPrecision(21)","\"-12345.6789012345670000\"");
shouldBe("Number(0).toPrecision()","\"0\"");
shouldBe("Number(0).toPrecision(1)","\"0\"");
shouldBe("Number(0).toPrecision(2)","\"0.0\"");
shouldBe("Number(0).toPrecision(3)","\"0.00\"");
shouldBe("Number(0).toPrecision(4)","\"0.000\"");
shouldBe("Number(0).toPrecision(5)","\"0.0000\"");
shouldBe("Number(0).toPrecision(6)","\"0.00000\"");
shouldBe("Number(0).toPrecision(7)","\"0.000000\"");
shouldBe("Number(0).toPrecision(8)","\"0.0000000\"");
shouldBe("Number(0).toPrecision(9)","\"0.00000000\"");
shouldBe("Number(0).toPrecision(10)","\"0.000000000\"");
shouldBe("Number(0).toPrecision(11)","\"0.0000000000\"");
shouldBe("Number(0).toPrecision(12)","\"0.00000000000\"");
shouldBe("Number(0).toPrecision(13)","\"0.000000000000\"");
shouldBe("Number(0).toPrecision(14)","\"0.0000000000000\"");
shouldBe("Number(0).toPrecision(15)","\"0.00000000000000\"");
shouldBe("Number(0).toPrecision(16)","\"0.000000000000000\"");
shouldBe("Number(0).toPrecision(17)","\"0.0000000000000000\"");
shouldBe("Number(0).toPrecision(18)","\"0.00000000000000000\"");
shouldBe("Number(0).toPrecision(19)","\"0.000000000000000000\"");
shouldBe("Number(0).toPrecision(20)","\"0.0000000000000000000\"");
shouldBe("Number(0).toPrecision(21)","\"0.00000000000000000000\"");
successfullyParsed = true
