
  struct AvailableComponent {
    /// The name of the component.
    const char *Name;

    /// The name of the library for this component (or NULL).
    const char *Library;

    /// Whether the component is installed.
    bool IsInstalled;

    /// The list of libraries required when linking this component.
    const char *RequiredLibraries[220];
  } AvailableComponents[220] = {
  { "aarch64", nullptr, true, {"aarch64codegen", "aarch64asmparser", "aarch64disassembler", "aarch64desc", "aarch64info", "aarch64utils"} },
{ "aarch64asmparser", "LLVMAArch64AsmParser", true, {"aarch64desc", "aarch64info", "aarch64utils", "codegentypes", "mc", "mcparser", "support", "targetparser"} },
{ "aarch64codegen", "LLVMAArch64CodeGen", true, {"aarch64desc", "aarch64info", "aarch64utils", "analysis", "asmprinter", "cfguard", "codegen", "codegentypes", "core", "globalisel", "mc", "scalaropts", "selectiondag", "support", "target", "targetparser", "transformutils", "vectorize"} },
{ "aarch64desc", "LLVMAArch64Desc", true, {"aarch64info", "aarch64utils", "binaryformat", "codegentypes", "mc", "support", "targetparser"} },
{ "aarch64disassembler", "LLVMAArch64Disassembler", true, {"aarch64desc", "aarch64info", "aarch64utils", "mc", "mcdisassembler", "support"} },
{ "aarch64info", "LLVMAArch64Info", true, {"mc", "support"} },
{ "aarch64utils", "LLVMAArch64Utils", true, {"support", "core"} },
{ "aggressiveinstcombine", "LLVMAggressiveInstCombine", true, {"analysis", "core", "support", "transformutils"} },
{ "all", nullptr, true, {"demangle", "support", "tablegen", "core", "fuzzercli", "fuzzmutate", "filecheck", "interfacestub", "irprinter", "irreader", "cgdata", "codegen", "selectiondag", "asmprinter", "mirparser", "globalisel", "codegentypes", "binaryformat", "bitreader", "bitwriter", "bitstreamreader", "dwarflinker", "dwarflinkerclassic", "dwarflinkerparallel", "extensions", "frontendatomic", "frontenddirective", "frontenddriver", "frontendhlsl", "frontendopenacc", "frontendopenmp", "frontendoffloading", "transformutils", "instrumentation", "aggressiveinstcombine", "instcombine", "scalaropts", "ipo", "vectorize", "objcarcopts", "coroutines", "cfguard", "hipstdpar", "linker", "analysis", "lto", "mc", "mcparser", "mcdisassembler", "mca", "objcopy", "object", "objectyaml", "option", "remarks", "debuginfodwarflowlevel", "debuginfodwarf", "debuginfogsym", "debuginfologicalview", "debuginfomsf", "debuginfocodeview", "debuginfopdb", "symbolize", "debuginfobtf", "dwarfcfichecker", "dwp", "executionengine", "interpreter", "jitlink", "mcjit", "orcjit", "orcdebugging", "orcshared", "orctargetprocess", "runtimedyld", "perfjitevents", "target", "aarch64codegen", "aarch64asmparser", "aarch64disassembler", "aarch64desc", "aarch64info", "aarch64utils", "amdgpucodegen", "amdgpuasmparser", "amdgpudisassembler", "amdgputargetmca", "amdgpudesc", "amdgpuinfo", "amdgpuutils", "armcodegen", "armasmparser", "armdisassembler", "armdesc", "arminfo", "armutils", "avrcodegen", "avrasmparser", "avrdisassembler", "avrdesc", "avrinfo", "bpfcodegen", "bpfasmparser", "bpfdisassembler", "bpfdesc", "bpfinfo", "hexagoncodegen", "hexagonasmparser", "hexagondisassembler", "hexagondesc", "hexagoninfo", "lanaicodegen", "lanaiasmparser", "lanaidisassembler", "lanaidesc", "lanaiinfo", "loongarchcodegen", "loongarchasmparser", "loongarchdisassembler", "loongarchdesc", "loongarchinfo", "mipscodegen", "mipsasmparser", "mipsdisassembler", "mipsdesc", "mipsinfo", "msp430codegen", "msp430desc", "msp430info", "msp430asmparser", "msp430disassembler", "nvptxcodegen", "nvptxdesc", "nvptxinfo", "powerpccodegen", "powerpcasmparser", "powerpcdisassembler", "powerpcdesc", "powerpcinfo", "riscvcodegen", "riscvasmparser", "riscvdisassembler", "riscvdesc", "riscvtargetmca", "riscvinfo", "sparccodegen", "sparcasmparser", "sparcdisassembler", "sparcdesc", "sparcinfo", "spirvcodegen", "spirvdesc", "spirvinfo", "spirvanalysis", "systemzcodegen", "systemzasmparser", "systemzdisassembler", "systemzdesc", "systemzinfo", "vecodegen", "veasmparser", "vedisassembler", "veinfo", "vedesc", "webassemblycodegen", "webassemblyasmparser", "webassemblydisassembler", "webassemblydesc", "webassemblyinfo", "webassemblyutils", "x86codegen", "x86asmparser", "x86disassembler", "x86targetmca", "x86desc", "x86info", "xcorecodegen", "xcoredisassembler", "xcoredesc", "xcoreinfo", "sandboxir", "asmparser", "lineeditor", "profiledata", "coverage", "passes", "targetparser", "textapi", "textapibinaryreader", "telemetry", "dlltooldriver", "libdriver", "xray", "windowsdriver", "windowsmanifest", "all-targets", "engine", "native", "nativecodegen", "aarch64", "amdgpu", "arm", "avr", "bpf", "hexagon", "lanai", "loongarch", "mips", "msp430", "nvptx", "powerpc", "riscv", "sparc", "spirv", "systemz", "ve", "webassembly", "x86", "xcore"} },
{ "all-targets", nullptr, true, {"aarch64", "amdgpu", "arm", "avr", "bpf", "hexagon", "lanai", "loongarch", "mips", "msp430", "nvptx", "powerpc", "riscv", "sparc", "spirv", "systemz", "ve", "webassembly", "x86", "xcore"} },
{ "amdgpu", nullptr, true, {"amdgpucodegen", "amdgpuasmparser", "amdgpudisassembler", "amdgputargetmca", "amdgpudesc", "amdgpuinfo", "amdgpuutils"} },
{ "amdgpuasmparser", "LLVMAMDGPUAsmParser", true, {"amdgpudesc", "amdgpuinfo", "amdgpuutils", "codegentypes", "mc", "mcparser", "support", "targetparser"} },
{ "amdgpucodegen", "LLVMAMDGPUCodeGen", true, {"amdgpudesc", "amdgpuinfo", "amdgpuutils", "analysis", "asmprinter", "binaryformat", "codegen", "codegentypes", "core", "globalisel", "hipstdpar", "ipo", "irprinter", "instrumentation", "mc", "mirparser", "passes", "scalaropts", "selectiondag", "support", "target", "targetparser", "transformutils", "vectorize"} },
{ "amdgpudesc", "LLVMAMDGPUDesc", true, {"amdgpuinfo", "amdgpuutils", "binaryformat", "codegentypes", "core", "mc", "support", "targetparser"} },
{ "amdgpudisassembler", "LLVMAMDGPUDisassembler", true, {"amdgpudesc", "amdgpuinfo", "amdgpuutils", "codegentypes", "mc", "mcdisassembler", "support"} },
{ "amdgpuinfo", "LLVMAMDGPUInfo", true, {"mc", "support"} },
{ "amdgputargetmca", "LLVMAMDGPUTargetMCA", true, {"amdgpudesc", "amdgpuinfo", "amdgpuutils", "codegentypes", "mc", "mca", "mcparser", "support", "targetparser"} },
{ "amdgpuutils", "LLVMAMDGPUUtils", true, {"analysis", "binaryformat", "codegentypes", "core", "mc", "mcparser", "support", "targetparser"} },
{ "analysis", "LLVMAnalysis", true, {"binaryformat", "core", "object", "profiledata", "support", "targetparser"} },
{ "arm", nullptr, true, {"armcodegen", "armasmparser", "armdisassembler", "armdesc", "arminfo", "armutils"} },
{ "armasmparser", "LLVMARMAsmParser", true, {"armdesc", "arminfo", "armutils", "codegentypes", "mc", "mcparser", "support", "targetparser"} },
{ "armcodegen", "LLVMARMCodeGen", true, {"armdesc", "arminfo", "armutils", "analysis", "asmprinter", "cfguard", "codegen", "codegentypes", "core", "globalisel", "ipo", "mc", "scalaropts", "selectiondag", "support", "target", "targetparser", "transformutils"} },
{ "armdesc", "LLVMARMDesc", true, {"arminfo", "armutils", "binaryformat", "codegentypes", "mc", "mcdisassembler", "object", "support", "targetparser"} },
{ "armdisassembler", "LLVMARMDisassembler", true, {"armdesc", "arminfo", "armutils", "codegentypes", "mc", "mcdisassembler", "support"} },
{ "arminfo", "LLVMARMInfo", true, {"mc", "support"} },
{ "armutils", "LLVMARMUtils", true, {"support"} },
{ "asmparser", "LLVMAsmParser", true, {"binaryformat", "core", "support", "targetparser"} },
{ "asmprinter", "LLVMAsmPrinter", true, {"analysis", "binaryformat", "codegen", "codegentypes", "core", "debuginfocodeview", "debuginfodwarf", "debuginfodwarflowlevel", "mc", "mcparser", "remarks", "support", "target", "targetparser"} },
{ "avr", nullptr, true, {"avrcodegen", "avrasmparser", "avrdisassembler", "avrdesc", "avrinfo"} },
{ "avrasmparser", "LLVMAVRAsmParser", true, {"avrdesc", "avrinfo", "codegentypes", "mc", "mcparser", "support"} },
{ "avrcodegen", "LLVMAVRCodeGen", true, {"avrdesc", "avrinfo", "asmprinter", "codegen", "codegentypes", "core", "mc", "selectiondag", "support", "target"} },
{ "avrdesc", "LLVMAVRDesc", true, {"mc", "avrinfo", "support", "targetparser"} },
{ "avrdisassembler", "LLVMAVRDisassembler", true, {"avrinfo", "codegentypes", "mc", "mcdisassembler", "support"} },
{ "avrinfo", "LLVMAVRInfo", true, {"mc", "support"} },
{ "binaryformat", "LLVMBinaryFormat", true, {"support", "targetparser"} },
{ "bitreader", "LLVMBitReader", true, {"bitstreamreader", "core", "support", "targetparser"} },
{ "bitstreamreader", "LLVMBitstreamReader", true, {"support"} },
{ "bitwriter", "LLVMBitWriter", true, {"analysis", "core", "mc", "object", "profiledata", "support", "targetparser"} },
{ "bpf", nullptr, true, {"bpfcodegen", "bpfasmparser", "bpfdisassembler", "bpfdesc", "bpfinfo"} },
{ "bpfasmparser", "LLVMBPFAsmParser", true, {"mc", "mcparser", "bpfdesc", "bpfinfo", "support"} },
{ "bpfcodegen", "LLVMBPFCodeGen", true, {"analysis", "asmprinter", "bpfdesc", "bpfinfo", "codegen", "codegentypes", "core", "globalisel", "ipo", "mc", "passes", "scalaropts", "selectiondag", "support", "target", "targetparser", "transformutils"} },
{ "bpfdesc", "LLVMBPFDesc", true, {"mc", "bpfinfo", "support", "targetparser"} },
{ "bpfdisassembler", "LLVMBPFDisassembler", true, {"mcdisassembler", "mc", "bpfinfo", "support"} },
{ "bpfinfo", "LLVMBPFInfo", true, {"mc", "support"} },
{ "cfguard", "LLVMCFGuard", true, {"core", "support", "targetparser"} },
{ "cgdata", "LLVMCGData", true, {"bitreader", "bitwriter", "core", "support", "object"} },
{ "codegen", "LLVMCodeGen", true, {"analysis", "bitreader", "bitwriter", "cgdata", "codegentypes", "core", "mc", "objcarcopts", "profiledata", "scalaropts", "support", "target", "targetparser", "transformutils"} },
{ "codegentypes", "LLVMCodeGenTypes", true, {"support"} },
{ "core", "LLVMCore", true, {"binaryformat", "demangle", "remarks", "support", "targetparser"} },
{ "coroutines", "LLVMCoroutines", true, {"analysis", "core", "ipo", "scalaropts", "support", "transformutils", "targetparser"} },
{ "coverage", "LLVMCoverage", true, {"core", "object", "profiledata", "support", "targetparser"} },
{ "debuginfobtf", "LLVMDebugInfoBTF", true, {"support"} },
{ "debuginfocodeview", "LLVMDebugInfoCodeView", true, {"support"} },
{ "debuginfodwarf", "LLVMDebugInfoDWARF", true, {"binaryformat", "debuginfodwarflowlevel", "object", "support", "targetparser"} },
{ "debuginfodwarflowlevel", "LLVMDebugInfoDWARFLowLevel", true, {"binaryformat", "support", "targetparser"} },
{ "debuginfogsym", "LLVMDebugInfoGSYM", true, {"mc", "object", "support", "targetparser", "debuginfodwarf"} },
{ "debuginfologicalview", "LLVMDebugInfoLogicalView", true, {"binaryformat", "demangle", "object", "mc", "support", "targetparser", "debuginfocodeview", "debuginfodwarf", "debuginfodwarflowlevel", "debuginfopdb"} },
{ "debuginfomsf", "LLVMDebugInfoMSF", true, {"support"} },
{ "debuginfopdb", "LLVMDebugInfoPDB", true, {"binaryformat", "object", "support", "debuginfocodeview", "debuginfomsf"} },
{ "demangle", "LLVMDemangle", true, {} },
{ "dlltooldriver", "LLVMDlltoolDriver", true, {"binaryformat", "object", "option", "support", "targetparser"} },
{ "dwarfcfichecker", "LLVMDWARFCFIChecker", true, {"mc", "debuginfodwarflowlevel", "support"} },
{ "dwarflinker", "LLVMDWARFLinker", true, {"binaryformat", "codegen", "debuginfodwarf", "object", "support"} },
{ "dwarflinkerclassic", "LLVMDWARFLinkerClassic", true, {"asmprinter", "binaryformat", "codegen", "codegentypes", "debuginfodwarf", "debuginfodwarflowlevel", "dwarflinker", "mc", "object", "support", "targetparser"} },
{ "dwarflinkerparallel", "LLVMDWARFLinkerParallel", true, {"asmprinter", "binaryformat", "codegen", "debuginfodwarf", "debuginfodwarflowlevel", "dwarflinker", "mc", "object", "support", "targetparser"} },
{ "dwp", "LLVMDWP", true, {"debuginfodwarf", "mc", "object", "support"} },
{ "engine", nullptr, true, {"interpreter"} },
{ "executionengine", "LLVMExecutionEngine", true, {"core", "mc", "object", "orctargetprocess", "runtimedyld", "support", "target", "targetparser"} },
{ "extensions", "LLVMExtensions", true, {"support"} },
{ "filecheck", "LLVMFileCheck", true, {} },
{ "frontendatomic", "LLVMFrontendAtomic", true, {"core", "support", "analysis"} },
{ "frontenddirective", "LLVMFrontendDirective", true, {"support"} },
{ "frontenddriver", "LLVMFrontendDriver", true, {"core", "support", "analysis", "instrumentation"} },
{ "frontendhlsl", "LLVMFrontendHLSL", true, {"binaryformat", "core", "support"} },
{ "frontendoffloading", "LLVMFrontendOffloading", true, {"core", "binaryformat", "object", "objectyaml", "support", "transformutils", "targetparser"} },
{ "frontendopenacc", "LLVMFrontendOpenACC", true, {} },
{ "frontendopenmp", "LLVMFrontendOpenMP", true, {"core", "support", "targetparser", "transformutils", "analysis", "demangle", "mc", "scalaropts", "bitreader", "frontendoffloading", "frontendatomic", "frontenddirective"} },
{ "fuzzercli", "LLVMFuzzerCLI", true, {"support", "targetparser"} },
{ "fuzzmutate", "LLVMFuzzMutate", true, {"analysis", "bitreader", "bitwriter", "core", "scalaropts", "support", "targetparser", "transformutils"} },
{ "globalisel", "LLVMGlobalISel", true, {"analysis", "codegen", "codegentypes", "core", "mc", "selectiondag", "support", "target", "transformutils"} },
{ "hexagon", nullptr, true, {"hexagoncodegen", "hexagonasmparser", "hexagondisassembler", "hexagondesc", "hexagoninfo"} },
{ "hexagonasmparser", "LLVMHexagonAsmParser", true, {"mc", "mcparser", "support", "hexagondesc", "hexagoninfo"} },
{ "hexagoncodegen", "LLVMHexagonCodeGen", true, {"analysis", "asmprinter", "codegen", "codegentypes", "core", "hexagonasmparser", "hexagondesc", "hexagoninfo", "ipo", "mc", "scalaropts", "selectiondag", "support", "target", "targetparser", "transformutils"} },
{ "hexagondesc", "LLVMHexagonDesc", true, {"hexagoninfo", "mc", "support"} },
{ "hexagondisassembler", "LLVMHexagonDisassembler", true, {"hexagondesc", "hexagoninfo", "mc", "mcdisassembler", "support"} },
{ "hexagoninfo", "LLVMHexagonInfo", true, {"mc", "support"} },
{ "hipstdpar", "LLVMHipStdPar", true, {"analysis", "core", "support", "transformutils"} },
{ "instcombine", "LLVMInstCombine", true, {"analysis", "core", "support", "transformutils"} },
{ "instrumentation", "LLVMInstrumentation", true, {"analysis", "core", "demangle", "mc", "support", "targetparser", "transformutils", "profiledata"} },
{ "interfacestub", "LLVMInterfaceStub", true, {"binaryformat", "mc", "object", "support", "targetparser"} },
{ "interpreter", "LLVMInterpreter", true, {"codegen", "core", "executionengine", "support"} },
{ "ipo", "LLVMipo", true, {"aggressiveinstcombine", "analysis", "bitreader", "bitwriter", "core", "frontendopenmp", "instcombine", "irreader", "demangle", "linker", "object", "profiledata", "scalaropts", "support", "targetparser", "transformutils", "vectorize", "instrumentation"} },
{ "irprinter", "LLVMIRPrinter", true, {"analysis", "core", "support"} },
{ "irreader", "LLVMIRReader", true, {"asmparser", "bitreader", "core", "support"} },
{ "jitlink", "LLVMJITLink", true, {"binaryformat", "object", "option", "orctargetprocess", "support", "targetparser"} },
{ "lanai", nullptr, true, {"lanaicodegen", "lanaiasmparser", "lanaidisassembler", "lanaidesc", "lanaiinfo"} },
{ "lanaiasmparser", "LLVMLanaiAsmParser", true, {"codegentypes", "lanaidesc", "lanaiinfo", "mc", "mcparser", "support"} },
{ "lanaicodegen", "LLVMLanaiCodeGen", true, {"analysis", "asmprinter", "codegen", "codegentypes", "core", "lanaiasmparser", "lanaidesc", "lanaiinfo", "mc", "selectiondag", "support", "target", "targetparser", "transformutils"} },
{ "lanaidesc", "LLVMLanaiDesc", true, {"lanaiinfo", "mc", "mcdisassembler", "support", "targetparser"} },
{ "lanaidisassembler", "LLVMLanaiDisassembler", true, {"codegentypes", "lanaidesc", "lanaiinfo", "mc", "mcdisassembler", "support"} },
{ "lanaiinfo", "LLVMLanaiInfo", true, {"mc", "support"} },
{ "libdriver", "LLVMLibDriver", true, {"binaryformat", "bitreader", "object", "option", "support", "targetparser", "binaryformat", "bitreader", "object", "option", "support"} },
{ "lineeditor", "LLVMLineEditor", true, {"support"} },
{ "linker", "LLVMLinker", true, {"core", "object", "support", "transformutils", "targetparser"} },
{ "loongarch", nullptr, true, {"loongarchcodegen", "loongarchasmparser", "loongarchdisassembler", "loongarchdesc", "loongarchinfo"} },
{ "loongarchasmparser", "LLVMLoongArchAsmParser", true, {"loongarchdesc", "loongarchinfo", "mc", "mcparser", "support"} },
{ "loongarchcodegen", "LLVMLoongArchCodeGen", true, {"analysis", "asmprinter", "codegen", "codegentypes", "core", "loongarchdesc", "loongarchinfo", "mc", "scalaropts", "selectiondag", "support", "target", "targetparser", "transformutils"} },
{ "loongarchdesc", "LLVMLoongArchDesc", true, {"mc", "loongarchinfo", "support", "targetparser"} },
{ "loongarchdisassembler", "LLVMLoongArchDisassembler", true, {"loongarchdesc", "loongarchinfo", "mc", "mcdisassembler", "support"} },
{ "loongarchinfo", "LLVMLoongArchInfo", true, {"mc", "support"} },
{ "lto", "LLVMLTO", true, {"aggressiveinstcombine", "analysis", "binaryformat", "bitreader", "bitwriter", "cgdata", "codegen", "codegentypes", "core", "extensions", "ipo", "instcombine", "instrumentation", "linker", "mc", "objcarcopts", "object", "passes", "remarks", "scalaropts", "support", "target", "targetparser", "transformutils"} },
{ "mc", "LLVMMC", true, {"support", "targetparser", "binaryformat"} },
{ "mca", "LLVMMCA", true, {"mc", "support"} },
{ "mcdisassembler", "LLVMMCDisassembler", true, {"mc", "support", "targetparser"} },
{ "mcjit", "LLVMMCJIT", true, {"core", "executionengine", "object", "runtimedyld", "support", "target"} },
{ "mcparser", "LLVMMCParser", true, {"mc", "support", "targetparser"} },
{ "mips", nullptr, true, {"mipscodegen", "mipsasmparser", "mipsdisassembler", "mipsdesc", "mipsinfo"} },
{ "mipsasmparser", "LLVMMipsAsmParser", true, {"mc", "mcparser", "mipsdesc", "mipsinfo", "support", "targetparser"} },
{ "mipscodegen", "LLVMMipsCodeGen", true, {"analysis", "asmprinter", "codegen", "codegentypes", "core", "globalisel", "mc", "mipsdesc", "mipsinfo", "selectiondag", "support", "target", "targetparser", "transformutils"} },
{ "mipsdesc", "LLVMMipsDesc", true, {"codegentypes", "mc", "mipsinfo", "support", "targetparser"} },
{ "mipsdisassembler", "LLVMMipsDisassembler", true, {"mcdisassembler", "mc", "mipsinfo", "support"} },
{ "mipsinfo", "LLVMMipsInfo", true, {"mc", "support"} },
{ "mirparser", "LLVMMIRParser", true, {"asmparser", "binaryformat", "codegen", "codegentypes", "core", "mc", "support", "target"} },
{ "msp430", nullptr, true, {"msp430codegen", "msp430desc", "msp430info", "msp430asmparser", "msp430disassembler"} },
{ "msp430asmparser", "LLVMMSP430AsmParser", true, {"codegentypes", "mc", "mcparser", "msp430desc", "msp430info", "support"} },
{ "msp430codegen", "LLVMMSP430CodeGen", true, {"asmprinter", "codegen", "codegentypes", "core", "mc", "msp430desc", "msp430info", "selectiondag", "support", "target"} },
{ "msp430desc", "LLVMMSP430Desc", true, {"mc", "msp430info", "support"} },
{ "msp430disassembler", "LLVMMSP430Disassembler", true, {"mcdisassembler", "mc", "msp430info", "support"} },
{ "msp430info", "LLVMMSP430Info", true, {"mc", "support"} },
{ "native", nullptr, true, {"x86"} },
{ "nativecodegen", nullptr, true, {"x86codegen"} },
{ "nvptx", nullptr, true, {"nvptxcodegen", "nvptxdesc", "nvptxinfo"} },
{ "nvptxcodegen", "LLVMNVPTXCodeGen", true, {"analysis", "asmprinter", "codegen", "codegentypes", "core", "ipo", "mc", "nvptxdesc", "nvptxinfo", "scalaropts", "selectiondag", "support", "target", "targetparser", "transformutils", "vectorize"} },
{ "nvptxdesc", "LLVMNVPTXDesc", true, {"mc", "nvptxinfo", "support", "targetparser"} },
{ "nvptxinfo", "LLVMNVPTXInfo", true, {"mc", "support"} },
{ "objcarcopts", "LLVMObjCARCOpts", true, {"analysis", "core", "support", "targetparser", "transformutils"} },
{ "objcopy", "LLVMObjCopy", true, {"binaryformat", "object", "support", "mc"} },
{ "object", "LLVMObject", true, {"bitreader", "core", "mc", "irreader", "binaryformat", "mcparser", "support", "targetparser", "textapi"} },
{ "objectyaml", "LLVMObjectYAML", true, {"binaryformat", "object", "support", "targetparser", "debuginfocodeview", "mc"} },
{ "option", "LLVMOption", true, {"support"} },
{ "orcdebugging", "LLVMOrcDebugging", true, {"binaryformat", "debuginfodwarf", "jitlink", "orcjit", "orcshared", "support", "targetparser"} },
{ "orcjit", "LLVMOrcJIT", true, {"binaryformat", "core", "executionengine", "jitlink", "object", "orcshared", "orctargetprocess", "windowsdriver", "mc", "passes", "runtimedyld", "support", "target", "targetparser", "textapi", "transformutils"} },
{ "orcshared", "LLVMOrcShared", true, {"support"} },
{ "orctargetprocess", "LLVMOrcTargetProcess", true, {"orcshared", "support", "targetparser"} },
{ "passes", "LLVMPasses", true, {"aggressiveinstcombine", "analysis", "cfguard", "codegen", "globalisel", "core", "coroutines", "hipstdpar", "ipo", "instcombine", "irprinter", "objcarcopts", "scalaropts", "support", "target", "transformutils", "vectorize", "instrumentation"} },
{ "perfjitevents", "LLVMPerfJITEvents", true, {"codegen", "core", "debuginfodwarf", "executionengine", "object", "support"} },
{ "powerpc", nullptr, true, {"powerpccodegen", "powerpcasmparser", "powerpcdisassembler", "powerpcdesc", "powerpcinfo"} },
{ "powerpcasmparser", "LLVMPowerPCAsmParser", true, {"mc", "mcparser", "powerpcdesc", "powerpcinfo", "support"} },
{ "powerpccodegen", "LLVMPowerPCCodeGen", true, {"analysis", "asmprinter", "binaryformat", "codegen", "codegentypes", "core", "globalisel", "mc", "powerpcdesc", "powerpcinfo", "scalaropts", "selectiondag", "support", "target", "targetparser", "transformutils"} },
{ "powerpcdesc", "LLVMPowerPCDesc", true, {"binaryformat", "codegentypes", "mc", "powerpcinfo", "support", "targetparser"} },
{ "powerpcdisassembler", "LLVMPowerPCDisassembler", true, {"mcdisassembler", "mc", "powerpcinfo", "support"} },
{ "powerpcinfo", "LLVMPowerPCInfo", true, {"mc", "support"} },
{ "profiledata", "LLVMProfileData", true, {"bitstreamreader", "core", "object", "support", "demangle", "symbolize", "debuginfodwarf", "debuginfodwarflowlevel", "targetparser"} },
{ "remarks", "LLVMRemarks", true, {"bitstreamreader", "support"} },
{ "riscv", nullptr, true, {"riscvcodegen", "riscvasmparser", "riscvdisassembler", "riscvdesc", "riscvtargetmca", "riscvinfo"} },
{ "riscvasmparser", "LLVMRISCVAsmParser", true, {"mc", "mcparser", "riscvdesc", "riscvinfo", "support", "targetparser"} },
{ "riscvcodegen", "LLVMRISCVCodeGen", true, {"analysis", "asmprinter", "codegen", "codegentypes", "core", "globalisel", "ipo", "mc", "riscvdesc", "riscvinfo", "scalaropts", "selectiondag", "support", "target", "targetparser", "transformutils", "vectorize"} },
{ "riscvdesc", "LLVMRISCVDesc", true, {"mc", "riscvinfo", "support", "targetparser"} },
{ "riscvdisassembler", "LLVMRISCVDisassembler", true, {"mc", "mcdisassembler", "riscvdesc", "riscvinfo", "support"} },
{ "riscvinfo", "LLVMRISCVInfo", true, {"mc", "support"} },
{ "riscvtargetmca", "LLVMRISCVTargetMCA", true, {"codegentypes", "mc", "mca", "mcparser", "riscvdesc", "riscvinfo", "support", "targetparser"} },
{ "runtimedyld", "LLVMRuntimeDyld", true, {"core", "mc", "object", "support", "targetparser"} },
{ "sandboxir", "LLVMSandboxIR", true, {"core", "support", "analysis"} },
{ "scalaropts", "LLVMScalarOpts", true, {"aggressiveinstcombine", "analysis", "core", "instcombine", "support", "transformutils"} },
{ "selectiondag", "LLVMSelectionDAG", true, {"analysis", "codegen", "codegentypes", "core", "mc", "support", "target", "targetparser", "transformutils"} },
{ "sparc", nullptr, true, {"sparccodegen", "sparcasmparser", "sparcdisassembler", "sparcdesc", "sparcinfo"} },
{ "sparcasmparser", "LLVMSparcAsmParser", true, {"mc", "mcparser", "sparcdesc", "sparcinfo", "support", "targetparser"} },
{ "sparccodegen", "LLVMSparcCodeGen", true, {"asmprinter", "codegen", "codegentypes", "core", "mc", "selectiondag", "sparcdesc", "sparcinfo", "support", "target", "targetparser"} },
{ "sparcdesc", "LLVMSparcDesc", true, {"mc", "sparcinfo", "support", "targetparser"} },
{ "sparcdisassembler", "LLVMSparcDisassembler", true, {"mcdisassembler", "mc", "sparcinfo", "support"} },
{ "sparcinfo", "LLVMSparcInfo", true, {"mc", "support"} },
{ "spirv", nullptr, true, {"spirvcodegen", "spirvdesc", "spirvinfo", "spirvanalysis"} },
{ "spirvanalysis", "LLVMSPIRVAnalysis", true, {"analysis", "core", "support", "transformutils"} },
{ "spirvcodegen", "LLVMSPIRVCodeGen", true, {"analysis", "asmprinter", "codegen", "codegentypes", "core", "demangle", "globalisel", "spirvanalysis", "mc", "spirvdesc", "spirvinfo", "scalaropts", "selectiondag", "support", "target", "targetparser", "transformutils"} },
{ "spirvdesc", "LLVMSPIRVDesc", true, {"codegentypes", "mc", "spirvinfo", "support", "targetparser"} },
{ "spirvinfo", "LLVMSPIRVInfo", true, {"mc", "support"} },
{ "support", "LLVMSupport", true, {"demangle"} },
{ "symbolize", "LLVMSymbolize", true, {"debuginfodwarf", "debuginfogsym", "debuginfopdb", "debuginfobtf", "object", "support", "demangle", "targetparser"} },
{ "systemz", nullptr, true, {"systemzcodegen", "systemzasmparser", "systemzdisassembler", "systemzdesc", "systemzinfo"} },
{ "systemzasmparser", "LLVMSystemZAsmParser", true, {"mc", "mcparser", "support", "systemzdesc", "systemzinfo"} },
{ "systemzcodegen", "LLVMSystemZCodeGen", true, {"analysis", "asmprinter", "codegen", "codegentypes", "core", "mc", "scalaropts", "selectiondag", "support", "systemzdesc", "systemzinfo", "target", "targetparser", "transformutils"} },
{ "systemzdesc", "LLVMSystemZDesc", true, {"codegentypes", "mc", "support", "systemzinfo"} },
{ "systemzdisassembler", "LLVMSystemZDisassembler", true, {"mc", "mcdisassembler", "support", "systemzdesc", "systemzinfo"} },
{ "systemzinfo", "LLVMSystemZInfo", true, {"mc", "support"} },
{ "tablegen", "LLVMTableGen", true, {"support"} },
{ "target", "LLVMTarget", true, {"analysis", "core", "mc", "support", "targetparser"} },
{ "targetparser", "LLVMTargetParser", true, {"support"} },
{ "telemetry", "LLVMTelemetry", true, {"support"} },
{ "textapi", "LLVMTextAPI", true, {"support", "binaryformat", "targetparser"} },
{ "textapibinaryreader", "LLVMTextAPIBinaryReader", true, {"debuginfodwarf", "support", "object", "textapi", "targetparser"} },
{ "transformutils", "LLVMTransformUtils", true, {"analysis", "core", "support", "targetparser"} },
{ "ve", nullptr, true, {"vecodegen", "veasmparser", "vedisassembler", "veinfo", "vedesc"} },
{ "veasmparser", "LLVMVEAsmParser", true, {"codegentypes", "mc", "mcparser", "support", "vedesc", "veinfo"} },
{ "vecodegen", "LLVMVECodeGen", true, {"analysis", "asmprinter", "codegen", "codegentypes", "core", "mc", "selectiondag", "support", "target", "targetparser", "transformutils", "vedesc", "veinfo"} },
{ "vectorize", "LLVMVectorize", true, {"analysis", "core", "support", "transformutils", "sandboxir"} },
{ "vedesc", "LLVMVEDesc", true, {"codegentypes", "mc", "support", "targetparser", "veinfo"} },
{ "vedisassembler", "LLVMVEDisassembler", true, {"codegentypes", "mc", "mcdisassembler", "support", "veinfo"} },
{ "veinfo", "LLVMVEInfo", true, {"mc", "support"} },
{ "webassembly", nullptr, true, {"webassemblycodegen", "webassemblyasmparser", "webassemblydisassembler", "webassemblydesc", "webassemblyinfo", "webassemblyutils"} },
{ "webassemblyasmparser", "LLVMWebAssemblyAsmParser", true, {"codegentypes", "mc", "mcparser", "support", "targetparser", "webassemblydesc", "webassemblyinfo"} },
{ "webassemblycodegen", "LLVMWebAssemblyCodeGen", true, {"analysis", "asmprinter", "binaryformat", "codegen", "codegentypes", "core", "mc", "scalaropts", "selectiondag", "support", "target", "targetparser", "transformutils", "webassemblydesc", "webassemblyinfo", "webassemblyutils"} },
{ "webassemblydesc", "LLVMWebAssemblyDesc", true, {"codegentypes", "mc", "support", "targetparser", "webassemblyinfo"} },
{ "webassemblydisassembler", "LLVMWebAssemblyDisassembler", true, {"codegentypes", "mc", "mcdisassembler", "support", "webassemblydesc", "webassemblyinfo"} },
{ "webassemblyinfo", "LLVMWebAssemblyInfo", true, {"mc", "support"} },
{ "webassemblyutils", "LLVMWebAssemblyUtils", true, {"codegen", "codegentypes", "core", "mc", "support", "webassemblydesc"} },
{ "windowsdriver", "LLVMWindowsDriver", true, {"option", "support", "targetparser"} },
{ "windowsmanifest", "LLVMWindowsManifest", true, {"support"} },
{ "x86", nullptr, true, {"x86codegen", "x86asmparser", "x86disassembler", "x86targetmca", "x86desc", "x86info"} },
{ "x86asmparser", "LLVMX86AsmParser", true, {"mc", "mcparser", "support", "x86desc", "x86info"} },
{ "x86codegen", "LLVMX86CodeGen", true, {"analysis", "asmprinter", "cfguard", "codegen", "codegentypes", "core", "globalisel", "irprinter", "instrumentation", "mc", "profiledata", "scalaropts", "selectiondag", "support", "target", "targetparser", "transformutils", "x86desc", "x86info"} },
{ "x86desc", "LLVMX86Desc", true, {"binaryformat", "codegentypes", "mc", "mcdisassembler", "support", "targetparser", "x86info"} },
{ "x86disassembler", "LLVMX86Disassembler", true, {"mcdisassembler", "support", "x86info"} },
{ "x86info", "LLVMX86Info", true, {"mc", "support"} },
{ "x86targetmca", "LLVMX86TargetMCA", true, {"codegentypes", "mc", "mca", "mcparser", "support", "targetparser", "x86desc", "x86info"} },
{ "xcore", nullptr, true, {"xcorecodegen", "xcoredisassembler", "xcoredesc", "xcoreinfo"} },
{ "xcorecodegen", "LLVMXCoreCodeGen", true, {"analysis", "asmprinter", "codegen", "codegentypes", "core", "mc", "selectiondag", "support", "target", "targetparser", "transformutils", "xcoredesc", "xcoreinfo"} },
{ "xcoredesc", "LLVMXCoreDesc", true, {"mc", "support", "xcoreinfo"} },
{ "xcoredisassembler", "LLVMXCoreDisassembler", true, {"codegentypes", "mc", "mcdisassembler", "support", "xcoreinfo"} },
{ "xcoreinfo", "LLVMXCoreInfo", true, {"mc", "support"} },
{ "xray", "LLVMXRay", true, {"support", "object", "targetparser"} },
};