\name{PasteImageFilter}
\alias{PasteImageFilter}
\title{PasteImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Paste an image (or a constant value) into another image.
PasteImageFilter}
\details{
PasteImageFilter allows a region in a destination image to be filled with a source
image or a constant pixel value. The SetDestinationIndex() method prescribes where in the destination input to start pasting
data from the source input. The SetSourceRegion method prescribes the
section of the second image to paste into the first. When a constant
pixel value is set, the SourceRegion describes the size of the region
filled. If the output requested region does not include the
SourceRegion after it has been repositioned to DestinationIndex, then
the output will just be a copy of the input.
This filter supports running "InPlace" to efficiently reuses the
destination image buffer for the output, removing the need to copy the
destination pixels to the output.
When the source image is a lower dimension than the destination image
then the DestinationSkipAxes parameter specifies which axes in the
destination image are set to 1 when copying the region or filling with
a constant.
PasteImageFilter}
%C++ includes: sitkPasteImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &destinationImage, const Image &sourceImage):}{}
\item{Image Execute(const Image &destinationImage, double constant):}{}
\item{Image Execute(Image &&destinationImage, const Image &sourceImage):}{
Execute the filter on the input image
}
\item{Image Execute(Image &&destinationImage, double constant):}{}
\item{std::vector< int > GetDestinationIndex() const:}{
Set/Get the destination index (where in the first input the second
input will be pasted.
}
\item{std::vector< bool > GetDestinationSkipAxes() const:}{
Set/Get the array describing which axes in the destination image to
skip
The axes with true values are set to 1, to fill the difference between
the dimension of the input and source image. The number of true values
in DestinationSkipAxes plus the DestinationImageDimension must equal
the InputImageDimension.
By default this array contains SourceImageDimension false values
followed by true values for the remainder.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< int > GetSourceIndex() const:}{}
\item{std::vector< unsigned int > GetSourceSize() const:}{}
\item{ PasteImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetDestinationIndex(std::vector< int > DestinationIndex):}{
Set/Get the destination index (where in the first input the second
input will be pasted.
}
\item{Self SetDestinationSkipAxes(std::vector< bool > DestinationSkipAxes):}{
Set/Get the array describing which axes in the destination image to
skip
The axes with true values are set to 1, to fill the difference between
the dimension of the input and source image. The number of true value
in DestinationSkipAxes plus the DestinationImageDimension must equal
the InputImageDimension.
By default this array contains SourceImageDimension false values
followed by true values for the remainder.
}
\item{Self SetSourceIndex(std::vector< int > SourceIndex):}{}
\item{Self SetSourceSize(std::vector< unsigned int > SourceSize):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~PasteImageFilter():}{
Destructor
}
}
}
