/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.prefix;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.table.AbstractTableModel;
import org.protege.editor.owl.ui.prefix.PrefixUtilities;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixMapperTableModel
extends AbstractTableModel {
    private final Logger logger = LoggerFactory.getLogger(PrefixMapperTableModel.class);
    @Nonnull
    private final List<String> prefixNames = new ArrayList<String>();
    @Nonnull
    private final Map<String, String> prefixName2PrefixMap = new HashMap<String, String>();
    @Nonnull
    private final PrefixDocumentFormat prefixManager;
    private boolean changed = false;

    public PrefixMapperTableModel(@Nonnull PrefixDocumentFormat prefixManager) {
        this.prefixManager = (PrefixDocumentFormat)Preconditions.checkNotNull((Object)prefixManager);
        this.refill();
    }

    public void refill() {
        this.changed = false;
        this.prefixNames.clear();
        this.prefixName2PrefixMap.clear();
        this.prefixManager.getPrefixName2PrefixMap().forEach(this.prefixName2PrefixMap::put);
        this.prefixNames.addAll(this.prefixName2PrefixMap.keySet());
        this.prefixNames.sort(Comparator.naturalOrder());
        this.fireTableDataChanged();
    }

    public int getIndexOfPrefix(String prefix) {
        return this.prefixNames.indexOf(prefix);
    }

    public int addMapping(String prefix, String value) {
        this.changed = this.changed || value != null && value.length() != 0;
        this.prefixNames.add(prefix);
        this.prefixName2PrefixMap.put(prefix, value);
        this.fireTableDataChanged();
        return this.prefixNames.indexOf(prefix);
    }

    public void removeMapping(String prefix) {
        this.prefixNames.remove(prefix);
        String prefixValue = this.prefixName2PrefixMap.remove(prefix);
        this.changed = this.changed || prefixValue != null & prefixValue.length() != 0;
        this.fireTableDataChanged();
    }

    public boolean commitPrefixes() {
        if (!this.changed) {
            return false;
        }
        this.prefixManager.setPrefixManager((PrefixManager)new DefaultPrefixManager());
        for (Map.Entry<String, String> prefixName2PrefixEntry : this.prefixName2PrefixMap.entrySet()) {
            String prefixName = prefixName2PrefixEntry.getKey();
            String prefix = prefixName2PrefixEntry.getValue();
            if (prefix == null || prefix.length() == 0) continue;
            this.prefixManager.setPrefix(prefixName, prefix);
        }
        this.changed = false;
        return true;
    }

    public void sortTable() {
        Collections.sort(this.prefixNames);
    }

    @Override
    public String getColumnName(int column) {
        switch (Column.values()[column].ordinal()) {
            case 0: {
                return "Prefix Name";
            }
            case 1: {
                return "Prefix";
            }
        }
        throw new UnsupportedOperationException("Programmer error: missed a case");
    }

    @Override
    public int getRowCount() {
        return this.prefixNames.size();
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return !PrefixUtilities.isStandardPrefix(this.prefixNames.get(rowIndex));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String prefix = this.prefixNames.get(rowIndex);
        switch (Column.values()[columnIndex].ordinal()) {
            case 0: {
                return prefix;
            }
            case 1: {
                return this.prefixName2PrefixMap.get(prefix);
            }
        }
        throw new UnsupportedOperationException("Programmer error: missed a case");
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String currentPrefixName = (String)this.getValueAt(rowIndex, Column.PREFIX_NAME.ordinal());
        switch (Column.values()[columnIndex].ordinal()) {
            case 0: {
                this.setPrefixNameAt(aValue, currentPrefixName);
                break;
            }
            case 1: {
                this.setPrefixAt(aValue, currentPrefixName);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Programmer error: missed a case");
            }
        }
    }

    private void setPrefixNameAt(Object aValue, String currentPrefixName) {
        String newPrefix = aValue.toString();
        if (this.prefixNames.contains(newPrefix)) {
            return;
        }
        this.prefixNames.remove(currentPrefixName);
        this.prefixNames.add(newPrefix);
        String prefixValue = this.prefixName2PrefixMap.remove(currentPrefixName);
        this.prefixName2PrefixMap.put(newPrefix, prefixValue);
        this.changed = this.changed || prefixValue != null && prefixValue.length() != 0;
        this.fireTableDataChanged();
    }

    private void setPrefixAt(Object aValue, String currentPrefixName) {
        this.removeMapping(currentPrefixName);
        this.addMapping(currentPrefixName, aValue.toString());
    }

    public static enum Column {
        PREFIX_NAME,
        PREFIX;

    }
}

