/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Objects;

public abstract class ApplicationEvent {
    private final Type type;
    private long enqueuedMs;

    protected ApplicationEvent(Type type) {
        this.type = Objects.requireNonNull(type);
    }

    public Type type() {
        return this.type;
    }

    public void setEnqueuedMs(long enqueuedMs) {
        this.enqueuedMs = enqueuedMs;
    }

    public long enqueuedMs() {
        return this.enqueuedMs;
    }

    protected String toStringBase() {
        return "type=" + String.valueOf((Object)this.type) + ", enqueuedMs=" + this.enqueuedMs;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{" + this.toStringBase() + "}";
    }

    public static enum Type {
        COMMIT_ASYNC,
        COMMIT_SYNC,
        POLL,
        FETCH_COMMITTED_OFFSETS,
        NEW_TOPICS_METADATA_UPDATE,
        ASSIGNMENT_CHANGE,
        LIST_OFFSETS,
        CHECK_AND_UPDATE_POSITIONS,
        RESET_OFFSET,
        TOPIC_METADATA,
        ALL_TOPICS_METADATA,
        TOPIC_SUBSCRIPTION_CHANGE,
        TOPIC_PATTERN_SUBSCRIPTION_CHANGE,
        TOPIC_RE2J_PATTERN_SUBSCRIPTION_CHANGE,
        UPDATE_SUBSCRIPTION_METADATA,
        UNSUBSCRIBE,
        CONSUMER_REBALANCE_LISTENER_CALLBACK_COMPLETED,
        COMMIT_ON_CLOSE,
        CREATE_FETCH_REQUESTS,
        LEAVE_GROUP_ON_CLOSE,
        STOP_FIND_COORDINATOR_ON_CLOSE,
        PAUSE_PARTITIONS,
        RESUME_PARTITIONS,
        CURRENT_LAG,
        SHARE_FETCH,
        SHARE_ACKNOWLEDGE_ASYNC,
        SHARE_ACKNOWLEDGE_SYNC,
        SHARE_SUBSCRIPTION_CHANGE,
        SHARE_UNSUBSCRIBE,
        SHARE_ACKNOWLEDGE_ON_CLOSE,
        SHARE_ACKNOWLEDGEMENT_COMMIT_CALLBACK_REGISTRATION,
        SEEK_UNVALIDATED,
        STREAMS_ON_TASKS_ASSIGNED_CALLBACK_COMPLETED,
        STREAMS_ON_TASKS_REVOKED_CALLBACK_COMPLETED,
        STREAMS_ON_ALL_TASKS_LOST_CALLBACK_COMPLETED;

    }
}

