/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class PolarStereographic
extends AbstractProj {
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double ITERATION_TOLERANCE = 1.0E-10;
    private static final double EPSILON = 1.0E-8;
    private double k0;
    boolean southPole;

    @Override
    public String getName() {
        return I18n.tr("Polar Stereographic", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "stere";
    }

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        super.initialize(params);
        if (params.lat0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
        }
        if (params.lat0 != 90.0 && params.lat0 != -90.0) {
            throw new ProjectionConfigurationException(I18n.tr("Polar Stereographic: Parameter ''{0}'' must be 90 or -90.", "lat_0"));
        }
        double latitudeTrueScale = params.lat_ts == null ? (params.lat0 < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Utils.toRadians(params.lat_ts);
        this.southPole = latitudeTrueScale < 0.0;
        double latitudeTrueScaleAbs = Math.abs(latitudeTrueScale);
        if (Math.abs(latitudeTrueScaleAbs - 1.5707963267948966) >= 1.0E-8) {
            double t = Math.sin(latitudeTrueScaleAbs);
            this.k0 = this.msfn(t, Math.cos(latitudeTrueScaleAbs)) / this.tsfn(latitudeTrueScaleAbs, t);
        } else {
            this.k0 = 2.0 / Math.sqrt(Math.pow(1.0 + this.e, 1.0 + this.e) * Math.pow(1.0 - this.e, 1.0 - this.e));
        }
    }

    @Override
    public double[] project(double y, double x) {
        double sinlat = Math.sin(y);
        double coslon = Math.cos(x);
        double sinlon = Math.sin(x);
        if (this.southPole) {
            double rho = this.k0 * this.tsfn(-y, -sinlat);
            x = rho * sinlon;
            y = rho * coslon;
        } else {
            double rho = this.k0 * this.tsfn(y, sinlat);
            x = rho * sinlon;
            y = -rho * coslon;
        }
        return new double[]{x, y};
    }

    @Override
    public double[] invproject(double x, double y) {
        double phi;
        double rho;
        block2: {
            rho = Math.hypot(x, y);
            if (this.southPole) {
                y = -y;
            }
            double t = rho / this.k0;
            double halfe = this.e / 2.0;
            double phi0 = 0.0;
            int i = 15;
            do {
                double esinphi;
                if (Math.abs((phi = 1.5707963267948966 - 2.0 * Math.atan(t * Math.pow((1.0 - (esinphi = this.e * Math.sin(phi0))) / (1.0 + esinphi), halfe))) - phi0) < 1.0E-10) break block2;
                phi0 = phi;
            } while (--i >= 0);
            throw new IllegalStateException("no convergence for x=" + x + ", y=" + y);
        }
        x = Math.abs(rho) < 1.0E-8 ? 0.0 : Math.atan2(x, -y);
        y = this.southPole ? -phi : phi;
        return new double[]{y, x};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        double cut = 60.0;
        if (this.southPole) {
            return new Bounds(-90.0, -180.0, 60.0, 180.0, false);
        }
        return new Bounds(-60.0, -180.0, 90.0, 180.0, false);
    }
}

