/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.freecol.common.model.Area;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.LandMap;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.generator.EuropeanStartingPositionsGenerator;
import net.sf.freecol.server.generator.MapGenerator;
import net.sf.freecol.server.generator.TerrainGenerator;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerRegion;
import net.sf.freecol.server.model.ServerUnit;

public class SimpleMapGenerator
implements MapGenerator {
    private static final Logger logger = Logger.getLogger(SimpleMapGenerator.class.getName());
    private static final float MIN_DISTANCE_FROM_POLE = 0.3f;
    private final Random random;
    private final RandomUtils.RandomIntCache cache;

    public SimpleMapGenerator(Random random) {
        this.random = random;
        this.cache = new RandomUtils.RandomIntCache(logger, "simpleMap", random, 65536, 512);
    }

    @Override
    public Map generateEmptyMap(Game game, int width, int height, LogBuilder lb) {
        LandMap landMap = new LandMap(width, height, this.cache);
        return new TerrainGenerator(this.random).generateMap(game, null, landMap, lb);
    }

    @Override
    public Map generateMap(Game game, Map importMap, boolean generateEuropeanPlayerUnits, LogBuilder lb) {
        LandMap landMap = importMap != null ? new LandMap(importMap, this.cache) : new LandMap(game.getMapGeneratorOptions(), this.cache);
        Map map = new TerrainGenerator(this.random).generateMap(game, importMap, landMap, lb);
        this.makeNativeSettlements(map, importMap, lb);
        this.makeLostCityRumours(map, importMap, lb);
        if (generateEuropeanPlayerUnits) {
            this.createEuropeanUnits(map, game.getLiveEuropeanPlayerList(new Player[0]));
        }
        lb.shrink("\n");
        return map;
    }

    private int getApproximateLandCount(Game game) {
        OptionGroup mapOptions = game.getMapGeneratorOptions();
        return mapOptions.getInteger("model.option.mapWidth") * mapOptions.getInteger("model.option.mapHeight") * mapOptions.getInteger("model.option.landMass") / 100;
    }

    private void makeLostCityRumours(Map map, Map importMap, LogBuilder lb) {
        Game game = map.getGame();
        boolean importRumours = game.getMapGeneratorOptions().getBoolean("model.option.importRumours");
        if (importMap != null && importRumours) {
            return;
        }
        int rumourNumber = game.getMapGeneratorOptions().getRange("model.option.rumourNumber");
        int number = this.getApproximateLandCount(game) / rumourNumber;
        int counter = 0;
        if (importMap != null) {
            number = map.getWidth() * map.getHeight() * 25 / 3500;
        }
        block0: for (int i = 0; i < number; ++i) {
            for (int tries = 0; tries < 100; ++tries) {
                Tile t = map.getRandomLandTile(this.random);
                if (t.isPolar() || !t.isLand() || t.hasLostCityRumour() || t.hasSettlement() || t.getUnitCount() != 0) continue;
                LostCityRumour r = new LostCityRumour(t.getGame(), t);
                if (r.chooseType(null, this.random) == LostCityRumour.RumourType.MOUNDS && t.getOwningSettlement() != null) {
                    r.setType(LostCityRumour.RumourType.MOUNDS);
                }
                t.addLostCityRumour(r);
                ++counter;
                continue block0;
            }
        }
        lb.add("Created ", counter, " lost city rumours of maximum ", number, ".\n");
    }

    private boolean importIndianSettlements(Map map, Map importMap, LogBuilder lb) {
        Game game = map.getGame();
        Specification spec = game.getSpecification();
        for (Player iPlayer : importMap.getGame().getLiveNativePlayerList(new Player[0])) {
            Player indian = game.getPlayerByNationId(iPlayer.getNationId());
            if (indian == null) {
                Nation nation = spec.getNation(iPlayer.getNationId());
                if (nation == null) {
                    lb.add("Native nation ", iPlayer.getNationId(), " not found in spec.\n");
                    continue;
                }
                indian = new ServerPlayer(game, false, nation);
                lb.add("Imported new native nation ", iPlayer.getNationId(), ": ", indian.getId(), "\n");
                game.addPlayer(indian);
                continue;
            }
            lb.add("Found native nation ", iPlayer.getNationId(), " for import: ", indian.getId(), "\n");
        }
        List<Tile> iTiles = importMap.getTileList(CollectionUtils.isNotNull(UnitLocation::getIndianSettlement));
        HashSet<ServerIndianSettlement> newSettlements = new HashSet<ServerIndianSettlement>(iTiles.size());
        for (Tile iTile : iTiles) {
            Player owner;
            IndianSettlement is = iTile.getIndianSettlement();
            if (is.getOwner() == null || (owner = game.getPlayerByNationId(is.getOwner().getNationId())) == null) continue;
            UnitType iSkill = is.getLearnableSkill();
            ServerIndianSettlement sis = new ServerIndianSettlement(game, owner, is.getName(), map.getTile(iTile.getX(), iTile.getY()), is.isCapital(), iSkill == null ? null : spec.getUnitType(iSkill.getId()), null);
            sis.placeSettlement(false);
            for (Tile tile : is.getOwnedTiles()) {
                map.getTile(tile.getX(), tile.getY()).changeOwnership(owner, sis);
            }
            List<Unit> iUnits = is.getUnitList();
            if (iUnits.isEmpty()) {
                sis.addUnits(this.random);
            } else {
                for (Unit iu : iUnits) {
                    UnitType it2 = spec.getUnitType(iu.getType().getId());
                    if (it2 == null) continue;
                    ServerUnit su = new ServerUnit(game, sis, owner, it2);
                    sis.add(su);
                    sis.addOwnedUnit(su);
                }
            }
            List<Goods> list = is.getCompactGoodsList();
            if (list.isEmpty()) {
                sis.addRandomGoods(this.random);
            } else {
                for (Goods ig2 : list) {
                    GoodsType it = spec.getGoodsType(ig2.getType().getId());
                    if (it == null) continue;
                    sis.addGoods(it, ig2.getAmount());
                }
            }
            sis.setWantedGoods(CollectionUtils.transform(is.getWantedGoods(), CollectionUtils.alwaysTrue(), ig -> ig == null ? null : spec.getGoodsType(ig.getId()), CollectionUtils.toListNoNulls()));
            owner.addSettlement(sis);
            newSettlements.add(sis);
        }
        lb.add("Imported ", newSettlements.size(), " native settlements.\n");
        return !newSettlements.isEmpty();
    }

    private void makeNativeSettlements(Map map, Map importMap, LogBuilder lb) {
        Game game = map.getGame();
        Specification spec = game.getSpecification();
        boolean importSettlements = game.getMapGeneratorOptions().getBoolean("model.option.importSettlements");
        if (importSettlements && importMap != null && this.importIndianSettlements(map, importMap, lb)) {
            return;
        }
        ArrayList<IndianSettlement> settlements = new ArrayList<IndianSettlement>();
        List<Player> nativePlayers = game.getLiveNativePlayerList(new Player[0]);
        if (nativePlayers.isEmpty()) {
            return;
        }
        List<Tile> allTiles = map.getShuffledTiles(this.random);
        int minDistance = spec.getRange("model.option.settlementNumber");
        LinkedHashSet<Tile> settlementTiles = new LinkedHashSet<Tile>();
        for (Tile tile : allTiles) {
            if (tile.isPolar() || !this.suitableForNativeSettlement(tile) || CollectionUtils.any(settlementTiles, t -> t.getDistanceTo((Tile)tile) < minDistance)) continue;
            settlementTiles.add(tile);
        }
        HashMap<Player, Set> designatedArea = new HashMap<Player, Set>();
        for (Player player : nativePlayers) {
            Area area = map.getGame().getNationStartingArea(player.getNation());
            if (area == null || area.isEmpty()) continue;
            Set settlementTilesForNation = area.getTiles().stream().filter(t -> settlementTiles.contains(t)).collect(Collectors.toCollection(LinkedHashSet::new));
            if (settlementTilesForNation.isEmpty()) {
                logger.warning("No settlements for nationType=" + player.getNationId());
            }
            designatedArea.put(player, settlementTilesForNation);
        }
        for (Player player : nativePlayers) {
            if (designatedArea.containsKey(player)) continue;
            IndianNationType indianNationType = (IndianNationType)player.getNationType();
            List otherRegions = indianNationType.getRegions().stream().map(key -> ((ServerRegion)map.getRegionByKey((String)key)).getBounds()).filter(bounds -> !bounds.isEmpty()).collect(Collectors.toList());
            if (otherRegions.isEmpty()) {
                logger.warning("No area or regions found for nationType=" + player.getNationId());
                continue;
            }
            Set settlementTilesForNation = settlementTiles.stream().filter(t -> otherRegions.stream().anyMatch(bounds -> bounds.contains(t.getX(), t.getY()))).collect(Collectors.toCollection(LinkedHashSet::new));
            if (settlementTilesForNation.isEmpty()) {
                logger.warning("No settlements in region for nationType=" + player.getNationId());
            }
            designatedArea.put(player, settlementTilesForNation);
        }
        block3: for (Player player : nativePlayers) {
            Set set = (Set)designatedArea.get(player);
            if (set == null) continue;
            for (Tile settlementTile : new ArrayList(settlementTiles)) {
                if (!set.contains(settlementTile)) continue;
                IndianSettlement capital = this.placeIndianSettlement(player, true, settlementTile, map, lb);
                settlements.add(capital);
                settlementTiles.remove(settlementTile);
                continue block3;
            }
        }
        for (Tile tile : settlementTiles) {
            ArrayList arrayList = new ArrayList(designatedArea.keySet());
            Collections.shuffle(arrayList, this.random);
            Player owner = arrayList.stream().filter(p -> {
                Set tiles = (Set)designatedArea.get(p);
                if (tiles == null) {
                    return false;
                }
                return tiles.contains(tile);
            }).findFirst().orElse(null);
            if (owner == null) continue;
            IndianSettlement settlement = this.placeIndianSettlement(owner, false, tile, map, lb);
            settlements.add(settlement);
        }
        HashMap<UnitType, Object> hashMap = new HashMap<UnitType, Object>();
        RandomUtils.randomShuffle(logger, "Settlements", settlements, this.random);
        for (IndianSettlement indianSettlement : settlements) {
            UnitType skill;
            Object isList;
            List<Tile> tiles = CollectionUtils.transform(indianSettlement.getOwnedTiles(), t -> CollectionUtils.any(t.getSurroundingTiles(1, 1), CollectionUtils.isNull(Tile::getOwningSettlement)));
            RandomUtils.randomShuffle(logger, "Settlement tiles", tiles, this.random);
            int minGrow = indianSettlement.getType().getMinimumGrowth();
            int maxGrow = indianSettlement.getType().getMaximumGrowth();
            if (maxGrow > minGrow) {
                Tile tile;
                for (int i = RandomUtils.randomInt(logger, "Gdiff", this.random, maxGrow - minGrow) + minGrow; i > 0 && (tile = this.findFreeNeighbouringTile(indianSettlement, tiles)) != null; --i) {
                    tile.changeOwnership(indianSettlement.getOwner(), indianSettlement);
                    tiles.add(tile);
                }
            }
            if ((isList = (ArrayList<IndianSettlement>)hashMap.get(skill = indianSettlement.getLearnableSkill())) == null) {
                isList = new ArrayList<IndianSettlement>();
                isList.add(indianSettlement);
                hashMap.put(skill, isList);
                continue;
            }
            isList.add(indianSettlement);
        }
        ArrayList<UnitType> arrayList = new ArrayList<UnitType>();
        for (GoodsType goodsType : spec.getNewWorldGoodsTypeList()) {
            UnitType expert = spec.getExpertForProducing(goodsType);
            if (hashMap.containsKey(expert)) continue;
            arrayList.add(expert);
        }
        ArrayList arrayList2 = new ArrayList(hashMap.values());
        while (!arrayList.isEmpty()) {
            UnitType neededSkill = (UnitType)arrayList.remove(0);
            arrayList2.sort(CollectionUtils.descendingListLengthComparator);
            List extras = (List)arrayList2.remove(0);
            UnitType extraSkill = ((IndianSettlement)extras.get(0)).getLearnableSkill();
            ArrayList choices = new ArrayList();
            for (IndianSettlement is : extras) {
                IndianNationType nation = (IndianNationType)is.getOwner().getNationType();
                int cm = is.isCapital() ? 2 : 1;
                RandomChoice rc = CollectionUtils.find(nation.generateSkillsForTile(is.getTile()), CollectionUtils.matchKeyEquals(neededSkill, RandomChoice::getObject));
                choices.add(new RandomChoice<IndianSettlement>(is, rc == null ? 1 : rc.getProbability() * cm));
            }
            if (!choices.isEmpty()) {
                IndianSettlement chose = (IndianSettlement)RandomChoice.getWeightedRandom(logger, "expert", choices, this.random);
                lb.add("At ", chose.getName(), " replaced ", extraSkill, " (one of ", extras.size(), ")", " by missing ", neededSkill, "\n");
                chose.setLearnableSkill(neededSkill);
                extras.remove(chose);
                arrayList2.add(0, extras);
                ArrayList<IndianSettlement> neededList = new ArrayList<IndianSettlement>();
                neededList.add(chose);
                arrayList2.add(neededList);
                continue;
            }
            lb.add("Game is missing skill: ", neededSkill, "\n");
        }
        lb.add("Settlement skills:");
        for (List iss : arrayList2) {
            if (iss.isEmpty()) {
                lb.add("  0 x <none>");
                continue;
            }
            lb.add("  ", iss.size(), " x ", ((IndianSettlement)iss.get(0)).getLearnableSkill().getSuffix());
        }
    }

    private boolean suitableForNativeSettlement(Tile tile) {
        if (!tile.getType().canSettle()) {
            return false;
        }
        int good = 0;
        int n = 0;
        for (Tile t : tile.getSurroundingTiles(1)) {
            if (t.getType().canSettle()) {
                ++good;
            }
            ++n;
        }
        return good >= n / 2;
    }

    private Tile findFreeNeighbouringTile(IndianSettlement is, List<Tile> tiles) {
        Player owner = is.getOwner();
        Predicate<Tile> freeTilePred = t -> t != null && t.getOwningSettlement() == null && owner.canClaimForSettlement((Tile)t);
        Direction[] dirns = Direction.getRandomDirections("freeTile", logger, this.random);
        for (Tile t2 : tiles) {
            Tile ret = CollectionUtils.find(CollectionUtils.map(dirns, d -> t2.getNeighbourOrNull((Direction)d)), freeTilePred);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private IndianSettlement placeIndianSettlement(Player player, boolean capital, Tile tile, Map map, LogBuilder lb) {
        String name = capital ? player.getCapitalName(this.random) : player.getSettlementName(this.random);
        UnitType skill = this.generateSkillForLocation(map, tile, player.getNationType());
        ServerIndianSettlement sis = new ServerIndianSettlement(map.getGame(), player, name, tile, capital, skill, null);
        player.addSettlement(sis);
        lb.add("Generated skill for ", sis.getName(), ": ", sis.getLearnableSkill().getSuffix(), "\n");
        sis.placeSettlement(true);
        sis.addRandomGoods(this.random);
        sis.addUnits(this.random);
        return sis;
    }

    private UnitType generateSkillForLocation(Map map, Tile tile, NationType nationType) {
        List<RandomChoice<UnitType>> skills = ((IndianNationType)nationType).getSkills();
        java.util.Map<GoodsType, Integer> scale = CollectionUtils.transform(skills, CollectionUtils.alwaysTrue(), Function.identity(), Collectors.toMap(rc -> ((UnitType)rc.getObject()).getExpertProduction(), rc -> 1));
        for (Tile t : tile.getSurroundingTiles(1)) {
            CollectionUtils.forEachMapEntry(scale, e -> {
                GoodsType goodsType = (GoodsType)e.getKey();
                scale.put(goodsType, (Integer)e.getValue() + t.getPotentialProduction(goodsType, null));
            });
        }
        Function<RandomChoice, RandomChoice> mapper = rc -> {
            UnitType unitType = (UnitType)rc.getObject();
            return new RandomChoice<UnitType>(unitType, rc.getProbability() * (Integer)scale.get(unitType.getExpertProduction()));
        };
        UnitType skill = (UnitType)RandomChoice.getWeightedRandom(null, null, CollectionUtils.transform(skills, CollectionUtils.alwaysTrue(), mapper), this.random);
        Specification spec = map.getSpecification();
        return skill != null ? skill : RandomUtils.getRandomMember(logger, "Scout", spec.getUnitTypesWithAbility("model.ability.expertScout"), this.random);
    }

    private void createEuropeanUnits(Map map, List<Player> liveEuropeanPlayerList) {
        EuropeanStartingPositionsGenerator startPosGenerator = new EuropeanStartingPositionsGenerator(this.random);
        startPosGenerator.createEuropeanUnits(map, liveEuropeanPlayerList);
    }
}

