/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.SnippetsSuggestedEvent;
import io.cucumber.plugin.event.StepDefinedEvent;
import io.cucumber.plugin.event.TestCaseEvent;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceParsed;
import io.cucumber.plugin.event.TestSourceRead;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

final class CanonicalEventOrder
implements Comparator<Event> {
    private static final Comparator<Event> eventOrder = Comparator.comparingInt(CanonicalEventOrder::eventOrder).thenComparing(CanonicalEventOrder::testCaseEvents).thenComparing(Event::getInstant);
    private static final Comparator<TestCaseEvent> testCaseOrder = Comparator.comparing(CanonicalEventOrder::testCaseUri).thenComparingInt(CanonicalEventOrder::testCaseLine).thenComparing((? super T rec$) -> ((TestCaseEvent)rec$).getInstant());
    private static final List<Class<? extends Event>> fixedOrder = Arrays.asList(TestRunStarted.class, TestSourceRead.class, TestSourceParsed.class, SnippetsSuggestedEvent.class, StepDefinedEvent.class, TestCaseEvent.class, TestRunFinished.class);

    CanonicalEventOrder() {
    }

    @Override
    public int compare(Event a, Event b) {
        return eventOrder.compare(a, b);
    }

    private static int testCaseEvents(Event a, Event b) {
        if (a instanceof TestCaseEvent && b instanceof TestCaseEvent) {
            return testCaseOrder.compare((TestCaseEvent)a, (TestCaseEvent)b);
        }
        return 0;
    }

    private static int testCaseLine(TestCaseEvent o) {
        return o.getTestCase().getLocation().getLine();
    }

    private static URI testCaseUri(TestCaseEvent o) {
        return o.getTestCase().getUri();
    }

    private static int eventOrder(Event o) {
        Class<?> eventClass = o.getClass();
        int index = CanonicalEventOrder.findInFixedOrder(eventClass);
        if (index < 0) {
            throw new IllegalStateException(eventClass + " was not in " + fixedOrder);
        }
        return index;
    }

    private static int findInFixedOrder(Class<? extends Event> o) {
        for (int i = 0; i < fixedOrder.size(); ++i) {
            if (!fixedOrder.get(i).isAssignableFrom(o)) continue;
            return i;
        }
        return -1;
    }
}

