// java wrapper for vtkRenderbuffer object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkRenderbuffer.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkRenderbuffer_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkRenderbuffer",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderbuffer_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderbuffer_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderbuffer_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderbuffer_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRenderbuffer_IsSupported_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  bool   temp20;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsSupported(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderbuffer_GetHandle_15(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHandle();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderbuffer_SetContext_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindow * temp0;
  temp0 = static_cast<vtkRenderWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetContext(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRenderbuffer_GetContext_17(JNIEnv* env, jobject obj)
{
  vtkRenderWindow * temp20;

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContext();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderbuffer_CreateColorAttachment_18(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
   unsigned int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateColorAttachment(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderbuffer_CreateDepthAttachment_19(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
   unsigned int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateDepthAttachment(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderbuffer_Create_110(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
   unsigned int   temp0;
   unsigned int   temp1;
   unsigned int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Create(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderbuffer_Create_111(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3)
{
   unsigned int   temp0;
   unsigned int   temp1;
   unsigned int   temp2;
   unsigned int   temp3;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Create(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderbuffer_ReleaseGraphicsResources_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRenderbuffer_Resize_113(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
   unsigned int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  op->Resize(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderbuffer_GetWidth_114(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWidth();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderbuffer_GetHeight_115(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHeight();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRenderbuffer_GetSamples_116(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkRenderbuffer* op = static_cast<vtkRenderbuffer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSamples();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkRenderbuffer_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkRenderbuffer::New());
}
