// java wrapper for vtkXMLTreeReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkXMLTreeReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkTreeAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkXMLTreeReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkXMLTreeReader",dType)) { return me; }
  if ((res= vtkTreeAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLTreeReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLTreeReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLTreeReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLTreeReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLTreeReader_GetFileName_14(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_SetFileName_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLTreeReader_GetXMLString_16(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXMLString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_SetXMLString_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXMLString(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLTreeReader_GetEdgePedigreeIdArrayName_18(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgePedigreeIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_SetEdgePedigreeIdArrayName_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgePedigreeIdArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLTreeReader_GetVertexPedigreeIdArrayName_110(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexPedigreeIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_SetVertexPedigreeIdArrayName_111(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexPedigreeIdArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_SetGenerateEdgePedigreeIds_112(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateEdgePedigreeIds(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXMLTreeReader_GetGenerateEdgePedigreeIds_113(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateEdgePedigreeIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_GenerateEdgePedigreeIdsOn_114(JNIEnv* env, jobject obj)
{

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateEdgePedigreeIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_GenerateEdgePedigreeIdsOff_115(JNIEnv* env, jobject obj)
{

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateEdgePedigreeIdsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_SetGenerateVertexPedigreeIds_116(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateVertexPedigreeIds(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXMLTreeReader_GetGenerateVertexPedigreeIds_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateVertexPedigreeIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_GenerateVertexPedigreeIdsOn_118(JNIEnv* env, jobject obj)
{

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateVertexPedigreeIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_GenerateVertexPedigreeIdsOff_119(JNIEnv* env, jobject obj)
{

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateVertexPedigreeIdsOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXMLTreeReader_GetMaskArrays_120(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaskArrays();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_SetMaskArrays_121(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaskArrays(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_MaskArraysOn_122(JNIEnv* env, jobject obj)
{

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->MaskArraysOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_MaskArraysOff_123(JNIEnv* env, jobject obj)
{

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->MaskArraysOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXMLTreeReader_GetReadCharData_124(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadCharData();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_SetReadCharData_125(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadCharData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_ReadCharDataOn_126(JNIEnv* env, jobject obj)
{

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadCharDataOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_ReadCharDataOff_127(JNIEnv* env, jobject obj)
{

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadCharDataOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXMLTreeReader_GetReadTagName_128(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadTagName();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_SetReadTagName_129(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadTagName(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_ReadTagNameOn_130(JNIEnv* env, jobject obj)
{

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadTagNameOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLTreeReader_ReadTagNameOff_131(JNIEnv* env, jobject obj)
{

  vtkXMLTreeReader* op = static_cast<vtkXMLTreeReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadTagNameOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkXMLTreeReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkXMLTreeReader::New());
}
