// java wrapper for vtkGDALRasterReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGDALRasterReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageReader2_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGDALRasterReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGDALRasterReader",dType)) { return me; }
  if ((res= vtkImageReader2_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGDALRasterReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGDALRasterReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGDALRasterReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGDALRasterReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGDALRasterReader_CanReadFile_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGDALRasterReader_GetProjectionString_15(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectionString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGDALRasterReader_GetProjectionWKT_16(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProjectionWKT();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGDALRasterReader_SetCollateBands_17(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCollateBands(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGDALRasterReader_GetCollateBands_18(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCollateBands();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGDALRasterReader_CollateBandsOn_19(JNIEnv* env, jobject obj)
{

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CollateBandsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGDALRasterReader_CollateBandsOff_110(JNIEnv* env, jobject obj)
{

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CollateBandsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGDALRasterReader_SetTargetDimensions_111(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTargetDimensions(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGDALRasterReader_SetTargetDimensions_112(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTargetDimensions(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkGDALRasterReader_GetTargetDimensions_113(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTargetDimensions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGDALRasterReader_GetDriverShortName_114(JNIEnv* env, jobject obj)
{
  const std::string * temp20;

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = &(op)->GetDriverShortName();
  return vtkJavaStringToUTF8(env, *temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGDALRasterReader_GetDriverLongName_115(JNIEnv* env, jobject obj)
{
  const std::string * temp20;

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = &(op)->GetDriverLongName();
  return vtkJavaStringToUTF8(env, *temp20);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGDALRasterReader_GetNumberOfCells_116(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGDALRasterReader_GetNumberOfCellArrays_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGDALRasterReader_GetCellArrayName_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGDALRasterReader_GetCellArrayStatus_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGDALRasterReader_SetCellArrayStatus_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGDALRasterReader_DisableAllCellArrays_121(JNIEnv* env, jobject obj)
{

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllCellArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGDALRasterReader_EnableAllCellArrays_122(JNIEnv* env, jobject obj)
{

  vtkGDALRasterReader* op = static_cast<vtkGDALRasterReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllCellArrays();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGDALRasterReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGDALRasterReader::New());
}
