// java wrapper for vtkHyperTreeGrid object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkHyperTreeGrid.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkHyperTreeGrid_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkHyperTreeGrid",dType)) { return me; }
  if ((res= vtkDataObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_LEVELS_10(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->LEVELS();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_DIMENSION_11(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DIMENSION();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_ORIENTATION_12(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ORIENTATION();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_SIZES_13(JNIEnv* env, jobject obj)
{
  vtkInformationDoubleVectorKey * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SIZES();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_IsTypeOf_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_IsA_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetNumberOfGenerationsFromBaseType_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetNumberOfGenerationsFromBase_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetModeSqueeze_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModeSqueeze(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkHyperTreeGrid_GetModeSqueeze_19(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModeSqueeze();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_Squeeze_110(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->Squeeze();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_GetDataObjectType_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_CopyStructure_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_CopyEmptyStructure_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyEmptyStructure(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetDimensions_114(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetDimensions_115(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
   unsigned int   temp0;
   unsigned int   temp1;
   unsigned int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_GetDimensions_116(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDimensions(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetExtent_117(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtent(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetExtent_118(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkHyperTreeGrid_GetExtent_119(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_GetCellDims_120(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellDims(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_GetDimension_121(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_GetNumberOfChildren_122(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfChildren();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetTransposedRootIndexing_123(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransposedRootIndexing(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHyperTreeGrid_GetTransposedRootIndexing_124(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransposedRootIndexing();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetIndexingModeToKJI_125(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIndexingModeToKJI();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetIndexingModeToIJK_126(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIndexingModeToIJK();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_GetOrientation_127(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientation();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHyperTreeGrid_GetFreezeState_128(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFreezeState();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetBranchFactor_129(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBranchFactor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_GetBranchFactor_130(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBranchFactor();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetMaxNumberOfTrees_131(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxNumberOfTrees();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetNumberOfNonEmptyTrees_132(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNonEmptyTrees();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetNumberOfLeaves_133(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLeaves();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_GetNumberOfLevels_134(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
   unsigned int   temp20;
  temp0 = id0;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLevels(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_GetNumberOfLevels_135(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLevels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetXCoordinates_136(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXCoordinates(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetXCoordinates_137(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXCoordinates();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetYCoordinates_138(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYCoordinates(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetYCoordinates_139(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYCoordinates();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetZCoordinates_140(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZCoordinates(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetZCoordinates_141(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZCoordinates();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_CopyCoordinates_142(JNIEnv* env, jobject obj,jobject id0)
{
  vtkHyperTreeGrid * temp0;
  temp0 = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyCoordinates(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetFixedCoordinates_143(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
   unsigned int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFixedCoordinates(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetMask_144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkBitArray * temp0;
  temp0 = static_cast<vtkBitArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMask(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetMask_145(JNIEnv* env, jobject obj)
{
  vtkBitArray * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMask();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHyperTreeGrid_HasMask_146(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasMask();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetHasInterface_147(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHasInterface(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHyperTreeGrid_GetHasInterface_148(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHasInterface();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_HasInterfaceOn_149(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->HasInterfaceOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_HasInterfaceOff_150(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->HasInterfaceOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetInterfaceNormalsName_151(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterfaceNormalsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkHyperTreeGrid_GetInterfaceNormalsName_152(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterfaceNormalsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetInterfaceInterceptsName_153(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterfaceInterceptsName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkHyperTreeGrid_GetInterfaceInterceptsName_154(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterfaceInterceptsName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetDepthLimiter_155(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDepthLimiter(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_GetDepthLimiter_156(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDepthLimiter();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_InitializeOrientedCursor_157(JNIEnv* env, jobject obj,jobject id0,jlong id1,jboolean id2)
{
  vtkHyperTreeGridOrientedCursor * temp0;
  long long   temp1;
  bool   temp2;
  temp0 = static_cast<vtkHyperTreeGridOrientedCursor*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeOrientedCursor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_NewOrientedCursor_158(JNIEnv* env, jobject obj,jlong id0,jboolean id1)
{
  long long   temp0;
  bool   temp1;
  vtkHyperTreeGridOrientedCursor * temp20;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewOrientedCursor(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_InitializeOrientedGeometryCursor_159(JNIEnv* env, jobject obj,jobject id0,jlong id1,jboolean id2)
{
  vtkHyperTreeGridOrientedGeometryCursor * temp0;
  long long   temp1;
  bool   temp2;
  temp0 = static_cast<vtkHyperTreeGridOrientedGeometryCursor*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeOrientedGeometryCursor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_NewOrientedGeometryCursor_160(JNIEnv* env, jobject obj,jlong id0,jboolean id1)
{
  long long   temp0;
  bool   temp1;
  vtkHyperTreeGridOrientedGeometryCursor * temp20;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewOrientedGeometryCursor(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_InitializeNonOrientedCursor_161(JNIEnv* env, jobject obj,jobject id0,jlong id1,jboolean id2)
{
  vtkHyperTreeGridNonOrientedCursor * temp0;
  long long   temp1;
  bool   temp2;
  temp0 = static_cast<vtkHyperTreeGridNonOrientedCursor*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeNonOrientedCursor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_NewNonOrientedCursor_162(JNIEnv* env, jobject obj,jlong id0,jboolean id1)
{
  long long   temp0;
  bool   temp1;
  vtkHyperTreeGridNonOrientedCursor * temp20;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewNonOrientedCursor(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_InitializeNonOrientedGeometryCursor_163(JNIEnv* env, jobject obj,jobject id0,jlong id1,jboolean id2)
{
  vtkHyperTreeGridNonOrientedGeometryCursor * temp0;
  long long   temp1;
  bool   temp2;
  temp0 = static_cast<vtkHyperTreeGridNonOrientedGeometryCursor*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeNonOrientedGeometryCursor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_NewNonOrientedGeometryCursor_164(JNIEnv* env, jobject obj,jlong id0,jboolean id1)
{
  long long   temp0;
  bool   temp1;
  vtkHyperTreeGridNonOrientedGeometryCursor * temp20;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewNonOrientedGeometryCursor(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_InitializeNonOrientedUnlimitedGeometryCursor_165(JNIEnv* env, jobject obj,jobject id0,jlong id1,jboolean id2)
{
  vtkHyperTreeGridNonOrientedUnlimitedGeometryCursor * temp0;
  long long   temp1;
  bool   temp2;
  temp0 = static_cast<vtkHyperTreeGridNonOrientedUnlimitedGeometryCursor*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeNonOrientedUnlimitedGeometryCursor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_NewNonOrientedUnlimitedGeometryCursor_166(JNIEnv* env, jobject obj,jlong id0,jboolean id1)
{
  long long   temp0;
  bool   temp1;
  vtkHyperTreeGridNonOrientedUnlimitedGeometryCursor * temp20;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewNonOrientedUnlimitedGeometryCursor(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_FindNonOrientedGeometryCursor_167(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  vtkHyperTreeGridNonOrientedGeometryCursor * temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindNonOrientedGeometryCursor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_FindDichotomicX_168(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
   unsigned int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindDichotomicX(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_FindDichotomicY_169(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
   unsigned int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindDichotomicY(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_FindDichotomicZ_170(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
   unsigned int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindDichotomicZ(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_InitializeNonOrientedVonNeumannSuperCursor_171(JNIEnv* env, jobject obj,jobject id0,jlong id1,jboolean id2)
{
  vtkHyperTreeGridNonOrientedVonNeumannSuperCursor * temp0;
  long long   temp1;
  bool   temp2;
  temp0 = static_cast<vtkHyperTreeGridNonOrientedVonNeumannSuperCursor*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeNonOrientedVonNeumannSuperCursor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_NewNonOrientedVonNeumannSuperCursor_172(JNIEnv* env, jobject obj,jlong id0,jboolean id1)
{
  long long   temp0;
  bool   temp1;
  vtkHyperTreeGridNonOrientedVonNeumannSuperCursor * temp20;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewNonOrientedVonNeumannSuperCursor(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_InitializeNonOrientedVonNeumannSuperCursorLight_173(JNIEnv* env, jobject obj,jobject id0,jlong id1,jboolean id2)
{
  vtkHyperTreeGridNonOrientedVonNeumannSuperCursorLight * temp0;
  long long   temp1;
  bool   temp2;
  temp0 = static_cast<vtkHyperTreeGridNonOrientedVonNeumannSuperCursorLight*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeNonOrientedVonNeumannSuperCursorLight(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_NewNonOrientedVonNeumannSuperCursorLight_174(JNIEnv* env, jobject obj,jlong id0,jboolean id1)
{
  long long   temp0;
  bool   temp1;
  vtkHyperTreeGridNonOrientedVonNeumannSuperCursorLight * temp20;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewNonOrientedVonNeumannSuperCursorLight(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_InitializeNonOrientedMooreSuperCursor_175(JNIEnv* env, jobject obj,jobject id0,jlong id1,jboolean id2)
{
  vtkHyperTreeGridNonOrientedMooreSuperCursor * temp0;
  long long   temp1;
  bool   temp2;
  temp0 = static_cast<vtkHyperTreeGridNonOrientedMooreSuperCursor*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeNonOrientedMooreSuperCursor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_NewNonOrientedMooreSuperCursor_176(JNIEnv* env, jobject obj,jlong id0,jboolean id1)
{
  long long   temp0;
  bool   temp1;
  vtkHyperTreeGridNonOrientedMooreSuperCursor * temp20;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewNonOrientedMooreSuperCursor(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_InitializeNonOrientedMooreSuperCursorLight_177(JNIEnv* env, jobject obj,jobject id0,jlong id1,jboolean id2)
{
  vtkHyperTreeGridNonOrientedMooreSuperCursorLight * temp0;
  long long   temp1;
  bool   temp2;
  temp0 = static_cast<vtkHyperTreeGridNonOrientedMooreSuperCursorLight*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeNonOrientedMooreSuperCursorLight(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_NewNonOrientedMooreSuperCursorLight_178(JNIEnv* env, jobject obj,jlong id0,jboolean id1)
{
  long long   temp0;
  bool   temp1;
  vtkHyperTreeGridNonOrientedMooreSuperCursorLight * temp20;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewNonOrientedMooreSuperCursorLight(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_InitializeNonOrientedUnlimitedMooreSuperCursor_179(JNIEnv* env, jobject obj,jobject id0,jlong id1,jboolean id2)
{
  vtkHyperTreeGridNonOrientedUnlimitedMooreSuperCursor * temp0;
  long long   temp1;
  bool   temp2;
  temp0 = static_cast<vtkHyperTreeGridNonOrientedUnlimitedMooreSuperCursor*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = (id2 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeNonOrientedUnlimitedMooreSuperCursor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_NewNonOrientedUnlimitedMooreSuperCursor_180(JNIEnv* env, jobject obj,jlong id0,jboolean id1)
{
  long long   temp0;
  bool   temp1;
  vtkHyperTreeGridNonOrientedUnlimitedMooreSuperCursor * temp20;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewNonOrientedUnlimitedMooreSuperCursor(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_Initialize_181(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetTree_182(JNIEnv* env, jobject obj,jlong id0,jboolean id1)
{
  long long   temp0;
  bool   temp1;
  vtkHyperTree * temp20;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTree(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_SetTree_183(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkHyperTree * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkHyperTree*>(vtkJavaGetPointerFromObject(env, id1));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTree(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_ShallowCopy_184(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_DeepCopy_185(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_GetExtentType_186(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtentType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetActualMemorySizeBytes_187(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySizeBytes();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetActualMemorySize_188(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHyperTreeGrid_SupportsGhostArray_189(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SupportsGhostArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetPureMask_190(JNIEnv* env, jobject obj)
{
  vtkBitArray * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPureMask();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHyperTreeGrid_GetChildMask_191(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
   unsigned int   temp20;
  temp0 = id0;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetChildMask(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetShiftedLevelZeroIndex_192(JNIEnv* env, jobject obj,jlong id0,jint id1,jint id2,jint id3)
{
  long long   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShiftedLevelZeroIndex(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetGlobalNodeIndexMax_193(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGlobalNodeIndexMax();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_InitializeLocalIndexNode_194(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitializeLocalIndexNode();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkHyperTreeGrid_HasAnyGhostCells_195(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAnyGhostCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetGhostCells_196(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGhostCells();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetTreeGhostArray_197(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTreeGhostArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_AllocateTreeGhostArray_198(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateTreeGhostArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetData_199(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkHyperTreeGrid * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetData_1100(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkHyperTreeGrid * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_ComputeBounds_1101(JNIEnv* env, jobject obj)
{

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeBounds();

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkHyperTreeGrid_GetBounds_1102(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_GetBounds_1103(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_GetGridBounds_1104(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetGridBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkHyperTreeGrid_GetCenter_1105(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenter();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHyperTreeGrid_GetCenter_1106(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCenter(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetCellData_1107(JNIEnv* env, jobject obj)
{
  vtkCellData * temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellData();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetAttributesAsFieldData_1108(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkFieldData * temp20;
  temp0 = id0;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAttributesAsFieldData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetNumberOfElements_1109(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfElements(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHyperTreeGrid_GetNumberOfCells_1110(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkHyperTreeGrid* op = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkHyperTreeGrid_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkHyperTreeGrid::New());
}
