// python wrapper for vtkExternalOpenGLRenderer
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkExternalOpenGLRenderer.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkExternalOpenGLRenderer(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkExternalOpenGLRenderer_ClassNew(); }


static PyObject *
PyvtkExternalOpenGLRenderer_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkExternalOpenGLRenderer::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkExternalOpenGLRenderer::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkExternalOpenGLRenderer *tempr = vtkExternalOpenGLRenderer::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkExternalOpenGLRenderer *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkExternalOpenGLRenderer::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkExternalOpenGLRenderer::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkExternalOpenGLRenderer::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_Render(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Render");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Render();
    }
    else
    {
      op->vtkExternalOpenGLRenderer::Render();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_MakeCamera(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MakeCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCamera *tempr = (ap.IsBound() ?
      op->MakeCamera() :
      op->vtkExternalOpenGLRenderer::MakeCamera());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_AddExternalLight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddExternalLight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  vtkExternalLight *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkExternalLight"))
  {
    if (ap.IsBound())
    {
      op->AddExternalLight(temp0);
    }
    else
    {
      op->vtkExternalOpenGLRenderer::AddExternalLight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_RemoveExternalLight(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveExternalLight");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  vtkExternalLight *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkExternalLight"))
  {
    if (ap.IsBound())
    {
      op->RemoveExternalLight(temp0);
    }
    else
    {
      op->vtkExternalOpenGLRenderer::RemoveExternalLight(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_RemoveAllExternalLights(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllExternalLights");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllExternalLights();
    }
    else
    {
      op->vtkExternalOpenGLRenderer::RemoveAllExternalLights();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_GetPreserveGLCameraMatrices(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPreserveGLCameraMatrices");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPreserveGLCameraMatrices() :
      op->vtkExternalOpenGLRenderer::GetPreserveGLCameraMatrices());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_SetPreserveGLCameraMatrices(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPreserveGLCameraMatrices");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPreserveGLCameraMatrices(temp0);
    }
    else
    {
      op->vtkExternalOpenGLRenderer::SetPreserveGLCameraMatrices(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_PreserveGLCameraMatricesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PreserveGLCameraMatricesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PreserveGLCameraMatricesOn();
    }
    else
    {
      op->vtkExternalOpenGLRenderer::PreserveGLCameraMatricesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_PreserveGLCameraMatricesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PreserveGLCameraMatricesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PreserveGLCameraMatricesOff();
    }
    else
    {
      op->vtkExternalOpenGLRenderer::PreserveGLCameraMatricesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_GetPreserveGLLights(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPreserveGLLights");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPreserveGLLights() :
      op->vtkExternalOpenGLRenderer::GetPreserveGLLights());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_SetPreserveGLLights(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPreserveGLLights");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPreserveGLLights(temp0);
    }
    else
    {
      op->vtkExternalOpenGLRenderer::SetPreserveGLLights(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_PreserveGLLightsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PreserveGLLightsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PreserveGLLightsOn();
    }
    else
    {
      op->vtkExternalOpenGLRenderer::PreserveGLLightsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalOpenGLRenderer_PreserveGLLightsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PreserveGLLightsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalOpenGLRenderer *op = static_cast<vtkExternalOpenGLRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PreserveGLLightsOff();
    }
    else
    {
      op->vtkExternalOpenGLRenderer::PreserveGLLightsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkExternalOpenGLRenderer_Methods[] = {
  {"IsTypeOf", PyvtkExternalOpenGLRenderer_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkExternalOpenGLRenderer_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkExternalOpenGLRenderer_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkExternalOpenGLRenderer\nC++: static vtkExternalOpenGLRenderer *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkExternalOpenGLRenderer_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkExternalOpenGLRenderer\nC++: vtkExternalOpenGLRenderer *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkExternalOpenGLRenderer_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkExternalOpenGLRenderer_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Render", PyvtkExternalOpenGLRenderer_Render, METH_VARARGS,
   "Render(self) -> None\nC++: void Render() override;\n\nSynchronize camera and light parameters\n"},
  {"MakeCamera", PyvtkExternalOpenGLRenderer_MakeCamera, METH_VARARGS,
   "MakeCamera(self) -> vtkCamera\nC++: vtkCamera *MakeCamera() override;\n\nCreate a new Camera sutible for use with this type of Renderer.\nThis function creates the vtkExternalOpenGLCamera.\n"},
  {"AddExternalLight", PyvtkExternalOpenGLRenderer_AddExternalLight, METH_VARARGS,
   "AddExternalLight(self, __a:vtkExternalLight) -> None\nC++: virtual void AddExternalLight(vtkExternalLight *)\n\nAdd an external light to the list of external lights.\n"},
  {"RemoveExternalLight", PyvtkExternalOpenGLRenderer_RemoveExternalLight, METH_VARARGS,
   "RemoveExternalLight(self, __a:vtkExternalLight) -> None\nC++: virtual void RemoveExternalLight(vtkExternalLight *)\n\nRemove an external light from the list of external lights.\n"},
  {"RemoveAllExternalLights", PyvtkExternalOpenGLRenderer_RemoveAllExternalLights, METH_VARARGS,
   "RemoveAllExternalLights(self) -> None\nC++: virtual void RemoveAllExternalLights()\n\nRemove all external lights\n"},
  {"GetPreserveGLCameraMatrices", PyvtkExternalOpenGLRenderer_GetPreserveGLCameraMatrices, METH_VARARGS,
   "GetPreserveGLCameraMatrices(self) -> int\nC++: virtual vtkTypeBool GetPreserveGLCameraMatrices()\n\nIf PreserveGLCameraMatrices is set to true, VTK camera matrices\nare copied from the current context GL_MODELVIEW_MATRIX and\nGL_PROJECTION_MATRIX parameters before each render call. This\nflag is on by default.\n"},
  {"SetPreserveGLCameraMatrices", PyvtkExternalOpenGLRenderer_SetPreserveGLCameraMatrices, METH_VARARGS,
   "SetPreserveGLCameraMatrices(self, _arg:int) -> None\nC++: virtual void SetPreserveGLCameraMatrices(vtkTypeBool _arg)\n\n"},
  {"PreserveGLCameraMatricesOn", PyvtkExternalOpenGLRenderer_PreserveGLCameraMatricesOn, METH_VARARGS,
   "PreserveGLCameraMatricesOn(self) -> None\nC++: virtual void PreserveGLCameraMatricesOn()\n\n"},
  {"PreserveGLCameraMatricesOff", PyvtkExternalOpenGLRenderer_PreserveGLCameraMatricesOff, METH_VARARGS,
   "PreserveGLCameraMatricesOff(self) -> None\nC++: virtual void PreserveGLCameraMatricesOff()\n\n"},
  {"GetPreserveGLLights", PyvtkExternalOpenGLRenderer_GetPreserveGLLights, METH_VARARGS,
   "GetPreserveGLLights(self) -> int\nC++: virtual vtkTypeBool GetPreserveGLLights()\n\nIf PreserveGLLights is set to true, existing GL lights are\nmodified before each render call to match the collection of\nlights added with AddExternalLight(). This flag is on by default.\n"},
  {"SetPreserveGLLights", PyvtkExternalOpenGLRenderer_SetPreserveGLLights, METH_VARARGS,
   "SetPreserveGLLights(self, _arg:int) -> None\nC++: virtual void SetPreserveGLLights(vtkTypeBool _arg)\n\n"},
  {"PreserveGLLightsOn", PyvtkExternalOpenGLRenderer_PreserveGLLightsOn, METH_VARARGS,
   "PreserveGLLightsOn(self) -> None\nC++: virtual void PreserveGLLightsOn()\n\n"},
  {"PreserveGLLightsOff", PyvtkExternalOpenGLRenderer_PreserveGLLightsOff, METH_VARARGS,
   "PreserveGLLightsOff(self) -> None\nC++: virtual void PreserveGLLightsOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkExternalOpenGLRenderer_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("preserve_gl_camera_matrices"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalOpenGLRenderer_GetPreserveGLCameraMatrices(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalOpenGLRenderer_SetPreserveGLCameraMatrices(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalOpenGLRenderer_SetPreserveGLCameraMatrices(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPreserveGLCameraMatrices/SetPreserveGLCameraMatrices\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("preserve_gl_lights"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalOpenGLRenderer_GetPreserveGLLights(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalOpenGLRenderer_SetPreserveGLLights(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalOpenGLRenderer_SetPreserveGLLights(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPreserveGLLights/SetPreserveGLLights\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkExternalOpenGLRenderer_Doc =
  "vtkExternalOpenGLRenderer - OpenGL renderer\n\n"
  "Superclass: vtkOpenGLRenderer\n\n"
  "vtkExternalOpenGLRenderer is a secondary implementation of the class\n"
  "vtkOpenGLRenderer. vtkExternalOpenGLRenderer interfaces to the OpenGL\n"
  "graphics library. This class provides API to preserve the color and\n"
  "depth buffers, thereby allowing external applications to manage the\n"
  "OpenGL buffers. This becomes very useful when there are multiple\n"
  "OpenGL applications sharing the same OpenGL context.\n\n"
  "vtkExternalOpenGLRenderer makes sure that the camera used in the\n"
  "scene if of type vtkExternalOpenGLCamera. It manages light and camera\n"
  "transformations for VTK objects in the OpenGL context.\n\n"
  "\\sa vtkExternalOpenGLCamera\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkExternalOpenGLRenderer_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingExternal.vtkExternalOpenGLRenderer", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkExternalOpenGLRenderer_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkExternalOpenGLRenderer_StaticNew()
{
  return vtkExternalOpenGLRenderer::New();
}

PyObject *PyvtkExternalOpenGLRenderer_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkExternalOpenGLRenderer_Type, PyvtkExternalOpenGLRenderer_Methods,
    "vtkExternalOpenGLRenderer",
 &PyvtkExternalOpenGLRenderer_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkOpenGLRenderer");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkExternalOpenGLRenderer_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkExternalOpenGLRenderer(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkExternalOpenGLRenderer_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkExternalOpenGLRenderer", o) != 0)
  {
    Py_DECREF(o);
  }

}

