// python wrapper for vtkBoostPrimMinimumSpanningTree
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkStdString.h"
#include "vtkBoostPrimMinimumSpanningTree.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkBoostPrimMinimumSpanningTree(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkBoostPrimMinimumSpanningTree_ClassNew(); }


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkBoostPrimMinimumSpanningTree::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostPrimMinimumSpanningTree *op = static_cast<vtkBoostPrimMinimumSpanningTree *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkBoostPrimMinimumSpanningTree::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkBoostPrimMinimumSpanningTree *tempr = vtkBoostPrimMinimumSpanningTree::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostPrimMinimumSpanningTree *op = static_cast<vtkBoostPrimMinimumSpanningTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkBoostPrimMinimumSpanningTree *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkBoostPrimMinimumSpanningTree::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkBoostPrimMinimumSpanningTree::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostPrimMinimumSpanningTree *op = static_cast<vtkBoostPrimMinimumSpanningTree *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkBoostPrimMinimumSpanningTree::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_SetEdgeWeightArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEdgeWeightArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostPrimMinimumSpanningTree *op = static_cast<vtkBoostPrimMinimumSpanningTree *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEdgeWeightArrayName(temp0);
    }
    else
    {
      op->vtkBoostPrimMinimumSpanningTree::SetEdgeWeightArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_SetOriginVertex_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOriginVertex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostPrimMinimumSpanningTree *op = static_cast<vtkBoostPrimMinimumSpanningTree *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOriginVertex(temp0);
    }
    else
    {
      op->vtkBoostPrimMinimumSpanningTree::SetOriginVertex(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkBoostPrimMinimumSpanningTree_SetOriginVertex_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOriginVertex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostPrimMinimumSpanningTree *op = static_cast<vtkBoostPrimMinimumSpanningTree *>(vp);

  vtkStdString temp0;
  vtkVariant *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVariant"))
  {
    if (ap.IsBound())
    {
      op->SetOriginVertex(temp0, *temp1);
    }
    else
    {
      op->vtkBoostPrimMinimumSpanningTree::SetOriginVertex(temp0, *temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}

static PyObject *
PyvtkBoostPrimMinimumSpanningTree_SetOriginVertex(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkBoostPrimMinimumSpanningTree_SetOriginVertex_s1(self, args);
    case 2:
      return PyvtkBoostPrimMinimumSpanningTree_SetOriginVertex_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetOriginVertex");
  return nullptr;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_SetCreateGraphVertexIdArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCreateGraphVertexIdArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostPrimMinimumSpanningTree *op = static_cast<vtkBoostPrimMinimumSpanningTree *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCreateGraphVertexIdArray(temp0);
    }
    else
    {
      op->vtkBoostPrimMinimumSpanningTree::SetCreateGraphVertexIdArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_GetCreateGraphVertexIdArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCreateGraphVertexIdArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostPrimMinimumSpanningTree *op = static_cast<vtkBoostPrimMinimumSpanningTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetCreateGraphVertexIdArray() :
      op->vtkBoostPrimMinimumSpanningTree::GetCreateGraphVertexIdArray());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_CreateGraphVertexIdArrayOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CreateGraphVertexIdArrayOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostPrimMinimumSpanningTree *op = static_cast<vtkBoostPrimMinimumSpanningTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CreateGraphVertexIdArrayOn();
    }
    else
    {
      op->vtkBoostPrimMinimumSpanningTree::CreateGraphVertexIdArrayOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_CreateGraphVertexIdArrayOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CreateGraphVertexIdArrayOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostPrimMinimumSpanningTree *op = static_cast<vtkBoostPrimMinimumSpanningTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CreateGraphVertexIdArrayOff();
    }
    else
    {
      op->vtkBoostPrimMinimumSpanningTree::CreateGraphVertexIdArrayOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_SetNegateEdgeWeights(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNegateEdgeWeights");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostPrimMinimumSpanningTree *op = static_cast<vtkBoostPrimMinimumSpanningTree *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNegateEdgeWeights(temp0);
    }
    else
    {
      op->vtkBoostPrimMinimumSpanningTree::SetNegateEdgeWeights(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_GetNegateEdgeWeights(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNegateEdgeWeights");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostPrimMinimumSpanningTree *op = static_cast<vtkBoostPrimMinimumSpanningTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetNegateEdgeWeights() :
      op->vtkBoostPrimMinimumSpanningTree::GetNegateEdgeWeights());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_NegateEdgeWeightsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NegateEdgeWeightsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostPrimMinimumSpanningTree *op = static_cast<vtkBoostPrimMinimumSpanningTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->NegateEdgeWeightsOn();
    }
    else
    {
      op->vtkBoostPrimMinimumSpanningTree::NegateEdgeWeightsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkBoostPrimMinimumSpanningTree_NegateEdgeWeightsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NegateEdgeWeightsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkBoostPrimMinimumSpanningTree *op = static_cast<vtkBoostPrimMinimumSpanningTree *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->NegateEdgeWeightsOff();
    }
    else
    {
      op->vtkBoostPrimMinimumSpanningTree::NegateEdgeWeightsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkBoostPrimMinimumSpanningTree_Methods[] = {
  {"IsTypeOf", PyvtkBoostPrimMinimumSpanningTree_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkBoostPrimMinimumSpanningTree_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkBoostPrimMinimumSpanningTree_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkBoostPrimMinimumSpanningTree\nC++: static vtkBoostPrimMinimumSpanningTree *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkBoostPrimMinimumSpanningTree_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkBoostPrimMinimumSpanningTree\nC++: vtkBoostPrimMinimumSpanningTree *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkBoostPrimMinimumSpanningTree_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkBoostPrimMinimumSpanningTree_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetEdgeWeightArrayName", PyvtkBoostPrimMinimumSpanningTree_SetEdgeWeightArrayName, METH_VARARGS,
   "SetEdgeWeightArrayName(self, _arg:str) -> None\nC++: virtual void SetEdgeWeightArrayName(const char *_arg)\n\nSet the name of the edge-weight input array, which must name an\narray that is part of the edge data of the input graph and\ncontains numeric data. If the edge-weight array is not of type\nvtkDoubleArray, the array will be copied into a temporary\nvtkDoubleArray.\n"},
  {"SetOriginVertex", PyvtkBoostPrimMinimumSpanningTree_SetOriginVertex, METH_VARARGS,
   "SetOriginVertex(self, index:int) -> None\nC++: void SetOriginVertex(vtkIdType index)\nSetOriginVertex(self, arrayName:str, value:vtkVariant) -> None\nC++: void SetOriginVertex(vtkStdString arrayName,\n    vtkVariant value)\n\nSet the index (into the vertex array) of the minimum spanning\ntree 'origin' vertex.\n"},
  {"SetCreateGraphVertexIdArray", PyvtkBoostPrimMinimumSpanningTree_SetCreateGraphVertexIdArray, METH_VARARGS,
   "SetCreateGraphVertexIdArray(self, _arg:bool) -> None\nC++: virtual void SetCreateGraphVertexIdArray(bool _arg)\n\nStores the graph vertex ids for the tree vertices in an array\nnamed \"GraphVertexId\".  Default is off.\n"},
  {"GetCreateGraphVertexIdArray", PyvtkBoostPrimMinimumSpanningTree_GetCreateGraphVertexIdArray, METH_VARARGS,
   "GetCreateGraphVertexIdArray(self) -> bool\nC++: virtual bool GetCreateGraphVertexIdArray()\n\n"},
  {"CreateGraphVertexIdArrayOn", PyvtkBoostPrimMinimumSpanningTree_CreateGraphVertexIdArrayOn, METH_VARARGS,
   "CreateGraphVertexIdArrayOn(self) -> None\nC++: virtual void CreateGraphVertexIdArrayOn()\n\n"},
  {"CreateGraphVertexIdArrayOff", PyvtkBoostPrimMinimumSpanningTree_CreateGraphVertexIdArrayOff, METH_VARARGS,
   "CreateGraphVertexIdArrayOff(self) -> None\nC++: virtual void CreateGraphVertexIdArrayOff()\n\n"},
  {"SetNegateEdgeWeights", PyvtkBoostPrimMinimumSpanningTree_SetNegateEdgeWeights, METH_VARARGS,
   "SetNegateEdgeWeights(self, value:bool) -> None\nC++: void SetNegateEdgeWeights(bool value)\n\nWhether to negate the edge weights. By negating the edge weights\nthis algorithm will give you the 'maximal' spanning tree (i.e.\nthe algorithm will try to create a spanning tree with the highest\nweighted edges). Defaulted to Off. FIXME: put a real definition\nin...\n"},
  {"GetNegateEdgeWeights", PyvtkBoostPrimMinimumSpanningTree_GetNegateEdgeWeights, METH_VARARGS,
   "GetNegateEdgeWeights(self) -> bool\nC++: virtual bool GetNegateEdgeWeights()\n\n"},
  {"NegateEdgeWeightsOn", PyvtkBoostPrimMinimumSpanningTree_NegateEdgeWeightsOn, METH_VARARGS,
   "NegateEdgeWeightsOn(self) -> None\nC++: virtual void NegateEdgeWeightsOn()\n\n"},
  {"NegateEdgeWeightsOff", PyvtkBoostPrimMinimumSpanningTree_NegateEdgeWeightsOff, METH_VARARGS,
   "NegateEdgeWeightsOff(self) -> None\nC++: virtual void NegateEdgeWeightsOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkBoostPrimMinimumSpanningTree_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("edge_weight_array_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostPrimMinimumSpanningTree_SetEdgeWeightArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostPrimMinimumSpanningTree_SetEdgeWeightArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEdgeWeightArrayName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("origin_vertex"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostPrimMinimumSpanningTree_SetOriginVertex(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostPrimMinimumSpanningTree_SetOriginVertex(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOriginVertex\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("create_graph_vertex_id_array"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostPrimMinimumSpanningTree_GetCreateGraphVertexIdArray(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostPrimMinimumSpanningTree_SetCreateGraphVertexIdArray(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostPrimMinimumSpanningTree_SetCreateGraphVertexIdArray(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCreateGraphVertexIdArray/SetCreateGraphVertexIdArray\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("negate_edge_weights"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkBoostPrimMinimumSpanningTree_GetNegateEdgeWeights(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkBoostPrimMinimumSpanningTree_SetNegateEdgeWeights(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkBoostPrimMinimumSpanningTree_SetNegateEdgeWeights(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNegateEdgeWeights/SetNegateEdgeWeights\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkBoostPrimMinimumSpanningTree_Doc =
  "vtkBoostPrimMinimumSpanningTree - Constructs a minimum spanning\n   tree from a graph, start node, and the weighting array\n\n"
  "Superclass: vtkTreeAlgorithm\n\n"
  "This vtk class uses the Boost Prim Minimum Spanning Tree generic\n"
  "algorithm to perform a minimum spanning tree creation given a\n"
  "weighting value for each of the edges in the input graph and a a\n"
  "starting node for the tree. A couple of caveats to be noted with the\n"
  "Prim implementation versus the Kruskal implementation:\n"
  "1. The negate edge weights function cannot be utilized to obtain a\n"
  "   'maximal' spanning tree (an exception is thrown when negated edge\n"
  "   weights exist), and\n"
  "2. the Boost implementation of the Prim algorithm returns a vertex\n"
  "   predecessor map which results in some ambiguity about which edge\n"
  "   from the original graph should be utilized if parallel edges\n"
  "   between nodes exist; therefore, the current VTK implementation\n"
  "   does not copy the edge data from the graph to the new tree.\n\n"
  "@sa\n"
  "vtkGraph vtkBoostGraphAdapter\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkBoostPrimMinimumSpanningTree_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkInfovisBoostGraphAlgorithms.vtkBoostPrimMinimumSpanningTree", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkBoostPrimMinimumSpanningTree_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkBoostPrimMinimumSpanningTree_StaticNew()
{
  return vtkBoostPrimMinimumSpanningTree::New();
}

PyObject *PyvtkBoostPrimMinimumSpanningTree_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkBoostPrimMinimumSpanningTree_Type, PyvtkBoostPrimMinimumSpanningTree_Methods,
    "vtkBoostPrimMinimumSpanningTree",
 &PyvtkBoostPrimMinimumSpanningTree_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkTreeAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkBoostPrimMinimumSpanningTree_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkBoostPrimMinimumSpanningTree(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkBoostPrimMinimumSpanningTree_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkBoostPrimMinimumSpanningTree", o) != 0)
  {
    Py_DECREF(o);
  }

}

