/*
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * Copyright (c) 2016 Canon Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "ReadableByteStreamInternalsBuiltins.h"

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/ImplementationVisibility.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSObjectInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

constinit const JSC::ConstructAbility s_readableByteStreamInternalsPrivateInitializeReadableByteStreamControllerCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsPrivateInitializeReadableByteStreamControllerCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsPrivateInitializeReadableByteStreamControllerCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsPrivateInitializeReadableByteStreamControllerCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsPrivateInitializeReadableByteStreamControllerCodeLength = 2333;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsPrivateInitializeReadableByteStreamControllerCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsPrivateInitializeReadableByteStreamControllerCode =
    "(function (stream, underlyingByteSource, highWaterMark)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableStream(stream))\n" \
    "        @throwTypeError(\"ReadableByteStreamController needs a ReadableStream\");\n" \
    "\n" \
    "    //\n" \
    "    if (@getByIdDirectPrivate(stream, \"readableStreamController\") !== null)\n" \
    "        @throwTypeError(\"ReadableStream already has a controller\");\n" \
    "\n" \
    "    @putByIdDirectPrivate(this, \"controlledReadableStream\", stream);\n" \
    "    @putByIdDirectPrivate(this, \"underlyingByteSource\", underlyingByteSource);\n" \
    "    @putByIdDirectPrivate(this, \"pullAgain\", false);\n" \
    "    @putByIdDirectPrivate(this, \"pulling\", false);\n" \
    "    @readableByteStreamControllerClearPendingPullIntos(this);\n" \
    "    @putByIdDirectPrivate(this, \"queue\", @newQueue());\n" \
    "    @putByIdDirectPrivate(this, \"started\", false);\n" \
    "    @putByIdDirectPrivate(this, \"closeRequested\", false);\n" \
    "\n" \
    "    let hwm = @toNumber(highWaterMark);\n" \
    "    if (hwm !== hwm || hwm < 0)\n" \
    "        @throwRangeError(\"highWaterMark value is negative or not a number\");\n" \
    "    @putByIdDirectPrivate(this, \"strategyHWM\", hwm);\n" \
    "\n" \
    "    let autoAllocateChunkSize = underlyingByteSource.autoAllocateChunkSize;\n" \
    "    if (autoAllocateChunkSize !== @undefined) {\n" \
    "        autoAllocateChunkSize = @toNumber(autoAllocateChunkSize);\n" \
    "        if (autoAllocateChunkSize <= 0 || autoAllocateChunkSize === @Infinity || autoAllocateChunkSize === -@Infinity)\n" \
    "            @throwRangeError(\"autoAllocateChunkSize value is negative or equal to positive or negative infinity\");\n" \
    "    }\n" \
    "    @putByIdDirectPrivate(this, \"autoAllocateChunkSize\", autoAllocateChunkSize);\n" \
    "    @putByIdDirectPrivate(this, \"pendingPullIntos\", []);\n" \
    "\n" \
    "    const controller = this;\n" \
    "    const startResult = @promiseInvokeOrNoopNoCatch(underlyingByteSource, \"start\", [this]).@then(() => {\n" \
    "        @putByIdDirectPrivate(controller, \"started\", true);\n" \
    "        @assert(!@getByIdDirectPrivate(controller, \"pulling\"));\n" \
    "        @assert(!@getByIdDirectPrivate(controller, \"pullAgain\"));\n" \
    "        @readableByteStreamControllerCallPullIfNeeded(controller);\n" \
    "    }, (error) => {\n" \
    "        if (@getByIdDirectPrivate(stream, \"state\") === @streamReadable)\n" \
    "            @readableByteStreamControllerError(controller, error);\n" \
    "    });\n" \
    "\n" \
    "    @putByIdDirectPrivate(this, \"cancel\", @readableByteStreamControllerCancel);\n" \
    "    @putByIdDirectPrivate(this, \"pull\", @readableByteStreamControllerPull);\n" \
    "\n" \
    "    return this;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsPrivateInitializeReadableStreamBYOBRequestCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsPrivateInitializeReadableStreamBYOBRequestCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsPrivateInitializeReadableStreamBYOBRequestCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsPrivateInitializeReadableStreamBYOBRequestCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsPrivateInitializeReadableStreamBYOBRequestCodeLength = 187;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsPrivateInitializeReadableStreamBYOBRequestCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsPrivateInitializeReadableStreamBYOBRequestCode =
    "(function (controller, view)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @putByIdDirectPrivate(this, \"associatedReadableByteStreamController\", controller);\n" \
    "    @putByIdDirectPrivate(this, \"view\", view);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsIsReadableByteStreamControllerCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsIsReadableByteStreamControllerCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsIsReadableByteStreamControllerCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsIsReadableByteStreamControllerCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsIsReadableByteStreamControllerCodeLength = 158;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsIsReadableByteStreamControllerCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsIsReadableByteStreamControllerCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    return @isObject(controller) && !!@getByIdDirectPrivate(controller, \"underlyingByteSource\");\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsIsReadableStreamBYOBRequestCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsIsReadableStreamBYOBRequestCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsIsReadableStreamBYOBRequestCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsIsReadableStreamBYOBRequestCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsIsReadableStreamBYOBRequestCodeLength = 179;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsIsReadableStreamBYOBRequestCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsIsReadableStreamBYOBRequestCode =
    "(function (byobRequest)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    return @isObject(byobRequest) && !!@getByIdDirectPrivate(byobRequest, \"associatedReadableByteStreamController\");\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsIsReadableStreamBYOBReaderCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsIsReadableStreamBYOBReaderCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsIsReadableStreamBYOBReaderCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsIsReadableStreamBYOBReaderCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsIsReadableStreamBYOBReaderCodeLength = 149;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsIsReadableStreamBYOBReaderCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsIsReadableStreamBYOBReaderCode =
    "(function (reader)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    return @isObject(reader) && !!@getByIdDirectPrivate(reader, \"readIntoRequests\");\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerCancelCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerCancelCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerCancelCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerCancelCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerCancelCodeLength = 392;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerCancelCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerCancelCode =
    "(function (controller, reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    var pendingPullIntos = @getByIdDirectPrivate(controller, \"pendingPullIntos\");\n" \
    "    if (pendingPullIntos.length > 0)\n" \
    "        pendingPullIntos[0].bytesFilled = 0;\n" \
    "    @putByIdDirectPrivate(controller, \"queue\", @newQueue());\n" \
    "    return @promiseInvokeOrNoop(@getByIdDirectPrivate(controller, \"underlyingByteSource\"), \"cancel\", [reason]);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerErrorCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerErrorCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerErrorCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerErrorCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerErrorCodeLength = 399;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerErrorCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerErrorCode =
    "(function (controller, e)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@getByIdDirectPrivate(@getByIdDirectPrivate(controller, \"controlledReadableStream\"), \"state\") === @streamReadable);\n" \
    "    @readableByteStreamControllerClearPendingPullIntos(controller);\n" \
    "    @putByIdDirectPrivate(controller, \"queue\", @newQueue());\n" \
    "    @readableStreamError(@getByIdDirectPrivate(controller, \"controlledReadableStream\"), e);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerCloseCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerCloseCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerCloseCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerCloseCodeLength = 848;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerCloseCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerCloseCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(!@getByIdDirectPrivate(controller, \"closeRequested\"));\n" \
    "    @assert(@getByIdDirectPrivate(@getByIdDirectPrivate(controller, \"controlledReadableStream\"), \"state\") === @streamReadable);\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(controller, \"queue\").size > 0) {\n" \
    "        @putByIdDirectPrivate(controller, \"closeRequested\", true);\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    var pendingPullIntos = @getByIdDirectPrivate(controller, \"pendingPullIntos\");\n" \
    "    if (pendingPullIntos.length > 0) {\n" \
    "        if (pendingPullIntos[0].bytesFilled > 0) {\n" \
    "            const e = @makeTypeError(\"Close requested while there remain pending bytes\");\n" \
    "            @readableByteStreamControllerError(controller, e);\n" \
    "            throw e;\n" \
    "        }\n" \
    "    }\n" \
    "\n" \
    "    @readableStreamClose(@getByIdDirectPrivate(controller, \"controlledReadableStream\"));\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerClearPendingPullIntosCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerClearPendingPullIntosCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerClearPendingPullIntosCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerClearPendingPullIntosCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerClearPendingPullIntosCodeLength = 178;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerClearPendingPullIntosCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerClearPendingPullIntosCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @readableByteStreamControllerInvalidateBYOBRequest(controller);\n" \
    "    @putByIdDirectPrivate(controller, \"pendingPullIntos\", []);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerGetDesiredSizeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerGetDesiredSizeCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerGetDesiredSizeCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerGetDesiredSizeCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerGetDesiredSizeCodeLength = 406;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerGetDesiredSizeCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerGetDesiredSizeCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "\n" \
    "    if (state === @streamErrored)\n" \
    "        return null;\n" \
    "    if (state === @streamClosed)\n" \
    "        return 0;\n" \
    "\n" \
    "    return @getByIdDirectPrivate(controller, \"strategyHWM\") - @getByIdDirectPrivate(controller, \"queue\").size;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableStreamHasBYOBReaderCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableStreamHasBYOBReaderCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableStreamHasBYOBReaderCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableStreamHasBYOBReaderCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableStreamHasBYOBReaderCodeLength = 176;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableStreamHasBYOBReaderCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableStreamHasBYOBReaderCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const reader = @getByIdDirectPrivate(stream, \"reader\");\n" \
    "    return reader !== @undefined && @isReadableStreamBYOBReader(reader);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableStreamHasDefaultReaderCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableStreamHasDefaultReaderCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableStreamHasDefaultReaderCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableStreamHasDefaultReaderCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableStreamHasDefaultReaderCodeLength = 179;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableStreamHasDefaultReaderCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableStreamHasDefaultReaderCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const reader = @getByIdDirectPrivate(stream, \"reader\");\n" \
    "    return reader !== @undefined && @isReadableStreamDefaultReader(reader);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerHandleQueueDrainCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerHandleQueueDrainCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerHandleQueueDrainCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerHandleQueueDrainCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerHandleQueueDrainCodeLength = 458;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerHandleQueueDrainCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerHandleQueueDrainCode =
    "(function (controller) {\n" \
    "\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@getByIdDirectPrivate(@getByIdDirectPrivate(controller, \"controlledReadableStream\"), \"state\") === @streamReadable);\n" \
    "    if (!@getByIdDirectPrivate(controller, \"queue\").size && @getByIdDirectPrivate(controller, \"closeRequested\"))\n" \
    "        @readableStreamClose(@getByIdDirectPrivate(controller, \"controlledReadableStream\"));\n" \
    "    else\n" \
    "        @readableByteStreamControllerCallPullIfNeeded(controller);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerPullCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerPullCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerPullCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerPullCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerPullCodeLength = 1701;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerPullCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerPullCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "    @assert(@readableStreamHasDefaultReader(stream));\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(controller, \"queue\").size > 0) {\n" \
    "        @assert(@getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readRequests\").length === 0);\n" \
    "        const entry = @getByIdDirectPrivate(controller, \"queue\").content.@shift();\n" \
    "        @getByIdDirectPrivate(controller, \"queue\").size -= entry.byteLength;\n" \
    "        @readableByteStreamControllerHandleQueueDrain(controller);\n" \
    "        let view;\n" \
    "        try {\n" \
    "            view = new @Uint8Array(entry.buffer, entry.byteOffset, entry.byteLength);\n" \
    "        } catch (error) {\n" \
    "            return @Promise.@reject(error);\n" \
    "        }\n" \
    "        return @createFulfilledPromise({ value: view, done: false });\n" \
    "    }\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(controller, \"autoAllocateChunkSize\") !== @undefined) {\n" \
    "        let buffer;\n" \
    "        try {\n" \
    "            buffer = new @ArrayBuffer(@getByIdDirectPrivate(controller, \"autoAllocateChunkSize\"));\n" \
    "        } catch (error) {\n" \
    "            return @Promise.@reject(error);\n" \
    "        }\n" \
    "        const pullIntoDescriptor = {\n" \
    "            buffer,\n" \
    "            byteOffset: 0,\n" \
    "            byteLength: @getByIdDirectPrivate(controller, \"autoAllocateChunkSize\"),\n" \
    "            bytesFilled: 0,\n" \
    "            elementSize: 1,\n" \
    "            ctor: @Uint8Array,\n" \
    "            readerType: 'default'\n" \
    "        };\n" \
    "        @arrayPush(@getByIdDirectPrivate(controller, \"pendingPullIntos\"), pullIntoDescriptor);\n" \
    "    }\n" \
    "\n" \
    "    const promise = @readableStreamAddReadRequest(stream);\n" \
    "    @readableByteStreamControllerCallPullIfNeeded(controller);\n" \
    "    return promise;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerShouldCallPullCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerShouldCallPullCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerShouldCallPullCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerShouldCallPullCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerShouldCallPullCodeLength = 815;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerShouldCallPullCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerShouldCallPullCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(stream, \"state\") !== @streamReadable)\n" \
    "        return false;\n" \
    "    if (@getByIdDirectPrivate(controller, \"closeRequested\"))\n" \
    "        return false;\n" \
    "    if (!@getByIdDirectPrivate(controller, \"started\"))\n" \
    "        return false;\n" \
    "    if (@readableStreamHasDefaultReader(stream) && @getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readRequests\").length > 0)\n" \
    "        return true;\n" \
    "    if (@readableStreamHasBYOBReader(stream) && @getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readIntoRequests\").length > 0)\n" \
    "        return true;\n" \
    "    if (@readableByteStreamControllerGetDesiredSize(controller) > 0)\n" \
    "        return true;\n" \
    "    return false;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerCallPullIfNeededCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerCallPullIfNeededCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerCallPullIfNeededCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerCallPullIfNeededCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerCallPullIfNeededCodeLength = 1002;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerCallPullIfNeededCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerCallPullIfNeededCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@readableByteStreamControllerShouldCallPull(controller))\n" \
    "        return;\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(controller, \"pulling\")) {\n" \
    "        @putByIdDirectPrivate(controller, \"pullAgain\", true);\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    @assert(!@getByIdDirectPrivate(controller, \"pullAgain\"));\n" \
    "    @putByIdDirectPrivate(controller, \"pulling\", true);\n" \
    "    @promiseInvokeOrNoop(@getByIdDirectPrivate(controller, \"underlyingByteSource\"), \"pull\", [controller]).@then(() => {\n" \
    "        @putByIdDirectPrivate(controller, \"pulling\", false);\n" \
    "        if (@getByIdDirectPrivate(controller, \"pullAgain\")) {\n" \
    "            @putByIdDirectPrivate(controller, \"pullAgain\", false);\n" \
    "            @readableByteStreamControllerCallPullIfNeeded(controller);\n" \
    "        }\n" \
    "    }, (error) => {\n" \
    "        if (@getByIdDirectPrivate(@getByIdDirectPrivate(controller, \"controlledReadableStream\"), \"state\") === @streamReadable)\n" \
    "            @readableByteStreamControllerError(controller, error);\n" \
    "    });\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsTransferBufferToCurrentRealmCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsTransferBufferToCurrentRealmCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsTransferBufferToCurrentRealmCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsTransferBufferToCurrentRealmCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsTransferBufferToCurrentRealmCodeLength = 90;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsTransferBufferToCurrentRealmCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsTransferBufferToCurrentRealmCode =
    "(function (buffer)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    return buffer;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerEnqueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerEnqueueCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerEnqueueCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerEnqueueCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerEnqueueCodeLength = 1423;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerEnqueueCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerEnqueueCode =
    "(function (controller, chunk)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "    @assert(!@getByIdDirectPrivate(controller, \"closeRequested\"));\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") === @streamReadable);\n" \
    "    const buffer = chunk.buffer;\n" \
    "    const byteOffset = chunk.byteOffset;\n" \
    "    const byteLength = chunk.byteLength;\n" \
    "    const transferredBuffer = @transferBufferToCurrentRealm(buffer);\n" \
    "\n" \
    "    if (@readableStreamHasDefaultReader(stream)) {\n" \
    "        if (!@getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readRequests\").length)\n" \
    "            @readableByteStreamControllerEnqueueChunk(controller, transferredBuffer, byteOffset, byteLength);\n" \
    "        else {\n" \
    "            @assert(!@getByIdDirectPrivate(controller, \"queue\").content.length);\n" \
    "            let transferredView = new @Uint8Array(transferredBuffer, byteOffset, byteLength);\n" \
    "            @readableStreamFulfillReadRequest(stream, transferredView, false);\n" \
    "        }\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    if (@readableStreamHasBYOBReader(stream)) {\n" \
    "        @readableByteStreamControllerEnqueueChunk(controller, transferredBuffer, byteOffset, byteLength);\n" \
    "        @readableByteStreamControllerProcessPullDescriptors(controller);\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    @assert(!@isReadableStreamLocked(stream));\n" \
    "    @readableByteStreamControllerEnqueueChunk(controller, transferredBuffer, byteOffset, byteLength);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerEnqueueChunkCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerEnqueueChunkCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerEnqueueChunkCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerEnqueueChunkCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerEnqueueChunkCodeLength = 310;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerEnqueueChunkCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerEnqueueChunkCode =
    "(function (controller, buffer, byteOffset, byteLength)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @arrayPush(@getByIdDirectPrivate(controller, \"queue\").content, {\n" \
    "        buffer: buffer,\n" \
    "        byteOffset: byteOffset,\n" \
    "        byteLength: byteLength\n" \
    "    });\n" \
    "    @getByIdDirectPrivate(controller, \"queue\").size += byteLength;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerRespondWithNewViewCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerRespondWithNewViewCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerRespondWithNewViewCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerRespondWithNewViewCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerRespondWithNewViewCodeLength = 609;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerRespondWithNewViewCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerRespondWithNewViewCode =
    "(function (controller, view)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@getByIdDirectPrivate(controller, \"pendingPullIntos\").length > 0);\n" \
    "\n" \
    "    let firstDescriptor = @getByIdDirectPrivate(controller, \"pendingPullIntos\")[0];\n" \
    "\n" \
    "    if (firstDescriptor.byteOffset + firstDescriptor.bytesFilled !== view.byteOffset)\n" \
    "        @throwRangeError(\"Invalid value for view.byteOffset\");\n" \
    "\n" \
    "    if (firstDescriptor.byteLength !== view.byteLength)\n" \
    "        @throwRangeError(\"Invalid value for view.byteLength\");\n" \
    "\n" \
    "    firstDescriptor.buffer = view.buffer;\n" \
    "    @readableByteStreamControllerRespondInternal(controller, view.byteLength);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerRespondCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerRespondCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerRespondCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerRespondCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerRespondCodeLength = 418;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerRespondCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerRespondCode =
    "(function (controller, bytesWritten)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    bytesWritten = @toNumber(bytesWritten);\n" \
    "\n" \
    "    if (bytesWritten !== bytesWritten || bytesWritten === @Infinity || bytesWritten < 0 )\n" \
    "        @throwRangeError(\"bytesWritten has an incorrect value\");\n" \
    "\n" \
    "    @assert(@getByIdDirectPrivate(controller, \"pendingPullIntos\").length > 0);\n" \
    "\n" \
    "    @readableByteStreamControllerRespondInternal(controller, bytesWritten);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerRespondInternalCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerRespondInternalCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerRespondInternalCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerRespondInternalCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerRespondInternalCodeLength = 708;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerRespondInternalCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerRespondInternalCode =
    "(function (controller, bytesWritten)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    let firstDescriptor = @getByIdDirectPrivate(controller, \"pendingPullIntos\")[0];\n" \
    "    let stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(stream, \"state\") === @streamClosed) {\n" \
    "        if (bytesWritten !== 0)\n" \
    "            @throwTypeError(\"bytesWritten is different from 0 even though stream is closed\");\n" \
    "        @readableByteStreamControllerRespondInClosedState(controller, firstDescriptor);\n" \
    "    } else {\n" \
    "        @assert(@getByIdDirectPrivate(stream, \"state\") === @streamReadable);\n" \
    "        @readableByteStreamControllerRespondInReadableState(controller, bytesWritten, firstDescriptor);\n" \
    "    }\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerRespondInReadableStateCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerRespondInReadableStateCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerRespondInReadableStateCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerRespondInReadableStateCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerRespondInReadableStateCodeLength = 1439;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerRespondInReadableStateCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerRespondInReadableStateCode =
    "(function (controller, bytesWritten, pullIntoDescriptor)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (pullIntoDescriptor.bytesFilled + bytesWritten > pullIntoDescriptor.byteLength)\n" \
    "        @throwRangeError(\"bytesWritten value is too great\");\n" \
    "\n" \
    "    @assert(@getByIdDirectPrivate(controller, \"pendingPullIntos\").length === 0 || @getByIdDirectPrivate(controller, \"pendingPullIntos\")[0] === pullIntoDescriptor);\n" \
    "    @readableByteStreamControllerInvalidateBYOBRequest(controller);\n" \
    "    pullIntoDescriptor.bytesFilled += bytesWritten;\n" \
    "\n" \
    "    if (pullIntoDescriptor.bytesFilled < pullIntoDescriptor.elementSize)\n" \
    "        return;\n" \
    "\n" \
    "    @readableByteStreamControllerShiftPendingDescriptor(controller);\n" \
    "    const remainderSize = pullIntoDescriptor.bytesFilled % pullIntoDescriptor.elementSize;\n" \
    "\n" \
    "    if (remainderSize > 0) {\n" \
    "        const end = pullIntoDescriptor.byteOffset + pullIntoDescriptor.bytesFilled;\n" \
    "        const remainder = @cloneArrayBuffer(pullIntoDescriptor.buffer, end - remainderSize, remainderSize);\n" \
    "        @readableByteStreamControllerEnqueueChunk(controller, remainder, 0, remainder.byteLength);\n" \
    "    }\n" \
    "\n" \
    "    pullIntoDescriptor.buffer = @transferBufferToCurrentRealm(pullIntoDescriptor.buffer);\n" \
    "    pullIntoDescriptor.bytesFilled -= remainderSize;\n" \
    "    @readableByteStreamControllerCommitDescriptor(@getByIdDirectPrivate(controller, \"controlledReadableStream\"), pullIntoDescriptor);\n" \
    "    @readableByteStreamControllerProcessPullDescriptors(controller);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerRespondInClosedStateCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerRespondInClosedStateCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerRespondInClosedStateCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerRespondInClosedStateCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerRespondInClosedStateCodeLength = 727;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerRespondInClosedStateCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerRespondInClosedStateCode =
    "(function (controller, firstDescriptor)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    firstDescriptor.buffer = @transferBufferToCurrentRealm(firstDescriptor.buffer);\n" \
    "    @assert(firstDescriptor.bytesFilled === 0);\n" \
    "\n" \
    "    if (@readableStreamHasBYOBReader(@getByIdDirectPrivate(controller, \"controlledReadableStream\"))) {\n" \
    "        while (@getByIdDirectPrivate(@getByIdDirectPrivate(@getByIdDirectPrivate(controller, \"controlledReadableStream\"), \"reader\"), \"readIntoRequests\").length > 0) {\n" \
    "            let pullIntoDescriptor = @readableByteStreamControllerShiftPendingDescriptor(controller);\n" \
    "            @readableByteStreamControllerCommitDescriptor(@getByIdDirectPrivate(controller, \"controlledReadableStream\"), pullIntoDescriptor);\n" \
    "        }\n" \
    "    }\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerProcessPullDescriptorsCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerProcessPullDescriptorsCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerProcessPullDescriptorsCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerProcessPullDescriptorsCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerProcessPullDescriptorsCodeLength = 706;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerProcessPullDescriptorsCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerProcessPullDescriptorsCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(!@getByIdDirectPrivate(controller, \"closeRequested\"));\n" \
    "    while (@getByIdDirectPrivate(controller, \"pendingPullIntos\").length > 0) {\n" \
    "        if (@getByIdDirectPrivate(controller, \"queue\").size === 0)\n" \
    "            return;\n" \
    "        let pullIntoDescriptor = @getByIdDirectPrivate(controller, \"pendingPullIntos\")[0];\n" \
    "        if (@readableByteStreamControllerFillDescriptorFromQueue(controller, pullIntoDescriptor)) {\n" \
    "            @readableByteStreamControllerShiftPendingDescriptor(controller);\n" \
    "            @readableByteStreamControllerCommitDescriptor(@getByIdDirectPrivate(controller, \"controlledReadableStream\"), pullIntoDescriptor);\n" \
    "        }\n" \
    "    }\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerFillDescriptorFromQueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerFillDescriptorFromQueueCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerFillDescriptorFromQueueCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerFillDescriptorFromQueueCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerFillDescriptorFromQueueCodeLength = 2355;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerFillDescriptorFromQueueCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerFillDescriptorFromQueueCode =
    "(function (controller, pullIntoDescriptor)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const currentAlignedBytes = pullIntoDescriptor.bytesFilled - (pullIntoDescriptor.bytesFilled % pullIntoDescriptor.elementSize);\n" \
    "    const maxBytesToCopy = @getByIdDirectPrivate(controller, \"queue\").size < pullIntoDescriptor.byteLength - pullIntoDescriptor.bytesFilled ?\n" \
    "                @getByIdDirectPrivate(controller, \"queue\").size : pullIntoDescriptor.byteLength - pullIntoDescriptor.bytesFilled;\n" \
    "    const maxBytesFilled = pullIntoDescriptor.bytesFilled + maxBytesToCopy;\n" \
    "    const maxAlignedBytes = maxBytesFilled - (maxBytesFilled % pullIntoDescriptor.elementSize);\n" \
    "    let totalBytesToCopyRemaining = maxBytesToCopy;\n" \
    "    let ready = false;\n" \
    "\n" \
    "    if (maxAlignedBytes > currentAlignedBytes) {\n" \
    "        totalBytesToCopyRemaining = maxAlignedBytes - pullIntoDescriptor.bytesFilled;\n" \
    "        ready = true;\n" \
    "    }\n" \
    "\n" \
    "    while (totalBytesToCopyRemaining > 0) {\n" \
    "        let headOfQueue = @getByIdDirectPrivate(controller, \"queue\").content[0];\n" \
    "        const bytesToCopy = totalBytesToCopyRemaining < headOfQueue.byteLength ? totalBytesToCopyRemaining : headOfQueue.byteLength;\n" \
    "        //\n" \
    "        //\n" \
    "        //\n" \
    "        const destStart = pullIntoDescriptor.byteOffset + pullIntoDescriptor.bytesFilled;\n" \
    "        //\n" \
    "        //\n" \
    "        new @Uint8Array(pullIntoDescriptor.buffer).set(new @Uint8Array(headOfQueue.buffer, headOfQueue.byteOffset, bytesToCopy), destStart);\n" \
    "\n" \
    "        if (headOfQueue.byteLength === bytesToCopy)\n" \
    "            @getByIdDirectPrivate(controller, \"queue\").content.@shift();\n" \
    "        else {\n" \
    "            headOfQueue.byteOffset += bytesToCopy;\n" \
    "            headOfQueue.byteLength -= bytesToCopy;\n" \
    "        }\n" \
    "\n" \
    "        @getByIdDirectPrivate(controller, \"queue\").size -= bytesToCopy;\n" \
    "        @assert(@getByIdDirectPrivate(controller, \"pendingPullIntos\").length === 0 || @getByIdDirectPrivate(controller, \"pendingPullIntos\")[0] === pullIntoDescriptor);\n" \
    "        @readableByteStreamControllerInvalidateBYOBRequest(controller);\n" \
    "        pullIntoDescriptor.bytesFilled += bytesToCopy;\n" \
    "        totalBytesToCopyRemaining -= bytesToCopy;\n" \
    "    }\n" \
    "\n" \
    "    if (!ready) {\n" \
    "        @assert(@getByIdDirectPrivate(controller, \"queue\").size === 0);\n" \
    "        @assert(pullIntoDescriptor.bytesFilled > 0);\n" \
    "        @assert(pullIntoDescriptor.bytesFilled < pullIntoDescriptor.elementSize);\n" \
    "    }\n" \
    "\n" \
    "    return ready;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerShiftPendingDescriptorCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerShiftPendingDescriptorCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerShiftPendingDescriptorCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerShiftPendingDescriptorCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerShiftPendingDescriptorCodeLength = 223;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerShiftPendingDescriptorCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerShiftPendingDescriptorCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    let descriptor = @getByIdDirectPrivate(controller, \"pendingPullIntos\").@shift();\n" \
    "    @readableByteStreamControllerInvalidateBYOBRequest(controller);\n" \
    "    return descriptor;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerInvalidateBYOBRequestCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerInvalidateBYOBRequestCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerInvalidateBYOBRequestCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerInvalidateBYOBRequestCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerInvalidateBYOBRequestCodeLength = 430;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerInvalidateBYOBRequestCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerInvalidateBYOBRequestCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(controller, \"byobRequest\") === @undefined)\n" \
    "        return;\n" \
    "    const byobRequest = @getByIdDirectPrivate(controller, \"byobRequest\");\n" \
    "    @putByIdDirectPrivate(byobRequest, \"associatedReadableByteStreamController\", @undefined);\n" \
    "    @putByIdDirectPrivate(byobRequest, \"view\", @undefined);\n" \
    "    @putByIdDirectPrivate(controller, \"byobRequest\", @undefined);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerCommitDescriptorCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerCommitDescriptorCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerCommitDescriptorCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerCommitDescriptorCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerCommitDescriptorCodeLength = 662;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerCommitDescriptorCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerCommitDescriptorCode =
    "(function (stream, pullIntoDescriptor)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") !== @streamErrored);\n" \
    "    let done = false;\n" \
    "    if (@getByIdDirectPrivate(stream, \"state\") === @streamClosed) {\n" \
    "        @assert(!pullIntoDescriptor.bytesFilled);\n" \
    "        done = true;\n" \
    "    }\n" \
    "    let filledView = @readableByteStreamControllerConvertDescriptor(pullIntoDescriptor);\n" \
    "    if (pullIntoDescriptor.readerType === \"default\")\n" \
    "        @readableStreamFulfillReadRequest(stream, filledView, done);\n" \
    "    else {\n" \
    "        @assert(pullIntoDescriptor.readerType === \"byob\");\n" \
    "        @readableStreamFulfillReadIntoRequest(stream, filledView, done);\n" \
    "    }\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerConvertDescriptorCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerConvertDescriptorCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerConvertDescriptorCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerConvertDescriptorCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerConvertDescriptorCodeLength = 381;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerConvertDescriptorCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerConvertDescriptorCode =
    "(function (pullIntoDescriptor)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(pullIntoDescriptor.bytesFilled <= pullIntoDescriptor.byteLength);\n" \
    "    @assert(pullIntoDescriptor.bytesFilled % pullIntoDescriptor.elementSize === 0);\n" \
    "\n" \
    "    return new pullIntoDescriptor.ctor(pullIntoDescriptor.buffer, pullIntoDescriptor.byteOffset, pullIntoDescriptor.bytesFilled / pullIntoDescriptor.elementSize);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableStreamFulfillReadIntoRequestCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableStreamFulfillReadIntoRequestCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableStreamFulfillReadIntoRequestCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableStreamFulfillReadIntoRequestCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableStreamFulfillReadIntoRequestCodeLength = 244;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableStreamFulfillReadIntoRequestCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableStreamFulfillReadIntoRequestCode =
    "(function (stream, chunk, done)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    const readIntoRequest = @getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readIntoRequests\").@shift();\n" \
    "    @fulfillPromise(readIntoRequest, { value: chunk, done: done });\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableStreamBYOBReaderReadCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableStreamBYOBReaderReadCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableStreamBYOBReaderReadCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableStreamBYOBReaderReadCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableStreamBYOBReaderReadCodeLength = 462;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableStreamBYOBReaderReadCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableStreamBYOBReaderReadCode =
    "(function (reader, view)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(reader, \"ownerReadableStream\");\n" \
    "    @assert(!!stream);\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"disturbed\", true);\n" \
    "    if (@getByIdDirectPrivate(stream, \"state\") === @streamErrored)\n" \
    "        return @Promise.@reject(@getByIdDirectPrivate(stream, \"storedError\"));\n" \
    "\n" \
    "    return @readableByteStreamControllerPullInto(@getByIdDirectPrivate(stream, \"readableStreamController\"), view);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerPullIntoCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerPullIntoCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableByteStreamControllerPullIntoCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableByteStreamControllerPullIntoCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableByteStreamControllerPullIntoCodeLength = 2216;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableByteStreamControllerPullIntoCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableByteStreamControllerPullIntoCode =
    "(function (controller, view)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "    let elementSize = 1;\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    if (view.BYTES_PER_ELEMENT !== @undefined)\n" \
    "        elementSize = view.BYTES_PER_ELEMENT;\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    const ctor = view.constructor;\n" \
    "\n" \
    "    const pullIntoDescriptor = {\n" \
    "        buffer: view.buffer,\n" \
    "        byteOffset: view.byteOffset,\n" \
    "        byteLength: view.byteLength,\n" \
    "        bytesFilled: 0,\n" \
    "        elementSize,\n" \
    "        ctor,\n" \
    "        readerType: 'byob'\n" \
    "    };\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(controller, \"pendingPullIntos\").length) {\n" \
    "        pullIntoDescriptor.buffer = @transferBufferToCurrentRealm(pullIntoDescriptor.buffer);\n" \
    "        @arrayPush(@getByIdDirectPrivate(controller, \"pendingPullIntos\"), pullIntoDescriptor);\n" \
    "        return @readableStreamAddReadIntoRequest(stream);\n" \
    "    }\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(stream, \"state\") === @streamClosed) {\n" \
    "        const emptyView = new ctor(pullIntoDescriptor.buffer, pullIntoDescriptor.byteOffset, 0);\n" \
    "        return @createFulfilledPromise({ value: emptyView, done: true });\n" \
    "    }\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(controller, \"queue\").size > 0) {\n" \
    "        if (@readableByteStreamControllerFillDescriptorFromQueue(controller, pullIntoDescriptor)) {\n" \
    "            const filledView = @readableByteStreamControllerConvertDescriptor(pullIntoDescriptor);\n" \
    "            @readableByteStreamControllerHandleQueueDrain(controller);\n" \
    "            return @createFulfilledPromise({ value: filledView, done: false });\n" \
    "        }\n" \
    "        if (@getByIdDirectPrivate(controller, \"closeRequested\")) {\n" \
    "            const e = @makeTypeError(\"Closing stream has been requested\");\n" \
    "            @readableByteStreamControllerError(controller, e);\n" \
    "            return @Promise.@reject(e);\n" \
    "        }\n" \
    "    }\n" \
    "\n" \
    "    pullIntoDescriptor.buffer = @transferBufferToCurrentRealm(pullIntoDescriptor.buffer);\n" \
    "    @arrayPush(@getByIdDirectPrivate(controller, \"pendingPullIntos\"), pullIntoDescriptor);\n" \
    "    const promise = @readableStreamAddReadIntoRequest(stream);\n" \
    "    @readableByteStreamControllerCallPullIfNeeded(controller);\n" \
    "    return promise;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamInternalsReadableStreamAddReadIntoRequestCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamInternalsReadableStreamAddReadIntoRequestCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamInternalsReadableStreamAddReadIntoRequestCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamInternalsReadableStreamAddReadIntoRequestCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamInternalsReadableStreamAddReadIntoRequestCodeLength = 437;
static constinit const JSC::Intrinsic s_readableByteStreamInternalsReadableStreamAddReadIntoRequestCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamInternalsReadableStreamAddReadIntoRequestCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStreamBYOBReader(@getByIdDirectPrivate(stream, \"reader\")));\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") === @streamReadable || @getByIdDirectPrivate(stream, \"state\") === @streamClosed);\n" \
    "\n" \
    "    const readRequest = @newPromise();\n" \
    "    @arrayPush(@getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readIntoRequests\"), readRequest);\n" \
    "\n" \
    "    return readRequest;\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = downcast<JSVMClientData>(vm.clientData); \
    return clientData->builtinFunctions().readableByteStreamInternalsBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().readableByteStreamInternalsBuiltins().codeName##Source(), std::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore
