/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXPathExpression.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "JSXPathResult.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsXPathExpressionPrototypeFunction_evaluate);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsXPathExpressionConstructor);

class JSXPathExpressionPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXPathExpressionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXPathExpressionPrototype* ptr = new (NotNull, JSC::allocateCell<JSXPathExpressionPrototype>(vm)) JSXPathExpressionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXPathExpressionPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXPathExpressionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXPathExpressionPrototype, JSXPathExpressionPrototype::Base);

using JSXPathExpressionDOMConstructor = JSDOMConstructorNotConstructable<JSXPathExpression>;

template<> const ClassInfo JSXPathExpressionDOMConstructor::s_info = { "XPathExpression"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathExpressionDOMConstructor) };

template<> JSValue JSXPathExpressionDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSXPathExpressionDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "XPathExpression"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSXPathExpression::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSXPathExpressionPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsXPathExpressionConstructor, 0 } },
    HashTableValue { "evaluate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsXPathExpressionPrototypeFunction_evaluate, 1 } },
};

const ClassInfo JSXPathExpressionPrototype::s_info = { "XPathExpression"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathExpressionPrototype) };

void JSXPathExpressionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXPathExpression::info(), JSXPathExpressionPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSXPathExpression::s_info = { "XPathExpression"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathExpression) };

JSXPathExpression::JSXPathExpression(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XPathExpression>&& impl)
    : JSDOMWrapper<XPathExpression>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, XPathExpression>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSXPathExpression::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSXPathExpressionPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSXPathExpressionPrototype::create(vm, &globalObject, structure);
}

JSObject* JSXPathExpression::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXPathExpression>(vm, globalObject);
}

JSValue JSXPathExpression::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXPathExpressionDOMConstructor, DOMConstructorID::XPathExpression>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSXPathExpression::destroy(JSC::JSCell* cell)
{
    JSXPathExpression* thisObject = static_cast<JSXPathExpression*>(cell);
    thisObject->JSXPathExpression::~JSXPathExpression();
}

JSC_DEFINE_CUSTOM_GETTER(jsXPathExpressionConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXPathExpressionPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSXPathExpression::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsXPathExpressionPrototypeFunction_evaluateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXPathExpression>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto contextNodeConversionResult = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "contextNode"_s, "XPathExpression"_s, "evaluate"_s, "Node"_s); });
    if (contextNodeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto typeConversionResult = convert<IDLUnsignedShort>(*lexicalGlobalObject, argument1.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto inResultConversionResult = convert<IDLNullable<IDLInterface<XPathResult>>>(*lexicalGlobalObject, argument2.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "inResult"_s, "XPathExpression"_s, "evaluate"_s, "XPathResult"_s); });
    if (inResultConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<XPathResult>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.evaluate(*contextNodeConversionResult.releaseReturnValue(), typeConversionResult.releaseReturnValue(), inResultConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsXPathExpressionPrototypeFunction_evaluate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSXPathExpression>::call<jsXPathExpressionPrototypeFunction_evaluateBody>(*lexicalGlobalObject, *callFrame, "evaluate");
}

JSC::GCClient::IsoSubspace* JSXPathExpression::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSXPathExpression, UseCustomHeapCellType::No>(vm, "JSXPathExpression"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForXPathExpression.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForXPathExpression = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForXPathExpression.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForXPathExpression = std::forward<decltype(space)>(space); }
    );
}

void JSXPathExpression::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXPathExpression*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSXPathExpressionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSXPathExpressionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXPathExpression = static_cast<JSXPathExpression*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsXPathExpression->protectedWrapped().ptr(), jsXPathExpression);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7XPathExpression@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15XPathExpressionE[]; }
#endif
template<std::same_as<XPathExpression> T>
static inline void verifyVTable(XPathExpression* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7XPathExpression@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15XPathExpressionE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // XPathExpression has subclasses. If XPathExpression has subclasses that get passed
        // to toJS() we currently require XPathExpression you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<XPathExpression>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<XPathExpression>(impl.ptr());
#endif
    return createWrapper<XPathExpression>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, XPathExpression& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

XPathExpression* JSXPathExpression::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXPathExpression*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
