/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_CODECS)

#include "JSWebCodecsEncodedVideoChunk.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWebCodecsEncodedVideoChunkType.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_CODECS)

template<> ConversionResult<IDLDictionary<WebCodecsEncodedVideoChunk::Init>> convertDictionary<WebCodecsEncodedVideoChunk::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WebCodecsEncodedVideoChunk::Init result;
    JSValue dataValue;
    if (isNullOrUndefined)
        dataValue = jsUndefined();
    else {
        dataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "data"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (dataValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "data"_s, "WebCodecsEncodedVideoChunkInit"_s, "(ArrayBufferView or ArrayBuffer)"_s);
        return ConversionResultException { };
    }
    auto dataConversionResult = convert<IDLAllowSharedAdaptor<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>>(lexicalGlobalObject, dataValue);
    if (dataConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.data = dataConversionResult.releaseReturnValue();
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!durationValue.isUndefined()) {
        auto durationConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, durationValue);
        if (durationConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.duration = durationConversionResult.releaseReturnValue();
    }
    JSValue timestampValue;
    if (isNullOrUndefined)
        timestampValue = jsUndefined();
    else {
        timestampValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timestamp"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!timestampValue.isUndefined()) {
        auto timestampConversionResult = convert<IDLEnforceRangeAdaptor<IDLLongLong>>(lexicalGlobalObject, timestampValue);
        if (timestampConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.timestamp = timestampConversionResult.releaseReturnValue();
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (typeValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "type"_s, "WebCodecsEncodedVideoChunkInit"_s, "WebCodecsEncodedVideoChunkType"_s);
        return ConversionResultException { };
    }
    auto typeConversionResult = convert<IDLEnumeration<WebCodecsEncodedVideoChunkType>>(lexicalGlobalObject, typeValue);
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.type = typeConversionResult.releaseReturnValue();
    return result;
}

#endif

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebCodecsEncodedVideoChunkPrototypeFunction_copyTo);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsEncodedVideoChunkConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsEncodedVideoChunk_type);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsEncodedVideoChunk_timestamp);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsEncodedVideoChunk_duration);
static JSC_DECLARE_CUSTOM_GETTER(jsWebCodecsEncodedVideoChunk_byteLength);

class JSWebCodecsEncodedVideoChunkPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebCodecsEncodedVideoChunkPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebCodecsEncodedVideoChunkPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebCodecsEncodedVideoChunkPrototype>(vm)) JSWebCodecsEncodedVideoChunkPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebCodecsEncodedVideoChunkPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebCodecsEncodedVideoChunkPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebCodecsEncodedVideoChunkPrototype, JSWebCodecsEncodedVideoChunkPrototype::Base);

using JSWebCodecsEncodedVideoChunkDOMConstructor = JSDOMConstructor<JSWebCodecsEncodedVideoChunk>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSWebCodecsEncodedVideoChunkDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSWebCodecsEncodedVideoChunkDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto initConversionResult = convert<IDLDictionary<WebCodecsEncodedVideoChunk::Init>>(*lexicalGlobalObject, argument0.value());
    if (initConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = WebCodecsEncodedVideoChunk::create(initConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<WebCodecsEncodedVideoChunk>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<WebCodecsEncodedVideoChunk>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSWebCodecsEncodedVideoChunkDOMConstructorConstruct, JSWebCodecsEncodedVideoChunkDOMConstructor::construct);

template<> const ClassInfo JSWebCodecsEncodedVideoChunkDOMConstructor::s_info = { "EncodedVideoChunk"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsEncodedVideoChunkDOMConstructor) };

template<> JSValue JSWebCodecsEncodedVideoChunkDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSWebCodecsEncodedVideoChunkDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "EncodedVideoChunk"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSWebCodecsEncodedVideoChunk::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 6> JSWebCodecsEncodedVideoChunkPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsEncodedVideoChunkConstructor, 0 } },
    HashTableValue { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsEncodedVideoChunk_type, 0 } },
    HashTableValue { "timestamp"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsEncodedVideoChunk_timestamp, 0 } },
    HashTableValue { "duration"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsEncodedVideoChunk_duration, 0 } },
    HashTableValue { "byteLength"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsWebCodecsEncodedVideoChunk_byteLength, 0 } },
    HashTableValue { "copyTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebCodecsEncodedVideoChunkPrototypeFunction_copyTo, 1 } },
};

const ClassInfo JSWebCodecsEncodedVideoChunkPrototype::s_info = { "EncodedVideoChunk"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsEncodedVideoChunkPrototype) };

void JSWebCodecsEncodedVideoChunkPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebCodecsEncodedVideoChunk::info(), JSWebCodecsEncodedVideoChunkPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebCodecsEncodedVideoChunk::s_info = { "EncodedVideoChunk"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebCodecsEncodedVideoChunk) };

JSWebCodecsEncodedVideoChunk::JSWebCodecsEncodedVideoChunk(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebCodecsEncodedVideoChunk>&& impl)
    : JSDOMWrapper<WebCodecsEncodedVideoChunk>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebCodecsEncodedVideoChunk>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebCodecsEncodedVideoChunk::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebCodecsEncodedVideoChunkPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebCodecsEncodedVideoChunkPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebCodecsEncodedVideoChunk::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebCodecsEncodedVideoChunk>(vm, globalObject);
}

JSValue JSWebCodecsEncodedVideoChunk::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebCodecsEncodedVideoChunkDOMConstructor, DOMConstructorID::WebCodecsEncodedVideoChunk>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSWebCodecsEncodedVideoChunk::destroy(JSC::JSCell* cell)
{
    JSWebCodecsEncodedVideoChunk* thisObject = static_cast<JSWebCodecsEncodedVideoChunk*>(cell);
    thisObject->JSWebCodecsEncodedVideoChunk::~JSWebCodecsEncodedVideoChunk();
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsEncodedVideoChunkConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSWebCodecsEncodedVideoChunkPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSWebCodecsEncodedVideoChunk::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsWebCodecsEncodedVideoChunk_typeGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsEncodedVideoChunk& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<WebCodecsEncodedVideoChunkType>>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsEncodedVideoChunk_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsEncodedVideoChunk>::get<jsWebCodecsEncodedVideoChunk_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsEncodedVideoChunk_timestampGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsEncodedVideoChunk& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLongLong>(lexicalGlobalObject, throwScope, impl.timestamp())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsEncodedVideoChunk_timestamp, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsEncodedVideoChunk>::get<jsWebCodecsEncodedVideoChunk_timestampGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsEncodedVideoChunk_durationGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsEncodedVideoChunk& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnsignedLongLong>>(lexicalGlobalObject, throwScope, impl.duration())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsEncodedVideoChunk_duration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsEncodedVideoChunk>::get<jsWebCodecsEncodedVideoChunk_durationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsWebCodecsEncodedVideoChunk_byteLengthGetter(JSGlobalObject& lexicalGlobalObject, JSWebCodecsEncodedVideoChunk& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.byteLength())));
}

JSC_DEFINE_CUSTOM_GETTER(jsWebCodecsEncodedVideoChunk_byteLength, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSWebCodecsEncodedVideoChunk>::get<jsWebCodecsEncodedVideoChunk_byteLengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsWebCodecsEncodedVideoChunkPrototypeFunction_copyToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebCodecsEncodedVideoChunk>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto destinationConversionResult = convert<IDLAllowSharedAdaptor<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>>(*lexicalGlobalObject, argument0.value());
    if (destinationConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.copyTo(destinationConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebCodecsEncodedVideoChunkPrototypeFunction_copyTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebCodecsEncodedVideoChunk>::call<jsWebCodecsEncodedVideoChunkPrototypeFunction_copyToBody>(*lexicalGlobalObject, *callFrame, "copyTo");
}

JSC::GCClient::IsoSubspace* JSWebCodecsEncodedVideoChunk::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebCodecsEncodedVideoChunk, UseCustomHeapCellType::No>(vm, "JSWebCodecsEncodedVideoChunk"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebCodecsEncodedVideoChunk.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebCodecsEncodedVideoChunk = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebCodecsEncodedVideoChunk.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebCodecsEncodedVideoChunk = std::forward<decltype(space)>(space); }
    );
}

void JSWebCodecsEncodedVideoChunk::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebCodecsEncodedVideoChunk*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebCodecsEncodedVideoChunkOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSWebCodecsEncodedVideoChunkOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebCodecsEncodedVideoChunk = static_cast<JSWebCodecsEncodedVideoChunk*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebCodecsEncodedVideoChunk->protectedWrapped().ptr(), jsWebCodecsEncodedVideoChunk);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebCodecsEncodedVideoChunk@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore26WebCodecsEncodedVideoChunkE[]; }
#endif
template<std::same_as<WebCodecsEncodedVideoChunk> T>
static inline void verifyVTable(WebCodecsEncodedVideoChunk* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebCodecsEncodedVideoChunk@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore26WebCodecsEncodedVideoChunkE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebCodecsEncodedVideoChunk has subclasses. If WebCodecsEncodedVideoChunk has subclasses that get passed
        // to toJS() we currently require WebCodecsEncodedVideoChunk you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebCodecsEncodedVideoChunk>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebCodecsEncodedVideoChunk>(impl.ptr());
#endif
    return createWrapper<WebCodecsEncodedVideoChunk>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebCodecsEncodedVideoChunk& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebCodecsEncodedVideoChunk* JSWebCodecsEncodedVideoChunk::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebCodecsEncodedVideoChunk*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_CODECS)
