/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileReaderSync.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsFileReaderSyncPrototypeFunction_readAsArrayBuffer);
static JSC_DECLARE_HOST_FUNCTION(jsFileReaderSyncPrototypeFunction_readAsBinaryString);
static JSC_DECLARE_HOST_FUNCTION(jsFileReaderSyncPrototypeFunction_readAsText);
static JSC_DECLARE_HOST_FUNCTION(jsFileReaderSyncPrototypeFunction_readAsDataURL);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFileReaderSyncConstructor);

class JSFileReaderSyncPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFileReaderSyncPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFileReaderSyncPrototype* ptr = new (NotNull, JSC::allocateCell<JSFileReaderSyncPrototype>(vm)) JSFileReaderSyncPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileReaderSyncPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFileReaderSyncPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileReaderSyncPrototype, JSFileReaderSyncPrototype::Base);

using JSFileReaderSyncDOMConstructor = JSDOMConstructor<JSFileReaderSync>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSFileReaderSyncDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSFileReaderSyncDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto object = FileReaderSync::create();
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<FileReaderSync>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<FileReaderSync>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSFileReaderSyncDOMConstructorConstruct, JSFileReaderSyncDOMConstructor::construct);

template<> const ClassInfo JSFileReaderSyncDOMConstructor::s_info = { "FileReaderSync"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileReaderSyncDOMConstructor) };

template<> JSValue JSFileReaderSyncDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFileReaderSyncDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FileReaderSync"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFileReaderSync::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 5> JSFileReaderSyncPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFileReaderSyncConstructor, 0 } },
    HashTableValue { "readAsArrayBuffer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileReaderSyncPrototypeFunction_readAsArrayBuffer, 1 } },
    HashTableValue { "readAsBinaryString"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileReaderSyncPrototypeFunction_readAsBinaryString, 1 } },
    HashTableValue { "readAsText"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileReaderSyncPrototypeFunction_readAsText, 1 } },
    HashTableValue { "readAsDataURL"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileReaderSyncPrototypeFunction_readAsDataURL, 1 } },
};

const ClassInfo JSFileReaderSyncPrototype::s_info = { "FileReaderSync"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileReaderSyncPrototype) };

void JSFileReaderSyncPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFileReaderSync::info(), JSFileReaderSyncPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFileReaderSync::s_info = { "FileReaderSync"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileReaderSync) };

JSFileReaderSync::JSFileReaderSync(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FileReaderSync>&& impl)
    : JSDOMWrapper<FileReaderSync>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, FileReaderSync>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSFileReaderSync::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFileReaderSyncPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSFileReaderSyncPrototype::create(vm, &globalObject, structure);
}

JSObject* JSFileReaderSync::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFileReaderSync>(vm, globalObject);
}

JSValue JSFileReaderSync::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileReaderSyncDOMConstructor, DOMConstructorID::FileReaderSync>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSFileReaderSync::destroy(JSC::JSCell* cell)
{
    JSFileReaderSync* thisObject = static_cast<JSFileReaderSync*>(cell);
    thisObject->JSFileReaderSync::~JSFileReaderSync();
}

JSC_DEFINE_CUSTOM_GETTER(jsFileReaderSyncConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileReaderSyncPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFileReaderSync::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsFileReaderSyncPrototypeFunction_readAsArrayBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileReaderSync>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto blobConversionResult = convert<IDLInterface<Blob>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "blob"_s, "FileReaderSync"_s, "readAsArrayBuffer"_s, "Blob"_s); });
    if (blobConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLArrayBuffer>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.readAsArrayBuffer(*context, *blobConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsFileReaderSyncPrototypeFunction_readAsArrayBuffer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileReaderSync>::call<jsFileReaderSyncPrototypeFunction_readAsArrayBufferBody>(*lexicalGlobalObject, *callFrame, "readAsArrayBuffer");
}

static inline JSC::EncodedJSValue jsFileReaderSyncPrototypeFunction_readAsBinaryStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileReaderSync>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto blobConversionResult = convert<IDLInterface<Blob>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "blob"_s, "FileReaderSync"_s, "readAsBinaryString"_s, "Blob"_s); });
    if (blobConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.readAsBinaryString(*context, *blobConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsFileReaderSyncPrototypeFunction_readAsBinaryString, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileReaderSync>::call<jsFileReaderSyncPrototypeFunction_readAsBinaryStringBody>(*lexicalGlobalObject, *callFrame, "readAsBinaryString");
}

static inline JSC::EncodedJSValue jsFileReaderSyncPrototypeFunction_readAsTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileReaderSync>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto blobConversionResult = convert<IDLInterface<Blob>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "blob"_s, "FileReaderSync"_s, "readAsText"_s, "Blob"_s); });
    if (blobConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto encodingConversionResult = convertOptionalWithDefault<IDLDOMString>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (encodingConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.readAsText(*context, *blobConversionResult.releaseReturnValue(), encodingConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsFileReaderSyncPrototypeFunction_readAsText, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileReaderSync>::call<jsFileReaderSyncPrototypeFunction_readAsTextBody>(*lexicalGlobalObject, *callFrame, "readAsText");
}

static inline JSC::EncodedJSValue jsFileReaderSyncPrototypeFunction_readAsDataURLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileReaderSync>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto blobConversionResult = convert<IDLInterface<Blob>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "blob"_s, "FileReaderSync"_s, "readAsDataURL"_s, "Blob"_s); });
    if (blobConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.readAsDataURL(*context, *blobConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsFileReaderSyncPrototypeFunction_readAsDataURL, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileReaderSync>::call<jsFileReaderSyncPrototypeFunction_readAsDataURLBody>(*lexicalGlobalObject, *callFrame, "readAsDataURL");
}

JSC::GCClient::IsoSubspace* JSFileReaderSync::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFileReaderSync, UseCustomHeapCellType::No>(vm, "JSFileReaderSync"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFileReaderSync.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFileReaderSync = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFileReaderSync.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFileReaderSync = std::forward<decltype(space)>(space); }
    );
}

void JSFileReaderSync::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFileReaderSync*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSFileReaderSyncOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFileReaderSyncOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFileReaderSync = static_cast<JSFileReaderSync*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFileReaderSync->protectedWrapped().ptr(), jsFileReaderSync);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FileReaderSync@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14FileReaderSyncE[]; }
#endif
template<std::same_as<FileReaderSync> T>
static inline void verifyVTable(FileReaderSync* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7FileReaderSync@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore14FileReaderSyncE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // FileReaderSync has subclasses. If FileReaderSync has subclasses that get passed
        // to toJS() we currently require FileReaderSync you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FileReaderSync>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<FileReaderSync>(impl.ptr());
#endif
    return createWrapper<FileReaderSync>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FileReaderSync& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FileReaderSync* JSFileReaderSync::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFileReaderSync*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
