// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Discontinue Windows fast launch for a Windows AMI, and clean up existing
// pre-provisioned snapshots. After you disable Windows fast launch, the AMI uses
// the standard launch process for each new instance. Amazon EC2 must remove all
// pre-provisioned snapshots before you can enable Windows fast launch again.
//
// You can only change these settings for Windows AMIs that you own or that have
// been shared with you.
func (c *Client) DisableFastLaunch(ctx context.Context, params *DisableFastLaunchInput, optFns ...func(*Options)) (*DisableFastLaunchOutput, error) {
	if params == nil {
		params = &DisableFastLaunchInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DisableFastLaunch", params, optFns, c.addOperationDisableFastLaunchMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DisableFastLaunchOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DisableFastLaunchInput struct {

	// Specify the ID of the image for which to disable Windows fast launch.
	//
	// This member is required.
	ImageId *string

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// Forces the image settings to turn off Windows fast launch for your Windows AMI.
	// This parameter overrides any errors that are encountered while cleaning up
	// resources in your account.
	Force *bool

	noSmithyDocumentSerde
}

type DisableFastLaunchOutput struct {

	// The ID of the image for which Windows fast launch was disabled.
	ImageId *string

	// The launch template that was used to launch Windows instances from
	// pre-provisioned snapshots.
	LaunchTemplate *types.FastLaunchLaunchTemplateSpecificationResponse

	// The maximum number of instances that Amazon EC2 can launch at the same time to
	// create pre-provisioned snapshots for Windows fast launch.
	MaxParallelLaunches *int32

	// The owner of the Windows AMI for which Windows fast launch was disabled.
	OwnerId *string

	// The pre-provisioning resource type that must be cleaned after turning off
	// Windows fast launch for the Windows AMI. Supported values include: snapshot .
	ResourceType types.FastLaunchResourceType

	// Parameters that were used for Windows fast launch for the Windows AMI before
	// Windows fast launch was disabled. This informs the clean-up process.
	SnapshotConfiguration *types.FastLaunchSnapshotConfigurationResponse

	// The current state of Windows fast launch for the specified Windows AMI.
	State types.FastLaunchStateCode

	// The reason that the state changed for Windows fast launch for the Windows AMI.
	StateTransitionReason *string

	// The time that the state changed for Windows fast launch for the Windows AMI.
	StateTransitionTime *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDisableFastLaunchMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDisableFastLaunch{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDisableFastLaunch{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DisableFastLaunch"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpDisableFastLaunchValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDisableFastLaunch(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDisableFastLaunch(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DisableFastLaunch",
	}
}
