const char utils_lua[] =
"local ffi = require('ffi')\n"
"local tarantool = require('tarantool')\n"
"\n"
"local utils = {}\n"
"\n"
"-- Same as type(), but returns 'number' if 'param' is\n"
"-- of type 'cdata' and represents a 64-bit integer.\n"
"local function param_type(param)\n"
"    local t = type(param)\n"
"    if t == 'cdata' and tonumber64(param) ~= nil then\n"
"        t = 'number'\n"
"    end\n"
"    return t\n"
"end\n"
"\n"
"--[[\n"
" @brief Common function to check type parameter (of function)\n"
" Calls box.error(box.error.ILLEGAL_PARAMS, ) on error\n"
" @example: check_param(user, 'user', 'string')\n"
"--]]\n"
"function utils.check_param(param, name, should_be_type)\n"
"    if param_type(param) ~= should_be_type then\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"                  name .. \" should be a \" .. should_be_type)\n"
"    end\n"
"end\n"
"\n"
"--[[\n"
" @brief Common function to check table with parameters (like options)\n"
" @param table - table with parameters\n"
" @param template - table with expected types of expected parameters\n"
"  type could be comma separated string with lua types (number, string etc),\n"
"  or 'any' if any type is allowed. Instead of this string, function, which will\n"
"  be used to check if the parameter is correct, can be used too. It should\n"
"  accept option as an argument and return either true or false + expected_type.\n"
" The function checks following:\n"
" 1)that parameters table is a table (or nil)\n"
" 2)all keys in parameters are present in template\n"
" 3)type of every parameter fits (one of) types described in template\n"
" The functions calls box.error(box.error.ILLEGAL_PARAMS, ..) on error\n"
" @example\n"
" check_param_table(options, { user = 'string',\n"
"                              port = 'string, number',\n"
"                              data = 'any',\n"
"                              addr = function(opt)\n"
"                                if not ffi.istype(addr_t, buf) then\n"
"                                    return false, \"struct addr\"\n"
"                                end\n"
"                                return true\n"
"                              end} )\n"
"--]]\n"
"function utils.check_param_table(table, template)\n"
"    if table == nil then\n"
"        return\n"
"    end\n"
"    if type(table) ~= 'table' then\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"                  \"options should be a table\")\n"
"    end\n"
"    for k,v in pairs(table) do\n"
"        if template[k] == nil then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                      \"unexpected option '\" .. k .. \"'\")\n"
"        elseif type(template[k]) == 'function' then\n"
"            local res, expected_type = template[k](v)\n"
"            if not res then\n"
"                box.error(box.error.ILLEGAL_PARAMS,\n"
"                          \"options parameter '\" .. k ..\n"
"                          \"' should be of type \" .. expected_type)\n"
"            end\n"
"        elseif template[k] == 'any' then -- luacheck: ignore\n"
"            -- any type is ok\n"
"        elseif (string.find(template[k], ',') == nil) then\n"
"            -- one type\n"
"            if param_type(v) ~= template[k] then\n"
"                box.error(box.error.ILLEGAL_PARAMS,\n"
"                          \"options parameter '\" .. k ..\n"
"                          \"' should be of type \" .. template[k])\n"
"            end\n"
"        else\n"
"            local good_types = string.gsub(template[k], ' ', '')\n"
"            local haystack = ',' .. good_types .. ','\n"
"            local needle = ',' .. param_type(v) .. ','\n"
"            if (string.find(haystack, needle) == nil) then\n"
"                box.error(box.error.ILLEGAL_PARAMS,\n"
"                          \"options parameter '\" .. k ..\n"
"                          \"' should be one of types: \" .. template[k])\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"--[[\n"
" Adds to a table key-value pairs from defaults table\n"
"  that is not present in original table.\n"
" Returns updated table.\n"
" If nil is passed instead of table, it's treated as empty table {}\n"
" For example update_param_table({ type = 'hash', temporary = true },\n"
"                                { type = 'tree', unique = true })\n"
"  will return table { type = 'hash', temporary = true, unique = true }\n"
"--]]\n"
"function utils.update_param_table(table, defaults)\n"
"    local new_table = {}\n"
"    if defaults ~= nil then\n"
"        for k,v in pairs(defaults) do\n"
"            new_table[k] = v\n"
"        end\n"
"    end\n"
"    if table ~= nil then\n"
"        for k,v in pairs(table) do\n"
"            new_table[k] = v\n"
"        end\n"
"    end\n"
"    return new_table\n"
"end\n"
"\n"
"ffi.cdef[[\n"
"void\n"
"__asan_poison_memory_region(void const volatile *addr, size_t size);\n"
"void\n"
"__asan_unpoison_memory_region(void const volatile *addr, size_t size);\n"
"int\n"
"__asan_address_is_poisoned(void const volatile *addr);\n"
"]]\n"
"\n"
"if tarantool.build.asan then\n"
"    utils.poison_memory_region = function(start, size)\n"
"        ffi.C.__asan_poison_memory_region(start, size)\n"
"    end\n"
"    utils.unpoison_memory_region = function(start, size)\n"
"        ffi.C.__asan_unpoison_memory_region(start, size)\n"
"    end\n"
"    utils.memory_region_is_poisoned = function(start, size)\n"
"        for i = 0, size - 1 do\n"
"            if ffi.C.__asan_address_is_poisoned(start + i) == 0 then\n"
"                return false\n"
"            end\n"
"        end\n"
"        return true\n"
"    end\n"
"else\n"
"    utils.poison_memory_region = function() end\n"
"    utils.unpoison_memory_region = function() end\n"
"    utils.memory_region_is_poisoned = function() return false end\n"
"end\n"
"\n"
"return utils\n"
""
;
