/* animatedListItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from animatedListItem.vala, do not modify */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <adwaita.h>
#include <float.h>
#include <math.h>
#include <gsk/gsk.h>
#include <graphene-gobject.h>
#include <string.h>
#include <gio/gio.h>

#define ANIMATED_LIST_ITEM_DEFAULT_ANIMATION_DURATION 350
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ANIMATED_LIST_ITEM (animated_list_item_get_type ())
#define ANIMATED_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATED_LIST_ITEM, AnimatedListItem))
#define ANIMATED_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATED_LIST_ITEM, AnimatedListItemClass))
#define IS_ANIMATED_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATED_LIST_ITEM))
#define IS_ANIMATED_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATED_LIST_ITEM))
#define ANIMATED_LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATED_LIST_ITEM, AnimatedListItemClass))

typedef struct _AnimatedListItem AnimatedListItem;
typedef struct _AnimatedListItemClass AnimatedListItemClass;
typedef struct _AnimatedListItemPrivate AnimatedListItemPrivate;
typedef enum  {
	ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_NONE,
	ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_SLIDE,
	ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_SLIDE_WITH
} AnimatedListItemRevealAnimationType;

#define ANIMATED_LIST_ITEM_TYPE_REVEAL_ANIMATION_TYPE (animated_list_item_reveal_animation_type_get_type ())
typedef enum  {
	ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_NONE,
	ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_SLIDE_FROM_LEFT,
	ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_SLIDE_FROM_RIGHT
} AnimatedListItemChildAnimationType;

#define ANIMATED_LIST_ITEM_TYPE_CHILD_ANIMATION_TYPE (animated_list_item_child_animation_type_get_type ())
enum  {
	ANIMATED_LIST_ITEM_0_PROPERTY,
	ANIMATED_LIST_ITEM_CHILD_PROPERTY,
	ANIMATED_LIST_ITEM_ANIMATION_DURATION_PROPERTY,
	ANIMATED_LIST_ITEM_ANIMATION_EASING_PROPERTY,
	ANIMATED_LIST_ITEM_ANIMATION_REVEAL_TYPE_PROPERTY,
	ANIMATED_LIST_ITEM_ANIMATION_CHILD_TYPE_PROPERTY,
	ANIMATED_LIST_ITEM_ANIMATION_CHILD_FADE_PROPERTY,
	ANIMATED_LIST_ITEM_DESTROYING_PROPERTY,
	ANIMATED_LIST_ITEM_NUM_PROPERTIES
};
static GParamSpec* animated_list_item_properties[ANIMATED_LIST_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gsk_transform_unref0(var) ((var == NULL) ? NULL : (var = (gsk_transform_unref (var), NULL)))
typedef void (*AnimatedListItemanimation_done) (AdwAnimation* animation, gpointer user_data);
typedef struct _Block1Data Block1Data;
typedef struct _AnimatedListItemAddedData AnimatedListItemAddedData;
typedef struct _AnimatedListItemRemovedData AnimatedListItemRemovedData;

struct _AnimatedListItem {
	GtkWidget parent_instance;
	AnimatedListItemPrivate * priv;
	GtkWidget* _child;
};

struct _AnimatedListItemClass {
	GtkWidgetClass parent_class;
};

struct _AnimatedListItemPrivate {
	gint _animation_duration;
	AdwEasing _animation_easing;
	AnimatedListItemRevealAnimationType _animation_reveal_type;
	AnimatedListItemChildAnimationType _animation_child_type;
	gboolean _animation_child_fade;
	gboolean _destroying;
	AdwCallbackAnimationTarget* target;
	AdwTimedAnimation* animation;
	gdouble animation_value;
	gulong animation_done_cb_id;
	GSourceFunc removed_cb;
	gpointer removed_cb_target;
	GSourceFunc added_cb;
	gpointer added_cb_target;
};

struct _Block1Data {
	int _ref_count_;
	AnimatedListItem* self;
	AnimatedListItemanimation_done handler;
	gpointer handler_target;
};

struct _AnimatedListItemAddedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AnimatedListItem* self;
	gboolean transition;
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	gboolean _tmp1_;
	gdouble _tmp2_;
	AdwTimedAnimation* _tmp3_;
	AdwAnimationState _tmp4_;
	AdwAnimationState _tmp5_;
	AdwTimedAnimation* _tmp6_;
	AdwTimedAnimation* _tmp7_;
	AdwTimedAnimation* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	AdwTimedAnimation* _tmp11_;
	AdwTimedAnimation* _tmp12_;
};

struct _AnimatedListItemRemovedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AnimatedListItem* self;
	gboolean transition;
	gboolean result;
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	gboolean _tmp1_;
	gdouble _tmp2_;
	AdwTimedAnimation* _tmp3_;
	AdwAnimationState _tmp4_;
	AdwAnimationState _tmp5_;
	AdwTimedAnimation* _tmp6_;
	AdwTimedAnimation* _tmp7_;
	AdwTimedAnimation* _tmp8_;
};

static gint AnimatedListItem_private_offset;
static gpointer animated_list_item_parent_class = NULL;

VALA_EXTERN GType animated_list_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatedListItem, g_object_unref)
VALA_EXTERN GType animated_list_item_reveal_animation_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType animated_list_item_child_animation_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AnimatedListItem* animated_list_item_new (void);
VALA_EXTERN AnimatedListItem* animated_list_item_construct (GType object_type);
static void animated_list_item_animation_value_cb (AnimatedListItem* self,
                                            gdouble value);
static void _animated_list_item_animation_value_cb_adw_animation_target_func (gdouble value,
                                                                       gpointer self);
VALA_EXTERN gint animated_list_item_get_animation_duration (AnimatedListItem* self);
static GtkSizeRequestMode animated_list_item_real_get_request_mode (GtkWidget* base);
static void animated_list_item_real_size_allocate (GtkWidget* base,
                                            gint width,
                                            gint height,
                                            gint baseline);
VALA_EXTERN GtkWidget* animated_list_item_get_child (AnimatedListItem* self);
VALA_EXTERN AnimatedListItemRevealAnimationType animated_list_item_get_animation_reveal_type (AnimatedListItem* self);
VALA_EXTERN AnimatedListItemChildAnimationType animated_list_item_get_animation_child_type (AnimatedListItem* self);
static void animated_list_item_real_measure (GtkWidget* base,
                                      GtkOrientation orientation,
                                      gint for_size,
                                      gint* minimum,
                                      gint* natural,
                                      gint* minimum_baseline,
                                      gint* natural_baseline);
static void animated_list_item_real_snapshot (GtkWidget* base,
                                       GtkSnapshot* snapshot);
VALA_EXTERN gboolean animated_list_item_get_animation_child_fade (AnimatedListItem* self);
static void animated_list_item_animation_done_add (AnimatedListItem* self);
static void animated_list_item_animation_done_remove (AnimatedListItem* self);
static void animated_list_item_animation_remove_done_cb (AnimatedListItem* self);
static void animated_list_item_animation_add_done_cb (AnimatedListItem* self,
                                               AnimatedListItemanimation_done handler,
                                               gpointer handler_target);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda10_ (Block1Data* _data1_,
                  AdwAnimation* a);
static void ___lambda10__adw_animation_done (AdwAnimation* _sender,
                                      gpointer self);
static void animated_list_item_added_data_free (gpointer _data);
VALA_EXTERN void animated_list_item_added (AnimatedListItem* self,
                               gboolean transition,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN void animated_list_item_added_finish (AnimatedListItem* self,
                                      GAsyncResult* _res_);
static gboolean animated_list_item_added_co (AnimatedListItemAddedData* _data_);
static void _animated_list_item_animation_done_add_animatedlistitemanimation_done (AdwAnimation* animation,
                                                                            gpointer self);
static gboolean _animated_list_item_added_co_gsource_func (gpointer self);
static void animated_list_item_removed_data_free (gpointer _data);
VALA_EXTERN void animated_list_item_removed (AnimatedListItem* self,
                                 gboolean transition,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN gboolean animated_list_item_removed_finish (AnimatedListItem* self,
                                            GAsyncResult* _res_);
static gboolean animated_list_item_removed_co (AnimatedListItemRemovedData* _data_);
static void _animated_list_item_animation_done_remove_animatedlistitemanimation_done (AdwAnimation* animation,
                                                                               gpointer self);
static gboolean _animated_list_item_removed_co_gsource_func (gpointer self);
static void animated_list_item_set_destroying (AnimatedListItem* self,
                                        gboolean value);
VALA_EXTERN void animated_list_item_set_child (AnimatedListItem* self,
                                   GtkWidget* value);
VALA_EXTERN void animated_list_item_set_animation_duration (AnimatedListItem* self,
                                                gint value);
VALA_EXTERN AdwEasing animated_list_item_get_animation_easing (AnimatedListItem* self);
VALA_EXTERN void animated_list_item_set_animation_easing (AnimatedListItem* self,
                                              AdwEasing value);
VALA_EXTERN void animated_list_item_set_animation_reveal_type (AnimatedListItem* self,
                                                   AnimatedListItemRevealAnimationType value);
VALA_EXTERN void animated_list_item_set_animation_child_type (AnimatedListItem* self,
                                                  AnimatedListItemChildAnimationType value);
VALA_EXTERN void animated_list_item_set_animation_child_fade (AnimatedListItem* self,
                                                  gboolean value);
VALA_EXTERN gboolean animated_list_item_get_destroying (AnimatedListItem* self);
static void animated_list_item_finalize (GObject * obj);
static GType animated_list_item_get_type_once (void);
static void _vala_animated_list_item_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_animated_list_item_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
animated_list_item_get_instance_private (AnimatedListItem* self)
{
	return G_STRUCT_MEMBER_P (self, AnimatedListItem_private_offset);
}

 G_GNUC_NO_INLINE static GType
animated_list_item_reveal_animation_type_get_type_once (void)
{
	static const GEnumValue values[] = {{ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_NONE, "ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_NONE", "none"}, {ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_SLIDE, "ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_SLIDE", "slide"}, {ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_SLIDE_WITH, "ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_SLIDE_WITH", "slide-with"}, {0, NULL, NULL}};
	GType animated_list_item_reveal_animation_type_type_id;
	animated_list_item_reveal_animation_type_type_id = g_enum_register_static ("AnimatedListItemRevealAnimationType", values);
	return animated_list_item_reveal_animation_type_type_id;
}

GType
animated_list_item_reveal_animation_type_get_type (void)
{
	static gsize animated_list_item_reveal_animation_type_type_id__once = 0;
	if (g_once_init_enter (&animated_list_item_reveal_animation_type_type_id__once)) {
		GType animated_list_item_reveal_animation_type_type_id;
		animated_list_item_reveal_animation_type_type_id = animated_list_item_reveal_animation_type_get_type_once ();
		g_once_init_leave (&animated_list_item_reveal_animation_type_type_id__once, animated_list_item_reveal_animation_type_type_id);
	}
	return animated_list_item_reveal_animation_type_type_id__once;
}

 G_GNUC_NO_INLINE static GType
animated_list_item_child_animation_type_get_type_once (void)
{
	static const GEnumValue values[] = {{ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_NONE, "ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_NONE", "none"}, {ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_SLIDE_FROM_LEFT, "ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_SLIDE_FROM_LEFT", "slide-from-left"}, {ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_SLIDE_FROM_RIGHT, "ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_SLIDE_FROM_RIGHT", "slide-from-right"}, {0, NULL, NULL}};
	GType animated_list_item_child_animation_type_type_id;
	animated_list_item_child_animation_type_type_id = g_enum_register_static ("AnimatedListItemChildAnimationType", values);
	return animated_list_item_child_animation_type_type_id;
}

GType
animated_list_item_child_animation_type_get_type (void)
{
	static gsize animated_list_item_child_animation_type_type_id__once = 0;
	if (g_once_init_enter (&animated_list_item_child_animation_type_type_id__once)) {
		GType animated_list_item_child_animation_type_type_id;
		animated_list_item_child_animation_type_type_id = animated_list_item_child_animation_type_get_type_once ();
		g_once_init_leave (&animated_list_item_child_animation_type_type_id__once, animated_list_item_child_animation_type_type_id);
	}
	return animated_list_item_child_animation_type_type_id__once;
}

static void
_animated_list_item_animation_value_cb_adw_animation_target_func (gdouble value,
                                                                  gpointer self)
{
	animated_list_item_animation_value_cb ((AnimatedListItem*) self, value);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

AnimatedListItem*
animated_list_item_construct (GType object_type)
{
	AnimatedListItem * self = NULL;
	AdwCallbackAnimationTarget* _tmp0_;
	gint _tmp1_;
	AdwCallbackAnimationTarget* _tmp2_;
	AdwAnimationTarget* _tmp3_;
	AdwTimedAnimation* _tmp4_;
	AdwTimedAnimation* _tmp5_;
	self = (AnimatedListItem*) g_object_new (object_type, "css-name", "animatedlistitem", "accessible-role", GTK_ACCESSIBLE_ROLE_LIST_ITEM, "overflow", GTK_OVERFLOW_HIDDEN, "animation-duration", ANIMATED_LIST_ITEM_DEFAULT_ANIMATION_DURATION, "animation-easing", ADW_EASE_OUT_QUINT, "animation-reveal-type", ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_SLIDE, "animation-child-type", ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_SLIDE_FROM_RIGHT, "animation-child-fade", TRUE, NULL);
	_tmp0_ = (AdwCallbackAnimationTarget*) adw_callback_animation_target_new (_animated_list_item_animation_value_cb_adw_animation_target_func, g_object_ref (self), g_object_unref);
	if (_tmp0_) {
		g_object_set_data ((GObject *) _tmp0_, "vala-creation-function", "AnimatedListItem.new");
	}
	_g_object_unref0 (self->priv->target);
	self->priv->target = _tmp0_;
	_tmp1_ = self->priv->_animation_duration;
	_tmp2_ = self->priv->target;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, adw_animation_target_get_type (), AdwAnimationTarget));
	_tmp4_ = (AdwTimedAnimation*) adw_timed_animation_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), 0.0, 1.0, (guint) _tmp1_, _tmp3_);
	if (_tmp4_) {
		g_object_set_data ((GObject *) _tmp4_, "vala-creation-function", "AnimatedListItem.new");
	}
	_g_object_unref0 (self->priv->animation);
	self->priv->animation = _tmp4_;
	_tmp5_ = self->priv->animation;
	g_object_bind_property_with_closures (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "animation-easing", G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_OBJECT, GObject), "easing", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return self;
}

AnimatedListItem*
animated_list_item_new (void)
{
	return animated_list_item_construct (TYPE_ANIMATED_LIST_ITEM);
}

static GtkSizeRequestMode
animated_list_item_real_get_request_mode (GtkWidget* base)
{
	AnimatedListItem * self;
	GtkSizeRequestMode result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST_ITEM, AnimatedListItem);
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}

static gpointer
_gsk_transform_ref0 (gpointer self)
{
	return self ? gsk_transform_ref (self) : NULL;
}

static void
animated_list_item_real_size_allocate (GtkWidget* base,
                                       gint width,
                                       gint height,
                                       gint baseline)
{
	AnimatedListItem * self;
	gboolean _tmp0_ = FALSE;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	gint child_width = 0;
	gint child_height = 0;
	GskTransform* transform = NULL;
	GskTransform* _tmp11_;
	AnimatedListItemRevealAnimationType _tmp12_;
	AnimatedListItemChildAnimationType _tmp17_;
	GtkWidget* _tmp26_;
	GtkWidget* _tmp27_;
	GskTransform* _tmp28_;
	GskTransform* _tmp29_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST_ITEM, AnimatedListItem);
	_tmp1_ = animated_list_item_get_child (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		_tmp3_ = animated_list_item_get_child (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !gtk_widget_should_layout (_tmp4_);
	}
	if (_tmp0_) {
		return;
	}
	if (self->priv->animation_value >= ((gdouble) 1)) {
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		_tmp5_ = animated_list_item_get_child (self);
		_tmp6_ = _tmp5_;
		gtk_widget_allocate (_tmp6_, width, height, baseline, NULL);
	} else {
		if (self->priv->animation_value < ((gdouble) 0)) {
			return;
		}
	}
	child_width = width;
	child_height = height;
	if (self->priv->animation_value < 1.0) {
		gint min = 0;
		gint nat = 0;
		GtkWidget* _tmp7_;
		GtkWidget* _tmp8_;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp7_ = animated_list_item_get_child (self);
		_tmp8_ = _tmp7_;
		gtk_widget_measure (_tmp8_, GTK_ORIENTATION_VERTICAL, width, &_tmp9_, &_tmp10_, NULL, NULL);
		min = _tmp9_;
		nat = _tmp10_;
		if (ceil (nat * self->priv->animation_value) == ((gdouble) height)) {
			child_height = nat;
		} else {
			if (ceil (min * self->priv->animation_value) == ((gdouble) height)) {
				child_height = min;
			} else {
				gdouble d = 0.0;
				d = floor (height / self->priv->animation_value);
				child_height = MIN ((gint) d, G_MAXINT);
			}
		}
	}
	_tmp11_ = gsk_transform_new ();
	transform = _tmp11_;
	_tmp12_ = self->priv->_animation_reveal_type;
	switch (_tmp12_) {
		case ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_SLIDE_WITH:
		{
			GskTransform* _tmp13_;
			graphene_point3d_t _tmp14_ = {0};
			graphene_point3d_t _tmp15_;
			GskTransform* _tmp16_;
			_tmp13_ = transform;
			transform = NULL;
			memset (&_tmp14_, 0, sizeof (graphene_point3d_t));
			_tmp15_ = *graphene_point3d_init (&_tmp14_, (gfloat) 0, (gfloat) (height - child_height), (gfloat) 0);
			_tmp16_ = gsk_transform_translate_3d (_tmp13_, &_tmp15_);
			_gsk_transform_unref0 (transform);
			transform = _tmp16_;
			break;
		}
		case ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_SLIDE:
		case ANIMATED_LIST_ITEM_REVEAL_ANIMATION_TYPE_NONE:
		{
			break;
		}
		default:
		break;
	}
	_tmp17_ = self->priv->_animation_child_type;
	switch (_tmp17_) {
		case ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_SLIDE_FROM_RIGHT:
		{
			GskTransform* _tmp18_;
			graphene_point3d_t _tmp19_ = {0};
			graphene_point3d_t _tmp20_;
			GskTransform* _tmp21_;
			_tmp18_ = transform;
			transform = NULL;
			memset (&_tmp19_, 0, sizeof (graphene_point3d_t));
			_tmp20_ = *graphene_point3d_init (&_tmp19_, child_width * ((gfloat) (1 - self->priv->animation_value)), (gfloat) 0, (gfloat) 0);
			_tmp21_ = gsk_transform_translate_3d (_tmp18_, &_tmp20_);
			_gsk_transform_unref0 (transform);
			transform = _tmp21_;
			break;
		}
		case ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_SLIDE_FROM_LEFT:
		{
			GskTransform* _tmp22_;
			graphene_point3d_t _tmp23_ = {0};
			graphene_point3d_t _tmp24_;
			GskTransform* _tmp25_;
			_tmp22_ = transform;
			transform = NULL;
			memset (&_tmp23_, 0, sizeof (graphene_point3d_t));
			_tmp24_ = *graphene_point3d_init (&_tmp23_, (-child_width) * ((gfloat) (1 - self->priv->animation_value)), (gfloat) 0, (gfloat) 0);
			_tmp25_ = gsk_transform_translate_3d (_tmp22_, &_tmp24_);
			_gsk_transform_unref0 (transform);
			transform = _tmp25_;
			break;
		}
		case ANIMATED_LIST_ITEM_CHILD_ANIMATION_TYPE_NONE:
		{
			break;
		}
		default:
		break;
	}
	_tmp26_ = animated_list_item_get_child (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = transform;
	_tmp29_ = _gsk_transform_ref0 (_tmp28_);
	gtk_widget_allocate (_tmp27_, child_width, child_height, -1, _tmp29_);
	_gsk_transform_unref0 (transform);
}

static void
animated_list_item_real_measure (GtkWidget* base,
                                 GtkOrientation orientation,
                                 gint for_size,
                                 gint* minimum,
                                 gint* natural,
                                 gint* minimum_baseline,
                                 gint* natural_baseline)
{
	AnimatedListItem * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint _vala_minimum_baseline = 0;
	gint _vala_natural_baseline = 0;
	gboolean _tmp0_ = FALSE;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST_ITEM, AnimatedListItem);
	_vala_minimum = 0;
	_vala_natural = 0;
	_vala_minimum_baseline = -1;
	_vala_natural_baseline = -1;
	_tmp1_ = animated_list_item_get_child (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		_tmp3_ = animated_list_item_get_child (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !gtk_widget_should_layout (_tmp4_);
	}
	if (_tmp0_) {
		if (minimum) {
			*minimum = _vala_minimum;
		}
		if (natural) {
			*natural = _vala_natural;
		}
		if (minimum_baseline) {
			*minimum_baseline = _vala_minimum_baseline;
		}
		if (natural_baseline) {
			*natural_baseline = _vala_natural_baseline;
		}
		return;
	}
	_tmp5_ = animated_list_item_get_child (self);
	_tmp6_ = _tmp5_;
	gtk_widget_measure (_tmp6_, orientation, for_size, &_tmp7_, &_tmp8_, NULL, NULL);
	_vala_minimum = _tmp7_;
	_vala_natural = _tmp8_;
	switch (orientation) {
		case GTK_ORIENTATION_HORIZONTAL:
		{
			break;
		}
		case GTK_ORIENTATION_VERTICAL:
		{
			_vala_minimum = (gint) ceil (_vala_minimum * self->priv->animation_value);
			_vala_natural = (gint) ceil (_vala_natural * self->priv->animation_value);
			break;
		}
		default:
		break;
	}
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
	if (minimum_baseline) {
		*minimum_baseline = _vala_minimum_baseline;
	}
	if (natural_baseline) {
		*natural_baseline = _vala_natural_baseline;
	}
}

static void
animated_list_item_real_snapshot (GtkWidget* base,
                                  GtkSnapshot* snapshot)
{
	AnimatedListItem * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	gboolean _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	gboolean _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ANIMATED_LIST_ITEM, AnimatedListItem);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (snapshot, gtk_snapshot_get_type ()));
	_tmp0_ = animated_list_item_get_child (self);
	_tmp1_ = _tmp0_;
	if (!gtk_widget_should_layout (_tmp1_)) {
		return;
	}
	_tmp2_ = self->priv->_animation_child_fade;
	if (_tmp2_) {
		gtk_snapshot_push_opacity (snapshot, self->priv->animation_value);
	}
	_tmp3_ = animated_list_item_get_child (self);
	_tmp4_ = _tmp3_;
	gtk_widget_snapshot_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp4_, snapshot);
	_tmp5_ = self->priv->_animation_child_fade;
	if (_tmp5_) {
		gtk_snapshot_pop (snapshot);
	}
}

static void
animated_list_item_animation_value_cb (AnimatedListItem* self,
                                       gdouble value)
{
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (self));
	self->priv->animation_value = value;
	gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static void
animated_list_item_animation_done_add (AnimatedListItem* self)
{
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (self));
	_tmp0_ = self->priv->added_cb;
	_tmp0__target = self->priv->added_cb_target;
	if (_tmp0_ != NULL) {
		GSourceFunc _tmp1_;
		gpointer _tmp1__target;
		_tmp1_ = self->priv->added_cb;
		_tmp1__target = self->priv->added_cb_target;
		_tmp1_ (_tmp1__target);
		self->priv->added_cb = NULL;
		self->priv->added_cb_target = NULL;
	}
}

static void
animated_list_item_animation_done_remove (AnimatedListItem* self)
{
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (self));
	gtk_widget_unparent (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp0_ = self->priv->removed_cb;
	_tmp0__target = self->priv->removed_cb_target;
	if (_tmp0_ != NULL) {
		GSourceFunc _tmp1_;
		gpointer _tmp1__target;
		_tmp1_ = self->priv->removed_cb;
		_tmp1__target = self->priv->removed_cb_target;
		_tmp1_ (_tmp1__target);
		self->priv->removed_cb = NULL;
		self->priv->removed_cb_target = NULL;
	}
}

static void
animated_list_item_animation_remove_done_cb (AnimatedListItem* self)
{
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (self));
	if (self->priv->animation_done_cb_id != ((gulong) 0)) {
		AdwTimedAnimation* _tmp0_;
		_tmp0_ = self->priv->animation;
		g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_OBJECT, GObject), self->priv->animation_done_cb_id);
		self->priv->animation_done_cb_id = (gulong) 0;
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		AnimatedListItem* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda10_ (Block1Data* _data1_,
             AdwAnimation* a)
{
	AnimatedListItem* self;
	self = _data1_->self;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (a, adw_animation_get_type ()));
	_data1_->handler (a, _data1_->handler_target);
}

static void
___lambda10__adw_animation_done (AdwAnimation* _sender,
                                 gpointer self)
{
	__lambda10_ (self, _sender);
}

static void
animated_list_item_animation_add_done_cb (AnimatedListItem* self,
                                          AnimatedListItemanimation_done handler,
                                          gpointer handler_target)
{
	Block1Data* _data1_;
	AdwTimedAnimation* _tmp0_;
	gulong _tmp1_;
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (self));
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->handler = handler;
	_data1_->handler_target = handler_target;
	animated_list_item_animation_remove_done_cb (self);
	_tmp0_ = self->priv->animation;
	_tmp1_ = g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, adw_animation_get_type (), AdwAnimation), "done", (GCallback) ___lambda10__adw_animation_done, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	self->priv->animation_done_cb_id = _tmp1_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
animated_list_item_added_data_free (gpointer _data)
{
	AnimatedListItemAddedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AnimatedListItemAddedData, _data_);
}

void
animated_list_item_added (AnimatedListItem* self,
                          gboolean transition,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	AnimatedListItemAddedData* _data_;
	AnimatedListItem* _tmp0_;
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (self));
	_data_ = g_slice_new0 (AnimatedListItemAddedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, animated_list_item_added_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->transition = transition;
	animated_list_item_added_co (_data_);
}

void
animated_list_item_added_finish (AnimatedListItem* self,
                                 GAsyncResult* _res_)
{
	AnimatedListItemAddedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_animated_list_item_animation_done_add_animatedlistitemanimation_done (AdwAnimation* animation,
                                                                       gpointer self)
{
	animated_list_item_animation_done_add ((AnimatedListItem*) self);
}

static gboolean
_animated_list_item_added_co_gsource_func (gpointer self)
{
	gboolean result;
	result = animated_list_item_added_co (self);
	return result;
}

static gboolean
animated_list_item_added_co (AnimatedListItemAddedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->added_cb;
	_data_->_tmp0__target = _data_->self->priv->added_cb_target;
	if (_data_->_tmp0_ != NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	animated_list_item_animation_remove_done_cb (_data_->self);
	if (gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget))) {
		_data_->_tmp1_ = _data_->transition;
	} else {
		_data_->_tmp1_ = FALSE;
	}
	if (_data_->_tmp1_) {
		animated_list_item_animation_add_done_cb (_data_->self, _animated_list_item_animation_done_add_animatedlistitemanimation_done, _data_->self);
		_data_->self->priv->added_cb = _animated_list_item_added_co_gsource_func;
		_data_->self->priv->added_cb_target = _data_;
		_data_->_tmp3_ = _data_->self->priv->animation;
		_data_->_tmp4_ = adw_animation_get_state (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, adw_animation_get_type (), AdwAnimation));
		_data_->_tmp5_ = _data_->_tmp4_;
		if (_data_->_tmp5_ == ADW_ANIMATION_PLAYING) {
			_data_->_tmp2_ = _data_->self->priv->animation_value;
		} else {
			_data_->_tmp2_ = 0.0;
		}
		_data_->_tmp6_ = _data_->self->priv->animation;
		adw_timed_animation_set_value_from (_data_->_tmp6_, _data_->_tmp2_);
		_data_->_tmp7_ = _data_->self->priv->animation;
		_data_->_tmp8_ = _data_->self->priv->animation;
		_data_->_tmp9_ = adw_animation_get_value (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, adw_animation_get_type (), AdwAnimation));
		_data_->_tmp10_ = _data_->_tmp9_;
		adw_timed_animation_set_value_from (_data_->_tmp7_, _data_->_tmp10_);
		_data_->_tmp11_ = _data_->self->priv->animation;
		adw_timed_animation_set_value_to (_data_->_tmp11_, 1.0);
		_data_->_tmp12_ = _data_->self->priv->animation;
		adw_animation_play (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, adw_animation_get_type (), AdwAnimation));
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	} else {
		_data_->self->priv->animation_value = 1.0;
		animated_list_item_animation_done_add (_data_->self);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
animated_list_item_removed_data_free (gpointer _data)
{
	AnimatedListItemRemovedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AnimatedListItemRemovedData, _data_);
}

void
animated_list_item_removed (AnimatedListItem* self,
                            gboolean transition,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	AnimatedListItemRemovedData* _data_;
	AnimatedListItem* _tmp0_;
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (self));
	_data_ = g_slice_new0 (AnimatedListItemRemovedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, animated_list_item_removed_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->transition = transition;
	animated_list_item_removed_co (_data_);
}

gboolean
animated_list_item_removed_finish (AnimatedListItem* self,
                                   GAsyncResult* _res_)
{
	gboolean result;
	AnimatedListItemRemovedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
_animated_list_item_animation_done_remove_animatedlistitemanimation_done (AdwAnimation* animation,
                                                                          gpointer self)
{
	animated_list_item_animation_done_remove ((AnimatedListItem*) self);
}

static gboolean
_animated_list_item_removed_co_gsource_func (gpointer self)
{
	gboolean result;
	result = animated_list_item_removed_co (self);
	return result;
}

static gboolean
animated_list_item_removed_co (AnimatedListItemRemovedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->removed_cb;
	_data_->_tmp0__target = _data_->self->priv->removed_cb_target;
	if (_data_->_tmp0_ != NULL) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	animated_list_item_animation_remove_done_cb (_data_->self);
	gtk_widget_set_can_focus (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget), FALSE);
	gtk_widget_set_can_target (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget), FALSE);
	if (gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget))) {
		_data_->_tmp1_ = _data_->transition;
	} else {
		_data_->_tmp1_ = FALSE;
	}
	if (_data_->_tmp1_) {
		animated_list_item_animation_add_done_cb (_data_->self, _animated_list_item_animation_done_remove_animatedlistitemanimation_done, _data_->self);
		_data_->self->priv->removed_cb = _animated_list_item_removed_co_gsource_func;
		_data_->self->priv->removed_cb_target = _data_;
		_data_->_tmp3_ = _data_->self->priv->animation;
		_data_->_tmp4_ = adw_animation_get_state (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, adw_animation_get_type (), AdwAnimation));
		_data_->_tmp5_ = _data_->_tmp4_;
		if (_data_->_tmp5_ == ADW_ANIMATION_PLAYING) {
			_data_->_tmp2_ = _data_->self->priv->animation_value;
		} else {
			_data_->_tmp2_ = 1.0;
		}
		_data_->_tmp6_ = _data_->self->priv->animation;
		adw_timed_animation_set_value_from (_data_->_tmp6_, _data_->_tmp2_);
		_data_->_tmp7_ = _data_->self->priv->animation;
		adw_timed_animation_set_value_to (_data_->_tmp7_, 0.0);
		animated_list_item_set_destroying (_data_->self, TRUE);
		_data_->_tmp8_ = _data_->self->priv->animation;
		adw_animation_play (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, adw_animation_get_type (), AdwAnimation));
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	} else {
		_data_->self->priv->animation_value = 0.0;
		animated_list_item_animation_done_remove (_data_->self);
	}
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GtkWidget*
animated_list_item_get_child (AnimatedListItem* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (IS_ANIMATED_LIST_ITEM (self), NULL);
	_tmp0_ = self->_child;
	result = _tmp0_;
	return result;
}

void
animated_list_item_set_child (AnimatedListItem* self,
                              GtkWidget* value)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (self));
	self->_child = value;
	_tmp0_ = self->_child;
	if (_tmp0_ != NULL) {
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp1_ = self->_child;
		gtk_widget_unparent (_tmp1_);
		_tmp2_ = self->_child;
		gtk_widget_set_parent (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
	g_object_notify_by_pspec ((GObject *) self, animated_list_item_properties[ANIMATED_LIST_ITEM_CHILD_PROPERTY]);
}

gint
animated_list_item_get_animation_duration (AnimatedListItem* self)
{
	gint result;
	g_return_val_if_fail (IS_ANIMATED_LIST_ITEM (self), 0);
	result = self->priv->_animation_duration;
	return result;
}

void
animated_list_item_set_animation_duration (AnimatedListItem* self,
                                           gint value)
{
	gint old_value;
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (self));
	old_value = animated_list_item_get_animation_duration (self);
	if (old_value != value) {
		self->priv->_animation_duration = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_item_properties[ANIMATED_LIST_ITEM_ANIMATION_DURATION_PROPERTY]);
	}
}

AdwEasing
animated_list_item_get_animation_easing (AnimatedListItem* self)
{
	AdwEasing result;
	g_return_val_if_fail (IS_ANIMATED_LIST_ITEM (self), 0);
	result = self->priv->_animation_easing;
	return result;
}

void
animated_list_item_set_animation_easing (AnimatedListItem* self,
                                         AdwEasing value)
{
	AdwEasing old_value;
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (self));
	old_value = animated_list_item_get_animation_easing (self);
	if (old_value != value) {
		self->priv->_animation_easing = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_item_properties[ANIMATED_LIST_ITEM_ANIMATION_EASING_PROPERTY]);
	}
}

AnimatedListItemRevealAnimationType
animated_list_item_get_animation_reveal_type (AnimatedListItem* self)
{
	AnimatedListItemRevealAnimationType result;
	g_return_val_if_fail (IS_ANIMATED_LIST_ITEM (self), 0);
	result = self->priv->_animation_reveal_type;
	return result;
}

void
animated_list_item_set_animation_reveal_type (AnimatedListItem* self,
                                              AnimatedListItemRevealAnimationType value)
{
	AnimatedListItemRevealAnimationType old_value;
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (self));
	old_value = animated_list_item_get_animation_reveal_type (self);
	if (old_value != value) {
		self->priv->_animation_reveal_type = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_item_properties[ANIMATED_LIST_ITEM_ANIMATION_REVEAL_TYPE_PROPERTY]);
	}
}

AnimatedListItemChildAnimationType
animated_list_item_get_animation_child_type (AnimatedListItem* self)
{
	AnimatedListItemChildAnimationType result;
	g_return_val_if_fail (IS_ANIMATED_LIST_ITEM (self), 0);
	result = self->priv->_animation_child_type;
	return result;
}

void
animated_list_item_set_animation_child_type (AnimatedListItem* self,
                                             AnimatedListItemChildAnimationType value)
{
	AnimatedListItemChildAnimationType old_value;
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (self));
	old_value = animated_list_item_get_animation_child_type (self);
	if (old_value != value) {
		self->priv->_animation_child_type = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_item_properties[ANIMATED_LIST_ITEM_ANIMATION_CHILD_TYPE_PROPERTY]);
	}
}

gboolean
animated_list_item_get_animation_child_fade (AnimatedListItem* self)
{
	gboolean result;
	g_return_val_if_fail (IS_ANIMATED_LIST_ITEM (self), FALSE);
	result = self->priv->_animation_child_fade;
	return result;
}

void
animated_list_item_set_animation_child_fade (AnimatedListItem* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (self));
	old_value = animated_list_item_get_animation_child_fade (self);
	if (old_value != value) {
		self->priv->_animation_child_fade = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_item_properties[ANIMATED_LIST_ITEM_ANIMATION_CHILD_FADE_PROPERTY]);
	}
}

gboolean
animated_list_item_get_destroying (AnimatedListItem* self)
{
	gboolean result;
	g_return_val_if_fail (IS_ANIMATED_LIST_ITEM (self), FALSE);
	result = self->priv->_destroying;
	return result;
}

static void
animated_list_item_set_destroying (AnimatedListItem* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (IS_ANIMATED_LIST_ITEM (self));
	old_value = animated_list_item_get_destroying (self);
	if (old_value != value) {
		self->priv->_destroying = value;
		g_object_notify_by_pspec ((GObject *) self, animated_list_item_properties[ANIMATED_LIST_ITEM_DESTROYING_PROPERTY]);
	}
}

static void
animated_list_item_class_init (AnimatedListItemClass * klass,
                               gpointer klass_data)
{
	animated_list_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AnimatedListItem_private_offset);
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkWidget*)) animated_list_item_real_get_request_mode;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) animated_list_item_real_size_allocate;
	((GtkWidgetClass *) klass)->measure = (void (*) (GtkWidget*, GtkOrientation, gint, gint*, gint*, gint*, gint*)) animated_list_item_real_measure;
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) animated_list_item_real_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_animated_list_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_animated_list_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = animated_list_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_ITEM_CHILD_PROPERTY, animated_list_item_properties[ANIMATED_LIST_ITEM_CHILD_PROPERTY] = g_param_spec_object ("child", "child", "child", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_ITEM_ANIMATION_DURATION_PROPERTY, animated_list_item_properties[ANIMATED_LIST_ITEM_ANIMATION_DURATION_PROPERTY] = g_param_spec_int ("animation-duration", "animation-duration", "animation-duration", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_ITEM_ANIMATION_EASING_PROPERTY, animated_list_item_properties[ANIMATED_LIST_ITEM_ANIMATION_EASING_PROPERTY] = g_param_spec_enum ("animation-easing", "animation-easing", "animation-easing", adw_easing_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_ITEM_ANIMATION_REVEAL_TYPE_PROPERTY, animated_list_item_properties[ANIMATED_LIST_ITEM_ANIMATION_REVEAL_TYPE_PROPERTY] = g_param_spec_enum ("animation-reveal-type", "animation-reveal-type", "animation-reveal-type", ANIMATED_LIST_ITEM_TYPE_REVEAL_ANIMATION_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_ITEM_ANIMATION_CHILD_TYPE_PROPERTY, animated_list_item_properties[ANIMATED_LIST_ITEM_ANIMATION_CHILD_TYPE_PROPERTY] = g_param_spec_enum ("animation-child-type", "animation-child-type", "animation-child-type", ANIMATED_LIST_ITEM_TYPE_CHILD_ANIMATION_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_ITEM_ANIMATION_CHILD_FADE_PROPERTY, animated_list_item_properties[ANIMATED_LIST_ITEM_ANIMATION_CHILD_FADE_PROPERTY] = g_param_spec_boolean ("animation-child-fade", "animation-child-fade", "animation-child-fade", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATED_LIST_ITEM_DESTROYING_PROPERTY, animated_list_item_properties[ANIMATED_LIST_ITEM_DESTROYING_PROPERTY] = g_param_spec_boolean ("destroying", "destroying", "destroying", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
animated_list_item_instance_init (AnimatedListItem * self,
                                  gpointer klass)
{
	self->priv = animated_list_item_get_instance_private (self);
	self->_child = NULL;
	self->priv->_destroying = FALSE;
	self->priv->animation_value = 0.0;
	self->priv->animation_done_cb_id = (gulong) 0;
	self->priv->removed_cb = NULL;
	self->priv->removed_cb_target = NULL;
	self->priv->added_cb = NULL;
	self->priv->added_cb_target = NULL;
}

static void
animated_list_item_finalize (GObject * obj)
{
	AnimatedListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ANIMATED_LIST_ITEM, AnimatedListItem);
	_g_object_unref0 (self->priv->target);
	_g_object_unref0 (self->priv->animation);
	G_OBJECT_CLASS (animated_list_item_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
animated_list_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AnimatedListItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) animated_list_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AnimatedListItem), 0, (GInstanceInitFunc) animated_list_item_instance_init, NULL };
	GType animated_list_item_type_id;
	animated_list_item_type_id = g_type_register_static (gtk_widget_get_type (), "AnimatedListItem", &g_define_type_info, 0);
	AnimatedListItem_private_offset = g_type_add_instance_private (animated_list_item_type_id, sizeof (AnimatedListItemPrivate));
	return animated_list_item_type_id;
}

GType
animated_list_item_get_type (void)
{
	static gsize animated_list_item_type_id__once = 0;
	if (g_once_init_enter (&animated_list_item_type_id__once)) {
		GType animated_list_item_type_id;
		animated_list_item_type_id = animated_list_item_get_type_once ();
		g_once_init_leave (&animated_list_item_type_id__once, animated_list_item_type_id);
	}
	return animated_list_item_type_id__once;
}

static void
_vala_animated_list_item_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	AnimatedListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ANIMATED_LIST_ITEM, AnimatedListItem);
	switch (property_id) {
		case ANIMATED_LIST_ITEM_CHILD_PROPERTY:
		g_value_set_object (value, animated_list_item_get_child (self));
		break;
		case ANIMATED_LIST_ITEM_ANIMATION_DURATION_PROPERTY:
		g_value_set_int (value, animated_list_item_get_animation_duration (self));
		break;
		case ANIMATED_LIST_ITEM_ANIMATION_EASING_PROPERTY:
		g_value_set_enum (value, animated_list_item_get_animation_easing (self));
		break;
		case ANIMATED_LIST_ITEM_ANIMATION_REVEAL_TYPE_PROPERTY:
		g_value_set_enum (value, animated_list_item_get_animation_reveal_type (self));
		break;
		case ANIMATED_LIST_ITEM_ANIMATION_CHILD_TYPE_PROPERTY:
		g_value_set_enum (value, animated_list_item_get_animation_child_type (self));
		break;
		case ANIMATED_LIST_ITEM_ANIMATION_CHILD_FADE_PROPERTY:
		g_value_set_boolean (value, animated_list_item_get_animation_child_fade (self));
		break;
		case ANIMATED_LIST_ITEM_DESTROYING_PROPERTY:
		g_value_set_boolean (value, animated_list_item_get_destroying (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_animated_list_item_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	AnimatedListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ANIMATED_LIST_ITEM, AnimatedListItem);
	switch (property_id) {
		case ANIMATED_LIST_ITEM_CHILD_PROPERTY:
		animated_list_item_set_child (self, g_value_get_object (value));
		break;
		case ANIMATED_LIST_ITEM_ANIMATION_DURATION_PROPERTY:
		animated_list_item_set_animation_duration (self, g_value_get_int (value));
		break;
		case ANIMATED_LIST_ITEM_ANIMATION_EASING_PROPERTY:
		animated_list_item_set_animation_easing (self, g_value_get_enum (value));
		break;
		case ANIMATED_LIST_ITEM_ANIMATION_REVEAL_TYPE_PROPERTY:
		animated_list_item_set_animation_reveal_type (self, g_value_get_enum (value));
		break;
		case ANIMATED_LIST_ITEM_ANIMATION_CHILD_TYPE_PROPERTY:
		animated_list_item_set_animation_child_type (self, g_value_get_enum (value));
		break;
		case ANIMATED_LIST_ITEM_ANIMATION_CHILD_FADE_PROPERTY:
		animated_list_item_set_animation_child_fade (self, g_value_get_boolean (value));
		break;
		case ANIMATED_LIST_ITEM_DESTROYING_PROPERTY:
		animated_list_item_set_destroying (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

