
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_mgmt.h"
#include "bin/default/librpc/gen_ndr/ndr_mgmt_c.h"

/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
static PyTypeObject ndr_syntax_id_p_Type;
static PyTypeObject rpc_if_id_vector_t_Type;
static PyTypeObject mgmt_statistics_Type;
static PyTypeObject mgmt_InterfaceType;
static PyTypeObject mgmt_inq_if_ids_Type;
static PyTypeObject mgmt_inq_stats_Type;
static PyTypeObject mgmt_is_server_listening_Type;
static PyTypeObject mgmt_stop_server_listening_Type;
static PyTypeObject mgmt_inq_princ_name_Type;

static PyTypeObject *ndr_syntax_id_Type;
static PyTypeObject *BaseObject_Type;
static PyTypeObject *ClientConnection_Type;

static PyObject *py_ndr_syntax_id_p_get_id(PyObject *obj, void *closure)
{
	struct ndr_syntax_id_p *object = pytalloc_get_ptr(obj);
	PyObject *py_id;
	if (object->id == NULL) {
		Py_RETURN_NONE;
	}
	if (object->id == NULL) {
		py_id = Py_None;
		Py_INCREF(py_id);
	} else {
		py_id = pytalloc_reference_ex(ndr_syntax_id_Type, object->id, object->id);
	}
	return py_id;
}

static int py_ndr_syntax_id_p_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ndr_syntax_id_p *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->id));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->id");
		return -1;
	}
	if (value == Py_None) {
		object->id = NULL;
	} else {
		object->id = NULL;
		PY_CHECK_TYPE(ndr_syntax_id_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->id = (struct ndr_syntax_id *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyGetSetDef py_ndr_syntax_id_p_getsetters[] = {
	{
		.name = discard_const_p(char, "id"),
		.get = py_ndr_syntax_id_p_get_id,
		.set = py_ndr_syntax_id_p_set_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type ndr_syntax_id")
	},
	{ .name = NULL }
};

static PyObject *py_ndr_syntax_id_p_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ndr_syntax_id_p, type);
}


static PyTypeObject ndr_syntax_id_p_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mgmt.ndr_syntax_id_p",
	.tp_getset = py_ndr_syntax_id_p_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ndr_syntax_id_p_new,
};


static PyObject *py_rpc_if_id_vector_t_get_count(PyObject *obj, void *closure)
{
	struct rpc_if_id_vector_t *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_rpc_if_id_vector_t_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct rpc_if_id_vector_t *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_rpc_if_id_vector_t_get_if_id(PyObject *obj, void *closure)
{
	struct rpc_if_id_vector_t *object = pytalloc_get_ptr(obj);
	PyObject *py_if_id;
	py_if_id = PyList_New(object->count);
	if (py_if_id == NULL) {
		return NULL;
	}
	{
		int if_id_cntr_0;
		for (if_id_cntr_0 = 0; if_id_cntr_0 < (object->count); if_id_cntr_0++) {
			PyObject *py_if_id_0;
			py_if_id_0 = pytalloc_reference_ex(&ndr_syntax_id_p_Type, object->if_id, &(object->if_id)[if_id_cntr_0]);
			PyList_SetItem(py_if_id, if_id_cntr_0, py_if_id_0);
		}
	}
	return py_if_id;
}

static int py_rpc_if_id_vector_t_set_if_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct rpc_if_id_vector_t *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->if_id");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int if_id_cntr_0;
		object->if_id = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->if_id, PyList_GET_SIZE(value));
		if (!object->if_id) { return -1; }
		talloc_set_name_const(object->if_id, "ARRAY: object->if_id");
		for (if_id_cntr_0 = 0; if_id_cntr_0 < PyList_GET_SIZE(value); if_id_cntr_0++) {
			if (PyList_GET_ITEM(value, if_id_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->if_id)[if_id_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&ndr_syntax_id_p_Type, PyList_GET_ITEM(value, if_id_cntr_0), return -1;);
			if (talloc_reference(object->if_id, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, if_id_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->if_id)[if_id_cntr_0] = *(struct ndr_syntax_id_p *)pytalloc_get_ptr(PyList_GET_ITEM(value, if_id_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_rpc_if_id_vector_t_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_rpc_if_id_vector_t_get_count,
		.set = py_rpc_if_id_vector_t_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "if_id"),
		.get = py_rpc_if_id_vector_t_get_if_id,
		.set = py_rpc_if_id_vector_t_set_if_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type ndr_syntax_id_p")
	},
	{ .name = NULL }
};

static PyObject *py_rpc_if_id_vector_t_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct rpc_if_id_vector_t, type);
}


static PyTypeObject rpc_if_id_vector_t_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mgmt.rpc_if_id_vector_t",
	.tp_getset = py_rpc_if_id_vector_t_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_rpc_if_id_vector_t_new,
};


static PyObject *py_mgmt_statistics_get_count(PyObject *obj, void *closure)
{
	struct mgmt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_mgmt_statistics_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mgmt_statistics_get_statistics(PyObject *obj, void *closure)
{
	struct mgmt_statistics *object = pytalloc_get_ptr(obj);
	PyObject *py_statistics;
	py_statistics = PyList_New(object->count);
	if (py_statistics == NULL) {
		return NULL;
	}
	{
		int statistics_cntr_0;
		for (statistics_cntr_0 = 0; statistics_cntr_0 < (object->count); statistics_cntr_0++) {
			PyObject *py_statistics_0;
			py_statistics_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->statistics)[statistics_cntr_0]));
			PyList_SetItem(py_statistics, statistics_cntr_0, py_statistics_0);
		}
	}
	return py_statistics;
}

static int py_mgmt_statistics_set_statistics(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_statistics *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->statistics");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int statistics_cntr_0;
		object->statistics = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->statistics, PyList_GET_SIZE(value));
		if (!object->statistics) { return -1; }
		talloc_set_name_const(object->statistics, "ARRAY: object->statistics");
		for (statistics_cntr_0 = 0; statistics_cntr_0 < PyList_GET_SIZE(value); statistics_cntr_0++) {
			if (PyList_GET_ITEM(value, statistics_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->statistics)[statistics_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->statistics)[statistics_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, statistics_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, statistics_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->statistics)[statistics_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_mgmt_statistics_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_mgmt_statistics_get_count,
		.set = py_mgmt_statistics_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "statistics"),
		.get = py_mgmt_statistics_get_statistics,
		.set = py_mgmt_statistics_set_statistics,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_mgmt_statistics_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct mgmt_statistics, type);
}


static PyTypeObject mgmt_statistics_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mgmt.statistics",
	.tp_getset = py_mgmt_statistics_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_mgmt_statistics_new,
};



static PyObject *py_mgmt_inq_if_ids_out_get_if_id_vector(PyObject *obj, void *closure)
{
	struct mgmt_inq_if_ids *object = pytalloc_get_ptr(obj);
	PyObject *py_if_id_vector;
	if (object->out.if_id_vector == NULL) {
		Py_RETURN_NONE;
	}
	if (*object->out.if_id_vector == NULL) {
		py_if_id_vector = Py_None;
		Py_INCREF(py_if_id_vector);
	} else {
		py_if_id_vector = pytalloc_reference_ex(&rpc_if_id_vector_t_Type, *object->out.if_id_vector, *object->out.if_id_vector);
	}
	return py_if_id_vector;
}

static int py_mgmt_inq_if_ids_out_set_if_id_vector(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_inq_if_ids *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.if_id_vector));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.if_id_vector");
		return -1;
	}
	object->out.if_id_vector = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.if_id_vector);
	if (object->out.if_id_vector == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	if (value == Py_None) {
		*object->out.if_id_vector = NULL;
	} else {
		*object->out.if_id_vector = NULL;
		PY_CHECK_TYPE(&rpc_if_id_vector_t_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		*object->out.if_id_vector = (struct rpc_if_id_vector_t *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_mgmt_inq_if_ids_get_result(PyObject *obj, void *closure)
{
	struct mgmt_inq_if_ids *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_mgmt_inq_if_ids_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_inq_if_ids *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_mgmt_inq_if_ids_getsetters[] = {
	{
		.name = discard_const_p(char, "out_if_id_vector"),
		.get = py_mgmt_inq_if_ids_out_get_if_id_vector,
		.set = py_mgmt_inq_if_ids_out_set_if_id_vector,
		.doc = discard_const_p(char, "PIDL-generated element of base type rpc_if_id_vector_t")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_mgmt_inq_if_ids_get_result,
		.set = py_mgmt_inq_if_ids_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_mgmt_inq_if_ids_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct mgmt_inq_if_ids, type);
	struct mgmt_inq_if_ids *_self = (struct mgmt_inq_if_ids *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	/* a pointer to a NULL pointer */
	_self->out.if_id_vector = talloc_zero(mem_ctx, struct rpc_if_id_vector_t *);
	return self;
}

static PyObject *py_mgmt_inq_if_ids_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(0);
}

static PyObject *py_mgmt_inq_if_ids_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_inq_if_ids *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_mgmt.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_inq_if_ids_ndr_pack");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[0];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_mgmt_inq_if_ids_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mgmt_inq_if_ids_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_mgmt_inq_if_ids_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mgmt_inq_if_ids_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_mgmt_inq_if_ids_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_inq_if_ids *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_mgmt.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_inq_if_ids_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[0];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_mgmt_inq_if_ids_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mgmt_inq_if_ids_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mgmt_inq_if_ids_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mgmt_inq_if_ids_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mgmt_inq_if_ids_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_inq_if_ids *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_mgmt.num_calls < 1) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_inq_if_ids_ndr_print");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[0];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_mgmt_inq_if_ids_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_mgmt_inq_if_ids_ndr_print(py_obj, args, kwargs, "mgmt_inq_if_ids_in", NDR_IN);
}

static PyObject *py_mgmt_inq_if_ids_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_mgmt_inq_if_ids_ndr_print(py_obj, args, kwargs, "mgmt_inq_if_ids_out", NDR_OUT);
}

static PyMethodDef py_mgmt_inq_if_ids_methods[] = {
	{ "opnum", (PyCFunction)py_mgmt_inq_if_ids_ndr_opnum, METH_NOARGS|METH_CLASS,
		"mgmt.inq_if_ids.opnum() -> 0 (0x00) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_if_ids_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_if_ids_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_if_ids_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_if_ids_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_if_ids_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_if_ids_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject mgmt_inq_if_ids_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mgmt.inq_if_ids",
	.tp_getset = py_mgmt_inq_if_ids_getsetters,
	.tp_methods = py_mgmt_inq_if_ids_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_mgmt_inq_if_ids_new,
};

static bool pack_py_mgmt_inq_if_ids_args_in(PyObject *args, PyObject *kwargs, struct mgmt_inq_if_ids *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":mgmt_inq_if_ids", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_mgmt_inq_if_ids_args_out(struct mgmt_inq_if_ids *r, bool raise_result_exception)
{
	PyObject *py_if_id_vector = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (*r->out.if_id_vector == NULL) {
		py_if_id_vector = Py_None;
		Py_INCREF(py_if_id_vector);
	} else {
		py_if_id_vector = pytalloc_reference_ex(&rpc_if_id_vector_t_Type, *r->out.if_id_vector, *r->out.if_id_vector);
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_if_id_vector);
	}
	if (result_size == 1) {
		result = py_if_id_vector;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_mgmt_inq_stats_in_get_max_count(PyObject *obj, void *closure)
{
	struct mgmt_inq_stats *object = pytalloc_get_ptr(obj);
	PyObject *py_max_count;
	py_max_count = PyLong_FromUnsignedLongLong((uint32_t)(object->in.max_count));
	return py_max_count;
}

static int py_mgmt_inq_stats_in_set_max_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_inq_stats *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.max_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.max_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.max_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mgmt_inq_stats_in_get_unknown(PyObject *obj, void *closure)
{
	struct mgmt_inq_stats *object = pytalloc_get_ptr(obj);
	PyObject *py_unknown;
	py_unknown = PyLong_FromUnsignedLongLong((uint32_t)(object->in.unknown));
	return py_unknown;
}

static int py_mgmt_inq_stats_in_set_unknown(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_inq_stats *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.unknown");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.unknown));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.unknown = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mgmt_inq_stats_out_get_statistics(PyObject *obj, void *closure)
{
	struct mgmt_inq_stats *object = pytalloc_get_ptr(obj);
	PyObject *py_statistics;
	if (object->out.statistics == NULL) {
		Py_RETURN_NONE;
	}
	py_statistics = pytalloc_reference_ex(&mgmt_statistics_Type, object->out.statistics, object->out.statistics);
	return py_statistics;
}

static int py_mgmt_inq_stats_out_set_statistics(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_inq_stats *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.statistics));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.statistics");
		return -1;
	}
	object->out.statistics = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.statistics);
	if (object->out.statistics == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	PY_CHECK_TYPE(&mgmt_statistics_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->out.statistics = (struct mgmt_statistics *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_mgmt_inq_stats_get_result(PyObject *obj, void *closure)
{
	struct mgmt_inq_stats *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_mgmt_inq_stats_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_inq_stats *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_mgmt_inq_stats_getsetters[] = {
	{
		.name = discard_const_p(char, "in_max_count"),
		.get = py_mgmt_inq_stats_in_get_max_count,
		.set = py_mgmt_inq_stats_in_set_max_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_unknown"),
		.get = py_mgmt_inq_stats_in_get_unknown,
		.set = py_mgmt_inq_stats_in_set_unknown,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_statistics"),
		.get = py_mgmt_inq_stats_out_get_statistics,
		.set = py_mgmt_inq_stats_out_set_statistics,
		.doc = discard_const_p(char, "PIDL-generated element of base type mgmt_statistics")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_mgmt_inq_stats_get_result,
		.set = py_mgmt_inq_stats_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_mgmt_inq_stats_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct mgmt_inq_stats, type);
	struct mgmt_inq_stats *_self = (struct mgmt_inq_stats *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.statistics = talloc_zero(mem_ctx, struct mgmt_statistics);
	return self;
}

static PyObject *py_mgmt_inq_stats_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(1);
}

static PyObject *py_mgmt_inq_stats_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_inq_stats *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_mgmt.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_inq_stats_ndr_pack");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[1];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_mgmt_inq_stats_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mgmt_inq_stats_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_mgmt_inq_stats_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mgmt_inq_stats_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_mgmt_inq_stats_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_inq_stats *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_mgmt.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_inq_stats_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[1];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_mgmt_inq_stats_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mgmt_inq_stats_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mgmt_inq_stats_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mgmt_inq_stats_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mgmt_inq_stats_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_inq_stats *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_mgmt.num_calls < 2) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_inq_stats_ndr_print");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[1];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_mgmt_inq_stats_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_mgmt_inq_stats_ndr_print(py_obj, args, kwargs, "mgmt_inq_stats_in", NDR_IN);
}

static PyObject *py_mgmt_inq_stats_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_mgmt_inq_stats_ndr_print(py_obj, args, kwargs, "mgmt_inq_stats_out", NDR_OUT);
}

static PyMethodDef py_mgmt_inq_stats_methods[] = {
	{ "opnum", (PyCFunction)py_mgmt_inq_stats_ndr_opnum, METH_NOARGS|METH_CLASS,
		"mgmt.inq_stats.opnum() -> 1 (0x01) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_stats_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_stats_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_stats_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_stats_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_stats_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_stats_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject mgmt_inq_stats_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mgmt.inq_stats",
	.tp_getset = py_mgmt_inq_stats_getsetters,
	.tp_methods = py_mgmt_inq_stats_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_mgmt_inq_stats_new,
};

static bool pack_py_mgmt_inq_stats_args_in(PyObject *args, PyObject *kwargs, struct mgmt_inq_stats *r)
{
	PyObject *py_max_count;
	PyObject *py_unknown;
	const char *kwnames[] = {
		"max_count", "unknown", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:mgmt_inq_stats", discard_const_p(char *, kwnames), &py_max_count, &py_unknown)) {
		return false;
	}

	if (py_max_count == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.max_count");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.max_count));
		if (PyLong_Check(py_max_count)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_max_count);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.max_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_unknown == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.unknown");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.unknown));
		if (PyLong_Check(py_unknown)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_unknown);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.unknown = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_mgmt_inq_stats_args_out(struct mgmt_inq_stats *r, bool raise_result_exception)
{
	PyObject *py_statistics = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	py_statistics = pytalloc_reference_ex(&mgmt_statistics_Type, r->out.statistics, r->out.statistics);
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_statistics);
	}
	if (result_size == 1) {
		result = py_statistics;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}


static PyObject *py_mgmt_is_server_listening_out_get_status(PyObject *obj, void *closure)
{
	struct mgmt_is_server_listening *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	if (object->out.status == NULL) {
		Py_RETURN_NONE;
	}
	py_status = PyLong_FromUnsignedLongLong((uint32_t)(*object->out.status));
	return py_status;
}

static int py_mgmt_is_server_listening_out_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_is_server_listening *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->out.status));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.status");
		return -1;
	}
	object->out.status = talloc_ptrtype(pytalloc_get_mem_ctx(py_obj), object->out.status);
	if (object->out.status == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(*object->out.status));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			*object->out.status = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mgmt_is_server_listening_get_result(PyObject *obj, void *closure)
{
	struct mgmt_is_server_listening *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyLong_FromUnsignedLongLong((uint32_t)(object->out.result));
	return py_result;
}

static int py_mgmt_is_server_listening_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_is_server_listening *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->out.result));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->out.result = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_mgmt_is_server_listening_getsetters[] = {
	{
		.name = discard_const_p(char, "out_status"),
		.get = py_mgmt_is_server_listening_out_get_status,
		.set = py_mgmt_is_server_listening_out_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_mgmt_is_server_listening_get_result,
		.set = py_mgmt_is_server_listening_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_mgmt_is_server_listening_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct mgmt_is_server_listening, type);
	struct mgmt_is_server_listening *_self = (struct mgmt_is_server_listening *)pytalloc_get_ptr(self);
	TALLOC_CTX *mem_ctx = pytalloc_get_mem_ctx(self);
	_self->out.status = talloc_zero(mem_ctx, uint32_t);
	return self;
}

static PyObject *py_mgmt_is_server_listening_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(2);
}

static PyObject *py_mgmt_is_server_listening_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_is_server_listening *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_mgmt.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_is_server_listening_ndr_pack");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[2];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_mgmt_is_server_listening_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mgmt_is_server_listening_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_mgmt_is_server_listening_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mgmt_is_server_listening_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_mgmt_is_server_listening_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_is_server_listening *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_mgmt.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_is_server_listening_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[2];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_mgmt_is_server_listening_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mgmt_is_server_listening_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mgmt_is_server_listening_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mgmt_is_server_listening_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mgmt_is_server_listening_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_is_server_listening *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_mgmt.num_calls < 3) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_is_server_listening_ndr_print");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[2];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_mgmt_is_server_listening_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_mgmt_is_server_listening_ndr_print(py_obj, args, kwargs, "mgmt_is_server_listening_in", NDR_IN);
}

static PyObject *py_mgmt_is_server_listening_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_mgmt_is_server_listening_ndr_print(py_obj, args, kwargs, "mgmt_is_server_listening_out", NDR_OUT);
}

static PyMethodDef py_mgmt_is_server_listening_methods[] = {
	{ "opnum", (PyCFunction)py_mgmt_is_server_listening_ndr_opnum, METH_NOARGS|METH_CLASS,
		"mgmt.is_server_listening.opnum() -> 2 (0x02) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_is_server_listening_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_is_server_listening_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_is_server_listening_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_is_server_listening_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_is_server_listening_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_is_server_listening_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject mgmt_is_server_listening_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mgmt.is_server_listening",
	.tp_getset = py_mgmt_is_server_listening_getsetters,
	.tp_methods = py_mgmt_is_server_listening_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_mgmt_is_server_listening_new,
};

static bool pack_py_mgmt_is_server_listening_args_in(PyObject *args, PyObject *kwargs, struct mgmt_is_server_listening *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":mgmt_is_server_listening", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_mgmt_is_server_listening_args_out(struct mgmt_is_server_listening *r, bool raise_result_exception)
{
	PyObject *py_status = NULL;
	PyObject *result = NULL;

	result = PyTuple_New(2);
	if (result == NULL) {
		return NULL;
	}

	py_status = PyLong_FromUnsignedLongLong((uint32_t)(*r->out.status));
	PyTuple_SetItem(result, 0, py_status);

	PyTuple_SetItem(result, 1, PyLong_FromUnsignedLongLong((uint32_t)(r->out.result)));

	return result;
}


static PyObject *py_mgmt_stop_server_listening_get_result(PyObject *obj, void *closure)
{
	struct mgmt_stop_server_listening *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_mgmt_stop_server_listening_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_stop_server_listening *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_mgmt_stop_server_listening_getsetters[] = {
	{
		.name = discard_const_p(char, "result"),
		.get = py_mgmt_stop_server_listening_get_result,
		.set = py_mgmt_stop_server_listening_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_mgmt_stop_server_listening_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct mgmt_stop_server_listening, type);
	return self;
}

static PyObject *py_mgmt_stop_server_listening_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(3);
}

static PyObject *py_mgmt_stop_server_listening_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_stop_server_listening *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_mgmt.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_stop_server_listening_ndr_pack");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[3];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_mgmt_stop_server_listening_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mgmt_stop_server_listening_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_mgmt_stop_server_listening_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mgmt_stop_server_listening_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_mgmt_stop_server_listening_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_stop_server_listening *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_mgmt.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_stop_server_listening_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[3];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_mgmt_stop_server_listening_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mgmt_stop_server_listening_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mgmt_stop_server_listening_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mgmt_stop_server_listening_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mgmt_stop_server_listening_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_stop_server_listening *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_mgmt.num_calls < 4) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_stop_server_listening_ndr_print");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[3];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_mgmt_stop_server_listening_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_mgmt_stop_server_listening_ndr_print(py_obj, args, kwargs, "mgmt_stop_server_listening_in", NDR_IN);
}

static PyObject *py_mgmt_stop_server_listening_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_mgmt_stop_server_listening_ndr_print(py_obj, args, kwargs, "mgmt_stop_server_listening_out", NDR_OUT);
}

static PyMethodDef py_mgmt_stop_server_listening_methods[] = {
	{ "opnum", (PyCFunction)py_mgmt_stop_server_listening_ndr_opnum, METH_NOARGS|METH_CLASS,
		"mgmt.stop_server_listening.opnum() -> 3 (0x03) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_stop_server_listening_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_stop_server_listening_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_stop_server_listening_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_stop_server_listening_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_stop_server_listening_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_stop_server_listening_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject mgmt_stop_server_listening_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mgmt.stop_server_listening",
	.tp_getset = py_mgmt_stop_server_listening_getsetters,
	.tp_methods = py_mgmt_stop_server_listening_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_mgmt_stop_server_listening_new,
};

static bool pack_py_mgmt_stop_server_listening_args_in(PyObject *args, PyObject *kwargs, struct mgmt_stop_server_listening *r)
{
	const char *kwnames[] = {
		NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, ":mgmt_stop_server_listening", discard_const_p(char *, kwnames))) {
		return false;
	}

	return true;
}

static PyObject *unpack_py_mgmt_stop_server_listening_args_out(struct mgmt_stop_server_listening *r, bool raise_result_exception)
{
	PyObject *result = NULL;
	size_t result_size = 0;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (!raise_result_exception) {
		result = PyErr_FromWERROR(r->out.result);
	}

	if (result_size == 0) {
		result = Py_None;
		Py_INCREF(result);
	}

	return result;
}


static PyObject *py_mgmt_inq_princ_name_in_get_authn_proto(PyObject *obj, void *closure)
{
	struct mgmt_inq_princ_name *object = pytalloc_get_ptr(obj);
	PyObject *py_authn_proto;
	py_authn_proto = PyLong_FromUnsignedLongLong((uint32_t)(object->in.authn_proto));
	return py_authn_proto;
}

static int py_mgmt_inq_princ_name_in_set_authn_proto(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_inq_princ_name *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.authn_proto");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.authn_proto));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.authn_proto = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mgmt_inq_princ_name_in_get_princ_name_size(PyObject *obj, void *closure)
{
	struct mgmt_inq_princ_name *object = pytalloc_get_ptr(obj);
	PyObject *py_princ_name_size;
	py_princ_name_size = PyLong_FromUnsignedLongLong((uint32_t)(object->in.princ_name_size));
	return py_princ_name_size;
}

static int py_mgmt_inq_princ_name_in_set_princ_name_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_inq_princ_name *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->in.princ_name_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->in.princ_name_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->in.princ_name_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_mgmt_inq_princ_name_out_get_princ_name(PyObject *obj, void *closure)
{
	struct mgmt_inq_princ_name *object = pytalloc_get_ptr(obj);
	PyObject *py_princ_name;
	if (object->out.princ_name == NULL) {
		py_princ_name = Py_None;
		Py_INCREF(py_princ_name);
	} else {
		py_princ_name = PyUnicode_Decode(object->out.princ_name, strlen(object->out.princ_name), "utf-8", "ignore");
	}
	return py_princ_name;
}

static int py_mgmt_inq_princ_name_out_set_princ_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_inq_princ_name *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.princ_name");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->out.princ_name = talloc_str;
	}
	return 0;
}

static PyObject *py_mgmt_inq_princ_name_get_result(PyObject *obj, void *closure)
{
	struct mgmt_inq_princ_name *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyErr_FromWERROR(object->out.result);
	return py_result;
}

static int py_mgmt_inq_princ_name_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct mgmt_inq_princ_name *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->out.result");
		return -1;
	}
	object->out.result = W_ERROR(PyLong_AsLong(value));
	return 0;
}

static PyGetSetDef py_mgmt_inq_princ_name_getsetters[] = {
	{
		.name = discard_const_p(char, "in_authn_proto"),
		.get = py_mgmt_inq_princ_name_in_get_authn_proto,
		.set = py_mgmt_inq_princ_name_in_set_authn_proto,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "in_princ_name_size"),
		.get = py_mgmt_inq_princ_name_in_get_princ_name_size,
		.set = py_mgmt_inq_princ_name_in_set_princ_name_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "out_princ_name"),
		.get = py_mgmt_inq_princ_name_out_get_princ_name,
		.set = py_mgmt_inq_princ_name_out_set_princ_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "result"),
		.get = py_mgmt_inq_princ_name_get_result,
		.set = py_mgmt_inq_princ_name_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of type WERROR")
	},
	{ .name = NULL }
};

static PyObject *py_mgmt_inq_princ_name_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyObject *self = pytalloc_new(struct mgmt_inq_princ_name, type);
	return self;
}

static PyObject *py_mgmt_inq_princ_name_ndr_opnum(PyTypeObject *type, PyObject *Py_UNUSED(ignored))
{


	return PyLong_FromLong(4);
}

static PyObject *py_mgmt_inq_princ_name_ndr_pack(PyObject *py_obj, ndr_flags_type ndr_inout_flags, libndr_flags ndr_push_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_inq_princ_name *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	struct ndr_push *push = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;

	if (ndr_table_mgmt.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_inq_princ_name_ndr_pack");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[4];

	push = ndr_push_init_ctx(pytalloc_get_mem_ctx(py_obj));
	if (push == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	push->flags |= ndr_push_flags;

	err = call->ndr_push(push, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(push);
		PyErr_SetNdrError(err);
		return NULL;
	}
	blob = ndr_push_blob(push);
	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(push);
	return ret;
}

static PyObject *py_mgmt_inq_princ_name_ndr_pack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_in__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mgmt_inq_princ_name_ndr_pack(py_obj, NDR_IN, ndr_push_flags);
}

static PyObject *py_mgmt_inq_princ_name_ndr_pack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "bigendian", "ndr64", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_push_flags = 0;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "|OO:__ndr_pack_out__",
		discard_const_p(char *, kwnames),
		&bigendian_obj,
		&ndr64_obj)) {
		return NULL;
	}

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_push_flags |= LIBNDR_FLAG_NDR64;
	}

	return py_mgmt_inq_princ_name_ndr_pack(py_obj, NDR_OUT, ndr_push_flags);
}

static PyObject *py_mgmt_inq_princ_name_ndr_unpack(PyObject *py_obj, const DATA_BLOB *blob, ndr_flags_type ndr_inout_flags, libndr_flags ndr_pull_flags, bool allow_remaining)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_inq_princ_name *object = pytalloc_get_ptr(py_obj);
	struct ndr_pull *pull = NULL;
	enum ndr_err_code err;

	if (ndr_table_mgmt.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_inq_princ_name_ndr_unpack");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[4];

	pull = ndr_pull_init_blob(blob, object);
	if (pull == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}

	pull->flags |= ndr_pull_flags;

	err = call->ndr_pull(pull, ndr_inout_flags, object);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(pull);
		PyErr_SetNdrError(err);
		return NULL;
	}
	if (!allow_remaining) {
		uint32_t highest_ofs;

		if (pull->offset > pull->relative_highest_offset) {
			highest_ofs = pull->offset;
		} else {
			highest_ofs = pull->relative_highest_offset;
		}
		if (highest_ofs < pull->data_size) {
			err = ndr_pull_error(pull, NDR_ERR_UNREAD_BYTES,
				"not all bytes consumed ofs[%u] size[%u]",
				highest_ofs, pull->data_size);
			TALLOC_FREE(pull);
			PyErr_SetNdrError(err);
			return NULL;
		}
	}

	TALLOC_FREE(pull);
	Py_RETURN_NONE;
}

static PyObject *py_mgmt_inq_princ_name_ndr_unpack_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_in__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mgmt_inq_princ_name_ndr_unpack(py_obj, &blob, NDR_IN, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mgmt_inq_princ_name_ndr_unpack_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	DATA_BLOB blob;
	Py_ssize_t blob_length = 0;
	const char * const kwnames[] = { "data_blob", "bigendian", "ndr64", "allow_remaining", NULL };
	PyObject *bigendian_obj = NULL;
	PyObject *ndr64_obj = NULL;
	libndr_flags ndr_pull_flags = LIBNDR_FLAG_REF_ALLOC;
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|OOO:__ndr_unpack_out__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&bigendian_obj,
		&ndr64_obj,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (bigendian_obj && PyObject_IsTrue(bigendian_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_BIGENDIAN;
	}
	if (ndr64_obj && PyObject_IsTrue(ndr64_obj)) {
		ndr_pull_flags |= LIBNDR_FLAG_NDR64;
	}

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	return py_mgmt_inq_princ_name_ndr_unpack(py_obj, &blob, NDR_OUT, ndr_pull_flags, allow_remaining);
}

static PyObject *py_mgmt_inq_princ_name_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs, const char *name, ndr_flags_type ndr_inout_flags)
{
	const struct ndr_interface_call *call = NULL;
	struct mgmt_inq_princ_name *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (ndr_table_mgmt.num_calls < 5) {
		PyErr_SetString(PyExc_TypeError, "Internal Error, ndr_interface_call missing for py_mgmt_inq_princ_name_ndr_print");
		return NULL;
	}
	call = &ndr_table_mgmt.calls[4];

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_function_secret_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	} else {
		retstr = ndr_print_function_string(pytalloc_get_mem_ctx(py_obj), call->ndr_print, name, ndr_inout_flags, object);
	}
	ret = PyUnicode_FromString(retstr);
	TALLOC_FREE(retstr);

	return ret;
}

static PyObject *py_mgmt_inq_princ_name_ndr_print_in(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_mgmt_inq_princ_name_ndr_print(py_obj, args, kwargs, "mgmt_inq_princ_name_in", NDR_IN);
}

static PyObject *py_mgmt_inq_princ_name_ndr_print_out(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	return py_mgmt_inq_princ_name_ndr_print(py_obj, args, kwargs, "mgmt_inq_princ_name_out", NDR_OUT);
}

static PyMethodDef py_mgmt_inq_princ_name_methods[] = {
	{ "opnum", (PyCFunction)py_mgmt_inq_princ_name_ndr_opnum, METH_NOARGS|METH_CLASS,
		"mgmt.inq_princ_name.opnum() -> 4 (0x04) " },
	{ "__ndr_pack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_princ_name_ndr_pack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_in(object, bigendian=False, ndr64=False) -> blob\nNDR pack input" },
	{ "__ndr_pack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_princ_name_ndr_pack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_pack_out(object, bigendian=False, ndr64=False) -> blob\nNDR pack output" },
	{ "__ndr_unpack_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_princ_name_ndr_unpack_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_in(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack input" },
	{ "__ndr_unpack_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_princ_name_ndr_unpack_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_unpack_out(class, blob, bigendian=False, ndr64=False, allow_remaining=False) -> None\nNDR unpack output" },
	{ "__ndr_print_in__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_princ_name_ndr_print_in), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_in(object, print_secrets=False) -> String\nNDR print input" },
	{ "__ndr_print_out__", PY_DISCARD_FUNC_SIG(PyCFunction,py_mgmt_inq_princ_name_ndr_print_out), METH_VARARGS|METH_KEYWORDS,
		"S.ndr_print_out(object, print_secrets=False) -> String\nNDR print output" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject mgmt_inq_princ_name_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mgmt.inq_princ_name",
	.tp_getset = py_mgmt_inq_princ_name_getsetters,
	.tp_methods = py_mgmt_inq_princ_name_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_mgmt_inq_princ_name_new,
};

static bool pack_py_mgmt_inq_princ_name_args_in(PyObject *args, PyObject *kwargs, struct mgmt_inq_princ_name *r)
{
	PyObject *py_authn_proto;
	PyObject *py_princ_name_size;
	const char *kwnames[] = {
		"authn_proto", "princ_name_size", NULL
	};

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OO:mgmt_inq_princ_name", discard_const_p(char *, kwnames), &py_authn_proto, &py_princ_name_size)) {
		return false;
	}

	if (py_authn_proto == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.authn_proto");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.authn_proto));
		if (PyLong_Check(py_authn_proto)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_authn_proto);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.authn_proto = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	if (py_princ_name_size == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: r->in.princ_name_size");
		return false;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(r->in.princ_name_size));
		if (PyLong_Check(py_princ_name_size)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(py_princ_name_size);
			if (PyErr_Occurred() != NULL) {
				return false;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return false;
			}
			r->in.princ_name_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return false;
		}
	}
	return true;
}

static PyObject *unpack_py_mgmt_inq_princ_name_args_out(struct mgmt_inq_princ_name *r, bool raise_result_exception)
{
	PyObject *py_princ_name = NULL;
	PyObject *result = NULL;
	size_t result_size = 1;

	if (raise_result_exception) {
		if (!W_ERROR_IS_OK(r->out.result)) {
			PyErr_SetWERROR(r->out.result);
			return NULL;
		}

	} else {
		/* WERROR will be part of the results */
		result_size += 1;
	}

	if (result_size > 1) {
		result = PyTuple_New(result_size);
		if (result == NULL) {
			return NULL;
		}
	}

	if (r->out.princ_name == NULL) {
		py_princ_name = Py_None;
		Py_INCREF(py_princ_name);
	} else {
		py_princ_name = PyUnicode_Decode(r->out.princ_name, strlen(r->out.princ_name), "utf-8", "ignore");
	}
	if (result_size > 1) {
		PyTuple_SetItem(result, 0, py_princ_name);
	}
	if (result_size == 1) {
		result = py_princ_name;
	}

	if (!raise_result_exception) {
		PyTuple_SetItem(result, 1, PyErr_FromWERROR(r->out.result));
	}

	return result;
}

const struct PyNdrRpcMethodDef py_ndr_mgmt_methods[] = {
	{
		.name = "inq_if_ids",
		.doc = "S.inq_if_ids() -> if_id_vector",
		.call = (py_dcerpc_call_fn)dcerpc_mgmt_inq_if_ids_r,
		.pack_in_data = (py_data_pack_fn)pack_py_mgmt_inq_if_ids_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_mgmt_inq_if_ids_args_out,
		.opnum = 0,
		.table = &ndr_table_mgmt,
	},
	{
		.name = "inq_stats",
		.doc = "S.inq_stats(max_count, unknown) -> statistics",
		.call = (py_dcerpc_call_fn)dcerpc_mgmt_inq_stats_r,
		.pack_in_data = (py_data_pack_fn)pack_py_mgmt_inq_stats_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_mgmt_inq_stats_args_out,
		.opnum = 1,
		.table = &ndr_table_mgmt,
	},
	{
		.name = "is_server_listening",
		.doc = "S.is_server_listening() -> (status, result)",
		.call = (py_dcerpc_call_fn)dcerpc_mgmt_is_server_listening_r,
		.pack_in_data = (py_data_pack_fn)pack_py_mgmt_is_server_listening_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_mgmt_is_server_listening_args_out,
		.opnum = 2,
		.table = &ndr_table_mgmt,
	},
	{
		.name = "stop_server_listening",
		.doc = "S.stop_server_listening() -> None",
		.call = (py_dcerpc_call_fn)dcerpc_mgmt_stop_server_listening_r,
		.pack_in_data = (py_data_pack_fn)pack_py_mgmt_stop_server_listening_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_mgmt_stop_server_listening_args_out,
		.opnum = 3,
		.table = &ndr_table_mgmt,
	},
	{
		.name = "inq_princ_name",
		.doc = "S.inq_princ_name(authn_proto, princ_name_size) -> princ_name",
		.call = (py_dcerpc_call_fn)dcerpc_mgmt_inq_princ_name_r,
		.pack_in_data = (py_data_pack_fn)pack_py_mgmt_inq_princ_name_args_in,
		.unpack_out_data = (py_data_unpack_fn)unpack_py_mgmt_inq_princ_name_args_out,
		.opnum = 4,
		.table = &ndr_table_mgmt,
	},
	{
		.name = NULL,
	},
};

static PyObject *interface_mgmt_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_interface_init_helper(type, args, kwargs, &ndr_table_mgmt);
}

#define PY_DOC_MGMT "DCE/RPC Remote Management"
static PyTypeObject mgmt_InterfaceType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mgmt.mgmt",
	.tp_basicsize = sizeof(dcerpc_InterfaceObject),
	.tp_doc = "mgmt(binding, lp_ctx=None, credentials=None, basis_connection=None) -> connection\n"
"\n\n"
"Parameters\n"
"----------\n"
"binding : str\n"
"    A DCE/RPC binding string (for example: ncacn_ip_tcp:127.0.0.1)\n"
"lp_ctx : param.LoadParm\n"
"    Should be a path to a smb.conf file or a param.LoadParm object\n"
"credentials : credentials.Credentials, optional\n"
"    A credentials.Credentials object (default is None).\n"
"basis_connection : samba.dcerpc.ClientConnection, optional\n"
"    A mgmt client connection object (default is None).\n"
"\n\n"
"Returns\n"
"-------\n"
"samba.dcerpc.ClientConnection\n"
"    A ClientConnection object\n"
"\n\n"
"Raises\n"
"------\n"
"samba.NTSTATUSError\n"
"    An NTSTATUS error\n"
"\n"PY_DOC_MGMT,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = interface_mgmt_new,
};

static PyObject *syntax_mgmt_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return py_dcerpc_syntax_init_helper(type, args, kwargs, &ndr_table_mgmt.syntax_id);
}

#define PY_DOC_MGMT_SYNTAX "DCE/RPC Remote Management"
static PyTypeObject mgmt_SyntaxType = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "mgmt.mgmt_abstract_syntax",
	.tp_doc = "mgmt_abstract_syntax()\n"PY_DOC_MGMT_SYNTAX,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = syntax_mgmt_new,
};

static PyMethodDef mgmt_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "mgmt",
	.m_doc = "mgmt DCE/RPC",
	.m_size = -1,
	.m_methods = mgmt_methods,
};
MODULE_INIT_FUNC(mgmt)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_talloc = NULL;
	PyObject *dep_samba_dcerpc_base = NULL;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	dep_samba_dcerpc_base = PyImport_ImportModule("samba.dcerpc.base");
	if (dep_samba_dcerpc_base == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	ClientConnection_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_base, "ClientConnection");
	if (ClientConnection_Type == NULL)
		goto out;

	ndr_syntax_id_p_Type.tp_base = BaseObject_Type;
	ndr_syntax_id_p_Type.tp_basicsize = pytalloc_BaseObject_size();

	rpc_if_id_vector_t_Type.tp_base = BaseObject_Type;
	rpc_if_id_vector_t_Type.tp_basicsize = pytalloc_BaseObject_size();

	mgmt_statistics_Type.tp_base = BaseObject_Type;
	mgmt_statistics_Type.tp_basicsize = pytalloc_BaseObject_size();

	mgmt_inq_if_ids_Type.tp_base = BaseObject_Type;
	mgmt_inq_if_ids_Type.tp_basicsize = pytalloc_BaseObject_size();

	mgmt_inq_stats_Type.tp_base = BaseObject_Type;
	mgmt_inq_stats_Type.tp_basicsize = pytalloc_BaseObject_size();

	mgmt_is_server_listening_Type.tp_base = BaseObject_Type;
	mgmt_is_server_listening_Type.tp_basicsize = pytalloc_BaseObject_size();

	mgmt_stop_server_listening_Type.tp_base = BaseObject_Type;
	mgmt_stop_server_listening_Type.tp_basicsize = pytalloc_BaseObject_size();

	mgmt_inq_princ_name_Type.tp_base = BaseObject_Type;
	mgmt_inq_princ_name_Type.tp_basicsize = pytalloc_BaseObject_size();

	mgmt_InterfaceType.tp_base = ClientConnection_Type;

	mgmt_SyntaxType.tp_base = ndr_syntax_id_Type;
	mgmt_SyntaxType.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&ndr_syntax_id_p_Type) < 0)
		goto out;
	if (PyType_Ready(&rpc_if_id_vector_t_Type) < 0)
		goto out;
	if (PyType_Ready(&mgmt_statistics_Type) < 0)
		goto out;
	if (PyType_Ready(&mgmt_inq_if_ids_Type) < 0)
		goto out;
	if (PyType_Ready(&mgmt_inq_stats_Type) < 0)
		goto out;
	if (PyType_Ready(&mgmt_is_server_listening_Type) < 0)
		goto out;
	if (PyType_Ready(&mgmt_stop_server_listening_Type) < 0)
		goto out;
	if (PyType_Ready(&mgmt_inq_princ_name_Type) < 0)
		goto out;
	if (PyType_Ready(&mgmt_InterfaceType) < 0)
		goto out;
	if (PyType_Ready(&mgmt_SyntaxType) < 0)
		goto out;
	if (!PyInterface_AddNdrRpcMethods(&mgmt_InterfaceType, py_ndr_mgmt_methods))
		return NULL;

#ifdef PY_NDR_SYNTAX_ID_P_PATCH
	PY_NDR_SYNTAX_ID_P_PATCH(&ndr_syntax_id_p_Type);
#endif
#ifdef PY_RPC_IF_ID_VECTOR_T_PATCH
	PY_RPC_IF_ID_VECTOR_T_PATCH(&rpc_if_id_vector_t_Type);
#endif
#ifdef PY_STATISTICS_PATCH
	PY_STATISTICS_PATCH(&mgmt_statistics_Type);
#endif
#ifdef PY_INQ_IF_IDS_PATCH
	PY_INQ_IF_IDS_PATCH(&mgmt_inq_if_ids_Type);
#endif
#ifdef PY_INQ_STATS_PATCH
	PY_INQ_STATS_PATCH(&mgmt_inq_stats_Type);
#endif
#ifdef PY_IS_SERVER_LISTENING_PATCH
	PY_IS_SERVER_LISTENING_PATCH(&mgmt_is_server_listening_Type);
#endif
#ifdef PY_STOP_SERVER_LISTENING_PATCH
	PY_STOP_SERVER_LISTENING_PATCH(&mgmt_stop_server_listening_Type);
#endif
#ifdef PY_INQ_PRINC_NAME_PATCH
	PY_INQ_PRINC_NAME_PATCH(&mgmt_inq_princ_name_Type);
#endif
#ifdef PY_MGMT_PATCH
	PY_MGMT_PATCH(&mgmt_InterfaceType);
#endif
#ifdef PY_MGMT_ABSTRACT_SYNTAX_PATCH
	PY_MGMT_ABSTRACT_SYNTAX_PATCH(&mgmt_SyntaxType);
#endif
#ifdef PY_ABSTRACT_SYNTAX_PATCH
	PY_ABSTRACT_SYNTAX_PATCH(&mgmt_SyntaxType);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "MGMT_STATS_CALLS_IN", PyLong_FromUnsignedLongLong(0));
	PyModule_AddObject(m, "MGMT_STATS_CALLS_OUT", PyLong_FromUnsignedLongLong(1));
	PyModule_AddObject(m, "MGMT_STATS_PKTS_IN", PyLong_FromUnsignedLongLong(2));
	PyModule_AddObject(m, "MGMT_STATS_PKTS_OUT", PyLong_FromUnsignedLongLong(3));
	PyModule_AddObject(m, "MGMT_STATS_ARRAY_MAX_SIZE", PyLong_FromUnsignedLongLong(4));
	Py_INCREF((PyObject *)(void *)&ndr_syntax_id_p_Type);
	PyModule_AddObject(m, "ndr_syntax_id_p", (PyObject *)(void *)&ndr_syntax_id_p_Type);
	Py_INCREF((PyObject *)(void *)&rpc_if_id_vector_t_Type);
	PyModule_AddObject(m, "rpc_if_id_vector_t", (PyObject *)(void *)&rpc_if_id_vector_t_Type);
	Py_INCREF((PyObject *)(void *)&mgmt_statistics_Type);
	PyModule_AddObject(m, "statistics", (PyObject *)(void *)&mgmt_statistics_Type);
	Py_INCREF((PyObject *)(void *)&mgmt_inq_if_ids_Type);
	PyModule_AddObject(m, "inq_if_ids", (PyObject *)(void *)&mgmt_inq_if_ids_Type);
	Py_INCREF((PyObject *)(void *)&mgmt_inq_stats_Type);
	PyModule_AddObject(m, "inq_stats", (PyObject *)(void *)&mgmt_inq_stats_Type);
	Py_INCREF((PyObject *)(void *)&mgmt_is_server_listening_Type);
	PyModule_AddObject(m, "is_server_listening", (PyObject *)(void *)&mgmt_is_server_listening_Type);
	Py_INCREF((PyObject *)(void *)&mgmt_stop_server_listening_Type);
	PyModule_AddObject(m, "stop_server_listening", (PyObject *)(void *)&mgmt_stop_server_listening_Type);
	Py_INCREF((PyObject *)(void *)&mgmt_inq_princ_name_Type);
	PyModule_AddObject(m, "inq_princ_name", (PyObject *)(void *)&mgmt_inq_princ_name_Type);
	Py_INCREF((PyObject *)(void *)&mgmt_InterfaceType);
	PyModule_AddObject(m, "mgmt", (PyObject *)(void *)&mgmt_InterfaceType);
	Py_INCREF((PyObject *)(void *)&mgmt_SyntaxType);
	PyModule_AddObject(m, "mgmt_abstract_syntax", (PyObject *)(void *)&mgmt_SyntaxType);
	Py_INCREF((PyObject *)(void *)&mgmt_SyntaxType);
	PyModule_AddObject(m, "abstract_syntax", (PyObject *)(void *)&mgmt_SyntaxType);
#ifdef PY_MOD_MGMT_PATCH
	PY_MOD_MGMT_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_talloc);
	Py_XDECREF(dep_samba_dcerpc_base);
	return m;

}
