/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_schannel.h"

#include "librpc/gen_ndr/ndr_netlogon.h"
#include "librpc/gen_ndr/ndr_nbt.h"
#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_security.h"
static enum ndr_err_code ndr_push_netlogon_creds_CredentialState_extra_info(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct netlogon_creds_CredentialState_extra_info *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->dummy_sid));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_netlogon_creds_CredentialState_extra_info(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct netlogon_creds_CredentialState_extra_info *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->dummy_sid));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_netlogon_creds_CredentialState_extra_info(struct ndr_print *ndr, const char *name, const struct netlogon_creds_CredentialState_extra_info *r)
{
	ndr_print_struct(ndr, name, "netlogon_creds_CredentialState_extra_info");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_dom_sid(ndr, "dummy_sid", &r->dummy_sid);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_netlogon_creds_CredentialState(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct netlogon_creds_CredentialState *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 8));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			{
				libndr_flags _flags_save_uint8 = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->session_key, 16));
				ndr->flags = _flags_save_uint8;
			}
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sequence));
			NDR_CHECK(ndr_push_netr_Credential(ndr, NDR_SCALARS, &r->seed));
			NDR_CHECK(ndr_push_netr_Credential(ndr, NDR_SCALARS, &r->client));
			NDR_CHECK(ndr_push_netr_Credential(ndr, NDR_SCALARS, &r->server));
			NDR_CHECK(ndr_push_netr_SchannelType(ndr, NDR_SCALARS, r->secure_channel_type));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->computer_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->computer_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->computer_name, ndr_charset_length(r->computer_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->account_name, CH_UTF8)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->account_name, CH_UTF8)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->account_name, ndr_charset_length(r->account_name, CH_UTF8), sizeof(uint8_t), CH_UTF8));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0xFFFFFFFF));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0xFFFFFFFF));
			NDR_CHECK(ndr_push_netr_NegotiateFlags(ndr, NDR_SCALARS, r->negotiate_flags));
			NDR_CHECK(ndr_push_netr_NegotiateFlags(ndr, NDR_SCALARS, r->client_requested_flags));
			NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->auth_time));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0xFFFFFFFF));
			NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_SCALARS, &r->client_sid));
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->tdo_guid));
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->authenticate_kerberos));
			NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_unique_ptr(ndr, NULL));
			NDR_CHECK(ndr_push_trailer_align(ndr, 8));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_push_dom_sid28(ndr, NDR_BUFFERS, &r->client_sid));
			if (NULL) {
				NDR_CHECK(ndr_push_netlogon_creds_CredentialState_extra_info(ndr, NDR_SCALARS, NULL));
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netlogon_creds_CredentialState(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct netlogon_creds_CredentialState *r)
{
	uint32_t size_session_key_0 = 0;
	uint32_t size_computer_name_0 = 0;
	uint32_t length_computer_name_0 = 0;
	uint32_t size_account_name_0 = 0;
	uint32_t length_account_name_0 = 0;
	uint32_t _ptr_ex;
	TALLOC_CTX *_mem_save_ex_0 = NULL;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 8));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->zero_flags));
			{
				libndr_flags _flags_save_uint8 = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
				size_session_key_0 = 16;
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->session_key, size_session_key_0));
				ndr->flags = _flags_save_uint8;
			}
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sequence));
			NDR_CHECK(ndr_pull_netr_Credential(ndr, NDR_SCALARS, &r->seed));
			NDR_CHECK(ndr_pull_netr_Credential(ndr, NDR_SCALARS, &r->client));
			NDR_CHECK(ndr_pull_netr_Credential(ndr, NDR_SCALARS, &r->server));
			NDR_CHECK(ndr_pull_netr_SchannelType(ndr, NDR_SCALARS, &r->secure_channel_type));
			NDR_CHECK(ndr_pull_array_size(ndr, &r->computer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->computer_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->computer_name, &size_computer_name_0));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->computer_name, &length_computer_name_0));
			if (length_computer_name_0 > size_computer_name_0) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_computer_name_0, length_computer_name_0);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_0, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->computer_name, length_computer_name_0, sizeof(uint8_t), CH_UTF8));
			NDR_CHECK(ndr_pull_array_size(ndr, &r->account_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->account_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->account_name, &size_account_name_0));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->account_name, &length_account_name_0));
			if (length_account_name_0 > size_account_name_0) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_account_name_0, length_account_name_0);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_account_name_0, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->account_name, length_account_name_0, sizeof(uint8_t), CH_UTF8));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic1));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic2));
			NDR_CHECK(ndr_pull_netr_NegotiateFlags(ndr, NDR_SCALARS, &r->negotiate_flags));
			NDR_CHECK(ndr_pull_netr_NegotiateFlags(ndr, NDR_SCALARS, &r->client_requested_flags));
			NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->auth_time));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->magic3));
			NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_SCALARS, &r->client_sid));
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->tdo_guid));
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->authenticate_kerberos));
			NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->reserved2));
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ex));
			if (_ptr_ex) {
				NDR_PULL_ALLOC(ndr, r->ex);
			} else {
				r->ex = NULL;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_pull_dom_sid28(ndr, NDR_BUFFERS, &r->client_sid));
			if (r->ex) {
				_mem_save_ex_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->ex, 0);
				NDR_CHECK(ndr_pull_netlogon_creds_CredentialState_extra_info(ndr, NDR_SCALARS, r->ex));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ex_0, 0);
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_netlogon_creds_CredentialState(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct netlogon_creds_CredentialState *r)
{
	ndr_print_netlogon_creds_CredentialState(ndr, name, r);
}

_PUBLIC_ void ndr_print_netlogon_creds_CredentialState(struct ndr_print *ndr, const char *name, const struct netlogon_creds_CredentialState *r)
{
	ndr_print_struct(ndr, name, "netlogon_creds_CredentialState");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint32(ndr, "zero_flags", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->zero_flags);
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_IS_SECRET);
			ndr_print_array_uint8(ndr, "session_key", r->session_key, 16);
			ndr->flags = _flags_save_uint8;
		}
		ndr_print_uint32(ndr, "sequence", r->sequence);
		ndr_print_netr_Credential(ndr, "seed", &r->seed);
		ndr_print_netr_Credential(ndr, "client", &r->client);
		ndr_print_netr_Credential(ndr, "server", &r->server);
		ndr_print_netr_SchannelType(ndr, "secure_channel_type", r->secure_channel_type);
		ndr_print_string(ndr, "computer_name", r->computer_name);
		ndr_print_string(ndr, "account_name", r->account_name);
		ndr_print_uint32(ndr, "magic1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0xFFFFFFFF:r->magic1);
		ndr_print_uint32(ndr, "magic2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0xFFFFFFFF:r->magic2);
		ndr_print_netr_NegotiateFlags(ndr, "negotiate_flags", r->negotiate_flags);
		ndr_print_netr_NegotiateFlags(ndr, "client_requested_flags", r->client_requested_flags);
		ndr_print_NTTIME(ndr, "auth_time", r->auth_time);
		ndr_print_uint32(ndr, "magic3", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0xFFFFFFFF:r->magic3);
		ndr_print_dom_sid28(ndr, "client_sid", &r->client_sid);
		ndr_print_GUID(ndr, "tdo_guid", &r->tdo_guid);
		ndr_print_uint8(ndr, "authenticate_kerberos", r->authenticate_kerberos);
		ndr_print_hyper(ndr, "reserved2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved2);
		ndr_print_ptr(ndr, "ex", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NULL:r->ex);
		ndr->depth++;
		if ((ndr->flags & LIBNDR_PRINT_SET_VALUES)?NULL:r->ex) {
			ndr_print_netlogon_creds_CredentialState_extra_info(ndr, "ex", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NULL:r->ex);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_netlogon_cache_entry(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct netlogon_cache_entry *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->computer_name));
		NDR_CHECK(ndr_push_netr_Credential(ndr, NDR_SCALARS, &r->server_challenge));
		NDR_CHECK(ndr_push_netr_Credential(ndr, NDR_SCALARS, &r->client_challenge));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->computer_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->computer_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->computer_name, ndr_charset_length(r->computer_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_netlogon_cache_entry(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct netlogon_cache_entry *r)
{
	uint32_t _ptr_computer_name;
	uint32_t size_computer_name_1 = 0;
	uint32_t length_computer_name_1 = 0;
	TALLOC_CTX *_mem_save_computer_name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_computer_name));
		if (_ptr_computer_name) {
			NDR_PULL_ALLOC(ndr, r->computer_name);
		} else {
			r->computer_name = NULL;
		}
		NDR_CHECK(ndr_pull_netr_Credential(ndr, NDR_SCALARS, &r->server_challenge));
		NDR_CHECK(ndr_pull_netr_Credential(ndr, NDR_SCALARS, &r->client_challenge));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->computer_name) {
			_mem_save_computer_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->computer_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->computer_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->computer_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->computer_name, &size_computer_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->computer_name, &length_computer_name_1));
			if (length_computer_name_1 > size_computer_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_computer_name_1, length_computer_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_computer_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->computer_name, length_computer_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_computer_name_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_netlogon_cache_entry(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct netlogon_cache_entry *r)
{
	ndr_print_netlogon_cache_entry(ndr, name, r);
}

_PUBLIC_ void ndr_print_netlogon_cache_entry(struct ndr_print *ndr, const char *name, const struct netlogon_cache_entry *r)
{
	ndr_print_struct(ndr, name, "netlogon_cache_entry");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "computer_name", r->computer_name);
	ndr->depth++;
	if (r->computer_name) {
		ndr_print_string(ndr, "computer_name", r->computer_name);
	}
	ndr->depth--;
	ndr_print_netr_Credential(ndr, "server_challenge", &r->server_challenge);
	ndr_print_netr_Credential(ndr, "client_challenge", &r->client_challenge);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_NL_AUTH_MESSAGE_TYPE(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum NL_AUTH_MESSAGE_TYPE r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NL_AUTH_MESSAGE_TYPE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum NL_AUTH_MESSAGE_TYPE *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NL_AUTH_MESSAGE_TYPE(struct ndr_print *ndr, const char *name, enum NL_AUTH_MESSAGE_TYPE r)
{
	const char *val = NULL;

	switch (r) {
		case NL_NEGOTIATE_REQUEST: val = "NL_NEGOTIATE_REQUEST"; break;
		case NL_NEGOTIATE_RESPONSE: val = "NL_NEGOTIATE_RESPONSE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_NL_AUTH_MESSAGE_FLAGS(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NL_AUTH_MESSAGE_FLAGS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NL_AUTH_MESSAGE_FLAGS(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NL_FLAG_OEM_NETBIOS_DOMAIN_NAME", NL_FLAG_OEM_NETBIOS_DOMAIN_NAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NL_FLAG_OEM_NETBIOS_COMPUTER_NAME", NL_FLAG_OEM_NETBIOS_COMPUTER_NAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NL_FLAG_UTF8_DNS_DOMAIN_NAME", NL_FLAG_UTF8_DNS_DOMAIN_NAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NL_FLAG_UTF8_DNS_HOST_NAME", NL_FLAG_UTF8_DNS_HOST_NAME, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME", NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_NL_AUTH_MESSAGE_BUFFER(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union NL_AUTH_MESSAGE_BUFFER *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case NL_FLAG_OEM_NETBIOS_DOMAIN_NAME: {
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->a));
					ndr->flags = _flags_save_string;
				}
			break; }

			case NL_FLAG_OEM_NETBIOS_COMPUTER_NAME: {
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->a));
					ndr->flags = _flags_save_string;
				}
			break; }

			case NL_FLAG_UTF8_DNS_DOMAIN_NAME: {
				NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->u));
			break; }

			case NL_FLAG_UTF8_DNS_HOST_NAME: {
				NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->u));
			break; }

			case NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME: {
				NDR_CHECK(ndr_push_nbt_string(ndr, NDR_SCALARS, r->u));
			break; }

			default: {
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NL_AUTH_MESSAGE_BUFFER(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union NL_AUTH_MESSAGE_BUFFER *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case NL_FLAG_OEM_NETBIOS_DOMAIN_NAME: {
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->a));
					ndr->flags = _flags_save_string;
				}
			break; }

			case NL_FLAG_OEM_NETBIOS_COMPUTER_NAME: {
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
					NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->a));
					ndr->flags = _flags_save_string;
				}
			break; }

			case NL_FLAG_UTF8_DNS_DOMAIN_NAME: {
				NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->u));
			break; }

			case NL_FLAG_UTF8_DNS_HOST_NAME: {
				NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->u));
			break; }

			case NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME: {
				NDR_CHECK(ndr_pull_nbt_string(ndr, NDR_SCALARS, &r->u));
			break; }

			default: {
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_push_NL_AUTH_MESSAGE_BUFFER_REPLY(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union NL_AUTH_MESSAGE_BUFFER_REPLY *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case NL_NEGOTIATE_RESPONSE: {
				NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dummy));
			break; }

			default: {
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NL_AUTH_MESSAGE_BUFFER_REPLY(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union NL_AUTH_MESSAGE_BUFFER_REPLY *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case NL_NEGOTIATE_RESPONSE: {
				NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dummy));
			break; }

			default: {
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_push_NL_AUTH_MESSAGE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct NL_AUTH_MESSAGE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_NL_AUTH_MESSAGE_TYPE(ndr, NDR_SCALARS, r->MessageType));
			NDR_CHECK(ndr_push_NL_AUTH_MESSAGE_FLAGS(ndr, NDR_SCALARS, r->Flags));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->oem_netbios_domain, r->Flags & NL_FLAG_OEM_NETBIOS_DOMAIN_NAME));
			NDR_CHECK(ndr_push_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_SCALARS, &r->oem_netbios_domain));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->oem_netbios_computer, r->Flags & NL_FLAG_OEM_NETBIOS_COMPUTER_NAME));
			NDR_CHECK(ndr_push_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_SCALARS, &r->oem_netbios_computer));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->utf8_dns_domain, r->Flags & NL_FLAG_UTF8_DNS_DOMAIN_NAME));
			NDR_CHECK(ndr_push_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_SCALARS, &r->utf8_dns_domain));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->utf8_dns_host, r->Flags & NL_FLAG_UTF8_DNS_HOST_NAME));
			NDR_CHECK(ndr_push_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_SCALARS, &r->utf8_dns_host));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->utf8_netbios_computer, r->Flags & NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME));
			NDR_CHECK(ndr_push_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_SCALARS, &r->utf8_netbios_computer));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->Buffer, r->MessageType & NL_NEGOTIATE_RESPONSE));
			NDR_CHECK(ndr_push_NL_AUTH_MESSAGE_BUFFER_REPLY(ndr, NDR_SCALARS, &r->Buffer));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->oem_netbios_domain, r->Flags & NL_FLAG_OEM_NETBIOS_DOMAIN_NAME));
			NDR_CHECK(ndr_push_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_BUFFERS, &r->oem_netbios_domain));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->oem_netbios_computer, r->Flags & NL_FLAG_OEM_NETBIOS_COMPUTER_NAME));
			NDR_CHECK(ndr_push_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_BUFFERS, &r->oem_netbios_computer));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->utf8_dns_domain, r->Flags & NL_FLAG_UTF8_DNS_DOMAIN_NAME));
			NDR_CHECK(ndr_push_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_BUFFERS, &r->utf8_dns_domain));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->utf8_dns_host, r->Flags & NL_FLAG_UTF8_DNS_HOST_NAME));
			NDR_CHECK(ndr_push_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_BUFFERS, &r->utf8_dns_host));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->utf8_netbios_computer, r->Flags & NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME));
			NDR_CHECK(ndr_push_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_BUFFERS, &r->utf8_netbios_computer));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->Buffer, r->MessageType & NL_NEGOTIATE_RESPONSE));
			NDR_CHECK(ndr_push_NL_AUTH_MESSAGE_BUFFER_REPLY(ndr, NDR_BUFFERS, &r->Buffer));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NL_AUTH_MESSAGE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct NL_AUTH_MESSAGE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_NL_AUTH_MESSAGE_TYPE(ndr, NDR_SCALARS, &r->MessageType));
			NDR_CHECK(ndr_pull_NL_AUTH_MESSAGE_FLAGS(ndr, NDR_SCALARS, &r->Flags));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->oem_netbios_domain, r->Flags & NL_FLAG_OEM_NETBIOS_DOMAIN_NAME));
			NDR_CHECK(ndr_pull_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_SCALARS, &r->oem_netbios_domain));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->oem_netbios_computer, r->Flags & NL_FLAG_OEM_NETBIOS_COMPUTER_NAME));
			NDR_CHECK(ndr_pull_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_SCALARS, &r->oem_netbios_computer));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->utf8_dns_domain, r->Flags & NL_FLAG_UTF8_DNS_DOMAIN_NAME));
			NDR_CHECK(ndr_pull_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_SCALARS, &r->utf8_dns_domain));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->utf8_dns_host, r->Flags & NL_FLAG_UTF8_DNS_HOST_NAME));
			NDR_CHECK(ndr_pull_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_SCALARS, &r->utf8_dns_host));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->utf8_netbios_computer, r->Flags & NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME));
			NDR_CHECK(ndr_pull_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_SCALARS, &r->utf8_netbios_computer));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->Buffer, r->MessageType & NL_NEGOTIATE_RESPONSE));
			NDR_CHECK(ndr_pull_NL_AUTH_MESSAGE_BUFFER_REPLY(ndr, NDR_SCALARS, &r->Buffer));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->oem_netbios_domain, r->Flags & NL_FLAG_OEM_NETBIOS_DOMAIN_NAME));
			NDR_CHECK(ndr_pull_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_BUFFERS, &r->oem_netbios_domain));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->oem_netbios_computer, r->Flags & NL_FLAG_OEM_NETBIOS_COMPUTER_NAME));
			NDR_CHECK(ndr_pull_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_BUFFERS, &r->oem_netbios_computer));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->utf8_dns_domain, r->Flags & NL_FLAG_UTF8_DNS_DOMAIN_NAME));
			NDR_CHECK(ndr_pull_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_BUFFERS, &r->utf8_dns_domain));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->utf8_dns_host, r->Flags & NL_FLAG_UTF8_DNS_HOST_NAME));
			NDR_CHECK(ndr_pull_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_BUFFERS, &r->utf8_dns_host));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->utf8_netbios_computer, r->Flags & NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME));
			NDR_CHECK(ndr_pull_NL_AUTH_MESSAGE_BUFFER(ndr, NDR_BUFFERS, &r->utf8_netbios_computer));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->Buffer, r->MessageType & NL_NEGOTIATE_RESPONSE));
			NDR_CHECK(ndr_pull_NL_AUTH_MESSAGE_BUFFER_REPLY(ndr, NDR_BUFFERS, &r->Buffer));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_NL_AUTH_MESSAGE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct NL_AUTH_MESSAGE *r)
{
	ndr_print_NL_AUTH_MESSAGE(ndr, name, r);
}

_PUBLIC_ void ndr_print_NL_AUTH_MESSAGE(struct ndr_print *ndr, const char *name, const struct NL_AUTH_MESSAGE *r)
{
	ndr_print_struct(ndr, name, "NL_AUTH_MESSAGE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_NL_AUTH_MESSAGE_TYPE(ndr, "MessageType", r->MessageType);
		ndr_print_NL_AUTH_MESSAGE_FLAGS(ndr, "Flags", r->Flags);
		ndr_print_set_switch_value(ndr, &r->oem_netbios_domain, r->Flags & NL_FLAG_OEM_NETBIOS_DOMAIN_NAME);
		ndr_print_NL_AUTH_MESSAGE_BUFFER(ndr, "oem_netbios_domain", &r->oem_netbios_domain);
		ndr_print_set_switch_value(ndr, &r->oem_netbios_computer, r->Flags & NL_FLAG_OEM_NETBIOS_COMPUTER_NAME);
		ndr_print_NL_AUTH_MESSAGE_BUFFER(ndr, "oem_netbios_computer", &r->oem_netbios_computer);
		ndr_print_set_switch_value(ndr, &r->utf8_dns_domain, r->Flags & NL_FLAG_UTF8_DNS_DOMAIN_NAME);
		ndr_print_NL_AUTH_MESSAGE_BUFFER(ndr, "utf8_dns_domain", &r->utf8_dns_domain);
		ndr_print_set_switch_value(ndr, &r->utf8_dns_host, r->Flags & NL_FLAG_UTF8_DNS_HOST_NAME);
		ndr_print_NL_AUTH_MESSAGE_BUFFER(ndr, "utf8_dns_host", &r->utf8_dns_host);
		ndr_print_set_switch_value(ndr, &r->utf8_netbios_computer, r->Flags & NL_FLAG_UTF8_NETBIOS_COMPUTER_NAME);
		ndr_print_NL_AUTH_MESSAGE_BUFFER(ndr, "utf8_netbios_computer", &r->utf8_netbios_computer);
		ndr_print_set_switch_value(ndr, &r->Buffer, r->MessageType & NL_NEGOTIATE_RESPONSE);
		ndr_print_NL_AUTH_MESSAGE_BUFFER_REPLY(ndr, "Buffer", &r->Buffer);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_NL_SIGNATURE_ALGORITHM(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum NL_SIGNATURE_ALGORITHM r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NL_SIGNATURE_ALGORITHM(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum NL_SIGNATURE_ALGORITHM *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NL_SIGNATURE_ALGORITHM(struct ndr_print *ndr, const char *name, enum NL_SIGNATURE_ALGORITHM r)
{
	const char *val = NULL;

	switch (r) {
		case NL_SIGN_HMAC_SHA256: val = "NL_SIGN_HMAC_SHA256"; break;
		case NL_SIGN_HMAC_MD5: val = "NL_SIGN_HMAC_MD5"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_NL_SEAL_ALGORITHM(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum NL_SEAL_ALGORITHM r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NL_SEAL_ALGORITHM(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum NL_SEAL_ALGORITHM *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NL_SEAL_ALGORITHM(struct ndr_print *ndr, const char *name, enum NL_SEAL_ALGORITHM r)
{
	const char *val = NULL;

	switch (r) {
		case NL_SEAL_AES128: val = "NL_SEAL_AES128"; break;
		case NL_SEAL_RC4: val = "NL_SEAL_RC4"; break;
		case NL_SEAL_NONE: val = "NL_SEAL_NONE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_NL_AUTH_SIGNATURE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct NL_AUTH_SIGNATURE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 3));
			NDR_CHECK(ndr_push_NL_SIGNATURE_ALGORITHM(ndr, NDR_SCALARS, NL_SIGN_HMAC_MD5));
			NDR_CHECK(ndr_push_NL_SEAL_ALGORITHM(ndr, NDR_SCALARS, r->SealAlgorithm));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Pad));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Flags));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->SequenceNumber, 8));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Checksum, 8));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Confounder, 8));
			NDR_CHECK(ndr_push_trailer_align(ndr, 3));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NL_AUTH_SIGNATURE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct NL_AUTH_SIGNATURE *r)
{
	uint32_t size_SequenceNumber_0 = 0;
	uint32_t size_Checksum_0 = 0;
	uint32_t size_Confounder_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 3));
			NDR_CHECK(ndr_pull_NL_SIGNATURE_ALGORITHM(ndr, NDR_SCALARS, &r->SignatureAlgorithm));
			NDR_CHECK(ndr_pull_NL_SEAL_ALGORITHM(ndr, NDR_SCALARS, &r->SealAlgorithm));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Pad));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Flags));
			size_SequenceNumber_0 = 8;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->SequenceNumber, size_SequenceNumber_0));
			size_Checksum_0 = 8;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Checksum, size_Checksum_0));
			size_Confounder_0 = 8;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Confounder, size_Confounder_0));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 3));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_NL_AUTH_SIGNATURE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct NL_AUTH_SIGNATURE *r)
{
	ndr_print_NL_AUTH_SIGNATURE(ndr, name, r);
}

_PUBLIC_ void ndr_print_NL_AUTH_SIGNATURE(struct ndr_print *ndr, const char *name, const struct NL_AUTH_SIGNATURE *r)
{
	ndr_print_struct(ndr, name, "NL_AUTH_SIGNATURE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_NL_SIGNATURE_ALGORITHM(ndr, "SignatureAlgorithm", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NL_SIGN_HMAC_MD5:r->SignatureAlgorithm);
		ndr_print_NL_SEAL_ALGORITHM(ndr, "SealAlgorithm", r->SealAlgorithm);
		ndr_print_uint16(ndr, "Pad", r->Pad);
		ndr_print_uint16(ndr, "Flags", r->Flags);
		ndr_print_array_uint8(ndr, "SequenceNumber", r->SequenceNumber, 8);
		ndr_print_array_uint8(ndr, "Checksum", r->Checksum, 8);
		ndr_print_array_uint8(ndr, "Confounder", r->Confounder, 8);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_NL_AUTH_SHA2_SIGNATURE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct NL_AUTH_SHA2_SIGNATURE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 3));
			NDR_CHECK(ndr_push_NL_SIGNATURE_ALGORITHM(ndr, NDR_SCALARS, NL_SIGN_HMAC_SHA256));
			NDR_CHECK(ndr_push_NL_SEAL_ALGORITHM(ndr, NDR_SCALARS, r->SealAlgorithm));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Pad));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Flags));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->SequenceNumber, 8));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Checksum, 32));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Confounder, 8));
			NDR_CHECK(ndr_push_trailer_align(ndr, 3));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NL_AUTH_SHA2_SIGNATURE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct NL_AUTH_SHA2_SIGNATURE *r)
{
	uint32_t size_SequenceNumber_0 = 0;
	uint32_t size_Checksum_0 = 0;
	uint32_t size_Confounder_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 3));
			NDR_CHECK(ndr_pull_NL_SIGNATURE_ALGORITHM(ndr, NDR_SCALARS, &r->SignatureAlgorithm));
			NDR_CHECK(ndr_pull_NL_SEAL_ALGORITHM(ndr, NDR_SCALARS, &r->SealAlgorithm));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Pad));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Flags));
			size_SequenceNumber_0 = 8;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->SequenceNumber, size_SequenceNumber_0));
			size_Checksum_0 = 32;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Checksum, size_Checksum_0));
			size_Confounder_0 = 8;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Confounder, size_Confounder_0));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 3));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_NL_AUTH_SHA2_SIGNATURE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct NL_AUTH_SHA2_SIGNATURE *r)
{
	ndr_print_NL_AUTH_SHA2_SIGNATURE(ndr, name, r);
}

_PUBLIC_ void ndr_print_NL_AUTH_SHA2_SIGNATURE(struct ndr_print *ndr, const char *name, const struct NL_AUTH_SHA2_SIGNATURE *r)
{
	ndr_print_struct(ndr, name, "NL_AUTH_SHA2_SIGNATURE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_NL_SIGNATURE_ALGORITHM(ndr, "SignatureAlgorithm", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NL_SIGN_HMAC_SHA256:r->SignatureAlgorithm);
		ndr_print_NL_SEAL_ALGORITHM(ndr, "SealAlgorithm", r->SealAlgorithm);
		ndr_print_uint16(ndr, "Pad", r->Pad);
		ndr_print_uint16(ndr, "Flags", r->Flags);
		ndr_print_array_uint8(ndr, "SequenceNumber", r->SequenceNumber, 8);
		ndr_print_array_uint8(ndr, "Checksum", r->Checksum, 32);
		ndr_print_array_uint8(ndr, "Confounder", r->Confounder, 8);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

#ifndef SKIP_NDR_TABLE_schannel
static const struct ndr_interface_public_struct schannel_public_structs[] = {
	{
		.name = "netlogon_creds_CredentialState",
		.struct_size = sizeof(struct netlogon_creds_CredentialState ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_netlogon_creds_CredentialState,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_netlogon_creds_CredentialState,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_netlogon_creds_CredentialState,
	},
	{
		.name = "netlogon_cache_entry",
		.struct_size = sizeof(struct netlogon_cache_entry ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_netlogon_cache_entry,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_netlogon_cache_entry,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_netlogon_cache_entry,
	},
	{
		.name = "NL_AUTH_MESSAGE",
		.struct_size = sizeof(struct NL_AUTH_MESSAGE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_NL_AUTH_MESSAGE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_NL_AUTH_MESSAGE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_NL_AUTH_MESSAGE,
	},
	{
		.name = "NL_AUTH_SIGNATURE",
		.struct_size = sizeof(struct NL_AUTH_SIGNATURE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_NL_AUTH_SIGNATURE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_NL_AUTH_SIGNATURE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_NL_AUTH_SIGNATURE,
	},
	{
		.name = "NL_AUTH_SHA2_SIGNATURE",
		.struct_size = sizeof(struct NL_AUTH_SHA2_SIGNATURE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_NL_AUTH_SHA2_SIGNATURE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_NL_AUTH_SHA2_SIGNATURE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_NL_AUTH_SHA2_SIGNATURE,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call schannel_calls[] = {
	{ .name = NULL }
};

static const char * const schannel_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\schannel]", 
};

static const struct ndr_interface_string_array schannel_endpoints = {
	.count	= 1,
	.names	= schannel_endpoint_strings
};

static const char * const schannel_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array schannel_authservices = {
	.count	= 1,
	.names	= schannel_authservice_strings
};


const struct ndr_interface_table ndr_table_schannel = {
	.name		= "schannel",
	.num_calls	= 0,
	.calls		= schannel_calls,
	.num_public_structs	= 5,
	.public_structs		= schannel_public_structs,
	.endpoints	= &schannel_endpoints,
	.authservices	= &schannel_authservices
};

#endif /* SKIP_NDR_TABLE_schannel */
