/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the X86 target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 142;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(X86InstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(X86InstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static X86InstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static X86InstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s1,
  GILLT_s8,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_s80,
  GILLT_s128,
  GILLT_v2s1,
  GILLT_v2s64,
  GILLT_v4s1,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v8s1,
  GILLT_v8s16,
  GILLT_v8s32,
  GILLT_v8s64,
  GILLT_v16s1,
  GILLT_v16s8,
  GILLT_v16s16,
  GILLT_v16s32,
  GILLT_v32s1,
  GILLT_v32s8,
  GILLT_v32s16,
  GILLT_v64s1,
  GILLT_v64s8,
};
const static size_t NumTypeObjects = 25;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
  LLT::scalar(8),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(80),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 1),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 1),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(8), 1),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 32),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(16), 1),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getFixed(16), 16),
  LLT::vector(ElementCount::getFixed(16), 32),
  LLT::vector(ElementCount::getFixed(32), 1),
  LLT::vector(ElementCount::getFixed(32), 8),
  LLT::vector(ElementCount::getFixed(32), 16),
  LLT::vector(ElementCount::getFixed(64), 1),
  LLT::vector(ElementCount::getFixed(64), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_TruePredicateBit = 60,
  Feature_HasEGPRBit = 5,
  Feature_NoEGPRBit = 4,
  Feature_HasNDDBit = 6,
  Feature_NoNDDBit = 26,
  Feature_HasCFBit = 29,
  Feature_HasCMOVBit = 28,
  Feature_NoCMOVBit = 128,
  Feature_HasMMXBit = 104,
  Feature_HasSSE1Bit = 46,
  Feature_UseSSE1Bit = 53,
  Feature_HasSSE2Bit = 45,
  Feature_UseSSE2Bit = 54,
  Feature_HasSSE3Bit = 37,
  Feature_UseSSE3Bit = 63,
  Feature_HasSSSE3Bit = 105,
  Feature_UseSSSE3Bit = 64,
  Feature_UseSSE41Bit = 61,
  Feature_UseSSE42Bit = 67,
  Feature_HasSSE4ABit = 77,
  Feature_NoAVXBit = 73,
  Feature_HasAVXBit = 55,
  Feature_HasAVX2Bit = 49,
  Feature_HasAVX1OnlyBit = 47,
  Feature_HasEVEX512Bit = 135,
  Feature_HasAVX512Bit = 90,
  Feature_UseAVXBit = 51,
  Feature_NoAVX512Bit = 42,
  Feature_HasCDIBit = 94,
  Feature_HasVPOPCNTDQBit = 98,
  Feature_HasDQIBit = 92,
  Feature_NoDQIBit = 65,
  Feature_HasBWIBit = 93,
  Feature_NoBWIBit = 62,
  Feature_HasVLXBit = 91,
  Feature_NoVLXBit = 41,
  Feature_NoVLX_Or_NoBWIBit = 59,
  Feature_HasVNNIBit = 100,
  Feature_HasVP2INTERSECTBit = 102,
  Feature_HasBF16Bit = 103,
  Feature_HasFP16Bit = 96,
  Feature_HasAVXVNNIINT16Bit = 89,
  Feature_HasAVXVNNIINT8Bit = 84,
  Feature_HasAVXVNNIBit = 78,
  Feature_NoVLX_Or_NoVNNIBit = 79,
  Feature_HasBITALGBit = 101,
  Feature_HasPOPCNTBit = 66,
  Feature_HasAESBit = 70,
  Feature_HasVAESBit = 72,
  Feature_NoVLX_Or_NoVAESBit = 71,
  Feature_HasFXSRBit = 38,
  Feature_HasX87Bit = 36,
  Feature_HasXSAVEBit = 117,
  Feature_HasXSAVEOPTBit = 118,
  Feature_HasXSAVECBit = 119,
  Feature_HasXSAVESBit = 120,
  Feature_HasPCLMULBit = 74,
  Feature_NoVLX_Or_NoVPCLMULQDQBit = 75,
  Feature_HasVPCLMULQDQBit = 76,
  Feature_HasGFNIBit = 81,
  Feature_HasFMABit = 39,
  Feature_HasFMA4Bit = 43,
  Feature_NoFMA4Bit = 40,
  Feature_HasXOPBit = 44,
  Feature_HasTBMBit = 25,
  Feature_NoTBMBit = 133,
  Feature_HasLWPBit = 12,
  Feature_HasMOVBEBit = 3,
  Feature_NoNDD_Or_NoMOVBEBit = 2,
  Feature_HasRDRANDBit = 7,
  Feature_HasF16CBit = 80,
  Feature_HasFSGSBaseBit = 121,
  Feature_HasLZCNTBit = 9,
  Feature_HasBMIBit = 10,
  Feature_HasBMI2Bit = 11,
  Feature_NoBMI2Bit = 132,
  Feature_HasVBMIBit = 95,
  Feature_HasVBMI2Bit = 99,
  Feature_HasIFMABit = 97,
  Feature_HasAVXIFMABit = 82,
  Feature_NoVLX_Or_NoIFMABit = 83,
  Feature_HasRTMBit = 107,
  Feature_HasSHABit = 69,
  Feature_HasSHA512Bit = 86,
  Feature_HasSM3Bit = 87,
  Feature_HasRDSEEDBit = 8,
  Feature_HasSSEPrefetchBit = 56,
  Feature_HasPREFETCHIBit = 20,
  Feature_HasPrefetchWBit = 106,
  Feature_HasMWAITXBit = 131,
  Feature_HasCLDEMOTEBit = 24,
  Feature_HasMOVDIRIBit = 14,
  Feature_HasMOVDIR64BBit = 15,
  Feature_HasPTWRITEBit = 124,
  Feature_FPStackf32Bit = 34,
  Feature_FPStackf64Bit = 35,
  Feature_HasSM4Bit = 88,
  Feature_HasCLFLUSHBit = 57,
  Feature_HasCLFLUSHOPTBit = 22,
  Feature_HasCLWBBit = 23,
  Feature_HasWBNOINVDBit = 116,
  Feature_HasRDPIDBit = 123,
  Feature_HasWAITPKGBit = 13,
  Feature_HasINVPCIDBit = 122,
  Feature_HasCX8Bit = 129,
  Feature_HasCX16Bit = 130,
  Feature_HasENQCMDBit = 16,
  Feature_HasAMXFP16Bit = 112,
  Feature_HasCMPCCXADDBit = 21,
  Feature_HasAVXNECONVERTBit = 85,
  Feature_HasKLBit = 108,
  Feature_HasRAOINTBit = 114,
  Feature_HasSERIALIZEBit = 17,
  Feature_HasTSXLDTRKBit = 18,
  Feature_HasAMXTILEBit = 109,
  Feature_HasAMXBF16Bit = 111,
  Feature_HasAMXINT8Bit = 110,
  Feature_HasAMXCOMPLEXBit = 113,
  Feature_HasUINTRBit = 19,
  Feature_HasUSERMSRBit = 115,
  Feature_HasCRC32Bit = 68,
  Feature_Not64BitModeBit = 0,
  Feature_In64BitModeBit = 1,
  Feature_IsLP64Bit = 126,
  Feature_NotLP64Bit = 125,
  Feature_NotWin64WithoutFPBit = 127,
  Feature_IsPSBit = 137,
  Feature_NotPSBit = 136,
  Feature_KernelCodeBit = 138,
  Feature_NearDataBit = 140,
  Feature_IsNotPICBit = 139,
  Feature_OptForSizeBit = 50,
  Feature_OptForMinSizeBit = 48,
  Feature_OptForSpeedBit = 134,
  Feature_UseIncDecBit = 27,
  Feature_NoSSE41_Or_OptForSizeBit = 52,
  Feature_CallImmAddrBit = 141,
  Feature_FavorMemIndirectCallBit = 30,
  Feature_HasFastSHLDRotateBit = 33,
  Feature_HasMFenceBit = 58,
  Feature_UseIndirectThunkCallsBit = 32,
  Feature_NotUseIndirectThunkCallsBit = 31,
};

PredicateBitset X86InstructionSelector::
computeAvailableModuleFeatures(const X86Subtarget *Subtarget) const {
  PredicateBitset Features{};
  if (true)
    Features.set(Feature_TruePredicateBit);
  if (Subtarget->hasEGPR())
    Features.set(Feature_HasEGPRBit);
  if (!Subtarget->hasEGPR())
    Features.set(Feature_NoEGPRBit);
  if (Subtarget->hasNDD())
    Features.set(Feature_HasNDDBit);
  if (!Subtarget->hasNDD())
    Features.set(Feature_NoNDDBit);
  if (Subtarget->hasCF())
    Features.set(Feature_HasCFBit);
  if (Subtarget->canUseCMOV())
    Features.set(Feature_HasCMOVBit);
  if (!Subtarget->canUseCMOV())
    Features.set(Feature_NoCMOVBit);
  if (Subtarget->hasMMX())
    Features.set(Feature_HasMMXBit);
  if (Subtarget->hasSSE1())
    Features.set(Feature_HasSSE1Bit);
  if (Subtarget->hasSSE1() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE1Bit);
  if (Subtarget->hasSSE2())
    Features.set(Feature_HasSSE2Bit);
  if (Subtarget->hasSSE2() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE2Bit);
  if (Subtarget->hasSSE3())
    Features.set(Feature_HasSSE3Bit);
  if (Subtarget->hasSSE3() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE3Bit);
  if (Subtarget->hasSSSE3())
    Features.set(Feature_HasSSSE3Bit);
  if (Subtarget->hasSSSE3() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSSE3Bit);
  if (Subtarget->hasSSE41() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE41Bit);
  if (Subtarget->hasSSE42() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE42Bit);
  if (Subtarget->hasSSE4A())
    Features.set(Feature_HasSSE4ABit);
  if (!Subtarget->hasAVX())
    Features.set(Feature_NoAVXBit);
  if (Subtarget->hasAVX())
    Features.set(Feature_HasAVXBit);
  if (Subtarget->hasAVX2())
    Features.set(Feature_HasAVX2Bit);
  if (Subtarget->hasAVX() && !Subtarget->hasAVX2())
    Features.set(Feature_HasAVX1OnlyBit);
  if (Subtarget->hasEVEX512())
    Features.set(Feature_HasEVEX512Bit);
  if (Subtarget->hasAVX512())
    Features.set(Feature_HasAVX512Bit);
  if (Subtarget->hasAVX() && !Subtarget->hasAVX512())
    Features.set(Feature_UseAVXBit);
  if (!Subtarget->hasAVX512())
    Features.set(Feature_NoAVX512Bit);
  if (Subtarget->hasCDI())
    Features.set(Feature_HasCDIBit);
  if (Subtarget->hasVPOPCNTDQ())
    Features.set(Feature_HasVPOPCNTDQBit);
  if (Subtarget->hasDQI())
    Features.set(Feature_HasDQIBit);
  if (!Subtarget->hasDQI())
    Features.set(Feature_NoDQIBit);
  if (Subtarget->hasBWI())
    Features.set(Feature_HasBWIBit);
  if (!Subtarget->hasBWI())
    Features.set(Feature_NoBWIBit);
  if (Subtarget->hasVLX())
    Features.set(Feature_HasVLXBit);
  if (!Subtarget->hasVLX())
    Features.set(Feature_NoVLXBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasBWI())
    Features.set(Feature_NoVLX_Or_NoBWIBit);
  if (Subtarget->hasVNNI())
    Features.set(Feature_HasVNNIBit);
  if (Subtarget->hasVP2INTERSECT())
    Features.set(Feature_HasVP2INTERSECTBit);
  if (Subtarget->hasBF16())
    Features.set(Feature_HasBF16Bit);
  if (Subtarget->hasFP16())
    Features.set(Feature_HasFP16Bit);
  if (Subtarget->hasAVXVNNIINT16())
    Features.set(Feature_HasAVXVNNIINT16Bit);
  if (Subtarget->hasAVXVNNIINT8())
    Features.set(Feature_HasAVXVNNIINT8Bit);
  if (Subtarget->hasAVXVNNI())
    Features.set(Feature_HasAVXVNNIBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVNNI())
    Features.set(Feature_NoVLX_Or_NoVNNIBit);
  if (Subtarget->hasBITALG())
    Features.set(Feature_HasBITALGBit);
  if (Subtarget->hasPOPCNT())
    Features.set(Feature_HasPOPCNTBit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasVAES())
    Features.set(Feature_HasVAESBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVAES())
    Features.set(Feature_NoVLX_Or_NoVAESBit);
  if (Subtarget->hasFXSR())
    Features.set(Feature_HasFXSRBit);
  if (Subtarget->hasX87())
    Features.set(Feature_HasX87Bit);
  if (Subtarget->hasXSAVE())
    Features.set(Feature_HasXSAVEBit);
  if (Subtarget->hasXSAVEOPT())
    Features.set(Feature_HasXSAVEOPTBit);
  if (Subtarget->hasXSAVEC())
    Features.set(Feature_HasXSAVECBit);
  if (Subtarget->hasXSAVES())
    Features.set(Feature_HasXSAVESBit);
  if (Subtarget->hasPCLMUL())
    Features.set(Feature_HasPCLMULBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVPCLMULQDQ())
    Features.set(Feature_NoVLX_Or_NoVPCLMULQDQBit);
  if (Subtarget->hasVPCLMULQDQ())
    Features.set(Feature_HasVPCLMULQDQBit);
  if (Subtarget->hasGFNI())
    Features.set(Feature_HasGFNIBit);
  if (Subtarget->hasFMA())
    Features.set(Feature_HasFMABit);
  if (Subtarget->hasFMA4())
    Features.set(Feature_HasFMA4Bit);
  if (!Subtarget->hasFMA4())
    Features.set(Feature_NoFMA4Bit);
  if (Subtarget->hasXOP())
    Features.set(Feature_HasXOPBit);
  if (Subtarget->hasTBM())
    Features.set(Feature_HasTBMBit);
  if (!Subtarget->hasTBM())
    Features.set(Feature_NoTBMBit);
  if (Subtarget->hasLWP())
    Features.set(Feature_HasLWPBit);
  if (Subtarget->hasMOVBE())
    Features.set(Feature_HasMOVBEBit);
  if (!Subtarget->hasNDD() || !Subtarget->hasMOVBE())
    Features.set(Feature_NoNDD_Or_NoMOVBEBit);
  if (Subtarget->hasRDRAND())
    Features.set(Feature_HasRDRANDBit);
  if (Subtarget->hasF16C())
    Features.set(Feature_HasF16CBit);
  if (Subtarget->hasFSGSBase())
    Features.set(Feature_HasFSGSBaseBit);
  if (Subtarget->hasLZCNT())
    Features.set(Feature_HasLZCNTBit);
  if (Subtarget->hasBMI())
    Features.set(Feature_HasBMIBit);
  if (Subtarget->hasBMI2())
    Features.set(Feature_HasBMI2Bit);
  if (!Subtarget->hasBMI2())
    Features.set(Feature_NoBMI2Bit);
  if (Subtarget->hasVBMI())
    Features.set(Feature_HasVBMIBit);
  if (Subtarget->hasVBMI2())
    Features.set(Feature_HasVBMI2Bit);
  if (Subtarget->hasIFMA())
    Features.set(Feature_HasIFMABit);
  if (Subtarget->hasAVXIFMA())
    Features.set(Feature_HasAVXIFMABit);
  if (!Subtarget->hasVLX() || !Subtarget->hasIFMA())
    Features.set(Feature_NoVLX_Or_NoIFMABit);
  if (Subtarget->hasRTM())
    Features.set(Feature_HasRTMBit);
  if (Subtarget->hasSHA())
    Features.set(Feature_HasSHABit);
  if (Subtarget->hasSHA512())
    Features.set(Feature_HasSHA512Bit);
  if (Subtarget->hasSM3())
    Features.set(Feature_HasSM3Bit);
  if (Subtarget->hasRDSEED())
    Features.set(Feature_HasRDSEEDBit);
  if (Subtarget->hasSSEPrefetch())
    Features.set(Feature_HasSSEPrefetchBit);
  if (Subtarget->hasPREFETCHI())
    Features.set(Feature_HasPREFETCHIBit);
  if (Subtarget->hasPrefetchW())
    Features.set(Feature_HasPrefetchWBit);
  if (Subtarget->hasMWAITX())
    Features.set(Feature_HasMWAITXBit);
  if (Subtarget->hasCLDEMOTE())
    Features.set(Feature_HasCLDEMOTEBit);
  if (Subtarget->hasMOVDIRI())
    Features.set(Feature_HasMOVDIRIBit);
  if (Subtarget->hasMOVDIR64B())
    Features.set(Feature_HasMOVDIR64BBit);
  if (Subtarget->hasPTWRITE())
    Features.set(Feature_HasPTWRITEBit);
  if (!Subtarget->hasSSE1())
    Features.set(Feature_FPStackf32Bit);
  if (!Subtarget->hasSSE2())
    Features.set(Feature_FPStackf64Bit);
  if (Subtarget->hasSM4())
    Features.set(Feature_HasSM4Bit);
  if (Subtarget->hasCLFLUSH())
    Features.set(Feature_HasCLFLUSHBit);
  if (Subtarget->hasCLFLUSHOPT())
    Features.set(Feature_HasCLFLUSHOPTBit);
  if (Subtarget->hasCLWB())
    Features.set(Feature_HasCLWBBit);
  if (Subtarget->hasWBNOINVD())
    Features.set(Feature_HasWBNOINVDBit);
  if (Subtarget->hasRDPID())
    Features.set(Feature_HasRDPIDBit);
  if (Subtarget->hasWAITPKG())
    Features.set(Feature_HasWAITPKGBit);
  if (Subtarget->hasINVPCID())
    Features.set(Feature_HasINVPCIDBit);
  if (Subtarget->hasCX8())
    Features.set(Feature_HasCX8Bit);
  if (Subtarget->hasCX16())
    Features.set(Feature_HasCX16Bit);
  if (Subtarget->hasENQCMD())
    Features.set(Feature_HasENQCMDBit);
  if (Subtarget->hasAMXFP16())
    Features.set(Feature_HasAMXFP16Bit);
  if (Subtarget->hasCMPCCXADD())
    Features.set(Feature_HasCMPCCXADDBit);
  if (Subtarget->hasAVXNECONVERT())
    Features.set(Feature_HasAVXNECONVERTBit);
  if (Subtarget->hasKL())
    Features.set(Feature_HasKLBit);
  if (Subtarget->hasRAOINT())
    Features.set(Feature_HasRAOINTBit);
  if (Subtarget->hasSERIALIZE())
    Features.set(Feature_HasSERIALIZEBit);
  if (Subtarget->hasTSXLDTRK())
    Features.set(Feature_HasTSXLDTRKBit);
  if (Subtarget->hasAMXTILE())
    Features.set(Feature_HasAMXTILEBit);
  if (Subtarget->hasAMXBF16())
    Features.set(Feature_HasAMXBF16Bit);
  if (Subtarget->hasAMXINT8())
    Features.set(Feature_HasAMXINT8Bit);
  if (Subtarget->hasAMXCOMPLEX())
    Features.set(Feature_HasAMXCOMPLEXBit);
  if (Subtarget->hasUINTR())
    Features.set(Feature_HasUINTRBit);
  if (Subtarget->hasUSERMSR())
    Features.set(Feature_HasUSERMSRBit);
  if (Subtarget->hasCRC32())
    Features.set(Feature_HasCRC32Bit);
  if (!Subtarget->is64Bit())
    Features.set(Feature_Not64BitModeBit);
  if (Subtarget->is64Bit())
    Features.set(Feature_In64BitModeBit);
  if (Subtarget->isTarget64BitLP64())
    Features.set(Feature_IsLP64Bit);
  if (!Subtarget->isTarget64BitLP64())
    Features.set(Feature_NotLP64Bit);
  if (Subtarget->isTargetPS())
    Features.set(Feature_IsPSBit);
  if (!Subtarget->isTargetPS())
    Features.set(Feature_NotPSBit);
  if (TM.getCodeModel() == CodeModel::Kernel)
    Features.set(Feature_KernelCodeBit);
  if (TM.getCodeModel() == CodeModel::Small ||TM.getCodeModel() == CodeModel::Kernel)
    Features.set(Feature_NearDataBit);
  if (!TM.isPositionIndependent())
    Features.set(Feature_IsNotPICBit);
  if (Subtarget->isLegalToCallImmediateAddr())
    Features.set(Feature_CallImmAddrBit);
  if (!Subtarget->slowTwoMemOps())
    Features.set(Feature_FavorMemIndirectCallBit);
  if (Subtarget->hasFastSHLDRotate())
    Features.set(Feature_HasFastSHLDRotateBit);
  if (Subtarget->hasMFence())
    Features.set(Feature_HasMFenceBit);
  if (Subtarget->useIndirectThunkCalls())
    Features.set(Feature_UseIndirectThunkCallsBit);
  if (!Subtarget->useIndirectThunkCalls())
    Features.set(Feature_NotUseIndirectThunkCallsBit);
  return Features;
}

void X86InstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const X86Subtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset X86InstructionSelector::
computeAvailableFunctionFeatures(const X86Subtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (!Subtarget->isTargetWin64() ||Subtarget->getFrameLowering()->hasFP(*MF))
    Features.set(Feature_NotWin64WithoutFPBit);
  if (shouldOptForSize(MF))
    Features.set(Feature_OptForSizeBit);
  if (MF->getFunction().hasMinSize())
    Features.set(Feature_OptForMinSizeBit);
  if (!shouldOptForSize(MF))
    Features.set(Feature_OptForSpeedBit);
  if (!Subtarget->slowIncDec() || shouldOptForSize(MF))
    Features.set(Feature_UseIncDecBit);
  if (shouldOptForSize(MF) || !Subtarget->hasSSE41())
    Features.set(Feature_NoSSE41_Or_OptForSizeBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_FPStackf32,
  GIFBS_FPStackf64,
  GIFBS_HasAVX,
  GIFBS_HasAVX1Only,
  GIFBS_HasAVX2,
  GIFBS_HasAVX512,
  GIFBS_HasAVXNECONVERT,
  GIFBS_HasAVXVNNIINT16,
  GIFBS_HasBITALG,
  GIFBS_HasBWI,
  GIFBS_HasCDI,
  GIFBS_HasDQI,
  GIFBS_HasFP16,
  GIFBS_HasFastSHLDRotate,
  GIFBS_HasKL,
  GIFBS_HasLWP,
  GIFBS_HasMFence,
  GIFBS_HasMMX,
  GIFBS_HasMOVBE,
  GIFBS_HasMWAITX,
  GIFBS_HasNDD,
  GIFBS_HasPTWRITE,
  GIFBS_HasRTM,
  GIFBS_HasSERIALIZE,
  GIFBS_HasSHA,
  GIFBS_HasSHA512,
  GIFBS_HasSM3,
  GIFBS_HasSM4,
  GIFBS_HasSSE1,
  GIFBS_HasSSE2,
  GIFBS_HasSSE3,
  GIFBS_HasSSE4A,
  GIFBS_HasTBM,
  GIFBS_HasTSXLDTRK,
  GIFBS_HasVLX,
  GIFBS_HasVPOPCNTDQ,
  GIFBS_HasWAITPKG,
  GIFBS_HasWBNOINVD,
  GIFBS_HasX87,
  GIFBS_HasXOP,
  GIFBS_In64BitMode,
  GIFBS_IsPS,
  GIFBS_NoDQI,
  GIFBS_NoNDD,
  GIFBS_NoNDD_Or_NoMOVBE,
  GIFBS_Not64BitMode,
  GIFBS_NotPS,
  GIFBS_UseAVX,
  GIFBS_UseSSE1,
  GIFBS_UseSSE2,
  GIFBS_UseSSE41,
  GIFBS_UseSSSE3,
  GIFBS_HasAES_HasAVX,
  GIFBS_HasAES_NoAVX,
  GIFBS_HasAMXBF16_In64BitMode,
  GIFBS_HasAMXCOMPLEX_In64BitMode,
  GIFBS_HasAMXFP16_In64BitMode,
  GIFBS_HasAMXINT8_In64BitMode,
  GIFBS_HasAMXTILE_In64BitMode,
  GIFBS_HasAVX_In64BitMode,
  GIFBS_HasAVX_NoBWI,
  GIFBS_HasAVX_NoVLX,
  GIFBS_HasAVX_NoVLX_Or_NoBWI,
  GIFBS_HasAVX2_NoVLX,
  GIFBS_HasAVX2_NoVLX_Or_NoBWI,
  GIFBS_HasAVX512_HasVAES,
  GIFBS_HasAVX512_HasVLX,
  GIFBS_HasAVX512_HasVPCLMULQDQ,
  GIFBS_HasAVX512_NoBWI,
  GIFBS_HasAVX512_NoDQI,
  GIFBS_HasBF16_HasVLX,
  GIFBS_HasBITALG_HasVLX,
  GIFBS_HasBMI_HasEGPR,
  GIFBS_HasBMI_NoEGPR,
  GIFBS_HasBMI2_HasEGPR,
  GIFBS_HasBMI2_NoEGPR,
  GIFBS_HasBWI_HasVLX,
  GIFBS_HasCDI_HasVLX,
  GIFBS_HasCRC32_NoEGPR,
  GIFBS_HasDQI_HasVLX,
  GIFBS_HasDQI_NoBWI,
  GIFBS_HasFMA4_NoAVX512,
  GIFBS_HasFMA4_NoVLX,
  GIFBS_HasFP16_HasVLX,
  GIFBS_HasFSGSBase_In64BitMode,
  GIFBS_HasNDD_In64BitMode,
  GIFBS_HasNDD_UseIncDec,
  GIFBS_HasPCLMUL_NoAVX,
  GIFBS_HasPTWRITE_In64BitMode,
  GIFBS_HasRDPID_In64BitMode,
  GIFBS_HasRDPID_Not64BitMode,
  GIFBS_HasUINTR_In64BitMode,
  GIFBS_HasUSERMSR_NoEGPR,
  GIFBS_HasVAES_HasVLX,
  GIFBS_HasVAES_NoVLX,
  GIFBS_HasVLX_HasVPCLMULQDQ,
  GIFBS_HasVLX_HasVPOPCNTDQ,
  GIFBS_HasVPCLMULQDQ_NoVLX,
  GIFBS_HasWAITPKG_In64BitMode,
  GIFBS_HasWAITPKG_Not64BitMode,
  GIFBS_In64BitMode_UseSSE2,
  GIFBS_NoNDD_UseIncDec,
  GIFBS_Not64BitMode_OptForSize,
  GIFBS_NotWin64WithoutFP_OptForMinSize,
  GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES,
  GIFBS_HasAVX_HasPCLMUL_NoVLX_Or_NoVPCLMULQDQ,
  GIFBS_HasAVX512_HasEVEX512_NoVLX,
  GIFBS_HasBITALG_HasEVEX512_NoVLX,
  GIFBS_HasBWI_HasEVEX512_NoVLX,
  GIFBS_HasCDI_HasEVEX512_NoVLX,
  GIFBS_HasCRC32_HasEGPR_In64BitMode,
  GIFBS_HasDQI_HasEVEX512_NoVLX,
  GIFBS_HasDQI_HasVLX_NoBWI,
  GIFBS_HasEGPR_HasUSERMSR_In64BitMode,
  GIFBS_HasEVEX512_HasVPOPCNTDQ_NoVLX,
  GIFBS_HasFMA_NoAVX512_NoFMA4,
  GIFBS_HasFMA_NoFMA4_NoVLX,
  GIFBS_HasMOVBE_HasNDD_In64BitMode,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_FPStackf32Bit, },
  {Feature_FPStackf64Bit, },
  {Feature_HasAVXBit, },
  {Feature_HasAVX1OnlyBit, },
  {Feature_HasAVX2Bit, },
  {Feature_HasAVX512Bit, },
  {Feature_HasAVXNECONVERTBit, },
  {Feature_HasAVXVNNIINT16Bit, },
  {Feature_HasBITALGBit, },
  {Feature_HasBWIBit, },
  {Feature_HasCDIBit, },
  {Feature_HasDQIBit, },
  {Feature_HasFP16Bit, },
  {Feature_HasFastSHLDRotateBit, },
  {Feature_HasKLBit, },
  {Feature_HasLWPBit, },
  {Feature_HasMFenceBit, },
  {Feature_HasMMXBit, },
  {Feature_HasMOVBEBit, },
  {Feature_HasMWAITXBit, },
  {Feature_HasNDDBit, },
  {Feature_HasPTWRITEBit, },
  {Feature_HasRTMBit, },
  {Feature_HasSERIALIZEBit, },
  {Feature_HasSHABit, },
  {Feature_HasSHA512Bit, },
  {Feature_HasSM3Bit, },
  {Feature_HasSM4Bit, },
  {Feature_HasSSE1Bit, },
  {Feature_HasSSE2Bit, },
  {Feature_HasSSE3Bit, },
  {Feature_HasSSE4ABit, },
  {Feature_HasTBMBit, },
  {Feature_HasTSXLDTRKBit, },
  {Feature_HasVLXBit, },
  {Feature_HasVPOPCNTDQBit, },
  {Feature_HasWAITPKGBit, },
  {Feature_HasWBNOINVDBit, },
  {Feature_HasX87Bit, },
  {Feature_HasXOPBit, },
  {Feature_In64BitModeBit, },
  {Feature_IsPSBit, },
  {Feature_NoDQIBit, },
  {Feature_NoNDDBit, },
  {Feature_NoNDD_Or_NoMOVBEBit, },
  {Feature_Not64BitModeBit, },
  {Feature_NotPSBit, },
  {Feature_UseAVXBit, },
  {Feature_UseSSE1Bit, },
  {Feature_UseSSE2Bit, },
  {Feature_UseSSE41Bit, },
  {Feature_UseSSSE3Bit, },
  {Feature_HasAESBit, Feature_HasAVXBit, },
  {Feature_HasAESBit, Feature_NoAVXBit, },
  {Feature_HasAMXBF16Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXCOMPLEXBit, Feature_In64BitModeBit, },
  {Feature_HasAMXFP16Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXINT8Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXTILEBit, Feature_In64BitModeBit, },
  {Feature_HasAVXBit, Feature_In64BitModeBit, },
  {Feature_HasAVXBit, Feature_NoBWIBit, },
  {Feature_HasAVXBit, Feature_NoVLXBit, },
  {Feature_HasAVXBit, Feature_NoVLX_Or_NoBWIBit, },
  {Feature_HasAVX2Bit, Feature_NoVLXBit, },
  {Feature_HasAVX2Bit, Feature_NoVLX_Or_NoBWIBit, },
  {Feature_HasAVX512Bit, Feature_HasVAESBit, },
  {Feature_HasAVX512Bit, Feature_HasVLXBit, },
  {Feature_HasAVX512Bit, Feature_HasVPCLMULQDQBit, },
  {Feature_HasAVX512Bit, Feature_NoBWIBit, },
  {Feature_HasAVX512Bit, Feature_NoDQIBit, },
  {Feature_HasBF16Bit, Feature_HasVLXBit, },
  {Feature_HasBITALGBit, Feature_HasVLXBit, },
  {Feature_HasBMIBit, Feature_HasEGPRBit, },
  {Feature_HasBMIBit, Feature_NoEGPRBit, },
  {Feature_HasBMI2Bit, Feature_HasEGPRBit, },
  {Feature_HasBMI2Bit, Feature_NoEGPRBit, },
  {Feature_HasBWIBit, Feature_HasVLXBit, },
  {Feature_HasCDIBit, Feature_HasVLXBit, },
  {Feature_HasCRC32Bit, Feature_NoEGPRBit, },
  {Feature_HasDQIBit, Feature_HasVLXBit, },
  {Feature_HasDQIBit, Feature_NoBWIBit, },
  {Feature_HasFMA4Bit, Feature_NoAVX512Bit, },
  {Feature_HasFMA4Bit, Feature_NoVLXBit, },
  {Feature_HasFP16Bit, Feature_HasVLXBit, },
  {Feature_HasFSGSBaseBit, Feature_In64BitModeBit, },
  {Feature_HasNDDBit, Feature_In64BitModeBit, },
  {Feature_HasNDDBit, Feature_UseIncDecBit, },
  {Feature_HasPCLMULBit, Feature_NoAVXBit, },
  {Feature_HasPTWRITEBit, Feature_In64BitModeBit, },
  {Feature_HasRDPIDBit, Feature_In64BitModeBit, },
  {Feature_HasRDPIDBit, Feature_Not64BitModeBit, },
  {Feature_HasUINTRBit, Feature_In64BitModeBit, },
  {Feature_HasUSERMSRBit, Feature_NoEGPRBit, },
  {Feature_HasVAESBit, Feature_HasVLXBit, },
  {Feature_HasVAESBit, Feature_NoVLXBit, },
  {Feature_HasVLXBit, Feature_HasVPCLMULQDQBit, },
  {Feature_HasVLXBit, Feature_HasVPOPCNTDQBit, },
  {Feature_HasVPCLMULQDQBit, Feature_NoVLXBit, },
  {Feature_HasWAITPKGBit, Feature_In64BitModeBit, },
  {Feature_HasWAITPKGBit, Feature_Not64BitModeBit, },
  {Feature_In64BitModeBit, Feature_UseSSE2Bit, },
  {Feature_NoNDDBit, Feature_UseIncDecBit, },
  {Feature_Not64BitModeBit, Feature_OptForSizeBit, },
  {Feature_NotWin64WithoutFPBit, Feature_OptForMinSizeBit, },
  {Feature_HasAESBit, Feature_HasAVXBit, Feature_NoVLX_Or_NoVAESBit, },
  {Feature_HasAVXBit, Feature_HasPCLMULBit, Feature_NoVLX_Or_NoVPCLMULQDQBit, },
  {Feature_HasAVX512Bit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasBITALGBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasBWIBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasCDIBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasCRC32Bit, Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasDQIBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasDQIBit, Feature_HasVLXBit, Feature_NoBWIBit, },
  {Feature_HasEGPRBit, Feature_HasUSERMSRBit, Feature_In64BitModeBit, },
  {Feature_HasEVEX512Bit, Feature_HasVPOPCNTDQBit, Feature_NoVLXBit, },
  {Feature_HasFMABit, Feature_NoAVX512Bit, Feature_NoFMA4Bit, },
  {Feature_HasFMABit, Feature_NoFMA4Bit, Feature_NoVLXBit, },
  {Feature_HasMOVBEBit, Feature_HasNDDBit, Feature_In64BitModeBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

X86InstructionSelector::ComplexMatcherMemFn
X86InstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
bool X86InstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_AndMask64 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_BTCBTSMask64,
  GICXXPred_I64_Predicate_BTRMask64,
  GICXXPred_I64_Predicate_i16immSExt8,
  GICXXPred_I64_Predicate_i32immSExt8,
  GICXXPred_I64_Predicate_i64immSExt8,
  GICXXPred_I64_Predicate_i64immSExt32,
  GICXXPred_I64_Predicate_i64immZExt32,
  GICXXPred_I64_Predicate_i64immZExt32SExt8,
  GICXXPred_I64_Predicate_i64timmSExt32,
  GICXXPred_I64_Predicate_immff00_ffff,
};
bool X86InstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_AndMask64: {
    
      return isMask_64(Imm) && !isUInt<32>(Imm);
    
  }
  case GICXXPred_I64_Predicate_BTCBTSMask64: {
    
      return !isInt<32>(Imm) && isPowerOf2_64(Imm);
    
  }
  case GICXXPred_I64_Predicate_BTRMask64: {
    
      return !isUInt<32>(Imm) && !isInt<32>(Imm) && isPowerOf2_64(~Imm);
    
  }
  case GICXXPred_I64_Predicate_i16immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i32immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immSExt32: {
     return isInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immZExt32: {
     return isUInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immZExt32SExt8: {
    
      return isUInt<32>(Imm) && isInt<8>(static_cast<int32_t>(Imm));
    
  }
  case GICXXPred_I64_Predicate_i64timmSExt32: {
     return isInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_immff00_ffff: {
    
      return Imm >= 0xff00 && Imm <= 0xffff;
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_fpimm0 = GICXXPred_Invalid + 1,
  GICXXPred_APFloat_Predicate_fpimm1,
  GICXXPred_APFloat_Predicate_fpimmneg0,
  GICXXPred_APFloat_Predicate_fpimmneg1,
};
bool X86InstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_fpimm0: {
    
      return Imm.isExactlyValue(+0.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm1: {
    
      return Imm.isExactlyValue(+1.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimmneg0: {
    
      return Imm.isExactlyValue(-0.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimmneg1: {
    
      return Imm.isExactlyValue(-1.0);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool X86InstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool X86InstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("X86InstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
X86InstructionSelector::CustomRendererFn
X86InstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool X86InstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool X86InstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("X86InstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *X86InstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(277), /*)*//*default:*//*Label 66*/ GIMT_Encode4(84900),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(906),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(3264),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(4856), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 3*/ GIMT_Encode4(6093),
    /*TargetOpcode::G_OR*//*Label 4*/ GIMT_Encode4(11889),
    /*TargetOpcode::G_XOR*//*Label 5*/ GIMT_Encode4(16257), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CONCAT_VECTORS*//*Label 6*/ GIMT_Encode4(24596), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 7*/ GIMT_Encode4(24763), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 8*/ GIMT_Encode4(26502),
    /*TargetOpcode::G_INTRINSIC_LLRINT*//*Label 9*/ GIMT_Encode4(27364), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 10*/ GIMT_Encode4(27758),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 11*/ GIMT_Encode4(34028), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 12*/ GIMT_Encode4(36788),
    /*TargetOpcode::G_TRUNC*//*Label 13*/ GIMT_Encode4(37223),
    /*TargetOpcode::G_CONSTANT*//*Label 14*/ GIMT_Encode4(38227),
    /*TargetOpcode::G_FCONSTANT*//*Label 15*/ GIMT_Encode4(38837), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 16*/ GIMT_Encode4(39290), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 17*/ GIMT_Encode4(40313),
    /*TargetOpcode::G_SHL*//*Label 18*/ GIMT_Encode4(41231),
    /*TargetOpcode::G_LSHR*//*Label 19*/ GIMT_Encode4(42419),
    /*TargetOpcode::G_ASHR*//*Label 20*/ GIMT_Encode4(43399),
    /*TargetOpcode::G_FSHL*//*Label 21*/ GIMT_Encode4(44379),
    /*TargetOpcode::G_FSHR*//*Label 22*/ GIMT_Encode4(44755),
    /*TargetOpcode::G_ROTR*//*Label 23*/ GIMT_Encode4(45131),
    /*TargetOpcode::G_ROTL*//*Label 24*/ GIMT_Encode4(47137),
    /*TargetOpcode::G_ICMP*//*Label 25*/ GIMT_Encode4(49145), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SELECT*//*Label 26*/ GIMT_Encode4(50802), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 27*/ GIMT_Encode4(58702),
    /*TargetOpcode::G_SMULH*//*Label 28*/ GIMT_Encode4(58949),
    /*TargetOpcode::G_UADDSAT*//*Label 29*/ GIMT_Encode4(59196),
    /*TargetOpcode::G_SADDSAT*//*Label 30*/ GIMT_Encode4(59646),
    /*TargetOpcode::G_USUBSAT*//*Label 31*/ GIMT_Encode4(60096),
    /*TargetOpcode::G_SSUBSAT*//*Label 32*/ GIMT_Encode4(60546), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 33*/ GIMT_Encode4(60996),
    /*TargetOpcode::G_FSUB*//*Label 34*/ GIMT_Encode4(62012),
    /*TargetOpcode::G_FMUL*//*Label 35*/ GIMT_Encode4(63028),
    /*TargetOpcode::G_FMA*//*Label 36*/ GIMT_Encode4(64044), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 37*/ GIMT_Encode4(65172), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 38*/ GIMT_Encode4(66188),
    /*TargetOpcode::G_FPEXT*//*Label 39*/ GIMT_Encode4(66311),
    /*TargetOpcode::G_FPTRUNC*//*Label 40*/ GIMT_Encode4(66881),
    /*TargetOpcode::G_FPTOSI*//*Label 41*/ GIMT_Encode4(67208),
    /*TargetOpcode::G_FPTOUI*//*Label 42*/ GIMT_Encode4(67705),
    /*TargetOpcode::G_SITOFP*//*Label 43*/ GIMT_Encode4(67907),
    /*TargetOpcode::G_UITOFP*//*Label 44*/ GIMT_Encode4(69169),
    /*TargetOpcode::G_FABS*//*Label 45*/ GIMT_Encode4(70019), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 46*/ GIMT_Encode4(70142),
    /*TargetOpcode::G_SMAX*//*Label 47*/ GIMT_Encode4(71251),
    /*TargetOpcode::G_UMIN*//*Label 48*/ GIMT_Encode4(72360),
    /*TargetOpcode::G_UMAX*//*Label 49*/ GIMT_Encode4(73469),
    /*TargetOpcode::G_ABS*//*Label 50*/ GIMT_Encode4(74578), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BR*//*Label 51*/ GIMT_Encode4(75451), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTTZ_ZERO_UNDEF*//*Label 52*/ GIMT_Encode4(75467),
    /*TargetOpcode::G_CTLZ*//*Label 53*/ GIMT_Encode4(75581), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 54*/ GIMT_Encode4(76255),
    /*TargetOpcode::G_BSWAP*//*Label 55*/ GIMT_Encode4(77563), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 56*/ GIMT_Encode4(77739), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FADD*//*Label 57*/ GIMT_Encode4(78691),
    /*TargetOpcode::G_STRICT_FSUB*//*Label 58*/ GIMT_Encode4(79707),
    /*TargetOpcode::G_STRICT_FMUL*//*Label 59*/ GIMT_Encode4(80723),
    /*TargetOpcode::G_STRICT_FDIV*//*Label 60*/ GIMT_Encode4(81739), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FMA*//*Label 61*/ GIMT_Encode4(82755),
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 62*/ GIMT_Encode4(83883), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_TRAP*//*Label 63*/ GIMT_Encode4(84835),
    /*TargetOpcode::G_DEBUGTRAP*//*Label 64*/ GIMT_Encode4(84848),
    /*TargetOpcode::G_UBSANTRAP*//*Label 65*/ GIMT_Encode4(84884),
    // Label 0: @906
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(25), /*)*//*default:*//*Label 83*/ GIMT_Encode4(3263),
    /*GILLT_s8*//*Label 67*/ GIMT_Encode4(1013),
    /*GILLT_s16*//*Label 68*/ GIMT_Encode4(1246),
    /*GILLT_s32*//*Label 69*/ GIMT_Encode4(1547),
    /*GILLT_s64*//*Label 70*/ GIMT_Encode4(1848), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 71*/ GIMT_Encode4(2239), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 72*/ GIMT_Encode4(2333),
    /*GILLT_v4s64*//*Label 73*/ GIMT_Encode4(2549), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 74*/ GIMT_Encode4(2616),
    /*GILLT_v8s32*//*Label 75*/ GIMT_Encode4(2832),
    /*GILLT_v8s64*//*Label 76*/ GIMT_Encode4(2899), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 77*/ GIMT_Encode4(2933),
    /*GILLT_v16s16*//*Label 78*/ GIMT_Encode4(3027),
    /*GILLT_v16s32*//*Label 79*/ GIMT_Encode4(3094), GIMT_Encode4(0),
    /*GILLT_v32s8*//*Label 80*/ GIMT_Encode4(3128),
    /*GILLT_v32s16*//*Label 81*/ GIMT_Encode4(3195), GIMT_Encode4(0),
    /*GILLT_v64s8*//*Label 82*/ GIMT_Encode4(3229),
    // Label 67: @1013
    GIM_Try, /*On fail goto*//*Label 84*/ GIMT_Encode4(1245),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 85*/ GIMT_Encode4(1056), // Rule ID 21273 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, 1:{ *:[i8] })  =>  (INC8r:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC8r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21273,
        GIR_EraseRootFromParent_Done,
      // Label 85: @1056
      GIM_Try, /*On fail goto*//*Label 86*/ GIMT_Encode4(1080), // Rule ID 21277 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, -1:{ *:[i8] })  =>  (DEC8r:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC8r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21277,
        GIR_EraseRootFromParent_Done,
      // Label 86: @1080
      GIM_Try, /*On fail goto*//*Label 87*/ GIMT_Encode4(1104), // Rule ID 21363 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, 1:{ *:[i8] })  =>  (INC8r_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC8r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21363,
        GIR_EraseRootFromParent_Done,
      // Label 87: @1104
      GIM_Try, /*On fail goto*//*Label 88*/ GIMT_Encode4(1128), // Rule ID 21367 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, -1:{ *:[i8] })  =>  (DEC8r_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC8r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21367,
        GIR_EraseRootFromParent_Done,
      // Label 88: @1128
      GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(1161), // Rule ID 21211 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (ADD8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21211,
        GIR_EraseRootFromParent_Done,
      // Label 89: @1161
      GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(1194), // Rule ID 21301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (ADD8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21301,
        GIR_EraseRootFromParent_Done,
      // Label 90: @1194
      GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(1219), // Rule ID 21203 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (ADD8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21203,
        GIR_Done,
      // Label 91: @1219
      GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(1244), // Rule ID 21293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (ADD8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21293,
        GIR_Done,
      // Label 92: @1244
      GIM_Reject,
    // Label 84: @1245
    GIM_Reject,
    // Label 68: @1246
    GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1546),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1299), // Rule ID 21013 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, 128:{ *:[i16] })  =>  (SUB16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, -128:{ *:[i16] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21013,
        GIR_EraseRootFromParent_Done,
      // Label 94: @1299
      GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1333), // Rule ID 21019 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, 128:{ *:[i16] })  =>  (SUB16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, -128:{ *:[i16] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21019,
        GIR_EraseRootFromParent_Done,
      // Label 95: @1333
      GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1357), // Rule ID 21274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, 1:{ *:[i16] })  =>  (INC16r:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC16r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21274,
        GIR_EraseRootFromParent_Done,
      // Label 96: @1357
      GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1381), // Rule ID 21278 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, -1:{ *:[i16] })  =>  (DEC16r:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC16r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21278,
        GIR_EraseRootFromParent_Done,
      // Label 97: @1381
      GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1405), // Rule ID 21364 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, 1:{ *:[i16] })  =>  (INC16r_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC16r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21364,
        GIR_EraseRootFromParent_Done,
      // Label 98: @1405
      GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1429), // Rule ID 21368 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, -1:{ *:[i16] })  =>  (DEC16r_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC16r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21368,
        GIR_EraseRootFromParent_Done,
      // Label 99: @1429
      GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1462), // Rule ID 21212 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (ADD16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21212,
        GIR_EraseRootFromParent_Done,
      // Label 100: @1462
      GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1495), // Rule ID 21302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (ADD16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21302,
        GIR_EraseRootFromParent_Done,
      // Label 101: @1495
      GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1520), // Rule ID 21204 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (ADD16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21204,
        GIR_Done,
      // Label 102: @1520
      GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1545), // Rule ID 21294 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (ADD16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21294,
        GIR_Done,
      // Label 103: @1545
      GIM_Reject,
    // Label 93: @1546
    GIM_Reject,
    // Label 69: @1547
    GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1847),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1600), // Rule ID 21014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, 128:{ *:[i32] })  =>  (SUB32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, -128:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21014,
        GIR_EraseRootFromParent_Done,
      // Label 105: @1600
      GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1634), // Rule ID 21020 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, 128:{ *:[i32] })  =>  (SUB32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, -128:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21020,
        GIR_EraseRootFromParent_Done,
      // Label 106: @1634
      GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1658), // Rule ID 21275 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] })  =>  (INC32r:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC32r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21275,
        GIR_EraseRootFromParent_Done,
      // Label 107: @1658
      GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(1682), // Rule ID 21279 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] })  =>  (DEC32r:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC32r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21279,
        GIR_EraseRootFromParent_Done,
      // Label 108: @1682
      GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(1706), // Rule ID 21365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] })  =>  (INC32r_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC32r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21365,
        GIR_EraseRootFromParent_Done,
      // Label 109: @1706
      GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(1730), // Rule ID 21369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] })  =>  (DEC32r_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC32r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21369,
        GIR_EraseRootFromParent_Done,
      // Label 110: @1730
      GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(1763), // Rule ID 21213 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (ADD32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21213,
        GIR_EraseRootFromParent_Done,
      // Label 111: @1763
      GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(1796), // Rule ID 21303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (ADD32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21303,
        GIR_EraseRootFromParent_Done,
      // Label 112: @1796
      GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1821), // Rule ID 21205 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (ADD32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21205,
        GIR_Done,
      // Label 113: @1821
      GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(1846), // Rule ID 21295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (ADD32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21295,
        GIR_Done,
      // Label 114: @1846
      GIM_Reject,
    // Label 104: @1847
    GIM_Reject,
    // Label 70: @1848
    GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(2238),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(1901), // Rule ID 21015 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 128:{ *:[i64] })  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -128:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21015,
        GIR_EraseRootFromParent_Done,
      // Label 116: @1901
      GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(1935), // Rule ID 21021 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 128:{ *:[i64] })  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -128:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21021,
        GIR_EraseRootFromParent_Done,
      // Label 117: @1935
      GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(1976), // Rule ID 21031 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(2147483648),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 2147483648:{ *:[i64] })  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -2147483648:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-2147483648),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21031,
        GIR_EraseRootFromParent_Done,
      // Label 118: @1976
      GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(2017), // Rule ID 21033 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(2147483648),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 2147483648:{ *:[i64] })  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -2147483648:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-2147483648),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21033,
        GIR_EraseRootFromParent_Done,
      // Label 119: @2017
      GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(2041), // Rule ID 21276 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] })  =>  (INC64r:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC64r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21276,
        GIR_EraseRootFromParent_Done,
      // Label 120: @2041
      GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(2065), // Rule ID 21280 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] })  =>  (DEC64r:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC64r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21280,
        GIR_EraseRootFromParent_Done,
      // Label 121: @2065
      GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(2089), // Rule ID 21366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] })  =>  (INC64r_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC64r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21366,
        GIR_EraseRootFromParent_Done,
      // Label 122: @2089
      GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(2113), // Rule ID 21370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] })  =>  (DEC64r_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC64r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21370,
        GIR_EraseRootFromParent_Done,
      // Label 123: @2113
      GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(2150), // Rule ID 21214 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (ADD64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21214,
        GIR_EraseRootFromParent_Done,
      // Label 124: @2150
      GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(2187), // Rule ID 21304 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (ADD64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21304,
        GIR_EraseRootFromParent_Done,
      // Label 125: @2187
      GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(2212), // Rule ID 21206 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (ADD64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21206,
        GIR_Done,
      // Label 126: @2212
      GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(2237), // Rule ID 21296 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (ADD64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21296,
        GIR_Done,
      // Label 127: @2237
      GIM_Reject,
    // Label 115: @2238
    GIM_Reject,
    // Label 71: @2239
    GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(2332),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(2277), // Rule ID 2488 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPADDQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2488,
        GIR_Done,
      // Label 129: @2277
      GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(2304), // Rule ID 2490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PADDQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2490,
        GIR_Done,
      // Label 130: @2304
      GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(2331), // Rule ID 4603 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (add:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPADDQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4603,
        GIR_Done,
      // Label 131: @2331
      GIM_Reject,
    // Label 128: @2332
    GIM_Reject,
    // Label 72: @2333
    GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(2548),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(2405), // Rule ID 16369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2), VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/2, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16369,
        GIR_EraseRootFromParent_Done,
      // Label 133: @2405
      GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(2466), // Rule ID 23610 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src3, (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2))  =>  (VPMACSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23610,
        GIR_EraseRootFromParent_Done,
      // Label 134: @2466
      GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(2493), // Rule ID 2482 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPADDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2482,
        GIR_Done,
      // Label 135: @2493
      GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(2520), // Rule ID 2484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PADDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2484,
        GIR_Done,
      // Label 136: @2520
      GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(2547), // Rule ID 4630 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (add:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPADDDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4630,
        GIR_Done,
      // Label 137: @2547
      GIM_Reject,
    // Label 132: @2548
    GIM_Reject,
    // Label 73: @2549
    GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(2615),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(2587), // Rule ID 2492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (add:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPADDQYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2492,
        GIR_Done,
      // Label 139: @2587
      GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(2614), // Rule ID 4594 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (add:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPADDQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4594,
        GIR_Done,
      // Label 140: @2614
      GIM_Reject,
    // Label 138: @2615
    GIM_Reject,
    // Label 74: @2616
    GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(2831),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(2688), // Rule ID 16368 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2), VR128:{ *:[v8i16] }:$src3)  =>  (VPMACSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/2, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16368,
        GIR_EraseRootFromParent_Done,
      // Label 142: @2688
      GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(2749), // Rule ID 23609 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src3, (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2))  =>  (VPMACSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23609,
        GIR_EraseRootFromParent_Done,
      // Label 143: @2749
      GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(2776), // Rule ID 2476 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPADDWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2476,
        GIR_Done,
      // Label 144: @2776
      GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(2803), // Rule ID 2478 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PADDWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2478,
        GIR_Done,
      // Label 145: @2803
      GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(2830), // Rule ID 4651 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (add:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPADDWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4651,
        GIR_Done,
      // Label 146: @2830
      GIM_Reject,
    // Label 141: @2831
    GIM_Reject,
    // Label 75: @2832
    GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(2898),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(2870), // Rule ID 2486 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (add:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPADDDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2486,
        GIR_Done,
      // Label 148: @2870
      GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(2897), // Rule ID 4621 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (add:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPADDDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4621,
        GIR_Done,
      // Label 149: @2897
      GIM_Reject,
    // Label 147: @2898
    GIM_Reject,
    // Label 76: @2899
    GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(2932), // Rule ID 4585 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (add:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPADDQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4585,
      GIR_Done,
    // Label 150: @2932
    GIM_Reject,
    // Label 77: @2933
    GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(3026),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(2971), // Rule ID 2470 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPADDBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2470,
        GIR_Done,
      // Label 152: @2971
      GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(2998), // Rule ID 2472 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PADDBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2472,
        GIR_Done,
      // Label 153: @2998
      GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(3025), // Rule ID 4669 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (add:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPADDBZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4669,
        GIR_Done,
      // Label 154: @3025
      GIM_Reject,
    // Label 151: @3026
    GIM_Reject,
    // Label 78: @3027
    GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(3093),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(3065), // Rule ID 2480 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (add:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPADDWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2480,
        GIR_Done,
      // Label 156: @3065
      GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(3092), // Rule ID 4645 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (add:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPADDWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4645,
        GIR_Done,
      // Label 157: @3092
      GIM_Reject,
    // Label 155: @3093
    GIM_Reject,
    // Label 79: @3094
    GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(3127), // Rule ID 4612 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (add:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPADDDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4612,
      GIR_Done,
    // Label 158: @3127
    GIM_Reject,
    // Label 80: @3128
    GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(3194),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(3166), // Rule ID 2474 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (add:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPADDBYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2474,
        GIR_Done,
      // Label 160: @3166
      GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(3193), // Rule ID 4663 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (add:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPADDBZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4663,
        GIR_Done,
      // Label 161: @3193
      GIM_Reject,
    // Label 159: @3194
    GIM_Reject,
    // Label 81: @3195
    GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(3228), // Rule ID 4639 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (add:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPADDWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4639,
      GIR_Done,
    // Label 162: @3228
    GIM_Reject,
    // Label 82: @3229
    GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(3262), // Rule ID 4657 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (add:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPADDBZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4657,
      GIR_Done,
    // Label 163: @3262
    GIM_Reject,
    // Label 83: @3263
    GIM_Reject,
    // Label 1: @3264
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(25), /*)*//*default:*//*Label 180*/ GIMT_Encode4(4855),
    /*GILLT_s8*//*Label 164*/ GIMT_Encode4(3371),
    /*GILLT_s16*//*Label 165*/ GIMT_Encode4(3545),
    /*GILLT_s32*//*Label 166*/ GIMT_Encode4(3719),
    /*GILLT_s64*//*Label 167*/ GIMT_Encode4(3893), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 168*/ GIMT_Encode4(4075), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 169*/ GIMT_Encode4(4169),
    /*GILLT_v4s64*//*Label 170*/ GIMT_Encode4(4263), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 171*/ GIMT_Encode4(4330),
    /*GILLT_v8s32*//*Label 172*/ GIMT_Encode4(4424),
    /*GILLT_v8s64*//*Label 173*/ GIMT_Encode4(4491), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 174*/ GIMT_Encode4(4525),
    /*GILLT_v16s16*//*Label 175*/ GIMT_Encode4(4619),
    /*GILLT_v16s32*//*Label 176*/ GIMT_Encode4(4686), GIMT_Encode4(0),
    /*GILLT_v32s8*//*Label 177*/ GIMT_Encode4(4720),
    /*GILLT_v32s16*//*Label 178*/ GIMT_Encode4(4787), GIMT_Encode4(0),
    /*GILLT_v64s8*//*Label 179*/ GIMT_Encode4(4821),
    // Label 164: @3371
    GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(3544),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(3411), // Rule ID 246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (sub:{ *:[i8] } 0:{ *:[i8] }, GR8:{ *:[i8] }:$src1)  =>  (NEG8r_NF_ND:{ *:[i8] } GR8:{ *:[i8] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG8r_NF_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 246,
        GIR_EraseRootFromParent_Done,
      // Label 182: @3411
      GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(3448), // Rule ID 21223 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (SUB8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21223,
        GIR_EraseRootFromParent_Done,
      // Label 183: @3448
      GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(3485), // Rule ID 21313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (SUB8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21313,
        GIR_EraseRootFromParent_Done,
      // Label 184: @3485
      GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(3514), // Rule ID 21215 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (SUB8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21215,
        GIR_Done,
      // Label 185: @3514
      GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(3543), // Rule ID 21305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (SUB8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21305,
        GIR_Done,
      // Label 186: @3543
      GIM_Reject,
    // Label 181: @3544
    GIM_Reject,
    // Label 165: @3545
    GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(3718),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(3585), // Rule ID 247 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (sub:{ *:[i16] } 0:{ *:[i16] }, GR16:{ *:[i16] }:$src1)  =>  (NEG16r_NF_ND:{ *:[i16] } GR16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG16r_NF_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 247,
        GIR_EraseRootFromParent_Done,
      // Label 188: @3585
      GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(3622), // Rule ID 21224 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (SUB16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21224,
        GIR_EraseRootFromParent_Done,
      // Label 189: @3622
      GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(3659), // Rule ID 21314 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (SUB16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21314,
        GIR_EraseRootFromParent_Done,
      // Label 190: @3659
      GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(3688), // Rule ID 21216 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (SUB16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21216,
        GIR_Done,
      // Label 191: @3688
      GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(3717), // Rule ID 21306 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (SUB16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21306,
        GIR_Done,
      // Label 192: @3717
      GIM_Reject,
    // Label 187: @3718
    GIM_Reject,
    // Label 166: @3719
    GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(3892),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(3759), // Rule ID 248 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (sub:{ *:[i32] } 0:{ *:[i32] }, GR32:{ *:[i32] }:$src1)  =>  (NEG32r_NF_ND:{ *:[i32] } GR32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG32r_NF_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 248,
        GIR_EraseRootFromParent_Done,
      // Label 194: @3759
      GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(3796), // Rule ID 21225 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (SUB32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21225,
        GIR_EraseRootFromParent_Done,
      // Label 195: @3796
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(3833), // Rule ID 21315 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (SUB32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21315,
        GIR_EraseRootFromParent_Done,
      // Label 196: @3833
      GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(3862), // Rule ID 21217 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (SUB32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21217,
        GIR_Done,
      // Label 197: @3862
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(3891), // Rule ID 21307 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (SUB32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21307,
        GIR_Done,
      // Label 198: @3891
      GIM_Reject,
    // Label 193: @3892
    GIM_Reject,
    // Label 167: @3893
    GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(4074),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(3933), // Rule ID 249 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (sub:{ *:[i64] } 0:{ *:[i64] }, GR64:{ *:[i64] }:$src1)  =>  (NEG64r_NF_ND:{ *:[i64] } GR64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG64r_NF_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 249,
        GIR_EraseRootFromParent_Done,
      // Label 200: @3933
      GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(3974), // Rule ID 21226 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21226,
        GIR_EraseRootFromParent_Done,
      // Label 201: @3974
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(4015), // Rule ID 21316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21316,
        GIR_EraseRootFromParent_Done,
      // Label 202: @4015
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(4044), // Rule ID 21218 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (SUB64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21218,
        GIR_Done,
      // Label 203: @4044
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(4073), // Rule ID 21308 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (SUB64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21308,
        GIR_Done,
      // Label 204: @4073
      GIM_Reject,
    // Label 199: @4074
    GIM_Reject,
    // Label 168: @4075
    GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(4168),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(4113), // Rule ID 2554 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPSUBQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2554,
        GIR_Done,
      // Label 206: @4113
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(4140), // Rule ID 2556 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PSUBQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2556,
        GIR_Done,
      // Label 207: @4140
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(4167), // Rule ID 4693 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (sub:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPSUBQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4693,
        GIR_Done,
      // Label 208: @4167
      GIM_Reject,
    // Label 205: @4168
    GIM_Reject,
    // Label 169: @4169
    GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(4262),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(4207), // Rule ID 2548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPSUBDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2548,
        GIR_Done,
      // Label 210: @4207
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(4234), // Rule ID 2550 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PSUBDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2550,
        GIR_Done,
      // Label 211: @4234
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(4261), // Rule ID 4720 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (sub:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPSUBDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4720,
        GIR_Done,
      // Label 212: @4261
      GIM_Reject,
    // Label 209: @4262
    GIM_Reject,
    // Label 170: @4263
    GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(4329),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(4301), // Rule ID 2558 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (sub:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPSUBQYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2558,
        GIR_Done,
      // Label 214: @4301
      GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(4328), // Rule ID 4684 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (sub:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPSUBQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4684,
        GIR_Done,
      // Label 215: @4328
      GIM_Reject,
    // Label 213: @4329
    GIM_Reject,
    // Label 171: @4330
    GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(4423),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(4368), // Rule ID 2542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPSUBWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2542,
        GIR_Done,
      // Label 217: @4368
      GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(4395), // Rule ID 2544 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PSUBWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2544,
        GIR_Done,
      // Label 218: @4395
      GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(4422), // Rule ID 4741 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (sub:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPSUBWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4741,
        GIR_Done,
      // Label 219: @4422
      GIM_Reject,
    // Label 216: @4423
    GIM_Reject,
    // Label 172: @4424
    GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(4490),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(4462), // Rule ID 2552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (sub:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPSUBDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2552,
        GIR_Done,
      // Label 221: @4462
      GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(4489), // Rule ID 4711 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (sub:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPSUBDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4711,
        GIR_Done,
      // Label 222: @4489
      GIM_Reject,
    // Label 220: @4490
    GIM_Reject,
    // Label 173: @4491
    GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(4524), // Rule ID 4675 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (sub:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPSUBQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4675,
      GIR_Done,
    // Label 223: @4524
    GIM_Reject,
    // Label 174: @4525
    GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(4618),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(4563), // Rule ID 2536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPSUBBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2536,
        GIR_Done,
      // Label 225: @4563
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(4590), // Rule ID 2538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PSUBBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2538,
        GIR_Done,
      // Label 226: @4590
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(4617), // Rule ID 4759 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (sub:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPSUBBZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4759,
        GIR_Done,
      // Label 227: @4617
      GIM_Reject,
    // Label 224: @4618
    GIM_Reject,
    // Label 175: @4619
    GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(4685),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(4657), // Rule ID 2546 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (sub:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPSUBWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2546,
        GIR_Done,
      // Label 229: @4657
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(4684), // Rule ID 4735 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (sub:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPSUBWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4735,
        GIR_Done,
      // Label 230: @4684
      GIM_Reject,
    // Label 228: @4685
    GIM_Reject,
    // Label 176: @4686
    GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(4719), // Rule ID 4702 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (sub:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPSUBDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4702,
      GIR_Done,
    // Label 231: @4719
    GIM_Reject,
    // Label 177: @4720
    GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(4786),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(4758), // Rule ID 2540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (sub:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPSUBBYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2540,
        GIR_Done,
      // Label 233: @4758
      GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(4785), // Rule ID 4753 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (sub:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPSUBBZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4753,
        GIR_Done,
      // Label 234: @4785
      GIM_Reject,
    // Label 232: @4786
    GIM_Reject,
    // Label 178: @4787
    GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(4820), // Rule ID 4729 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (sub:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPSUBWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4729,
      GIR_Done,
    // Label 235: @4820
    GIM_Reject,
    // Label 179: @4821
    GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(4854), // Rule ID 4747 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (sub:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPSUBBZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4747,
      GIR_Done,
    // Label 236: @4854
    GIM_Reject,
    // Label 180: @4855
    GIM_Reject,
    // Label 2: @4856
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(23), /*)*//*default:*//*Label 249*/ GIMT_Encode4(6092),
    /*GILLT_s16*//*Label 237*/ GIMT_Encode4(4951),
    /*GILLT_s32*//*Label 238*/ GIMT_Encode4(5052),
    /*GILLT_s64*//*Label 239*/ GIMT_Encode4(5153), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 240*/ GIMT_Encode4(5258), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 241*/ GIMT_Encode4(5463),
    /*GILLT_v4s64*//*Label 242*/ GIMT_Encode4(5557), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 243*/ GIMT_Encode4(5762),
    /*GILLT_v8s32*//*Label 244*/ GIMT_Encode4(5856),
    /*GILLT_v8s64*//*Label 245*/ GIMT_Encode4(5923), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s16*//*Label 246*/ GIMT_Encode4(5957),
    /*GILLT_v16s32*//*Label 247*/ GIMT_Encode4(6024), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v32s16*//*Label 248*/ GIMT_Encode4(6058),
    // Label 237: @4951
    GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(5051),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(5000), // Rule ID 21383 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (IMUL16rri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21383,
        GIR_EraseRootFromParent_Done,
      // Label 251: @5000
      GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(5025), // Rule ID 21231 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (IMUL16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21231,
        GIR_Done,
      // Label 252: @5025
      GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(5050), // Rule ID 21321 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (IMUL16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21321,
        GIR_Done,
      // Label 253: @5050
      GIM_Reject,
    // Label 250: @5051
    GIM_Reject,
    // Label 238: @5052
    GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(5152),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(5101), // Rule ID 21384 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (IMUL32rri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21384,
        GIR_EraseRootFromParent_Done,
      // Label 255: @5101
      GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(5126), // Rule ID 21232 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (IMUL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21232,
        GIR_Done,
      // Label 256: @5126
      GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(5151), // Rule ID 21322 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (IMUL32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21322,
        GIR_Done,
      // Label 257: @5151
      GIM_Reject,
    // Label 254: @5152
    GIM_Reject,
    // Label 239: @5153
    GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(5257),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(5206), // Rule ID 21385 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (IMUL64rri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21385,
        GIR_EraseRootFromParent_Done,
      // Label 259: @5206
      GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(5231), // Rule ID 21233 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (IMUL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21233,
        GIR_Done,
      // Label 260: @5231
      GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(5256), // Rule ID 21323 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (IMUL64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21323,
        GIR_Done,
      // Label 261: @5256
      GIM_Reject,
    // Label 258: @5257
    GIM_Reject,
    // Label 240: @5258
    GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(5462),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(5296), // Rule ID 4972 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (mul:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPMULLQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4972,
        GIR_Done,
      // Label 263: @5296
      GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(5461), // Rule ID 18578 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (mul:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (EXTRACT_SUBREG:{ *:[v2i64] } (VPMULLQZrr:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src1, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src2, sub_xmm:{ *:[i32] })), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/4, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/2, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 18578,
        GIR_EraseRootFromParent_Done,
      // Label 264: @5461
      GIM_Reject,
    // Label 262: @5462
    GIM_Reject,
    // Label 241: @5463
    GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(5556),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(5501), // Rule ID 3187 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPMULLDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3187,
        GIR_Done,
      // Label 266: @5501
      GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(5528), // Rule ID 3195 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE41),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PMULLDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PMULLDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3195,
        GIR_Done,
      // Label 267: @5528
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(5555), // Rule ID 4927 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (mul:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPMULLDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4927,
        GIR_Done,
      // Label 268: @5555
      GIM_Reject,
    // Label 265: @5556
    GIM_Reject,
    // Label 242: @5557
    GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(5761),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(5595), // Rule ID 4963 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (mul:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPMULLQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4963,
        GIR_Done,
      // Label 270: @5595
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(5760), // Rule ID 18576 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (mul:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (EXTRACT_SUBREG:{ *:[v4i64] } (VPMULLQZrr:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src1, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src2, sub_ymm:{ *:[i32] })), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/4, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 18576,
        GIR_EraseRootFromParent_Done,
      // Label 271: @5760
      GIM_Reject,
    // Label 269: @5761
    GIM_Reject,
    // Label 243: @5762
    GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(5855),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(5800), // Rule ID 2518 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPMULLWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2518,
        GIR_Done,
      // Label 273: @5800
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(5827), // Rule ID 2520 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PMULLWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PMULLWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2520,
        GIR_Done,
      // Label 274: @5827
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(5854), // Rule ID 4948 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (mul:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPMULLWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4948,
        GIR_Done,
      // Label 275: @5854
      GIM_Reject,
    // Label 272: @5855
    GIM_Reject,
    // Label 244: @5856
    GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(5922),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(5894), // Rule ID 3191 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (mul:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPMULLDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3191,
        GIR_Done,
      // Label 277: @5894
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(5921), // Rule ID 4918 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (mul:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPMULLDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4918,
        GIR_Done,
      // Label 278: @5921
      GIM_Reject,
    // Label 276: @5922
    GIM_Reject,
    // Label 245: @5923
    GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(5956), // Rule ID 4954 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (mul:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPMULLQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4954,
      GIR_Done,
    // Label 279: @5956
    GIM_Reject,
    // Label 246: @5957
    GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(6023),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(5995), // Rule ID 2522 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (mul:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPMULLWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2522,
        GIR_Done,
      // Label 281: @5995
      GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(6022), // Rule ID 4942 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (mul:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPMULLWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4942,
        GIR_Done,
      // Label 282: @6022
      GIM_Reject,
    // Label 280: @6023
    GIM_Reject,
    // Label 247: @6024
    GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(6057), // Rule ID 4909 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (mul:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPMULLDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4909,
      GIR_Done,
    // Label 283: @6057
    GIM_Reject,
    // Label 248: @6058
    GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(6091), // Rule ID 4936 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (mul:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPMULLWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4936,
      GIR_Done,
    // Label 284: @6091
    GIM_Reject,
    // Label 249: @6092
    GIM_Reject,
    // Label 3: @6093
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(25), /*)*//*default:*//*Label 308*/ GIMT_Encode4(11888),
    /*GILLT_s1*//*Label 285*/ GIMT_Encode4(6204),
    /*GILLT_s8*//*Label 286*/ GIMT_Encode4(6532),
    /*GILLT_s16*//*Label 287*/ GIMT_Encode4(6669),
    /*GILLT_s32*//*Label 288*/ GIMT_Encode4(7134),
    /*GILLT_s64*//*Label 289*/ GIMT_Encode4(8320), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s1*//*Label 290*/ GIMT_Encode4(9384),
    /*GILLT_v2s64*//*Label 291*/ GIMT_Encode4(9712),
    /*GILLT_v4s1*//*Label 292*/ GIMT_Encode4(9806),
    /*GILLT_v4s32*//*Label 293*/ GIMT_Encode4(10134),
    /*GILLT_v4s64*//*Label 294*/ GIMT_Encode4(10228),
    /*GILLT_v8s1*//*Label 295*/ GIMT_Encode4(10322),
    /*GILLT_v8s16*//*Label 296*/ GIMT_Encode4(10802),
    /*GILLT_v8s32*//*Label 297*/ GIMT_Encode4(10896),
    /*GILLT_v8s64*//*Label 298*/ GIMT_Encode4(10990),
    /*GILLT_v16s1*//*Label 299*/ GIMT_Encode4(11024),
    /*GILLT_v16s8*//*Label 300*/ GIMT_Encode4(11184),
    /*GILLT_v16s16*//*Label 301*/ GIMT_Encode4(11278),
    /*GILLT_v16s32*//*Label 302*/ GIMT_Encode4(11372),
    /*GILLT_v32s1*//*Label 303*/ GIMT_Encode4(11406),
    /*GILLT_v32s8*//*Label 304*/ GIMT_Encode4(11566),
    /*GILLT_v32s16*//*Label 305*/ GIMT_Encode4(11660),
    /*GILLT_v64s1*//*Label 306*/ GIMT_Encode4(11694),
    /*GILLT_v64s8*//*Label 307*/ GIMT_Encode4(11854),
    // Label 285: @6204
    GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(6531),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
      GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(6333), // Rule ID 18022 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v1i1] } (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }), VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 18022,
        GIR_EraseRootFromParent_Done,
      // Label 310: @6333
      GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(6447), // Rule ID 23787 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src2, (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 23787,
        GIR_EraseRootFromParent_Done,
      // Label 311: @6447
      GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(6530), // Rule ID 18018 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        // (and:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 18018,
        GIR_EraseRootFromParent_Done,
      // Label 312: @6530
      GIM_Reject,
    // Label 309: @6531
    GIM_Reject,
    // Label 286: @6532
    GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(6668),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(6584), // Rule ID 21269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (AND8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21269,
        GIR_EraseRootFromParent_Done,
      // Label 314: @6584
      GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(6617), // Rule ID 21359 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (AND8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21359,
        GIR_EraseRootFromParent_Done,
      // Label 315: @6617
      GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(6642), // Rule ID 21261 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (AND8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21261,
        GIR_Done,
      // Label 316: @6642
      GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(6667), // Rule ID 21351 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (AND8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21351,
        GIR_Done,
      // Label 317: @6667
      GIM_Reject,
    // Label 313: @6668
    GIM_Reject,
    // Label 287: @6669
    GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(7133),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(6786), // Rule ID 24456 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } (rotl:{ *:[i16] } -2:{ *:[i16] }, GR8:{ *:[i8] }:$src2), GR16:{ *:[i16] }:$src1)  =>  (BTR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24456,
        GIR_EraseRootFromParent_Done,
      // Label 319: @6786
      GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(6892), // Rule ID 21185 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (rotl:{ *:[i16] } -2:{ *:[i16] }, GR8:{ *:[i8] }:$src2))  =>  (BTR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21185,
        GIR_EraseRootFromParent_Done,
      // Label 320: @6892
      GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(6984), // Rule ID 21045 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, 255:{ *:[i16] })  =>  (EXTRACT_SUBREG:{ *:[i16] } (MOVZX32rr8:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i8] } GR16:{ *:[i16] }:$src1, sub_8bit:{ *:[i32] })), sub_16bit:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s8,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
        // GIR_Coverage, 21045,
        GIR_EraseRootFromParent_Done,
      // Label 321: @6984
      GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(7025), // Rule ID 21270 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (AND16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21270,
        GIR_EraseRootFromParent_Done,
      // Label 322: @7025
      GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(7066), // Rule ID 21360 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (AND16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21360,
        GIR_EraseRootFromParent_Done,
      // Label 323: @7066
      GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(7099), // Rule ID 21262 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (AND16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21262,
        GIR_Done,
      // Label 324: @7099
      GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(7132), // Rule ID 21352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (AND16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21352,
        GIR_Done,
      // Label 325: @7132
      GIM_Reject,
    // Label 318: @7133
    GIM_Reject,
    // Label 288: @7134
    GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(8319),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(7219), // Rule ID 23415 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLCIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23415,
        GIR_EraseRootFromParent_Done,
      // Label 327: @7219
      GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(7296), // Rule ID 23427 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (TZMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23427,
        GIR_EraseRootFromParent_Done,
      // Label 328: @7296
      GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(7373), // Rule ID 15858 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15858,
        GIR_EraseRootFromParent_Done,
      // Label 329: @7373
      GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(7450), // Rule ID 15870 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (TZMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15870,
        GIR_EraseRootFromParent_Done,
      // Label 330: @7450
      GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(7508), // Rule ID 23409 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23409,
        GIR_EraseRootFromParent_Done,
      // Label 331: @7508
      GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(7617), // Rule ID 24462 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GR8:{ *:[i8] }:$src2), GR32:{ *:[i32] }:$src1)  =>  (BTR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24462,
        GIR_EraseRootFromParent_Done,
      // Label 332: @7617
      GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(7671), // Rule ID 15852 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15852,
        GIR_EraseRootFromParent_Done,
      // Label 333: @7671
      GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(7780), // Rule ID 21191 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GR8:{ *:[i8] }:$src2))  =>  (BTR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21191,
        GIR_EraseRootFromParent_Done,
      // Label 334: @7780
      GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(7845), // Rule ID 21043 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, 65535:{ *:[i32] })  =>  (MOVZX32rr16:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i16] } GR32:{ *:[i32] }:$src1, sub_16bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(4), // src1
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21043,
        GIR_EraseRootFromParent_Done,
      // Label 335: @7845
      GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(7910), // Rule ID 21044 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, 255:{ *:[i32] })  =>  (MOVZX32rr8:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i8] } GR32:{ *:[i32] }:$src1, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src1
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21044,
        GIR_EraseRootFromParent_Done,
      // Label 336: @7910
      GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(7954), // Rule ID 21271 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (AND32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21271,
        GIR_EraseRootFromParent_Done,
      // Label 337: @7954
      GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(7998), // Rule ID 21361 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (AND32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21361,
        GIR_EraseRootFromParent_Done,
      // Label 338: @7998
      GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(8060), // Rule ID 16046 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src2)  =>  (ANDN32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16046,
        GIR_EraseRootFromParent_Done,
      // Label 339: @8060
      GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(8122), // Rule ID 16050 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src2)  =>  (ANDN32rr_EVEX:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16050,
        GIR_EraseRootFromParent_Done,
      // Label 340: @8122
      GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(8184), // Rule ID 23521 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src2, (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }))  =>  (ANDN32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23521,
        GIR_EraseRootFromParent_Done,
      // Label 341: @8184
      GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(8246), // Rule ID 23525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src2, (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }))  =>  (ANDN32rr_EVEX:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23525,
        GIR_EraseRootFromParent_Done,
      // Label 342: @8246
      GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(8282), // Rule ID 21263 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (AND32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21263,
        GIR_Done,
      // Label 343: @8282
      GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(8318), // Rule ID 21353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (AND32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21353,
        GIR_Done,
      // Label 344: @8318
      GIM_Reject,
    // Label 326: @8319
    GIM_Reject,
    // Label 289: @8320
    GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(9383),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(8405), // Rule ID 23416 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLCIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23416,
        GIR_EraseRootFromParent_Done,
      // Label 346: @8405
      GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(8482), // Rule ID 23428 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (TZMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23428,
        GIR_EraseRootFromParent_Done,
      // Label 347: @8482
      GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(8559), // Rule ID 15859 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15859,
        GIR_EraseRootFromParent_Done,
      // Label 348: @8559
      GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(8636), // Rule ID 15871 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (TZMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15871,
        GIR_EraseRootFromParent_Done,
      // Label 349: @8636
      GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(8694), // Rule ID 23410 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23410,
        GIR_EraseRootFromParent_Done,
      // Label 350: @8694
      GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(8803), // Rule ID 24468 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (rotl:{ *:[i64] } -2:{ *:[i64] }, GR8:{ *:[i8] }:$src2), GR64:{ *:[i64] }:$src1)  =>  (BTR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24468,
        GIR_EraseRootFromParent_Done,
      // Label 351: @8803
      GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(8857), // Rule ID 15853 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15853,
        GIR_EraseRootFromParent_Done,
      // Label 352: @8857
      GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(8966), // Rule ID 21197 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (rotl:{ *:[i64] } -2:{ *:[i64] }, GR8:{ *:[i8] }:$src2))  =>  (BTR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21197,
        GIR_EraseRootFromParent_Done,
      // Label 353: @8966
      GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(9014), // Rule ID 21272 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (AND64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21272,
        GIR_EraseRootFromParent_Done,
      // Label 354: @9014
      GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(9062), // Rule ID 21362 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (AND64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21362,
        GIR_EraseRootFromParent_Done,
      // Label 355: @9062
      GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(9124), // Rule ID 16047 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src2)  =>  (ANDN64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16047,
        GIR_EraseRootFromParent_Done,
      // Label 356: @9124
      GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(9186), // Rule ID 16051 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src2)  =>  (ANDN64rr_EVEX:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16051,
        GIR_EraseRootFromParent_Done,
      // Label 357: @9186
      GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(9248), // Rule ID 23522 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src2, (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }))  =>  (ANDN64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23522,
        GIR_EraseRootFromParent_Done,
      // Label 358: @9248
      GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(9310), // Rule ID 23526 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src2, (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }))  =>  (ANDN64rr_EVEX:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23526,
        GIR_EraseRootFromParent_Done,
      // Label 359: @9310
      GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(9346), // Rule ID 21264 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (AND64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21264,
        GIR_Done,
      // Label 360: @9346
      GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(9382), // Rule ID 21354 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (AND64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21354,
        GIR_Done,
      // Label 361: @9382
      GIM_Reject,
    // Label 345: @9383
    GIM_Reject,
    // Label 290: @9384
    GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(9711),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(9513), // Rule ID 18023 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i1] } (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }), VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 18023,
        GIR_EraseRootFromParent_Done,
      // Label 363: @9513
      GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(9627), // Rule ID 23788 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src2, (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 23788,
        GIR_EraseRootFromParent_Done,
      // Label 364: @9627
      GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(9710), // Rule ID 18019 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        // (and:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 18019,
        GIR_EraseRootFromParent_Done,
      // Label 365: @9710
      GIM_Reject,
    // Label 362: @9711
    GIM_Reject,
    // Label 291: @9712
    GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(9805),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(9750), // Rule ID 2098 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPANDrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2098,
        GIR_Done,
      // Label 367: @9750
      GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(9777), // Rule ID 2100 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PANDrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2100,
        GIR_Done,
      // Label 368: @9777
      GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(9804), // Rule ID 5656 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (and:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPANDQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5656,
        GIR_Done,
      // Label 369: @9804
      GIM_Reject,
    // Label 366: @9805
    GIM_Reject,
    // Label 292: @9806
    GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(10133),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(9935), // Rule ID 18024 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i1] } (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }), VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 18024,
        GIR_EraseRootFromParent_Done,
      // Label 371: @9935
      GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(10049), // Rule ID 23789 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src2, (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 23789,
        GIR_EraseRootFromParent_Done,
      // Label 372: @10049
      GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(10132), // Rule ID 18020 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        // (and:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 18020,
        GIR_EraseRootFromParent_Done,
      // Label 373: @10132
      GIM_Reject,
    // Label 370: @10133
    GIM_Reject,
    // Label 293: @10134
    GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(10227),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(10172), // Rule ID 5683 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (and:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPANDDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5683,
        GIR_Done,
      // Label 375: @10172
      GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(10199), // Rule ID 16658 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPANDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16658,
        GIR_Done,
      // Label 376: @10199
      GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(10226), // Rule ID 16682 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PANDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16682,
        GIR_Done,
      // Label 377: @10226
      GIM_Reject,
    // Label 374: @10227
    GIM_Reject,
    // Label 294: @10228
    GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(10321),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(10266), // Rule ID 2102 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPANDYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2102,
        GIR_Done,
      // Label 379: @10266
      GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(10293), // Rule ID 5647 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (and:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPANDQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5647,
        GIR_Done,
      // Label 380: @10293
      GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(10320), // Rule ID 16627 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VANDPSYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16627,
        GIR_Done,
      // Label 381: @10320
      GIM_Reject,
    // Label 378: @10321
    GIM_Reject,
    // Label 295: @10322
    GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(10801),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(10397), // Rule ID 4383 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (KANDNBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4383,
        GIR_EraseRootFromParent_Done,
      // Label 383: @10397
      GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(10514), // Rule ID 18021 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 18021,
        GIR_EraseRootFromParent_Done,
      // Label 384: @10514
      GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(10574), // Rule ID 22112 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (KANDNBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22112,
        GIR_EraseRootFromParent_Done,
      // Label 385: @10574
      GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(10691), // Rule ID 23786 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDNWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 23786,
        GIR_EraseRootFromParent_Done,
      // Label 386: @10691
      GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(10714), // Rule ID 4367 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KANDBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4367,
        GIR_Done,
      // Label 387: @10714
      GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(10800), // Rule ID 18017 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 18017,
        GIR_EraseRootFromParent_Done,
      // Label 388: @10800
      GIM_Reject,
    // Label 382: @10801
    GIM_Reject,
    // Label 296: @10802
    GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(10895),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(10840), // Rule ID 16657 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPANDrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16657,
        GIR_Done,
      // Label 390: @10840
      GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(10867), // Rule ID 16681 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PANDrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16681,
        GIR_Done,
      // Label 391: @10867
      GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(10894), // Rule ID 18597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (and:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPANDQZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18597,
        GIR_Done,
      // Label 392: @10894
      GIM_Reject,
    // Label 389: @10895
    GIM_Reject,
    // Label 297: @10896
    GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(10989),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(10934), // Rule ID 5674 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (and:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPANDDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5674,
        GIR_Done,
      // Label 394: @10934
      GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(10961), // Rule ID 16602 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPANDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16602,
        GIR_Done,
      // Label 395: @10961
      GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(10988), // Rule ID 16626 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VANDPSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16626,
        GIR_Done,
      // Label 396: @10988
      GIM_Reject,
    // Label 393: @10989
    GIM_Reject,
    // Label 298: @10990
    GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(11023), // Rule ID 5638 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (and:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPANDQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5638,
      GIR_Done,
    // Label 397: @11023
    GIM_Reject,
    // Label 299: @11024
    GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(11183),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(11099), // Rule ID 4384 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v16i1] } (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }), VK16:{ *:[v16i1] }:$src2)  =>  (KANDNWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4384,
        GIR_EraseRootFromParent_Done,
      // Label 399: @11099
      GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(11159), // Rule ID 22113 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src2, (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }))  =>  (KANDNWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22113,
        GIR_EraseRootFromParent_Done,
      // Label 400: @11159
      GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(11182), // Rule ID 4368 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        // (and:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KANDWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4368,
        GIR_Done,
      // Label 401: @11182
      GIM_Reject,
    // Label 398: @11183
    GIM_Reject,
    // Label 300: @11184
    GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(11277),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(11222), // Rule ID 16656 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPANDrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16656,
        GIR_Done,
      // Label 403: @11222
      GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(11249), // Rule ID 16680 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PANDrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16680,
        GIR_Done,
      // Label 404: @11249
      GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(11276), // Rule ID 18596 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (and:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPANDQZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18596,
        GIR_Done,
      // Label 405: @11276
      GIM_Reject,
    // Label 402: @11277
    GIM_Reject,
    // Label 301: @11278
    GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(11371),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(11316), // Rule ID 16601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPANDYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16601,
        GIR_Done,
      // Label 407: @11316
      GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(11343), // Rule ID 16625 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VANDPSYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16625,
        GIR_Done,
      // Label 408: @11343
      GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(11370), // Rule ID 18613 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (and:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPANDQZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18613,
        GIR_Done,
      // Label 409: @11370
      GIM_Reject,
    // Label 406: @11371
    GIM_Reject,
    // Label 302: @11372
    GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(11405), // Rule ID 5665 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (and:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPANDDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5665,
      GIR_Done,
    // Label 410: @11405
    GIM_Reject,
    // Label 303: @11406
    GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(11565),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(11481), // Rule ID 4385 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v32i1] } (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }), VK32:{ *:[v32i1] }:$src2)  =>  (KANDNDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4385,
        GIR_EraseRootFromParent_Done,
      // Label 412: @11481
      GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(11541), // Rule ID 22114 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src2, (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }))  =>  (KANDNDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22114,
        GIR_EraseRootFromParent_Done,
      // Label 413: @11541
      GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(11564), // Rule ID 4369 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        // (and:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)  =>  (KANDDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4369,
        GIR_Done,
      // Label 414: @11564
      GIM_Reject,
    // Label 411: @11565
    GIM_Reject,
    // Label 304: @11566
    GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(11659),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(11604), // Rule ID 16600 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPANDYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16600,
        GIR_Done,
      // Label 416: @11604
      GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(11631), // Rule ID 16624 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VANDPSYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16624,
        GIR_Done,
      // Label 417: @11631
      GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(11658), // Rule ID 18612 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (and:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPANDQZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18612,
        GIR_Done,
      // Label 418: @11658
      GIM_Reject,
    // Label 415: @11659
    GIM_Reject,
    // Label 305: @11660
    GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(11693), // Rule ID 18629 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (and:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPANDQZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18629,
      GIR_Done,
    // Label 419: @11693
    GIM_Reject,
    // Label 306: @11694
    GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(11853),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(11769), // Rule ID 4386 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v64i1] } (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }), VK64:{ *:[v64i1] }:$src2)  =>  (KANDNQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4386,
        GIR_EraseRootFromParent_Done,
      // Label 421: @11769
      GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(11829), // Rule ID 22115 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src2, (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }))  =>  (KANDNQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22115,
        GIR_EraseRootFromParent_Done,
      // Label 422: @11829
      GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(11852), // Rule ID 4370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        // (and:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)  =>  (KANDQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4370,
        GIR_Done,
      // Label 423: @11852
      GIM_Reject,
    // Label 420: @11853
    GIM_Reject,
    // Label 307: @11854
    GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(11887), // Rule ID 18628 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (and:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPANDQZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18628,
      GIR_Done,
    // Label 424: @11887
    GIM_Reject,
    // Label 308: @11888
    GIM_Reject,
    // Label 4: @11889
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(25), /*)*//*default:*//*Label 448*/ GIMT_Encode4(16256),
    /*GILLT_s1*//*Label 425*/ GIMT_Encode4(12000),
    /*GILLT_s8*//*Label 426*/ GIMT_Encode4(12094),
    /*GILLT_s16*//*Label 427*/ GIMT_Encode4(12231),
    /*GILLT_s32*//*Label 428*/ GIMT_Encode4(12584),
    /*GILLT_s64*//*Label 429*/ GIMT_Encode4(13768), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s1*//*Label 430*/ GIMT_Encode4(14960),
    /*GILLT_v2s64*//*Label 431*/ GIMT_Encode4(15054),
    /*GILLT_v4s1*//*Label 432*/ GIMT_Encode4(15148),
    /*GILLT_v4s32*//*Label 433*/ GIMT_Encode4(15242),
    /*GILLT_v4s64*//*Label 434*/ GIMT_Encode4(15336),
    /*GILLT_v8s1*//*Label 435*/ GIMT_Encode4(15430),
    /*GILLT_v8s16*//*Label 436*/ GIMT_Encode4(15548),
    /*GILLT_v8s32*//*Label 437*/ GIMT_Encode4(15642),
    /*GILLT_v8s64*//*Label 438*/ GIMT_Encode4(15736),
    /*GILLT_v16s1*//*Label 439*/ GIMT_Encode4(15770),
    /*GILLT_v16s8*//*Label 440*/ GIMT_Encode4(15804),
    /*GILLT_v16s16*//*Label 441*/ GIMT_Encode4(15898),
    /*GILLT_v16s32*//*Label 442*/ GIMT_Encode4(15992),
    /*GILLT_v32s1*//*Label 443*/ GIMT_Encode4(16026),
    /*GILLT_v32s8*//*Label 444*/ GIMT_Encode4(16060),
    /*GILLT_v32s16*//*Label 445*/ GIMT_Encode4(16154),
    /*GILLT_v64s1*//*Label 446*/ GIMT_Encode4(16188),
    /*GILLT_v64s8*//*Label 447*/ GIMT_Encode4(16222),
    // Label 425: @12000
    GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(12093), // Rule ID 18026 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
      // (or:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
      // GIR_Coverage, 18026,
      GIR_EraseRootFromParent_Done,
    // Label 449: @12093
    GIM_Reject,
    // Label 426: @12094
    GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(12230),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(12146), // Rule ID 21245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (OR8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21245,
        GIR_EraseRootFromParent_Done,
      // Label 451: @12146
      GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(12179), // Rule ID 21335 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (OR8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21335,
        GIR_EraseRootFromParent_Done,
      // Label 452: @12179
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(12204), // Rule ID 21237 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (OR8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21237,
        GIR_Done,
      // Label 453: @12204
      GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(12229), // Rule ID 21327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (OR8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21327,
        GIR_Done,
      // Label 454: @12229
      GIM_Reject,
    // Label 450: @12230
    GIM_Reject,
    // Label 427: @12231
    GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(12583),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(12348), // Rule ID 24457 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2), GR16:{ *:[i16] }:$src1)  =>  (BTS16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24457,
        GIR_EraseRootFromParent_Done,
      // Label 456: @12348
      GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(12450), // Rule ID 21186 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2))  =>  (BTS16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21186,
        GIR_EraseRootFromParent_Done,
      // Label 457: @12450
      GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(12487), // Rule ID 21246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (OR16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21246,
        GIR_EraseRootFromParent_Done,
      // Label 458: @12487
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(12524), // Rule ID 21336 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (OR16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21336,
        GIR_EraseRootFromParent_Done,
      // Label 459: @12524
      GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(12553), // Rule ID 21238 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (OR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21238,
        GIR_Done,
      // Label 460: @12553
      GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(12582), // Rule ID 21328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (OR16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21328,
        GIR_Done,
      // Label 461: @12582
      GIM_Reject,
    // Label 455: @12583
    GIM_Reject,
    // Label 428: @12584
    GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(13767),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(12669), // Rule ID 23423 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23423,
        GIR_EraseRootFromParent_Done,
      // Label 463: @12669
      GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(12746), // Rule ID 23425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (T1MSKC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23425,
        GIR_EraseRootFromParent_Done,
      // Label 464: @12746
      GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(12824), // Rule ID 23411 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), -1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23411,
        GIR_EraseRootFromParent_Done,
      // Label 465: @12824
      GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(12901), // Rule ID 15866 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15866,
        GIR_EraseRootFromParent_Done,
      // Label 466: @12901
      GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(12978), // Rule ID 15868 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (T1MSKC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15868,
        GIR_EraseRootFromParent_Done,
      // Label 467: @12978
      GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(13052), // Rule ID 15854 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (xor:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), -1:{ *:[i32] }))  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15854,
        GIR_EraseRootFromParent_Done,
      // Label 468: @13052
      GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(13110), // Rule ID 23419 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23419,
        GIR_EraseRootFromParent_Done,
      // Label 469: @13110
      GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(13168), // Rule ID 23421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLSFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23421,
        GIR_EraseRootFromParent_Done,
      // Label 470: @13168
      GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(13277), // Rule ID 24463 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2), GR32:{ *:[i32] }:$src1)  =>  (BTS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24463,
        GIR_EraseRootFromParent_Done,
      // Label 471: @13277
      GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(13335), // Rule ID 23413 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (sub:{ *:[i32] } -2:{ *:[i32] }, GR32:{ *:[i32] }:$src), GR32:{ *:[i32] }:$src)  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23413,
        GIR_EraseRootFromParent_Done,
      // Label 472: @13335
      GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(13389), // Rule ID 15862 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15862,
        GIR_EraseRootFromParent_Done,
      // Label 473: @13389
      GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(13443), // Rule ID 15864 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15864,
        GIR_EraseRootFromParent_Done,
      // Label 474: @13443
      GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(13552), // Rule ID 21192 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2))  =>  (BTS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21192,
        GIR_EraseRootFromParent_Done,
      // Label 475: @13552
      GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(13606), // Rule ID 15856 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (sub:{ *:[i32] } -2:{ *:[i32] }, GR32:{ *:[i32] }:$src))  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15856,
        GIR_EraseRootFromParent_Done,
      // Label 476: @13606
      GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(13650), // Rule ID 21247 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (OR32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21247,
        GIR_EraseRootFromParent_Done,
      // Label 477: @13650
      GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(13694), // Rule ID 21337 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (OR32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21337,
        GIR_EraseRootFromParent_Done,
      // Label 478: @13694
      GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(13730), // Rule ID 21239 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (OR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21239,
        GIR_Done,
      // Label 479: @13730
      GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(13766), // Rule ID 21329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (OR32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21329,
        GIR_Done,
      // Label 480: @13766
      GIM_Reject,
    // Label 462: @13767
    GIM_Reject,
    // Label 429: @13768
    GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(14959),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(13853), // Rule ID 23424 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23424,
        GIR_EraseRootFromParent_Done,
      // Label 482: @13853
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(13930), // Rule ID 23426 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (T1MSKC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23426,
        GIR_EraseRootFromParent_Done,
      // Label 483: @13930
      GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(14008), // Rule ID 23412 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (xor:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), -1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23412,
        GIR_EraseRootFromParent_Done,
      // Label 484: @14008
      GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(14085), // Rule ID 15867 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15867,
        GIR_EraseRootFromParent_Done,
      // Label 485: @14085
      GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(14162), // Rule ID 15869 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (T1MSKC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15869,
        GIR_EraseRootFromParent_Done,
      // Label 486: @14162
      GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(14236), // Rule ID 15855 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (xor:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), -1:{ *:[i64] }))  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15855,
        GIR_EraseRootFromParent_Done,
      // Label 487: @14236
      GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(14294), // Rule ID 23420 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23420,
        GIR_EraseRootFromParent_Done,
      // Label 488: @14294
      GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(14352), // Rule ID 23422 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLSFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23422,
        GIR_EraseRootFromParent_Done,
      // Label 489: @14352
      GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(14461), // Rule ID 24469 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2), GR64:{ *:[i64] }:$src1)  =>  (BTS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24469,
        GIR_EraseRootFromParent_Done,
      // Label 490: @14461
      GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(14519), // Rule ID 23414 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (sub:{ *:[i64] } -2:{ *:[i64] }, GR64:{ *:[i64] }:$src), GR64:{ *:[i64] }:$src)  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23414,
        GIR_EraseRootFromParent_Done,
      // Label 491: @14519
      GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(14573), // Rule ID 15863 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15863,
        GIR_EraseRootFromParent_Done,
      // Label 492: @14573
      GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(14627), // Rule ID 15865 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15865,
        GIR_EraseRootFromParent_Done,
      // Label 493: @14627
      GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(14736), // Rule ID 21198 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2))  =>  (BTS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21198,
        GIR_EraseRootFromParent_Done,
      // Label 494: @14736
      GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(14790), // Rule ID 15857 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (sub:{ *:[i64] } -2:{ *:[i64] }, GR64:{ *:[i64] }:$src))  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15857,
        GIR_EraseRootFromParent_Done,
      // Label 495: @14790
      GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(14838), // Rule ID 21248 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (OR64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21248,
        GIR_EraseRootFromParent_Done,
      // Label 496: @14838
      GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(14886), // Rule ID 21338 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (OR64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21338,
        GIR_EraseRootFromParent_Done,
      // Label 497: @14886
      GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(14922), // Rule ID 21240 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (OR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21240,
        GIR_Done,
      // Label 498: @14922
      GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(14958), // Rule ID 21330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (OR64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21330,
        GIR_Done,
      // Label 499: @14958
      GIM_Reject,
    // Label 481: @14959
    GIM_Reject,
    // Label 430: @14960
    GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(15053), // Rule ID 18027 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      // (or:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
      // GIR_Coverage, 18027,
      GIR_EraseRootFromParent_Done,
    // Label 500: @15053
    GIM_Reject,
    // Label 431: @15054
    GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(15147),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(15092), // Rule ID 2104 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2104,
        GIR_Done,
      // Label 502: @15092
      GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(15119), // Rule ID 2106 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2106,
        GIR_Done,
      // Label 503: @15119
      GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(15146), // Rule ID 5710 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (or:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPORQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5710,
        GIR_Done,
      // Label 504: @15146
      GIM_Reject,
    // Label 501: @15147
    GIM_Reject,
    // Label 432: @15148
    GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(15241), // Rule ID 18028 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      // (or:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
      // GIR_Coverage, 18028,
      GIR_EraseRootFromParent_Done,
    // Label 505: @15241
    GIM_Reject,
    // Label 433: @15242
    GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(15335),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(15280), // Rule ID 5737 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (or:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPORDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5737,
        GIR_Done,
      // Label 507: @15280
      GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(15307), // Rule ID 16661 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16661,
        GIR_Done,
      // Label 508: @15307
      GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(15334), // Rule ID 16685 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16685,
        GIR_Done,
      // Label 509: @15334
      GIM_Reject,
    // Label 506: @15335
    GIM_Reject,
    // Label 434: @15336
    GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(15429),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(15374), // Rule ID 2108 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPORYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2108,
        GIR_Done,
      // Label 511: @15374
      GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(15401), // Rule ID 5701 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (or:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPORQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5701,
        GIR_Done,
      // Label 512: @15401
      GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(15428), // Rule ID 16631 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VORPSYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16631,
        GIR_Done,
      // Label 513: @15428
      GIM_Reject,
    // Label 510: @15429
    GIM_Reject,
    // Label 435: @15430
    GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(15547),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(15468), // Rule ID 4371 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        // (or:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KORBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4371,
        GIR_Done,
      // Label 515: @15468
      GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(15546), // Rule ID 18025 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        // (or:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 18025,
        GIR_EraseRootFromParent_Done,
      // Label 516: @15546
      GIM_Reject,
    // Label 514: @15547
    GIM_Reject,
    // Label 436: @15548
    GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(15641),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(15586), // Rule ID 16660 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16660,
        GIR_Done,
      // Label 518: @15586
      GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(15613), // Rule ID 16684 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16684,
        GIR_Done,
      // Label 519: @15613
      GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(15640), // Rule ID 18599 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (or:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPORQZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18599,
        GIR_Done,
      // Label 520: @15640
      GIM_Reject,
    // Label 517: @15641
    GIM_Reject,
    // Label 437: @15642
    GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(15735),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(15680), // Rule ID 5728 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (or:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPORDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5728,
        GIR_Done,
      // Label 522: @15680
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(15707), // Rule ID 16605 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPORYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16605,
        GIR_Done,
      // Label 523: @15707
      GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(15734), // Rule ID 16630 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VORPSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16630,
        GIR_Done,
      // Label 524: @15734
      GIM_Reject,
    // Label 521: @15735
    GIM_Reject,
    // Label 438: @15736
    GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(15769), // Rule ID 5692 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (or:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPORQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5692,
      GIR_Done,
    // Label 525: @15769
    GIM_Reject,
    // Label 439: @15770
    GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(15803), // Rule ID 4372 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      // (or:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KORWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORWrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4372,
      GIR_Done,
    // Label 526: @15803
    GIM_Reject,
    // Label 440: @15804
    GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(15897),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(15842), // Rule ID 16659 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16659,
        GIR_Done,
      // Label 528: @15842
      GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(15869), // Rule ID 16683 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16683,
        GIR_Done,
      // Label 529: @15869
      GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(15896), // Rule ID 18598 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (or:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPORQZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18598,
        GIR_Done,
      // Label 530: @15896
      GIM_Reject,
    // Label 527: @15897
    GIM_Reject,
    // Label 441: @15898
    GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(15991),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(15936), // Rule ID 16604 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPORYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16604,
        GIR_Done,
      // Label 532: @15936
      GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(15963), // Rule ID 16629 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VORPSYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16629,
        GIR_Done,
      // Label 533: @15963
      GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(15990), // Rule ID 18615 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (or:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPORQZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18615,
        GIR_Done,
      // Label 534: @15990
      GIM_Reject,
    // Label 531: @15991
    GIM_Reject,
    // Label 442: @15992
    GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(16025), // Rule ID 5719 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (or:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPORDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5719,
      GIR_Done,
    // Label 535: @16025
    GIM_Reject,
    // Label 443: @16026
    GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(16059), // Rule ID 4373 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      // (or:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)  =>  (KORDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORDrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4373,
      GIR_Done,
    // Label 536: @16059
    GIM_Reject,
    // Label 444: @16060
    GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(16153),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(16098), // Rule ID 16603 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPORYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16603,
        GIR_Done,
      // Label 538: @16098
      GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(16125), // Rule ID 16628 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VORPSYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16628,
        GIR_Done,
      // Label 539: @16125
      GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(16152), // Rule ID 18614 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (or:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPORQZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18614,
        GIR_Done,
      // Label 540: @16152
      GIM_Reject,
    // Label 537: @16153
    GIM_Reject,
    // Label 445: @16154
    GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(16187), // Rule ID 18631 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (or:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPORQZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18631,
      GIR_Done,
    // Label 541: @16187
    GIM_Reject,
    // Label 446: @16188
    GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(16221), // Rule ID 4374 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      // (or:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)  =>  (KORQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORQrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4374,
      GIR_Done,
    // Label 542: @16221
    GIM_Reject,
    // Label 447: @16222
    GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(16255), // Rule ID 18630 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (or:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPORQZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18630,
      GIR_Done,
    // Label 543: @16255
    GIM_Reject,
    // Label 448: @16256
    GIM_Reject,
    // Label 5: @16257
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(25), /*)*//*default:*//*Label 567*/ GIMT_Encode4(24595),
    /*GILLT_s1*//*Label 544*/ GIMT_Encode4(16368),
    /*GILLT_s8*//*Label 545*/ GIMT_Encode4(16899),
    /*GILLT_s16*//*Label 546*/ GIMT_Encode4(17102),
    /*GILLT_s32*//*Label 547*/ GIMT_Encode4(17547),
    /*GILLT_s64*//*Label 548*/ GIMT_Encode4(18160), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s1*//*Label 549*/ GIMT_Encode4(18732),
    /*GILLT_v2s64*//*Label 550*/ GIMT_Encode4(19247),
    /*GILLT_v4s1*//*Label 551*/ GIMT_Encode4(19619),
    /*GILLT_v4s32*//*Label 552*/ GIMT_Encode4(20134),
    /*GILLT_v4s64*//*Label 553*/ GIMT_Encode4(20506),
    /*GILLT_v8s1*//*Label 554*/ GIMT_Encode4(20878),
    /*GILLT_v8s16*//*Label 555*/ GIMT_Encode4(21649),
    /*GILLT_v8s32*//*Label 556*/ GIMT_Encode4(22021),
    /*GILLT_v8s64*//*Label 557*/ GIMT_Encode4(22393),
    /*GILLT_v16s1*//*Label 558*/ GIMT_Encode4(22471),
    /*GILLT_v16s8*//*Label 559*/ GIMT_Encode4(22729),
    /*GILLT_v16s16*//*Label 560*/ GIMT_Encode4(23101),
    /*GILLT_v16s32*//*Label 561*/ GIMT_Encode4(23473),
    /*GILLT_v32s1*//*Label 562*/ GIMT_Encode4(23551),
    /*GILLT_v32s8*//*Label 563*/ GIMT_Encode4(23809),
    /*GILLT_v32s16*//*Label 564*/ GIMT_Encode4(24181),
    /*GILLT_v64s1*//*Label 565*/ GIMT_Encode4(24259),
    /*GILLT_v64s8*//*Label 566*/ GIMT_Encode4(24517),
    // Label 544: @16368
    GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(16898),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(16497), // Rule ID 23792 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v1i1] } (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }), VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 23792,
        GIR_EraseRootFromParent_Done,
      // Label 569: @16497
      GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(16616), // Rule ID 18030 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v1i1] } (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2), immAllOnesV:{ *:[v1i1] })  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 18030,
        GIR_EraseRootFromParent_Done,
      // Label 570: @16616
      GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(16734), // Rule ID 23793 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src2, (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 23793,
        GIR_EraseRootFromParent_Done,
      // Label 571: @16734
      GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(16810), // Rule ID 18016 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src, immAllOnesV:{ *:[v1i1] })  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KNOTWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KNOTWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 18016,
        GIR_EraseRootFromParent_Done,
      // Label 572: @16810
      GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(16897), // Rule ID 18034 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        // (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KXORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 18034,
        GIR_EraseRootFromParent_Done,
      // Label 573: @16897
      GIM_Reject,
    // Label 568: @16898
    GIM_Reject,
    // Label 545: @16899
    GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(17101),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(16942), // Rule ID 21010 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-128),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, -128:{ *:[i8] })  =>  (ADD8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, -128:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21010,
        GIR_EraseRootFromParent_Done,
      // Label 575: @16942
      GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(16963), // Rule ID 234 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, -1:{ *:[i8] })  =>  (NOT8r:{ *:[i8] } GR8:{ *:[i8] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT8r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 234,
        GIR_EraseRootFromParent_Done,
      // Label 576: @16963
      GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(16984), // Rule ID 242 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, -1:{ *:[i8] })  =>  (NOT8r_ND:{ *:[i8] } GR8:{ *:[i8] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT8r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 242,
        GIR_EraseRootFromParent_Done,
      // Label 577: @16984
      GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(17017), // Rule ID 21257 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (XOR8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21257,
        GIR_EraseRootFromParent_Done,
      // Label 578: @17017
      GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(17050), // Rule ID 21347 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (XOR8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21347,
        GIR_EraseRootFromParent_Done,
      // Label 579: @17050
      GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(17075), // Rule ID 21249 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (XOR8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21249,
        GIR_Done,
      // Label 580: @17075
      GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(17100), // Rule ID 21339 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (XOR8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21339,
        GIR_Done,
      // Label 581: @17100
      GIM_Reject,
    // Label 574: @17101
    GIM_Reject,
    // Label 546: @17102
    GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(17546),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(17159), // Rule ID 21011 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(-32768),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, -32768:{ *:[i16] })  =>  (ADD16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, -32768:{ *:[i16] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-32768),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21011,
        GIR_EraseRootFromParent_Done,
      // Label 583: @17159
      GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(17261), // Rule ID 24458 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i16] } (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2), GR16:{ *:[i16] }:$src1)  =>  (BTC16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24458,
        GIR_EraseRootFromParent_Done,
      // Label 584: @17261
      GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(17363), // Rule ID 21187 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2))  =>  (BTC16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21187,
        GIR_EraseRootFromParent_Done,
      // Label 585: @17363
      GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(17388), // Rule ID 235 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, -1:{ *:[i16] })  =>  (NOT16r:{ *:[i16] } GR16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT16r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 235,
        GIR_EraseRootFromParent_Done,
      // Label 586: @17388
      GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(17413), // Rule ID 243 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, -1:{ *:[i16] })  =>  (NOT16r_ND:{ *:[i16] } GR16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT16r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 243,
        GIR_EraseRootFromParent_Done,
      // Label 587: @17413
      GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(17450), // Rule ID 21258 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (XOR16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21258,
        GIR_EraseRootFromParent_Done,
      // Label 588: @17450
      GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(17487), // Rule ID 21348 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (XOR16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21348,
        GIR_EraseRootFromParent_Done,
      // Label 589: @17487
      GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(17516), // Rule ID 21250 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (XOR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21250,
        GIR_Done,
      // Label 590: @17516
      GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(17545), // Rule ID 21340 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (XOR16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21340,
        GIR_Done,
      // Label 591: @17545
      GIM_Reject,
    // Label 582: @17546
    GIM_Reject,
    // Label 547: @17547
    GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(18159),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(17604), // Rule ID 21012 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(-2147483648),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -2147483648:{ *:[i32] })  =>  (ADD32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, -2147483648:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-2147483648),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21012,
        GIR_EraseRootFromParent_Done,
      // Label 593: @17604
      GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(17662), // Rule ID 23417 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCMSK32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23417,
        GIR_EraseRootFromParent_Done,
      // Label 594: @17662
      GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(17771), // Rule ID 24464 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2), GR32:{ *:[i32] }:$src1)  =>  (BTC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24464,
        GIR_EraseRootFromParent_Done,
      // Label 595: @17771
      GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(17825), // Rule ID 15860 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCMSK32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15860,
        GIR_EraseRootFromParent_Done,
      // Label 596: @17825
      GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(17934), // Rule ID 21193 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2))  =>  (BTC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21193,
        GIR_EraseRootFromParent_Done,
      // Label 597: @17934
      GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(17966), // Rule ID 236 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] })  =>  (NOT32r:{ *:[i32] } GR32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT32r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 236,
        GIR_EraseRootFromParent_Done,
      // Label 598: @17966
      GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(17998), // Rule ID 244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] })  =>  (NOT32r_ND:{ *:[i32] } GR32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT32r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 244,
        GIR_EraseRootFromParent_Done,
      // Label 599: @17998
      GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(18042), // Rule ID 21259 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (XOR32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21259,
        GIR_EraseRootFromParent_Done,
      // Label 600: @18042
      GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(18086), // Rule ID 21349 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (XOR32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21349,
        GIR_EraseRootFromParent_Done,
      // Label 601: @18086
      GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(18122), // Rule ID 21251 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (XOR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21251,
        GIR_Done,
      // Label 602: @18122
      GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(18158), // Rule ID 21341 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (XOR32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21341,
        GIR_Done,
      // Label 603: @18158
      GIM_Reject,
    // Label 592: @18159
    GIM_Reject,
    // Label 548: @18160
    GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(18731),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(18226), // Rule ID 23418 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCMSK64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23418,
        GIR_EraseRootFromParent_Done,
      // Label 605: @18226
      GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(18335), // Rule ID 24470 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2), GR64:{ *:[i64] }:$src1)  =>  (BTC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24470,
        GIR_EraseRootFromParent_Done,
      // Label 606: @18335
      GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(18389), // Rule ID 15861 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCMSK64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15861,
        GIR_EraseRootFromParent_Done,
      // Label 607: @18389
      GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(18498), // Rule ID 21199 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2))  =>  (BTC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21199,
        GIR_EraseRootFromParent_Done,
      // Label 608: @18498
      GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(18530), // Rule ID 237 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] })  =>  (NOT64r:{ *:[i64] } GR64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT64r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 237,
        GIR_EraseRootFromParent_Done,
      // Label 609: @18530
      GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(18562), // Rule ID 245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] })  =>  (NOT64r_ND:{ *:[i64] } GR64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT64r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 245,
        GIR_EraseRootFromParent_Done,
      // Label 610: @18562
      GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(18610), // Rule ID 21260 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (XOR64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21260,
        GIR_EraseRootFromParent_Done,
      // Label 611: @18610
      GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(18658), // Rule ID 21350 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (XOR64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21350,
        GIR_EraseRootFromParent_Done,
      // Label 612: @18658
      GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(18694), // Rule ID 21252 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (XOR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21252,
        GIR_Done,
      // Label 613: @18694
      GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(18730), // Rule ID 21342 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (XOR64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 21342,
        GIR_Done,
      // Label 614: @18730
      GIM_Reject,
    // Label 604: @18731
    GIM_Reject,
    // Label 549: @18732
    GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(19246),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(18861), // Rule ID 23794 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v2i1] } (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }), VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 23794,
        GIR_EraseRootFromParent_Done,
      // Label 616: @18861
      GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(18976), // Rule ID 18031 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v2i1] } (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2), immAllOnesV:{ *:[v2i1] })  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 18031,
        GIR_EraseRootFromParent_Done,
      // Label 617: @18976
      GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(19090), // Rule ID 23795 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src2, (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 23795,
        GIR_EraseRootFromParent_Done,
      // Label 618: @19090
      GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(19162), // Rule ID 18015 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src, immAllOnesV:{ *:[v2i1] })  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KNOTWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KNOTWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 18015,
        GIR_EraseRootFromParent_Done,
      // Label 619: @19162
      GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(19245), // Rule ID 18035 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        // (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KXORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 18035,
        GIR_EraseRootFromParent_Done,
      // Label 620: @19245
      GIM_Reject,
    // Label 615: @19246
    GIM_Reject,
    // Label 550: @19247
    GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(19618),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(19490), // Rule ID 20490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src, immAllOnesV:{ *:[v2i64] })  =>  (EXTRACT_SUBREG:{ *:[v2i64] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src, sub_xmm:{ *:[i32] }), 15:{ *:[i8] }), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20490,
        GIR_EraseRootFromParent_Done,
      // Label 622: @19490
      GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(19536), // Rule ID 20498 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src, immAllOnesV:{ *:[v2i64] })  =>  (VPTERNLOGQZ128rri:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src, VR128X:{ *:[v2i64] }:$src, VR128X:{ *:[v2i64] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20498,
        GIR_EraseRootFromParent_Done,
      // Label 623: @19536
      GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(19563), // Rule ID 2110 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPXORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2110,
        GIR_Done,
      // Label 624: @19563
      GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(19590), // Rule ID 2112 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PXORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2112,
        GIR_Done,
      // Label 625: @19590
      GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(19617), // Rule ID 5764 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (xor:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPXORQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5764,
        GIR_Done,
      // Label 626: @19617
      GIM_Reject,
    // Label 621: @19618
    GIM_Reject,
    // Label 551: @19619
    GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(20133),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(19748), // Rule ID 23796 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i1] } (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }), VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 23796,
        GIR_EraseRootFromParent_Done,
      // Label 628: @19748
      GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(19863), // Rule ID 18032 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i1] } (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2), immAllOnesV:{ *:[v4i1] })  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 18032,
        GIR_EraseRootFromParent_Done,
      // Label 629: @19863
      GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(19977), // Rule ID 23797 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src2, (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 23797,
        GIR_EraseRootFromParent_Done,
      // Label 630: @19977
      GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(20049), // Rule ID 18014 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src, immAllOnesV:{ *:[v4i1] })  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KNOTWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KNOTWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 18014,
        GIR_EraseRootFromParent_Done,
      // Label 631: @20049
      GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(20132), // Rule ID 18036 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        // (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KXORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 18036,
        GIR_EraseRootFromParent_Done,
      // Label 632: @20132
      GIM_Reject,
    // Label 627: @20133
    GIM_Reject,
    // Label 552: @20134
    GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(20505),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(20377), // Rule ID 20489 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src, immAllOnesV:{ *:[v4i32] })  =>  (EXTRACT_SUBREG:{ *:[v4i32] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v4i32] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v4i32] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v4i32] }:$src, sub_xmm:{ *:[i32] }), 15:{ *:[i8] }), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20489,
        GIR_EraseRootFromParent_Done,
      // Label 634: @20377
      GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(20423), // Rule ID 20497 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src, immAllOnesV:{ *:[v4i32] })  =>  (VPTERNLOGQZ128rri:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src, VR128X:{ *:[v4i32] }:$src, VR128X:{ *:[v4i32] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20497,
        GIR_EraseRootFromParent_Done,
      // Label 635: @20423
      GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(20450), // Rule ID 5791 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (xor:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPXORDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5791,
        GIR_Done,
      // Label 636: @20450
      GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(20477), // Rule ID 16664 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPXORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16664,
        GIR_Done,
      // Label 637: @20477
      GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(20504), // Rule ID 16688 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PXORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16688,
        GIR_Done,
      // Label 638: @20504
      GIM_Reject,
    // Label 633: @20505
    GIM_Reject,
    // Label 553: @20506
    GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(20877),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(20749), // Rule ID 20494 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src, immAllOnesV:{ *:[v4i64] })  =>  (EXTRACT_SUBREG:{ *:[v4i64] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src, sub_ymm:{ *:[i32] }), 15:{ *:[i8] }), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20494,
        GIR_EraseRootFromParent_Done,
      // Label 640: @20749
      GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(20795), // Rule ID 20502 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src, immAllOnesV:{ *:[v4i64] })  =>  (VPTERNLOGQZ256rri:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src, VR256X:{ *:[v4i64] }:$src, VR256X:{ *:[v4i64] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20502,
        GIR_EraseRootFromParent_Done,
      // Label 641: @20795
      GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(20822), // Rule ID 2114 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPXORYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2114,
        GIR_Done,
      // Label 642: @20822
      GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(20849), // Rule ID 5755 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (xor:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPXORQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5755,
        GIR_Done,
      // Label 643: @20849
      GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(20876), // Rule ID 16635 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VXORPSYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VXORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16635,
        GIR_Done,
      // Label 644: @20876
      GIM_Reject,
    // Label 639: @20877
    GIM_Reject,
    // Label 554: @20878
    GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(21648),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(20953), // Rule ID 22104 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (KXNORBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22104,
        GIR_EraseRootFromParent_Done,
      // Label 646: @20953
      GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(21070), // Rule ID 23790 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 23790,
        GIR_EraseRootFromParent_Done,
      // Label 647: @21070
      GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(21133), // Rule ID 4375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2), immAllOnesV:{ *:[v8i1] })  =>  (KXNORBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4375,
        GIR_EraseRootFromParent_Done,
      // Label 648: @21133
      GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(21251), // Rule ID 18029 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2), immAllOnesV:{ *:[v8i1] })  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 18029,
        GIR_EraseRootFromParent_Done,
      // Label 649: @21251
      GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(21311), // Rule ID 22105 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (KXNORBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22105,
        GIR_EraseRootFromParent_Done,
      // Label 650: @21311
      GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(21428), // Rule ID 23791 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KXNORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 23791,
        GIR_EraseRootFromParent_Done,
      // Label 651: @21428
      GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(21463), // Rule ID 4363 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src, immAllOnesV:{ *:[v8i1] })  =>  (KNOTBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KNOTBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4363,
        GIR_EraseRootFromParent_Done,
      // Label 652: @21463
      GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(21538), // Rule ID 18013 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src, immAllOnesV:{ *:[v8i1] })  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KNOTWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KNOTWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 18013,
        GIR_EraseRootFromParent_Done,
      // Label 653: @21538
      GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(21561), // Rule ID 4379 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KXORBrr:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KXORBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4379,
        GIR_Done,
      // Label 654: @21561
      GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(21647), // Rule ID 18033 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KXORWrr:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXORWrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 18033,
        GIR_EraseRootFromParent_Done,
      // Label 655: @21647
      GIM_Reject,
    // Label 645: @21648
    GIM_Reject,
    // Label 555: @21649
    GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(22020),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(21892), // Rule ID 20488 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src, immAllOnesV:{ *:[v8i16] })  =>  (EXTRACT_SUBREG:{ *:[v8i16] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v8i16] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v8i16] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v8i16] }:$src, sub_xmm:{ *:[i32] }), 15:{ *:[i8] }), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20488,
        GIR_EraseRootFromParent_Done,
      // Label 657: @21892
      GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(21938), // Rule ID 20496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src, immAllOnesV:{ *:[v8i16] })  =>  (VPTERNLOGQZ128rri:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src, VR128X:{ *:[v8i16] }:$src, VR128X:{ *:[v8i16] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20496,
        GIR_EraseRootFromParent_Done,
      // Label 658: @21938
      GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(21965), // Rule ID 16663 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPXORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16663,
        GIR_Done,
      // Label 659: @21965
      GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(21992), // Rule ID 16687 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PXORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16687,
        GIR_Done,
      // Label 660: @21992
      GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(22019), // Rule ID 18601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (xor:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPXORQZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18601,
        GIR_Done,
      // Label 661: @22019
      GIM_Reject,
    // Label 656: @22020
    GIM_Reject,
    // Label 556: @22021
    GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(22392),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(22264), // Rule ID 20493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src, immAllOnesV:{ *:[v8i32] })  =>  (EXTRACT_SUBREG:{ *:[v8i32] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v8i32] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v8i32] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v8i32] }:$src, sub_ymm:{ *:[i32] }), 15:{ *:[i8] }), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20493,
        GIR_EraseRootFromParent_Done,
      // Label 663: @22264
      GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(22310), // Rule ID 20501 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src, immAllOnesV:{ *:[v8i32] })  =>  (VPTERNLOGQZ256rri:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src, VR256X:{ *:[v8i32] }:$src, VR256X:{ *:[v8i32] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20501,
        GIR_EraseRootFromParent_Done,
      // Label 664: @22310
      GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(22337), // Rule ID 5782 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (xor:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPXORDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5782,
        GIR_Done,
      // Label 665: @22337
      GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(22364), // Rule ID 16608 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPXORYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16608,
        GIR_Done,
      // Label 666: @22364
      GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(22391), // Rule ID 16634 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VXORPSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VXORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16634,
        GIR_Done,
      // Label 667: @22391
      GIM_Reject,
    // Label 662: @22392
    GIM_Reject,
    // Label 557: @22393
    GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(22470),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(22450), // Rule ID 20486 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src, immAllOnesV:{ *:[v8i64] })  =>  (VPTERNLOGQZrri:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src, VR512:{ *:[v8i64] }:$src, VR512:{ *:[v8i64] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20486,
        GIR_EraseRootFromParent_Done,
      // Label 669: @22450
      GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(22469), // Rule ID 5746 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (xor:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPXORQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5746,
        GIR_Done,
      // Label 670: @22469
      GIM_Reject,
    // Label 668: @22470
    GIM_Reject,
    // Label 558: @22471
    GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(22728),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(22546), // Rule ID 22106 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v16i1] } (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }), VK16:{ *:[v16i1] }:$src2)  =>  (KXNORWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22106,
        GIR_EraseRootFromParent_Done,
      // Label 672: @22546
      GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(22609), // Rule ID 4376 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v16i1] } (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2), immAllOnesV:{ *:[v16i1] })  =>  (KXNORWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4376,
        GIR_EraseRootFromParent_Done,
      // Label 673: @22609
      GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(22669), // Rule ID 22107 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src2, (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }))  =>  (KXNORWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22107,
        GIR_EraseRootFromParent_Done,
      // Label 674: @22669
      GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(22704), // Rule ID 4364 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src, immAllOnesV:{ *:[v16i1] })  =>  (KNOTWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KNOTWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4364,
        GIR_EraseRootFromParent_Done,
      // Label 675: @22704
      GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(22727), // Rule ID 4380 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        // (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KXORWrr:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KXORWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4380,
        GIR_Done,
      // Label 676: @22727
      GIM_Reject,
    // Label 671: @22728
    GIM_Reject,
    // Label 559: @22729
    GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(23100),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(22972), // Rule ID 20487 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src, immAllOnesV:{ *:[v16i8] })  =>  (EXTRACT_SUBREG:{ *:[v16i8] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v16i8] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v16i8] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v16i8] }:$src, sub_xmm:{ *:[i32] }), 15:{ *:[i8] }), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/9,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20487,
        GIR_EraseRootFromParent_Done,
      // Label 678: @22972
      GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(23018), // Rule ID 20495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src, immAllOnesV:{ *:[v16i8] })  =>  (VPTERNLOGQZ128rri:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src, VR128X:{ *:[v16i8] }:$src, VR128X:{ *:[v16i8] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20495,
        GIR_EraseRootFromParent_Done,
      // Label 679: @23018
      GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(23045), // Rule ID 16662 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPXORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16662,
        GIR_Done,
      // Label 680: @23045
      GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(23072), // Rule ID 16686 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PXORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16686,
        GIR_Done,
      // Label 681: @23072
      GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(23099), // Rule ID 18600 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (xor:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPXORQZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18600,
        GIR_Done,
      // Label 682: @23099
      GIM_Reject,
    // Label 677: @23100
    GIM_Reject,
    // Label 560: @23101
    GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(23472),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(23344), // Rule ID 20492 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src, immAllOnesV:{ *:[v16i16] })  =>  (EXTRACT_SUBREG:{ *:[v16i16] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v16i16] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v16i16] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v16i16] }:$src, sub_ymm:{ *:[i32] }), 15:{ *:[i8] }), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20492,
        GIR_EraseRootFromParent_Done,
      // Label 684: @23344
      GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(23390), // Rule ID 20500 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src, immAllOnesV:{ *:[v16i16] })  =>  (VPTERNLOGQZ256rri:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src, VR256X:{ *:[v16i16] }:$src, VR256X:{ *:[v16i16] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20500,
        GIR_EraseRootFromParent_Done,
      // Label 685: @23390
      GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(23417), // Rule ID 16607 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPXORYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16607,
        GIR_Done,
      // Label 686: @23417
      GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(23444), // Rule ID 16633 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VXORPSYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VXORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16633,
        GIR_Done,
      // Label 687: @23444
      GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(23471), // Rule ID 18617 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (xor:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPXORQZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18617,
        GIR_Done,
      // Label 688: @23471
      GIM_Reject,
    // Label 683: @23472
    GIM_Reject,
    // Label 561: @23473
    GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(23550),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(23530), // Rule ID 20485 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src, immAllOnesV:{ *:[v16i32] })  =>  (VPTERNLOGQZrri:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src, VR512:{ *:[v16i32] }:$src, VR512:{ *:[v16i32] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20485,
        GIR_EraseRootFromParent_Done,
      // Label 690: @23530
      GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(23549), // Rule ID 5773 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (xor:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPXORDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORDZrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5773,
        GIR_Done,
      // Label 691: @23549
      GIM_Reject,
    // Label 689: @23550
    GIM_Reject,
    // Label 562: @23551
    GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(23808),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(23626), // Rule ID 22108 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v32i1] } (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }), VK32:{ *:[v32i1] }:$src2)  =>  (KXNORDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22108,
        GIR_EraseRootFromParent_Done,
      // Label 693: @23626
      GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(23689), // Rule ID 4377 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v32i1] } (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2), immAllOnesV:{ *:[v32i1] })  =>  (KXNORDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4377,
        GIR_EraseRootFromParent_Done,
      // Label 694: @23689
      GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(23749), // Rule ID 22109 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src2, (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }))  =>  (KXNORDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22109,
        GIR_EraseRootFromParent_Done,
      // Label 695: @23749
      GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(23784), // Rule ID 4365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src, immAllOnesV:{ *:[v32i1] })  =>  (KNOTDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KNOTDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4365,
        GIR_EraseRootFromParent_Done,
      // Label 696: @23784
      GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(23807), // Rule ID 4381 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        // (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)  =>  (KXORDrr:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KXORDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4381,
        GIR_Done,
      // Label 697: @23807
      GIM_Reject,
    // Label 692: @23808
    GIM_Reject,
    // Label 563: @23809
    GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(24180),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(24052), // Rule ID 20491 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src, immAllOnesV:{ *:[v32i8] })  =>  (EXTRACT_SUBREG:{ *:[v32i8] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v32i8] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v32i8] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v32i8] }:$src, sub_ymm:{ *:[i32] }), 15:{ *:[i8] }), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20491,
        GIR_EraseRootFromParent_Done,
      // Label 699: @24052
      GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(24098), // Rule ID 20499 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src, immAllOnesV:{ *:[v32i8] })  =>  (VPTERNLOGQZ256rri:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src, VR256X:{ *:[v32i8] }:$src, VR256X:{ *:[v32i8] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20499,
        GIR_EraseRootFromParent_Done,
      // Label 700: @24098
      GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(24125), // Rule ID 16606 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPXORYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16606,
        GIR_Done,
      // Label 701: @24125
      GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(24152), // Rule ID 16632 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VXORPSYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VXORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16632,
        GIR_Done,
      // Label 702: @24152
      GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(24179), // Rule ID 18616 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (xor:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPXORQZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18616,
        GIR_Done,
      // Label 703: @24179
      GIM_Reject,
    // Label 698: @24180
    GIM_Reject,
    // Label 564: @24181
    GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(24258),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(24238), // Rule ID 20484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src, immAllOnesV:{ *:[v32i16] })  =>  (VPTERNLOGQZrri:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src, VR512:{ *:[v32i16] }:$src, VR512:{ *:[v32i16] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20484,
        GIR_EraseRootFromParent_Done,
      // Label 705: @24238
      GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(24257), // Rule ID 18633 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (xor:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPXORQZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18633,
        GIR_Done,
      // Label 706: @24257
      GIM_Reject,
    // Label 704: @24258
    GIM_Reject,
    // Label 565: @24259
    GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(24516),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(24334), // Rule ID 22110 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v64i1] } (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }), VK64:{ *:[v64i1] }:$src2)  =>  (KXNORQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22110,
        GIR_EraseRootFromParent_Done,
      // Label 708: @24334
      GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(24397), // Rule ID 4378 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v64i1] } (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2), immAllOnesV:{ *:[v64i1] })  =>  (KXNORQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4378,
        GIR_EraseRootFromParent_Done,
      // Label 709: @24397
      GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(24457), // Rule ID 22111 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src2, (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }))  =>  (KXNORQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22111,
        GIR_EraseRootFromParent_Done,
      // Label 710: @24457
      GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(24492), // Rule ID 4366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src, immAllOnesV:{ *:[v64i1] })  =>  (KNOTQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KNOTQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4366,
        GIR_EraseRootFromParent_Done,
      // Label 711: @24492
      GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(24515), // Rule ID 4382 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        // (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)  =>  (KXORQrr:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KXORQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4382,
        GIR_Done,
      // Label 712: @24515
      GIM_Reject,
    // Label 707: @24516
    GIM_Reject,
    // Label 566: @24517
    GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(24594),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(24574), // Rule ID 20483 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src, immAllOnesV:{ *:[v64i8] })  =>  (VPTERNLOGQZrri:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src, VR512:{ *:[v64i8] }:$src, VR512:{ *:[v64i8] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20483,
        GIR_EraseRootFromParent_Done,
      // Label 714: @24574
      GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(24593), // Rule ID 18632 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (xor:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPXORQZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18632,
        GIR_Done,
      // Label 715: @24593
      GIM_Reject,
    // Label 713: @24594
    GIM_Reject,
    // Label 567: @24595
    GIM_Reject,
    // Label 6: @24596
    GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(24762),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(16), GIMT_Encode2(24), /*)*//*default:*//*Label 720*/ GIMT_Encode4(24761),
      /*GILLT_v16s1*//*Label 717*/ GIMT_Encode4(24647), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v32s1*//*Label 718*/ GIMT_Encode4(24685), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v64s1*//*Label 719*/ GIMT_Encode4(24723),
      // Label 717: @24647
      GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(24684), // Rule ID 18037 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (concat_vectors:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KUNPCKBWrr:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK8:{ *:[v8i1] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KUNPCKBWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18037,
        GIR_EraseRootFromParent_Done,
      // Label 721: @24684
      GIM_Reject,
      // Label 718: @24685
      GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(24722), // Rule ID 18038 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        // (concat_vectors:{ *:[v32i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KUNPCKWDrr:{ *:[v32i1] } VK16:{ *:[v16i1] }:$src2, VK16:{ *:[v16i1] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KUNPCKWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18038,
        GIR_EraseRootFromParent_Done,
      // Label 722: @24722
      GIM_Reject,
      // Label 719: @24723
      GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(24760), // Rule ID 18039 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        // (concat_vectors:{ *:[v64i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)  =>  (KUNPCKDQrr:{ *:[v64i1] } VK32:{ *:[v32i1] }:$src2, VK32:{ *:[v32i1] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KUNPCKDQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18039,
        GIR_EraseRootFromParent_Done,
      // Label 723: @24760
      GIM_Reject,
      // Label 720: @24761
      GIM_Reject,
    // Label 716: @24762
    GIM_Reject,
    // Label 7: @24763
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(24), /*)*//*default:*//*Label 732*/ GIMT_Encode4(26501),
    /*GILLT_s8*//*Label 724*/ GIMT_Encode4(24866),
    /*GILLT_s16*//*Label 725*/ GIMT_Encode4(24924),
    /*GILLT_s32*//*Label 726*/ GIMT_Encode4(25739),
    /*GILLT_s64*//*Label 727*/ GIMT_Encode4(25967), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s1*//*Label 728*/ GIMT_Encode4(26195), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s1*//*Label 729*/ GIMT_Encode4(26277), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v32s1*//*Label 730*/ GIMT_Encode4(26359), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v64s1*//*Label 731*/ GIMT_Encode4(26430),
    // Label 724: @24866
    GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(24923), // Rule ID 17968 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      // (bitconvert:{ *:[i8] } VK8:{ *:[v8i1] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } (COPY_TO_REGCLASS:{ *:[i32] } VK8:{ *:[v8i1] }:$src, GR32:{ *:[i32] }), sub_8bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_8bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 17968,
      GIR_EraseRootFromParent_Done,
    // Label 733: @24923
    GIM_Reject,
    // Label 725: @24924
    GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(24981), // Rule ID 17965 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      // (bitconvert:{ *:[i16] } VK16:{ *:[v16i1] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i32] } VK16:{ *:[v16i1] }:$src, GR32:{ *:[i32] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 17965,
      GIR_EraseRootFromParent_Done,
    // Label 734: @24981
    GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(25082), // Rule ID 20689 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFP16),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (bitconvert:{ *:[f16] } GR16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f16] } (VMOVW2SHrr:{ *:[f128] } (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] })), FR16X:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/2, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VMOVW2SHrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
      // GIR_Coverage, 20689,
      GIR_EraseRootFromParent_Done,
    // Label 735: @25082
    GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(25159), // Rule ID 20702 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFP16),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
      // (bitconvert:{ *:[i16] } FR16X:{ *:[f16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (VMOVSH2Wrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[f128] } FR16X:{ *:[f16] }:$src, VR128X:{ *:[i32] })), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VMOVSH2Wrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 20702,
      GIR_EraseRootFromParent_Done,
    // Label 736: @25159
    GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(25235), // Rule ID 16850 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[i16] } f16:{ *:[f16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (VPEXTRWrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v8i16] } FR16:{ *:[f16] }:$src, VR128:{ *:[i32] }), 0:{ *:[i8] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPEXTRWrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 16850,
      GIR_EraseRootFromParent_Done,
    // Label 737: @25235
    GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(25352), // Rule ID 16851 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16RegClassID),
      // (bitconvert:{ *:[f16] } i16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f16] } (VPINSRWrr:{ *:[f128] } (IMPLICIT_DEF:{ *:[v8i16] }), (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] }), 0:{ *:[i8] }), FR16:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/3, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPINSRWrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16RegClassID),
      // GIR_Coverage, 16851,
      GIR_EraseRootFromParent_Done,
    // Label 738: @25352
    GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(25428), // Rule ID 16847 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[i16] } f16:{ *:[f16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (PEXTRWrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v8i16] } FR16:{ *:[f16] }:$src, VR128:{ *:[i32] }), 0:{ *:[i8] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::PEXTRWrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 16847,
      GIR_EraseRootFromParent_Done,
    // Label 739: @25428
    GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(25545), // Rule ID 16848 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16RegClassID),
      // (bitconvert:{ *:[f16] } i16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f16] } (PINSRWrr:{ *:[f128] } (IMPLICIT_DEF:{ *:[v8i16] }), (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] }), 0:{ *:[i8] }), FR16:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/3, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::PINSRWrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16RegClassID),
      // GIR_Coverage, 16848,
      GIR_EraseRootFromParent_Done,
    // Label 740: @25545
    GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(25621), // Rule ID 20385 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[i16] } f16:{ *:[f16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (VPEXTRWZrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v8i16] } FR16X:{ *:[f16] }:$src, VR128X:{ *:[i32] }), 0:{ *:[i8] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPEXTRWZrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 20385,
      GIR_EraseRootFromParent_Done,
    // Label 741: @25621
    GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(25738), // Rule ID 20386 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
      // (bitconvert:{ *:[f16] } i16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f16] } (VPINSRWZrr:{ *:[f128] } (IMPLICIT_DEF:{ *:[v8i16] }), (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] }), 0:{ *:[i8] }), FR16X:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/3, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPINSRWZrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
      // GIR_Coverage, 20386,
      GIR_EraseRootFromParent_Done,
    // Label 742: @25738
    GIM_Reject,
    // Label 726: @25739
    GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(25765), // Rule ID 2863 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[f32] } GR32:{ *:[i32] }:$src)  =>  (VMOVDI2SSrr:{ *:[f32] } GR32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVDI2SSrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2863,
      GIR_Done,
    // Label 743: @25765
    GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(25791), // Rule ID 2864 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[f32] } GR32:{ *:[i32] }:$src)  =>  (MOVDI2SSrr:{ *:[f32] } GR32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOVDI2SSrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2864,
      GIR_Done,
    // Label 744: @25791
    GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(25817), // Rule ID 2873 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (bitconvert:{ *:[i32] } FR32:{ *:[f32] }:$src)  =>  (VMOVSS2DIrr:{ *:[i32] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVSS2DIrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2873,
      GIR_Done,
    // Label 745: @25817
    GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(25843), // Rule ID 2874 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (bitconvert:{ *:[i32] } FR32:{ *:[f32] }:$src)  =>  (MOVSS2DIrr:{ *:[i32] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOVSS2DIrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2874,
      GIR_Done,
    // Label 746: @25843
    GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(25869), // Rule ID 4550 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[f32] } GR32:{ *:[i32] }:$src)  =>  (VMOVDI2SSZrr:{ *:[f32] } GR32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVDI2SSZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4550,
      GIR_Done,
    // Label 747: @25869
    GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(25895), // Rule ID 4555 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      // (bitconvert:{ *:[i32] } FR32X:{ *:[f32] }:$src)  =>  (VMOVSS2DIZrr:{ *:[i32] } FR32X:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVSS2DIZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4555,
      GIR_Done,
    // Label 748: @25895
    GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(25922), // Rule ID 17976 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      // (bitconvert:{ *:[i32] } VK32:{ *:[v32i1] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } VK32:{ *:[v32i1] }:$src, GR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 17976,
      GIR_Done,
    // Label 749: @25922
    GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(25966), // Rule ID 18456 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      // (bitconvert:{ *:[f32] } VK32:{ *:[v32i1] }:$src)  =>  (VMOVDI2SSZrr:{ *:[f32] } (KMOVDrk:{ *:[i32] } VK32:{ *:[v32i1] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KMOVDrk),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMOVDI2SSZrr),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18456,
      GIR_EraseRootFromParent_Done,
    // Label 750: @25966
    GIM_Reject,
    // Label 727: @25967
    GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(25993), // Rule ID 2858 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // (bitconvert:{ *:[f64] } GR64:{ *:[i64] }:$src)  =>  (VMOV64toSDrr:{ *:[f64] } GR64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOV64toSDrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2858,
      GIR_Done,
    // Label 751: @25993
    GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(26019), // Rule ID 2862 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // (bitconvert:{ *:[f64] } GR64:{ *:[i64] }:$src)  =>  (MOV64toSDrr:{ *:[f64] } GR64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOV64toSDrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2862,
      GIR_Done,
    // Label 752: @26019
    GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(26045), // Rule ID 2871 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (bitconvert:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (VMOVSDto64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVSDto64rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2871,
      GIR_Done,
    // Label 753: @26045
    GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(26071), // Rule ID 2872 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (bitconvert:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (MOVSDto64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOVSDto64rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2872,
      GIR_Done,
    // Label 754: @26071
    GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(26097), // Rule ID 4548 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // (bitconvert:{ *:[f64] } GR64:{ *:[i64] }:$src)  =>  (VMOV64toSDZrr:{ *:[f64] } GR64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOV64toSDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4548,
      GIR_Done,
    // Label 755: @26097
    GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(26123), // Rule ID 4549 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      // (bitconvert:{ *:[i64] } FR64X:{ *:[f64] }:$src)  =>  (VMOVSDto64Zrr:{ *:[i64] } FR64X:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVSDto64Zrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4549,
      GIR_Done,
    // Label 756: @26123
    GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(26150), // Rule ID 17978 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      // (bitconvert:{ *:[i64] } VK64:{ *:[v64i1] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i64] } VK64:{ *:[v64i1] }:$src, GR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR64RegClassID),
      // GIR_Coverage, 17978,
      GIR_Done,
    // Label 757: @26150
    GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(26194), // Rule ID 18458 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      // (bitconvert:{ *:[f64] } VK64:{ *:[v64i1] }:$src)  =>  (VMOV64toSDZrr:{ *:[f64] } (KMOVQrk:{ *:[i64] } VK64:{ *:[v64i1] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KMOVQrk),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMOV64toSDZrr),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18458,
      GIR_EraseRootFromParent_Done,
    // Label 758: @26194
    GIM_Reject,
    // Label 728: @26195
    GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(26276), // Rule ID 17967 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      // (bitconvert:{ *:[v8i1] } GR8:{ *:[i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src, sub_8bit:{ *:[i32] }), VK8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
      // GIR_Coverage, 17967,
      GIR_EraseRootFromParent_Done,
    // Label 759: @26276
    GIM_Reject,
    // Label 729: @26277
    GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(26358), // Rule ID 17964 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (bitconvert:{ *:[v16i1] } GR16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] }), VK16:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/1, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
      // GIR_Coverage, 17964,
      GIR_EraseRootFromParent_Done,
    // Label 760: @26358
    GIM_Reject,
    // Label 730: @26359
    GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(26429),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(26391), // Rule ID 17975 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (bitconvert:{ *:[v32i1] } GR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v32i1] } GR32:{ *:[i32] }:$src, VK32:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK32RegClassID),
        // GIR_Coverage, 17975,
        GIR_Done,
      // Label 762: @26391
      GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(26428), // Rule ID 18455 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
        // (bitconvert:{ *:[v32i1] } FR32X:{ *:[f32] }:$src)  =>  (KMOVDkr:{ *:[v32i1] } (VMOVSS2DIZrr:{ *:[i32] } FR32X:{ *:[f32] }:$src))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VMOVSS2DIZrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KMOVDkr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18455,
        GIR_EraseRootFromParent_Done,
      // Label 763: @26428
      GIM_Reject,
    // Label 761: @26429
    GIM_Reject,
    // Label 731: @26430
    GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(26500),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(26462), // Rule ID 17977 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (bitconvert:{ *:[v64i1] } GR64:{ *:[i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v64i1] } GR64:{ *:[i64] }:$src, VK64:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK64RegClassID),
        // GIR_Coverage, 17977,
        GIR_Done,
      // Label 765: @26462
      GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(26499), // Rule ID 18457 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
        // (bitconvert:{ *:[v64i1] } FR64X:{ *:[f64] }:$src)  =>  (KMOVQkr:{ *:[v64i1] } (VMOVSDto64Zrr:{ *:[i64] } FR64X:{ *:[f64] }:$src))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VMOVSDto64Zrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KMOVQkr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18457,
        GIR_EraseRootFromParent_Done,
      // Label 766: @26499
      GIM_Reject,
    // Label 764: @26500
    GIM_Reject,
    // Label 732: @26501
    GIM_Reject,
    // Label 8: @26502
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(20), /*)*//*default:*//*Label 775*/ GIMT_Encode4(27363),
    /*GILLT_s32*//*Label 767*/ GIMT_Encode4(26581),
    /*GILLT_s64*//*Label 768*/ GIMT_Encode4(26762), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 769*/ GIMT_Encode4(26943), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 770*/ GIMT_Encode4(26974),
    /*GILLT_v4s64*//*Label 771*/ GIMT_Encode4(27125), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s32*//*Label 772*/ GIMT_Encode4(27186),
    /*GILLT_v8s64*//*Label 773*/ GIMT_Encode4(27274), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s32*//*Label 774*/ GIMT_Encode4(27335),
    // Label 767: @26581
    GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(26611), // Rule ID 1743 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i32] } FR32:{ *:[f32] }:$src)  =>  (VCVTSS2SIrr:{ *:[i32] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SIrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1743,
      GIR_Done,
    // Label 776: @26611
    GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(26641), // Rule ID 1747 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i32] } FR64:{ *:[f64] }:$src)  =>  (VCVTSD2SIrr:{ *:[i32] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SIrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1747,
      GIR_Done,
    // Label 777: @26641
    GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(26671), // Rule ID 1767 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i32] } FR32:{ *:[f32] }:$src)  =>  (CVTSS2SIrr:{ *:[i32] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSS2SIrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1767,
      GIR_Done,
    // Label 778: @26671
    GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(26701), // Rule ID 1771 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i32] } FR64:{ *:[f64] }:$src)  =>  (CVTSD2SIrr:{ *:[i32] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSD2SIrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1771,
      GIR_Done,
    // Label 779: @26701
    GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(26731), // Rule ID 10238 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      // (lrint:{ *:[i32] } FR32X:{ *:[f32] }:$src)  =>  (VCVTSS2SIZrr:{ *:[i32] } FR32X:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SIZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 10238,
      GIR_Done,
    // Label 780: @26731
    GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(26761), // Rule ID 10242 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      // (lrint:{ *:[i32] } FR64X:{ *:[f64] }:$src)  =>  (VCVTSD2SIZrr:{ *:[i32] } FR64X:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SIZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 10242,
      GIR_Done,
    // Label 781: @26761
    GIM_Reject,
    // Label 768: @26762
    GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(26792), // Rule ID 16499 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (VCVTSS2SI64rr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16499,
      GIR_Done,
    // Label 782: @26792
    GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(26822), // Rule ID 16501 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (VCVTSD2SI64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16501,
      GIR_Done,
    // Label 783: @26822
    GIM_Try, /*On fail goto*//*Label 784*/ GIMT_Encode4(26852), // Rule ID 16503 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (CVTSS2SI64rr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSS2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16503,
      GIR_Done,
    // Label 784: @26852
    GIM_Try, /*On fail goto*//*Label 785*/ GIMT_Encode4(26882), // Rule ID 16505 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (CVTSD2SI64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSD2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16505,
      GIR_Done,
    // Label 785: @26882
    GIM_Try, /*On fail goto*//*Label 786*/ GIMT_Encode4(26912), // Rule ID 19739 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (VCVTSS2SI64Zrr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SI64Zrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19739,
      GIR_Done,
    // Label 786: @26912
    GIM_Try, /*On fail goto*//*Label 787*/ GIMT_Encode4(26942), // Rule ID 19741 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (VCVTSD2SI64Zrr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SI64Zrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19741,
      GIR_Done,
    // Label 787: @26942
    GIM_Reject,
    // Label 769: @26943
    GIM_Try, /*On fail goto*//*Label 788*/ GIMT_Encode4(26973), // Rule ID 19964 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (lrint:{ *:[v2i64] } VR128X:{ *:[v2f64] }:$src)  =>  (VCVTPD2QQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZ128rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19964,
      GIR_Done,
    // Label 788: @26973
    GIM_Reject,
    // Label 770: @26974
    GIM_Try, /*On fail goto*//*Label 789*/ GIMT_Encode4(27004), // Rule ID 16553 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      // (lrint:{ *:[v4i32] } VR128:{ *:[v4f32] }:$src)  =>  (VCVTPS2DQrr:{ *:[v4i32] } VR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16553,
      GIR_Done,
    // Label 789: @27004
    GIM_Try, /*On fail goto*//*Label 790*/ GIMT_Encode4(27034), // Rule ID 16557 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
      // (lrint:{ *:[v4i32] } VR256:{ *:[v4f64] }:$src)  =>  (VCVTPD2DQYrr:{ *:[v4i32] } VR256:{ *:[v4f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2DQYrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16557,
      GIR_Done,
    // Label 790: @27034
    GIM_Try, /*On fail goto*//*Label 791*/ GIMT_Encode4(27064), // Rule ID 16559 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      // (lrint:{ *:[v4i32] } VR128:{ *:[v4f32] }:$src)  =>  (CVTPS2DQrr:{ *:[v4i32] } VR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTPS2DQrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16559,
      GIR_Done,
    // Label 791: @27064
    GIM_Try, /*On fail goto*//*Label 792*/ GIMT_Encode4(27094), // Rule ID 19936 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (lrint:{ *:[v4i32] } VR128X:{ *:[v4f32] }:$src)  =>  (VCVTPS2DQZ128rr:{ *:[v4i32] } VR128X:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQZ128rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19936,
      GIR_Done,
    // Label 792: @27094
    GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(27124), // Rule ID 19940 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (lrint:{ *:[v4i32] } VR256X:{ *:[v4f64] }:$src)  =>  (VCVTPD2DQZ256rr:{ *:[v4i32] } VR256X:{ *:[v4f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2DQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19940,
      GIR_Done,
    // Label 793: @27124
    GIM_Reject,
    // Label 771: @27125
    GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(27155), // Rule ID 19960 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (lrint:{ *:[v4i64] } VR128X:{ *:[v4f32] }:$src)  =>  (VCVTPS2QQZ256rr:{ *:[v4i64] } VR128X:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2QQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19960,
      GIR_Done,
    // Label 794: @27155
    GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(27185), // Rule ID 19966 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (lrint:{ *:[v4i64] } VR256X:{ *:[v4f64] }:$src)  =>  (VCVTPD2QQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19966,
      GIR_Done,
    // Label 795: @27185
    GIM_Reject,
    // Label 772: @27186
    GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(27216), // Rule ID 16555 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
      // (lrint:{ *:[v8i32] } VR256:{ *:[v8f32] }:$src)  =>  (VCVTPS2DQYrr:{ *:[v8i32] } VR256:{ *:[v8f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQYrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 16555,
      GIR_Done,
    // Label 796: @27216
    GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(27246), // Rule ID 19938 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (lrint:{ *:[v8i32] } VR256X:{ *:[v8f32] }:$src)  =>  (VCVTPS2DQZ256rr:{ *:[v8i32] } VR256X:{ *:[v8f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19938,
      GIR_Done,
    // Label 797: @27246
    GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(27273), // Rule ID 19944 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (lrint:{ *:[v8i32] } VR512:{ *:[v8f64] }:$src)  =>  (VCVTPD2DQZrr:{ *:[v8i32] } VR512:{ *:[v8f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2DQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19944,
      GIR_Done,
    // Label 798: @27273
    GIM_Reject,
    // Label 773: @27274
    GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(27304), // Rule ID 19972 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (lrint:{ *:[v8i64] } VR256X:{ *:[v8f32] }:$src)  =>  (VCVTPS2QQZrr:{ *:[v8i64] } VR256X:{ *:[v8f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2QQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19972,
      GIR_Done,
    // Label 799: @27304
    GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(27334), // Rule ID 19976 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (lrint:{ *:[v8i64] } VR512:{ *:[v8f64] }:$src)  =>  (VCVTPD2QQZrr:{ *:[v8i64] } VR512:{ *:[v8f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19976,
      GIR_Done,
    // Label 800: @27334
    GIM_Reject,
    // Label 774: @27335
    GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(27362), // Rule ID 19942 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (lrint:{ *:[v16i32] } VR512:{ *:[v16f32] }:$src)  =>  (VCVTPS2DQZrr:{ *:[v16i32] } VR512:{ *:[v16f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19942,
      GIR_Done,
    // Label 801: @27362
    GIM_Reject,
    // Label 775: @27363
    GIM_Reject,
    // Label 9: @27364
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(4), GIMT_Encode2(16), /*)*//*default:*//*Label 806*/ GIMT_Encode4(27757),
    /*GILLT_s64*//*Label 802*/ GIMT_Encode4(27423), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 803*/ GIMT_Encode4(27604), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s64*//*Label 804*/ GIMT_Encode4(27635), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s64*//*Label 805*/ GIMT_Encode4(27696),
    // Label 802: @27423
    GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(27453), // Rule ID 1745 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (llrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (VCVTSS2SI64rr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1745,
      GIR_Done,
    // Label 807: @27453
    GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(27483), // Rule ID 1749 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (llrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (VCVTSD2SI64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1749,
      GIR_Done,
    // Label 808: @27483
    GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(27513), // Rule ID 1769 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (llrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (CVTSS2SI64rr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSS2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1769,
      GIR_Done,
    // Label 809: @27513
    GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(27543), // Rule ID 1773 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (llrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (CVTSD2SI64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSD2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1773,
      GIR_Done,
    // Label 810: @27543
    GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(27573), // Rule ID 10240 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      // (llrint:{ *:[i64] } FR32X:{ *:[f32] }:$src)  =>  (VCVTSS2SI64Zrr:{ *:[i64] } FR32X:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SI64Zrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 10240,
      GIR_Done,
    // Label 811: @27573
    GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(27603), // Rule ID 10244 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      // (llrint:{ *:[i64] } FR64X:{ *:[f64] }:$src)  =>  (VCVTSD2SI64Zrr:{ *:[i64] } FR64X:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SI64Zrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 10244,
      GIR_Done,
    // Label 812: @27603
    GIM_Reject,
    // Label 803: @27604
    GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(27634), // Rule ID 19968 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (llrint:{ *:[v2i64] } VR128X:{ *:[v2f64] }:$src)  =>  (VCVTPD2QQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZ128rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19968,
      GIR_Done,
    // Label 813: @27634
    GIM_Reject,
    // Label 804: @27635
    GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(27665), // Rule ID 19962 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (llrint:{ *:[v4i64] } VR128X:{ *:[v4f32] }:$src)  =>  (VCVTPS2QQZ256rr:{ *:[v4i64] } VR128X:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2QQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19962,
      GIR_Done,
    // Label 814: @27665
    GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(27695), // Rule ID 19970 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (llrint:{ *:[v4i64] } VR256X:{ *:[v4f64] }:$src)  =>  (VCVTPD2QQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19970,
      GIR_Done,
    // Label 815: @27695
    GIM_Reject,
    // Label 805: @27696
    GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(27726), // Rule ID 19974 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (llrint:{ *:[v8i64] } VR256X:{ *:[v8f32] }:$src)  =>  (VCVTPS2QQZrr:{ *:[v8i64] } VR256X:{ *:[v8f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2QQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19974,
      GIR_Done,
    // Label 816: @27726
    GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(27756), // Rule ID 19978 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (llrint:{ *:[v8i64] } VR512:{ *:[v8f64] }:$src)  =>  (VCVTPD2QQZrr:{ *:[v8i64] } VR512:{ *:[v8f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19978,
      GIR_Done,
    // Label 817: @27756
    GIM_Reject,
    // Label 806: @27757
    GIM_Reject,
    // Label 10: @27758
    GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(28891),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(27802), // Rule ID 1517 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphsubwd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13952:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHSUBWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1517,
        GIR_EraseRootFromParent_Done,
      // Label 819: @27802
      GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(27838), // Rule ID 1519 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphsubdq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13951:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src)  =>  (VPHSUBDQrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBDQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1519,
        GIR_EraseRootFromParent_Done,
      // Label 820: @27838
      GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(27874), // Rule ID 1521 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphsubbw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13950:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHSUBBWrr:{ *:[v8i16] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBBWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1521,
        GIR_EraseRootFromParent_Done,
      // Label 821: @27874
      GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(27910), // Rule ID 1523 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddwq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13949:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHADDWQrr:{ *:[v2i64] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDWQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1523,
        GIR_EraseRootFromParent_Done,
      // Label 822: @27910
      GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(27946), // Rule ID 1525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddwd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13948:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHADDWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1525,
        GIR_EraseRootFromParent_Done,
      // Label 823: @27946
      GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(27982), // Rule ID 1527 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphadduwq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13947:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHADDUWQrr:{ *:[v2i64] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUWQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1527,
        GIR_EraseRootFromParent_Done,
      // Label 824: @27982
      GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(28018), // Rule ID 1529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphadduwd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13946:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHADDUWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1529,
        GIR_EraseRootFromParent_Done,
      // Label 825: @28018
      GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(28054), // Rule ID 1531 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddudq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13945:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src)  =>  (VPHADDUDQrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUDQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1531,
        GIR_EraseRootFromParent_Done,
      // Label 826: @28054
      GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(28090), // Rule ID 1533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddubw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13944:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDUBWrr:{ *:[v8i16] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUBWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1533,
        GIR_EraseRootFromParent_Done,
      // Label 827: @28090
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(28126), // Rule ID 1535 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddubq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13943:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDUBQrr:{ *:[v2i64] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUBQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1535,
        GIR_EraseRootFromParent_Done,
      // Label 828: @28126
      GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(28162), // Rule ID 1537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddubd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13942:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDUBDrr:{ *:[v4i32] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUBDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1537,
        GIR_EraseRootFromParent_Done,
      // Label 829: @28162
      GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(28198), // Rule ID 1539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphadddq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13941:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src)  =>  (VPHADDDQrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDDQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1539,
        GIR_EraseRootFromParent_Done,
      // Label 830: @28198
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(28234), // Rule ID 1541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddbw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13940:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDBWrr:{ *:[v8i16] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDBWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1541,
        GIR_EraseRootFromParent_Done,
      // Label 831: @28234
      GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(28270), // Rule ID 1543 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddbq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13939:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDBQrr:{ *:[v2i64] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDBQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1543,
        GIR_EraseRootFromParent_Done,
      // Label 832: @28270
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(28306), // Rule ID 1545 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddbd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13938:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDBDrr:{ *:[v4i32] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDBDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1545,
        GIR_EraseRootFromParent_Done,
      // Label 833: @28306
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(28342), // Rule ID 1547 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 13933:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (VFRCZSSrr:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZSSrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1547,
        GIR_EraseRootFromParent_Done,
      // Label 834: @28342
      GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(28378), // Rule ID 1551 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_ps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 13930:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (VFRCZPSrr:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZPSrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1551,
        GIR_EraseRootFromParent_Done,
      // Label 835: @28378
      GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(28414), // Rule ID 1553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_ps_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8f32] } 13931:{ *:[iPTR] }, VR256:{ *:[v8f32] }:$src)  =>  (VFRCZPSYrr:{ *:[v8f32] } VR256:{ *:[v8f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZPSYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1553,
        GIR_EraseRootFromParent_Done,
      // Label 836: @28414
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(28450), // Rule ID 1555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_sd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 13932:{ *:[iPTR] }, VR128:{ *:[v2f64] }:$src)  =>  (VFRCZSDrr:{ *:[v2f64] } VR128:{ *:[v2f64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZSDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1555,
        GIR_EraseRootFromParent_Done,
      // Label 837: @28450
      GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(28486), // Rule ID 1559 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_pd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 13928:{ *:[iPTR] }, VR128:{ *:[v2f64] }:$src)  =>  (VFRCZPDrr:{ *:[v2f64] } VR128:{ *:[v2f64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZPDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1559,
        GIR_EraseRootFromParent_Done,
      // Label 838: @28486
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(28522), // Rule ID 1561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_pd_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f64] } 13929:{ *:[iPTR] }, VR256:{ *:[v4f64] }:$src)  =>  (VFRCZPDYrr:{ *:[v4f64] } VR256:{ *:[v4f64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZPDYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1561,
        GIR_EraseRootFromParent_Done,
      // Label 839: @28522
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(28558), // Rule ID 3311 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesimc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12613:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1)  =>  (VAESIMCrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESIMCrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3311,
        GIR_EraseRootFromParent_Done,
      // Label 840: @28558
      GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(28594), // Rule ID 3313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesimc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12613:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1)  =>  (AESIMCrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESIMCrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3313,
        GIR_EraseRootFromParent_Done,
      // Label 841: @28594
      GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(28630), // Rule ID 3503 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXNECONVERT),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vcvtneps2bf16128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8bf16] } 13890:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (VCVTNEPS2BF16rr:{ *:[v8bf16] } VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VCVTNEPS2BF16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3503,
        GIR_EraseRootFromParent_Done,
      // Label 842: @28630
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(28666), // Rule ID 3505 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXNECONVERT),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vcvtneps2bf16256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8bf16] } 13891:{ *:[iPTR] }, VR256:{ *:[v8f32] }:$src)  =>  (VCVTNEPS2BF16Yrr:{ *:[v8bf16] } VR256:{ *:[v8f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VCVTNEPS2BF16Yrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3505,
        GIR_EraseRootFromParent_Done,
      // Label 843: @28666
      GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(28704), // Rule ID 16776 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse_rsqrt_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 13698:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (RSQRTSSr_Int:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src, VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RSQRTSSr_Int),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16776,
        GIR_EraseRootFromParent_Done,
      // Label 844: @28704
      GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(28742), // Rule ID 16780 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse_rsqrt_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 13698:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (VRSQRTSSr_Int:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src, VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VRSQRTSSr_Int),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16780,
        GIR_EraseRootFromParent_Done,
      // Label 845: @28742
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(28780), // Rule ID 16796 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse_rcp_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 13696:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (RCPSSr_Int:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src, VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RCPSSr_Int),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16796,
        GIR_EraseRootFromParent_Done,
      // Label 846: @28780
      GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(28818), // Rule ID 16800 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse_rcp_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 13696:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (VRCPSSr_Int:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src, VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VRCPSSr_Int),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 16800,
        GIR_EraseRootFromParent_Done,
      // Label 847: @28818
      GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(28854), // Rule ID 20675 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBF16_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vcvtneps2bf16128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v8bf16] } 13890:{ *:[iPTR] }, VR128X:{ *:[v4f32] }:$src)  =>  (VCVTNEPS2BF16Z128rr:{ *:[v8bf16] } VR128X:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VCVTNEPS2BF16Z128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20675,
        GIR_EraseRootFromParent_Done,
      // Label 848: @28854
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(28890), // Rule ID 20677 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBF16_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vcvtneps2bf16256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v8bf16] } 13891:{ *:[iPTR] }, VR256X:{ *:[v8f32] }:$src)  =>  (VCVTNEPS2BF16Z256rr:{ *:[v8bf16] } VR256X:{ *:[v8f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VCVTNEPS2BF16Z256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20677,
        GIR_EraseRootFromParent_Done,
      // Label 849: @28890
      GIM_Reject,
    // Label 818: @28891
    GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(31682),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(28940), // Rule ID 3315 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aeskeygenassist),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v2i64] } 12614:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, (timm:{ *:[i8] }):$src2)  =>  (VAESKEYGENASSIST128rr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, (timm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESKEYGENASSIST128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3315,
        GIR_EraseRootFromParent_Done,
      // Label 851: @28940
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(28981), // Rule ID 3317 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aeskeygenassist),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v2i64] } 12614:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, (timm:{ *:[i8] }):$src2)  =>  (AESKEYGENASSIST128rr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, (timm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESKEYGENASSIST128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3317,
        GIR_EraseRootFromParent_Done,
      // Label 852: @28981
      GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(29026), // Rule ID 2970 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_b_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 13836:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPSIGNBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2970,
        GIR_EraseRootFromParent_Done,
      // Label 853: @29026
      GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(29071), // Rule ID 2972 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_w_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13840:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPSIGNWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2972,
        GIR_EraseRootFromParent_Done,
      // Label 854: @29071
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(29116), // Rule ID 2974 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_d_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13838:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPSIGNDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2974,
        GIR_EraseRootFromParent_Done,
      // Label 855: @29116
      GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(29161), // Rule ID 2976 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_phadd_sw_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13820:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPHADDSWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDSWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2976,
        GIR_EraseRootFromParent_Done,
      // Label 856: @29161
      GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(29206), // Rule ID 2978 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_phsub_sw_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13826:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPHSUBSWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBSWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2978,
        GIR_EraseRootFromParent_Done,
      // Label 857: @29206
      GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(29251), // Rule ID 2994 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_psign_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v32s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v32s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v32i8] } 12732:{ *:[iPTR] }, VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPSIGNBYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNBYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2994,
        GIR_EraseRootFromParent_Done,
      // Label 858: @29251
      GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(29296), // Rule ID 2996 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_psign_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i16] } 12734:{ *:[iPTR] }, VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPSIGNWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNWYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2996,
        GIR_EraseRootFromParent_Done,
      // Label 859: @29296
      GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(29341), // Rule ID 2998 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_psign_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 12733:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPSIGNDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNDYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2998,
        GIR_EraseRootFromParent_Done,
      // Label 860: @29341
      GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(29386), // Rule ID 3000 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_phadd_sw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i16] } 12719:{ *:[iPTR] }, VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPHADDSWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDSWYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3000,
        GIR_EraseRootFromParent_Done,
      // Label 861: @29386
      GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(29431), // Rule ID 3002 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_phsub_sw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i16] } 12722:{ *:[iPTR] }, VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPHSUBSWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBSWYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3002,
        GIR_EraseRootFromParent_Done,
      // Label 862: @29431
      GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(29476), // Rule ID 3012 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_b_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 13836:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PSIGNBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PSIGNBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3012,
        GIR_EraseRootFromParent_Done,
      // Label 863: @29476
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(29521), // Rule ID 3014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_w_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13840:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PSIGNWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PSIGNWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3014,
        GIR_EraseRootFromParent_Done,
      // Label 864: @29521
      GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(29566), // Rule ID 3016 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_d_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13838:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PSIGNDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PSIGNDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3016,
        GIR_EraseRootFromParent_Done,
      // Label 865: @29566
      GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(29611), // Rule ID 3020 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_phadd_sw_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13820:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PHADDSWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PHADDSWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3020,
        GIR_EraseRootFromParent_Done,
      // Label 866: @29611
      GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(29656), // Rule ID 3022 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_phsub_sw_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13826:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PHSUBSWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PHSUBSWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3022,
        GIR_EraseRootFromParent_Done,
      // Label 867: @29656
      GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(29701), // Rule ID 3257 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_8),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 13794:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (CRC32r32r8:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3257,
        GIR_EraseRootFromParent_Done,
      // Label 868: @29701
      GIM_Try, /*On fail goto*//*Label 869*/ GIMT_Encode4(29746), // Rule ID 3259 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 13792:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (CRC32r32r16:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3259,
        GIR_EraseRootFromParent_Done,
      // Label 869: @29746
      GIM_Try, /*On fail goto*//*Label 870*/ GIMT_Encode4(29791), // Rule ID 3261 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 13793:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (CRC32r32r32:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3261,
        GIR_EraseRootFromParent_Done,
      // Label 870: @29791
      GIM_Try, /*On fail goto*//*Label 871*/ GIMT_Encode4(29836), // Rule ID 3263 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_64_64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 13795:{ *:[iPTR] }, GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (CRC32r64r64:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r64r64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3263,
        GIR_EraseRootFromParent_Done,
      // Label 871: @29836
      GIM_Try, /*On fail goto*//*Label 872*/ GIMT_Encode4(29881), // Rule ID 3265 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_HasEGPR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_8),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 13794:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (CRC32r32r8_EVEX:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r8_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3265,
        GIR_EraseRootFromParent_Done,
      // Label 872: @29881
      GIM_Try, /*On fail goto*//*Label 873*/ GIMT_Encode4(29926), // Rule ID 3267 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_HasEGPR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 13792:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (CRC32r32r16_EVEX:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r16_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3267,
        GIR_EraseRootFromParent_Done,
      // Label 873: @29926
      GIM_Try, /*On fail goto*//*Label 874*/ GIMT_Encode4(29971), // Rule ID 3269 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_HasEGPR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 13793:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (CRC32r32r32_EVEX:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r32_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3269,
        GIR_EraseRootFromParent_Done,
      // Label 874: @29971
      GIM_Try, /*On fail goto*//*Label 875*/ GIMT_Encode4(30016), // Rule ID 3271 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_HasEGPR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_64_64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 13795:{ *:[iPTR] }, GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (CRC32r64r64_EVEX:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r64r64_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3271,
        GIR_EraseRootFromParent_Done,
      // Label 875: @30016
      GIM_Try, /*On fail goto*//*Label 876*/ GIMT_Encode4(30061), // Rule ID 3275 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha1nexte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13664:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA1NEXTErr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA1NEXTErr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3275,
        GIR_EraseRootFromParent_Done,
      // Label 876: @30061
      GIM_Try, /*On fail goto*//*Label 877*/ GIMT_Encode4(30106), // Rule ID 3277 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha1msg1),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13662:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA1MSG1rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA1MSG1rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3277,
        GIR_EraseRootFromParent_Done,
      // Label 877: @30106
      GIM_Try, /*On fail goto*//*Label 878*/ GIMT_Encode4(30151), // Rule ID 3279 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha1msg2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13663:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA1MSG2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA1MSG2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3279,
        GIR_EraseRootFromParent_Done,
      // Label 878: @30151
      GIM_Try, /*On fail goto*//*Label 879*/ GIMT_Encode4(30196), // Rule ID 3283 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha256msg1),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13666:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA256MSG1rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA256MSG1rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3283,
        GIR_EraseRootFromParent_Done,
      // Label 879: @30196
      GIM_Try, /*On fail goto*//*Label 880*/ GIMT_Encode4(30241), // Rule ID 3285 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha256msg2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13667:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA256MSG2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA256MSG2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3285,
        GIR_EraseRootFromParent_Done,
      // Label 880: @30241
      GIM_Try, /*On fail goto*//*Label 881*/ GIMT_Encode4(30286), // Rule ID 3287 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12607:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VAESENCrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3287,
        GIR_EraseRootFromParent_Done,
      // Label 881: @30286
      GIM_Try, /*On fail goto*//*Label 882*/ GIMT_Encode4(30331), // Rule ID 3289 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12610:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VAESENCLASTrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3289,
        GIR_EraseRootFromParent_Done,
      // Label 882: @30331
      GIM_Try, /*On fail goto*//*Label 883*/ GIMT_Encode4(30376), // Rule ID 3291 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12601:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VAESDECrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3291,
        GIR_EraseRootFromParent_Done,
      // Label 883: @30376
      GIM_Try, /*On fail goto*//*Label 884*/ GIMT_Encode4(30421), // Rule ID 3293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12604:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VAESDECLASTrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3293,
        GIR_EraseRootFromParent_Done,
      // Label 884: @30421
      GIM_Try, /*On fail goto*//*Label 885*/ GIMT_Encode4(30466), // Rule ID 3295 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12608:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VAESENCYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3295,
        GIR_EraseRootFromParent_Done,
      // Label 885: @30466
      GIM_Try, /*On fail goto*//*Label 886*/ GIMT_Encode4(30511), // Rule ID 3297 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12611:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VAESENCLASTYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3297,
        GIR_EraseRootFromParent_Done,
      // Label 886: @30511
      GIM_Try, /*On fail goto*//*Label 887*/ GIMT_Encode4(30556), // Rule ID 3299 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12602:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VAESDECYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3299,
        GIR_EraseRootFromParent_Done,
      // Label 887: @30556
      GIM_Try, /*On fail goto*//*Label 888*/ GIMT_Encode4(30601), // Rule ID 3301 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12605:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VAESDECLASTYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3301,
        GIR_EraseRootFromParent_Done,
      // Label 888: @30601
      GIM_Try, /*On fail goto*//*Label 889*/ GIMT_Encode4(30646), // Rule ID 3303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12607:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (AESENCrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESENCrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3303,
        GIR_EraseRootFromParent_Done,
      // Label 889: @30646
      GIM_Try, /*On fail goto*//*Label 890*/ GIMT_Encode4(30691), // Rule ID 3305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12610:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (AESENCLASTrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESENCLASTrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3305,
        GIR_EraseRootFromParent_Done,
      // Label 890: @30691
      GIM_Try, /*On fail goto*//*Label 891*/ GIMT_Encode4(30736), // Rule ID 3307 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12601:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (AESDECrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESDECrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3307,
        GIR_EraseRootFromParent_Done,
      // Label 891: @30736
      GIM_Try, /*On fail goto*//*Label 892*/ GIMT_Encode4(30781), // Rule ID 3309 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12604:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (AESDECLASTrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESDECLASTrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3309,
        GIR_EraseRootFromParent_Done,
      // Label 892: @30781
      GIM_Try, /*On fail goto*//*Label 893*/ GIMT_Encode4(30826), // Rule ID 3326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE4A),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse4a_extrq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13810:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src, VR128:{ *:[v16i8] }:$mask)  =>  (EXTRQ:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::EXTRQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/3, // mask
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3326,
        GIR_EraseRootFromParent_Done,
      // Label 893: @30826
      GIM_Try, /*On fail goto*//*Label 894*/ GIMT_Encode4(30871), // Rule ID 3328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE4A),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse4a_insertq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13812:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src, VR128:{ *:[v2i64] }:$mask)  =>  (INSERTQ:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src, VR128:{ *:[v2i64] }:$mask)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INSERTQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/3, // mask
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3328,
        GIR_EraseRootFromParent_Done,
      // Label 894: @30871
      GIM_Try, /*On fail goto*//*Label 895*/ GIMT_Encode4(30916), // Rule ID 3507 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA512),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsha512msg1),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 13903:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VSHA512MSG1rr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSHA512MSG1rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3507,
        GIR_EraseRootFromParent_Done,
      // Label 895: @30916
      GIM_Try, /*On fail goto*//*Label 896*/ GIMT_Encode4(30961), // Rule ID 3508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA512),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsha512msg2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 13904:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VSHA512MSG2rr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSHA512MSG2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3508,
        GIR_EraseRootFromParent_Done,
      // Label 896: @30961
      GIM_Try, /*On fail goto*//*Label 897*/ GIMT_Encode4(31006), // Rule ID 3516 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4key4128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13909:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VSM4KEY4rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4KEY4rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3516,
        GIR_EraseRootFromParent_Done,
      // Label 897: @31006
      GIM_Try, /*On fail goto*//*Label 898*/ GIMT_Encode4(31051), // Rule ID 3518 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4key4256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 13910:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VSM4KEY4Yrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4KEY4Yrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3518,
        GIR_EraseRootFromParent_Done,
      // Label 898: @31051
      GIM_Try, /*On fail goto*//*Label 899*/ GIMT_Encode4(31096), // Rule ID 3520 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4rnds4128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13911:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VSM4RNDS4rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4RNDS4rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3520,
        GIR_EraseRootFromParent_Done,
      // Label 899: @31096
      GIM_Try, /*On fail goto*//*Label 900*/ GIMT_Encode4(31141), // Rule ID 3522 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4rnds4256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 13912:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VSM4RNDS4Yrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4RNDS4Yrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3522,
        GIR_EraseRootFromParent_Done,
      // Label 900: @31141
      GIM_Try, /*On fail goto*//*Label 901*/ GIMT_Encode4(31186), // Rule ID 13946 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12607:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VAESENCZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCZ128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13946,
        GIR_EraseRootFromParent_Done,
      // Label 901: @31186
      GIM_Try, /*On fail goto*//*Label 902*/ GIMT_Encode4(31231), // Rule ID 13948 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12608:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VAESENCZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCZ256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13948,
        GIR_EraseRootFromParent_Done,
      // Label 902: @31231
      GIM_Try, /*On fail goto*//*Label 903*/ GIMT_Encode4(31276), // Rule ID 13950 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i64] } 12609:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VAESENCZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCZrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13950,
        GIR_EraseRootFromParent_Done,
      // Label 903: @31276
      GIM_Try, /*On fail goto*//*Label 904*/ GIMT_Encode4(31321), // Rule ID 13952 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12610:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VAESENCLASTZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTZ128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13952,
        GIR_EraseRootFromParent_Done,
      // Label 904: @31321
      GIM_Try, /*On fail goto*//*Label 905*/ GIMT_Encode4(31366), // Rule ID 13954 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12611:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VAESENCLASTZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTZ256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13954,
        GIR_EraseRootFromParent_Done,
      // Label 905: @31366
      GIM_Try, /*On fail goto*//*Label 906*/ GIMT_Encode4(31411), // Rule ID 13956 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i64] } 12612:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VAESENCLASTZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTZrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13956,
        GIR_EraseRootFromParent_Done,
      // Label 906: @31411
      GIM_Try, /*On fail goto*//*Label 907*/ GIMT_Encode4(31456), // Rule ID 13958 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12601:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VAESDECZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECZ128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13958,
        GIR_EraseRootFromParent_Done,
      // Label 907: @31456
      GIM_Try, /*On fail goto*//*Label 908*/ GIMT_Encode4(31501), // Rule ID 13960 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12602:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VAESDECZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECZ256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13960,
        GIR_EraseRootFromParent_Done,
      // Label 908: @31501
      GIM_Try, /*On fail goto*//*Label 909*/ GIMT_Encode4(31546), // Rule ID 13962 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i64] } 12603:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VAESDECZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECZrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13962,
        GIR_EraseRootFromParent_Done,
      // Label 909: @31546
      GIM_Try, /*On fail goto*//*Label 910*/ GIMT_Encode4(31591), // Rule ID 13964 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12604:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VAESDECLASTZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTZ128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13964,
        GIR_EraseRootFromParent_Done,
      // Label 910: @31591
      GIM_Try, /*On fail goto*//*Label 911*/ GIMT_Encode4(31636), // Rule ID 13966 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12605:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VAESDECLASTZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTZ256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13966,
        GIR_EraseRootFromParent_Done,
      // Label 911: @31636
      GIM_Try, /*On fail goto*//*Label 912*/ GIMT_Encode4(31681), // Rule ID 13968 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i64] } 12606:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VAESDECLASTZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTZrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13968,
        GIR_EraseRootFromParent_Done,
      // Label 912: @31681
      GIM_Reject,
    // Label 850: @31682
    GIM_Try, /*On fail goto*//*Label 913*/ GIMT_Encode4(33965),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 914*/ GIMT_Encode4(31740), // Rule ID 3199 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_mpsadbw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v8i16] } 13781:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VMPSADBWrri:{ *:[v8i16] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMPSADBWrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3199,
        GIR_EraseRootFromParent_Done,
      // Label 914: @31740
      GIM_Try, /*On fail goto*//*Label 915*/ GIMT_Encode4(31790), // Rule ID 3201 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_dpps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4f32] } 13779:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src1, VR128:{ *:[v4f32] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VDPPSrri:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src1, VR128:{ *:[v4f32] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VDPPSrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3201,
        GIR_EraseRootFromParent_Done,
      // Label 915: @31790
      GIM_Try, /*On fail goto*//*Label 916*/ GIMT_Encode4(31840), // Rule ID 3203 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_dppd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2f64] } 13778:{ *:[iPTR] }, VR128:{ *:[v2f64] }:$src1, VR128:{ *:[v2f64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VDPPDrri:{ *:[v2f64] } VR128:{ *:[v2f64] }:$src1, VR128:{ *:[v2f64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VDPPDrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3203,
        GIR_EraseRootFromParent_Done,
      // Label 916: @31840
      GIM_Try, /*On fail goto*//*Label 917*/ GIMT_Encode4(31890), // Rule ID 3205 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx_dp_ps_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v8f32] } 12639:{ *:[iPTR] }, VR256:{ *:[v8f32] }:$src1, VR256:{ *:[v8f32] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VDPPSYrri:{ *:[v8f32] } VR256:{ *:[v8f32] }:$src1, VR256:{ *:[v8f32] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VDPPSYrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3205,
        GIR_EraseRootFromParent_Done,
      // Label 917: @31890
      GIM_Try, /*On fail goto*//*Label 918*/ GIMT_Encode4(31940), // Rule ID 3207 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_mpsadbw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v32s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v16i16] } 12708:{ *:[iPTR] }, VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VMPSADBWYrri:{ *:[v16i16] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMPSADBWYrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3207,
        GIR_EraseRootFromParent_Done,
      // Label 918: @31940
      GIM_Try, /*On fail goto*//*Label 919*/ GIMT_Encode4(31990), // Rule ID 3209 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE41),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_mpsadbw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v8i16] } 13781:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (MPSADBWrri:{ *:[v8i16] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MPSADBWrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3209,
        GIR_EraseRootFromParent_Done,
      // Label 919: @31990
      GIM_Try, /*On fail goto*//*Label 920*/ GIMT_Encode4(32040), // Rule ID 3211 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE41),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_dpps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4f32] } 13779:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src1, VR128:{ *:[v4f32] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (DPPSrri:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src1, VR128:{ *:[v4f32] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DPPSrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3211,
        GIR_EraseRootFromParent_Done,
      // Label 920: @32040
      GIM_Try, /*On fail goto*//*Label 921*/ GIMT_Encode4(32090), // Rule ID 3213 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE41),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_dppd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2f64] } 13778:{ *:[iPTR] }, VR128:{ *:[v2f64] }:$src1, VR128:{ *:[v2f64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (DPPDrri:{ *:[v2f64] } VR128:{ *:[v2f64] }:$src1, VR128:{ *:[v2f64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DPPDrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3213,
        GIR_EraseRootFromParent_Done,
      // Label 921: @32090
      GIM_Try, /*On fail goto*//*Label 922*/ GIMT_Encode4(32140), // Rule ID 3273 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha1rnds4),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i32] } 13665:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (SHA1RNDS4rri:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA1RNDS4rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3273,
        GIR_EraseRootFromParent_Done,
      // Label 922: @32140
      GIM_Try, /*On fail goto*//*Label 923*/ GIMT_Encode4(32190), // Rule ID 3319 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasPCLMUL_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 13631:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (PCLMULQDQrri:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PCLMULQDQrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3319,
        GIR_EraseRootFromParent_Done,
      // Label 923: @32190
      GIM_Try, /*On fail goto*//*Label 924*/ GIMT_Encode4(32240), // Rule ID 3321 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_HasPCLMUL_NoVLX_Or_NoVPCLMULQDQ),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 13631:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQrri:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3321,
        GIR_EraseRootFromParent_Done,
      // Label 924: @32240
      GIM_Try, /*On fail goto*//*Label 925*/ GIMT_Encode4(32290), // Rule ID 3323 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVPCLMULQDQ_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i64] } 13632:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQYrri:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQYrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3323,
        GIR_EraseRootFromParent_Done,
      // Label 925: @32290
      GIM_Try, /*On fail goto*//*Label 926*/ GIMT_Encode4(32340), // Rule ID 13970 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVPCLMULQDQ),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v8i64] } 13633:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQZrri:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13970,
        GIR_EraseRootFromParent_Done,
      // Label 926: @32340
      GIM_Try, /*On fail goto*//*Label 927*/ GIMT_Encode4(32390), // Rule ID 13972 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX_HasVPCLMULQDQ),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 13631:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQZ128rri:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13972,
        GIR_EraseRootFromParent_Done,
      // Label 927: @32390
      GIM_Try, /*On fail goto*//*Label 928*/ GIMT_Encode4(32440), // Rule ID 13974 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX_HasVPCLMULQDQ),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i64] } 13632:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQZ256rri:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 13974,
        GIR_EraseRootFromParent_Done,
      // Label 928: @32440
      GIM_Try, /*On fail goto*//*Label 929*/ GIMT_Encode4(32494), // Rule ID 1607 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmadcswd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13964:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMADCSWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMADCSWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1607,
        GIR_EraseRootFromParent_Done,
      // Label 929: @32494
      GIM_Try, /*On fail goto*//*Label 930*/ GIMT_Encode4(32548), // Rule ID 1609 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmadcsswd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13963:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMADCSSWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMADCSSWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1609,
        GIR_EraseRootFromParent_Done,
      // Label 930: @32548
      GIM_Try, /*On fail goto*//*Label 931*/ GIMT_Encode4(32602), // Rule ID 1611 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsww),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13962:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)  =>  (VPMACSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1611,
        GIR_EraseRootFromParent_Done,
      // Label 931: @32602
      GIM_Try, /*On fail goto*//*Label 932*/ GIMT_Encode4(32656), // Rule ID 1613 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacswd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13961:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1613,
        GIR_EraseRootFromParent_Done,
      // Label 932: @32656
      GIM_Try, /*On fail goto*//*Label 933*/ GIMT_Encode4(32710), // Rule ID 1615 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacssww),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 13960:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)  =>  (VPMACSSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSWWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1615,
        GIR_EraseRootFromParent_Done,
      // Label 933: @32710
      GIM_Try, /*On fail goto*//*Label 934*/ GIMT_Encode4(32764), // Rule ID 1617 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsswd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13959:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSSWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1617,
        GIR_EraseRootFromParent_Done,
      // Label 934: @32764
      GIM_Try, /*On fail goto*//*Label 935*/ GIMT_Encode4(32818), // Rule ID 1619 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacssdql),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13958:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VPMACSSDQLrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSDQLrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1619,
        GIR_EraseRootFromParent_Done,
      // Label 935: @32818
      GIM_Try, /*On fail goto*//*Label 936*/ GIMT_Encode4(32872), // Rule ID 1621 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacssdqh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13957:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VPMACSSDQHrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSDQHrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1621,
        GIR_EraseRootFromParent_Done,
      // Label 936: @32872
      GIM_Try, /*On fail goto*//*Label 937*/ GIMT_Encode4(32926), // Rule ID 1623 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacssdd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13956:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSDDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1623,
        GIR_EraseRootFromParent_Done,
      // Label 937: @32926
      GIM_Try, /*On fail goto*//*Label 938*/ GIMT_Encode4(32980), // Rule ID 1625 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsdql),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13955:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VPMACSDQLrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDQLrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1625,
        GIR_EraseRootFromParent_Done,
      // Label 938: @32980
      GIM_Try, /*On fail goto*//*Label 939*/ GIMT_Encode4(33034), // Rule ID 1627 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsdqh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 13954:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VPMACSDQHrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDQHrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1627,
        GIR_EraseRootFromParent_Done,
      // Label 939: @33034
      GIM_Try, /*On fail goto*//*Label 940*/ GIMT_Encode4(33088), // Rule ID 1629 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsdd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13953:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1629,
        GIR_EraseRootFromParent_Done,
      // Label 940: @33088
      GIM_Try, /*On fail goto*//*Label 941*/ GIMT_Encode4(33154), // Rule ID 3281 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha256rnds2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13668:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, XMM0:{ *:[v4i32] })  =>  (SHA256RNDS2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::XMM0), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XMM0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA256RNDS2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3281,
        GIR_EraseRootFromParent_Done,
      // Label 941: @33154
      GIM_Try, /*On fail goto*//*Label 942*/ GIMT_Encode4(33208), // Rule ID 3509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA512),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsha512rnds2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 13905:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VSHA512RNDS2rr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSHA512RNDS2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3509,
        GIR_EraseRootFromParent_Done,
      // Label 942: @33208
      GIM_Try, /*On fail goto*//*Label 943*/ GIMT_Encode4(33262), // Rule ID 3510 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm3msg1),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13906:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VSM3MSG1rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM3MSG1rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3510,
        GIR_EraseRootFromParent_Done,
      // Label 943: @33262
      GIM_Try, /*On fail goto*//*Label 944*/ GIMT_Encode4(33316), // Rule ID 3512 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm3msg2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 13907:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VSM3MSG2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM3MSG2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3512,
        GIR_EraseRootFromParent_Done,
      // Label 944: @33316
      GIM_Try, /*On fail goto*//*Label 945*/ GIMT_Encode4(33370), // Rule ID 3524 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwsud_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 12773:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPDPWSUDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWSUDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3524,
        GIR_EraseRootFromParent_Done,
      // Label 945: @33370
      GIM_Try, /*On fail goto*//*Label 946*/ GIMT_Encode4(33424), // Rule ID 3526 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwsud_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 12774:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)  =>  (VPDPWSUDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWSUDYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3526,
        GIR_EraseRootFromParent_Done,
      // Label 946: @33424
      GIM_Try, /*On fail goto*//*Label 947*/ GIMT_Encode4(33478), // Rule ID 3528 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwsuds_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 12775:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPDPWSUDSrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWSUDSrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3528,
        GIR_EraseRootFromParent_Done,
      // Label 947: @33478
      GIM_Try, /*On fail goto*//*Label 948*/ GIMT_Encode4(33532), // Rule ID 3530 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwsuds_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 12776:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)  =>  (VPDPWSUDSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWSUDSYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3530,
        GIR_EraseRootFromParent_Done,
      // Label 948: @33532
      GIM_Try, /*On fail goto*//*Label 949*/ GIMT_Encode4(33586), // Rule ID 3532 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwusd_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 12777:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPDPWUSDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUSDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3532,
        GIR_EraseRootFromParent_Done,
      // Label 949: @33586
      GIM_Try, /*On fail goto*//*Label 950*/ GIMT_Encode4(33640), // Rule ID 3534 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwusd_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 12778:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)  =>  (VPDPWUSDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUSDYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3534,
        GIR_EraseRootFromParent_Done,
      // Label 950: @33640
      GIM_Try, /*On fail goto*//*Label 951*/ GIMT_Encode4(33694), // Rule ID 3536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwusds_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 12779:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPDPWUSDSrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUSDSrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3536,
        GIR_EraseRootFromParent_Done,
      // Label 951: @33694
      GIM_Try, /*On fail goto*//*Label 952*/ GIMT_Encode4(33748), // Rule ID 3538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwusds_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 12780:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)  =>  (VPDPWUSDSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUSDSYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3538,
        GIR_EraseRootFromParent_Done,
      // Label 952: @33748
      GIM_Try, /*On fail goto*//*Label 953*/ GIMT_Encode4(33802), // Rule ID 3540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwuud_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 12781:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPDPWUUDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUUDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3540,
        GIR_EraseRootFromParent_Done,
      // Label 953: @33802
      GIM_Try, /*On fail goto*//*Label 954*/ GIMT_Encode4(33856), // Rule ID 3542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwuud_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 12782:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)  =>  (VPDPWUUDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUUDYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3542,
        GIR_EraseRootFromParent_Done,
      // Label 954: @33856
      GIM_Try, /*On fail goto*//*Label 955*/ GIMT_Encode4(33910), // Rule ID 3544 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwuuds_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 12783:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPDPWUUDSrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUUDSrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3544,
        GIR_EraseRootFromParent_Done,
      // Label 955: @33910
      GIM_Try, /*On fail goto*//*Label 956*/ GIMT_Encode4(33964), // Rule ID 3546 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVXVNNIINT16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_vpdpwuuds_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 12784:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)  =>  (VPDPWUUDSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2, VR256:{ *:[v8i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPDPWUUDSYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3546,
        GIR_EraseRootFromParent_Done,
      // Label 956: @33964
      GIM_Reject,
    // Label 913: @33965
    GIM_Try, /*On fail goto*//*Label 957*/ GIMT_Encode4(34027), // Rule ID 3514 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM3),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/6,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm3rnds2),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      // MIs[0] src4
      GIM_CheckIsImm, /*MI*/0, /*Op*/5,
      // (intrinsic_wo_chain:{ *:[v4i32] } 13908:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3, (timm:{ *:[i32] }):$src4)  =>  (VSM3RNDS2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3, (timm:{ *:[i32] }):$src4)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM3RNDS2rr),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_RootToRootCopy, /*OpIdx*/2, // src1
      GIR_RootToRootCopy, /*OpIdx*/3, // src2
      GIR_RootToRootCopy, /*OpIdx*/4, // src3
      GIR_RootToRootCopy, /*OpIdx*/5, // src4
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3514,
      GIR_EraseRootFromParent_Done,
    // Label 957: @34027
    GIM_Reject,
    // Label 11: @34028
    GIM_Try, /*On fail goto*//*Label 958*/ GIMT_Encode4(34581),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/1,
      GIM_Try, /*On fail goto*//*Label 959*/ GIMT_Encode4(34058), // Rule ID 149 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSERIALIZE),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_serialize),
        // (intrinsic_void 13660:{ *:[iPTR] })  =>  (SERIALIZE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SERIALIZE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 149,
        GIR_EraseRootFromParent_Done,
      // Label 959: @34058
      GIM_Try, /*On fail goto*//*Label 960*/ GIMT_Encode4(34080), // Rule ID 150 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTSXLDTRK),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xsusldtrk),
        // (intrinsic_void 13988:{ *:[iPTR] })  =>  (XSUSLDTRK)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XSUSLDTRK),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 150,
        GIR_EraseRootFromParent_Done,
      // Label 960: @34080
      GIM_Try, /*On fail goto*//*Label 961*/ GIMT_Encode4(34102), // Rule ID 151 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTSXLDTRK),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xresldtrk),
        // (intrinsic_void 13974:{ *:[iPTR] })  =>  (XRESLDTRK)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XRESLDTRK),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 151,
        GIR_EraseRootFromParent_Done,
      // Label 961: @34102
      GIM_Try, /*On fail goto*//*Label 962*/ GIMT_Encode4(34124), // Rule ID 152 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUINTR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_clui),
        // (intrinsic_void 13523:{ *:[iPTR] })  =>  (CLUI)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CLUI),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 152,
        GIR_EraseRootFromParent_Done,
      // Label 962: @34124
      GIM_Try, /*On fail goto*//*Label 963*/ GIMT_Encode4(34146), // Rule ID 153 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUINTR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_stui),
        // (intrinsic_void 13842:{ *:[iPTR] })  =>  (STUI)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::STUI),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 153,
        GIR_EraseRootFromParent_Done,
      // Label 963: @34146
      GIM_Try, /*On fail goto*//*Label 964*/ GIMT_Encode4(34165), // Rule ID 2458 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_pause),
        // (intrinsic_void 13737:{ *:[iPTR] })  =>  (PAUSE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PAUSE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2458,
        GIR_EraseRootFromParent_Done,
      // Label 964: @34165
      GIM_Try, /*On fail goto*//*Label 965*/ GIMT_Encode4(34187), // Rule ID 2459 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse_sfence),
        // (intrinsic_void 13699:{ *:[iPTR] })  =>  (SFENCE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SFENCE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2459,
        GIR_EraseRootFromParent_Done,
      // Label 965: @34187
      GIM_Try, /*On fail goto*//*Label 966*/ GIMT_Encode4(34209), // Rule ID 2460 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_lfence),
        // (intrinsic_void 13726:{ *:[iPTR] })  =>  (LFENCE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LFENCE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2460,
        GIR_EraseRootFromParent_Done,
      // Label 966: @34209
      GIM_Try, /*On fail goto*//*Label 967*/ GIMT_Encode4(34231), // Rule ID 2461 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMFence),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_mfence),
        // (intrinsic_void 13730:{ *:[iPTR] })  =>  (MFENCE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MFENCE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2461,
        GIR_EraseRootFromParent_Done,
      // Label 967: @34231
      GIM_Try, /*On fail goto*//*Label 968*/ GIMT_Encode4(34297), // Rule ID 3375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_avx_vzeroall),
        // (intrinsic_void 12682:{ *:[iPTR] })  =>  (VZEROALL)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VZEROALL),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM0*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM1*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM2*/2,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM3*/3,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM4*/4,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM5*/5,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM6*/6,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM7*/7,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM8*/8,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM9*/9,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM10*/10,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM11*/11,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM12*/12,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM13*/13,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM14*/14,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM15*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3375,
        GIR_EraseRootFromParent_Done,
      // Label 968: @34297
      GIM_Try, /*On fail goto*//*Label 969*/ GIMT_Encode4(34363), // Rule ID 3376 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_avx_vzeroupper),
        // (intrinsic_void 12683:{ *:[iPTR] })  =>  (VZEROUPPER)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VZEROUPPER),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM0*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM1*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM2*/2,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM3*/3,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM4*/4,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM5*/5,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM6*/6,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM7*/7,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM8*/8,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM9*/9,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM10*/10,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM11*/11,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM12*/12,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM13*/13,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM14*/14,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM15*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3376,
        GIR_EraseRootFromParent_Done,
      // Label 969: @34363
      GIM_Try, /*On fail goto*//*Label 970*/ GIMT_Encode4(34433), // Rule ID 15346 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMMX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_mmx_emms),
        // (intrinsic_void 13558:{ *:[iPTR] })  =>  (MMX_EMMS:{ *:[x86mmx] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MMX_EMMS),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM0*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM1*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM2*/2,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM3*/3,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM4*/4,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM5*/5,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM6*/6,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM7*/7,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST0*/8,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST1*/9,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST2*/10,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST3*/11,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST4*/12,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST5*/13,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST6*/14,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST7*/15,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15346,
        GIR_EraseRootFromParent_Done,
      // Label 970: @34433
      GIM_Try, /*On fail goto*//*Label 971*/ GIMT_Encode4(34455), // Rule ID 15529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xend),
        // (intrinsic_void 13926:{ *:[iPTR] })  =>  (XEND)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XEND),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15529,
        GIR_EraseRootFromParent_Done,
      // Label 971: @34455
      GIM_Try, /*On fail goto*//*Label 972*/ GIMT_Encode4(34501), // Rule ID 15541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXTILE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tilerelease),
        // (intrinsic_void 13868:{ *:[iPTR] })  =>  (TILERELEASE:{ *:[x86amx] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TILERELEASE),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM0*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM1*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM2*/2,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM3*/3,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM4*/4,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM5*/5,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM6*/6,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM7*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15541,
        GIR_EraseRootFromParent_Done,
      // Label 972: @34501
      GIM_Try, /*On fail goto*//*Label 973*/ GIMT_Encode4(34520), // Rule ID 15588 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wbinvd),
        // (intrinsic_void 13913:{ *:[iPTR] })  =>  (WBINVD)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WBINVD),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15588,
        GIR_EraseRootFromParent_Done,
      // Label 973: @34520
      GIM_Try, /*On fail goto*//*Label 974*/ GIMT_Encode4(34542), // Rule ID 15589 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasWBNOINVD),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wbnoinvd),
        // (intrinsic_void 13914:{ *:[iPTR] })  =>  (WBNOINVD)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WBNOINVD),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15589,
        GIR_EraseRootFromParent_Done,
      // Label 974: @34542
      GIM_Try, /*On fail goto*//*Label 975*/ GIMT_Encode4(34561), // Rule ID 15594 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_saveprevssp),
        // (intrinsic_void 13655:{ *:[iPTR] })  =>  (SAVEPREVSSP)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SAVEPREVSSP),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15594,
        GIR_EraseRootFromParent_Done,
      // Label 975: @34561
      GIM_Try, /*On fail goto*//*Label 976*/ GIMT_Encode4(34580), // Rule ID 15604 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_setssbsy),
        // (intrinsic_void 13661:{ *:[iPTR] })  =>  (SETSSBSY)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SETSSBSY),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15604,
        GIR_EraseRootFromParent_Done,
      // Label 976: @34580
      GIM_Reject,
    // Label 958: @34581
    GIM_Try, /*On fail goto*//*Label 977*/ GIMT_Encode4(35575),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_Try, /*On fail goto*//*Label 978*/ GIMT_Encode4(34619), // Rule ID 15577 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_int),
        // MIs[0] Operand 1
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(3),
        // (intrinsic_void 13548:{ *:[iPTR] }, 3:{ *:[i8] })  =>  (INT3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INT3),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15577,
        GIR_EraseRootFromParent_Done,
      // Label 978: @34619
      GIM_Try, /*On fail goto*//*Label 979*/ GIMT_Encode4(34646), // Rule ID 15531 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xabort),
        // MIs[0] imm
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 13924:{ *:[iPTR] }, (timm:{ *:[i8] }):$imm)  =>  (XABORT (timm:{ *:[i8] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XABORT),
        GIR_RootToRootCopy, /*OpIdx*/1, // imm
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15531,
        GIR_EraseRootFromParent_Done,
      // Label 979: @34646
      GIM_Try, /*On fail goto*//*Label 980*/ GIMT_Encode4(34673), // Rule ID 15543 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXTILE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tilezero),
        // MIs[0] src
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 13871:{ *:[iPTR] }, (timm:{ *:[i8] }):$src)  =>  (PTILEZERO (timm:{ *:[i8] }):$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTILEZERO),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15543,
        GIR_EraseRootFromParent_Done,
      // Label 980: @34673
      GIM_Try, /*On fail goto*//*Label 981*/ GIMT_Encode4(34697), // Rule ID 15579 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_int),
        // MIs[0] trap
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 13548:{ *:[iPTR] }, (timm:{ *:[i8] }):$trap)  =>  (INT (timm:{ *:[i8] }):$trap)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INT),
        GIR_RootToRootCopy, /*OpIdx*/1, // trap
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15579,
        GIR_EraseRootFromParent_Done,
      // Label 981: @34697
      GIM_Try, /*On fail goto*//*Label 982*/ GIMT_Encode4(34728), // Rule ID 1 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_flags_read_u32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13534:{ *:[iPTR] })  =>  (RDFLAGS32:{ *:[i32] }:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDFLAGS32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1,
        GIR_EraseRootFromParent_Done,
      // Label 982: @34728
      GIM_Try, /*On fail goto*//*Label 983*/ GIMT_Encode4(34762), // Rule ID 2 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_flags_read_u64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 13535:{ *:[iPTR] })  =>  (RDFLAGS64:{ *:[i64] }:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDFLAGS64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ESP*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2,
        GIR_EraseRootFromParent_Done,
      // Label 983: @34762
      GIM_Try, /*On fail goto*//*Label 984*/ GIMT_Encode4(34793), // Rule ID 115 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_slwpcb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13669:{ *:[iPTR] })  =>  (SLWPCB:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SLWPCB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 115,
        GIR_EraseRootFromParent_Done,
      // Label 984: @34793
      GIM_Try, /*On fail goto*//*Label 985*/ GIMT_Encode4(34824), // Rule ID 117 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_slwpcb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 13669:{ *:[iPTR] })  =>  (SLWPCB64:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SLWPCB64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 117,
        GIR_EraseRootFromParent_Done,
      // Label 985: @34824
      GIM_Try, /*On fail goto*//*Label 986*/ GIMT_Encode4(34855), // Rule ID 15528 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xbegin),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13925:{ *:[iPTR] })  =>  (XBEGIN:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XBEGIN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15528,
        GIR_EraseRootFromParent_Done,
      // Label 986: @34855
      GIM_Try, /*On fail goto*//*Label 987*/ GIMT_Encode4(34886), // Rule ID 15621 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdfsbase_32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13636:{ *:[iPTR] })  =>  (RDFSBASE:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDFSBASE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15621,
        GIR_EraseRootFromParent_Done,
      // Label 987: @34886
      GIM_Try, /*On fail goto*//*Label 988*/ GIMT_Encode4(34917), // Rule ID 15622 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdfsbase_64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 13637:{ *:[iPTR] })  =>  (RDFSBASE64:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDFSBASE64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15622,
        GIR_EraseRootFromParent_Done,
      // Label 988: @34917
      GIM_Try, /*On fail goto*//*Label 989*/ GIMT_Encode4(34948), // Rule ID 15623 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdgsbase_32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13638:{ *:[iPTR] })  =>  (RDGSBASE:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDGSBASE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15623,
        GIR_EraseRootFromParent_Done,
      // Label 989: @34948
      GIM_Try, /*On fail goto*//*Label 990*/ GIMT_Encode4(34979), // Rule ID 15624 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdgsbase_64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 13639:{ *:[iPTR] })  =>  (RDGSBASE64:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDGSBASE64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15624,
        GIR_EraseRootFromParent_Done,
      // Label 990: @34979
      GIM_Try, /*On fail goto*//*Label 991*/ GIMT_Encode4(35010), // Rule ID 15630 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRDPID_Not64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdpid),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13640:{ *:[iPTR] })  =>  (RDPID32:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDPID32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15630,
        GIR_EraseRootFromParent_Done,
      // Label 991: @35010
      GIM_Try, /*On fail goto*//*Label 992*/ GIMT_Encode4(35067), // Rule ID 20794 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRDPID_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdpid),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13640:{ *:[iPTR] })  =>  (EXTRACT_SUBREG:{ *:[i32] } (RDPID64:{ *:[i64] }), sub_32bit:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::RDPID64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_32bit),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        // GIR_Coverage, 20794,
        GIR_EraseRootFromParent_Done,
      // Label 992: @35067
      GIM_Try, /*On fail goto*//*Label 993*/ GIMT_Encode4(35104), // Rule ID 3 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_flags_write_u32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13536:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (WRFLAGS32:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRFLAGS32),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::DF*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3,
        GIR_EraseRootFromParent_Done,
      // Label 993: @35104
      GIM_Try, /*On fail goto*//*Label 994*/ GIMT_Encode4(35141), // Rule ID 4 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_flags_write_u64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13537:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (WRFLAGS64:{ *:[i64] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRFLAGS64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::DF*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4,
        GIR_EraseRootFromParent_Done,
      // Label 994: @35141
      GIM_Try, /*On fail goto*//*Label 995*/ GIMT_Encode4(35172), // Rule ID 154 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUINTR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_senduipi),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13659:{ *:[iPTR] }, GR64:{ *:[i64] }:$arg)  =>  (SENDUIPI GR64:{ *:[i64] }:$arg)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SENDUIPI),
        GIR_RootToRootCopy, /*OpIdx*/1, // arg
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 154,
        GIR_EraseRootFromParent_Done,
      // Label 995: @35172
      GIM_Try, /*On fail goto*//*Label 996*/ GIMT_Encode4(35200), // Rule ID 15590 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_incsspd),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13546:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (INCSSPD GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INCSSPD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15590,
        GIR_EraseRootFromParent_Done,
      // Label 996: @35200
      GIM_Try, /*On fail goto*//*Label 997*/ GIMT_Encode4(35228), // Rule ID 15591 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_incsspq),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13547:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (INCSSPQ GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INCSSPQ),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15591,
        GIR_EraseRootFromParent_Done,
      // Label 997: @35228
      GIM_Try, /*On fail goto*//*Label 998*/ GIMT_Encode4(35259), // Rule ID 15625 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wrfsbase_32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13915:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (WRFSBASE GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRFSBASE),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15625,
        GIR_EraseRootFromParent_Done,
      // Label 998: @35259
      GIM_Try, /*On fail goto*//*Label 999*/ GIMT_Encode4(35290), // Rule ID 15626 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wrfsbase_64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13916:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (WRFSBASE64 GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRFSBASE64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15626,
        GIR_EraseRootFromParent_Done,
      // Label 999: @35290
      GIM_Try, /*On fail goto*//*Label 1000*/ GIMT_Encode4(35321), // Rule ID 15627 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wrgsbase_32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13917:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (WRGSBASE GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRGSBASE),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15627,
        GIR_EraseRootFromParent_Done,
      // Label 1000: @35321
      GIM_Try, /*On fail goto*//*Label 1001*/ GIMT_Encode4(35352), // Rule ID 15628 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wrgsbase_64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13918:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (WRGSBASE64 GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRGSBASE64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15628,
        GIR_EraseRootFromParent_Done,
      // Label 1001: @35352
      GIM_Try, /*On fail goto*//*Label 1002*/ GIMT_Encode4(35383), // Rule ID 15633 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasPTWRITE),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_ptwrite32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13634:{ *:[iPTR] }, GR32:{ *:[i32] }:$dst)  =>  (PTWRITEr GR32:{ *:[i32] }:$dst)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTWRITEr),
        GIR_RootToRootCopy, /*OpIdx*/1, // dst
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15633,
        GIR_EraseRootFromParent_Done,
      // Label 1002: @35383
      GIM_Try, /*On fail goto*//*Label 1003*/ GIMT_Encode4(35414), // Rule ID 15634 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasPTWRITE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_ptwrite64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13635:{ *:[iPTR] }, GR64:{ *:[i64] }:$dst)  =>  (PTWRITE64r GR64:{ *:[i64] }:$dst)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTWRITE64r),
        GIR_RootToRootCopy, /*OpIdx*/1, // dst
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15634,
        GIR_EraseRootFromParent_Done,
      // Label 1003: @35414
      GIM_Try, /*On fail goto*//*Label 1004*/ GIMT_Encode4(35446), // Rule ID 114 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_llwpcb),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13552:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (LLWPCB GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LLWPCB),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 114,
        GIR_EraseRootFromParent_Done,
      // Label 1004: @35446
      GIM_Try, /*On fail goto*//*Label 1005*/ GIMT_Encode4(35478), // Rule ID 116 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_llwpcb),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13552:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (LLWPCB64 GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LLWPCB64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 116,
        GIR_EraseRootFromParent_Done,
      // Label 1005: @35478
      GIM_Try, /*On fail goto*//*Label 1006*/ GIMT_Encode4(35510), // Rule ID 126 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasWAITPKG_Not64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_umonitor),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (intrinsic_void 13874:{ *:[iPTR] }, GR16:{ *:[i16] }:$src)  =>  (UMONITOR16 GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UMONITOR16),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 126,
        GIR_EraseRootFromParent_Done,
      // Label 1006: @35510
      GIM_Try, /*On fail goto*//*Label 1007*/ GIMT_Encode4(35542), // Rule ID 127 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasWAITPKG),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_umonitor),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13874:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (UMONITOR32 GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UMONITOR32),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 127,
        GIR_EraseRootFromParent_Done,
      // Label 1007: @35542
      GIM_Try, /*On fail goto*//*Label 1008*/ GIMT_Encode4(35574), // Rule ID 128 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasWAITPKG_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_umonitor),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13874:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (UMONITOR64 GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UMONITOR64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 128,
        GIR_EraseRootFromParent_Done,
      // Label 1008: @35574
      GIM_Reject,
    // Label 977: @35575
    GIM_Try, /*On fail goto*//*Label 1009*/ GIMT_Encode4(35925),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 1010*/ GIMT_Encode4(35626), // Rule ID 15654 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::asan_check_memaccess),
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64PLTSafeRegClassID),
        // MIs[0] accessinfo
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_void 9:{ *:[iPTR] }, GR64PLTSafe:{ *:[i64] }:$addr, (timm:{ *:[i32] }):$accessinfo)  =>  (ASAN_CHECK_MEMACCESS:{ *:[i64] } GR64PLTSafe:{ *:[i64] }:$addr, (timm:{ *:[i32] }):$accessinfo)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ASAN_CHECK_MEMACCESS),
        GIR_RootToRootCopy, /*OpIdx*/1, // addr
        GIR_RootToRootCopy, /*OpIdx*/2, // accessinfo
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::R10*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::R11*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15654,
        GIR_EraseRootFromParent_Done,
      // Label 1010: @35626
      GIM_Try, /*On fail goto*//*Label 1011*/ GIMT_Encode4(35666), // Rule ID 15580 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUSERMSR_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_urdmsr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 13876:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (URDMSRrr:{ *:[i64] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::URDMSRrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15580,
        GIR_EraseRootFromParent_Done,
      // Label 1011: @35666
      GIM_Try, /*On fail goto*//*Label 1012*/ GIMT_Encode4(35706), // Rule ID 15584 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasEGPR_HasUSERMSR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_urdmsr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 13876:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (URDMSRrr_EVEX:{ *:[i64] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::URDMSRrr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15584,
        GIR_EraseRootFromParent_Done,
      // Label 1012: @35706
      GIM_Try, /*On fail goto*//*Label 1013*/ GIMT_Encode4(35743), // Rule ID 15592 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdsspd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 13650:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (RDSSPD:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDSSPD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15592,
        GIR_EraseRootFromParent_Done,
      // Label 1013: @35743
      GIM_Try, /*On fail goto*//*Label 1014*/ GIMT_Encode4(35780), // Rule ID 15593 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdsspq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 13651:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (RDSSPQ:{ *:[i64] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDSSPQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15593,
        GIR_EraseRootFromParent_Done,
      // Label 1014: @35780
      GIM_Try, /*On fail goto*//*Label 1015*/ GIMT_Encode4(35844), // Rule ID 3034 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse3_mwait),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32_ArgRef_and_GR32_CBRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32_ADRegClassID),
        // (intrinsic_void 13775:{ *:[iPTR] }, ECX:{ *:[i32] }, EAX:{ *:[i32] })  =>  (MWAITrr)
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/2, GIMT_Encode2(X86::EAX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // EAX
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::ECX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // ECX
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MWAITrr),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3034,
        GIR_EraseRootFromParent_Done,
      // Label 1015: @35844
      GIM_Try, /*On fail goto*//*Label 1016*/ GIMT_Encode4(35884), // Rule ID 15582 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUSERMSR_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_uwrmsr),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13877:{ *:[iPTR] }, GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (UWRMSRrr GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UWRMSRrr),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15582,
        GIR_EraseRootFromParent_Done,
      // Label 1016: @35884
      GIM_Try, /*On fail goto*//*Label 1017*/ GIMT_Encode4(35924), // Rule ID 15586 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasEGPR_HasUSERMSR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_uwrmsr),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 13877:{ *:[iPTR] }, GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (UWRMSRrr_EVEX GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UWRMSRrr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15586,
        GIR_EraseRootFromParent_Done,
      // Label 1017: @35924
      GIM_Reject,
    // Label 1009: @35925
    GIM_Try, /*On fail goto*//*Label 1018*/ GIMT_Encode4(36699),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 1019*/ GIMT_Encode4(35970), // Rule ID 15548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXINT8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbssd),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13853:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBSSD (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBSSD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15548,
        GIR_EraseRootFromParent_Done,
      // Label 1019: @35970
      GIM_Try, /*On fail goto*//*Label 1020*/ GIMT_Encode4(36007), // Rule ID 15549 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXINT8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbsud),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13855:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBSUD (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBSUD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15549,
        GIR_EraseRootFromParent_Done,
      // Label 1020: @36007
      GIM_Try, /*On fail goto*//*Label 1021*/ GIMT_Encode4(36044), // Rule ID 15550 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXINT8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbusd),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13857:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBUSD (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBUSD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15550,
        GIR_EraseRootFromParent_Done,
      // Label 1021: @36044
      GIM_Try, /*On fail goto*//*Label 1022*/ GIMT_Encode4(36081), // Rule ID 15551 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXINT8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbuud),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13859:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBUUD (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBUUD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15551,
        GIR_EraseRootFromParent_Done,
      // Label 1022: @36081
      GIM_Try, /*On fail goto*//*Label 1023*/ GIMT_Encode4(36118), // Rule ID 15553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXBF16_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbf16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13851:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBF16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBF16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15553,
        GIR_EraseRootFromParent_Done,
      // Label 1023: @36118
      GIM_Try, /*On fail goto*//*Label 1024*/ GIMT_Encode4(36155), // Rule ID 15555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXFP16_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpfp16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13861:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPFP16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPFP16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15555,
        GIR_EraseRootFromParent_Done,
      // Label 1024: @36155
      GIM_Try, /*On fail goto*//*Label 1025*/ GIMT_Encode4(36192), // Rule ID 15558 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXCOMPLEX_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tcmmimfp16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13847:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTCMMIMFP16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTCMMIMFP16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15558,
        GIR_EraseRootFromParent_Done,
      // Label 1025: @36192
      GIM_Try, /*On fail goto*//*Label 1026*/ GIMT_Encode4(36229), // Rule ID 15559 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXCOMPLEX_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tcmmrlfp16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13849:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTCMMRLFP16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTCMMRLFP16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15559,
        GIR_EraseRootFromParent_Done,
      // Label 1026: @36229
      GIM_Try, /*On fail goto*//*Label 1027*/ GIMT_Encode4(36274), // Rule ID 122 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_lwpval32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // MIs[0] cntl
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13556:{ *:[iPTR] }, GR32:{ *:[i32] }:$src0, GR32:{ *:[i32] }:$src1, (timm:{ *:[i32] }):$cntl)  =>  (LWPVAL32rri GR32:{ *:[i32] }:$src0, GR32:{ *:[i32] }:$src1, (timm:{ *:[i32] }):$cntl)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LWPVAL32rri),
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // cntl
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 122,
        GIR_EraseRootFromParent_Done,
      // Label 1027: @36274
      GIM_Try, /*On fail goto*//*Label 1028*/ GIMT_Encode4(36319), // Rule ID 124 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_lwpval64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // MIs[0] cntl
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 13557:{ *:[iPTR] }, GR64:{ *:[i64] }:$src0, GR32:{ *:[i32] }:$src1, (timm:{ *:[i32] }):$cntl)  =>  (LWPVAL64rri GR64:{ *:[i64] }:$src0, GR32:{ *:[i32] }:$src1, (timm:{ *:[i32] }):$cntl)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LWPVAL64rri),
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // cntl
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 124,
        GIR_EraseRootFromParent_Done,
      // Label 1028: @36319
      GIM_Try, /*On fail goto*//*Label 1029*/ GIMT_Encode4(36401), // Rule ID 15606 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xsetbv),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32_ArgRef_and_GR32_CBRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32_AD_and_GR32_ArgRefRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32_ADRegClassID),
        // (intrinsic_void 13987:{ *:[iPTR] }, ECX:{ *:[i32] }, EDX:{ *:[i32] }, EAX:{ *:[i32] })  =>  (XSETBV)
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/3, GIMT_Encode2(X86::EAX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/3, // EAX
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/2, GIMT_Encode2(X86::EDX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // EDX
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::ECX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // ECX
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XSETBV),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15606,
        GIR_EraseRootFromParent_Done,
      // Label 1029: @36401
      GIM_Try, /*On fail goto*//*Label 1030*/ GIMT_Encode4(36450), // Rule ID 15795 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMWAITX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_mwaitx),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 13630:{ *:[iPTR] }, GR32:{ *:[i32] }:$ecx, GR32:{ *:[i32] }:$eax, GR32:{ *:[i32] }:$ebx)  =>  (MWAITX GR32:{ *:[i32] }:$ecx, GR32:{ *:[i32] }:$eax, GR32:{ *:[i32] }:$ebx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MWAITX),
        GIR_RootToRootCopy, /*OpIdx*/1, // ecx
        GIR_RootToRootCopy, /*OpIdx*/2, // eax
        GIR_RootToRootCopy, /*OpIdx*/3, // ebx
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 15795,
        GIR_EraseRootFromParent_Done,
      // Label 1030: @36450
      GIM_Try, /*On fail goto*//*Label 1031*/ GIMT_Encode4(36512), // Rule ID 2851 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_maskmov_dqu),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] Operand 3
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/3, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR64_with_sub_32bit_in_GR32_DIBP_and_GR32_SIDIRegClassID),
        // (intrinsic_void 13727:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask, RDI:{ *:[i64] })  =>  (VMASKMOVDQU64 VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::RDI), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // RDI
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMASKMOVDQU64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2851,
        GIR_EraseRootFromParent_Done,
      // Label 1031: @36512
      GIM_Try, /*On fail goto*//*Label 1032*/ GIMT_Encode4(36574), // Rule ID 2852 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_maskmov_dqu),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] Operand 3
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/3, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32_DIBP_and_GR32_SIDIRegClassID),
        // (intrinsic_void 13727:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask, EDI:{ *:[i32] })  =>  (VMASKMOVDQU VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::EDI), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // EDI
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMASKMOVDQU),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2852,
        GIR_EraseRootFromParent_Done,
      // Label 1032: @36574
      GIM_Try, /*On fail goto*//*Label 1033*/ GIMT_Encode4(36636), // Rule ID 2853 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode_UseSSE2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_maskmov_dqu),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] Operand 3
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/3, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR64_with_sub_32bit_in_GR32_DIBP_and_GR32_SIDIRegClassID),
        // (intrinsic_void 13727:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask, RDI:{ *:[i64] })  =>  (MASKMOVDQU64 VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::RDI), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // RDI
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MASKMOVDQU64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2853,
        GIR_EraseRootFromParent_Done,
      // Label 1033: @36636
      GIM_Try, /*On fail goto*//*Label 1034*/ GIMT_Encode4(36698), // Rule ID 2854 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_maskmov_dqu),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] Operand 3
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/3, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32_DIBP_and_GR32_SIDIRegClassID),
        // (intrinsic_void 13727:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask, EDI:{ *:[i32] })  =>  (MASKMOVDQU VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::EDI), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // EDI
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MASKMOVDQU),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2854,
        GIR_EraseRootFromParent_Done,
      // Label 1034: @36698
      GIM_Reject,
    // Label 1018: @36699
    GIM_Try, /*On fail goto*//*Label 1035*/ GIMT_Encode4(36787), // Rule ID 15532 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasKL),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_loadiwkey),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::GR32_ADRegClassID),
      // (intrinsic_void 13553:{ *:[iPTR] }, XMM0:{ *:[v2i64] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, EAX:{ *:[i32] })  =>  (LOADIWKEY:{ *:[i32] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddRegister, /*InsnID*/2, GIMT_Encode2(X86::EAX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // EAX
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::XMM0), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // XMM0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LOADIWKEY),
      GIR_RootToRootCopy, /*OpIdx*/2, // src1
      GIR_RootToRootCopy, /*OpIdx*/3, // src2
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 15532,
      GIR_EraseRootFromParent_Done,
    // Label 1035: @36787
    GIM_Reject,
    // Label 12: @36788
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(5), /*)*//*default:*//*Label 1039*/ GIMT_Encode4(37222),
    /*GILLT_s16*//*Label 1036*/ GIMT_Encode4(36811),
    /*GILLT_s32*//*Label 1037*/ GIMT_Encode4(36869),
    /*GILLT_s64*//*Label 1038*/ GIMT_Encode4(37044),
    // Label 1036: @36811
    GIM_Try, /*On fail goto*//*Label 1040*/ GIMT_Encode4(36868), // Rule ID 21001 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      // (anyext:{ *:[i16] } GR8:{ *:[i8] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (MOVZX32rr8:{ *:[i32] } GR8:{ *:[i8] }:$src), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 21001,
      GIR_EraseRootFromParent_Done,
    // Label 1040: @36868
    GIM_Reject,
    // Label 1037: @36869
    GIM_Try, /*On fail goto*//*Label 1041*/ GIMT_Encode4(36915), // Rule ID 17971 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (anyext:{ *:[i32] } (bitconvert:{ *:[i16] } VK16:{ *:[v16i1] }:$src))  =>  (COPY_TO_REGCLASS:{ *:[i32] } VK16:{ *:[v16i1] }:$src, GR32:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 17971,
      GIR_EraseRootFromParent_Done,
    // Label 1041: @36915
    GIM_Try, /*On fail goto*//*Label 1042*/ GIMT_Encode4(36961), // Rule ID 17974 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (anyext:{ *:[i32] } (bitconvert:{ *:[i8] } VK8:{ *:[v8i1] }:$src))  =>  (COPY_TO_REGCLASS:{ *:[i32] } VK8:{ *:[v8i1] }:$src, GR32:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 17974,
      GIR_EraseRootFromParent_Done,
    // Label 1042: @36961
    GIM_Try, /*On fail goto*//*Label 1043*/ GIMT_Encode4(36984), // Rule ID 21002 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      // (anyext:{ *:[i32] } GR8:{ *:[i8] }:$src)  =>  (MOVZX32rr8:{ *:[i32] } GR8:{ *:[i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21002,
      GIR_Done,
    // Label 1043: @36984
    GIM_Try, /*On fail goto*//*Label 1044*/ GIMT_Encode4(37043), // Rule ID 21003 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (anyext:{ *:[i32] } GR16:{ *:[i16] }:$src)  =>  (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      // GIR_Coverage, 21003,
      GIR_EraseRootFromParent_Done,
    // Label 1044: @37043
    GIM_Reject,
    // Label 1038: @37044
    GIM_Try, /*On fail goto*//*Label 1045*/ GIMT_Encode4(37103), // Rule ID 21004 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      // (anyext:{ *:[i64] } GR8:{ *:[i8] }:$src)  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (MOVZX32rr8:{ *:[i32] } GR8:{ *:[i8] }:$src), sub_32bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 21004,
      GIR_EraseRootFromParent_Done,
    // Label 1045: @37103
    GIM_Try, /*On fail goto*//*Label 1046*/ GIMT_Encode4(37162), // Rule ID 21005 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (anyext:{ *:[i64] } GR16:{ *:[i16] }:$src)  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (MOVZX32rr16:{ *:[i32] } GR16:{ *:[i16] }:$src), sub_32bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr16),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 21005,
      GIR_EraseRootFromParent_Done,
    // Label 1046: @37162
    GIM_Try, /*On fail goto*//*Label 1047*/ GIMT_Encode4(37221), // Rule ID 21006 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (anyext:{ *:[i64] } GR32:{ *:[i32] }:$src)  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR32:{ *:[i32] }:$src, sub_32bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 21006,
      GIR_EraseRootFromParent_Done,
    // Label 1047: @37221
    GIM_Reject,
    // Label 1039: @37222
    GIM_Reject,
    // Label 13: @37223
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(22), /*)*//*default:*//*Label 1056*/ GIMT_Encode4(38226),
    /*GILLT_s8*//*Label 1048*/ GIMT_Encode4(37318),
    /*GILLT_s16*//*Label 1049*/ GIMT_Encode4(37593), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 1050*/ GIMT_Encode4(37632), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 1051*/ GIMT_Encode4(37772),
    /*GILLT_v8s32*//*Label 1052*/ GIMT_Encode4(37935), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 1053*/ GIMT_Encode4(37962),
    /*GILLT_v16s16*//*Label 1054*/ GIMT_Encode4(38172), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v32s8*//*Label 1055*/ GIMT_Encode4(38199),
    // Label 1048: @37318
    GIM_Try, /*On fail goto*//*Label 1057*/ GIMT_Encode4(37390), // Rule ID 17966 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (trunc:{ *:[i8] } (bitconvert:{ *:[i16] } VK16:{ *:[v16i1] }:$src))  =>  (EXTRACT_SUBREG:{ *:[i8] } (COPY_TO_REGCLASS:{ *:[i32] } VK16:{ *:[v16i1] }:$src, GR32:{ *:[i32] }), sub_8bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_8bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 17966,
      GIR_EraseRootFromParent_Done,
    // Label 1057: @37390
    GIM_Try, /*On fail goto*//*Label 1058*/ GIMT_Encode4(37450), // Rule ID 21063 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32_ABCDRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (trunc:{ *:[i8] } GR32:{ *:[i32] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } (COPY_TO_REGCLASS:{ *:[i32] } GR32:{ *:[i32] }:$src, GR32_ABCD:{ *:[i32] }), sub_8bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_8bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8_ABCD_LRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32_ABCDRegClassID),
      // GIR_Coverage, 21063,
      GIR_EraseRootFromParent_Done,
    // Label 1058: @37450
    GIM_Try, /*On fail goto*//*Label 1059*/ GIMT_Encode4(37510), // Rule ID 21064 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16_ABCDRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (trunc:{ *:[i8] } GR16:{ *:[i16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } (COPY_TO_REGCLASS:{ *:[i16] } GR16:{ *:[i16] }:$src, GR16_ABCD:{ *:[i32] }), sub_8bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_8bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8_ABCD_LRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR16_ABCDRegClassID),
      // GIR_Coverage, 21064,
      GIR_EraseRootFromParent_Done,
    // Label 1059: @37510
    GIM_Try, /*On fail goto*//*Label 1060*/ GIMT_Encode4(37551), // Rule ID 21068 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (trunc:{ *:[i8] } GR32:{ *:[i32] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } GR32:{ *:[i32] }:$src, sub_8bit:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopySubReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 21068,
      GIR_EraseRootFromParent_Done,
    // Label 1060: @37551
    GIM_Try, /*On fail goto*//*Label 1061*/ GIMT_Encode4(37592), // Rule ID 21069 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (trunc:{ *:[i8] } GR16:{ *:[i16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } GR16:{ *:[i16] }:$src, sub_8bit:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopySubReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
      // GIR_Coverage, 21069,
      GIR_EraseRootFromParent_Done,
    // Label 1061: @37592
    GIM_Reject,
    // Label 1049: @37593
    GIM_Try, /*On fail goto*//*Label 1062*/ GIMT_Encode4(37631), // Rule ID 21062 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (trunc:{ *:[i16] } GR32:{ *:[i32] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } GR32:{ *:[i32] }:$src, sub_16bit:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopySubReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(4), // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 21062,
      GIR_EraseRootFromParent_Done,
    // Label 1062: @37631
    GIM_Reject,
    // Label 1050: @37632
    GIM_Try, /*On fail goto*//*Label 1063*/ GIMT_Encode4(37771),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 1064*/ GIMT_Encode4(37663), // Rule ID 12148 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (trunc:{ *:[v4i32] } VR256X:{ *:[v4i64] }:$src)  =>  (VPMOVQDZ256rr:{ *:[v4i32] } VR256X:{ *:[v4i64] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVQDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12148,
        GIR_Done,
      // Label 1064: @37663
      GIM_Try, /*On fail goto*//*Label 1065*/ GIMT_Encode4(37770), // Rule ID 20137 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (trunc:{ *:[v4i32] } VR256X:{ *:[v4i64] }:$src)  =>  (EXTRACT_SUBREG:{ *:[v4i32] } (VPMOVQDZrr:{ *:[v8i32] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src, sub_ymm:{ *:[i32] })), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s32,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMOVQDZrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR256XRegClassID),
        // GIR_Coverage, 20137,
        GIR_EraseRootFromParent_Done,
      // Label 1065: @37770
      GIM_Reject,
    // Label 1063: @37771
    GIM_Reject,
    // Label 1051: @37772
    GIM_Try, /*On fail goto*//*Label 1066*/ GIMT_Encode4(37798), // Rule ID 12124 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (trunc:{ *:[v8i16] } VR512:{ *:[v8i64] }:$src)  =>  (VPMOVQWZrr:{ *:[v8i16] } VR512:{ *:[v8i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVQWZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12124,
      GIR_Done,
    // Label 1066: @37798
    GIM_Try, /*On fail goto*//*Label 1067*/ GIMT_Encode4(37824), // Rule ID 12202 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (trunc:{ *:[v8i16] } VR256X:{ *:[v8i32] }:$src)  =>  (VPMOVDWZ256rr:{ *:[v8i16] } VR256X:{ *:[v8i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVDWZ256rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12202,
      GIR_Done,
    // Label 1067: @37824
    GIM_Try, /*On fail goto*//*Label 1068*/ GIMT_Encode4(37934), // Rule ID 20136 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (trunc:{ *:[v8i16] } VR256X:{ *:[v8i32] }:$src)  =>  (EXTRACT_SUBREG:{ *:[v8i16] } (VPMOVDWZrr:{ *:[v16i16] } (INSERT_SUBREG:{ *:[v16i32] } (IMPLICIT_DEF:{ *:[v16i32] }), VR256X:{ *:[v8i32] }:$src, sub_ymm:{ *:[i32] })), sub_xmm:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s16,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s32,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMOVDWZrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR256XRegClassID),
      // GIR_Coverage, 20136,
      GIR_EraseRootFromParent_Done,
    // Label 1068: @37934
    GIM_Reject,
    // Label 1052: @37935
    GIM_Try, /*On fail goto*//*Label 1069*/ GIMT_Encode4(37961), // Rule ID 12151 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (trunc:{ *:[v8i32] } VR512:{ *:[v8i64] }:$src)  =>  (VPMOVQDZrr:{ *:[v8i32] } VR512:{ *:[v8i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVQDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12151,
      GIR_Done,
    // Label 1069: @37961
    GIM_Reject,
    // Label 1053: @37962
    GIM_Try, /*On fail goto*//*Label 1070*/ GIMT_Encode4(37988), // Rule ID 12178 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (trunc:{ *:[v16i8] } VR512:{ *:[v16i32] }:$src)  =>  (VPMOVDBZrr:{ *:[v16i8] } VR512:{ *:[v16i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVDBZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12178,
      GIR_Done,
    // Label 1070: @37988
    GIM_Try, /*On fail goto*//*Label 1071*/ GIMT_Encode4(38014), // Rule ID 12229 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (trunc:{ *:[v16i8] } VR256X:{ *:[v16i16] }:$src)  =>  (VPMOVWBZ256rr:{ *:[v16i8] } VR256X:{ *:[v16i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVWBZ256rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12229,
      GIR_Done,
    // Label 1071: @38014
    GIM_Try, /*On fail goto*//*Label 1072*/ GIMT_Encode4(38124), // Rule ID 20138 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasEVEX512_NoVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (trunc:{ *:[v16i8] } VR256X:{ *:[v16i16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[v16i8] } (VPMOVWBZrr:{ *:[v32i8] } (INSERT_SUBREG:{ *:[v32i16] } (IMPLICIT_DEF:{ *:[v32i16] }), VR256X:{ *:[v16i16] }:$src, sub_ymm:{ *:[i32] })), sub_xmm:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v32s8,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v32s16,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v32s16,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/2, /*Imm*/10,
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMOVWBZrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR256XRegClassID),
      // GIR_Coverage, 20138,
      GIR_EraseRootFromParent_Done,
    // Label 1072: @38124
    GIM_Try, /*On fail goto*//*Label 1073*/ GIMT_Encode4(38171), // Rule ID 20229 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_NoBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (trunc:{ *:[v16i8] } VR256X:{ *:[v16i16] }:$src)  =>  (VPMOVDBZrr:{ *:[v16i8] } (VPMOVZXWDZrr:{ *:[v16i32] } VR256X:{ *:[v16i16] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMOVZXWDZrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMOVDBZrr),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 20229,
      GIR_EraseRootFromParent_Done,
    // Label 1073: @38171
    GIM_Reject,
    // Label 1054: @38172
    GIM_Try, /*On fail goto*//*Label 1074*/ GIMT_Encode4(38198), // Rule ID 12205 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (trunc:{ *:[v16i16] } VR512:{ *:[v16i32] }:$src)  =>  (VPMOVDWZrr:{ *:[v16i16] } VR512:{ *:[v16i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVDWZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12205,
      GIR_Done,
    // Label 1074: @38198
    GIM_Reject,
    // Label 1055: @38199
    GIM_Try, /*On fail goto*//*Label 1075*/ GIMT_Encode4(38225), // Rule ID 12232 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (trunc:{ *:[v32i8] } VR512:{ *:[v32i16] }:$src)  =>  (VPMOVWBZrr:{ *:[v32i8] } VR512:{ *:[v32i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVWBZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12232,
      GIR_Done,
    // Label 1075: @38225
    GIM_Reject,
    // Label 1056: @38226
    GIM_Reject,
    // Label 14: @38227
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(5), /*)*//*default:*//*Label 1080*/ GIMT_Encode4(38836),
    /*GILLT_s8*//*Label 1076*/ GIMT_Encode4(38254),
    /*GILLT_s16*//*Label 1077*/ GIMT_Encode4(38334),
    /*GILLT_s32*//*Label 1078*/ GIMT_Encode4(38540),
    /*GILLT_s64*//*Label 1079*/ GIMT_Encode4(38682),
    // Label 1076: @38254
    GIM_Try, /*On fail goto*//*Label 1081*/ GIMT_Encode4(38314), // Rule ID 20797 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(0),
      // 0:{ *:[i8] }  =>  (EXTRACT_SUBREG:{ *:[i8] } (MOV32r0:{ *:[i32] }:{ *:[i32] }), sub_8bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOV32r0),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_SetImplicitDefDead, /*InsnID*/1, /*OpIdx for X86::EFLAGS*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_8bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 20797,
      GIR_EraseRootFromParent_Done,
    // Label 1081: @38314
    GIM_Try, /*On fail goto*//*Label 1082*/ GIMT_Encode4(38333), // Rule ID 19 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i8] }):$src  =>  (MOV8ri:{ *:[i8] } (imm:{ *:[i8] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV8ri),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 19,
      GIR_EraseRootFromParent_Done,
    // Label 1082: @38333
    GIM_Reject,
    // Label 1077: @38334
    GIM_Try, /*On fail goto*//*Label 1083*/ GIMT_Encode4(38394), // Rule ID 20798 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(0),
      // 0:{ *:[i16] }  =>  (EXTRACT_SUBREG:{ *:[i16] } (MOV32r0:{ *:[i32] }:{ *:[i32] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOV32r0),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_SetImplicitDefDead, /*InsnID*/1, /*OpIdx for X86::EFLAGS*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 20798,
      GIR_EraseRootFromParent_Done,
    // Label 1083: @38394
    GIM_Try, /*On fail goto*//*Label 1084*/ GIMT_Encode4(38457), // Rule ID 20800 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode_OptForSize),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(1),
      // 1:{ *:[i16] }  =>  (EXTRACT_SUBREG:{ *:[i16] } (MOV32r1:{ *:[i32] }:{ *:[i32] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOV32r1),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_SetImplicitDefDead, /*InsnID*/1, /*OpIdx for X86::EFLAGS*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 20800,
      GIR_EraseRootFromParent_Done,
    // Label 1084: @38457
    GIM_Try, /*On fail goto*//*Label 1085*/ GIMT_Encode4(38520), // Rule ID 20801 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode_OptForSize),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(-1),
      // -1:{ *:[i16] }  =>  (EXTRACT_SUBREG:{ *:[i16] } (MOV32r_1:{ *:[i32] }:{ *:[i32] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOV32r_1),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_SetImplicitDefDead, /*InsnID*/1, /*OpIdx for X86::EFLAGS*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 20801,
      GIR_EraseRootFromParent_Done,
    // Label 1085: @38520
    GIM_Try, /*On fail goto*//*Label 1086*/ GIMT_Encode4(38539), // Rule ID 20 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i16] }):$src  =>  (MOV16ri:{ *:[i16] } (imm:{ *:[i16] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV16ri),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 20,
      GIR_EraseRootFromParent_Done,
    // Label 1086: @38539
    GIM_Reject,
    // Label 1078: @38540
    GIM_Try, /*On fail goto*//*Label 1087*/ GIMT_Encode4(38570), // Rule ID 15655 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(0),
      // 0:{ *:[i32] }  =>  (MOV32r0:{ *:[i32] }:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV32r0),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 15655,
      GIR_EraseRootFromParent_Done,
    // Label 1087: @38570
    GIM_Try, /*On fail goto*//*Label 1088*/ GIMT_Encode4(38603), // Rule ID 15656 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode_OptForSize),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(1),
      // 1:{ *:[i32] }  =>  (MOV32r1:{ *:[i32] }:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV32r1),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 15656,
      GIR_EraseRootFromParent_Done,
    // Label 1088: @38603
    GIM_Try, /*On fail goto*//*Label 1089*/ GIMT_Encode4(38636), // Rule ID 15657 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode_OptForSize),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(-1),
      // -1:{ *:[i32] }  =>  (MOV32r_1:{ *:[i32] }:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV32r_1),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 15657,
      GIR_EraseRootFromParent_Done,
    // Label 1089: @38636
    GIM_Try, /*On fail goto*//*Label 1090*/ GIMT_Encode4(38662), // Rule ID 15658 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotWin64WithoutFP_OptForMinSize),
      GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i32immSExt8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i32] })<<P:Predicate_i32immSExt8>>:$src  =>  (MOV32ImmSExti8:{ *:[i32] } (imm:{ *:[i32] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV32ImmSExti8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 15658,
      GIR_EraseRootFromParent_Done,
    // Label 1090: @38662
    GIM_Try, /*On fail goto*//*Label 1091*/ GIMT_Encode4(38681), // Rule ID 21 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i32] }):$src  =>  (MOV32ri:{ *:[i32] } (imm:{ *:[i32] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV32ri),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21,
      GIR_EraseRootFromParent_Done,
    // Label 1091: @38681
    GIM_Reject,
    // Label 1079: @38682
    GIM_Try, /*On fail goto*//*Label 1092*/ GIMT_Encode4(38744), // Rule ID 20799 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // MIs[0] Operand 1
      GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(0),
      // 0:{ *:[i64] }  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (MOV32r0:{ *:[i32] }:{ *:[i32] }), sub_32bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOV32r0),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_SetImplicitDefDead, /*InsnID*/1, /*OpIdx for X86::EFLAGS*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 20799,
      GIR_EraseRootFromParent_Done,
    // Label 1092: @38744
    GIM_Try, /*On fail goto*//*Label 1093*/ GIMT_Encode4(38770), // Rule ID 15659 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotWin64WithoutFP_OptForMinSize),
      GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt8),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i64] })<<P:Predicate_i64immSExt8>>:$src  =>  (MOV64ImmSExti8:{ *:[i64] } (imm:{ *:[i64] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV64ImmSExti8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 15659,
      GIR_EraseRootFromParent_Done,
    // Label 1093: @38770
    GIM_Try, /*On fail goto*//*Label 1094*/ GIMT_Encode4(38793), // Rule ID 15660 //
      GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immZExt32),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i64] })<<P:Predicate_i64immZExt32>>:$src  =>  (MOV32ri64:{ *:[i64] } (imm:{ *:[i64] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV32ri64),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 15660,
      GIR_EraseRootFromParent_Done,
    // Label 1094: @38793
    GIM_Try, /*On fail goto*//*Label 1095*/ GIMT_Encode4(38816), // Rule ID 22 //
      GIM_CheckI64ImmPredicate, /*MI*/0, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src  =>  (MOV64ri32:{ *:[i64] } (imm:{ *:[i64] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV64ri32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 22,
      GIR_EraseRootFromParent_Done,
    // Label 1095: @38816
    GIM_Try, /*On fail goto*//*Label 1096*/ GIMT_Encode4(38835), // Rule ID 23 //
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i64] }):$src  =>  (MOV64ri:{ *:[i64] } (imm:{ *:[i64] }):$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOV64ri),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // src
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 23,
      GIR_EraseRootFromParent_Done,
    // Label 1096: @38835
    GIM_Reject,
    // Label 1080: @38836
    GIM_Reject,
    // Label 15: @38837
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(6), /*)*//*default:*//*Label 1100*/ GIMT_Encode4(39289),
    /*GILLT_s32*//*Label 1097*/ GIMT_Encode4(38860),
    /*GILLT_s64*//*Label