#ifdef GET_MIMGBaseOpcode_DECL
enum MIMGBaseOpcode {
  IMAGE_ATOMIC_ADD = 0,
  IMAGE_ATOMIC_ADD_FLT = 1,
  IMAGE_ATOMIC_AND = 2,
  IMAGE_ATOMIC_CMPSWAP = 3,
  IMAGE_ATOMIC_DEC = 4,
  IMAGE_ATOMIC_FCMPSWAP = 5,
  IMAGE_ATOMIC_FMAX = 6,
  IMAGE_ATOMIC_FMIN = 7,
  IMAGE_ATOMIC_INC = 8,
  IMAGE_ATOMIC_MAX_FLT = 9,
  IMAGE_ATOMIC_MIN_FLT = 10,
  IMAGE_ATOMIC_OR = 11,
  IMAGE_ATOMIC_PK_ADD_BF16 = 12,
  IMAGE_ATOMIC_PK_ADD_F16 = 13,
  IMAGE_ATOMIC_RSUB = 14,
  IMAGE_ATOMIC_SMAX = 15,
  IMAGE_ATOMIC_SMIN = 16,
  IMAGE_ATOMIC_SUB = 17,
  IMAGE_ATOMIC_SWAP = 18,
  IMAGE_ATOMIC_UMAX = 19,
  IMAGE_ATOMIC_UMIN = 20,
  IMAGE_ATOMIC_XOR = 21,
  IMAGE_BVH64_INTERSECT_RAY = 22,
  IMAGE_BVH64_INTERSECT_RAY_a16 = 23,
  IMAGE_BVH_INTERSECT_RAY = 24,
  IMAGE_BVH_INTERSECT_RAY_a16 = 25,
  IMAGE_GATHER4 = 26,
  IMAGE_GATHER4H = 27,
  IMAGE_GATHER4_B = 28,
  IMAGE_GATHER4_B_CL = 29,
  IMAGE_GATHER4_B_CL_O = 30,
  IMAGE_GATHER4_B_O = 31,
  IMAGE_GATHER4_C = 32,
  IMAGE_GATHER4_CL = 33,
  IMAGE_GATHER4_CL_O = 34,
  IMAGE_GATHER4_C_B = 35,
  IMAGE_GATHER4_C_B_CL = 36,
  IMAGE_GATHER4_C_B_CL_O = 37,
  IMAGE_GATHER4_C_B_O = 38,
  IMAGE_GATHER4_C_CL = 39,
  IMAGE_GATHER4_C_CL_O = 40,
  IMAGE_GATHER4_C_L = 41,
  IMAGE_GATHER4_C_LZ = 42,
  IMAGE_GATHER4_C_LZ_O = 43,
  IMAGE_GATHER4_C_L_O = 44,
  IMAGE_GATHER4_C_O = 45,
  IMAGE_GATHER4_L = 46,
  IMAGE_GATHER4_LZ = 47,
  IMAGE_GATHER4_LZ_O = 48,
  IMAGE_GATHER4_L_O = 49,
  IMAGE_GATHER4_O = 50,
  IMAGE_GET_LOD = 51,
  IMAGE_GET_RESINFO = 52,
  IMAGE_LOAD = 53,
  IMAGE_LOAD_MIP = 54,
  IMAGE_LOAD_MIP_PCK = 55,
  IMAGE_LOAD_MIP_PCK_SGN = 56,
  IMAGE_LOAD_PCK = 57,
  IMAGE_LOAD_PCK_SGN = 58,
  IMAGE_MSAA_LOAD = 59,
  IMAGE_MSAA_LOAD_X = 60,
  IMAGE_SAMPLE = 61,
  IMAGE_SAMPLE_B = 62,
  IMAGE_SAMPLE_B_CL = 63,
  IMAGE_SAMPLE_B_CL_O = 64,
  IMAGE_SAMPLE_B_CL_O_nortn = 65,
  IMAGE_SAMPLE_B_CL_nortn = 66,
  IMAGE_SAMPLE_B_O = 67,
  IMAGE_SAMPLE_B_O_nortn = 68,
  IMAGE_SAMPLE_B_nortn = 69,
  IMAGE_SAMPLE_C = 70,
  IMAGE_SAMPLE_CD = 71,
  IMAGE_SAMPLE_CD_CL = 72,
  IMAGE_SAMPLE_CD_CL_G16 = 73,
  IMAGE_SAMPLE_CD_CL_G16_nortn = 74,
  IMAGE_SAMPLE_CD_CL_O = 75,
  IMAGE_SAMPLE_CD_CL_O_G16 = 76,
  IMAGE_SAMPLE_CD_CL_O_G16_nortn = 77,
  IMAGE_SAMPLE_CD_CL_O_nortn = 78,
  IMAGE_SAMPLE_CD_CL_nortn = 79,
  IMAGE_SAMPLE_CD_G16 = 80,
  IMAGE_SAMPLE_CD_G16_nortn = 81,
  IMAGE_SAMPLE_CD_O = 82,
  IMAGE_SAMPLE_CD_O_G16 = 83,
  IMAGE_SAMPLE_CD_O_G16_nortn = 84,
  IMAGE_SAMPLE_CD_O_nortn = 85,
  IMAGE_SAMPLE_CD_nortn = 86,
  IMAGE_SAMPLE_CL = 87,
  IMAGE_SAMPLE_CL_O = 88,
  IMAGE_SAMPLE_CL_O_nortn = 89,
  IMAGE_SAMPLE_CL_nortn = 90,
  IMAGE_SAMPLE_C_B = 91,
  IMAGE_SAMPLE_C_B_CL = 92,
  IMAGE_SAMPLE_C_B_CL_O = 93,
  IMAGE_SAMPLE_C_B_CL_O_nortn = 94,
  IMAGE_SAMPLE_C_B_CL_nortn = 95,
  IMAGE_SAMPLE_C_B_O = 96,
  IMAGE_SAMPLE_C_B_O_nortn = 97,
  IMAGE_SAMPLE_C_B_nortn = 98,
  IMAGE_SAMPLE_C_CD = 99,
  IMAGE_SAMPLE_C_CD_CL = 100,
  IMAGE_SAMPLE_C_CD_CL_G16 = 101,
  IMAGE_SAMPLE_C_CD_CL_G16_nortn = 102,
  IMAGE_SAMPLE_C_CD_CL_O = 103,
  IMAGE_SAMPLE_C_CD_CL_O_G16 = 104,
  IMAGE_SAMPLE_C_CD_CL_O_G16_nortn = 105,
  IMAGE_SAMPLE_C_CD_CL_O_nortn = 106,
  IMAGE_SAMPLE_C_CD_CL_nortn = 107,
  IMAGE_SAMPLE_C_CD_G16 = 108,
  IMAGE_SAMPLE_C_CD_G16_nortn = 109,
  IMAGE_SAMPLE_C_CD_O = 110,
  IMAGE_SAMPLE_C_CD_O_G16 = 111,
  IMAGE_SAMPLE_C_CD_O_G16_nortn = 112,
  IMAGE_SAMPLE_C_CD_O_nortn = 113,
  IMAGE_SAMPLE_C_CD_nortn = 114,
  IMAGE_SAMPLE_C_CL = 115,
  IMAGE_SAMPLE_C_CL_O = 116,
  IMAGE_SAMPLE_C_CL_O_nortn = 117,
  IMAGE_SAMPLE_C_CL_nortn = 118,
  IMAGE_SAMPLE_C_D = 119,
  IMAGE_SAMPLE_C_D_CL = 120,
  IMAGE_SAMPLE_C_D_CL_G16 = 121,
  IMAGE_SAMPLE_C_D_CL_G16_nortn = 122,
  IMAGE_SAMPLE_C_D_CL_O = 123,
  IMAGE_SAMPLE_C_D_CL_O_G16 = 124,
  IMAGE_SAMPLE_C_D_CL_O_G16_nortn = 125,
  IMAGE_SAMPLE_C_D_CL_O_nortn = 126,
  IMAGE_SAMPLE_C_D_CL_nortn = 127,
  IMAGE_SAMPLE_C_D_G16 = 128,
  IMAGE_SAMPLE_C_D_G16_nortn = 129,
  IMAGE_SAMPLE_C_D_O = 130,
  IMAGE_SAMPLE_C_D_O_G16 = 131,
  IMAGE_SAMPLE_C_D_O_G16_nortn = 132,
  IMAGE_SAMPLE_C_D_O_nortn = 133,
  IMAGE_SAMPLE_C_D_nortn = 134,
  IMAGE_SAMPLE_C_L = 135,
  IMAGE_SAMPLE_C_LZ = 136,
  IMAGE_SAMPLE_C_LZ_O = 137,
  IMAGE_SAMPLE_C_LZ_O_nortn = 138,
  IMAGE_SAMPLE_C_LZ_nortn = 139,
  IMAGE_SAMPLE_C_L_O = 140,
  IMAGE_SAMPLE_C_L_O_nortn = 141,
  IMAGE_SAMPLE_C_L_nortn = 142,
  IMAGE_SAMPLE_C_O = 143,
  IMAGE_SAMPLE_C_O_nortn = 144,
  IMAGE_SAMPLE_C_nortn = 145,
  IMAGE_SAMPLE_D = 146,
  IMAGE_SAMPLE_D_CL = 147,
  IMAGE_SAMPLE_D_CL_G16 = 148,
  IMAGE_SAMPLE_D_CL_G16_nortn = 149,
  IMAGE_SAMPLE_D_CL_O = 150,
  IMAGE_SAMPLE_D_CL_O_G16 = 151,
  IMAGE_SAMPLE_D_CL_O_G16_nortn = 152,
  IMAGE_SAMPLE_D_CL_O_nortn = 153,
  IMAGE_SAMPLE_D_CL_nortn = 154,
  IMAGE_SAMPLE_D_G16 = 155,
  IMAGE_SAMPLE_D_G16_nortn = 156,
  IMAGE_SAMPLE_D_O = 157,
  IMAGE_SAMPLE_D_O_G16 = 158,
  IMAGE_SAMPLE_D_O_G16_nortn = 159,
  IMAGE_SAMPLE_D_O_nortn = 160,
  IMAGE_SAMPLE_D_nortn = 161,
  IMAGE_SAMPLE_L = 162,
  IMAGE_SAMPLE_LZ = 163,
  IMAGE_SAMPLE_LZ_O = 164,
  IMAGE_SAMPLE_LZ_O_nortn = 165,
  IMAGE_SAMPLE_LZ_nortn = 166,
  IMAGE_SAMPLE_L_O = 167,
  IMAGE_SAMPLE_L_O_nortn = 168,
  IMAGE_SAMPLE_L_nortn = 169,
  IMAGE_SAMPLE_O = 170,
  IMAGE_SAMPLE_O_nortn = 171,
  IMAGE_SAMPLE_nortn = 172,
  IMAGE_STORE = 173,
  IMAGE_STORE_MIP = 174,
  IMAGE_STORE_MIP_PCK = 175,
  IMAGE_STORE_PCK = 176,
};
#endif

#ifdef GET_MIMGDim_DECL
enum MIMGDim {
  AMDGPUDim1D = 0,
  AMDGPUDim1DArray = 1,
  AMDGPUDim2D = 2,
  AMDGPUDim2DArray = 3,
  AMDGPUDim2DArrayMsaa = 4,
  AMDGPUDim2DMsaa = 5,
  AMDGPUDim3D = 6,
  AMDGPUDimCube = 7,
};
#endif

#ifdef GET_MIMGEncoding_DECL
enum MIMGEncoding {
  MIMGEncGfx10Default = 0,
  MIMGEncGfx10NSA = 1,
  MIMGEncGfx11Default = 2,
  MIMGEncGfx11NSA = 3,
  MIMGEncGfx12 = 4,
  MIMGEncGfx6 = 5,
  MIMGEncGfx8 = 6,
  MIMGEncGfx90a = 7,
};
#endif

#ifdef GET_WMMAOpcode_DECL
enum WMMAOpcode {
  V_DOT2_F32_BF16 = 0,
  V_DOT2_F32_F16 = 1,
  V_DOT2_I32_I16 = 2,
  V_DOT2_U32_U16 = 3,
  V_DOT4_F32_BF8_BF8 = 4,
  V_DOT4_F32_BF8_FP8 = 5,
  V_DOT4_F32_FP8_BF8 = 6,
  V_DOT4_F32_FP8_FP8 = 7,
  V_DOT4_I32_I8 = 8,
  V_DOT4_I32_IU8 = 9,
  V_DOT4_U32_U8 = 10,
  V_DOT8_I32_I4 = 11,
  V_DOT8_I32_IU4 = 12,
  V_DOT8_U32_U4 = 13,
  V_FMA_MIXHI_F16 = 14,
  V_FMA_MIXLO_F16 = 15,
  V_FMA_MIX_F32 = 16,
  V_MAD_MIXHI_F16 = 17,
  V_MAD_MIXLO_F16 = 18,
  V_MAD_MIX_F32 = 19,
  V_MFMA_LD_SCALE_B32 = 20,
  V_PK_ADD_F16 = 21,
  V_PK_ADD_F32 = 22,
  V_PK_ADD_I16 = 23,
  V_PK_ADD_U16 = 24,
  V_PK_ASHRREV_I16 = 25,
  V_PK_FMA_F16 = 26,
  V_PK_FMA_F32 = 27,
  V_PK_LSHLREV_B16 = 28,
  V_PK_LSHRREV_B16 = 29,
  V_PK_MAD_I16 = 30,
  V_PK_MAD_U16 = 31,
  V_PK_MAXIMUM3_F16 = 32,
  V_PK_MAXIMUM_F16 = 33,
  V_PK_MAX_F16 = 34,
  V_PK_MAX_I16 = 35,
  V_PK_MAX_U16 = 36,
  V_PK_MINIMUM3_F16 = 37,
  V_PK_MINIMUM_F16 = 38,
  V_PK_MIN_F16 = 39,
  V_PK_MIN_I16 = 40,
  V_PK_MIN_U16 = 41,
  V_PK_MOV_B32 = 42,
  V_PK_MUL_F16 = 43,
  V_PK_MUL_F32 = 44,
  V_PK_MUL_LO_U16 = 45,
  V_PK_SUB_I16 = 46,
  V_PK_SUB_U16 = 47,
  V_SWMMAC_BF16_16X16X32_BF16_w32_twoaddr = 48,
  V_SWMMAC_BF16_16X16X32_BF16_w64_twoaddr = 49,
  V_SWMMAC_F16_16X16X32_F16_w32_twoaddr = 50,
  V_SWMMAC_F16_16X16X32_F16_w64_twoaddr = 51,
  V_SWMMAC_F32_16X16X32_BF16_w32_twoaddr = 52,
  V_SWMMAC_F32_16X16X32_BF16_w64_twoaddr = 53,
  V_SWMMAC_F32_16X16X32_BF8_BF8_w32_twoaddr = 54,
  V_SWMMAC_F32_16X16X32_BF8_BF8_w64_twoaddr = 55,
  V_SWMMAC_F32_16X16X32_BF8_FP8_w32_twoaddr = 56,
  V_SWMMAC_F32_16X16X32_BF8_FP8_w64_twoaddr = 57,
  V_SWMMAC_F32_16X16X32_F16_w32_twoaddr = 58,
  V_SWMMAC_F32_16X16X32_F16_w64_twoaddr = 59,
  V_SWMMAC_F32_16X16X32_FP8_BF8_w32_twoaddr = 60,
  V_SWMMAC_F32_16X16X32_FP8_BF8_w64_twoaddr = 61,
  V_SWMMAC_F32_16X16X32_FP8_FP8_w32_twoaddr = 62,
  V_SWMMAC_F32_16X16X32_FP8_FP8_w64_twoaddr = 63,
  V_SWMMAC_I32_16X16X32_IU4_w32_twoaddr = 64,
  V_SWMMAC_I32_16X16X32_IU4_w64_twoaddr = 65,
  V_SWMMAC_I32_16X16X32_IU8_w32_twoaddr = 66,
  V_SWMMAC_I32_16X16X32_IU8_w64_twoaddr = 67,
  V_SWMMAC_I32_16X16X64_IU4_w32_twoaddr = 68,
  V_SWMMAC_I32_16X16X64_IU4_w64_twoaddr = 69,
  V_WMMA_BF16_16X16X16_BF16_TIED_twoaddr_w32 = 70,
  V_WMMA_BF16_16X16X16_BF16_TIED_twoaddr_w64 = 71,
  V_WMMA_BF16_16X16X16_BF16_threeaddr_w32 = 72,
  V_WMMA_BF16_16X16X16_BF16_threeaddr_w64 = 73,
  V_WMMA_BF16_16X16X16_BF16_twoaddr_w32 = 74,
  V_WMMA_BF16_16X16X16_BF16_twoaddr_w64 = 75,
  V_WMMA_BF16_16X16X16_BF16_w32_threeaddr = 76,
  V_WMMA_BF16_16X16X16_BF16_w32_twoaddr = 77,
  V_WMMA_BF16_16X16X16_BF16_w64_threeaddr = 78,
  V_WMMA_BF16_16X16X16_BF16_w64_twoaddr = 79,
  V_WMMA_F16_16X16X16_F16_TIED_twoaddr_w32 = 80,
  V_WMMA_F16_16X16X16_F16_TIED_twoaddr_w64 = 81,
  V_WMMA_F16_16X16X16_F16_threeaddr_w32 = 82,
  V_WMMA_F16_16X16X16_F16_threeaddr_w64 = 83,
  V_WMMA_F16_16X16X16_F16_twoaddr_w32 = 84,
  V_WMMA_F16_16X16X16_F16_twoaddr_w64 = 85,
  V_WMMA_F16_16X16X16_F16_w32_threeaddr = 86,
  V_WMMA_F16_16X16X16_F16_w32_twoaddr = 87,
  V_WMMA_F16_16X16X16_F16_w64_threeaddr = 88,
  V_WMMA_F16_16X16X16_F16_w64_twoaddr = 89,
  V_WMMA_F32_16X16X16_BF16_threeaddr_w32 = 90,
  V_WMMA_F32_16X16X16_BF16_threeaddr_w64 = 91,
  V_WMMA_F32_16X16X16_BF16_twoaddr_w32 = 92,
  V_WMMA_F32_16X16X16_BF16_twoaddr_w64 = 93,
  V_WMMA_F32_16X16X16_BF16_w32_threeaddr = 94,
  V_WMMA_F32_16X16X16_BF16_w32_twoaddr = 95,
  V_WMMA_F32_16X16X16_BF16_w64_threeaddr = 96,
  V_WMMA_F32_16X16X16_BF16_w64_twoaddr = 97,
  V_WMMA_F32_16X16X16_BF8_BF8_w32_threeaddr = 98,
  V_WMMA_F32_16X16X16_BF8_BF8_w32_twoaddr = 99,
  V_WMMA_F32_16X16X16_BF8_BF8_w64_threeaddr = 100,
  V_WMMA_F32_16X16X16_BF8_BF8_w64_twoaddr = 101,
  V_WMMA_F32_16X16X16_BF8_FP8_w32_threeaddr = 102,
  V_WMMA_F32_16X16X16_BF8_FP8_w32_twoaddr = 103,
  V_WMMA_F32_16X16X16_BF8_FP8_w64_threeaddr = 104,
  V_WMMA_F32_16X16X16_BF8_FP8_w64_twoaddr = 105,
  V_WMMA_F32_16X16X16_F16_threeaddr_w32 = 106,
  V_WMMA_F32_16X16X16_F16_threeaddr_w64 = 107,
  V_WMMA_F32_16X16X16_F16_twoaddr_w32 = 108,
  V_WMMA_F32_16X16X16_F16_twoaddr_w64 = 109,
  V_WMMA_F32_16X16X16_F16_w32_threeaddr = 110,
  V_WMMA_F32_16X16X16_F16_w32_twoaddr = 111,
  V_WMMA_F32_16X16X16_F16_w64_threeaddr = 112,
  V_WMMA_F32_16X16X16_F16_w64_twoaddr = 113,
  V_WMMA_F32_16X16X16_FP8_BF8_w32_threeaddr = 114,
  V_WMMA_F32_16X16X16_FP8_BF8_w32_twoaddr = 115,
  V_WMMA_F32_16X16X16_FP8_BF8_w64_threeaddr = 116,
  V_WMMA_F32_16X16X16_FP8_BF8_w64_twoaddr = 117,
  V_WMMA_F32_16X16X16_FP8_FP8_w32_threeaddr = 118,
  V_WMMA_F32_16X16X16_FP8_FP8_w32_twoaddr = 119,
  V_WMMA_F32_16X16X16_FP8_FP8_w64_threeaddr = 120,
  V_WMMA_F32_16X16X16_FP8_FP8_w64_twoaddr = 121,
  V_WMMA_I32_16X16X16_IU4_threeaddr_w32 = 122,
  V_WMMA_I32_16X16X16_IU4_threeaddr_w64 = 123,
  V_WMMA_I32_16X16X16_IU4_twoaddr_w32 = 124,
  V_WMMA_I32_16X16X16_IU4_twoaddr_w64 = 125,
  V_WMMA_I32_16X16X16_IU4_w32_threeaddr = 126,
  V_WMMA_I32_16X16X16_IU4_w32_twoaddr = 127,
  V_WMMA_I32_16X16X16_IU4_w64_threeaddr = 128,
  V_WMMA_I32_16X16X16_IU4_w64_twoaddr = 129,
  V_WMMA_I32_16X16X16_IU8_threeaddr_w32 = 130,
  V_WMMA_I32_16X16X16_IU8_threeaddr_w64 = 131,
  V_WMMA_I32_16X16X16_IU8_twoaddr_w32 = 132,
  V_WMMA_I32_16X16X16_IU8_twoaddr_w64 = 133,
  V_WMMA_I32_16X16X16_IU8_w32_threeaddr = 134,
  V_WMMA_I32_16X16X16_IU8_w32_twoaddr = 135,
  V_WMMA_I32_16X16X16_IU8_w64_threeaddr = 136,
  V_WMMA_I32_16X16X16_IU8_w64_twoaddr = 137,
  V_WMMA_I32_16X16X32_IU4_w32_threeaddr = 138,
  V_WMMA_I32_16X16X32_IU4_w32_twoaddr = 139,
  V_WMMA_I32_16X16X32_IU4_w64_threeaddr = 140,
  V_WMMA_I32_16X16X32_IU4_w64_twoaddr = 141,
};
#endif

#ifdef GET_FP8DstByteSelTable_DECL
const FP8DstByteSelInfo *getFP8DstByteSelHelper(unsigned Opcode);
#endif

#ifdef GET_FP8DstByteSelTable_IMPL
constexpr FP8DstByteSelInfo FP8DstByteSelTable[] = {
  { V_ACCVGPR_READ_B32_e64, false }, // 0
  { V_ACCVGPR_WRITE_B32_e64, false }, // 1
  { V_ADD3_U32_e64, false }, // 2
  { V_ADDC_U32_e64, false }, // 3
  { V_ADD_CO_U32_e64, false }, // 4
  { V_ADD_F16_e64, false }, // 5
  { V_ADD_F16_fake16_e64, false }, // 6
  { V_ADD_F16_t16_e64, false }, // 7
  { V_ADD_F32_e64, false }, // 8
  { V_ADD_F64_e64, false }, // 9
  { V_ADD_F64_pseudo_e64, false }, // 10
  { V_ADD_I16_e64, false }, // 11
  { V_ADD_I32_e64, false }, // 12
  { V_ADD_LSHL_U32_e64, false }, // 13
  { V_ADD_NC_U16_e64, false }, // 14
  { V_ADD_U16_e64, false }, // 15
  { V_ADD_U32_e64, false }, // 16
  { V_ALIGNBIT_B32_e64, false }, // 17
  { V_ALIGNBYTE_B32_e64, false }, // 18
  { V_AND_B16_t16_e64, false }, // 19
  { V_AND_B32_e64, false }, // 20
  { V_AND_OR_B32_e64, false }, // 21
  { V_ASHRREV_I16_e64, false }, // 22
  { V_ASHRREV_I16_t16_e64, false }, // 23
  { V_ASHRREV_I32_e64, false }, // 24
  { V_ASHRREV_I64_e64, false }, // 25
  { V_ASHR_I32_e64, false }, // 26
  { V_ASHR_I64_e64, false }, // 27
  { V_ASHR_PK_I8_I32_e64, false }, // 28
  { V_ASHR_PK_U8_I32_e64, false }, // 29
  { V_BCNT_U32_B32_e64, false }, // 30
  { V_BFE_I32_e64, false }, // 31
  { V_BFE_U32_e64, false }, // 32
  { V_BFI_B32_e64, false }, // 33
  { V_BFM_B32_e64, false }, // 34
  { V_BFREV_B32_e64, false }, // 35
  { V_BITOP3_B16_e64, false }, // 36
  { V_BITOP3_B32_e64, false }, // 37
  { V_CEIL_F16_e64, false }, // 38
  { V_CEIL_F16_fake16_e64, false }, // 39
  { V_CEIL_F16_t16_e64, false }, // 40
  { V_CEIL_F32_e64, false }, // 41
  { V_CEIL_F64_e64, false }, // 42
  { V_CLREXCP_e64, false }, // 43
  { V_CMPSX_EQ_F32_e64, false }, // 44
  { V_CMPSX_EQ_F32_nosdst_e64, false }, // 45
  { V_CMPSX_EQ_F64_e64, false }, // 46
  { V_CMPSX_EQ_F64_nosdst_e64, false }, // 47
  { V_CMPSX_F_F32_e64, false }, // 48
  { V_CMPSX_F_F32_nosdst_e64, false }, // 49
  { V_CMPSX_F_F64_e64, false }, // 50
  { V_CMPSX_F_F64_nosdst_e64, false }, // 51
  { V_CMPSX_GE_F32_e64, false }, // 52
  { V_CMPSX_GE_F32_nosdst_e64, false }, // 53
  { V_CMPSX_GE_F64_e64, false }, // 54
  { V_CMPSX_GE_F64_nosdst_e64, false }, // 55
  { V_CMPSX_GT_F32_e64, false }, // 56
  { V_CMPSX_GT_F32_nosdst_e64, false }, // 57
  { V_CMPSX_GT_F64_e64, false }, // 58
  { V_CMPSX_GT_F64_nosdst_e64, false }, // 59
  { V_CMPSX_LE_F32_e64, false }, // 60
  { V_CMPSX_LE_F32_nosdst_e64, false }, // 61
  { V_CMPSX_LE_F64_e64, false }, // 62
  { V_CMPSX_LE_F64_nosdst_e64, false }, // 63
  { V_CMPSX_LG_F32_e64, false }, // 64
  { V_CMPSX_LG_F32_nosdst_e64, false }, // 65
  { V_CMPSX_LG_F64_e64, false }, // 66
  { V_CMPSX_LG_F64_nosdst_e64, false }, // 67
  { V_CMPSX_LT_F32_e64, false }, // 68
  { V_CMPSX_LT_F32_nosdst_e64, false }, // 69
  { V_CMPSX_LT_F64_e64, false }, // 70
  { V_CMPSX_LT_F64_nosdst_e64, false }, // 71
  { V_CMPSX_NEQ_F32_e64, false }, // 72
  { V_CMPSX_NEQ_F32_nosdst_e64, false }, // 73
  { V_CMPSX_NEQ_F64_e64, false }, // 74
  { V_CMPSX_NEQ_F64_nosdst_e64, false }, // 75
  { V_CMPSX_NGE_F32_e64, false }, // 76
  { V_CMPSX_NGE_F32_nosdst_e64, false }, // 77
  { V_CMPSX_NGE_F64_e64, false }, // 78
  { V_CMPSX_NGE_F64_nosdst_e64, false }, // 79
  { V_CMPSX_NGT_F32_e64, false }, // 80
  { V_CMPSX_NGT_F32_nosdst_e64, false }, // 81
  { V_CMPSX_NGT_F64_e64, false }, // 82
  { V_CMPSX_NGT_F64_nosdst_e64, false }, // 83
  { V_CMPSX_NLE_F32_e64, false }, // 84
  { V_CMPSX_NLE_F32_nosdst_e64, false }, // 85
  { V_CMPSX_NLE_F64_e64, false }, // 86
  { V_CMPSX_NLE_F64_nosdst_e64, false }, // 87
  { V_CMPSX_NLG_F32_e64, false }, // 88
  { V_CMPSX_NLG_F32_nosdst_e64, false }, // 89
  { V_CMPSX_NLG_F64_e64, false }, // 90
  { V_CMPSX_NLG_F64_nosdst_e64, false }, // 91
  { V_CMPSX_NLT_F32_e64, false }, // 92
  { V_CMPSX_NLT_F32_nosdst_e64, false }, // 93
  { V_CMPSX_NLT_F64_e64, false }, // 94
  { V_CMPSX_NLT_F64_nosdst_e64, false }, // 95
  { V_CMPSX_O_F32_e64, false }, // 96
  { V_CMPSX_O_F32_nosdst_e64, false }, // 97
  { V_CMPSX_O_F64_e64, false }, // 98
  { V_CMPSX_O_F64_nosdst_e64, false }, // 99
  { V_CMPSX_TRU_F32_e64, false }, // 100
  { V_CMPSX_TRU_F32_nosdst_e64, false }, // 101
  { V_CMPSX_TRU_F64_e64, false }, // 102
  { V_CMPSX_TRU_F64_nosdst_e64, false }, // 103
  { V_CMPSX_U_F32_e64, false }, // 104
  { V_CMPSX_U_F32_nosdst_e64, false }, // 105
  { V_CMPSX_U_F64_e64, false }, // 106
  { V_CMPSX_U_F64_nosdst_e64, false }, // 107
  { V_CMPS_EQ_F32_e64, false }, // 108
  { V_CMPS_EQ_F64_e64, false }, // 109
  { V_CMPS_F_F32_e64, false }, // 110
  { V_CMPS_F_F64_e64, false }, // 111
  { V_CMPS_GE_F32_e64, false }, // 112
  { V_CMPS_GE_F64_e64, false }, // 113
  { V_CMPS_GT_F32_e64, false }, // 114
  { V_CMPS_GT_F64_e64, false }, // 115
  { V_CMPS_LE_F32_e64, false }, // 116
  { V_CMPS_LE_F64_e64, false }, // 117
  { V_CMPS_LG_F32_e64, false }, // 118
  { V_CMPS_LG_F64_e64, false }, // 119
  { V_CMPS_LT_F32_e64, false }, // 120
  { V_CMPS_LT_F64_e64, false }, // 121
  { V_CMPS_NEQ_F32_e64, false }, // 122
  { V_CMPS_NEQ_F64_e64, false }, // 123
  { V_CMPS_NGE_F32_e64, false }, // 124
  { V_CMPS_NGE_F64_e64, false }, // 125
  { V_CMPS_NGT_F32_e64, false }, // 126
  { V_CMPS_NGT_F64_e64, false }, // 127
  { V_CMPS_NLE_F32_e64, false }, // 128
  { V_CMPS_NLE_F64_e64, false }, // 129
  { V_CMPS_NLG_F32_e64, false }, // 130
  { V_CMPS_NLG_F64_e64, false }, // 131
  { V_CMPS_NLT_F32_e64, false }, // 132
  { V_CMPS_NLT_F64_e64, false }, // 133
  { V_CMPS_O_F32_e64, false }, // 134
  { V_CMPS_O_F64_e64, false }, // 135
  { V_CMPS_TRU_F32_e64, false }, // 136
  { V_CMPS_TRU_F64_e64, false }, // 137
  { V_CMPS_U_F32_e64, false }, // 138
  { V_CMPS_U_F64_e64, false }, // 139
  { V_CMPX_CLASS_F16_e64, false }, // 140
  { V_CMPX_CLASS_F16_nosdst_e64, false }, // 141
  { V_CMPX_CLASS_F16_t16_e64, false }, // 142
  { V_CMPX_CLASS_F16_t16_nosdst_e64, false }, // 143
  { V_CMPX_CLASS_F32_e64, false }, // 144
  { V_CMPX_CLASS_F32_nosdst_e64, false }, // 145
  { V_CMPX_CLASS_F64_e64, false }, // 146
  { V_CMPX_CLASS_F64_nosdst_e64, false }, // 147
  { V_CMPX_EQ_F16_e64, false }, // 148
  { V_CMPX_EQ_F16_nosdst_e64, false }, // 149
  { V_CMPX_EQ_F16_t16_e64, false }, // 150
  { V_CMPX_EQ_F16_t16_nosdst_e64, false }, // 151
  { V_CMPX_EQ_F32_e64, false }, // 152
  { V_CMPX_EQ_F32_nosdst_e64, false }, // 153
  { V_CMPX_EQ_F64_e64, false }, // 154
  { V_CMPX_EQ_F64_nosdst_e64, false }, // 155
  { V_CMPX_EQ_I16_e64, false }, // 156
  { V_CMPX_EQ_I16_nosdst_e64, false }, // 157
  { V_CMPX_EQ_I16_t16_e64, false }, // 158
  { V_CMPX_EQ_I16_t16_nosdst_e64, false }, // 159
  { V_CMPX_EQ_I32_e64, false }, // 160
  { V_CMPX_EQ_I32_nosdst_e64, false }, // 161
  { V_CMPX_EQ_I64_e64, false }, // 162
  { V_CMPX_EQ_I64_nosdst_e64, false }, // 163
  { V_CMPX_EQ_U16_e64, false }, // 164
  { V_CMPX_EQ_U16_nosdst_e64, false }, // 165
  { V_CMPX_EQ_U16_t16_e64, false }, // 166
  { V_CMPX_EQ_U16_t16_nosdst_e64, false }, // 167
  { V_CMPX_EQ_U32_e64, false }, // 168
  { V_CMPX_EQ_U32_nosdst_e64, false }, // 169
  { V_CMPX_EQ_U64_e64, false }, // 170
  { V_CMPX_EQ_U64_nosdst_e64, false }, // 171
  { V_CMPX_F_F16_e64, false }, // 172
  { V_CMPX_F_F16_nosdst_e64, false }, // 173
  { V_CMPX_F_F16_t16_e64, false }, // 174
  { V_CMPX_F_F16_t16_nosdst_e64, false }, // 175
  { V_CMPX_F_F32_e64, false }, // 176
  { V_CMPX_F_F32_nosdst_e64, false }, // 177
  { V_CMPX_F_F64_e64, false }, // 178
  { V_CMPX_F_F64_nosdst_e64, false }, // 179
  { V_CMPX_F_I16_e64, false }, // 180
  { V_CMPX_F_I16_nosdst_e64, false }, // 181
  { V_CMPX_F_I16_t16_e64, false }, // 182
  { V_CMPX_F_I16_t16_nosdst_e64, false }, // 183
  { V_CMPX_F_I32_e64, false }, // 184
  { V_CMPX_F_I32_nosdst_e64, false }, // 185
  { V_CMPX_F_I64_e64, false }, // 186
  { V_CMPX_F_I64_nosdst_e64, false }, // 187
  { V_CMPX_F_U16_e64, false }, // 188
  { V_CMPX_F_U16_nosdst_e64, false }, // 189
  { V_CMPX_F_U16_t16_e64, false }, // 190
  { V_CMPX_F_U16_t16_nosdst_e64, false }, // 191
  { V_CMPX_F_U32_e64, false }, // 192
  { V_CMPX_F_U32_nosdst_e64, false }, // 193
  { V_CMPX_F_U64_e64, false }, // 194
  { V_CMPX_F_U64_nosdst_e64, false }, // 195
  { V_CMPX_GE_F16_e64, false }, // 196
  { V_CMPX_GE_F16_nosdst_e64, false }, // 197
  { V_CMPX_GE_F16_t16_e64, false }, // 198
  { V_CMPX_GE_F16_t16_nosdst_e64, false }, // 199
  { V_CMPX_GE_F32_e64, false }, // 200
  { V_CMPX_GE_F32_nosdst_e64, false }, // 201
  { V_CMPX_GE_F64_e64, false }, // 202
  { V_CMPX_GE_F64_nosdst_e64, false }, // 203
  { V_CMPX_GE_I16_e64, false }, // 204
  { V_CMPX_GE_I16_nosdst_e64, false }, // 205
  { V_CMPX_GE_I16_t16_e64, false }, // 206
  { V_CMPX_GE_I16_t16_nosdst_e64, false }, // 207
  { V_CMPX_GE_I32_e64, false }, // 208
  { V_CMPX_GE_I32_nosdst_e64, false }, // 209
  { V_CMPX_GE_I64_e64, false }, // 210
  { V_CMPX_GE_I64_nosdst_e64, false }, // 211
  { V_CMPX_GE_U16_e64, false }, // 212
  { V_CMPX_GE_U16_nosdst_e64, false }, // 213
  { V_CMPX_GE_U16_t16_e64, false }, // 214
  { V_CMPX_GE_U16_t16_nosdst_e64, false }, // 215
  { V_CMPX_GE_U32_e64, false }, // 216
  { V_CMPX_GE_U32_nosdst_e64, false }, // 217
  { V_CMPX_GE_U64_e64, false }, // 218
  { V_CMPX_GE_U64_nosdst_e64, false }, // 219
  { V_CMPX_GT_F16_e64, false }, // 220
  { V_CMPX_GT_F16_nosdst_e64, false }, // 221
  { V_CMPX_GT_F16_t16_e64, false }, // 222
  { V_CMPX_GT_F16_t16_nosdst_e64, false }, // 223
  { V_CMPX_GT_F32_e64, false }, // 224
  { V_CMPX_GT_F32_nosdst_e64, false }, // 225
  { V_CMPX_GT_F64_e64, false }, // 226
  { V_CMPX_GT_F64_nosdst_e64, false }, // 227
  { V_CMPX_GT_I16_e64, false }, // 228
  { V_CMPX_GT_I16_nosdst_e64, false }, // 229
  { V_CMPX_GT_I16_t16_e64, false }, // 230
  { V_CMPX_GT_I16_t16_nosdst_e64, false }, // 231
  { V_CMPX_GT_I32_e64, false }, // 232
  { V_CMPX_GT_I32_nosdst_e64, false }, // 233
  { V_CMPX_GT_I64_e64, false }, // 234
  { V_CMPX_GT_I64_nosdst_e64, false }, // 235
  { V_CMPX_GT_U16_e64, false }, // 236
  { V_CMPX_GT_U16_nosdst_e64, false }, // 237
  { V_CMPX_GT_U16_t16_e64, false }, // 238
  { V_CMPX_GT_U16_t16_nosdst_e64, false }, // 239
  { V_CMPX_GT_U32_e64, false }, // 240
  { V_CMPX_GT_U32_nosdst_e64, false }, // 241
  { V_CMPX_GT_U64_e64, false }, // 242
  { V_CMPX_GT_U64_nosdst_e64, false }, // 243
  { V_CMPX_LE_F16_e64, false }, // 244
  { V_CMPX_LE_F16_nosdst_e64, false }, // 245
  { V_CMPX_LE_F16_t16_e64, false }, // 246
  { V_CMPX_LE_F16_t16_nosdst_e64, false }, // 247
  { V_CMPX_LE_F32_e64, false }, // 248
  { V_CMPX_LE_F32_nosdst_e64, false }, // 249
  { V_CMPX_LE_F64_e64, false }, // 250
  { V_CMPX_LE_F64_nosdst_e64, false }, // 251
  { V_CMPX_LE_I16_e64, false }, // 252
  { V_CMPX_LE_I16_nosdst_e64, false }, // 253
  { V_CMPX_LE_I16_t16_e64, false }, // 254
  { V_CMPX_LE_I16_t16_nosdst_e64, false }, // 255
  { V_CMPX_LE_I32_e64, false }, // 256
  { V_CMPX_LE_I32_nosdst_e64, false }, // 257
  { V_CMPX_LE_I64_e64, false }, // 258
  { V_CMPX_LE_I64_nosdst_e64, false }, // 259
  { V_CMPX_LE_U16_e64, false }, // 260
  { V_CMPX_LE_U16_nosdst_e64, false }, // 261
  { V_CMPX_LE_U16_t16_e64, false }, // 262
  { V_CMPX_LE_U16_t16_nosdst_e64, false }, // 263
  { V_CMPX_LE_U32_e64, false }, // 264
  { V_CMPX_LE_U32_nosdst_e64, false }, // 265
  { V_CMPX_LE_U64_e64, false }, // 266
  { V_CMPX_LE_U64_nosdst_e64, false }, // 267
  { V_CMPX_LG_F16_e64, false }, // 268
  { V_CMPX_LG_F16_nosdst_e64, false }, // 269
  { V_CMPX_LG_F16_t16_e64, false }, // 270
  { V_CMPX_LG_F16_t16_nosdst_e64, false }, // 271
  { V_CMPX_LG_F32_e64, false }, // 272
  { V_CMPX_LG_F32_nosdst_e64, false }, // 273
  { V_CMPX_LG_F64_e64, false }, // 274
  { V_CMPX_LG_F64_nosdst_e64, false }, // 275
  { V_CMPX_LT_F16_e64, false }, // 276
  { V_CMPX_LT_F16_nosdst_e64, false }, // 277
  { V_CMPX_LT_F16_t16_e64, false }, // 278
  { V_CMPX_LT_F16_t16_nosdst_e64, false }, // 279
  { V_CMPX_LT_F32_e64, false }, // 280
  { V_CMPX_LT_F32_nosdst_e64, false }, // 281
  { V_CMPX_LT_F64_e64, false }, // 282
  { V_CMPX_LT_F64_nosdst_e64, false }, // 283
  { V_CMPX_LT_I16_e64, false }, // 284
  { V_CMPX_LT_I16_nosdst_e64, false }, // 285
  { V_CMPX_LT_I16_t16_e64, false }, // 286
  { V_CMPX_LT_I16_t16_nosdst_e64, false }, // 287
  { V_CMPX_LT_I32_e64, false }, // 288
  { V_CMPX_LT_I32_nosdst_e64, false }, // 289
  { V_CMPX_LT_I64_e64, false }, // 290
  { V_CMPX_LT_I64_nosdst_e64, false }, // 291
  { V_CMPX_LT_U16_e64, false }, // 292
  { V_CMPX_LT_U16_nosdst_e64, false }, // 293
  { V_CMPX_LT_U16_t16_e64, false }, // 294
  { V_CMPX_LT_U16_t16_nosdst_e64, false }, // 295
  { V_CMPX_LT_U32_e64, false }, // 296
  { V_CMPX_LT_U32_nosdst_e64, false }, // 297
  { V_CMPX_LT_U64_e64, false }, // 298
  { V_CMPX_LT_U64_nosdst_e64, false }, // 299
  { V_CMPX_NEQ_F16_e64, false }, // 300
  { V_CMPX_NEQ_F16_nosdst_e64, false }, // 301
  { V_CMPX_NEQ_F16_t16_e64, false }, // 302
  { V_CMPX_NEQ_F16_t16_nosdst_e64, false }, // 303
  { V_CMPX_NEQ_F32_e64, false }, // 304
  { V_CMPX_NEQ_F32_nosdst_e64, false }, // 305
  { V_CMPX_NEQ_F64_e64, false }, // 306
  { V_CMPX_NEQ_F64_nosdst_e64, false }, // 307
  { V_CMPX_NE_I16_e64, false }, // 308
  { V_CMPX_NE_I16_nosdst_e64, false }, // 309
  { V_CMPX_NE_I16_t16_e64, false }, // 310
  { V_CMPX_NE_I16_t16_nosdst_e64, false }, // 311
  { V_CMPX_NE_I32_e64, false }, // 312
  { V_CMPX_NE_I32_nosdst_e64, false }, // 313
  { V_CMPX_NE_I64_e64, false }, // 314
  { V_CMPX_NE_I64_nosdst_e64, false }, // 315
  { V_CMPX_NE_U16_e64, false }, // 316
  { V_CMPX_NE_U16_nosdst_e64, false }, // 317
  { V_CMPX_NE_U16_t16_e64, false }, // 318
  { V_CMPX_NE_U16_t16_nosdst_e64, false }, // 319
  { V_CMPX_NE_U32_e64, false }, // 320
  { V_CMPX_NE_U32_nosdst_e64, false }, // 321
  { V_CMPX_NE_U64_e64, false }, // 322
  { V_CMPX_NE_U64_nosdst_e64, false }, // 323
  { V_CMPX_NGE_F16_e64, false }, // 324
  { V_CMPX_NGE_F16_nosdst_e64, false }, // 325
  { V_CMPX_NGE_F16_t16_e64, false }, // 326
  { V_CMPX_NGE_F16_t16_nosdst_e64, false }, // 327
  { V_CMPX_NGE_F32_e64, false }, // 328
  { V_CMPX_NGE_F32_nosdst_e64, false }, // 329
  { V_CMPX_NGE_F64_e64, false }, // 330
  { V_CMPX_NGE_F64_nosdst_e64, false }, // 331
  { V_CMPX_NGT_F16_e64, false }, // 332
  { V_CMPX_NGT_F16_nosdst_e64, false }, // 333
  { V_CMPX_NGT_F16_t16_e64, false }, // 334
  { V_CMPX_NGT_F16_t16_nosdst_e64, false }, // 335
  { V_CMPX_NGT_F32_e64, false }, // 336
  { V_CMPX_NGT_F32_nosdst_e64, false }, // 337
  { V_CMPX_NGT_F64_e64, false }, // 338
  { V_CMPX_NGT_F64_nosdst_e64, false }, // 339
  { V_CMPX_NLE_F16_e64, false }, // 340
  { V_CMPX_NLE_F16_nosdst_e64, false }, // 341
  { V_CMPX_NLE_F16_t16_e64, false }, // 342
  { V_CMPX_NLE_F16_t16_nosdst_e64, false }, // 343
  { V_CMPX_NLE_F32_e64, false }, // 344
  { V_CMPX_NLE_F32_nosdst_e64, false }, // 345
  { V_CMPX_NLE_F64_e64, false }, // 346
  { V_CMPX_NLE_F64_nosdst_e64, false }, // 347
  { V_CMPX_NLG_F16_e64, false }, // 348
  { V_CMPX_NLG_F16_nosdst_e64, false }, // 349
  { V_CMPX_NLG_F16_t16_e64, false }, // 350
  { V_CMPX_NLG_F16_t16_nosdst_e64, false }, // 351
  { V_CMPX_NLG_F32_e64, false }, // 352
  { V_CMPX_NLG_F32_nosdst_e64, false }, // 353
  { V_CMPX_NLG_F64_e64, false }, // 354
  { V_CMPX_NLG_F64_nosdst_e64, false }, // 355
  { V_CMPX_NLT_F16_e64, false }, // 356
  { V_CMPX_NLT_F16_nosdst_e64, false }, // 357
  { V_CMPX_NLT_F16_t16_e64, false }, // 358
  { V_CMPX_NLT_F16_t16_nosdst_e64, false }, // 359
  { V_CMPX_NLT_F32_e64, false }, // 360
  { V_CMPX_NLT_F32_nosdst_e64, false }, // 361
  { V_CMPX_NLT_F64_e64, false }, // 362
  { V_CMPX_NLT_F64_nosdst_e64, false }, // 363
  { V_CMPX_O_F16_e64, false }, // 364
  { V_CMPX_O_F16_nosdst_e64, false }, // 365
  { V_CMPX_O_F16_t16_e64, false }, // 366
  { V_CMPX_O_F16_t16_nosdst_e64, false }, // 367
  { V_CMPX_O_F32_e64, false }, // 368
  { V_CMPX_O_F32_nosdst_e64, false }, // 369
  { V_CMPX_O_F64_e64, false }, // 370
  { V_CMPX_O_F64_nosdst_e64, false }, // 371
  { V_CMPX_TRU_F16_e64, false }, // 372
  { V_CMPX_TRU_F16_nosdst_e64, false }, // 373
  { V_CMPX_TRU_F16_t16_e64, false }, // 374
  { V_CMPX_TRU_F16_t16_nosdst_e64, false }, // 375
  { V_CMPX_TRU_F32_e64, false }, // 376
  { V_CMPX_TRU_F32_nosdst_e64, false }, // 377
  { V_CMPX_TRU_F64_e64, false }, // 378
  { V_CMPX_TRU_F64_nosdst_e64, false }, // 379
  { V_CMPX_T_I16_e64, false }, // 380
  { V_CMPX_T_I16_nosdst_e64, false }, // 381
  { V_CMPX_T_I16_t16_e64, false }, // 382
  { V_CMPX_T_I16_t16_nosdst_e64, false }, // 383
  { V_CMPX_T_I32_e64, false }, // 384
  { V_CMPX_T_I32_nosdst_e64, false }, // 385
  { V_CMPX_T_I64_e64, false }, // 386
  { V_CMPX_T_I64_nosdst_e64, false }, // 387
  { V_CMPX_T_U16_e64, false }, // 388
  { V_CMPX_T_U16_nosdst_e64, false }, // 389
  { V_CMPX_T_U16_t16_e64, false }, // 390
  { V_CMPX_T_U16_t16_nosdst_e64, false }, // 391
  { V_CMPX_T_U32_e64, false }, // 392
  { V_CMPX_T_U32_nosdst_e64, false }, // 393
  { V_CMPX_T_U64_e64, false }, // 394
  { V_CMPX_T_U64_nosdst_e64, false }, // 395
  { V_CMPX_U_F16_e64, false }, // 396
  { V_CMPX_U_F16_nosdst_e64, false }, // 397
  { V_CMPX_U_F16_t16_e64, false }, // 398
  { V_CMPX_U_F16_t16_nosdst_e64, false }, // 399
  { V_CMPX_U_F32_e64, false }, // 400
  { V_CMPX_U_F32_nosdst_e64, false }, // 401
  { V_CMPX_U_F64_e64, false }, // 402
  { V_CMPX_U_F64_nosdst_e64, false }, // 403
  { V_CMP_CLASS_F16_e64, false }, // 404
  { V_CMP_CLASS_F16_t16_e64, false }, // 405
  { V_CMP_CLASS_F32_e64, false }, // 406
  { V_CMP_CLASS_F64_e64, false }, // 407
  { V_CMP_EQ_F16_e64, false }, // 408
  { V_CMP_EQ_F16_t16_e64, false }, // 409
  { V_CMP_EQ_F32_e64, false }, // 410
  { V_CMP_EQ_F64_e64, false }, // 411
  { V_CMP_EQ_I16_e64, false }, // 412
  { V_CMP_EQ_I16_t16_e64, false }, // 413
  { V_CMP_EQ_I32_e64, false }, // 414
  { V_CMP_EQ_I64_e64, false }, // 415
  { V_CMP_EQ_U16_e64, false }, // 416
  { V_CMP_EQ_U16_t16_e64, false }, // 417
  { V_CMP_EQ_U32_e64, false }, // 418
  { V_CMP_EQ_U64_e64, false }, // 419
  { V_CMP_F_F16_e64, false }, // 420
  { V_CMP_F_F16_t16_e64, false }, // 421
  { V_CMP_F_F32_e64, false }, // 422
  { V_CMP_F_F64_e64, false }, // 423
  { V_CMP_F_I16_e64, false }, // 424
  { V_CMP_F_I16_t16_e64, false }, // 425
  { V_CMP_F_I32_e64, false }, // 426
  { V_CMP_F_I64_e64, false }, // 427
  { V_CMP_F_U16_e64, false }, // 428
  { V_CMP_F_U16_t16_e64, false }, // 429
  { V_CMP_F_U32_e64, false }, // 430
  { V_CMP_F_U64_e64, false }, // 431
  { V_CMP_GE_F16_e64, false }, // 432
  { V_CMP_GE_F16_t16_e64, false }, // 433
  { V_CMP_GE_F32_e64, false }, // 434
  { V_CMP_GE_F64_e64, false }, // 435
  { V_CMP_GE_I16_e64, false }, // 436
  { V_CMP_GE_I16_t16_e64, false }, // 437
  { V_CMP_GE_I32_e64, false }, // 438
  { V_CMP_GE_I64_e64, false }, // 439
  { V_CMP_GE_U16_e64, false }, // 440
  { V_CMP_GE_U16_t16_e64, false }, // 441
  { V_CMP_GE_U32_e64, false }, // 442
  { V_CMP_GE_U64_e64, false }, // 443
  { V_CMP_GT_F16_e64, false }, // 444
  { V_CMP_GT_F16_t16_e64, false }, // 445
  { V_CMP_GT_F32_e64, false }, // 446
  { V_CMP_GT_F64_e64, false }, // 447
  { V_CMP_GT_I16_e64, false }, // 448
  { V_CMP_GT_I16_t16_e64, false }, // 449
  { V_CMP_GT_I32_e64, false }, // 450
  { V_CMP_GT_I64_e64, false }, // 451
  { V_CMP_GT_U16_e64, false }, // 452
  { V_CMP_GT_U16_t16_e64, false }, // 453
  { V_CMP_GT_U32_e64, false }, // 454
  { V_CMP_GT_U64_e64, false }, // 455
  { V_CMP_LE_F16_e64, false }, // 456
  { V_CMP_LE_F16_t16_e64, false }, // 457
  { V_CMP_LE_F32_e64, false }, // 458
  { V_CMP_LE_F64_e64, false }, // 459
  { V_CMP_LE_I16_e64, false }, // 460
  { V_CMP_LE_I16_t16_e64, false }, // 461
  { V_CMP_LE_I32_e64, false }, // 462
  { V_CMP_LE_I64_e64, false }, // 463
  { V_CMP_LE_U16_e64, false }, // 464
  { V_CMP_LE_U16_t16_e64, false }, // 465
  { V_CMP_LE_U32_e64, false }, // 466
  { V_CMP_LE_U64_e64, false }, // 467
  { V_CMP_LG_F16_e64, false }, // 468
  { V_CMP_LG_F16_t16_e64, false }, // 469
  { V_CMP_LG_F32_e64, false }, // 470
  { V_CMP_LG_F64_e64, false }, // 471
  { V_CMP_LT_F16_e64, false }, // 472
  { V_CMP_LT_F16_t16_e64, false }, // 473
  { V_CMP_LT_F32_e64, false }, // 474
  { V_CMP_LT_F64_e64, false }, // 475
  { V_CMP_LT_I16_e64, false }, // 476
  { V_CMP_LT_I16_t16_e64, false }, // 477
  { V_CMP_LT_I32_e64, false }, // 478
  { V_CMP_LT_I64_e64, false }, // 479
  { V_CMP_LT_U16_e64, false }, // 480
  { V_CMP_LT_U16_t16_e64, false }, // 481
  { V_CMP_LT_U32_e64, false }, // 482
  { V_CMP_LT_U64_e64, false }, // 483
  { V_CMP_NEQ_F16_e64, false }, // 484
  { V_CMP_NEQ_F16_t16_e64, false }, // 485
  { V_CMP_NEQ_F32_e64, false }, // 486
  { V_CMP_NEQ_F64_e64, false }, // 487
  { V_CMP_NE_I16_e64, false }, // 488
  { V_CMP_NE_I16_t16_e64, false }, // 489
  { V_CMP_NE_I32_e64, false }, // 490
  { V_CMP_NE_I64_e64, false }, // 491
  { V_CMP_NE_U16_e64, false }, // 492
  { V_CMP_NE_U16_t16_e64, false }, // 493
  { V_CMP_NE_U32_e64, false }, // 494
  { V_CMP_NE_U64_e64, false }, // 495
  { V_CMP_NGE_F16_e64, false }, // 496
  { V_CMP_NGE_F16_t16_e64, false }, // 497
  { V_CMP_NGE_F32_e64, false }, // 498
  { V_CMP_NGE_F64_e64, false }, // 499
  { V_CMP_NGT_F16_e64, false }, // 500
  { V_CMP_NGT_F16_t16_e64, false }, // 501
  { V_CMP_NGT_F32_e64, false }, // 502
  { V_CMP_NGT_F64_e64, false }, // 503
  { V_CMP_NLE_F16_e64, false }, // 504
  { V_CMP_NLE_F16_t16_e64, false }, // 505
  { V_CMP_NLE_F32_e64, false }, // 506
  { V_CMP_NLE_F64_e64, false }, // 507
  { V_CMP_NLG_F16_e64, false }, // 508
  { V_CMP_NLG_F16_t16_e64, false }, // 509
  { V_CMP_NLG_F32_e64, false }, // 510
  { V_CMP_NLG_F64_e64, false }, // 511
  { V_CMP_NLT_F16_e64, false }, // 512
  { V_CMP_NLT_F16_t16_e64, false }, // 513
  { V_CMP_NLT_F32_e64, false }, // 514
  { V_CMP_NLT_F64_e64, false }, // 515
  { V_CMP_O_F16_e64, false }, // 516
  { V_CMP_O_F16_t16_e64, false }, // 517
  { V_CMP_O_F32_e64, false }, // 518
  { V_CMP_O_F64_e64, false }, // 519
  { V_CMP_TRU_F16_e64, false }, // 520
  { V_CMP_TRU_F16_t16_e64, false }, // 521
  { V_CMP_TRU_F32_e64, false }, // 522
  { V_CMP_TRU_F64_e64, false }, // 523
  { V_CMP_T_I16_e64, false }, // 524
  { V_CMP_T_I16_t16_e64, false }, // 525
  { V_CMP_T_I32_e64, false }, // 526
  { V_CMP_T_I64_e64, false }, // 527
  { V_CMP_T_U16_e64, false }, // 528
  { V_CMP_T_U16_t16_e64, false }, // 529
  { V_CMP_T_U32_e64, false }, // 530
  { V_CMP_T_U64_e64, false }, // 531
  { V_CMP_U_F16_e64, false }, // 532
  { V_CMP_U_F16_t16_e64, false }, // 533
  { V_CMP_U_F32_e64, false }, // 534
  { V_CMP_U_F64_e64, false }, // 535
  { V_CNDMASK_B16_e64, false }, // 536
  { V_CNDMASK_B32_e64, false }, // 537
  { V_COS_F16_e64, false }, // 538
  { V_COS_F16_fake16_e64, false }, // 539
  { V_COS_F16_t16_e64, false }, // 540
  { V_COS_F32_e64, false }, // 541
  { V_CUBEID_F32_e64, false }, // 542
  { V_CUBEMA_F32_e64, false }, // 543
  { V_CUBESC_F32_e64, false }, // 544
  { V_CUBETC_F32_e64, false }, // 545
  { V_CVT_F16_F32_e64, false }, // 546
  { V_CVT_F16_F32_t16_e64, false }, // 547
  { V_CVT_F16_I16_e64, false }, // 548
  { V_CVT_F16_I16_t16_e64, false }, // 549
  { V_CVT_F16_U16_e64, false }, // 550
  { V_CVT_F16_U16_t16_e64, false }, // 551
  { V_CVT_F32_BF16_e64, false }, // 552
  { V_CVT_F32_BF16_fake16_e64, false }, // 553
  { V_CVT_F32_BF16_t16_e64, false }, // 554
  { V_CVT_F32_BF8_OP_SEL_e64, false }, // 555
  { V_CVT_F32_BF8_e64, false }, // 556
  { V_CVT_F32_F16_e64, false }, // 557
  { V_CVT_F32_F16_t16_e64, false }, // 558
  { V_CVT_F32_F64_e64, false }, // 559
  { V_CVT_F32_FP8_OP_SEL_e64, false }, // 560
  { V_CVT_F32_FP8_e64, false }, // 561
  { V_CVT_F32_I32_e64, false }, // 562
  { V_CVT_F32_U32_e64, false }, // 563
  { V_CVT_F32_UBYTE0_e64, false }, // 564
  { V_CVT_F32_UBYTE1_e64, false }, // 565
  { V_CVT_F32_UBYTE2_e64, false }, // 566
  { V_CVT_F32_UBYTE3_e64, false }, // 567
  { V_CVT_F64_F32_e64, false }, // 568
  { V_CVT_F64_I32_e64, false }, // 569
  { V_CVT_F64_U32_e64, false }, // 570
  { V_CVT_FLR_I32_F32_e64, false }, // 571
  { V_CVT_I16_F16_e64, false }, // 572
  { V_CVT_I16_F16_t16_e64, false }, // 573
  { V_CVT_I32_F32_e64, false }, // 574
  { V_CVT_I32_F64_e64, false }, // 575
  { V_CVT_I32_I16_e64, false }, // 576
  { V_CVT_I32_I16_fake16_e64, false }, // 577
  { V_CVT_I32_I16_t16_e64, false }, // 578
  { V_CVT_NORM_I16_F16_e64, false }, // 579
  { V_CVT_NORM_I16_F16_t16_e64, false }, // 580
  { V_CVT_NORM_U16_F16_e64, false }, // 581
  { V_CVT_NORM_U16_F16_t16_e64, false }, // 582
  { V_CVT_OFF_F32_I4_e64, false }, // 583
  { V_CVT_PKACCUM_U8_F32_e64, false }, // 584
  { V_CVT_PKNORM_I16_F16_e64, false }, // 585
  { V_CVT_PKNORM_I16_F32_e64, false }, // 586
  { V_CVT_PKNORM_U16_F16_e64, false }, // 587
  { V_CVT_PKNORM_U16_F32_e64, false }, // 588
  { V_CVT_PKRTZ_F16_F32_e64, false }, // 589
  { V_CVT_PK_BF16_F32_e64, false }, // 590
  { V_CVT_PK_BF8_F32_e64, false }, // 591
  { V_CVT_PK_F16_F32_e64, false }, // 592
  { V_CVT_PK_F32_BF8_OP_SEL_e64, false }, // 593
  { V_CVT_PK_F32_BF8_e64, false }, // 594
  { V_CVT_PK_F32_FP8_OP_SEL_e64, false }, // 595
  { V_CVT_PK_F32_FP8_e64, false }, // 596
  { V_CVT_PK_FP8_F32_e64, false }, // 597
  { V_CVT_PK_I16_F32_e64, false }, // 598
  { V_CVT_PK_I16_I32_e64, false }, // 599
  { V_CVT_PK_U16_F32_e64, false }, // 600
  { V_CVT_PK_U16_U32_e64, false }, // 601
  { V_CVT_PK_U8_F32_e64, false }, // 602
  { V_CVT_RPI_I32_F32_e64, false }, // 603
  { V_CVT_SCALEF32_2XPK16_BF6_F32_e64, false }, // 604
  { V_CVT_SCALEF32_2XPK16_FP6_F32_e64, false }, // 605
  { V_CVT_SCALEF32_F16_BF8_e64, false }, // 606
  { V_CVT_SCALEF32_F16_FP8_e64, false }, // 607
  { V_CVT_SCALEF32_F32_BF8_e64, false }, // 608
  { V_CVT_SCALEF32_F32_FP8_e64, false }, // 609
  { V_CVT_SCALEF32_PK32_BF16_BF6_e64, false }, // 610
  { V_CVT_SCALEF32_PK32_BF16_FP6_e64, false }, // 611
  { V_CVT_SCALEF32_PK32_BF6_BF16_e64, false }, // 612
  { V_CVT_SCALEF32_PK32_BF6_F16_e64, false }, // 613
  { V_CVT_SCALEF32_PK32_F16_BF6_e64, false }, // 614
  { V_CVT_SCALEF32_PK32_F16_FP6_e64, false }, // 615
  { V_CVT_SCALEF32_PK32_F32_BF6_e64, false }, // 616
  { V_CVT_SCALEF32_PK32_F32_FP6_e64, false }, // 617
  { V_CVT_SCALEF32_PK32_FP6_BF16_e64, false }, // 618
  { V_CVT_SCALEF32_PK32_FP6_F16_e64, false }, // 619
  { V_CVT_SCALEF32_PK_BF16_BF8_e64, false }, // 620
  { V_CVT_SCALEF32_PK_BF16_FP4_e64, false }, // 621
  { V_CVT_SCALEF32_PK_BF16_FP8_e64, false }, // 622
  { V_CVT_SCALEF32_PK_BF8_BF16_e64, false }, // 623
  { V_CVT_SCALEF32_PK_BF8_F16_e64, false }, // 624
  { V_CVT_SCALEF32_PK_BF8_F32_e64, false }, // 625
  { V_CVT_SCALEF32_PK_F16_BF8_e64, false }, // 626
  { V_CVT_SCALEF32_PK_F16_FP4_e64, false }, // 627
  { V_CVT_SCALEF32_PK_F16_FP8_e64, false }, // 628
  { V_CVT_SCALEF32_PK_F32_BF8_e64, false }, // 629
  { V_CVT_SCALEF32_PK_F32_FP4_e64, false }, // 630
  { V_CVT_SCALEF32_PK_F32_FP8_e64, false }, // 631
  { V_CVT_SCALEF32_PK_FP4_BF16_e64, true }, // 632
  { V_CVT_SCALEF32_PK_FP4_F16_e64, true }, // 633
  { V_CVT_SCALEF32_PK_FP4_F32_e64, true }, // 634
  { V_CVT_SCALEF32_PK_FP8_BF16_e64, false }, // 635
  { V_CVT_SCALEF32_PK_FP8_F16_e64, false }, // 636
  { V_CVT_SCALEF32_PK_FP8_F32_e64, false }, // 637
  { V_CVT_SCALEF32_SR_BF8_BF16_e64, true }, // 638
  { V_CVT_SCALEF32_SR_BF8_F16_e64, true }, // 639
  { V_CVT_SCALEF32_SR_BF8_F32_e64, true }, // 640
  { V_CVT_SCALEF32_SR_FP8_BF16_e64, true }, // 641
  { V_CVT_SCALEF32_SR_FP8_F16_e64, true }, // 642
  { V_CVT_SCALEF32_SR_FP8_F32_e64, true }, // 643
  { V_CVT_SCALEF32_SR_PK32_BF6_BF16_e64, false }, // 644
  { V_CVT_SCALEF32_SR_PK32_BF6_F16_e64, false }, // 645
  { V_CVT_SCALEF32_SR_PK32_BF6_F32_e64, false }, // 646
  { V_CVT_SCALEF32_SR_PK32_FP6_BF16_e64, false }, // 647
  { V_CVT_SCALEF32_SR_PK32_FP6_F16_e64, false }, // 648
  { V_CVT_SCALEF32_SR_PK32_FP6_F32_e64, false }, // 649
  { V_CVT_SCALEF32_SR_PK_FP4_BF16_e64, true }, // 650
  { V_CVT_SCALEF32_SR_PK_FP4_F16_e64, true }, // 651
  { V_CVT_SCALEF32_SR_PK_FP4_F32_e64, true }, // 652
  { V_CVT_SR_BF16_F32_e64, false }, // 653
  { V_CVT_SR_BF8_F32_e64, true }, // 654
  { V_CVT_SR_BF8_F32_gfx12_e64, true }, // 655
  { V_CVT_SR_F16_F32_e64, false }, // 656
  { V_CVT_SR_FP8_F32_e64, true }, // 657
  { V_CVT_SR_FP8_F32_gfx12_e64, true }, // 658
  { V_CVT_U16_F16_e64, false }, // 659
  { V_CVT_U16_F16_t16_e64, false }, // 660
  { V_CVT_U32_F32_e64, false }, // 661
  { V_CVT_U32_F64_e64, false }, // 662
  { V_CVT_U32_U16_e64, false }, // 663
  { V_CVT_U32_U16_fake16_e64, false }, // 664
  { V_CVT_U32_U16_t16_e64, false }, // 665
  { V_DIV_FIXUP_F16_e64, false }, // 666
  { V_DIV_FIXUP_F16_gfx9_e64, false }, // 667
  { V_DIV_FIXUP_F32_e64, false }, // 668
  { V_DIV_FIXUP_F64_e64, false }, // 669
  { V_DIV_FMAS_F32_e64, false }, // 670
  { V_DIV_FMAS_F64_e64, false }, // 671
  { V_DIV_SCALE_F32_e64, false }, // 672
  { V_DIV_SCALE_F64_e64, false }, // 673
  { V_DOT2C_F32_BF16_e64, false }, // 674
  { V_DOT2C_F32_F16_e64, false }, // 675
  { V_DOT2C_I32_I16_e64, false }, // 676
  { V_DOT2_BF16_BF16_e64, false }, // 677
  { V_DOT2_F16_F16_e64, false }, // 678
  { V_DOT2_F32_BF16, false }, // 679
  { V_DOT2_F32_F16, false }, // 680
  { V_DOT2_I32_I16, false }, // 681
  { V_DOT2_U32_U16, false }, // 682
  { V_DOT4C_I32_I8_e64, false }, // 683
  { V_DOT4_F32_BF8_BF8, false }, // 684
  { V_DOT4_F32_BF8_FP8, false }, // 685
  { V_DOT4_F32_FP8_BF8, false }, // 686
  { V_DOT4_F32_FP8_FP8, false }, // 687
  { V_DOT4_I32_I8, false }, // 688
  { V_DOT4_I32_IU8, false }, // 689
  { V_DOT4_U32_U8, false }, // 690
  { V_DOT8C_I32_I4_e64, false }, // 691
  { V_DOT8_I32_I4, false }, // 692
  { V_DOT8_I32_IU4, false }, // 693
  { V_DOT8_U32_U4, false }, // 694
  { V_EXP_F16_e64, false }, // 695
  { V_EXP_F16_fake16_e64, false }, // 696
  { V_EXP_F16_t16_e64, false }, // 697
  { V_EXP_F32_e64, false }, // 698
  { V_EXP_LEGACY_F32_e64, false }, // 699
  { V_FFBH_I32_e64, false }, // 700
  { V_FFBH_U32_e64, false }, // 701
  { V_FFBL_B32_e64, false }, // 702
  { V_FLOOR_F16_e64, false }, // 703
  { V_FLOOR_F16_fake16_e64, false }, // 704
  { V_FLOOR_F16_t16_e64, false }, // 705
  { V_FLOOR_F32_e64, false }, // 706
  { V_FLOOR_F64_e64, false }, // 707
  { V_FMAC_F16_e64, false }, // 708
  { V_FMAC_F16_t16_e64, false }, // 709
  { V_FMAC_F32_e64, false }, // 710
  { V_FMAC_F64_e64, false }, // 711
  { V_FMAC_LEGACY_F32_e64, false }, // 712
  { V_FMA_F16_e64, false }, // 713
  { V_FMA_F16_gfx9_e64, false }, // 714
  { V_FMA_F32_e64, false }, // 715
  { V_FMA_F64_e64, false }, // 716
  { V_FMA_LEGACY_F32_e64, false }, // 717
  { V_FMA_MIXHI_F16, false }, // 718
  { V_FMA_MIXLO_F16, false }, // 719
  { V_FMA_MIX_F32, false }, // 720
  { V_FRACT_F16_e64, false }, // 721
  { V_FRACT_F16_fake16_e64, false }, // 722
  { V_FRACT_F16_t16_e64, false }, // 723
  { V_FRACT_F32_e64, false }, // 724
  { V_FRACT_F64_e64, false }, // 725
  { V_FREXP_EXP_I16_F16_e64, false }, // 726
  { V_FREXP_EXP_I16_F16_t16_e64, false }, // 727
  { V_FREXP_EXP_I32_F32_e64, false }, // 728
  { V_FREXP_EXP_I32_F64_e64, false }, // 729
  { V_FREXP_MANT_F16_e64, false }, // 730
  { V_FREXP_MANT_F16_fake16_e64, false }, // 731
  { V_FREXP_MANT_F16_t16_e64, false }, // 732
  { V_FREXP_MANT_F32_e64, false }, // 733
  { V_FREXP_MANT_F64_e64, false }, // 734
  { V_INTERP_MOV_F32_e64, false }, // 735
  { V_INTERP_P10_F16_F32_inreg, false }, // 736
  { V_INTERP_P10_F32_inreg, false }, // 737
  { V_INTERP_P10_RTZ_F16_F32_inreg, false }, // 738
  { V_INTERP_P1LL_F16, false }, // 739
  { V_INTERP_P1LV_F16, false }, // 740
  { V_INTERP_P1_F32_e64, false }, // 741
  { V_INTERP_P2_F16, false }, // 742
  { V_INTERP_P2_F16_F32_inreg, false }, // 743
  { V_INTERP_P2_F16_gfx9, false }, // 744
  { V_INTERP_P2_F32_e64, false }, // 745
  { V_INTERP_P2_F32_inreg, false }, // 746
  { V_INTERP_P2_RTZ_F16_F32_inreg, false }, // 747
  { V_LDEXP_F16_e64, false }, // 748
  { V_LDEXP_F16_t16_e64, false }, // 749
  { V_LDEXP_F32_e64, false }, // 750
  { V_LDEXP_F64_e64, false }, // 751
  { V_LERP_U8_e64, false }, // 752
  { V_LOG_CLAMP_F32_e64, false }, // 753
  { V_LOG_F16_e64, false }, // 754
  { V_LOG_F16_fake16_e64, false }, // 755
  { V_LOG_F16_t16_e64, false }, // 756
  { V_LOG_F32_e64, false }, // 757
  { V_LOG_LEGACY_F32_e64, false }, // 758
  { V_LSHLREV_B16_e64, false }, // 759
  { V_LSHLREV_B16_t16_e64, false }, // 760
  { V_LSHLREV_B32_e64, false }, // 761
  { V_LSHLREV_B64_e64, false }, // 762
  { V_LSHLREV_B64_pseudo_e64, false }, // 763
  { V_LSHL_ADD_U32_e64, false }, // 764
  { V_LSHL_ADD_U64_e64, false }, // 765
  { V_LSHL_B32_e64, false }, // 766
  { V_LSHL_B64_e64, false }, // 767
  { V_LSHL_OR_B32_e64, false }, // 768
  { V_LSHRREV_B16_e64, false }, // 769
  { V_LSHRREV_B16_t16_e64, false }, // 770
  { V_LSHRREV_B32_e64, false }, // 771
  { V_LSHRREV_B64_e64, false }, // 772
  { V_LSHR_B32_e64, false }, // 773
  { V_LSHR_B64_e64, false }, // 774
  { V_MAC_F16_e64, false }, // 775
  { V_MAC_F32_e64, false }, // 776
  { V_MAC_LEGACY_F32_e64, false }, // 777
  { V_MAD_F16_e64, false }, // 778
  { V_MAD_F16_gfx9_e64, false }, // 779
  { V_MAD_F32_e64, false }, // 780
  { V_MAD_I16_e64, false }, // 781
  { V_MAD_I16_gfx9_e64, false }, // 782
  { V_MAD_I32_I16_e64, false }, // 783
  { V_MAD_I32_I24_e64, false }, // 784
  { V_MAD_I64_I32_e64, false }, // 785
  { V_MAD_I64_I32_gfx11_e64, false }, // 786
  { V_MAD_LEGACY_F32_e64, false }, // 787
  { V_MAD_MIXHI_F16, false }, // 788
  { V_MAD_MIXLO_F16, false }, // 789
  { V_MAD_MIX_F32, false }, // 790
  { V_MAD_U16_e64, false }, // 791
  { V_MAD_U16_gfx9_e64, false }, // 792
  { V_MAD_U32_U16_e64, false }, // 793
  { V_MAD_U32_U24_e64, false }, // 794
  { V_MAD_U64_U32_e64, false }, // 795
  { V_MAD_U64_U32_gfx11_e64, false }, // 796
  { V_MAX3_F16_e64, false }, // 797
  { V_MAX3_F32_e64, false }, // 798
  { V_MAX3_I16_e64, false }, // 799
  { V_MAX3_I32_e64, false }, // 800
  { V_MAX3_U16_e64, false }, // 801
  { V_MAX3_U32_e64, false }, // 802
  { V_MAXIMUM3_F16_e64, false }, // 803
  { V_MAXIMUM3_F32_e64, false }, // 804
  { V_MAXIMUMMINIMUM_F16_e64, false }, // 805
  { V_MAXIMUMMINIMUM_F32_e64, false }, // 806
  { V_MAXIMUM_F16_e64, false }, // 807
  { V_MAXIMUM_F32_e64, false }, // 808
  { V_MAXIMUM_F64_e64, false }, // 809
  { V_MAXMIN_F16_e64, false }, // 810
  { V_MAXMIN_F32_e64, false }, // 811
  { V_MAXMIN_I32_e64, false }, // 812
  { V_MAXMIN_U32_e64, false }, // 813
  { V_MAX_F16_e64, false }, // 814
  { V_MAX_F16_fake16_e64, false }, // 815
  { V_MAX_F16_t16_e64, false }, // 816
  { V_MAX_F32_e64, false }, // 817
  { V_MAX_F64_e64, false }, // 818
  { V_MAX_I16_e64, false }, // 819
  { V_MAX_I16_t16_e64, false }, // 820
  { V_MAX_I32_e64, false }, // 821
  { V_MAX_LEGACY_F32_e64, false }, // 822
  { V_MAX_NUM_F64_e64, false }, // 823
  { V_MAX_U16_e64, false }, // 824
  { V_MAX_U16_t16_e64, false }, // 825
  { V_MAX_U32_e64, false }, // 826
  { V_MBCNT_HI_U32_B32_e64, false }, // 827
  { V_MBCNT_LO_U32_B32_e64, false }, // 828
  { V_MED3_F16_e64, false }, // 829
  { V_MED3_F32_e64, false }, // 830
  { V_MED3_I16_e64, false }, // 831
  { V_MED3_I32_e64, false }, // 832
  { V_MED3_U16_e64, false }, // 833
  { V_MED3_U32_e64, false }, // 834
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f4_e64, false }, // 835
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f4_vgprcd_e64, false }, // 836
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f6_e64, false }, // 837
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f6_vgprcd_e64, false }, // 838
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f8_e64, false }, // 839
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f8_vgprcd_e64, false }, // 840
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f4_e64, false }, // 841
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f4_vgprcd_e64, false }, // 842
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f6_e64, false }, // 843
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f6_vgprcd_e64, false }, // 844
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f8_e64, false }, // 845
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f8_vgprcd_e64, false }, // 846
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f4_e64, false }, // 847
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f4_vgprcd_e64, false }, // 848
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f6_e64, false }, // 849
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f6_vgprcd_e64, false }, // 850
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f8_e64, false }, // 851
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f8_vgprcd_e64, false }, // 852
  { V_MFMA_F32_16X16X16BF16_1K_e64, false }, // 853
  { V_MFMA_F32_16X16X16BF16_1K_vgprcd_e64, false }, // 854
  { V_MFMA_F32_16X16X16F16_e64, false }, // 855
  { V_MFMA_F32_16X16X16F16_vgprcd_e64, false }, // 856
  { V_MFMA_F32_16X16X1F32_e64, false }, // 857
  { V_MFMA_F32_16X16X1F32_mac_e64, false }, // 858
  { V_MFMA_F32_16X16X1F32_mac_vgprcd_e64, false }, // 859
  { V_MFMA_F32_16X16X1F32_vgprcd_e64, false }, // 860
  { V_MFMA_F32_16X16X2BF16_e64, false }, // 861
  { V_MFMA_F32_16X16X2BF16_mac_e64, false }, // 862
  { V_MFMA_F32_16X16X2BF16_mac_vgprcd_e64, false }, // 863
  { V_MFMA_F32_16X16X2BF16_vgprcd_e64, false }, // 864
  { V_MFMA_F32_16X16X32_BF16_e64, false }, // 865
  { V_MFMA_F32_16X16X32_BF16_vgprcd_e64, false }, // 866
  { V_MFMA_F32_16X16X32_BF8_BF8_e64, false }, // 867
  { V_MFMA_F32_16X16X32_BF8_BF8_vgprcd_e64, false }, // 868
  { V_MFMA_F32_16X16X32_BF8_FP8_e64, false }, // 869
  { V_MFMA_F32_16X16X32_BF8_FP8_vgprcd_e64, false }, // 870
  { V_MFMA_F32_16X16X32_F16_e64, false }, // 871
  { V_MFMA_F32_16X16X32_F16_vgprcd_e64, false }, // 872
  { V_MFMA_F32_16X16X32_FP8_BF8_e64, false }, // 873
  { V_MFMA_F32_16X16X32_FP8_BF8_vgprcd_e64, false }, // 874
  { V_MFMA_F32_16X16X32_FP8_FP8_e64, false }, // 875
  { V_MFMA_F32_16X16X32_FP8_FP8_vgprcd_e64, false }, // 876
  { V_MFMA_F32_16X16X4BF16_1K_e64, false }, // 877
  { V_MFMA_F32_16X16X4BF16_1K_mac_e64, false }, // 878
  { V_MFMA_F32_16X16X4BF16_1K_mac_vgprcd_e64, false }, // 879
  { V_MFMA_F32_16X16X4BF16_1K_vgprcd_e64, false }, // 880
  { V_MFMA_F32_16X16X4F16_e64, false }, // 881
  { V_MFMA_F32_16X16X4F16_mac_e64, false }, // 882
  { V_MFMA_F32_16X16X4F16_mac_vgprcd_e64, false }, // 883
  { V_MFMA_F32_16X16X4F16_vgprcd_e64, false }, // 884
  { V_MFMA_F32_16X16X4F32_e64, false }, // 885
  { V_MFMA_F32_16X16X4F32_vgprcd_e64, false }, // 886
  { V_MFMA_F32_16X16X8BF16_e64, false }, // 887
  { V_MFMA_F32_16X16X8BF16_vgprcd_e64, false }, // 888
  { V_MFMA_F32_16X16X8XF32_e64, false }, // 889
  { V_MFMA_F32_16X16X8XF32_vgprcd_e64, false }, // 890
  { V_MFMA_F32_32X32X16_BF16_e64, false }, // 891
  { V_MFMA_F32_32X32X16_BF16_mac_e64, false }, // 892
  { V_MFMA_F32_32X32X16_BF16_mac_vgprcd_e64, false }, // 893
  { V_MFMA_F32_32X32X16_BF16_vgprcd_e64, false }, // 894
  { V_MFMA_F32_32X32X16_BF8_BF8_e64, false }, // 895
  { V_MFMA_F32_32X32X16_BF8_BF8_mac_e64, false }, // 896
  { V_MFMA_F32_32X32X16_BF8_BF8_mac_vgprcd_e64, false }, // 897
  { V_MFMA_F32_32X32X16_BF8_BF8_vgprcd_e64, false }, // 898
  { V_MFMA_F32_32X32X16_BF8_FP8_e64, false }, // 899
  { V_MFMA_F32_32X32X16_BF8_FP8_mac_e64, false }, // 900
  { V_MFMA_F32_32X32X16_BF8_FP8_mac_vgprcd_e64, false }, // 901
  { V_MFMA_F32_32X32X16_BF8_FP8_vgprcd_e64, false }, // 902
  { V_MFMA_F32_32X32X16_F16_e64, false }, // 903
  { V_MFMA_F32_32X32X16_F16_mac_e64, false }, // 904
  { V_MFMA_F32_32X32X16_F16_mac_vgprcd_e64, false }, // 905
  { V_MFMA_F32_32X32X16_F16_vgprcd_e64, false }, // 906
  { V_MFMA_F32_32X32X16_FP8_BF8_e64, false }, // 907
  { V_MFMA_F32_32X32X16_FP8_BF8_mac_e64, false }, // 908
  { V_MFMA_F32_32X32X16_FP8_BF8_mac_vgprcd_e64, false }, // 909
  { V_MFMA_F32_32X32X16_FP8_BF8_vgprcd_e64, false }, // 910
  { V_MFMA_F32_32X32X16_FP8_FP8_e64, false }, // 911
  { V_MFMA_F32_32X32X16_FP8_FP8_mac_e64, false }, // 912
  { V_MFMA_F32_32X32X16_FP8_FP8_mac_vgprcd_e64, false }, // 913
  { V_MFMA_F32_32X32X16_FP8_FP8_vgprcd_e64, false }, // 914
  { V_MFMA_F32_32X32X1F32_e64, false }, // 915
  { V_MFMA_F32_32X32X1F32_mac_e64, false }, // 916
  { V_MFMA_F32_32X32X1F32_mac_vgprcd_e64, false }, // 917
  { V_MFMA_F32_32X32X1F32_vgprcd_e64, false }, // 918
  { V_MFMA_F32_32X32X2BF16_e64, false }, // 919
  { V_MFMA_F32_32X32X2BF16_mac_e64, false }, // 920
  { V_MFMA_F32_32X32X2BF16_mac_vgprcd_e64, false }, // 921
  { V_MFMA_F32_32X32X2BF16_vgprcd_e64, false }, // 922
  { V_MFMA_F32_32X32X2F32_e64, false }, // 923
  { V_MFMA_F32_32X32X2F32_mac_e64, false }, // 924
  { V_MFMA_F32_32X32X2F32_mac_vgprcd_e64, false }, // 925
  { V_MFMA_F32_32X32X2F32_vgprcd_e64, false }, // 926
  { V_MFMA_F32_32X32X4BF16_1K_e64, false }, // 927
  { V_MFMA_F32_32X32X4BF16_1K_mac_e64, false }, // 928
  { V_MFMA_F32_32X32X4BF16_1K_mac_vgprcd_e64, false }, // 929
  { V_MFMA_F32_32X32X4BF16_1K_vgprcd_e64, false }, // 930
  { V_MFMA_F32_32X32X4BF16_e64, false }, // 931
  { V_MFMA_F32_32X32X4BF16_mac_e64, false }, // 932
  { V_MFMA_F32_32X32X4BF16_mac_vgprcd_e64, false }, // 933
  { V_MFMA_F32_32X32X4BF16_vgprcd_e64, false }, // 934
  { V_MFMA_F32_32X32X4F16_e64, false }, // 935
  { V_MFMA_F32_32X32X4F16_mac_e64, false }, // 936
  { V_MFMA_F32_32X32X4F16_mac_vgprcd_e64, false }, // 937
  { V_MFMA_F32_32X32X4F16_vgprcd_e64, false }, // 938
  { V_MFMA_F32_32X32X4XF32_e64, false }, // 939
  { V_MFMA_F32_32X32X4XF32_mac_e64, false }, // 940
  { V_MFMA_F32_32X32X4XF32_mac_vgprcd_e64, false }, // 941
  { V_MFMA_F32_32X32X4XF32_vgprcd_e64, false }, // 942
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_e64, false }, // 943
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_mac_e64, false }, // 944
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_mac_vgprcd_e64, false }, // 945
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_vgprcd_e64, false }, // 946
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_e64, false }, // 947
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_mac_e64, false }, // 948
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_mac_vgprcd_e64, false }, // 949
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_vgprcd_e64, false }, // 950
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_e64, false }, // 951
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_mac_e64, false }, // 952
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_mac_vgprcd_e64, false }, // 953
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_vgprcd_e64, false }, // 954
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_e64, false }, // 955
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_mac_e64, false }, // 956
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_mac_vgprcd_e64, false }, // 957
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_vgprcd_e64, false }, // 958
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_e64, false }, // 959
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_mac_e64, false }, // 960
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_mac_vgprcd_e64, false }, // 961
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_vgprcd_e64, false }, // 962
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_e64, false }, // 963
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_mac_e64, false }, // 964
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_mac_vgprcd_e64, false }, // 965
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_vgprcd_e64, false }, // 966
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_e64, false }, // 967
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_mac_e64, false }, // 968
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_mac_vgprcd_e64, false }, // 969
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_vgprcd_e64, false }, // 970
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_e64, false }, // 971
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_mac_e64, false }, // 972
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_mac_vgprcd_e64, false }, // 973
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_vgprcd_e64, false }, // 974
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_e64, false }, // 975
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_mac_e64, false }, // 976
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_mac_vgprcd_e64, false }, // 977
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_vgprcd_e64, false }, // 978
  { V_MFMA_F32_32X32X8BF16_1K_e64, false }, // 979
  { V_MFMA_F32_32X32X8BF16_1K_mac_e64, false }, // 980
  { V_MFMA_F32_32X32X8BF16_1K_mac_vgprcd_e64, false }, // 981
  { V_MFMA_F32_32X32X8BF16_1K_vgprcd_e64, false }, // 982
  { V_MFMA_F32_32X32X8F16_e64, false }, // 983
  { V_MFMA_F32_32X32X8F16_mac_e64, false }, // 984
  { V_MFMA_F32_32X32X8F16_mac_vgprcd_e64, false }, // 985
  { V_MFMA_F32_32X32X8F16_vgprcd_e64, false }, // 986
  { V_MFMA_F32_4X4X1F32_e64, false }, // 987
  { V_MFMA_F32_4X4X1F32_vgprcd_e64, false }, // 988
  { V_MFMA_F32_4X4X2BF16_e64, false }, // 989
  { V_MFMA_F32_4X4X2BF16_vgprcd_e64, false }, // 990
  { V_MFMA_F32_4X4X4BF16_1K_e64, false }, // 991
  { V_MFMA_F32_4X4X4BF16_1K_vgprcd_e64, false }, // 992
  { V_MFMA_F32_4X4X4F16_e64, false }, // 993
  { V_MFMA_F32_4X4X4F16_vgprcd_e64, false }, // 994
  { V_MFMA_F64_16X16X4F64_e64, false }, // 995
  { V_MFMA_F64_16X16X4F64_mac_e64, false }, // 996
  { V_MFMA_F64_16X16X4F64_mac_vgprcd_e64, false }, // 997
  { V_MFMA_F64_16X16X4F64_vgprcd_e64, false }, // 998
  { V_MFMA_F64_4X4X4F64_e64, false }, // 999
  { V_MFMA_F64_4X4X4F64_vgprcd_e64, false }, // 1000
  { V_MFMA_I32_16X16X16I8_e64, false }, // 1001
  { V_MFMA_I32_16X16X16I8_vgprcd_e64, false }, // 1002
  { V_MFMA_I32_16X16X32I8_e64, false }, // 1003
  { V_MFMA_I32_16X16X32I8_vgprcd_e64, false }, // 1004
  { V_MFMA_I32_16X16X4I8_e64, false }, // 1005
  { V_MFMA_I32_16X16X4I8_mac_e64, false }, // 1006
  { V_MFMA_I32_16X16X4I8_mac_vgprcd_e64, false }, // 1007
  { V_MFMA_I32_16X16X4I8_vgprcd_e64, false }, // 1008
  { V_MFMA_I32_16X16X64_I8_e64, false }, // 1009
  { V_MFMA_I32_16X16X64_I8_vgprcd_e64, false }, // 1010
  { V_MFMA_I32_32X32X16I8_e64, false }, // 1011
  { V_MFMA_I32_32X32X16I8_mac_e64, false }, // 1012
  { V_MFMA_I32_32X32X16I8_mac_vgprcd_e64, false }, // 1013
  { V_MFMA_I32_32X32X16I8_vgprcd_e64, false }, // 1014
  { V_MFMA_I32_32X32X32_I8_e64, false }, // 1015
  { V_MFMA_I32_32X32X32_I8_mac_e64, false }, // 1016
  { V_MFMA_I32_32X32X32_I8_mac_vgprcd_e64, false }, // 1017
  { V_MFMA_I32_32X32X32_I8_vgprcd_e64, false }, // 1018
  { V_MFMA_I32_32X32X4I8_e64, false }, // 1019
  { V_MFMA_I32_32X32X4I8_mac_e64, false }, // 1020
  { V_MFMA_I32_32X32X4I8_mac_vgprcd_e64, false }, // 1021
  { V_MFMA_I32_32X32X4I8_vgprcd_e64, false }, // 1022
  { V_MFMA_I32_32X32X8I8_e64, false }, // 1023
  { V_MFMA_I32_32X32X8I8_mac_e64, false }, // 1024
  { V_MFMA_I32_32X32X8I8_mac_vgprcd_e64, false }, // 1025
  { V_MFMA_I32_32X32X8I8_vgprcd_e64, false }, // 1026
  { V_MFMA_I32_4X4X4I8_e64, false }, // 1027
  { V_MFMA_I32_4X4X4I8_vgprcd_e64, false }, // 1028
  { V_MFMA_LD_SCALE_B32, false }, // 1029
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f4_e64, false }, // 1030
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f4_vgprcd_e64, false }, // 1031
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f6_e64, false }, // 1032
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f6_vgprcd_e64, false }, // 1033
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f8_e64, false }, // 1034
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f8_vgprcd_e64, false }, // 1035
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f4_e64, false }, // 1036
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f4_vgprcd_e64, false }, // 1037
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f6_e64, false }, // 1038
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f6_vgprcd_e64, false }, // 1039
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f8_e64, false }, // 1040
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f8_vgprcd_e64, false }, // 1041
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f4_e64, false }, // 1042
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f4_vgprcd_e64, false }, // 1043
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f6_e64, false }, // 1044
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f6_vgprcd_e64, false }, // 1045
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f8_e64, false }, // 1046
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f8_vgprcd_e64, false }, // 1047
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_e64, false }, // 1048
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_mac_e64, false }, // 1049
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_mac_vgprcd_e64, false }, // 1050
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_vgprcd_e64, false }, // 1051
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_e64, false }, // 1052
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_mac_e64, false }, // 1053
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_mac_vgprcd_e64, false }, // 1054
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_vgprcd_e64, false }, // 1055
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_e64, false }, // 1056
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_mac_e64, false }, // 1057
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_mac_vgprcd_e64, false }, // 1058
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_vgprcd_e64, false }, // 1059
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_e64, false }, // 1060
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_mac_e64, false }, // 1061
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_mac_vgprcd_e64, false }, // 1062
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_vgprcd_e64, false }, // 1063
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_e64, false }, // 1064
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_mac_e64, false }, // 1065
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_mac_vgprcd_e64, false }, // 1066
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_vgprcd_e64, false }, // 1067
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_e64, false }, // 1068
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_mac_e64, false }, // 1069
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_mac_vgprcd_e64, false }, // 1070
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_vgprcd_e64, false }, // 1071
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_e64, false }, // 1072
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_mac_e64, false }, // 1073
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_mac_vgprcd_e64, false }, // 1074
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_vgprcd_e64, false }, // 1075
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_e64, false }, // 1076
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_mac_e64, false }, // 1077
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_mac_vgprcd_e64, false }, // 1078
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_vgprcd_e64, false }, // 1079
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_e64, false }, // 1080
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_mac_e64, false }, // 1081
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_mac_vgprcd_e64, false }, // 1082
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_vgprcd_e64, false }, // 1083
  { V_MIN3_F16_e64, false }, // 1084
  { V_MIN3_F32_e64, false }, // 1085
  { V_MIN3_I16_e64, false }, // 1086
  { V_MIN3_I32_e64, false }, // 1087
  { V_MIN3_U16_e64, false }, // 1088
  { V_MIN3_U32_e64, false }, // 1089
  { V_MINIMUM3_F16_e64, false }, // 1090
  { V_MINIMUM3_F32_e64, false }, // 1091
  { V_MINIMUMMAXIMUM_F16_e64, false }, // 1092
  { V_MINIMUMMAXIMUM_F32_e64, false }, // 1093
  { V_MINIMUM_F16_e64, false }, // 1094
  { V_MINIMUM_F32_e64, false }, // 1095
  { V_MINIMUM_F64_e64, false }, // 1096
  { V_MINMAX_F16_e64, false }, // 1097
  { V_MINMAX_F32_e64, false }, // 1098
  { V_MINMAX_I32_e64, false }, // 1099
  { V_MINMAX_U32_e64, false }, // 1100
  { V_MIN_F16_e64, false }, // 1101
  { V_MIN_F16_fake16_e64, false }, // 1102
  { V_MIN_F16_t16_e64, false }, // 1103
  { V_MIN_F32_e64, false }, // 1104
  { V_MIN_F64_e64, false }, // 1105
  { V_MIN_I16_e64, false }, // 1106
  { V_MIN_I16_t16_e64, false }, // 1107
  { V_MIN_I32_e64, false }, // 1108
  { V_MIN_LEGACY_F32_e64, false }, // 1109
  { V_MIN_NUM_F64_e64, false }, // 1110
  { V_MIN_U16_e64, false }, // 1111
  { V_MIN_U16_t16_e64, false }, // 1112
  { V_MIN_U32_e64, false }, // 1113
  { V_MOVRELD_B32_e64, false }, // 1114
  { V_MOVRELSD_2_B32_e64, false }, // 1115
  { V_MOVRELSD_B32_e64, false }, // 1116
  { V_MOVRELS_B32_e64, false }, // 1117
  { V_MOV_B16_t16_e64, false }, // 1118
  { V_MOV_B32_e64, false }, // 1119
  { V_MOV_B64_e64, false }, // 1120
  { V_MQSAD_PK_U16_U8_e64, false }, // 1121
  { V_MQSAD_U32_U8_e64, false }, // 1122
  { V_MSAD_U8_e64, false }, // 1123
  { V_MULLIT_F32_e64, false }, // 1124
  { V_MUL_F16_e64, false }, // 1125
  { V_MUL_F16_fake16_e64, false }, // 1126
  { V_MUL_F16_t16_e64, false }, // 1127
  { V_MUL_F32_e64, false }, // 1128
  { V_MUL_F64_e64, false }, // 1129
  { V_MUL_F64_pseudo_e64, false }, // 1130
  { V_MUL_HI_I32_I24_e64, false }, // 1131
  { V_MUL_HI_I32_e64, false }, // 1132
  { V_MUL_HI_U32_U24_e64, false }, // 1133
  { V_MUL_HI_U32_e64, false }, // 1134
  { V_MUL_I32_I24_e64, false }, // 1135
  { V_MUL_LEGACY_F32_e64, false }, // 1136
  { V_MUL_LO_I32_e64, false }, // 1137
  { V_MUL_LO_U16_e64, false }, // 1138
  { V_MUL_LO_U16_t16_e64, false }, // 1139
  { V_MUL_LO_U32_e64, false }, // 1140
  { V_MUL_U32_U24_e64, false }, // 1141
  { V_NOP_e64, false }, // 1142
  { V_NOT_B16_e64, false }, // 1143
  { V_NOT_B16_fake16_e64, false }, // 1144
  { V_NOT_B16_t16_e64, false }, // 1145
  { V_NOT_B32_e64, false }, // 1146
  { V_OR3_B32_e64, false }, // 1147
  { V_OR_B16_t16_e64, false }, // 1148
  { V_OR_B32_e64, false }, // 1149
  { V_PACK_B32_F16_e64, false }, // 1150
  { V_PERMLANE16_B32_e64, false }, // 1151
  { V_PERMLANE16_SWAP_B32_e64, false }, // 1152
  { V_PERMLANE16_VAR_B32_e64, false }, // 1153
  { V_PERMLANE32_SWAP_B32_e64, false }, // 1154
  { V_PERMLANEX16_B32_e64, false }, // 1155
  { V_PERMLANEX16_VAR_B32_e64, false }, // 1156
  { V_PERM_B32_e64, false }, // 1157
  { V_PIPEFLUSH_e64, false }, // 1158
  { V_PK_ADD_F16, false }, // 1159
  { V_PK_ADD_F32, false }, // 1160
  { V_PK_ADD_I16, false }, // 1161
  { V_PK_ADD_U16, false }, // 1162
  { V_PK_ASHRREV_I16, false }, // 1163
  { V_PK_FMAC_F16_e64, false }, // 1164
  { V_PK_FMA_F16, false }, // 1165
  { V_PK_FMA_F32, false }, // 1166
  { V_PK_LSHLREV_B16, false }, // 1167
  { V_PK_LSHRREV_B16, false }, // 1168
  { V_PK_MAD_I16, false }, // 1169
  { V_PK_MAD_U16, false }, // 1170
  { V_PK_MAXIMUM3_F16, false }, // 1171
  { V_PK_MAXIMUM_F16, false }, // 1172
  { V_PK_MAX_F16, false }, // 1173
  { V_PK_MAX_I16, false }, // 1174
  { V_PK_MAX_U16, false }, // 1175
  { V_PK_MINIMUM3_F16, false }, // 1176
  { V_PK_MINIMUM_F16, false }, // 1177
  { V_PK_MIN_F16, false }, // 1178
  { V_PK_MIN_I16, false }, // 1179
  { V_PK_MIN_U16, false }, // 1180
  { V_PK_MOV_B32, false }, // 1181
  { V_PK_MUL_F16, false }, // 1182
  { V_PK_MUL_F32, false }, // 1183
  { V_PK_MUL_LO_U16, false }, // 1184
  { V_PK_SUB_I16, false }, // 1185
  { V_PK_SUB_U16, false }, // 1186
  { V_PRNG_B32_e64, false }, // 1187
  { V_QSAD_PK_U16_U8_e64, false }, // 1188
  { V_RCP_CLAMP_F32_e64, false }, // 1189
  { V_RCP_CLAMP_F64_e64, false }, // 1190
  { V_RCP_F16_e64, false }, // 1191
  { V_RCP_F16_fake16_e64, false }, // 1192
  { V_RCP_F16_t16_e64, false }, // 1193
  { V_RCP_F32_e64, false }, // 1194
  { V_RCP_F64_e64, false }, // 1195
  { V_RCP_IFLAG_F32_e64, false }, // 1196
  { V_RCP_LEGACY_F32_e64, false }, // 1197
  { V_RNDNE_F16_e64, false }, // 1198
  { V_RNDNE_F16_fake16_e64, false }, // 1199
  { V_RNDNE_F16_t16_e64, false }, // 1200
  { V_RNDNE_F32_e64, false }, // 1201
  { V_RNDNE_F64_e64, false }, // 1202
  { V_RSQ_CLAMP_F32_e64, false }, // 1203
  { V_RSQ_CLAMP_F64_e64, false }, // 1204
  { V_RSQ_F16_e64, false }, // 1205
  { V_RSQ_F16_fake16_e64, false }, // 1206
  { V_RSQ_F16_t16_e64, false }, // 1207
  { V_RSQ_F32_e64, false }, // 1208
  { V_RSQ_F64_e64, false }, // 1209
  { V_RSQ_LEGACY_F32_e64, false }, // 1210
  { V_SAD_HI_U8_e64, false }, // 1211
  { V_SAD_U16_e64, false }, // 1212
  { V_SAD_U32_e64, false }, // 1213
  { V_SAD_U8_e64, false }, // 1214
  { V_SAT_PK_U8_I16_e64, false }, // 1215
  { V_SAT_PK_U8_I16_fake16_e64, false }, // 1216
  { V_SAT_PK_U8_I16_t16_e64, false }, // 1217
  { V_SCREEN_PARTITION_4SE_B32_e64, false }, // 1218
  { V_SIN_F16_e64, false }, // 1219
  { V_SIN_F16_fake16_e64, false }, // 1220
  { V_SIN_F16_t16_e64, false }, // 1221
  { V_SIN_F32_e64, false }, // 1222
  { V_SMFMAC_F32_16X16X128_BF8_BF8_e64, false }, // 1223
  { V_SMFMAC_F32_16X16X128_BF8_FP8_e64, false }, // 1224
  { V_SMFMAC_F32_16X16X128_FP8_BF8_e64, false }, // 1225
  { V_SMFMAC_F32_16X16X128_FP8_FP8_e64, false }, // 1226
  { V_SMFMAC_F32_16X16X32_BF16_e64, false }, // 1227
  { V_SMFMAC_F32_16X16X32_F16_e64, false }, // 1228
  { V_SMFMAC_F32_16X16X64_BF16_e64, false }, // 1229
  { V_SMFMAC_F32_16X16X64_BF8_BF8_e64, false }, // 1230
  { V_SMFMAC_F32_16X16X64_BF8_FP8_e64, false }, // 1231
  { V_SMFMAC_F32_16X16X64_F16_e64, false }, // 1232
  { V_SMFMAC_F32_16X16X64_FP8_BF8_e64, false }, // 1233
  { V_SMFMAC_F32_16X16X64_FP8_FP8_e64, false }, // 1234
  { V_SMFMAC_F32_32X32X16_BF16_e64, false }, // 1235
  { V_SMFMAC_F32_32X32X16_F16_e64, false }, // 1236
  { V_SMFMAC_F32_32X32X32_BF16_e64, false }, // 1237
  { V_SMFMAC_F32_32X32X32_BF8_BF8_e64, false }, // 1238
  { V_SMFMAC_F32_32X32X32_BF8_FP8_e64, false }, // 1239
  { V_SMFMAC_F32_32X32X32_F16_e64, false }, // 1240
  { V_SMFMAC_F32_32X32X32_FP8_BF8_e64, false }, // 1241
  { V_SMFMAC_F32_32X32X32_FP8_FP8_e64, false }, // 1242
  { V_SMFMAC_F32_32X32X64_BF8_BF8_e64, false }, // 1243
  { V_SMFMAC_F32_32X32X64_BF8_FP8_e64, false }, // 1244
  { V_SMFMAC_F32_32X32X64_FP8_BF8_e64, false }, // 1245
  { V_SMFMAC_F32_32X32X64_FP8_FP8_e64, false }, // 1246
  { V_SMFMAC_I32_16X16X128_I8_e64, false }, // 1247
  { V_SMFMAC_I32_16X16X64_I8_e64, false }, // 1248
  { V_SMFMAC_I32_32X32X32_I8_e64, false }, // 1249
  { V_SMFMAC_I32_32X32X64_I8_e64, false }, // 1250
  { V_SQRT_F16_e64, false }, // 1251
  { V_SQRT_F16_fake16_e64, false }, // 1252
  { V_SQRT_F16_t16_e64, false }, // 1253
  { V_SQRT_F32_e64, false }, // 1254
  { V_SQRT_F64_e64, false }, // 1255
  { V_SUBBREV_U32_e64, false }, // 1256
  { V_SUBB_U32_e64, false }, // 1257
  { V_SUBREV_CO_U32_e64, false }, // 1258
  { V_SUBREV_F16_e64, false }, // 1259
  { V_SUBREV_F16_fake16_e64, false }, // 1260
  { V_SUBREV_F16_t16_e64, false }, // 1261
  { V_SUBREV_F32_e64, false }, // 1262
  { V_SUBREV_U16_e64, false }, // 1263
  { V_SUBREV_U32_e64, false }, // 1264
  { V_SUB_CO_U32_e64, false }, // 1265
  { V_SUB_F16_e64, false }, // 1266
  { V_SUB_F16_fake16_e64, false }, // 1267
  { V_SUB_F16_t16_e64, false }, // 1268
  { V_SUB_F32_e64, false }, // 1269
  { V_SUB_I16_e64, false }, // 1270
  { V_SUB_I32_e64, false }, // 1271
  { V_SUB_NC_U16_e64, false }, // 1272
  { V_SUB_U16_e64, false }, // 1273
  { V_SUB_U32_e64, false }, // 1274
  { V_SWMMAC_BF16_16X16X32_BF16_w32_twoaddr, false }, // 1275
  { V_SWMMAC_BF16_16X16X32_BF16_w64_twoaddr, false }, // 1276
  { V_SWMMAC_F16_16X16X32_F16_w32_twoaddr, false }, // 1277
  { V_SWMMAC_F16_16X16X32_F16_w64_twoaddr, false }, // 1278
  { V_SWMMAC_F32_16X16X32_BF16_w32_twoaddr, false }, // 1279
  { V_SWMMAC_F32_16X16X32_BF16_w64_twoaddr, false }, // 1280
  { V_SWMMAC_F32_16X16X32_BF8_BF8_w32_twoaddr, false }, // 1281
  { V_SWMMAC_F32_16X16X32_BF8_BF8_w64_twoaddr, false }, // 1282
  { V_SWMMAC_F32_16X16X32_BF8_FP8_w32_twoaddr, false }, // 1283
  { V_SWMMAC_F32_16X16X32_BF8_FP8_w64_twoaddr, false }, // 1284
  { V_SWMMAC_F32_16X16X32_F16_w32_twoaddr, false }, // 1285
  { V_SWMMAC_F32_16X16X32_F16_w64_twoaddr, false }, // 1286
  { V_SWMMAC_F32_16X16X32_FP8_BF8_w32_twoaddr, false }, // 1287
  { V_SWMMAC_F32_16X16X32_FP8_BF8_w64_twoaddr, false }, // 1288
  { V_SWMMAC_F32_16X16X32_FP8_FP8_w32_twoaddr, false }, // 1289
  { V_SWMMAC_F32_16X16X32_FP8_FP8_w64_twoaddr, false }, // 1290
  { V_SWMMAC_I32_16X16X32_IU4_w32_twoaddr, false }, // 1291
  { V_SWMMAC_I32_16X16X32_IU4_w64_twoaddr, false }, // 1292
  { V_SWMMAC_I32_16X16X32_IU8_w32_twoaddr, false }, // 1293
  { V_SWMMAC_I32_16X16X32_IU8_w64_twoaddr, false }, // 1294
  { V_SWMMAC_I32_16X16X64_IU4_w32_twoaddr, false }, // 1295
  { V_SWMMAC_I32_16X16X64_IU4_w64_twoaddr, false }, // 1296
  { V_S_EXP_F16_e64, false }, // 1297
  { V_S_EXP_F32_e64, false }, // 1298
  { V_S_LOG_F16_e64, false }, // 1299
  { V_S_LOG_F32_e64, false }, // 1300
  { V_S_RCP_F16_e64, false }, // 1301
  { V_S_RCP_F32_e64, false }, // 1302
  { V_S_RSQ_F16_e64, false }, // 1303
  { V_S_RSQ_F32_e64, false }, // 1304
  { V_S_SQRT_F16_e64, false }, // 1305
  { V_S_SQRT_F32_e64, false }, // 1306
  { V_TRIG_PREOP_F64_e64, false }, // 1307
  { V_TRUNC_F16_e64, false }, // 1308
  { V_TRUNC_F16_fake16_e64, false }, // 1309
  { V_TRUNC_F16_t16_e64, false }, // 1310
  { V_TRUNC_F32_e64, false }, // 1311
  { V_TRUNC_F64_e64, false }, // 1312
  { V_WMMA_BF16_16X16X16_BF16_TIED_twoaddr_w32, false }, // 1313
  { V_WMMA_BF16_16X16X16_BF16_TIED_twoaddr_w64, false }, // 1314
  { V_WMMA_BF16_16X16X16_BF16_threeaddr_w32, false }, // 1315
  { V_WMMA_BF16_16X16X16_BF16_threeaddr_w64, false }, // 1316
  { V_WMMA_BF16_16X16X16_BF16_twoaddr_w32, false }, // 1317
  { V_WMMA_BF16_16X16X16_BF16_twoaddr_w64, false }, // 1318
  { V_WMMA_BF16_16X16X16_BF16_w32_threeaddr, false }, // 1319
  { V_WMMA_BF16_16X16X16_BF16_w32_twoaddr, false }, // 1320
  { V_WMMA_BF16_16X16X16_BF16_w64_threeaddr, false }, // 1321
  { V_WMMA_BF16_16X16X16_BF16_w64_twoaddr, false }, // 1322
  { V_WMMA_F16_16X16X16_F16_TIED_twoaddr_w32, false }, // 1323
  { V_WMMA_F16_16X16X16_F16_TIED_twoaddr_w64, false }, // 1324
  { V_WMMA_F16_16X16X16_F16_threeaddr_w32, false }, // 1325
  { V_WMMA_F16_16X16X16_F16_threeaddr_w64, false }, // 1326
  { V_WMMA_F16_16X16X16_F16_twoaddr_w32, false }, // 1327
  { V_WMMA_F16_16X16X16_F16_twoaddr_w64, false }, // 1328
  { V_WMMA_F16_16X16X16_F16_w32_threeaddr, false }, // 1329
  { V_WMMA_F16_16X16X16_F16_w32_twoaddr, false }, // 1330
  { V_WMMA_F16_16X16X16_F16_w64_threeaddr, false }, // 1331
  { V_WMMA_F16_16X16X16_F16_w64_twoaddr, false }, // 1332
  { V_WMMA_F32_16X16X16_BF16_threeaddr_w32, false }, // 1333
  { V_WMMA_F32_16X16X16_BF16_threeaddr_w64, false }, // 1334
  { V_WMMA_F32_16X16X16_BF16_twoaddr_w32, false }, // 1335
  { V_WMMA_F32_16X16X16_BF16_twoaddr_w64, false }, // 1336
  { V_WMMA_F32_16X16X16_BF16_w32_threeaddr, false }, // 1337
  { V_WMMA_F32_16X16X16_BF16_w32_twoaddr, false }, // 1338
  { V_WMMA_F32_16X16X16_BF16_w64_threeaddr, false }, // 1339
  { V_WMMA_F32_16X16X16_BF16_w64_twoaddr, false }, // 1340
  { V_WMMA_F32_16X16X16_BF8_BF8_w32_threeaddr, false }, // 1341
  { V_WMMA_F32_16X16X16_BF8_BF8_w32_twoaddr, false }, // 1342
  { V_WMMA_F32_16X16X16_BF8_BF8_w64_threeaddr, false }, // 1343
  { V_WMMA_F32_16X16X16_BF8_BF8_w64_twoaddr, false }, // 1344
  { V_WMMA_F32_16X16X16_BF8_FP8_w32_threeaddr, false }, // 1345
  { V_WMMA_F32_16X16X16_BF8_FP8_w32_twoaddr, false }, // 1346
  { V_WMMA_F32_16X16X16_BF8_FP8_w64_threeaddr, false }, // 1347
  { V_WMMA_F32_16X16X16_BF8_FP8_w64_twoaddr, false }, // 1348
  { V_WMMA_F32_16X16X16_F16_threeaddr_w32, false }, // 1349
  { V_WMMA_F32_16X16X16_F16_threeaddr_w64, false }, // 1350
  { V_WMMA_F32_16X16X16_F16_twoaddr_w32, false }, // 1351
  { V_WMMA_F32_16X16X16_F16_twoaddr_w64, false }, // 1352
  { V_WMMA_F32_16X16X16_F16_w32_threeaddr, false }, // 1353
  { V_WMMA_F32_16X16X16_F16_w32_twoaddr, false }, // 1354
  { V_WMMA_F32_16X16X16_F16_w64_threeaddr, false }, // 1355
  { V_WMMA_F32_16X16X16_F16_w64_twoaddr, false }, // 1356
  { V_WMMA_F32_16X16X16_FP8_BF8_w32_threeaddr, false }, // 1357
  { V_WMMA_F32_16X16X16_FP8_BF8_w32_twoaddr, false }, // 1358
  { V_WMMA_F32_16X16X16_FP8_BF8_w64_threeaddr, false }, // 1359
  { V_WMMA_F32_16X16X16_FP8_BF8_w64_twoaddr, false }, // 1360
  { V_WMMA_F32_16X16X16_FP8_FP8_w32_threeaddr, false }, // 1361
  { V_WMMA_F32_16X16X16_FP8_FP8_w32_twoaddr, false }, // 1362
  { V_WMMA_F32_16X16X16_FP8_FP8_w64_threeaddr, false }, // 1363
  { V_WMMA_F32_16X16X16_FP8_FP8_w64_twoaddr, false }, // 1364
  { V_WMMA_I32_16X16X16_IU4_threeaddr_w32, false }, // 1365
  { V_WMMA_I32_16X16X16_IU4_threeaddr_w64, false }, // 1366
  { V_WMMA_I32_16X16X16_IU4_twoaddr_w32, false }, // 1367
  { V_WMMA_I32_16X16X16_IU4_twoaddr_w64, false }, // 1368
  { V_WMMA_I32_16X16X16_IU4_w32_threeaddr, false }, // 1369
  { V_WMMA_I32_16X16X16_IU4_w32_twoaddr, false }, // 1370
  { V_WMMA_I32_16X16X16_IU4_w64_threeaddr, false }, // 1371
  { V_WMMA_I32_16X16X16_IU4_w64_twoaddr, false }, // 1372
  { V_WMMA_I32_16X16X16_IU8_threeaddr_w32, false }, // 1373
  { V_WMMA_I32_16X16X16_IU8_threeaddr_w64, false }, // 1374
  { V_WMMA_I32_16X16X16_IU8_twoaddr_w32, false }, // 1375
  { V_WMMA_I32_16X16X16_IU8_twoaddr_w64, false }, // 1376
  { V_WMMA_I32_16X16X16_IU8_w32_threeaddr, false }, // 1377
  { V_WMMA_I32_16X16X16_IU8_w32_twoaddr, false }, // 1378
  { V_WMMA_I32_16X16X16_IU8_w64_threeaddr, false }, // 1379
  { V_WMMA_I32_16X16X16_IU8_w64_twoaddr, false }, // 1380
  { V_WMMA_I32_16X16X32_IU4_w32_threeaddr, false }, // 1381
  { V_WMMA_I32_16X16X32_IU4_w32_twoaddr, false }, // 1382
  { V_WMMA_I32_16X16X32_IU4_w64_threeaddr, false }, // 1383
  { V_WMMA_I32_16X16X32_IU4_w64_twoaddr, false }, // 1384
  { V_XAD_U32_e64, false }, // 1385
  { V_XNOR_B32_e64, false }, // 1386
  { V_XOR3_B32_e64, false }, // 1387
  { V_XOR_B16_t16_e64, false }, // 1388
  { V_XOR_B32_e64, false }, // 1389
 };

const FP8DstByteSelInfo *getFP8DstByteSelHelper(unsigned Opcode) {
  struct KeyType {
    unsigned Opcode;
  };
  KeyType Key = {Opcode};
  struct Comp {
    bool operator()(const FP8DstByteSelInfo &LHS, const KeyType &RHS) const {
      if (LHS.Opcode < RHS.Opcode)
        return true;
      if (LHS.Opcode > RHS.Opcode)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(FP8DstByteSelTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Opcode != Idx->Opcode)
    return nullptr;

  return &*Idx;
}
#endif

#ifdef GET_Gfx9BufferFormat_DECL
const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat);
const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t Format);
#endif

#ifdef GET_Gfx9BufferFormat_IMPL
constexpr GcnBufferFormatInfo Gfx9BufferFormat[] = {
  { 0x1, 0x8, 0x1, 0x0, 0x1 }, // 0
  { 0x11, 0x8, 0x1, 0x1, 0x1 }, // 1
  { 0x21, 0x8, 0x1, 0x2, 0x1 }, // 2
  { 0x31, 0x8, 0x1, 0x3, 0x1 }, // 3
  { 0x41, 0x8, 0x1, 0x4, 0x1 }, // 4
  { 0x51, 0x8, 0x1, 0x5, 0x1 }, // 5
  { 0x3, 0x8, 0x2, 0x0, 0x3 }, // 6
  { 0x13, 0x8, 0x2, 0x1, 0x3 }, // 7
  { 0x23, 0x8, 0x2, 0x2, 0x3 }, // 8
  { 0x33, 0x8, 0x2, 0x3, 0x3 }, // 9
  { 0x43, 0x8, 0x2, 0x4, 0x3 }, // 10
  { 0x53, 0x8, 0x2, 0x5, 0x3 }, // 11
  { 0xA, 0x8, 0x4, 0x0, 0xA }, // 12
  { 0x1A, 0x8, 0x4, 0x1, 0xA }, // 13
  { 0x2A, 0x8, 0x4, 0x2, 0xA }, // 14
  { 0x3A, 0x8, 0x4, 0x3, 0xA }, // 15
  { 0x4A, 0x8, 0x4, 0x4, 0xA }, // 16
  { 0x5A, 0x8, 0x4, 0x5, 0xA }, // 17
  { 0x2, 0x10, 0x1, 0x0, 0x2 }, // 18
  { 0x12, 0x10, 0x1, 0x1, 0x2 }, // 19
  { 0x22, 0x10, 0x1, 0x2, 0x2 }, // 20
  { 0x32, 0x10, 0x1, 0x3, 0x2 }, // 21
  { 0x42, 0x10, 0x1, 0x4, 0x2 }, // 22
  { 0x52, 0x10, 0x1, 0x5, 0x2 }, // 23
  { 0x72, 0x10, 0x1, 0x7, 0x2 }, // 24
  { 0x5, 0x10, 0x2, 0x0, 0x5 }, // 25
  { 0x15, 0x10, 0x2, 0x1, 0x5 }, // 26
  { 0x25, 0x10, 0x2, 0x2, 0x5 }, // 27
  { 0x35, 0x10, 0x2, 0x3, 0x5 }, // 28
  { 0x45, 0x10, 0x2, 0x4, 0x5 }, // 29
  { 0x55, 0x10, 0x2, 0x5, 0x5 }, // 30
  { 0x75, 0x10, 0x2, 0x7, 0x5 }, // 31
  { 0xC, 0x10, 0x4, 0x0, 0xC }, // 32
  { 0x1C, 0x10, 0x4, 0x1, 0xC }, // 33
  { 0x2C, 0x10, 0x4, 0x2, 0xC }, // 34
  { 0x3C, 0x10, 0x4, 0x3, 0xC }, // 35
  { 0x4C, 0x10, 0x4, 0x4, 0xC }, // 36
  { 0x5C, 0x10, 0x4, 0x5, 0xC }, // 37
  { 0x7C, 0x10, 0x4, 0x7, 0xC }, // 38
  { 0x44, 0x20, 0x1, 0x4, 0x4 }, // 39
  { 0x54, 0x20, 0x1, 0x5, 0x4 }, // 40
  { 0x74, 0x20, 0x1, 0x7, 0x4 }, // 41
  { 0x4B, 0x20, 0x2, 0x4, 0xB }, // 42
  { 0x5B, 0x20, 0x2, 0x5, 0xB }, // 43
  { 0x7B, 0x20, 0x2, 0x7, 0xB }, // 44
  { 0x4D, 0x20, 0x3, 0x4, 0xD }, // 45
  { 0x5D, 0x20, 0x3, 0x5, 0xD }, // 46
  { 0x7D, 0x20, 0x3, 0x7, 0xD }, // 47
  { 0x4E, 0x20, 0x4, 0x4, 0xE }, // 48
  { 0x5E, 0x20, 0x4, 0x5, 0xE }, // 49
  { 0x7E, 0x20, 0x4, 0x7, 0xE }, // 50
 };

const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat) {
  struct KeyType {
    uint8_t BitsPerComp;
    uint8_t NumComponents;
    uint8_t NumFormat;
  };
  KeyType Key = {BitsPerComp, NumComponents, NumFormat};
  struct Comp {
    bool operator()(const GcnBufferFormatInfo &LHS, const KeyType &RHS) const {
      if (LHS.BitsPerComp < RHS.BitsPerComp)
        return true;
      if (LHS.BitsPerComp > RHS.BitsPerComp)
        return false;
      if (LHS.NumComponents < RHS.NumComponents)
        return true;
      if (LHS.NumComponents > RHS.NumComponents)
        return false;
      if (LHS.NumFormat < RHS.NumFormat)
        return true;
      if (LHS.NumFormat > RHS.NumFormat)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Gfx9BufferFormat);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.BitsPerComp != Idx->BitsPerComp ||
      Key.NumComponents != Idx->NumComponents ||
      Key.NumFormat != Idx->NumFormat)
    return nullptr;

  return &*Idx;
}

const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t Format) {
  struct IndexType {
    uint8_t Format;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 18 },
    { 0x3, 6 },
    { 0x5, 25 },
    { 0xA, 12 },
    { 0xC, 32 },
    { 0x11, 1 },
    { 0x12, 19 },
    { 0x13, 7 },
    { 0x15, 26 },
    { 0x1A, 13 },
    { 0x1C, 33 },
    { 0x21, 2 },
    { 0x22, 20 },
    { 0x23, 8 },
    { 0x25, 27 },
    { 0x2A, 14 },
    { 0x2C, 34 },
    { 0x31, 3 },
    { 0x32, 21 },
    { 0x33, 9 },
    { 0x35, 28 },
    { 0x3A, 15 },
    { 0x3C, 35 },
    { 0x41, 4 },
    { 0x42, 22 },
    { 0x43, 10 },
    { 0x44, 39 },
    { 0x45, 29 },
    { 0x4A, 16 },
    { 0x4B, 42 },
    { 0x4C, 36 },
    { 0x4D, 45 },
    { 0x4E, 48 },
    { 0x51, 5 },
    { 0x52, 23 },
    { 0x53, 11 },
    { 0x54, 40 },
    { 0x55, 30 },
    { 0x5A, 17 },
    { 0x5B, 43 },
    { 0x5C, 37 },
    { 0x5D, 46 },
    { 0x5E, 49 },
    { 0x72, 24 },
    { 0x74, 41 },
    { 0x75, 31 },
    { 0x7B, 44 },
    { 0x7C, 38 },
    { 0x7D, 47 },
    { 0x7E, 50 },
  };

  struct KeyType {
    uint8_t Format;
  };
  KeyType Key = {Format};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      if (LHS.Format < RHS.Format)
        return true;
      if (LHS.Format > RHS.Format)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Format != Idx->Format)
    return nullptr;

  return &Gfx9BufferFormat[Idx->_index];
}
#endif

#ifdef GET_Gfx10BufferFormat_DECL
const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat);
const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t Format);
#endif

#ifdef GET_Gfx10BufferFormat_IMPL
constexpr GcnBufferFormatInfo Gfx10BufferFormat[] = {
  { 0x1, 0x8, 0x1, 0x0, 0x1 }, // 0
  { 0x2, 0x8, 0x1, 0x1, 0x1 }, // 1
  { 0x3, 0x8, 0x1, 0x2, 0x1 }, // 2
  { 0x4, 0x8, 0x1, 0x3, 0x1 }, // 3
  { 0x5, 0x8, 0x1, 0x4, 0x1 }, // 4
  { 0x6, 0x8, 0x1, 0x5, 0x1 }, // 5
  { 0xE, 0x8, 0x2, 0x0, 0x3 }, // 6
  { 0xF, 0x8, 0x2, 0x1, 0x3 }, // 7
  { 0x10, 0x8, 0x2, 0x2, 0x3 }, // 8
  { 0x11, 0x8, 0x2, 0x3, 0x3 }, // 9
  { 0x12, 0x8, 0x2, 0x4, 0x3 }, // 10
  { 0x13, 0x8, 0x2, 0x5, 0x3 }, // 11
  { 0x38, 0x8, 0x4, 0x0, 0xA }, // 12
  { 0x39, 0x8, 0x4, 0x1, 0xA }, // 13
  { 0x3A, 0x8, 0x4, 0x2, 0xA }, // 14
  { 0x3B, 0x8, 0x4, 0x3, 0xA }, // 15
  { 0x3C, 0x8, 0x4, 0x4, 0xA }, // 16
  { 0x3D, 0x8, 0x4, 0x5, 0xA }, // 17
  { 0x7, 0x10, 0x1, 0x0, 0x2 }, // 18
  { 0x8, 0x10, 0x1, 0x1, 0x2 }, // 19
  { 0x9, 0x10, 0x1, 0x2, 0x2 }, // 20
  { 0xA, 0x10, 0x1, 0x3, 0x2 }, // 21
  { 0xB, 0x10, 0x1, 0x4, 0x2 }, // 22
  { 0xC, 0x10, 0x1, 0x5, 0x2 }, // 23
  { 0xD, 0x10, 0x1, 0x7, 0x2 }, // 24
  { 0x17, 0x10, 0x2, 0x0, 0x5 }, // 25
  { 0x18, 0x10, 0x2, 0x1, 0x5 }, // 26
  { 0x19, 0x10, 0x2, 0x2, 0x5 }, // 27
  { 0x1A, 0x10, 0x2, 0x3, 0x5 }, // 28
  { 0x1B, 0x10, 0x2, 0x4, 0x5 }, // 29
  { 0x1C, 0x10, 0x2, 0x5, 0x5 }, // 30
  { 0x1D, 0x10, 0x2, 0x7, 0x5 }, // 31
  { 0x41, 0x10, 0x4, 0x0, 0xC }, // 32
  { 0x42, 0x10, 0x4, 0x1, 0xC }, // 33
  { 0x43, 0x10, 0x4, 0x2, 0xC }, // 34
  { 0x44, 0x10, 0x4, 0x3, 0xC }, // 35
  { 0x45, 0x10, 0x4, 0x4, 0xC }, // 36
  { 0x46, 0x10, 0x4, 0x5, 0xC }, // 37
  { 0x47, 0x10, 0x4, 0x7, 0xC }, // 38
  { 0x14, 0x20, 0x1, 0x4, 0x4 }, // 39
  { 0x15, 0x20, 0x1, 0x5, 0x4 }, // 40
  { 0x16, 0x20, 0x1, 0x7, 0x4 }, // 41
  { 0x3E, 0x20, 0x2, 0x4, 0xB }, // 42
  { 0x3F, 0x20, 0x2, 0x5, 0xB }, // 43
  { 0x40, 0x20, 0x2, 0x7, 0xB }, // 44
  { 0x48, 0x20, 0x3, 0x4, 0xD }, // 45
  { 0x49, 0x20, 0x3, 0x5, 0xD }, // 46
  { 0x4A, 0x20, 0x3, 0x7, 0xD }, // 47
  { 0x4B, 0x20, 0x4, 0x4, 0xE }, // 48
  { 0x4C, 0x20, 0x4, 0x5, 0xE }, // 49
  { 0x4D, 0x20, 0x4, 0x7, 0xE }, // 50
 };

const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat) {
  struct KeyType {
    uint8_t BitsPerComp;
    uint8_t NumComponents;
    uint8_t NumFormat;
  };
  KeyType Key = {BitsPerComp, NumComponents, NumFormat};
  struct Comp {
    bool operator()(const GcnBufferFormatInfo &LHS, const KeyType &RHS) const {
      if (LHS.BitsPerComp < RHS.BitsPerComp)
        return true;
      if (LHS.BitsPerComp > RHS.BitsPerComp)
        return false;
      if (LHS.NumComponents < RHS.NumComponents)
        return true;
      if (LHS.NumComponents > RHS.NumComponents)
        return false;
      if (LHS.NumFormat < RHS.NumFormat)
        return true;
      if (LHS.NumFormat > RHS.NumFormat)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Gfx10BufferFormat);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.BitsPerComp != Idx->BitsPerComp ||
      Key.NumComponents != Idx->NumComponents ||
      Key.NumFormat != Idx->NumFormat)
    return nullptr;

  return &*Idx;
}

const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t Format) {
  struct IndexType {
    uint8_t Format;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 1 },
    { 0x3, 2 },
    { 0x4, 3 },
    { 0x5, 4 },
    { 0x6, 5 },
    { 0x7, 18 },
    { 0x8, 19 },
    { 0x9, 20 },
    { 0xA, 21 },
    { 0xB, 22 },
    { 0xC, 23 },
    { 0xD, 24 },
    { 0xE, 6 },
    { 0xF, 7 },
    { 0x10, 8 },
    { 0x11, 9 },
    { 0x12, 10 },
    { 0x13, 11 },
    { 0x14, 39 },
    { 0x15, 40 },
    { 0x16, 41 },
    { 0x17, 25 },
    { 0x18, 26 },
    { 0x19, 27 },
    { 0x1A, 28 },
    { 0x1B, 29 },
    { 0x1C, 30 },
    { 0x1D, 31 },
    { 0x38, 12 },
    { 0x39, 13 },
    { 0x3A, 14 },
    { 0x3B, 15 },
    { 0x3C, 16 },
    { 0x3D, 17 },
    { 0x3E, 42 },
    { 0x3F, 43 },
    { 0x40, 44 },
    { 0x41, 32 },
    { 0x42, 33 },
    { 0x43, 34 },
    { 0x44, 35 },
    { 0x45, 36 },
    { 0x46, 37 },
    { 0x47, 38 },
    { 0x48, 45 },
    { 0x49, 46 },
    { 0x4A, 47 },
    { 0x4B, 48 },
    { 0x4C, 49 },
    { 0x4D, 50 },
  };

  struct KeyType {
    uint8_t Format;
  };
  KeyType Key = {Format};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      if (LHS.Format < RHS.Format)
        return true;
      if (LHS.Format > RHS.Format)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Format != Idx->Format)
    return nullptr;

  return &Gfx10BufferFormat[Idx->_index];
}
#endif

#ifdef GET_Gfx11PlusBufferFormat_DECL
const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat);
const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t Format);
#endif

#ifdef GET_Gfx11PlusBufferFormat_IMPL
constexpr GcnBufferFormatInfo Gfx11PlusBufferFormat[] = {
  { 0x1, 0x8, 0x1, 0x0, 0x1 }, // 0
  { 0x2, 0x8, 0x1, 0x1, 0x1 }, // 1
  { 0x3, 0x8, 0x1, 0x2, 0x1 }, // 2
  { 0x4, 0x8, 0x1, 0x3, 0x1 }, // 3
  { 0x5, 0x8, 0x1, 0x4, 0x1 }, // 4
  { 0x6, 0x8, 0x1, 0x5, 0x1 }, // 5
  { 0xE, 0x8, 0x2, 0x0, 0x3 }, // 6
  { 0xF, 0x8, 0x2, 0x1, 0x3 }, // 7
  { 0x10, 0x8, 0x2, 0x2, 0x3 }, // 8
  { 0x11, 0x8, 0x2, 0x3, 0x3 }, // 9
  { 0x12, 0x8, 0x2, 0x4, 0x3 }, // 10
  { 0x13, 0x8, 0x2, 0x5, 0x3 }, // 11
  { 0x2A, 0x8, 0x4, 0x0, 0xA }, // 12
  { 0x2B, 0x8, 0x4, 0x1, 0xA }, // 13
  { 0x2C, 0x8, 0x4, 0x2, 0xA }, // 14
  { 0x2D, 0x8, 0x4, 0x3, 0xA }, // 15
  { 0x2E, 0x8, 0x4, 0x4, 0xA }, // 16
  { 0x2F, 0x8, 0x4, 0x5, 0xA }, // 17
  { 0x7, 0x10, 0x1, 0x0, 0x2 }, // 18
  { 0x8, 0x10, 0x1, 0x1, 0x2 }, // 19
  { 0x9, 0x10, 0x1, 0x2, 0x2 }, // 20
  { 0xA, 0x10, 0x1, 0x3, 0x2 }, // 21
  { 0xB, 0x10, 0x1, 0x4, 0x2 }, // 22
  { 0xC, 0x10, 0x1, 0x5, 0x2 }, // 23
  { 0xD, 0x10, 0x1, 0x7, 0x2 }, // 24
  { 0x17, 0x10, 0x2, 0x0, 0x5 }, // 25
  { 0x18, 0x10, 0x2, 0x1, 0x5 }, // 26
  { 0x19, 0x10, 0x2, 0x2, 0x5 }, // 27
  { 0x1A, 0x10, 0x2, 0x3, 0x5 }, // 28
  { 0x1B, 0x10, 0x2, 0x4, 0x5 }, // 29
  { 0x1C, 0x10, 0x2, 0x5, 0x5 }, // 30
  { 0x1D, 0x10, 0x2, 0x7, 0x5 }, // 31
  { 0x33, 0x10, 0x4, 0x0, 0xC }, // 32
  { 0x34, 0x10, 0x4, 0x1, 0xC }, // 33
  { 0x35, 0x10, 0x4, 0x2, 0xC }, // 34
  { 0x36, 0x10, 0x4, 0x3, 0xC }, // 35
  { 0x37, 0x10, 0x4, 0x4, 0xC }, // 36
  { 0x38, 0x10, 0x4, 0x5, 0xC }, // 37
  { 0x39, 0x10, 0x4, 0x7, 0xC }, // 38
  { 0x14, 0x20, 0x1, 0x4, 0x4 }, // 39
  { 0x15, 0x20, 0x1, 0x5, 0x4 }, // 40
  { 0x16, 0x20, 0x1, 0x7, 0x4 }, // 41
  { 0x30, 0x20, 0x2, 0x4, 0xB }, // 42
  { 0x31, 0x20, 0x2, 0x5, 0xB }, // 43
  { 0x32, 0x20, 0x2, 0x7, 0xB }, // 44
  { 0x3A, 0x20, 0x3, 0x4, 0xD }, // 45
  { 0x3B, 0x20, 0x3, 0x5, 0xD }, // 46
  { 0x3C, 0x20, 0x3, 0x7, 0xD }, // 47
  { 0x3D, 0x20, 0x4, 0x4, 0xE }, // 48
  { 0x3E, 0x20, 0x4, 0x5, 0xE }, // 49
  { 0x3F, 0x20, 0x4, 0x7, 0xE }, // 50
 };

const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat) {
  struct KeyType {
    uint8_t BitsPerComp;
    uint8_t NumComponents;
    uint8_t NumFormat;
  };
  KeyType Key = {BitsPerComp, NumComponents, NumFormat};
  struct Comp {
    bool operator()(const GcnBufferFormatInfo &LHS, const KeyType &RHS) const {
      if (LHS.BitsPerComp < RHS.BitsPerComp)
        return true;
      if (LHS.BitsPerComp > RHS.BitsPerComp)
        return false;
      if (LHS.NumComponents < RHS.NumComponents)
        return true;
      if (LHS.NumComponents > RHS.NumComponents)
        return false;
      if (LHS.NumFormat < RHS.NumFormat)
        return true;
      if (LHS.NumFormat > RHS.NumFormat)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Gfx11PlusBufferFormat);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.BitsPerComp != Idx->BitsPerComp ||
      Key.NumComponents != Idx->NumComponents ||
      Key.NumFormat != Idx->NumFormat)
    return nullptr;

  return &*Idx;
}

const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t Format) {
  struct IndexType {
    uint8_t Format;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 1 },
    { 0x3, 2 },
    { 0x4, 3 },
    { 0x5, 4 },
    { 0x6, 5 },
    { 0x7, 18 },
    { 0x8, 19 },
    { 0x9, 20 },
    { 0xA, 21 },
    { 0xB, 22 },
    { 0xC, 23 },
    { 0xD, 24 },
    { 0xE, 6 },
    { 0xF, 7 },
    { 0x10, 8 },
    { 0x11, 9 },
    { 0x12, 10 },
    { 0x13, 11 },
    { 0x14, 39 },
    { 0x15, 40 },
    { 0x16, 41 },
    { 0x17, 25 },
    { 0x18, 26 },
    { 0x19, 27 },
    { 0x1A, 28 },
    { 0x1B, 29 },
    { 0x1C, 30 },
    { 0x1D, 31 },
    { 0x2A, 12 },
    { 0x2B, 13 },
    { 0x2C, 14 },
    { 0x2D, 15 },
    { 0x2E, 16 },
    { 0x2F, 17 },
    { 0x30, 42 },
    { 0x31, 43 },
    { 0x32, 44 },
    { 0x33, 32 },
    { 0x34, 33 },
    { 0x35, 34 },
    { 0x36, 35 },
    { 0x37, 36 },
    { 0x38, 37 },
    { 0x39, 38 },
    { 0x3A, 45 },
    { 0x3B, 46 },
    { 0x3C, 47 },
    { 0x3D, 48 },
    { 0x3E, 49 },
    { 0x3F, 50 },
  };

  struct KeyType {
    uint8_t Format;
  };
  KeyType Key = {Format};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      if (LHS.Format < RHS.Format)
        return true;
      if (LHS.Format > RHS.Format)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Format != Idx->Format)
    return nullptr;

  return &Gfx11PlusBufferFormat[Idx->_index];
}
#endif

#ifdef GET_ImageDimIntrinsicTable_DECL
const ImageDimIntrinsicInfo *getImageDimIntrinsicInfo(unsigned Intr);
const ImageDimIntrinsicInfo *getImageDimIntrinsicByBaseOpcode(unsigned BaseOpcode, unsigned Dim);
#endif

#ifdef GET_ImageDimIntrinsicTable_IMPL
constexpr ImageDimIntrinsicInfo ImageDimIntrinsicTable[] = {
  { Intrinsic::amdgcn_image_atomic_add_1d, IMAGE_ATOMIC_ADD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 0
  { Intrinsic::amdgcn_image_atomic_add_1darray, IMAGE_ATOMIC_ADD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 1
  { Intrinsic::amdgcn_image_atomic_add_2d, IMAGE_ATOMIC_ADD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 2
  { Intrinsic::amdgcn_image_atomic_add_2darray, IMAGE_ATOMIC_ADD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 3
  { Intrinsic::amdgcn_image_atomic_add_2darraymsaa, IMAGE_ATOMIC_ADD, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 4
  { Intrinsic::amdgcn_image_atomic_add_2dmsaa, IMAGE_ATOMIC_ADD, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 5
  { Intrinsic::amdgcn_image_atomic_add_3d, IMAGE_ATOMIC_ADD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 6
  { Intrinsic::amdgcn_image_atomic_add_cube, IMAGE_ATOMIC_ADD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 7
  { Intrinsic::amdgcn_image_atomic_add_flt_1d, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 8
  { Intrinsic::amdgcn_image_atomic_add_flt_1darray, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 9
  { Intrinsic::amdgcn_image_atomic_add_flt_2d, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 10
  { Intrinsic::amdgcn_image_atomic_add_flt_2darray, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 11
  { Intrinsic::amdgcn_image_atomic_add_flt_2darraymsaa, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 12
  { Intrinsic::amdgcn_image_atomic_add_flt_2dmsaa, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 13
  { Intrinsic::amdgcn_image_atomic_add_flt_3d, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 14
  { Intrinsic::amdgcn_image_atomic_add_flt_cube, IMAGE_ATOMIC_ADD_FLT, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 15
  { Intrinsic::amdgcn_image_atomic_and_1d, IMAGE_ATOMIC_AND, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 16
  { Intrinsic::amdgcn_image_atomic_and_1darray, IMAGE_ATOMIC_AND, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 17
  { Intrinsic::amdgcn_image_atomic_and_2d, IMAGE_ATOMIC_AND, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 18
  { Intrinsic::amdgcn_image_atomic_and_2darray, IMAGE_ATOMIC_AND, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 19
  { Intrinsic::amdgcn_image_atomic_and_2darraymsaa, IMAGE_ATOMIC_AND, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 20
  { Intrinsic::amdgcn_image_atomic_and_2dmsaa, IMAGE_ATOMIC_AND, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 21
  { Intrinsic::amdgcn_image_atomic_and_3d, IMAGE_ATOMIC_AND, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 22
  { Intrinsic::amdgcn_image_atomic_and_cube, IMAGE_ATOMIC_AND, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 23
  { Intrinsic::amdgcn_image_atomic_cmpswap_1d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x1, 0x6, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 24
  { Intrinsic::amdgcn_image_atomic_cmpswap_1darray, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x7, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 25
  { Intrinsic::amdgcn_image_atomic_cmpswap_2d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x7, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 26
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darray, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 27
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darraymsaa, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x4, 0x9, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 28
  { Intrinsic::amdgcn_image_atomic_cmpswap_2dmsaa, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 29
  { Intrinsic::amdgcn_image_atomic_cmpswap_3d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 30
  { Intrinsic::amdgcn_image_atomic_cmpswap_cube, IMAGE_ATOMIC_CMPSWAP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 31
  { Intrinsic::amdgcn_image_atomic_dec_1d, IMAGE_ATOMIC_DEC, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 32
  { Intrinsic::amdgcn_image_atomic_dec_1darray, IMAGE_ATOMIC_DEC, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 33
  { Intrinsic::amdgcn_image_atomic_dec_2d, IMAGE_ATOMIC_DEC, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 34
  { Intrinsic::amdgcn_image_atomic_dec_2darray, IMAGE_ATOMIC_DEC, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 35
  { Intrinsic::amdgcn_image_atomic_dec_2darraymsaa, IMAGE_ATOMIC_DEC, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 36
  { Intrinsic::amdgcn_image_atomic_dec_2dmsaa, IMAGE_ATOMIC_DEC, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 37
  { Intrinsic::amdgcn_image_atomic_dec_3d, IMAGE_ATOMIC_DEC, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 38
  { Intrinsic::amdgcn_image_atomic_dec_cube, IMAGE_ATOMIC_DEC, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 39
  { Intrinsic::amdgcn_image_atomic_fmax_1d, IMAGE_ATOMIC_FMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 40
  { Intrinsic::amdgcn_image_atomic_fmax_1darray, IMAGE_ATOMIC_FMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 41
  { Intrinsic::amdgcn_image_atomic_fmax_2d, IMAGE_ATOMIC_FMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 42
  { Intrinsic::amdgcn_image_atomic_fmax_2darray, IMAGE_ATOMIC_FMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 43
  { Intrinsic::amdgcn_image_atomic_fmax_2darraymsaa, IMAGE_ATOMIC_FMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 44
  { Intrinsic::amdgcn_image_atomic_fmax_2dmsaa, IMAGE_ATOMIC_FMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 45
  { Intrinsic::amdgcn_image_atomic_fmax_3d, IMAGE_ATOMIC_FMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 46
  { Intrinsic::amdgcn_image_atomic_fmax_cube, IMAGE_ATOMIC_FMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 47
  { Intrinsic::amdgcn_image_atomic_fmin_1d, IMAGE_ATOMIC_FMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 48
  { Intrinsic::amdgcn_image_atomic_fmin_1darray, IMAGE_ATOMIC_FMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 49
  { Intrinsic::amdgcn_image_atomic_fmin_2d, IMAGE_ATOMIC_FMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 50
  { Intrinsic::amdgcn_image_atomic_fmin_2darray, IMAGE_ATOMIC_FMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 51
  { Intrinsic::amdgcn_image_atomic_fmin_2darraymsaa, IMAGE_ATOMIC_FMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 52
  { Intrinsic::amdgcn_image_atomic_fmin_2dmsaa, IMAGE_ATOMIC_FMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 53
  { Intrinsic::amdgcn_image_atomic_fmin_3d, IMAGE_ATOMIC_FMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 54
  { Intrinsic::amdgcn_image_atomic_fmin_cube, IMAGE_ATOMIC_FMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 55
  { Intrinsic::amdgcn_image_atomic_inc_1d, IMAGE_ATOMIC_INC, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 56
  { Intrinsic::amdgcn_image_atomic_inc_1darray, IMAGE_ATOMIC_INC, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 57
  { Intrinsic::amdgcn_image_atomic_inc_2d, IMAGE_ATOMIC_INC, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 58
  { Intrinsic::amdgcn_image_atomic_inc_2darray, IMAGE_ATOMIC_INC, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 59
  { Intrinsic::amdgcn_image_atomic_inc_2darraymsaa, IMAGE_ATOMIC_INC, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 60
  { Intrinsic::amdgcn_image_atomic_inc_2dmsaa, IMAGE_ATOMIC_INC, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 61
  { Intrinsic::amdgcn_image_atomic_inc_3d, IMAGE_ATOMIC_INC, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 62
  { Intrinsic::amdgcn_image_atomic_inc_cube, IMAGE_ATOMIC_INC, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 63
  { Intrinsic::amdgcn_image_atomic_max_flt_1d, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 64
  { Intrinsic::amdgcn_image_atomic_max_flt_1darray, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 65
  { Intrinsic::amdgcn_image_atomic_max_flt_2d, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 66
  { Intrinsic::amdgcn_image_atomic_max_flt_2darray, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 67
  { Intrinsic::amdgcn_image_atomic_max_flt_2darraymsaa, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 68
  { Intrinsic::amdgcn_image_atomic_max_flt_2dmsaa, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 69
  { Intrinsic::amdgcn_image_atomic_max_flt_3d, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 70
  { Intrinsic::amdgcn_image_atomic_max_flt_cube, IMAGE_ATOMIC_MAX_FLT, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 71
  { Intrinsic::amdgcn_image_atomic_min_flt_1d, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 72
  { Intrinsic::amdgcn_image_atomic_min_flt_1darray, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 73
  { Intrinsic::amdgcn_image_atomic_min_flt_2d, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 74
  { Intrinsic::amdgcn_image_atomic_min_flt_2darray, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 75
  { Intrinsic::amdgcn_image_atomic_min_flt_2darraymsaa, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 76
  { Intrinsic::amdgcn_image_atomic_min_flt_2dmsaa, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 77
  { Intrinsic::amdgcn_image_atomic_min_flt_3d, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 78
  { Intrinsic::amdgcn_image_atomic_min_flt_cube, IMAGE_ATOMIC_MIN_FLT, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 79
  { Intrinsic::amdgcn_image_atomic_or_1d, IMAGE_ATOMIC_OR, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 80
  { Intrinsic::amdgcn_image_atomic_or_1darray, IMAGE_ATOMIC_OR, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 81
  { Intrinsic::amdgcn_image_atomic_or_2d, IMAGE_ATOMIC_OR, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 82
  { Intrinsic::amdgcn_image_atomic_or_2darray, IMAGE_ATOMIC_OR, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 83
  { Intrinsic::amdgcn_image_atomic_or_2darraymsaa, IMAGE_ATOMIC_OR, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 84
  { Intrinsic::amdgcn_image_atomic_or_2dmsaa, IMAGE_ATOMIC_OR, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 85
  { Intrinsic::amdgcn_image_atomic_or_3d, IMAGE_ATOMIC_OR, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 86
  { Intrinsic::amdgcn_image_atomic_or_cube, IMAGE_ATOMIC_OR, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 87
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_1d, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 88
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_1darray, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 89
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_2d, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 90
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_2darray, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 91
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_2darraymsaa, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 92
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_2dmsaa, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 93
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_3d, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 94
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_cube, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 95
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_1d, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 96
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_1darray, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 97
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_2d, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 98
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_2darray, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 99
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_2darraymsaa, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 100
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_2dmsaa, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 101
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_3d, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 102
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_cube, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 103
  { Intrinsic::amdgcn_image_atomic_smax_1d, IMAGE_ATOMIC_SMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 104
  { Intrinsic::amdgcn_image_atomic_smax_1darray, IMAGE_ATOMIC_SMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 105
  { Intrinsic::amdgcn_image_atomic_smax_2d, IMAGE_ATOMIC_SMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 106
  { Intrinsic::amdgcn_image_atomic_smax_2darray, IMAGE_ATOMIC_SMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 107
  { Intrinsic::amdgcn_image_atomic_smax_2darraymsaa, IMAGE_ATOMIC_SMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 108
  { Intrinsic::amdgcn_image_atomic_smax_2dmsaa, IMAGE_ATOMIC_SMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 109
  { Intrinsic::amdgcn_image_atomic_smax_3d, IMAGE_ATOMIC_SMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 110
  { Intrinsic::amdgcn_image_atomic_smax_cube, IMAGE_ATOMIC_SMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 111
  { Intrinsic::amdgcn_image_atomic_smin_1d, IMAGE_ATOMIC_SMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 112
  { Intrinsic::amdgcn_image_atomic_smin_1darray, IMAGE_ATOMIC_SMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 113
  { Intrinsic::amdgcn_image_atomic_smin_2d, IMAGE_ATOMIC_SMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 114
  { Intrinsic::amdgcn_image_atomic_smin_2darray, IMAGE_ATOMIC_SMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 115
  { Intrinsic::amdgcn_image_atomic_smin_2darraymsaa, IMAGE_ATOMIC_SMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 116
  { Intrinsic::amdgcn_image_atomic_smin_2dmsaa, IMAGE_ATOMIC_SMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 117
  { Intrinsic::amdgcn_image_atomic_smin_3d, IMAGE_ATOMIC_SMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 118
  { Intrinsic::amdgcn_image_atomic_smin_cube, IMAGE_ATOMIC_SMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 119
  { Intrinsic::amdgcn_image_atomic_sub_1d, IMAGE_ATOMIC_SUB, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 120
  { Intrinsic::amdgcn_image_atomic_sub_1darray, IMAGE_ATOMIC_SUB, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 121
  { Intrinsic::amdgcn_image_atomic_sub_2d, IMAGE_ATOMIC_SUB, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 122
  { Intrinsic::amdgcn_image_atomic_sub_2darray, IMAGE_ATOMIC_SUB, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 123
  { Intrinsic::amdgcn_image_atomic_sub_2darraymsaa, IMAGE_ATOMIC_SUB, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 124
  { Intrinsic::amdgcn_image_atomic_sub_2dmsaa, IMAGE_ATOMIC_SUB, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 125
  { Intrinsic::amdgcn_image_atomic_sub_3d, IMAGE_ATOMIC_SUB, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 126
  { Intrinsic::amdgcn_image_atomic_sub_cube, IMAGE_ATOMIC_SUB, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 127
  { Intrinsic::amdgcn_image_atomic_swap_1d, IMAGE_ATOMIC_SWAP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 128
  { Intrinsic::amdgcn_image_atomic_swap_1darray, IMAGE_ATOMIC_SWAP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 129
  { Intrinsic::amdgcn_image_atomic_swap_2d, IMAGE_ATOMIC_SWAP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 130
  { Intrinsic::amdgcn_image_atomic_swap_2darray, IMAGE_ATOMIC_SWAP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 131
  { Intrinsic::amdgcn_image_atomic_swap_2darraymsaa, IMAGE_ATOMIC_SWAP, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 132
  { Intrinsic::amdgcn_image_atomic_swap_2dmsaa, IMAGE_ATOMIC_SWAP, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 133
  { Intrinsic::amdgcn_image_atomic_swap_3d, IMAGE_ATOMIC_SWAP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 134
  { Intrinsic::amdgcn_image_atomic_swap_cube, IMAGE_ATOMIC_SWAP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 135
  { Intrinsic::amdgcn_image_atomic_umax_1d, IMAGE_ATOMIC_UMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 136
  { Intrinsic::amdgcn_image_atomic_umax_1darray, IMAGE_ATOMIC_UMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 137
  { Intrinsic::amdgcn_image_atomic_umax_2d, IMAGE_ATOMIC_UMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 138
  { Intrinsic::amdgcn_image_atomic_umax_2darray, IMAGE_ATOMIC_UMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 139
  { Intrinsic::amdgcn_image_atomic_umax_2darraymsaa, IMAGE_ATOMIC_UMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 140
  { Intrinsic::amdgcn_image_atomic_umax_2dmsaa, IMAGE_ATOMIC_UMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 141
  { Intrinsic::amdgcn_image_atomic_umax_3d, IMAGE_ATOMIC_UMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 142
  { Intrinsic::amdgcn_image_atomic_umax_cube, IMAGE_ATOMIC_UMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 143
  { Intrinsic::amdgcn_image_atomic_umin_1d, IMAGE_ATOMIC_UMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 144
  { Intrinsic::amdgcn_image_atomic_umin_1darray, IMAGE_ATOMIC_UMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 145
  { Intrinsic::amdgcn_image_atomic_umin_2d, IMAGE_ATOMIC_UMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 146
  { Intrinsic::amdgcn_image_atomic_umin_2darray, IMAGE_ATOMIC_UMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 147
  { Intrinsic::amdgcn_image_atomic_umin_2darraymsaa, IMAGE_ATOMIC_UMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 148
  { Intrinsic::amdgcn_image_atomic_umin_2dmsaa, IMAGE_ATOMIC_UMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 149
  { Intrinsic::amdgcn_image_atomic_umin_3d, IMAGE_ATOMIC_UMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 150
  { Intrinsic::amdgcn_image_atomic_umin_cube, IMAGE_ATOMIC_UMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 151
  { Intrinsic::amdgcn_image_atomic_xor_1d, IMAGE_ATOMIC_XOR, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 152
  { Intrinsic::amdgcn_image_atomic_xor_1darray, IMAGE_ATOMIC_XOR, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 153
  { Intrinsic::amdgcn_image_atomic_xor_2d, IMAGE_ATOMIC_XOR, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 154
  { Intrinsic::amdgcn_image_atomic_xor_2darray, IMAGE_ATOMIC_XOR, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 155
  { Intrinsic::amdgcn_image_atomic_xor_2darraymsaa, IMAGE_ATOMIC_XOR, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 156
  { Intrinsic::amdgcn_image_atomic_xor_2dmsaa, IMAGE_ATOMIC_XOR, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 157
  { Intrinsic::amdgcn_image_atomic_xor_3d, IMAGE_ATOMIC_XOR, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 158
  { Intrinsic::amdgcn_image_atomic_xor_cube, IMAGE_ATOMIC_XOR, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 159
  { Intrinsic::amdgcn_image_gather4_2d, IMAGE_GATHER4, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 160
  { Intrinsic::amdgcn_image_gather4_2darray, IMAGE_GATHER4, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 161
  { Intrinsic::amdgcn_image_gather4_b_2d, IMAGE_GATHER4_B, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 162
  { Intrinsic::amdgcn_image_gather4_b_2darray, IMAGE_GATHER4_B, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 163
  { Intrinsic::amdgcn_image_gather4_b_cl_2d, IMAGE_GATHER4_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 164
  { Intrinsic::amdgcn_image_gather4_b_cl_2darray, IMAGE_GATHER4_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 165
  { Intrinsic::amdgcn_image_gather4_b_cl_cube, IMAGE_GATHER4_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 166
  { Intrinsic::amdgcn_image_gather4_b_cl_o_2d, IMAGE_GATHER4_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 167
  { Intrinsic::amdgcn_image_gather4_b_cl_o_2darray, IMAGE_GATHER4_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 168
  { Intrinsic::amdgcn_image_gather4_b_cl_o_cube, IMAGE_GATHER4_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 169
  { Intrinsic::amdgcn_image_gather4_b_cube, IMAGE_GATHER4_B, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 170
  { Intrinsic::amdgcn_image_gather4_b_o_2d, IMAGE_GATHER4_B_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 171
  { Intrinsic::amdgcn_image_gather4_b_o_2darray, IMAGE_GATHER4_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 172
  { Intrinsic::amdgcn_image_gather4_b_o_cube, IMAGE_GATHER4_B_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 173
  { Intrinsic::amdgcn_image_gather4_c_2d, IMAGE_GATHER4_C, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 174
  { Intrinsic::amdgcn_image_gather4_c_2darray, IMAGE_GATHER4_C, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 175
  { Intrinsic::amdgcn_image_gather4_c_b_2d, IMAGE_GATHER4_C_B, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 176
  { Intrinsic::amdgcn_image_gather4_c_b_2darray, IMAGE_GATHER4_C_B, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 177
  { Intrinsic::amdgcn_image_gather4_c_b_cl_2d, IMAGE_GATHER4_C_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 178
  { Intrinsic::amdgcn_image_gather4_c_b_cl_2darray, IMAGE_GATHER4_C_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 179
  { Intrinsic::amdgcn_image_gather4_c_b_cl_cube, IMAGE_GATHER4_C_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 180
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_2d, IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 181
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_2darray, IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 182
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_cube, IMAGE_GATHER4_C_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 183
  { Intrinsic::amdgcn_image_gather4_c_b_cube, IMAGE_GATHER4_C_B, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 184
  { Intrinsic::amdgcn_image_gather4_c_b_o_2d, IMAGE_GATHER4_C_B_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 185
  { Intrinsic::amdgcn_image_gather4_c_b_o_2darray, IMAGE_GATHER4_C_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 186
  { Intrinsic::amdgcn_image_gather4_c_b_o_cube, IMAGE_GATHER4_C_B_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 187
  { Intrinsic::amdgcn_image_gather4_c_cl_2d, IMAGE_GATHER4_C_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 188
  { Intrinsic::amdgcn_image_gather4_c_cl_2darray, IMAGE_GATHER4_C_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 189
  { Intrinsic::amdgcn_image_gather4_c_cl_cube, IMAGE_GATHER4_C_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 190
  { Intrinsic::amdgcn_image_gather4_c_cl_o_2d, IMAGE_GATHER4_C_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 191
  { Intrinsic::amdgcn_image_gather4_c_cl_o_2darray, IMAGE_GATHER4_C_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 192
  { Intrinsic::amdgcn_image_gather4_c_cl_o_cube, IMAGE_GATHER4_C_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 193
  { Intrinsic::amdgcn_image_gather4_c_cube, IMAGE_GATHER4_C, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 194
  { Intrinsic::amdgcn_image_gather4_c_l_2d, IMAGE_GATHER4_C_L, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 195
  { Intrinsic::amdgcn_image_gather4_c_l_2darray, IMAGE_GATHER4_C_L, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 196
  { Intrinsic::amdgcn_image_gather4_c_l_cube, IMAGE_GATHER4_C_L, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 197
  { Intrinsic::amdgcn_image_gather4_c_l_o_2d, IMAGE_GATHER4_C_L_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 198
  { Intrinsic::amdgcn_image_gather4_c_l_o_2darray, IMAGE_GATHER4_C_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 199
  { Intrinsic::amdgcn_image_gather4_c_l_o_cube, IMAGE_GATHER4_C_L_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 200
  { Intrinsic::amdgcn_image_gather4_c_lz_2d, IMAGE_GATHER4_C_LZ, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 201
  { Intrinsic::amdgcn_image_gather4_c_lz_2darray, IMAGE_GATHER4_C_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 202
  { Intrinsic::amdgcn_image_gather4_c_lz_cube, IMAGE_GATHER4_C_LZ, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 203
  { Intrinsic::amdgcn_image_gather4_c_lz_o_2d, IMAGE_GATHER4_C_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 204
  { Intrinsic::amdgcn_image_gather4_c_lz_o_2darray, IMAGE_GATHER4_C_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 205
  { Intrinsic::amdgcn_image_gather4_c_lz_o_cube, IMAGE_GATHER4_C_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 206
  { Intrinsic::amdgcn_image_gather4_c_o_2d, IMAGE_GATHER4_C_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 207
  { Intrinsic::amdgcn_image_gather4_c_o_2darray, IMAGE_GATHER4_C_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 208
  { Intrinsic::amdgcn_image_gather4_c_o_cube, IMAGE_GATHER4_C_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 209
  { Intrinsic::amdgcn_image_gather4_cl_2d, IMAGE_GATHER4_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 210
  { Intrinsic::amdgcn_image_gather4_cl_2darray, IMAGE_GATHER4_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 211
  { Intrinsic::amdgcn_image_gather4_cl_cube, IMAGE_GATHER4_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 212
  { Intrinsic::amdgcn_image_gather4_cl_o_2d, IMAGE_GATHER4_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 213
  { Intrinsic::amdgcn_image_gather4_cl_o_2darray, IMAGE_GATHER4_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 214
  { Intrinsic::amdgcn_image_gather4_cl_o_cube, IMAGE_GATHER4_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 215
  { Intrinsic::amdgcn_image_gather4_cube, IMAGE_GATHER4, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 216
  { Intrinsic::amdgcn_image_gather4_l_2d, IMAGE_GATHER4_L, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 217
  { Intrinsic::amdgcn_image_gather4_l_2darray, IMAGE_GATHER4_L, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 218
  { Intrinsic::amdgcn_image_gather4_l_cube, IMAGE_GATHER4_L, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 219
  { Intrinsic::amdgcn_image_gather4_l_o_2d, IMAGE_GATHER4_L_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 220
  { Intrinsic::amdgcn_image_gather4_l_o_2darray, IMAGE_GATHER4_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 221
  { Intrinsic::amdgcn_image_gather4_l_o_cube, IMAGE_GATHER4_L_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 222
  { Intrinsic::amdgcn_image_gather4_lz_2d, IMAGE_GATHER4_LZ, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 223
  { Intrinsic::amdgcn_image_gather4_lz_2darray, IMAGE_GATHER4_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 224
  { Intrinsic::amdgcn_image_gather4_lz_cube, IMAGE_GATHER4_LZ, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 225
  { Intrinsic::amdgcn_image_gather4_lz_o_2d, IMAGE_GATHER4_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 226
  { Intrinsic::amdgcn_image_gather4_lz_o_2darray, IMAGE_GATHER4_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 227
  { Intrinsic::amdgcn_image_gather4_lz_o_cube, IMAGE_GATHER4_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 228
  { Intrinsic::amdgcn_image_gather4_o_2d, IMAGE_GATHER4_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 229
  { Intrinsic::amdgcn_image_gather4_o_2darray, IMAGE_GATHER4_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 230
  { Intrinsic::amdgcn_image_gather4_o_cube, IMAGE_GATHER4_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 231
  { Intrinsic::amdgcn_image_getlod_1d, IMAGE_GET_LOD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 232
  { Intrinsic::amdgcn_image_getlod_1darray, IMAGE_GET_LOD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 233
  { Intrinsic::amdgcn_image_getlod_2d, IMAGE_GET_LOD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 234
  { Intrinsic::amdgcn_image_getlod_2darray, IMAGE_GET_LOD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 235
  { Intrinsic::amdgcn_image_getlod_3d, IMAGE_GET_LOD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 236
  { Intrinsic::amdgcn_image_getlod_cube, IMAGE_GET_LOD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 237
  { Intrinsic::amdgcn_image_getresinfo_1d, IMAGE_GET_RESINFO, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 238
  { Intrinsic::amdgcn_image_getresinfo_1darray, IMAGE_GET_RESINFO, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 239
  { Intrinsic::amdgcn_image_getresinfo_2d, IMAGE_GET_RESINFO, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 240
  { Intrinsic::amdgcn_image_getresinfo_2darray, IMAGE_GET_RESINFO, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 241
  { Intrinsic::amdgcn_image_getresinfo_2darraymsaa, IMAGE_GET_RESINFO, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 242
  { Intrinsic::amdgcn_image_getresinfo_2dmsaa, IMAGE_GET_RESINFO, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 243
  { Intrinsic::amdgcn_image_getresinfo_3d, IMAGE_GET_RESINFO, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 244
  { Intrinsic::amdgcn_image_getresinfo_cube, IMAGE_GET_RESINFO, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 245
  { Intrinsic::amdgcn_image_load_1d, IMAGE_LOAD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 246
  { Intrinsic::amdgcn_image_load_1darray, IMAGE_LOAD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 247
  { Intrinsic::amdgcn_image_load_2d, IMAGE_LOAD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 248
  { Intrinsic::amdgcn_image_load_2darray, IMAGE_LOAD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 249
  { Intrinsic::amdgcn_image_load_2darraymsaa, IMAGE_LOAD, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 250
  { Intrinsic::amdgcn_image_load_2dmsaa, IMAGE_LOAD, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 251
  { Intrinsic::amdgcn_image_load_3d, IMAGE_LOAD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 252
  { Intrinsic::amdgcn_image_load_cube, IMAGE_LOAD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 253
  { Intrinsic::amdgcn_image_load_mip_1d, IMAGE_LOAD_MIP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 254
  { Intrinsic::amdgcn_image_load_mip_1darray, IMAGE_LOAD_MIP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 255
  { Intrinsic::amdgcn_image_load_mip_2d, IMAGE_LOAD_MIP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 256
  { Intrinsic::amdgcn_image_load_mip_2darray, IMAGE_LOAD_MIP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 257
  { Intrinsic::amdgcn_image_load_mip_3d, IMAGE_LOAD_MIP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 258
  { Intrinsic::amdgcn_image_load_mip_cube, IMAGE_LOAD_MIP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 259
  { Intrinsic::amdgcn_image_msaa_load_2darraymsaa, IMAGE_MSAA_LOAD, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 260
  { Intrinsic::amdgcn_image_msaa_load_2dmsaa, IMAGE_MSAA_LOAD, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 261
  { Intrinsic::amdgcn_image_msaa_load_x_2darraymsaa, IMAGE_MSAA_LOAD_X, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 262
  { Intrinsic::amdgcn_image_msaa_load_x_2dmsaa, IMAGE_MSAA_LOAD_X, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 263
  { Intrinsic::amdgcn_image_sample_1d, IMAGE_SAMPLE, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 264
  { Intrinsic::amdgcn_image_sample_1d_nortn, IMAGE_SAMPLE_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x0, 0x0, 0x0 }, // 265
  { Intrinsic::amdgcn_image_sample_1darray, IMAGE_SAMPLE, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 266
  { Intrinsic::amdgcn_image_sample_1darray_nortn, IMAGE_SAMPLE_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 267
  { Intrinsic::amdgcn_image_sample_2d, IMAGE_SAMPLE, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 268
  { Intrinsic::amdgcn_image_sample_2d_nortn, IMAGE_SAMPLE_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 269
  { Intrinsic::amdgcn_image_sample_2darray, IMAGE_SAMPLE, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 270
  { Intrinsic::amdgcn_image_sample_2darray_nortn, IMAGE_SAMPLE_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 271
  { Intrinsic::amdgcn_image_sample_3d, IMAGE_SAMPLE, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 272
  { Intrinsic::amdgcn_image_sample_3d_nortn, IMAGE_SAMPLE_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 273
  { Intrinsic::amdgcn_image_sample_b_1d, IMAGE_SAMPLE_B, AMDGPUDim1D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x2, 0x2 }, // 274
  { Intrinsic::amdgcn_image_sample_b_1d_nortn, IMAGE_SAMPLE_B_nortn, AMDGPUDim1D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x1, 0x1 }, // 275
  { Intrinsic::amdgcn_image_sample_b_1darray, IMAGE_SAMPLE_B, AMDGPUDim1DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 276
  { Intrinsic::amdgcn_image_sample_b_1darray_nortn, IMAGE_SAMPLE_B_nortn, AMDGPUDim1DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x1, 0x1 }, // 277
  { Intrinsic::amdgcn_image_sample_b_2d, IMAGE_SAMPLE_B, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 278
  { Intrinsic::amdgcn_image_sample_b_2d_nortn, IMAGE_SAMPLE_B_nortn, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x1, 0x1 }, // 279
  { Intrinsic::amdgcn_image_sample_b_2darray, IMAGE_SAMPLE_B, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 280
  { Intrinsic::amdgcn_image_sample_b_2darray_nortn, IMAGE_SAMPLE_B_nortn, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 281
  { Intrinsic::amdgcn_image_sample_b_3d, IMAGE_SAMPLE_B, AMDGPUDim3D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 282
  { Intrinsic::amdgcn_image_sample_b_3d_nortn, IMAGE_SAMPLE_B_nortn, AMDGPUDim3D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 283
  { Intrinsic::amdgcn_image_sample_b_cl_1d, IMAGE_SAMPLE_B_CL, AMDGPUDim1D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 284
  { Intrinsic::amdgcn_image_sample_b_cl_1d_nortn, IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim1D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x1, 0x1 }, // 285
  { Intrinsic::amdgcn_image_sample_b_cl_1darray, IMAGE_SAMPLE_B_CL, AMDGPUDim1DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 286
  { Intrinsic::amdgcn_image_sample_b_cl_1darray_nortn, IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim1DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 287
  { Intrinsic::amdgcn_image_sample_b_cl_2d, IMAGE_SAMPLE_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 288
  { Intrinsic::amdgcn_image_sample_b_cl_2d_nortn, IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 289
  { Intrinsic::amdgcn_image_sample_b_cl_2darray, IMAGE_SAMPLE_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 290
  { Intrinsic::amdgcn_image_sample_b_cl_2darray_nortn, IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 291
  { Intrinsic::amdgcn_image_sample_b_cl_3d, IMAGE_SAMPLE_B_CL, AMDGPUDim3D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 292
  { Intrinsic::amdgcn_image_sample_b_cl_3d_nortn, IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim3D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 293
  { Intrinsic::amdgcn_image_sample_b_cl_cube, IMAGE_SAMPLE_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 294
  { Intrinsic::amdgcn_image_sample_b_cl_cube_nortn, IMAGE_SAMPLE_B_CL_nortn, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 295
  { Intrinsic::amdgcn_image_sample_b_cl_o_1d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim1D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 296
  { Intrinsic::amdgcn_image_sample_b_cl_o_1d_nortn, IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim1D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 297
  { Intrinsic::amdgcn_image_sample_b_cl_o_1darray, IMAGE_SAMPLE_B_CL_O, AMDGPUDim1DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 298
  { Intrinsic::amdgcn_image_sample_b_cl_o_1darray_nortn, IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 299
  { Intrinsic::amdgcn_image_sample_b_cl_o_2d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 300
  { Intrinsic::amdgcn_image_sample_b_cl_o_2d_nortn, IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 301
  { Intrinsic::amdgcn_image_sample_b_cl_o_2darray, IMAGE_SAMPLE_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 302
  { Intrinsic::amdgcn_image_sample_b_cl_o_2darray_nortn, IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 303
  { Intrinsic::amdgcn_image_sample_b_cl_o_3d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim3D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 304
  { Intrinsic::amdgcn_image_sample_b_cl_o_3d_nortn, IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim3D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 305
  { Intrinsic::amdgcn_image_sample_b_cl_o_cube, IMAGE_SAMPLE_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 306
  { Intrinsic::amdgcn_image_sample_b_cl_o_cube_nortn, IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 307
  { Intrinsic::amdgcn_image_sample_b_cube, IMAGE_SAMPLE_B, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 308
  { Intrinsic::amdgcn_image_sample_b_cube_nortn, IMAGE_SAMPLE_B_nortn, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 309
  { Intrinsic::amdgcn_image_sample_b_o_1d, IMAGE_SAMPLE_B_O, AMDGPUDim1D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 310
  { Intrinsic::amdgcn_image_sample_b_o_1d_nortn, IMAGE_SAMPLE_B_O_nortn, AMDGPUDim1D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x1, 0x1 }, // 311
  { Intrinsic::amdgcn_image_sample_b_o_1darray, IMAGE_SAMPLE_B_O, AMDGPUDim1DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 312
  { Intrinsic::amdgcn_image_sample_b_o_1darray_nortn, IMAGE_SAMPLE_B_O_nortn, AMDGPUDim1DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 313
  { Intrinsic::amdgcn_image_sample_b_o_2d, IMAGE_SAMPLE_B_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 314
  { Intrinsic::amdgcn_image_sample_b_o_2d_nortn, IMAGE_SAMPLE_B_O_nortn, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 315
  { Intrinsic::amdgcn_image_sample_b_o_2darray, IMAGE_SAMPLE_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 316
  { Intrinsic::amdgcn_image_sample_b_o_2darray_nortn, IMAGE_SAMPLE_B_O_nortn, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 317
  { Intrinsic::amdgcn_image_sample_b_o_3d, IMAGE_SAMPLE_B_O, AMDGPUDim3D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 318
  { Intrinsic::amdgcn_image_sample_b_o_3d_nortn, IMAGE_SAMPLE_B_O_nortn, AMDGPUDim3D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 319
  { Intrinsic::amdgcn_image_sample_b_o_cube, IMAGE_SAMPLE_B_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 320
  { Intrinsic::amdgcn_image_sample_b_o_cube_nortn, IMAGE_SAMPLE_B_O_nortn, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 321
  { Intrinsic::amdgcn_image_sample_c_1d, IMAGE_SAMPLE_C, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 322
  { Intrinsic::amdgcn_image_sample_c_1d_nortn, IMAGE_SAMPLE_C_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 323
  { Intrinsic::amdgcn_image_sample_c_1darray, IMAGE_SAMPLE_C, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 324
  { Intrinsic::amdgcn_image_sample_c_1darray_nortn, IMAGE_SAMPLE_C_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 325
  { Intrinsic::amdgcn_image_sample_c_2d, IMAGE_SAMPLE_C, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 326
  { Intrinsic::amdgcn_image_sample_c_2d_nortn, IMAGE_SAMPLE_C_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 327
  { Intrinsic::amdgcn_image_sample_c_2darray, IMAGE_SAMPLE_C, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 328
  { Intrinsic::amdgcn_image_sample_c_2darray_nortn, IMAGE_SAMPLE_C_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 329
  { Intrinsic::amdgcn_image_sample_c_3d, IMAGE_SAMPLE_C, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 330
  { Intrinsic::amdgcn_image_sample_c_3d_nortn, IMAGE_SAMPLE_C_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 331
  { Intrinsic::amdgcn_image_sample_c_b_1d, IMAGE_SAMPLE_C_B, AMDGPUDim1D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 332
  { Intrinsic::amdgcn_image_sample_c_b_1d_nortn, IMAGE_SAMPLE_C_B_nortn, AMDGPUDim1D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x1, 0x1 }, // 333
  { Intrinsic::amdgcn_image_sample_c_b_1darray, IMAGE_SAMPLE_C_B, AMDGPUDim1DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 334
  { Intrinsic::amdgcn_image_sample_c_b_1darray_nortn, IMAGE_SAMPLE_C_B_nortn, AMDGPUDim1DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 335
  { Intrinsic::amdgcn_image_sample_c_b_2d, IMAGE_SAMPLE_C_B, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 336
  { Intrinsic::amdgcn_image_sample_c_b_2d_nortn, IMAGE_SAMPLE_C_B_nortn, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 337
  { Intrinsic::amdgcn_image_sample_c_b_2darray, IMAGE_SAMPLE_C_B, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 338
  { Intrinsic::amdgcn_image_sample_c_b_2darray_nortn, IMAGE_SAMPLE_C_B_nortn, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 339
  { Intrinsic::amdgcn_image_sample_c_b_3d, IMAGE_SAMPLE_C_B, AMDGPUDim3D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 340
  { Intrinsic::amdgcn_image_sample_c_b_3d_nortn, IMAGE_SAMPLE_C_B_nortn, AMDGPUDim3D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 341
  { Intrinsic::amdgcn_image_sample_c_b_cl_1d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim1D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 342
  { Intrinsic::amdgcn_image_sample_c_b_cl_1d_nortn, IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim1D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 343
  { Intrinsic::amdgcn_image_sample_c_b_cl_1darray, IMAGE_SAMPLE_C_B_CL, AMDGPUDim1DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 344
  { Intrinsic::amdgcn_image_sample_c_b_cl_1darray_nortn, IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim1DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 345
  { Intrinsic::amdgcn_image_sample_c_b_cl_2d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 346
  { Intrinsic::amdgcn_image_sample_c_b_cl_2d_nortn, IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 347
  { Intrinsic::amdgcn_image_sample_c_b_cl_2darray, IMAGE_SAMPLE_C_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 348
  { Intrinsic::amdgcn_image_sample_c_b_cl_2darray_nortn, IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 349
  { Intrinsic::amdgcn_image_sample_c_b_cl_3d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim3D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 350
  { Intrinsic::amdgcn_image_sample_c_b_cl_3d_nortn, IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim3D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 351
  { Intrinsic::amdgcn_image_sample_c_b_cl_cube, IMAGE_SAMPLE_C_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 352
  { Intrinsic::amdgcn_image_sample_c_b_cl_cube_nortn, IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 353
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 354
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1d_nortn, IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim1D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 355
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1darray, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 356
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1darray_nortn, IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 357
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 358
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2d_nortn, IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 359
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2darray, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 360
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2darray_nortn, IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x1, 0x1 }, // 361
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_3d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim3D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 362
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_3d_nortn, IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim3D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x1, 0x1 }, // 363
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_cube, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 364
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_cube_nortn, IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x1, 0x1 }, // 365
  { Intrinsic::amdgcn_image_sample_c_b_cube, IMAGE_SAMPLE_C_B, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 366
  { Intrinsic::amdgcn_image_sample_c_b_cube_nortn, IMAGE_SAMPLE_C_B_nortn, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 367
  { Intrinsic::amdgcn_image_sample_c_b_o_1d, IMAGE_SAMPLE_C_B_O, AMDGPUDim1D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 368
  { Intrinsic::amdgcn_image_sample_c_b_o_1d_nortn, IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim1D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 369
  { Intrinsic::amdgcn_image_sample_c_b_o_1darray, IMAGE_SAMPLE_C_B_O, AMDGPUDim1DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 370
  { Intrinsic::amdgcn_image_sample_c_b_o_1darray_nortn, IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim1DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 371
  { Intrinsic::amdgcn_image_sample_c_b_o_2d, IMAGE_SAMPLE_C_B_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 372
  { Intrinsic::amdgcn_image_sample_c_b_o_2d_nortn, IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 373
  { Intrinsic::amdgcn_image_sample_c_b_o_2darray, IMAGE_SAMPLE_C_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 374
  { Intrinsic::amdgcn_image_sample_c_b_o_2darray_nortn, IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 375
  { Intrinsic::amdgcn_image_sample_c_b_o_3d, IMAGE_SAMPLE_C_B_O, AMDGPUDim3D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 376
  { Intrinsic::amdgcn_image_sample_c_b_o_3d_nortn, IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim3D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 377
  { Intrinsic::amdgcn_image_sample_c_b_o_cube, IMAGE_SAMPLE_C_B_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 378
  { Intrinsic::amdgcn_image_sample_c_b_o_cube_nortn, IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 379
  { Intrinsic::amdgcn_image_sample_c_cd_1d, IMAGE_SAMPLE_C_CD, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 380
  { Intrinsic::amdgcn_image_sample_c_cd_1d_nortn, IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 381
  { Intrinsic::amdgcn_image_sample_c_cd_1darray, IMAGE_SAMPLE_C_CD, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 382
  { Intrinsic::amdgcn_image_sample_c_cd_1darray_nortn, IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 383
  { Intrinsic::amdgcn_image_sample_c_cd_2d, IMAGE_SAMPLE_C_CD, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 384
  { Intrinsic::amdgcn_image_sample_c_cd_2d_nortn, IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 385
  { Intrinsic::amdgcn_image_sample_c_cd_2darray, IMAGE_SAMPLE_C_CD, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 386
  { Intrinsic::amdgcn_image_sample_c_cd_2darray_nortn, IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 387
  { Intrinsic::amdgcn_image_sample_c_cd_3d, IMAGE_SAMPLE_C_CD, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 388
  { Intrinsic::amdgcn_image_sample_c_cd_3d_nortn, IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 389
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 390
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1d_nortn, IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 391
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1darray, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 392
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1darray_nortn, IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 393
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 394
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2d_nortn, IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 395
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2darray, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 396
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2darray_nortn, IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 397
  { Intrinsic::amdgcn_image_sample_c_cd_cl_3d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 398
  { Intrinsic::amdgcn_image_sample_c_cd_cl_3d_nortn, IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x0, 0x0, 0x1 }, // 399
  { Intrinsic::amdgcn_image_sample_c_cd_cl_cube, IMAGE_SAMPLE_C_CD_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 400
  { Intrinsic::amdgcn_image_sample_c_cd_cl_cube_nortn, IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 401
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 402
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1d_nortn, IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 403
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1darray, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 404
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1darray_nortn, IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 405
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 406
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2d_nortn, IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 407
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2darray, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 408
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2darray_nortn, IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 409
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_3d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xC, 0x12, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xC, 0xC, 0xD, 0xD, 0xE, 0xF, 0x10, 0x11, 0x1, 0x1, 0x2 }, // 410
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_3d_nortn, IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xC, 0x12, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xC, 0xC, 0xD, 0xD, 0xE, 0xF, 0x10, 0x11, 0x0, 0x0, 0x1 }, // 411
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_cube, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 412
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_cube_nortn, IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 413
  { Intrinsic::amdgcn_image_sample_c_cd_cube, IMAGE_SAMPLE_C_CD, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 414
  { Intrinsic::amdgcn_image_sample_c_cd_cube_nortn, IMAGE_SAMPLE_C_CD_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 415
  { Intrinsic::amdgcn_image_sample_c_cd_o_1d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 416
  { Intrinsic::amdgcn_image_sample_c_cd_o_1d_nortn, IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 417
  { Intrinsic::amdgcn_image_sample_c_cd_o_1darray, IMAGE_SAMPLE_C_CD_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 418
  { Intrinsic::amdgcn_image_sample_c_cd_o_1darray_nortn, IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 419
  { Intrinsic::amdgcn_image_sample_c_cd_o_2d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 420
  { Intrinsic::amdgcn_image_sample_c_cd_o_2d_nortn, IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 421
  { Intrinsic::amdgcn_image_sample_c_cd_o_2darray, IMAGE_SAMPLE_C_CD_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 422
  { Intrinsic::amdgcn_image_sample_c_cd_o_2darray_nortn, IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 423
  { Intrinsic::amdgcn_image_sample_c_cd_o_3d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 424
  { Intrinsic::amdgcn_image_sample_c_cd_o_3d_nortn, IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x0, 0x0, 0x1 }, // 425
  { Intrinsic::amdgcn_image_sample_c_cd_o_cube, IMAGE_SAMPLE_C_CD_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 426
  { Intrinsic::amdgcn_image_sample_c_cd_o_cube_nortn, IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 427
  { Intrinsic::amdgcn_image_sample_c_cl_1d, IMAGE_SAMPLE_C_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 428
  { Intrinsic::amdgcn_image_sample_c_cl_1d_nortn, IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 429
  { Intrinsic::amdgcn_image_sample_c_cl_1darray, IMAGE_SAMPLE_C_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 430
  { Intrinsic::amdgcn_image_sample_c_cl_1darray_nortn, IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 431
  { Intrinsic::amdgcn_image_sample_c_cl_2d, IMAGE_SAMPLE_C_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 432
  { Intrinsic::amdgcn_image_sample_c_cl_2d_nortn, IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 433
  { Intrinsic::amdgcn_image_sample_c_cl_2darray, IMAGE_SAMPLE_C_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 434
  { Intrinsic::amdgcn_image_sample_c_cl_2darray_nortn, IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 435
  { Intrinsic::amdgcn_image_sample_c_cl_3d, IMAGE_SAMPLE_C_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 436
  { Intrinsic::amdgcn_image_sample_c_cl_3d_nortn, IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 437
  { Intrinsic::amdgcn_image_sample_c_cl_cube, IMAGE_SAMPLE_C_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 438
  { Intrinsic::amdgcn_image_sample_c_cl_cube_nortn, IMAGE_SAMPLE_C_CL_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 439
  { Intrinsic::amdgcn_image_sample_c_cl_o_1d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 440
  { Intrinsic::amdgcn_image_sample_c_cl_o_1d_nortn, IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 441
  { Intrinsic::amdgcn_image_sample_c_cl_o_1darray, IMAGE_SAMPLE_C_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 442
  { Intrinsic::amdgcn_image_sample_c_cl_o_1darray_nortn, IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 443
  { Intrinsic::amdgcn_image_sample_c_cl_o_2d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 444
  { Intrinsic::amdgcn_image_sample_c_cl_o_2d_nortn, IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 445
  { Intrinsic::amdgcn_image_sample_c_cl_o_2darray, IMAGE_SAMPLE_C_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 446
  { Intrinsic::amdgcn_image_sample_c_cl_o_2darray_nortn, IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x0 }, // 447
  { Intrinsic::amdgcn_image_sample_c_cl_o_3d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 448
  { Intrinsic::amdgcn_image_sample_c_cl_o_3d_nortn, IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x0 }, // 449
  { Intrinsic::amdgcn_image_sample_c_cl_o_cube, IMAGE_SAMPLE_C_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 450
  { Intrinsic::amdgcn_image_sample_c_cl_o_cube_nortn, IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x0 }, // 451
  { Intrinsic::amdgcn_image_sample_c_cube, IMAGE_SAMPLE_C, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 452
  { Intrinsic::amdgcn_image_sample_c_cube_nortn, IMAGE_SAMPLE_C_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 453
  { Intrinsic::amdgcn_image_sample_c_d_1d, IMAGE_SAMPLE_C_D, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 454
  { Intrinsic::amdgcn_image_sample_c_d_1d_nortn, IMAGE_SAMPLE_C_D_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 455
  { Intrinsic::amdgcn_image_sample_c_d_1darray, IMAGE_SAMPLE_C_D, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 456
  { Intrinsic::amdgcn_image_sample_c_d_1darray_nortn, IMAGE_SAMPLE_C_D_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 457
  { Intrinsic::amdgcn_image_sample_c_d_2d, IMAGE_SAMPLE_C_D, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 458
  { Intrinsic::amdgcn_image_sample_c_d_2d_nortn, IMAGE_SAMPLE_C_D_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 459
  { Intrinsic::amdgcn_image_sample_c_d_2darray, IMAGE_SAMPLE_C_D, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 460
  { Intrinsic::amdgcn_image_sample_c_d_2darray_nortn, IMAGE_SAMPLE_C_D_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 461
  { Intrinsic::amdgcn_image_sample_c_d_3d, IMAGE_SAMPLE_C_D, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 462
  { Intrinsic::amdgcn_image_sample_c_d_3d_nortn, IMAGE_SAMPLE_C_D_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 463
  { Intrinsic::amdgcn_image_sample_c_d_cl_1d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 464
  { Intrinsic::amdgcn_image_sample_c_d_cl_1d_nortn, IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 465
  { Intrinsic::amdgcn_image_sample_c_d_cl_1darray, IMAGE_SAMPLE_C_D_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 466
  { Intrinsic::amdgcn_image_sample_c_d_cl_1darray_nortn, IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 467
  { Intrinsic::amdgcn_image_sample_c_d_cl_2d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 468
  { Intrinsic::amdgcn_image_sample_c_d_cl_2d_nortn, IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 469
  { Intrinsic::amdgcn_image_sample_c_d_cl_2darray, IMAGE_SAMPLE_C_D_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 470
  { Intrinsic::amdgcn_image_sample_c_d_cl_2darray_nortn, IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 471
  { Intrinsic::amdgcn_image_sample_c_d_cl_3d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 472
  { Intrinsic::amdgcn_image_sample_c_d_cl_3d_nortn, IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x0, 0x0, 0x1 }, // 473
  { Intrinsic::amdgcn_image_sample_c_d_cl_cube, IMAGE_SAMPLE_C_D_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 474
  { Intrinsic::amdgcn_image_sample_c_d_cl_cube_nortn, IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 475
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 476
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1d_nortn, IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 477
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1darray, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 478
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1darray_nortn, IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 479
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 480
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2d_nortn, IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 481
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2darray, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 482
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2darray_nortn, IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 483
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_3d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xC, 0x12, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xC, 0xC, 0xD, 0xD, 0xE, 0xF, 0x10, 0x11, 0x1, 0x1, 0x2 }, // 484
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_3d_nortn, IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xC, 0x12, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xC, 0xC, 0xD, 0xD, 0xE, 0xF, 0x10, 0x11, 0x0, 0x0, 0x1 }, // 485
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_cube, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 486
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_cube_nortn, IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 487
  { Intrinsic::amdgcn_image_sample_c_d_cube, IMAGE_SAMPLE_C_D, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 488
  { Intrinsic::amdgcn_image_sample_c_d_cube_nortn, IMAGE_SAMPLE_C_D_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 489
  { Intrinsic::amdgcn_image_sample_c_d_o_1d, IMAGE_SAMPLE_C_D_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 490
  { Intrinsic::amdgcn_image_sample_c_d_o_1d_nortn, IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 491
  { Intrinsic::amdgcn_image_sample_c_d_o_1darray, IMAGE_SAMPLE_C_D_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 492
  { Intrinsic::amdgcn_image_sample_c_d_o_1darray_nortn, IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 493
  { Intrinsic::amdgcn_image_sample_c_d_o_2d, IMAGE_SAMPLE_C_D_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 494
  { Intrinsic::amdgcn_image_sample_c_d_o_2d_nortn, IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 495
  { Intrinsic::amdgcn_image_sample_c_d_o_2darray, IMAGE_SAMPLE_C_D_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 496
  { Intrinsic::amdgcn_image_sample_c_d_o_2darray_nortn, IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 497
  { Intrinsic::amdgcn_image_sample_c_d_o_3d, IMAGE_SAMPLE_C_D_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 498
  { Intrinsic::amdgcn_image_sample_c_d_o_3d_nortn, IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x0, 0x0, 0x1 }, // 499
  { Intrinsic::amdgcn_image_sample_c_d_o_cube, IMAGE_SAMPLE_C_D_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 500
  { Intrinsic::amdgcn_image_sample_c_d_o_cube_nortn, IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 501
  { Intrinsic::amdgcn_image_sample_c_l_1d, IMAGE_SAMPLE_C_L, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 502
  { Intrinsic::amdgcn_image_sample_c_l_1d_nortn, IMAGE_SAMPLE_C_L_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 503
  { Intrinsic::amdgcn_image_sample_c_l_1darray, IMAGE_SAMPLE_C_L, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 504
  { Intrinsic::amdgcn_image_sample_c_l_1darray_nortn, IMAGE_SAMPLE_C_L_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 505
  { Intrinsic::amdgcn_image_sample_c_l_2d, IMAGE_SAMPLE_C_L, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 506
  { Intrinsic::amdgcn_image_sample_c_l_2d_nortn, IMAGE_SAMPLE_C_L_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 507
  { Intrinsic::amdgcn_image_sample_c_l_2darray, IMAGE_SAMPLE_C_L, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 508
  { Intrinsic::amdgcn_image_sample_c_l_2darray_nortn, IMAGE_SAMPLE_C_L_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 509
  { Intrinsic::amdgcn_image_sample_c_l_3d, IMAGE_SAMPLE_C_L, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 510
  { Intrinsic::amdgcn_image_sample_c_l_3d_nortn, IMAGE_SAMPLE_C_L_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 511
  { Intrinsic::amdgcn_image_sample_c_l_cube, IMAGE_SAMPLE_C_L, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 512
  { Intrinsic::amdgcn_image_sample_c_l_cube_nortn, IMAGE_SAMPLE_C_L_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 513
  { Intrinsic::amdgcn_image_sample_c_l_o_1d, IMAGE_SAMPLE_C_L_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 514
  { Intrinsic::amdgcn_image_sample_c_l_o_1d_nortn, IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 515
  { Intrinsic::amdgcn_image_sample_c_l_o_1darray, IMAGE_SAMPLE_C_L_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 516
  { Intrinsic::amdgcn_image_sample_c_l_o_1darray_nortn, IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 517
  { Intrinsic::amdgcn_image_sample_c_l_o_2d, IMAGE_SAMPLE_C_L_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 518
  { Intrinsic::amdgcn_image_sample_c_l_o_2d_nortn, IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 519
  { Intrinsic::amdgcn_image_sample_c_l_o_2darray, IMAGE_SAMPLE_C_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 520
  { Intrinsic::amdgcn_image_sample_c_l_o_2darray_nortn, IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x0 }, // 521
  { Intrinsic::amdgcn_image_sample_c_l_o_3d, IMAGE_SAMPLE_C_L_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 522
  { Intrinsic::amdgcn_image_sample_c_l_o_3d_nortn, IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x0 }, // 523
  { Intrinsic::amdgcn_image_sample_c_l_o_cube, IMAGE_SAMPLE_C_L_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 524
  { Intrinsic::amdgcn_image_sample_c_l_o_cube_nortn, IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x0 }, // 525
  { Intrinsic::amdgcn_image_sample_c_lz_1d, IMAGE_SAMPLE_C_LZ, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 526
  { Intrinsic::amdgcn_image_sample_c_lz_1d_nortn, IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 527
  { Intrinsic::amdgcn_image_sample_c_lz_1darray, IMAGE_SAMPLE_C_LZ, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 528
  { Intrinsic::amdgcn_image_sample_c_lz_1darray_nortn, IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 529
  { Intrinsic::amdgcn_image_sample_c_lz_2d, IMAGE_SAMPLE_C_LZ, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 530
  { Intrinsic::amdgcn_image_sample_c_lz_2d_nortn, IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 531
  { Intrinsic::amdgcn_image_sample_c_lz_2darray, IMAGE_SAMPLE_C_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 532
  { Intrinsic::amdgcn_image_sample_c_lz_2darray_nortn, IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 533
  { Intrinsic::amdgcn_image_sample_c_lz_3d, IMAGE_SAMPLE_C_LZ, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 534
  { Intrinsic::amdgcn_image_sample_c_lz_3d_nortn, IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 535
  { Intrinsic::amdgcn_image_sample_c_lz_cube, IMAGE_SAMPLE_C_LZ, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 536
  { Intrinsic::amdgcn_image_sample_c_lz_cube_nortn, IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 537
  { Intrinsic::amdgcn_image_sample_c_lz_o_1d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 538
  { Intrinsic::amdgcn_image_sample_c_lz_o_1d_nortn, IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 539
  { Intrinsic::amdgcn_image_sample_c_lz_o_1darray, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 540
  { Intrinsic::amdgcn_image_sample_c_lz_o_1darray_nortn, IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 541
  { Intrinsic::amdgcn_image_sample_c_lz_o_2d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 542
  { Intrinsic::amdgcn_image_sample_c_lz_o_2d_nortn, IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 543
  { Intrinsic::amdgcn_image_sample_c_lz_o_2darray, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 544
  { Intrinsic::amdgcn_image_sample_c_lz_o_2darray_nortn, IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 545
  { Intrinsic::amdgcn_image_sample_c_lz_o_3d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 546
  { Intrinsic::amdgcn_image_sample_c_lz_o_3d_nortn, IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 547
  { Intrinsic::amdgcn_image_sample_c_lz_o_cube, IMAGE_SAMPLE_C_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 548
  { Intrinsic::amdgcn_image_sample_c_lz_o_cube_nortn, IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 549
  { Intrinsic::amdgcn_image_sample_c_o_1d, IMAGE_SAMPLE_C_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 550
  { Intrinsic::amdgcn_image_sample_c_o_1d_nortn, IMAGE_SAMPLE_C_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 551
  { Intrinsic::amdgcn_image_sample_c_o_1darray, IMAGE_SAMPLE_C_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 552
  { Intrinsic::amdgcn_image_sample_c_o_1darray_nortn, IMAGE_SAMPLE_C_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 553
  { Intrinsic::amdgcn_image_sample_c_o_2d, IMAGE_SAMPLE_C_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 554
  { Intrinsic::amdgcn_image_sample_c_o_2d_nortn, IMAGE_SAMPLE_C_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 555
  { Intrinsic::amdgcn_image_sample_c_o_2darray, IMAGE_SAMPLE_C_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 556
  { Intrinsic::amdgcn_image_sample_c_o_2darray_nortn, IMAGE_SAMPLE_C_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 557
  { Intrinsic::amdgcn_image_sample_c_o_3d, IMAGE_SAMPLE_C_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 558
  { Intrinsic::amdgcn_image_sample_c_o_3d_nortn, IMAGE_SAMPLE_C_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 559
  { Intrinsic::amdgcn_image_sample_c_o_cube, IMAGE_SAMPLE_C_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 560
  { Intrinsic::amdgcn_image_sample_c_o_cube_nortn, IMAGE_SAMPLE_C_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 561
  { Intrinsic::amdgcn_image_sample_cd_1d, IMAGE_SAMPLE_CD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x2 }, // 562
  { Intrinsic::amdgcn_image_sample_cd_1d_nortn, IMAGE_SAMPLE_CD_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x1 }, // 563
  { Intrinsic::amdgcn_image_sample_cd_1darray, IMAGE_SAMPLE_CD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 564
  { Intrinsic::amdgcn_image_sample_cd_1darray_nortn, IMAGE_SAMPLE_CD_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 565
  { Intrinsic::amdgcn_image_sample_cd_2d, IMAGE_SAMPLE_CD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 566
  { Intrinsic::amdgcn_image_sample_cd_2d_nortn, IMAGE_SAMPLE_CD_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 567
  { Intrinsic::amdgcn_image_sample_cd_2darray, IMAGE_SAMPLE_CD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 568
  { Intrinsic::amdgcn_image_sample_cd_2darray_nortn, IMAGE_SAMPLE_CD_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 569
  { Intrinsic::amdgcn_image_sample_cd_3d, IMAGE_SAMPLE_CD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 570
  { Intrinsic::amdgcn_image_sample_cd_3d_nortn, IMAGE_SAMPLE_CD_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 571
  { Intrinsic::amdgcn_image_sample_cd_cl_1d, IMAGE_SAMPLE_CD_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 572
  { Intrinsic::amdgcn_image_sample_cd_cl_1d_nortn, IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 573
  { Intrinsic::amdgcn_image_sample_cd_cl_1darray, IMAGE_SAMPLE_CD_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 574
  { Intrinsic::amdgcn_image_sample_cd_cl_1darray_nortn, IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 575
  { Intrinsic::amdgcn_image_sample_cd_cl_2d, IMAGE_SAMPLE_CD_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 576
  { Intrinsic::amdgcn_image_sample_cd_cl_2d_nortn, IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 577
  { Intrinsic::amdgcn_image_sample_cd_cl_2darray, IMAGE_SAMPLE_CD_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 578
  { Intrinsic::amdgcn_image_sample_cd_cl_2darray_nortn, IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 579
  { Intrinsic::amdgcn_image_sample_cd_cl_3d, IMAGE_SAMPLE_CD_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 580
  { Intrinsic::amdgcn_image_sample_cd_cl_3d_nortn, IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 581
  { Intrinsic::amdgcn_image_sample_cd_cl_cube, IMAGE_SAMPLE_CD_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 582
  { Intrinsic::amdgcn_image_sample_cd_cl_cube_nortn, IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 583
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 584
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1d_nortn, IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 585
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1darray, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 586
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1darray_nortn, IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 587
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 588
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2d_nortn, IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 589
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2darray, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 590
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2darray_nortn, IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 591
  { Intrinsic::amdgcn_image_sample_cd_cl_o_3d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 592
  { Intrinsic::amdgcn_image_sample_cd_cl_o_3d_nortn, IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x0, 0x0, 0x1 }, // 593
  { Intrinsic::amdgcn_image_sample_cd_cl_o_cube, IMAGE_SAMPLE_CD_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 594
  { Intrinsic::amdgcn_image_sample_cd_cl_o_cube_nortn, IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 595
  { Intrinsic::amdgcn_image_sample_cd_cube, IMAGE_SAMPLE_CD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 596
  { Intrinsic::amdgcn_image_sample_cd_cube_nortn, IMAGE_SAMPLE_CD_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 597
  { Intrinsic::amdgcn_image_sample_cd_o_1d, IMAGE_SAMPLE_CD_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 598
  { Intrinsic::amdgcn_image_sample_cd_o_1d_nortn, IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 599
  { Intrinsic::amdgcn_image_sample_cd_o_1darray, IMAGE_SAMPLE_CD_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 600
  { Intrinsic::amdgcn_image_sample_cd_o_1darray_nortn, IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 601
  { Intrinsic::amdgcn_image_sample_cd_o_2d, IMAGE_SAMPLE_CD_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 602
  { Intrinsic::amdgcn_image_sample_cd_o_2d_nortn, IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 603
  { Intrinsic::amdgcn_image_sample_cd_o_2darray, IMAGE_SAMPLE_CD_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 604
  { Intrinsic::amdgcn_image_sample_cd_o_2darray_nortn, IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 605
  { Intrinsic::amdgcn_image_sample_cd_o_3d, IMAGE_SAMPLE_CD_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 606
  { Intrinsic::amdgcn_image_sample_cd_o_3d_nortn, IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 607
  { Intrinsic::amdgcn_image_sample_cd_o_cube, IMAGE_SAMPLE_CD_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 608
  { Intrinsic::amdgcn_image_sample_cd_o_cube_nortn, IMAGE_SAMPLE_CD_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 609
  { Intrinsic::amdgcn_image_sample_cl_1d, IMAGE_SAMPLE_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 610
  { Intrinsic::amdgcn_image_sample_cl_1d_nortn, IMAGE_SAMPLE_CL_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 611
  { Intrinsic::amdgcn_image_sample_cl_1darray, IMAGE_SAMPLE_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 612
  { Intrinsic::amdgcn_image_sample_cl_1darray_nortn, IMAGE_SAMPLE_CL_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 613
  { Intrinsic::amdgcn_image_sample_cl_2d, IMAGE_SAMPLE_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 614
  { Intrinsic::amdgcn_image_sample_cl_2d_nortn, IMAGE_SAMPLE_CL_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 615
  { Intrinsic::amdgcn_image_sample_cl_2darray, IMAGE_SAMPLE_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 616
  { Intrinsic::amdgcn_image_sample_cl_2darray_nortn, IMAGE_SAMPLE_CL_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 617
  { Intrinsic::amdgcn_image_sample_cl_3d, IMAGE_SAMPLE_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 618
  { Intrinsic::amdgcn_image_sample_cl_3d_nortn, IMAGE_SAMPLE_CL_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 619
  { Intrinsic::amdgcn_image_sample_cl_cube, IMAGE_SAMPLE_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 620
  { Intrinsic::amdgcn_image_sample_cl_cube_nortn, IMAGE_SAMPLE_CL_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 621
  { Intrinsic::amdgcn_image_sample_cl_o_1d, IMAGE_SAMPLE_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 622
  { Intrinsic::amdgcn_image_sample_cl_o_1d_nortn, IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 623
  { Intrinsic::amdgcn_image_sample_cl_o_1darray, IMAGE_SAMPLE_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 624
  { Intrinsic::amdgcn_image_sample_cl_o_1darray_nortn, IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 625
  { Intrinsic::amdgcn_image_sample_cl_o_2d, IMAGE_SAMPLE_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 626
  { Intrinsic::amdgcn_image_sample_cl_o_2d_nortn, IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 627
  { Intrinsic::amdgcn_image_sample_cl_o_2darray, IMAGE_SAMPLE_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 628
  { Intrinsic::amdgcn_image_sample_cl_o_2darray_nortn, IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 629
  { Intrinsic::amdgcn_image_sample_cl_o_3d, IMAGE_SAMPLE_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 630
  { Intrinsic::amdgcn_image_sample_cl_o_3d_nortn, IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 631
  { Intrinsic::amdgcn_image_sample_cl_o_cube, IMAGE_SAMPLE_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 632
  { Intrinsic::amdgcn_image_sample_cl_o_cube_nortn, IMAGE_SAMPLE_CL_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 633
  { Intrinsic::amdgcn_image_sample_cube, IMAGE_SAMPLE, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 634
  { Intrinsic::amdgcn_image_sample_cube_nortn, IMAGE_SAMPLE_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 635
  { Intrinsic::amdgcn_image_sample_d_1d, IMAGE_SAMPLE_D, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x2 }, // 636
  { Intrinsic::amdgcn_image_sample_d_1d_nortn, IMAGE_SAMPLE_D_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x1 }, // 637
  { Intrinsic::amdgcn_image_sample_d_1darray, IMAGE_SAMPLE_D, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 638
  { Intrinsic::amdgcn_image_sample_d_1darray_nortn, IMAGE_SAMPLE_D_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 639
  { Intrinsic::amdgcn_image_sample_d_2d, IMAGE_SAMPLE_D, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 640
  { Intrinsic::amdgcn_image_sample_d_2d_nortn, IMAGE_SAMPLE_D_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 641
  { Intrinsic::amdgcn_image_sample_d_2darray, IMAGE_SAMPLE_D, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 642
  { Intrinsic::amdgcn_image_sample_d_2darray_nortn, IMAGE_SAMPLE_D_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 643
  { Intrinsic::amdgcn_image_sample_d_3d, IMAGE_SAMPLE_D, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 644
  { Intrinsic::amdgcn_image_sample_d_3d_nortn, IMAGE_SAMPLE_D_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 645
  { Intrinsic::amdgcn_image_sample_d_cl_1d, IMAGE_SAMPLE_D_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 646
  { Intrinsic::amdgcn_image_sample_d_cl_1d_nortn, IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 647
  { Intrinsic::amdgcn_image_sample_d_cl_1darray, IMAGE_SAMPLE_D_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 648
  { Intrinsic::amdgcn_image_sample_d_cl_1darray_nortn, IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 649
  { Intrinsic::amdgcn_image_sample_d_cl_2d, IMAGE_SAMPLE_D_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 650
  { Intrinsic::amdgcn_image_sample_d_cl_2d_nortn, IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 651
  { Intrinsic::amdgcn_image_sample_d_cl_2darray, IMAGE_SAMPLE_D_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 652
  { Intrinsic::amdgcn_image_sample_d_cl_2darray_nortn, IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 653
  { Intrinsic::amdgcn_image_sample_d_cl_3d, IMAGE_SAMPLE_D_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 654
  { Intrinsic::amdgcn_image_sample_d_cl_3d_nortn, IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 655
  { Intrinsic::amdgcn_image_sample_d_cl_cube, IMAGE_SAMPLE_D_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 656
  { Intrinsic::amdgcn_image_sample_d_cl_cube_nortn, IMAGE_SAMPLE_D_CL_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 657
  { Intrinsic::amdgcn_image_sample_d_cl_o_1d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 658
  { Intrinsic::amdgcn_image_sample_d_cl_o_1d_nortn, IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 659
  { Intrinsic::amdgcn_image_sample_d_cl_o_1darray, IMAGE_SAMPLE_D_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 660
  { Intrinsic::amdgcn_image_sample_d_cl_o_1darray_nortn, IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 661
  { Intrinsic::amdgcn_image_sample_d_cl_o_2d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 662
  { Intrinsic::amdgcn_image_sample_d_cl_o_2d_nortn, IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 663
  { Intrinsic::amdgcn_image_sample_d_cl_o_2darray, IMAGE_SAMPLE_D_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 664
  { Intrinsic::amdgcn_image_sample_d_cl_o_2darray_nortn, IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 665
  { Intrinsic::amdgcn_image_sample_d_cl_o_3d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 666
  { Intrinsic::amdgcn_image_sample_d_cl_o_3d_nortn, IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x0, 0x0, 0x1 }, // 667
  { Intrinsic::amdgcn_image_sample_d_cl_o_cube, IMAGE_SAMPLE_D_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 668
  { Intrinsic::amdgcn_image_sample_d_cl_o_cube_nortn, IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 669
  { Intrinsic::amdgcn_image_sample_d_cube, IMAGE_SAMPLE_D, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 670
  { Intrinsic::amdgcn_image_sample_d_cube_nortn, IMAGE_SAMPLE_D_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 671
  { Intrinsic::amdgcn_image_sample_d_o_1d, IMAGE_SAMPLE_D_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 672
  { Intrinsic::amdgcn_image_sample_d_o_1d_nortn, IMAGE_SAMPLE_D_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 673
  { Intrinsic::amdgcn_image_sample_d_o_1darray, IMAGE_SAMPLE_D_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 674
  { Intrinsic::amdgcn_image_sample_d_o_1darray_nortn, IMAGE_SAMPLE_D_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 675
  { Intrinsic::amdgcn_image_sample_d_o_2d, IMAGE_SAMPLE_D_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 676
  { Intrinsic::amdgcn_image_sample_d_o_2d_nortn, IMAGE_SAMPLE_D_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 677
  { Intrinsic::amdgcn_image_sample_d_o_2darray, IMAGE_SAMPLE_D_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 678
  { Intrinsic::amdgcn_image_sample_d_o_2darray_nortn, IMAGE_SAMPLE_D_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 679
  { Intrinsic::amdgcn_image_sample_d_o_3d, IMAGE_SAMPLE_D_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 680
  { Intrinsic::amdgcn_image_sample_d_o_3d_nortn, IMAGE_SAMPLE_D_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 681
  { Intrinsic::amdgcn_image_sample_d_o_cube, IMAGE_SAMPLE_D_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 682
  { Intrinsic::amdgcn_image_sample_d_o_cube_nortn, IMAGE_SAMPLE_D_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 683
  { Intrinsic::amdgcn_image_sample_l_1d, IMAGE_SAMPLE_L, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 684
  { Intrinsic::amdgcn_image_sample_l_1d_nortn, IMAGE_SAMPLE_L_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 685
  { Intrinsic::amdgcn_image_sample_l_1darray, IMAGE_SAMPLE_L, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 686
  { Intrinsic::amdgcn_image_sample_l_1darray_nortn, IMAGE_SAMPLE_L_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 687
  { Intrinsic::amdgcn_image_sample_l_2d, IMAGE_SAMPLE_L, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 688
  { Intrinsic::amdgcn_image_sample_l_2d_nortn, IMAGE_SAMPLE_L_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 689
  { Intrinsic::amdgcn_image_sample_l_2darray, IMAGE_SAMPLE_L, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 690
  { Intrinsic::amdgcn_image_sample_l_2darray_nortn, IMAGE_SAMPLE_L_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 691
  { Intrinsic::amdgcn_image_sample_l_3d, IMAGE_SAMPLE_L, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 692
  { Intrinsic::amdgcn_image_sample_l_3d_nortn, IMAGE_SAMPLE_L_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 693
  { Intrinsic::amdgcn_image_sample_l_cube, IMAGE_SAMPLE_L, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 694
  { Intrinsic::amdgcn_image_sample_l_cube_nortn, IMAGE_SAMPLE_L_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 695
  { Intrinsic::amdgcn_image_sample_l_o_1d, IMAGE_SAMPLE_L_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 696
  { Intrinsic::amdgcn_image_sample_l_o_1d_nortn, IMAGE_SAMPLE_L_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 697
  { Intrinsic::amdgcn_image_sample_l_o_1darray, IMAGE_SAMPLE_L_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 698
  { Intrinsic::amdgcn_image_sample_l_o_1darray_nortn, IMAGE_SAMPLE_L_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 699
  { Intrinsic::amdgcn_image_sample_l_o_2d, IMAGE_SAMPLE_L_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 700
  { Intrinsic::amdgcn_image_sample_l_o_2d_nortn, IMAGE_SAMPLE_L_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 701
  { Intrinsic::amdgcn_image_sample_l_o_2darray, IMAGE_SAMPLE_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 702
  { Intrinsic::amdgcn_image_sample_l_o_2darray_nortn, IMAGE_SAMPLE_L_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 703
  { Intrinsic::amdgcn_image_sample_l_o_3d, IMAGE_SAMPLE_L_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 704
  { Intrinsic::amdgcn_image_sample_l_o_3d_nortn, IMAGE_SAMPLE_L_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 705
  { Intrinsic::amdgcn_image_sample_l_o_cube, IMAGE_SAMPLE_L_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 706
  { Intrinsic::amdgcn_image_sample_l_o_cube_nortn, IMAGE_SAMPLE_L_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 707
  { Intrinsic::amdgcn_image_sample_lz_1d, IMAGE_SAMPLE_LZ, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 708
  { Intrinsic::amdgcn_image_sample_lz_1d_nortn, IMAGE_SAMPLE_LZ_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x0, 0x0, 0x0 }, // 709
  { Intrinsic::amdgcn_image_sample_lz_1darray, IMAGE_SAMPLE_LZ, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 710
  { Intrinsic::amdgcn_image_sample_lz_1darray_nortn, IMAGE_SAMPLE_LZ_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 711
  { Intrinsic::amdgcn_image_sample_lz_2d, IMAGE_SAMPLE_LZ, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 712
  { Intrinsic::amdgcn_image_sample_lz_2d_nortn, IMAGE_SAMPLE_LZ_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 713
  { Intrinsic::amdgcn_image_sample_lz_2darray, IMAGE_SAMPLE_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 714
  { Intrinsic::amdgcn_image_sample_lz_2darray_nortn, IMAGE_SAMPLE_LZ_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 715
  { Intrinsic::amdgcn_image_sample_lz_3d, IMAGE_SAMPLE_LZ, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 716
  { Intrinsic::amdgcn_image_sample_lz_3d_nortn, IMAGE_SAMPLE_LZ_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 717
  { Intrinsic::amdgcn_image_sample_lz_cube, IMAGE_SAMPLE_LZ, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 718
  { Intrinsic::amdgcn_image_sample_lz_cube_nortn, IMAGE_SAMPLE_LZ_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 719
  { Intrinsic::amdgcn_image_sample_lz_o_1d, IMAGE_SAMPLE_LZ_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 720
  { Intrinsic::amdgcn_image_sample_lz_o_1d_nortn, IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 721
  { Intrinsic::amdgcn_image_sample_lz_o_1darray, IMAGE_SAMPLE_LZ_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 722
  { Intrinsic::amdgcn_image_sample_lz_o_1darray_nortn, IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 723
  { Intrinsic::amdgcn_image_sample_lz_o_2d, IMAGE_SAMPLE_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 724
  { Intrinsic::amdgcn_image_sample_lz_o_2d_nortn, IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 725
  { Intrinsic::amdgcn_image_sample_lz_o_2darray, IMAGE_SAMPLE_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 726
  { Intrinsic::amdgcn_image_sample_lz_o_2darray_nortn, IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 727
  { Intrinsic::amdgcn_image_sample_lz_o_3d, IMAGE_SAMPLE_LZ_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 728
  { Intrinsic::amdgcn_image_sample_lz_o_3d_nortn, IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 729
  { Intrinsic::amdgcn_image_sample_lz_o_cube, IMAGE_SAMPLE_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 730
  { Intrinsic::amdgcn_image_sample_lz_o_cube_nortn, IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 731
  { Intrinsic::amdgcn_image_sample_o_1d, IMAGE_SAMPLE_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 732
  { Intrinsic::amdgcn_image_sample_o_1d_nortn, IMAGE_SAMPLE_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 733
  { Intrinsic::amdgcn_image_sample_o_1darray, IMAGE_SAMPLE_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 734
  { Intrinsic::amdgcn_image_sample_o_1darray_nortn, IMAGE_SAMPLE_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 735
  { Intrinsic::amdgcn_image_sample_o_2d, IMAGE_SAMPLE_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 736
  { Intrinsic::amdgcn_image_sample_o_2d_nortn, IMAGE_SAMPLE_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 737
  { Intrinsic::amdgcn_image_sample_o_2darray, IMAGE_SAMPLE_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 738
  { Intrinsic::amdgcn_image_sample_o_2darray_nortn, IMAGE_SAMPLE_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 739
  { Intrinsic::amdgcn_image_sample_o_3d, IMAGE_SAMPLE_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 740
  { Intrinsic::amdgcn_image_sample_o_3d_nortn, IMAGE_SAMPLE_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 741
  { Intrinsic::amdgcn_image_sample_o_cube, IMAGE_SAMPLE_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 742
  { Intrinsic::amdgcn_image_sample_o_cube_nortn, IMAGE_SAMPLE_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 743
  { Intrinsic::amdgcn_image_store_1d, IMAGE_STORE, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x6, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 744
  { Intrinsic::amdgcn_image_store_1darray, IMAGE_STORE, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 745
  { Intrinsic::amdgcn_image_store_2d, IMAGE_STORE, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 746
  { Intrinsic::amdgcn_image_store_2darray, IMAGE_STORE, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 747
  { Intrinsic::amdgcn_image_store_2darraymsaa, IMAGE_STORE, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 748
  { Intrinsic::amdgcn_image_store_2dmsaa, IMAGE_STORE, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 749
  { Intrinsic::amdgcn_image_store_3d, IMAGE_STORE, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 750
  { Intrinsic::amdgcn_image_store_cube, IMAGE_STORE, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 751
  { Intrinsic::amdgcn_image_store_mip_1d, IMAGE_STORE_MIP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 752
  { Intrinsic::amdgcn_image_store_mip_1darray, IMAGE_STORE_MIP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 753
  { Intrinsic::amdgcn_image_store_mip_2d, IMAGE_STORE_MIP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 754
  { Intrinsic::amdgcn_image_store_mip_2darray, IMAGE_STORE_MIP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 755
  { Intrinsic::amdgcn_image_store_mip_3d, IMAGE_STORE_MIP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 756
  { Intrinsic::amdgcn_image_store_mip_cube, IMAGE_STORE_MIP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 757
 };

const ImageDimIntrinsicInfo *getImageDimIntrinsicInfo(unsigned Intr) {
  if ((Intr < Intrinsic::amdgcn_image_atomic_add_1d) ||
      (Intr > Intrinsic::amdgcn_image_store_mip_cube))
    return nullptr;

  struct KeyType {
    unsigned Intr;
  };
  KeyType Key = {Intr};
  struct Comp {
    bool operator()(const ImageDimIntrinsicInfo &LHS, const KeyType &RHS) const {
      if (LHS.Intr < RHS.Intr)
        return true;
      if (LHS.Intr > RHS.Intr)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(ImageDimIntrinsicTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Intr != Idx->Intr)
    return nullptr;

  return &*Idx;
}

const ImageDimIntrinsicInfo *getImageDimIntrinsicByBaseOpcode(unsigned BaseOpcode, unsigned Dim) {
  struct IndexType {
    unsigned BaseOpcode;
    unsigned Dim;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { IMAGE_ATOMIC_ADD, AMDGPUDim1D, 0 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim1DArray, 1 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2D, 2 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DArray, 3 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DArrayMsaa, 4 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DMsaa, 5 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim3D, 6 },
    { IMAGE_ATOMIC_ADD, AMDGPUDimCube, 7 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim1D, 8 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim1DArray, 9 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2D, 10 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DArray, 11 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DArrayMsaa, 12 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DMsaa, 13 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim3D, 14 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDimCube, 15 },
    { IMAGE_ATOMIC_AND, AMDGPUDim1D, 16 },
    { IMAGE_ATOMIC_AND, AMDGPUDim1DArray, 17 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2D, 18 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DArray, 19 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DArrayMsaa, 20 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DMsaa, 21 },
    { IMAGE_ATOMIC_AND, AMDGPUDim3D, 22 },
    { IMAGE_ATOMIC_AND, AMDGPUDimCube, 23 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1D, 24 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1DArray, 25 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2D, 26 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArray, 27 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArrayMsaa, 28 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DMsaa, 29 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim3D, 30 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDimCube, 31 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim1D, 32 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim1DArray, 33 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2D, 34 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DArray, 35 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DArrayMsaa, 36 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DMsaa, 37 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim3D, 38 },
    { IMAGE_ATOMIC_DEC, AMDGPUDimCube, 39 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim1D, 40 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim1DArray, 41 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2D, 42 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DArray, 43 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DArrayMsaa, 44 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DMsaa, 45 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim3D, 46 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDimCube, 47 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim1D, 48 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim1DArray, 49 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2D, 50 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DArray, 51 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DArrayMsaa, 52 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DMsaa, 53 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim3D, 54 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDimCube, 55 },
    { IMAGE_ATOMIC_INC, AMDGPUDim1D, 56 },
    { IMAGE_ATOMIC_INC, AMDGPUDim1DArray, 57 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2D, 58 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DArray, 59 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DArrayMsaa, 60 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DMsaa, 61 },
    { IMAGE_ATOMIC_INC, AMDGPUDim3D, 62 },
    { IMAGE_ATOMIC_INC, AMDGPUDimCube, 63 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim1D, 64 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim1DArray, 65 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2D, 66 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DArray, 67 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DArrayMsaa, 68 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DMsaa, 69 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim3D, 70 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDimCube, 71 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim1D, 72 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim1DArray, 73 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2D, 74 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DArray, 75 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DArrayMsaa, 76 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DMsaa, 77 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim3D, 78 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDimCube, 79 },
    { IMAGE_ATOMIC_OR, AMDGPUDim1D, 80 },
    { IMAGE_ATOMIC_OR, AMDGPUDim1DArray, 81 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2D, 82 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DArray, 83 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DArrayMsaa, 84 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DMsaa, 85 },
    { IMAGE_ATOMIC_OR, AMDGPUDim3D, 86 },
    { IMAGE_ATOMIC_OR, AMDGPUDimCube, 87 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim1D, 88 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim1DArray, 89 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2D, 90 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DArray, 91 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DArrayMsaa, 92 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DMsaa, 93 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim3D, 94 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDimCube, 95 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim1D, 96 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim1DArray, 97 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2D, 98 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DArray, 99 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DArrayMsaa, 100 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DMsaa, 101 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim3D, 102 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDimCube, 103 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim1D, 104 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim1DArray, 105 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2D, 106 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DArray, 107 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DArrayMsaa, 108 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DMsaa, 109 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim3D, 110 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDimCube, 111 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim1D, 112 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim1DArray, 113 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2D, 114 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DArray, 115 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DArrayMsaa, 116 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DMsaa, 117 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim3D, 118 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDimCube, 119 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim1D, 120 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim1DArray, 121 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2D, 122 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DArray, 123 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DArrayMsaa, 124 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DMsaa, 125 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim3D, 126 },
    { IMAGE_ATOMIC_SUB, AMDGPUDimCube, 127 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim1D, 128 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim1DArray, 129 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2D, 130 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DArray, 131 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DArrayMsaa, 132 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DMsaa, 133 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim3D, 134 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDimCube, 135 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim1D, 136 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim1DArray, 137 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2D, 138 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DArray, 139 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DArrayMsaa, 140 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DMsaa, 141 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim3D, 142 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDimCube, 143 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim1D, 144 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim1DArray, 145 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2D, 146 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DArray, 147 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DArrayMsaa, 148 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DMsaa, 149 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim3D, 150 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDimCube, 151 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim1D, 152 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim1DArray, 153 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2D, 154 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DArray, 155 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DArrayMsaa, 156 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DMsaa, 157 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim3D, 158 },
    { IMAGE_ATOMIC_XOR, AMDGPUDimCube, 159 },
    { IMAGE_GATHER4, AMDGPUDim2D, 160 },
    { IMAGE_GATHER4, AMDGPUDim2DArray, 161 },
    { IMAGE_GATHER4, AMDGPUDimCube, 216 },
    { IMAGE_GATHER4_B, AMDGPUDim2D, 162 },
    { IMAGE_GATHER4_B, AMDGPUDim2DArray, 163 },
    { IMAGE_GATHER4_B, AMDGPUDimCube, 170 },
    { IMAGE_GATHER4_B_CL, AMDGPUDim2D, 164 },
    { IMAGE_GATHER4_B_CL, AMDGPUDim2DArray, 165 },
    { IMAGE_GATHER4_B_CL, AMDGPUDimCube, 166 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDim2D, 167 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDim2DArray, 168 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDimCube, 169 },
    { IMAGE_GATHER4_B_O, AMDGPUDim2D, 171 },
    { IMAGE_GATHER4_B_O, AMDGPUDim2DArray, 172 },
    { IMAGE_GATHER4_B_O, AMDGPUDimCube, 173 },
    { IMAGE_GATHER4_C, AMDGPUDim2D, 174 },
    { IMAGE_GATHER4_C, AMDGPUDim2DArray, 175 },
    { IMAGE_GATHER4_C, AMDGPUDimCube, 194 },
    { IMAGE_GATHER4_CL, AMDGPUDim2D, 210 },
    { IMAGE_GATHER4_CL, AMDGPUDim2DArray, 211 },
    { IMAGE_GATHER4_CL, AMDGPUDimCube, 212 },
    { IMAGE_GATHER4_CL_O, AMDGPUDim2D, 213 },
    { IMAGE_GATHER4_CL_O, AMDGPUDim2DArray, 214 },
    { IMAGE_GATHER4_CL_O, AMDGPUDimCube, 215 },
    { IMAGE_GATHER4_C_B, AMDGPUDim2D, 176 },
    { IMAGE_GATHER4_C_B, AMDGPUDim2DArray, 177 },
    { IMAGE_GATHER4_C_B, AMDGPUDimCube, 184 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDim2D, 178 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDim2DArray, 179 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDimCube, 180 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2D, 181 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2DArray, 182 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDimCube, 183 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDim2D, 185 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDim2DArray, 186 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDimCube, 187 },
    { IMAGE_GATHER4_C_CL, AMDGPUDim2D, 188 },
    { IMAGE_GATHER4_C_CL, AMDGPUDim2DArray, 189 },
    { IMAGE_GATHER4_C_CL, AMDGPUDimCube, 190 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDim2D, 191 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDim2DArray, 192 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDimCube, 193 },
    { IMAGE_GATHER4_C_L, AMDGPUDim2D, 195 },
    { IMAGE_GATHER4_C_L, AMDGPUDim2DArray, 196 },
    { IMAGE_GATHER4_C_L, AMDGPUDimCube, 197 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDim2D, 201 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDim2DArray, 202 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDimCube, 203 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDim2D, 204 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDim2DArray, 205 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDimCube, 206 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDim2D, 198 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDim2DArray, 199 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDimCube, 200 },
    { IMAGE_GATHER4_C_O, AMDGPUDim2D, 207 },
    { IMAGE_GATHER4_C_O, AMDGPUDim2DArray, 208 },
    { IMAGE_GATHER4_C_O, AMDGPUDimCube, 209 },
    { IMAGE_GATHER4_L, AMDGPUDim2D, 217 },
    { IMAGE_GATHER4_L, AMDGPUDim2DArray, 218 },
    { IMAGE_GATHER4_L, AMDGPUDimCube, 219 },
    { IMAGE_GATHER4_LZ, AMDGPUDim2D, 223 },
    { IMAGE_GATHER4_LZ, AMDGPUDim2DArray, 224 },
    { IMAGE_GATHER4_LZ, AMDGPUDimCube, 225 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDim2D, 226 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDim2DArray, 227 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDimCube, 228 },
    { IMAGE_GATHER4_L_O, AMDGPUDim2D, 220 },
    { IMAGE_GATHER4_L_O, AMDGPUDim2DArray, 221 },
    { IMAGE_GATHER4_L_O, AMDGPUDimCube, 222 },
    { IMAGE_GATHER4_O, AMDGPUDim2D, 229 },
    { IMAGE_GATHER4_O, AMDGPUDim2DArray, 230 },
    { IMAGE_GATHER4_O, AMDGPUDimCube, 231 },
    { IMAGE_GET_LOD, AMDGPUDim1D, 232 },
    { IMAGE_GET_LOD, AMDGPUDim1DArray, 233 },
    { IMAGE_GET_LOD, AMDGPUDim2D, 234 },
    { IMAGE_GET_LOD, AMDGPUDim2DArray, 235 },
    { IMAGE_GET_LOD, AMDGPUDim3D, 236 },
    { IMAGE_GET_LOD, AMDGPUDimCube, 237 },
    { IMAGE_GET_RESINFO, AMDGPUDim1D, 238 },
    { IMAGE_GET_RESINFO, AMDGPUDim1DArray, 239 },
    { IMAGE_GET_RESINFO, AMDGPUDim2D, 240 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DArray, 241 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DArrayMsaa, 242 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DMsaa, 243 },
    { IMAGE_GET_RESINFO, AMDGPUDim3D, 244 },
    { IMAGE_GET_RESINFO, AMDGPUDimCube, 245 },
    { IMAGE_LOAD, AMDGPUDim1D, 246 },
    { IMAGE_LOAD, AMDGPUDim1DArray, 247 },
    { IMAGE_LOAD, AMDGPUDim2D, 248 },
    { IMAGE_LOAD, AMDGPUDim2DArray, 249 },
    { IMAGE_LOAD, AMDGPUDim2DArrayMsaa, 250 },
    { IMAGE_LOAD, AMDGPUDim2DMsaa, 251 },
    { IMAGE_LOAD, AMDGPUDim3D, 252 },
    { IMAGE_LOAD, AMDGPUDimCube, 253 },
    { IMAGE_LOAD_MIP, AMDGPUDim1D, 254 },
    { IMAGE_LOAD_MIP, AMDGPUDim1DArray, 255 },
    { IMAGE_LOAD_MIP, AMDGPUDim2D, 256 },
    { IMAGE_LOAD_MIP, AMDGPUDim2DArray, 257 },
    { IMAGE_LOAD_MIP, AMDGPUDim3D, 258 },
    { IMAGE_LOAD_MIP, AMDGPUDimCube, 259 },
    { IMAGE_MSAA_LOAD, AMDGPUDim2DArrayMsaa, 260 },
    { IMAGE_MSAA_LOAD, AMDGPUDim2DMsaa, 261 },
    { IMAGE_MSAA_LOAD_X, AMDGPUDim2DArrayMsaa, 262 },
    { IMAGE_MSAA_LOAD_X, AMDGPUDim2DMsaa, 263 },
    { IMAGE_SAMPLE, AMDGPUDim1D, 264 },
    { IMAGE_SAMPLE, AMDGPUDim1DArray, 266 },
    { IMAGE_SAMPLE, AMDGPUDim2D, 268 },
    { IMAGE_SAMPLE, AMDGPUDim2DArray, 270 },
    { IMAGE_SAMPLE, AMDGPUDim3D, 272 },
    { IMAGE_SAMPLE, AMDGPUDimCube, 634 },
    { IMAGE_SAMPLE_B, AMDGPUDim1D, 274 },
    { IMAGE_SAMPLE_B, AMDGPUDim1DArray, 276 },
    { IMAGE_SAMPLE_B, AMDGPUDim2D, 278 },
    { IMAGE_SAMPLE_B, AMDGPUDim2DArray, 280 },
    { IMAGE_SAMPLE_B, AMDGPUDim3D, 282 },
    { IMAGE_SAMPLE_B, AMDGPUDimCube, 308 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim1D, 284 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim1DArray, 286 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim2D, 288 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim2DArray, 290 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim3D, 292 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDimCube, 294 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim1D, 296 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim1DArray, 298 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim2D, 300 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim2DArray, 302 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim3D, 304 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDimCube, 306 },
    { IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim1D, 297 },
    { IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim1DArray, 299 },
    { IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim2D, 301 },
    { IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim2DArray, 303 },
    { IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim3D, 305 },
    { IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDimCube, 307 },
    { IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim1D, 285 },
    { IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim1DArray, 287 },
    { IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim2D, 289 },
    { IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim2DArray, 291 },
    { IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim3D, 293 },
    { IMAGE_SAMPLE_B_CL_nortn, AMDGPUDimCube, 295 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim1D, 310 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim1DArray, 312 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim2D, 314 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim2DArray, 316 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim3D, 318 },
    { IMAGE_SAMPLE_B_O, AMDGPUDimCube, 320 },
    { IMAGE_SAMPLE_B_O_nortn, AMDGPUDim1D, 311 },
    { IMAGE_SAMPLE_B_O_nortn, AMDGPUDim1DArray, 313 },
    { IMAGE_SAMPLE_B_O_nortn, AMDGPUDim2D, 315 },
    { IMAGE_SAMPLE_B_O_nortn, AMDGPUDim2DArray, 317 },
    { IMAGE_SAMPLE_B_O_nortn, AMDGPUDim3D, 319 },
    { IMAGE_SAMPLE_B_O_nortn, AMDGPUDimCube, 321 },
    { IMAGE_SAMPLE_B_nortn, AMDGPUDim1D, 275 },
    { IMAGE_SAMPLE_B_nortn, AMDGPUDim1DArray, 277 },
    { IMAGE_SAMPLE_B_nortn, AMDGPUDim2D, 279 },
    { IMAGE_SAMPLE_B_nortn, AMDGPUDim2DArray, 281 },
    { IMAGE_SAMPLE_B_nortn, AMDGPUDim3D, 283 },
    { IMAGE_SAMPLE_B_nortn, AMDGPUDimCube, 309 },
    { IMAGE_SAMPLE_C, AMDGPUDim1D, 322 },
    { IMAGE_SAMPLE_C, AMDGPUDim1DArray, 324 },
    { IMAGE_SAMPLE_C, AMDGPUDim2D, 326 },
    { IMAGE_SAMPLE_C, AMDGPUDim2DArray, 328 },
    { IMAGE_SAMPLE_C, AMDGPUDim3D, 330 },
    { IMAGE_SAMPLE_C, AMDGPUDimCube, 452 },
    { IMAGE_SAMPLE_CD, AMDGPUDim1D, 562 },
    { IMAGE_SAMPLE_CD, AMDGPUDim1DArray, 564 },
    { IMAGE_SAMPLE_CD, AMDGPUDim2D, 566 },
    { IMAGE_SAMPLE_CD, AMDGPUDim2DArray, 568 },
    { IMAGE_SAMPLE_CD, AMDGPUDim3D, 570 },
    { IMAGE_SAMPLE_CD, AMDGPUDimCube, 596 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim1D, 572 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim1DArray, 574 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim2D, 576 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim2DArray, 578 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim3D, 580 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDimCube, 582 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1D, 584 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1DArray, 586 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2D, 588 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2DArray, 590 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim3D, 592 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDimCube, 594 },
    { IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim1D, 585 },
    { IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim1DArray, 587 },
    { IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim2D, 589 },
    { IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim2DArray, 591 },
    { IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim3D, 593 },
    { IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDimCube, 595 },
    { IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim1D, 573 },
    { IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim1DArray, 575 },
    { IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim2D, 577 },
    { IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim2DArray, 579 },
    { IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim3D, 581 },
    { IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDimCube, 583 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim1D, 598 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim1DArray, 600 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim2D, 602 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim2DArray, 604 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim3D, 606 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDimCube, 608 },
    { IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim1D, 599 },
    { IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim1DArray, 601 },
    { IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim2D, 603 },
    { IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim2DArray, 605 },
    { IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim3D, 607 },
    { IMAGE_SAMPLE_CD_O_nortn, AMDGPUDimCube, 609 },
    { IMAGE_SAMPLE_CD_nortn, AMDGPUDim1D, 563 },
    { IMAGE_SAMPLE_CD_nortn, AMDGPUDim1DArray, 565 },
    { IMAGE_SAMPLE_CD_nortn, AMDGPUDim2D, 567 },
    { IMAGE_SAMPLE_CD_nortn, AMDGPUDim2DArray, 569 },
    { IMAGE_SAMPLE_CD_nortn, AMDGPUDim3D, 571 },
    { IMAGE_SAMPLE_CD_nortn, AMDGPUDimCube, 597 },
    { IMAGE_SAMPLE_CL, AMDGPUDim1D, 610 },
    { IMAGE_SAMPLE_CL, AMDGPUDim1DArray, 612 },
    { IMAGE_SAMPLE_CL, AMDGPUDim2D, 614 },
    { IMAGE_SAMPLE_CL, AMDGPUDim2DArray, 616 },
    { IMAGE_SAMPLE_CL, AMDGPUDim3D, 618 },
    { IMAGE_SAMPLE_CL, AMDGPUDimCube, 620 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim1D, 622 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim1DArray, 624 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim2D, 626 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim2DArray, 628 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim3D, 630 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDimCube, 632 },
    { IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim1D, 623 },
    { IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim1DArray, 625 },
    { IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim2D, 627 },
    { IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim2DArray, 629 },
    { IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim3D, 631 },
    { IMAGE_SAMPLE_CL_O_nortn, AMDGPUDimCube, 633 },
    { IMAGE_SAMPLE_CL_nortn, AMDGPUDim1D, 611 },
    { IMAGE_SAMPLE_CL_nortn, AMDGPUDim1DArray, 613 },
    { IMAGE_SAMPLE_CL_nortn, AMDGPUDim2D, 615 },
    { IMAGE_SAMPLE_CL_nortn, AMDGPUDim2DArray, 617 },
    { IMAGE_SAMPLE_CL_nortn, AMDGPUDim3D, 619 },
    { IMAGE_SAMPLE_CL_nortn, AMDGPUDimCube, 621 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim1D, 332 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim1DArray, 334 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim2D, 336 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim2DArray, 338 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim3D, 340 },
    { IMAGE_SAMPLE_C_B, AMDGPUDimCube, 366 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim1D, 342 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim1DArray, 344 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim2D, 346 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim2DArray, 348 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim3D, 350 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDimCube, 352 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1D, 354 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1DArray, 356 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2D, 358 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2DArray, 360 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim3D, 362 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDimCube, 364 },
    { IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim1D, 355 },
    { IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim1DArray, 357 },
    { IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim2D, 359 },
    { IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim2DArray, 361 },
    { IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim3D, 363 },
    { IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDimCube, 365 },
    { IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim1D, 343 },
    { IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim1DArray, 345 },
    { IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim2D, 347 },
    { IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim2DArray, 349 },
    { IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim3D, 351 },
    { IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDimCube, 353 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim1D, 368 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim1DArray, 370 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim2D, 372 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim2DArray, 374 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim3D, 376 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDimCube, 378 },
    { IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim1D, 369 },
    { IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim1DArray, 371 },
    { IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim2D, 373 },
    { IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim2DArray, 375 },
    { IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim3D, 377 },
    { IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDimCube, 379 },
    { IMAGE_SAMPLE_C_B_nortn, AMDGPUDim1D, 333 },
    { IMAGE_SAMPLE_C_B_nortn, AMDGPUDim1DArray, 335 },
    { IMAGE_SAMPLE_C_B_nortn, AMDGPUDim2D, 337 },
    { IMAGE_SAMPLE_C_B_nortn, AMDGPUDim2DArray, 339 },
    { IMAGE_SAMPLE_C_B_nortn, AMDGPUDim3D, 341 },
    { IMAGE_SAMPLE_C_B_nortn, AMDGPUDimCube, 367 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim1D, 380 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim1DArray, 382 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim2D, 384 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim2DArray, 386 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim3D, 388 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDimCube, 414 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1D, 390 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1DArray, 392 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2D, 394 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2DArray, 396 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim3D, 398 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDimCube, 400 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1D, 402 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1DArray, 404 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2D, 406 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2DArray, 408 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim3D, 410 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDimCube, 412 },
    { IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim1D, 403 },
    { IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim1DArray, 405 },
    { IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim2D, 407 },
    { IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim2DArray, 409 },
    { IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim3D, 411 },
    { IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDimCube, 413 },
    { IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim1D, 391 },
    { IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim1DArray, 393 },
    { IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim2D, 395 },
    { IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim2DArray, 397 },
    { IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim3D, 399 },
    { IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDimCube, 401 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim1D, 416 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim1DArray, 418 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim2D, 420 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim2DArray, 422 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim3D, 424 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDimCube, 426 },
    { IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim1D, 417 },
    { IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim1DArray, 419 },
    { IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim2D, 421 },
    { IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim2DArray, 423 },
    { IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim3D, 425 },
    { IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDimCube, 427 },
    { IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim1D, 381 },
    { IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim1DArray, 383 },
    { IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim2D, 385 },
    { IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim2DArray, 387 },
    { IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim3D, 389 },
    { IMAGE_SAMPLE_C_CD_nortn, AMDGPUDimCube, 415 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim1D, 428 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim1DArray, 430 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim2D, 432 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim2DArray, 434 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim3D, 436 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDimCube, 438 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim1D, 440 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim1DArray, 442 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim2D, 444 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim2DArray, 446 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim3D, 448 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDimCube, 450 },
    { IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim1D, 441 },
    { IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim1DArray, 443 },
    { IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim2D, 445 },
    { IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim2DArray, 447 },
    { IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim3D, 449 },
    { IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDimCube, 451 },
    { IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim1D, 429 },
    { IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim1DArray, 431 },
    { IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim2D, 433 },
    { IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim2DArray, 435 },
    { IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim3D, 437 },
    { IMAGE_SAMPLE_C_CL_nortn, AMDGPUDimCube, 439 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim1D, 454 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim1DArray, 456 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim2D, 458 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim2DArray, 460 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim3D, 462 },
    { IMAGE_SAMPLE_C_D, AMDGPUDimCube, 488 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim1D, 464 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim1DArray, 466 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim2D, 468 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim2DArray, 470 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim3D, 472 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDimCube, 474 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1D, 476 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1DArray, 478 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2D, 480 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2DArray, 482 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim3D, 484 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDimCube, 486 },
    { IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim1D, 477 },
    { IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim1DArray, 479 },
    { IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim2D, 481 },
    { IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim2DArray, 483 },
    { IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim3D, 485 },
    { IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDimCube, 487 },
    { IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim1D, 465 },
    { IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim1DArray, 467 },
    { IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim2D, 469 },
    { IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim2DArray, 471 },
    { IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim3D, 473 },
    { IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDimCube, 475 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim1D, 490 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim1DArray, 492 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim2D, 494 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim2DArray, 496 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim3D, 498 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDimCube, 500 },
    { IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim1D, 491 },
    { IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim1DArray, 493 },
    { IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim2D, 495 },
    { IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim2DArray, 497 },
    { IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim3D, 499 },
    { IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDimCube, 501 },
    { IMAGE_SAMPLE_C_D_nortn, AMDGPUDim1D, 455 },
    { IMAGE_SAMPLE_C_D_nortn, AMDGPUDim1DArray, 457 },
    { IMAGE_SAMPLE_C_D_nortn, AMDGPUDim2D, 459 },
    { IMAGE_SAMPLE_C_D_nortn, AMDGPUDim2DArray, 461 },
    { IMAGE_SAMPLE_C_D_nortn, AMDGPUDim3D, 463 },
    { IMAGE_SAMPLE_C_D_nortn, AMDGPUDimCube, 489 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim1D, 502 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim1DArray, 504 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim2D, 506 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim2DArray, 508 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim3D, 510 },
    { IMAGE_SAMPLE_C_L, AMDGPUDimCube, 512 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim1D, 526 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim1DArray, 528 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim2D, 530 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim2DArray, 532 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim3D, 534 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDimCube, 536 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1D, 538 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1DArray, 540 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2D, 542 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2DArray, 544 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim3D, 546 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDimCube, 548 },
    { IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim1D, 539 },
    { IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim1DArray, 541 },
    { IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim2D, 543 },
    { IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim2DArray, 545 },
    { IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim3D, 547 },
    { IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDimCube, 549 },
    { IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim1D, 527 },
    { IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim1DArray, 529 },
    { IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim2D, 531 },
    { IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim2DArray, 533 },
    { IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim3D, 535 },
    { IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDimCube, 537 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim1D, 514 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim1DArray, 516 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim2D, 518 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim2DArray, 520 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim3D, 522 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDimCube, 524 },
    { IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim1D, 515 },
    { IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim1DArray, 517 },
    { IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim2D, 519 },
    { IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim2DArray, 521 },
    { IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim3D, 523 },
    { IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDimCube, 525 },
    { IMAGE_SAMPLE_C_L_nortn, AMDGPUDim1D, 503 },
    { IMAGE_SAMPLE_C_L_nortn, AMDGPUDim1DArray, 505 },
    { IMAGE_SAMPLE_C_L_nortn, AMDGPUDim2D, 507 },
    { IMAGE_SAMPLE_C_L_nortn, AMDGPUDim2DArray, 509 },
    { IMAGE_SAMPLE_C_L_nortn, AMDGPUDim3D, 511 },
    { IMAGE_SAMPLE_C_L_nortn, AMDGPUDimCube, 513 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim1D, 550 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim1DArray, 552 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim2D, 554 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim2DArray, 556 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim3D, 558 },
    { IMAGE_SAMPLE_C_O, AMDGPUDimCube, 560 },
    { IMAGE_SAMPLE_C_O_nortn, AMDGPUDim1D, 551 },
    { IMAGE_SAMPLE_C_O_nortn, AMDGPUDim1DArray, 553 },
    { IMAGE_SAMPLE_C_O_nortn, AMDGPUDim2D, 555 },
    { IMAGE_SAMPLE_C_O_nortn, AMDGPUDim2DArray, 557 },
    { IMAGE_SAMPLE_C_O_nortn, AMDGPUDim3D, 559 },
    { IMAGE_SAMPLE_C_O_nortn, AMDGPUDimCube, 561 },
    { IMAGE_SAMPLE_C_nortn, AMDGPUDim1D, 323 },
    { IMAGE_SAMPLE_C_nortn, AMDGPUDim1DArray, 325 },
    { IMAGE_SAMPLE_C_nortn, AMDGPUDim2D, 327 },
    { IMAGE_SAMPLE_C_nortn, AMDGPUDim2DArray, 329 },
    { IMAGE_SAMPLE_C_nortn, AMDGPUDim3D, 331 },
    { IMAGE_SAMPLE_C_nortn, AMDGPUDimCube, 453 },
    { IMAGE_SAMPLE_D, AMDGPUDim1D, 636 },
    { IMAGE_SAMPLE_D, AMDGPUDim1DArray, 638 },
    { IMAGE_SAMPLE_D, AMDGPUDim2D, 640 },
    { IMAGE_SAMPLE_D, AMDGPUDim2DArray, 642 },
    { IMAGE_SAMPLE_D, AMDGPUDim3D, 644 },
    { IMAGE_SAMPLE_D, AMDGPUDimCube, 670 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim1D, 646 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim1DArray, 648 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim2D, 650 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim2DArray, 652 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim3D, 654 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDimCube, 656 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim1D, 658 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim1DArray, 660 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim2D, 662 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim2DArray, 664 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim3D, 666 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDimCube, 668 },
    { IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim1D, 659 },
    { IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim1DArray, 661 },
    { IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim2D, 663 },
    { IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim2DArray, 665 },
    { IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim3D, 667 },
    { IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDimCube, 669 },
    { IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim1D, 647 },
    { IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim1DArray, 649 },
    { IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim2D, 651 },
    { IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim2DArray, 653 },
    { IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim3D, 655 },
    { IMAGE_SAMPLE_D_CL_nortn, AMDGPUDimCube, 657 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim1D, 672 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim1DArray, 674 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim2D, 676 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim2DArray, 678 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim3D, 680 },
    { IMAGE_SAMPLE_D_O, AMDGPUDimCube, 682 },
    { IMAGE_SAMPLE_D_O_nortn, AMDGPUDim1D, 673 },
    { IMAGE_SAMPLE_D_O_nortn, AMDGPUDim1DArray, 675 },
    { IMAGE_SAMPLE_D_O_nortn, AMDGPUDim2D, 677 },
    { IMAGE_SAMPLE_D_O_nortn, AMDGPUDim2DArray, 679 },
    { IMAGE_SAMPLE_D_O_nortn, AMDGPUDim3D, 681 },
    { IMAGE_SAMPLE_D_O_nortn, AMDGPUDimCube, 683 },
    { IMAGE_SAMPLE_D_nortn, AMDGPUDim1D, 637 },
    { IMAGE_SAMPLE_D_nortn, AMDGPUDim1DArray, 639 },
    { IMAGE_SAMPLE_D_nortn, AMDGPUDim2D, 641 },
    { IMAGE_SAMPLE_D_nortn, AMDGPUDim2DArray, 643 },
    { IMAGE_SAMPLE_D_nortn, AMDGPUDim3D, 645 },
    { IMAGE_SAMPLE_D_nortn, AMDGPUDimCube, 671 },
    { IMAGE_SAMPLE_L, AMDGPUDim1D, 684 },
    { IMAGE_SAMPLE_L, AMDGPUDim1DArray, 686 },
    { IMAGE_SAMPLE_L, AMDGPUDim2D, 688 },
    { IMAGE_SAMPLE_L, AMDGPUDim2DArray, 690 },
    { IMAGE_SAMPLE_L, AMDGPUDim3D, 692 },
    { IMAGE_SAMPLE_L, AMDGPUDimCube, 694 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim1D, 708 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim1DArray, 710 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim2D, 712 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim2DArray, 714 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim3D, 716 },
    { IMAGE_SAMPLE_LZ, AMDGPUDimCube, 718 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim1D, 720 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim1DArray, 722 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim2D, 724 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim2DArray, 726 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim3D, 728 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDimCube, 730 },
    { IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim1D, 721 },
    { IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim1DArray, 723 },
    { IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim2D, 725 },
    { IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim2DArray, 727 },
    { IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim3D, 729 },
    { IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDimCube, 731 },
    { IMAGE_SAMPLE_LZ_nortn, AMDGPUDim1D, 709 },
    { IMAGE_SAMPLE_LZ_nortn, AMDGPUDim1DArray, 711 },
    { IMAGE_SAMPLE_LZ_nortn, AMDGPUDim2D, 713 },
    { IMAGE_SAMPLE_LZ_nortn, AMDGPUDim2DArray, 715 },
    { IMAGE_SAMPLE_LZ_nortn, AMDGPUDim3D, 717 },
    { IMAGE_SAMPLE_LZ_nortn, AMDGPUDimCube, 719 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim1D, 696 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim1DArray, 698 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim2D, 700 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim2DArray, 702 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim3D, 704 },
    { IMAGE_SAMPLE_L_O, AMDGPUDimCube, 706 },
    { IMAGE_SAMPLE_L_O_nortn, AMDGPUDim1D, 697 },
    { IMAGE_SAMPLE_L_O_nortn, AMDGPUDim1DArray, 699 },
    { IMAGE_SAMPLE_L_O_nortn, AMDGPUDim2D, 701 },
    { IMAGE_SAMPLE_L_O_nortn, AMDGPUDim2DArray, 703 },
    { IMAGE_SAMPLE_L_O_nortn, AMDGPUDim3D, 705 },
    { IMAGE_SAMPLE_L_O_nortn, AMDGPUDimCube, 707 },
    { IMAGE_SAMPLE_L_nortn, AMDGPUDim1D, 685 },
    { IMAGE_SAMPLE_L_nortn, AMDGPUDim1DArray, 687 },
    { IMAGE_SAMPLE_L_nortn, AMDGPUDim2D, 689 },
    { IMAGE_SAMPLE_L_nortn, AMDGPUDim2DArray, 691 },
    { IMAGE_SAMPLE_L_nortn, AMDGPUDim3D, 693 },
    { IMAGE_SAMPLE_L_nortn, AMDGPUDimCube, 695 },
    { IMAGE_SAMPLE_O, AMDGPUDim1D, 732 },
    { IMAGE_SAMPLE_O, AMDGPUDim1DArray, 734 },
    { IMAGE_SAMPLE_O, AMDGPUDim2D, 736 },
    { IMAGE_SAMPLE_O, AMDGPUDim2DArray, 738 },
    { IMAGE_SAMPLE_O, AMDGPUDim3D, 740 },
    { IMAGE_SAMPLE_O, AMDGPUDimCube, 742 },
    { IMAGE_SAMPLE_O_nortn, AMDGPUDim1D, 733 },
    { IMAGE_SAMPLE_O_nortn, AMDGPUDim1DArray, 735 },
    { IMAGE_SAMPLE_O_nortn, AMDGPUDim2D, 737 },
    { IMAGE_SAMPLE_O_nortn, AMDGPUDim2DArray, 739 },
    { IMAGE_SAMPLE_O_nortn, AMDGPUDim3D, 741 },
    { IMAGE_SAMPLE_O_nortn, AMDGPUDimCube, 743 },
    { IMAGE_SAMPLE_nortn, AMDGPUDim1D, 265 },
    { IMAGE_SAMPLE_nortn, AMDGPUDim1DArray, 267 },
    { IMAGE_SAMPLE_nortn, AMDGPUDim2D, 269 },
    { IMAGE_SAMPLE_nortn, AMDGPUDim2DArray, 271 },
    { IMAGE_SAMPLE_nortn, AMDGPUDim3D, 273 },
    { IMAGE_SAMPLE_nortn, AMDGPUDimCube, 635 },
    { IMAGE_STORE, AMDGPUDim1D, 744 },
    { IMAGE_STORE, AMDGPUDim1DArray, 745 },
    { IMAGE_STORE, AMDGPUDim2D, 746 },
    { IMAGE_STORE, AMDGPUDim2DArray, 747 },
    { IMAGE_STORE, AMDGPUDim2DArrayMsaa, 748 },
    { IMAGE_STORE, AMDGPUDim2DMsaa, 749 },
    { IMAGE_STORE, AMDGPUDim3D, 750 },
    { IMAGE_STORE, AMDGPUDimCube, 751 },
    { IMAGE_STORE_MIP, AMDGPUDim1D, 752 },
    { IMAGE_STORE_MIP, AMDGPUDim1DArray, 753 },
    { IMAGE_STORE_MIP, AMDGPUDim2D, 754 },
    { IMAGE_STORE_MIP, AMDGPUDim2DArray, 755 },
    { IMAGE_STORE_MIP, AMDGPUDim3D, 756 },
    { IMAGE_STORE_MIP, AMDGPUDimCube, 757 },
  };

  struct KeyType {
    unsigned BaseOpcode;
    unsigned Dim;
  };
  KeyType Key = {BaseOpcode, Dim};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      if ((unsigned)LHS.BaseOpcode < (unsigned)RHS.BaseOpcode)
        return true;
      if ((unsigned)LHS.BaseOpcode > (unsigned)RHS.BaseOpcode)
        return false;
      if ((unsigned)LHS.Dim < (unsigned)RHS.Dim)
        return true;
      if ((unsigned)LHS.Dim > (unsigned)RHS.Dim)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.BaseOpcode != Idx->BaseOpcode ||
      Key.Dim != Idx->Dim)
    return nullptr;

  return &ImageDimIntrinsicTable[Idx->_index];
}
#endif

#ifdef GET_MAIInstInfoTable_DECL
const MAIInstInfo *getMAIInstInfoHelper(unsigned Opcode);
#endif

#ifdef GET_MAIInstInfoTable_IMPL
constexpr MAIInstInfo MAIInstInfoTable[] = {
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f4_e64, false, true }, // 0
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f4_vgprcd_e64, false, true }, // 1
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f6_e64, false, true }, // 2
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f6_vgprcd_e64, false, true }, // 3
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f8_e64, false, true }, // 4
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f8_vgprcd_e64, false, true }, // 5
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f4_e64, false, true }, // 6
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f4_vgprcd_e64, false, true }, // 7
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f6_e64, false, true }, // 8
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f6_vgprcd_e64, false, true }, // 9
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f8_e64, false, true }, // 10
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f8_vgprcd_e64, false, true }, // 11
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f4_e64, false, true }, // 12
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f4_vgprcd_e64, false, true }, // 13
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f6_e64, false, true }, // 14
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f6_vgprcd_e64, false, true }, // 15
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f8_e64, false, true }, // 16
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f8_vgprcd_e64, false, true }, // 17
  { V_MFMA_F32_16X16X16BF16_1K_e64, false, true }, // 18
  { V_MFMA_F32_16X16X16BF16_1K_vgprcd_e64, false, true }, // 19
  { V_MFMA_F32_16X16X16F16_e64, false, true }, // 20
  { V_MFMA_F32_16X16X16F16_vgprcd_e64, false, true }, // 21
  { V_MFMA_F32_16X16X1F32_e64, false, false }, // 22
  { V_MFMA_F32_16X16X1F32_mac_e64, false, false }, // 23
  { V_MFMA_F32_16X16X1F32_mac_vgprcd_e64, false, false }, // 24
  { V_MFMA_F32_16X16X1F32_vgprcd_e64, false, false }, // 25
  { V_MFMA_F32_16X16X2BF16_e64, false, false }, // 26
  { V_MFMA_F32_16X16X2BF16_mac_e64, false, false }, // 27
  { V_MFMA_F32_16X16X2BF16_mac_vgprcd_e64, false, false }, // 28
  { V_MFMA_F32_16X16X2BF16_vgprcd_e64, false, false }, // 29
  { V_MFMA_F32_16X16X32_BF16_e64, false, true }, // 30
  { V_MFMA_F32_16X16X32_BF16_vgprcd_e64, false, true }, // 31
  { V_MFMA_F32_16X16X32_BF8_BF8_e64, false, true }, // 32
  { V_MFMA_F32_16X16X32_BF8_BF8_vgprcd_e64, false, true }, // 33
  { V_MFMA_F32_16X16X32_BF8_FP8_e64, false, true }, // 34
  { V_MFMA_F32_16X16X32_BF8_FP8_vgprcd_e64, false, true }, // 35
  { V_MFMA_F32_16X16X32_F16_e64, false, true }, // 36
  { V_MFMA_F32_16X16X32_F16_vgprcd_e64, false, true }, // 37
  { V_MFMA_F32_16X16X32_FP8_BF8_e64, false, true }, // 38
  { V_MFMA_F32_16X16X32_FP8_BF8_vgprcd_e64, false, true }, // 39
  { V_MFMA_F32_16X16X32_FP8_FP8_e64, false, true }, // 40
  { V_MFMA_F32_16X16X32_FP8_FP8_vgprcd_e64, false, true }, // 41
  { V_MFMA_F32_16X16X4BF16_1K_e64, false, true }, // 42
  { V_MFMA_F32_16X16X4BF16_1K_mac_e64, false, true }, // 43
  { V_MFMA_F32_16X16X4BF16_1K_mac_vgprcd_e64, false, true }, // 44
  { V_MFMA_F32_16X16X4BF16_1K_vgprcd_e64, false, true }, // 45
  { V_MFMA_F32_16X16X4F16_e64, false, true }, // 46
  { V_MFMA_F32_16X16X4F16_mac_e64, false, true }, // 47
  { V_MFMA_F32_16X16X4F16_mac_vgprcd_e64, false, true }, // 48
  { V_MFMA_F32_16X16X4F16_vgprcd_e64, false, true }, // 49
  { V_MFMA_F32_16X16X4F32_e64, false, false }, // 50
  { V_MFMA_F32_16X16X4F32_vgprcd_e64, false, false }, // 51
  { V_MFMA_F32_16X16X8BF16_e64, false, false }, // 52
  { V_MFMA_F32_16X16X8BF16_vgprcd_e64, false, false }, // 53
  { V_MFMA_F32_16X16X8XF32_e64, false, true }, // 54
  { V_MFMA_F32_16X16X8XF32_vgprcd_e64, false, true }, // 55
  { V_MFMA_F32_32X32X16_BF16_e64, false, true }, // 56
  { V_MFMA_F32_32X32X16_BF16_mac_e64, false, true }, // 57
  { V_MFMA_F32_32X32X16_BF16_mac_vgprcd_e64, false, true }, // 58
  { V_MFMA_F32_32X32X16_BF16_vgprcd_e64, false, true }, // 59
  { V_MFMA_F32_32X32X16_BF8_BF8_e64, false, true }, // 60
  { V_MFMA_F32_32X32X16_BF8_BF8_mac_e64, false, true }, // 61
  { V_MFMA_F32_32X32X16_BF8_BF8_mac_vgprcd_e64, false, true }, // 62
  { V_MFMA_F32_32X32X16_BF8_BF8_vgprcd_e64, false, true }, // 63
  { V_MFMA_F32_32X32X16_BF8_FP8_e64, false, true }, // 64
  { V_MFMA_F32_32X32X16_BF8_FP8_mac_e64, false, true }, // 65
  { V_MFMA_F32_32X32X16_BF8_FP8_mac_vgprcd_e64, false, true }, // 66
  { V_MFMA_F32_32X32X16_BF8_FP8_vgprcd_e64, false, true }, // 67
  { V_MFMA_F32_32X32X16_F16_e64, false, true }, // 68
  { V_MFMA_F32_32X32X16_F16_mac_e64, false, true }, // 69
  { V_MFMA_F32_32X32X16_F16_mac_vgprcd_e64, false, true }, // 70
  { V_MFMA_F32_32X32X16_F16_vgprcd_e64, false, true }, // 71
  { V_MFMA_F32_32X32X16_FP8_BF8_e64, false, true }, // 72
  { V_MFMA_F32_32X32X16_FP8_BF8_mac_e64, false, true }, // 73
  { V_MFMA_F32_32X32X16_FP8_BF8_mac_vgprcd_e64, false, true }, // 74
  { V_MFMA_F32_32X32X16_FP8_BF8_vgprcd_e64, false, true }, // 75
  { V_MFMA_F32_32X32X16_FP8_FP8_e64, false, true }, // 76
  { V_MFMA_F32_32X32X16_FP8_FP8_mac_e64, false, true }, // 77
  { V_MFMA_F32_32X32X16_FP8_FP8_mac_vgprcd_e64, false, true }, // 78
  { V_MFMA_F32_32X32X16_FP8_FP8_vgprcd_e64, false, true }, // 79
  { V_MFMA_F32_32X32X1F32_e64, false, false }, // 80
  { V_MFMA_F32_32X32X1F32_mac_e64, false, false }, // 81
  { V_MFMA_F32_32X32X1F32_mac_vgprcd_e64, false, false }, // 82
  { V_MFMA_F32_32X32X1F32_vgprcd_e64, false, false }, // 83
  { V_MFMA_F32_32X32X2BF16_e64, false, false }, // 84
  { V_MFMA_F32_32X32X2BF16_mac_e64, false, false }, // 85
  { V_MFMA_F32_32X32X2BF16_mac_vgprcd_e64, false, false }, // 86
  { V_MFMA_F32_32X32X2BF16_vgprcd_e64, false, false }, // 87
  { V_MFMA_F32_32X32X2F32_e64, false, false }, // 88
  { V_MFMA_F32_32X32X2F32_mac_e64, false, false }, // 89
  { V_MFMA_F32_32X32X2F32_mac_vgprcd_e64, false, false }, // 90
  { V_MFMA_F32_32X32X2F32_vgprcd_e64, false, false }, // 91
  { V_MFMA_F32_32X32X4BF16_1K_e64, false, true }, // 92
  { V_MFMA_F32_32X32X4BF16_1K_mac_e64, false, true }, // 93
  { V_MFMA_F32_32X32X4BF16_1K_mac_vgprcd_e64, false, true }, // 94
  { V_MFMA_F32_32X32X4BF16_1K_vgprcd_e64, false, true }, // 95
  { V_MFMA_F32_32X32X4BF16_e64, false, false }, // 96
  { V_MFMA_F32_32X32X4BF16_mac_e64, false, false }, // 97
  { V_MFMA_F32_32X32X4BF16_mac_vgprcd_e64, false, false }, // 98
  { V_MFMA_F32_32X32X4BF16_vgprcd_e64, false, false }, // 99
  { V_MFMA_F32_32X32X4F16_e64, false, true }, // 100
  { V_MFMA_F32_32X32X4F16_mac_e64, false, true }, // 101
  { V_MFMA_F32_32X32X4F16_mac_vgprcd_e64, false, true }, // 102
  { V_MFMA_F32_32X32X4F16_vgprcd_e64, false, true }, // 103
  { V_MFMA_F32_32X32X4XF32_e64, false, true }, // 104
  { V_MFMA_F32_32X32X4XF32_mac_e64, false, true }, // 105
  { V_MFMA_F32_32X32X4XF32_mac_vgprcd_e64, false, true }, // 106
  { V_MFMA_F32_32X32X4XF32_vgprcd_e64, false, true }, // 107
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_e64, false, true }, // 108
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_mac_e64, false, true }, // 109
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_mac_vgprcd_e64, false, true }, // 110
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_vgprcd_e64, false, true }, // 111
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_e64, false, true }, // 112
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_mac_e64, false, true }, // 113
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_mac_vgprcd_e64, false, true }, // 114
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_vgprcd_e64, false, true }, // 115
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_e64, false, true }, // 116
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_mac_e64, false, true }, // 117
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_mac_vgprcd_e64, false, true }, // 118
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_vgprcd_e64, false, true }, // 119
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_e64, false, true }, // 120
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_mac_e64, false, true }, // 121
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_mac_vgprcd_e64, false, true }, // 122
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_vgprcd_e64, false, true }, // 123
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_e64, false, true }, // 124
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_mac_e64, false, true }, // 125
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_mac_vgprcd_e64, false, true }, // 126
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_vgprcd_e64, false, true }, // 127
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_e64, false, true }, // 128
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_mac_e64, false, true }, // 129
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_mac_vgprcd_e64, false, true }, // 130
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_vgprcd_e64, false, true }, // 131
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_e64, false, true }, // 132
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_mac_e64, false, true }, // 133
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_mac_vgprcd_e64, false, true }, // 134
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_vgprcd_e64, false, true }, // 135
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_e64, false, true }, // 136
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_mac_e64, false, true }, // 137
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_mac_vgprcd_e64, false, true }, // 138
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_vgprcd_e64, false, true }, // 139
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_e64, false, true }, // 140
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_mac_e64, false, true }, // 141
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_mac_vgprcd_e64, false, true }, // 142
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_vgprcd_e64, false, true }, // 143
  { V_MFMA_F32_32X32X8BF16_1K_e64, false, true }, // 144
  { V_MFMA_F32_32X32X8BF16_1K_mac_e64, false, true }, // 145
  { V_MFMA_F32_32X32X8BF16_1K_mac_vgprcd_e64, false, true }, // 146
  { V_MFMA_F32_32X32X8BF16_1K_vgprcd_e64, false, true }, // 147
  { V_MFMA_F32_32X32X8F16_e64, false, true }, // 148
  { V_MFMA_F32_32X32X8F16_mac_e64, false, true }, // 149
  { V_MFMA_F32_32X32X8F16_mac_vgprcd_e64, false, true }, // 150
  { V_MFMA_F32_32X32X8F16_vgprcd_e64, false, true }, // 151
  { V_MFMA_F32_4X4X1F32_e64, false, false }, // 152
  { V_MFMA_F32_4X4X1F32_vgprcd_e64, false, false }, // 153
  { V_MFMA_F32_4X4X2BF16_e64, false, false }, // 154
  { V_MFMA_F32_4X4X2BF16_vgprcd_e64, false, false }, // 155
  { V_MFMA_F32_4X4X4BF16_1K_e64, false, true }, // 156
  { V_MFMA_F32_4X4X4BF16_1K_vgprcd_e64, false, true }, // 157
  { V_MFMA_F32_4X4X4F16_e64, false, true }, // 158
  { V_MFMA_F32_4X4X4F16_vgprcd_e64, false, true }, // 159
  { V_MFMA_F64_16X16X4F64_e64, true, false }, // 160
  { V_MFMA_F64_16X16X4F64_mac_e64, true, false }, // 161
  { V_MFMA_F64_16X16X4F64_mac_vgprcd_e64, true, false }, // 162
  { V_MFMA_F64_16X16X4F64_vgprcd_e64, true, false }, // 163
  { V_MFMA_F64_4X4X4F64_e64, true, false }, // 164
  { V_MFMA_F64_4X4X4F64_vgprcd_e64, true, false }, // 165
  { V_MFMA_I32_16X16X16I8_e64, false, false }, // 166
  { V_MFMA_I32_16X16X16I8_vgprcd_e64, false, false }, // 167
  { V_MFMA_I32_16X16X32I8_e64, false, true }, // 168
  { V_MFMA_I32_16X16X32I8_vgprcd_e64, false, true }, // 169
  { V_MFMA_I32_16X16X4I8_e64, false, true }, // 170
  { V_MFMA_I32_16X16X4I8_mac_e64, false, true }, // 171
  { V_MFMA_I32_16X16X4I8_mac_vgprcd_e64, false, true }, // 172
  { V_MFMA_I32_16X16X4I8_vgprcd_e64, false, true }, // 173
  { V_MFMA_I32_16X16X64_I8_e64, false, true }, // 174
  { V_MFMA_I32_16X16X64_I8_vgprcd_e64, false, true }, // 175
  { V_MFMA_I32_32X32X16I8_e64, false, true }, // 176
  { V_MFMA_I32_32X32X16I8_mac_e64, false, true }, // 177
  { V_MFMA_I32_32X32X16I8_mac_vgprcd_e64, false, true }, // 178
  { V_MFMA_I32_32X32X16I8_vgprcd_e64, false, true }, // 179
  { V_MFMA_I32_32X32X32_I8_e64, false, true }, // 180
  { V_MFMA_I32_32X32X32_I8_mac_e64, false, true }, // 181
  { V_MFMA_I32_32X32X32_I8_mac_vgprcd_e64, false, true }, // 182
  { V_MFMA_I32_32X32X32_I8_vgprcd_e64, false, true }, // 183
  { V_MFMA_I32_32X32X4I8_e64, false, true }, // 184
  { V_MFMA_I32_32X32X4I8_mac_e64, false, true }, // 185
  { V_MFMA_I32_32X32X4I8_mac_vgprcd_e64, false, true }, // 186
  { V_MFMA_I32_32X32X4I8_vgprcd_e64, false, true }, // 187
  { V_MFMA_I32_32X32X8I8_e64, false, false }, // 188
  { V_MFMA_I32_32X32X8I8_mac_e64, false, false }, // 189
  { V_MFMA_I32_32X32X8I8_mac_vgprcd_e64, false, false }, // 190
  { V_MFMA_I32_32X32X8I8_vgprcd_e64, false, false }, // 191
  { V_MFMA_I32_4X4X4I8_e64, false, true }, // 192
  { V_MFMA_I32_4X4X4I8_vgprcd_e64, false, true }, // 193
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f4_e64, false, true }, // 194
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f4_vgprcd_e64, false, true }, // 195
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f6_e64, false, true }, // 196
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f6_vgprcd_e64, false, true }, // 197
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f8_e64, false, true }, // 198
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f8_vgprcd_e64, false, true }, // 199
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f4_e64, false, true }, // 200
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f4_vgprcd_e64, false, true }, // 201
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f6_e64, false, true }, // 202
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f6_vgprcd_e64, false, true }, // 203
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f8_e64, false, true }, // 204
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f8_vgprcd_e64, false, true }, // 205
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f4_e64, false, true }, // 206
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f4_vgprcd_e64, false, true }, // 207
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f6_e64, false, true }, // 208
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f6_vgprcd_e64, false, true }, // 209
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f8_e64, false, true }, // 210
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f8_vgprcd_e64, false, true }, // 211
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_e64, false, true }, // 212
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_mac_e64, false, true }, // 213
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_mac_vgprcd_e64, false, true }, // 214
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_vgprcd_e64, false, true }, // 215
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_e64, false, true }, // 216
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_mac_e64, false, true }, // 217
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_mac_vgprcd_e64, false, true }, // 218
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_vgprcd_e64, false, true }, // 219
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_e64, false, true }, // 220
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_mac_e64, false, true }, // 221
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_mac_vgprcd_e64, false, true }, // 222
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_vgprcd_e64, false, true }, // 223
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_e64, false, true }, // 224
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_mac_e64, false, true }, // 225
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_mac_vgprcd_e64, false, true }, // 226
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_vgprcd_e64, false, true }, // 227
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_e64, false, true }, // 228
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_mac_e64, false, true }, // 229
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_mac_vgprcd_e64, false, true }, // 230
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_vgprcd_e64, false, true }, // 231
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_e64, false, true }, // 232
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_mac_e64, false, true }, // 233
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_mac_vgprcd_e64, false, true }, // 234
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_vgprcd_e64, false, true }, // 235
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_e64, false, true }, // 236
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_mac_e64, false, true }, // 237
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_mac_vgprcd_e64, false, true }, // 238
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_vgprcd_e64, false, true }, // 239
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_e64, false, true }, // 240
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_mac_e64, false, true }, // 241
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_mac_vgprcd_e64, false, true }, // 242
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_vgprcd_e64, false, true }, // 243
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_e64, false, true }, // 244
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_mac_e64, false, true }, // 245
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_mac_vgprcd_e64, false, true }, // 246
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_vgprcd_e64, false, true }, // 247
  { V_SMFMAC_F32_16X16X128_BF8_BF8_e64, false, true }, // 248
  { V_SMFMAC_F32_16X16X128_BF8_FP8_e64, false, true }, // 249
  { V_SMFMAC_F32_16X16X128_FP8_BF8_e64, false, true }, // 250
  { V_SMFMAC_F32_16X16X128_FP8_FP8_e64, false, true }, // 251
  { V_SMFMAC_F32_16X16X32_BF16_e64, false, true }, // 252
  { V_SMFMAC_F32_16X16X32_F16_e64, false, true }, // 253
  { V_SMFMAC_F32_16X16X64_BF16_e64, false, true }, // 254
  { V_SMFMAC_F32_16X16X64_BF8_BF8_e64, false, true }, // 255
  { V_SMFMAC_F32_16X16X64_BF8_FP8_e64, false, true }, // 256
  { V_SMFMAC_F32_16X16X64_F16_e64, false, true }, // 257
  { V_SMFMAC_F32_16X16X64_FP8_BF8_e64, false, true }, // 258
  { V_SMFMAC_F32_16X16X64_FP8_FP8_e64, false, true }, // 259
  { V_SMFMAC_F32_32X32X16_BF16_e64, false, true }, // 260
  { V_SMFMAC_F32_32X32X16_F16_e64, false, true }, // 261
  { V_SMFMAC_F32_32X32X32_BF16_e64, false, true }, // 262
  { V_SMFMAC_F32_32X32X32_BF8_BF8_e64, false, true }, // 263
  { V_SMFMAC_F32_32X32X32_BF8_FP8_e64, false, true }, // 264
  { V_SMFMAC_F32_32X32X32_F16_e64, false, true }, // 265
  { V_SMFMAC_F32_32X32X32_FP8_BF8_e64, false, true }, // 266
  { V_SMFMAC_F32_32X32X32_FP8_FP8_e64, false, true }, // 267
  { V_SMFMAC_F32_32X32X64_BF8_BF8_e64, false, true }, // 268
  { V_SMFMAC_F32_32X32X64_BF8_FP8_e64, false, true }, // 269
  { V_SMFMAC_F32_32X32X64_FP8_BF8_e64, false, true }, // 270
  { V_SMFMAC_F32_32X32X64_FP8_FP8_e64, false, true }, // 271
  { V_SMFMAC_I32_16X16X128_I8_e64, false, true }, // 272
  { V_SMFMAC_I32_16X16X64_I8_e64, false, true }, // 273
  { V_SMFMAC_I32_32X32X32_I8_e64, false, true }, // 274
  { V_SMFMAC_I32_32X32X64_I8_e64, false, true }, // 275
 };

const MAIInstInfo *getMAIInstInfoHelper(unsigned Opcode) {
  struct KeyType {
    unsigned Opcode;
  };
  KeyType Key = {Opcode};
  struct Comp {
    bool operator()(const MAIInstInfo &LHS, const KeyType &RHS) const {
      if (LHS.Opcode < RHS.Opcode)
        return true;
      if (LHS.Opcode > RHS.Opcode)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(MAIInstInfoTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Opcode != Idx->Opcode)
    return nullptr;

  return &*Idx;
}
#endif

#ifdef GET_MIMGBaseOpcodesTable_DECL
const MIMGBaseOpcodeInfo *getMIMGBaseOpcodeInfo(unsigned BaseOpcode);
#endif

#ifdef GET_MIMGBaseOpcodesTable_IMPL
constexpr MIMGBaseOpcodeInfo MIMGBaseOpcodesTable[] = {
  { IMAGE_ATOMIC_ADD, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 0
  { IMAGE_ATOMIC_ADD_FLT, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 1
  { IMAGE_ATOMIC_AND, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 2
  { IMAGE_ATOMIC_CMPSWAP, false, true, true, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 3
  { IMAGE_ATOMIC_DEC, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 4
  { IMAGE_ATOMIC_FCMPSWAP, false, true, true, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 5
  { IMAGE_ATOMIC_FMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 6
  { IMAGE_ATOMIC_FMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 7
  { IMAGE_ATOMIC_INC, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 8
  { IMAGE_ATOMIC_MAX_FLT, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 9
  { IMAGE_ATOMIC_MIN_FLT, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 10
  { IMAGE_ATOMIC_OR, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 11
  { IMAGE_ATOMIC_PK_ADD_BF16, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 12
  { IMAGE_ATOMIC_PK_ADD_F16, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 13
  { IMAGE_ATOMIC_RSUB, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 14
  { IMAGE_ATOMIC_SMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 15
  { IMAGE_ATOMIC_SMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 16
  { IMAGE_ATOMIC_SUB, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 17
  { IMAGE_ATOMIC_SWAP, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 18
  { IMAGE_ATOMIC_UMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 19
  { IMAGE_ATOMIC_UMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 20
  { IMAGE_ATOMIC_XOR, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 21
  { IMAGE_BVH64_INTERSECT_RAY, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, false, false }, // 22
  { IMAGE_BVH64_INTERSECT_RAY_a16, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, true, false }, // 23
  { IMAGE_BVH_INTERSECT_RAY, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, false, false }, // 24
  { IMAGE_BVH_INTERSECT_RAY_a16, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, true, false }, // 25
  { IMAGE_GATHER4, false, false, false, true, true, 0x0, false, false, true, false, true, false, false, false, false }, // 26
  { IMAGE_GATHER4H, false, false, false, true, true, 0x0, false, false, true, false, true, false, false, false, false }, // 27
  { IMAGE_GATHER4_B, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false, false }, // 28
  { IMAGE_GATHER4_B_CL, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false, false }, // 29
  { IMAGE_GATHER4_B_CL_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false, false }, // 30
  { IMAGE_GATHER4_B_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false, false }, // 31
  { IMAGE_GATHER4_C, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false, false }, // 32
  { IMAGE_GATHER4_CL, false, false, false, true, true, 0x0, false, false, true, true, true, false, false, false, false }, // 33
  { IMAGE_GATHER4_CL_O, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false, false }, // 34
  { IMAGE_GATHER4_C_B, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false, false }, // 35
  { IMAGE_GATHER4_C_B_CL, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false, false }, // 36
  { IMAGE_GATHER4_C_B_CL_O, false, false, false, true, true, 0x3, false, false, true, true, true, false, false, false, false }, // 37
  { IMAGE_GATHER4_C_B_O, false, false, false, true, true, 0x3, false, false, true, false, true, false, false, false, false }, // 38
  { IMAGE_GATHER4_C_CL, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false, false }, // 39
  { IMAGE_GATHER4_C_CL_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false, false }, // 40
  { IMAGE_GATHER4_C_L, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false, false }, // 41
  { IMAGE_GATHER4_C_LZ, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false, false }, // 42
  { IMAGE_GATHER4_C_LZ_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false, false }, // 43
  { IMAGE_GATHER4_C_L_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false, false }, // 44
  { IMAGE_GATHER4_C_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false, false }, // 45
  { IMAGE_GATHER4_L, false, false, false, true, true, 0x0, false, false, true, true, true, false, false, false, false }, // 46
  { IMAGE_GATHER4_LZ, false, false, false, true, true, 0x0, false, false, true, false, true, false, false, false, false }, // 47
  { IMAGE_GATHER4_LZ_O, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false, false }, // 48
  { IMAGE_GATHER4_L_O, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false, false }, // 49
  { IMAGE_GATHER4_O, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false, false }, // 50
  { IMAGE_GET_LOD, false, false, false, true, false, 0x0, false, false, true, false, false, false, false, false, false }, // 51
  { IMAGE_GET_RESINFO, false, false, false, false, false, 0x0, false, false, false, true, false, false, false, false, false }, // 52
  { IMAGE_LOAD, false, false, false, false, false, 0x0, false, false, true, false, true, false, false, false, false }, // 53
  { IMAGE_LOAD_MIP, false, false, false, false, false, 0x0, false, false, true, true, true, false, false, false, false }, // 54
  { IMAGE_LOAD_MIP_PCK, false, false, false, false, false, 0x0, false, false, true, true, false, false, false, false, false }, // 55
  { IMAGE_LOAD_MIP_PCK_SGN, false, false, false, false, false, 0x0, false, false, true, true, false, false, false, false, false }, // 56
  { IMAGE_LOAD_PCK, false, false, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 57
  { IMAGE_LOAD_PCK_SGN, false, false, false, false, false, 0x0, false, false, true, false, false, false, false, false, false }, // 58
  { IMAGE_MSAA_LOAD, false, false, false, false, true, 0x0, false, false, true, false, true, true, false, false, false }, // 59
  { IMAGE_MSAA_LOAD_X, false, false, false, false, false, 0x0, false, false, true, false, true, true, false, false, false }, // 60
  { IMAGE_SAMPLE, false, false, false, true, false, 0x0, false, false, true, false, true, false, false, false, false }, // 61
  { IMAGE_SAMPLE_B, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, false }, // 62
  { IMAGE_SAMPLE_B_CL, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, false }, // 63
  { IMAGE_SAMPLE_B_CL_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, false }, // 64
  { IMAGE_SAMPLE_B_CL_O_nortn, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, true }, // 65
  { IMAGE_SAMPLE_B_CL_nortn, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, true }, // 66
  { IMAGE_SAMPLE_B_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, false }, // 67
  { IMAGE_SAMPLE_B_O_nortn, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, true }, // 68
  { IMAGE_SAMPLE_B_nortn, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, true }, // 69
  { IMAGE_SAMPLE_C, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, false }, // 70
  { IMAGE_SAMPLE_CD, false, false, false, true, false, 0x0, true, false, true, false, true, false, false, false, false }, // 71
  { IMAGE_SAMPLE_CD_CL, false, false, false, true, false, 0x0, true, false, true, true, true, false, false, false, false }, // 72
  { IMAGE_SAMPLE_CD_CL_G16, false, false, false, true, false, 0x0, true, true, true, true, true, false, false, false, false }, // 73
  { IMAGE_SAMPLE_CD_CL_G16_nortn, false, false, false, true, false, 0x0, true, true, true, true, true, false, false, false, true }, // 74
  { IMAGE_SAMPLE_CD_CL_O, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, false }, // 75
  { IMAGE_SAMPLE_CD_CL_O_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, false }, // 76
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, true }, // 77
  { IMAGE_SAMPLE_CD_CL_O_nortn, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, true }, // 78
  { IMAGE_SAMPLE_CD_CL_nortn, false, false, false, true, false, 0x0, true, false, true, true, true, false, false, false, true }, // 79
  { IMAGE_SAMPLE_CD_G16, false, false, false, true, false, 0x0, true, true, true, false, true, false, false, false, false }, // 80
  { IMAGE_SAMPLE_CD_G16_nortn, false, false, false, true, false, 0x0, true, true, true, false, true, false, false, false, true }, // 81
  { IMAGE_SAMPLE_CD_O, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, false }, // 82
  { IMAGE_SAMPLE_CD_O_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, false }, // 83
  { IMAGE_SAMPLE_CD_O_G16_nortn, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, true }, // 84
  { IMAGE_SAMPLE_CD_O_nortn, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, true }, // 85
  { IMAGE_SAMPLE_CD_nortn, false, false, false, true, false, 0x0, true, false, true, false, true, false, false, false, true }, // 86
  { IMAGE_SAMPLE_CL, false, false, false, true, false, 0x0, false, false, true, true, true, false, false, false, false }, // 87
  { IMAGE_SAMPLE_CL_O, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, false }, // 88
  { IMAGE_SAMPLE_CL_O_nortn, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, true }, // 89
  { IMAGE_SAMPLE_CL_nortn, false, false, false, true, false, 0x0, false, false, true, true, true, false, false, false, true }, // 90
  { IMAGE_SAMPLE_C_B, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, false }, // 91
  { IMAGE_SAMPLE_C_B_CL, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, false }, // 92
  { IMAGE_SAMPLE_C_B_CL_O, false, false, false, true, false, 0x3, false, false, true, true, true, false, false, false, false }, // 93
  { IMAGE_SAMPLE_C_B_CL_O_nortn, false, false, false, true, false, 0x3, false, false, true, true, true, false, false, false, true }, // 94
  { IMAGE_SAMPLE_C_B_CL_nortn, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, true }, // 95
  { IMAGE_SAMPLE_C_B_O, false, false, false, true, false, 0x3, false, false, true, false, true, false, false, false, false }, // 96
  { IMAGE_SAMPLE_C_B_O_nortn, false, false, false, true, false, 0x3, false, false, true, false, true, false, false, false, true }, // 97
  { IMAGE_SAMPLE_C_B_nortn, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, true }, // 98
  { IMAGE_SAMPLE_C_CD, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, false }, // 99
  { IMAGE_SAMPLE_C_CD_CL, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, false }, // 100
  { IMAGE_SAMPLE_C_CD_CL_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, false }, // 101
  { IMAGE_SAMPLE_C_CD_CL_G16_nortn, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, true }, // 102
  { IMAGE_SAMPLE_C_CD_CL_O, false, false, false, true, false, 0x2, true, false, true, true, true, false, false, false, false }, // 103
  { IMAGE_SAMPLE_C_CD_CL_O_G16, false, false, false, true, false, 0x2, true, true, true, true, true, false, false, false, false }, // 104
  { IMAGE_SAMPLE_C_CD_CL_O_G16_nortn, false, false, false, true, false, 0x2, true, true, true, true, true, false, false, false, true }, // 105
  { IMAGE_SAMPLE_C_CD_CL_O_nortn, false, false, false, true, false, 0x2, true, false, true, true, true, false, false, false, true }, // 106
  { IMAGE_SAMPLE_C_CD_CL_nortn, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, true }, // 107
  { IMAGE_SAMPLE_C_CD_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, false }, // 108
  { IMAGE_SAMPLE_C_CD_G16_nortn, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, true }, // 109
  { IMAGE_SAMPLE_C_CD_O, false, false, false, true, false, 0x2, true, false, true, false, true, false, false, false, false }, // 110
  { IMAGE_SAMPLE_C_CD_O_G16, false, false, false, true, false, 0x2, true, true, true, false, true, false, false, false, false }, // 111
  { IMAGE_SAMPLE_C_CD_O_G16_nortn, false, false, false, true, false, 0x2, true, true, true, false, true, false, false, false, true }, // 112
  { IMAGE_SAMPLE_C_CD_O_nortn, false, false, false, true, false, 0x2, true, false, true, false, true, false, false, false, true }, // 113
  { IMAGE_SAMPLE_C_CD_nortn, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, true }, // 114
  { IMAGE_SAMPLE_C_CL, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, false }, // 115
  { IMAGE_SAMPLE_C_CL_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, false }, // 116
  { IMAGE_SAMPLE_C_CL_O_nortn, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, true }, // 117
  { IMAGE_SAMPLE_C_CL_nortn, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, true }, // 118
  { IMAGE_SAMPLE_C_D, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, false }, // 119
  { IMAGE_SAMPLE_C_D_CL, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, false }, // 120
  { IMAGE_SAMPLE_C_D_CL_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, false }, // 121
  { IMAGE_SAMPLE_C_D_CL_G16_nortn, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, true }, // 122
  { IMAGE_SAMPLE_C_D_CL_O, false, false, false, true, false, 0x2, true, false, true, true, true, false, false, false, false }, // 123
  { IMAGE_SAMPLE_C_D_CL_O_G16, false, false, false, true, false, 0x2, true, true, true, true, true, false, false, false, false }, // 124
  { IMAGE_SAMPLE_C_D_CL_O_G16_nortn, false, false, false, true, false, 0x2, true, true, true, true, true, false, false, false, true }, // 125
  { IMAGE_SAMPLE_C_D_CL_O_nortn, false, false, false, true, false, 0x2, true, false, true, true, true, false, false, false, true }, // 126
  { IMAGE_SAMPLE_C_D_CL_nortn, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, true }, // 127
  { IMAGE_SAMPLE_C_D_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, false }, // 128
  { IMAGE_SAMPLE_C_D_G16_nortn, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, true }, // 129
  { IMAGE_SAMPLE_C_D_O, false, false, false, true, false, 0x2, true, false, true, false, true, false, false, false, false }, // 130
  { IMAGE_SAMPLE_C_D_O_G16, false, false, false, true, false, 0x2, true, true, true, false, true, false, false, false, false }, // 131
  { IMAGE_SAMPLE_C_D_O_G16_nortn, false, false, false, true, false, 0x2, true, true, true, false, true, false, false, false, true }, // 132
  { IMAGE_SAMPLE_C_D_O_nortn, false, false, false, true, false, 0x2, true, false, true, false, true, false, false, false, true }, // 133
  { IMAGE_SAMPLE_C_D_nortn, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, true }, // 134
  { IMAGE_SAMPLE_C_L, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, false }, // 135
  { IMAGE_SAMPLE_C_LZ, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, false }, // 136
  { IMAGE_SAMPLE_C_LZ_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, false }, // 137
  { IMAGE_SAMPLE_C_LZ_O_nortn, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, true }, // 138
  { IMAGE_SAMPLE_C_LZ_nortn, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, true }, // 139
  { IMAGE_SAMPLE_C_L_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, false }, // 140
  { IMAGE_SAMPLE_C_L_O_nortn, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, true }, // 141
  { IMAGE_SAMPLE_C_L_nortn, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, true }, // 142
  { IMAGE_SAMPLE_C_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, false }, // 143
  { IMAGE_SAMPLE_C_O_nortn, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, true }, // 144
  { IMAGE_SAMPLE_C_nortn, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, true }, // 145
  { IMAGE_SAMPLE_D, false, false, false, true, false, 0x0, true, false, true, false, true, false, false, false, false }, // 146
  { IMAGE_SAMPLE_D_CL, false, false, false, true, false, 0x0, true, false, true, true, true, false, false, false, false }, // 147
  { IMAGE_SAMPLE_D_CL_G16, false, false, false, true, false, 0x0, true, true, true, true, true, false, false, false, false }, // 148
  { IMAGE_SAMPLE_D_CL_G16_nortn, false, false, false, true, false, 0x0, true, true, true, true, true, false, false, false, true }, // 149
  { IMAGE_SAMPLE_D_CL_O, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, false }, // 150
  { IMAGE_SAMPLE_D_CL_O_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, false }, // 151
  { IMAGE_SAMPLE_D_CL_O_G16_nortn, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, true }, // 152
  { IMAGE_SAMPLE_D_CL_O_nortn, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, true }, // 153
  { IMAGE_SAMPLE_D_CL_nortn, false, false, false, true, false, 0x0, true, false, true, true, true, false, false, false, true }, // 154
  { IMAGE_SAMPLE_D_G16, false, false, false, true, false, 0x0, true, true, true, false, true, false, false, false, false }, // 155
  { IMAGE_SAMPLE_D_G16_nortn, false, false, false, true, false, 0x0, true, true, true, false, true, false, false, false, true }, // 156
  { IMAGE_SAMPLE_D_O, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, false }, // 157
  { IMAGE_SAMPLE_D_O_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, false }, // 158
  { IMAGE_SAMPLE_D_O_G16_nortn, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, true }, // 159
  { IMAGE_SAMPLE_D_O_nortn, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, true }, // 160
  { IMAGE_SAMPLE_D_nortn, false, false, false, true, false, 0x0, true, false, true, false, true, false, false, false, true }, // 161
  { IMAGE_SAMPLE_L, false, false, false, true, false, 0x0, false, false, true, true, true, false, false, false, false }, // 162
  { IMAGE_SAMPLE_LZ, false, false, false, true, false, 0x0, false, false, true, false, true, false, false, false, false }, // 163
  { IMAGE_SAMPLE_LZ_O, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, false }, // 164
  { IMAGE_SAMPLE_LZ_O_nortn, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, true }, // 165
  { IMAGE_SAMPLE_LZ_nortn, false, false, false, true, false, 0x0, false, false, true, false, true, false, false, false, true }, // 166
  { IMAGE_SAMPLE_L_O, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, false }, // 167
  { IMAGE_SAMPLE_L_O_nortn, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, true }, // 168
  { IMAGE_SAMPLE_L_nortn, false, false, false, true, false, 0x0, false, false, true, true, true, false, false, false, true }, // 169
  { IMAGE_SAMPLE_O, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, false }, // 170
  { IMAGE_SAMPLE_O_nortn, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, true }, // 171
  { IMAGE_SAMPLE_nortn, false, false, false, true, false, 0x0, false, false, true, false, true, false, false, false, true }, // 172
  { IMAGE_STORE, true, false, false, false, false, 0x0, false, false, true, false, true, false, false, false, true }, // 173
  { IMAGE_STORE_MIP, true, false, false, false, false, 0x0, false, false, true, true, true, false, false, false, true }, // 174
  { IMAGE_STORE_MIP_PCK, true, false, false, false, false, 0x0, false, false, true, true, false, false, false, false, true }, // 175
  { IMAGE_STORE_PCK, true, false, false, false, false, 0x0, false, false, true, false, false, false, false, false, true }, // 176
 };

const MIMGBaseOpcodeInfo *getMIMGBaseOpcodeInfo(unsigned BaseOpcode) {
  if ((BaseOpcode < IMAGE_ATOMIC_ADD) ||
      (BaseOpcode > IMAGE_STORE_PCK))
    return nullptr;
  auto Table = ArrayRef(MIMGBaseOpcodesTable);
  size_t Idx = BaseOpcode - IMAGE_ATOMIC_ADD;
  return &Table[Idx];
}
#endif

#ifdef GET_MIMGBiasMappingTable_DECL
const MIMGBiasMappingInfo *getMIMGBiasMappingInfo(unsigned Bias);
#endif

#ifdef GET_MIMGBiasMappingTable_IMPL
constexpr MIMGBiasMappingInfo MIMGBiasMappingTable[] = {
  { IMAGE_GATHER4_B, IMAGE_GATHER4 }, // 0
  { IMAGE_GATHER4_B_CL, IMAGE_GATHER4_CL }, // 1
  { IMAGE_GATHER4_B_CL_O, IMAGE_GATHER4_CL_O }, // 2
  { IMAGE_GATHER4_B_O, IMAGE_GATHER4_O }, // 3
  { IMAGE_GATHER4_C_B, IMAGE_GATHER4_C }, // 4
  { IMAGE_GATHER4_C_B_CL, IMAGE_GATHER4_C_CL }, // 5
  { IMAGE_GATHER4_C_B_CL_O, IMAGE_GATHER4_C_CL_O }, // 6
  { IMAGE_GATHER4_C_B_O, IMAGE_GATHER4_C_O }, // 7
  { IMAGE_SAMPLE_B, IMAGE_SAMPLE }, // 8
  { IMAGE_SAMPLE_B_CL, IMAGE_SAMPLE_CL }, // 9
  { IMAGE_SAMPLE_B_CL_O, IMAGE_SAMPLE_CL_O }, // 10
  { IMAGE_SAMPLE_B_CL_O_nortn, IMAGE_SAMPLE_CL_O_nortn }, // 11
  { IMAGE_SAMPLE_B_CL_nortn, IMAGE_SAMPLE_CL_nortn }, // 12
  { IMAGE_SAMPLE_B_O, IMAGE_SAMPLE_O }, // 13
  { IMAGE_SAMPLE_B_O_nortn, IMAGE_SAMPLE_O_nortn }, // 14
  { IMAGE_SAMPLE_B_nortn, IMAGE_SAMPLE_nortn }, // 15
  { IMAGE_SAMPLE_C_B, IMAGE_SAMPLE_C }, // 16
  { IMAGE_SAMPLE_C_B_CL, IMAGE_SAMPLE_C_CL }, // 17
  { IMAGE_SAMPLE_C_B_CL_O, IMAGE_SAMPLE_C_CL_O }, // 18
  { IMAGE_SAMPLE_C_B_CL_O_nortn, IMAGE_SAMPLE_C_CL_O_nortn }, // 19
  { IMAGE_SAMPLE_C_B_CL_nortn, IMAGE_SAMPLE_C_CL_nortn }, // 20
  { IMAGE_SAMPLE_C_B_O, IMAGE_SAMPLE_C_O }, // 21
  { IMAGE_SAMPLE_C_B_O_nortn, IMAGE_SAMPLE_C_O_nortn }, // 22
  { IMAGE_SAMPLE_C_B_nortn, IMAGE_SAMPLE_C_nortn }, // 23
 };

const MIMGBiasMappingInfo *getMIMGBiasMappingInfo(unsigned Bias) {
  struct KeyType {
    unsigned Bias;
  };
  KeyType Key = {Bias};
  struct Comp {
    bool operator()(const MIMGBiasMappingInfo &LHS, const KeyType &RHS) const {
      if ((unsigned)LHS.Bias < (unsigned)RHS.Bias)
        return true;
      if ((unsigned)LHS.Bias > (unsigned)RHS.Bias)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(MIMGBiasMappingTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Bias != Idx->Bias)
    return nullptr;

  return &*Idx;
}
#endif

#ifdef GET_MIMGDimInfoTable_DECL
const MIMGDimInfo *getMIMGDimInfo(unsigned Dim);
const MIMGDimInfo *getMIMGDimInfoByAsmSuffix(StringRef AsmSuffix);
const MIMGDimInfo *getMIMGDimInfoByEncoding(uint8_t Encoding);
#endif

#ifdef GET_MIMGDimInfoTable_IMPL
constexpr MIMGDimInfo MIMGDimInfoTable[] = {
  { AMDGPUDim1D, 0x1, 0x2, false, false, 0x0, "1D" }, // 0
  { AMDGPUDim1DArray, 0x2, 0x2, false, true, 0x4, "1D_ARRAY" }, // 1
  { AMDGPUDim2D, 0x2, 0x4, false, false, 0x1, "2D" }, // 2
  { AMDGPUDim2DArray, 0x3, 0x4, false, true, 0x5, "2D_ARRAY" }, // 3
  { AMDGPUDim2DArrayMsaa, 0x4, 0x4, true, true, 0x7, "2D_MSAA_ARRAY" }, // 4
  { AMDGPUDim2DMsaa, 0x3, 0x4, true, false, 0x6, "2D_MSAA" }, // 5
  { AMDGPUDim3D, 0x3, 0x6, false, false, 0x2, "3D" }, // 6
  { AMDGPUDimCube, 0x3, 0x4, false, true, 0x3, "CUBE" }, // 7
 };

const MIMGDimInfo *getMIMGDimInfo(unsigned Dim) {
  if ((Dim < AMDGPUDim1D) ||
      (Dim > AMDGPUDimCube))
    return nullptr;
  auto Table = ArrayRef(MIMGDimInfoTable);
  size_t Idx = Dim - AMDGPUDim1D;
  return &Table[Idx];
}

const MIMGDimInfo *getMIMGDimInfoByAsmSuffix(StringRef AsmSuffix) {
  struct IndexType {
    const char * AsmSuffix;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "1D", 0 },
    { "1D_ARRAY", 1 },
    { "2D", 2 },
    { "2D_ARRAY", 3 },
    { "2D_MSAA", 5 },
    { "2D_MSAA_ARRAY", 4 },
    { "3D", 6 },
    { "CUBE", 7 },
  };

  struct KeyType {
    std::string AsmSuffix;
  };
  KeyType Key = {AsmSuffix.upper()};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpAsmSuffix = StringRef(LHS.AsmSuffix).compare(RHS.AsmSuffix);
      if (CmpAsmSuffix < 0) return true;
      if (CmpAsmSuffix > 0) return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.AsmSuffix != Idx->AsmSuffix)
    return nullptr;

  return &MIMGDimInfoTable[Idx->_index];
}

const MIMGDimInfo *getMIMGDimInfoByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 0 },
    { 0x1, 2 },
    { 0x2, 6 },
    { 0x3, 7 },
    { 0x4, 1 },
    { 0x5, 3 },
    { 0x6, 5 },
    { 0x7, 4 },
  };

  if ((Encoding < 0x0) ||
      (Encoding > 0x7))
    return nullptr;
  auto Table = ArrayRef(Index);
  size_t Idx = Encoding - 0x0;
  return &MIMGDimInfoTable[Table[Idx]._index];
}
#endif

#ifdef GET_MIMGG16MappingTable_DECL
const MIMGG16MappingInfo *getMIMGG16MappingInfo(unsigned G);
#endif

#ifdef GET_MIMGG16MappingTable_IMPL
constexpr MIMGG16MappingInfo MIMGG16MappingTable[] = {
  { IMAGE_SAMPLE_CD, IMAGE_SAMPLE_CD_G16 }, // 0
  { IMAGE_SAMPLE_CD_CL, IMAGE_SAMPLE_CD_CL_G16 }, // 1
  { IMAGE_SAMPLE_CD_CL_O, IMAGE_SAMPLE_CD_CL_O_G16 }, // 2
  { IMAGE_SAMPLE_CD_CL_O_nortn, IMAGE_SAMPLE_CD_CL_O_G16_nortn }, // 3
  { IMAGE_SAMPLE_CD_CL_nortn, IMAGE_SAMPLE_CD_CL_G16_nortn }, // 4
  { IMAGE_SAMPLE_CD_O, IMAGE_SAMPLE_CD_O_G16 }, // 5
  { IMAGE_SAMPLE_CD_O_nortn, IMAGE_SAMPLE_CD_O_G16_nortn }, // 6
  { IMAGE_SAMPLE_CD_nortn, IMAGE_SAMPLE_CD_G16_nortn }, // 7
  { IMAGE_SAMPLE_C_CD, IMAGE_SAMPLE_C_CD_G16 }, // 8
  { IMAGE_SAMPLE_C_CD_CL, IMAGE_SAMPLE_C_CD_CL_G16 }, // 9
  { IMAGE_SAMPLE_C_CD_CL_O, IMAGE_SAMPLE_C_CD_CL_O_G16 }, // 10
  { IMAGE_SAMPLE_C_CD_CL_O_nortn, IMAGE_SAMPLE_C_CD_CL_O_G16_nortn }, // 11
  { IMAGE_SAMPLE_C_CD_CL_nortn, IMAGE_SAMPLE_C_CD_CL_G16_nortn }, // 12
  { IMAGE_SAMPLE_C_CD_O, IMAGE_SAMPLE_C_CD_O_G16 }, // 13
  { IMAGE_SAMPLE_C_CD_O_nortn, IMAGE_SAMPLE_C_CD_O_G16_nortn }, // 14
  { IMAGE_SAMPLE_C_CD_nortn, IMAGE_SAMPLE_C_CD_G16_nortn }, // 15
  { IMAGE_SAMPLE_C_D, IMAGE_SAMPLE_C_D_G16 }, // 16
  { IMAGE_SAMPLE_C_D_CL, IMAGE_SAMPLE_C_D_CL_G16 }, // 17
  { IMAGE_SAMPLE_C_D_CL_O, IMAGE_SAMPLE_C_D_CL_O_G16 }, // 18
  { IMAGE_SAMPLE_C_D_CL_O_nortn, IMAGE_SAMPLE_C_D_CL_O_G16_nortn }, // 19
  { IMAGE_SAMPLE_C_D_CL_nortn, IMAGE_SAMPLE_C_D_CL_G16_nortn }, // 20
  { IMAGE_SAMPLE_C_D_O, IMAGE_SAMPLE_C_D_O_G16 }, // 21
  { IMAGE_SAMPLE_C_D_O_nortn, IMAGE_SAMPLE_C_D_O_G16_nortn }, // 22
  { IMAGE_SAMPLE_C_D_nortn, IMAGE_SAMPLE_C_D_G16_nortn }, // 23
  { IMAGE_SAMPLE_D, IMAGE_SAMPLE_D_G16 }, // 24
  { IMAGE_SAMPLE_D_CL, IMAGE_SAMPLE_D_CL_G16 }, // 25
  { IMAGE_SAMPLE_D_CL_O, IMAGE_SAMPLE_D_CL_O_G16 }, // 26
  { IMAGE_SAMPLE_D_CL_O_nortn, IMAGE_SAMPLE_D_CL_O_G16_nortn }, // 27
  { IMAGE_SAMPLE_D_CL_nortn, IMAGE_SAMPLE_D_CL_G16_nortn }, // 28
  { IMAGE_SAMPLE_D_O, IMAGE_SAMPLE_D_O_G16 }, // 29
  { IMAGE_SAMPLE_D_O_nortn, IMAGE_SAMPLE_D_O_G16_nortn }, // 30
  { IMAGE_SAMPLE_D_nortn, IMAGE_SAMPLE_D_G16_nortn }, // 31
 };

const MIMGG16MappingInfo *getMIMGG16MappingInfo(unsigned G) {
  struct KeyType {
    unsigned G;
  };
  KeyType Key = {G};
  struct Comp {
    bool operator()(const MIMGG16MappingInfo &LHS, const KeyType &RHS) const {
      if ((unsigned)LHS.G < (unsigned)RHS.G)
        return true;
      if ((unsigned)LHS.G > (unsigned)RHS.G)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(MIMGG16MappingTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.G != Idx->G)
    return nullptr;

  return &*Idx;
}
#endif

#ifdef GET_MIMGInfoTable_DECL
const MIMGInfo *getMIMGOpcodeHelper(unsigned BaseOpcode, unsigned MIMGEncoding, uint8_t VDataDwords, uint8_t VAddrDwords);
const MIMGInfo *getMIMGInfo(unsigned Opcode);
#endif

#ifdef GET_MIMGInfoTable_IMPL
constexpr MIMGInfo MIMGInfoTable[] = {
  { IMAGE_ATOMIC_ADD_V1_V1_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 0
  { IMAGE_ATOMIC_ADD_V1_V2_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1
  { IMAGE_ATOMIC_ADD_V1_V3_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2
  { IMAGE_ATOMIC_ADD_V1_V4_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3
  { IMAGE_ATOMIC_ADD_V2_V1_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 4
  { IMAGE_ATOMIC_ADD_V3_V1_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 5
  { IMAGE_ATOMIC_ADD_V2_V2_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 6
  { IMAGE_ATOMIC_ADD_V3_V2_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 7
  { IMAGE_ATOMIC_ADD_V2_V3_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 8
  { IMAGE_ATOMIC_ADD_V3_V3_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 9
  { IMAGE_ATOMIC_ADD_V2_V4_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 10
  { IMAGE_ATOMIC_ADD_V3_V4_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 11
  { IMAGE_ATOMIC_ADD_V4_V1_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 12
  { IMAGE_ATOMIC_ADD_V4_V2_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 13
  { IMAGE_ATOMIC_ADD_V4_V3_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 14
  { IMAGE_ATOMIC_ADD_V4_V4_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 15
  { IMAGE_ATOMIC_ADD_V1_V2_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 16
  { IMAGE_ATOMIC_ADD_V1_V3_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 17
  { IMAGE_ATOMIC_ADD_V1_V4_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 18
  { IMAGE_ATOMIC_ADD_V2_V2_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 19
  { IMAGE_ATOMIC_ADD_V3_V2_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 20
  { IMAGE_ATOMIC_ADD_V2_V3_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 21
  { IMAGE_ATOMIC_ADD_V3_V3_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 22
  { IMAGE_ATOMIC_ADD_V2_V4_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 23
  { IMAGE_ATOMIC_ADD_V3_V4_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 24
  { IMAGE_ATOMIC_ADD_V4_V2_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 25
  { IMAGE_ATOMIC_ADD_V4_V3_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 26
  { IMAGE_ATOMIC_ADD_V4_V4_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 27
  { IMAGE_ATOMIC_ADD_V1_V1_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 28
  { IMAGE_ATOMIC_ADD_V1_V2_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 29
  { IMAGE_ATOMIC_ADD_V1_V3_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 30
  { IMAGE_ATOMIC_ADD_V1_V4_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 31
  { IMAGE_ATOMIC_ADD_V2_V1_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 32
  { IMAGE_ATOMIC_ADD_V3_V1_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 33
  { IMAGE_ATOMIC_ADD_V2_V2_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 34
  { IMAGE_ATOMIC_ADD_V3_V2_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 35
  { IMAGE_ATOMIC_ADD_V2_V3_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 36
  { IMAGE_ATOMIC_ADD_V3_V3_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 37
  { IMAGE_ATOMIC_ADD_V2_V4_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 38
  { IMAGE_ATOMIC_ADD_V3_V4_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 39
  { IMAGE_ATOMIC_ADD_V4_V1_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 40
  { IMAGE_ATOMIC_ADD_V4_V2_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 41
  { IMAGE_ATOMIC_ADD_V4_V3_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 42
  { IMAGE_ATOMIC_ADD_V4_V4_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 43
  { IMAGE_ATOMIC_ADD_V1_V2_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 44
  { IMAGE_ATOMIC_ADD_V1_V3_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 45
  { IMAGE_ATOMIC_ADD_V1_V4_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 46
  { IMAGE_ATOMIC_ADD_V2_V2_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 47
  { IMAGE_ATOMIC_ADD_V3_V2_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 48
  { IMAGE_ATOMIC_ADD_V2_V3_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 49
  { IMAGE_ATOMIC_ADD_V3_V3_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 50
  { IMAGE_ATOMIC_ADD_V2_V4_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 51
  { IMAGE_ATOMIC_ADD_V3_V4_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 52
  { IMAGE_ATOMIC_ADD_V4_V2_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 53
  { IMAGE_ATOMIC_ADD_V4_V3_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 54
  { IMAGE_ATOMIC_ADD_V4_V4_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 55
  { IMAGE_ATOMIC_ADD_V1_V1_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 56
  { IMAGE_ATOMIC_ADD_V1_V2_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 57
  { IMAGE_ATOMIC_ADD_V1_V3_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 58
  { IMAGE_ATOMIC_ADD_V1_V4_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 59
  { IMAGE_ATOMIC_ADD_V2_V1_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 60
  { IMAGE_ATOMIC_ADD_V3_V1_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 61
  { IMAGE_ATOMIC_ADD_V2_V2_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 62
  { IMAGE_ATOMIC_ADD_V3_V2_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 63
  { IMAGE_ATOMIC_ADD_V2_V3_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 64
  { IMAGE_ATOMIC_ADD_V3_V3_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 65
  { IMAGE_ATOMIC_ADD_V2_V4_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 66
  { IMAGE_ATOMIC_ADD_V3_V4_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 67
  { IMAGE_ATOMIC_ADD_V4_V1_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 68
  { IMAGE_ATOMIC_ADD_V4_V2_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 69
  { IMAGE_ATOMIC_ADD_V4_V3_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 70
  { IMAGE_ATOMIC_ADD_V4_V4_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 71
  { IMAGE_ATOMIC_ADD_V1_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 72
  { IMAGE_ATOMIC_ADD_V1_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 73
  { IMAGE_ATOMIC_ADD_V1_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 74
  { IMAGE_ATOMIC_ADD_V1_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 75
  { IMAGE_ATOMIC_ADD_V2_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 76
  { IMAGE_ATOMIC_ADD_V3_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 77
  { IMAGE_ATOMIC_ADD_V2_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 78
  { IMAGE_ATOMIC_ADD_V3_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 79
  { IMAGE_ATOMIC_ADD_V2_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 80
  { IMAGE_ATOMIC_ADD_V3_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 81
  { IMAGE_ATOMIC_ADD_V2_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 82
  { IMAGE_ATOMIC_ADD_V3_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 83
  { IMAGE_ATOMIC_ADD_V4_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 84
  { IMAGE_ATOMIC_ADD_V4_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 85
  { IMAGE_ATOMIC_ADD_V4_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 86
  { IMAGE_ATOMIC_ADD_V4_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 87
  { IMAGE_ATOMIC_ADD_V1_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 88
  { IMAGE_ATOMIC_ADD_V1_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 89
  { IMAGE_ATOMIC_ADD_V1_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 90
  { IMAGE_ATOMIC_ADD_V1_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 91
  { IMAGE_ATOMIC_ADD_V2_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 92
  { IMAGE_ATOMIC_ADD_V3_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 93
  { IMAGE_ATOMIC_ADD_V2_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 94
  { IMAGE_ATOMIC_ADD_V3_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 95
  { IMAGE_ATOMIC_ADD_V2_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 96
  { IMAGE_ATOMIC_ADD_V3_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 97
  { IMAGE_ATOMIC_ADD_V2_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 98
  { IMAGE_ATOMIC_ADD_V3_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 99
  { IMAGE_ATOMIC_ADD_V4_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 100
  { IMAGE_ATOMIC_ADD_V4_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 101
  { IMAGE_ATOMIC_ADD_V4_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 102
  { IMAGE_ATOMIC_ADD_V4_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 103
  { IMAGE_ATOMIC_ADD_V1_V1_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 104
  { IMAGE_ATOMIC_ADD_V1_V2_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 105
  { IMAGE_ATOMIC_ADD_V1_V3_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 106
  { IMAGE_ATOMIC_ADD_V1_V4_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 107
  { IMAGE_ATOMIC_ADD_V2_V1_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 108
  { IMAGE_ATOMIC_ADD_V3_V1_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 109
  { IMAGE_ATOMIC_ADD_V2_V2_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 110
  { IMAGE_ATOMIC_ADD_V3_V2_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 111
  { IMAGE_ATOMIC_ADD_V2_V3_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 112
  { IMAGE_ATOMIC_ADD_V3_V3_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 113
  { IMAGE_ATOMIC_ADD_V2_V4_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 114
  { IMAGE_ATOMIC_ADD_V3_V4_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 115
  { IMAGE_ATOMIC_ADD_V4_V1_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 116
  { IMAGE_ATOMIC_ADD_V4_V2_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 117
  { IMAGE_ATOMIC_ADD_V4_V3_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 118
  { IMAGE_ATOMIC_ADD_V4_V4_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 119
  { IMAGE_ATOMIC_ADD_FLT_V1_V1_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 120
  { IMAGE_ATOMIC_ADD_FLT_V1_V2_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 121
  { IMAGE_ATOMIC_ADD_FLT_V1_V3_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 122
  { IMAGE_ATOMIC_ADD_FLT_V1_V4_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 123
  { IMAGE_ATOMIC_ADD_FLT_V2_V1_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 124
  { IMAGE_ATOMIC_ADD_FLT_V3_V1_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 125
  { IMAGE_ATOMIC_ADD_FLT_V2_V2_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 126
  { IMAGE_ATOMIC_ADD_FLT_V3_V2_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 127
  { IMAGE_ATOMIC_ADD_FLT_V2_V3_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 128
  { IMAGE_ATOMIC_ADD_FLT_V3_V3_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 129
  { IMAGE_ATOMIC_ADD_FLT_V2_V4_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 130
  { IMAGE_ATOMIC_ADD_FLT_V3_V4_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 131
  { IMAGE_ATOMIC_ADD_FLT_V4_V1_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 132
  { IMAGE_ATOMIC_ADD_FLT_V4_V2_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 133
  { IMAGE_ATOMIC_ADD_FLT_V4_V3_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 134
  { IMAGE_ATOMIC_ADD_FLT_V4_V4_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 135
  { IMAGE_ATOMIC_AND_V1_V1_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 136
  { IMAGE_ATOMIC_AND_V1_V2_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 137
  { IMAGE_ATOMIC_AND_V1_V3_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 138
  { IMAGE_ATOMIC_AND_V1_V4_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 139
  { IMAGE_ATOMIC_AND_V2_V1_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 140
  { IMAGE_ATOMIC_AND_V3_V1_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 141
  { IMAGE_ATOMIC_AND_V2_V2_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 142
  { IMAGE_ATOMIC_AND_V3_V2_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 143
  { IMAGE_ATOMIC_AND_V2_V3_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 144
  { IMAGE_ATOMIC_AND_V3_V3_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 145
  { IMAGE_ATOMIC_AND_V2_V4_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 146
  { IMAGE_ATOMIC_AND_V3_V4_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 147
  { IMAGE_ATOMIC_AND_V4_V1_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 148
  { IMAGE_ATOMIC_AND_V4_V2_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 149
  { IMAGE_ATOMIC_AND_V4_V3_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 150
  { IMAGE_ATOMIC_AND_V4_V4_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 151
  { IMAGE_ATOMIC_AND_V1_V2_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 152
  { IMAGE_ATOMIC_AND_V1_V3_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 153
  { IMAGE_ATOMIC_AND_V1_V4_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 154
  { IMAGE_ATOMIC_AND_V2_V2_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 155
  { IMAGE_ATOMIC_AND_V3_V2_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 156
  { IMAGE_ATOMIC_AND_V2_V3_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 157
  { IMAGE_ATOMIC_AND_V3_V3_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 158
  { IMAGE_ATOMIC_AND_V2_V4_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 159
  { IMAGE_ATOMIC_AND_V3_V4_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 160
  { IMAGE_ATOMIC_AND_V4_V2_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 161
  { IMAGE_ATOMIC_AND_V4_V3_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 162
  { IMAGE_ATOMIC_AND_V4_V4_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 163
  { IMAGE_ATOMIC_AND_V1_V1_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 164
  { IMAGE_ATOMIC_AND_V1_V2_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 165
  { IMAGE_ATOMIC_AND_V1_V3_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 166
  { IMAGE_ATOMIC_AND_V1_V4_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 167
  { IMAGE_ATOMIC_AND_V2_V1_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 168
  { IMAGE_ATOMIC_AND_V3_V1_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 169
  { IMAGE_ATOMIC_AND_V2_V2_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 170
  { IMAGE_ATOMIC_AND_V3_V2_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 171
  { IMAGE_ATOMIC_AND_V2_V3_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 172
  { IMAGE_ATOMIC_AND_V3_V3_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 173
  { IMAGE_ATOMIC_AND_V2_V4_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 174
  { IMAGE_ATOMIC_AND_V3_V4_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 175
  { IMAGE_ATOMIC_AND_V4_V1_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 176
  { IMAGE_ATOMIC_AND_V4_V2_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 177
  { IMAGE_ATOMIC_AND_V4_V3_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 178
  { IMAGE_ATOMIC_AND_V4_V4_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 179
  { IMAGE_ATOMIC_AND_V1_V2_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 180
  { IMAGE_ATOMIC_AND_V1_V3_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 181
  { IMAGE_ATOMIC_AND_V1_V4_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 182
  { IMAGE_ATOMIC_AND_V2_V2_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 183
  { IMAGE_ATOMIC_AND_V3_V2_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 184
  { IMAGE_ATOMIC_AND_V2_V3_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 185
  { IMAGE_ATOMIC_AND_V3_V3_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 186
  { IMAGE_ATOMIC_AND_V2_V4_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 187
  { IMAGE_ATOMIC_AND_V3_V4_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 188
  { IMAGE_ATOMIC_AND_V4_V2_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 189
  { IMAGE_ATOMIC_AND_V4_V3_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 190
  { IMAGE_ATOMIC_AND_V4_V4_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 191
  { IMAGE_ATOMIC_AND_V1_V1_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 192
  { IMAGE_ATOMIC_AND_V1_V2_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 193
  { IMAGE_ATOMIC_AND_V1_V3_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 194
  { IMAGE_ATOMIC_AND_V1_V4_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 195
  { IMAGE_ATOMIC_AND_V2_V1_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 196
  { IMAGE_ATOMIC_AND_V3_V1_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 197
  { IMAGE_ATOMIC_AND_V2_V2_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 198
  { IMAGE_ATOMIC_AND_V3_V2_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 199
  { IMAGE_ATOMIC_AND_V2_V3_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 200
  { IMAGE_ATOMIC_AND_V3_V3_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 201
  { IMAGE_ATOMIC_AND_V2_V4_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 202
  { IMAGE_ATOMIC_AND_V3_V4_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 203
  { IMAGE_ATOMIC_AND_V4_V1_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 204
  { IMAGE_ATOMIC_AND_V4_V2_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 205
  { IMAGE_ATOMIC_AND_V4_V3_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 206
  { IMAGE_ATOMIC_AND_V4_V4_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 207
  { IMAGE_ATOMIC_AND_V1_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 208
  { IMAGE_ATOMIC_AND_V1_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 209
  { IMAGE_ATOMIC_AND_V1_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 210
  { IMAGE_ATOMIC_AND_V1_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 211
  { IMAGE_ATOMIC_AND_V2_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 212
  { IMAGE_ATOMIC_AND_V3_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 213
  { IMAGE_ATOMIC_AND_V2_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 214
  { IMAGE_ATOMIC_AND_V3_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 215
  { IMAGE_ATOMIC_AND_V2_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 216
  { IMAGE_ATOMIC_AND_V3_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 217
  { IMAGE_ATOMIC_AND_V2_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 218
  { IMAGE_ATOMIC_AND_V3_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 219
  { IMAGE_ATOMIC_AND_V4_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 220
  { IMAGE_ATOMIC_AND_V4_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 221
  { IMAGE_ATOMIC_AND_V4_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 222
  { IMAGE_ATOMIC_AND_V4_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 223
  { IMAGE_ATOMIC_AND_V1_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 224
  { IMAGE_ATOMIC_AND_V1_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 225
  { IMAGE_ATOMIC_AND_V1_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 226
  { IMAGE_ATOMIC_AND_V1_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 227
  { IMAGE_ATOMIC_AND_V2_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 228
  { IMAGE_ATOMIC_AND_V3_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 229
  { IMAGE_ATOMIC_AND_V2_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 230
  { IMAGE_ATOMIC_AND_V3_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 231
  { IMAGE_ATOMIC_AND_V2_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 232
  { IMAGE_ATOMIC_AND_V3_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 233
  { IMAGE_ATOMIC_AND_V2_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 234
  { IMAGE_ATOMIC_AND_V3_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 235
  { IMAGE_ATOMIC_AND_V4_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 236
  { IMAGE_ATOMIC_AND_V4_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 237
  { IMAGE_ATOMIC_AND_V4_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 238
  { IMAGE_ATOMIC_AND_V4_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 239
  { IMAGE_ATOMIC_AND_V1_V1_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 240
  { IMAGE_ATOMIC_AND_V1_V2_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 241
  { IMAGE_ATOMIC_AND_V1_V3_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 242
  { IMAGE_ATOMIC_AND_V1_V4_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 243
  { IMAGE_ATOMIC_AND_V2_V1_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 244
  { IMAGE_ATOMIC_AND_V3_V1_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 245
  { IMAGE_ATOMIC_AND_V2_V2_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 246
  { IMAGE_ATOMIC_AND_V3_V2_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 247
  { IMAGE_ATOMIC_AND_V2_V3_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 248
  { IMAGE_ATOMIC_AND_V3_V3_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 249
  { IMAGE_ATOMIC_AND_V2_V4_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 250
  { IMAGE_ATOMIC_AND_V3_V4_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 251
  { IMAGE_ATOMIC_AND_V4_V1_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 252
  { IMAGE_ATOMIC_AND_V4_V2_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 253
  { IMAGE_ATOMIC_AND_V4_V3_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 254
  { IMAGE_ATOMIC_AND_V4_V4_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 255
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 256
  { IMAGE_ATOMIC_CMPSWAP_V3_V1_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 257
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 258
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 259
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 260
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 261
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 262
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 263
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 264
  { IMAGE_ATOMIC_CMPSWAP_V4_V1_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 265
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 266
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 267
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 268
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 269
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 270
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 271
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 272
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 273
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 274
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 275
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 276
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 277
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 278
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 279
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 280
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 281
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 282
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 283
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 284
  { IMAGE_ATOMIC_CMPSWAP_V3_V1_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 285
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 286
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 287
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 288
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 289
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 290
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 291
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 292
  { IMAGE_ATOMIC_CMPSWAP_V4_V1_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 293
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 294
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 295
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 296
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 297
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 298
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 299
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 300
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 301
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 302
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 303
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 304
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 305
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 306
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 307
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 308
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 309
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 310
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 311
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 312
  { IMAGE_ATOMIC_CMPSWAP_V3_V1_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 313
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 314
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 315
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 316
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 317
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 318
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 319
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 320
  { IMAGE_ATOMIC_CMPSWAP_V4_V1_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 321
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 322
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 323
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 324
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 325
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 326
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 327
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 328
  { IMAGE_ATOMIC_CMPSWAP_V3_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 329
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 330
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 331
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 332
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 333
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 334
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 335
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 336
  { IMAGE_ATOMIC_CMPSWAP_V4_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 337
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 338
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 339
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 340
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 341
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 342
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 343
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 344
  { IMAGE_ATOMIC_CMPSWAP_V3_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 345
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 346
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 347
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 348
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 349
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 350
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 351
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 352
  { IMAGE_ATOMIC_CMPSWAP_V4_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 353
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 354
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 355
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 356
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 357
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 358
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 359
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 360
  { IMAGE_ATOMIC_CMPSWAP_V3_V1_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 361
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 362
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 363
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 364
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 365
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 366
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 367
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 368
  { IMAGE_ATOMIC_CMPSWAP_V4_V1_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 369
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 370
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 371
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 372
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 373
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 374
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 375
  { IMAGE_ATOMIC_DEC_V1_V1_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 376
  { IMAGE_ATOMIC_DEC_V1_V2_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 377
  { IMAGE_ATOMIC_DEC_V1_V3_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 378
  { IMAGE_ATOMIC_DEC_V1_V4_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 379
  { IMAGE_ATOMIC_DEC_V2_V1_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 380
  { IMAGE_ATOMIC_DEC_V3_V1_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 381
  { IMAGE_ATOMIC_DEC_V2_V2_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 382
  { IMAGE_ATOMIC_DEC_V3_V2_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 383
  { IMAGE_ATOMIC_DEC_V2_V3_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 384
  { IMAGE_ATOMIC_DEC_V3_V3_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 385
  { IMAGE_ATOMIC_DEC_V2_V4_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 386
  { IMAGE_ATOMIC_DEC_V3_V4_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 387
  { IMAGE_ATOMIC_DEC_V4_V1_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 388
  { IMAGE_ATOMIC_DEC_V4_V2_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 389
  { IMAGE_ATOMIC_DEC_V4_V3_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 390
  { IMAGE_ATOMIC_DEC_V4_V4_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 391
  { IMAGE_ATOMIC_DEC_V1_V2_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 392
  { IMAGE_ATOMIC_DEC_V1_V3_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 393
  { IMAGE_ATOMIC_DEC_V1_V4_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 394
  { IMAGE_ATOMIC_DEC_V2_V2_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 395
  { IMAGE_ATOMIC_DEC_V3_V2_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 396
  { IMAGE_ATOMIC_DEC_V2_V3_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 397
  { IMAGE_ATOMIC_DEC_V3_V3_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 398
  { IMAGE_ATOMIC_DEC_V2_V4_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 399
  { IMAGE_ATOMIC_DEC_V3_V4_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 400
  { IMAGE_ATOMIC_DEC_V4_V2_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 401
  { IMAGE_ATOMIC_DEC_V4_V3_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 402
  { IMAGE_ATOMIC_DEC_V4_V4_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 403
  { IMAGE_ATOMIC_DEC_V1_V1_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 404
  { IMAGE_ATOMIC_DEC_V1_V2_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 405
  { IMAGE_ATOMIC_DEC_V1_V3_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 406
  { IMAGE_ATOMIC_DEC_V1_V4_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 407
  { IMAGE_ATOMIC_DEC_V2_V1_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 408
  { IMAGE_ATOMIC_DEC_V3_V1_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 409
  { IMAGE_ATOMIC_DEC_V2_V2_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 410
  { IMAGE_ATOMIC_DEC_V3_V2_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 411
  { IMAGE_ATOMIC_DEC_V2_V3_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 412
  { IMAGE_ATOMIC_DEC_V3_V3_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 413
  { IMAGE_ATOMIC_DEC_V2_V4_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 414
  { IMAGE_ATOMIC_DEC_V3_V4_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 415
  { IMAGE_ATOMIC_DEC_V4_V1_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 416
  { IMAGE_ATOMIC_DEC_V4_V2_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 417
  { IMAGE_ATOMIC_DEC_V4_V3_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 418
  { IMAGE_ATOMIC_DEC_V4_V4_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 419
  { IMAGE_ATOMIC_DEC_V1_V2_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 420
  { IMAGE_ATOMIC_DEC_V1_V3_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 421
  { IMAGE_ATOMIC_DEC_V1_V4_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 422
  { IMAGE_ATOMIC_DEC_V2_V2_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 423
  { IMAGE_ATOMIC_DEC_V3_V2_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 424
  { IMAGE_ATOMIC_DEC_V2_V3_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 425
  { IMAGE_ATOMIC_DEC_V3_V3_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 426
  { IMAGE_ATOMIC_DEC_V2_V4_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 427
  { IMAGE_ATOMIC_DEC_V3_V4_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 428
  { IMAGE_ATOMIC_DEC_V4_V2_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 429
  { IMAGE_ATOMIC_DEC_V4_V3_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 430
  { IMAGE_ATOMIC_DEC_V4_V4_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 431
  { IMAGE_ATOMIC_DEC_V1_V1_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 432
  { IMAGE_ATOMIC_DEC_V1_V2_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 433
  { IMAGE_ATOMIC_DEC_V1_V3_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 434
  { IMAGE_ATOMIC_DEC_V1_V4_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 435
  { IMAGE_ATOMIC_DEC_V2_V1_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 436
  { IMAGE_ATOMIC_DEC_V3_V1_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 437
  { IMAGE_ATOMIC_DEC_V2_V2_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 438
  { IMAGE_ATOMIC_DEC_V3_V2_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 439
  { IMAGE_ATOMIC_DEC_V2_V3_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 440
  { IMAGE_ATOMIC_DEC_V3_V3_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 441
  { IMAGE_ATOMIC_DEC_V2_V4_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 442
  { IMAGE_ATOMIC_DEC_V3_V4_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 443
  { IMAGE_ATOMIC_DEC_V4_V1_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 444
  { IMAGE_ATOMIC_DEC_V4_V2_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 445
  { IMAGE_ATOMIC_DEC_V4_V3_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 446
  { IMAGE_ATOMIC_DEC_V4_V4_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 447
  { IMAGE_ATOMIC_DEC_V1_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 448
  { IMAGE_ATOMIC_DEC_V1_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 449
  { IMAGE_ATOMIC_DEC_V1_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 450
  { IMAGE_ATOMIC_DEC_V1_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 451
  { IMAGE_ATOMIC_DEC_V2_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 452
  { IMAGE_ATOMIC_DEC_V3_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 453
  { IMAGE_ATOMIC_DEC_V2_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 454
  { IMAGE_ATOMIC_DEC_V3_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 455
  { IMAGE_ATOMIC_DEC_V2_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 456
  { IMAGE_ATOMIC_DEC_V3_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 457
  { IMAGE_ATOMIC_DEC_V2_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 458
  { IMAGE_ATOMIC_DEC_V3_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 459
  { IMAGE_ATOMIC_DEC_V4_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 460
  { IMAGE_ATOMIC_DEC_V4_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 461
  { IMAGE_ATOMIC_DEC_V4_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 462
  { IMAGE_ATOMIC_DEC_V4_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 463
  { IMAGE_ATOMIC_DEC_V1_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 464
  { IMAGE_ATOMIC_DEC_V1_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 465
  { IMAGE_ATOMIC_DEC_V1_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 466
  { IMAGE_ATOMIC_DEC_V1_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 467
  { IMAGE_ATOMIC_DEC_V2_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 468
  { IMAGE_ATOMIC_DEC_V3_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 469
  { IMAGE_ATOMIC_DEC_V2_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 470
  { IMAGE_ATOMIC_DEC_V3_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 471
  { IMAGE_ATOMIC_DEC_V2_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 472
  { IMAGE_ATOMIC_DEC_V3_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 473
  { IMAGE_ATOMIC_DEC_V2_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 474
  { IMAGE_ATOMIC_DEC_V3_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 475
  { IMAGE_ATOMIC_DEC_V4_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 476
  { IMAGE_ATOMIC_DEC_V4_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 477
  { IMAGE_ATOMIC_DEC_V4_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 478
  { IMAGE_ATOMIC_DEC_V4_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 479
  { IMAGE_ATOMIC_DEC_V1_V1_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 480
  { IMAGE_ATOMIC_DEC_V1_V2_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 481
  { IMAGE_ATOMIC_DEC_V1_V3_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 482
  { IMAGE_ATOMIC_DEC_V1_V4_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 483
  { IMAGE_ATOMIC_DEC_V2_V1_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 484
  { IMAGE_ATOMIC_DEC_V3_V1_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 485
  { IMAGE_ATOMIC_DEC_V2_V2_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 486
  { IMAGE_ATOMIC_DEC_V3_V2_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 487
  { IMAGE_ATOMIC_DEC_V2_V3_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 488
  { IMAGE_ATOMIC_DEC_V3_V3_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 489
  { IMAGE_ATOMIC_DEC_V2_V4_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 490
  { IMAGE_ATOMIC_DEC_V3_V4_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 491
  { IMAGE_ATOMIC_DEC_V4_V1_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 492
  { IMAGE_ATOMIC_DEC_V4_V2_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 493
  { IMAGE_ATOMIC_DEC_V4_V3_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 494
  { IMAGE_ATOMIC_DEC_V4_V4_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 495
  { IMAGE_ATOMIC_FCMPSWAP_V1_V1_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 496
  { IMAGE_ATOMIC_FCMPSWAP_V3_V1_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 497
  { IMAGE_ATOMIC_FCMPSWAP_V1_V2_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 498
  { IMAGE_ATOMIC_FCMPSWAP_V3_V2_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 499
  { IMAGE_ATOMIC_FCMPSWAP_V1_V3_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 500
  { IMAGE_ATOMIC_FCMPSWAP_V3_V3_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 501
  { IMAGE_ATOMIC_FCMPSWAP_V1_V4_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 502
  { IMAGE_ATOMIC_FCMPSWAP_V3_V4_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 503
  { IMAGE_ATOMIC_FCMPSWAP_V2_V1_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 504
  { IMAGE_ATOMIC_FCMPSWAP_V4_V1_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 505
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 506
  { IMAGE_ATOMIC_FCMPSWAP_V4_V2_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 507
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 508
  { IMAGE_ATOMIC_FCMPSWAP_V4_V3_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 509
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 510
  { IMAGE_ATOMIC_FCMPSWAP_V4_V4_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 511
  { IMAGE_ATOMIC_FCMPSWAP_V1_V2_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 512
  { IMAGE_ATOMIC_FCMPSWAP_V3_V2_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 513
  { IMAGE_ATOMIC_FCMPSWAP_V1_V3_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 514
  { IMAGE_ATOMIC_FCMPSWAP_V3_V3_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 515
  { IMAGE_ATOMIC_FCMPSWAP_V1_V4_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 516
  { IMAGE_ATOMIC_FCMPSWAP_V3_V4_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 517
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 518
  { IMAGE_ATOMIC_FCMPSWAP_V4_V2_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 519
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 520
  { IMAGE_ATOMIC_FCMPSWAP_V4_V3_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 521
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 522
  { IMAGE_ATOMIC_FCMPSWAP_V4_V4_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 523
  { IMAGE_ATOMIC_FCMPSWAP_V1_V1_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 524
  { IMAGE_ATOMIC_FCMPSWAP_V3_V1_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 525
  { IMAGE_ATOMIC_FCMPSWAP_V1_V2_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 526
  { IMAGE_ATOMIC_FCMPSWAP_V3_V2_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 527
  { IMAGE_ATOMIC_FCMPSWAP_V1_V3_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 528
  { IMAGE_ATOMIC_FCMPSWAP_V3_V3_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 529
  { IMAGE_ATOMIC_FCMPSWAP_V1_V4_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 530
  { IMAGE_ATOMIC_FCMPSWAP_V3_V4_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 531
  { IMAGE_ATOMIC_FCMPSWAP_V2_V1_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 532
  { IMAGE_ATOMIC_FCMPSWAP_V4_V1_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 533
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 534
  { IMAGE_ATOMIC_FCMPSWAP_V4_V2_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 535
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 536
  { IMAGE_ATOMIC_FCMPSWAP_V4_V3_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 537
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 538
  { IMAGE_ATOMIC_FCMPSWAP_V4_V4_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 539
  { IMAGE_ATOMIC_FMAX_V1_V1_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 540
  { IMAGE_ATOMIC_FMAX_V1_V2_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 541
  { IMAGE_ATOMIC_FMAX_V1_V3_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 542
  { IMAGE_ATOMIC_FMAX_V1_V4_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 543
  { IMAGE_ATOMIC_FMAX_V2_V1_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 544
  { IMAGE_ATOMIC_FMAX_V3_V1_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 545
  { IMAGE_ATOMIC_FMAX_V2_V2_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 546
  { IMAGE_ATOMIC_FMAX_V3_V2_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 547
  { IMAGE_ATOMIC_FMAX_V2_V3_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 548
  { IMAGE_ATOMIC_FMAX_V3_V3_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 549
  { IMAGE_ATOMIC_FMAX_V2_V4_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 550
  { IMAGE_ATOMIC_FMAX_V3_V4_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 551
  { IMAGE_ATOMIC_FMAX_V4_V1_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 552
  { IMAGE_ATOMIC_FMAX_V4_V2_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 553
  { IMAGE_ATOMIC_FMAX_V4_V3_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 554
  { IMAGE_ATOMIC_FMAX_V4_V4_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 555
  { IMAGE_ATOMIC_FMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 556
  { IMAGE_ATOMIC_FMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 557
  { IMAGE_ATOMIC_FMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 558
  { IMAGE_ATOMIC_FMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 559
  { IMAGE_ATOMIC_FMAX_V3_V2_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 560
  { IMAGE_ATOMIC_FMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 561
  { IMAGE_ATOMIC_FMAX_V3_V3_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 562
  { IMAGE_ATOMIC_FMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 563
  { IMAGE_ATOMIC_FMAX_V3_V4_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 564
  { IMAGE_ATOMIC_FMAX_V4_V2_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 565
  { IMAGE_ATOMIC_FMAX_V4_V3_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 566
  { IMAGE_ATOMIC_FMAX_V4_V4_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 567
  { IMAGE_ATOMIC_FMAX_V1_V1_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 568
  { IMAGE_ATOMIC_FMAX_V1_V2_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 569
  { IMAGE_ATOMIC_FMAX_V1_V3_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 570
  { IMAGE_ATOMIC_FMAX_V1_V4_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 571
  { IMAGE_ATOMIC_FMAX_V2_V1_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 572
  { IMAGE_ATOMIC_FMAX_V3_V1_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 573
  { IMAGE_ATOMIC_FMAX_V2_V2_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 574
  { IMAGE_ATOMIC_FMAX_V3_V2_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 575
  { IMAGE_ATOMIC_FMAX_V2_V3_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 576
  { IMAGE_ATOMIC_FMAX_V3_V3_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 577
  { IMAGE_ATOMIC_FMAX_V2_V4_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 578
  { IMAGE_ATOMIC_FMAX_V3_V4_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 579
  { IMAGE_ATOMIC_FMAX_V4_V1_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 580
  { IMAGE_ATOMIC_FMAX_V4_V2_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 581
  { IMAGE_ATOMIC_FMAX_V4_V3_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 582
  { IMAGE_ATOMIC_FMAX_V4_V4_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 583
  { IMAGE_ATOMIC_FMIN_V1_V1_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 584
  { IMAGE_ATOMIC_FMIN_V1_V2_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 585
  { IMAGE_ATOMIC_FMIN_V1_V3_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 586
  { IMAGE_ATOMIC_FMIN_V1_V4_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 587
  { IMAGE_ATOMIC_FMIN_V2_V1_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 588
  { IMAGE_ATOMIC_FMIN_V3_V1_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 589
  { IMAGE_ATOMIC_FMIN_V2_V2_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 590
  { IMAGE_ATOMIC_FMIN_V3_V2_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 591
  { IMAGE_ATOMIC_FMIN_V2_V3_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 592
  { IMAGE_ATOMIC_FMIN_V3_V3_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 593
  { IMAGE_ATOMIC_FMIN_V2_V4_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 594
  { IMAGE_ATOMIC_FMIN_V3_V4_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 595
  { IMAGE_ATOMIC_FMIN_V4_V1_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 596
  { IMAGE_ATOMIC_FMIN_V4_V2_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 597
  { IMAGE_ATOMIC_FMIN_V4_V3_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 598
  { IMAGE_ATOMIC_FMIN_V4_V4_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 599
  { IMAGE_ATOMIC_FMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 600
  { IMAGE_ATOMIC_FMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 601
  { IMAGE_ATOMIC_FMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 602
  { IMAGE_ATOMIC_FMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 603
  { IMAGE_ATOMIC_FMIN_V3_V2_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 604
  { IMAGE_ATOMIC_FMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 605
  { IMAGE_ATOMIC_FMIN_V3_V3_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 606
  { IMAGE_ATOMIC_FMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 607
  { IMAGE_ATOMIC_FMIN_V3_V4_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 608
  { IMAGE_ATOMIC_FMIN_V4_V2_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 609
  { IMAGE_ATOMIC_FMIN_V4_V3_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 610
  { IMAGE_ATOMIC_FMIN_V4_V4_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 611
  { IMAGE_ATOMIC_FMIN_V1_V1_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 612
  { IMAGE_ATOMIC_FMIN_V1_V2_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 613
  { IMAGE_ATOMIC_FMIN_V1_V3_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 614
  { IMAGE_ATOMIC_FMIN_V1_V4_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 615
  { IMAGE_ATOMIC_FMIN_V2_V1_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 616
  { IMAGE_ATOMIC_FMIN_V3_V1_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 617
  { IMAGE_ATOMIC_FMIN_V2_V2_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 618
  { IMAGE_ATOMIC_FMIN_V3_V2_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 619
  { IMAGE_ATOMIC_FMIN_V2_V3_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 620
  { IMAGE_ATOMIC_FMIN_V3_V3_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 621
  { IMAGE_ATOMIC_FMIN_V2_V4_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 622
  { IMAGE_ATOMIC_FMIN_V3_V4_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 623
  { IMAGE_ATOMIC_FMIN_V4_V1_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 624
  { IMAGE_ATOMIC_FMIN_V4_V2_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 625
  { IMAGE_ATOMIC_FMIN_V4_V3_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 626
  { IMAGE_ATOMIC_FMIN_V4_V4_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 627
  { IMAGE_ATOMIC_INC_V1_V1_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 628
  { IMAGE_ATOMIC_INC_V1_V2_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 629
  { IMAGE_ATOMIC_INC_V1_V3_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 630
  { IMAGE_ATOMIC_INC_V1_V4_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 631
  { IMAGE_ATOMIC_INC_V2_V1_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 632
  { IMAGE_ATOMIC_INC_V3_V1_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 633
  { IMAGE_ATOMIC_INC_V2_V2_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 634
  { IMAGE_ATOMIC_INC_V3_V2_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 635
  { IMAGE_ATOMIC_INC_V2_V3_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 636
  { IMAGE_ATOMIC_INC_V3_V3_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 637
  { IMAGE_ATOMIC_INC_V2_V4_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 638
  { IMAGE_ATOMIC_INC_V3_V4_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 639
  { IMAGE_ATOMIC_INC_V4_V1_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 640
  { IMAGE_ATOMIC_INC_V4_V2_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 641
  { IMAGE_ATOMIC_INC_V4_V3_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 642
  { IMAGE_ATOMIC_INC_V4_V4_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 643
  { IMAGE_ATOMIC_INC_V1_V2_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 644
  { IMAGE_ATOMIC_INC_V1_V3_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 645
  { IMAGE_ATOMIC_INC_V1_V4_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 646
  { IMAGE_ATOMIC_INC_V2_V2_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 647
  { IMAGE_ATOMIC_INC_V3_V2_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 648
  { IMAGE_ATOMIC_INC_V2_V3_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 649
  { IMAGE_ATOMIC_INC_V3_V3_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 650
  { IMAGE_ATOMIC_INC_V2_V4_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 651
  { IMAGE_ATOMIC_INC_V3_V4_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 652
  { IMAGE_ATOMIC_INC_V4_V2_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 653
  { IMAGE_ATOMIC_INC_V4_V3_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 654
  { IMAGE_ATOMIC_INC_V4_V4_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 655
  { IMAGE_ATOMIC_INC_V1_V1_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 656
  { IMAGE_ATOMIC_INC_V1_V2_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 657
  { IMAGE_ATOMIC_INC_V1_V3_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 658
  { IMAGE_ATOMIC_INC_V1_V4_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 659
  { IMAGE_ATOMIC_INC_V2_V1_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 660
  { IMAGE_ATOMIC_INC_V3_V1_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 661
  { IMAGE_ATOMIC_INC_V2_V2_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 662
  { IMAGE_ATOMIC_INC_V3_V2_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 663
  { IMAGE_ATOMIC_INC_V2_V3_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 664
  { IMAGE_ATOMIC_INC_V3_V3_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 665
  { IMAGE_ATOMIC_INC_V2_V4_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 666
  { IMAGE_ATOMIC_INC_V3_V4_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 667
  { IMAGE_ATOMIC_INC_V4_V1_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 668
  { IMAGE_ATOMIC_INC_V4_V2_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 669
  { IMAGE_ATOMIC_INC_V4_V3_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 670
  { IMAGE_ATOMIC_INC_V4_V4_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 671
  { IMAGE_ATOMIC_INC_V1_V2_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 672
  { IMAGE_ATOMIC_INC_V1_V3_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 673
  { IMAGE_ATOMIC_INC_V1_V4_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 674
  { IMAGE_ATOMIC_INC_V2_V2_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 675
  { IMAGE_ATOMIC_INC_V3_V2_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 676
  { IMAGE_ATOMIC_INC_V2_V3_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 677
  { IMAGE_ATOMIC_INC_V3_V3_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 678
  { IMAGE_ATOMIC_INC_V2_V4_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 679
  { IMAGE_ATOMIC_INC_V3_V4_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 680
  { IMAGE_ATOMIC_INC_V4_V2_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 681
  { IMAGE_ATOMIC_INC_V4_V3_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 682
  { IMAGE_ATOMIC_INC_V4_V4_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 683
  { IMAGE_ATOMIC_INC_V1_V1_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 684
  { IMAGE_ATOMIC_INC_V1_V2_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 685
  { IMAGE_ATOMIC_INC_V1_V3_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 686
  { IMAGE_ATOMIC_INC_V1_V4_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 687
  { IMAGE_ATOMIC_INC_V2_V1_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 688
  { IMAGE_ATOMIC_INC_V3_V1_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 689
  { IMAGE_ATOMIC_INC_V2_V2_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 690
  { IMAGE_ATOMIC_INC_V3_V2_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 691
  { IMAGE_ATOMIC_INC_V2_V3_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 692
  { IMAGE_ATOMIC_INC_V3_V3_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 693
  { IMAGE_ATOMIC_INC_V2_V4_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 694
  { IMAGE_ATOMIC_INC_V3_V4_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 695
  { IMAGE_ATOMIC_INC_V4_V1_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 696
  { IMAGE_ATOMIC_INC_V4_V2_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 697
  { IMAGE_ATOMIC_INC_V4_V3_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 698
  { IMAGE_ATOMIC_INC_V4_V4_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 699
  { IMAGE_ATOMIC_INC_V1_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 700
  { IMAGE_ATOMIC_INC_V1_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 701
  { IMAGE_ATOMIC_INC_V1_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 702
  { IMAGE_ATOMIC_INC_V1_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 703
  { IMAGE_ATOMIC_INC_V2_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 704
  { IMAGE_ATOMIC_INC_V3_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 705
  { IMAGE_ATOMIC_INC_V2_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 706
  { IMAGE_ATOMIC_INC_V3_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 707
  { IMAGE_ATOMIC_INC_V2_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 708
  { IMAGE_ATOMIC_INC_V3_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 709
  { IMAGE_ATOMIC_INC_V2_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 710
  { IMAGE_ATOMIC_INC_V3_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 711
  { IMAGE_ATOMIC_INC_V4_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 712
  { IMAGE_ATOMIC_INC_V4_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 713
  { IMAGE_ATOMIC_INC_V4_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 714
  { IMAGE_ATOMIC_INC_V4_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 715
  { IMAGE_ATOMIC_INC_V1_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 716
  { IMAGE_ATOMIC_INC_V1_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 717
  { IMAGE_ATOMIC_INC_V1_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 718
  { IMAGE_ATOMIC_INC_V1_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 719
  { IMAGE_ATOMIC_INC_V2_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 720
  { IMAGE_ATOMIC_INC_V3_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 721
  { IMAGE_ATOMIC_INC_V2_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 722
  { IMAGE_ATOMIC_INC_V3_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 723
  { IMAGE_ATOMIC_INC_V2_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 724
  { IMAGE_ATOMIC_INC_V3_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 725
  { IMAGE_ATOMIC_INC_V2_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 726
  { IMAGE_ATOMIC_INC_V3_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 727
  { IMAGE_ATOMIC_INC_V4_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 728
  { IMAGE_ATOMIC_INC_V4_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 729
  { IMAGE_ATOMIC_INC_V4_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 730
  { IMAGE_ATOMIC_INC_V4_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 731
  { IMAGE_ATOMIC_INC_V1_V1_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 732
  { IMAGE_ATOMIC_INC_V1_V2_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 733
  { IMAGE_ATOMIC_INC_V1_V3_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 734
  { IMAGE_ATOMIC_INC_V1_V4_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 735
  { IMAGE_ATOMIC_INC_V2_V1_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 736
  { IMAGE_ATOMIC_INC_V3_V1_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 737
  { IMAGE_ATOMIC_INC_V2_V2_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 738
  { IMAGE_ATOMIC_INC_V3_V2_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 739
  { IMAGE_ATOMIC_INC_V2_V3_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 740
  { IMAGE_ATOMIC_INC_V3_V3_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 741
  { IMAGE_ATOMIC_INC_V2_V4_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 742
  { IMAGE_ATOMIC_INC_V3_V4_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 743
  { IMAGE_ATOMIC_INC_V4_V1_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 744
  { IMAGE_ATOMIC_INC_V4_V2_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 745
  { IMAGE_ATOMIC_INC_V4_V3_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 746
  { IMAGE_ATOMIC_INC_V4_V4_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 747
  { IMAGE_ATOMIC_MAX_FLT_V1_V1_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 748
  { IMAGE_ATOMIC_MAX_FLT_V1_V2_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 749
  { IMAGE_ATOMIC_MAX_FLT_V1_V3_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 750
  { IMAGE_ATOMIC_MAX_FLT_V1_V4_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 751
  { IMAGE_ATOMIC_MAX_FLT_V2_V1_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 752
  { IMAGE_ATOMIC_MAX_FLT_V3_V1_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 753
  { IMAGE_ATOMIC_MAX_FLT_V2_V2_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 754
  { IMAGE_ATOMIC_MAX_FLT_V3_V2_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 755
  { IMAGE_ATOMIC_MAX_FLT_V2_V3_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 756
  { IMAGE_ATOMIC_MAX_FLT_V3_V3_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 757
  { IMAGE_ATOMIC_MAX_FLT_V2_V4_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 758
  { IMAGE_ATOMIC_MAX_FLT_V3_V4_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 759
  { IMAGE_ATOMIC_MAX_FLT_V4_V1_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 760
  { IMAGE_ATOMIC_MAX_FLT_V4_V2_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 761
  { IMAGE_ATOMIC_MAX_FLT_V4_V3_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 762
  { IMAGE_ATOMIC_MAX_FLT_V4_V4_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 763
  { IMAGE_ATOMIC_MIN_FLT_V1_V1_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 764
  { IMAGE_ATOMIC_MIN_FLT_V1_V2_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 765
  { IMAGE_ATOMIC_MIN_FLT_V1_V3_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 766
  { IMAGE_ATOMIC_MIN_FLT_V1_V4_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 767
  { IMAGE_ATOMIC_MIN_FLT_V2_V1_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 768
  { IMAGE_ATOMIC_MIN_FLT_V3_V1_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 769
  { IMAGE_ATOMIC_MIN_FLT_V2_V2_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 770
  { IMAGE_ATOMIC_MIN_FLT_V3_V2_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 771
  { IMAGE_ATOMIC_MIN_FLT_V2_V3_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 772
  { IMAGE_ATOMIC_MIN_FLT_V3_V3_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 773
  { IMAGE_ATOMIC_MIN_FLT_V2_V4_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 774
  { IMAGE_ATOMIC_MIN_FLT_V3_V4_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 775
  { IMAGE_ATOMIC_MIN_FLT_V4_V1_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 776
  { IMAGE_ATOMIC_MIN_FLT_V4_V2_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 777
  { IMAGE_ATOMIC_MIN_FLT_V4_V3_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 778
  { IMAGE_ATOMIC_MIN_FLT_V4_V4_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 779
  { IMAGE_ATOMIC_OR_V1_V1_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 780
  { IMAGE_ATOMIC_OR_V1_V2_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 781
  { IMAGE_ATOMIC_OR_V1_V3_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 782
  { IMAGE_ATOMIC_OR_V1_V4_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 783
  { IMAGE_ATOMIC_OR_V2_V1_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 784
  { IMAGE_ATOMIC_OR_V3_V1_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 785
  { IMAGE_ATOMIC_OR_V2_V2_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 786
  { IMAGE_ATOMIC_OR_V3_V2_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 787
  { IMAGE_ATOMIC_OR_V2_V3_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 788
  { IMAGE_ATOMIC_OR_V3_V3_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 789
  { IMAGE_ATOMIC_OR_V2_V4_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 790
  { IMAGE_ATOMIC_OR_V3_V4_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 791
  { IMAGE_ATOMIC_OR_V4_V1_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 792
  { IMAGE_ATOMIC_OR_V4_V2_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 793
  { IMAGE_ATOMIC_OR_V4_V3_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 794
  { IMAGE_ATOMIC_OR_V4_V4_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 795
  { IMAGE_ATOMIC_OR_V1_V2_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 796
  { IMAGE_ATOMIC_OR_V1_V3_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 797
  { IMAGE_ATOMIC_OR_V1_V4_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 798
  { IMAGE_ATOMIC_OR_V2_V2_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 799
  { IMAGE_ATOMIC_OR_V3_V2_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 800
  { IMAGE_ATOMIC_OR_V2_V3_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 801
  { IMAGE_ATOMIC_OR_V3_V3_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 802
  { IMAGE_ATOMIC_OR_V2_V4_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 803
  { IMAGE_ATOMIC_OR_V3_V4_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 804
  { IMAGE_ATOMIC_OR_V4_V2_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 805
  { IMAGE_ATOMIC_OR_V4_V3_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 806
  { IMAGE_ATOMIC_OR_V4_V4_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 807
  { IMAGE_ATOMIC_OR_V1_V1_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 808
  { IMAGE_ATOMIC_OR_V1_V2_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 809
  { IMAGE_ATOMIC_OR_V1_V3_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 810
  { IMAGE_ATOMIC_OR_V1_V4_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 811
  { IMAGE_ATOMIC_OR_V2_V1_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 812
  { IMAGE_ATOMIC_OR_V3_V1_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 813
  { IMAGE_ATOMIC_OR_V2_V2_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 814
  { IMAGE_ATOMIC_OR_V3_V2_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 815
  { IMAGE_ATOMIC_OR_V2_V3_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 816
  { IMAGE_ATOMIC_OR_V3_V3_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 817
  { IMAGE_ATOMIC_OR_V2_V4_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 818
  { IMAGE_ATOMIC_OR_V3_V4_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 819
  { IMAGE_ATOMIC_OR_V4_V1_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 820
  { IMAGE_ATOMIC_OR_V4_V2_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 821
  { IMAGE_ATOMIC_OR_V4_V3_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 822
  { IMAGE_ATOMIC_OR_V4_V4_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 823
  { IMAGE_ATOMIC_OR_V1_V2_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 824
  { IMAGE_ATOMIC_OR_V1_V3_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 825
  { IMAGE_ATOMIC_OR_V1_V4_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 826
  { IMAGE_ATOMIC_OR_V2_V2_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 827
  { IMAGE_ATOMIC_OR_V3_V2_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 828
  { IMAGE_ATOMIC_OR_V2_V3_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 829
  { IMAGE_ATOMIC_OR_V3_V3_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 830
  { IMAGE_ATOMIC_OR_V2_V4_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 831
  { IMAGE_ATOMIC_OR_V3_V4_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 832
  { IMAGE_ATOMIC_OR_V4_V2_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 833
  { IMAGE_ATOMIC_OR_V4_V3_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 834
  { IMAGE_ATOMIC_OR_V4_V4_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 835
  { IMAGE_ATOMIC_OR_V1_V1_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 836
  { IMAGE_ATOMIC_OR_V1_V2_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 837
  { IMAGE_ATOMIC_OR_V1_V3_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 838
  { IMAGE_ATOMIC_OR_V1_V4_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 839
  { IMAGE_ATOMIC_OR_V2_V1_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 840
  { IMAGE_ATOMIC_OR_V3_V1_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 841
  { IMAGE_ATOMIC_OR_V2_V2_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 842
  { IMAGE_ATOMIC_OR_V3_V2_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 843
  { IMAGE_ATOMIC_OR_V2_V3_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 844
  { IMAGE_ATOMIC_OR_V3_V3_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 845
  { IMAGE_ATOMIC_OR_V2_V4_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 846
  { IMAGE_ATOMIC_OR_V3_V4_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 847
  { IMAGE_ATOMIC_OR_V4_V1_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 848
  { IMAGE_ATOMIC_OR_V4_V2_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 849
  { IMAGE_ATOMIC_OR_V4_V3_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 850
  { IMAGE_ATOMIC_OR_V4_V4_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 851
  { IMAGE_ATOMIC_OR_V1_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 852
  { IMAGE_ATOMIC_OR_V1_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 853
  { IMAGE_ATOMIC_OR_V1_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 854
  { IMAGE_ATOMIC_OR_V1_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 855
  { IMAGE_ATOMIC_OR_V2_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 856
  { IMAGE_ATOMIC_OR_V3_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 857
  { IMAGE_ATOMIC_OR_V2_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 858
  { IMAGE_ATOMIC_OR_V3_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 859
  { IMAGE_ATOMIC_OR_V2_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 860
  { IMAGE_ATOMIC_OR_V3_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 861
  { IMAGE_ATOMIC_OR_V2_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 862
  { IMAGE_ATOMIC_OR_V3_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 863
  { IMAGE_ATOMIC_OR_V4_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 864
  { IMAGE_ATOMIC_OR_V4_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 865
  { IMAGE_ATOMIC_OR_V4_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 866
  { IMAGE_ATOMIC_OR_V4_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 867
  { IMAGE_ATOMIC_OR_V1_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 868
  { IMAGE_ATOMIC_OR_V1_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 869
  { IMAGE_ATOMIC_OR_V1_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 870
  { IMAGE_ATOMIC_OR_V1_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 871
  { IMAGE_ATOMIC_OR_V2_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 872
  { IMAGE_ATOMIC_OR_V3_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 873
  { IMAGE_ATOMIC_OR_V2_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 874
  { IMAGE_ATOMIC_OR_V3_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 875
  { IMAGE_ATOMIC_OR_V2_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 876
  { IMAGE_ATOMIC_OR_V3_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 877
  { IMAGE_ATOMIC_OR_V2_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 878
  { IMAGE_ATOMIC_OR_V3_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 879
  { IMAGE_ATOMIC_OR_V4_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 880
  { IMAGE_ATOMIC_OR_V4_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 881
  { IMAGE_ATOMIC_OR_V4_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 882
  { IMAGE_ATOMIC_OR_V4_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 883
  { IMAGE_ATOMIC_OR_V1_V1_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 884
  { IMAGE_ATOMIC_OR_V1_V2_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 885
  { IMAGE_ATOMIC_OR_V1_V3_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 886
  { IMAGE_ATOMIC_OR_V1_V4_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 887
  { IMAGE_ATOMIC_OR_V2_V1_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 888
  { IMAGE_ATOMIC_OR_V3_V1_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 889
  { IMAGE_ATOMIC_OR_V2_V2_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 890
  { IMAGE_ATOMIC_OR_V3_V2_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 891
  { IMAGE_ATOMIC_OR_V2_V3_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 892
  { IMAGE_ATOMIC_OR_V3_V3_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 893
  { IMAGE_ATOMIC_OR_V2_V4_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 894
  { IMAGE_ATOMIC_OR_V3_V4_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 895
  { IMAGE_ATOMIC_OR_V4_V1_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 896
  { IMAGE_ATOMIC_OR_V4_V2_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 897
  { IMAGE_ATOMIC_OR_V4_V3_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 898
  { IMAGE_ATOMIC_OR_V4_V4_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 899
  { IMAGE_ATOMIC_PK_ADD_BF16_V1_V1_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 900
  { IMAGE_ATOMIC_PK_ADD_BF16_V1_V2_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 901
  { IMAGE_ATOMIC_PK_ADD_BF16_V1_V3_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 902
  { IMAGE_ATOMIC_PK_ADD_BF16_V1_V4_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 903
  { IMAGE_ATOMIC_PK_ADD_BF16_V2_V1_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 904
  { IMAGE_ATOMIC_PK_ADD_BF16_V3_V1_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 905
  { IMAGE_ATOMIC_PK_ADD_BF16_V2_V2_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 906
  { IMAGE_ATOMIC_PK_ADD_BF16_V3_V2_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 907
  { IMAGE_ATOMIC_PK_ADD_BF16_V2_V3_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 908
  { IMAGE_ATOMIC_PK_ADD_BF16_V3_V3_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 909
  { IMAGE_ATOMIC_PK_ADD_BF16_V2_V4_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 910
  { IMAGE_ATOMIC_PK_ADD_BF16_V3_V4_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 911
  { IMAGE_ATOMIC_PK_ADD_BF16_V4_V1_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 912
  { IMAGE_ATOMIC_PK_ADD_BF16_V4_V2_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 913
  { IMAGE_ATOMIC_PK_ADD_BF16_V4_V3_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 914
  { IMAGE_ATOMIC_PK_ADD_BF16_V4_V4_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 915
  { IMAGE_ATOMIC_PK_ADD_F16_V1_V1_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 916
  { IMAGE_ATOMIC_PK_ADD_F16_V1_V2_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 917
  { IMAGE_ATOMIC_PK_ADD_F16_V1_V3_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 918
  { IMAGE_ATOMIC_PK_ADD_F16_V1_V4_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 919
  { IMAGE_ATOMIC_PK_ADD_F16_V2_V1_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 920
  { IMAGE_ATOMIC_PK_ADD_F16_V3_V1_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 921
  { IMAGE_ATOMIC_PK_ADD_F16_V2_V2_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 922
  { IMAGE_ATOMIC_PK_ADD_F16_V3_V2_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 923
  { IMAGE_ATOMIC_PK_ADD_F16_V2_V3_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 924
  { IMAGE_ATOMIC_PK_ADD_F16_V3_V3_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 925
  { IMAGE_ATOMIC_PK_ADD_F16_V2_V4_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 926
  { IMAGE_ATOMIC_PK_ADD_F16_V3_V4_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 927
  { IMAGE_ATOMIC_PK_ADD_F16_V4_V1_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 928
  { IMAGE_ATOMIC_PK_ADD_F16_V4_V2_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 929
  { IMAGE_ATOMIC_PK_ADD_F16_V4_V3_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 930
  { IMAGE_ATOMIC_PK_ADD_F16_V4_V4_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 931
  { IMAGE_ATOMIC_RSUB_V1_V1_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 932
  { IMAGE_ATOMIC_RSUB_V1_V2_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 933
  { IMAGE_ATOMIC_RSUB_V1_V3_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 934
  { IMAGE_ATOMIC_RSUB_V1_V4_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 935
  { IMAGE_ATOMIC_RSUB_V2_V1_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 936
  { IMAGE_ATOMIC_RSUB_V3_V1_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 937
  { IMAGE_ATOMIC_RSUB_V2_V2_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 938
  { IMAGE_ATOMIC_RSUB_V3_V2_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 939
  { IMAGE_ATOMIC_RSUB_V2_V3_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 940
  { IMAGE_ATOMIC_RSUB_V3_V3_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 941
  { IMAGE_ATOMIC_RSUB_V2_V4_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 942
  { IMAGE_ATOMIC_RSUB_V3_V4_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 943
  { IMAGE_ATOMIC_RSUB_V4_V1_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 944
  { IMAGE_ATOMIC_RSUB_V4_V2_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 945
  { IMAGE_ATOMIC_RSUB_V4_V3_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 946
  { IMAGE_ATOMIC_RSUB_V4_V4_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 947
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 948
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 949
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 950
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 951
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 952
  { IMAGE_ATOMIC_SMAX_V3_V1_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 953
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 954
  { IMAGE_ATOMIC_SMAX_V3_V2_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 955
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 956
  { IMAGE_ATOMIC_SMAX_V3_V3_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 957
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 958
  { IMAGE_ATOMIC_SMAX_V3_V4_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 959
  { IMAGE_ATOMIC_SMAX_V4_V1_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 960
  { IMAGE_ATOMIC_SMAX_V4_V2_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 961
  { IMAGE_ATOMIC_SMAX_V4_V3_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 962
  { IMAGE_ATOMIC_SMAX_V4_V4_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 963
  { IMAGE_ATOMIC_SMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 964
  { IMAGE_ATOMIC_SMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 965
  { IMAGE_ATOMIC_SMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 966
  { IMAGE_ATOMIC_SMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 967
  { IMAGE_ATOMIC_SMAX_V3_V2_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 968
  { IMAGE_ATOMIC_SMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 969
  { IMAGE_ATOMIC_SMAX_V3_V3_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 970
  { IMAGE_ATOMIC_SMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 971
  { IMAGE_ATOMIC_SMAX_V3_V4_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 972
  { IMAGE_ATOMIC_SMAX_V4_V2_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 973
  { IMAGE_ATOMIC_SMAX_V4_V3_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 974
  { IMAGE_ATOMIC_SMAX_V4_V4_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 975
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 976
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 977
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 978
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 979
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 980
  { IMAGE_ATOMIC_SMAX_V3_V1_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 981
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 982
  { IMAGE_ATOMIC_SMAX_V3_V2_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 983
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 984
  { IMAGE_ATOMIC_SMAX_V3_V3_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 985
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 986
  { IMAGE_ATOMIC_SMAX_V3_V4_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 987
  { IMAGE_ATOMIC_SMAX_V4_V1_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 988
  { IMAGE_ATOMIC_SMAX_V4_V2_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 989
  { IMAGE_ATOMIC_SMAX_V4_V3_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 990
  { IMAGE_ATOMIC_SMAX_V4_V4_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 991
  { IMAGE_ATOMIC_SMAX_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 992
  { IMAGE_ATOMIC_SMAX_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 993
  { IMAGE_ATOMIC_SMAX_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 994
  { IMAGE_ATOMIC_SMAX_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 995
  { IMAGE_ATOMIC_SMAX_V3_V2_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 996
  { IMAGE_ATOMIC_SMAX_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 997
  { IMAGE_ATOMIC_SMAX_V3_V3_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 998
  { IMAGE_ATOMIC_SMAX_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 999
  { IMAGE_ATOMIC_SMAX_V3_V4_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1000
  { IMAGE_ATOMIC_SMAX_V4_V2_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1001
  { IMAGE_ATOMIC_SMAX_V4_V3_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1002
  { IMAGE_ATOMIC_SMAX_V4_V4_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1003
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 1004
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 1005
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 1006
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 1007
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1008
  { IMAGE_ATOMIC_SMAX_V3_V1_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1009
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1010
  { IMAGE_ATOMIC_SMAX_V3_V2_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1011
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1012
  { IMAGE_ATOMIC_SMAX_V3_V3_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1013
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1014
  { IMAGE_ATOMIC_SMAX_V3_V4_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1015
  { IMAGE_ATOMIC_SMAX_V4_V1_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 1016
  { IMAGE_ATOMIC_SMAX_V4_V2_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1017
  { IMAGE_ATOMIC_SMAX_V4_V3_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1018
  { IMAGE_ATOMIC_SMAX_V4_V4_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1019
  { IMAGE_ATOMIC_SMAX_V1_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 1020
  { IMAGE_ATOMIC_SMAX_V1_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 1021
  { IMAGE_ATOMIC_SMAX_V1_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 1022
  { IMAGE_ATOMIC_SMAX_V1_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 1023
  { IMAGE_ATOMIC_SMAX_V2_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1024
  { IMAGE_ATOMIC_SMAX_V3_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1025
  { IMAGE_ATOMIC_SMAX_V2_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1026
  { IMAGE_ATOMIC_SMAX_V3_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1027
  { IMAGE_ATOMIC_SMAX_V2_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1028
  { IMAGE_ATOMIC_SMAX_V3_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1029
  { IMAGE_ATOMIC_SMAX_V2_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1030
  { IMAGE_ATOMIC_SMAX_V3_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1031
  { IMAGE_ATOMIC_SMAX_V4_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1032
  { IMAGE_ATOMIC_SMAX_V4_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1033
  { IMAGE_ATOMIC_SMAX_V4_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1034
  { IMAGE_ATOMIC_SMAX_V4_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1035
  { IMAGE_ATOMIC_SMAX_V1_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 1036
  { IMAGE_ATOMIC_SMAX_V1_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 1037
  { IMAGE_ATOMIC_SMAX_V1_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 1038
  { IMAGE_ATOMIC_SMAX_V1_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 1039
  { IMAGE_ATOMIC_SMAX_V2_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1040
  { IMAGE_ATOMIC_SMAX_V3_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1041
  { IMAGE_ATOMIC_SMAX_V2_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1042
  { IMAGE_ATOMIC_SMAX_V3_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1043
  { IMAGE_ATOMIC_SMAX_V2_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1044
  { IMAGE_ATOMIC_SMAX_V3_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1045
  { IMAGE_ATOMIC_SMAX_V2_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1046
  { IMAGE_ATOMIC_SMAX_V3_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1047
  { IMAGE_ATOMIC_SMAX_V4_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 1048
  { IMAGE_ATOMIC_SMAX_V4_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 1049
  { IMAGE_ATOMIC_SMAX_V4_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 1050
  { IMAGE_ATOMIC_SMAX_V4_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 1051
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 1052
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 1053
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 1054
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 1055
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1056
  { IMAGE_ATOMIC_SMAX_V3_V1_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1057
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1058
  { IMAGE_ATOMIC_SMAX_V3_V2_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1059
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1060
  { IMAGE_ATOMIC_SMAX_V3_V3_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1061
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1062
  { IMAGE_ATOMIC_SMAX_V3_V4_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1063
  { IMAGE_ATOMIC_SMAX_V4_V1_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 1064
  { IMAGE_ATOMIC_SMAX_V4_V2_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 1065
  { IMAGE_ATOMIC_SMAX_V4_V3_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 1066
  { IMAGE_ATOMIC_SMAX_V4_V4_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 1067
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 1068
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1069
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 1070
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 1071
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1072
  { IMAGE_ATOMIC_SMIN_V3_V1_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1073
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1074
  { IMAGE_ATOMIC_SMIN_V3_V2_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1075
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1076
  { IMAGE_ATOMIC_SMIN_V3_V3_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1077
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1078
  { IMAGE_ATOMIC_SMIN_V3_V4_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1079
  { IMAGE_ATOMIC_SMIN_V4_V1_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1080
  { IMAGE_ATOMIC_SMIN_V4_V2_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1081
  { IMAGE_ATOMIC_SMIN_V4_V3_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1082
  { IMAGE_ATOMIC_SMIN_V4_V4_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1083
  { IMAGE_ATOMIC_SMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 1084
  { IMAGE_ATOMIC_SMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 1085
  { IMAGE_ATOMIC_SMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 1086
  { IMAGE_ATOMIC_SMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1087
  { IMAGE_ATOMIC_SMIN_V3_V2_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1088
  { IMAGE_ATOMIC_SMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1089
  { IMAGE_ATOMIC_SMIN_V3_V3_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1090
  { IMAGE_ATOMIC_SMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1091
  { IMAGE_ATOMIC_SMIN_V3_V4_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1092
  { IMAGE_ATOMIC_SMIN_V4_V2_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1093
  { IMAGE_ATOMIC_SMIN_V4_V3_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1094
  { IMAGE_ATOMIC_SMIN_V4_V4_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1095
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 1096
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 1097
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 1098
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 1099
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1100
  { IMAGE_ATOMIC_SMIN_V3_V1_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1101
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1102
  { IMAGE_ATOMIC_SMIN_V3_V2_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1103
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1104
  { IMAGE_ATOMIC_SMIN_V3_V3_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1105
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1106
  { IMAGE_ATOMIC_SMIN_V3_V4_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1107
  { IMAGE_ATOMIC_SMIN_V4_V1_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1108
  { IMAGE_ATOMIC_SMIN_V4_V2_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1109
  { IMAGE_ATOMIC_SMIN_V4_V3_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1110
  { IMAGE_ATOMIC_SMIN_V4_V4_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1111
  { IMAGE_ATOMIC_SMIN_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 1112
  { IMAGE_ATOMIC_SMIN_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 1113
  { IMAGE_ATOMIC_SMIN_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 1114
  { IMAGE_ATOMIC_SMIN_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1115
  { IMAGE_ATOMIC_SMIN_V3_V2_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1116
  { IMAGE_ATOMIC_SMIN_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1117
  { IMAGE_ATOMIC_SMIN_V3_V3_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1118
  { IMAGE_ATOMIC_SMIN_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1119
  { IMAGE_ATOMIC_SMIN_V3_V4_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1120
  { IMAGE_ATOMIC_SMIN_V4_V2_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1121
  { IMAGE_ATOMIC_SMIN_V4_V3_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1122
  { IMAGE_ATOMIC_SMIN_V4_V4_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1123
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 1124
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 1125
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 1126
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 1127
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1128
  { IMAGE_ATOMIC_SMIN_V3_V1_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1129
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1130
  { IMAGE_ATOMIC_SMIN_V3_V2_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1131
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1132
  { IMAGE_ATOMIC_SMIN_V3_V3_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1133
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1134
  { IMAGE_ATOMIC_SMIN_V3_V4_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1135
  { IMAGE_ATOMIC_SMIN_V4_V1_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 1136
  { IMAGE_ATOMIC_SMIN_V4_V2_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1137
  { IMAGE_ATOMIC_SMIN_V4_V3_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1138
  { IMAGE_ATOMIC_SMIN_V4_V4_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1139
  { IMAGE_ATOMIC_SMIN_V1_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 1140
  { IMAGE_ATOMIC_SMIN_V1_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 1141
  { IMAGE_ATOMIC_SMIN_V1_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 1142
  { IMAGE_ATOMIC_SMIN_V1_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 1143
  { IMAGE_ATOMIC_SMIN_V2_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1144
  { IMAGE_ATOMIC_SMIN_V3_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1145
  { IMAGE_ATOMIC_SMIN_V2_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1146
  { IMAGE_ATOMIC_SMIN_V3_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1147
  { IMAGE_ATOMIC_SMIN_V2_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1148
  { IMAGE_ATOMIC_SMIN_V3_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1149
  { IMAGE_ATOMIC_SMIN_V2_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1150
  { IMAGE_ATOMIC_SMIN_V3_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1151
  { IMAGE_ATOMIC_SMIN_V4_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1152
  { IMAGE_ATOMIC_SMIN_V4_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1153
  { IMAGE_ATOMIC_SMIN_V4_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1154
  { IMAGE_ATOMIC_SMIN_V4_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1155
  { IMAGE_ATOMIC_SMIN_V1_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 1156
  { IMAGE_ATOMIC_SMIN_V1_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 1157
  { IMAGE_ATOMIC_SMIN_V1_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 1158
  { IMAGE_ATOMIC_SMIN_V1_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 1159
  { IMAGE_ATOMIC_SMIN_V2_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1160
  { IMAGE_ATOMIC_SMIN_V3_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1161
  { IMAGE_ATOMIC_SMIN_V2_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1162
  { IMAGE_ATOMIC_SMIN_V3_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1163
  { IMAGE_ATOMIC_SMIN_V2_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1164
  { IMAGE_ATOMIC_SMIN_V3_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1165
  { IMAGE_ATOMIC_SMIN_V2_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1166
  { IMAGE_ATOMIC_SMIN_V3_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1167
  { IMAGE_ATOMIC_SMIN_V4_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 1168
  { IMAGE_ATOMIC_SMIN_V4_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 1169
  { IMAGE_ATOMIC_SMIN_V4_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 1170
  { IMAGE_ATOMIC_SMIN_V4_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 1171
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 1172
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 1173
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 1174
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 1175
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1176
  { IMAGE_ATOMIC_SMIN_V3_V1_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1177
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1178
  { IMAGE_ATOMIC_SMIN_V3_V2_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1179
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1180
  { IMAGE_ATOMIC_SMIN_V3_V3_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1181
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1182
  { IMAGE_ATOMIC_SMIN_V3_V4_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1183
  { IMAGE_ATOMIC_SMIN_V4_V1_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 1184
  { IMAGE_ATOMIC_SMIN_V4_V2_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 1185
  { IMAGE_ATOMIC_SMIN_V4_V3_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 1186
  { IMAGE_ATOMIC_SMIN_V4_V4_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 1187
  { IMAGE_ATOMIC_SUB_V1_V1_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 1188
  { IMAGE_ATOMIC_SUB_V1_V2_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1189
  { IMAGE_ATOMIC_SUB_V1_V3_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 1190
  { IMAGE_ATOMIC_SUB_V1_V4_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 1191
  { IMAGE_ATOMIC_SUB_V2_V1_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1192
  { IMAGE_ATOMIC_SUB_V3_V1_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1193
  { IMAGE_ATOMIC_SUB_V2_V2_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1194
  { IMAGE_ATOMIC_SUB_V3_V2_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1195
  { IMAGE_ATOMIC_SUB_V2_V3_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1196
  { IMAGE_ATOMIC_SUB_V3_V3_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1197
  { IMAGE_ATOMIC_SUB_V2_V4_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1198
  { IMAGE_ATOMIC_SUB_V3_V4_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1199
  { IMAGE_ATOMIC_SUB_V4_V1_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1200
  { IMAGE_ATOMIC_SUB_V4_V2_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1201
  { IMAGE_ATOMIC_SUB_V4_V3_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1202
  { IMAGE_ATOMIC_SUB_V4_V4_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1203
  { IMAGE_ATOMIC_SUB_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 1204
  { IMAGE_ATOMIC_SUB_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 1205
  { IMAGE_ATOMIC_SUB_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 1206
  { IMAGE_ATOMIC_SUB_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1207
  { IMAGE_ATOMIC_SUB_V3_V2_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1208
  { IMAGE_ATOMIC_SUB_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1209
  { IMAGE_ATOMIC_SUB_V3_V3_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1210
  { IMAGE_ATOMIC_SUB_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1211
  { IMAGE_ATOMIC_SUB_V3_V4_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1212
  { IMAGE_ATOMIC_SUB_V4_V2_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1213
  { IMAGE_ATOMIC_SUB_V4_V3_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1214
  { IMAGE_ATOMIC_SUB_V4_V4_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1215
  { IMAGE_ATOMIC_SUB_V1_V1_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 1216
  { IMAGE_ATOMIC_SUB_V1_V2_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 1217
  { IMAGE_ATOMIC_SUB_V1_V3_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 1218
  { IMAGE_ATOMIC_SUB_V1_V4_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 1219
  { IMAGE_ATOMIC_SUB_V2_V1_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1220
  { IMAGE_ATOMIC_SUB_V3_V1_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1221
  { IMAGE_ATOMIC_SUB_V2_V2_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1222
  { IMAGE_ATOMIC_SUB_V3_V2_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1223
  { IMAGE_ATOMIC_SUB_V2_V3_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1224
  { IMAGE_ATOMIC_SUB_V3_V3_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1225
  { IMAGE_ATOMIC_SUB_V2_V4_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1226
  { IMAGE_ATOMIC_SUB_V3_V4_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1227
  { IMAGE_ATOMIC_SUB_V4_V1_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1228
  { IMAGE_ATOMIC_SUB_V4_V2_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1229
  { IMAGE_ATOMIC_SUB_V4_V3_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1230
  { IMAGE_ATOMIC_SUB_V4_V4_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1231
  { IMAGE_ATOMIC_SUB_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 1232
  { IMAGE_ATOMIC_SUB_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 1233
  { IMAGE_ATOMIC_SUB_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 1234
  { IMAGE_ATOMIC_SUB_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1235
  { IMAGE_ATOMIC_SUB_V3_V2_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1236
  { IMAGE_ATOMIC_SUB_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1237
  { IMAGE_ATOMIC_SUB_V3_V3_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1238
  { IMAGE_ATOMIC_SUB_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1239
  { IMAGE_ATOMIC_SUB_V3_V4_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1240
  { IMAGE_ATOMIC_SUB_V4_V2_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1241
  { IMAGE_ATOMIC_SUB_V4_V3_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1242
  { IMAGE_ATOMIC_SUB_V4_V4_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1243
  { IMAGE_ATOMIC_SUB_V1_V1_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 1244
  { IMAGE_ATOMIC_SUB_V1_V2_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 1245
  { IMAGE_ATOMIC_SUB_V1_V3_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 1246
  { IMAGE_ATOMIC_SUB_V1_V4_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 1247
  { IMAGE_ATOMIC_SUB_V2_V1_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1248
  { IMAGE_ATOMIC_SUB_V3_V1_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1249
  { IMAGE_ATOMIC_SUB_V2_V2_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1250
  { IMAGE_ATOMIC_SUB_V3_V2_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1251
  { IMAGE_ATOMIC_SUB_V2_V3_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1252
  { IMAGE_ATOMIC_SUB_V3_V3_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1253
  { IMAGE_ATOMIC_SUB_V2_V4_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1254
  { IMAGE_ATOMIC_SUB_V3_V4_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1255
  { IMAGE_ATOMIC_SUB_V4_V1_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 1256
  { IMAGE_ATOMIC_SUB_V4_V2_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1257
  { IMAGE_ATOMIC_SUB_V4_V3_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1258
  { IMAGE_ATOMIC_SUB_V4_V4_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1259
  { IMAGE_ATOMIC_SUB_V1_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 1260
  { IMAGE_ATOMIC_SUB_V1_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 1261
  { IMAGE_ATOMIC_SUB_V1_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 1262
  { IMAGE_ATOMIC_SUB_V1_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 1263
  { IMAGE_ATOMIC_SUB_V2_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1264
  { IMAGE_ATOMIC_SUB_V3_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1265
  { IMAGE_ATOMIC_SUB_V2_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1266
  { IMAGE_ATOMIC_SUB_V3_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1267
  { IMAGE_ATOMIC_SUB_V2_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1268
  { IMAGE_ATOMIC_SUB_V3_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1269
  { IMAGE_ATOMIC_SUB_V2_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1270
  { IMAGE_ATOMIC_SUB_V3_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1271
  { IMAGE_ATOMIC_SUB_V4_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1272
  { IMAGE_ATOMIC_SUB_V4_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1273
  { IMAGE_ATOMIC_SUB_V4_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1274
  { IMAGE_ATOMIC_SUB_V4_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1275
  { IMAGE_ATOMIC_SUB_V1_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 1276
  { IMAGE_ATOMIC_SUB_V1_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 1277
  { IMAGE_ATOMIC_SUB_V1_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 1278
  { IMAGE_ATOMIC_SUB_V1_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 1279
  { IMAGE_ATOMIC_SUB_V2_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1280
  { IMAGE_ATOMIC_SUB_V3_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1281
  { IMAGE_ATOMIC_SUB_V2_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1282
  { IMAGE_ATOMIC_SUB_V3_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1283
  { IMAGE_ATOMIC_SUB_V2_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1284
  { IMAGE_ATOMIC_SUB_V3_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1285
  { IMAGE_ATOMIC_SUB_V2_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1286
  { IMAGE_ATOMIC_SUB_V3_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1287
  { IMAGE_ATOMIC_SUB_V4_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 1288
  { IMAGE_ATOMIC_SUB_V4_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 1289
  { IMAGE_ATOMIC_SUB_V4_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 1290
  { IMAGE_ATOMIC_SUB_V4_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 1291
  { IMAGE_ATOMIC_SUB_V1_V1_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 1292
  { IMAGE_ATOMIC_SUB_V1_V2_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 1293
  { IMAGE_ATOMIC_SUB_V1_V3_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 1294
  { IMAGE_ATOMIC_SUB_V1_V4_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 1295
  { IMAGE_ATOMIC_SUB_V2_V1_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1296
  { IMAGE_ATOMIC_SUB_V3_V1_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1297
  { IMAGE_ATOMIC_SUB_V2_V2_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1298
  { IMAGE_ATOMIC_SUB_V3_V2_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1299
  { IMAGE_ATOMIC_SUB_V2_V3_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1300
  { IMAGE_ATOMIC_SUB_V3_V3_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1301
  { IMAGE_ATOMIC_SUB_V2_V4_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1302
  { IMAGE_ATOMIC_SUB_V3_V4_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1303
  { IMAGE_ATOMIC_SUB_V4_V1_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 1304
  { IMAGE_ATOMIC_SUB_V4_V2_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 1305
  { IMAGE_ATOMIC_SUB_V4_V3_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 1306
  { IMAGE_ATOMIC_SUB_V4_V4_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 1307
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 1308
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1309
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 1310
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 1311
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1312
  { IMAGE_ATOMIC_SWAP_V3_V1_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1313
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1314
  { IMAGE_ATOMIC_SWAP_V3_V2_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1315
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1316
  { IMAGE_ATOMIC_SWAP_V3_V3_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1317
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1318
  { IMAGE_ATOMIC_SWAP_V3_V4_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1319
  { IMAGE_ATOMIC_SWAP_V4_V1_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1320
  { IMAGE_ATOMIC_SWAP_V4_V2_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1321
  { IMAGE_ATOMIC_SWAP_V4_V3_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1322
  { IMAGE_ATOMIC_SWAP_V4_V4_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1323
  { IMAGE_ATOMIC_SWAP_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 1324
  { IMAGE_ATOMIC_SWAP_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 1325
  { IMAGE_ATOMIC_SWAP_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 1326
  { IMAGE_ATOMIC_SWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1327
  { IMAGE_ATOMIC_SWAP_V3_V2_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1328
  { IMAGE_ATOMIC_SWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1329
  { IMAGE_ATOMIC_SWAP_V3_V3_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1330
  { IMAGE_ATOMIC_SWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1331
  { IMAGE_ATOMIC_SWAP_V3_V4_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1332
  { IMAGE_ATOMIC_SWAP_V4_V2_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1333
  { IMAGE_ATOMIC_SWAP_V4_V3_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1334
  { IMAGE_ATOMIC_SWAP_V4_V4_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1335
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 1336
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 1337
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 1338
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 1339
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1340
  { IMAGE_ATOMIC_SWAP_V3_V1_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1341
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1342
  { IMAGE_ATOMIC_SWAP_V3_V2_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1343
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1344
  { IMAGE_ATOMIC_SWAP_V3_V3_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1345
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1346
  { IMAGE_ATOMIC_SWAP_V3_V4_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1347
  { IMAGE_ATOMIC_SWAP_V4_V1_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1348
  { IMAGE_ATOMIC_SWAP_V4_V2_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1349
  { IMAGE_ATOMIC_SWAP_V4_V3_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1350
  { IMAGE_ATOMIC_SWAP_V4_V4_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1351
  { IMAGE_ATOMIC_SWAP_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 1352
  { IMAGE_ATOMIC_SWAP_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 1353
  { IMAGE_ATOMIC_SWAP_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 1354
  { IMAGE_ATOMIC_SWAP_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1355
  { IMAGE_ATOMIC_SWAP_V3_V2_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1356
  { IMAGE_ATOMIC_SWAP_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1357
  { IMAGE_ATOMIC_SWAP_V3_V3_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1358
  { IMAGE_ATOMIC_SWAP_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1359
  { IMAGE_ATOMIC_SWAP_V3_V4_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1360
  { IMAGE_ATOMIC_SWAP_V4_V2_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1361
  { IMAGE_ATOMIC_SWAP_V4_V3_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1362
  { IMAGE_ATOMIC_SWAP_V4_V4_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1363
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 1364
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 1365
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 1366
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 1367
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1368
  { IMAGE_ATOMIC_SWAP_V3_V1_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1369
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1370
  { IMAGE_ATOMIC_SWAP_V3_V2_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1371
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1372
  { IMAGE_ATOMIC_SWAP_V3_V3_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1373
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1374
  { IMAGE_ATOMIC_SWAP_V3_V4_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1375
  { IMAGE_ATOMIC_SWAP_V4_V1_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 1376
  { IMAGE_ATOMIC_SWAP_V4_V2_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1377
  { IMAGE_ATOMIC_SWAP_V4_V3_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1378
  { IMAGE_ATOMIC_SWAP_V4_V4_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1379
  { IMAGE_ATOMIC_SWAP_V1_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 1380
  { IMAGE_ATOMIC_SWAP_V1_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 1381
  { IMAGE_ATOMIC_SWAP_V1_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 1382
  { IMAGE_ATOMIC_SWAP_V1_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 1383
  { IMAGE_ATOMIC_SWAP_V2_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1384
  { IMAGE_ATOMIC_SWAP_V3_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1385
  { IMAGE_ATOMIC_SWAP_V2_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1386
  { IMAGE_ATOMIC_SWAP_V3_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1387
  { IMAGE_ATOMIC_SWAP_V2_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1388
  { IMAGE_ATOMIC_SWAP_V3_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1389
  { IMAGE_ATOMIC_SWAP_V2_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1390
  { IMAGE_ATOMIC_SWAP_V3_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1391
  { IMAGE_ATOMIC_SWAP_V4_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1392
  { IMAGE_ATOMIC_SWAP_V4_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1393
  { IMAGE_ATOMIC_SWAP_V4_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1394
  { IMAGE_ATOMIC_SWAP_V4_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1395
  { IMAGE_ATOMIC_SWAP_V1_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 1396
  { IMAGE_ATOMIC_SWAP_V1_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 1397
  { IMAGE_ATOMIC_SWAP_V1_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 1398
  { IMAGE_ATOMIC_SWAP_V1_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 1399
  { IMAGE_ATOMIC_SWAP_V2_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1400
  { IMAGE_ATOMIC_SWAP_V3_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1401
  { IMAGE_ATOMIC_SWAP_V2_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1402
  { IMAGE_ATOMIC_SWAP_V3_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1403
  { IMAGE_ATOMIC_SWAP_V2_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1404
  { IMAGE_ATOMIC_SWAP_V3_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1405
  { IMAGE_ATOMIC_SWAP_V2_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1406
  { IMAGE_ATOMIC_SWAP_V3_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1407
  { IMAGE_ATOMIC_SWAP_V4_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 1408
  { IMAGE_ATOMIC_SWAP_V4_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 1409
  { IMAGE_ATOMIC_SWAP_V4_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 1410
  { IMAGE_ATOMIC_SWAP_V4_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 1411
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 1412
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 1413
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 1414
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 1415
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1416
  { IMAGE_ATOMIC_SWAP_V3_V1_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1417
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1418
  { IMAGE_ATOMIC_SWAP_V3_V2_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1419
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1420
  { IMAGE_ATOMIC_SWAP_V3_V3_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1421
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1422
  { IMAGE_ATOMIC_SWAP_V3_V4_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1423
  { IMAGE_ATOMIC_SWAP_V4_V1_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 1424
  { IMAGE_ATOMIC_SWAP_V4_V2_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 1425
  { IMAGE_ATOMIC_SWAP_V4_V3_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 1426
  { IMAGE_ATOMIC_SWAP_V4_V4_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 1427
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 1428
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1429
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 1430
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 1431
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1432
  { IMAGE_ATOMIC_UMAX_V3_V1_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1433
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1434
  { IMAGE_ATOMIC_UMAX_V3_V2_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1435
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1436
  { IMAGE_ATOMIC_UMAX_V3_V3_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1437
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1438
  { IMAGE_ATOMIC_UMAX_V3_V4_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1439
  { IMAGE_ATOMIC_UMAX_V4_V1_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1440
  { IMAGE_ATOMIC_UMAX_V4_V2_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1441
  { IMAGE_ATOMIC_UMAX_V4_V3_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1442
  { IMAGE_ATOMIC_UMAX_V4_V4_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1443
  { IMAGE_ATOMIC_UMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 1444
  { IMAGE_ATOMIC_UMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 1445
  { IMAGE_ATOMIC_UMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 1446
  { IMAGE_ATOMIC_UMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1447
  { IMAGE_ATOMIC_UMAX_V3_V2_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1448
  { IMAGE_ATOMIC_UMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1449
  { IMAGE_ATOMIC_UMAX_V3_V3_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1450
  { IMAGE_ATOMIC_UMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1451
  { IMAGE_ATOMIC_UMAX_V3_V4_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1452
  { IMAGE_ATOMIC_UMAX_V4_V2_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1453
  { IMAGE_ATOMIC_UMAX_V4_V3_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1454
  { IMAGE_ATOMIC_UMAX_V4_V4_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1455
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 1456
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 1457
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 1458
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 1459
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1460
  { IMAGE_ATOMIC_UMAX_V3_V1_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1461
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1462
  { IMAGE_ATOMIC_UMAX_V3_V2_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1463
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1464
  { IMAGE_ATOMIC_UMAX_V3_V3_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1465
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1466
  { IMAGE_ATOMIC_UMAX_V3_V4_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1467
  { IMAGE_ATOMIC_UMAX_V4_V1_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1468
  { IMAGE_ATOMIC_UMAX_V4_V2_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1469
  { IMAGE_ATOMIC_UMAX_V4_V3_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1470
  { IMAGE_ATOMIC_UMAX_V4_V4_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1471
  { IMAGE_ATOMIC_UMAX_V1_V2_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 1472
  { IMAGE_ATOMIC_UMAX_V1_V3_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 1473
  { IMAGE_ATOMIC_UMAX_V1_V4_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 1474
  { IMAGE_ATOMIC_UMAX_V2_V2_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1475
  { IMAGE_ATOMIC_UMAX_V3_V2_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1476
  { IMAGE_ATOMIC_UMAX_V2_V3_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1477
  { IMAGE_ATOMIC_UMAX_V3_V3_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1478
  { IMAGE_ATOMIC_UMAX_V2_V4_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1479
  { IMAGE_ATOMIC_UMAX_V3_V4_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1480
  { IMAGE_ATOMIC_UMAX_V4_V2_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1481
  { IMAGE_ATOMIC_UMAX_V4_V3_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1482
  { IMAGE_ATOMIC_UMAX_V4_V4_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1483
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 1484
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 1485
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 1486
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 1487
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1488
  { IMAGE_ATOMIC_UMAX_V3_V1_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1489
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1490
  { IMAGE_ATOMIC_UMAX_V3_V2_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1491
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1492
  { IMAGE_ATOMIC_UMAX_V3_V3_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1493
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1494
  { IMAGE_ATOMIC_UMAX_V3_V4_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1495
  { IMAGE_ATOMIC_UMAX_V4_V1_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 1496
  { IMAGE_ATOMIC_UMAX_V4_V2_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1497
  { IMAGE_ATOMIC_UMAX_V4_V3_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1498
  { IMAGE_ATOMIC_UMAX_V4_V4_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1499
  { IMAGE_ATOMIC_UMAX_V1_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 1500
  { IMAGE_ATOMIC_UMAX_V1_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 1501
  { IMAGE_ATOMIC_UMAX_V1_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 1502
  { IMAGE_ATOMIC_UMAX_V1_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 1503
  { IMAGE_ATOMIC_UMAX_V2_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1504
  { IMAGE_ATOMIC_UMAX_V3_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1505
  { IMAGE_ATOMIC_UMAX_V2_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1506
  { IMAGE_ATOMIC_UMAX_V3_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1507
  { IMAGE_ATOMIC_UMAX_V2_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1508
  { IMAGE_ATOMIC_UMAX_V3_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1509
  { IMAGE_ATOMIC_UMAX_V2_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1510
  { IMAGE_ATOMIC_UMAX_V3_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1511
  { IMAGE_ATOMIC_UMAX_V4_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1512
  { IMAGE_ATOMIC_UMAX_V4_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1513
  { IMAGE_ATOMIC_UMAX_V4_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1514
  { IMAGE_ATOMIC_UMAX_V4_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1515
  { IMAGE_ATOMIC_UMAX_V1_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 1516
  { IMAGE_ATOMIC_UMAX_V1_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 1517
  { IMAGE_ATOMIC_UMAX_V1_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 1518
  { IMAGE_ATOMIC_UMAX_V1_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 1519
  { IMAGE_ATOMIC_UMAX_V2_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1520
  { IMAGE_ATOMIC_UMAX_V3_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1521
  { IMAGE_ATOMIC_UMAX_V2_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1522
  { IMAGE_ATOMIC_UMAX_V3_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1523
  { IMAGE_ATOMIC_UMAX_V2_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1524
  { IMAGE_ATOMIC_UMAX_V3_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1525
  { IMAGE_ATOMIC_UMAX_V2_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1526
  { IMAGE_ATOMIC_UMAX_V3_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1527
  { IMAGE_ATOMIC_UMAX_V4_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 1528
  { IMAGE_ATOMIC_UMAX_V4_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 1529
  { IMAGE_ATOMIC_UMAX_V4_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 1530
  { IMAGE_ATOMIC_UMAX_V4_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 1531
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 1532
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 1533
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 1534
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 1535
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1536
  { IMAGE_ATOMIC_UMAX_V3_V1_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1537
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1538
  { IMAGE_ATOMIC_UMAX_V3_V2_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1539
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1540
  { IMAGE_ATOMIC_UMAX_V3_V3_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1541
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1542
  { IMAGE_ATOMIC_UMAX_V3_V4_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1543
  { IMAGE_ATOMIC_UMAX_V4_V1_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 1544
  { IMAGE_ATOMIC_UMAX_V4_V2_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 1545
  { IMAGE_ATOMIC_UMAX_V4_V3_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 1546
  { IMAGE_ATOMIC_UMAX_V4_V4_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 1547
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 1548
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1549
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 1550
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 1551
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1552
  { IMAGE_ATOMIC_UMIN_V3_V1_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1553
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1554
  { IMAGE_ATOMIC_UMIN_V3_V2_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1555
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1556
  { IMAGE_ATOMIC_UMIN_V3_V3_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1557
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1558
  { IMAGE_ATOMIC_UMIN_V3_V4_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1559
  { IMAGE_ATOMIC_UMIN_V4_V1_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1560
  { IMAGE_ATOMIC_UMIN_V4_V2_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1561
  { IMAGE_ATOMIC_UMIN_V4_V3_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1562
  { IMAGE_ATOMIC_UMIN_V4_V4_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1563
  { IMAGE_ATOMIC_UMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 1564
  { IMAGE_ATOMIC_UMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 1565
  { IMAGE_ATOMIC_UMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 1566
  { IMAGE_ATOMIC_UMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1567
  { IMAGE_ATOMIC_UMIN_V3_V2_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1568
  { IMAGE_ATOMIC_UMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1569
  { IMAGE_ATOMIC_UMIN_V3_V3_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1570
  { IMAGE_ATOMIC_UMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1571
  { IMAGE_ATOMIC_UMIN_V3_V4_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1572
  { IMAGE_ATOMIC_UMIN_V4_V2_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1573
  { IMAGE_ATOMIC_UMIN_V4_V3_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1574
  { IMAGE_ATOMIC_UMIN_V4_V4_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1575
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 1576
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 1577
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 1578
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 1579
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1580
  { IMAGE_ATOMIC_UMIN_V3_V1_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1581
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1582
  { IMAGE_ATOMIC_UMIN_V3_V2_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1583
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1584
  { IMAGE_ATOMIC_UMIN_V3_V3_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1585
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1586
  { IMAGE_ATOMIC_UMIN_V3_V4_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1587
  { IMAGE_ATOMIC_UMIN_V4_V1_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1588
  { IMAGE_ATOMIC_UMIN_V4_V2_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1589
  { IMAGE_ATOMIC_UMIN_V4_V3_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1590
  { IMAGE_ATOMIC_UMIN_V4_V4_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1591
  { IMAGE_ATOMIC_UMIN_V1_V2_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 1592
  { IMAGE_ATOMIC_UMIN_V1_V3_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 1593
  { IMAGE_ATOMIC_UMIN_V1_V4_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 1594
  { IMAGE_ATOMIC_UMIN_V2_V2_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1595
  { IMAGE_ATOMIC_UMIN_V3_V2_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1596
  { IMAGE_ATOMIC_UMIN_V2_V3_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1597
  { IMAGE_ATOMIC_UMIN_V3_V3_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1598
  { IMAGE_ATOMIC_UMIN_V2_V4_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1599
  { IMAGE_ATOMIC_UMIN_V3_V4_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1600
  { IMAGE_ATOMIC_UMIN_V4_V2_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1601
  { IMAGE_ATOMIC_UMIN_V4_V3_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1602
  { IMAGE_ATOMIC_UMIN_V4_V4_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1603
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 1604
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 1605
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 1606
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 1607
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1608
  { IMAGE_ATOMIC_UMIN_V3_V1_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1609
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1610
  { IMAGE_ATOMIC_UMIN_V3_V2_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1611
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1612
  { IMAGE_ATOMIC_UMIN_V3_V3_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1613
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1614
  { IMAGE_ATOMIC_UMIN_V3_V4_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1615
  { IMAGE_ATOMIC_UMIN_V4_V1_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 1616
  { IMAGE_ATOMIC_UMIN_V4_V2_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1617
  { IMAGE_ATOMIC_UMIN_V4_V3_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1618
  { IMAGE_ATOMIC_UMIN_V4_V4_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1619
  { IMAGE_ATOMIC_UMIN_V1_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 1620
  { IMAGE_ATOMIC_UMIN_V1_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 1621
  { IMAGE_ATOMIC_UMIN_V1_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 1622
  { IMAGE_ATOMIC_UMIN_V1_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 1623
  { IMAGE_ATOMIC_UMIN_V2_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1624
  { IMAGE_ATOMIC_UMIN_V3_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1625
  { IMAGE_ATOMIC_UMIN_V2_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1626
  { IMAGE_ATOMIC_UMIN_V3_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1627
  { IMAGE_ATOMIC_UMIN_V2_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1628
  { IMAGE_ATOMIC_UMIN_V3_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1629
  { IMAGE_ATOMIC_UMIN_V2_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1630
  { IMAGE_ATOMIC_UMIN_V3_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1631
  { IMAGE_ATOMIC_UMIN_V4_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1632
  { IMAGE_ATOMIC_UMIN_V4_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1633
  { IMAGE_ATOMIC_UMIN_V4_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1634
  { IMAGE_ATOMIC_UMIN_V4_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1635
  { IMAGE_ATOMIC_UMIN_V1_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 1636
  { IMAGE_ATOMIC_UMIN_V1_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 1637
  { IMAGE_ATOMIC_UMIN_V1_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 1638
  { IMAGE_ATOMIC_UMIN_V1_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 1639
  { IMAGE_ATOMIC_UMIN_V2_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1640
  { IMAGE_ATOMIC_UMIN_V3_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1641
  { IMAGE_ATOMIC_UMIN_V2_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1642
  { IMAGE_ATOMIC_UMIN_V3_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1643
  { IMAGE_ATOMIC_UMIN_V2_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1644
  { IMAGE_ATOMIC_UMIN_V3_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1645
  { IMAGE_ATOMIC_UMIN_V2_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1646
  { IMAGE_ATOMIC_UMIN_V3_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1647
  { IMAGE_ATOMIC_UMIN_V4_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 1648
  { IMAGE_ATOMIC_UMIN_V4_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 1649
  { IMAGE_ATOMIC_UMIN_V4_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 1650
  { IMAGE_ATOMIC_UMIN_V4_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 1651
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 1652
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 1653
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 1654
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 1655
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1656
  { IMAGE_ATOMIC_UMIN_V3_V1_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1657
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1658
  { IMAGE_ATOMIC_UMIN_V3_V2_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1659
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1660
  { IMAGE_ATOMIC_UMIN_V3_V3_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1661
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1662
  { IMAGE_ATOMIC_UMIN_V3_V4_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1663
  { IMAGE_ATOMIC_UMIN_V4_V1_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 1664
  { IMAGE_ATOMIC_UMIN_V4_V2_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 1665
  { IMAGE_ATOMIC_UMIN_V4_V3_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 1666
  { IMAGE_ATOMIC_UMIN_V4_V4_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 1667
  { IMAGE_ATOMIC_XOR_V1_V1_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 1668
  { IMAGE_ATOMIC_XOR_V1_V2_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1669
  { IMAGE_ATOMIC_XOR_V1_V3_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 1670
  { IMAGE_ATOMIC_XOR_V1_V4_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 1671
  { IMAGE_ATOMIC_XOR_V2_V1_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1672
  { IMAGE_ATOMIC_XOR_V3_V1_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1673
  { IMAGE_ATOMIC_XOR_V2_V2_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1674
  { IMAGE_ATOMIC_XOR_V3_V2_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1675
  { IMAGE_ATOMIC_XOR_V2_V3_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1676
  { IMAGE_ATOMIC_XOR_V3_V3_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1677
  { IMAGE_ATOMIC_XOR_V2_V4_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1678
  { IMAGE_ATOMIC_XOR_V3_V4_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1679
  { IMAGE_ATOMIC_XOR_V4_V1_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1680
  { IMAGE_ATOMIC_XOR_V4_V2_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1681
  { IMAGE_ATOMIC_XOR_V4_V3_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1682
  { IMAGE_ATOMIC_XOR_V4_V4_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1683
  { IMAGE_ATOMIC_XOR_V1_V2_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 1684
  { IMAGE_ATOMIC_XOR_V1_V3_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 1685
  { IMAGE_ATOMIC_XOR_V1_V4_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 1686
  { IMAGE_ATOMIC_XOR_V2_V2_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1687
  { IMAGE_ATOMIC_XOR_V3_V2_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1688
  { IMAGE_ATOMIC_XOR_V2_V3_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1689
  { IMAGE_ATOMIC_XOR_V3_V3_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1690
  { IMAGE_ATOMIC_XOR_V2_V4_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1691
  { IMAGE_ATOMIC_XOR_V3_V4_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1692
  { IMAGE_ATOMIC_XOR_V4_V2_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1693
  { IMAGE_ATOMIC_XOR_V4_V3_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1694
  { IMAGE_ATOMIC_XOR_V4_V4_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1695
  { IMAGE_ATOMIC_XOR_V1_V1_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 1696
  { IMAGE_ATOMIC_XOR_V1_V2_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 1697
  { IMAGE_ATOMIC_XOR_V1_V3_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 1698
  { IMAGE_ATOMIC_XOR_V1_V4_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 1699
  { IMAGE_ATOMIC_XOR_V2_V1_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1700
  { IMAGE_ATOMIC_XOR_V3_V1_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1701
  { IMAGE_ATOMIC_XOR_V2_V2_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1702
  { IMAGE_ATOMIC_XOR_V3_V2_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1703
  { IMAGE_ATOMIC_XOR_V2_V3_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1704
  { IMAGE_ATOMIC_XOR_V3_V3_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1705
  { IMAGE_ATOMIC_XOR_V2_V4_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1706
  { IMAGE_ATOMIC_XOR_V3_V4_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1707
  { IMAGE_ATOMIC_XOR_V4_V1_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1708
  { IMAGE_ATOMIC_XOR_V4_V2_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1709
  { IMAGE_ATOMIC_XOR_V4_V3_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1710
  { IMAGE_ATOMIC_XOR_V4_V4_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1711
  { IMAGE_ATOMIC_XOR_V1_V2_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 1712
  { IMAGE_ATOMIC_XOR_V1_V3_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 1713
  { IMAGE_ATOMIC_XOR_V1_V4_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 1714
  { IMAGE_ATOMIC_XOR_V2_V2_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1715
  { IMAGE_ATOMIC_XOR_V3_V2_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1716
  { IMAGE_ATOMIC_XOR_V2_V3_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1717
  { IMAGE_ATOMIC_XOR_V3_V3_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1718
  { IMAGE_ATOMIC_XOR_V2_V4_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1719
  { IMAGE_ATOMIC_XOR_V3_V4_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1720
  { IMAGE_ATOMIC_XOR_V4_V2_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1721
  { IMAGE_ATOMIC_XOR_V4_V3_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1722
  { IMAGE_ATOMIC_XOR_V4_V4_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1723
  { IMAGE_ATOMIC_XOR_V1_V1_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 1724
  { IMAGE_ATOMIC_XOR_V1_V2_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 1725
  { IMAGE_ATOMIC_XOR_V1_V3_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 1726
  { IMAGE_ATOMIC_XOR_V1_V4_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 1727
  { IMAGE_ATOMIC_XOR_V2_V1_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1728
  { IMAGE_ATOMIC_XOR_V3_V1_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1729
  { IMAGE_ATOMIC_XOR_V2_V2_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1730
  { IMAGE_ATOMIC_XOR_V3_V2_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1731
  { IMAGE_ATOMIC_XOR_V2_V3_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1732
  { IMAGE_ATOMIC_XOR_V3_V3_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1733
  { IMAGE_ATOMIC_XOR_V2_V4_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1734
  { IMAGE_ATOMIC_XOR_V3_V4_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1735
  { IMAGE_ATOMIC_XOR_V4_V1_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 1736
  { IMAGE_ATOMIC_XOR_V4_V2_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1737
  { IMAGE_ATOMIC_XOR_V4_V3_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1738
  { IMAGE_ATOMIC_XOR_V4_V4_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1739
  { IMAGE_ATOMIC_XOR_V1_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 1740
  { IMAGE_ATOMIC_XOR_V1_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 1741
  { IMAGE_ATOMIC_XOR_V1_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 1742
  { IMAGE_ATOMIC_XOR_V1_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 1743
  { IMAGE_ATOMIC_XOR_V2_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1744
  { IMAGE_ATOMIC_XOR_V3_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1745
  { IMAGE_ATOMIC_XOR_V2_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1746
  { IMAGE_ATOMIC_XOR_V3_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1747
  { IMAGE_ATOMIC_XOR_V2_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1748
  { IMAGE_ATOMIC_XOR_V3_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1749
  { IMAGE_ATOMIC_XOR_V2_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1750
  { IMAGE_ATOMIC_XOR_V3_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1751
  { IMAGE_ATOMIC_XOR_V4_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1752
  { IMAGE_ATOMIC_XOR_V4_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1753
  { IMAGE_ATOMIC_XOR_V4_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1754
  { IMAGE_ATOMIC_XOR_V4_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1755
  { IMAGE_ATOMIC_XOR_V1_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 1756
  { IMAGE_ATOMIC_XOR_V1_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 1757
  { IMAGE_ATOMIC_XOR_V1_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 1758
  { IMAGE_ATOMIC_XOR_V1_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 1759
  { IMAGE_ATOMIC_XOR_V2_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1760
  { IMAGE_ATOMIC_XOR_V3_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1761
  { IMAGE_ATOMIC_XOR_V2_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1762
  { IMAGE_ATOMIC_XOR_V3_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1763
  { IMAGE_ATOMIC_XOR_V2_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1764
  { IMAGE_ATOMIC_XOR_V3_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1765
  { IMAGE_ATOMIC_XOR_V2_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1766
  { IMAGE_ATOMIC_XOR_V3_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1767
  { IMAGE_ATOMIC_XOR_V4_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 1768
  { IMAGE_ATOMIC_XOR_V4_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 1769
  { IMAGE_ATOMIC_XOR_V4_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 1770
  { IMAGE_ATOMIC_XOR_V4_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 1771
  { IMAGE_ATOMIC_XOR_V1_V1_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 1772
  { IMAGE_ATOMIC_XOR_V1_V2_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 1773
  { IMAGE_ATOMIC_XOR_V1_V3_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 1774
  { IMAGE_ATOMIC_XOR_V1_V4_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 1775
  { IMAGE_ATOMIC_XOR_V2_V1_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1776
  { IMAGE_ATOMIC_XOR_V3_V1_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1777
  { IMAGE_ATOMIC_XOR_V2_V2_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1778
  { IMAGE_ATOMIC_XOR_V3_V2_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1779
  { IMAGE_ATOMIC_XOR_V2_V3_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1780
  { IMAGE_ATOMIC_XOR_V3_V3_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1781
  { IMAGE_ATOMIC_XOR_V2_V4_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1782
  { IMAGE_ATOMIC_XOR_V3_V4_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1783
  { IMAGE_ATOMIC_XOR_V4_V1_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 1784
  { IMAGE_ATOMIC_XOR_V4_V2_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 1785
  { IMAGE_ATOMIC_XOR_V4_V3_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 1786
  { IMAGE_ATOMIC_XOR_V4_V4_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 1787
  { IMAGE_BVH64_INTERSECT_RAY_sa_gfx10, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx10Default, 0x4, 0xC, 0x1 }, // 1788
  { IMAGE_BVH64_INTERSECT_RAY_nsa_gfx10, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx10NSA, 0x4, 0xC, 0xC }, // 1789
  { IMAGE_BVH64_INTERSECT_RAY_sa_gfx11, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx11Default, 0x4, 0xC, 0x1 }, // 1790
  { IMAGE_BVH64_INTERSECT_RAY_nsa_gfx11, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx11NSA, 0x4, 0xC, 0x5 }, // 1791
  { IMAGE_BVH64_INTERSECT_RAY_gfx12, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx12, 0x4, 0xC, 0x5 }, // 1792
  { IMAGE_BVH64_INTERSECT_RAY_a16_sa_gfx10, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 1793
  { IMAGE_BVH64_INTERSECT_RAY_a16_nsa_gfx10, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 1794
  { IMAGE_BVH64_INTERSECT_RAY_a16_sa_gfx11, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 1795
  { IMAGE_BVH64_INTERSECT_RAY_a16_nsa_gfx11, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx11NSA, 0x4, 0x9, 0x4 }, // 1796
  { IMAGE_BVH64_INTERSECT_RAY_a16_gfx12, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx12, 0x4, 0x9, 0x4 }, // 1797
  { IMAGE_BVH_INTERSECT_RAY_sa_gfx10, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 1798
  { IMAGE_BVH_INTERSECT_RAY_nsa_gfx10, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 1799
  { IMAGE_BVH_INTERSECT_RAY_sa_gfx11, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx11Default, 0x4, 0xB, 0x1 }, // 1800
  { IMAGE_BVH_INTERSECT_RAY_nsa_gfx11, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx11NSA, 0x4, 0xB, 0x5 }, // 1801
  { IMAGE_BVH_INTERSECT_RAY_gfx12, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx12, 0x4, 0xB, 0x5 }, // 1802
  { IMAGE_BVH_INTERSECT_RAY_a16_sa_gfx10, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1803
  { IMAGE_BVH_INTERSECT_RAY_a16_nsa_gfx10, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 1804
  { IMAGE_BVH_INTERSECT_RAY_a16_sa_gfx11, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1805
  { IMAGE_BVH_INTERSECT_RAY_a16_nsa_gfx11, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx11NSA, 0x4, 0x8, 0x4 }, // 1806
  { IMAGE_BVH_INTERSECT_RAY_a16_gfx12, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx12, 0x4, 0x8, 0x4 }, // 1807
  { IMAGE_GATHER4_V2_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1808
  { IMAGE_GATHER4_V2_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1809
  { IMAGE_GATHER4_V2_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1810
  { IMAGE_GATHER4_V2_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1811
  { IMAGE_GATHER4_V4_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1812
  { IMAGE_GATHER4_V4_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1813
  { IMAGE_GATHER4_V4_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1814
  { IMAGE_GATHER4_V4_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1815
  { IMAGE_GATHER4_V5_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 1816
  { IMAGE_GATHER4_V5_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1817
  { IMAGE_GATHER4_V5_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1818
  { IMAGE_GATHER4_V5_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1819
  { IMAGE_GATHER4_V2_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1820
  { IMAGE_GATHER4_V2_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1821
  { IMAGE_GATHER4_V4_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1822
  { IMAGE_GATHER4_V4_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1823
  { IMAGE_GATHER4_V5_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1824
  { IMAGE_GATHER4_V5_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1825
  { IMAGE_GATHER4_V2_V1_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1826
  { IMAGE_GATHER4_V2_V2_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1827
  { IMAGE_GATHER4_V2_V3_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1828
  { IMAGE_GATHER4_V2_V4_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1829
  { IMAGE_GATHER4_V4_V1_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1830
  { IMAGE_GATHER4_V4_V2_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1831
  { IMAGE_GATHER4_V4_V3_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1832
  { IMAGE_GATHER4_V4_V4_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1833
  { IMAGE_GATHER4_V5_V1_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 1834
  { IMAGE_GATHER4_V5_V2_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1835
  { IMAGE_GATHER4_V5_V3_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1836
  { IMAGE_GATHER4_V5_V4_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1837
  { IMAGE_GATHER4_V2_V2_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1838
  { IMAGE_GATHER4_V2_V3_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1839
  { IMAGE_GATHER4_V4_V2_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1840
  { IMAGE_GATHER4_V4_V3_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1841
  { IMAGE_GATHER4_V5_V2_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1842
  { IMAGE_GATHER4_V5_V3_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1843
  { IMAGE_GATHER4_V2_V1_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1844
  { IMAGE_GATHER4_V2_V2_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1845
  { IMAGE_GATHER4_V2_V3_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1846
  { IMAGE_GATHER4_V4_V1_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 1847
  { IMAGE_GATHER4_V4_V2_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1848
  { IMAGE_GATHER4_V4_V3_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1849
  { IMAGE_GATHER4_V5_V1_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 1850
  { IMAGE_GATHER4_V5_V2_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1851
  { IMAGE_GATHER4_V5_V3_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1852
  { IMAGE_GATHER4_V2_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1853
  { IMAGE_GATHER4_V2_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1854
  { IMAGE_GATHER4_V2_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1855
  { IMAGE_GATHER4_V2_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1856
  { IMAGE_GATHER4_V4_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1857
  { IMAGE_GATHER4_V4_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1858
  { IMAGE_GATHER4_V4_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1859
  { IMAGE_GATHER4_V4_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1860
  { IMAGE_GATHER4_V5_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 1861
  { IMAGE_GATHER4_V5_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1862
  { IMAGE_GATHER4_V5_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1863
  { IMAGE_GATHER4_V5_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1864
  { IMAGE_GATHER4H_V2_V1_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1865
  { IMAGE_GATHER4H_V2_V2_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1866
  { IMAGE_GATHER4H_V2_V3_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1867
  { IMAGE_GATHER4H_V2_V4_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1868
  { IMAGE_GATHER4H_V4_V1_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1869
  { IMAGE_GATHER4H_V4_V2_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1870
  { IMAGE_GATHER4H_V4_V3_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1871
  { IMAGE_GATHER4H_V4_V4_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1872
  { IMAGE_GATHER4H_V5_V1_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 1873
  { IMAGE_GATHER4H_V5_V2_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1874
  { IMAGE_GATHER4H_V5_V3_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1875
  { IMAGE_GATHER4H_V5_V4_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1876
  { IMAGE_GATHER4H_V2_V2_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1877
  { IMAGE_GATHER4H_V2_V3_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1878
  { IMAGE_GATHER4H_V4_V2_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1879
  { IMAGE_GATHER4H_V4_V3_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1880
  { IMAGE_GATHER4H_V5_V2_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1881
  { IMAGE_GATHER4H_V5_V3_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1882
  { IMAGE_GATHER4H_V2_V1_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1883
  { IMAGE_GATHER4H_V2_V2_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1884
  { IMAGE_GATHER4H_V2_V3_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1885
  { IMAGE_GATHER4H_V2_V4_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1886
  { IMAGE_GATHER4H_V4_V1_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1887
  { IMAGE_GATHER4H_V4_V2_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1888
  { IMAGE_GATHER4H_V4_V3_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1889
  { IMAGE_GATHER4H_V4_V4_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1890
  { IMAGE_GATHER4H_V5_V1_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 1891
  { IMAGE_GATHER4H_V5_V2_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1892
  { IMAGE_GATHER4H_V5_V3_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1893
  { IMAGE_GATHER4H_V5_V4_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1894
  { IMAGE_GATHER4H_V2_V2_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1895
  { IMAGE_GATHER4H_V2_V3_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1896
  { IMAGE_GATHER4H_V4_V2_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1897
  { IMAGE_GATHER4H_V4_V3_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1898
  { IMAGE_GATHER4H_V5_V2_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1899
  { IMAGE_GATHER4H_V5_V3_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1900
  { IMAGE_GATHER4H_V2_V1_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1901
  { IMAGE_GATHER4H_V2_V2_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1902
  { IMAGE_GATHER4H_V2_V3_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1903
  { IMAGE_GATHER4H_V4_V1_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 1904
  { IMAGE_GATHER4H_V4_V2_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1905
  { IMAGE_GATHER4H_V4_V3_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1906
  { IMAGE_GATHER4H_V5_V1_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 1907
  { IMAGE_GATHER4H_V5_V2_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1908
  { IMAGE_GATHER4H_V5_V3_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1909
  { IMAGE_GATHER4H_V2_V1, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1910
  { IMAGE_GATHER4H_V2_V2, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1911
  { IMAGE_GATHER4H_V2_V3, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1912
  { IMAGE_GATHER4H_V2_V4, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1913
  { IMAGE_GATHER4H_V4_V1, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1914
  { IMAGE_GATHER4H_V4_V2, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1915
  { IMAGE_GATHER4H_V4_V3, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1916
  { IMAGE_GATHER4H_V4_V4, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1917
  { IMAGE_GATHER4H_V5_V1, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 1918
  { IMAGE_GATHER4H_V5_V2, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1919
  { IMAGE_GATHER4H_V5_V3, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1920
  { IMAGE_GATHER4H_V5_V4, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1921
  { IMAGE_GATHER4_B_V2_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1922
  { IMAGE_GATHER4_B_V2_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1923
  { IMAGE_GATHER4_B_V2_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1924
  { IMAGE_GATHER4_B_V4_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1925
  { IMAGE_GATHER4_B_V4_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1926
  { IMAGE_GATHER4_B_V4_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1927
  { IMAGE_GATHER4_B_V5_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1928
  { IMAGE_GATHER4_B_V5_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1929
  { IMAGE_GATHER4_B_V5_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1930
  { IMAGE_GATHER4_B_V2_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1931
  { IMAGE_GATHER4_B_V2_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1932
  { IMAGE_GATHER4_B_V2_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1933
  { IMAGE_GATHER4_B_V4_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1934
  { IMAGE_GATHER4_B_V4_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1935
  { IMAGE_GATHER4_B_V4_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1936
  { IMAGE_GATHER4_B_V5_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1937
  { IMAGE_GATHER4_B_V5_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1938
  { IMAGE_GATHER4_B_V5_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1939
  { IMAGE_GATHER4_B_V2_V2_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1940
  { IMAGE_GATHER4_B_V2_V3_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1941
  { IMAGE_GATHER4_B_V2_V4_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1942
  { IMAGE_GATHER4_B_V4_V2_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1943
  { IMAGE_GATHER4_B_V4_V3_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1944
  { IMAGE_GATHER4_B_V4_V4_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1945
  { IMAGE_GATHER4_B_V5_V2_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1946
  { IMAGE_GATHER4_B_V5_V3_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1947
  { IMAGE_GATHER4_B_V5_V4_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1948
  { IMAGE_GATHER4_B_V2_V2_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1949
  { IMAGE_GATHER4_B_V2_V3_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1950
  { IMAGE_GATHER4_B_V2_V4_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1951
  { IMAGE_GATHER4_B_V4_V2_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1952
  { IMAGE_GATHER4_B_V4_V3_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1953
  { IMAGE_GATHER4_B_V4_V4_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1954
  { IMAGE_GATHER4_B_V5_V2_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1955
  { IMAGE_GATHER4_B_V5_V3_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1956
  { IMAGE_GATHER4_B_V5_V4_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1957
  { IMAGE_GATHER4_B_V2_V2_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1958
  { IMAGE_GATHER4_B_V2_V3_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1959
  { IMAGE_GATHER4_B_V2_V4_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1960
  { IMAGE_GATHER4_B_V4_V2_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1961
  { IMAGE_GATHER4_B_V4_V3_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1962
  { IMAGE_GATHER4_B_V4_V4_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1963
  { IMAGE_GATHER4_B_V5_V2_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1964
  { IMAGE_GATHER4_B_V5_V3_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1965
  { IMAGE_GATHER4_B_V5_V4_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1966
  { IMAGE_GATHER4_B_V2_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1967
  { IMAGE_GATHER4_B_V2_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1968
  { IMAGE_GATHER4_B_V2_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1969
  { IMAGE_GATHER4_B_V4_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1970
  { IMAGE_GATHER4_B_V4_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1971
  { IMAGE_GATHER4_B_V4_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1972
  { IMAGE_GATHER4_B_V5_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1973
  { IMAGE_GATHER4_B_V5_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1974
  { IMAGE_GATHER4_B_V5_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1975
  { IMAGE_GATHER4_B_CL_V2_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1976
  { IMAGE_GATHER4_B_CL_V2_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1977
  { IMAGE_GATHER4_B_CL_V2_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1978
  { IMAGE_GATHER4_B_CL_V2_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1979
  { IMAGE_GATHER4_B_CL_V2_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1980
  { IMAGE_GATHER4_B_CL_V4_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1981
  { IMAGE_GATHER4_B_CL_V4_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1982
  { IMAGE_GATHER4_B_CL_V4_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1983
  { IMAGE_GATHER4_B_CL_V4_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1984
  { IMAGE_GATHER4_B_CL_V4_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1985
  { IMAGE_GATHER4_B_CL_V5_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1986
  { IMAGE_GATHER4_B_CL_V5_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1987
  { IMAGE_GATHER4_B_CL_V5_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1988
  { IMAGE_GATHER4_B_CL_V5_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1989
  { IMAGE_GATHER4_B_CL_V5_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1990
  { IMAGE_GATHER4_B_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1991
  { IMAGE_GATHER4_B_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1992
  { IMAGE_GATHER4_B_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1993
  { IMAGE_GATHER4_B_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1994
  { IMAGE_GATHER4_B_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1995
  { IMAGE_GATHER4_B_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1996
  { IMAGE_GATHER4_B_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1997
  { IMAGE_GATHER4_B_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1998
  { IMAGE_GATHER4_B_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1999
  { IMAGE_GATHER4_B_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2000
  { IMAGE_GATHER4_B_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2001
  { IMAGE_GATHER4_B_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2002
  { IMAGE_GATHER4_B_CL_V2_V2_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2003
  { IMAGE_GATHER4_B_CL_V2_V3_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2004
  { IMAGE_GATHER4_B_CL_V2_V4_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2005
  { IMAGE_GATHER4_B_CL_V2_V5_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 2006
  { IMAGE_GATHER4_B_CL_V2_V8_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 2007
  { IMAGE_GATHER4_B_CL_V4_V2_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2008
  { IMAGE_GATHER4_B_CL_V4_V3_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2009
  { IMAGE_GATHER4_B_CL_V4_V4_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2010
  { IMAGE_GATHER4_B_CL_V4_V5_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 2011
  { IMAGE_GATHER4_B_CL_V4_V8_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 2012
  { IMAGE_GATHER4_B_CL_V5_V2_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2013
  { IMAGE_GATHER4_B_CL_V5_V3_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2014
  { IMAGE_GATHER4_B_CL_V5_V4_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2015
  { IMAGE_GATHER4_B_CL_V5_V5_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 2016
  { IMAGE_GATHER4_B_CL_V5_V8_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 2017
  { IMAGE_GATHER4_B_CL_V2_V2_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2018
  { IMAGE_GATHER4_B_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2019
  { IMAGE_GATHER4_B_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2020
  { IMAGE_GATHER4_B_CL_V2_V5_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 2021
  { IMAGE_GATHER4_B_CL_V4_V2_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2022
  { IMAGE_GATHER4_B_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2023
  { IMAGE_GATHER4_B_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2024
  { IMAGE_GATHER4_B_CL_V4_V5_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 2025
  { IMAGE_GATHER4_B_CL_V5_V2_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2026
  { IMAGE_GATHER4_B_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2027
  { IMAGE_GATHER4_B_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2028
  { IMAGE_GATHER4_B_CL_V5_V5_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 2029
  { IMAGE_GATHER4_B_CL_V2_V2_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2030
  { IMAGE_GATHER4_B_CL_V2_V3_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2031
  { IMAGE_GATHER4_B_CL_V2_V4_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2032
  { IMAGE_GATHER4_B_CL_V2_V5_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 2033
  { IMAGE_GATHER4_B_CL_V4_V2_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2034
  { IMAGE_GATHER4_B_CL_V4_V3_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2035
  { IMAGE_GATHER4_B_CL_V4_V4_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2036
  { IMAGE_GATHER4_B_CL_V4_V5_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 2037
  { IMAGE_GATHER4_B_CL_V5_V2_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2038
  { IMAGE_GATHER4_B_CL_V5_V3_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2039
  { IMAGE_GATHER4_B_CL_V5_V4_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2040
  { IMAGE_GATHER4_B_CL_V5_V5_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 2041
  { IMAGE_GATHER4_B_CL_V2_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2042
  { IMAGE_GATHER4_B_CL_V2_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2043
  { IMAGE_GATHER4_B_CL_V2_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2044
  { IMAGE_GATHER4_B_CL_V2_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2045
  { IMAGE_GATHER4_B_CL_V2_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2046
  { IMAGE_GATHER4_B_CL_V4_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2047
  { IMAGE_GATHER4_B_CL_V4_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2048
  { IMAGE_GATHER4_B_CL_V4_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2049
  { IMAGE_GATHER4_B_CL_V4_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2050
  { IMAGE_GATHER4_B_CL_V4_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2051
  { IMAGE_GATHER4_B_CL_V5_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2052
  { IMAGE_GATHER4_B_CL_V5_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2053
  { IMAGE_GATHER4_B_CL_V5_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2054
  { IMAGE_GATHER4_B_CL_V5_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2055
  { IMAGE_GATHER4_B_CL_V5_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2056
  { IMAGE_GATHER4_B_CL_O_V2_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2057
  { IMAGE_GATHER4_B_CL_O_V2_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2058
  { IMAGE_GATHER4_B_CL_O_V2_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2059
  { IMAGE_GATHER4_B_CL_O_V2_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 2060
  { IMAGE_GATHER4_B_CL_O_V2_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2061
  { IMAGE_GATHER4_B_CL_O_V4_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2062
  { IMAGE_GATHER4_B_CL_O_V4_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2063
  { IMAGE_GATHER4_B_CL_O_V4_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2064
  { IMAGE_GATHER4_B_CL_O_V4_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 2065
  { IMAGE_GATHER4_B_CL_O_V4_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2066
  { IMAGE_GATHER4_B_CL_O_V5_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2067
  { IMAGE_GATHER4_B_CL_O_V5_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2068
  { IMAGE_GATHER4_B_CL_O_V5_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2069
  { IMAGE_GATHER4_B_CL_O_V5_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 2070
  { IMAGE_GATHER4_B_CL_O_V5_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2071
  { IMAGE_GATHER4_B_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2072
  { IMAGE_GATHER4_B_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2073
  { IMAGE_GATHER4_B_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2074
  { IMAGE_GATHER4_B_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 2075
  { IMAGE_GATHER4_B_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2076
  { IMAGE_GATHER4_B_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2077
  { IMAGE_GATHER4_B_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2078
  { IMAGE_GATHER4_B_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 2079
  { IMAGE_GATHER4_B_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2080
  { IMAGE_GATHER4_B_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2081
  { IMAGE_GATHER4_B_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2082
  { IMAGE_GATHER4_B_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 2083
  { IMAGE_GATHER4_B_CL_O_V2_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2084
  { IMAGE_GATHER4_B_CL_O_V2_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2085
  { IMAGE_GATHER4_B_CL_O_V2_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2086
  { IMAGE_GATHER4_B_CL_O_V2_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 2087
  { IMAGE_GATHER4_B_CL_O_V2_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2088
  { IMAGE_GATHER4_B_CL_O_V4_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2089
  { IMAGE_GATHER4_B_CL_O_V4_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2090
  { IMAGE_GATHER4_B_CL_O_V4_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2091
  { IMAGE_GATHER4_B_CL_O_V4_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 2092
  { IMAGE_GATHER4_B_CL_O_V4_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2093
  { IMAGE_GATHER4_B_CL_O_V5_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2094
  { IMAGE_GATHER4_B_CL_O_V5_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2095
  { IMAGE_GATHER4_B_CL_O_V5_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2096
  { IMAGE_GATHER4_B_CL_O_V5_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 2097
  { IMAGE_GATHER4_B_CL_O_V5_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2098
  { IMAGE_GATHER4_B_O_V2_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2099
  { IMAGE_GATHER4_B_O_V2_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2100
  { IMAGE_GATHER4_B_O_V2_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2101
  { IMAGE_GATHER4_B_O_V2_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2102
  { IMAGE_GATHER4_B_O_V4_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2103
  { IMAGE_GATHER4_B_O_V4_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2104
  { IMAGE_GATHER4_B_O_V4_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2105
  { IMAGE_GATHER4_B_O_V4_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2106
  { IMAGE_GATHER4_B_O_V5_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2107
  { IMAGE_GATHER4_B_O_V5_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2108
  { IMAGE_GATHER4_B_O_V5_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2109
  { IMAGE_GATHER4_B_O_V5_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2110
  { IMAGE_GATHER4_B_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2111
  { IMAGE_GATHER4_B_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2112
  { IMAGE_GATHER4_B_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2113
  { IMAGE_GATHER4_B_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2114
  { IMAGE_GATHER4_B_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2115
  { IMAGE_GATHER4_B_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2116
  { IMAGE_GATHER4_B_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2117
  { IMAGE_GATHER4_B_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2118
  { IMAGE_GATHER4_B_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2119
  { IMAGE_GATHER4_B_O_V2_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2120
  { IMAGE_GATHER4_B_O_V2_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2121
  { IMAGE_GATHER4_B_O_V2_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2122
  { IMAGE_GATHER4_B_O_V2_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2123
  { IMAGE_GATHER4_B_O_V4_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2124
  { IMAGE_GATHER4_B_O_V4_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2125
  { IMAGE_GATHER4_B_O_V4_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2126
  { IMAGE_GATHER4_B_O_V4_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2127
  { IMAGE_GATHER4_B_O_V5_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2128
  { IMAGE_GATHER4_B_O_V5_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2129
  { IMAGE_GATHER4_B_O_V5_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2130
  { IMAGE_GATHER4_B_O_V5_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2131
  { IMAGE_GATHER4_C_V2_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2132
  { IMAGE_GATHER4_C_V2_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2133
  { IMAGE_GATHER4_C_V2_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2134
  { IMAGE_GATHER4_C_V4_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2135
  { IMAGE_GATHER4_C_V4_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2136
  { IMAGE_GATHER4_C_V4_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2137
  { IMAGE_GATHER4_C_V5_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2138
  { IMAGE_GATHER4_C_V5_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2139
  { IMAGE_GATHER4_C_V5_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2140
  { IMAGE_GATHER4_C_V2_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2141
  { IMAGE_GATHER4_C_V2_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2142
  { IMAGE_GATHER4_C_V2_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2143
  { IMAGE_GATHER4_C_V4_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2144
  { IMAGE_GATHER4_C_V4_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2145
  { IMAGE_GATHER4_C_V4_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2146
  { IMAGE_GATHER4_C_V5_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2147
  { IMAGE_GATHER4_C_V5_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2148
  { IMAGE_GATHER4_C_V5_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2149
  { IMAGE_GATHER4_C_V2_V2_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2150
  { IMAGE_GATHER4_C_V2_V3_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2151
  { IMAGE_GATHER4_C_V2_V4_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2152
  { IMAGE_GATHER4_C_V4_V2_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2153
  { IMAGE_GATHER4_C_V4_V3_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2154
  { IMAGE_GATHER4_C_V4_V4_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2155
  { IMAGE_GATHER4_C_V5_V2_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2156
  { IMAGE_GATHER4_C_V5_V3_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2157
  { IMAGE_GATHER4_C_V5_V4_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2158
  { IMAGE_GATHER4_C_V2_V2_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2159
  { IMAGE_GATHER4_C_V2_V3_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2160
  { IMAGE_GATHER4_C_V2_V4_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2161
  { IMAGE_GATHER4_C_V4_V2_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2162
  { IMAGE_GATHER4_C_V4_V3_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2163
  { IMAGE_GATHER4_C_V4_V4_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2164
  { IMAGE_GATHER4_C_V5_V2_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2165
  { IMAGE_GATHER4_C_V5_V3_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2166
  { IMAGE_GATHER4_C_V5_V4_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2167
  { IMAGE_GATHER4_C_V2_V2_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2168
  { IMAGE_GATHER4_C_V2_V3_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2169
  { IMAGE_GATHER4_C_V2_V4_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2170
  { IMAGE_GATHER4_C_V4_V2_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2171
  { IMAGE_GATHER4_C_V4_V3_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2172
  { IMAGE_GATHER4_C_V4_V4_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2173
  { IMAGE_GATHER4_C_V5_V2_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2174
  { IMAGE_GATHER4_C_V5_V3_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2175
  { IMAGE_GATHER4_C_V5_V4_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2176
  { IMAGE_GATHER4_C_V2_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2177
  { IMAGE_GATHER4_C_V2_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2178
  { IMAGE_GATHER4_C_V2_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2179
  { IMAGE_GATHER4_C_V4_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2180
  { IMAGE_GATHER4_C_V4_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2181
  { IMAGE_GATHER4_C_V4_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2182
  { IMAGE_GATHER4_C_V5_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2183
  { IMAGE_GATHER4_C_V5_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2184
  { IMAGE_GATHER4_C_V5_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2185
  { IMAGE_GATHER4_CL_V2_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2186
  { IMAGE_GATHER4_CL_V2_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2187
  { IMAGE_GATHER4_CL_V2_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2188
  { IMAGE_GATHER4_CL_V2_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2189
  { IMAGE_GATHER4_CL_V4_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2190
  { IMAGE_GATHER4_CL_V4_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2191
  { IMAGE_GATHER4_CL_V4_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2192
  { IMAGE_GATHER4_CL_V4_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2193
  { IMAGE_GATHER4_CL_V5_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2194
  { IMAGE_GATHER4_CL_V5_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2195
  { IMAGE_GATHER4_CL_V5_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2196
  { IMAGE_GATHER4_CL_V5_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2197
  { IMAGE_GATHER4_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2198
  { IMAGE_GATHER4_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2199
  { IMAGE_GATHER4_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2200
  { IMAGE_GATHER4_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2201
  { IMAGE_GATHER4_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2202
  { IMAGE_GATHER4_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2203
  { IMAGE_GATHER4_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2204
  { IMAGE_GATHER4_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2205
  { IMAGE_GATHER4_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2206
  { IMAGE_GATHER4_CL_V2_V1_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2207
  { IMAGE_GATHER4_CL_V2_V2_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2208
  { IMAGE_GATHER4_CL_V2_V3_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2209
  { IMAGE_GATHER4_CL_V2_V4_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2210
  { IMAGE_GATHER4_CL_V4_V1_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2211
  { IMAGE_GATHER4_CL_V4_V2_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2212
  { IMAGE_GATHER4_CL_V4_V3_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2213
  { IMAGE_GATHER4_CL_V4_V4_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2214
  { IMAGE_GATHER4_CL_V5_V1_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2215
  { IMAGE_GATHER4_CL_V5_V2_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2216
  { IMAGE_GATHER4_CL_V5_V3_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2217
  { IMAGE_GATHER4_CL_V5_V4_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2218
  { IMAGE_GATHER4_CL_V2_V2_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2219
  { IMAGE_GATHER4_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2220
  { IMAGE_GATHER4_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2221
  { IMAGE_GATHER4_CL_V4_V2_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2222
  { IMAGE_GATHER4_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2223
  { IMAGE_GATHER4_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2224
  { IMAGE_GATHER4_CL_V5_V2_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2225
  { IMAGE_GATHER4_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2226
  { IMAGE_GATHER4_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2227
  { IMAGE_GATHER4_CL_V2_V1_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 2228
  { IMAGE_GATHER4_CL_V2_V2_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2229
  { IMAGE_GATHER4_CL_V2_V3_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2230
  { IMAGE_GATHER4_CL_V2_V4_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2231
  { IMAGE_GATHER4_CL_V4_V1_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 2232
  { IMAGE_GATHER4_CL_V4_V2_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2233
  { IMAGE_GATHER4_CL_V4_V3_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2234
  { IMAGE_GATHER4_CL_V4_V4_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2235
  { IMAGE_GATHER4_CL_V5_V1_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 2236
  { IMAGE_GATHER4_CL_V5_V2_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2237
  { IMAGE_GATHER4_CL_V5_V3_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2238
  { IMAGE_GATHER4_CL_V5_V4_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2239
  { IMAGE_GATHER4_CL_V2_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2240
  { IMAGE_GATHER4_CL_V2_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2241
  { IMAGE_GATHER4_CL_V2_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2242
  { IMAGE_GATHER4_CL_V2_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2243
  { IMAGE_GATHER4_CL_V4_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2244
  { IMAGE_GATHER4_CL_V4_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2245
  { IMAGE_GATHER4_CL_V4_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2246
  { IMAGE_GATHER4_CL_V4_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2247
  { IMAGE_GATHER4_CL_V5_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2248
  { IMAGE_GATHER4_CL_V5_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2249
  { IMAGE_GATHER4_CL_V5_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2250
  { IMAGE_GATHER4_CL_V5_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2251
  { IMAGE_GATHER4_CL_O_V2_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2252
  { IMAGE_GATHER4_CL_O_V2_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2253
  { IMAGE_GATHER4_CL_O_V2_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2254
  { IMAGE_GATHER4_CL_O_V2_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2255
  { IMAGE_GATHER4_CL_O_V2_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2256
  { IMAGE_GATHER4_CL_O_V4_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2257
  { IMAGE_GATHER4_CL_O_V4_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2258
  { IMAGE_GATHER4_CL_O_V4_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2259
  { IMAGE_GATHER4_CL_O_V4_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2260
  { IMAGE_GATHER4_CL_O_V4_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2261
  { IMAGE_GATHER4_CL_O_V5_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2262
  { IMAGE_GATHER4_CL_O_V5_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2263
  { IMAGE_GATHER4_CL_O_V5_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2264
  { IMAGE_GATHER4_CL_O_V5_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2265
  { IMAGE_GATHER4_CL_O_V5_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2266
  { IMAGE_GATHER4_CL_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2267
  { IMAGE_GATHER4_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2268
  { IMAGE_GATHER4_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2269
  { IMAGE_GATHER4_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2270
  { IMAGE_GATHER4_CL_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2271
  { IMAGE_GATHER4_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2272
  { IMAGE_GATHER4_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2273
  { IMAGE_GATHER4_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2274
  { IMAGE_GATHER4_CL_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2275
  { IMAGE_GATHER4_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2276
  { IMAGE_GATHER4_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2277
  { IMAGE_GATHER4_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2278
  { IMAGE_GATHER4_CL_O_V2_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2279
  { IMAGE_GATHER4_CL_O_V2_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2280
  { IMAGE_GATHER4_CL_O_V2_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2281
  { IMAGE_GATHER4_CL_O_V2_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2282
  { IMAGE_GATHER4_CL_O_V2_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2283
  { IMAGE_GATHER4_CL_O_V4_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2284
  { IMAGE_GATHER4_CL_O_V4_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2285
  { IMAGE_GATHER4_CL_O_V4_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2286
  { IMAGE_GATHER4_CL_O_V4_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2287
  { IMAGE_GATHER4_CL_O_V4_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2288
  { IMAGE_GATHER4_CL_O_V5_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2289
  { IMAGE_GATHER4_CL_O_V5_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2290
  { IMAGE_GATHER4_CL_O_V5_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2291
  { IMAGE_GATHER4_CL_O_V5_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2292
  { IMAGE_GATHER4_CL_O_V5_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2293
  { IMAGE_GATHER4_C_B_V2_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2294
  { IMAGE_GATHER4_C_B_V2_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2295
  { IMAGE_GATHER4_C_B_V2_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2296
  { IMAGE_GATHER4_C_B_V2_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2297
  { IMAGE_GATHER4_C_B_V4_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2298
  { IMAGE_GATHER4_C_B_V4_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2299
  { IMAGE_GATHER4_C_B_V4_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2300
  { IMAGE_GATHER4_C_B_V4_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2301
  { IMAGE_GATHER4_C_B_V5_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2302
  { IMAGE_GATHER4_C_B_V5_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2303
  { IMAGE_GATHER4_C_B_V5_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2304
  { IMAGE_GATHER4_C_B_V5_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2305
  { IMAGE_GATHER4_C_B_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2306
  { IMAGE_GATHER4_C_B_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2307
  { IMAGE_GATHER4_C_B_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2308
  { IMAGE_GATHER4_C_B_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2309
  { IMAGE_GATHER4_C_B_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2310
  { IMAGE_GATHER4_C_B_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2311
  { IMAGE_GATHER4_C_B_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2312
  { IMAGE_GATHER4_C_B_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2313
  { IMAGE_GATHER4_C_B_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2314
  { IMAGE_GATHER4_C_B_V2_V3_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2315
  { IMAGE_GATHER4_C_B_V2_V4_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2316
  { IMAGE_GATHER4_C_B_V2_V5_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 2317
  { IMAGE_GATHER4_C_B_V2_V8_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 2318
  { IMAGE_GATHER4_C_B_V4_V3_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2319
  { IMAGE_GATHER4_C_B_V4_V4_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2320
  { IMAGE_GATHER4_C_B_V4_V5_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 2321
  { IMAGE_GATHER4_C_B_V4_V8_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 2322
  { IMAGE_GATHER4_C_B_V5_V3_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2323
  { IMAGE_GATHER4_C_B_V5_V4_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2324
  { IMAGE_GATHER4_C_B_V5_V5_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 2325
  { IMAGE_GATHER4_C_B_V5_V8_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 2326
  { IMAGE_GATHER4_C_B_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2327
  { IMAGE_GATHER4_C_B_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2328
  { IMAGE_GATHER4_C_B_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 2329
  { IMAGE_GATHER4_C_B_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2330
  { IMAGE_GATHER4_C_B_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2331
  { IMAGE_GATHER4_C_B_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 2332
  { IMAGE_GATHER4_C_B_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2333
  { IMAGE_GATHER4_C_B_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2334
  { IMAGE_GATHER4_C_B_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 2335
  { IMAGE_GATHER4_C_B_V2_V3_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2336
  { IMAGE_GATHER4_C_B_V2_V4_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2337
  { IMAGE_GATHER4_C_B_V2_V5_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 2338
  { IMAGE_GATHER4_C_B_V4_V3_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2339
  { IMAGE_GATHER4_C_B_V4_V4_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2340
  { IMAGE_GATHER4_C_B_V4_V5_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 2341
  { IMAGE_GATHER4_C_B_V5_V3_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2342
  { IMAGE_GATHER4_C_B_V5_V4_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2343
  { IMAGE_GATHER4_C_B_V5_V5_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 2344
  { IMAGE_GATHER4_C_B_V2_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2345
  { IMAGE_GATHER4_C_B_V2_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2346
  { IMAGE_GATHER4_C_B_V2_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2347
  { IMAGE_GATHER4_C_B_V2_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2348
  { IMAGE_GATHER4_C_B_V4_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2349
  { IMAGE_GATHER4_C_B_V4_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2350
  { IMAGE_GATHER4_C_B_V4_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2351
  { IMAGE_GATHER4_C_B_V4_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2352
  { IMAGE_GATHER4_C_B_V5_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2353
  { IMAGE_GATHER4_C_B_V5_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2354
  { IMAGE_GATHER4_C_B_V5_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2355
  { IMAGE_GATHER4_C_B_V5_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2356
  { IMAGE_GATHER4_C_B_CL_V2_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2357
  { IMAGE_GATHER4_C_B_CL_V2_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2358
  { IMAGE_GATHER4_C_B_CL_V2_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2359
  { IMAGE_GATHER4_C_B_CL_V2_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 2360
  { IMAGE_GATHER4_C_B_CL_V2_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2361
  { IMAGE_GATHER4_C_B_CL_V4_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2362
  { IMAGE_GATHER4_C_B_CL_V4_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2363
  { IMAGE_GATHER4_C_B_CL_V4_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2364
  { IMAGE_GATHER4_C_B_CL_V4_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 2365
  { IMAGE_GATHER4_C_B_CL_V4_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2366
  { IMAGE_GATHER4_C_B_CL_V5_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2367
  { IMAGE_GATHER4_C_B_CL_V5_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2368
  { IMAGE_GATHER4_C_B_CL_V5_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2369
  { IMAGE_GATHER4_C_B_CL_V5_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 2370
  { IMAGE_GATHER4_C_B_CL_V5_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2371
  { IMAGE_GATHER4_C_B_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2372
  { IMAGE_GATHER4_C_B_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2373
  { IMAGE_GATHER4_C_B_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2374
  { IMAGE_GATHER4_C_B_CL_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 2375
  { IMAGE_GATHER4_C_B_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2376
  { IMAGE_GATHER4_C_B_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2377
  { IMAGE_GATHER4_C_B_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2378
  { IMAGE_GATHER4_C_B_CL_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 2379
  { IMAGE_GATHER4_C_B_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2380
  { IMAGE_GATHER4_C_B_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2381
  { IMAGE_GATHER4_C_B_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2382
  { IMAGE_GATHER4_C_B_CL_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 2383
  { IMAGE_GATHER4_C_B_CL_V2_V3_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2384
  { IMAGE_GATHER4_C_B_CL_V2_V4_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2385
  { IMAGE_GATHER4_C_B_CL_V2_V5_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 2386
  { IMAGE_GATHER4_C_B_CL_V2_V6_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 2387
  { IMAGE_GATHER4_C_B_CL_V2_V8_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 2388
  { IMAGE_GATHER4_C_B_CL_V4_V3_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2389
  { IMAGE_GATHER4_C_B_CL_V4_V4_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2390
  { IMAGE_GATHER4_C_B_CL_V4_V5_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 2391
  { IMAGE_GATHER4_C_B_CL_V4_V6_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 2392
  { IMAGE_GATHER4_C_B_CL_V4_V8_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 2393
  { IMAGE_GATHER4_C_B_CL_V5_V3_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2394
  { IMAGE_GATHER4_C_B_CL_V5_V4_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2395
  { IMAGE_GATHER4_C_B_CL_V5_V5_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 2396
  { IMAGE_GATHER4_C_B_CL_V5_V6_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 2397
  { IMAGE_GATHER4_C_B_CL_V5_V8_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 2398
  { IMAGE_GATHER4_C_B_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2399
  { IMAGE_GATHER4_C_B_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2400
  { IMAGE_GATHER4_C_B_CL_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 2401
  { IMAGE_GATHER4_C_B_CL_V2_V6_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 2402
  { IMAGE_GATHER4_C_B_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2403
  { IMAGE_GATHER4_C_B_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2404
  { IMAGE_GATHER4_C_B_CL_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 2405
  { IMAGE_GATHER4_C_B_CL_V4_V6_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 2406
  { IMAGE_GATHER4_C_B_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2407
  { IMAGE_GATHER4_C_B_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2408
  { IMAGE_GATHER4_C_B_CL_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 2409
  { IMAGE_GATHER4_C_B_CL_V5_V6_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 2410
  { IMAGE_GATHER4_C_B_CL_V2_V3_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2411
  { IMAGE_GATHER4_C_B_CL_V2_V4_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2412
  { IMAGE_GATHER4_C_B_CL_V2_V5_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 2413
  { IMAGE_GATHER4_C_B_CL_V2_V6_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 2414
  { IMAGE_GATHER4_C_B_CL_V4_V3_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2415
  { IMAGE_GATHER4_C_B_CL_V4_V4_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2416
  { IMAGE_GATHER4_C_B_CL_V4_V5_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 2417
  { IMAGE_GATHER4_C_B_CL_V4_V6_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 2418
  { IMAGE_GATHER4_C_B_CL_V5_V3_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2419
  { IMAGE_GATHER4_C_B_CL_V5_V4_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2420
  { IMAGE_GATHER4_C_B_CL_V5_V5_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 2421
  { IMAGE_GATHER4_C_B_CL_V5_V6_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 2422
  { IMAGE_GATHER4_C_B_CL_V2_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2423
  { IMAGE_GATHER4_C_B_CL_V2_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2424
  { IMAGE_GATHER4_C_B_CL_V2_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2425
  { IMAGE_GATHER4_C_B_CL_V2_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 2426
  { IMAGE_GATHER4_C_B_CL_V2_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2427
  { IMAGE_GATHER4_C_B_CL_V4_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2428
  { IMAGE_GATHER4_C_B_CL_V4_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2429
  { IMAGE_GATHER4_C_B_CL_V4_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2430
  { IMAGE_GATHER4_C_B_CL_V4_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 2431
  { IMAGE_GATHER4_C_B_CL_V4_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2432
  { IMAGE_GATHER4_C_B_CL_V5_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2433
  { IMAGE_GATHER4_C_B_CL_V5_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2434
  { IMAGE_GATHER4_C_B_CL_V5_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2435
  { IMAGE_GATHER4_C_B_CL_V5_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 2436
  { IMAGE_GATHER4_C_B_CL_V5_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2437
  { IMAGE_GATHER4_C_B_CL_O_V2_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2438
  { IMAGE_GATHER4_C_B_CL_O_V2_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2439
  { IMAGE_GATHER4_C_B_CL_O_V2_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 2440
  { IMAGE_GATHER4_C_B_CL_O_V2_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 2441
  { IMAGE_GATHER4_C_B_CL_O_V2_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2442
  { IMAGE_GATHER4_C_B_CL_O_V4_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2443
  { IMAGE_GATHER4_C_B_CL_O_V4_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2444
  { IMAGE_GATHER4_C_B_CL_O_V4_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 2445
  { IMAGE_GATHER4_C_B_CL_O_V4_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 2446
  { IMAGE_GATHER4_C_B_CL_O_V4_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2447
  { IMAGE_GATHER4_C_B_CL_O_V5_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2448
  { IMAGE_GATHER4_C_B_CL_O_V5_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2449
  { IMAGE_GATHER4_C_B_CL_O_V5_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 2450
  { IMAGE_GATHER4_C_B_CL_O_V5_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 2451
  { IMAGE_GATHER4_C_B_CL_O_V5_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2452
  { IMAGE_GATHER4_C_B_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2453
  { IMAGE_GATHER4_C_B_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2454
  { IMAGE_GATHER4_C_B_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 2455
  { IMAGE_GATHER4_C_B_CL_O_V2_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 2456
  { IMAGE_GATHER4_C_B_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2457
  { IMAGE_GATHER4_C_B_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2458
  { IMAGE_GATHER4_C_B_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 2459
  { IMAGE_GATHER4_C_B_CL_O_V4_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 2460
  { IMAGE_GATHER4_C_B_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2461
  { IMAGE_GATHER4_C_B_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2462
  { IMAGE_GATHER4_C_B_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 2463
  { IMAGE_GATHER4_C_B_CL_O_V5_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 2464
  { IMAGE_GATHER4_C_B_CL_O_V2_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2465
  { IMAGE_GATHER4_C_B_CL_O_V2_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2466
  { IMAGE_GATHER4_C_B_CL_O_V2_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 2467
  { IMAGE_GATHER4_C_B_CL_O_V2_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 2468
  { IMAGE_GATHER4_C_B_CL_O_V2_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2469
  { IMAGE_GATHER4_C_B_CL_O_V4_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2470
  { IMAGE_GATHER4_C_B_CL_O_V4_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2471
  { IMAGE_GATHER4_C_B_CL_O_V4_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 2472
  { IMAGE_GATHER4_C_B_CL_O_V4_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 2473
  { IMAGE_GATHER4_C_B_CL_O_V4_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2474
  { IMAGE_GATHER4_C_B_CL_O_V5_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2475
  { IMAGE_GATHER4_C_B_CL_O_V5_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2476
  { IMAGE_GATHER4_C_B_CL_O_V5_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 2477
  { IMAGE_GATHER4_C_B_CL_O_V5_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 2478
  { IMAGE_GATHER4_C_B_CL_O_V5_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2479
  { IMAGE_GATHER4_C_B_O_V2_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2480
  { IMAGE_GATHER4_C_B_O_V2_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2481
  { IMAGE_GATHER4_C_B_O_V2_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 2482
  { IMAGE_GATHER4_C_B_O_V2_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2483
  { IMAGE_GATHER4_C_B_O_V4_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2484
  { IMAGE_GATHER4_C_B_O_V4_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2485
  { IMAGE_GATHER4_C_B_O_V4_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 2486
  { IMAGE_GATHER4_C_B_O_V4_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2487
  { IMAGE_GATHER4_C_B_O_V5_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2488
  { IMAGE_GATHER4_C_B_O_V5_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2489
  { IMAGE_GATHER4_C_B_O_V5_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 2490
  { IMAGE_GATHER4_C_B_O_V5_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2491
  { IMAGE_GATHER4_C_B_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2492
  { IMAGE_GATHER4_C_B_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2493
  { IMAGE_GATHER4_C_B_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 2494
  { IMAGE_GATHER4_C_B_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2495
  { IMAGE_GATHER4_C_B_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2496
  { IMAGE_GATHER4_C_B_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 2497
  { IMAGE_GATHER4_C_B_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2498
  { IMAGE_GATHER4_C_B_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2499
  { IMAGE_GATHER4_C_B_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 2500
  { IMAGE_GATHER4_C_B_O_V2_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2501
  { IMAGE_GATHER4_C_B_O_V2_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2502
  { IMAGE_GATHER4_C_B_O_V2_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 2503
  { IMAGE_GATHER4_C_B_O_V2_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2504
  { IMAGE_GATHER4_C_B_O_V4_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2505
  { IMAGE_GATHER4_C_B_O_V4_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2506
  { IMAGE_GATHER4_C_B_O_V4_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 2507
  { IMAGE_GATHER4_C_B_O_V4_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2508
  { IMAGE_GATHER4_C_B_O_V5_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2509
  { IMAGE_GATHER4_C_B_O_V5_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2510
  { IMAGE_GATHER4_C_B_O_V5_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 2511
  { IMAGE_GATHER4_C_B_O_V5_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2512
  { IMAGE_GATHER4_C_CL_V2_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2513
  { IMAGE_GATHER4_C_CL_V2_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2514
  { IMAGE_GATHER4_C_CL_V2_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2515
  { IMAGE_GATHER4_C_CL_V2_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2516
  { IMAGE_GATHER4_C_CL_V2_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2517
  { IMAGE_GATHER4_C_CL_V4_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2518
  { IMAGE_GATHER4_C_CL_V4_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2519
  { IMAGE_GATHER4_C_CL_V4_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2520
  { IMAGE_GATHER4_C_CL_V4_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2521
  { IMAGE_GATHER4_C_CL_V4_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2522
  { IMAGE_GATHER4_C_CL_V5_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2523
  { IMAGE_GATHER4_C_CL_V5_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2524
  { IMAGE_GATHER4_C_CL_V5_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2525
  { IMAGE_GATHER4_C_CL_V5_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2526
  { IMAGE_GATHER4_C_CL_V5_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2527
  { IMAGE_GATHER4_C_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2528
  { IMAGE_GATHER4_C_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2529
  { IMAGE_GATHER4_C_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2530
  { IMAGE_GATHER4_C_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2531
  { IMAGE_GATHER4_C_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2532
  { IMAGE_GATHER4_C_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2533
  { IMAGE_GATHER4_C_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2534
  { IMAGE_GATHER4_C_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2535
  { IMAGE_GATHER4_C_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2536
  { IMAGE_GATHER4_C_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2537
  { IMAGE_GATHER4_C_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2538
  { IMAGE_GATHER4_C_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2539
  { IMAGE_GATHER4_C_CL_V2_V2_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2540
  { IMAGE_GATHER4_C_CL_V2_V3_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2541
  { IMAGE_GATHER4_C_CL_V2_V4_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2542
  { IMAGE_GATHER4_C_CL_V2_V5_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 2543
  { IMAGE_GATHER4_C_CL_V2_V8_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 2544
  { IMAGE_GATHER4_C_CL_V4_V2_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2545
  { IMAGE_GATHER4_C_CL_V4_V3_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2546
  { IMAGE_GATHER4_C_CL_V4_V4_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2547
  { IMAGE_GATHER4_C_CL_V4_V5_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 2548
  { IMAGE_GATHER4_C_CL_V4_V8_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 2549
  { IMAGE_GATHER4_C_CL_V5_V2_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2550
  { IMAGE_GATHER4_C_CL_V5_V3_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2551
  { IMAGE_GATHER4_C_CL_V5_V4_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2552
  { IMAGE_GATHER4_C_CL_V5_V5_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 2553
  { IMAGE_GATHER4_C_CL_V5_V8_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 2554
  { IMAGE_GATHER4_C_CL_V2_V2_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2555
  { IMAGE_GATHER4_C_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2556
  { IMAGE_GATHER4_C_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2557
  { IMAGE_GATHER4_C_CL_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 2558
  { IMAGE_GATHER4_C_CL_V4_V2_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2559
  { IMAGE_GATHER4_C_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2560
  { IMAGE_GATHER4_C_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2561
  { IMAGE_GATHER4_C_CL_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 2562
  { IMAGE_GATHER4_C_CL_V5_V2_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2563
  { IMAGE_GATHER4_C_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2564
  { IMAGE_GATHER4_C_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2565
  { IMAGE_GATHER4_C_CL_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 2566
  { IMAGE_GATHER4_C_CL_V2_V2_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2567
  { IMAGE_GATHER4_C_CL_V2_V3_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2568
  { IMAGE_GATHER4_C_CL_V2_V4_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2569
  { IMAGE_GATHER4_C_CL_V2_V5_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 2570
  { IMAGE_GATHER4_C_CL_V4_V2_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2571
  { IMAGE_GATHER4_C_CL_V4_V3_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2572
  { IMAGE_GATHER4_C_CL_V4_V4_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2573
  { IMAGE_GATHER4_C_CL_V4_V5_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 2574
  { IMAGE_GATHER4_C_CL_V5_V2_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2575
  { IMAGE_GATHER4_C_CL_V5_V3_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2576
  { IMAGE_GATHER4_C_CL_V5_V4_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2577
  { IMAGE_GATHER4_C_CL_V5_V5_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 2578
  { IMAGE_GATHER4_C_CL_V2_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2579
  { IMAGE_GATHER4_C_CL_V2_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2580
  { IMAGE_GATHER4_C_CL_V2_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2581
  { IMAGE_GATHER4_C_CL_V2_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2582
  { IMAGE_GATHER4_C_CL_V2_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2583
  { IMAGE_GATHER4_C_CL_V4_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2584
  { IMAGE_GATHER4_C_CL_V4_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2585
  { IMAGE_GATHER4_C_CL_V4_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2586
  { IMAGE_GATHER4_C_CL_V4_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2587
  { IMAGE_GATHER4_C_CL_V4_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2588
  { IMAGE_GATHER4_C_CL_V5_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2589
  { IMAGE_GATHER4_C_CL_V5_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2590
  { IMAGE_GATHER4_C_CL_V5_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2591
  { IMAGE_GATHER4_C_CL_V5_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2592
  { IMAGE_GATHER4_C_CL_V5_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2593
  { IMAGE_GATHER4_C_CL_O_V2_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2594
  { IMAGE_GATHER4_C_CL_O_V2_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2595
  { IMAGE_GATHER4_C_CL_O_V2_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2596
  { IMAGE_GATHER4_C_CL_O_V2_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 2597
  { IMAGE_GATHER4_C_CL_O_V2_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2598
  { IMAGE_GATHER4_C_CL_O_V4_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2599
  { IMAGE_GATHER4_C_CL_O_V4_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2600
  { IMAGE_GATHER4_C_CL_O_V4_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2601
  { IMAGE_GATHER4_C_CL_O_V4_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 2602
  { IMAGE_GATHER4_C_CL_O_V4_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2603
  { IMAGE_GATHER4_C_CL_O_V5_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2604
  { IMAGE_GATHER4_C_CL_O_V5_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2605
  { IMAGE_GATHER4_C_CL_O_V5_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2606
  { IMAGE_GATHER4_C_CL_O_V5_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 2607
  { IMAGE_GATHER4_C_CL_O_V5_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2608
  { IMAGE_GATHER4_C_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2609
  { IMAGE_GATHER4_C_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2610
  { IMAGE_GATHER4_C_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2611
  { IMAGE_GATHER4_C_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 2612
  { IMAGE_GATHER4_C_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2613
  { IMAGE_GATHER4_C_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2614
  { IMAGE_GATHER4_C_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2615
  { IMAGE_GATHER4_C_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 2616
  { IMAGE_GATHER4_C_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2617
  { IMAGE_GATHER4_C_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2618
  { IMAGE_GATHER4_C_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2619
  { IMAGE_GATHER4_C_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 2620
  { IMAGE_GATHER4_C_CL_O_V2_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2621
  { IMAGE_GATHER4_C_CL_O_V2_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2622
  { IMAGE_GATHER4_C_CL_O_V2_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2623
  { IMAGE_GATHER4_C_CL_O_V2_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 2624
  { IMAGE_GATHER4_C_CL_O_V2_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2625
  { IMAGE_GATHER4_C_CL_O_V4_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2626
  { IMAGE_GATHER4_C_CL_O_V4_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2627
  { IMAGE_GATHER4_C_CL_O_V4_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2628
  { IMAGE_GATHER4_C_CL_O_V4_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 2629
  { IMAGE_GATHER4_C_CL_O_V4_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2630
  { IMAGE_GATHER4_C_CL_O_V5_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2631
  { IMAGE_GATHER4_C_CL_O_V5_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2632
  { IMAGE_GATHER4_C_CL_O_V5_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2633
  { IMAGE_GATHER4_C_CL_O_V5_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 2634
  { IMAGE_GATHER4_C_CL_O_V5_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2635
  { IMAGE_GATHER4_C_L_V2_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2636
  { IMAGE_GATHER4_C_L_V2_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2637
  { IMAGE_GATHER4_C_L_V2_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2638
  { IMAGE_GATHER4_C_L_V2_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2639
  { IMAGE_GATHER4_C_L_V2_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2640
  { IMAGE_GATHER4_C_L_V4_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2641
  { IMAGE_GATHER4_C_L_V4_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2642
  { IMAGE_GATHER4_C_L_V4_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2643
  { IMAGE_GATHER4_C_L_V4_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2644
  { IMAGE_GATHER4_C_L_V4_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2645
  { IMAGE_GATHER4_C_L_V5_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2646
  { IMAGE_GATHER4_C_L_V5_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2647
  { IMAGE_GATHER4_C_L_V5_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2648
  { IMAGE_GATHER4_C_L_V5_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2649
  { IMAGE_GATHER4_C_L_V5_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2650
  { IMAGE_GATHER4_C_L_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2651
  { IMAGE_GATHER4_C_L_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2652
  { IMAGE_GATHER4_C_L_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2653
  { IMAGE_GATHER4_C_L_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2654
  { IMAGE_GATHER4_C_L_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2655
  { IMAGE_GATHER4_C_L_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2656
  { IMAGE_GATHER4_C_L_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2657
  { IMAGE_GATHER4_C_L_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2658
  { IMAGE_GATHER4_C_L_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2659
  { IMAGE_GATHER4_C_L_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2660
  { IMAGE_GATHER4_C_L_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2661
  { IMAGE_GATHER4_C_L_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2662
  { IMAGE_GATHER4_C_L_V2_V2_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2663
  { IMAGE_GATHER4_C_L_V2_V3_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2664
  { IMAGE_GATHER4_C_L_V2_V4_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2665
  { IMAGE_GATHER4_C_L_V2_V5_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 2666
  { IMAGE_GATHER4_C_L_V2_V8_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 2667
  { IMAGE_GATHER4_C_L_V4_V2_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2668
  { IMAGE_GATHER4_C_L_V4_V3_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2669
  { IMAGE_GATHER4_C_L_V4_V4_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2670
  { IMAGE_GATHER4_C_L_V4_V5_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 2671
  { IMAGE_GATHER4_C_L_V4_V8_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 2672
  { IMAGE_GATHER4_C_L_V5_V2_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2673
  { IMAGE_GATHER4_C_L_V5_V3_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2674
  { IMAGE_GATHER4_C_L_V5_V4_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2675
  { IMAGE_GATHER4_C_L_V5_V5_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 2676
  { IMAGE_GATHER4_C_L_V5_V8_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 2677
  { IMAGE_GATHER4_C_L_V2_V2_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2678
  { IMAGE_GATHER4_C_L_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2679
  { IMAGE_GATHER4_C_L_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2680
  { IMAGE_GATHER4_C_L_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 2681
  { IMAGE_GATHER4_C_L_V4_V2_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2682
  { IMAGE_GATHER4_C_L_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2683
  { IMAGE_GATHER4_C_L_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2684
  { IMAGE_GATHER4_C_L_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 2685
  { IMAGE_GATHER4_C_L_V5_V2_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2686
  { IMAGE_GATHER4_C_L_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2687
  { IMAGE_GATHER4_C_L_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2688
  { IMAGE_GATHER4_C_L_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 2689
  { IMAGE_GATHER4_C_L_V2_V2_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2690
  { IMAGE_GATHER4_C_L_V2_V3_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2691
  { IMAGE_GATHER4_C_L_V2_V4_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2692
  { IMAGE_GATHER4_C_L_V2_V5_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 2693
  { IMAGE_GATHER4_C_L_V4_V2_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2694
  { IMAGE_GATHER4_C_L_V4_V3_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2695
  { IMAGE_GATHER4_C_L_V4_V4_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2696
  { IMAGE_GATHER4_C_L_V4_V5_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 2697
  { IMAGE_GATHER4_C_L_V5_V2_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2698
  { IMAGE_GATHER4_C_L_V5_V3_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2699
  { IMAGE_GATHER4_C_L_V5_V4_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2700
  { IMAGE_GATHER4_C_L_V5_V5_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 2701
  { IMAGE_GATHER4_C_L_V2_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2702
  { IMAGE_GATHER4_C_L_V2_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2703
  { IMAGE_GATHER4_C_L_V2_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2704
  { IMAGE_GATHER4_C_L_V2_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2705
  { IMAGE_GATHER4_C_L_V2_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2706
  { IMAGE_GATHER4_C_L_V4_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2707
  { IMAGE_GATHER4_C_L_V4_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2708
  { IMAGE_GATHER4_C_L_V4_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2709
  { IMAGE_GATHER4_C_L_V4_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2710
  { IMAGE_GATHER4_C_L_V4_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2711
  { IMAGE_GATHER4_C_L_V5_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2712
  { IMAGE_GATHER4_C_L_V5_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2713
  { IMAGE_GATHER4_C_L_V5_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2714
  { IMAGE_GATHER4_C_L_V5_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2715
  { IMAGE_GATHER4_C_L_V5_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2716
  { IMAGE_GATHER4_C_LZ_V2_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2717
  { IMAGE_GATHER4_C_LZ_V2_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2718
  { IMAGE_GATHER4_C_LZ_V2_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2719
  { IMAGE_GATHER4_C_LZ_V4_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2720
  { IMAGE_GATHER4_C_LZ_V4_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2721
  { IMAGE_GATHER4_C_LZ_V4_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2722
  { IMAGE_GATHER4_C_LZ_V5_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2723
  { IMAGE_GATHER4_C_LZ_V5_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2724
  { IMAGE_GATHER4_C_LZ_V5_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2725
  { IMAGE_GATHER4_C_LZ_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2726
  { IMAGE_GATHER4_C_LZ_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2727
  { IMAGE_GATHER4_C_LZ_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2728
  { IMAGE_GATHER4_C_LZ_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2729
  { IMAGE_GATHER4_C_LZ_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2730
  { IMAGE_GATHER4_C_LZ_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2731
  { IMAGE_GATHER4_C_LZ_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2732
  { IMAGE_GATHER4_C_LZ_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2733
  { IMAGE_GATHER4_C_LZ_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2734
  { IMAGE_GATHER4_C_LZ_V2_V2_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2735
  { IMAGE_GATHER4_C_LZ_V2_V3_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2736
  { IMAGE_GATHER4_C_LZ_V2_V4_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2737
  { IMAGE_GATHER4_C_LZ_V4_V2_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2738
  { IMAGE_GATHER4_C_LZ_V4_V3_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2739
  { IMAGE_GATHER4_C_LZ_V4_V4_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2740
  { IMAGE_GATHER4_C_LZ_V5_V2_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2741
  { IMAGE_GATHER4_C_LZ_V5_V3_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2742
  { IMAGE_GATHER4_C_LZ_V5_V4_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2743
  { IMAGE_GATHER4_C_LZ_V2_V2_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2744
  { IMAGE_GATHER4_C_LZ_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2745
  { IMAGE_GATHER4_C_LZ_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2746
  { IMAGE_GATHER4_C_LZ_V4_V2_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2747
  { IMAGE_GATHER4_C_LZ_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2748
  { IMAGE_GATHER4_C_LZ_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2749
  { IMAGE_GATHER4_C_LZ_V5_V2_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2750
  { IMAGE_GATHER4_C_LZ_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2751
  { IMAGE_GATHER4_C_LZ_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2752
  { IMAGE_GATHER4_C_LZ_V2_V2_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2753
  { IMAGE_GATHER4_C_LZ_V2_V3_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2754
  { IMAGE_GATHER4_C_LZ_V2_V4_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2755
  { IMAGE_GATHER4_C_LZ_V4_V2_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2756
  { IMAGE_GATHER4_C_LZ_V4_V3_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2757
  { IMAGE_GATHER4_C_LZ_V4_V4_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2758
  { IMAGE_GATHER4_C_LZ_V5_V2_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2759
  { IMAGE_GATHER4_C_LZ_V5_V3_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2760
  { IMAGE_GATHER4_C_LZ_V5_V4_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2761
  { IMAGE_GATHER4_C_LZ_V2_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2762
  { IMAGE_GATHER4_C_LZ_V2_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2763
  { IMAGE_GATHER4_C_LZ_V2_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2764
  { IMAGE_GATHER4_C_LZ_V4_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2765
  { IMAGE_GATHER4_C_LZ_V4_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2766
  { IMAGE_GATHER4_C_LZ_V4_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2767
  { IMAGE_GATHER4_C_LZ_V5_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2768
  { IMAGE_GATHER4_C_LZ_V5_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2769
  { IMAGE_GATHER4_C_LZ_V5_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2770
  { IMAGE_GATHER4_C_LZ_O_V2_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2771
  { IMAGE_GATHER4_C_LZ_O_V2_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2772
  { IMAGE_GATHER4_C_LZ_O_V2_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2773
  { IMAGE_GATHER4_C_LZ_O_V2_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2774
  { IMAGE_GATHER4_C_LZ_O_V4_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2775
  { IMAGE_GATHER4_C_LZ_O_V4_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2776
  { IMAGE_GATHER4_C_LZ_O_V4_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2777
  { IMAGE_GATHER4_C_LZ_O_V4_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2778
  { IMAGE_GATHER4_C_LZ_O_V5_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2779
  { IMAGE_GATHER4_C_LZ_O_V5_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2780
  { IMAGE_GATHER4_C_LZ_O_V5_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2781
  { IMAGE_GATHER4_C_LZ_O_V5_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2782
  { IMAGE_GATHER4_C_LZ_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2783
  { IMAGE_GATHER4_C_LZ_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2784
  { IMAGE_GATHER4_C_LZ_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2785
  { IMAGE_GATHER4_C_LZ_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2786
  { IMAGE_GATHER4_C_LZ_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2787
  { IMAGE_GATHER4_C_LZ_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2788
  { IMAGE_GATHER4_C_LZ_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2789
  { IMAGE_GATHER4_C_LZ_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2790
  { IMAGE_GATHER4_C_LZ_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2791
  { IMAGE_GATHER4_C_LZ_O_V2_V3_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2792
  { IMAGE_GATHER4_C_LZ_O_V2_V4_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2793
  { IMAGE_GATHER4_C_LZ_O_V2_V5_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 2794
  { IMAGE_GATHER4_C_LZ_O_V2_V8_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 2795
  { IMAGE_GATHER4_C_LZ_O_V4_V3_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2796
  { IMAGE_GATHER4_C_LZ_O_V4_V4_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2797
  { IMAGE_GATHER4_C_LZ_O_V4_V5_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 2798
  { IMAGE_GATHER4_C_LZ_O_V4_V8_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 2799
  { IMAGE_GATHER4_C_LZ_O_V5_V3_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2800
  { IMAGE_GATHER4_C_LZ_O_V5_V4_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2801
  { IMAGE_GATHER4_C_LZ_O_V5_V5_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 2802
  { IMAGE_GATHER4_C_LZ_O_V5_V8_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 2803
  { IMAGE_GATHER4_C_LZ_O_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2804
  { IMAGE_GATHER4_C_LZ_O_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2805
  { IMAGE_GATHER4_C_LZ_O_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 2806
  { IMAGE_GATHER4_C_LZ_O_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2807
  { IMAGE_GATHER4_C_LZ_O_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2808
  { IMAGE_GATHER4_C_LZ_O_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 2809
  { IMAGE_GATHER4_C_LZ_O_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2810
  { IMAGE_GATHER4_C_LZ_O_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2811
  { IMAGE_GATHER4_C_LZ_O_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 2812
  { IMAGE_GATHER4_C_LZ_O_V2_V3_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2813
  { IMAGE_GATHER4_C_LZ_O_V2_V4_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2814
  { IMAGE_GATHER4_C_LZ_O_V2_V5_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 2815
  { IMAGE_GATHER4_C_LZ_O_V4_V3_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2816
  { IMAGE_GATHER4_C_LZ_O_V4_V4_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2817
  { IMAGE_GATHER4_C_LZ_O_V4_V5_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 2818
  { IMAGE_GATHER4_C_LZ_O_V5_V3_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2819
  { IMAGE_GATHER4_C_LZ_O_V5_V4_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2820
  { IMAGE_GATHER4_C_LZ_O_V5_V5_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 2821
  { IMAGE_GATHER4_C_LZ_O_V2_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2822
  { IMAGE_GATHER4_C_LZ_O_V2_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2823
  { IMAGE_GATHER4_C_LZ_O_V2_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2824
  { IMAGE_GATHER4_C_LZ_O_V2_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2825
  { IMAGE_GATHER4_C_LZ_O_V4_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2826
  { IMAGE_GATHER4_C_LZ_O_V4_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2827
  { IMAGE_GATHER4_C_LZ_O_V4_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2828
  { IMAGE_GATHER4_C_LZ_O_V4_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2829
  { IMAGE_GATHER4_C_LZ_O_V5_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2830
  { IMAGE_GATHER4_C_LZ_O_V5_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2831
  { IMAGE_GATHER4_C_LZ_O_V5_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2832
  { IMAGE_GATHER4_C_LZ_O_V5_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2833
  { IMAGE_GATHER4_C_L_O_V2_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2834
  { IMAGE_GATHER4_C_L_O_V2_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2835
  { IMAGE_GATHER4_C_L_O_V2_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2836
  { IMAGE_GATHER4_C_L_O_V2_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 2837
  { IMAGE_GATHER4_C_L_O_V2_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2838
  { IMAGE_GATHER4_C_L_O_V4_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2839
  { IMAGE_GATHER4_C_L_O_V4_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2840
  { IMAGE_GATHER4_C_L_O_V4_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2841
  { IMAGE_GATHER4_C_L_O_V4_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 2842
  { IMAGE_GATHER4_C_L_O_V4_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2843
  { IMAGE_GATHER4_C_L_O_V5_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2844
  { IMAGE_GATHER4_C_L_O_V5_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2845
  { IMAGE_GATHER4_C_L_O_V5_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2846
  { IMAGE_GATHER4_C_L_O_V5_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 2847
  { IMAGE_GATHER4_C_L_O_V5_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2848
  { IMAGE_GATHER4_C_L_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2849
  { IMAGE_GATHER4_C_L_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2850
  { IMAGE_GATHER4_C_L_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2851
  { IMAGE_GATHER4_C_L_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 2852
  { IMAGE_GATHER4_C_L_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2853
  { IMAGE_GATHER4_C_L_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2854
  { IMAGE_GATHER4_C_L_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2855
  { IMAGE_GATHER4_C_L_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 2856
  { IMAGE_GATHER4_C_L_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2857
  { IMAGE_GATHER4_C_L_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2858
  { IMAGE_GATHER4_C_L_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2859
  { IMAGE_GATHER4_C_L_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 2860
  { IMAGE_GATHER4_C_L_O_V2_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2861
  { IMAGE_GATHER4_C_L_O_V2_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2862
  { IMAGE_GATHER4_C_L_O_V2_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2863
  { IMAGE_GATHER4_C_L_O_V2_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 2864
  { IMAGE_GATHER4_C_L_O_V2_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2865
  { IMAGE_GATHER4_C_L_O_V4_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2866
  { IMAGE_GATHER4_C_L_O_V4_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2867
  { IMAGE_GATHER4_C_L_O_V4_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2868
  { IMAGE_GATHER4_C_L_O_V4_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 2869
  { IMAGE_GATHER4_C_L_O_V4_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2870
  { IMAGE_GATHER4_C_L_O_V5_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2871
  { IMAGE_GATHER4_C_L_O_V5_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2872
  { IMAGE_GATHER4_C_L_O_V5_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2873
  { IMAGE_GATHER4_C_L_O_V5_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 2874
  { IMAGE_GATHER4_C_L_O_V5_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2875
  { IMAGE_GATHER4_C_O_V2_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2876
  { IMAGE_GATHER4_C_O_V2_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2877
  { IMAGE_GATHER4_C_O_V2_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2878
  { IMAGE_GATHER4_C_O_V2_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2879
  { IMAGE_GATHER4_C_O_V4_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2880
  { IMAGE_GATHER4_C_O_V4_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2881
  { IMAGE_GATHER4_C_O_V4_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2882
  { IMAGE_GATHER4_C_O_V4_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2883
  { IMAGE_GATHER4_C_O_V5_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2884
  { IMAGE_GATHER4_C_O_V5_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2885
  { IMAGE_GATHER4_C_O_V5_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2886
  { IMAGE_GATHER4_C_O_V5_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2887
  { IMAGE_GATHER4_C_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2888
  { IMAGE_GATHER4_C_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2889
  { IMAGE_GATHER4_C_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2890
  { IMAGE_GATHER4_C_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2891
  { IMAGE_GATHER4_C_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2892
  { IMAGE_GATHER4_C_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2893
  { IMAGE_GATHER4_C_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2894
  { IMAGE_GATHER4_C_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2895
  { IMAGE_GATHER4_C_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2896
  { IMAGE_GATHER4_C_O_V2_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2897
  { IMAGE_GATHER4_C_O_V2_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2898
  { IMAGE_GATHER4_C_O_V2_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2899
  { IMAGE_GATHER4_C_O_V2_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2900
  { IMAGE_GATHER4_C_O_V4_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2901
  { IMAGE_GATHER4_C_O_V4_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2902
  { IMAGE_GATHER4_C_O_V4_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2903
  { IMAGE_GATHER4_C_O_V4_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2904
  { IMAGE_GATHER4_C_O_V5_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2905
  { IMAGE_GATHER4_C_O_V5_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2906
  { IMAGE_GATHER4_C_O_V5_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2907
  { IMAGE_GATHER4_C_O_V5_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2908
  { IMAGE_GATHER4_L_V2_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2909
  { IMAGE_GATHER4_L_V2_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2910
  { IMAGE_GATHER4_L_V2_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2911
  { IMAGE_GATHER4_L_V2_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2912
  { IMAGE_GATHER4_L_V4_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2913
  { IMAGE_GATHER4_L_V4_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2914
  { IMAGE_GATHER4_L_V4_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2915
  { IMAGE_GATHER4_L_V4_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2916
  { IMAGE_GATHER4_L_V5_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2917
  { IMAGE_GATHER4_L_V5_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2918
  { IMAGE_GATHER4_L_V5_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2919
  { IMAGE_GATHER4_L_V5_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2920
  { IMAGE_GATHER4_L_V2_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2921
  { IMAGE_GATHER4_L_V2_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2922
  { IMAGE_GATHER4_L_V2_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2923
  { IMAGE_GATHER4_L_V4_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2924
  { IMAGE_GATHER4_L_V4_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2925
  { IMAGE_GATHER4_L_V4_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2926
  { IMAGE_GATHER4_L_V5_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2927
  { IMAGE_GATHER4_L_V5_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2928
  { IMAGE_GATHER4_L_V5_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2929
  { IMAGE_GATHER4_L_V2_V1_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2930
  { IMAGE_GATHER4_L_V2_V2_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2931
  { IMAGE_GATHER4_L_V2_V3_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2932
  { IMAGE_GATHER4_L_V2_V4_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2933
  { IMAGE_GATHER4_L_V4_V1_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2934
  { IMAGE_GATHER4_L_V4_V2_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2935
  { IMAGE_GATHER4_L_V4_V3_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2936
  { IMAGE_GATHER4_L_V4_V4_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2937
  { IMAGE_GATHER4_L_V5_V1_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2938
  { IMAGE_GATHER4_L_V5_V2_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2939
  { IMAGE_GATHER4_L_V5_V3_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2940
  { IMAGE_GATHER4_L_V5_V4_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2941
  { IMAGE_GATHER4_L_V2_V2_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2942
  { IMAGE_GATHER4_L_V2_V3_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2943
  { IMAGE_GATHER4_L_V2_V4_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2944
  { IMAGE_GATHER4_L_V4_V2_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2945
  { IMAGE_GATHER4_L_V4_V3_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2946
  { IMAGE_GATHER4_L_V4_V4_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2947
  { IMAGE_GATHER4_L_V5_V2_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2948
  { IMAGE_GATHER4_L_V5_V3_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2949
  { IMAGE_GATHER4_L_V5_V4_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2950
  { IMAGE_GATHER4_L_V2_V1_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 2951
  { IMAGE_GATHER4_L_V2_V2_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2952
  { IMAGE_GATHER4_L_V2_V3_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2953
  { IMAGE_GATHER4_L_V2_V4_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2954
  { IMAGE_GATHER4_L_V4_V1_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 2955
  { IMAGE_GATHER4_L_V4_V2_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2956
  { IMAGE_GATHER4_L_V4_V3_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2957
  { IMAGE_GATHER4_L_V4_V4_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2958
  { IMAGE_GATHER4_L_V5_V1_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 2959
  { IMAGE_GATHER4_L_V5_V2_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2960
  { IMAGE_GATHER4_L_V5_V3_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2961
  { IMAGE_GATHER4_L_V5_V4_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2962
  { IMAGE_GATHER4_L_V2_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2963
  { IMAGE_GATHER4_L_V2_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2964
  { IMAGE_GATHER4_L_V2_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2965
  { IMAGE_GATHER4_L_V2_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2966
  { IMAGE_GATHER4_L_V4_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2967
  { IMAGE_GATHER4_L_V4_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2968
  { IMAGE_GATHER4_L_V4_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2969
  { IMAGE_GATHER4_L_V4_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2970
  { IMAGE_GATHER4_L_V5_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2971
  { IMAGE_GATHER4_L_V5_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2972
  { IMAGE_GATHER4_L_V5_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2973
  { IMAGE_GATHER4_L_V5_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2974
  { IMAGE_GATHER4_LZ_V2_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2975
  { IMAGE_GATHER4_LZ_V2_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2976
  { IMAGE_GATHER4_LZ_V2_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2977
  { IMAGE_GATHER4_LZ_V2_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2978
  { IMAGE_GATHER4_LZ_V4_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2979
  { IMAGE_GATHER4_LZ_V4_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2980
  { IMAGE_GATHER4_LZ_V4_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2981
  { IMAGE_GATHER4_LZ_V4_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2982
  { IMAGE_GATHER4_LZ_V5_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2983
  { IMAGE_GATHER4_LZ_V5_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2984
  { IMAGE_GATHER4_LZ_V5_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2985
  { IMAGE_GATHER4_LZ_V5_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2986
  { IMAGE_GATHER4_LZ_V2_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2987
  { IMAGE_GATHER4_LZ_V2_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2988
  { IMAGE_GATHER4_LZ_V4_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2989
  { IMAGE_GATHER4_LZ_V4_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2990
  { IMAGE_GATHER4_LZ_V5_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2991
  { IMAGE_GATHER4_LZ_V5_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2992
  { IMAGE_GATHER4_LZ_V2_V1_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2993
  { IMAGE_GATHER4_LZ_V2_V2_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2994
  { IMAGE_GATHER4_LZ_V2_V3_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2995
  { IMAGE_GATHER4_LZ_V2_V4_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2996
  { IMAGE_GATHER4_LZ_V4_V1_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2997
  { IMAGE_GATHER4_LZ_V4_V2_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2998
  { IMAGE_GATHER4_LZ_V4_V3_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2999
  { IMAGE_GATHER4_LZ_V4_V4_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3000
  { IMAGE_GATHER4_LZ_V5_V1_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3001
  { IMAGE_GATHER4_LZ_V5_V2_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3002
  { IMAGE_GATHER4_LZ_V5_V3_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3003
  { IMAGE_GATHER4_LZ_V5_V4_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3004
  { IMAGE_GATHER4_LZ_V2_V2_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3005
  { IMAGE_GATHER4_LZ_V2_V3_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3006
  { IMAGE_GATHER4_LZ_V4_V2_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3007
  { IMAGE_GATHER4_LZ_V4_V3_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3008
  { IMAGE_GATHER4_LZ_V5_V2_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3009
  { IMAGE_GATHER4_LZ_V5_V3_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3010
  { IMAGE_GATHER4_LZ_V2_V1_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3011
  { IMAGE_GATHER4_LZ_V2_V2_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3012
  { IMAGE_GATHER4_LZ_V2_V3_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3013
  { IMAGE_GATHER4_LZ_V4_V1_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3014
  { IMAGE_GATHER4_LZ_V4_V2_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3015
  { IMAGE_GATHER4_LZ_V4_V3_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3016
  { IMAGE_GATHER4_LZ_V5_V1_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3017
  { IMAGE_GATHER4_LZ_V5_V2_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3018
  { IMAGE_GATHER4_LZ_V5_V3_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3019
  { IMAGE_GATHER4_LZ_V2_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3020
  { IMAGE_GATHER4_LZ_V2_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3021
  { IMAGE_GATHER4_LZ_V2_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3022
  { IMAGE_GATHER4_LZ_V2_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3023
  { IMAGE_GATHER4_LZ_V4_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3024
  { IMAGE_GATHER4_LZ_V4_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3025
  { IMAGE_GATHER4_LZ_V4_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3026
  { IMAGE_GATHER4_LZ_V4_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3027
  { IMAGE_GATHER4_LZ_V5_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3028
  { IMAGE_GATHER4_LZ_V5_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3029
  { IMAGE_GATHER4_LZ_V5_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3030
  { IMAGE_GATHER4_LZ_V5_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3031
  { IMAGE_GATHER4_LZ_O_V2_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3032
  { IMAGE_GATHER4_LZ_O_V2_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3033
  { IMAGE_GATHER4_LZ_O_V2_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3034
  { IMAGE_GATHER4_LZ_O_V4_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3035
  { IMAGE_GATHER4_LZ_O_V4_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3036
  { IMAGE_GATHER4_LZ_O_V4_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3037
  { IMAGE_GATHER4_LZ_O_V5_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3038
  { IMAGE_GATHER4_LZ_O_V5_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3039
  { IMAGE_GATHER4_LZ_O_V5_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3040
  { IMAGE_GATHER4_LZ_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3041
  { IMAGE_GATHER4_LZ_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3042
  { IMAGE_GATHER4_LZ_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3043
  { IMAGE_GATHER4_LZ_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3044
  { IMAGE_GATHER4_LZ_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3045
  { IMAGE_GATHER4_LZ_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3046
  { IMAGE_GATHER4_LZ_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3047
  { IMAGE_GATHER4_LZ_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3048
  { IMAGE_GATHER4_LZ_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3049
  { IMAGE_GATHER4_LZ_O_V2_V2_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3050
  { IMAGE_GATHER4_LZ_O_V2_V3_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3051
  { IMAGE_GATHER4_LZ_O_V2_V4_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3052
  { IMAGE_GATHER4_LZ_O_V4_V2_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3053
  { IMAGE_GATHER4_LZ_O_V4_V3_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3054
  { IMAGE_GATHER4_LZ_O_V4_V4_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3055
  { IMAGE_GATHER4_LZ_O_V5_V2_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3056
  { IMAGE_GATHER4_LZ_O_V5_V3_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3057
  { IMAGE_GATHER4_LZ_O_V5_V4_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3058
  { IMAGE_GATHER4_LZ_O_V2_V2_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3059
  { IMAGE_GATHER4_LZ_O_V2_V3_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3060
  { IMAGE_GATHER4_LZ_O_V2_V4_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3061
  { IMAGE_GATHER4_LZ_O_V4_V2_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3062
  { IMAGE_GATHER4_LZ_O_V4_V3_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3063
  { IMAGE_GATHER4_LZ_O_V4_V4_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3064
  { IMAGE_GATHER4_LZ_O_V5_V2_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3065
  { IMAGE_GATHER4_LZ_O_V5_V3_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3066
  { IMAGE_GATHER4_LZ_O_V5_V4_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3067
  { IMAGE_GATHER4_LZ_O_V2_V2_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3068
  { IMAGE_GATHER4_LZ_O_V2_V3_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3069
  { IMAGE_GATHER4_LZ_O_V2_V4_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3070
  { IMAGE_GATHER4_LZ_O_V4_V2_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3071
  { IMAGE_GATHER4_LZ_O_V4_V3_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3072
  { IMAGE_GATHER4_LZ_O_V4_V4_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3073
  { IMAGE_GATHER4_LZ_O_V5_V2_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3074
  { IMAGE_GATHER4_LZ_O_V5_V3_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3075
  { IMAGE_GATHER4_LZ_O_V5_V4_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3076
  { IMAGE_GATHER4_LZ_O_V2_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3077
  { IMAGE_GATHER4_LZ_O_V2_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3078
  { IMAGE_GATHER4_LZ_O_V2_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3079
  { IMAGE_GATHER4_LZ_O_V4_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3080
  { IMAGE_GATHER4_LZ_O_V4_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3081
  { IMAGE_GATHER4_LZ_O_V4_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3082
  { IMAGE_GATHER4_LZ_O_V5_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3083
  { IMAGE_GATHER4_LZ_O_V5_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3084
  { IMAGE_GATHER4_LZ_O_V5_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3085
  { IMAGE_GATHER4_L_O_V2_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3086
  { IMAGE_GATHER4_L_O_V2_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3087
  { IMAGE_GATHER4_L_O_V2_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3088
  { IMAGE_GATHER4_L_O_V2_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 3089
  { IMAGE_GATHER4_L_O_V2_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 3090
  { IMAGE_GATHER4_L_O_V4_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3091
  { IMAGE_GATHER4_L_O_V4_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3092
  { IMAGE_GATHER4_L_O_V4_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3093
  { IMAGE_GATHER4_L_O_V4_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 3094
  { IMAGE_GATHER4_L_O_V4_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 3095
  { IMAGE_GATHER4_L_O_V5_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3096
  { IMAGE_GATHER4_L_O_V5_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3097
  { IMAGE_GATHER4_L_O_V5_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3098
  { IMAGE_GATHER4_L_O_V5_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 3099
  { IMAGE_GATHER4_L_O_V5_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 3100
  { IMAGE_GATHER4_L_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3101
  { IMAGE_GATHER4_L_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3102
  { IMAGE_GATHER4_L_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3103
  { IMAGE_GATHER4_L_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 3104
  { IMAGE_GATHER4_L_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3105
  { IMAGE_GATHER4_L_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3106
  { IMAGE_GATHER4_L_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3107
  { IMAGE_GATHER4_L_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 3108
  { IMAGE_GATHER4_L_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3109
  { IMAGE_GATHER4_L_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3110
  { IMAGE_GATHER4_L_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3111
  { IMAGE_GATHER4_L_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 3112
  { IMAGE_GATHER4_L_O_V2_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3113
  { IMAGE_GATHER4_L_O_V2_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3114
  { IMAGE_GATHER4_L_O_V2_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3115
  { IMAGE_GATHER4_L_O_V2_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 3116
  { IMAGE_GATHER4_L_O_V2_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 3117
  { IMAGE_GATHER4_L_O_V4_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3118
  { IMAGE_GATHER4_L_O_V4_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3119
  { IMAGE_GATHER4_L_O_V4_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3120
  { IMAGE_GATHER4_L_O_V4_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 3121
  { IMAGE_GATHER4_L_O_V4_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 3122
  { IMAGE_GATHER4_L_O_V5_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3123
  { IMAGE_GATHER4_L_O_V5_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3124
  { IMAGE_GATHER4_L_O_V5_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3125
  { IMAGE_GATHER4_L_O_V5_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 3126
  { IMAGE_GATHER4_L_O_V5_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 3127
  { IMAGE_GATHER4_O_V2_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3128
  { IMAGE_GATHER4_O_V2_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3129
  { IMAGE_GATHER4_O_V2_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3130
  { IMAGE_GATHER4_O_V4_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3131
  { IMAGE_GATHER4_O_V4_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3132
  { IMAGE_GATHER4_O_V4_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3133
  { IMAGE_GATHER4_O_V5_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3134
  { IMAGE_GATHER4_O_V5_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3135
  { IMAGE_GATHER4_O_V5_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3136
  { IMAGE_GATHER4_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3137
  { IMAGE_GATHER4_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3138
  { IMAGE_GATHER4_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3139
  { IMAGE_GATHER4_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3140
  { IMAGE_GATHER4_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3141
  { IMAGE_GATHER4_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3142
  { IMAGE_GATHER4_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3143
  { IMAGE_GATHER4_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3144
  { IMAGE_GATHER4_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3145
  { IMAGE_GATHER4_O_V2_V2_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3146
  { IMAGE_GATHER4_O_V2_V3_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3147
  { IMAGE_GATHER4_O_V2_V4_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3148
  { IMAGE_GATHER4_O_V4_V2_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3149
  { IMAGE_GATHER4_O_V4_V3_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3150
  { IMAGE_GATHER4_O_V4_V4_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3151
  { IMAGE_GATHER4_O_V5_V2_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3152
  { IMAGE_GATHER4_O_V5_V3_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3153
  { IMAGE_GATHER4_O_V5_V4_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3154
  { IMAGE_GATHER4_O_V2_V2_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3155
  { IMAGE_GATHER4_O_V2_V3_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3156
  { IMAGE_GATHER4_O_V2_V4_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3157
  { IMAGE_GATHER4_O_V4_V2_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3158
  { IMAGE_GATHER4_O_V4_V3_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3159
  { IMAGE_GATHER4_O_V4_V4_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3160
  { IMAGE_GATHER4_O_V5_V2_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3161
  { IMAGE_GATHER4_O_V5_V3_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3162
  { IMAGE_GATHER4_O_V5_V4_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3163
  { IMAGE_GATHER4_O_V2_V2_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3164
  { IMAGE_GATHER4_O_V2_V3_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3165
  { IMAGE_GATHER4_O_V2_V4_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3166
  { IMAGE_GATHER4_O_V4_V2_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3167
  { IMAGE_GATHER4_O_V4_V3_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3168
  { IMAGE_GATHER4_O_V4_V4_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3169
  { IMAGE_GATHER4_O_V5_V2_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3170
  { IMAGE_GATHER4_O_V5_V3_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3171
  { IMAGE_GATHER4_O_V5_V4_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3172
  { IMAGE_GATHER4_O_V2_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3173
  { IMAGE_GATHER4_O_V2_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3174
  { IMAGE_GATHER4_O_V2_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3175
  { IMAGE_GATHER4_O_V4_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3176
  { IMAGE_GATHER4_O_V4_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3177
  { IMAGE_GATHER4_O_V4_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3178
  { IMAGE_GATHER4_O_V5_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3179
  { IMAGE_GATHER4_O_V5_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3180
  { IMAGE_GATHER4_O_V5_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3181
  { IMAGE_GET_LOD_V1_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3182
  { IMAGE_GET_LOD_V1_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3183
  { IMAGE_GET_LOD_V1_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3184
  { IMAGE_GET_LOD_V1_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3185
  { IMAGE_GET_LOD_V2_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3186
  { IMAGE_GET_LOD_V2_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3187
  { IMAGE_GET_LOD_V2_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3188
  { IMAGE_GET_LOD_V2_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3189
  { IMAGE_GET_LOD_V3_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3190
  { IMAGE_GET_LOD_V3_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3191
  { IMAGE_GET_LOD_V3_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3192
  { IMAGE_GET_LOD_V3_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3193
  { IMAGE_GET_LOD_V4_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3194
  { IMAGE_GET_LOD_V4_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3195
  { IMAGE_GET_LOD_V4_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3196
  { IMAGE_GET_LOD_V4_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3197
  { IMAGE_GET_LOD_V5_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3198
  { IMAGE_GET_LOD_V5_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3199
  { IMAGE_GET_LOD_V5_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3200
  { IMAGE_GET_LOD_V5_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3201
  { IMAGE_GET_LOD_V1_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3202
  { IMAGE_GET_LOD_V1_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3203
  { IMAGE_GET_LOD_V2_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3204
  { IMAGE_GET_LOD_V2_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3205
  { IMAGE_GET_LOD_V3_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3206
  { IMAGE_GET_LOD_V3_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3207
  { IMAGE_GET_LOD_V4_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3208
  { IMAGE_GET_LOD_V4_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3209
  { IMAGE_GET_LOD_V5_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3210
  { IMAGE_GET_LOD_V5_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3211
  { IMAGE_GET_LOD_V1_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3212
  { IMAGE_GET_LOD_V1_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3213
  { IMAGE_GET_LOD_V1_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3214
  { IMAGE_GET_LOD_V1_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3215
  { IMAGE_GET_LOD_V2_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3216
  { IMAGE_GET_LOD_V2_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3217
  { IMAGE_GET_LOD_V2_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3218
  { IMAGE_GET_LOD_V2_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3219
  { IMAGE_GET_LOD_V3_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3220
  { IMAGE_GET_LOD_V3_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3221
  { IMAGE_GET_LOD_V3_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3222
  { IMAGE_GET_LOD_V3_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3223
  { IMAGE_GET_LOD_V4_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3224
  { IMAGE_GET_LOD_V4_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3225
  { IMAGE_GET_LOD_V4_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3226
  { IMAGE_GET_LOD_V4_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3227
  { IMAGE_GET_LOD_V5_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3228
  { IMAGE_GET_LOD_V5_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3229
  { IMAGE_GET_LOD_V5_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3230
  { IMAGE_GET_LOD_V5_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3231
  { IMAGE_GET_LOD_V1_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3232
  { IMAGE_GET_LOD_V1_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3233
  { IMAGE_GET_LOD_V2_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3234
  { IMAGE_GET_LOD_V2_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3235
  { IMAGE_GET_LOD_V3_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3236
  { IMAGE_GET_LOD_V3_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3237
  { IMAGE_GET_LOD_V4_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3238
  { IMAGE_GET_LOD_V4_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3239
  { IMAGE_GET_LOD_V5_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3240
  { IMAGE_GET_LOD_V5_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3241
  { IMAGE_GET_LOD_V1_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3242
  { IMAGE_GET_LOD_V1_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3243
  { IMAGE_GET_LOD_V1_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3244
  { IMAGE_GET_LOD_V2_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3245
  { IMAGE_GET_LOD_V2_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3246
  { IMAGE_GET_LOD_V2_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3247
  { IMAGE_GET_LOD_V3_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3248
  { IMAGE_GET_LOD_V3_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3249
  { IMAGE_GET_LOD_V3_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3250
  { IMAGE_GET_LOD_V4_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3251
  { IMAGE_GET_LOD_V4_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3252
  { IMAGE_GET_LOD_V4_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3253
  { IMAGE_GET_LOD_V5_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3254
  { IMAGE_GET_LOD_V5_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3255
  { IMAGE_GET_LOD_V5_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3256
  { IMAGE_GET_LOD_V1_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3257
  { IMAGE_GET_LOD_V1_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3258
  { IMAGE_GET_LOD_V1_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3259
  { IMAGE_GET_LOD_V1_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3260
  { IMAGE_GET_LOD_V2_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3261
  { IMAGE_GET_LOD_V2_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3262
  { IMAGE_GET_LOD_V2_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3263
  { IMAGE_GET_LOD_V2_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3264
  { IMAGE_GET_LOD_V3_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3265
  { IMAGE_GET_LOD_V3_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3266
  { IMAGE_GET_LOD_V3_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3267
  { IMAGE_GET_LOD_V3_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3268
  { IMAGE_GET_LOD_V4_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3269
  { IMAGE_GET_LOD_V4_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3270
  { IMAGE_GET_LOD_V4_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3271
  { IMAGE_GET_LOD_V4_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3272
  { IMAGE_GET_LOD_V5_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3273
  { IMAGE_GET_LOD_V5_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3274
  { IMAGE_GET_LOD_V5_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3275
  { IMAGE_GET_LOD_V5_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3276
  { IMAGE_GET_LOD_V1_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3277
  { IMAGE_GET_LOD_V1_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3278
  { IMAGE_GET_LOD_V1_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3279
  { IMAGE_GET_LOD_V1_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3280
  { IMAGE_GET_LOD_V2_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3281
  { IMAGE_GET_LOD_V2_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3282
  { IMAGE_GET_LOD_V2_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3283
  { IMAGE_GET_LOD_V2_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3284
  { IMAGE_GET_LOD_V3_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3285
  { IMAGE_GET_LOD_V3_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3286
  { IMAGE_GET_LOD_V3_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3287
  { IMAGE_GET_LOD_V3_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3288
  { IMAGE_GET_LOD_V4_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3289
  { IMAGE_GET_LOD_V4_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3290
  { IMAGE_GET_LOD_V4_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3291
  { IMAGE_GET_LOD_V4_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3292
  { IMAGE_GET_LOD_V5_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3293
  { IMAGE_GET_LOD_V5_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3294
  { IMAGE_GET_LOD_V5_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3295
  { IMAGE_GET_LOD_V5_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3296
  { IMAGE_GET_RESINFO_V1_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3297
  { IMAGE_GET_RESINFO_V1_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3298
  { IMAGE_GET_RESINFO_V1_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3299
  { IMAGE_GET_RESINFO_V1_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3300
  { IMAGE_GET_RESINFO_V2_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3301
  { IMAGE_GET_RESINFO_V2_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3302
  { IMAGE_GET_RESINFO_V2_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3303
  { IMAGE_GET_RESINFO_V2_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3304
  { IMAGE_GET_RESINFO_V3_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3305
  { IMAGE_GET_RESINFO_V3_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3306
  { IMAGE_GET_RESINFO_V3_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3307
  { IMAGE_GET_RESINFO_V3_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3308
  { IMAGE_GET_RESINFO_V4_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3309
  { IMAGE_GET_RESINFO_V4_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3310
  { IMAGE_GET_RESINFO_V4_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3311
  { IMAGE_GET_RESINFO_V4_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3312
  { IMAGE_GET_RESINFO_V5_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3313
  { IMAGE_GET_RESINFO_V5_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3314
  { IMAGE_GET_RESINFO_V5_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3315
  { IMAGE_GET_RESINFO_V5_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3316
  { IMAGE_GET_RESINFO_V1_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3317
  { IMAGE_GET_RESINFO_V1_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3318
  { IMAGE_GET_RESINFO_V1_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3319
  { IMAGE_GET_RESINFO_V2_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3320
  { IMAGE_GET_RESINFO_V2_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3321
  { IMAGE_GET_RESINFO_V2_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3322
  { IMAGE_GET_RESINFO_V3_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3323
  { IMAGE_GET_RESINFO_V3_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3324
  { IMAGE_GET_RESINFO_V3_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3325
  { IMAGE_GET_RESINFO_V4_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3326
  { IMAGE_GET_RESINFO_V4_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3327
  { IMAGE_GET_RESINFO_V4_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3328
  { IMAGE_GET_RESINFO_V5_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3329
  { IMAGE_GET_RESINFO_V5_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3330
  { IMAGE_GET_RESINFO_V5_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3331
  { IMAGE_GET_RESINFO_V1_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3332
  { IMAGE_GET_RESINFO_V1_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3333
  { IMAGE_GET_RESINFO_V1_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3334
  { IMAGE_GET_RESINFO_V1_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3335
  { IMAGE_GET_RESINFO_V2_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3336
  { IMAGE_GET_RESINFO_V2_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3337
  { IMAGE_GET_RESINFO_V2_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3338
  { IMAGE_GET_RESINFO_V2_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3339
  { IMAGE_GET_RESINFO_V3_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3340
  { IMAGE_GET_RESINFO_V3_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3341
  { IMAGE_GET_RESINFO_V3_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3342
  { IMAGE_GET_RESINFO_V3_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3343
  { IMAGE_GET_RESINFO_V4_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3344
  { IMAGE_GET_RESINFO_V4_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3345
  { IMAGE_GET_RESINFO_V4_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3346
  { IMAGE_GET_RESINFO_V4_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3347
  { IMAGE_GET_RESINFO_V5_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3348
  { IMAGE_GET_RESINFO_V5_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3349
  { IMAGE_GET_RESINFO_V5_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3350
  { IMAGE_GET_RESINFO_V5_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3351
  { IMAGE_GET_RESINFO_V1_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3352
  { IMAGE_GET_RESINFO_V1_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3353
  { IMAGE_GET_RESINFO_V1_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3354
  { IMAGE_GET_RESINFO_V2_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3355
  { IMAGE_GET_RESINFO_V2_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3356
  { IMAGE_GET_RESINFO_V2_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3357
  { IMAGE_GET_RESINFO_V3_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3358
  { IMAGE_GET_RESINFO_V3_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3359
  { IMAGE_GET_RESINFO_V3_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3360
  { IMAGE_GET_RESINFO_V4_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3361
  { IMAGE_GET_RESINFO_V4_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3362
  { IMAGE_GET_RESINFO_V4_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3363
  { IMAGE_GET_RESINFO_V5_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3364
  { IMAGE_GET_RESINFO_V5_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3365
  { IMAGE_GET_RESINFO_V5_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3366
  { IMAGE_GET_RESINFO_V1_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3367
  { IMAGE_GET_RESINFO_V1_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3368
  { IMAGE_GET_RESINFO_V1_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3369
  { IMAGE_GET_RESINFO_V1_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3370
  { IMAGE_GET_RESINFO_V2_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3371
  { IMAGE_GET_RESINFO_V2_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3372
  { IMAGE_GET_RESINFO_V2_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3373
  { IMAGE_GET_RESINFO_V2_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3374
  { IMAGE_GET_RESINFO_V3_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3375
  { IMAGE_GET_RESINFO_V3_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3376
  { IMAGE_GET_RESINFO_V3_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3377
  { IMAGE_GET_RESINFO_V3_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3378
  { IMAGE_GET_RESINFO_V4_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3379
  { IMAGE_GET_RESINFO_V4_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3380
  { IMAGE_GET_RESINFO_V4_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3381
  { IMAGE_GET_RESINFO_V4_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3382
  { IMAGE_GET_RESINFO_V5_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3383
  { IMAGE_GET_RESINFO_V5_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3384
  { IMAGE_GET_RESINFO_V5_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3385
  { IMAGE_GET_RESINFO_V5_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3386
  { IMAGE_GET_RESINFO_V1_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3387
  { IMAGE_GET_RESINFO_V1_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3388
  { IMAGE_GET_RESINFO_V1_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3389
  { IMAGE_GET_RESINFO_V1_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3390
  { IMAGE_GET_RESINFO_V2_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3391
  { IMAGE_GET_RESINFO_V2_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3392
  { IMAGE_GET_RESINFO_V2_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3393
  { IMAGE_GET_RESINFO_V2_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3394
  { IMAGE_GET_RESINFO_V3_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3395
  { IMAGE_GET_RESINFO_V3_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3396
  { IMAGE_GET_RESINFO_V3_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3397
  { IMAGE_GET_RESINFO_V3_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3398
  { IMAGE_GET_RESINFO_V4_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3399
  { IMAGE_GET_RESINFO_V4_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3400
  { IMAGE_GET_RESINFO_V4_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3401
  { IMAGE_GET_RESINFO_V4_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3402
  { IMAGE_GET_RESINFO_V5_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3403
  { IMAGE_GET_RESINFO_V5_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3404
  { IMAGE_GET_RESINFO_V5_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3405
  { IMAGE_GET_RESINFO_V5_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3406
  { IMAGE_GET_RESINFO_V1_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3407
  { IMAGE_GET_RESINFO_V1_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3408
  { IMAGE_GET_RESINFO_V1_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3409
  { IMAGE_GET_RESINFO_V1_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3410
  { IMAGE_GET_RESINFO_V2_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3411
  { IMAGE_GET_RESINFO_V2_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3412
  { IMAGE_GET_RESINFO_V2_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3413
  { IMAGE_GET_RESINFO_V2_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3414
  { IMAGE_GET_RESINFO_V3_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3415
  { IMAGE_GET_RESINFO_V3_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3416
  { IMAGE_GET_RESINFO_V3_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3417
  { IMAGE_GET_RESINFO_V3_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3418
  { IMAGE_GET_RESINFO_V4_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3419
  { IMAGE_GET_RESINFO_V4_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3420
  { IMAGE_GET_RESINFO_V4_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3421
  { IMAGE_GET_RESINFO_V4_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3422
  { IMAGE_GET_RESINFO_V5_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3423
  { IMAGE_GET_RESINFO_V5_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3424
  { IMAGE_GET_RESINFO_V5_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3425
  { IMAGE_GET_RESINFO_V5_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3426
  { IMAGE_LOAD_V1_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3427
  { IMAGE_LOAD_V1_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3428
  { IMAGE_LOAD_V1_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3429
  { IMAGE_LOAD_V1_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3430
  { IMAGE_LOAD_V2_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3431
  { IMAGE_LOAD_V2_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3432
  { IMAGE_LOAD_V2_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3433
  { IMAGE_LOAD_V2_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3434
  { IMAGE_LOAD_V3_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3435
  { IMAGE_LOAD_V3_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3436
  { IMAGE_LOAD_V3_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3437
  { IMAGE_LOAD_V3_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3438
  { IMAGE_LOAD_V4_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3439
  { IMAGE_LOAD_V4_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3440
  { IMAGE_LOAD_V4_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3441
  { IMAGE_LOAD_V4_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3442
  { IMAGE_LOAD_V5_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3443
  { IMAGE_LOAD_V5_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3444
  { IMAGE_LOAD_V5_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3445
  { IMAGE_LOAD_V5_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3446
  { IMAGE_LOAD_V1_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3447
  { IMAGE_LOAD_V1_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3448
  { IMAGE_LOAD_V1_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3449
  { IMAGE_LOAD_V2_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3450
  { IMAGE_LOAD_V2_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3451
  { IMAGE_LOAD_V2_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3452
  { IMAGE_LOAD_V3_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3453
  { IMAGE_LOAD_V3_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3454
  { IMAGE_LOAD_V3_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3455
  { IMAGE_LOAD_V4_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3456
  { IMAGE_LOAD_V4_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3457
  { IMAGE_LOAD_V4_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3458
  { IMAGE_LOAD_V5_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3459
  { IMAGE_LOAD_V5_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3460
  { IMAGE_LOAD_V5_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3461
  { IMAGE_LOAD_V1_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3462
  { IMAGE_LOAD_V1_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3463
  { IMAGE_LOAD_V1_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3464
  { IMAGE_LOAD_V1_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3465
  { IMAGE_LOAD_V2_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3466
  { IMAGE_LOAD_V2_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3467
  { IMAGE_LOAD_V2_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3468
  { IMAGE_LOAD_V2_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3469
  { IMAGE_LOAD_V3_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3470
  { IMAGE_LOAD_V3_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3471
  { IMAGE_LOAD_V3_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3472
  { IMAGE_LOAD_V3_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3473
  { IMAGE_LOAD_V4_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3474
  { IMAGE_LOAD_V4_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3475
  { IMAGE_LOAD_V4_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3476
  { IMAGE_LOAD_V4_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3477
  { IMAGE_LOAD_V5_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3478
  { IMAGE_LOAD_V5_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3479
  { IMAGE_LOAD_V5_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3480
  { IMAGE_LOAD_V5_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3481
  { IMAGE_LOAD_V1_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3482
  { IMAGE_LOAD_V1_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3483
  { IMAGE_LOAD_V1_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3484
  { IMAGE_LOAD_V2_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3485
  { IMAGE_LOAD_V2_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3486
  { IMAGE_LOAD_V2_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3487
  { IMAGE_LOAD_V3_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3488
  { IMAGE_LOAD_V3_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3489
  { IMAGE_LOAD_V3_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3490
  { IMAGE_LOAD_V4_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3491
  { IMAGE_LOAD_V4_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3492
  { IMAGE_LOAD_V4_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3493
  { IMAGE_LOAD_V5_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3494
  { IMAGE_LOAD_V5_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3495
  { IMAGE_LOAD_V5_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3496
  { IMAGE_LOAD_V1_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3497
  { IMAGE_LOAD_V1_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3498
  { IMAGE_LOAD_V1_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3499
  { IMAGE_LOAD_V1_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3500
  { IMAGE_LOAD_V2_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3501
  { IMAGE_LOAD_V2_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3502
  { IMAGE_LOAD_V2_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3503
  { IMAGE_LOAD_V2_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3504
  { IMAGE_LOAD_V3_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3505
  { IMAGE_LOAD_V3_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3506
  { IMAGE_LOAD_V3_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3507
  { IMAGE_LOAD_V3_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3508
  { IMAGE_LOAD_V4_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3509
  { IMAGE_LOAD_V4_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3510
  { IMAGE_LOAD_V4_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3511
  { IMAGE_LOAD_V4_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3512
  { IMAGE_LOAD_V5_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3513
  { IMAGE_LOAD_V5_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3514
  { IMAGE_LOAD_V5_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3515
  { IMAGE_LOAD_V5_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3516
  { IMAGE_LOAD_V1_V1, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3517
  { IMAGE_LOAD_V1_V2, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3518
  { IMAGE_LOAD_V1_V3, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3519
  { IMAGE_LOAD_V1_V4, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3520
  { IMAGE_LOAD_V2_V1, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3521
  { IMAGE_LOAD_V2_V2, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3522
  { IMAGE_LOAD_V2_V3, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3523
  { IMAGE_LOAD_V2_V4, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3524
  { IMAGE_LOAD_V3_V1, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3525
  { IMAGE_LOAD_V3_V2, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3526
  { IMAGE_LOAD_V3_V3, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3527
  { IMAGE_LOAD_V3_V4, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3528
  { IMAGE_LOAD_V4_V1, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3529
  { IMAGE_LOAD_V4_V2, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3530
  { IMAGE_LOAD_V4_V3, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3531
  { IMAGE_LOAD_V4_V4, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3532
  { IMAGE_LOAD_V5_V1, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3533
  { IMAGE_LOAD_V5_V2, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3534
  { IMAGE_LOAD_V5_V3, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3535
  { IMAGE_LOAD_V5_V4, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3536
  { IMAGE_LOAD_V1_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3537
  { IMAGE_LOAD_V1_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3538
  { IMAGE_LOAD_V1_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3539
  { IMAGE_LOAD_V1_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3540
  { IMAGE_LOAD_V2_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3541
  { IMAGE_LOAD_V2_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3542
  { IMAGE_LOAD_V2_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3543
  { IMAGE_LOAD_V2_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3544
  { IMAGE_LOAD_V3_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3545
  { IMAGE_LOAD_V3_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3546
  { IMAGE_LOAD_V3_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3547
  { IMAGE_LOAD_V3_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3548
  { IMAGE_LOAD_V4_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3549
  { IMAGE_LOAD_V4_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3550
  { IMAGE_LOAD_V4_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3551
  { IMAGE_LOAD_V4_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3552
  { IMAGE_LOAD_V5_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3553
  { IMAGE_LOAD_V5_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3554
  { IMAGE_LOAD_V5_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3555
  { IMAGE_LOAD_V5_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3556
  { IMAGE_LOAD_MIP_V1_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3557
  { IMAGE_LOAD_MIP_V1_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3558
  { IMAGE_LOAD_MIP_V1_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3559
  { IMAGE_LOAD_MIP_V1_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3560
  { IMAGE_LOAD_MIP_V2_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3561
  { IMAGE_LOAD_MIP_V2_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3562
  { IMAGE_LOAD_MIP_V2_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3563
  { IMAGE_LOAD_MIP_V2_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3564
  { IMAGE_LOAD_MIP_V3_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3565
  { IMAGE_LOAD_MIP_V3_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3566
  { IMAGE_LOAD_MIP_V3_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3567
  { IMAGE_LOAD_MIP_V3_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3568
  { IMAGE_LOAD_MIP_V4_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3569
  { IMAGE_LOAD_MIP_V4_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3570
  { IMAGE_LOAD_MIP_V4_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3571
  { IMAGE_LOAD_MIP_V4_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3572
  { IMAGE_LOAD_MIP_V5_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3573
  { IMAGE_LOAD_MIP_V5_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3574
  { IMAGE_LOAD_MIP_V5_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3575
  { IMAGE_LOAD_MIP_V5_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3576
  { IMAGE_LOAD_MIP_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3577
  { IMAGE_LOAD_MIP_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3578
  { IMAGE_LOAD_MIP_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3579
  { IMAGE_LOAD_MIP_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3580
  { IMAGE_LOAD_MIP_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3581
  { IMAGE_LOAD_MIP_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3582
  { IMAGE_LOAD_MIP_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3583
  { IMAGE_LOAD_MIP_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3584
  { IMAGE_LOAD_MIP_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3585
  { IMAGE_LOAD_MIP_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3586
  { IMAGE_LOAD_MIP_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3587
  { IMAGE_LOAD_MIP_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3588
  { IMAGE_LOAD_MIP_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3589
  { IMAGE_LOAD_MIP_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3590
  { IMAGE_LOAD_MIP_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3591
  { IMAGE_LOAD_MIP_V1_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3592
  { IMAGE_LOAD_MIP_V1_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3593
  { IMAGE_LOAD_MIP_V1_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3594
  { IMAGE_LOAD_MIP_V1_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3595
  { IMAGE_LOAD_MIP_V2_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3596
  { IMAGE_LOAD_MIP_V2_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3597
  { IMAGE_LOAD_MIP_V2_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3598
  { IMAGE_LOAD_MIP_V2_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3599
  { IMAGE_LOAD_MIP_V3_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3600
  { IMAGE_LOAD_MIP_V3_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3601
  { IMAGE_LOAD_MIP_V3_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3602
  { IMAGE_LOAD_MIP_V3_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3603
  { IMAGE_LOAD_MIP_V4_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3604
  { IMAGE_LOAD_MIP_V4_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3605
  { IMAGE_LOAD_MIP_V4_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3606
  { IMAGE_LOAD_MIP_V4_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3607
  { IMAGE_LOAD_MIP_V5_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3608
  { IMAGE_LOAD_MIP_V5_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3609
  { IMAGE_LOAD_MIP_V5_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3610
  { IMAGE_LOAD_MIP_V5_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3611
  { IMAGE_LOAD_MIP_V1_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3612
  { IMAGE_LOAD_MIP_V1_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3613
  { IMAGE_LOAD_MIP_V1_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3614
  { IMAGE_LOAD_MIP_V2_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3615
  { IMAGE_LOAD_MIP_V2_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3616
  { IMAGE_LOAD_MIP_V2_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3617
  { IMAGE_LOAD_MIP_V3_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3618
  { IMAGE_LOAD_MIP_V3_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3619
  { IMAGE_LOAD_MIP_V3_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3620
  { IMAGE_LOAD_MIP_V4_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3621
  { IMAGE_LOAD_MIP_V4_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3622
  { IMAGE_LOAD_MIP_V4_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3623
  { IMAGE_LOAD_MIP_V5_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3624
  { IMAGE_LOAD_MIP_V5_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3625
  { IMAGE_LOAD_MIP_V5_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3626
  { IMAGE_LOAD_MIP_V1_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3627
  { IMAGE_LOAD_MIP_V1_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3628
  { IMAGE_LOAD_MIP_V1_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3629
  { IMAGE_LOAD_MIP_V1_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3630
  { IMAGE_LOAD_MIP_V2_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3631
  { IMAGE_LOAD_MIP_V2_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3632
  { IMAGE_LOAD_MIP_V2_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3633
  { IMAGE_LOAD_MIP_V2_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3634
  { IMAGE_LOAD_MIP_V3_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3635
  { IMAGE_LOAD_MIP_V3_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3636
  { IMAGE_LOAD_MIP_V3_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3637
  { IMAGE_LOAD_MIP_V3_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3638
  { IMAGE_LOAD_MIP_V4_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3639
  { IMAGE_LOAD_MIP_V4_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3640
  { IMAGE_LOAD_MIP_V4_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3641
  { IMAGE_LOAD_MIP_V4_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3642
  { IMAGE_LOAD_MIP_V5_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3643
  { IMAGE_LOAD_MIP_V5_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3644
  { IMAGE_LOAD_MIP_V5_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3645
  { IMAGE_LOAD_MIP_V5_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3646
  { IMAGE_LOAD_MIP_V1_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3647
  { IMAGE_LOAD_MIP_V1_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3648
  { IMAGE_LOAD_MIP_V1_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3649
  { IMAGE_LOAD_MIP_V1_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3650
  { IMAGE_LOAD_MIP_V2_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3651
  { IMAGE_LOAD_MIP_V2_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3652
  { IMAGE_LOAD_MIP_V2_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3653
  { IMAGE_LOAD_MIP_V2_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3654
  { IMAGE_LOAD_MIP_V3_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3655
  { IMAGE_LOAD_MIP_V3_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3656
  { IMAGE_LOAD_MIP_V3_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3657
  { IMAGE_LOAD_MIP_V3_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3658
  { IMAGE_LOAD_MIP_V4_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3659
  { IMAGE_LOAD_MIP_V4_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3660
  { IMAGE_LOAD_MIP_V4_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3661
  { IMAGE_LOAD_MIP_V4_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3662
  { IMAGE_LOAD_MIP_V5_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3663
  { IMAGE_LOAD_MIP_V5_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3664
  { IMAGE_LOAD_MIP_V5_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3665
  { IMAGE_LOAD_MIP_V5_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3666
  { IMAGE_LOAD_MIP_V1_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3667
  { IMAGE_LOAD_MIP_V1_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3668
  { IMAGE_LOAD_MIP_V1_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3669
  { IMAGE_LOAD_MIP_V1_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3670
  { IMAGE_LOAD_MIP_V2_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3671
  { IMAGE_LOAD_MIP_V2_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3672
  { IMAGE_LOAD_MIP_V2_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3673
  { IMAGE_LOAD_MIP_V2_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3674
  { IMAGE_LOAD_MIP_V3_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3675
  { IMAGE_LOAD_MIP_V3_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3676
  { IMAGE_LOAD_MIP_V3_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3677
  { IMAGE_LOAD_MIP_V3_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3678
  { IMAGE_LOAD_MIP_V4_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3679
  { IMAGE_LOAD_MIP_V4_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3680
  { IMAGE_LOAD_MIP_V4_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3681
  { IMAGE_LOAD_MIP_V4_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3682
  { IMAGE_LOAD_MIP_V5_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3683
  { IMAGE_LOAD_MIP_V5_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3684
  { IMAGE_LOAD_MIP_V5_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3685
  { IMAGE_LOAD_MIP_V5_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3686
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3687
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3688
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3689
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3690
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3691
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3692
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3693
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3694
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3695
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3696
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3697
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3698
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3699
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3700
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3701
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3702
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3703
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3704
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3705
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3706
  { IMAGE_LOAD_MIP_PCK_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3707
  { IMAGE_LOAD_MIP_PCK_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3708
  { IMAGE_LOAD_MIP_PCK_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3709
  { IMAGE_LOAD_MIP_PCK_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3710
  { IMAGE_LOAD_MIP_PCK_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3711
  { IMAGE_LOAD_MIP_PCK_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3712
  { IMAGE_LOAD_MIP_PCK_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3713
  { IMAGE_LOAD_MIP_PCK_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3714
  { IMAGE_LOAD_MIP_PCK_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3715
  { IMAGE_LOAD_MIP_PCK_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3716
  { IMAGE_LOAD_MIP_PCK_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3717
  { IMAGE_LOAD_MIP_PCK_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3718
  { IMAGE_LOAD_MIP_PCK_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3719
  { IMAGE_LOAD_MIP_PCK_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3720
  { IMAGE_LOAD_MIP_PCK_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3721
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3722
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3723
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3724
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3725
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3726
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3727
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3728
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3729
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3730
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3731
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3732
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3733
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3734
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3735
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3736
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3737
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3738
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3739
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3740
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3741
  { IMAGE_LOAD_MIP_PCK_V1_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3742
  { IMAGE_LOAD_MIP_PCK_V1_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3743
  { IMAGE_LOAD_MIP_PCK_V1_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3744
  { IMAGE_LOAD_MIP_PCK_V2_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3745
  { IMAGE_LOAD_MIP_PCK_V2_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3746
  { IMAGE_LOAD_MIP_PCK_V2_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3747
  { IMAGE_LOAD_MIP_PCK_V3_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3748
  { IMAGE_LOAD_MIP_PCK_V3_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3749
  { IMAGE_LOAD_MIP_PCK_V3_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3750
  { IMAGE_LOAD_MIP_PCK_V4_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3751
  { IMAGE_LOAD_MIP_PCK_V4_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3752
  { IMAGE_LOAD_MIP_PCK_V4_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3753
  { IMAGE_LOAD_MIP_PCK_V5_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3754
  { IMAGE_LOAD_MIP_PCK_V5_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3755
  { IMAGE_LOAD_MIP_PCK_V5_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3756
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3757
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3758
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3759
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3760
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3761
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3762
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3763
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3764
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3765
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3766
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3767
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3768
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3769
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3770
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3771
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3772
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3773
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3774
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3775
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3776
  { IMAGE_LOAD_MIP_PCK_V1_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3777
  { IMAGE_LOAD_MIP_PCK_V1_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3778
  { IMAGE_LOAD_MIP_PCK_V1_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3779
  { IMAGE_LOAD_MIP_PCK_V1_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3780
  { IMAGE_LOAD_MIP_PCK_V2_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3781
  { IMAGE_LOAD_MIP_PCK_V2_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3782
  { IMAGE_LOAD_MIP_PCK_V2_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3783
  { IMAGE_LOAD_MIP_PCK_V2_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3784
  { IMAGE_LOAD_MIP_PCK_V3_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3785
  { IMAGE_LOAD_MIP_PCK_V3_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3786
  { IMAGE_LOAD_MIP_PCK_V3_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3787
  { IMAGE_LOAD_MIP_PCK_V3_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3788
  { IMAGE_LOAD_MIP_PCK_V4_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3789
  { IMAGE_LOAD_MIP_PCK_V4_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3790
  { IMAGE_LOAD_MIP_PCK_V4_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3791
  { IMAGE_LOAD_MIP_PCK_V4_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3792
  { IMAGE_LOAD_MIP_PCK_V5_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3793
  { IMAGE_LOAD_MIP_PCK_V5_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3794
  { IMAGE_LOAD_MIP_PCK_V5_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3795
  { IMAGE_LOAD_MIP_PCK_V5_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3796
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3797
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3798
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3799
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3800
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3801
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3802
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3803
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3804
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3805
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3806
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3807
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3808
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3809
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3810
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3811
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3812
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3813
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3814
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3815
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3816
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3817
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3818
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3819
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3820
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3821
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3822
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3823
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3824
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3825
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3826
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3827
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3828
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3829
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3830
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3831
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3832
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3833
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3834
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3835
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3836
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3837
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3838
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3839
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3840
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3841
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3842
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3843
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3844
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3845
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3846
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3847
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3848
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3849
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3850
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3851
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3852
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3853
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3854
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3855
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3856
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3857
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3858
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3859
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3860
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3861
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3862
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3863
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3864
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3865
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3866
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3867
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3868
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3869
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3870
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3871
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3872
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3873
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3874
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3875
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3876
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3877
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3878
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3879
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3880
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3881
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3882
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3883
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3884
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3885
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3886
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3887
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3888
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3889
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3890
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3891
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3892
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3893
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3894
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3895
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3896
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3897
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3898
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3899
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3900
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3901
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3902
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3903
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3904
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3905
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3906
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3907
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3908
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3909
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3910
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3911
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3912
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3913
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3914
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3915
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3916
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3917
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3918
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3919
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3920
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3921
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3922
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3923
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3924
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3925
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3926
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3927
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3928
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3929
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3930
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3931
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3932
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3933
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3934
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3935
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3936
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3937
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3938
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3939
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3940
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3941
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3942
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3943
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3944
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3945
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3946
  { IMAGE_LOAD_PCK_V1_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3947
  { IMAGE_LOAD_PCK_V1_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3948
  { IMAGE_LOAD_PCK_V1_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3949
  { IMAGE_LOAD_PCK_V1_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3950
  { IMAGE_LOAD_PCK_V2_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3951
  { IMAGE_LOAD_PCK_V2_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3952
  { IMAGE_LOAD_PCK_V2_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3953
  { IMAGE_LOAD_PCK_V2_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3954
  { IMAGE_LOAD_PCK_V3_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3955
  { IMAGE_LOAD_PCK_V3_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3956
  { IMAGE_LOAD_PCK_V3_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3957
  { IMAGE_LOAD_PCK_V3_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3958
  { IMAGE_LOAD_PCK_V4_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3959
  { IMAGE_LOAD_PCK_V4_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3960
  { IMAGE_LOAD_PCK_V4_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3961
  { IMAGE_LOAD_PCK_V4_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3962
  { IMAGE_LOAD_PCK_V5_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3963
  { IMAGE_LOAD_PCK_V5_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3964
  { IMAGE_LOAD_PCK_V5_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3965
  { IMAGE_LOAD_PCK_V5_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3966
  { IMAGE_LOAD_PCK_V1_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3967
  { IMAGE_LOAD_PCK_V1_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3968
  { IMAGE_LOAD_PCK_V1_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3969
  { IMAGE_LOAD_PCK_V2_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3970
  { IMAGE_LOAD_PCK_V2_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3971
  { IMAGE_LOAD_PCK_V2_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3972
  { IMAGE_LOAD_PCK_V3_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3973
  { IMAGE_LOAD_PCK_V3_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3974
  { IMAGE_LOAD_PCK_V3_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3975
  { IMAGE_LOAD_PCK_V4_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3976
  { IMAGE_LOAD_PCK_V4_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3977
  { IMAGE_LOAD_PCK_V4_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3978
  { IMAGE_LOAD_PCK_V5_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3979
  { IMAGE_LOAD_PCK_V5_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3980
  { IMAGE_LOAD_PCK_V5_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3981
  { IMAGE_LOAD_PCK_V1_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3982
  { IMAGE_LOAD_PCK_V1_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3983
  { IMAGE_LOAD_PCK_V1_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3984
  { IMAGE_LOAD_PCK_V1_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3985
  { IMAGE_LOAD_PCK_V2_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3986
  { IMAGE_LOAD_PCK_V2_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3987
  { IMAGE_LOAD_PCK_V2_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3988
  { IMAGE_LOAD_PCK_V2_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3989
  { IMAGE_LOAD_PCK_V3_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3990
  { IMAGE_LOAD_PCK_V3_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3991
  { IMAGE_LOAD_PCK_V3_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3992
  { IMAGE_LOAD_PCK_V3_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3993
  { IMAGE_LOAD_PCK_V4_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3994
  { IMAGE_LOAD_PCK_V4_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3995
  { IMAGE_LOAD_PCK_V4_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3996
  { IMAGE_LOAD_PCK_V4_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3997
  { IMAGE_LOAD_PCK_V5_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3998
  { IMAGE_LOAD_PCK_V5_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3999
  { IMAGE_LOAD_PCK_V5_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4000
  { IMAGE_LOAD_PCK_V5_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4001
  { IMAGE_LOAD_PCK_V1_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 4002
  { IMAGE_LOAD_PCK_V1_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4003
  { IMAGE_LOAD_PCK_V1_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4004
  { IMAGE_LOAD_PCK_V2_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 4005
  { IMAGE_LOAD_PCK_V2_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4006
  { IMAGE_LOAD_PCK_V2_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4007
  { IMAGE_LOAD_PCK_V3_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 4008
  { IMAGE_LOAD_PCK_V3_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4009
  { IMAGE_LOAD_PCK_V3_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4010
  { IMAGE_LOAD_PCK_V4_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 4011
  { IMAGE_LOAD_PCK_V4_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4012
  { IMAGE_LOAD_PCK_V4_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4013
  { IMAGE_LOAD_PCK_V5_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 4014
  { IMAGE_LOAD_PCK_V5_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4015
  { IMAGE_LOAD_PCK_V5_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4016
  { IMAGE_LOAD_PCK_V1_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 4017
  { IMAGE_LOAD_PCK_V1_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 4018
  { IMAGE_LOAD_PCK_V1_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 4019
  { IMAGE_LOAD_PCK_V1_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 4020
  { IMAGE_LOAD_PCK_V2_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 4021
  { IMAGE_LOAD_PCK_V2_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 4022
  { IMAGE_LOAD_PCK_V2_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 4023
  { IMAGE_LOAD_PCK_V2_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 4024
  { IMAGE_LOAD_PCK_V3_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 4025
  { IMAGE_LOAD_PCK_V3_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 4026
  { IMAGE_LOAD_PCK_V3_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 4027
  { IMAGE_LOAD_PCK_V3_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 4028
  { IMAGE_LOAD_PCK_V4_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 4029
  { IMAGE_LOAD_PCK_V4_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 4030
  { IMAGE_LOAD_PCK_V4_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 4031
  { IMAGE_LOAD_PCK_V4_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 4032
  { IMAGE_LOAD_PCK_V5_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 4033
  { IMAGE_LOAD_PCK_V5_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 4034
  { IMAGE_LOAD_PCK_V5_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 4035
  { IMAGE_LOAD_PCK_V5_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 4036
  { IMAGE_LOAD_PCK_V1_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 4037
  { IMAGE_LOAD_PCK_V1_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4038
  { IMAGE_LOAD_PCK_V1_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4039
  { IMAGE_LOAD_PCK_V1_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4040
  { IMAGE_LOAD_PCK_V2_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 4041
  { IMAGE_LOAD_PCK_V2_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4042
  { IMAGE_LOAD_PCK_V2_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4043
  { IMAGE_LOAD_PCK_V2_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4044
  { IMAGE_LOAD_PCK_V3_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 4045
  { IMAGE_LOAD_PCK_V3_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4046
  { IMAGE_LOAD_PCK_V3_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4047
  { IMAGE_LOAD_PCK_V3_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4048
  { IMAGE_LOAD_PCK_V4_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 4049
  { IMAGE_LOAD_PCK_V4_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4050
  { IMAGE_LOAD_PCK_V4_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4051
  { IMAGE_LOAD_PCK_V4_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4052
  { IMAGE_LOAD_PCK_V5_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 4053
  { IMAGE_LOAD_PCK_V5_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4054
  { IMAGE_LOAD_PCK_V5_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4055
  { IMAGE_LOAD_PCK_V5_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4056
  { IMAGE_LOAD_PCK_V1_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 4057
  { IMAGE_LOAD_PCK_V1_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 4058
  { IMAGE_LOAD_PCK_V1_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 4059
  { IMAGE_LOAD_PCK_V1_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 4060
  { IMAGE_LOAD_PCK_V2_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 4061
  { IMAGE_LOAD_PCK_V2_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 4062
  { IMAGE_LOAD_PCK_V2_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 4063
  { IMAGE_LOAD_PCK_V2_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 4064
  { IMAGE_LOAD_PCK_V3_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 4065
  { IMAGE_LOAD_PCK_V3_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 4066
  { IMAGE_LOAD_PCK_V3_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 4067
  { IMAGE_LOAD_PCK_V3_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 4068
  { IMAGE_LOAD_PCK_V4_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 4069
  { IMAGE_LOAD_PCK_V4_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 4070
  { IMAGE_LOAD_PCK_V4_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 4071
  { IMAGE_LOAD_PCK_V4_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 4072
  { IMAGE_LOAD_PCK_V5_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 4073
  { IMAGE_LOAD_PCK_V5_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 4074
  { IMAGE_LOAD_PCK_V5_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 4075
  { IMAGE_LOAD_PCK_V5_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 4076
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 4077
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4078
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4079
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4080
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 4081
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4082
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4083
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4084
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 4085
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4086
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4087
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4088
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 4089
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4090
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4091
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4092
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 4093
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4094
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4095
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4096
  { IMAGE_LOAD_PCK_SGN_V1_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4097
  { IMAGE_LOAD_PCK_SGN_V1_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4098
  { IMAGE_LOAD_PCK_SGN_V1_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4099
  { IMAGE_LOAD_PCK_SGN_V2_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4100
  { IMAGE_LOAD_PCK_SGN_V2_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4101
  { IMAGE_LOAD_PCK_SGN_V2_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4102
  { IMAGE_LOAD_PCK_SGN_V3_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4103
  { IMAGE_LOAD_PCK_SGN_V3_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4104
  { IMAGE_LOAD_PCK_SGN_V3_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4105
  { IMAGE_LOAD_PCK_SGN_V4_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4106
  { IMAGE_LOAD_PCK_SGN_V4_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4107
  { IMAGE_LOAD_PCK_SGN_V4_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4108
  { IMAGE_LOAD_PCK_SGN_V5_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4109
  { IMAGE_LOAD_PCK_SGN_V5_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4110
  { IMAGE_LOAD_PCK_SGN_V5_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4111
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 4112
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 4113
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4114
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4115
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 4116
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 4117
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4118
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4119
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 4120
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 4121
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4122
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4123
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 4124
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 4125
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4126
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4127
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 4128
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 4129
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4130
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4131
  { IMAGE_LOAD_PCK_SGN_V1_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 4132
  { IMAGE_LOAD_PCK_SGN_V1_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4133
  { IMAGE_LOAD_PCK_SGN_V1_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4134
  { IMAGE_LOAD_PCK_SGN_V2_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 4135
  { IMAGE_LOAD_PCK_SGN_V2_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4136
  { IMAGE_LOAD_PCK_SGN_V2_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4137
  { IMAGE_LOAD_PCK_SGN_V3_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 4138
  { IMAGE_LOAD_PCK_SGN_V3_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4139
  { IMAGE_LOAD_PCK_SGN_V3_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4140
  { IMAGE_LOAD_PCK_SGN_V4_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 4141
  { IMAGE_LOAD_PCK_SGN_V4_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4142
  { IMAGE_LOAD_PCK_SGN_V4_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4143
  { IMAGE_LOAD_PCK_SGN_V5_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 4144
  { IMAGE_LOAD_PCK_SGN_V5_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4145
  { IMAGE_LOAD_PCK_SGN_V5_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4146
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 4147
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 4148
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 4149
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 4150
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 4151
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 4152
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 4153
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 4154
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 4155
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 4156
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 4157
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 4158
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 4159
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 4160
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 4161
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 4162
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 4163
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 4164
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 4165
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 4166
  { IMAGE_LOAD_PCK_SGN_V1_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 4167
  { IMAGE_LOAD_PCK_SGN_V1_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4168
  { IMAGE_LOAD_PCK_SGN_V1_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4169
  { IMAGE_LOAD_PCK_SGN_V1_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4170
  { IMAGE_LOAD_PCK_SGN_V2_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 4171
  { IMAGE_LOAD_PCK_SGN_V2_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4172
  { IMAGE_LOAD_PCK_SGN_V2_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4173
  { IMAGE_LOAD_PCK_SGN_V2_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4174
  { IMAGE_LOAD_PCK_SGN_V3_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 4175
  { IMAGE_LOAD_PCK_SGN_V3_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4176
  { IMAGE_LOAD_PCK_SGN_V3_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4177
  { IMAGE_LOAD_PCK_SGN_V3_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4178
  { IMAGE_LOAD_PCK_SGN_V4_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 4179
  { IMAGE_LOAD_PCK_SGN_V4_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4180
  { IMAGE_LOAD_PCK_SGN_V4_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4181
  { IMAGE_LOAD_PCK_SGN_V4_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4182
  { IMAGE_LOAD_PCK_SGN_V5_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 4183
  { IMAGE_LOAD_PCK_SGN_V5_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4184
  { IMAGE_LOAD_PCK_SGN_V5_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4185
  { IMAGE_LOAD_PCK_SGN_V5_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4186
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 4187
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 4188
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 4189
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 4190
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 4191
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 4192
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 4193
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 4194
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 4195
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 4196
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 4197
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 4198
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 4199
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 4200
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 4201
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 4202
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 4203
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 4204
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 4205
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 4206
  { IMAGE_MSAA_LOAD_V2_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 4207
  { IMAGE_MSAA_LOAD_V2_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 4208
  { IMAGE_MSAA_LOAD_V2_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4209
  { IMAGE_MSAA_LOAD_V2_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4210
  { IMAGE_MSAA_LOAD_V3_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 4211
  { IMAGE_MSAA_LOAD_V3_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 4212
  { IMAGE_MSAA_LOAD_V3_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4213
  { IMAGE_MSAA_LOAD_V3_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4214
  { IMAGE_MSAA_LOAD_V4_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 4215
  { IMAGE_MSAA_LOAD_V4_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 4216
  { IMAGE_MSAA_LOAD_V4_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4217
  { IMAGE_MSAA_LOAD_V4_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4218
  { IMAGE_MSAA_LOAD_V5_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 4219
  { IMAGE_MSAA_LOAD_V5_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 4220
  { IMAGE_MSAA_LOAD_V5_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4221
  { IMAGE_MSAA_LOAD_V5_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4222
  { IMAGE_MSAA_LOAD_V2_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 4223
  { IMAGE_MSAA_LOAD_V2_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4224
  { IMAGE_MSAA_LOAD_V2_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4225
  { IMAGE_MSAA_LOAD_V3_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 4226
  { IMAGE_MSAA_LOAD_V3_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4227
  { IMAGE_MSAA_LOAD_V3_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4228
  { IMAGE_MSAA_LOAD_V4_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 4229
  { IMAGE_MSAA_LOAD_V4_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4230
  { IMAGE_MSAA_LOAD_V4_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4231
  { IMAGE_MSAA_LOAD_V5_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 4232
  { IMAGE_MSAA_LOAD_V5_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4233
  { IMAGE_MSAA_LOAD_V5_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4234
  { IMAGE_MSAA_LOAD_V2_V1_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 4235
  { IMAGE_MSAA_LOAD_V2_V2_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 4236
  { IMAGE_MSAA_LOAD_V2_V3_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 4237
  { IMAGE_MSAA_LOAD_V2_V4_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 4238
  { IMAGE_MSAA_LOAD_V3_V1_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 4239
  { IMAGE_MSAA_LOAD_V3_V2_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 4240
  { IMAGE_MSAA_LOAD_V3_V3_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 4241
  { IMAGE_MSAA_LOAD_V3_V4_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 4242
  { IMAGE_MSAA_LOAD_V4_V1_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 4243
  { IMAGE_MSAA_LOAD_V4_V2_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 4244
  { IMAGE_MSAA_LOAD_V4_V3_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 4245
  { IMAGE_MSAA_LOAD_V4_V4_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 4246
  { IMAGE_MSAA_LOAD_V5_V1_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 4247
  { IMAGE_MSAA_LOAD_V5_V2_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 4248
  { IMAGE_MSAA_LOAD_V5_V3_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 4249
  { IMAGE_MSAA_LOAD_V5_V4_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 4250
  { IMAGE_MSAA_LOAD_X_V1_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 4251
  { IMAGE_MSAA_LOAD_X_V1_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4252
  { IMAGE_MSAA_LOAD_X_V1_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4253
  { IMAGE_MSAA_LOAD_X_V1_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4254
  { IMAGE_MSAA_LOAD_X_V2_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 4255
  { IMAGE_MSAA_LOAD_X_V2_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4256
  { IMAGE_MSAA_LOAD_X_V2_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4257
  { IMAGE_MSAA_LOAD_X_V2_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4258
  { IMAGE_MSAA_LOAD_X_V3_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 4259
  { IMAGE_MSAA_LOAD_X_V3_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4260
  { IMAGE_MSAA_LOAD_X_V3_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4261
  { IMAGE_MSAA_LOAD_X_V3_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4262
  { IMAGE_MSAA_LOAD_X_V4_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 4263
  { IMAGE_MSAA_LOAD_X_V4_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4264
  { IMAGE_MSAA_LOAD_X_V4_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4265
  { IMAGE_MSAA_LOAD_X_V4_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4266
  { IMAGE_MSAA_LOAD_X_V5_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 4267
  { IMAGE_MSAA_LOAD_X_V5_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4268
  { IMAGE_MSAA_LOAD_X_V5_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4269
  { IMAGE_MSAA_LOAD_X_V5_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4270
  { IMAGE_MSAA_LOAD_X_V1_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4271
  { IMAGE_MSAA_LOAD_X_V1_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4272
  { IMAGE_MSAA_LOAD_X_V1_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4273
  { IMAGE_MSAA_LOAD_X_V2_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4274
  { IMAGE_MSAA_LOAD_X_V2_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4275
  { IMAGE_MSAA_LOAD_X_V2_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4276
  { IMAGE_MSAA_LOAD_X_V3_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4277
  { IMAGE_MSAA_LOAD_X_V3_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4278
  { IMAGE_MSAA_LOAD_X_V3_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4279
  { IMAGE_MSAA_LOAD_X_V4_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4280
  { IMAGE_MSAA_LOAD_X_V4_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4281
  { IMAGE_MSAA_LOAD_X_V4_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4282
  { IMAGE_MSAA_LOAD_X_V5_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4283
  { IMAGE_MSAA_LOAD_X_V5_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4284
  { IMAGE_MSAA_LOAD_X_V5_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4285
  { IMAGE_MSAA_LOAD_X_V1_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 4286
  { IMAGE_MSAA_LOAD_X_V1_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4287
  { IMAGE_MSAA_LOAD_X_V1_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4288
  { IMAGE_MSAA_LOAD_X_V1_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4289
  { IMAGE_MSAA_LOAD_X_V2_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 4290
  { IMAGE_MSAA_LOAD_X_V2_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4291
  { IMAGE_MSAA_LOAD_X_V2_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4292
  { IMAGE_MSAA_LOAD_X_V2_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4293
  { IMAGE_MSAA_LOAD_X_V3_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 4294
  { IMAGE_MSAA_LOAD_X_V3_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4295
  { IMAGE_MSAA_LOAD_X_V3_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4296
  { IMAGE_MSAA_LOAD_X_V3_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4297
  { IMAGE_MSAA_LOAD_X_V4_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 4298
  { IMAGE_MSAA_LOAD_X_V4_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4299
  { IMAGE_MSAA_LOAD_X_V4_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4300
  { IMAGE_MSAA_LOAD_X_V4_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4301
  { IMAGE_MSAA_LOAD_X_V5_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 4302
  { IMAGE_MSAA_LOAD_X_V5_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4303
  { IMAGE_MSAA_LOAD_X_V5_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4304
  { IMAGE_MSAA_LOAD_X_V5_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4305
  { IMAGE_SAMPLE_V1_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 4306
  { IMAGE_SAMPLE_V1_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4307
  { IMAGE_SAMPLE_V1_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4308
  { IMAGE_SAMPLE_V1_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4309
  { IMAGE_SAMPLE_V2_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 4310
  { IMAGE_SAMPLE_V2_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4311
  { IMAGE_SAMPLE_V2_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4312
  { IMAGE_SAMPLE_V2_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4313
  { IMAGE_SAMPLE_V3_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 4314
  { IMAGE_SAMPLE_V3_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4315
  { IMAGE_SAMPLE_V3_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4316
  { IMAGE_SAMPLE_V3_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4317
  { IMAGE_SAMPLE_V4_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 4318
  { IMAGE_SAMPLE_V4_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4319
  { IMAGE_SAMPLE_V4_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4320
  { IMAGE_SAMPLE_V4_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4321
  { IMAGE_SAMPLE_V5_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 4322
  { IMAGE_SAMPLE_V5_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4323
  { IMAGE_SAMPLE_V5_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4324
  { IMAGE_SAMPLE_V5_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4325
  { IMAGE_SAMPLE_V1_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4326
  { IMAGE_SAMPLE_V1_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4327
  { IMAGE_SAMPLE_V2_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4328
  { IMAGE_SAMPLE_V2_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4329
  { IMAGE_SAMPLE_V3_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4330
  { IMAGE_SAMPLE_V3_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4331
  { IMAGE_SAMPLE_V4_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4332
  { IMAGE_SAMPLE_V4_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4333
  { IMAGE_SAMPLE_V5_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4334
  { IMAGE_SAMPLE_V5_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4335
  { IMAGE_SAMPLE_V1_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 4336
  { IMAGE_SAMPLE_V1_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 4337
  { IMAGE_SAMPLE_V1_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4338
  { IMAGE_SAMPLE_V1_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4339
  { IMAGE_SAMPLE_V2_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 4340
  { IMAGE_SAMPLE_V2_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 4341
  { IMAGE_SAMPLE_V2_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4342
  { IMAGE_SAMPLE_V2_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4343
  { IMAGE_SAMPLE_V3_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 4344
  { IMAGE_SAMPLE_V3_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 4345
  { IMAGE_SAMPLE_V3_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4346
  { IMAGE_SAMPLE_V3_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4347
  { IMAGE_SAMPLE_V4_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 4348
  { IMAGE_SAMPLE_V4_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 4349
  { IMAGE_SAMPLE_V4_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4350
  { IMAGE_SAMPLE_V4_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4351
  { IMAGE_SAMPLE_V5_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 4352
  { IMAGE_SAMPLE_V5_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 4353
  { IMAGE_SAMPLE_V5_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4354
  { IMAGE_SAMPLE_V5_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4355
  { IMAGE_SAMPLE_V1_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 4356
  { IMAGE_SAMPLE_V1_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4357
  { IMAGE_SAMPLE_V2_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 4358
  { IMAGE_SAMPLE_V2_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4359
  { IMAGE_SAMPLE_V3_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 4360
  { IMAGE_SAMPLE_V3_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4361
  { IMAGE_SAMPLE_V4_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 4362
  { IMAGE_SAMPLE_V4_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4363
  { IMAGE_SAMPLE_V5_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 4364
  { IMAGE_SAMPLE_V5_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4365
  { IMAGE_SAMPLE_V1_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 4366
  { IMAGE_SAMPLE_V1_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 4367
  { IMAGE_SAMPLE_V1_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 4368
  { IMAGE_SAMPLE_V2_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 4369
  { IMAGE_SAMPLE_V2_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 4370
  { IMAGE_SAMPLE_V2_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 4371
  { IMAGE_SAMPLE_V3_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 4372
  { IMAGE_SAMPLE_V3_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 4373
  { IMAGE_SAMPLE_V3_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 4374
  { IMAGE_SAMPLE_V4_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 4375
  { IMAGE_SAMPLE_V4_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 4376
  { IMAGE_SAMPLE_V4_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 4377
  { IMAGE_SAMPLE_V5_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 4378
  { IMAGE_SAMPLE_V5_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 4379
  { IMAGE_SAMPLE_V5_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 4380
  { IMAGE_SAMPLE_V1_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 4381
  { IMAGE_SAMPLE_V1_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4382
  { IMAGE_SAMPLE_V1_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4383
  { IMAGE_SAMPLE_V1_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4384
  { IMAGE_SAMPLE_V2_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 4385
  { IMAGE_SAMPLE_V2_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4386
  { IMAGE_SAMPLE_V2_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4387
  { IMAGE_SAMPLE_V2_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4388
  { IMAGE_SAMPLE_V3_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 4389
  { IMAGE_SAMPLE_V3_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4390
  { IMAGE_SAMPLE_V3_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4391
  { IMAGE_SAMPLE_V3_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4392
  { IMAGE_SAMPLE_V4_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 4393
  { IMAGE_SAMPLE_V4_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4394
  { IMAGE_SAMPLE_V4_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4395
  { IMAGE_SAMPLE_V4_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4396
  { IMAGE_SAMPLE_V5_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 4397
  { IMAGE_SAMPLE_V5_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4398
  { IMAGE_SAMPLE_V5_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4399
  { IMAGE_SAMPLE_V5_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4400
  { IMAGE_SAMPLE_V1_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 4401
  { IMAGE_SAMPLE_V1_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 4402
  { IMAGE_SAMPLE_V1_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 4403
  { IMAGE_SAMPLE_V1_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 4404
  { IMAGE_SAMPLE_V2_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 4405
  { IMAGE_SAMPLE_V2_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 4406
  { IMAGE_SAMPLE_V2_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 4407
  { IMAGE_SAMPLE_V2_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 4408
  { IMAGE_SAMPLE_V3_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 4409
  { IMAGE_SAMPLE_V3_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 4410
  { IMAGE_SAMPLE_V3_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 4411
  { IMAGE_SAMPLE_V3_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 4412
  { IMAGE_SAMPLE_V4_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 4413
  { IMAGE_SAMPLE_V4_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 4414
  { IMAGE_SAMPLE_V4_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 4415
  { IMAGE_SAMPLE_V4_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 4416
  { IMAGE_SAMPLE_V5_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 4417
  { IMAGE_SAMPLE_V5_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 4418
  { IMAGE_SAMPLE_V5_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 4419
  { IMAGE_SAMPLE_V5_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 4420
  { IMAGE_SAMPLE_B_V1_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4421
  { IMAGE_SAMPLE_B_V1_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4422
  { IMAGE_SAMPLE_B_V1_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4423
  { IMAGE_SAMPLE_B_V2_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4424
  { IMAGE_SAMPLE_B_V2_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4425
  { IMAGE_SAMPLE_B_V2_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4426
  { IMAGE_SAMPLE_B_V3_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4427
  { IMAGE_SAMPLE_B_V3_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4428
  { IMAGE_SAMPLE_B_V3_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4429
  { IMAGE_SAMPLE_B_V4_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4430
  { IMAGE_SAMPLE_B_V4_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4431
  { IMAGE_SAMPLE_B_V4_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4432
  { IMAGE_SAMPLE_B_V5_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4433
  { IMAGE_SAMPLE_B_V5_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4434
  { IMAGE_SAMPLE_B_V5_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4435
  { IMAGE_SAMPLE_B_V1_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4436
  { IMAGE_SAMPLE_B_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4437
  { IMAGE_SAMPLE_B_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4438
  { IMAGE_SAMPLE_B_V2_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4439
  { IMAGE_SAMPLE_B_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4440
  { IMAGE_SAMPLE_B_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4441
  { IMAGE_SAMPLE_B_V3_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4442
  { IMAGE_SAMPLE_B_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4443
  { IMAGE_SAMPLE_B_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4444
  { IMAGE_SAMPLE_B_V4_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4445
  { IMAGE_SAMPLE_B_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4446
  { IMAGE_SAMPLE_B_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4447
  { IMAGE_SAMPLE_B_V5_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4448
  { IMAGE_SAMPLE_B_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4449
  { IMAGE_SAMPLE_B_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4450
  { IMAGE_SAMPLE_B_V1_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 4451
  { IMAGE_SAMPLE_B_V1_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4452
  { IMAGE_SAMPLE_B_V1_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4453
  { IMAGE_SAMPLE_B_V2_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 4454
  { IMAGE_SAMPLE_B_V2_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4455
  { IMAGE_SAMPLE_B_V2_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4456
  { IMAGE_SAMPLE_B_V3_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 4457
  { IMAGE_SAMPLE_B_V3_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4458
  { IMAGE_SAMPLE_B_V3_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4459
  { IMAGE_SAMPLE_B_V4_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 4460
  { IMAGE_SAMPLE_B_V4_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4461
  { IMAGE_SAMPLE_B_V4_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4462
  { IMAGE_SAMPLE_B_V5_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 4463
  { IMAGE_SAMPLE_B_V5_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4464
  { IMAGE_SAMPLE_B_V5_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4465
  { IMAGE_SAMPLE_B_V1_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 4466
  { IMAGE_SAMPLE_B_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4467
  { IMAGE_SAMPLE_B_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4468
  { IMAGE_SAMPLE_B_V2_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 4469
  { IMAGE_SAMPLE_B_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4470
  { IMAGE_SAMPLE_B_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4471
  { IMAGE_SAMPLE_B_V3_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 4472
  { IMAGE_SAMPLE_B_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4473
  { IMAGE_SAMPLE_B_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4474
  { IMAGE_SAMPLE_B_V4_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 4475
  { IMAGE_SAMPLE_B_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4476
  { IMAGE_SAMPLE_B_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4477
  { IMAGE_SAMPLE_B_V5_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 4478
  { IMAGE_SAMPLE_B_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4479
  { IMAGE_SAMPLE_B_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4480
  { IMAGE_SAMPLE_B_V1_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 4481
  { IMAGE_SAMPLE_B_V1_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 4482
  { IMAGE_SAMPLE_B_V1_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 4483
  { IMAGE_SAMPLE_B_V2_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 4484
  { IMAGE_SAMPLE_B_V2_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 4485
  { IMAGE_SAMPLE_B_V2_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 4486
  { IMAGE_SAMPLE_B_V3_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 4487
  { IMAGE_SAMPLE_B_V3_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 4488
  { IMAGE_SAMPLE_B_V3_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 4489
  { IMAGE_SAMPLE_B_V4_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 4490
  { IMAGE_SAMPLE_B_V4_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 4491
  { IMAGE_SAMPLE_B_V4_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 4492
  { IMAGE_SAMPLE_B_V5_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 4493
  { IMAGE_SAMPLE_B_V5_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 4494
  { IMAGE_SAMPLE_B_V5_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 4495
  { IMAGE_SAMPLE_B_V1_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4496
  { IMAGE_SAMPLE_B_V1_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4497
  { IMAGE_SAMPLE_B_V1_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4498
  { IMAGE_SAMPLE_B_V2_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4499
  { IMAGE_SAMPLE_B_V2_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4500
  { IMAGE_SAMPLE_B_V2_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4501
  { IMAGE_SAMPLE_B_V3_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4502
  { IMAGE_SAMPLE_B_V3_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4503
  { IMAGE_SAMPLE_B_V3_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4504
  { IMAGE_SAMPLE_B_V4_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4505
  { IMAGE_SAMPLE_B_V4_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4506
  { IMAGE_SAMPLE_B_V4_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4507
  { IMAGE_SAMPLE_B_V5_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4508
  { IMAGE_SAMPLE_B_V5_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4509
  { IMAGE_SAMPLE_B_V5_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4510
  { IMAGE_SAMPLE_B_CL_V1_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4511
  { IMAGE_SAMPLE_B_CL_V1_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4512
  { IMAGE_SAMPLE_B_CL_V1_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4513
  { IMAGE_SAMPLE_B_CL_V1_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4514
  { IMAGE_SAMPLE_B_CL_V1_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4515
  { IMAGE_SAMPLE_B_CL_V2_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4516
  { IMAGE_SAMPLE_B_CL_V2_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4517
  { IMAGE_SAMPLE_B_CL_V2_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4518
  { IMAGE_SAMPLE_B_CL_V2_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4519
  { IMAGE_SAMPLE_B_CL_V2_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4520
  { IMAGE_SAMPLE_B_CL_V3_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4521
  { IMAGE_SAMPLE_B_CL_V3_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4522
  { IMAGE_SAMPLE_B_CL_V3_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4523
  { IMAGE_SAMPLE_B_CL_V3_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4524
  { IMAGE_SAMPLE_B_CL_V3_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4525
  { IMAGE_SAMPLE_B_CL_V4_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4526
  { IMAGE_SAMPLE_B_CL_V4_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4527
  { IMAGE_SAMPLE_B_CL_V4_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4528
  { IMAGE_SAMPLE_B_CL_V4_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4529
  { IMAGE_SAMPLE_B_CL_V4_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4530
  { IMAGE_SAMPLE_B_CL_V5_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4531
  { IMAGE_SAMPLE_B_CL_V5_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4532
  { IMAGE_SAMPLE_B_CL_V5_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4533
  { IMAGE_SAMPLE_B_CL_V5_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4534
  { IMAGE_SAMPLE_B_CL_V5_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4535
  { IMAGE_SAMPLE_B_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4536
  { IMAGE_SAMPLE_B_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4537
  { IMAGE_SAMPLE_B_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4538
  { IMAGE_SAMPLE_B_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4539
  { IMAGE_SAMPLE_B_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4540
  { IMAGE_SAMPLE_B_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4541
  { IMAGE_SAMPLE_B_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4542
  { IMAGE_SAMPLE_B_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4543
  { IMAGE_SAMPLE_B_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4544
  { IMAGE_SAMPLE_B_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4545
  { IMAGE_SAMPLE_B_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4546
  { IMAGE_SAMPLE_B_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4547
  { IMAGE_SAMPLE_B_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4548
  { IMAGE_SAMPLE_B_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4549
  { IMAGE_SAMPLE_B_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4550
  { IMAGE_SAMPLE_B_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4551
  { IMAGE_SAMPLE_B_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4552
  { IMAGE_SAMPLE_B_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4553
  { IMAGE_SAMPLE_B_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4554
  { IMAGE_SAMPLE_B_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4555
  { IMAGE_SAMPLE_B_CL_V1_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 4556
  { IMAGE_SAMPLE_B_CL_V1_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4557
  { IMAGE_SAMPLE_B_CL_V1_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4558
  { IMAGE_SAMPLE_B_CL_V1_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 4559
  { IMAGE_SAMPLE_B_CL_V1_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 4560
  { IMAGE_SAMPLE_B_CL_V2_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 4561
  { IMAGE_SAMPLE_B_CL_V2_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4562
  { IMAGE_SAMPLE_B_CL_V2_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4563
  { IMAGE_SAMPLE_B_CL_V2_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 4564
  { IMAGE_SAMPLE_B_CL_V2_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 4565
  { IMAGE_SAMPLE_B_CL_V3_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 4566
  { IMAGE_SAMPLE_B_CL_V3_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4567
  { IMAGE_SAMPLE_B_CL_V3_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4568
  { IMAGE_SAMPLE_B_CL_V3_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 4569
  { IMAGE_SAMPLE_B_CL_V3_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 4570
  { IMAGE_SAMPLE_B_CL_V4_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 4571
  { IMAGE_SAMPLE_B_CL_V4_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4572
  { IMAGE_SAMPLE_B_CL_V4_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4573
  { IMAGE_SAMPLE_B_CL_V4_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 4574
  { IMAGE_SAMPLE_B_CL_V4_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 4575
  { IMAGE_SAMPLE_B_CL_V5_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 4576
  { IMAGE_SAMPLE_B_CL_V5_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4577
  { IMAGE_SAMPLE_B_CL_V5_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4578
  { IMAGE_SAMPLE_B_CL_V5_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 4579
  { IMAGE_SAMPLE_B_CL_V5_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 4580
  { IMAGE_SAMPLE_B_CL_V1_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 4581
  { IMAGE_SAMPLE_B_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4582
  { IMAGE_SAMPLE_B_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4583
  { IMAGE_SAMPLE_B_CL_V1_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 4584
  { IMAGE_SAMPLE_B_CL_V2_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 4585
  { IMAGE_SAMPLE_B_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4586
  { IMAGE_SAMPLE_B_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4587
  { IMAGE_SAMPLE_B_CL_V2_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 4588
  { IMAGE_SAMPLE_B_CL_V3_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 4589
  { IMAGE_SAMPLE_B_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4590
  { IMAGE_SAMPLE_B_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4591
  { IMAGE_SAMPLE_B_CL_V3_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 4592
  { IMAGE_SAMPLE_B_CL_V4_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 4593
  { IMAGE_SAMPLE_B_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4594
  { IMAGE_SAMPLE_B_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4595
  { IMAGE_SAMPLE_B_CL_V4_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 4596
  { IMAGE_SAMPLE_B_CL_V5_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 4597
  { IMAGE_SAMPLE_B_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4598
  { IMAGE_SAMPLE_B_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4599
  { IMAGE_SAMPLE_B_CL_V5_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 4600
  { IMAGE_SAMPLE_B_CL_V1_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 4601
  { IMAGE_SAMPLE_B_CL_V1_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 4602
  { IMAGE_SAMPLE_B_CL_V1_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 4603
  { IMAGE_SAMPLE_B_CL_V1_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 4604
  { IMAGE_SAMPLE_B_CL_V2_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 4605
  { IMAGE_SAMPLE_B_CL_V2_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 4606
  { IMAGE_SAMPLE_B_CL_V2_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 4607
  { IMAGE_SAMPLE_B_CL_V2_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 4608
  { IMAGE_SAMPLE_B_CL_V3_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 4609
  { IMAGE_SAMPLE_B_CL_V3_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 4610
  { IMAGE_SAMPLE_B_CL_V3_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 4611
  { IMAGE_SAMPLE_B_CL_V3_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 4612
  { IMAGE_SAMPLE_B_CL_V4_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 4613
  { IMAGE_SAMPLE_B_CL_V4_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 4614
  { IMAGE_SAMPLE_B_CL_V4_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 4615
  { IMAGE_SAMPLE_B_CL_V4_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 4616
  { IMAGE_SAMPLE_B_CL_V5_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 4617
  { IMAGE_SAMPLE_B_CL_V5_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 4618
  { IMAGE_SAMPLE_B_CL_V5_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 4619
  { IMAGE_SAMPLE_B_CL_V5_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 4620
  { IMAGE_SAMPLE_B_CL_V1_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4621
  { IMAGE_SAMPLE_B_CL_V1_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4622
  { IMAGE_SAMPLE_B_CL_V1_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4623
  { IMAGE_SAMPLE_B_CL_V1_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4624
  { IMAGE_SAMPLE_B_CL_V1_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4625
  { IMAGE_SAMPLE_B_CL_V2_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4626
  { IMAGE_SAMPLE_B_CL_V2_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4627
  { IMAGE_SAMPLE_B_CL_V2_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4628
  { IMAGE_SAMPLE_B_CL_V2_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4629
  { IMAGE_SAMPLE_B_CL_V2_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4630
  { IMAGE_SAMPLE_B_CL_V3_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4631
  { IMAGE_SAMPLE_B_CL_V3_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4632
  { IMAGE_SAMPLE_B_CL_V3_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4633
  { IMAGE_SAMPLE_B_CL_V3_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4634
  { IMAGE_SAMPLE_B_CL_V3_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4635
  { IMAGE_SAMPLE_B_CL_V4_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4636
  { IMAGE_SAMPLE_B_CL_V4_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4637
  { IMAGE_SAMPLE_B_CL_V4_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4638
  { IMAGE_SAMPLE_B_CL_V4_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4639
  { IMAGE_SAMPLE_B_CL_V4_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4640
  { IMAGE_SAMPLE_B_CL_V5_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4641
  { IMAGE_SAMPLE_B_CL_V5_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4642
  { IMAGE_SAMPLE_B_CL_V5_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4643
  { IMAGE_SAMPLE_B_CL_V5_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4644
  { IMAGE_SAMPLE_B_CL_V5_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4645
  { IMAGE_SAMPLE_B_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4646
  { IMAGE_SAMPLE_B_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4647
  { IMAGE_SAMPLE_B_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4648
  { IMAGE_SAMPLE_B_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4649
  { IMAGE_SAMPLE_B_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4650
  { IMAGE_SAMPLE_B_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4651
  { IMAGE_SAMPLE_B_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4652
  { IMAGE_SAMPLE_B_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4653
  { IMAGE_SAMPLE_B_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4654
  { IMAGE_SAMPLE_B_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4655
  { IMAGE_SAMPLE_B_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4656
  { IMAGE_SAMPLE_B_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4657
  { IMAGE_SAMPLE_B_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4658
  { IMAGE_SAMPLE_B_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4659
  { IMAGE_SAMPLE_B_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4660
  { IMAGE_SAMPLE_B_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4661
  { IMAGE_SAMPLE_B_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4662
  { IMAGE_SAMPLE_B_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4663
  { IMAGE_SAMPLE_B_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4664
  { IMAGE_SAMPLE_B_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4665
  { IMAGE_SAMPLE_B_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4666
  { IMAGE_SAMPLE_B_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4667
  { IMAGE_SAMPLE_B_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4668
  { IMAGE_SAMPLE_B_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4669
  { IMAGE_SAMPLE_B_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4670
  { IMAGE_SAMPLE_B_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4671
  { IMAGE_SAMPLE_B_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4672
  { IMAGE_SAMPLE_B_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4673
  { IMAGE_SAMPLE_B_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4674
  { IMAGE_SAMPLE_B_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4675
  { IMAGE_SAMPLE_B_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4676
  { IMAGE_SAMPLE_B_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4677
  { IMAGE_SAMPLE_B_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4678
  { IMAGE_SAMPLE_B_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4679
  { IMAGE_SAMPLE_B_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4680
  { IMAGE_SAMPLE_B_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4681
  { IMAGE_SAMPLE_B_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4682
  { IMAGE_SAMPLE_B_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4683
  { IMAGE_SAMPLE_B_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4684
  { IMAGE_SAMPLE_B_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4685
  { IMAGE_SAMPLE_B_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4686
  { IMAGE_SAMPLE_B_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4687
  { IMAGE_SAMPLE_B_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4688
  { IMAGE_SAMPLE_B_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4689
  { IMAGE_SAMPLE_B_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4690
  { IMAGE_SAMPLE_B_CL_O_V1_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4691
  { IMAGE_SAMPLE_B_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4692
  { IMAGE_SAMPLE_B_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 4693
  { IMAGE_SAMPLE_B_CL_O_V1_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 4694
  { IMAGE_SAMPLE_B_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 4695
  { IMAGE_SAMPLE_B_CL_O_V2_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4696
  { IMAGE_SAMPLE_B_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4697
  { IMAGE_SAMPLE_B_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 4698
  { IMAGE_SAMPLE_B_CL_O_V2_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 4699
  { IMAGE_SAMPLE_B_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 4700
  { IMAGE_SAMPLE_B_CL_O_V3_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4701
  { IMAGE_SAMPLE_B_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4702
  { IMAGE_SAMPLE_B_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 4703
  { IMAGE_SAMPLE_B_CL_O_V3_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 4704
  { IMAGE_SAMPLE_B_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 4705
  { IMAGE_SAMPLE_B_CL_O_V4_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4706
  { IMAGE_SAMPLE_B_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4707
  { IMAGE_SAMPLE_B_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 4708
  { IMAGE_SAMPLE_B_CL_O_V4_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 4709
  { IMAGE_SAMPLE_B_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 4710
  { IMAGE_SAMPLE_B_CL_O_V5_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4711
  { IMAGE_SAMPLE_B_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4712
  { IMAGE_SAMPLE_B_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 4713
  { IMAGE_SAMPLE_B_CL_O_V5_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 4714
  { IMAGE_SAMPLE_B_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 4715
  { IMAGE_SAMPLE_B_CL_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4716
  { IMAGE_SAMPLE_B_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4717
  { IMAGE_SAMPLE_B_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 4718
  { IMAGE_SAMPLE_B_CL_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 4719
  { IMAGE_SAMPLE_B_CL_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4720
  { IMAGE_SAMPLE_B_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4721
  { IMAGE_SAMPLE_B_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 4722
  { IMAGE_SAMPLE_B_CL_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 4723
  { IMAGE_SAMPLE_B_CL_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4724
  { IMAGE_SAMPLE_B_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4725
  { IMAGE_SAMPLE_B_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 4726
  { IMAGE_SAMPLE_B_CL_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 4727
  { IMAGE_SAMPLE_B_CL_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4728
  { IMAGE_SAMPLE_B_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4729
  { IMAGE_SAMPLE_B_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 4730
  { IMAGE_SAMPLE_B_CL_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 4731
  { IMAGE_SAMPLE_B_CL_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4732
  { IMAGE_SAMPLE_B_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4733
  { IMAGE_SAMPLE_B_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 4734
  { IMAGE_SAMPLE_B_CL_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 4735
  { IMAGE_SAMPLE_B_CL_O_V1_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 4736
  { IMAGE_SAMPLE_B_CL_O_V1_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 4737
  { IMAGE_SAMPLE_B_CL_O_V1_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 4738
  { IMAGE_SAMPLE_B_CL_O_V1_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x1, 0x6, 0x6 }, // 4739
  { IMAGE_SAMPLE_B_CL_O_V2_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 4740
  { IMAGE_SAMPLE_B_CL_O_V2_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 4741
  { IMAGE_SAMPLE_B_CL_O_V2_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 4742
  { IMAGE_SAMPLE_B_CL_O_V2_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 4743
  { IMAGE_SAMPLE_B_CL_O_V3_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 4744
  { IMAGE_SAMPLE_B_CL_O_V3_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 4745
  { IMAGE_SAMPLE_B_CL_O_V3_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 4746
  { IMAGE_SAMPLE_B_CL_O_V3_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x3, 0x6, 0x6 }, // 4747
  { IMAGE_SAMPLE_B_CL_O_V4_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 4748
  { IMAGE_SAMPLE_B_CL_O_V4_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 4749
  { IMAGE_SAMPLE_B_CL_O_V4_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 4750
  { IMAGE_SAMPLE_B_CL_O_V4_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 4751
  { IMAGE_SAMPLE_B_CL_O_V5_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 4752
  { IMAGE_SAMPLE_B_CL_O_V5_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 4753
  { IMAGE_SAMPLE_B_CL_O_V5_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 4754
  { IMAGE_SAMPLE_B_CL_O_V5_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 4755
  { IMAGE_SAMPLE_B_CL_O_V1_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4756
  { IMAGE_SAMPLE_B_CL_O_V1_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4757
  { IMAGE_SAMPLE_B_CL_O_V1_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4758
  { IMAGE_SAMPLE_B_CL_O_V1_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4759
  { IMAGE_SAMPLE_B_CL_O_V1_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4760
  { IMAGE_SAMPLE_B_CL_O_V2_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4761
  { IMAGE_SAMPLE_B_CL_O_V2_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4762
  { IMAGE_SAMPLE_B_CL_O_V2_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4763
  { IMAGE_SAMPLE_B_CL_O_V2_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4764
  { IMAGE_SAMPLE_B_CL_O_V2_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4765
  { IMAGE_SAMPLE_B_CL_O_V3_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4766
  { IMAGE_SAMPLE_B_CL_O_V3_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4767
  { IMAGE_SAMPLE_B_CL_O_V3_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4768
  { IMAGE_SAMPLE_B_CL_O_V3_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4769
  { IMAGE_SAMPLE_B_CL_O_V3_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4770
  { IMAGE_SAMPLE_B_CL_O_V4_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4771
  { IMAGE_SAMPLE_B_CL_O_V4_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4772
  { IMAGE_SAMPLE_B_CL_O_V4_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4773
  { IMAGE_SAMPLE_B_CL_O_V4_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4774
  { IMAGE_SAMPLE_B_CL_O_V4_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4775
  { IMAGE_SAMPLE_B_CL_O_V5_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4776
  { IMAGE_SAMPLE_B_CL_O_V5_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4777
  { IMAGE_SAMPLE_B_CL_O_V5_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4778
  { IMAGE_SAMPLE_B_CL_O_V5_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4779
  { IMAGE_SAMPLE_B_CL_O_V5_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4780
  { IMAGE_SAMPLE_B_CL_O_nortn_V3_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 4781
  { IMAGE_SAMPLE_B_CL_O_nortn_V4_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 4782
  { IMAGE_SAMPLE_B_CL_O_nortn_V5_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 4783
  { IMAGE_SAMPLE_B_CL_O_nortn_V6_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 4784
  { IMAGE_SAMPLE_B_CL_O_nortn_V8_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 4785
  { IMAGE_SAMPLE_B_CL_O_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 4786
  { IMAGE_SAMPLE_B_CL_O_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 4787
  { IMAGE_SAMPLE_B_CL_O_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 4788
  { IMAGE_SAMPLE_B_CL_O_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 4789
  { IMAGE_SAMPLE_B_CL_O_nortn_V3_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x3, 0x1 }, // 4790
  { IMAGE_SAMPLE_B_CL_O_nortn_V4_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x4, 0x1 }, // 4791
  { IMAGE_SAMPLE_B_CL_O_nortn_V5_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x5, 0x1 }, // 4792
  { IMAGE_SAMPLE_B_CL_O_nortn_V6_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x6, 0x1 }, // 4793
  { IMAGE_SAMPLE_B_CL_O_nortn_V8_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x8, 0x1 }, // 4794
  { IMAGE_SAMPLE_B_CL_O_nortn_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11NSA, 0x0, 0x3, 0x3 }, // 4795
  { IMAGE_SAMPLE_B_CL_O_nortn_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11NSA, 0x0, 0x4, 0x4 }, // 4796
  { IMAGE_SAMPLE_B_CL_O_nortn_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11NSA, 0x0, 0x5, 0x5 }, // 4797
  { IMAGE_SAMPLE_B_CL_O_nortn_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11NSA, 0x0, 0x6, 0x6 }, // 4798
  { IMAGE_SAMPLE_B_CL_O_nortn_V3_gfx12, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx12, 0x0, 0x3, 0x3 }, // 4799
  { IMAGE_SAMPLE_B_CL_O_nortn_V4_gfx12, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx12, 0x0, 0x4, 0x4 }, // 4800
  { IMAGE_SAMPLE_B_CL_O_nortn_V5_gfx12, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx12, 0x0, 0x5, 0x5 }, // 4801
  { IMAGE_SAMPLE_B_CL_O_nortn_V6_gfx12, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx12, 0x0, 0x6, 0x6 }, // 4802
  { IMAGE_SAMPLE_B_CL_nortn_V2_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 4803
  { IMAGE_SAMPLE_B_CL_nortn_V3_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 4804
  { IMAGE_SAMPLE_B_CL_nortn_V4_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 4805
  { IMAGE_SAMPLE_B_CL_nortn_V5_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 4806
  { IMAGE_SAMPLE_B_CL_nortn_V8_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 4807
  { IMAGE_SAMPLE_B_CL_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 4808
  { IMAGE_SAMPLE_B_CL_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 4809
  { IMAGE_SAMPLE_B_CL_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 4810
  { IMAGE_SAMPLE_B_CL_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 4811
  { IMAGE_SAMPLE_B_CL_nortn_V2_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11Default, 0x0, 0x2, 0x1 }, // 4812
  { IMAGE_SAMPLE_B_CL_nortn_V3_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11Default, 0x0, 0x3, 0x1 }, // 4813
  { IMAGE_SAMPLE_B_CL_nortn_V4_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11Default, 0x0, 0x4, 0x1 }, // 4814
  { IMAGE_SAMPLE_B_CL_nortn_V5_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11Default, 0x0, 0x5, 0x1 }, // 4815
  { IMAGE_SAMPLE_B_CL_nortn_V8_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11Default, 0x0, 0x8, 0x1 }, // 4816
  { IMAGE_SAMPLE_B_CL_nortn_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11NSA, 0x0, 0x2, 0x2 }, // 4817
  { IMAGE_SAMPLE_B_CL_nortn_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11NSA, 0x0, 0x3, 0x3 }, // 4818
  { IMAGE_SAMPLE_B_CL_nortn_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11NSA, 0x0, 0x4, 0x4 }, // 4819
  { IMAGE_SAMPLE_B_CL_nortn_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11NSA, 0x0, 0x5, 0x5 }, // 4820
  { IMAGE_SAMPLE_B_CL_nortn_V2_gfx12, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx12, 0x0, 0x2, 0x2 }, // 4821
  { IMAGE_SAMPLE_B_CL_nortn_V3_gfx12, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx12, 0x0, 0x3, 0x3 }, // 4822
  { IMAGE_SAMPLE_B_CL_nortn_V4_gfx12, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx12, 0x0, 0x4, 0x4 }, // 4823
  { IMAGE_SAMPLE_B_CL_nortn_V5_gfx12, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx12, 0x0, 0x5, 0x5 }, // 4824
  { IMAGE_SAMPLE_B_O_V1_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4825
  { IMAGE_SAMPLE_B_O_V1_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4826
  { IMAGE_SAMPLE_B_O_V1_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4827
  { IMAGE_SAMPLE_B_O_V1_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4828
  { IMAGE_SAMPLE_B_O_V2_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4829
  { IMAGE_SAMPLE_B_O_V2_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4830
  { IMAGE_SAMPLE_B_O_V2_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4831
  { IMAGE_SAMPLE_B_O_V2_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4832
  { IMAGE_SAMPLE_B_O_V3_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4833
  { IMAGE_SAMPLE_B_O_V3_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4834
  { IMAGE_SAMPLE_B_O_V3_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4835
  { IMAGE_SAMPLE_B_O_V3_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4836
  { IMAGE_SAMPLE_B_O_V4_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4837
  { IMAGE_SAMPLE_B_O_V4_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4838
  { IMAGE_SAMPLE_B_O_V4_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4839
  { IMAGE_SAMPLE_B_O_V4_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4840
  { IMAGE_SAMPLE_B_O_V5_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4841
  { IMAGE_SAMPLE_B_O_V5_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4842
  { IMAGE_SAMPLE_B_O_V5_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4843
  { IMAGE_SAMPLE_B_O_V5_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4844
  { IMAGE_SAMPLE_B_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4845
  { IMAGE_SAMPLE_B_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4846
  { IMAGE_SAMPLE_B_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4847
  { IMAGE_SAMPLE_B_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4848
  { IMAGE_SAMPLE_B_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4849
  { IMAGE_SAMPLE_B_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4850
  { IMAGE_SAMPLE_B_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4851
  { IMAGE_SAMPLE_B_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4852
  { IMAGE_SAMPLE_B_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4853
  { IMAGE_SAMPLE_B_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4854
  { IMAGE_SAMPLE_B_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4855
  { IMAGE_SAMPLE_B_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4856
  { IMAGE_SAMPLE_B_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4857
  { IMAGE_SAMPLE_B_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4858
  { IMAGE_SAMPLE_B_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4859
  { IMAGE_SAMPLE_B_O_V1_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4860
  { IMAGE_SAMPLE_B_O_V1_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4861
  { IMAGE_SAMPLE_B_O_V1_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 4862
  { IMAGE_SAMPLE_B_O_V1_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 4863
  { IMAGE_SAMPLE_B_O_V2_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4864
  { IMAGE_SAMPLE_B_O_V2_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4865
  { IMAGE_SAMPLE_B_O_V2_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 4866
  { IMAGE_SAMPLE_B_O_V2_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 4867
  { IMAGE_SAMPLE_B_O_V3_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4868
  { IMAGE_SAMPLE_B_O_V3_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4869
  { IMAGE_SAMPLE_B_O_V3_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 4870
  { IMAGE_SAMPLE_B_O_V3_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 4871
  { IMAGE_SAMPLE_B_O_V4_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4872
  { IMAGE_SAMPLE_B_O_V4_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4873
  { IMAGE_SAMPLE_B_O_V4_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 4874
  { IMAGE_SAMPLE_B_O_V4_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 4875
  { IMAGE_SAMPLE_B_O_V5_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4876
  { IMAGE_SAMPLE_B_O_V5_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4877
  { IMAGE_SAMPLE_B_O_V5_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 4878
  { IMAGE_SAMPLE_B_O_V5_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 4879
  { IMAGE_SAMPLE_B_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4880
  { IMAGE_SAMPLE_B_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4881
  { IMAGE_SAMPLE_B_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 4882
  { IMAGE_SAMPLE_B_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4883
  { IMAGE_SAMPLE_B_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4884
  { IMAGE_SAMPLE_B_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 4885
  { IMAGE_SAMPLE_B_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4886
  { IMAGE_SAMPLE_B_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4887
  { IMAGE_SAMPLE_B_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 4888
  { IMAGE_SAMPLE_B_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4889
  { IMAGE_SAMPLE_B_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4890
  { IMAGE_SAMPLE_B_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 4891
  { IMAGE_SAMPLE_B_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4892
  { IMAGE_SAMPLE_B_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4893
  { IMAGE_SAMPLE_B_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 4894
  { IMAGE_SAMPLE_B_O_V1_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 4895
  { IMAGE_SAMPLE_B_O_V1_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 4896
  { IMAGE_SAMPLE_B_O_V1_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 4897
  { IMAGE_SAMPLE_B_O_V2_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 4898
  { IMAGE_SAMPLE_B_O_V2_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 4899
  { IMAGE_SAMPLE_B_O_V2_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 4900
  { IMAGE_SAMPLE_B_O_V3_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 4901
  { IMAGE_SAMPLE_B_O_V3_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 4902
  { IMAGE_SAMPLE_B_O_V3_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 4903
  { IMAGE_SAMPLE_B_O_V4_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 4904
  { IMAGE_SAMPLE_B_O_V4_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 4905
  { IMAGE_SAMPLE_B_O_V4_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 4906
  { IMAGE_SAMPLE_B_O_V5_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 4907
  { IMAGE_SAMPLE_B_O_V5_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 4908
  { IMAGE_SAMPLE_B_O_V5_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 4909
  { IMAGE_SAMPLE_B_O_V1_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4910
  { IMAGE_SAMPLE_B_O_V1_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4911
  { IMAGE_SAMPLE_B_O_V1_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4912
  { IMAGE_SAMPLE_B_O_V1_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4913
  { IMAGE_SAMPLE_B_O_V2_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4914
  { IMAGE_SAMPLE_B_O_V2_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4915
  { IMAGE_SAMPLE_B_O_V2_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4916
  { IMAGE_SAMPLE_B_O_V2_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4917
  { IMAGE_SAMPLE_B_O_V3_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4918
  { IMAGE_SAMPLE_B_O_V3_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4919
  { IMAGE_SAMPLE_B_O_V3_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4920
  { IMAGE_SAMPLE_B_O_V3_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4921
  { IMAGE_SAMPLE_B_O_V4_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4922
  { IMAGE_SAMPLE_B_O_V4_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4923
  { IMAGE_SAMPLE_B_O_V4_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4924
  { IMAGE_SAMPLE_B_O_V4_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4925
  { IMAGE_SAMPLE_B_O_V5_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4926
  { IMAGE_SAMPLE_B_O_V5_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4927
  { IMAGE_SAMPLE_B_O_V5_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4928
  { IMAGE_SAMPLE_B_O_V5_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4929
  { IMAGE_SAMPLE_B_O_nortn_V3_gfx10, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 4930
  { IMAGE_SAMPLE_B_O_nortn_V4_gfx10, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 4931
  { IMAGE_SAMPLE_B_O_nortn_V5_gfx10, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 4932
  { IMAGE_SAMPLE_B_O_nortn_V8_gfx10, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 4933
  { IMAGE_SAMPLE_B_O_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 4934
  { IMAGE_SAMPLE_B_O_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 4935
  { IMAGE_SAMPLE_B_O_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 4936
  { IMAGE_SAMPLE_B_O_nortn_V3_gfx11, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx11Default, 0x0, 0x3, 0x1 }, // 4937
  { IMAGE_SAMPLE_B_O_nortn_V4_gfx11, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx11Default, 0x0, 0x4, 0x1 }, // 4938
  { IMAGE_SAMPLE_B_O_nortn_V5_gfx11, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx11Default, 0x0, 0x5, 0x1 }, // 4939
  { IMAGE_SAMPLE_B_O_nortn_V8_gfx11, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx11Default, 0x0, 0x8, 0x1 }, // 4940
  { IMAGE_SAMPLE_B_O_nortn_V3_nsa_gfx11, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx11NSA, 0x0, 0x3, 0x3 }, // 4941
  { IMAGE_SAMPLE_B_O_nortn_V4_nsa_gfx11, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx11NSA, 0x0, 0x4, 0x4 }, // 4942
  { IMAGE_SAMPLE_B_O_nortn_V5_nsa_gfx11, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx11NSA, 0x0, 0x5, 0x5 }, // 4943
  { IMAGE_SAMPLE_B_O_nortn_V3_gfx12, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx12, 0x0, 0x3, 0x3 }, // 4944
  { IMAGE_SAMPLE_B_O_nortn_V4_gfx12, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx12, 0x0, 0x4, 0x4 }, // 4945
  { IMAGE_SAMPLE_B_O_nortn_V5_gfx12, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx12, 0x0, 0x5, 0x5 }, // 4946
  { IMAGE_SAMPLE_B_nortn_V2_gfx10, IMAGE_SAMPLE_B_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 4947
  { IMAGE_SAMPLE_B_nortn_V3_gfx10, IMAGE_SAMPLE_B_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 4948
  { IMAGE_SAMPLE_B_nortn_V4_gfx10, IMAGE_SAMPLE_B_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 4949
  { IMAGE_SAMPLE_B_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_B_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 4950
  { IMAGE_SAMPLE_B_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_B_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 4951
  { IMAGE_SAMPLE_B_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_B_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 4952
  { IMAGE_SAMPLE_B_nortn_V2_gfx11, IMAGE_SAMPLE_B_nortn, MIMGEncGfx11Default, 0x0, 0x2, 0x1 }, // 4953
  { IMAGE_SAMPLE_B_nortn_V3_gfx11, IMAGE_SAMPLE_B_nortn, MIMGEncGfx11Default, 0x0, 0x3, 0x1 }, // 4954
  { IMAGE_SAMPLE_B_nortn_V4_gfx11, IMAGE_SAMPLE_B_nortn, MIMGEncGfx11Default, 0x0, 0x4, 0x1 }, // 4955
  { IMAGE_SAMPLE_B_nortn_V2_nsa_gfx11, IMAGE_SAMPLE_B_nortn, MIMGEncGfx11NSA, 0x0, 0x2, 0x2 }, // 4956
  { IMAGE_SAMPLE_B_nortn_V3_nsa_gfx11, IMAGE_SAMPLE_B_nortn, MIMGEncGfx11NSA, 0x0, 0x3, 0x3 }, // 4957
  { IMAGE_SAMPLE_B_nortn_V4_nsa_gfx11, IMAGE_SAMPLE_B_nortn, MIMGEncGfx11NSA, 0x0, 0x4, 0x4 }, // 4958
  { IMAGE_SAMPLE_B_nortn_V2_gfx12, IMAGE_SAMPLE_B_nortn, MIMGEncGfx12, 0x0, 0x2, 0x2 }, // 4959
  { IMAGE_SAMPLE_B_nortn_V3_gfx12, IMAGE_SAMPLE_B_nortn, MIMGEncGfx12, 0x0, 0x3, 0x3 }, // 4960
  { IMAGE_SAMPLE_B_nortn_V4_gfx12, IMAGE_SAMPLE_B_nortn, MIMGEncGfx12, 0x0, 0x4, 0x4 }, // 4961
  { IMAGE_SAMPLE_C_V1_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4962
  { IMAGE_SAMPLE_C_V1_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4963
  { IMAGE_SAMPLE_C_V1_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4964
  { IMAGE_SAMPLE_C_V2_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4965
  { IMAGE_SAMPLE_C_V2_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4966
  { IMAGE_SAMPLE_C_V2_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4967
  { IMAGE_SAMPLE_C_V3_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4968
  { IMAGE_SAMPLE_C_V3_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4969
  { IMAGE_SAMPLE_C_V3_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4970
  { IMAGE_SAMPLE_C_V4_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4971
  { IMAGE_SAMPLE_C_V4_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4972
  { IMAGE_SAMPLE_C_V4_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4973
  { IMAGE_SAMPLE_C_V5_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4974
  { IMAGE_SAMPLE_C_V5_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4975
  { IMAGE_SAMPLE_C_V5_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4976
  { IMAGE_SAMPLE_C_V1_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4977
  { IMAGE_SAMPLE_C_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4978
  { IMAGE_SAMPLE_C_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4979
  { IMAGE_SAMPLE_C_V2_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4980
  { IMAGE_SAMPLE_C_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4981
  { IMAGE_SAMPLE_C_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4982
  { IMAGE_SAMPLE_C_V3_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4983
  { IMAGE_SAMPLE_C_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4984
  { IMAGE_SAMPLE_C_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4985
  { IMAGE_SAMPLE_C_V4_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4986
  { IMAGE_SAMPLE_C_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4987
  { IMAGE_SAMPLE_C_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4988
  { IMAGE_SAMPLE_C_V5_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4989
  { IMAGE_SAMPLE_C_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4990
  { IMAGE_SAMPLE_C_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4991
  { IMAGE_SAMPLE_C_V1_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 4992
  { IMAGE_SAMPLE_C_V1_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4993
  { IMAGE_SAMPLE_C_V1_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4994
  { IMAGE_SAMPLE_C_V2_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 4995
  { IMAGE_SAMPLE_C_V2_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4996
  { IMAGE_SAMPLE_C_V2_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4997
  { IMAGE_SAMPLE_C_V3_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 4998
  { IMAGE_SAMPLE_C_V3_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4999
  { IMAGE_SAMPLE_C_V3_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 5000
  { IMAGE_SAMPLE_C_V4_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 5001
  { IMAGE_SAMPLE_C_V4_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 5002
  { IMAGE_SAMPLE_C_V4_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 5003
  { IMAGE_SAMPLE_C_V5_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 5004
  { IMAGE_SAMPLE_C_V5_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 5005
  { IMAGE_SAMPLE_C_V5_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 5006
  { IMAGE_SAMPLE_C_V1_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 5007
  { IMAGE_SAMPLE_C_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 5008
  { IMAGE_SAMPLE_C_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 5009
  { IMAGE_SAMPLE_C_V2_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 5010
  { IMAGE_SAMPLE_C_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 5011
  { IMAGE_SAMPLE_C_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 5012
  { IMAGE_SAMPLE_C_V3_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 5013
  { IMAGE_SAMPLE_C_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 5014
  { IMAGE_SAMPLE_C_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 5015
  { IMAGE_SAMPLE_C_V4_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 5016
  { IMAGE_SAMPLE_C_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 5017
  { IMAGE_SAMPLE_C_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 5018
  { IMAGE_SAMPLE_C_V5_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 5019
  { IMAGE_SAMPLE_C_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 5020
  { IMAGE_SAMPLE_C_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 5021
  { IMAGE_SAMPLE_C_V1_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 5022
  { IMAGE_SAMPLE_C_V1_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 5023
  { IMAGE_SAMPLE_C_V1_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 5024
  { IMAGE_SAMPLE_C_V2_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 5025
  { IMAGE_SAMPLE_C_V2_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 5026
  { IMAGE_SAMPLE_C_V2_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 5027
  { IMAGE_SAMPLE_C_V3_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 5028
  { IMAGE_SAMPLE_C_V3_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 5029
  { IMAGE_SAMPLE_C_V3_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 5030
  { IMAGE_SAMPLE_C_V4_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 5031
  { IMAGE_SAMPLE_C_V4_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 5032
  { IMAGE_SAMPLE_C_V4_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 5033
  { IMAGE_SAMPLE_C_V5_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 5034
  { IMAGE_SAMPLE_C_V5_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 5035
  { IMAGE_SAMPLE_C_V5_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 5036
  { IMAGE_SAMPLE_C_V1_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 5037
  { IMAGE_SAMPLE_C_V1_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5038
  { IMAGE_SAMPLE_C_V1_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5039
  { IMAGE_SAMPLE_C_V2_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 5040
  { IMAGE_SAMPLE_C_V2_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5041
  { IMAGE_SAMPLE_C_V2_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5042
  { IMAGE_SAMPLE_C_V3_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 5043
  { IMAGE_SAMPLE_C_V3_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5044
  { IMAGE_SAMPLE_C_V3_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5045
  { IMAGE_SAMPLE_C_V4_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 5046
  { IMAGE_SAMPLE_C_V4_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5047
  { IMAGE_SAMPLE_C_V4_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5048
  { IMAGE_SAMPLE_C_V5_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 5049
  { IMAGE_SAMPLE_C_V5_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5050
  { IMAGE_SAMPLE_C_V5_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5051
  { IMAGE_SAMPLE_CD_V1_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 5052
  { IMAGE_SAMPLE_CD_V1_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5053
  { IMAGE_SAMPLE_CD_V1_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5054
  { IMAGE_SAMPLE_CD_V1_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5055
  { IMAGE_SAMPLE_CD_V1_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5056
  { IMAGE_SAMPLE_CD_V1_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5057
  { IMAGE_SAMPLE_CD_V1_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5058
  { IMAGE_SAMPLE_CD_V1_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5059
  { IMAGE_SAMPLE_CD_V2_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 5060
  { IMAGE_SAMPLE_CD_V2_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5061
  { IMAGE_SAMPLE_CD_V2_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5062
  { IMAGE_SAMPLE_CD_V2_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5063
  { IMAGE_SAMPLE_CD_V2_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5064
  { IMAGE_SAMPLE_CD_V2_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5065
  { IMAGE_SAMPLE_CD_V2_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5066
  { IMAGE_SAMPLE_CD_V2_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5067
  { IMAGE_SAMPLE_CD_V3_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 5068
  { IMAGE_SAMPLE_CD_V3_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5069
  { IMAGE_SAMPLE_CD_V3_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5070
  { IMAGE_SAMPLE_CD_V3_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5071
  { IMAGE_SAMPLE_CD_V3_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5072
  { IMAGE_SAMPLE_CD_V3_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5073
  { IMAGE_SAMPLE_CD_V3_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5074
  { IMAGE_SAMPLE_CD_V3_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5075
  { IMAGE_SAMPLE_CD_V4_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 5076
  { IMAGE_SAMPLE_CD_V4_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5077
  { IMAGE_SAMPLE_CD_V4_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5078
  { IMAGE_SAMPLE_CD_V4_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5079
  { IMAGE_SAMPLE_CD_V4_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5080
  { IMAGE_SAMPLE_CD_V4_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5081
  { IMAGE_SAMPLE_CD_V4_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5082
  { IMAGE_SAMPLE_CD_V4_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5083
  { IMAGE_SAMPLE_CD_V5_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 5084
  { IMAGE_SAMPLE_CD_V5_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5085
  { IMAGE_SAMPLE_CD_V5_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5086
  { IMAGE_SAMPLE_CD_V5_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5087
  { IMAGE_SAMPLE_CD_V5_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5088
  { IMAGE_SAMPLE_CD_V5_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5089
  { IMAGE_SAMPLE_CD_V5_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5090
  { IMAGE_SAMPLE_CD_V5_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5091
  { IMAGE_SAMPLE_CD_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 5092
  { IMAGE_SAMPLE_CD_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5093
  { IMAGE_SAMPLE_CD_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5094
  { IMAGE_SAMPLE_CD_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5095
  { IMAGE_SAMPLE_CD_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5096
  { IMAGE_SAMPLE_CD_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5097
  { IMAGE_SAMPLE_CD_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5098
  { IMAGE_SAMPLE_CD_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5099
  { IMAGE_SAMPLE_CD_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 5100
  { IMAGE_SAMPLE_CD_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5101
  { IMAGE_SAMPLE_CD_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5102
  { IMAGE_SAMPLE_CD_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5103
  { IMAGE_SAMPLE_CD_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5104
  { IMAGE_SAMPLE_CD_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5105
  { IMAGE_SAMPLE_CD_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5106
  { IMAGE_SAMPLE_CD_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5107
  { IMAGE_SAMPLE_CD_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 5108
  { IMAGE_SAMPLE_CD_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5109
  { IMAGE_SAMPLE_CD_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5110
  { IMAGE_SAMPLE_CD_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5111
  { IMAGE_SAMPLE_CD_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5112
  { IMAGE_SAMPLE_CD_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5113
  { IMAGE_SAMPLE_CD_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5114
  { IMAGE_SAMPLE_CD_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5115
  { IMAGE_SAMPLE_CD_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 5116
  { IMAGE_SAMPLE_CD_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5117
  { IMAGE_SAMPLE_CD_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5118
  { IMAGE_SAMPLE_CD_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5119
  { IMAGE_SAMPLE_CD_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5120
  { IMAGE_SAMPLE_CD_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5121
  { IMAGE_SAMPLE_CD_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5122
  { IMAGE_SAMPLE_CD_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5123
  { IMAGE_SAMPLE_CD_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 5124
  { IMAGE_SAMPLE_CD_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5125
  { IMAGE_SAMPLE_CD_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5126
  { IMAGE_SAMPLE_CD_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5127
  { IMAGE_SAMPLE_CD_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5128
  { IMAGE_SAMPLE_CD_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5129
  { IMAGE_SAMPLE_CD_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5130
  { IMAGE_SAMPLE_CD_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5131
  { IMAGE_SAMPLE_CD_V1_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 5132
  { IMAGE_SAMPLE_CD_V1_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5133
  { IMAGE_SAMPLE_CD_V1_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5134
  { IMAGE_SAMPLE_CD_V1_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5135
  { IMAGE_SAMPLE_CD_V1_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5136
  { IMAGE_SAMPLE_CD_V1_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5137
  { IMAGE_SAMPLE_CD_V1_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5138
  { IMAGE_SAMPLE_CD_V1_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5139
  { IMAGE_SAMPLE_CD_V2_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 5140
  { IMAGE_SAMPLE_CD_V2_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5141
  { IMAGE_SAMPLE_CD_V2_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5142
  { IMAGE_SAMPLE_CD_V2_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5143
  { IMAGE_SAMPLE_CD_V2_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5144
  { IMAGE_SAMPLE_CD_V2_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5145
  { IMAGE_SAMPLE_CD_V2_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5146
  { IMAGE_SAMPLE_CD_V2_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5147
  { IMAGE_SAMPLE_CD_V3_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 5148
  { IMAGE_SAMPLE_CD_V3_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5149
  { IMAGE_SAMPLE_CD_V3_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5150
  { IMAGE_SAMPLE_CD_V3_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5151
  { IMAGE_SAMPLE_CD_V3_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5152
  { IMAGE_SAMPLE_CD_V3_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5153
  { IMAGE_SAMPLE_CD_V3_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5154
  { IMAGE_SAMPLE_CD_V3_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5155
  { IMAGE_SAMPLE_CD_V4_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 5156
  { IMAGE_SAMPLE_CD_V4_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5157
  { IMAGE_SAMPLE_CD_V4_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5158
  { IMAGE_SAMPLE_CD_V4_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5159
  { IMAGE_SAMPLE_CD_V4_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5160
  { IMAGE_SAMPLE_CD_V4_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5161
  { IMAGE_SAMPLE_CD_V4_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5162
  { IMAGE_SAMPLE_CD_V4_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5163
  { IMAGE_SAMPLE_CD_V5_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 5164
  { IMAGE_SAMPLE_CD_V5_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5165
  { IMAGE_SAMPLE_CD_V5_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5166
  { IMAGE_SAMPLE_CD_V5_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5167
  { IMAGE_SAMPLE_CD_V5_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5168
  { IMAGE_SAMPLE_CD_V5_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5169
  { IMAGE_SAMPLE_CD_V5_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5170
  { IMAGE_SAMPLE_CD_V5_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5171
  { IMAGE_SAMPLE_CD_CL_V1_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 5172
  { IMAGE_SAMPLE_CD_CL_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5173
  { IMAGE_SAMPLE_CD_CL_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5174
  { IMAGE_SAMPLE_CD_CL_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5175
  { IMAGE_SAMPLE_CD_CL_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5176
  { IMAGE_SAMPLE_CD_CL_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5177
  { IMAGE_SAMPLE_CD_CL_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5178
  { IMAGE_SAMPLE_CD_CL_V1_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5179
  { IMAGE_SAMPLE_CD_CL_V1_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 5180
  { IMAGE_SAMPLE_CD_CL_V2_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 5181
  { IMAGE_SAMPLE_CD_CL_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5182
  { IMAGE_SAMPLE_CD_CL_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5183
  { IMAGE_SAMPLE_CD_CL_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5184
  { IMAGE_SAMPLE_CD_CL_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5185
  { IMAGE_SAMPLE_CD_CL_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5186
  { IMAGE_SAMPLE_CD_CL_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5187
  { IMAGE_SAMPLE_CD_CL_V2_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5188
  { IMAGE_SAMPLE_CD_CL_V2_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 5189
  { IMAGE_SAMPLE_CD_CL_V3_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 5190
  { IMAGE_SAMPLE_CD_CL_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5191
  { IMAGE_SAMPLE_CD_CL_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5192
  { IMAGE_SAMPLE_CD_CL_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5193
  { IMAGE_SAMPLE_CD_CL_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5194
  { IMAGE_SAMPLE_CD_CL_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5195
  { IMAGE_SAMPLE_CD_CL_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5196
  { IMAGE_SAMPLE_CD_CL_V3_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5197
  { IMAGE_SAMPLE_CD_CL_V3_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 5198
  { IMAGE_SAMPLE_CD_CL_V4_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 5199
  { IMAGE_SAMPLE_CD_CL_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5200
  { IMAGE_SAMPLE_CD_CL_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5201
  { IMAGE_SAMPLE_CD_CL_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5202
  { IMAGE_SAMPLE_CD_CL_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5203
  { IMAGE_SAMPLE_CD_CL_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5204
  { IMAGE_SAMPLE_CD_CL_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5205
  { IMAGE_SAMPLE_CD_CL_V4_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5206
  { IMAGE_SAMPLE_CD_CL_V4_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 5207
  { IMAGE_SAMPLE_CD_CL_V5_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 5208
  { IMAGE_SAMPLE_CD_CL_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5209
  { IMAGE_SAMPLE_CD_CL_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5210
  { IMAGE_SAMPLE_CD_CL_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5211
  { IMAGE_SAMPLE_CD_CL_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5212
  { IMAGE_SAMPLE_CD_CL_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5213
  { IMAGE_SAMPLE_CD_CL_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5214
  { IMAGE_SAMPLE_CD_CL_V5_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5215
  { IMAGE_SAMPLE_CD_CL_V5_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 5216
  { IMAGE_SAMPLE_CD_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 5217
  { IMAGE_SAMPLE_CD_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5218
  { IMAGE_SAMPLE_CD_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5219
  { IMAGE_SAMPLE_CD_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5220
  { IMAGE_SAMPLE_CD_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5221
  { IMAGE_SAMPLE_CD_CL_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5222
  { IMAGE_SAMPLE_CD_CL_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5223
  { IMAGE_SAMPLE_CD_CL_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5224
  { IMAGE_SAMPLE_CD_CL_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 5225
  { IMAGE_SAMPLE_CD_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 5226
  { IMAGE_SAMPLE_CD_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5227
  { IMAGE_SAMPLE_CD_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5228
  { IMAGE_SAMPLE_CD_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5229
  { IMAGE_SAMPLE_CD_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5230
  { IMAGE_SAMPLE_CD_CL_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5231
  { IMAGE_SAMPLE_CD_CL_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5232
  { IMAGE_SAMPLE_CD_CL_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5233
  { IMAGE_SAMPLE_CD_CL_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 5234
  { IMAGE_SAMPLE_CD_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 5235
  { IMAGE_SAMPLE_CD_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5236
  { IMAGE_SAMPLE_CD_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5237
  { IMAGE_SAMPLE_CD_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5238
  { IMAGE_SAMPLE_CD_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5239
  { IMAGE_SAMPLE_CD_CL_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5240
  { IMAGE_SAMPLE_CD_CL_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5241
  { IMAGE_SAMPLE_CD_CL_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5242
  { IMAGE_SAMPLE_CD_CL_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 5243
  { IMAGE_SAMPLE_CD_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 5244
  { IMAGE_SAMPLE_CD_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5245
  { IMAGE_SAMPLE_CD_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5246
  { IMAGE_SAMPLE_CD_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5247
  { IMAGE_SAMPLE_CD_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5248
  { IMAGE_SAMPLE_CD_CL_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5249
  { IMAGE_SAMPLE_CD_CL_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5250
  { IMAGE_SAMPLE_CD_CL_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5251
  { IMAGE_SAMPLE_CD_CL_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 5252
  { IMAGE_SAMPLE_CD_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 5253
  { IMAGE_SAMPLE_CD_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5254
  { IMAGE_SAMPLE_CD_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5255
  { IMAGE_SAMPLE_CD_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5256
  { IMAGE_SAMPLE_CD_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5257
  { IMAGE_SAMPLE_CD_CL_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5258
  { IMAGE_SAMPLE_CD_CL_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5259
  { IMAGE_SAMPLE_CD_CL_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5260
  { IMAGE_SAMPLE_CD_CL_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 5261
  { IMAGE_SAMPLE_CD_CL_V1_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 5262
  { IMAGE_SAMPLE_CD_CL_V1_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5263
  { IMAGE_SAMPLE_CD_CL_V1_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5264
  { IMAGE_SAMPLE_CD_CL_V1_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5265
  { IMAGE_SAMPLE_CD_CL_V1_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5266
  { IMAGE_SAMPLE_CD_CL_V1_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5267
  { IMAGE_SAMPLE_CD_CL_V1_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5268
  { IMAGE_SAMPLE_CD_CL_V1_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5269
  { IMAGE_SAMPLE_CD_CL_V1_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 5270
  { IMAGE_SAMPLE_CD_CL_V2_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 5271
  { IMAGE_SAMPLE_CD_CL_V2_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5272
  { IMAGE_SAMPLE_CD_CL_V2_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5273
  { IMAGE_SAMPLE_CD_CL_V2_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5274
  { IMAGE_SAMPLE_CD_CL_V2_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5275
  { IMAGE_SAMPLE_CD_CL_V2_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5276
  { IMAGE_SAMPLE_CD_CL_V2_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5277
  { IMAGE_SAMPLE_CD_CL_V2_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5278
  { IMAGE_SAMPLE_CD_CL_V2_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 5279
  { IMAGE_SAMPLE_CD_CL_V3_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 5280
  { IMAGE_SAMPLE_CD_CL_V3_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5281
  { IMAGE_SAMPLE_CD_CL_V3_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5282
  { IMAGE_SAMPLE_CD_CL_V3_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5283
  { IMAGE_SAMPLE_CD_CL_V3_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5284
  { IMAGE_SAMPLE_CD_CL_V3_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5285
  { IMAGE_SAMPLE_CD_CL_V3_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5286
  { IMAGE_SAMPLE_CD_CL_V3_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5287
  { IMAGE_SAMPLE_CD_CL_V3_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 5288
  { IMAGE_SAMPLE_CD_CL_V4_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 5289
  { IMAGE_SAMPLE_CD_CL_V4_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5290
  { IMAGE_SAMPLE_CD_CL_V4_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5291
  { IMAGE_SAMPLE_CD_CL_V4_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5292
  { IMAGE_SAMPLE_CD_CL_V4_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5293
  { IMAGE_SAMPLE_CD_CL_V4_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5294
  { IMAGE_SAMPLE_CD_CL_V4_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5295
  { IMAGE_SAMPLE_CD_CL_V4_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5296
  { IMAGE_SAMPLE_CD_CL_V4_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 5297
  { IMAGE_SAMPLE_CD_CL_V5_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 5298
  { IMAGE_SAMPLE_CD_CL_V5_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5299
  { IMAGE_SAMPLE_CD_CL_V5_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5300
  { IMAGE_SAMPLE_CD_CL_V5_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5301
  { IMAGE_SAMPLE_CD_CL_V5_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5302
  { IMAGE_SAMPLE_CD_CL_V5_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5303
  { IMAGE_SAMPLE_CD_CL_V5_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5304
  { IMAGE_SAMPLE_CD_CL_V5_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5305
  { IMAGE_SAMPLE_CD_CL_V5_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 5306
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 5307
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5308
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5309
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5310
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5311
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5312
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5313
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 5314
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5315
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5316
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5317
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5318
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5319
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5320
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 5321
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5322
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5323
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5324
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5325
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5326
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5327
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 5328
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5329
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5330
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5331
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5332
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5333
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5334
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 5335
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5336
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5337
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5338
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5339
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5340
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5341
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 5342
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5343
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5344
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5345
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5346
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5347
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5348
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 5349
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5350
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5351
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5352
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5353
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5354
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5355
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 5356
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5357
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5358
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5359
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5360
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5361
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5362
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 5363
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5364
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5365
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5366
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5367
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5368
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5369
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 5370
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5371
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5372
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5373
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5374
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5375
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5376
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 5377
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5378
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5379
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5380
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5381
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5382
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5383
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 5384
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5385
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5386
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5387
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5388
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5389
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5390
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 5391
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5392
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5393
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5394
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5395
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5396
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5397
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 5398
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5399
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5400
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5401
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5402
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5403
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5404
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 5405
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5406
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5407
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5408
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5409
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5410
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5411
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 5412
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 5413
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 5414
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 5415
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 5416
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 5417
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 5418
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 5419
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 5420
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 5421
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 5422
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 5423
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 5424
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x8, 0x8 }, // 5425
  { IMAGE_SAMPLE_CD_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5426
  { IMAGE_SAMPLE_CD_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5427
  { IMAGE_SAMPLE_CD_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5428
  { IMAGE_SAMPLE_CD_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5429
  { IMAGE_SAMPLE_CD_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5430
  { IMAGE_SAMPLE_CD_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5431
  { IMAGE_SAMPLE_CD_CL_O_V1_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5432
  { IMAGE_SAMPLE_CD_CL_O_V1_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 5433
  { IMAGE_SAMPLE_CD_CL_O_V1_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 5434
  { IMAGE_SAMPLE_CD_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5435
  { IMAGE_SAMPLE_CD_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5436
  { IMAGE_SAMPLE_CD_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5437
  { IMAGE_SAMPLE_CD_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5438
  { IMAGE_SAMPLE_CD_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5439
  { IMAGE_SAMPLE_CD_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5440
  { IMAGE_SAMPLE_CD_CL_O_V2_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5441
  { IMAGE_SAMPLE_CD_CL_O_V2_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 5442
  { IMAGE_SAMPLE_CD_CL_O_V2_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 5443
  { IMAGE_SAMPLE_CD_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5444
  { IMAGE_SAMPLE_CD_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5445
  { IMAGE_SAMPLE_CD_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5446
  { IMAGE_SAMPLE_CD_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5447
  { IMAGE_SAMPLE_CD_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5448
  { IMAGE_SAMPLE_CD_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5449
  { IMAGE_SAMPLE_CD_CL_O_V3_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5450
  { IMAGE_SAMPLE_CD_CL_O_V3_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 5451
  { IMAGE_SAMPLE_CD_CL_O_V3_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 5452
  { IMAGE_SAMPLE_CD_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5453
  { IMAGE_SAMPLE_CD_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5454
  { IMAGE_SAMPLE_CD_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5455
  { IMAGE_SAMPLE_CD_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5456
  { IMAGE_SAMPLE_CD_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5457
  { IMAGE_SAMPLE_CD_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5458
  { IMAGE_SAMPLE_CD_CL_O_V4_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5459
  { IMAGE_SAMPLE_CD_CL_O_V4_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 5460
  { IMAGE_SAMPLE_CD_CL_O_V4_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 5461
  { IMAGE_SAMPLE_CD_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5462
  { IMAGE_SAMPLE_CD_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5463
  { IMAGE_SAMPLE_CD_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5464
  { IMAGE_SAMPLE_CD_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5465
  { IMAGE_SAMPLE_CD_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5466
  { IMAGE_SAMPLE_CD_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5467
  { IMAGE_SAMPLE_CD_CL_O_V5_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5468
  { IMAGE_SAMPLE_CD_CL_O_V5_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 5469
  { IMAGE_SAMPLE_CD_CL_O_V5_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 5470
  { IMAGE_SAMPLE_CD_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5471
  { IMAGE_SAMPLE_CD_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5472
  { IMAGE_SAMPLE_CD_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5473
  { IMAGE_SAMPLE_CD_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5474
  { IMAGE_SAMPLE_CD_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5475
  { IMAGE_SAMPLE_CD_CL_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5476
  { IMAGE_SAMPLE_CD_CL_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5477
  { IMAGE_SAMPLE_CD_CL_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 5478
  { IMAGE_SAMPLE_CD_CL_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 5479
  { IMAGE_SAMPLE_CD_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5480
  { IMAGE_SAMPLE_CD_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5481
  { IMAGE_SAMPLE_CD_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5482
  { IMAGE_SAMPLE_CD_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5483
  { IMAGE_SAMPLE_CD_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5484
  { IMAGE_SAMPLE_CD_CL_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5485
  { IMAGE_SAMPLE_CD_CL_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5486
  { IMAGE_SAMPLE_CD_CL_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 5487
  { IMAGE_SAMPLE_CD_CL_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 5488
  { IMAGE_SAMPLE_CD_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5489
  { IMAGE_SAMPLE_CD_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5490
  { IMAGE_SAMPLE_CD_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5491
  { IMAGE_SAMPLE_CD_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5492
  { IMAGE_SAMPLE_CD_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5493
  { IMAGE_SAMPLE_CD_CL_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5494
  { IMAGE_SAMPLE_CD_CL_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5495
  { IMAGE_SAMPLE_CD_CL_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 5496
  { IMAGE_SAMPLE_CD_CL_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 5497
  { IMAGE_SAMPLE_CD_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5498
  { IMAGE_SAMPLE_CD_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5499
  { IMAGE_SAMPLE_CD_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5500
  { IMAGE_SAMPLE_CD_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5501
  { IMAGE_SAMPLE_CD_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5502
  { IMAGE_SAMPLE_CD_CL_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5503
  { IMAGE_SAMPLE_CD_CL_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5504
  { IMAGE_SAMPLE_CD_CL_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 5505
  { IMAGE_SAMPLE_CD_CL_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 5506
  { IMAGE_SAMPLE_CD_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5507
  { IMAGE_SAMPLE_CD_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5508
  { IMAGE_SAMPLE_CD_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5509
  { IMAGE_SAMPLE_CD_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5510
  { IMAGE_SAMPLE_CD_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5511
  { IMAGE_SAMPLE_CD_CL_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5512
  { IMAGE_SAMPLE_CD_CL_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5513
  { IMAGE_SAMPLE_CD_CL_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 5514
  { IMAGE_SAMPLE_CD_CL_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 5515
  { IMAGE_SAMPLE_CD_CL_O_V1_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5516
  { IMAGE_SAMPLE_CD_CL_O_V1_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5517
  { IMAGE_SAMPLE_CD_CL_O_V1_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5518
  { IMAGE_SAMPLE_CD_CL_O_V1_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5519
  { IMAGE_SAMPLE_CD_CL_O_V1_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5520
  { IMAGE_SAMPLE_CD_CL_O_V1_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5521
  { IMAGE_SAMPLE_CD_CL_O_V1_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5522
  { IMAGE_SAMPLE_CD_CL_O_V1_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 5523
  { IMAGE_SAMPLE_CD_CL_O_V1_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 5524
  { IMAGE_SAMPLE_CD_CL_O_V2_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5525
  { IMAGE_SAMPLE_CD_CL_O_V2_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5526
  { IMAGE_SAMPLE_CD_CL_O_V2_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5527
  { IMAGE_SAMPLE_CD_CL_O_V2_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5528
  { IMAGE_SAMPLE_CD_CL_O_V2_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5529
  { IMAGE_SAMPLE_CD_CL_O_V2_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5530
  { IMAGE_SAMPLE_CD_CL_O_V2_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5531
  { IMAGE_SAMPLE_CD_CL_O_V2_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 5532
  { IMAGE_SAMPLE_CD_CL_O_V2_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 5533
  { IMAGE_SAMPLE_CD_CL_O_V3_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5534
  { IMAGE_SAMPLE_CD_CL_O_V3_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5535
  { IMAGE_SAMPLE_CD_CL_O_V3_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5536
  { IMAGE_SAMPLE_CD_CL_O_V3_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5537
  { IMAGE_SAMPLE_CD_CL_O_V3_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5538
  { IMAGE_SAMPLE_CD_CL_O_V3_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5539
  { IMAGE_SAMPLE_CD_CL_O_V3_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5540
  { IMAGE_SAMPLE_CD_CL_O_V3_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 5541
  { IMAGE_SAMPLE_CD_CL_O_V3_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 5542
  { IMAGE_SAMPLE_CD_CL_O_V4_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5543
  { IMAGE_SAMPLE_CD_CL_O_V4_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5544
  { IMAGE_SAMPLE_CD_CL_O_V4_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5545
  { IMAGE_SAMPLE_CD_CL_O_V4_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5546
  { IMAGE_SAMPLE_CD_CL_O_V4_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5547
  { IMAGE_SAMPLE_CD_CL_O_V4_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5548
  { IMAGE_SAMPLE_CD_CL_O_V4_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5549
  { IMAGE_SAMPLE_CD_CL_O_V4_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 5550
  { IMAGE_SAMPLE_CD_CL_O_V4_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 5551
  { IMAGE_SAMPLE_CD_CL_O_V5_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5552
  { IMAGE_SAMPLE_CD_CL_O_V5_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5553
  { IMAGE_SAMPLE_CD_CL_O_V5_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5554
  { IMAGE_SAMPLE_CD_CL_O_V5_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5555
  { IMAGE_SAMPLE_CD_CL_O_V5_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5556
  { IMAGE_SAMPLE_CD_CL_O_V5_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5557
  { IMAGE_SAMPLE_CD_CL_O_V5_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5558
  { IMAGE_SAMPLE_CD_CL_O_V5_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 5559
  { IMAGE_SAMPLE_CD_CL_O_V5_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 5560
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5561
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5562
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5563
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5564
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5565
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5566
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5567
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5568
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5569
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5570
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5571
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5572
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5573
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5574
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5575
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5576
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5577
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5578
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5579
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5580
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5581
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5582
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5583
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5584
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5585
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5586
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5587
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5588
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5589
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5590
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5591
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5592
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5593
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5594
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5595
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5596
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5597
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5598
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5599
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5600
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5601
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5602
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5603
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5604
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5605
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5606
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5607
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5608
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5609
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5610
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5611
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5612
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5613
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5614
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5615
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5616
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5617
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5618
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5619
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5620
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5621
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5622
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5623
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5624
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5625
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5626
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5627
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5628
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5629
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5630
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5631
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5632
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5633
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5634
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5635
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5636
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5637
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5638
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5639
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5640
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5641
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5642
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5643
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5644
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5645
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5646
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5647
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5648
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5649
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5650
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5651
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5652
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5653
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5654
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5655
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5656
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5657
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5658
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5659
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5660
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5661
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5662
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5663
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5664
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5665
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 5666
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 5667
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 5668
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 5669
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 5670
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 5671
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x9, 0x1 }, // 5672
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 5673
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 5674
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 5675
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 5676
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 5677
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x8, 0x8 }, // 5678
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x9, 0x9 }, // 5679
  { IMAGE_SAMPLE_CD_CL_O_nortn_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 5680
  { IMAGE_SAMPLE_CD_CL_O_nortn_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 5681
  { IMAGE_SAMPLE_CD_CL_O_nortn_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 5682
  { IMAGE_SAMPLE_CD_CL_O_nortn_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 5683
  { IMAGE_SAMPLE_CD_CL_O_nortn_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 5684
  { IMAGE_SAMPLE_CD_CL_O_nortn_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 5685
  { IMAGE_SAMPLE_CD_CL_O_nortn_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x9, 0x1 }, // 5686
  { IMAGE_SAMPLE_CD_CL_O_nortn_V10_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0xA, 0x1 }, // 5687
  { IMAGE_SAMPLE_CD_CL_O_nortn_V11_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0xB, 0x1 }, // 5688
  { IMAGE_SAMPLE_CD_CL_O_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 5689
  { IMAGE_SAMPLE_CD_CL_O_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 5690
  { IMAGE_SAMPLE_CD_CL_O_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 5691
  { IMAGE_SAMPLE_CD_CL_O_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 5692
  { IMAGE_SAMPLE_CD_CL_O_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 5693
  { IMAGE_SAMPLE_CD_CL_O_nortn_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x8, 0x8 }, // 5694
  { IMAGE_SAMPLE_CD_CL_O_nortn_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x9, 0x9 }, // 5695
  { IMAGE_SAMPLE_CD_CL_O_nortn_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0xA, 0xA }, // 5696
  { IMAGE_SAMPLE_CD_CL_O_nortn_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0xB, 0xB }, // 5697
  { IMAGE_SAMPLE_CD_CL_nortn_V2_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 5698
  { IMAGE_SAMPLE_CD_CL_nortn_V3_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 5699
  { IMAGE_SAMPLE_CD_CL_nortn_V4_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 5700
  { IMAGE_SAMPLE_CD_CL_nortn_V5_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 5701
  { IMAGE_SAMPLE_CD_CL_nortn_V6_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 5702
  { IMAGE_SAMPLE_CD_CL_nortn_V7_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 5703
  { IMAGE_SAMPLE_CD_CL_nortn_V8_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 5704
  { IMAGE_SAMPLE_CD_CL_nortn_V9_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x9, 0x1 }, // 5705
  { IMAGE_SAMPLE_CD_CL_nortn_V10_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0xA, 0x1 }, // 5706
  { IMAGE_SAMPLE_CD_CL_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 5707
  { IMAGE_SAMPLE_CD_CL_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 5708
  { IMAGE_SAMPLE_CD_CL_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 5709
  { IMAGE_SAMPLE_CD_CL_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 5710
  { IMAGE_SAMPLE_CD_CL_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 5711
  { IMAGE_SAMPLE_CD_CL_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 5712
  { IMAGE_SAMPLE_CD_CL_nortn_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x8, 0x8 }, // 5713
  { IMAGE_SAMPLE_CD_CL_nortn_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x9, 0x9 }, // 5714
  { IMAGE_SAMPLE_CD_CL_nortn_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0xA, 0xA }, // 5715
  { IMAGE_SAMPLE_CD_G16_V1_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 5716
  { IMAGE_SAMPLE_CD_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5717
  { IMAGE_SAMPLE_CD_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5718
  { IMAGE_SAMPLE_CD_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5719
  { IMAGE_SAMPLE_CD_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5720
  { IMAGE_SAMPLE_CD_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5721
  { IMAGE_SAMPLE_CD_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5722
  { IMAGE_SAMPLE_CD_G16_V2_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 5723
  { IMAGE_SAMPLE_CD_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5724
  { IMAGE_SAMPLE_CD_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5725
  { IMAGE_SAMPLE_CD_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5726
  { IMAGE_SAMPLE_CD_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5727
  { IMAGE_SAMPLE_CD_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5728
  { IMAGE_SAMPLE_CD_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5729
  { IMAGE_SAMPLE_CD_G16_V3_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 5730
  { IMAGE_SAMPLE_CD_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5731
  { IMAGE_SAMPLE_CD_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5732
  { IMAGE_SAMPLE_CD_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5733
  { IMAGE_SAMPLE_CD_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5734
  { IMAGE_SAMPLE_CD_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5735
  { IMAGE_SAMPLE_CD_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5736
  { IMAGE_SAMPLE_CD_G16_V4_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 5737
  { IMAGE_SAMPLE_CD_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5738
  { IMAGE_SAMPLE_CD_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5739
  { IMAGE_SAMPLE_CD_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5740
  { IMAGE_SAMPLE_CD_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5741
  { IMAGE_SAMPLE_CD_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5742
  { IMAGE_SAMPLE_CD_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5743
  { IMAGE_SAMPLE_CD_G16_V5_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 5744
  { IMAGE_SAMPLE_CD_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5745
  { IMAGE_SAMPLE_CD_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5746
  { IMAGE_SAMPLE_CD_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5747
  { IMAGE_SAMPLE_CD_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5748
  { IMAGE_SAMPLE_CD_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5749
  { IMAGE_SAMPLE_CD_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5750
  { IMAGE_SAMPLE_CD_G16_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 5751
  { IMAGE_SAMPLE_CD_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5752
  { IMAGE_SAMPLE_CD_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5753
  { IMAGE_SAMPLE_CD_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5754
  { IMAGE_SAMPLE_CD_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5755
  { IMAGE_SAMPLE_CD_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5756
  { IMAGE_SAMPLE_CD_G16_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 5757
  { IMAGE_SAMPLE_CD_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5758
  { IMAGE_SAMPLE_CD_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5759
  { IMAGE_SAMPLE_CD_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5760
  { IMAGE_SAMPLE_CD_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5761
  { IMAGE_SAMPLE_CD_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5762
  { IMAGE_SAMPLE_CD_G16_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 5763
  { IMAGE_SAMPLE_CD_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5764
  { IMAGE_SAMPLE_CD_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5765
  { IMAGE_SAMPLE_CD_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5766
  { IMAGE_SAMPLE_CD_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5767
  { IMAGE_SAMPLE_CD_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5768
  { IMAGE_SAMPLE_CD_G16_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 5769
  { IMAGE_SAMPLE_CD_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5770
  { IMAGE_SAMPLE_CD_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5771
  { IMAGE_SAMPLE_CD_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5772
  { IMAGE_SAMPLE_CD_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5773
  { IMAGE_SAMPLE_CD_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5774
  { IMAGE_SAMPLE_CD_G16_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 5775
  { IMAGE_SAMPLE_CD_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5776
  { IMAGE_SAMPLE_CD_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5777
  { IMAGE_SAMPLE_CD_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5778
  { IMAGE_SAMPLE_CD_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5779
  { IMAGE_SAMPLE_CD_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5780
  { IMAGE_SAMPLE_CD_G16_V1_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 5781
  { IMAGE_SAMPLE_CD_G16_V1_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5782
  { IMAGE_SAMPLE_CD_G16_V1_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5783
  { IMAGE_SAMPLE_CD_G16_V1_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5784
  { IMAGE_SAMPLE_CD_G16_V1_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5785
  { IMAGE_SAMPLE_CD_G16_V1_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5786
  { IMAGE_SAMPLE_CD_G16_V1_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5787
  { IMAGE_SAMPLE_CD_G16_V2_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 5788
  { IMAGE_SAMPLE_CD_G16_V2_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5789
  { IMAGE_SAMPLE_CD_G16_V2_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5790
  { IMAGE_SAMPLE_CD_G16_V2_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5791
  { IMAGE_SAMPLE_CD_G16_V2_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5792
  { IMAGE_SAMPLE_CD_G16_V2_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5793
  { IMAGE_SAMPLE_CD_G16_V2_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5794
  { IMAGE_SAMPLE_CD_G16_V3_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 5795
  { IMAGE_SAMPLE_CD_G16_V3_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5796
  { IMAGE_SAMPLE_CD_G16_V3_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5797
  { IMAGE_SAMPLE_CD_G16_V3_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5798
  { IMAGE_SAMPLE_CD_G16_V3_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5799
  { IMAGE_SAMPLE_CD_G16_V3_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5800
  { IMAGE_SAMPLE_CD_G16_V3_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5801
  { IMAGE_SAMPLE_CD_G16_V4_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 5802
  { IMAGE_SAMPLE_CD_G16_V4_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5803
  { IMAGE_SAMPLE_CD_G16_V4_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5804
  { IMAGE_SAMPLE_CD_G16_V4_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5805
  { IMAGE_SAMPLE_CD_G16_V4_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5806
  { IMAGE_SAMPLE_CD_G16_V4_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5807
  { IMAGE_SAMPLE_CD_G16_V4_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5808
  { IMAGE_SAMPLE_CD_G16_V5_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 5809
  { IMAGE_SAMPLE_CD_G16_V5_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5810
  { IMAGE_SAMPLE_CD_G16_V5_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5811
  { IMAGE_SAMPLE_CD_G16_V5_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5812
  { IMAGE_SAMPLE_CD_G16_V5_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5813
  { IMAGE_SAMPLE_CD_G16_V5_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5814
  { IMAGE_SAMPLE_CD_G16_V5_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5815
  { IMAGE_SAMPLE_CD_G16_nortn_V2_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 5816
  { IMAGE_SAMPLE_CD_G16_nortn_V3_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 5817
  { IMAGE_SAMPLE_CD_G16_nortn_V4_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 5818
  { IMAGE_SAMPLE_CD_G16_nortn_V5_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 5819
  { IMAGE_SAMPLE_CD_G16_nortn_V6_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 5820
  { IMAGE_SAMPLE_CD_G16_nortn_V7_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 5821
  { IMAGE_SAMPLE_CD_G16_nortn_V8_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 5822
  { IMAGE_SAMPLE_CD_G16_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 5823
  { IMAGE_SAMPLE_CD_G16_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 5824
  { IMAGE_SAMPLE_CD_G16_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 5825
  { IMAGE_SAMPLE_CD_G16_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 5826
  { IMAGE_SAMPLE_CD_G16_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 5827
  { IMAGE_SAMPLE_CD_G16_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 5828
  { IMAGE_SAMPLE_CD_O_V1_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5829
  { IMAGE_SAMPLE_CD_O_V1_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5830
  { IMAGE_SAMPLE_CD_O_V1_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5831
  { IMAGE_SAMPLE_CD_O_V1_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5832
  { IMAGE_SAMPLE_CD_O_V1_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5833
  { IMAGE_SAMPLE_CD_O_V1_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5834
  { IMAGE_SAMPLE_CD_O_V1_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5835
  { IMAGE_SAMPLE_CD_O_V1_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 5836
  { IMAGE_SAMPLE_CD_O_V2_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5837
  { IMAGE_SAMPLE_CD_O_V2_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5838
  { IMAGE_SAMPLE_CD_O_V2_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5839
  { IMAGE_SAMPLE_CD_O_V2_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5840
  { IMAGE_SAMPLE_CD_O_V2_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5841
  { IMAGE_SAMPLE_CD_O_V2_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5842
  { IMAGE_SAMPLE_CD_O_V2_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5843
  { IMAGE_SAMPLE_CD_O_V2_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 5844
  { IMAGE_SAMPLE_CD_O_V3_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5845
  { IMAGE_SAMPLE_CD_O_V3_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5846
  { IMAGE_SAMPLE_CD_O_V3_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5847
  { IMAGE_SAMPLE_CD_O_V3_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5848
  { IMAGE_SAMPLE_CD_O_V3_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5849
  { IMAGE_SAMPLE_CD_O_V3_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5850
  { IMAGE_SAMPLE_CD_O_V3_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5851
  { IMAGE_SAMPLE_CD_O_V3_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 5852
  { IMAGE_SAMPLE_CD_O_V4_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5853
  { IMAGE_SAMPLE_CD_O_V4_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5854
  { IMAGE_SAMPLE_CD_O_V4_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5855
  { IMAGE_SAMPLE_CD_O_V4_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5856
  { IMAGE_SAMPLE_CD_O_V4_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5857
  { IMAGE_SAMPLE_CD_O_V4_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5858
  { IMAGE_SAMPLE_CD_O_V4_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5859
  { IMAGE_SAMPLE_CD_O_V4_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 5860
  { IMAGE_SAMPLE_CD_O_V5_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5861
  { IMAGE_SAMPLE_CD_O_V5_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5862
  { IMAGE_SAMPLE_CD_O_V5_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5863
  { IMAGE_SAMPLE_CD_O_V5_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5864
  { IMAGE_SAMPLE_CD_O_V5_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5865
  { IMAGE_SAMPLE_CD_O_V5_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5866
  { IMAGE_SAMPLE_CD_O_V5_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5867
  { IMAGE_SAMPLE_CD_O_V5_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 5868
  { IMAGE_SAMPLE_CD_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5869
  { IMAGE_SAMPLE_CD_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5870
  { IMAGE_SAMPLE_CD_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5871
  { IMAGE_SAMPLE_CD_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5872
  { IMAGE_SAMPLE_CD_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5873
  { IMAGE_SAMPLE_CD_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5874
  { IMAGE_SAMPLE_CD_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5875
  { IMAGE_SAMPLE_CD_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 5876
  { IMAGE_SAMPLE_CD_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5877
  { IMAGE_SAMPLE_CD_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5878
  { IMAGE_SAMPLE_CD_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5879
  { IMAGE_SAMPLE_CD_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5880
  { IMAGE_SAMPLE_CD_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5881
  { IMAGE_SAMPLE_CD_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5882
  { IMAGE_SAMPLE_CD_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5883
  { IMAGE_SAMPLE_CD_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 5884
  { IMAGE_SAMPLE_CD_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5885
  { IMAGE_SAMPLE_CD_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5886
  { IMAGE_SAMPLE_CD_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5887
  { IMAGE_SAMPLE_CD_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5888
  { IMAGE_SAMPLE_CD_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5889
  { IMAGE_SAMPLE_CD_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5890
  { IMAGE_SAMPLE_CD_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5891
  { IMAGE_SAMPLE_CD_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 5892
  { IMAGE_SAMPLE_CD_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5893
  { IMAGE_SAMPLE_CD_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5894
  { IMAGE_SAMPLE_CD_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5895
  { IMAGE_SAMPLE_CD_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5896
  { IMAGE_SAMPLE_CD_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5897
  { IMAGE_SAMPLE_CD_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5898
  { IMAGE_SAMPLE_CD_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5899
  { IMAGE_SAMPLE_CD_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 5900
  { IMAGE_SAMPLE_CD_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5901
  { IMAGE_SAMPLE_CD_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5902
  { IMAGE_SAMPLE_CD_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5903
  { IMAGE_SAMPLE_CD_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5904
  { IMAGE_SAMPLE_CD_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5905
  { IMAGE_SAMPLE_CD_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5906
  { IMAGE_SAMPLE_CD_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5907
  { IMAGE_SAMPLE_CD_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 5908
  { IMAGE_SAMPLE_CD_O_V1_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5909
  { IMAGE_SAMPLE_CD_O_V1_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5910
  { IMAGE_SAMPLE_CD_O_V1_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5911
  { IMAGE_SAMPLE_CD_O_V1_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5912
  { IMAGE_SAMPLE_CD_O_V1_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5913
  { IMAGE_SAMPLE_CD_O_V1_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5914
  { IMAGE_SAMPLE_CD_O_V1_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5915
  { IMAGE_SAMPLE_CD_O_V1_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 5916
  { IMAGE_SAMPLE_CD_O_V2_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5917
  { IMAGE_SAMPLE_CD_O_V2_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5918
  { IMAGE_SAMPLE_CD_O_V2_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5919
  { IMAGE_SAMPLE_CD_O_V2_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5920
  { IMAGE_SAMPLE_CD_O_V2_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5921
  { IMAGE_SAMPLE_CD_O_V2_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5922
  { IMAGE_SAMPLE_CD_O_V2_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5923
  { IMAGE_SAMPLE_CD_O_V2_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 5924
  { IMAGE_SAMPLE_CD_O_V3_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5925
  { IMAGE_SAMPLE_CD_O_V3_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5926
  { IMAGE_SAMPLE_CD_O_V3_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5927
  { IMAGE_SAMPLE_CD_O_V3_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5928
  { IMAGE_SAMPLE_CD_O_V3_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5929
  { IMAGE_SAMPLE_CD_O_V3_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5930
  { IMAGE_SAMPLE_CD_O_V3_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5931
  { IMAGE_SAMPLE_CD_O_V3_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 5932
  { IMAGE_SAMPLE_CD_O_V4_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5933
  { IMAGE_SAMPLE_CD_O_V4_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5934
  { IMAGE_SAMPLE_CD_O_V4_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5935
  { IMAGE_SAMPLE_CD_O_V4_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5936
  { IMAGE_SAMPLE_CD_O_V4_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5937
  { IMAGE_SAMPLE_CD_O_V4_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5938
  { IMAGE_SAMPLE_CD_O_V4_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5939
  { IMAGE_SAMPLE_CD_O_V4_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 5940
  { IMAGE_SAMPLE_CD_O_V5_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5941
  { IMAGE_SAMPLE_CD_O_V5_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5942
  { IMAGE_SAMPLE_CD_O_V5_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5943
  { IMAGE_SAMPLE_CD_O_V5_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5944
  { IMAGE_SAMPLE_CD_O_V5_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5945
  { IMAGE_SAMPLE_CD_O_V5_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5946
  { IMAGE_SAMPLE_CD_O_V5_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5947
  { IMAGE_SAMPLE_CD_O_V5_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 5948
  { IMAGE_SAMPLE_CD_O_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5949
  { IMAGE_SAMPLE_CD_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5950
  { IMAGE_SAMPLE_CD_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5951
  { IMAGE_SAMPLE_CD_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5952
  { IMAGE_SAMPLE_CD_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5953
  { IMAGE_SAMPLE_CD_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5954
  { IMAGE_SAMPLE_CD_O_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5955
  { IMAGE_SAMPLE_CD_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5956
  { IMAGE_SAMPLE_CD_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5957
  { IMAGE_SAMPLE_CD_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5958
  { IMAGE_SAMPLE_CD_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5959
  { IMAGE_SAMPLE_CD_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5960
  { IMAGE_SAMPLE_CD_O_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5961
  { IMAGE_SAMPLE_CD_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5962
  { IMAGE_SAMPLE_CD_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5963
  { IMAGE_SAMPLE_CD_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5964
  { IMAGE_SAMPLE_CD_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5965
  { IMAGE_SAMPLE_CD_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5966
  { IMAGE_SAMPLE_CD_O_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5967
  { IMAGE_SAMPLE_CD_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5968
  { IMAGE_SAMPLE_CD_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5969
  { IMAGE_SAMPLE_CD_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5970
  { IMAGE_SAMPLE_CD_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5971
  { IMAGE_SAMPLE_CD_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5972
  { IMAGE_SAMPLE_CD_O_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5973
  { IMAGE_SAMPLE_CD_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5974
  { IMAGE_SAMPLE_CD_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5975
  { IMAGE_SAMPLE_CD_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5976
  { IMAGE_SAMPLE_CD_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5977
  { IMAGE_SAMPLE_CD_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5978
  { IMAGE_SAMPLE_CD_O_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5979
  { IMAGE_SAMPLE_CD_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5980
  { IMAGE_SAMPLE_CD_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5981
  { IMAGE_SAMPLE_CD_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5982
  { IMAGE_SAMPLE_CD_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5983
  { IMAGE_SAMPLE_CD_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5984
  { IMAGE_SAMPLE_CD_O_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5985
  { IMAGE_SAMPLE_CD_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5986
  { IMAGE_SAMPLE_CD_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5987
  { IMAGE_SAMPLE_CD_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5988
  { IMAGE_SAMPLE_CD_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5989
  { IMAGE_SAMPLE_CD_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5990
  { IMAGE_SAMPLE_CD_O_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5991
  { IMAGE_SAMPLE_CD_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5992
  { IMAGE_SAMPLE_CD_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5993
  { IMAGE_SAMPLE_CD_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5994
  { IMAGE_SAMPLE_CD_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5995
  { IMAGE_SAMPLE_CD_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5996
  { IMAGE_SAMPLE_CD_O_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5997
  { IMAGE_SAMPLE_CD_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5998
  { IMAGE_SAMPLE_CD_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5999
  { IMAGE_SAMPLE_CD_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6000
  { IMAGE_SAMPLE_CD_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 6001
  { IMAGE_SAMPLE_CD_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 6002
  { IMAGE_SAMPLE_CD_O_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 6003
  { IMAGE_SAMPLE_CD_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6004
  { IMAGE_SAMPLE_CD_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6005
  { IMAGE_SAMPLE_CD_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6006
  { IMAGE_SAMPLE_CD_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 6007
  { IMAGE_SAMPLE_CD_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 6008
  { IMAGE_SAMPLE_CD_O_G16_V1_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 6009
  { IMAGE_SAMPLE_CD_O_G16_V1_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6010
  { IMAGE_SAMPLE_CD_O_G16_V1_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6011
  { IMAGE_SAMPLE_CD_O_G16_V1_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6012
  { IMAGE_SAMPLE_CD_O_G16_V1_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 6013
  { IMAGE_SAMPLE_CD_O_G16_V1_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6014
  { IMAGE_SAMPLE_CD_O_G16_V2_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 6015
  { IMAGE_SAMPLE_CD_O_G16_V2_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6016
  { IMAGE_SAMPLE_CD_O_G16_V2_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6017
  { IMAGE_SAMPLE_CD_O_G16_V2_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6018
  { IMAGE_SAMPLE_CD_O_G16_V2_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 6019
  { IMAGE_SAMPLE_CD_O_G16_V2_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6020
  { IMAGE_SAMPLE_CD_O_G16_V3_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 6021
  { IMAGE_SAMPLE_CD_O_G16_V3_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6022
  { IMAGE_SAMPLE_CD_O_G16_V3_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6023
  { IMAGE_SAMPLE_CD_O_G16_V3_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6024
  { IMAGE_SAMPLE_CD_O_G16_V3_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 6025
  { IMAGE_SAMPLE_CD_O_G16_V3_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6026
  { IMAGE_SAMPLE_CD_O_G16_V4_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 6027
  { IMAGE_SAMPLE_CD_O_G16_V4_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6028
  { IMAGE_SAMPLE_CD_O_G16_V4_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6029
  { IMAGE_SAMPLE_CD_O_G16_V4_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6030
  { IMAGE_SAMPLE_CD_O_G16_V4_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 6031
  { IMAGE_SAMPLE_CD_O_G16_V4_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6032
  { IMAGE_SAMPLE_CD_O_G16_V5_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 6033
  { IMAGE_SAMPLE_CD_O_G16_V5_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6034
  { IMAGE_SAMPLE_CD_O_G16_V5_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6035
  { IMAGE_SAMPLE_CD_O_G16_V5_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6036
  { IMAGE_SAMPLE_CD_O_G16_V5_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 6037
  { IMAGE_SAMPLE_CD_O_G16_V5_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6038
  { IMAGE_SAMPLE_CD_O_G16_nortn_V3_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 6039
  { IMAGE_SAMPLE_CD_O_G16_nortn_V4_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 6040
  { IMAGE_SAMPLE_CD_O_G16_nortn_V5_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 6041
  { IMAGE_SAMPLE_CD_O_G16_nortn_V6_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 6042
  { IMAGE_SAMPLE_CD_O_G16_nortn_V7_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 6043
  { IMAGE_SAMPLE_CD_O_G16_nortn_V8_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 6044
  { IMAGE_SAMPLE_CD_O_G16_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 6045
  { IMAGE_SAMPLE_CD_O_G16_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 6046
  { IMAGE_SAMPLE_CD_O_G16_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 6047
  { IMAGE_SAMPLE_CD_O_G16_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 6048
  { IMAGE_SAMPLE_CD_O_G16_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 6049
  { IMAGE_SAMPLE_CD_O_G16_nortn_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x8, 0x8 }, // 6050
  { IMAGE_SAMPLE_CD_O_nortn_V3_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 6051
  { IMAGE_SAMPLE_CD_O_nortn_V4_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 6052
  { IMAGE_SAMPLE_CD_O_nortn_V5_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 6053
  { IMAGE_SAMPLE_CD_O_nortn_V6_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 6054
  { IMAGE_SAMPLE_CD_O_nortn_V7_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 6055
  { IMAGE_SAMPLE_CD_O_nortn_V8_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 6056
  { IMAGE_SAMPLE_CD_O_nortn_V9_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0x9, 0x1 }, // 6057
  { IMAGE_SAMPLE_CD_O_nortn_V10_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0xA, 0x1 }, // 6058
  { IMAGE_SAMPLE_CD_O_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 6059
  { IMAGE_SAMPLE_CD_O_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 6060
  { IMAGE_SAMPLE_CD_O_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 6061
  { IMAGE_SAMPLE_CD_O_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 6062
  { IMAGE_SAMPLE_CD_O_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 6063
  { IMAGE_SAMPLE_CD_O_nortn_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0x8, 0x8 }, // 6064
  { IMAGE_SAMPLE_CD_O_nortn_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0x9, 0x9 }, // 6065
  { IMAGE_SAMPLE_CD_O_nortn_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0xA, 0xA }, // 6066
  { IMAGE_SAMPLE_CD_nortn_V2_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 6067
  { IMAGE_SAMPLE_CD_nortn_V3_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 6068
  { IMAGE_SAMPLE_CD_nortn_V4_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 6069
  { IMAGE_SAMPLE_CD_nortn_V5_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 6070
  { IMAGE_SAMPLE_CD_nortn_V6_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 6071
  { IMAGE_SAMPLE_CD_nortn_V7_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 6072
  { IMAGE_SAMPLE_CD_nortn_V8_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 6073
  { IMAGE_SAMPLE_CD_nortn_V9_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x9, 0x1 }, // 6074
  { IMAGE_SAMPLE_CD_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 6075
  { IMAGE_SAMPLE_CD_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 6076
  { IMAGE_SAMPLE_CD_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 6077
  { IMAGE_SAMPLE_CD_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 6078
  { IMAGE_SAMPLE_CD_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 6079
  { IMAGE_SAMPLE_CD_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 6080
  { IMAGE_SAMPLE_CD_nortn_V8_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x8, 0x8 }, // 6081
  { IMAGE_SAMPLE_CD_nortn_V9_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x9, 0x9 }, // 6082
  { IMAGE_SAMPLE_CL_V1_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 6083
  { IMAGE_SAMPLE_CL_V1_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 6084
  { IMAGE_SAMPLE_CL_V1_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 6085
  { IMAGE_SAMPLE_CL_V1_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6086
  { IMAGE_SAMPLE_CL_V2_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 6087
  { IMAGE_SAMPLE_CL_V2_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 6088
  { IMAGE_SAMPLE_CL_V2_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6089
  { IMAGE_SAMPLE_CL_V2_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6090
  { IMAGE_SAMPLE_CL_V3_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 6091
  { IMAGE_SAMPLE_CL_V3_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 6092
  { IMAGE_SAMPLE_CL_V3_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 6093
  { IMAGE_SAMPLE_CL_V3_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6094
  { IMAGE_SAMPLE_CL_V4_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 6095
  { IMAGE_SAMPLE_CL_V4_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 6096
  { IMAGE_SAMPLE_CL_V4_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 6097
  { IMAGE_SAMPLE_CL_V4_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6098
  { IMAGE_SAMPLE_CL_V5_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 6099
  { IMAGE_SAMPLE_CL_V5_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 6100
  { IMAGE_SAMPLE_CL_V5_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 6101
  { IMAGE_SAMPLE_CL_V5_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6102
  { IMAGE_SAMPLE_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 6103
  { IMAGE_SAMPLE_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 6104
  { IMAGE_SAMPLE_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6105
  { IMAGE_SAMPLE_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 6106
  { IMAGE_SAMPLE_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 6107
  { IMAGE_SAMPLE_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6108
  { IMAGE_SAMPLE_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 6109
  { IMAGE_SAMPLE_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 6110
  { IMAGE_SAMPLE_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6111
  { IMAGE_SAMPLE_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 6112
  { IMAGE_SAMPLE_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 6113
  { IMAGE_SAMPLE_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6114
  { IMAGE_SAMPLE_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 6115
  { IMAGE_SAMPLE_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 6116
  { IMAGE_SAMPLE_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6117
  { IMAGE_SAMPLE_CL_V1_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 6118
  { IMAGE_SAMPLE_CL_V1_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 6119
  { IMAGE_SAMPLE_CL_V1_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 6120
  { IMAGE_SAMPLE_CL_V1_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 6121
  { IMAGE_SAMPLE_CL_V2_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 6122
  { IMAGE_SAMPLE_CL_V2_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 6123
  { IMAGE_SAMPLE_CL_V2_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 6124
  { IMAGE_SAMPLE_CL_V2_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 6125
  { IMAGE_SAMPLE_CL_V3_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 6126
  { IMAGE_SAMPLE_CL_V3_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 6127
  { IMAGE_SAMPLE_CL_V3_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 6128
  { IMAGE_SAMPLE_CL_V3_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 6129
  { IMAGE_SAMPLE_CL_V4_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 6130
  { IMAGE_SAMPLE_CL_V4_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 6131
  { IMAGE_SAMPLE_CL_V4_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 6132
  { IMAGE_SAMPLE_CL_V4_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 6133
  { IMAGE_SAMPLE_CL_V5_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 6134
  { IMAGE_SAMPLE_CL_V5_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 6135
  { IMAGE_SAMPLE_CL_V5_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 6136
  { IMAGE_SAMPLE_CL_V5_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 6137
  { IMAGE_SAMPLE_CL_V1_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 6138
  { IMAGE_SAMPLE_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 6139
  { IMAGE_SAMPLE_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 6140
  { IMAGE_SAMPLE_CL_V2_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 6141
  { IMAGE_SAMPLE_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 6142
  { IMAGE_SAMPLE_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 6143
  { IMAGE_SAMPLE_CL_V3_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 6144
  { IMAGE_SAMPLE_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 6145
  { IMAGE_SAMPLE_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 6146
  { IMAGE_SAMPLE_CL_V4_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 6147
  { IMAGE_SAMPLE_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 6148
  { IMAGE_SAMPLE_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 6149
  { IMAGE_SAMPLE_CL_V5_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 6150
  { IMAGE_SAMPLE_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 6151
  { IMAGE_SAMPLE_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 6152
  { IMAGE_SAMPLE_CL_V1_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 6153
  { IMAGE_SAMPLE_CL_V1_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 6154
  { IMAGE_SAMPLE_CL_V1_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 6155
  { IMAGE_SAMPLE_CL_V1_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 6156
  { IMAGE_SAMPLE_CL_V2_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 6157
  { IMAGE_SAMPLE_CL_V2_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 6158
  { IMAGE_SAMPLE_CL_V2_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 6159
  { IMAGE_SAMPLE_CL_V2_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 6160
  { IMAGE_SAMPLE_CL_V3_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 6161
  { IMAGE_SAMPLE_CL_V3_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 6162
  { IMAGE_SAMPLE_CL_V3_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 6163
  { IMAGE_SAMPLE_CL_V3_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 6164
  { IMAGE_SAMPLE_CL_V4_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 6165
  { IMAGE_SAMPLE_CL_V4_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 6166
  { IMAGE_SAMPLE_CL_V4_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 6167
  { IMAGE_SAMPLE_CL_V4_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 6168
  { IMAGE_SAMPLE_CL_V5_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 6169
  { IMAGE_SAMPLE_CL_V5_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 6170
  { IMAGE_SAMPLE_CL_V5_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 6171
  { IMAGE_SAMPLE_CL_V5_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 6172
  { IMAGE_SAMPLE_CL_V1_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 6173
  { IMAGE_SAMPLE_CL_V1_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 6174
  { IMAGE_SAMPLE_CL_V1_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 6175
  { IMAGE_SAMPLE_CL_V1_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6176
  { IMAGE_SAMPLE_CL_V2_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 6177
  { IMAGE_SAMPLE_CL_V2_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 6178
  { IMAGE_SAMPLE_CL_V2_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 6179
  { IMAGE_SAMPLE_CL_V2_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6180
  { IMAGE_SAMPLE_CL_V3_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 6181
  { IMAGE_SAMPLE_CL_V3_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 6182
  { IMAGE_SAMPLE_CL_V3_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 6183
  { IMAGE_SAMPLE_CL_V3_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6184
  { IMAGE_SAMPLE_CL_V4_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 6185
  { IMAGE_SAMPLE_CL_V4_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 6186
  { IMAGE_SAMPLE_CL_V4_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 6187
  { IMAGE_SAMPLE_CL_V4_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6188
  { IMAGE_SAMPLE_CL_V5_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 6189
  { IMAGE_SAMPLE_CL_V5_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 6190
  { IMAGE_SAMPLE_CL_V5_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 6191
  { IMAGE_SAMPLE_CL_V5_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6192
  { IMAGE_SAMPLE_CL_O_V1_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 6193
  { IMAGE_SAMPLE_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 6194
  { IMAGE_SAMPLE_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6195
  { IMAGE_SAMPLE_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6196
  { IMAGE_SAMPLE_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6197
  { IMAGE_SAMPLE_CL_O_V2_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 6198
  { IMAGE_SAMPLE_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6199
  { IMAGE_SAMPLE_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6200
  { IMAGE_SAMPLE_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6201
  { IMAGE_SAMPLE_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6202
  { IMAGE_SAMPLE_CL_O_V3_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 6203
  { IMAGE_SAMPLE_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 6204
  { IMAGE_SAMPLE_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6205
  { IMAGE_SAMPLE_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6206
  { IMAGE_SAMPLE_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6207
  { IMAGE_SAMPLE_CL_O_V4_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 6208
  { IMAGE_SAMPLE_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 6209
  { IMAGE_SAMPLE_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6210
  { IMAGE_SAMPLE_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6211
  { IMAGE_SAMPLE_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6212
  { IMAGE_SAMPLE_CL_O_V5_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 6213
  { IMAGE_SAMPLE_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 6214
  { IMAGE_SAMPLE_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6215
  { IMAGE_SAMPLE_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6216
  { IMAGE_SAMPLE_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6217
  { IMAGE_SAMPLE_CL_O_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 6218
  { IMAGE_SAMPLE_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 6219
  { IMAGE_SAMPLE_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6220
  { IMAGE_SAMPLE_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6221
  { IMAGE_SAMPLE_CL_O_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 6222
  { IMAGE_SAMPLE_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 6223
  { IMAGE_SAMPLE_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6224
  { IMAGE_SAMPLE_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6225
  { IMAGE_SAMPLE_CL_O_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 6226
  { IMAGE_SAMPLE_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 6227
  { IMAGE_SAMPLE_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6228
  { IMAGE_SAMPLE_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6229
  { IMAGE_SAMPLE_CL_O_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 6230
  { IMAGE_SAMPLE_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 6231
  { IMAGE_SAMPLE_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6232
  { IMAGE_SAMPLE_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6233
  { IMAGE_SAMPLE_CL_O_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 6234
  { IMAGE_SAMPLE_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 6235
  { IMAGE_SAMPLE_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6236
  { IMAGE_SAMPLE_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6237
  { IMAGE_SAMPLE_CL_O_V1_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 6238
  { IMAGE_SAMPLE_CL_O_V1_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 6239
  { IMAGE_SAMPLE_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 6240
  { IMAGE_SAMPLE_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 6241
  { IMAGE_SAMPLE_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 6242
  { IMAGE_SAMPLE_CL_O_V2_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 6243
  { IMAGE_SAMPLE_CL_O_V2_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 6244
  { IMAGE_SAMPLE_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 6245
  { IMAGE_SAMPLE_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 6246
  { IMAGE_SAMPLE_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 6247
  { IMAGE_SAMPLE_CL_O_V3_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 6248
  { IMAGE_SAMPLE_CL_O_V3_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 6249
  { IMAGE_SAMPLE_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 6250
  { IMAGE_SAMPLE_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 6251
  { IMAGE_SAMPLE_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 6252
  { IMAGE_SAMPLE_CL_O_V4_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 6253
  { IMAGE_SAMPLE_CL_O_V4_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 6254
  { IMAGE_SAMPLE_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 6255
  { IMAGE_SAMPLE_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 6256
  { IMAGE_SAMPLE_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 6257
  { IMAGE_SAMPLE_CL_O_V5_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 6258
  { IMAGE_SAMPLE_CL_O_V5_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 6259
  { IMAGE_SAMPLE_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 6260
  { IMAGE_SAMPLE_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 6261
  { IMAGE_SAMPLE_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 6262
  { IMAGE_SAMPLE_CL_O_V1_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 6263
  { IMAGE_SAMPLE_CL_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 6264
  { IMAGE_SAMPLE_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 6265
  { IMAGE_SAMPLE_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 6266
  { IMAGE_SAMPLE_CL_O_V2_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 6267
  { IMAGE_SAMPLE_CL_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 6268
  { IMAGE_SAMPLE_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 6269
  { IMAGE_SAMPLE_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 6270
  { IMAGE_SAMPLE_CL_O_V3_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 6271
  { IMAGE_SAMPLE_CL_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 6272
  { IMAGE_SAMPLE_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 6273
  { IMAGE_SAMPLE_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 6274
  { IMAGE_SAMPLE_CL_O_V4_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 6275
  { IMAGE_SAMPLE_CL_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 6276
  { IMAGE_SAMPLE_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 6277
  { IMAGE_SAMPLE_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 6278
  { IMAGE_SAMPLE_CL_O_V5_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 6279
  { IMAGE_SAMPLE_CL_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 6280
  { IMAGE_SAMPLE_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 6281
  { IMAGE_SAMPLE_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 6282
  { IMAGE_SAMPLE_CL_O_V1_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 6283
  { IMAGE_SAMPLE_CL_O_V1_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 6284
  { IMAGE_SAMPLE_CL_O_V1_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 6285
  { IMAGE_SAMPLE_CL_O_V1_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 6286
  { IMAGE_SAMPLE_CL_O_V2_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 6287
  { IMAGE_SAMPLE_CL_O_V2_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 6288
  { IMAGE_SAMPLE_CL_O_V2_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 6289
  { IMAGE_SAMPLE_CL_O_V2_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 6290
  { IMAGE_SAMPLE_CL_O_V3_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 6291
  { IMAGE_SAMPLE_CL_O_V3_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 6292
  { IMAGE_SAMPLE_CL_O_V3_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 6293
  { IMAGE_SAMPLE_CL_O_V3_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 6294
  { IMAGE_SAMPLE_CL_O_V4_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 6295
  { IMAGE_SAMPLE_CL_O_V4_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 6296
  { IMAGE_SAMPLE_CL_O_V4_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 6297
  { IMAGE_SAMPLE_CL_O_V4_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 6298
  { IMAGE_SAMPLE_CL_O_V5_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 6299
  { IMAGE_SAMPLE_CL_O_V5_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 6300
  { IMAGE_SAMPLE_CL_O_V5_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 6301
  { IMAGE_SAMPLE_CL_O_V5_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 6302
  { IMAGE_SAMPLE_CL_O_V1_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 6303
  { IMAGE_SAMPLE_CL_O_V1_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 6304
  { IMAGE_SAMPLE_CL_O_V1_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6305
  { IMAGE_SAMPLE_CL_O_V1_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6306
  { IMAGE_SAMPLE_CL_O_V1_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6307
  { IMAGE_SAMPLE_CL_O_V2_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 6308
  { IMAGE_SAMPLE_CL_O_V2_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 6309
  { IMAGE_SAMPLE_CL_O_V2_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6310
  { IMAGE_SAMPLE_CL_O_V2_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6311
  { IMAGE_SAMPLE_CL_O_V2_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6312
  { IMAGE_SAMPLE_CL_O_V3_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 6313
  { IMAGE_SAMPLE_CL_O_V3_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 6314
  { IMAGE_SAMPLE_CL_O_V3_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6315
  { IMAGE_SAMPLE_CL_O_V3_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6316
  { IMAGE_SAMPLE_CL_O_V3_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6317
  { IMAGE_SAMPLE_CL_O_V4_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 6318
  { IMAGE_SAMPLE_CL_O_V4_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 6319
  { IMAGE_SAMPLE_CL_O_V4_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6320
  { IMAGE_SAMPLE_CL_O_V4_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6321
  { IMAGE_SAMPLE_CL_O_V4_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6322
  { IMAGE_SAMPLE_CL_O_V5_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 6323
  { IMAGE_SAMPLE_CL_O_V5_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 6324
  { IMAGE_SAMPLE_CL_O_V5_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6325
  { IMAGE_SAMPLE_CL_O_V5_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6326
  { IMAGE_SAMPLE_CL_O_V5_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6327
  { IMAGE_SAMPLE_CL_O_nortn_V2_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 6328
  { IMAGE_SAMPLE_CL_O_nortn_V3_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 6329
  { IMAGE_SAMPLE_CL_O_nortn_V4_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 6330
  { IMAGE_SAMPLE_CL_O_nortn_V5_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 6331
  { IMAGE_SAMPLE_CL_O_nortn_V8_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 6332
  { IMAGE_SAMPLE_CL_O_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 6333
  { IMAGE_SAMPLE_CL_O_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 6334
  { IMAGE_SAMPLE_CL_O_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 6335
  { IMAGE_SAMPLE_CL_O_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 6336
  { IMAGE_SAMPLE_CL_O_nortn_V2_gfx11, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x2, 0x1 }, // 6337
  { IMAGE_SAMPLE_CL_O_nortn_V3_gfx11, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x3, 0x1 }, // 6338
  { IMAGE_SAMPLE_CL_O_nortn_V4_gfx11, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x4, 0x1 }, // 6339
  { IMAGE_SAMPLE_CL_O_nortn_V5_gfx11, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x5, 0x1 }, // 6340
  { IMAGE_SAMPLE_CL_O_nortn_V8_gfx11, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x8, 0x1 }, // 6341
  { IMAGE_SAMPLE_CL_O_nortn_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx11NSA, 0x0, 0x2, 0x2 }, // 6342
  { IMAGE_SAMPLE_CL_O_nortn_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx11NSA, 0x0, 0x3, 0x3 }, // 6343
  { IMAGE_SAMPLE_CL_O_nortn_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx11NSA, 0x0, 0x4, 0x4 }, // 6344
  { IMAGE_SAMPLE_CL_O_nortn_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx11NSA, 0x0, 0x5, 0x5 }, // 6345
  { IMAGE_SAMPLE_CL_O_nortn_V2_gfx12, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx12, 0x0, 0x2, 0x2 }, // 6346
  { IMAGE_SAMPLE_CL_O_nortn_V3_gfx12, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx12, 0x0, 0x3, 0x3 }, // 6347
  { IMAGE_SAMPLE_CL_O_nortn_V4_gfx12, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx12, 0x0, 0x4, 0x4 }, // 6348
  { IMAGE_SAMPLE_CL_O_nortn_V5_gfx12, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx12, 0x0, 0x5, 0x5 }, // 6349
  { IMAGE_SAMPLE_CL_nortn_V1_gfx10, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx10Default, 0x0, 0x1, 0x1 }, // 6350
  { IMAGE_SAMPLE_CL_nortn_V2_gfx10, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 6351
  { IMAGE_SAMPLE_CL_nortn_V3_gfx10, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 6352
  { IMAGE_SAMPLE_CL_nortn_V4_gfx10, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 6353
  { IMAGE_SAMPLE_CL_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 6354
  { IMAGE_SAMPLE_CL_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 6355
  { IMAGE_SAMPLE_CL_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 6356
  { IMAGE_SAMPLE_CL_nortn_V1_gfx11, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx11Default, 0x0, 0x1, 0x1 }, // 6357
  { IMAGE_SAMPLE_CL_nortn_V2_gfx11, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx11Default, 0x0, 0x2, 0x1 }, // 6358
  { IMAGE_SAMPLE_CL_nortn_V3_gfx11, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx11Default, 0x0, 0x3, 0x1 }, // 6359
  { IMAGE_SAMPLE_CL_nortn_V4_gfx11, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx11Default, 0x0, 0x4, 0x1 }, // 6360
  { IMAGE_SAMPLE_CL_nortn_V2_nsa_gfx11, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx11NSA, 0x0, 0x2, 0x2 }, // 6361
  { IMAGE_SAMPLE_CL_nortn_V3_nsa_gfx11, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx11NSA, 0x0, 0x3, 0x3 }, // 6362
  { IMAGE_SAMPLE_CL_nortn_V4_nsa_gfx11, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx11NSA, 0x0, 0x4, 0x4 }, // 6363
  { IMAGE_SAMPLE_CL_nortn_V1_gfx12, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx12, 0x0, 0x1, 0x1 }, // 6364
  { IMAGE_SAMPLE_CL_nortn_V2_gfx12, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx12, 0x0, 0x2, 0x2 }, // 6365
  { IMAGE_SAMPLE_CL_nortn_V3_gfx12, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx12, 0x0, 0x3, 0x3 }, // 6366
  { IMAGE_SAMPLE_CL_nortn_V4_gfx12, IMAGE_SAMPLE_CL_nortn, MIMGEncGfx12, 0x0, 0x4, 0x4 }, // 6367
  { IMAGE_SAMPLE_C_B_V1_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 6368
  { IMAGE_SAMPLE_C_B_V1_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6369
  { IMAGE_SAMPLE_C_B_V1_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6370
  { IMAGE_SAMPLE_C_B_V1_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6371
  { IMAGE_SAMPLE_C_B_V2_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6372
  { IMAGE_SAMPLE_C_B_V2_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6373
  { IMAGE_SAMPLE_C_B_V2_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6374
  { IMAGE_SAMPLE_C_B_V2_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6375
  { IMAGE_SAMPLE_C_B_V3_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 6376
  { IMAGE_SAMPLE_C_B_V3_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6377
  { IMAGE_SAMPLE_C_B_V3_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6378
  { IMAGE_SAMPLE_C_B_V3_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6379
  { IMAGE_SAMPLE_C_B_V4_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 6380
  { IMAGE_SAMPLE_C_B_V4_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6381
  { IMAGE_SAMPLE_C_B_V4_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6382
  { IMAGE_SAMPLE_C_B_V4_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6383
  { IMAGE_SAMPLE_C_B_V5_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 6384
  { IMAGE_SAMPLE_C_B_V5_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6385
  { IMAGE_SAMPLE_C_B_V5_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6386
  { IMAGE_SAMPLE_C_B_V5_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6387
  { IMAGE_SAMPLE_C_B_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 6388
  { IMAGE_SAMPLE_C_B_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6389
  { IMAGE_SAMPLE_C_B_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6390
  { IMAGE_SAMPLE_C_B_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 6391
  { IMAGE_SAMPLE_C_B_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6392
  { IMAGE_SAMPLE_C_B_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6393
  { IMAGE_SAMPLE_C_B_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 6394
  { IMAGE_SAMPLE_C_B_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6395
  { IMAGE_SAMPLE_C_B_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6396
  { IMAGE_SAMPLE_C_B_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 6397
  { IMAGE_SAMPLE_C_B_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6398
  { IMAGE_SAMPLE_C_B_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6399
  { IMAGE_SAMPLE_C_B_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 6400
  { IMAGE_SAMPLE_C_B_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6401
  { IMAGE_SAMPLE_C_B_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6402
  { IMAGE_SAMPLE_C_B_V1_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 6403
  { IMAGE_SAMPLE_C_B_V1_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 6404
  { IMAGE_SAMPLE_C_B_V1_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 6405
  { IMAGE_SAMPLE_C_B_V1_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 6406
  { IMAGE_SAMPLE_C_B_V2_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 6407
  { IMAGE_SAMPLE_C_B_V2_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 6408
  { IMAGE_SAMPLE_C_B_V2_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 6409
  { IMAGE_SAMPLE_C_B_V2_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 6410
  { IMAGE_SAMPLE_C_B_V3_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 6411
  { IMAGE_SAMPLE_C_B_V3_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 6412
  { IMAGE_SAMPLE_C_B_V3_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 6413
  { IMAGE_SAMPLE_C_B_V3_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 6414
  { IMAGE_SAMPLE_C_B_V4_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 6415
  { IMAGE_SAMPLE_C_B_V4_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 6416
  { IMAGE_SAMPLE_C_B_V4_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 6417
  { IMAGE_SAMPLE_C_B_V4_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 6418
  { IMAGE_SAMPLE_C_B_V5_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 6419
  { IMAGE_SAMPLE_C_B_V5_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 6420
  { IMAGE_SAMPLE_C_B_V5_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 6421
  { IMAGE_SAMPLE_C_B_V5_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 6422
  { IMAGE_SAMPLE_C_B_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 6423
  { IMAGE_SAMPLE_C_B_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 6424
  { IMAGE_SAMPLE_C_B_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 6425
  { IMAGE_SAMPLE_C_B_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 6426
  { IMAGE_SAMPLE_C_B_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 6427
  { IMAGE_SAMPLE_C_B_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 6428
  { IMAGE_SAMPLE_C_B_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 6429
  { IMAGE_SAMPLE_C_B_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 6430
  { IMAGE_SAMPLE_C_B_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 6431
  { IMAGE_SAMPLE_C_B_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 6432
  { IMAGE_SAMPLE_C_B_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 6433
  { IMAGE_SAMPLE_C_B_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 6434
  { IMAGE_SAMPLE_C_B_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 6435
  { IMAGE_SAMPLE_C_B_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 6436
  { IMAGE_SAMPLE_C_B_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 6437
  { IMAGE_SAMPLE_C_B_V1_V3_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 6438
  { IMAGE_SAMPLE_C_B_V1_V4_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 6439
  { IMAGE_SAMPLE_C_B_V1_V5_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 6440
  { IMAGE_SAMPLE_C_B_V2_V3_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 6441
  { IMAGE_SAMPLE_C_B_V2_V4_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 6442
  { IMAGE_SAMPLE_C_B_V2_V5_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 6443
  { IMAGE_SAMPLE_C_B_V3_V3_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 6444
  { IMAGE_SAMPLE_C_B_V3_V4_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 6445
  { IMAGE_SAMPLE_C_B_V3_V5_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 6446
  { IMAGE_SAMPLE_C_B_V4_V3_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 6447
  { IMAGE_SAMPLE_C_B_V4_V4_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 6448
  { IMAGE_SAMPLE_C_B_V4_V5_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 6449
  { IMAGE_SAMPLE_C_B_V5_V3_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 6450
  { IMAGE_SAMPLE_C_B_V5_V4_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 6451
  { IMAGE_SAMPLE_C_B_V5_V5_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 6452
  { IMAGE_SAMPLE_C_B_V1_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 6453
  { IMAGE_SAMPLE_C_B_V1_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6454
  { IMAGE_SAMPLE_C_B_V1_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6455
  { IMAGE_SAMPLE_C_B_V1_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6456
  { IMAGE_SAMPLE_C_B_V2_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 6457
  { IMAGE_SAMPLE_C_B_V2_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6458
  { IMAGE_SAMPLE_C_B_V2_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6459
  { IMAGE_SAMPLE_C_B_V2_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6460
  { IMAGE_SAMPLE_C_B_V3_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 6461
  { IMAGE_SAMPLE_C_B_V3_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6462
  { IMAGE_SAMPLE_C_B_V3_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6463
  { IMAGE_SAMPLE_C_B_V3_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6464
  { IMAGE_SAMPLE_C_B_V4_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 6465
  { IMAGE_SAMPLE_C_B_V4_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6466
  { IMAGE_SAMPLE_C_B_V4_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6467
  { IMAGE_SAMPLE_C_B_V4_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6468
  { IMAGE_SAMPLE_C_B_V5_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 6469
  { IMAGE_SAMPLE_C_B_V5_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6470
  { IMAGE_SAMPLE_C_B_V5_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6471
  { IMAGE_SAMPLE_C_B_V5_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6472
  { IMAGE_SAMPLE_C_B_CL_V1_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 6473
  { IMAGE_SAMPLE_C_B_CL_V1_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6474
  { IMAGE_SAMPLE_C_B_CL_V1_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6475
  { IMAGE_SAMPLE_C_B_CL_V1_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6476
  { IMAGE_SAMPLE_C_B_CL_V1_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6477
  { IMAGE_SAMPLE_C_B_CL_V2_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6478
  { IMAGE_SAMPLE_C_B_CL_V2_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6479
  { IMAGE_SAMPLE_C_B_CL_V2_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6480
  { IMAGE_SAMPLE_C_B_CL_V2_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6481
  { IMAGE_SAMPLE_C_B_CL_V2_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6482
  { IMAGE_SAMPLE_C_B_CL_V3_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 6483
  { IMAGE_SAMPLE_C_B_CL_V3_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6484
  { IMAGE_SAMPLE_C_B_CL_V3_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6485
  { IMAGE_SAMPLE_C_B_CL_V3_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6486
  { IMAGE_SAMPLE_C_B_CL_V3_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6487
  { IMAGE_SAMPLE_C_B_CL_V4_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 6488
  { IMAGE_SAMPLE_C_B_CL_V4_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6489
  { IMAGE_SAMPLE_C_B_CL_V4_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6490
  { IMAGE_SAMPLE_C_B_CL_V4_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 6491
  { IMAGE_SAMPLE_C_B_CL_V4_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6492
  { IMAGE_SAMPLE_C_B_CL_V5_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 6493
  { IMAGE_SAMPLE_C_B_CL_V5_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6494
  { IMAGE_SAMPLE_C_B_CL_V5_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6495
  { IMAGE_SAMPLE_C_B_CL_V5_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6496
  { IMAGE_SAMPLE_C_B_CL_V5_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6497
  { IMAGE_SAMPLE_C_B_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 6498
  { IMAGE_SAMPLE_C_B_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6499
  { IMAGE_SAMPLE_C_B_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6500
  { IMAGE_SAMPLE_C_B_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6501
  { IMAGE_SAMPLE_C_B_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 6502
  { IMAGE_SAMPLE_C_B_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6503
  { IMAGE_SAMPLE_C_B_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6504
  { IMAGE_SAMPLE_C_B_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6505
  { IMAGE_SAMPLE_C_B_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 6506
  { IMAGE_SAMPLE_C_B_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6507
  { IMAGE_SAMPLE_C_B_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6508
  { IMAGE_SAMPLE_C_B_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6509
  { IMAGE_SAMPLE_C_B_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 6510
  { IMAGE_SAMPLE_C_B_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6511
  { IMAGE_SAMPLE_C_B_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6512
  { IMAGE_SAMPLE_C_B_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6513
  { IMAGE_SAMPLE_C_B_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 6514
  { IMAGE_SAMPLE_C_B_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6515
  { IMAGE_SAMPLE_C_B_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6516
  { IMAGE_SAMPLE_C_B_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6517
  { IMAGE_SAMPLE_C_B_CL_V1_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 6518
  { IMAGE_SAMPLE_C_B_CL_V1_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 6519
  { IMAGE_SAMPLE_C_B_CL_V1_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 6520
  { IMAGE_SAMPLE_C_B_CL_V1_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 6521
  { IMAGE_SAMPLE_C_B_CL_V1_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 6522
  { IMAGE_SAMPLE_C_B_CL_V2_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 6523
  { IMAGE_SAMPLE_C_B_CL_V2_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 6524
  { IMAGE_SAMPLE_C_B_CL_V2_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 6525
  { IMAGE_SAMPLE_C_B_CL_V2_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 6526
  { IMAGE_SAMPLE_C_B_CL_V2_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 6527
  { IMAGE_SAMPLE_C_B_CL_V3_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 6528
  { IMAGE_SAMPLE_C_B_CL_V3_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 6529
  { IMAGE_SAMPLE_C_B_CL_V3_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 6530
  { IMAGE_SAMPLE_C_B_CL_V3_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 6531
  { IMAGE_SAMPLE_C_B_CL_V3_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 6532
  { IMAGE_SAMPLE_C_B_CL_V4_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 6533
  { IMAGE_SAMPLE_C_B_CL_V4_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 6534
  { IMAGE_SAMPLE_C_B_CL_V4_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 6535
  { IMAGE_SAMPLE_C_B_CL_V4_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 6536
  { IMAGE_SAMPLE_C_B_CL_V4_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 6537
  { IMAGE_SAMPLE_C_B_CL_V5_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 6538
  { IMAGE_SAMPLE_C_B_CL_V5_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 6539
  { IMAGE_SAMPLE_C_B_CL_V5_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 6540
  { IMAGE_SAMPLE_C_B_CL_V5_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 6541
  { IMAGE_SAMPLE_C_B_CL_V5_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 6542
  { IMAGE_SAMPLE_C_B_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 6543
  { IMAGE_SAMPLE_C_B_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 6544
  { IMAGE_SAMPLE_C_B_CL_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 6545
  { IMAGE_SAMPLE_C_B_CL_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 6546
  { IMAGE_SAMPLE_C_B_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 6547
  { IMAGE_SAMPLE_C_B_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 6548
  { IMAGE_SAMPLE_C_B_CL_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 6549
  { IMAGE_SAMPLE_C_B_CL_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 6550
  { IMAGE_SAMPLE_C_B_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 6551
  { IMAGE_SAMPLE_C_B_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 6552
  { IMAGE_SAMPLE_C_B_CL_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 6553
  { IMAGE_SAMPLE_C_B_CL_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 6554
  { IMAGE_SAMPLE_C_B_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 6555
  { IMAGE_SAMPLE_C_B_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 6556
  { IMAGE_SAMPLE_C_B_CL_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 6557
  { IMAGE_SAMPLE_C_B_CL_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 6558
  { IMAGE_SAMPLE_C_B_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 6559
  { IMAGE_SAMPLE_C_B_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 6560
  { IMAGE_SAMPLE_C_B_CL_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 6561
  { IMAGE_SAMPLE_C_B_CL_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 6562
  { IMAGE_SAMPLE_C_B_CL_V1_V3_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 6563
  { IMAGE_SAMPLE_C_B_CL_V1_V4_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 6564
  { IMAGE_SAMPLE_C_B_CL_V1_V5_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 6565
  { IMAGE_SAMPLE_C_B_CL_V1_V6_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x1, 0x6, 0x6 }, // 6566
  { IMAGE_SAMPLE_C_B_CL_V2_V3_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 6567
  { IMAGE_SAMPLE_C_B_CL_V2_V4_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 6568
  { IMAGE_SAMPLE_C_B_CL_V2_V5_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 6569
  { IMAGE_SAMPLE_C_B_CL_V2_V6_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 6570
  { IMAGE_SAMPLE_C_B_CL_V3_V3_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 6571
  { IMAGE_SAMPLE_C_B_CL_V3_V4_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 6572
  { IMAGE_SAMPLE_C_B_CL_V3_V5_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 6573
  { IMAGE_SAMPLE_C_B_CL_V3_V6_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x3, 0x6, 0x6 }, // 6574
  { IMAGE_SAMPLE_C_B_CL_V4_V3_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 6575
  { IMAGE_SAMPLE_C_B_CL_V4_V4_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 6576
  { IMAGE_SAMPLE_C_B_CL_V4_V5_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 6577
  { IMAGE_SAMPLE_C_B_CL_V4_V6_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 6578
  { IMAGE_SAMPLE_C_B_CL_V5_V3_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 6579
  { IMAGE_SAMPLE_C_B_CL_V5_V4_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 6580
  { IMAGE_SAMPLE_C_B_CL_V5_V5_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 6581
  { IMAGE_SAMPLE_C_B_CL_V5_V6_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 6582
  { IMAGE_SAMPLE_C_B_CL_V1_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 6583
  { IMAGE_SAMPLE_C_B_CL_V1_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6584
  { IMAGE_SAMPLE_C_B_CL_V1_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6585
  { IMAGE_SAMPLE_C_B_CL_V1_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6586
  { IMAGE_SAMPLE_C_B_CL_V1_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6587
  { IMAGE_SAMPLE_C_B_CL_V2_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 6588
  { IMAGE_SAMPLE_C_B_CL_V2_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6589
  { IMAGE_SAMPLE_C_B_CL_V2_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6590
  { IMAGE_SAMPLE_C_B_CL_V2_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6591
  { IMAGE_SAMPLE_C_B_CL_V2_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6592
  { IMAGE_SAMPLE_C_B_CL_V3_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 6593
  { IMAGE_SAMPLE_C_B_CL_V3_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6594
  { IMAGE_SAMPLE_C_B_CL_V3_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6595
  { IMAGE_SAMPLE_C_B_CL_V3_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6596
  { IMAGE_SAMPLE_C_B_CL_V3_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6597
  { IMAGE_SAMPLE_C_B_CL_V4_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 6598
  { IMAGE_SAMPLE_C_B_CL_V4_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6599
  { IMAGE_SAMPLE_C_B_CL_V4_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6600
  { IMAGE_SAMPLE_C_B_CL_V4_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6601
  { IMAGE_SAMPLE_C_B_CL_V4_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6602
  { IMAGE_SAMPLE_C_B_CL_V5_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 6603
  { IMAGE_SAMPLE_C_B_CL_V5_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6604
  { IMAGE_SAMPLE_C_B_CL_V5_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6605
  { IMAGE_SAMPLE_C_B_CL_V5_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6606
  { IMAGE_SAMPLE_C_B_CL_V5_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6607
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6608
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6609
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6610
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 6611
  { IMAGE_SAMPLE_C_B_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6612
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6613
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6614
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6615
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 6616
  { IMAGE_SAMPLE_C_B_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6617
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6618
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6619
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6620
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 6621
  { IMAGE_SAMPLE_C_B_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6622
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6623
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6624
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 6625
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 6626
  { IMAGE_SAMPLE_C_B_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6627
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6628
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6629
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6630
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 6631
  { IMAGE_SAMPLE_C_B_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6632
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6633
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6634
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6635
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 6636
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6637
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6638
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6639
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 6640
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6641
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6642
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6643
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 6644
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6645
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6646
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6647
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 6648
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6649
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6650
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6651
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 6652
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 6653
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 6654
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 6655
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 6656
  { IMAGE_SAMPLE_C_B_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 6657
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 6658
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 6659
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 6660
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 6661
  { IMAGE_SAMPLE_C_B_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 6662
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 6663
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 6664
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 6665
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 6666
  { IMAGE_SAMPLE_C_B_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 6667
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 6668
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 6669
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 6670
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 6671
  { IMAGE_SAMPLE_C_B_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 6672
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 6673
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 6674
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 6675
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 6676
  { IMAGE_SAMPLE_C_B_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 6677
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 6678
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 6679
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 6680
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 6681
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 6682
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 6683
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 6684
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 6685
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 6686
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 6687
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 6688
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 6689
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 6690
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 6691
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 6692
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 6693
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 6694
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 6695
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 6696
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 6697
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 6698
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 6699
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x1, 0x6, 0x6 }, // 6700
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x1, 0x7, 0x7 }, // 6701
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 6702
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 6703
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 6704
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x2, 0x7, 0x7 }, // 6705
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 6706
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 6707
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x3, 0x6, 0x6 }, // 6708
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x3, 0x7, 0x7 }, // 6709
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 6710
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 6711
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 6712
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x4, 0x7, 0x7 }, // 6713
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 6714
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 6715
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 6716
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x5, 0x7, 0x7 }, // 6717
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6718
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6719
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6720
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 6721
  { IMAGE_SAMPLE_C_B_CL_O_V1_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6722
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6723
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6724
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6725
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 6726
  { IMAGE_SAMPLE_C_B_CL_O_V2_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6727
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6728
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6729
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6730
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 6731
  { IMAGE_SAMPLE_C_B_CL_O_V3_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6732
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6733
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6734
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6735
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 6736
  { IMAGE_SAMPLE_C_B_CL_O_V4_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6737
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6738
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6739
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6740
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 6741
  { IMAGE_