// third_party/blink/public/mojom/mediasession/media_session.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/mediasession/media_session.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-params-data.h"
#include "third_party/blink/public/mojom/mediasession/media_session.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
MediaSessionSeekToDetails::MediaSessionSeekToDetails()
    : seek_time(),
      fast_seek() {}

MediaSessionSeekToDetails::MediaSessionSeekToDetails(
    ::base::TimeDelta seek_time_in,
    bool fast_seek_in)
    : seek_time(std::move(seek_time_in)),
      fast_seek(std::move(fast_seek_in)) {}

MediaSessionSeekToDetails::~MediaSessionSeekToDetails() = default;

void MediaSessionSeekToDetails::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("seek_time", base::trace_event::ValueToString(this->seek_time, "<value of type ::base::TimeDelta>"));
  value->SetBoolean("fast_seek", this->fast_seek);
}

bool MediaSessionSeekToDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SpecMediaMetadata::SpecMediaMetadata()
    : title(),
      artist(),
      album(),
      artwork() {}

SpecMediaMetadata::SpecMediaMetadata(
    const ::base::string16& title_in,
    const ::base::string16& artist_in,
    const ::base::string16& album_in,
    std::vector<::media_session::MediaImage> artwork_in)
    : title(std::move(title_in)),
      artist(std::move(artist_in)),
      album(std::move(album_in)),
      artwork(std::move(artwork_in)) {}

SpecMediaMetadata::~SpecMediaMetadata() = default;

void SpecMediaMetadata::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("title", base::trace_event::ValueToString(this->title, "<value of type const ::base::string16&>"));
  value->SetString("artist", base::trace_event::ValueToString(this->artist, "<value of type const ::base::string16&>"));
  value->SetString("album", base::trace_event::ValueToString(this->album, "<value of type const ::base::string16&>"));
  value->BeginArray("artwork");
  for (const auto& item0 : this->artwork) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::media_session::MediaImage&>"));
  }
  value->EndArray();
}

bool SpecMediaMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaSessionActionDetails::MediaSessionActionDetails() : tag_(Tag::SEEK_TO) {
  data_.seek_to = new MediaSessionSeekToDetailsPtr;
}

MediaSessionActionDetails::~MediaSessionActionDetails() {
  DestroyActive();
}


void MediaSessionActionDetails::set_seek_to(
    MediaSessionSeekToDetailsPtr seek_to) {
  if (tag_ == Tag::SEEK_TO) {
    *(data_.seek_to) = std::move(seek_to);
  } else {
    DestroyActive();
    tag_ = Tag::SEEK_TO;
    data_.seek_to = new MediaSessionSeekToDetailsPtr(
        std::move(seek_to));
  }
}

void MediaSessionActionDetails::DestroyActive() {
  switch (tag_) {

    case Tag::SEEK_TO:

      delete data_.seek_to;
      break;
  }
}

bool MediaSessionActionDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char MediaSessionClient::Name_[] = "blink.mojom.MediaSessionClient";

MediaSessionClientProxy::MediaSessionClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaSessionClientProxy::DidReceiveAction(
    ::media_session::mojom::MediaSessionAction in_action, MediaSessionActionDetailsPtr in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionClient::DidReceiveAction", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("action", base::trace_event::ValueToString(in_action));
      raw_value->SetString("details", base::trace_event::ValueToString(in_details, "<value of type MediaSessionActionDetailsPtr>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionClient_DidReceiveAction_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::MediaSessionClient_DidReceiveAction_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::media_session::mojom::MediaSessionAction>(
      in_action, &params->action);
  typename decltype(params->details)::BufferWriter details_writer;
  details_writer.AllocateInline(buffer, &params->details);
  mojo::internal::Serialize<::blink::mojom::MediaSessionActionDetailsDataView>(
      in_details, buffer, &details_writer, true, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionClient::Name_);
  message.set_method_name("DidReceiveAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaSessionClientStubDispatch::Accept(
    MediaSessionClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kMediaSessionClient_DidReceiveAction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionClient::DidReceiveAction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionClient::DidReceiveAction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionClient_DidReceiveAction_Params_Data* params =
          reinterpret_cast<internal::MediaSessionClient_DidReceiveAction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::MediaSessionAction p_action{};
      MediaSessionActionDetailsPtr p_details{};
      MediaSessionClient_DidReceiveAction_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReceiveAction(
std::move(p_action), 
std::move(p_details));
      return true;
    }
  }
  return false;
}

// static
bool MediaSessionClientStubDispatch::AcceptWithResponder(
    MediaSessionClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaSessionClient_DidReceiveAction_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaSessionClientValidationInfo[] = {
    {&internal::MediaSessionClient_DidReceiveAction_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaSessionClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::MediaSessionClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaSessionClientValidationInfo);
}

const char MediaSessionService::Name_[] = "blink.mojom.MediaSessionService";

MediaSessionServiceProxy::MediaSessionServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaSessionServiceProxy::SetClient(
    ::mojo::PendingRemote<MediaSessionClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionService::SetClient", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("client", in_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionService_SetClient_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::MediaSessionService_SetClient_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::MediaSessionClientInterfaceBase>>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in MediaSessionService.SetClient request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionServiceProxy::SetPlaybackState(
    MediaSessionPlaybackState in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionService::SetPlaybackState", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("state", base::trace_event::ValueToString(in_state));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionService_SetPlaybackState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::MediaSessionService_SetPlaybackState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::MediaSessionPlaybackState>(
      in_state, &params->state);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetPlaybackState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionServiceProxy::SetPositionState(
    const base::Optional<::media_session::MediaPosition>& in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionService::SetPositionState", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("position", base::trace_event::ValueToString(in_position, "<value of type const base::Optional<::media_session::MediaPosition>&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionService_SetPositionState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::MediaSessionService_SetPositionState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->position)::BaseType::BufferWriter
      position_writer;
  mojo::internal::Serialize<::media_session::mojom::MediaPositionDataView>(
      in_position, buffer, &position_writer, &serialization_context);
  params->position.Set(
      position_writer.is_null() ? nullptr : position_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetPositionState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionServiceProxy::SetMetadata(
    SpecMediaMetadataPtr in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionService::SetMetadata", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_metadata.is_null()) {
        raw_value->SetString("metadata", "nullptr");
      } else {
        raw_value->BeginDictionary("metadata");
        in_metadata->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionService_SetMetadata_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::MediaSessionService_SetMetadata_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->metadata)::BaseType::BufferWriter
      metadata_writer;
  mojo::internal::Serialize<::blink::mojom::SpecMediaMetadataDataView>(
      in_metadata, buffer, &metadata_writer, &serialization_context);
  params->metadata.Set(
      metadata_writer.is_null() ? nullptr : metadata_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("SetMetadata");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionServiceProxy::EnableAction(
    ::media_session::mojom::MediaSessionAction in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionService::EnableAction", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("action", base::trace_event::ValueToString(in_action));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionService_EnableAction_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::MediaSessionService_EnableAction_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::media_session::mojom::MediaSessionAction>(
      in_action, &params->action);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("EnableAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void MediaSessionServiceProxy::DisableAction(
    ::media_session::mojom::MediaSessionAction in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::MediaSessionService::DisableAction", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("action", base::trace_event::ValueToString(in_action));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kMediaSessionService_DisableAction_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::MediaSessionService_DisableAction_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::media_session::mojom::MediaSessionAction>(
      in_action, &params->action);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaSessionService::Name_);
  message.set_method_name("DisableAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool MediaSessionServiceStubDispatch::Accept(
    MediaSessionService* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kMediaSessionService_SetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionService::SetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionService::SetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetClient_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<MediaSessionClient> p_client{};
      MediaSessionService_SetClient_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(
std::move(p_client));
      return true;
    }
    case internal::kMediaSessionService_SetPlaybackState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionService::SetPlaybackState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionService::SetPlaybackState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetPlaybackState_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetPlaybackState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      MediaSessionPlaybackState p_state{};
      MediaSessionService_SetPlaybackState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPlaybackState(
std::move(p_state));
      return true;
    }
    case internal::kMediaSessionService_SetPositionState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionService::SetPositionState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionService::SetPositionState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetPositionState_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetPositionState_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::media_session::MediaPosition> p_position{};
      MediaSessionService_SetPositionState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPositionState(
std::move(p_position));
      return true;
    }
    case internal::kMediaSessionService_SetMetadata_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionService::SetMetadata",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionService::SetMetadata");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_SetMetadata_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_SetMetadata_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SpecMediaMetadataPtr p_metadata{};
      MediaSessionService_SetMetadata_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMetadata(
std::move(p_metadata));
      return true;
    }
    case internal::kMediaSessionService_EnableAction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionService::EnableAction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionService::EnableAction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_EnableAction_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_EnableAction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::MediaSessionAction p_action{};
      MediaSessionService_EnableAction_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableAction(
std::move(p_action));
      return true;
    }
    case internal::kMediaSessionService_DisableAction_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::MediaSessionService::DisableAction",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::MediaSessionService::DisableAction");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::MediaSessionService_DisableAction_Params_Data* params =
          reinterpret_cast<internal::MediaSessionService_DisableAction_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::media_session::mojom::MediaSessionAction p_action{};
      MediaSessionService_DisableAction_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaSessionService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableAction(
std::move(p_action));
      return true;
    }
  }
  return false;
}

// static
bool MediaSessionServiceStubDispatch::AcceptWithResponder(
    MediaSessionService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kMediaSessionService_SetClient_Name: {
      break;
    }
    case internal::kMediaSessionService_SetPlaybackState_Name: {
      break;
    }
    case internal::kMediaSessionService_SetPositionState_Name: {
      break;
    }
    case internal::kMediaSessionService_SetMetadata_Name: {
      break;
    }
    case internal::kMediaSessionService_EnableAction_Name: {
      break;
    }
    case internal::kMediaSessionService_DisableAction_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kMediaSessionServiceValidationInfo[] = {
    {&internal::MediaSessionService_SetClient_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionService_SetPlaybackState_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionService_SetPositionState_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionService_SetMetadata_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionService_EnableAction_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::MediaSessionService_DisableAction_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaSessionServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::MediaSessionService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kMediaSessionServiceValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::MediaSessionSeekToDetails::DataView, ::blink::mojom::MediaSessionSeekToDetailsPtr>::Read(
    ::blink::mojom::MediaSessionSeekToDetails::DataView input,
    ::blink::mojom::MediaSessionSeekToDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::MediaSessionSeekToDetailsPtr result(::blink::mojom::MediaSessionSeekToDetails::New());
  
      if (success && !input.ReadSeekTime(&result->seek_time))
        success = false;
      if (success)
        result->fast_seek = input.fast_seek();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::SpecMediaMetadata::DataView, ::blink::mojom::SpecMediaMetadataPtr>::Read(
    ::blink::mojom::SpecMediaMetadata::DataView input,
    ::blink::mojom::SpecMediaMetadataPtr* output) {
  bool success = true;
  ::blink::mojom::SpecMediaMetadataPtr result(::blink::mojom::SpecMediaMetadata::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadArtist(&result->artist))
        success = false;
      if (success && !input.ReadAlbum(&result->album))
        success = false;
      if (success && !input.ReadArtwork(&result->artwork))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::MediaSessionActionDetails::DataView, ::blink::mojom::MediaSessionActionDetailsPtr>::Read(
    ::blink::mojom::MediaSessionActionDetails::DataView input,
    ::blink::mojom::MediaSessionActionDetailsPtr* output) {
  using UnionType = ::blink::mojom::MediaSessionActionDetails;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::SEEK_TO: {
      ::blink::mojom::MediaSessionSeekToDetailsPtr result_seek_to;
      if (!input.ReadSeekTo(&result_seek_to))
        return false;

      *output = UnionType::NewSeekTo(
          std::move(result_seek_to));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif